/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal.servlet;

import com.google.gson.Gson;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.persistence.FilterCriteria;
import org.eclipse.smarthome.core.persistence.HistoricItem;
import org.eclipse.smarthome.core.persistence.QueryablePersistenceService;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.model.sitemap.SitemapProvider;
import org.eclipse.smarthome.model.sitemap.sitemap.Sitemap;
import org.openhab.ui.cometvisu.internal.Config;
import org.openhab.ui.cometvisu.internal.config.ConfigHelper;
import org.openhab.ui.cometvisu.internal.config.VisuConfig;
import org.openhab.ui.cometvisu.internal.editor.dataprovider.beans.DataBean;
import org.openhab.ui.cometvisu.internal.editor.dataprovider.beans.ItemBean;
import org.openhab.ui.cometvisu.internal.rss.beans.Entry;
import org.openhab.ui.cometvisu.internal.rss.beans.Feed;
import org.openhab.ui.cometvisu.internal.servlet.CometVisuApp;
import org.openhab.ui.cometvisu.internal.util.ClientInstaller;
import org.openhab.ui.cometvisu.php.PHProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CometVisuServlet
extends HttpServlet {
    private static final long serialVersionUID = 4448918908615003303L;
    private final Logger logger = LoggerFactory.getLogger(CometVisuServlet.class);
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private static final long DEFAULT_EXPIRE_TIME = 604800000L;
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    private Pattern sitemapPattern = Pattern.compile(".*/visu_config_?(oh_)?([^\\.]+)?\\.xml");
    private Pattern configStorePattern = Pattern.compile("config/visu_config_oh_([a-z0-9_]+)\\.xml");
    private String rssLogPath = "/plugins/rsslog/rsslog_oh.php";
    private final String rssLogMessageSeparator = "\\|";
    private DateFormat rssPubDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
    protected String root;
    protected File rootFolder;
    protected File userFileFolder;
    protected String defaultUserDir;
    protected PHProvider engine;
    protected ServletContext servletContext;
    protected ServletConfig config;
    protected boolean phpEnabled = false;
    private CometVisuApp cometVisuApp;

    public CometVisuServlet(String filesystemDir, CometVisuApp cometVisuApp) {
        this.root = filesystemDir;
        this.rootFolder = new File(this.root);
        this.userFileFolder = new File(String.valueOf(ConfigConstants.getConfigFolder()) + Config.COMETVISU_WEBAPP_USERFILE_FOLDER);
        this.defaultUserDir = System.getProperty("user.dir");
        this.cometVisuApp = cometVisuApp;
        PHProvider prov = cometVisuApp.getPHProvider();
        if (prov != null) {
            this.setPHProvider(prov);
        }
    }

    public void setPHProvider(PHProvider prov) {
        this.engine = prov;
        this.initQuercusEngine();
    }

    public void unsetPHProvider() {
        this.engine = null;
        this.phpEnabled = false;
    }

    private void initQuercusEngine() {
        try {
            this.engine.createQuercusEngine();
            this.engine.setIni("include_path", ".:" + this.rootFolder.getAbsolutePath());
            if (this.servletContext != null) {
                this.engine.init(this.rootFolder.getAbsolutePath(), this.defaultUserDir, this.servletContext);
                this.phpEnabled = true;
            }
        }
        catch (Exception e) {
            this.phpEnabled = false;
        }
    }

    public boolean isPhpEnabled() {
        return this.phpEnabled;
    }

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.servletContext = config.getServletContext();
        if (this.engine != null) {
            this.engine.init(this.rootFolder.getAbsolutePath(), this.defaultUserDir, this.servletContext);
            this.phpEnabled = true;
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        File requestedFile = this.getRequestedFile(req);
        Matcher match = this.configStorePattern.matcher(req.getParameter("config"));
        if (requestedFile.getName().endsWith("save_config.php") && match.find() && req.getParameter("type") != null && req.getParameter("type").equals("xml")) {
            this.saveConfig(req, resp);
        } else {
            this.processPhpRequest(requestedFile, req, resp);
        }
    }

    private Sitemap getSitemap(String sitemapname) {
        for (SitemapProvider provider : this.cometVisuApp.getSitemapProviders()) {
            Sitemap sitemap = provider.getSitemap(sitemapname);
            if (sitemap == null) continue;
            return sitemap;
        }
        return null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        File requestedFile = this.getRequestedFile(req);
        String path = req.getPathInfo() != null ? req.getPathInfo() : "/index.html";
        Matcher matcher = this.sitemapPattern.matcher(path);
        if (matcher.find()) {
            resp.setHeader("X-CometVisu-Backend-LoginUrl", "/rest/cv/l");
            resp.setHeader("X-CometVisu-Backend-Name", "openhab2");
            if (!requestedFile.exists()) {
                Sitemap sitemap = this.getSitemap(matcher.group(2));
                if (sitemap != null) {
                    this.logger.debug("reading sitemap '{}'", (Object)sitemap);
                    VisuConfig config = new VisuConfig(sitemap, this.cometVisuApp, this.rootFolder);
                    resp.setContentType("application/xml");
                    resp.getWriter().write(config.getConfigXml(req));
                    resp.flushBuffer();
                    return;
                }
                this.logger.debug("Config file not found. Neither as normal config ('{}') nor as sitemap ('{}.sitemap')", (Object)requestedFile, (Object)matcher.group(2));
                resp.sendError(404);
                return;
            }
        }
        if (path.matches(".*editor/dataproviders/.+\\.(php|json)$") || path.matches(".*designs/get_designs\\.php$")) {
            this.dataProviderService(requestedFile, req, resp);
        } else if (path.endsWith(this.rssLogPath)) {
            this.processRssLogRequest(requestedFile, req, resp);
        } else if (requestedFile.getName().endsWith(".php")) {
            this.processPhpRequest(requestedFile, req, resp);
        } else {
            this.processStaticRequest(requestedFile, req, resp, true);
        }
    }

    protected void processPhpRequest(File file, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.phpEnabled) {
            this.initQuercusEngine();
        }
        if (this.phpEnabled) {
            this.engine.phpService(file, request, response);
        } else {
            this.logger.debug("php service is not available please install com.caucho.quercus bundle");
        }
    }

    protected File getRequestedFile(HttpServletRequest req) throws UnsupportedEncodingException {
        FilenameFilter filter;
        String[] stringArray;
        String requestedFile = req.getPathInfo();
        if (requestedFile.endsWith("/")) {
            requestedFile = requestedFile.substring(0, requestedFile.length() - 1);
        }
        File file = null;
        if (requestedFile != null) {
            file = new File(this.userFileFolder, URLDecoder.decode(requestedFile, "UTF-8"));
        }
        if (file == null || !file.exists() || file.isDirectory()) {
            File file2 = file = requestedFile != null ? new File(this.rootFolder, URLDecoder.decode(requestedFile, "UTF-8")) : this.rootFolder;
        }
        if (file.isDirectory() && (stringArray = file.list(filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("index.") && (name.endsWith(".php") || name.endsWith(".html"));
            }
        })).length != 0) {
            String dirFile = stringArray[0];
            file = new File(file, dirFile);
        }
        return file;
    }

    private void processRssLogRequest(File file, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter("f") == null) {
            return;
        }
        String[] itemNames = request.getParameter("f").split(",");
        ArrayList<Item> items = new ArrayList<Item>();
        String[] stringArray = itemNames;
        int n = itemNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                Item item = this.cometVisuApp.getItemRegistry().getItem(name);
                items.add(item);
            }
            catch (ItemNotFoundException e) {
                this.logger.error("item '{}' not found", (Object)name);
            }
            ++n2;
        }
        if (items.size() > 0) {
            if (!CometVisuApp.getPersistenceServices().entrySet().iterator().hasNext()) {
                throw new IllegalArgumentException("No Persistence service found.");
            }
            if (request.getParameter("c") != null) {
                if (items.size() == 1) {
                    String title = request.getParameter("h");
                    String message = request.getParameter("c");
                    String state = request.getParameter("state");
                    StringType command = new StringType(String.valueOf(title) + "\\|" + message + "\\|" + state + "\\|" + ((Item)items.get(0)).getName());
                    this.cometVisuApp.getEventPublisher().post((Event)ItemEventFactory.createCommandEvent((String)((Item)items.get(0)).getName(), (Command)command));
                }
                response.setContentType("text/plain");
                response.getWriter().write("");
                response.flushBuffer();
            } else if (request.getParameter("dump") == null) {
                if (request.getParameter("r") != null) {
                    response.setContentType("text/plain");
                    response.getWriter().write("Cannot execute query: It is not possible to delete data from openHAB PersistenceService");
                    response.flushBuffer();
                } else if (request.getParameter("u") != null) {
                    response.setContentType("text/plain");
                    response.getWriter().write("Cannot execute query: It is not possible to update data from openHAB PersistenceService");
                    response.flushBuffer();
                } else if (request.getParameter("d") != null) {
                    response.setContentType("text/plain");
                    response.getWriter().write("Cannot execute query: It is not possible to delete data from openHAB PersistenceService");
                    response.flushBuffer();
                } else {
                    Feed feed = new Feed();
                    feed.feedUrl = request.getRequestURL().toString();
                    feed.title = "RSS supplied logs";
                    feed.link = request.getRequestURL().toString();
                    feed.author = "";
                    feed.description = "RSS supplied logs";
                    feed.type = "rss20";
                    FilterCriteria filter = new FilterCriteria();
                    Calendar start = Calendar.getInstance();
                    start.add(6, -7);
                    filter.setBeginDate(start.getTime());
                    filter.setPageSize(25);
                    filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
                    for (Item item : items) {
                        filter.setItemName(item.getName());
                        Iterator<Map.Entry<String, QueryablePersistenceService>> pit = CometVisuApp.getPersistenceServices().entrySet().iterator();
                        QueryablePersistenceService persistenceService = pit.next().getValue();
                        Iterable result = persistenceService.query(filter);
                        Iterator it = result.iterator();
                        boolean forceStop = false;
                        while (!forceStop && !it.hasNext()) {
                            if (pit.hasNext()) {
                                persistenceService = pit.next().getValue();
                                result = persistenceService.query(filter);
                                continue;
                            }
                            forceStop = true;
                        }
                        if (it.hasNext()) {
                            this.logger.debug("persisted data for item {} found in service {}", (Object)item.getName(), (Object)persistenceService.getId());
                        }
                        int i = 0;
                        while (it.hasNext()) {
                            ++i;
                            HistoricItem historicItem = (HistoricItem)it.next();
                            if (historicItem.getState() == null || historicItem.getState().toString().isEmpty()) continue;
                            Entry entry = new Entry();
                            entry.publishedDate = historicItem.getTimestamp().getTime();
                            entry.tags.add(historicItem.getName());
                            String[] content = historicItem.getState().toString().split("\\|");
                            if (content.length == 0) {
                                entry.content = historicItem.getState().toString();
                            } else if (content.length == 1) {
                                entry.content = content[0];
                            } else if (content.length == 2) {
                                entry.title = content[0];
                                entry.content = content[1];
                            } else if (content.length == 3) {
                                entry.title = content[0];
                                entry.content = content[1];
                                entry.state = content[2];
                            } else if (content.length == 4) {
                                entry.title = content[0];
                                entry.content = content[1];
                                entry.state = content[2];
                            }
                            feed.entries.add(entry);
                        }
                        if ("rrd4j".equals(persistenceService.getId()) && FilterCriteria.Ordering.DESCENDING.equals((Object)filter.getOrdering())) {
                            Collections.sort(feed.entries, new Comparator<Entry>(){

                                @Override
                                public int compare(Entry o1, Entry o2) {
                                    return Long.compare(o2.publishedDate, o1.publishedDate);
                                }
                            });
                        }
                        this.logger.debug("querying {} item from {} to {} => {} results on service {}", new Object[]{filter.getItemName(), filter.getBeginDate(), filter.getEndDate(), i, persistenceService.getId()});
                    }
                    if (request.getParameter("j") != null) {
                        response.setContentType("application/json");
                        response.getWriter().write("{\"responseData\": { \"feed\": " + this.marshalJson(feed) + "},\"responseDetails\":null,\"responseStatus\":200}");
                    } else {
                        response.setContentType("application/atom+xml");
                        String rss = "<?xml version=\"1.0\"?>\n<rss version=\"2.0\">\n<channel>\n";
                        rss = String.valueOf(rss) + "<title>" + feed.title + "</title>\n";
                        rss = String.valueOf(rss) + "<link>" + feed.link + "</link>\n";
                        rss = String.valueOf(rss) + "<desrciption>" + feed.description + "</desription>\n";
                        for (Entry entry : feed.entries) {
                            rss = String.valueOf(rss) + "<item>";
                            rss = String.valueOf(rss) + "<title>" + entry.title + "</title>";
                            rss = String.valueOf(rss) + "<description>" + entry.content + "</description>";
                            Date pubDate = new Date(entry.publishedDate);
                            rss = String.valueOf(rss) + "<pubDate>" + this.rssPubDateFormat.format(pubDate) + "</pubDate>";
                            rss = String.valueOf(rss) + "</item>\n";
                        }
                        rss = String.valueOf(rss) + "</channel></rss>";
                        response.getWriter().write(rss);
                    }
                    response.flushBuffer();
                }
            }
        }
    }

    private void processStaticRequest(File file, HttpServletRequest request, HttpServletResponse response, boolean content) throws IOException {
        if (file == null) {
            String requestedFile = request.getPathInfo();
            if (requestedFile == null) {
                response.sendError(404);
                return;
            }
            file = new File(this.rootFolder, URLDecoder.decode(requestedFile, "UTF-8"));
        }
        if (file.equals(this.rootFolder) || file.exists() && file.isDirectory()) {
            file = new File(file, "index.html");
        }
        if (!file.exists()) {
            if (file.getParentFile().equals(this.rootFolder) && (file.getName().equalsIgnoreCase("index.html") || file.getName().length() == 0)) {
                File folder;
                String path = null;
                File file2 = folder = file.isDirectory() ? file : file.getParentFile();
                if (folder.exists()) {
                    File index = ClientInstaller.findClientRoot(folder, "index.html");
                    String string = path = index.exists() ? index.getPath().replaceFirst(String.valueOf(this.rootFolder.getPath()) + "/", "") : null;
                }
                if (path != null) {
                    response.setStatus(301);
                    response.setHeader("Location", String.valueOf(path) + "?" + request.getQueryString());
                } else {
                    this.showInstallationHint(request, response);
                }
            } else {
                response.sendError(404);
            }
            return;
        }
        String fileName = file.getName();
        long length = file.length();
        long lastModified = file.lastModified();
        String eTag = String.valueOf(fileName) + "_" + length + "_" + lastModified;
        long expires = System.currentTimeMillis() + 604800000L;
        String ifNoneMatch = request.getHeader("If-None-Match");
        if (ifNoneMatch != null && CometVisuServlet.matches(ifNoneMatch, eTag)) {
            response.setStatus(304);
            response.setHeader("ETag", eTag);
            response.setDateHeader("Expires", expires);
            return;
        }
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        if (ifNoneMatch == null && ifModifiedSince != -1L && ifModifiedSince + 1000L > lastModified) {
            response.setStatus(304);
            response.setHeader("ETag", eTag);
            response.setDateHeader("Expires", expires);
            return;
        }
        String ifMatch = request.getHeader("If-Match");
        if (ifMatch != null && !CometVisuServlet.matches(ifMatch, eTag)) {
            response.sendError(412);
            return;
        }
        long ifUnmodifiedSince = request.getDateHeader("If-Unmodified-Since");
        if (ifUnmodifiedSince != -1L && ifUnmodifiedSince + 1000L <= lastModified) {
            response.sendError(412);
            return;
        }
        Range full = new Range(0L, length - 1L, length);
        ArrayList<Range> ranges = new ArrayList<Range>();
        String range = request.getHeader("Range");
        if (range != null) {
            if (!range.matches("^bytes=\\d*-\\d*(,\\d*-\\d*)*$")) {
                response.setHeader("Content-Range", "bytes */" + length);
                response.sendError(416);
                return;
            }
            String ifRange = request.getHeader("If-Range");
            if (ifRange != null && !ifRange.equals(eTag)) {
                try {
                    long ifRangeTime = request.getDateHeader("If-Range");
                    if (ifRangeTime != -1L && ifRangeTime + 1000L < lastModified) {
                        ranges.add(full);
                    }
                }
                catch (IllegalArgumentException ignore) {
                    ranges.add(full);
                }
            }
            if (ranges.isEmpty()) {
                String[] stringArray = range.substring(6).split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    long start = CometVisuServlet.sublong(part, 0, part.indexOf("-"));
                    long end = CometVisuServlet.sublong(part, part.indexOf("-") + 1, part.length());
                    if (start == -1L) {
                        start = length - end;
                        end = length - 1L;
                    } else if (end == -1L || end > length - 1L) {
                        end = length - 1L;
                    }
                    if (start > end) {
                        response.setHeader("Content-Range", "bytes */" + length);
                        response.sendError(416);
                        return;
                    }
                    ranges.add(new Range(start, end, length));
                    ++n2;
                }
            }
        }
        String contentType = this.getServletContext().getMimeType(fileName);
        boolean acceptsGzip = false;
        String disposition = "inline";
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        if (contentType.startsWith("text")) {
            String acceptEncoding = request.getHeader("Accept-Encoding");
            acceptsGzip = acceptEncoding != null && CometVisuServlet.accepts(acceptEncoding, "gzip");
            contentType = String.valueOf(contentType) + ";charset=UTF-8";
        } else if (!contentType.startsWith("image")) {
            String accept = request.getHeader("Accept");
            disposition = accept != null && CometVisuServlet.accepts(accept, contentType) ? "inline" : "attachment";
        }
        response.setBufferSize(10240);
        response.setHeader("Content-Disposition", String.valueOf(disposition) + ";filename=\"" + fileName + "\"");
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("ETag", eTag);
        response.setDateHeader("Last-Modified", lastModified);
        response.setDateHeader("Expires", expires);
        RandomAccessFile input = null;
        Object output = null;
        try {
            input = new RandomAccessFile(file, "r");
            output = response.getOutputStream();
            if (ranges.isEmpty() || ranges.get(0) == full) {
                Range r = full;
                response.setContentType(contentType);
                response.setHeader("Content-Range", "bytes " + r.start + "-" + r.end + "/" + r.total);
                if (content) {
                    if (acceptsGzip) {
                        response.setHeader("Content-Encoding", "gzip");
                        output = new GZIPOutputStream((OutputStream)output, 10240);
                    } else {
                        response.setHeader("Content-Length", String.valueOf(r.length));
                    }
                    CometVisuServlet.copy(input, (OutputStream)output, r.start, r.length);
                }
            } else if (ranges.size() == 1) {
                Range r = (Range)ranges.get(0);
                response.setContentType(contentType);
                response.setHeader("Content-Range", "bytes " + r.start + "-" + r.end + "/" + r.total);
                response.setHeader("Content-Length", String.valueOf(r.length));
                response.setStatus(206);
                if (content) {
                    CometVisuServlet.copy(input, (OutputStream)output, r.start, r.length);
                }
            } else {
                response.setContentType("multipart/byteranges; boundary=MULTIPART_BYTERANGES");
                response.setStatus(206);
                if (content) {
                    ServletOutputStream sos = output;
                    for (Range r : ranges) {
                        sos.println();
                        sos.println("--MULTIPART_BYTERANGES");
                        sos.println("Content-Type: " + contentType);
                        sos.println("Content-Range: bytes " + r.start + "-" + r.end + "/" + r.total);
                        CometVisuServlet.copy(input, (OutputStream)output, r.start, r.length);
                    }
                    sos.println();
                    sos.println("--MULTIPART_BYTERANGES--");
                }
            }
        }
        catch (Throwable throwable) {
            CometVisuServlet.close(output);
            CometVisuServlet.close(input);
            throw throwable;
        }
        CometVisuServlet.close((Closeable)output);
        CometVisuServlet.close(input);
    }

    private void showInstallationHint(HttpServletRequest request, HttpServletResponse response) throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("404.html");
        response.setContentType("text/html");
        PrintWriter writer = response.getWriter();
        byte[] bytes = new byte[in.available()];
        in.read(bytes);
        response.setContentLength(bytes.length);
        writer.print(new String(bytes));
        writer.flush();
        writer.close();
    }

    private final void saveConfig(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String fileName = request.getParameter("config");
        File file = new File(this.userFileFolder, URLDecoder.decode(fileName, "UTF-8"));
        response.setContentType("application/json");
        class Response {
            public Boolean success = false;
            public String message = "";

            Response() {
            }
        }
        Response resp = new Response();
        if (file.exists()) {
            this.logger.debug("save config file'{}' requested", (Object)file);
            File backupFolder = new File(this.userFileFolder, "config/backup/");
            boolean backup = true;
            if (!backupFolder.exists()) {
                try {
                    backupFolder.mkdir();
                }
                catch (SecurityException e) {
                    this.logger.error("Error creating backup directory for CometVisu config files");
                    backup = false;
                }
            }
            if (backup) {
                File backupFile = new File(backupFolder, String.valueOf(file.getName()) + "-" + System.currentTimeMillis());
                FileUtils.copyFile((File)file, (File)backupFile);
            }
            String data = request.getParameter("data");
            FileUtils.writeStringToFile((File)file, (String)data);
            resp.success = true;
            resp.message = "File saved";
        }
        response.getWriter().write(this.marshalJson(resp));
        response.flushBuffer();
    }

    private final void dataProviderService(File file, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.debug("dataprovider '{}' requested", (Object)file.getPath());
        ArrayList<Object> beans = new ArrayList<Object>();
        String resultString = null;
        File resourceFolder = this.rootFolder;
        String rel = file.getPath().substring(this.rootFolder.getPath().length());
        if (rel.startsWith("/source/") || rel.startsWith("/build/")) {
            String[] parts = rel.substring(1).split("/");
            resourceFolder = new File(this.rootFolder, String.valueOf(parts[0]) + "/resource");
            this.logger.debug("new resource folder is {}", (Object)resourceFolder.getPath());
        }
        if (file.getName().equals("dpt_list.json")) {
            ConfigHelper.Transform[] transformArray = ConfigHelper.Transform.values();
            int n = transformArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigHelper.Transform transform = transformArray[n2];
                DataBean bean = new DataBean();
                bean.label = transform.toString().toLowerCase();
                bean.value = "OH:" + bean.label;
                beans.add(bean);
                ++n2;
            }
        } else if (file.getName().equals("list_all_addresses.php")) {
            ArrayList<String> transformTypes = new ArrayList<String>();
            Object bean = ConfigHelper.Transform.values();
            int n = ((ConfigHelper.Transform[])bean).length;
            int n3 = 0;
            while (n3 < n) {
                ConfigHelper.Transform transform = bean[n3];
                transformTypes.add(transform.toString().toLowerCase());
                ++n3;
            }
            HashMap groups = new HashMap();
            for (Item item : this.cometVisuApp.getItemRegistry().getItems()) {
                bean = new ItemBean();
                bean.value = item.getName();
                String type = item.getType();
                if (item.getType() == "Group") {
                    if (((GroupItem)item).getBaseItem() == null) continue;
                    type = ((GroupItem)item).getBaseItem().getType();
                }
                bean.label = item.getName();
                String transform = type.toLowerCase().replace("Item", "");
                if (!transformTypes.contains(transform)) {
                    this.logger.debug("no transform type found for item type {}, skipping this item", (Object)type);
                    continue;
                }
                bean.hints.put("transform", "OH:" + transform);
                if (!groups.containsKey(type)) {
                    groups.put(type, new ArrayList());
                }
                ((List)groups.get(type)).add(bean);
            }
            resultString = this.marshalJson(groups);
        } else if (file.getName().equals("list_all_icons.php")) {
            File svgFile = new File(resourceFolder, "icon/knx-uf-iconset.svg");
            if (svgFile.exists()) {
                try {
                    DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document doc = builder.parse(svgFile);
                    XPath xpath = XPathFactory.newInstance().newXPath();
                    XPathExpression expr = xpath.compile("//symbol/@id");
                    NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
                    int i = 0;
                    int len = nl.getLength();
                    while (i < len) {
                        Node node = nl.item(i);
                        DataBean bean = new DataBean();
                        String iconName = node.getTextContent();
                        if (iconName.startsWith("kuf-")) {
                            iconName = iconName.substring(4);
                        }
                        bean.label = iconName;
                        bean.value = iconName;
                        beans.add(bean);
                        ++i;
                    }
                }
                catch (SAXException e) {
                    this.logger.error("error parsing SVG file: {}", (Object)e.getMessage(), (Object)e);
                }
                catch (ParserConfigurationException e) {
                    this.logger.error("error extracting items from SVG file: {}", (Object)e.getMessage(), (Object)e);
                }
                catch (XPathExpressionException e) {
                    this.logger.error("error extracting items from SVG file: {}", (Object)e.getMessage(), (Object)e);
                }
            } else {
                File iconDir = new File(resourceFolder, "icon/knx-uf-iconset/128x128_white/");
                if (iconDir.exists() && iconDir.isDirectory()) {
                    FilenameFilter filter = new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".png");
                        }
                    };
                    Object[] icons = iconDir.listFiles(filter);
                    Arrays.sort(icons);
                    Object[] objectArray = icons;
                    int i = icons.length;
                    int n = 0;
                    while (n < i) {
                        Object iconFile = objectArray[n];
                        if (((File)iconFile).isFile()) {
                            String iconName = ((File)iconFile).getName().replace(".png", "");
                            DataBean bean = new DataBean();
                            bean.label = iconName;
                            bean.value = iconName;
                            beans.add(bean);
                        }
                        ++n;
                    }
                }
            }
        } else if (file.getName().equals("list_all_plugins.php")) {
            File pluginDir = new File(resourceFolder, "plugins/");
            Object[] plugins = pluginDir.listFiles();
            Arrays.sort(plugins);
            Object[] objectArray = plugins;
            int n = plugins.length;
            int n4 = 0;
            while (n4 < n) {
                Object icon = objectArray[n4];
                if (((File)icon).isDirectory()) {
                    DataBean bean = new DataBean();
                    bean.label = ((File)icon).getName();
                    bean.value = ((File)icon).getName();
                    beans.add(bean);
                }
                ++n4;
            }
        } else if (file.getName().equals("get_designs.php")) {
            File designDir = new File(resourceFolder, "designs/");
            Object[] designs = designDir.listFiles();
            if (designs != null) {
                Arrays.sort(designs);
                Object[] objectArray = designs;
                int n = designs.length;
                int n5 = 0;
                while (n5 < n) {
                    Object design = objectArray[n5];
                    if (((File)design).isDirectory()) {
                        beans.add(((File)design).getName());
                    }
                    ++n5;
                }
            }
        } else {
            file.getName().equals("list_all_rrds.php");
        }
        if (beans.size() == 0 && resultString == null) {
            this.processPhpRequest(file, request, response);
        } else {
            response.setContentType("application/json");
            if (resultString == null) {
                resultString = this.marshalJson(beans);
            }
            response.getWriter().write(resultString);
            response.flushBuffer();
        }
    }

    private String marshalJson(Object bean) {
        Gson gson = new Gson();
        return gson.toJson(bean);
    }

    private static boolean accepts(String acceptHeader, String toAccept) {
        Object[] acceptValues = acceptHeader.split("\\s*(,|;)\\s*");
        Arrays.sort(acceptValues);
        return Arrays.binarySearch(acceptValues, toAccept) > -1 || Arrays.binarySearch(acceptValues, toAccept.replaceAll("/.*$", "/*")) > -1 || Arrays.binarySearch(acceptValues, "*/*") > -1;
    }

    private static boolean matches(String matchHeader, String toMatch) {
        Object[] matchValues = matchHeader.split("\\s*,\\s*");
        Arrays.sort(matchValues);
        return Arrays.binarySearch(matchValues, toMatch) > -1 || Arrays.binarySearch(matchValues, "*") > -1;
    }

    private static long sublong(String value, int beginIndex, int endIndex) {
        String substring = value.substring(beginIndex, endIndex);
        return substring.length() > 0 ? Long.parseLong(substring) : -1L;
    }

    private static void copy(RandomAccessFile input, OutputStream output, long start, long length) throws IOException {
        byte[] buffer = new byte[10240];
        if (input.length() == length) {
            int read;
            while ((read = input.read(buffer)) > 0) {
                output.write(buffer, 0, read);
            }
        } else {
            int read;
            input.seek(start);
            long toRead = length;
            while ((read = input.read(buffer)) > 0) {
                if ((toRead -= (long)read) > 0L) {
                    output.write(buffer, 0, read);
                    continue;
                }
                output.write(buffer, 0, (int)toRead + read);
                break;
            }
        }
    }

    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected class Range {
        long start;
        long end;
        long length;
        long total;

        public Range(long start, long end, long total) {
            this.start = start;
            this.end = end;
            this.length = end - start + 1L;
            this.total = total;
        }
    }
}

