/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal.servlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.core.persistence.QueryablePersistenceService;
import org.eclipse.smarthome.model.sitemap.SitemapProvider;
import org.eclipse.smarthome.ui.icon.IconProvider;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.openhab.ui.cometvisu.internal.Config;
import org.openhab.ui.cometvisu.internal.servlet.CometVisuServlet;
import org.openhab.ui.cometvisu.internal.util.ClientInstaller;
import org.openhab.ui.cometvisu.php.PHProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={CometVisuApp.class}, configurationPid={"org.openhab.cometvisu"}, property={"service.pid=org.openhab.cometvisu", "service.config.description.uri=ui:cometvisu", "service.config.category=ui", "service.config.label=CometVisu"})
public class CometVisuApp {
    private final Logger logger = LoggerFactory.getLogger(CometVisuApp.class);
    protected HttpService httpService;
    private ItemUIRegistry itemUIRegistry;
    private ItemRegistry itemRegistry;
    private Set<SitemapProvider> sitemapProviders = new HashSet<SitemapProvider>();
    private List<IconProvider> iconProviders = new ArrayList<IconProvider>();
    private EventPublisher eventPublisher;
    private CometVisuServlet servlet;
    private PHProvider phpProvider;
    protected static Map<String, QueryablePersistenceService> persistenceServices = new HashMap<String, QueryablePersistenceService>();
    private final ClientInstaller installer = ClientInstaller.getInstance();
    private Map<String, Object> properties = new HashMap<String, Object>();

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> props) {
        this.properties = props;
    }

    public CometVisuServlet getServlet() {
        return this.servlet;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addPersistenceService(PersistenceService service) {
        if (service instanceof QueryablePersistenceService) {
            persistenceServices.put(service.getId(), (QueryablePersistenceService)service);
        }
    }

    public void removePersistenceService(PersistenceService service) {
        persistenceServices.remove(service.getId());
    }

    public static Map<String, QueryablePersistenceService> getPersistenceServices() {
        return persistenceServices;
    }

    public List<IconProvider> getIconProviders() {
        return this.iconProviders;
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    public void addIconProvider(IconProvider iconProvider) {
        this.iconProviders.add(iconProvider);
    }

    public void removeIconProvider(IconProvider iconProvider) {
        this.iconProviders.remove(iconProvider);
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    public ItemRegistry getItemRegistry() {
        return this.itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference
    public void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    public void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.add(provider);
    }

    public void removeSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.remove(provider);
    }

    public ItemUIRegistry getItemUIRegistry() {
        return this.itemUIRegistry;
    }

    public Set<SitemapProvider> getSitemapProviders() {
        return this.sitemapProviders;
    }

    @Reference
    protected void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void unsetHttpService(HttpService httpService) {
        this.httpService = null;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setPHProvider(PHProvider prov) {
        this.phpProvider = prov;
        if (this.servlet != null) {
            this.servlet.setPHProvider(prov);
        }
    }

    public PHProvider getPHProvider() {
        return this.phpProvider;
    }

    public void unsetPHProvider(PHProvider prov) {
        this.phpProvider = null;
        if (this.servlet != null) {
            this.servlet.unsetPHProvider();
        }
    }

    private void readConfiguration(Map<String, Object> properties) {
        if (properties != null) {
            this.setProperties(properties);
            if (properties.get("webFolder") != null) {
                Config.cometvisuWebfolder = (String)properties.get("webFolder");
            }
            if (properties.get("webAlias") != null) {
                Config.cometvisuWebappAlias = (String)properties.get("webAlias");
            }
            if (properties.get("autoDownload") != null) {
                Object propertyValue = properties.get("autoDownload");
                Boolean newValue = false;
                if (propertyValue instanceof String) {
                    newValue = Boolean.valueOf((String)propertyValue);
                } else if (propertyValue instanceof Boolean) {
                    newValue = (Boolean)propertyValue;
                }
                boolean changed = Config.cometvisuAutoDownload ^ newValue;
                Config.cometvisuAutoDownload = newValue;
                if (Config.cometvisuAutoDownload && changed) {
                    this.installer.check();
                }
                Config.cometvisuAutoDownload = newValue;
            }
            for (String key : properties.keySet()) {
                String[] parts = key.split(">");
                String propKey = parts.length > 1 ? parts[1] : parts[0];
                String propPid = parts.length > 1 ? parts[0] : "";
                this.logger.debug("Property: {}->{}:{}, Parts {}", new Object[]{propPid, propKey, properties.get(key), parts.length});
                if (propPid.isEmpty() || !Config.configMappings.containsKey(propPid)) continue;
                Config.configMappings.get(propPid).put(propKey, properties.get(key));
            }
        }
    }

    @Activate
    protected void activate(Map<String, Object> configProps) throws ConfigurationException {
        this.readConfiguration(configProps);
        this.registerServlet();
        this.logger.info("Started CometVisu UI at {} serving {}", (Object)Config.cometvisuWebappAlias, (Object)Config.cometvisuWebfolder);
    }

    @Deactivate
    public void deactivate(BundleContext componentContext) {
        this.unregisterServlet();
        this.logger.info("Stopped CometVisu UI");
    }

    private void registerServlet() {
        if (!Config.cometvisuWebappAlias.startsWith("/")) {
            Config.cometvisuWebappAlias = "/" + Config.cometvisuWebappAlias;
        }
        if (Config.cometvisuWebappAlias.endsWith("/")) {
            Config.cometvisuWebappAlias = Config.cometvisuWebappAlias.substring(0, Config.cometvisuWebappAlias.length() - 1);
        }
        Hashtable servletParams = new Hashtable();
        this.servlet = new CometVisuServlet(Config.cometvisuWebfolder, this);
        try {
            this.httpService.registerServlet(Config.cometvisuWebappAlias, (Servlet)this.servlet, servletParams, null);
        }
        catch (ServletException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
        catch (NamespaceException e) {
            this.logger.error("Error during servlet startup", (Throwable)e);
        }
    }

    private void unregisterServlet() {
        this.httpService.unregister(Config.cometvisuWebappAlias);
    }

    @Modified
    protected void modified(Map<String, Object> configProps) throws ConfigurationException {
        this.logger.info("updated({})", configProps);
        if (configProps == null) {
            return;
        }
        if (configProps.containsKey("webFolder") || configProps.containsKey("webAlias")) {
            this.unregisterServlet();
        }
        this.readConfiguration(configProps);
        if (configProps.containsKey("webFolder") || configProps.containsKey("webAlias")) {
            this.registerServlet();
        }
    }
}

