/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal.listeners;

import java.util.Map;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.types.State;
import org.openhab.ui.cometvisu.internal.backend.EventBroadcaster;
import org.openhab.ui.cometvisu.internal.backend.beans.StateBean;

public class StateEventListener
implements StateChangeListener {
    private EventBroadcaster eventBroadcaster;

    public void setEventBroadcaster(EventBroadcaster eventBroadcaster) {
        this.eventBroadcaster = eventBroadcaster;
    }

    protected void unsetEventBroadcaster(EventBroadcaster eventBroadcaster) {
        this.eventBroadcaster = null;
    }

    public void stateChanged(Item item, State oldState, State newState) {
        Map<String, Class<? extends State>> clientItems = this.eventBroadcaster.getClientItems(item);
        if (clientItems != null && clientItems.size() > 0) {
            for (String cvItemName : clientItems.keySet()) {
                Class<? extends State> stateClass = clientItems.get(cvItemName);
                StateBean stateBean = new StateBean();
                stateBean.name = cvItemName;
                stateBean.state = stateClass != null ? item.getStateAs(stateClass).toString() : item.getState().toString();
                this.eventBroadcaster.broadcastEvent(stateBean);
            }
        } else {
            StateBean stateBean = new StateBean();
            stateBean.name = item.getName();
            stateBean.state = newState.toString();
            this.eventBroadcaster.broadcastEvent(stateBean);
        }
    }

    public void stateUpdated(Item item, State state) {
        Map<String, Class<? extends State>> clientItems;
        if (item instanceof GroupItem && (clientItems = this.eventBroadcaster.getClientItems(item)) != null && clientItems.size() > 0) {
            for (String cvItemName : clientItems.keySet()) {
                Class<? extends State> stateClass = clientItems.get(cvItemName);
                if (stateClass == null) continue;
                StateBean stateBean = new StateBean();
                stateBean.name = cvItemName;
                stateBean.state = item.getStateAs(stateClass).toString();
                this.eventBroadcaster.broadcastEvent(stateBean);
            }
        }
    }
}

