/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal.listeners;

import java.util.Collection;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ItemRegistryChangeListener;
import org.openhab.ui.cometvisu.internal.backend.EventBroadcaster;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class ItemRegistryEventListener
implements ItemRegistryChangeListener {
    private ItemRegistry itemRegistry;
    private EventBroadcaster eventBroadcaster;

    @Reference
    protected void setEventBroadcaster(EventBroadcaster eventBroadcaster) {
        this.eventBroadcaster = eventBroadcaster;
    }

    protected void unsetEventBroadcaster(EventBroadcaster eventBroadcaster) {
        this.eventBroadcaster = null;
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
        this.itemRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.itemRegistry = null;
    }

    public void added(Item element) {
        this.eventBroadcaster.registerItem(element);
    }

    public void removed(Item element) {
        this.eventBroadcaster.unregisterItem(element);
    }

    public void updated(Item oldElement, Item element) {
        this.eventBroadcaster.unregisterItem(oldElement);
        this.eventBroadcaster.registerItem(element);
    }

    public void allItemsChanged(Collection<String> oldItemNames) {
        this.eventBroadcaster.registerItems();
    }
}

