/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal.config;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.library.items.ContactItem;
import org.eclipse.smarthome.core.library.items.DateTimeItem;
import org.eclipse.smarthome.core.library.items.NumberItem;
import org.eclipse.smarthome.core.library.items.RollershutterItem;
import org.eclipse.smarthome.model.sitemap.sitemap.Chart;
import org.eclipse.smarthome.model.sitemap.sitemap.Colorpicker;
import org.eclipse.smarthome.model.sitemap.sitemap.Frame;
import org.eclipse.smarthome.model.sitemap.sitemap.LinkableWidget;
import org.eclipse.smarthome.model.sitemap.sitemap.Selection;
import org.eclipse.smarthome.model.sitemap.sitemap.Setpoint;
import org.eclipse.smarthome.model.sitemap.sitemap.Sitemap;
import org.eclipse.smarthome.model.sitemap.sitemap.Slider;
import org.eclipse.smarthome.model.sitemap.sitemap.Webview;
import org.eclipse.smarthome.model.sitemap.sitemap.Widget;
import org.openhab.ui.cometvisu.internal.Config;
import org.openhab.ui.cometvisu.internal.config.ConfigHelper;
import org.openhab.ui.cometvisu.internal.config.beans.Address;
import org.openhab.ui.cometvisu.internal.config.beans.Colorchooser;
import org.openhab.ui.cometvisu.internal.config.beans.Diagram;
import org.openhab.ui.cometvisu.internal.config.beans.Group;
import org.openhab.ui.cometvisu.internal.config.beans.Image;
import org.openhab.ui.cometvisu.internal.config.beans.Info;
import org.openhab.ui.cometvisu.internal.config.beans.LibVersion;
import org.openhab.ui.cometvisu.internal.config.beans.Mapping;
import org.openhab.ui.cometvisu.internal.config.beans.Meta;
import org.openhab.ui.cometvisu.internal.config.beans.NavbarPositionType;
import org.openhab.ui.cometvisu.internal.config.beans.ObjectFactory;
import org.openhab.ui.cometvisu.internal.config.beans.Page;
import org.openhab.ui.cometvisu.internal.config.beans.Pages;
import org.openhab.ui.cometvisu.internal.config.beans.Plugin;
import org.openhab.ui.cometvisu.internal.config.beans.Rrd;
import org.openhab.ui.cometvisu.internal.config.beans.SchemaPages;
import org.openhab.ui.cometvisu.internal.config.beans.Slide;
import org.openhab.ui.cometvisu.internal.config.beans.Switch;
import org.openhab.ui.cometvisu.internal.config.beans.Text;
import org.openhab.ui.cometvisu.internal.config.beans.Trigger;
import org.openhab.ui.cometvisu.internal.config.beans.Video;
import org.openhab.ui.cometvisu.internal.config.beans.Web;
import org.openhab.ui.cometvisu.internal.servlet.CometVisuApp;
import org.rrd4j.ConsolFun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class VisuConfig {
    private final Logger logger = LoggerFactory.getLogger(VisuConfig.class);
    private Sitemap sitemap;
    private final String schemaFile = "visu_config.xsd";
    private CometVisuApp app;
    private ConfigHelper configHelper;
    private File rootFolder;
    private ObjectFactory factory = new ObjectFactory();

    public VisuConfig(Sitemap sitemap, CometVisuApp app, File rootFolder) {
        this.sitemap = sitemap;
        this.app = app;
        this.rootFolder = rootFolder;
    }

    public String getConfigXml(HttpServletRequest req) {
        SchemaPages pagesBean = new SchemaPages();
        pagesBean.setBackend("oh2");
        pagesBean.setDesign("metal");
        pagesBean.setMaxMobileScreenWidth(new BigDecimal(480));
        pagesBean.setBindClickToWidget(true);
        pagesBean.setLibVersion(BigInteger.valueOf(LibVersion.no));
        pagesBean.setScrollSpeed(new BigDecimal(0));
        File rootFolder = new File(Config.cometvisuWebfolder);
        File sitemap = new File(rootFolder, req.getPathInfo());
        String relXsd = "";
        File parent = sitemap.getParentFile();
        File schema = new File(parent, "visu_config.xsd");
        while (!parent.equals(rootFolder) && !schema.exists()) {
            parent = parent.getParentFile();
            relXsd = String.valueOf(relXsd) + "../";
            schema = new File(parent, "visu_config.xsd");
        }
        pagesBean.setNoNamespaceSchemaLocation(String.valueOf(relXsd) + "visu_config.xsd");
        Meta meta = new Meta();
        pagesBean.setMeta(meta);
        this.configHelper = new ConfigHelper(pagesBean, this.app, sitemap.getName());
        this.createPages(pagesBean);
        return this.marshal(pagesBean, schema.getPath());
    }

    private String marshal(Pages bean, String xsdSchema) {
        String res = "";
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{bean.getClass()});
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = xsdSchema == null || xsdSchema.trim().length() == 0 ? null : schemaFactory.newSchema(new File(xsdSchema));
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setSchema(schema);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter sw = new StringWriter();
            marshaller.marshal((Object)bean, (Writer)sw);
            res = sw.toString();
        }
        catch (JAXBException e) {
            this.logger.error("{}", (Object)e.getMessage(), (Object)e);
        }
        catch (SAXException e) {
            this.logger.error("{}", (Object)e.getMessage(), (Object)e);
        }
        return res;
    }

    private Pages createPages(Pages pagesBean) {
        Page rootPage = new Page();
        rootPage.setName(this.sitemap.getName());
        pagesBean.setPage(rootPage);
        try {
            for (Widget widget : this.sitemap.getChildren()) {
                this.processWidget(rootPage, widget, pagesBean, 0);
            }
            this.configHelper.cleanup(rootPage, pagesBean);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            Text text = new Text();
            text.setFlavour("lithium");
            this.configHelper.addLabel((Object)text, e.getClass() + ": " + e.getMessage());
            rootPage.getPageOrGroupOrNavbar().add(this.factory.createPageText(text));
        }
        return pagesBean;
    }

    private void processWidget(Object rootPage, Widget widget, Pages pages, int level) {
        Item item = null;
        if (widget.getItem() != null) {
            try {
                item = this.app.getItemUIRegistry().getItem(widget.getItem());
            }
            catch (ItemNotFoundException e) {
                this.logger.debug("{}", (Object)e.getMessage());
            }
        }
        if (widget instanceof LinkableWidget) {
            EList children = this.app.getItemUIRegistry().getChildren((LinkableWidget)widget);
            if (children.size() == 0) {
                this.processItemWidget(rootPage, widget, item, pages, level);
            } else if (widget instanceof Frame) {
                Group group = new Group();
                group.setLayout(this.configHelper.createLayout(6));
                group.setName(this.configHelper.getLabel(widget));
                this.configHelper.addToRoot(rootPage, this.factory.createPageGroup(group));
                for (Widget child : children) {
                    this.processWidget(group, child, pages, level + 1);
                }
            } else {
                Page page = new Page();
                page.setName(this.configHelper.getLabel(widget));
                this.configHelper.addToRoot(rootPage, this.factory.createPagePage(page));
                if (widget instanceof org.eclipse.smarthome.model.sitemap.sitemap.Group) {
                    Page barPage;
                    org.eclipse.smarthome.model.sitemap.sitemap.Group group = (org.eclipse.smarthome.model.sitemap.sitemap.Group)widget;
                    NavbarPositionType position = level <= 1 ? NavbarPositionType.TOP : NavbarPositionType.LEFT;
                    Page page2 = barPage = rootPage instanceof Page ? (Page)rootPage : pages.getPage();
                    if (NavbarPositionType.TOP.equals((Object)position)) {
                        barPage = pages.getPage();
                    }
                    this.configHelper.addToNavbar(barPage, page, group, position, item);
                    page.setVisible(false);
                }
                for (Widget child : children) {
                    this.processWidget(page, child, pages, level + 1);
                }
            }
        } else {
            this.processItemWidget(rootPage, widget, item, pages, level);
        }
    }

    private void processItemWidget(Object rootPage, Widget widget, Item item, Pages pages, int level) {
        if (widget instanceof org.eclipse.smarthome.model.sitemap.sitemap.Switch) {
            org.eclipse.smarthome.model.sitemap.sitemap.Switch switchWidget = (org.eclipse.smarthome.model.sitemap.sitemap.Switch)widget;
            if (item instanceof RollershutterItem) {
                this.configHelper.addRollershutter(rootPage, item, (Widget)switchWidget);
            } else if (switchWidget.getMappings().size() > 0) {
                if (switchWidget.getMappings().size() <= 4) {
                    this.configHelper.mapToMultiTrigger(rootPage, item, (Widget)switchWidget);
                } else {
                    this.configHelper.mapToTriggers(rootPage, item, (Widget)switchWidget);
                }
            } else {
                Switch switchBean = new Switch();
                switchBean.setStyling("GreyGreen");
                switchBean.setMapping("OnOff");
                this.configHelper.addAddress(switchBean, item, ConfigHelper.Transform.SWITCH);
                this.configHelper.addLabel((Object)switchBean, this.configHelper.getLabel(widget));
                this.configHelper.addMapping((Object)switchBean, widget);
                this.configHelper.addStyling(switchBean, widget);
                this.configHelper.addToRoot(rootPage, this.factory.createPageSwitch(switchBean));
            }
        } else if (widget instanceof org.eclipse.smarthome.model.sitemap.sitemap.Text) {
            Info info = new Info();
            ConfigHelper.Transform transform = ConfigHelper.Transform.STRING;
            boolean skipFormat = false;
            if (item instanceof ContactItem) {
                transform = ConfigHelper.Transform.CONTACT;
            } else if (item instanceof DateTimeItem) {
                transform = ConfigHelper.Transform.DATETIME;
                skipFormat = true;
            }
            Address address = this.configHelper.addAddress(info, item, transform);
            if (address != null) {
                address.setMode("read");
                if (item != null && !skipFormat) {
                    this.configHelper.addFormat(info, item.getLabel());
                }
                this.configHelper.addLabel((Object)info, widget);
                if (ConfigHelper.Transform.CONTACT.equals((Object)transform)) {
                    info.setMapping("OpenClose");
                } else {
                    this.configHelper.addMapping((Object)info, widget);
                }
                this.configHelper.addStyling(info, widget);
                this.configHelper.addToRoot(rootPage, this.factory.createPageInfo(info));
            } else {
                Text text = new Text();
                this.configHelper.addLabel((Object)text, widget);
                this.configHelper.addStyling(text, widget);
                this.configHelper.addMapping((Object)text, widget);
                this.configHelper.addToRoot(rootPage, this.factory.createPageText(text));
            }
        } else if (widget instanceof Slider) {
            Slide bean = new Slide();
            bean.setFormat("%d%%");
            this.configHelper.addAddress(bean, item, ConfigHelper.Transform.DIMMER);
            this.configHelper.addLabel((Object)bean, widget);
            this.configHelper.addToRoot(rootPage, this.factory.createPageSlide(bean));
        } else if (widget instanceof Setpoint) {
            Setpoint setpoint = (Setpoint)widget;
            Slide bean = new Slide();
            bean.setFormat("%d");
            bean.setMin(setpoint.getMinValue());
            bean.setMax(setpoint.getMaxValue());
            bean.setStep(setpoint.getStep());
            this.configHelper.addAddress(bean, item, ConfigHelper.Transform.DIMMER);
            this.configHelper.addLabel((Object)bean, widget);
            this.configHelper.addToRoot(rootPage, this.factory.createPageSlide(bean));
        } else if (widget instanceof Selection) {
            Selection selection = (Selection)widget;
            Group bean = new Group();
            bean.setNowidget(true);
            bean.setName(this.configHelper.getLabel(widget));
            Address address = this.configHelper.getAddress(item, ConfigHelper.Transform.NUMBER);
            String mappingName = String.valueOf(selection.getMappings().hashCode());
            Mapping mapping = this.configHelper.createMapping(mappingName, (EList<org.eclipse.smarthome.model.sitemap.sitemap.Mapping>)selection.getMappings());
            this.configHelper.addToMappings(mapping);
            for (org.eclipse.smarthome.model.sitemap.sitemap.Mapping map : selection.getMappings()) {
                Trigger trigger = new Trigger();
                trigger.setValue(map.getCmd());
                trigger.setMapping(mappingName);
                trigger.getAddress().add(address);
                trigger.setLayout(this.configHelper.createLayout(Math.max(1, 6 / selection.getMappings().size())));
                this.configHelper.addToRoot(bean, this.factory.createPageTrigger(trigger));
            }
            this.configHelper.addToRoot(rootPage, this.factory.createPageGroup(bean));
        } else if (widget instanceof Webview) {
            Webview webview = (Webview)widget;
            Web bean = new Web();
            bean.setHeight(String.valueOf(String.valueOf(webview.getHeight())) + "%");
            bean.setWidth("100%");
            bean.setSrc(webview.getUrl());
            bean.setRefresh(new BigDecimal(60));
            this.configHelper.addLabel((Object)bean, widget);
            this.configHelper.addToRoot(rootPage, this.factory.createPageWeb(bean));
        } else if (widget instanceof org.eclipse.smarthome.model.sitemap.sitemap.Image) {
            org.eclipse.smarthome.model.sitemap.sitemap.Image image = (org.eclipse.smarthome.model.sitemap.sitemap.Image)widget;
            Image bean = new Image();
            bean.setSrc(image.getUrl());
            bean.setRefresh(new BigDecimal(image.getRefresh()));
            this.configHelper.addLabel((Object)bean, widget);
            this.configHelper.addToRoot(rootPage, this.factory.createPageImage(bean));
        } else if (widget instanceof org.eclipse.smarthome.model.sitemap.sitemap.Video) {
            org.eclipse.smarthome.model.sitemap.sitemap.Video video = (org.eclipse.smarthome.model.sitemap.sitemap.Video)widget;
            Video bean = new Video();
            bean.setSrc(video.getUrl());
            this.configHelper.addLabel((Object)bean, widget);
            this.configHelper.addToRoot(rootPage, this.factory.createPageVideo(bean));
        } else if (widget instanceof Chart && item != null) {
            Plugin plugin = new Plugin();
            plugin.setName("diagram");
            this.configHelper.addPlugin(plugin);
            Chart chart = (Chart)widget;
            Diagram bean = new Diagram();
            bean.setSeries(this.configHelper.getCvChartPeriod(chart.getPeriod()));
            bean.setRefresh(new BigInteger(String.valueOf(chart.getRefresh())));
            bean.setHeight(this.configHelper.defaultChartHeight);
            if (item instanceof GroupItem) {
                for (Item member : ((GroupItem)item).getMembers()) {
                    Rrd rrd = new Rrd();
                    rrd.setValue(member.getName());
                    if (member instanceof NumberItem) {
                        rrd.setConsolidationFunction(ConsolFun.AVERAGE.toString());
                    } else {
                        rrd.setConsolidationFunction(ConsolFun.MAX.toString());
                    }
                    bean.getRrd().add(rrd);
                }
            } else {
                Rrd rrd = new Rrd();
                rrd.setValue(item.getName());
                if (item instanceof NumberItem) {
                    rrd.setConsolidationFunction(ConsolFun.AVERAGE.toString());
                } else {
                    rrd.setConsolidationFunction(ConsolFun.MAX.toString());
                }
                bean.getRrd().add(rrd);
            }
            this.configHelper.addToRoot(rootPage, this.factory.createPageDiagram(bean));
        } else if (widget instanceof Colorpicker) {
            Plugin plugin = new Plugin();
            plugin.setName("colorchooser");
            this.configHelper.addPlugin(plugin);
            Colorchooser bean = new Colorchooser();
            this.configHelper.addAddress(bean, item, ConfigHelper.Transform.COLOR, "rgb");
            this.configHelper.addLabel((Object)bean, widget);
            this.configHelper.addToRoot(rootPage, this.factory.createPageColorchooser(bean));
        } else {
            this.logger.error("unhandled widget '{}'", (Object)widget);
        }
    }
}

