/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal.config;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.model.sitemap.sitemap.Widget;
import org.eclipse.smarthome.ui.icon.IconProvider;
import org.eclipse.smarthome.ui.icon.IconSet;
import org.openhab.ui.cometvisu.internal.Config;
import org.openhab.ui.cometvisu.internal.config.beans.Address;
import org.openhab.ui.cometvisu.internal.config.beans.CDataStatus;
import org.openhab.ui.cometvisu.internal.config.beans.Entry;
import org.openhab.ui.cometvisu.internal.config.beans.Group;
import org.openhab.ui.cometvisu.internal.config.beans.Icon;
import org.openhab.ui.cometvisu.internal.config.beans.IconDefinition;
import org.openhab.ui.cometvisu.internal.config.beans.Icons;
import org.openhab.ui.cometvisu.internal.config.beans.Info;
import org.openhab.ui.cometvisu.internal.config.beans.Label;
import org.openhab.ui.cometvisu.internal.config.beans.Layout;
import org.openhab.ui.cometvisu.internal.config.beans.Line;
import org.openhab.ui.cometvisu.internal.config.beans.Mapping;
import org.openhab.ui.cometvisu.internal.config.beans.Mappings;
import org.openhab.ui.cometvisu.internal.config.beans.Multitrigger;
import org.openhab.ui.cometvisu.internal.config.beans.Navbar;
import org.openhab.ui.cometvisu.internal.config.beans.NavbarPositionType;
import org.openhab.ui.cometvisu.internal.config.beans.ObjectFactory;
import org.openhab.ui.cometvisu.internal.config.beans.Page;
import org.openhab.ui.cometvisu.internal.config.beans.Pagejump;
import org.openhab.ui.cometvisu.internal.config.beans.Pages;
import org.openhab.ui.cometvisu.internal.config.beans.Plugin;
import org.openhab.ui.cometvisu.internal.config.beans.Plugins;
import org.openhab.ui.cometvisu.internal.config.beans.Statusbar;
import org.openhab.ui.cometvisu.internal.config.beans.StylingEntry;
import org.openhab.ui.cometvisu.internal.config.beans.Stylings;
import org.openhab.ui.cometvisu.internal.config.beans.Text;
import org.openhab.ui.cometvisu.internal.config.beans.Trigger;
import org.openhab.ui.cometvisu.internal.config.beans.Widgetinfo;
import org.openhab.ui.cometvisu.internal.servlet.CometVisuApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHelper {
    private final Logger logger = LoggerFactory.getLogger(ConfigHelper.class);
    private Pages pages;
    private String sitemapName;
    private CometVisuApp app;
    private ObjectFactory factory = new ObjectFactory();
    private Map<String, Mapping> mappings = new HashMap<String, Mapping>();
    private Map<String, String> chartPeriodMapping = new HashMap<String, String>();
    public final String defaultChartHeight = "300px";
    private Pattern labelPattern = Pattern.compile(".+\\[(MAP\\(.+\\))?:?(.+)\\]$");

    public ConfigHelper(Pages pages, CometVisuApp app, String sitemapName) {
        this.pages = pages;
        this.app = app;
        this.sitemapName = sitemapName;
        this.logger.info("icon mapping enabled: {}, {} known mappings", Config.iconConfig.get("enableMapping"), (Object)Config.iconMappings.size());
        this.initBasicMappings();
        this.initBasicStylings();
        this.initStatusBar();
        this.chartPeriodMapping.put("h", "hour");
        this.chartPeriodMapping.put("d", "day");
        this.chartPeriodMapping.put("w", "week");
        this.chartPeriodMapping.put("m", "month");
        this.chartPeriodMapping.put("y", "year");
    }

    public String getCvChartPeriod(String ohChartPeriod) {
        if (this.chartPeriodMapping.containsKey(ohChartPeriod.toLowerCase())) {
            return this.chartPeriodMapping.get(ohChartPeriod.toLowerCase());
        }
        return ohChartPeriod.toLowerCase();
    }

    private void initStatusBar() {
        Statusbar statusbar = new Statusbar();
        CDataStatus confStatus = new CDataStatus();
        confStatus.setType("html");
        confStatus.setValue("<img src=\"icon/comet_64_ff8000.png\" alt=\"CometVisu\" /> by <a href=\"http://www.cometvisu.org/\">CometVisu.org</a>");
        statusbar.getStatus().add(confStatus);
        CDataStatus reloadStatus = new CDataStatus();
        reloadStatus.setType("html");
        reloadStatus.setHrefextend("config");
        reloadStatus.setValue(" - <a href=\".?forceReload=true\">Reload</a>");
        statusbar.getStatus().add(reloadStatus);
        CDataStatus defaultStatus = new CDataStatus();
        defaultStatus.setType("html");
        defaultStatus.setValue(" - <a href=\".\">Default Config</a>");
        statusbar.getStatus().add(defaultStatus);
        if (this.app.getServlet().isPhpEnabled()) {
            CDataStatus editStatus = new CDataStatus();
            editStatus.setType("html");
            editStatus.setCondition("!edit");
            editStatus.setHrefextend("config");
            editStatus.setValue(" - <a href=\"editor/\">Edit</a>");
            statusbar.getStatus().add(editStatus);
            CDataStatus checkStatus = new CDataStatus();
            checkStatus.setType("html");
            checkStatus.setHrefextend("config");
            checkStatus.setValue("- <a href=\"check_config.php\">Check Config</a>");
            statusbar.getStatus().add(checkStatus);
        }
        CDataStatus downloadConfig = new CDataStatus();
        downloadConfig.setType("html");
        downloadConfig.setValue(" - <a href=\"config/" + this.sitemapName + "\" download target=\"_blank\">Download</a>");
        statusbar.getStatus().add(downloadConfig);
        CDataStatus versionHint = new CDataStatus();
        versionHint.setType("html");
        versionHint.setHrefextend("config");
        String version = "autogenerated from openHAB " + this.sitemapName + " sitemap";
        versionHint.setValue("<div style=\"float:right;padding-right:0.5em\">Version: " + version + "</div>");
        statusbar.getStatus().add(versionHint);
        this.pages.getMeta().getPluginsOrIconsOrMappings().add(statusbar);
    }

    public boolean hasIconMapping(String ohIconName) {
        return Config.iconConfig.get("enableMapping") != null && Config.iconConfig.get("enableMapping").equals("true") && Config.iconMappings.get(ohIconName) != null;
    }

    public String getIconMapping(String ohIconName) {
        return (String)Config.iconMappings.get(ohIconName);
    }

    private void initBasicStylings() {
        Entry entry;
        StylingEntry styling = new StylingEntry();
        styling.setName("RedGreen");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("0", "red");
        map.put("1", "green");
        for (String value : map.keySet()) {
            entry = new Entry();
            entry.setValue(value);
            entry.getContent().add((Serializable)map.get(value));
            styling.getEntry().add(entry);
        }
        this.addToStylings(styling);
        styling = new StylingEntry();
        styling.setName("GreyGreen");
        map.clear();
        map.put("0", "grey");
        map.put("1", "green");
        for (String value : map.keySet()) {
            entry = new Entry();
            entry.setValue(value);
            entry.getContent().add((Serializable)map.get(value));
            styling.getEntry().add(entry);
        }
        this.addToStylings(styling);
        styling = new StylingEntry();
        styling.setName("GreenGrey");
        map.clear();
        map.put("0", "green");
        map.put("1", "grey");
        for (String value : map.keySet()) {
            entry = new Entry();
            entry.setValue(value);
            entry.getContent().add((Serializable)map.get(value));
            styling.getEntry().add(entry);
        }
        this.addToStylings(styling);
    }

    private void initBasicMappings() {
        Entry entry;
        Entry entry2;
        Mapping mapping = new Mapping();
        mapping.setName("shutter");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("UP", "&#8593;");
        map.put("STOP", "o");
        map.put("DOWN", "&#8595;");
        for (String value : map.keySet()) {
            entry2 = new Entry();
            entry2.setValue(value);
            entry2.getContent().add((Serializable)map.get(value));
            mapping.getEntry().add(entry2);
        }
        this.addToMappings(mapping);
        mapping = new Mapping();
        mapping.setName("OnOff");
        map.clear();
        map.put("0", "O");
        map.put("1", "I");
        for (String value : map.keySet()) {
            entry2 = new Entry();
            entry2.setValue(value);
            if (value == "0") {
                entry2.setDefault(true);
            }
            entry2.getContent().add((Serializable)map.get(value));
            mapping.getEntry().add(entry2);
        }
        this.addToMappings(mapping);
        mapping = new Mapping();
        mapping.setName("OpenClose");
        HashMap<String, Icon> iconMap = new HashMap<String, Icon>();
        iconMap.put("1", this.createIcon("fts_window_1w_open", "red"));
        iconMap.put("0", this.createIcon("fts_window_1w", null));
        for (String value : iconMap.keySet()) {
            entry = new Entry();
            entry.setValue(value);
            entry.getContent().add((Serializable)this.factory.createEntryIcon((Icon)iconMap.get(value)));
            mapping.getEntry().add(entry);
        }
        this.addToMappings(mapping);
        mapping = new Mapping();
        mapping.setName("UpDown");
        iconMap.clear();
        iconMap.put("1", this.createIcon("control_down", null));
        iconMap.put("0", this.createIcon("control_up", null));
        for (String value : iconMap.keySet()) {
            entry = new Entry();
            entry.setValue(value);
            entry.getContent().add((Serializable)this.factory.createEntryIcon((Icon)iconMap.get(value)));
            mapping.getEntry().add(entry);
        }
        this.addToMappings(mapping);
    }

    private Icon createIcon(String name, String color) {
        Icon icon = new Icon();
        icon.setName(name);
        if (color != null && !color.isEmpty()) {
            icon.setColor(color);
        }
        return icon;
    }

    public Address addAddress(Object element, Item item) {
        return this.addAddress(element, item, Transform.STRING);
    }

    public Address addAddress(Object element, Item item, Transform transform) {
        return this.addAddress(element, item, transform, null);
    }

    public Address addAddress(Object element, Item item, Transform transform, String variant) {
        if (element == null || item == null) {
            return null;
        }
        try {
            Method getAddress = element.getClass().getMethod("getAddress", new Class[0]);
            Address address = this.getAddress(item, transform, variant);
            if (getAddress != null && address != null) {
                ((List)getAddress.invoke(element, new Object[0])).add(address);
                return address;
            }
        }
        catch (Exception e) {
            this.logger.error("{}", (Object)e.getMessage());
        }
        return null;
    }

    public Address getAddress(Item item, Transform transform) {
        return this.getAddress(item, transform, null);
    }

    public Address getAddress(Item item, Transform transform, String variant) {
        if (item == null) {
            return null;
        }
        Address address = new Address();
        address.setTransform("OH:" + transform.toString().toLowerCase());
        address.setValue(item.getName());
        if (variant != null) {
            address.setVariant(variant);
        }
        return address;
    }

    public Label addLabel(Object element, Widget widget) {
        return this.addLabel(element, this.getLabel(widget), null);
    }

    public Label addLabel(Object element, String name) {
        return this.addLabel(element, name, null);
    }

    public Label addLabel(Object element, String name, String iconName) {
        if (element == null) {
            return null;
        }
        try {
            Method setter = element.getClass().getMethod("setLabel", Label.class);
            if (setter != null) {
                Label label = new Label();
                if (iconName != null) {
                    Icon icon = new Icon();
                    icon.setName(iconName);
                    label.getContent().add((Serializable)this.factory.createLabelIcon(icon));
                }
                label.getContent().add((Serializable)((Object)name));
                setter.invoke(element, label);
                return label;
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            this.logger.error("{}", (Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.error("{}", (Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.logger.error("{}", (Object)e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.logger.error("{}", (Object)e.getMessage());
        }
        return null;
    }

    public Mapping createMapping(String name, EList<org.eclipse.smarthome.model.sitemap.sitemap.Mapping> sitemapMapping) {
        Mapping mapping = null;
        if (this.mappings.containsKey(name)) {
            mapping = this.mappings.get(name);
        } else {
            mapping = new Mapping();
            mapping.setName(name);
            for (org.eclipse.smarthome.model.sitemap.sitemap.Mapping map : sitemapMapping) {
                Entry entry = new Entry();
                entry.setValue(map.getCmd());
                entry.getContent().add((Serializable)((Object)map.getLabel()));
                mapping.getEntry().add(entry);
            }
            this.mappings.put(name, mapping);
            this.addToMappings(mapping);
        }
        return mapping;
    }

    public Mapping addMapping(Object element, Mapping mapping) {
        if (element != null && mapping != null) {
            try {
                Method setter = element.getClass().getMethod("setMapping", String.class);
                setter.invoke(element, mapping.getName());
                return mapping;
            }
            catch (NoSuchMethodException | SecurityException e) {
                this.logger.error("{}", (Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.logger.error("{}", (Object)e.getMessage());
            }
            catch (IllegalArgumentException e) {
                this.logger.error("{}", (Object)e.getMessage());
            }
            catch (InvocationTargetException e) {
                this.logger.error("{}", (Object)e.getMessage());
            }
        }
        return null;
    }

    public void addRollershutter(Object element, Item item, Widget widget) {
        Group bean = new Group();
        bean.setNowidget(true);
        bean.setLayout(this.createLayout(6));
        Text text = new Text();
        text.setLayout(this.createLayout(3));
        this.addLabel(text, this.getLabel(widget), "fts_shutter");
        this.addToRoot(bean, this.factory.createPageText(text));
        Address address = this.getAddress(item, Transform.ROLLERSHUTTER);
        Trigger upTrigger = new Trigger();
        upTrigger.setValue("UP");
        upTrigger.setMapping("shutter");
        upTrigger.getAddress().add(address);
        upTrigger.setLayout(this.createLayout(1));
        this.addToRoot(bean, this.factory.createPageTrigger(upTrigger));
        Trigger stopTrigger = new Trigger();
        stopTrigger.setValue("STOP");
        stopTrigger.setMapping("shutter");
        stopTrigger.getAddress().add(address);
        stopTrigger.setLayout(this.createLayout(1));
        this.addToRoot(bean, this.factory.createPageTrigger(stopTrigger));
        Trigger downTrigger = new Trigger();
        downTrigger.setValue("DOWN");
        downTrigger.setMapping("shutter");
        downTrigger.getAddress().add(address);
        downTrigger.setLayout(this.createLayout(1));
        this.addToRoot(bean, this.factory.createPageTrigger(downTrigger));
        this.addToRoot(element, this.factory.createPageGroup(bean));
    }

    public void mapToTriggers(Object element, Item item, Widget widget) {
        EList<org.eclipse.smarthome.model.sitemap.sitemap.Mapping> sitemapMapping = this.getMapping(widget);
        int groupColumns = 6;
        Group bean = new Group();
        bean.setNowidget(true);
        bean.setLayout(this.createLayout(groupColumns));
        int textColumns = Math.min(3, groupColumns - sitemapMapping.size());
        int triggerColumns = Math.max(1, Math.round((groupColumns - textColumns) / sitemapMapping.size()));
        Text text = new Text();
        text.setLayout(this.createLayout(textColumns));
        this.addLabel((Object)text, this.getLabel(widget));
        this.addToRoot(bean, this.factory.createGroupText(text));
        Transform transform = Transform.NUMBER;
        ArrayList<Class<StringType>> states = new ArrayList<Class<StringType>>();
        states.add(DecimalType.class);
        states.add(OnOffType.class);
        states.add(OpenClosedType.class);
        states.add(UpDownType.class);
        states.add(StringType.class);
        for (org.eclipse.smarthome.model.sitemap.sitemap.Mapping map : sitemapMapping) {
            Command command = TypeParser.parseCommand(states, (String)map.getCmd());
            if (command instanceof DecimalType) continue;
            transform = Transform.STRING;
            break;
        }
        Address address = this.getAddress(item, transform);
        String mappingName = String.valueOf(sitemapMapping.hashCode());
        Mapping mapping = this.createMapping(mappingName, sitemapMapping);
        this.addToMappings(mapping);
        for (org.eclipse.smarthome.model.sitemap.sitemap.Mapping map : sitemapMapping) {
            Trigger trigger = new Trigger();
            trigger.setValue(map.getCmd());
            trigger.setMapping(mappingName);
            trigger.getAddress().add(address);
            trigger.setLayout(this.createLayout(triggerColumns));
            this.addToRoot(bean, this.factory.createGroupTrigger(trigger));
        }
        this.addToRoot(element, this.factory.createPageGroup(bean));
    }

    public void mapToMultiTrigger(Object element, Item item, Widget widget) {
        EList<org.eclipse.smarthome.model.sitemap.sitemap.Mapping> sitemapMapping = this.getMapping(widget);
        Transform transform = Transform.NUMBER;
        ArrayList<Class<StringType>> states = new ArrayList<Class<StringType>>();
        states.add(DecimalType.class);
        states.add(OnOffType.class);
        states.add(OpenClosedType.class);
        states.add(UpDownType.class);
        states.add(StringType.class);
        for (org.eclipse.smarthome.model.sitemap.sitemap.Mapping map : sitemapMapping) {
            Command command = TypeParser.parseCommand(states, (String)map.getCmd());
            if (command instanceof DecimalType) continue;
            transform = Transform.STRING;
            break;
        }
        Address address = this.getAddress(item, transform);
        Multitrigger mtrigger = this.factory.createMultitrigger();
        mtrigger.setShowstatus("true");
        this.addLabel((Object)mtrigger, this.getLabel(widget));
        mtrigger.getAddress().add(address);
        mtrigger.setLayout(this.createLayout(6));
        int i = 1;
        for (org.eclipse.smarthome.model.sitemap.sitemap.Mapping map : sitemapMapping) {
            switch (i) {
                case 1: {
                    mtrigger.setButton1Label(map.getLabel());
                    mtrigger.setButton1Value(map.getCmd());
                    break;
                }
                case 2: {
                    mtrigger.setButton2Label(map.getLabel());
                    mtrigger.setButton2Value(map.getCmd());
                    break;
                }
                case 3: {
                    mtrigger.setButton3Label(map.getLabel());
                    mtrigger.setButton3Value(map.getCmd());
                    break;
                }
                case 4: {
                    mtrigger.setButton4Label(map.getLabel());
                    mtrigger.setButton4Value(map.getCmd());
                }
            }
            ++i;
        }
        this.addToRoot(element, this.factory.createPageMultitrigger(mtrigger));
    }

    private EList<org.eclipse.smarthome.model.sitemap.sitemap.Mapping> getMapping(Widget widget) {
        EList mapping = null;
        try {
            Method getter = widget.getClass().getMethod("getMappings", new Class[0]);
            mapping = (EList)getter.invoke((Object)widget, new Object[0]);
        }
        catch (NoSuchMethodException | SecurityException getter) {
        }
        catch (IllegalAccessException e) {
            this.logger.error("{}", (Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.logger.error("{}", (Object)e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.logger.error("{}", (Object)e.getMessage());
        }
        return mapping;
    }

    public Mapping addMapping(Object element, Widget widget) {
        Mapping mapping = null;
        EList<org.eclipse.smarthome.model.sitemap.sitemap.Mapping> smap = this.getMapping(widget);
        if (smap != null && smap.size() > 0) {
            mapping = this.addMapping(element, String.valueOf(smap.hashCode()), smap);
        }
        return mapping;
    }

    public Mapping addMapping(Object element, String name, EList<org.eclipse.smarthome.model.sitemap.sitemap.Mapping> sitemapMapping) {
        Mapping mapping = this.createMapping(name, sitemapMapping);
        this.addMapping(element, mapping);
        return mapping;
    }

    public void addToMappings(Mapping mapping) {
        Mappings mappings = null;
        for (Object mp : this.pages.getMeta().getPluginsOrIconsOrMappings()) {
            if (!(mp instanceof Mappings)) continue;
            mappings = (Mappings)mp;
            for (Mapping map : mappings.getMapping()) {
                if (!map.getName().equals(mapping.getName())) continue;
                return;
            }
        }
        if (mappings == null) {
            mappings = new Mappings();
            this.pages.getMeta().getPluginsOrIconsOrMappings().add(mappings);
        }
        mappings.getMapping().add(mapping);
    }

    public void addStyling(Object bean, Widget widget) {
    }

    public void addToStylings(StylingEntry styling) {
        Stylings stylings = null;
        for (Object mp : this.pages.getMeta().getPluginsOrIconsOrMappings()) {
            if (!(mp instanceof Stylings)) continue;
            stylings = (Stylings)mp;
            for (StylingEntry style : stylings.getStyling()) {
                if (!style.getName().equals(styling.getName())) continue;
                return;
            }
        }
        if (stylings == null) {
            stylings = new Stylings();
            this.pages.getMeta().getPluginsOrIconsOrMappings().add(stylings);
        }
        stylings.getStyling().add(styling);
    }

    public void addPlugin(Plugin plugin) {
        boolean found = false;
        Plugins plugins = null;
        for (Object rp : this.pages.getMeta().getPluginsOrIconsOrMappings()) {
            if (rp instanceof Plugins) {
                plugins = (Plugins)rp;
                for (Plugin p : plugins.getPlugin()) {
                    if (!p.getName().equals(plugin.getName())) continue;
                    found = true;
                    break;
                }
            }
            if (found) break;
        }
        if (!found) {
            if (plugins == null) {
                plugins = new Plugins();
                this.pages.getMeta().getPluginsOrIconsOrMappings().add(plugins);
            }
            plugins.getPlugin().add(plugin);
        }
    }

    public void addToRoot(Object root, JAXBElement<?> child) {
        if (root instanceof Page) {
            ((Page)root).getPageOrGroupOrNavbar().add(child);
        } else if (root instanceof Group) {
            ((Group)root).getPageOrGroupOrLine().add(child);
        }
    }

    public Layout createLayout(int colspan) {
        return this.createLayout(colspan, 1);
    }

    public Layout createLayout(int colspan, int rowspan) {
        Layout layout = new Layout();
        layout.setColspan(new BigDecimal(colspan));
        if (rowspan != 1) {
            layout.setRowspan(new BigDecimal(rowspan));
        }
        return layout;
    }

    public String getLabel(Widget widget) {
        String label = this.app.getItemUIRegistry().getLabel(widget);
        label = label.replaceAll("\\[.*\\]$", "");
        return StringEscapeUtils.escapeXml((String)label);
    }

    public void addSeparatorToNavbar(Page page, NavbarPositionType position, boolean ifNotEmpty) {
        Navbar navbar = this.getNavbar(page, position);
        if (!(navbar == null || ifNotEmpty && navbar.getPageOrGroupOrLine().size() <= 0)) {
            Line line = new Line();
            line.setLayout(this.createLayout(0));
            navbar.getPageOrGroupOrLine().add(this.factory.createNavbarLine(line));
        }
    }

    public String getExistingIconName(String ohIcon) {
        if (ohIcon == null || ohIcon.isEmpty()) {
            return null;
        }
        if (this.hasIconMapping(ohIcon)) {
            return this.getIconMapping(ohIcon);
        }
        for (IconProvider provider : this.app.getIconProviders()) {
            this.logger.debug("searching for icon '{}' on provider '{}'", (Object)ohIcon, (Object)provider);
            if (provider.hasIcon(ohIcon, "classic", IconSet.Format.PNG) == null) continue;
            IconDefinition iconDef = this.factory.createIconDefinition();
            iconDef.setUri("/icon/" + ohIcon + "?format=png");
            iconDef.setName("OH_" + ohIcon);
            this.addIconDefinition(iconDef);
            return "OH_" + ohIcon;
        }
        this.logger.debug("no icon named '{}' found", (Object)ohIcon);
        return null;
    }

    public void addToNavbar(Page barPage, Page targetPage, org.eclipse.smarthome.model.sitemap.sitemap.Group widget, NavbarPositionType position, Item item) {
        Pagejump pagejump = new Pagejump();
        pagejump.setBindClickToWidget(true);
        pagejump.setTarget(targetPage.getName());
        String ohIcon = this.app.getItemUIRegistry().getCategory((Widget)widget);
        if (NavbarPositionType.TOP.equals((Object)position) || NavbarPositionType.BOTTOM.equals((Object)position)) {
            this.addLabel(pagejump, targetPage.getName(), this.getExistingIconName(ohIcon));
        } else {
            this.addLabel(pagejump, "", this.getExistingIconName(ohIcon));
            pagejump.setName(targetPage.getName());
        }
        if (item != null && item.getLabel() != null) {
            Matcher m = this.labelPattern.matcher(item.getLabel());
            String format = null;
            if (m.matches() && (format = m.group(2)).contains("%d")) {
                Widgetinfo infowidget = new Widgetinfo();
                Info info = new Info();
                info.setFormat(format);
                info.setLayout(this.createLayout(0));
                Address address = new Address();
                address.setTransform("OH:" + Transform.NUMBER.toString().toLowerCase());
                address.setValue(String.valueOf(Transform.NUMBER.toString().toLowerCase()) + ":" + item.getName());
                info.getAddress().add(address);
                infowidget.setInfo(info);
                pagejump.setWidgetinfo(infowidget);
            }
        }
        this.addToNavbar(barPage, pagejump, position);
    }

    public void addIconDefinition(IconDefinition iconDef) {
        Icons icons = null;
        for (Object entry : this.pages.getMeta().getPluginsOrIconsOrMappings()) {
            if (!(entry instanceof Icons)) continue;
            icons = (Icons)entry;
            break;
        }
        if (icons == null) {
            icons = this.factory.createIcons();
            this.pages.getMeta().getPluginsOrIconsOrMappings().add(icons);
            icons.getIconDefinition().add(iconDef);
        } else {
            boolean found = false;
            for (IconDefinition def : icons.getIconDefinition()) {
                if (!def.getName().equals(iconDef.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                icons.getIconDefinition().add(iconDef);
            }
        }
        this.logger.trace("adding icon-def '{}' url '{}'", (Object)iconDef.getName(), (Object)iconDef.getUri());
    }

    private Navbar getNavbar(Page page, NavbarPositionType position) {
        Navbar navbar = null;
        for (JAXBElement<?> elem : page.getPageOrGroupOrNavbar()) {
            if (!(elem.getValue() instanceof Navbar) || !((Navbar)elem.getValue()).getPosition().equals((Object)position)) continue;
            navbar = (Navbar)elem.getValue();
            break;
        }
        return navbar;
    }

    private void addToNavbar(Page page, Pagejump pagejump, NavbarPositionType position) {
        Navbar navbar = this.getNavbar(page, position);
        if (navbar == null) {
            navbar = new Navbar();
            navbar.setPosition(position);
            navbar.setDynamic(true);
            page.getPageOrGroupOrNavbar().add(this.factory.createPageNavbar(navbar));
            switch (position) {
                case BOTTOM: {
                    page.setShownavbarBottom(true);
                    break;
                }
                case LEFT: {
                    navbar.setWidth("200px");
                    page.setShownavbarLeft(true);
                    break;
                }
                case RIGHT: {
                    navbar.setWidth("200px");
                    page.setShownavbarRight(true);
                    break;
                }
                case TOP: {
                    page.setShownavbarTop(true);
                }
            }
        }
        if (NavbarPositionType.TOP.equals((Object)position)) {
            pagejump.setLayout(this.createLayout(0));
        }
        navbar.getPageOrGroupOrLine().add(this.factory.createNavbarPagejump(pagejump));
    }

    public void addFormat(Object elem, String label) {
        try {
            Method method = elem.getClass().getMethod("setFormat", String.class);
            Matcher m = this.labelPattern.matcher(label);
            String format = null;
            if (m.matches() && !m.group(2).equals("%s")) {
                format = m.group(2);
                method.invoke(elem, format);
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            this.logger.error("{}", (Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.error("{}", (Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            this.logger.error("{}", (Object)e.getMessage());
        }
        catch (InvocationTargetException e) {
            this.logger.error("{}", (Object)e.getMessage());
        }
    }

    public void cleanup(Object page, Pages pages) {
        List<Object> children = new ArrayList();
        if (page instanceof Pages) {
            this.cleanup(((Pages)page).getPage(), pages);
        } else if (page instanceof Page) {
            children = ((Page)page).getPageOrGroupOrNavbar();
        } else if (page instanceof Group) {
            children = ((Group)page).getPageOrGroupOrLine();
        }
        ArrayList childsToAdd = new ArrayList();
        ArrayList<JAXBElement> groupsToDelete = new ArrayList<JAXBElement>();
        for (JAXBElement jAXBElement : children) {
            int visible;
            if (jAXBElement.getValue() instanceof Page) {
                Page p = (Page)jAXBElement.getValue();
                visible = 0;
                Page firstChildPage = null;
                for (JAXBElement<?> ge : p.getPageOrGroupOrNavbar()) {
                    if (ge.getValue() instanceof Page) {
                        if (firstChildPage == null) {
                            firstChildPage = (Page)ge.getValue();
                        }
                        if (((Page)ge.getValue()).isVisible() != null && !((Page)ge.getValue()).isVisible().booleanValue()) continue;
                        ++visible;
                        continue;
                    }
                    if (!(ge.getValue() instanceof Group)) continue;
                    ++visible;
                }
                if (visible == 0 && firstChildPage != null) {
                    for (JAXBElement<?> e : pages.getPage().getPageOrGroupOrNavbar()) {
                        if (!(e.getValue() instanceof Navbar)) continue;
                        Navbar navbar = (Navbar)e.getValue();
                        for (JAXBElement<?> ne : navbar.getPageOrGroupOrLine()) {
                            Pagejump pj;
                            if (!(ne.getValue() instanceof Pagejump) || !(pj = (Pagejump)ne.getValue()).getTarget().equals(p.getName())) continue;
                            pj.setTarget(firstChildPage.getName());
                        }
                    }
                }
                this.cleanup(jAXBElement.getValue(), pages);
                continue;
            }
            if (!(jAXBElement.getValue() instanceof Group)) continue;
            Group group = (Group)jAXBElement.getValue();
            visible = 0;
            for (JAXBElement<?> ge : group.getPageOrGroupOrLine()) {
                if (ge == null || ge.getValue() == null) continue;
                if (ge.getValue() instanceof Page) {
                    Page p = (Page)ge.getValue();
                    if (p.isVisible() != null && !p.isVisible().booleanValue()) continue;
                    ++visible;
                    continue;
                }
                ++visible;
            }
            if (visible == 0) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("group '{}' has no visible elements", (Object)group.getName());
                }
                for (JAXBElement<?> ge : group.getPageOrGroupOrLine()) {
                    childsToAdd.add(ge);
                }
                groupsToDelete.add(jAXBElement);
            }
            this.cleanup(group, pages);
        }
        if (childsToAdd.size() > 0 && page instanceof Page && this.logger.isTraceEnabled()) {
            this.logger.trace("there are '{}' children to be added to '{}'", (Object)childsToAdd.size(), (Object)((Page)page).getName());
        }
        for (JAXBElement jAXBElement : childsToAdd) {
            if (page instanceof Page) {
                ((Page)page).getPageOrGroupOrNavbar().add(jAXBElement);
                continue;
            }
            if (!(page instanceof Group)) continue;
            ((Group)page).getPageOrGroupOrLine().add(jAXBElement);
        }
        for (JAXBElement jAXBElement : groupsToDelete) {
            if (page instanceof Page) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("removing group '{}' from '{}'", (Object)jAXBElement, (Object)((Page)page).getName());
                }
                ((Page)page).getPageOrGroupOrNavbar().remove(jAXBElement);
                continue;
            }
            if (!(page instanceof Group)) continue;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("removing group '{}' from '{}'", (Object)jAXBElement, (Object)((Group)page).getName());
            }
            ((Group)page).getPageOrGroupOrLine().remove(jAXBElement);
        }
    }

    public static enum Transform {
        NUMBER,
        SWITCH,
        STRING,
        ROLLERSHUTTER,
        DATETIME,
        TIME,
        CONTACT,
        DIMMER,
        COLOR,
        LOCATION;

    }
}

