/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal.backend;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.TypeParser;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.openhab.ui.cometvisu.internal.backend.beans.SuccessBean;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="cv/w")
@Component(immediate=true, service={WriteResource.class, RESTResource.class})
public class WriteResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(WriteResource.class);
    private ItemRegistry itemRegistry;
    private EventPublisher eventPublisher;
    @Context
    private UriInfo uriInfo;

    @GET
    @Produces(value={"application/json"})
    public Response setState(@Context HttpHeaders headers, @QueryParam(value="a") String itemName, @QueryParam(value="v") String value, @QueryParam(value="ts") long timestamp) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received CV write request at '{}' for item '{}' with value '{}'.", new Object[]{this.uriInfo.getPath(), itemName, value});
        }
        try {
            Item item = this.itemRegistry.getItem(itemName);
            Command command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)value);
            SuccessBean bean = new SuccessBean();
            if (command != null) {
                this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)item.getName(), (Command)command));
                bean.success = 1;
            } else {
                bean.success = 0;
            }
            return Response.ok((Object)bean, (String)"application/json").build();
        }
        catch (ItemNotFoundException e) {
            this.logger.error("{}", (Object)e.getLocalizedMessage());
            return Response.notAcceptable(null).build();
        }
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    @Reference
    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }
}

