/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal.backend;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemFactory;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.SseBroadcaster;
import org.glassfish.jersey.server.ChunkedOutput;
import org.openhab.ui.cometvisu.internal.Config;
import org.openhab.ui.cometvisu.internal.backend.EventBroadcaster;
import org.openhab.ui.cometvisu.internal.backend.beans.StateBean;
import org.openhab.ui.cometvisu.internal.listeners.StateEventListener;
import org.openhab.ui.cometvisu.internal.util.SseUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="cv/r")
@Component(immediate=true)
public class ReadResource
implements EventBroadcaster,
RESTResource {
    private final Logger logger = LoggerFactory.getLogger(ReadResource.class);
    private SseBroadcaster broadcaster = new SseBroadcaster();
    private final ExecutorService executorService;
    private ItemRegistry itemRegistry;
    private StateEventListener stateEventListener;
    private List<String> itemNames = new ArrayList<String>();
    private Map<Item, Map<String, Class<? extends State>>> items = new HashMap<Item, Map<String, Class<? extends State>>>();
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpServletResponse response;
    @Context
    private HttpServletRequest request;
    private Collection<ItemFactory> itemFactories = new CopyOnWriteArrayList<ItemFactory>();

    public ReadResource() {
        this.executorService = Executors.newSingleThreadExecutor();
        this.stateEventListener = new StateEventListener();
        this.stateEventListener.setEventBroadcaster(this);
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    protected void addItemFactory(ItemFactory itemFactory) {
        this.itemFactories.add(itemFactory);
    }

    protected void removeItemFactory(ItemFactory itemFactory) {
        this.itemFactories.remove(itemFactory);
    }

    @GET
    @Produces(value={"text/event-stream"})
    public Object getStates(@QueryParam(value="a") List<String> itemNames, @QueryParam(value="i") long index, @QueryParam(value="t") long time) throws IOException, InterruptedException {
        EventOutput eventOutput = new EventOutput();
        this.itemNames = itemNames;
        this.broadcaster.add((ChunkedOutput)eventOutput);
        this.items = new HashMap<Item, Map<String, Class<? extends State>>>();
        if (this.itemRegistry != null) {
            ArrayList<StateBean> states = new ArrayList<StateBean>();
            for (String cvItemName : itemNames) {
                try {
                    Item item;
                    String[] parts = cvItemName.split(":");
                    String ohItemName = cvItemName;
                    Class<? extends State> stateClass = null;
                    if (parts.length == 2) {
                        String classPrefix = parts[0].toLowerCase();
                        if (Config.itemTypeMapper.containsKey(classPrefix)) {
                            stateClass = Config.itemTypeMapper.get(classPrefix);
                            classPrefix = String.valueOf(classPrefix) + ":";
                        } else {
                            this.logger.debug("no type found for '{}'", (Object)classPrefix);
                            classPrefix = "";
                        }
                        ohItemName = parts[1];
                    }
                    if (!this.items.containsKey(item = this.itemRegistry.getItem(ohItemName))) {
                        this.items.put(item, new HashMap());
                    }
                    this.items.get(item).put(cvItemName, stateClass);
                    StateBean itemState = new StateBean();
                    itemState.name = cvItemName;
                    if (stateClass != null) {
                        itemState.state = item.getStateAs(stateClass).toString();
                        this.logger.trace("get state of '{}' as '{}' == '{}'", new Object[]{item, stateClass, itemState.state});
                    } else {
                        itemState.state = item.getState().toString();
                    }
                    states.add(itemState);
                }
                catch (ItemNotFoundException e) {
                    this.logger.error("{}", (Object)e.getLocalizedMessage());
                }
            }
            this.logger.debug("initially broadcasting {}/{} item states", (Object)states.size(), (Object)itemNames.size());
            this.broadcaster.broadcast((Object)SseUtil.buildEvent(states));
        }
        this.registerItems();
        return eventOutput;
    }

    @Override
    public void registerItems() {
        for (Item item : this.items.keySet()) {
            if (!(item instanceof GenericItem)) continue;
            ((GenericItem)item).addStateChangeListener((StateChangeListener)this.stateEventListener);
        }
    }

    @Override
    public void registerItem(Item item) {
        if (item == null || this.items.containsKey(item) || !this.itemNames.contains(item.getName())) {
            return;
        }
        if (item instanceof GenericItem) {
            ((GenericItem)item).addStateChangeListener((StateChangeListener)this.stateEventListener);
        }
    }

    @Override
    public void unregisterItem(Item item) {
        if (item == null || this.items.containsKey(item) || !this.itemNames.contains(item.getName())) {
            return;
        }
        if (item instanceof GenericItem) {
            ((GenericItem)item).removeStateChangeListener((StateChangeListener)this.stateEventListener);
            this.items.remove(item);
        }
    }

    @Override
    public void broadcastEvent(Object eventObject) {
        this.executorService.execute(() -> this.broadcaster.broadcast((Object)SseUtil.buildEvent(eventObject)));
    }

    @Override
    public Map<String, Class<? extends State>> getClientItems(Item item) {
        return this.items.get(item);
    }
}

