/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal.backend;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.openhab.ui.cometvisu.internal.util.ClientInstaller;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="cv/config")
@Component(immediate=true, service={ConfigResource.class, RESTResource.class})
public class ConfigResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(ConfigResource.class);

    @GET
    @Path(value="/{actionName}")
    @Produces(value={"text/plain"})
    public Response getValue(@PathParam(value="actionName") String actionName) {
        if (!"download-client".equalsIgnoreCase(actionName)) {
            this.logger.error("Unknown CometVisu backend action '{}' requested", (Object)actionName);
            return Response.status((int)404).build();
        }
        this.logger.debug("calling installation checker with config overriding");
        ClientInstaller.getInstance().check(true);
        return Response.ok().build();
    }
}

