/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal.backend;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.persistence.FilterCriteria;
import org.eclipse.smarthome.core.persistence.HistoricItem;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.core.persistence.QueryablePersistenceService;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.io.rest.RESTResource;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="cv/rrdfetch")
@Component(immediate=true, service={ChartResource.class, RESTResource.class})
public class ChartResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(ChartResource.class);
    private static final String PATTERN = "0.0000000000E00";
    private static final DecimalFormat DECIMAL_FORMAT;
    protected static final String RRD_FOLDER;
    protected static Map<String, QueryablePersistenceService> persistenceServices;
    private ItemRegistry itemRegistry;
    @Context
    private UriInfo uriInfo;

    static {
        RRD_FOLDER = String.valueOf(ConfigConstants.getUserDataFolder()) + File.separator + "persistence" + File.separator + "rrd4j";
        DECIMAL_FORMAT = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
        DECIMAL_FORMAT.applyPattern(PATTERN);
        persistenceServices = new HashMap<String, QueryablePersistenceService>();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addPersistenceService(PersistenceService service) {
        if (service instanceof QueryablePersistenceService) {
            persistenceServices.put(service.getId(), (QueryablePersistenceService)service);
        }
    }

    public void removePersistenceService(PersistenceService service) {
        persistenceServices.remove(service.getId());
    }

    public static Map<String, QueryablePersistenceService> getPersistenceServices() {
        return persistenceServices;
    }

    @Reference
    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Produces(value={"application/json"})
    public Response getChartSeries(@Context HttpHeaders headers, @QueryParam(value="rrd") String itemName, @QueryParam(value="ds") String consFunction, @QueryParam(value="start") String start, @QueryParam(value="end") String end, @QueryParam(value="res") long resolution) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received GET request at '{}' for rrd '{}'.", (Object)this.uriInfo.getPath(), (Object)itemName);
        }
        String responseType = "application/json";
        ConsolFun consilidationFunction = ConsolFun.valueOf((String)consFunction);
        long[] times = Util.getTimestamps((String)start, (String)end);
        Date startTime = new Date();
        startTime.setTime(times[0] * 1000L);
        Date endTime = new Date();
        endTime.setTime(times[1] * 1000L);
        if (itemName.endsWith(".rrd")) {
            itemName = itemName.substring(0, itemName.length() - 4);
        }
        String[] parts = itemName.split(":");
        String service = "rrd4j";
        if (parts.length == 2) {
            itemName = parts[1];
            service = parts[0];
        }
        try {
            Item item = this.itemRegistry.getItem(itemName);
            this.logger.debug("item '{}' found ", (Object)item);
            QueryablePersistenceService persistenceService = ChartResource.getPersistenceServices().get(service);
            if (persistenceService == null) {
                Iterator<Map.Entry<String, QueryablePersistenceService>> pit = ChartResource.getPersistenceServices().entrySet().iterator();
                if (!pit.hasNext()) throw new IllegalArgumentException("No Persistence service found.");
                persistenceService = pit.next().getValue();
                this.logger.debug("required persistence service ({}) not found, using {} instead", (Object)service, (Object)persistenceService.getId());
            } else {
                this.logger.debug("using {} persistence for item {}", (Object)persistenceService.getId(), (Object)itemName);
            }
            Object data = null;
            data = persistenceService.getId().equals("rrd4j") ? this.getRrdSeries(persistenceService, item, consilidationFunction, startTime, endTime, resolution) : this.getPersistenceSeries(persistenceService, item, startTime, endTime, resolution);
            return Response.ok((Object)data, (String)responseType).build();
        }
        catch (ItemNotFoundException e1) {
            this.logger.error("Item '{}' not found error while requesting series data.", (Object)itemName);
            return Response.serverError().build();
        }
    }

    public Object getPersistenceSeries(QueryablePersistenceService persistenceService, Item item, Date timeBegin, Date timeEnd, long resolution) {
        HashMap<Long, List<String>> data = new HashMap<Long, List<String>>();
        FilterCriteria filter = new FilterCriteria();
        filter.setBeginDate(timeBegin);
        filter.setEndDate(timeEnd);
        filter.setItemName(item.getName());
        filter.setOrdering(FilterCriteria.Ordering.ASCENDING);
        Iterable result = persistenceService.query(filter);
        Iterator it = result.iterator();
        int dataCounter = 0;
        while (it.hasNext()) {
            ++dataCounter;
            HistoricItem historicItem = (HistoricItem)it.next();
            State state = historicItem.getState();
            if (!(state instanceof DecimalType)) continue;
            ArrayList<String> vals = new ArrayList<String>();
            vals.add(ChartResource.formatDouble(((DecimalType)state).doubleValue(), "null", true));
            data.put(historicItem.getTimestamp().getTime(), vals);
        }
        this.logger.debug("'{}' querying item '{}' from '{}' to '{}' => '{}' results", new Object[]{persistenceService.getId(), filter.getItemName(), filter.getBeginDate(), filter.getEndDate(), dataCounter});
        return this.convertToRrd(data);
    }

    public Object getRrdSeries(QueryablePersistenceService persistenceService, Item item, ConsolFun consilidationFunction, Date timeBegin, Date timeEnd, long resolution) {
        TreeMap<Long, List<String>> data = new TreeMap<Long, List<String>>();
        try {
            ArrayList<String> itemNames = new ArrayList<String>();
            if (item instanceof GroupItem) {
                GroupItem groupItem = (GroupItem)item;
                for (Item member : groupItem.getMembers()) {
                    itemNames.add(member.getName());
                }
            } else {
                itemNames.add(item.getName());
            }
            for (String itemName : itemNames) {
                this.addRrdData(data, itemName, consilidationFunction, timeBegin, timeEnd, resolution);
            }
        }
        catch (FileNotFoundException e) {
            this.logger.debug("no rrd file found '{}'", (Object)(String.valueOf(RRD_FOLDER) + File.separator + item.getName() + ".rrd"));
            return this.getPersistenceSeries(persistenceService, item, timeBegin, timeEnd, resolution);
        }
        catch (Exception e) {
            this.logger.error("{}: fallback to generic persistance service", (Object)e.getLocalizedMessage());
            return this.getPersistenceSeries(persistenceService, item, timeBegin, timeEnd, resolution);
        }
        return this.convertToRrd(data);
    }

    private List<Object> convertToRrd(Map<Long, List<String>> data) {
        TreeMap<Long, List<String>> treeMap = new TreeMap<Long, List<String>>(data);
        ArrayList<Object> rrd = new ArrayList<Object>();
        for (Long time : treeMap.keySet()) {
            Object[] entry = new Object[]{time, data.get(time)};
            rrd.add(entry);
        }
        return rrd;
    }

    private Map<Long, List<String>> addRrdData(Map<Long, List<String>> data, String itemName, ConsolFun consilidationFunction, Date timeBegin, Date timeEnd, long resolution) throws IOException {
        RrdDb rrdDb = new RrdDb(String.valueOf(RRD_FOLDER) + File.separator + itemName + ".rrd");
        FetchRequest fetchRequest = rrdDb.createFetchRequest(consilidationFunction, Util.getTimestamp((Date)timeBegin), Util.getTimestamp((Date)timeEnd), resolution);
        FetchData fetchData = fetchRequest.fetchData();
        long[] timestamps = fetchData.getTimestamps();
        double[][] values = fetchData.getValues();
        this.logger.debug("RRD fetch returned '{}' rows and '{}' columns", (Object)fetchData.getRowCount(), (Object)fetchData.getColumnCount());
        int row = 0;
        while (row < fetchData.getRowCount()) {
            long time = timestamps[row] * 1000L;
            if (!data.containsKey(time)) {
                data.put(time, new ArrayList());
            }
            List<String> vals = data.get(time);
            int indexOffset = vals.size();
            int dsIndex = 0;
            while (dsIndex < fetchData.getColumnCount()) {
                vals.add(dsIndex + indexOffset, ChartResource.formatDouble(values[dsIndex][row], "null", true));
                ++dsIndex;
            }
            ++row;
        }
        rrdDb.close();
        return data;
    }

    static String formatDouble(double x, String nanString, boolean forceExponents) {
        if (Double.isNaN(x)) {
            return nanString;
        }
        if (forceExponents) {
            return DECIMAL_FORMAT.format(x);
        }
        return "" + x;
    }
}

