/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal.async;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegate;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegateProvider;
import org.openhab.ui.cometvisu.internal.util.SseUtil;

public class BlockingAsyncContextDelegateProvider
implements AsyncContextDelegateProvider {
    public final AsyncContextDelegate createDelegate(HttpServletRequest request, HttpServletResponse response) {
        return new BlockingAsyncContextDelegate(request, response);
    }

    private static final class BlockingAsyncContextDelegate
    implements AsyncContextDelegate {
        private static final int PING_TIMEOUT = 15000;
        private final HttpServletResponse response;
        private volatile boolean isRunning;

        private BlockingAsyncContextDelegate(HttpServletRequest request, HttpServletResponse response) {
            this.response = response;
        }

        public void complete() {
            this.isRunning = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void suspend() throws IllegalStateException {
            if (!SseUtil.shouldAsyncBlock()) throw new UnsupportedOperationException("ASYNCHRONOUS PROCESSING IS NOT SUPPORTED!");
            this.isRunning = true;
            BlockingAsyncContextDelegate blockingAsyncContextDelegate = this;
            synchronized (blockingAsyncContextDelegate) {
                while (true) {
                    if (!this.isRunning) {
                        return;
                    }
                    try {
                        this.wait(15000L);
                        ServletOutputStream outputStream = this.response.getOutputStream();
                        outputStream.write(10);
                        this.response.flushBuffer();
                        outputStream.write(10);
                        this.response.flushBuffer();
                    }
                    catch (Exception exception) {
                        try {
                            this.response.getOutputStream().close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.isRunning = false;
                    }
                }
            }
        }
    }
}

