/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;
import org.openhab.ui.cometvisu.internal.backend.beans.StateBean;

@Provider
@Produces(value={"application/json"})
public class StateBeanMessageBodyWriter
implements MessageBodyWriter<Object> {
    public long getSize(Object arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return 0L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] arg2, MediaType arg3) {
        return type == StateBean.class || genericType == StateBean.class;
    }

    public void writeTo(Object stateBean, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serialize(stateBean));
        Throwable throwable = null;
        Object var10_11 = null;
        try (DataOutputStream dos = new DataOutputStream(entityStream);){
            dos.writeUTF(sb.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String serialize(Object bean) {
        String msg = "{\"d\":{";
        if (bean instanceof StateBean) {
            StateBean stateBean = (StateBean)bean;
            msg = String.valueOf(msg) + "\"" + stateBean.name + "\":\"" + stateBean.state + "\"";
        } else if (bean instanceof List) {
            ArrayList<String> states = new ArrayList<String>();
            for (Object bo : (List)bean) {
                if (!(bo instanceof StateBean)) continue;
                StateBean stateBean = (StateBean)bo;
                states.add("\"" + stateBean.name + "\":\"" + stateBean.state + "\"");
            }
            if (states.size() > 0) {
                msg = String.valueOf(msg) + StringUtils.join(states, (String)",");
            }
        }
        msg = String.valueOf(msg) + "}}";
        return msg;
    }
}

