/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.cometvisu.internal;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.smarthome.model.sitemap.SitemapProvider;
import org.openhab.ui.cometvisu.internal.Config;
import org.openhab.ui.dashboard.DashboardTile;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class CometVisuDashboardTile
implements DashboardTile {
    private Set<SitemapProvider> sitemapProviders = new HashSet<SitemapProvider>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.add(provider);
    }

    public void removeSitemapProvider(SitemapProvider provider) {
        this.sitemapProviders.remove(provider);
    }

    public String getName() {
        return "CometVisu";
    }

    public String getUrl() {
        HashSet sitemapNames = new HashSet();
        for (SitemapProvider provider : this.sitemapProviders) {
            sitemapNames.addAll(provider.getSitemapNames());
        }
        String sitemap = "demo";
        if (sitemapNames.size() > 0) {
            sitemap = sitemapNames.contains("demo") ? "oh_demo" : "oh_" + (String)sitemapNames.iterator().next();
        }
        String path = "/";
        File root = new File(Config.cometvisuWebfolder);
        File index = new File(root, "index.html");
        if (index.exists()) {
            path = "/index.html";
        } else {
            File build = new File(root, "build");
            if (new File(build, "index.html").exists()) {
                path = "/build/index.html";
            } else {
                File source = new File(root, "source");
                if (new File(source, "index.html").exists()) {
                    path = "/source/index.html";
                } else {
                    File src = new File(root, "src");
                    if (new File(src, "index.html").exists()) {
                        path = "/src/index.html";
                    }
                }
            }
        }
        return String.valueOf(Config.cometvisuWebappAlias) + path + "?config=" + sitemap;
    }

    public String getOverlay() {
        return "html5";
    }

    public String getImageUrl() {
        return "img/cometvisu.png";
    }
}

