"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.register = register;
const language_service_1 = require("@volar/language-service");
const featureWorkers_1 = require("@volar/language-service/lib/utils/featureWorkers");
const vscode_html_languageservice_1 = require("vscode-html-languageservice");
function register(htmlLs) {
    const docForEmptyLineCompletion = vscode_html_languageservice_1.TextDocument.create('file:///foo.html', 'html', 0, '< />');
    const htmlDocForEmptyLineCompletion = htmlLs.parseHTMLDocument(docForEmptyLineCompletion);
    const posForEmptyLine = docForEmptyLineCompletion.positionAt(1);
    return async (pugDoc, pos, serviceContext, documentContext, options) => {
        const offset = pugDoc.pugTextDocument.offsetAt(pos);
        if (pugDoc.emptyLineEnds.includes(offset)) {
            const htmlComplete = htmlLs.doComplete(docForEmptyLineCompletion, posForEmptyLine, htmlDocForEmptyLineCompletion, options);
            for (const item of htmlComplete.items) {
                item.textEdit = undefined;
            }
            return htmlComplete;
        }
        for (const htmlPos of (0, featureWorkers_1.getGeneratedPositions)(pugDoc.docs, pos)) {
            const htmlComplete = documentContext
                ? await htmlLs.doComplete2(pugDoc.docs[1], htmlPos, pugDoc.htmlDocument, documentContext, options)
                : htmlLs.doComplete(pugDoc.docs[1], htmlPos, pugDoc.htmlDocument, options);
            return (0, language_service_1.transformCompletionList)(htmlComplete, htmlRange => (0, featureWorkers_1.getSourceRange)(pugDoc.docs, htmlRange), pugDoc.docs[1], serviceContext);
        }
    };
}
//# sourceMappingURL=completion.js.map