/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.markdown;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DocumentDiagnosticParams;
import org.eclipse.lsp4j.DocumentDiagnosticReport;
import org.eclipse.lsp4j.FullDocumentDiagnosticReport;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RelatedFullDocumentDiagnosticReport;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageServer;

public final class MarkdownDiagnosticsManager {
    public static final String MARKDOWN_MARKER_TYPE = "org.eclipse.wildwebdeveloper.markdown.problem";

    static {
        FileBuffers.getTextFileBufferManager().addFileBufferListener(new IFileBufferListener(){

            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
            }

            public void bufferContentReplaced(IFileBuffer buffer) {
            }

            public void bufferCreated(IFileBuffer buffer) {
            }

            public void bufferDisposed(IFileBuffer buffer) {
                IPath location = buffer.getLocation();
                if (location == null) {
                    return;
                }
                try {
                    String name;
                    IFile file;
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IResource res = root.findMember(location);
                    if (res instanceof IFile && (file = (IFile)res).exists() && ((name = file.getName().toLowerCase()).endsWith(".md") || name.endsWith(".markdown") || name.endsWith(".mdown"))) {
                        MarkdownDiagnosticsManager.clearMarkers(file);
                    }
                }
                catch (Exception ex) {
                    ILog.get().warn(ex.getMessage(), (Throwable)ex);
                }
            }

            public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            }

            public void stateChangeFailed(IFileBuffer buffer) {
            }

            public void stateChanging(IFileBuffer buffer) {
            }

            public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
            }

            public void underlyingFileDeleted(IFileBuffer buffer) {
            }

            public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
            }
        });
    }

    private static String markerKey(String message, int severity, int charStart, int charEnd) {
        return message + "|" + severity + "|" + charStart + ":" + charEnd;
    }

    private static String markerKey(IMarker marker) throws CoreException {
        String message = String.valueOf(marker.getAttribute("message"));
        int severity = marker.getAttribute("severity", -1);
        int charStart = marker.getAttribute("charStart", -1);
        int charEnd = marker.getAttribute("charEnd", -1);
        return MarkdownDiagnosticsManager.markerKey(message, severity, charStart, charEnd);
    }

    private static synchronized void applyMarkers(IFile file, List<Diagnostic> diagnostics) {
        try {
            HashMap<String, IMarker> markdownMarkers = new HashMap<String, IMarker>();
            IMarker[] iMarkerArray = file.findMarkers(MARKDOWN_MARKER_TYPE, true, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker m = iMarkerArray[n2];
                markdownMarkers.putIfAbsent(MarkdownDiagnosticsManager.markerKey(m), m);
                ++n2;
            }
            for (Diagnostic d : diagnostics) {
                IMarker target;
                String msg = d.getMessage();
                int severity = MarkdownDiagnosticsManager.toIMarkerSeverity(d.getSeverity());
                int line = d.getRange() != null ? d.getRange().getStart().getLine() + 1 : 1;
                int charStart = -1;
                int charEnd = -1;
                if (d.getRange() != null) {
                    try {
                        int[] offsets = MarkdownDiagnosticsManager.toOffsets(file, d.getRange());
                        charStart = offsets[0];
                        charEnd = offsets[1];
                    }
                    catch (Exception ignore) {
                        ILog.get().warn(ignore.getMessage(), (Throwable)ignore);
                    }
                }
                if ((target = (IMarker)markdownMarkers.remove(MarkdownDiagnosticsManager.markerKey(msg, severity, charStart, charEnd))) != null) continue;
                target = file.createMarker(MARKDOWN_MARKER_TYPE);
                target.setAttribute("message", (Object)msg);
                target.setAttribute("severity", severity);
                target.setAttribute("lineNumber", line);
                if (charStart >= 0 && charEnd >= 0) {
                    target.setAttribute("charStart", charStart);
                    target.setAttribute("charEnd", charEnd);
                    continue;
                }
                target.setAttribute("charStart", -1);
                target.setAttribute("charEnd", -1);
            }
            for (IMarker m : markdownMarkers.values()) {
                try {
                    m.delete();
                }
                catch (Exception ignore) {
                    ILog.get().warn(ignore.getMessage(), (Throwable)ignore);
                }
            }
        }
        catch (Exception ex) {
            ILog.get().warn(ex.getMessage(), (Throwable)ex);
        }
    }

    private static void clearMarkers(IFile file) throws CoreException {
        file.deleteMarkers(MARKDOWN_MARKER_TYPE, true, 0);
    }

    private static List<Diagnostic> extractDiagnostics(DocumentDiagnosticReport report) {
        if (report == null) {
            return List.of();
        }
        if (report.isLeft()) {
            RelatedFullDocumentDiagnosticReport full = (RelatedFullDocumentDiagnosticReport)report.getLeft();
            ArrayList<Diagnostic> out = new ArrayList<Diagnostic>();
            if (full.getItems() != null) {
                out.addAll(full.getItems());
            }
            if (full.getRelatedDocuments() != null) {
                for (Either rel : full.getRelatedDocuments().values()) {
                    FullDocumentDiagnosticReport rfull;
                    if (rel == null || !rel.isLeft() || (rfull = (FullDocumentDiagnosticReport)rel.getLeft()).getItems() == null) continue;
                    out.addAll(rfull.getItems());
                }
            }
            return out;
        }
        report.isRight();
        return List.of();
    }

    public static void refreshAllOpenMarkdownFiles(LanguageServer languageServer) {
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(res -> {
                if (res.getType() == 1) {
                    String name = res.getName().toLowerCase();
                    if (name.endsWith(".md") || name.endsWith(".markdown") || name.endsWith(".mdown")) {
                        MarkdownDiagnosticsManager.refreshFile((IFile)res, languageServer);
                    }
                    return false;
                }
                return true;
            });
        }
        catch (Exception ex) {
            ILog.get().warn(ex.getMessage(), (Throwable)ex);
        }
    }

    public static void refreshFile(IFile file) {
        try {
            if (file == null || !file.exists()) {
                return;
            }
            ((LanguageServers.LanguageServerProjectExecutor)LanguageServers.forProject((IProject)file.getProject()).withPreferredServer(LanguageServersRegistry.getInstance().getDefinition("org.eclipse.wildwebdeveloper.markdown"))).excludeInactive().collectAll((w, ls) -> CompletableFuture.completedFuture(ls)).thenAccept(lss -> lss.forEach(ls -> MarkdownDiagnosticsManager.refreshFile(file, ls)));
        }
        catch (Exception ex) {
            ILog.get().warn(ex.getMessage(), (Throwable)ex);
        }
    }

    private static void refreshFile(IFile file, LanguageServer languageServer) {
        try {
            if (file == null || !file.exists()) {
                return;
            }
            String uri = MarkdownDiagnosticsManager.toLspFileUri(file);
            DocumentDiagnosticParams params = new DocumentDiagnosticParams();
            params.setTextDocument(new TextDocumentIdentifier(uri));
            DocumentDiagnosticReport report = (DocumentDiagnosticReport)languageServer.getTextDocumentService().diagnostic(params).get();
            MarkdownDiagnosticsManager.applyMarkers(file, MarkdownDiagnosticsManager.extractDiagnostics(report));
        }
        catch (Exception ex) {
            ILog.get().warn(ex.getMessage(), (Throwable)ex);
        }
    }

    private static int toIMarkerSeverity(DiagnosticSeverity sev) {
        if (sev == null) {
            return 0;
        }
        return switch (sev) {
            case DiagnosticSeverity.Error -> 2;
            case DiagnosticSeverity.Warning -> 1;
            case DiagnosticSeverity.Information, DiagnosticSeverity.Hint -> 0;
            default -> throw new MatchException(null, null);
        };
    }

    private static String toLspFileUri(IFile file) {
        String s = file.getLocationURI().toString();
        if (s.startsWith("file:/") && !s.startsWith("file:///") && s.length() >= 8 && Character.isLetter(s.charAt(6)) && s.charAt(7) == ':') {
            return "file:///" + s.substring("file:/".length());
        }
        return s;
    }

    private static int[] toOffsets(IFile file, Range range) throws CoreException, BadLocationException {
        ITextFileBufferManager mgr = FileBuffers.getTextFileBufferManager();
        IPath path = file.getFullPath();
        mgr.connect(path, LocationKind.IFILE, null);
        try {
            IDocument doc;
            ITextFileBuffer buf = mgr.getTextFileBuffer(path, LocationKind.IFILE);
            IDocument iDocument = doc = buf != null ? buf.getDocument() : null;
            if (doc == null) {
                int[] nArray = new int[2];
                return nArray;
            }
            int startLine = Math.max(0, range.getStart().getLine());
            int startCol = Math.max(0, range.getStart().getCharacter());
            int endLine = Math.max(0, range.getEnd().getLine());
            int endCol = Math.max(0, range.getEnd().getCharacter());
            int start = Math.min(doc.getLength(), doc.getLineOffset(startLine) + startCol);
            int end = Math.min(doc.getLength(), doc.getLineOffset(endLine) + endCol);
            if (end < start) {
                end = start;
            }
            int[] nArray = new int[]{start, end};
            return nArray;
        }
        finally {
            mgr.disconnect(path, LocationKind.IFILE, null);
        }
    }

    private MarkdownDiagnosticsManager() {
    }
}

