"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getImportPathForFile = void 0;
function getImportPathForFile(fileName, incomingFileName, preferences) {
    const { typescript: ts, languageService, languageServiceHost } = this;
    const program = languageService.getProgram();
    const incomingFile = program?.getSourceFile(incomingFileName);
    const sourceFile = program?.getSourceFile(fileName);
    if (!program || !sourceFile || !incomingFile) {
        return;
    }
    const getModuleSpecifiersWithCacheInfo = ts.moduleSpecifiers.getModuleSpecifiersWithCacheInfo;
    const resolutionHost = ts.createModuleSpecifierResolutionHost(program, languageServiceHost);
    const moduleSpecifiers = getModuleSpecifiersWithCacheInfo(incomingFile.symbol, program.getTypeChecker(), languageServiceHost.getCompilationSettings(), sourceFile, resolutionHost, preferences);
    for (const moduleSpecifier of moduleSpecifiers.moduleSpecifiers) {
        return moduleSpecifier;
    }
}
exports.getImportPathForFile = getImportPathForFile;
//# sourceMappingURL=getImportPathForFile.js.map