"use strict";
var __getOwnPropNames = Object.getOwnPropertyNames;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/cmdline_utils.js
var require_cmdline_utils = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/cmdline_utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.generateHelpMessage = exports2.parseCommandLine = void 0;
    function findArgument(argv, argName) {
      const index = argv.indexOf(argName);
      if (index < 0 || index === argv.length - 1) {
        return;
      }
      return argv[index + 1];
    }
    function parseStringArray(argv, argName) {
      const arg = findArgument(argv, argName);
      if (!arg) {
        return [];
      }
      return arg.split(",");
    }
    function hasArgument(argv, argName) {
      return argv.includes(argName);
    }
    function parseCommandLine(argv) {
      var _a;
      return {
        help: hasArgument(argv, "--help"),
        logFile: findArgument(argv, "--logFile"),
        logVerbosity: findArgument(argv, "--logVerbosity"),
        logToConsole: hasArgument(argv, "--logToConsole"),
        ngProbeLocations: parseStringArray(argv, "--ngProbeLocations"),
        tsProbeLocations: parseStringArray(argv, "--tsProbeLocations"),
        tsdk: (_a = findArgument(argv, "--tsdk")) !== null && _a !== void 0 ? _a : null,
        includeAutomaticOptionalChainCompletions: hasArgument(argv, "--includeAutomaticOptionalChainCompletions"),
        includeCompletionsWithSnippetText: hasArgument(argv, "--includeCompletionsWithSnippetText"),
        forceStrictTemplates: hasArgument(argv, "--forceStrictTemplates"),
        disableBlockSyntax: hasArgument(argv, "--disableBlockSyntax"),
        angularCoreVersion: findArgument(argv, "--angularCoreVersion")
      };
    }
    exports2.parseCommandLine = parseCommandLine;
    function generateHelpMessage(argv) {
      return `Angular Language Service that implements the Language Server Protocol (LSP).

  Usage: ${argv[0]} ${argv[1]} [options]

  Options:
    --help: Prints help message.
    --logFile: Location to log messages. Logging to file is disabled if not provided.
    --logVerbosity: terse|normal|verbose|requestTime. See ts.server.LogLevel.
    --logToConsole: Enables logging to console via 'window/logMessage'. Defaults to false.
    --ngProbeLocations: Path of @angular/language-service. Required.
    --tsProbeLocations: Path of typescript. Required.
    --includeAutomaticOptionalChainCompletions: Shows completions on potentially undefined values that insert an optional chain call. Requires TS 3.7+ and strict null checks to be enabled.
    --includeCompletionsWithSnippetText: Enables snippet completions from Angular language server;
    --forceStrictTemplates: Forces the language service to use strictTemplates and ignore the user settings in the 'tsconfig.json'.

  Additional options supported by vscode-languageserver:
    --clientProcessId=<number>: Automatically kills the server if the client process dies.
    --node-ipc: Communicate using Node's IPC. This is the default.
    --stdio: Communicate over stdin/stdout.
    --socket=<number>: Communicate using Unix socket.
  `;
    }
    exports2.generateHelpMessage = generateHelpMessage;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/common/resolver.js
var require_resolver = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/common/resolver.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Version = exports2.resolve = void 0;
    var fs = __importStar(require("fs"));
    function resolve(packageName, location, rootPackage) {
      rootPackage = rootPackage || packageName;
      try {
        const packageJsonPath = require.resolve(`${rootPackage}/package.json`, {
          paths: [location]
        });
        const packageJson = JSON.parse(fs.readFileSync(packageJsonPath, "utf8"));
        const resolvedPath = require.resolve(packageName, {
          paths: [location]
        });
        return {
          name: packageName,
          resolvedPath,
          version: new Version(packageJson.version)
        };
      } catch (_a) {
      }
    }
    exports2.resolve = resolve;
    var Version = class {
      constructor(versionStr) {
        this.versionStr = versionStr;
        const [major, minor, patch] = Version.parseVersionStr(versionStr);
        this.major = major;
        this.minor = minor;
        this.patch = patch;
      }
      greaterThanOrEqual(other, compare = "patch") {
        if (this.major < other.major) {
          return false;
        }
        if (this.major > other.major || this.major === other.major && compare === "major") {
          return true;
        }
        if (this.minor < other.minor) {
          return false;
        }
        if (this.minor > other.minor || this.minor === other.minor && compare === "minor") {
          return true;
        }
        return this.patch >= other.patch;
      }
      toString() {
        return this.versionStr;
      }
      /**
       * Converts the specified `versionStr` to its number constituents. Invalid
       * number value is represented as negative number.
       * @param versionStr
       */
      static parseVersionStr(versionStr) {
        const [major, minor, patch] = versionStr.split(".").map(parseNonNegativeInt);
        return [
          major === void 0 ? 0 : major,
          minor === void 0 ? 0 : minor,
          patch === void 0 ? 0 : patch
        ];
      }
    };
    exports2.Version = Version;
    function parseNonNegativeInt(a) {
      const i = parseInt(
        a,
        10
        /* radix */
      );
      return isNaN(i) ? -1 : i;
    }
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/version_provider.js
var require_version_provider = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/version_provider.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveNgLangSvc = exports2.loadEsmModule = exports2.resolveTsServer = void 0;
    var fs = __importStar(require("fs"));
    var path = __importStar(require("path"));
    var resolver_1 = require_resolver();
    var MIN_TS_VERSION = "5.0";
    var MIN_NG_VERSION = "15.0";
    var TSSERVERLIB = "typescript/lib/tsserverlibrary";
    function resolveWithMinVersion(packageName, minVersionStr, probeLocations, rootPackage) {
      if (!packageName.startsWith(rootPackage)) {
        throw new Error(`${packageName} must be in the root package`);
      }
      const minVersion = new resolver_1.Version(minVersionStr);
      for (const location of probeLocations) {
        const nodeModule = (0, resolver_1.resolve)(packageName, location, rootPackage);
        if (nodeModule && nodeModule.version.greaterThanOrEqual(minVersion)) {
          return nodeModule;
        }
      }
      throw new Error(`Failed to resolve '${packageName}' with minimum version '${minVersion}' from ` + JSON.stringify(probeLocations, null, 2));
    }
    function resolveTsServer(probeLocations, tsdk) {
      if (tsdk !== null) {
        const resolvedFromTsdk = resolveTsServerFromTsdk(tsdk, probeLocations);
        const minVersion = new resolver_1.Version(MIN_TS_VERSION);
        if (resolvedFromTsdk !== void 0) {
          if (resolvedFromTsdk.version.greaterThanOrEqual(minVersion)) {
            return resolvedFromTsdk;
          } else {
            console.warn(`Ignoring TSDK version specified in the TypeScript extension options ${resolvedFromTsdk.version} because it is lower than the required TS version for the language service (${MIN_TS_VERSION}).`);
          }
        }
      }
      return resolveWithMinVersion(TSSERVERLIB, MIN_TS_VERSION, probeLocations, "typescript");
    }
    exports2.resolveTsServer = resolveTsServer;
    function resolveTsServerFromTsdk(tsdk, probeLocations) {
      if (path.isAbsolute(tsdk)) {
        probeLocations = [tsdk];
      } else {
        probeLocations = probeLocations.map((location) => path.join(location, tsdk));
      }
      for (const location of probeLocations) {
        const tsserverlib = path.join(location, "tsserverlibrary.js");
        if (!fs.existsSync(tsserverlib)) {
          continue;
        }
        const packageJson = path.resolve(tsserverlib, "../../package.json");
        if (!fs.existsSync(packageJson)) {
          continue;
        }
        try {
          const json = JSON.parse(fs.readFileSync(packageJson, "utf8"));
          return {
            name: TSSERVERLIB,
            resolvedPath: tsserverlib,
            version: new resolver_1.Version(json.version)
          };
        } catch (_a) {
          continue;
        }
      }
      return void 0;
    }
    function loadEsmModule(modulePath) {
      return new Function("modulePath", `return import(modulePath);`)(modulePath);
    }
    exports2.loadEsmModule = loadEsmModule;
    function resolveNgLangSvc(probeLocations) {
      const ngls = "@angular/language-service";
      return resolveWithMinVersion(ngls, MIN_NG_VERSION, probeLocations, ngls);
    }
    exports2.resolveNgLangSvc = resolveNgLangSvc;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/banner.js
Object.defineProperty(exports, "__esModule", { value: true });
exports.requireOverride = void 0;
var cmdline_utils_1 = require_cmdline_utils();
var version_provider_1 = require_version_provider();
var originalRequire = require;
function requireOverride(moduleName) {
  const TSSERVER = "typescript/lib/tsserverlibrary";
  if (moduleName === "typescript") {
    throw new Error(`Import '${TSSERVER}' instead of 'typescript'`);
  }
  if (moduleName === TSSERVER) {
    const { tsProbeLocations, tsdk } = (0, cmdline_utils_1.parseCommandLine)(process.argv);
    moduleName = (0, version_provider_1.resolveTsServer)(tsProbeLocations, tsdk).resolvedPath;
  }
  return originalRequire(moduleName);
}
exports.requireOverride = requireOverride;
requireOverride.resolve = originalRequire.resolve;
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
require = requireOverride;

"use strict";
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __pow = Math.pow;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/cmdline_utils.js
var require_cmdline_utils = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/cmdline_utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.generateHelpMessage = exports2.parseCommandLine = void 0;
    function findArgument(argv, argName) {
      const index = argv.indexOf(argName);
      if (index < 0 || index === argv.length - 1) {
        return;
      }
      return argv[index + 1];
    }
    function parseStringArray(argv, argName) {
      const arg = findArgument(argv, argName);
      if (!arg) {
        return [];
      }
      return arg.split(",");
    }
    function hasArgument(argv, argName) {
      return argv.includes(argName);
    }
    function parseCommandLine(argv) {
      var _a;
      return {
        help: hasArgument(argv, "--help"),
        logFile: findArgument(argv, "--logFile"),
        logVerbosity: findArgument(argv, "--logVerbosity"),
        logToConsole: hasArgument(argv, "--logToConsole"),
        ngProbeLocations: parseStringArray(argv, "--ngProbeLocations"),
        tsProbeLocations: parseStringArray(argv, "--tsProbeLocations"),
        tsdk: (_a = findArgument(argv, "--tsdk")) !== null && _a !== void 0 ? _a : null,
        includeAutomaticOptionalChainCompletions: hasArgument(argv, "--includeAutomaticOptionalChainCompletions"),
        includeCompletionsWithSnippetText: hasArgument(argv, "--includeCompletionsWithSnippetText"),
        forceStrictTemplates: hasArgument(argv, "--forceStrictTemplates"),
        disableBlockSyntax: hasArgument(argv, "--disableBlockSyntax"),
        angularCoreVersion: findArgument(argv, "--angularCoreVersion")
      };
    }
    exports2.parseCommandLine = parseCommandLine;
    function generateHelpMessage(argv) {
      return `Angular Language Service that implements the Language Server Protocol (LSP).

  Usage: ${argv[0]} ${argv[1]} [options]

  Options:
    --help: Prints help message.
    --logFile: Location to log messages. Logging to file is disabled if not provided.
    --logVerbosity: terse|normal|verbose|requestTime. See ts.server.LogLevel.
    --logToConsole: Enables logging to console via 'window/logMessage'. Defaults to false.
    --ngProbeLocations: Path of @angular/language-service. Required.
    --tsProbeLocations: Path of typescript. Required.
    --includeAutomaticOptionalChainCompletions: Shows completions on potentially undefined values that insert an optional chain call. Requires TS 3.7+ and strict null checks to be enabled.
    --includeCompletionsWithSnippetText: Enables snippet completions from Angular language server;
    --forceStrictTemplates: Forces the language service to use strictTemplates and ignore the user settings in the 'tsconfig.json'.

  Additional options supported by vscode-languageserver:
    --clientProcessId=<number>: Automatically kills the server if the client process dies.
    --node-ipc: Communicate using Node's IPC. This is the default.
    --stdio: Communicate over stdin/stdout.
    --socket=<number>: Communicate using Unix socket.
  `;
    }
    exports2.generateHelpMessage = generateHelpMessage;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/logger.js
var require_logger = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/logger.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createLogger = void 0;
    var fs = __importStar(require("fs"));
    var path = __importStar(require("path"));
    var ts = __importStar(require("typescript/lib/tsserverlibrary"));
    function createLogger(options2) {
      let logLevel;
      switch (options2.logVerbosity) {
        case "requestTime":
          logLevel = ts.server.LogLevel.requestTime;
          break;
        case "verbose":
          logLevel = ts.server.LogLevel.verbose;
          break;
        case "normal":
          logLevel = ts.server.LogLevel.normal;
          break;
        case "terse":
        default:
          logLevel = ts.server.LogLevel.terse;
          break;
      }
      return new Logger(logLevel, options2.logFile);
    }
    exports2.createLogger = createLogger;
    function noop(_) {
    }
    function nowString() {
      const d = /* @__PURE__ */ new Date();
      return `${d.getHours()}:${d.getMinutes()}:${d.getSeconds()}.${d.getMilliseconds()}`;
    }
    var Logger = class {
      constructor(level, logFilename) {
        this.level = level;
        this.logFilename = logFilename;
        this.seq = 0;
        this.inGroup = false;
        this.firstInGroup = true;
        this.fd = -1;
        if (logFilename) {
          try {
            const dir = path.dirname(logFilename);
            if (!fs.existsSync(dir)) {
              fs.mkdirSync(dir);
            }
            this.fd = fs.openSync(logFilename, "w");
          } catch (_a) {
          }
        }
      }
      close() {
        if (this.loggingEnabled()) {
          fs.close(this.fd, noop);
        }
      }
      getLogFileName() {
        return this.logFilename;
      }
      perftrc(s) {
        this.msg(s, ts.server.Msg.Perf);
      }
      info(s) {
        this.msg(s, ts.server.Msg.Info);
      }
      startGroup() {
        this.inGroup = true;
        this.firstInGroup = true;
      }
      endGroup() {
        this.inGroup = false;
      }
      loggingEnabled() {
        return this.fd >= 0;
      }
      hasLevel(level) {
        return this.loggingEnabled() && this.level >= level;
      }
      msg(s, type = ts.server.Msg.Err) {
        if (!this.loggingEnabled()) {
          return;
        }
        let prefix = "";
        if (!this.inGroup || this.firstInGroup) {
          this.firstInGroup = false;
          prefix = `${type} ${this.seq}`.padEnd(10) + `[${nowString()}] `;
        }
        const entry = prefix + s + "\n";
        fs.writeSync(this.fd, entry);
        if (!this.inGroup) {
          this.seq++;
        }
      }
    };
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/server_host.js
var require_server_host = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/server_host.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ServerHost = void 0;
    var ts = __importStar(require("typescript/lib/tsserverlibrary"));
    var NOOP_WATCHER = {
      close() {
      }
    };
    var ServerHost = class {
      constructor(isG3) {
        this.isG3 = isG3;
        this.args = ts.sys.args;
        this.newLine = ts.sys.newLine;
        this.useCaseSensitiveFileNames = ts.sys.useCaseSensitiveFileNames;
      }
      write(s) {
        ts.sys.write(s);
      }
      writeOutputIsTTY() {
        return ts.sys.writeOutputIsTTY();
      }
      readFile(path, encoding) {
        return ts.sys.readFile(path, encoding);
      }
      getFileSize(path) {
        return ts.sys.getFileSize(path);
      }
      writeFile(path, data, writeByteOrderMark) {
        return ts.sys.writeFile(path, data, writeByteOrderMark);
      }
      /**
       * @pollingInterval - this parameter is used in polling-based watchers and
       * ignored in watchers that use native OS file watching
       */
      watchFile(path, callback, pollingInterval, options2) {
        return ts.sys.watchFile(path, callback, pollingInterval, options2);
      }
      watchDirectory(path, callback, recursive, options2) {
        if (this.isG3 && path.startsWith("/google/src")) {
          return NOOP_WATCHER;
        }
        return ts.sys.watchDirectory(path, callback, recursive, options2);
      }
      resolvePath(path) {
        return ts.sys.resolvePath(path);
      }
      fileExists(path) {
        if (path.endsWith(".ngtypecheck.ts")) {
          return true;
        }
        return ts.sys.fileExists(path);
      }
      directoryExists(path) {
        return ts.sys.directoryExists(path);
      }
      createDirectory(path) {
        return ts.sys.createDirectory(path);
      }
      getExecutingFilePath() {
        return ts.sys.getExecutingFilePath();
      }
      getCurrentDirectory() {
        return ts.sys.getCurrentDirectory();
      }
      getDirectories(path) {
        return ts.sys.getDirectories(path);
      }
      readDirectory(path, extensions, exclude, include, depth) {
        return ts.sys.readDirectory(path, extensions, exclude, include, depth);
      }
      getModifiedTime(path) {
        return ts.sys.getModifiedTime(path);
      }
      setModifiedTime(path, time) {
        return ts.sys.setModifiedTime(path, time);
      }
      deleteFile(path) {
        return ts.sys.deleteFile(path);
      }
      /**
       * A good implementation is node.js' `crypto.createHash`.
       * (https://nodejs.org/api/crypto.html#crypto_crypto_createhash_algorithm)
       */
      createHash(data) {
        return ts.sys.createHash(data);
      }
      /**
       * This must be cryptographically secure. Only implement this method using
       * `crypto.createHash("sha256")`.
       */
      createSHA256Hash(data) {
        return ts.sys.createSHA256Hash(data);
      }
      getMemoryUsage() {
        return ts.sys.getMemoryUsage();
      }
      exit(exitCode) {
        return ts.sys.exit(exitCode);
      }
      realpath(path) {
        return ts.sys.realpath(path);
      }
      setTimeout(callback, ms, ...args) {
        return ts.sys.setTimeout(callback, ms, ...args);
      }
      clearTimeout(timeoutId) {
        return ts.sys.clearTimeout(timeoutId);
      }
      clearScreen() {
        return ts.sys.clearScreen();
      }
      base64decode(input) {
        return ts.sys.base64decode(input);
      }
      base64encode(input) {
        return ts.sys.base64encode(input);
      }
      setImmediate(callback, ...args) {
        return setImmediate(callback, ...args);
      }
      clearImmediate(timeoutId) {
        return clearImmediate(timeoutId);
      }
      require(initialPath, moduleName) {
        if (moduleName !== "@angular/language-service") {
          return {
            module: void 0,
            error: new Error(`Angular server will not load plugin '${moduleName}'.`)
          };
        }
        try {
          const modulePath = require.resolve(moduleName, {
            paths: [initialPath]
          });
          return {
            module: require(modulePath),
            error: void 0
          };
        } catch (e) {
          return {
            module: void 0,
            error: e
          };
        }
      }
    };
    exports2.ServerHost = ServerHost;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/@angular+language-service@registry.npmjs.org+@angular+language-service@17.3.6/node_modules/@angular/language-service/api_bundle.js
var require_api_bundle = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/@angular+language-service@registry.npmjs.org+@angular+language-service@17.3.6/node_modules/@angular/language-service/api_bundle.js"(exports2, module2) {
    var __defProp2 = Object.defineProperty;
    var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp2 = Object.prototype.hasOwnProperty;
    var __export = (target, all) => {
      for (var name in all)
        __defProp2(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp2.call(to, key) && key !== except)
            __defProp2(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS = (mod) => __copyProps(__defProp2({}, "__esModule", { value: true }), mod);
    var api_exports = {};
    __export(api_exports, {
      isNgLanguageService: () => isNgLanguageService
    });
    module2.exports = __toCommonJS(api_exports);
    function isNgLanguageService(ls) {
      return "getTcb" in ls;
    }
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/common/notifications.js
var require_notifications = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/common/notifications.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.OpenOutputChannel = exports2.SuggestStrictMode = exports2.ProjectLanguageService = exports2.ProjectLoadingFinish = exports2.ProjectLoadingStart = void 0;
    var vscode_jsonrpc_1 = require("vscode-jsonrpc");
    exports2.ProjectLoadingStart = new vscode_jsonrpc_1.NotificationType0("angular/projectLoadingStart");
    exports2.ProjectLoadingFinish = new vscode_jsonrpc_1.NotificationType0("angular/projectLoadingFinish");
    exports2.ProjectLanguageService = new vscode_jsonrpc_1.NotificationType("angular/projectLanguageService");
    exports2.SuggestStrictMode = new vscode_jsonrpc_1.NotificationType("angular/suggestStrictMode");
    exports2.OpenOutputChannel = new vscode_jsonrpc_1.NotificationType("angular/OpenOutputChannel");
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-types@registry.npmjs.org+vscode-languageserver-types@3.16.0/node_modules/vscode-languageserver-types/lib/umd/main.js
var require_main = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-types@registry.npmjs.org+vscode-languageserver-types@3.16.0/node_modules/vscode-languageserver-types/lib/umd/main.js"(exports2, module2) {
    (function(factory) {
      if (typeof module2 === "object" && typeof module2.exports === "object") {
        var v = factory(require, exports2);
        if (v !== void 0)
          module2.exports = v;
      } else if (typeof define === "function" && define.amd) {
        define(["require", "exports"], factory);
      }
    })(function(require2, exports3) {
      "use strict";
      Object.defineProperty(exports3, "__esModule", { value: true });
      exports3.TextDocument = exports3.EOL = exports3.SelectionRange = exports3.DocumentLink = exports3.FormattingOptions = exports3.CodeLens = exports3.CodeAction = exports3.CodeActionContext = exports3.CodeActionKind = exports3.DocumentSymbol = exports3.SymbolInformation = exports3.SymbolTag = exports3.SymbolKind = exports3.DocumentHighlight = exports3.DocumentHighlightKind = exports3.SignatureInformation = exports3.ParameterInformation = exports3.Hover = exports3.MarkedString = exports3.CompletionList = exports3.CompletionItem = exports3.InsertTextMode = exports3.InsertReplaceEdit = exports3.CompletionItemTag = exports3.InsertTextFormat = exports3.CompletionItemKind = exports3.MarkupContent = exports3.MarkupKind = exports3.TextDocumentItem = exports3.OptionalVersionedTextDocumentIdentifier = exports3.VersionedTextDocumentIdentifier = exports3.TextDocumentIdentifier = exports3.WorkspaceChange = exports3.WorkspaceEdit = exports3.DeleteFile = exports3.RenameFile = exports3.CreateFile = exports3.TextDocumentEdit = exports3.AnnotatedTextEdit = exports3.ChangeAnnotationIdentifier = exports3.ChangeAnnotation = exports3.TextEdit = exports3.Command = exports3.Diagnostic = exports3.CodeDescription = exports3.DiagnosticTag = exports3.DiagnosticSeverity = exports3.DiagnosticRelatedInformation = exports3.FoldingRange = exports3.FoldingRangeKind = exports3.ColorPresentation = exports3.ColorInformation = exports3.Color = exports3.LocationLink = exports3.Location = exports3.Range = exports3.Position = exports3.uinteger = exports3.integer = void 0;
      var integer;
      (function(integer2) {
        integer2.MIN_VALUE = -2147483648;
        integer2.MAX_VALUE = 2147483647;
      })(integer = exports3.integer || (exports3.integer = {}));
      var uinteger;
      (function(uinteger2) {
        uinteger2.MIN_VALUE = 0;
        uinteger2.MAX_VALUE = 2147483647;
      })(uinteger = exports3.uinteger || (exports3.uinteger = {}));
      var Position;
      (function(Position2) {
        function create(line, character) {
          if (line === Number.MAX_VALUE) {
            line = uinteger.MAX_VALUE;
          }
          if (character === Number.MAX_VALUE) {
            character = uinteger.MAX_VALUE;
          }
          return { line, character };
        }
        Position2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Is.uinteger(candidate.line) && Is.uinteger(candidate.character);
        }
        Position2.is = is;
      })(Position = exports3.Position || (exports3.Position = {}));
      var Range;
      (function(Range2) {
        function create(one, two, three, four) {
          if (Is.uinteger(one) && Is.uinteger(two) && Is.uinteger(three) && Is.uinteger(four)) {
            return { start: Position.create(one, two), end: Position.create(three, four) };
          } else if (Position.is(one) && Position.is(two)) {
            return { start: one, end: two };
          } else {
            throw new Error("Range#create called with invalid arguments[" + one + ", " + two + ", " + three + ", " + four + "]");
          }
        }
        Range2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Position.is(candidate.start) && Position.is(candidate.end);
        }
        Range2.is = is;
      })(Range = exports3.Range || (exports3.Range = {}));
      var Location;
      (function(Location2) {
        function create(uri, range) {
          return { uri, range };
        }
        Location2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Range.is(candidate.range) && (Is.string(candidate.uri) || Is.undefined(candidate.uri));
        }
        Location2.is = is;
      })(Location = exports3.Location || (exports3.Location = {}));
      var LocationLink;
      (function(LocationLink2) {
        function create(targetUri, targetRange, targetSelectionRange, originSelectionRange) {
          return { targetUri, targetRange, targetSelectionRange, originSelectionRange };
        }
        LocationLink2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Range.is(candidate.targetRange) && Is.string(candidate.targetUri) && (Range.is(candidate.targetSelectionRange) || Is.undefined(candidate.targetSelectionRange)) && (Range.is(candidate.originSelectionRange) || Is.undefined(candidate.originSelectionRange));
        }
        LocationLink2.is = is;
      })(LocationLink = exports3.LocationLink || (exports3.LocationLink = {}));
      var Color;
      (function(Color2) {
        function create(red, green, blue, alpha) {
          return {
            red,
            green,
            blue,
            alpha
          };
        }
        Color2.create = create;
        function is(value) {
          var candidate = value;
          return Is.numberRange(candidate.red, 0, 1) && Is.numberRange(candidate.green, 0, 1) && Is.numberRange(candidate.blue, 0, 1) && Is.numberRange(candidate.alpha, 0, 1);
        }
        Color2.is = is;
      })(Color = exports3.Color || (exports3.Color = {}));
      var ColorInformation;
      (function(ColorInformation2) {
        function create(range, color) {
          return {
            range,
            color
          };
        }
        ColorInformation2.create = create;
        function is(value) {
          var candidate = value;
          return Range.is(candidate.range) && Color.is(candidate.color);
        }
        ColorInformation2.is = is;
      })(ColorInformation = exports3.ColorInformation || (exports3.ColorInformation = {}));
      var ColorPresentation;
      (function(ColorPresentation2) {
        function create(label, textEdit, additionalTextEdits) {
          return {
            label,
            textEdit,
            additionalTextEdits
          };
        }
        ColorPresentation2.create = create;
        function is(value) {
          var candidate = value;
          return Is.string(candidate.label) && (Is.undefined(candidate.textEdit) || TextEdit.is(candidate)) && (Is.undefined(candidate.additionalTextEdits) || Is.typedArray(candidate.additionalTextEdits, TextEdit.is));
        }
        ColorPresentation2.is = is;
      })(ColorPresentation = exports3.ColorPresentation || (exports3.ColorPresentation = {}));
      var FoldingRangeKind;
      (function(FoldingRangeKind2) {
        FoldingRangeKind2["Comment"] = "comment";
        FoldingRangeKind2["Imports"] = "imports";
        FoldingRangeKind2["Region"] = "region";
      })(FoldingRangeKind = exports3.FoldingRangeKind || (exports3.FoldingRangeKind = {}));
      var FoldingRange;
      (function(FoldingRange2) {
        function create(startLine, endLine, startCharacter, endCharacter, kind) {
          var result = {
            startLine,
            endLine
          };
          if (Is.defined(startCharacter)) {
            result.startCharacter = startCharacter;
          }
          if (Is.defined(endCharacter)) {
            result.endCharacter = endCharacter;
          }
          if (Is.defined(kind)) {
            result.kind = kind;
          }
          return result;
        }
        FoldingRange2.create = create;
        function is(value) {
          var candidate = value;
          return Is.uinteger(candidate.startLine) && Is.uinteger(candidate.startLine) && (Is.undefined(candidate.startCharacter) || Is.uinteger(candidate.startCharacter)) && (Is.undefined(candidate.endCharacter) || Is.uinteger(candidate.endCharacter)) && (Is.undefined(candidate.kind) || Is.string(candidate.kind));
        }
        FoldingRange2.is = is;
      })(FoldingRange = exports3.FoldingRange || (exports3.FoldingRange = {}));
      var DiagnosticRelatedInformation;
      (function(DiagnosticRelatedInformation2) {
        function create(location, message) {
          return {
            location,
            message
          };
        }
        DiagnosticRelatedInformation2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Location.is(candidate.location) && Is.string(candidate.message);
        }
        DiagnosticRelatedInformation2.is = is;
      })(DiagnosticRelatedInformation = exports3.DiagnosticRelatedInformation || (exports3.DiagnosticRelatedInformation = {}));
      var DiagnosticSeverity;
      (function(DiagnosticSeverity2) {
        DiagnosticSeverity2.Error = 1;
        DiagnosticSeverity2.Warning = 2;
        DiagnosticSeverity2.Information = 3;
        DiagnosticSeverity2.Hint = 4;
      })(DiagnosticSeverity = exports3.DiagnosticSeverity || (exports3.DiagnosticSeverity = {}));
      var DiagnosticTag;
      (function(DiagnosticTag2) {
        DiagnosticTag2.Unnecessary = 1;
        DiagnosticTag2.Deprecated = 2;
      })(DiagnosticTag = exports3.DiagnosticTag || (exports3.DiagnosticTag = {}));
      var CodeDescription;
      (function(CodeDescription2) {
        function is(value) {
          var candidate = value;
          return candidate !== void 0 && candidate !== null && Is.string(candidate.href);
        }
        CodeDescription2.is = is;
      })(CodeDescription = exports3.CodeDescription || (exports3.CodeDescription = {}));
      var Diagnostic;
      (function(Diagnostic2) {
        function create(range, message, severity, code, source, relatedInformation) {
          var result = { range, message };
          if (Is.defined(severity)) {
            result.severity = severity;
          }
          if (Is.defined(code)) {
            result.code = code;
          }
          if (Is.defined(source)) {
            result.source = source;
          }
          if (Is.defined(relatedInformation)) {
            result.relatedInformation = relatedInformation;
          }
          return result;
        }
        Diagnostic2.create = create;
        function is(value) {
          var _a;
          var candidate = value;
          return Is.defined(candidate) && Range.is(candidate.range) && Is.string(candidate.message) && (Is.number(candidate.severity) || Is.undefined(candidate.severity)) && (Is.integer(candidate.code) || Is.string(candidate.code) || Is.undefined(candidate.code)) && (Is.undefined(candidate.codeDescription) || Is.string((_a = candidate.codeDescription) === null || _a === void 0 ? void 0 : _a.href)) && (Is.string(candidate.source) || Is.undefined(candidate.source)) && (Is.undefined(candidate.relatedInformation) || Is.typedArray(candidate.relatedInformation, DiagnosticRelatedInformation.is));
        }
        Diagnostic2.is = is;
      })(Diagnostic = exports3.Diagnostic || (exports3.Diagnostic = {}));
      var Command;
      (function(Command2) {
        function create(title, command) {
          var args = [];
          for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
          }
          var result = { title, command };
          if (Is.defined(args) && args.length > 0) {
            result.arguments = args;
          }
          return result;
        }
        Command2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.title) && Is.string(candidate.command);
        }
        Command2.is = is;
      })(Command = exports3.Command || (exports3.Command = {}));
      var TextEdit;
      (function(TextEdit2) {
        function replace(range, newText) {
          return { range, newText };
        }
        TextEdit2.replace = replace;
        function insert(position, newText) {
          return { range: { start: position, end: position }, newText };
        }
        TextEdit2.insert = insert;
        function del(range) {
          return { range, newText: "" };
        }
        TextEdit2.del = del;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Is.string(candidate.newText) && Range.is(candidate.range);
        }
        TextEdit2.is = is;
      })(TextEdit = exports3.TextEdit || (exports3.TextEdit = {}));
      var ChangeAnnotation;
      (function(ChangeAnnotation2) {
        function create(label, needsConfirmation, description) {
          var result = { label };
          if (needsConfirmation !== void 0) {
            result.needsConfirmation = needsConfirmation;
          }
          if (description !== void 0) {
            result.description = description;
          }
          return result;
        }
        ChangeAnnotation2.create = create;
        function is(value) {
          var candidate = value;
          return candidate !== void 0 && Is.objectLiteral(candidate) && Is.string(candidate.label) && (Is.boolean(candidate.needsConfirmation) || candidate.needsConfirmation === void 0) && (Is.string(candidate.description) || candidate.description === void 0);
        }
        ChangeAnnotation2.is = is;
      })(ChangeAnnotation = exports3.ChangeAnnotation || (exports3.ChangeAnnotation = {}));
      var ChangeAnnotationIdentifier;
      (function(ChangeAnnotationIdentifier2) {
        function is(value) {
          var candidate = value;
          return typeof candidate === "string";
        }
        ChangeAnnotationIdentifier2.is = is;
      })(ChangeAnnotationIdentifier = exports3.ChangeAnnotationIdentifier || (exports3.ChangeAnnotationIdentifier = {}));
      var AnnotatedTextEdit;
      (function(AnnotatedTextEdit2) {
        function replace(range, newText, annotation) {
          return { range, newText, annotationId: annotation };
        }
        AnnotatedTextEdit2.replace = replace;
        function insert(position, newText, annotation) {
          return { range: { start: position, end: position }, newText, annotationId: annotation };
        }
        AnnotatedTextEdit2.insert = insert;
        function del(range, annotation) {
          return { range, newText: "", annotationId: annotation };
        }
        AnnotatedTextEdit2.del = del;
        function is(value) {
          var candidate = value;
          return TextEdit.is(candidate) && (ChangeAnnotation.is(candidate.annotationId) || ChangeAnnotationIdentifier.is(candidate.annotationId));
        }
        AnnotatedTextEdit2.is = is;
      })(AnnotatedTextEdit = exports3.AnnotatedTextEdit || (exports3.AnnotatedTextEdit = {}));
      var TextDocumentEdit;
      (function(TextDocumentEdit2) {
        function create(textDocument, edits) {
          return { textDocument, edits };
        }
        TextDocumentEdit2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && OptionalVersionedTextDocumentIdentifier.is(candidate.textDocument) && Array.isArray(candidate.edits);
        }
        TextDocumentEdit2.is = is;
      })(TextDocumentEdit = exports3.TextDocumentEdit || (exports3.TextDocumentEdit = {}));
      var CreateFile;
      (function(CreateFile2) {
        function create(uri, options2, annotation) {
          var result = {
            kind: "create",
            uri
          };
          if (options2 !== void 0 && (options2.overwrite !== void 0 || options2.ignoreIfExists !== void 0)) {
            result.options = options2;
          }
          if (annotation !== void 0) {
            result.annotationId = annotation;
          }
          return result;
        }
        CreateFile2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && candidate.kind === "create" && Is.string(candidate.uri) && (candidate.options === void 0 || (candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
        }
        CreateFile2.is = is;
      })(CreateFile = exports3.CreateFile || (exports3.CreateFile = {}));
      var RenameFile;
      (function(RenameFile2) {
        function create(oldUri, newUri, options2, annotation) {
          var result = {
            kind: "rename",
            oldUri,
            newUri
          };
          if (options2 !== void 0 && (options2.overwrite !== void 0 || options2.ignoreIfExists !== void 0)) {
            result.options = options2;
          }
          if (annotation !== void 0) {
            result.annotationId = annotation;
          }
          return result;
        }
        RenameFile2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && candidate.kind === "rename" && Is.string(candidate.oldUri) && Is.string(candidate.newUri) && (candidate.options === void 0 || (candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
        }
        RenameFile2.is = is;
      })(RenameFile = exports3.RenameFile || (exports3.RenameFile = {}));
      var DeleteFile;
      (function(DeleteFile2) {
        function create(uri, options2, annotation) {
          var result = {
            kind: "delete",
            uri
          };
          if (options2 !== void 0 && (options2.recursive !== void 0 || options2.ignoreIfNotExists !== void 0)) {
            result.options = options2;
          }
          if (annotation !== void 0) {
            result.annotationId = annotation;
          }
          return result;
        }
        DeleteFile2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && candidate.kind === "delete" && Is.string(candidate.uri) && (candidate.options === void 0 || (candidate.options.recursive === void 0 || Is.boolean(candidate.options.recursive)) && (candidate.options.ignoreIfNotExists === void 0 || Is.boolean(candidate.options.ignoreIfNotExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
        }
        DeleteFile2.is = is;
      })(DeleteFile = exports3.DeleteFile || (exports3.DeleteFile = {}));
      var WorkspaceEdit;
      (function(WorkspaceEdit2) {
        function is(value) {
          var candidate = value;
          return candidate && (candidate.changes !== void 0 || candidate.documentChanges !== void 0) && (candidate.documentChanges === void 0 || candidate.documentChanges.every(function(change) {
            if (Is.string(change.kind)) {
              return CreateFile.is(change) || RenameFile.is(change) || DeleteFile.is(change);
            } else {
              return TextDocumentEdit.is(change);
            }
          }));
        }
        WorkspaceEdit2.is = is;
      })(WorkspaceEdit = exports3.WorkspaceEdit || (exports3.WorkspaceEdit = {}));
      var TextEditChangeImpl = (
        /** @class */
        function() {
          function TextEditChangeImpl2(edits, changeAnnotations) {
            this.edits = edits;
            this.changeAnnotations = changeAnnotations;
          }
          TextEditChangeImpl2.prototype.insert = function(position, newText, annotation) {
            var edit;
            var id;
            if (annotation === void 0) {
              edit = TextEdit.insert(position, newText);
            } else if (ChangeAnnotationIdentifier.is(annotation)) {
              id = annotation;
              edit = AnnotatedTextEdit.insert(position, newText, annotation);
            } else {
              this.assertChangeAnnotations(this.changeAnnotations);
              id = this.changeAnnotations.manage(annotation);
              edit = AnnotatedTextEdit.insert(position, newText, id);
            }
            this.edits.push(edit);
            if (id !== void 0) {
              return id;
            }
          };
          TextEditChangeImpl2.prototype.replace = function(range, newText, annotation) {
            var edit;
            var id;
            if (annotation === void 0) {
              edit = TextEdit.replace(range, newText);
            } else if (ChangeAnnotationIdentifier.is(annotation)) {
              id = annotation;
              edit = AnnotatedTextEdit.replace(range, newText, annotation);
            } else {
              this.assertChangeAnnotations(this.changeAnnotations);
              id = this.changeAnnotations.manage(annotation);
              edit = AnnotatedTextEdit.replace(range, newText, id);
            }
            this.edits.push(edit);
            if (id !== void 0) {
              return id;
            }
          };
          TextEditChangeImpl2.prototype.delete = function(range, annotation) {
            var edit;
            var id;
            if (annotation === void 0) {
              edit = TextEdit.del(range);
            } else if (ChangeAnnotationIdentifier.is(annotation)) {
              id = annotation;
              edit = AnnotatedTextEdit.del(range, annotation);
            } else {
              this.assertChangeAnnotations(this.changeAnnotations);
              id = this.changeAnnotations.manage(annotation);
              edit = AnnotatedTextEdit.del(range, id);
            }
            this.edits.push(edit);
            if (id !== void 0) {
              return id;
            }
          };
          TextEditChangeImpl2.prototype.add = function(edit) {
            this.edits.push(edit);
          };
          TextEditChangeImpl2.prototype.all = function() {
            return this.edits;
          };
          TextEditChangeImpl2.prototype.clear = function() {
            this.edits.splice(0, this.edits.length);
          };
          TextEditChangeImpl2.prototype.assertChangeAnnotations = function(value) {
            if (value === void 0) {
              throw new Error("Text edit change is not configured to manage change annotations.");
            }
          };
          return TextEditChangeImpl2;
        }()
      );
      var ChangeAnnotations = (
        /** @class */
        function() {
          function ChangeAnnotations2(annotations) {
            this._annotations = annotations === void 0 ? /* @__PURE__ */ Object.create(null) : annotations;
            this._counter = 0;
            this._size = 0;
          }
          ChangeAnnotations2.prototype.all = function() {
            return this._annotations;
          };
          Object.defineProperty(ChangeAnnotations2.prototype, "size", {
            get: function() {
              return this._size;
            },
            enumerable: false,
            configurable: true
          });
          ChangeAnnotations2.prototype.manage = function(idOrAnnotation, annotation) {
            var id;
            if (ChangeAnnotationIdentifier.is(idOrAnnotation)) {
              id = idOrAnnotation;
            } else {
              id = this.nextId();
              annotation = idOrAnnotation;
            }
            if (this._annotations[id] !== void 0) {
              throw new Error("Id " + id + " is already in use.");
            }
            if (annotation === void 0) {
              throw new Error("No annotation provided for id " + id);
            }
            this._annotations[id] = annotation;
            this._size++;
            return id;
          };
          ChangeAnnotations2.prototype.nextId = function() {
            this._counter++;
            return this._counter.toString();
          };
          return ChangeAnnotations2;
        }()
      );
      var WorkspaceChange = (
        /** @class */
        function() {
          function WorkspaceChange2(workspaceEdit) {
            var _this = this;
            this._textEditChanges = /* @__PURE__ */ Object.create(null);
            if (workspaceEdit !== void 0) {
              this._workspaceEdit = workspaceEdit;
              if (workspaceEdit.documentChanges) {
                this._changeAnnotations = new ChangeAnnotations(workspaceEdit.changeAnnotations);
                workspaceEdit.changeAnnotations = this._changeAnnotations.all();
                workspaceEdit.documentChanges.forEach(function(change) {
                  if (TextDocumentEdit.is(change)) {
                    var textEditChange = new TextEditChangeImpl(change.edits, _this._changeAnnotations);
                    _this._textEditChanges[change.textDocument.uri] = textEditChange;
                  }
                });
              } else if (workspaceEdit.changes) {
                Object.keys(workspaceEdit.changes).forEach(function(key) {
                  var textEditChange = new TextEditChangeImpl(workspaceEdit.changes[key]);
                  _this._textEditChanges[key] = textEditChange;
                });
              }
            } else {
              this._workspaceEdit = {};
            }
          }
          Object.defineProperty(WorkspaceChange2.prototype, "edit", {
            /**
             * Returns the underlying [WorkspaceEdit](#WorkspaceEdit) literal
             * use to be returned from a workspace edit operation like rename.
             */
            get: function() {
              this.initDocumentChanges();
              if (this._changeAnnotations !== void 0) {
                if (this._changeAnnotations.size === 0) {
                  this._workspaceEdit.changeAnnotations = void 0;
                } else {
                  this._workspaceEdit.changeAnnotations = this._changeAnnotations.all();
                }
              }
              return this._workspaceEdit;
            },
            enumerable: false,
            configurable: true
          });
          WorkspaceChange2.prototype.getTextEditChange = function(key) {
            if (OptionalVersionedTextDocumentIdentifier.is(key)) {
              this.initDocumentChanges();
              if (this._workspaceEdit.documentChanges === void 0) {
                throw new Error("Workspace edit is not configured for document changes.");
              }
              var textDocument = { uri: key.uri, version: key.version };
              var result = this._textEditChanges[textDocument.uri];
              if (!result) {
                var edits = [];
                var textDocumentEdit = {
                  textDocument,
                  edits
                };
                this._workspaceEdit.documentChanges.push(textDocumentEdit);
                result = new TextEditChangeImpl(edits, this._changeAnnotations);
                this._textEditChanges[textDocument.uri] = result;
              }
              return result;
            } else {
              this.initChanges();
              if (this._workspaceEdit.changes === void 0) {
                throw new Error("Workspace edit is not configured for normal text edit changes.");
              }
              var result = this._textEditChanges[key];
              if (!result) {
                var edits = [];
                this._workspaceEdit.changes[key] = edits;
                result = new TextEditChangeImpl(edits);
                this._textEditChanges[key] = result;
              }
              return result;
            }
          };
          WorkspaceChange2.prototype.initDocumentChanges = function() {
            if (this._workspaceEdit.documentChanges === void 0 && this._workspaceEdit.changes === void 0) {
              this._changeAnnotations = new ChangeAnnotations();
              this._workspaceEdit.documentChanges = [];
              this._workspaceEdit.changeAnnotations = this._changeAnnotations.all();
            }
          };
          WorkspaceChange2.prototype.initChanges = function() {
            if (this._workspaceEdit.documentChanges === void 0 && this._workspaceEdit.changes === void 0) {
              this._workspaceEdit.changes = /* @__PURE__ */ Object.create(null);
            }
          };
          WorkspaceChange2.prototype.createFile = function(uri, optionsOrAnnotation, options2) {
            this.initDocumentChanges();
            if (this._workspaceEdit.documentChanges === void 0) {
              throw new Error("Workspace edit is not configured for document changes.");
            }
            var annotation;
            if (ChangeAnnotation.is(optionsOrAnnotation) || ChangeAnnotationIdentifier.is(optionsOrAnnotation)) {
              annotation = optionsOrAnnotation;
            } else {
              options2 = optionsOrAnnotation;
            }
            var operation;
            var id;
            if (annotation === void 0) {
              operation = CreateFile.create(uri, options2);
            } else {
              id = ChangeAnnotationIdentifier.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
              operation = CreateFile.create(uri, options2, id);
            }
            this._workspaceEdit.documentChanges.push(operation);
            if (id !== void 0) {
              return id;
            }
          };
          WorkspaceChange2.prototype.renameFile = function(oldUri, newUri, optionsOrAnnotation, options2) {
            this.initDocumentChanges();
            if (this._workspaceEdit.documentChanges === void 0) {
              throw new Error("Workspace edit is not configured for document changes.");
            }
            var annotation;
            if (ChangeAnnotation.is(optionsOrAnnotation) || ChangeAnnotationIdentifier.is(optionsOrAnnotation)) {
              annotation = optionsOrAnnotation;
            } else {
              options2 = optionsOrAnnotation;
            }
            var operation;
            var id;
            if (annotation === void 0) {
              operation = RenameFile.create(oldUri, newUri, options2);
            } else {
              id = ChangeAnnotationIdentifier.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
              operation = RenameFile.create(oldUri, newUri, options2, id);
            }
            this._workspaceEdit.documentChanges.push(operation);
            if (id !== void 0) {
              return id;
            }
          };
          WorkspaceChange2.prototype.deleteFile = function(uri, optionsOrAnnotation, options2) {
            this.initDocumentChanges();
            if (this._workspaceEdit.documentChanges === void 0) {
              throw new Error("Workspace edit is not configured for document changes.");
            }
            var annotation;
            if (ChangeAnnotation.is(optionsOrAnnotation) || ChangeAnnotationIdentifier.is(optionsOrAnnotation)) {
              annotation = optionsOrAnnotation;
            } else {
              options2 = optionsOrAnnotation;
            }
            var operation;
            var id;
            if (annotation === void 0) {
              operation = DeleteFile.create(uri, options2);
            } else {
              id = ChangeAnnotationIdentifier.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
              operation = DeleteFile.create(uri, options2, id);
            }
            this._workspaceEdit.documentChanges.push(operation);
            if (id !== void 0) {
              return id;
            }
          };
          return WorkspaceChange2;
        }()
      );
      exports3.WorkspaceChange = WorkspaceChange;
      var TextDocumentIdentifier;
      (function(TextDocumentIdentifier2) {
        function create(uri) {
          return { uri };
        }
        TextDocumentIdentifier2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri);
        }
        TextDocumentIdentifier2.is = is;
      })(TextDocumentIdentifier = exports3.TextDocumentIdentifier || (exports3.TextDocumentIdentifier = {}));
      var VersionedTextDocumentIdentifier;
      (function(VersionedTextDocumentIdentifier2) {
        function create(uri, version) {
          return { uri, version };
        }
        VersionedTextDocumentIdentifier2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri) && Is.integer(candidate.version);
        }
        VersionedTextDocumentIdentifier2.is = is;
      })(VersionedTextDocumentIdentifier = exports3.VersionedTextDocumentIdentifier || (exports3.VersionedTextDocumentIdentifier = {}));
      var OptionalVersionedTextDocumentIdentifier;
      (function(OptionalVersionedTextDocumentIdentifier2) {
        function create(uri, version) {
          return { uri, version };
        }
        OptionalVersionedTextDocumentIdentifier2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri) && (candidate.version === null || Is.integer(candidate.version));
        }
        OptionalVersionedTextDocumentIdentifier2.is = is;
      })(OptionalVersionedTextDocumentIdentifier = exports3.OptionalVersionedTextDocumentIdentifier || (exports3.OptionalVersionedTextDocumentIdentifier = {}));
      var TextDocumentItem;
      (function(TextDocumentItem2) {
        function create(uri, languageId, version, text) {
          return { uri, languageId, version, text };
        }
        TextDocumentItem2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri) && Is.string(candidate.languageId) && Is.integer(candidate.version) && Is.string(candidate.text);
        }
        TextDocumentItem2.is = is;
      })(TextDocumentItem = exports3.TextDocumentItem || (exports3.TextDocumentItem = {}));
      var MarkupKind;
      (function(MarkupKind2) {
        MarkupKind2.PlainText = "plaintext";
        MarkupKind2.Markdown = "markdown";
      })(MarkupKind = exports3.MarkupKind || (exports3.MarkupKind = {}));
      (function(MarkupKind2) {
        function is(value) {
          var candidate = value;
          return candidate === MarkupKind2.PlainText || candidate === MarkupKind2.Markdown;
        }
        MarkupKind2.is = is;
      })(MarkupKind = exports3.MarkupKind || (exports3.MarkupKind = {}));
      var MarkupContent;
      (function(MarkupContent2) {
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(value) && MarkupKind.is(candidate.kind) && Is.string(candidate.value);
        }
        MarkupContent2.is = is;
      })(MarkupContent = exports3.MarkupContent || (exports3.MarkupContent = {}));
      var CompletionItemKind;
      (function(CompletionItemKind2) {
        CompletionItemKind2.Text = 1;
        CompletionItemKind2.Method = 2;
        CompletionItemKind2.Function = 3;
        CompletionItemKind2.Constructor = 4;
        CompletionItemKind2.Field = 5;
        CompletionItemKind2.Variable = 6;
        CompletionItemKind2.Class = 7;
        CompletionItemKind2.Interface = 8;
        CompletionItemKind2.Module = 9;
        CompletionItemKind2.Property = 10;
        CompletionItemKind2.Unit = 11;
        CompletionItemKind2.Value = 12;
        CompletionItemKind2.Enum = 13;
        CompletionItemKind2.Keyword = 14;
        CompletionItemKind2.Snippet = 15;
        CompletionItemKind2.Color = 16;
        CompletionItemKind2.File = 17;
        CompletionItemKind2.Reference = 18;
        CompletionItemKind2.Folder = 19;
        CompletionItemKind2.EnumMember = 20;
        CompletionItemKind2.Constant = 21;
        CompletionItemKind2.Struct = 22;
        CompletionItemKind2.Event = 23;
        CompletionItemKind2.Operator = 24;
        CompletionItemKind2.TypeParameter = 25;
      })(CompletionItemKind = exports3.CompletionItemKind || (exports3.CompletionItemKind = {}));
      var InsertTextFormat;
      (function(InsertTextFormat2) {
        InsertTextFormat2.PlainText = 1;
        InsertTextFormat2.Snippet = 2;
      })(InsertTextFormat = exports3.InsertTextFormat || (exports3.InsertTextFormat = {}));
      var CompletionItemTag;
      (function(CompletionItemTag2) {
        CompletionItemTag2.Deprecated = 1;
      })(CompletionItemTag = exports3.CompletionItemTag || (exports3.CompletionItemTag = {}));
      var InsertReplaceEdit;
      (function(InsertReplaceEdit2) {
        function create(newText, insert, replace) {
          return { newText, insert, replace };
        }
        InsertReplaceEdit2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && Is.string(candidate.newText) && Range.is(candidate.insert) && Range.is(candidate.replace);
        }
        InsertReplaceEdit2.is = is;
      })(InsertReplaceEdit = exports3.InsertReplaceEdit || (exports3.InsertReplaceEdit = {}));
      var InsertTextMode;
      (function(InsertTextMode2) {
        InsertTextMode2.asIs = 1;
        InsertTextMode2.adjustIndentation = 2;
      })(InsertTextMode = exports3.InsertTextMode || (exports3.InsertTextMode = {}));
      var CompletionItem;
      (function(CompletionItem2) {
        function create(label) {
          return { label };
        }
        CompletionItem2.create = create;
      })(CompletionItem = exports3.CompletionItem || (exports3.CompletionItem = {}));
      var CompletionList;
      (function(CompletionList2) {
        function create(items, isIncomplete) {
          return { items: items ? items : [], isIncomplete: !!isIncomplete };
        }
        CompletionList2.create = create;
      })(CompletionList = exports3.CompletionList || (exports3.CompletionList = {}));
      var MarkedString;
      (function(MarkedString2) {
        function fromPlainText(plainText) {
          return plainText.replace(/[\\`*_{}[\]()#+\-.!]/g, "\\$&");
        }
        MarkedString2.fromPlainText = fromPlainText;
        function is(value) {
          var candidate = value;
          return Is.string(candidate) || Is.objectLiteral(candidate) && Is.string(candidate.language) && Is.string(candidate.value);
        }
        MarkedString2.is = is;
      })(MarkedString = exports3.MarkedString || (exports3.MarkedString = {}));
      var Hover;
      (function(Hover2) {
        function is(value) {
          var candidate = value;
          return !!candidate && Is.objectLiteral(candidate) && (MarkupContent.is(candidate.contents) || MarkedString.is(candidate.contents) || Is.typedArray(candidate.contents, MarkedString.is)) && (value.range === void 0 || Range.is(value.range));
        }
        Hover2.is = is;
      })(Hover = exports3.Hover || (exports3.Hover = {}));
      var ParameterInformation;
      (function(ParameterInformation2) {
        function create(label, documentation) {
          return documentation ? { label, documentation } : { label };
        }
        ParameterInformation2.create = create;
      })(ParameterInformation = exports3.ParameterInformation || (exports3.ParameterInformation = {}));
      var SignatureInformation;
      (function(SignatureInformation2) {
        function create(label, documentation) {
          var parameters = [];
          for (var _i = 2; _i < arguments.length; _i++) {
            parameters[_i - 2] = arguments[_i];
          }
          var result = { label };
          if (Is.defined(documentation)) {
            result.documentation = documentation;
          }
          if (Is.defined(parameters)) {
            result.parameters = parameters;
          } else {
            result.parameters = [];
          }
          return result;
        }
        SignatureInformation2.create = create;
      })(SignatureInformation = exports3.SignatureInformation || (exports3.SignatureInformation = {}));
      var DocumentHighlightKind;
      (function(DocumentHighlightKind2) {
        DocumentHighlightKind2.Text = 1;
        DocumentHighlightKind2.Read = 2;
        DocumentHighlightKind2.Write = 3;
      })(DocumentHighlightKind = exports3.DocumentHighlightKind || (exports3.DocumentHighlightKind = {}));
      var DocumentHighlight;
      (function(DocumentHighlight2) {
        function create(range, kind) {
          var result = { range };
          if (Is.number(kind)) {
            result.kind = kind;
          }
          return result;
        }
        DocumentHighlight2.create = create;
      })(DocumentHighlight = exports3.DocumentHighlight || (exports3.DocumentHighlight = {}));
      var SymbolKind;
      (function(SymbolKind2) {
        SymbolKind2.File = 1;
        SymbolKind2.Module = 2;
        SymbolKind2.Namespace = 3;
        SymbolKind2.Package = 4;
        SymbolKind2.Class = 5;
        SymbolKind2.Method = 6;
        SymbolKind2.Property = 7;
        SymbolKind2.Field = 8;
        SymbolKind2.Constructor = 9;
        SymbolKind2.Enum = 10;
        SymbolKind2.Interface = 11;
        SymbolKind2.Function = 12;
        SymbolKind2.Variable = 13;
        SymbolKind2.Constant = 14;
        SymbolKind2.String = 15;
        SymbolKind2.Number = 16;
        SymbolKind2.Boolean = 17;
        SymbolKind2.Array = 18;
        SymbolKind2.Object = 19;
        SymbolKind2.Key = 20;
        SymbolKind2.Null = 21;
        SymbolKind2.EnumMember = 22;
        SymbolKind2.Struct = 23;
        SymbolKind2.Event = 24;
        SymbolKind2.Operator = 25;
        SymbolKind2.TypeParameter = 26;
      })(SymbolKind = exports3.SymbolKind || (exports3.SymbolKind = {}));
      var SymbolTag;
      (function(SymbolTag2) {
        SymbolTag2.Deprecated = 1;
      })(SymbolTag = exports3.SymbolTag || (exports3.SymbolTag = {}));
      var SymbolInformation;
      (function(SymbolInformation2) {
        function create(name, kind, range, uri, containerName) {
          var result = {
            name,
            kind,
            location: { uri, range }
          };
          if (containerName) {
            result.containerName = containerName;
          }
          return result;
        }
        SymbolInformation2.create = create;
      })(SymbolInformation = exports3.SymbolInformation || (exports3.SymbolInformation = {}));
      var DocumentSymbol;
      (function(DocumentSymbol2) {
        function create(name, detail, kind, range, selectionRange, children) {
          var result = {
            name,
            detail,
            kind,
            range,
            selectionRange
          };
          if (children !== void 0) {
            result.children = children;
          }
          return result;
        }
        DocumentSymbol2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && Is.string(candidate.name) && Is.number(candidate.kind) && Range.is(candidate.range) && Range.is(candidate.selectionRange) && (candidate.detail === void 0 || Is.string(candidate.detail)) && (candidate.deprecated === void 0 || Is.boolean(candidate.deprecated)) && (candidate.children === void 0 || Array.isArray(candidate.children)) && (candidate.tags === void 0 || Array.isArray(candidate.tags));
        }
        DocumentSymbol2.is = is;
      })(DocumentSymbol = exports3.DocumentSymbol || (exports3.DocumentSymbol = {}));
      var CodeActionKind;
      (function(CodeActionKind2) {
        CodeActionKind2.Empty = "";
        CodeActionKind2.QuickFix = "quickfix";
        CodeActionKind2.Refactor = "refactor";
        CodeActionKind2.RefactorExtract = "refactor.extract";
        CodeActionKind2.RefactorInline = "refactor.inline";
        CodeActionKind2.RefactorRewrite = "refactor.rewrite";
        CodeActionKind2.Source = "source";
        CodeActionKind2.SourceOrganizeImports = "source.organizeImports";
        CodeActionKind2.SourceFixAll = "source.fixAll";
      })(CodeActionKind = exports3.CodeActionKind || (exports3.CodeActionKind = {}));
      var CodeActionContext;
      (function(CodeActionContext2) {
        function create(diagnostics, only) {
          var result = { diagnostics };
          if (only !== void 0 && only !== null) {
            result.only = only;
          }
          return result;
        }
        CodeActionContext2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.typedArray(candidate.diagnostics, Diagnostic.is) && (candidate.only === void 0 || Is.typedArray(candidate.only, Is.string));
        }
        CodeActionContext2.is = is;
      })(CodeActionContext = exports3.CodeActionContext || (exports3.CodeActionContext = {}));
      var CodeAction;
      (function(CodeAction2) {
        function create(title, kindOrCommandOrEdit, kind) {
          var result = { title };
          var checkKind = true;
          if (typeof kindOrCommandOrEdit === "string") {
            checkKind = false;
            result.kind = kindOrCommandOrEdit;
          } else if (Command.is(kindOrCommandOrEdit)) {
            result.command = kindOrCommandOrEdit;
          } else {
            result.edit = kindOrCommandOrEdit;
          }
          if (checkKind && kind !== void 0) {
            result.kind = kind;
          }
          return result;
        }
        CodeAction2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && Is.string(candidate.title) && (candidate.diagnostics === void 0 || Is.typedArray(candidate.diagnostics, Diagnostic.is)) && (candidate.kind === void 0 || Is.string(candidate.kind)) && (candidate.edit !== void 0 || candidate.command !== void 0) && (candidate.command === void 0 || Command.is(candidate.command)) && (candidate.isPreferred === void 0 || Is.boolean(candidate.isPreferred)) && (candidate.edit === void 0 || WorkspaceEdit.is(candidate.edit));
        }
        CodeAction2.is = is;
      })(CodeAction = exports3.CodeAction || (exports3.CodeAction = {}));
      var CodeLens;
      (function(CodeLens2) {
        function create(range, data) {
          var result = { range };
          if (Is.defined(data)) {
            result.data = data;
          }
          return result;
        }
        CodeLens2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.command) || Command.is(candidate.command));
        }
        CodeLens2.is = is;
      })(CodeLens = exports3.CodeLens || (exports3.CodeLens = {}));
      var FormattingOptions;
      (function(FormattingOptions2) {
        function create(tabSize, insertSpaces) {
          return { tabSize, insertSpaces };
        }
        FormattingOptions2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.uinteger(candidate.tabSize) && Is.boolean(candidate.insertSpaces);
        }
        FormattingOptions2.is = is;
      })(FormattingOptions = exports3.FormattingOptions || (exports3.FormattingOptions = {}));
      var DocumentLink;
      (function(DocumentLink2) {
        function create(range, target, data) {
          return { range, target, data };
        }
        DocumentLink2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.target) || Is.string(candidate.target));
        }
        DocumentLink2.is = is;
      })(DocumentLink = exports3.DocumentLink || (exports3.DocumentLink = {}));
      var SelectionRange;
      (function(SelectionRange2) {
        function create(range, parent) {
          return { range, parent };
        }
        SelectionRange2.create = create;
        function is(value) {
          var candidate = value;
          return candidate !== void 0 && Range.is(candidate.range) && (candidate.parent === void 0 || SelectionRange2.is(candidate.parent));
        }
        SelectionRange2.is = is;
      })(SelectionRange = exports3.SelectionRange || (exports3.SelectionRange = {}));
      exports3.EOL = ["\n", "\r\n", "\r"];
      var TextDocument;
      (function(TextDocument2) {
        function create(uri, languageId, version, content) {
          return new FullTextDocument(uri, languageId, version, content);
        }
        TextDocument2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri) && (Is.undefined(candidate.languageId) || Is.string(candidate.languageId)) && Is.uinteger(candidate.lineCount) && Is.func(candidate.getText) && Is.func(candidate.positionAt) && Is.func(candidate.offsetAt) ? true : false;
        }
        TextDocument2.is = is;
        function applyEdits(document, edits) {
          var text = document.getText();
          var sortedEdits = mergeSort(edits, function(a, b) {
            var diff = a.range.start.line - b.range.start.line;
            if (diff === 0) {
              return a.range.start.character - b.range.start.character;
            }
            return diff;
          });
          var lastModifiedOffset = text.length;
          for (var i = sortedEdits.length - 1; i >= 0; i--) {
            var e = sortedEdits[i];
            var startOffset = document.offsetAt(e.range.start);
            var endOffset = document.offsetAt(e.range.end);
            if (endOffset <= lastModifiedOffset) {
              text = text.substring(0, startOffset) + e.newText + text.substring(endOffset, text.length);
            } else {
              throw new Error("Overlapping edit");
            }
            lastModifiedOffset = startOffset;
          }
          return text;
        }
        TextDocument2.applyEdits = applyEdits;
        function mergeSort(data, compare) {
          if (data.length <= 1) {
            return data;
          }
          var p = data.length / 2 | 0;
          var left = data.slice(0, p);
          var right = data.slice(p);
          mergeSort(left, compare);
          mergeSort(right, compare);
          var leftIdx = 0;
          var rightIdx = 0;
          var i = 0;
          while (leftIdx < left.length && rightIdx < right.length) {
            var ret = compare(left[leftIdx], right[rightIdx]);
            if (ret <= 0) {
              data[i++] = left[leftIdx++];
            } else {
              data[i++] = right[rightIdx++];
            }
          }
          while (leftIdx < left.length) {
            data[i++] = left[leftIdx++];
          }
          while (rightIdx < right.length) {
            data[i++] = right[rightIdx++];
          }
          return data;
        }
      })(TextDocument = exports3.TextDocument || (exports3.TextDocument = {}));
      var FullTextDocument = (
        /** @class */
        function() {
          function FullTextDocument2(uri, languageId, version, content) {
            this._uri = uri;
            this._languageId = languageId;
            this._version = version;
            this._content = content;
            this._lineOffsets = void 0;
          }
          Object.defineProperty(FullTextDocument2.prototype, "uri", {
            get: function() {
              return this._uri;
            },
            enumerable: false,
            configurable: true
          });
          Object.defineProperty(FullTextDocument2.prototype, "languageId", {
            get: function() {
              return this._languageId;
            },
            enumerable: false,
            configurable: true
          });
          Object.defineProperty(FullTextDocument2.prototype, "version", {
            get: function() {
              return this._version;
            },
            enumerable: false,
            configurable: true
          });
          FullTextDocument2.prototype.getText = function(range) {
            if (range) {
              var start = this.offsetAt(range.start);
              var end = this.offsetAt(range.end);
              return this._content.substring(start, end);
            }
            return this._content;
          };
          FullTextDocument2.prototype.update = function(event, version) {
            this._content = event.text;
            this._version = version;
            this._lineOffsets = void 0;
          };
          FullTextDocument2.prototype.getLineOffsets = function() {
            if (this._lineOffsets === void 0) {
              var lineOffsets = [];
              var text = this._content;
              var isLineStart = true;
              for (var i = 0; i < text.length; i++) {
                if (isLineStart) {
                  lineOffsets.push(i);
                  isLineStart = false;
                }
                var ch = text.charAt(i);
                isLineStart = ch === "\r" || ch === "\n";
                if (ch === "\r" && i + 1 < text.length && text.charAt(i + 1) === "\n") {
                  i++;
                }
              }
              if (isLineStart && text.length > 0) {
                lineOffsets.push(text.length);
              }
              this._lineOffsets = lineOffsets;
            }
            return this._lineOffsets;
          };
          FullTextDocument2.prototype.positionAt = function(offset) {
            offset = Math.max(Math.min(offset, this._content.length), 0);
            var lineOffsets = this.getLineOffsets();
            var low = 0, high = lineOffsets.length;
            if (high === 0) {
              return Position.create(0, offset);
            }
            while (low < high) {
              var mid = Math.floor((low + high) / 2);
              if (lineOffsets[mid] > offset) {
                high = mid;
              } else {
                low = mid + 1;
              }
            }
            var line = low - 1;
            return Position.create(line, offset - lineOffsets[line]);
          };
          FullTextDocument2.prototype.offsetAt = function(position) {
            var lineOffsets = this.getLineOffsets();
            if (position.line >= lineOffsets.length) {
              return this._content.length;
            } else if (position.line < 0) {
              return 0;
            }
            var lineOffset = lineOffsets[position.line];
            var nextLineOffset = position.line + 1 < lineOffsets.length ? lineOffsets[position.line + 1] : this._content.length;
            return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
          };
          Object.defineProperty(FullTextDocument2.prototype, "lineCount", {
            get: function() {
              return this.getLineOffsets().length;
            },
            enumerable: false,
            configurable: true
          });
          return FullTextDocument2;
        }()
      );
      var Is;
      (function(Is2) {
        var toString = Object.prototype.toString;
        function defined(value) {
          return typeof value !== "undefined";
        }
        Is2.defined = defined;
        function undefined2(value) {
          return typeof value === "undefined";
        }
        Is2.undefined = undefined2;
        function boolean(value) {
          return value === true || value === false;
        }
        Is2.boolean = boolean;
        function string(value) {
          return toString.call(value) === "[object String]";
        }
        Is2.string = string;
        function number(value) {
          return toString.call(value) === "[object Number]";
        }
        Is2.number = number;
        function numberRange(value, min, max) {
          return toString.call(value) === "[object Number]" && min <= value && value <= max;
        }
        Is2.numberRange = numberRange;
        function integer2(value) {
          return toString.call(value) === "[object Number]" && -2147483648 <= value && value <= 2147483647;
        }
        Is2.integer = integer2;
        function uinteger2(value) {
          return toString.call(value) === "[object Number]" && 0 <= value && value <= 2147483647;
        }
        Is2.uinteger = uinteger2;
        function func(value) {
          return toString.call(value) === "[object Function]";
        }
        Is2.func = func;
        function objectLiteral(value) {
          return value !== null && typeof value === "object";
        }
        Is2.objectLiteral = objectLiteral;
        function typedArray(value, check) {
          return Array.isArray(value) && value.every(check);
        }
        Is2.typedArray = typedArray;
      })(Is || (Is = {}));
    });
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/messages.js
var require_messages = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/messages.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ProtocolNotificationType = exports2.ProtocolNotificationType0 = exports2.ProtocolRequestType = exports2.ProtocolRequestType0 = exports2.RegistrationType = void 0;
    var vscode_jsonrpc_1 = require("vscode-jsonrpc");
    var RegistrationType = class {
      constructor(method) {
        this.method = method;
      }
    };
    exports2.RegistrationType = RegistrationType;
    var ProtocolRequestType0 = class extends vscode_jsonrpc_1.RequestType0 {
      constructor(method) {
        super(method);
      }
    };
    exports2.ProtocolRequestType0 = ProtocolRequestType0;
    var ProtocolRequestType = class extends vscode_jsonrpc_1.RequestType {
      constructor(method) {
        super(method, vscode_jsonrpc_1.ParameterStructures.byName);
      }
    };
    exports2.ProtocolRequestType = ProtocolRequestType;
    var ProtocolNotificationType0 = class extends vscode_jsonrpc_1.NotificationType0 {
      constructor(method) {
        super(method);
      }
    };
    exports2.ProtocolNotificationType0 = ProtocolNotificationType0;
    var ProtocolNotificationType = class extends vscode_jsonrpc_1.NotificationType {
      constructor(method) {
        super(method, vscode_jsonrpc_1.ParameterStructures.byName);
      }
    };
    exports2.ProtocolNotificationType = ProtocolNotificationType;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/utils/is.js
var require_is = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/utils/is.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.objectLiteral = exports2.typedArray = exports2.stringArray = exports2.array = exports2.func = exports2.error = exports2.number = exports2.string = exports2.boolean = void 0;
    function boolean(value) {
      return value === true || value === false;
    }
    exports2.boolean = boolean;
    function string(value) {
      return typeof value === "string" || value instanceof String;
    }
    exports2.string = string;
    function number(value) {
      return typeof value === "number" || value instanceof Number;
    }
    exports2.number = number;
    function error(value) {
      return value instanceof Error;
    }
    exports2.error = error;
    function func(value) {
      return typeof value === "function";
    }
    exports2.func = func;
    function array(value) {
      return Array.isArray(value);
    }
    exports2.array = array;
    function stringArray(value) {
      return array(value) && value.every((elem) => string(elem));
    }
    exports2.stringArray = stringArray;
    function typedArray(value, check) {
      return Array.isArray(value) && value.every(check);
    }
    exports2.typedArray = typedArray;
    function objectLiteral(value) {
      return value !== null && typeof value === "object";
    }
    exports2.objectLiteral = objectLiteral;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.implementation.js
var require_protocol_implementation = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.implementation.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ImplementationRequest = void 0;
    var messages_1 = require_messages();
    var ImplementationRequest;
    (function(ImplementationRequest2) {
      ImplementationRequest2.method = "textDocument/implementation";
      ImplementationRequest2.type = new messages_1.ProtocolRequestType(ImplementationRequest2.method);
    })(ImplementationRequest = exports2.ImplementationRequest || (exports2.ImplementationRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.typeDefinition.js
var require_protocol_typeDefinition = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.typeDefinition.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TypeDefinitionRequest = void 0;
    var messages_1 = require_messages();
    var TypeDefinitionRequest;
    (function(TypeDefinitionRequest2) {
      TypeDefinitionRequest2.method = "textDocument/typeDefinition";
      TypeDefinitionRequest2.type = new messages_1.ProtocolRequestType(TypeDefinitionRequest2.method);
    })(TypeDefinitionRequest = exports2.TypeDefinitionRequest || (exports2.TypeDefinitionRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.workspaceFolders.js
var require_protocol_workspaceFolders = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.workspaceFolders.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DidChangeWorkspaceFoldersNotification = exports2.WorkspaceFoldersRequest = void 0;
    var messages_1 = require_messages();
    var WorkspaceFoldersRequest;
    (function(WorkspaceFoldersRequest2) {
      WorkspaceFoldersRequest2.type = new messages_1.ProtocolRequestType0("workspace/workspaceFolders");
    })(WorkspaceFoldersRequest = exports2.WorkspaceFoldersRequest || (exports2.WorkspaceFoldersRequest = {}));
    var DidChangeWorkspaceFoldersNotification;
    (function(DidChangeWorkspaceFoldersNotification2) {
      DidChangeWorkspaceFoldersNotification2.type = new messages_1.ProtocolNotificationType("workspace/didChangeWorkspaceFolders");
    })(DidChangeWorkspaceFoldersNotification = exports2.DidChangeWorkspaceFoldersNotification || (exports2.DidChangeWorkspaceFoldersNotification = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.configuration.js
var require_protocol_configuration = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.configuration.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ConfigurationRequest = void 0;
    var messages_1 = require_messages();
    var ConfigurationRequest;
    (function(ConfigurationRequest2) {
      ConfigurationRequest2.type = new messages_1.ProtocolRequestType("workspace/configuration");
    })(ConfigurationRequest = exports2.ConfigurationRequest || (exports2.ConfigurationRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.colorProvider.js
var require_protocol_colorProvider = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.colorProvider.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ColorPresentationRequest = exports2.DocumentColorRequest = void 0;
    var messages_1 = require_messages();
    var DocumentColorRequest;
    (function(DocumentColorRequest2) {
      DocumentColorRequest2.method = "textDocument/documentColor";
      DocumentColorRequest2.type = new messages_1.ProtocolRequestType(DocumentColorRequest2.method);
    })(DocumentColorRequest = exports2.DocumentColorRequest || (exports2.DocumentColorRequest = {}));
    var ColorPresentationRequest;
    (function(ColorPresentationRequest2) {
      ColorPresentationRequest2.type = new messages_1.ProtocolRequestType("textDocument/colorPresentation");
    })(ColorPresentationRequest = exports2.ColorPresentationRequest || (exports2.ColorPresentationRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.foldingRange.js
var require_protocol_foldingRange = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.foldingRange.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FoldingRangeRequest = exports2.FoldingRangeKind = void 0;
    var messages_1 = require_messages();
    var FoldingRangeKind;
    (function(FoldingRangeKind2) {
      FoldingRangeKind2["Comment"] = "comment";
      FoldingRangeKind2["Imports"] = "imports";
      FoldingRangeKind2["Region"] = "region";
    })(FoldingRangeKind = exports2.FoldingRangeKind || (exports2.FoldingRangeKind = {}));
    var FoldingRangeRequest;
    (function(FoldingRangeRequest2) {
      FoldingRangeRequest2.method = "textDocument/foldingRange";
      FoldingRangeRequest2.type = new messages_1.ProtocolRequestType(FoldingRangeRequest2.method);
    })(FoldingRangeRequest = exports2.FoldingRangeRequest || (exports2.FoldingRangeRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.declaration.js
var require_protocol_declaration = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.declaration.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DeclarationRequest = void 0;
    var messages_1 = require_messages();
    var DeclarationRequest;
    (function(DeclarationRequest2) {
      DeclarationRequest2.method = "textDocument/declaration";
      DeclarationRequest2.type = new messages_1.ProtocolRequestType(DeclarationRequest2.method);
    })(DeclarationRequest = exports2.DeclarationRequest || (exports2.DeclarationRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.selectionRange.js
var require_protocol_selectionRange = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.selectionRange.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SelectionRangeRequest = void 0;
    var messages_1 = require_messages();
    var SelectionRangeRequest;
    (function(SelectionRangeRequest2) {
      SelectionRangeRequest2.method = "textDocument/selectionRange";
      SelectionRangeRequest2.type = new messages_1.ProtocolRequestType(SelectionRangeRequest2.method);
    })(SelectionRangeRequest = exports2.SelectionRangeRequest || (exports2.SelectionRangeRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.progress.js
var require_protocol_progress = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.progress.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.WorkDoneProgressCancelNotification = exports2.WorkDoneProgressCreateRequest = exports2.WorkDoneProgress = void 0;
    var vscode_jsonrpc_1 = require("vscode-jsonrpc");
    var messages_1 = require_messages();
    var WorkDoneProgress;
    (function(WorkDoneProgress2) {
      WorkDoneProgress2.type = new vscode_jsonrpc_1.ProgressType();
      function is(value) {
        return value === WorkDoneProgress2.type;
      }
      WorkDoneProgress2.is = is;
    })(WorkDoneProgress = exports2.WorkDoneProgress || (exports2.WorkDoneProgress = {}));
    var WorkDoneProgressCreateRequest;
    (function(WorkDoneProgressCreateRequest2) {
      WorkDoneProgressCreateRequest2.type = new messages_1.ProtocolRequestType("window/workDoneProgress/create");
    })(WorkDoneProgressCreateRequest = exports2.WorkDoneProgressCreateRequest || (exports2.WorkDoneProgressCreateRequest = {}));
    var WorkDoneProgressCancelNotification;
    (function(WorkDoneProgressCancelNotification2) {
      WorkDoneProgressCancelNotification2.type = new messages_1.ProtocolNotificationType("window/workDoneProgress/cancel");
    })(WorkDoneProgressCancelNotification = exports2.WorkDoneProgressCancelNotification || (exports2.WorkDoneProgressCancelNotification = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.callHierarchy.js
var require_protocol_callHierarchy = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.callHierarchy.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CallHierarchyOutgoingCallsRequest = exports2.CallHierarchyIncomingCallsRequest = exports2.CallHierarchyPrepareRequest = void 0;
    var messages_1 = require_messages();
    var CallHierarchyPrepareRequest;
    (function(CallHierarchyPrepareRequest2) {
      CallHierarchyPrepareRequest2.method = "textDocument/prepareCallHierarchy";
      CallHierarchyPrepareRequest2.type = new messages_1.ProtocolRequestType(CallHierarchyPrepareRequest2.method);
    })(CallHierarchyPrepareRequest = exports2.CallHierarchyPrepareRequest || (exports2.CallHierarchyPrepareRequest = {}));
    var CallHierarchyIncomingCallsRequest;
    (function(CallHierarchyIncomingCallsRequest2) {
      CallHierarchyIncomingCallsRequest2.method = "callHierarchy/incomingCalls";
      CallHierarchyIncomingCallsRequest2.type = new messages_1.ProtocolRequestType(CallHierarchyIncomingCallsRequest2.method);
    })(CallHierarchyIncomingCallsRequest = exports2.CallHierarchyIncomingCallsRequest || (exports2.CallHierarchyIncomingCallsRequest = {}));
    var CallHierarchyOutgoingCallsRequest;
    (function(CallHierarchyOutgoingCallsRequest2) {
      CallHierarchyOutgoingCallsRequest2.method = "callHierarchy/outgoingCalls";
      CallHierarchyOutgoingCallsRequest2.type = new messages_1.ProtocolRequestType(CallHierarchyOutgoingCallsRequest2.method);
    })(CallHierarchyOutgoingCallsRequest = exports2.CallHierarchyOutgoingCallsRequest || (exports2.CallHierarchyOutgoingCallsRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.semanticTokens.js
var require_protocol_semanticTokens = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.semanticTokens.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SemanticTokensRefreshRequest = exports2.SemanticTokensRangeRequest = exports2.SemanticTokensDeltaRequest = exports2.SemanticTokensRequest = exports2.SemanticTokensRegistrationType = exports2.TokenFormat = exports2.SemanticTokens = exports2.SemanticTokenModifiers = exports2.SemanticTokenTypes = void 0;
    var messages_1 = require_messages();
    var SemanticTokenTypes;
    (function(SemanticTokenTypes2) {
      SemanticTokenTypes2["namespace"] = "namespace";
      SemanticTokenTypes2["type"] = "type";
      SemanticTokenTypes2["class"] = "class";
      SemanticTokenTypes2["enum"] = "enum";
      SemanticTokenTypes2["interface"] = "interface";
      SemanticTokenTypes2["struct"] = "struct";
      SemanticTokenTypes2["typeParameter"] = "typeParameter";
      SemanticTokenTypes2["parameter"] = "parameter";
      SemanticTokenTypes2["variable"] = "variable";
      SemanticTokenTypes2["property"] = "property";
      SemanticTokenTypes2["enumMember"] = "enumMember";
      SemanticTokenTypes2["event"] = "event";
      SemanticTokenTypes2["function"] = "function";
      SemanticTokenTypes2["method"] = "method";
      SemanticTokenTypes2["macro"] = "macro";
      SemanticTokenTypes2["keyword"] = "keyword";
      SemanticTokenTypes2["modifier"] = "modifier";
      SemanticTokenTypes2["comment"] = "comment";
      SemanticTokenTypes2["string"] = "string";
      SemanticTokenTypes2["number"] = "number";
      SemanticTokenTypes2["regexp"] = "regexp";
      SemanticTokenTypes2["operator"] = "operator";
    })(SemanticTokenTypes = exports2.SemanticTokenTypes || (exports2.SemanticTokenTypes = {}));
    var SemanticTokenModifiers;
    (function(SemanticTokenModifiers2) {
      SemanticTokenModifiers2["declaration"] = "declaration";
      SemanticTokenModifiers2["definition"] = "definition";
      SemanticTokenModifiers2["readonly"] = "readonly";
      SemanticTokenModifiers2["static"] = "static";
      SemanticTokenModifiers2["deprecated"] = "deprecated";
      SemanticTokenModifiers2["abstract"] = "abstract";
      SemanticTokenModifiers2["async"] = "async";
      SemanticTokenModifiers2["modification"] = "modification";
      SemanticTokenModifiers2["documentation"] = "documentation";
      SemanticTokenModifiers2["defaultLibrary"] = "defaultLibrary";
    })(SemanticTokenModifiers = exports2.SemanticTokenModifiers || (exports2.SemanticTokenModifiers = {}));
    var SemanticTokens;
    (function(SemanticTokens2) {
      function is(value) {
        const candidate = value;
        return candidate !== void 0 && (candidate.resultId === void 0 || typeof candidate.resultId === "string") && Array.isArray(candidate.data) && (candidate.data.length === 0 || typeof candidate.data[0] === "number");
      }
      SemanticTokens2.is = is;
    })(SemanticTokens = exports2.SemanticTokens || (exports2.SemanticTokens = {}));
    var TokenFormat;
    (function(TokenFormat2) {
      TokenFormat2.Relative = "relative";
    })(TokenFormat = exports2.TokenFormat || (exports2.TokenFormat = {}));
    var SemanticTokensRegistrationType;
    (function(SemanticTokensRegistrationType2) {
      SemanticTokensRegistrationType2.method = "textDocument/semanticTokens";
      SemanticTokensRegistrationType2.type = new messages_1.RegistrationType(SemanticTokensRegistrationType2.method);
    })(SemanticTokensRegistrationType = exports2.SemanticTokensRegistrationType || (exports2.SemanticTokensRegistrationType = {}));
    var SemanticTokensRequest;
    (function(SemanticTokensRequest2) {
      SemanticTokensRequest2.method = "textDocument/semanticTokens/full";
      SemanticTokensRequest2.type = new messages_1.ProtocolRequestType(SemanticTokensRequest2.method);
    })(SemanticTokensRequest = exports2.SemanticTokensRequest || (exports2.SemanticTokensRequest = {}));
    var SemanticTokensDeltaRequest;
    (function(SemanticTokensDeltaRequest2) {
      SemanticTokensDeltaRequest2.method = "textDocument/semanticTokens/full/delta";
      SemanticTokensDeltaRequest2.type = new messages_1.ProtocolRequestType(SemanticTokensDeltaRequest2.method);
    })(SemanticTokensDeltaRequest = exports2.SemanticTokensDeltaRequest || (exports2.SemanticTokensDeltaRequest = {}));
    var SemanticTokensRangeRequest;
    (function(SemanticTokensRangeRequest2) {
      SemanticTokensRangeRequest2.method = "textDocument/semanticTokens/range";
      SemanticTokensRangeRequest2.type = new messages_1.ProtocolRequestType(SemanticTokensRangeRequest2.method);
    })(SemanticTokensRangeRequest = exports2.SemanticTokensRangeRequest || (exports2.SemanticTokensRangeRequest = {}));
    var SemanticTokensRefreshRequest;
    (function(SemanticTokensRefreshRequest2) {
      SemanticTokensRefreshRequest2.method = `workspace/semanticTokens/refresh`;
      SemanticTokensRefreshRequest2.type = new messages_1.ProtocolRequestType0(SemanticTokensRefreshRequest2.method);
    })(SemanticTokensRefreshRequest = exports2.SemanticTokensRefreshRequest || (exports2.SemanticTokensRefreshRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.showDocument.js
var require_protocol_showDocument = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.showDocument.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ShowDocumentRequest = void 0;
    var messages_1 = require_messages();
    var ShowDocumentRequest;
    (function(ShowDocumentRequest2) {
      ShowDocumentRequest2.method = "window/showDocument";
      ShowDocumentRequest2.type = new messages_1.ProtocolRequestType(ShowDocumentRequest2.method);
    })(ShowDocumentRequest = exports2.ShowDocumentRequest || (exports2.ShowDocumentRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.linkedEditingRange.js
var require_protocol_linkedEditingRange = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.linkedEditingRange.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LinkedEditingRangeRequest = void 0;
    var messages_1 = require_messages();
    var LinkedEditingRangeRequest;
    (function(LinkedEditingRangeRequest2) {
      LinkedEditingRangeRequest2.method = "textDocument/linkedEditingRange";
      LinkedEditingRangeRequest2.type = new messages_1.ProtocolRequestType(LinkedEditingRangeRequest2.method);
    })(LinkedEditingRangeRequest = exports2.LinkedEditingRangeRequest || (exports2.LinkedEditingRangeRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.fileOperations.js
var require_protocol_fileOperations = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.fileOperations.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.WillDeleteFilesRequest = exports2.DidDeleteFilesNotification = exports2.DidRenameFilesNotification = exports2.WillRenameFilesRequest = exports2.DidCreateFilesNotification = exports2.WillCreateFilesRequest = exports2.FileOperationPatternKind = void 0;
    var messages_1 = require_messages();
    var FileOperationPatternKind;
    (function(FileOperationPatternKind2) {
      FileOperationPatternKind2.file = "file";
      FileOperationPatternKind2.folder = "folder";
    })(FileOperationPatternKind = exports2.FileOperationPatternKind || (exports2.FileOperationPatternKind = {}));
    var WillCreateFilesRequest;
    (function(WillCreateFilesRequest2) {
      WillCreateFilesRequest2.method = "workspace/willCreateFiles";
      WillCreateFilesRequest2.type = new messages_1.ProtocolRequestType(WillCreateFilesRequest2.method);
    })(WillCreateFilesRequest = exports2.WillCreateFilesRequest || (exports2.WillCreateFilesRequest = {}));
    var DidCreateFilesNotification;
    (function(DidCreateFilesNotification2) {
      DidCreateFilesNotification2.method = "workspace/didCreateFiles";
      DidCreateFilesNotification2.type = new messages_1.ProtocolNotificationType(DidCreateFilesNotification2.method);
    })(DidCreateFilesNotification = exports2.DidCreateFilesNotification || (exports2.DidCreateFilesNotification = {}));
    var WillRenameFilesRequest;
    (function(WillRenameFilesRequest2) {
      WillRenameFilesRequest2.method = "workspace/willRenameFiles";
      WillRenameFilesRequest2.type = new messages_1.ProtocolRequestType(WillRenameFilesRequest2.method);
    })(WillRenameFilesRequest = exports2.WillRenameFilesRequest || (exports2.WillRenameFilesRequest = {}));
    var DidRenameFilesNotification;
    (function(DidRenameFilesNotification2) {
      DidRenameFilesNotification2.method = "workspace/didRenameFiles";
      DidRenameFilesNotification2.type = new messages_1.ProtocolNotificationType(DidRenameFilesNotification2.method);
    })(DidRenameFilesNotification = exports2.DidRenameFilesNotification || (exports2.DidRenameFilesNotification = {}));
    var DidDeleteFilesNotification;
    (function(DidDeleteFilesNotification2) {
      DidDeleteFilesNotification2.method = "workspace/didDeleteFiles";
      DidDeleteFilesNotification2.type = new messages_1.ProtocolNotificationType(DidDeleteFilesNotification2.method);
    })(DidDeleteFilesNotification = exports2.DidDeleteFilesNotification || (exports2.DidDeleteFilesNotification = {}));
    var WillDeleteFilesRequest;
    (function(WillDeleteFilesRequest2) {
      WillDeleteFilesRequest2.method = "workspace/willDeleteFiles";
      WillDeleteFilesRequest2.type = new messages_1.ProtocolRequestType(WillDeleteFilesRequest2.method);
    })(WillDeleteFilesRequest = exports2.WillDeleteFilesRequest || (exports2.WillDeleteFilesRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.moniker.js
var require_protocol_moniker = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.moniker.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MonikerRequest = exports2.MonikerKind = exports2.UniquenessLevel = void 0;
    var messages_1 = require_messages();
    var UniquenessLevel;
    (function(UniquenessLevel2) {
      UniquenessLevel2["document"] = "document";
      UniquenessLevel2["project"] = "project";
      UniquenessLevel2["group"] = "group";
      UniquenessLevel2["scheme"] = "scheme";
      UniquenessLevel2["global"] = "global";
    })(UniquenessLevel = exports2.UniquenessLevel || (exports2.UniquenessLevel = {}));
    var MonikerKind;
    (function(MonikerKind2) {
      MonikerKind2["import"] = "import";
      MonikerKind2["export"] = "export";
      MonikerKind2["local"] = "local";
    })(MonikerKind = exports2.MonikerKind || (exports2.MonikerKind = {}));
    var MonikerRequest;
    (function(MonikerRequest2) {
      MonikerRequest2.method = "textDocument/moniker";
      MonikerRequest2.type = new messages_1.ProtocolRequestType(MonikerRequest2.method);
    })(MonikerRequest = exports2.MonikerRequest || (exports2.MonikerRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.js
var require_protocol = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DocumentLinkRequest = exports2.CodeLensRefreshRequest = exports2.CodeLensResolveRequest = exports2.CodeLensRequest = exports2.WorkspaceSymbolRequest = exports2.CodeActionResolveRequest = exports2.CodeActionRequest = exports2.DocumentSymbolRequest = exports2.DocumentHighlightRequest = exports2.ReferencesRequest = exports2.DefinitionRequest = exports2.SignatureHelpRequest = exports2.SignatureHelpTriggerKind = exports2.HoverRequest = exports2.CompletionResolveRequest = exports2.CompletionRequest = exports2.CompletionTriggerKind = exports2.PublishDiagnosticsNotification = exports2.WatchKind = exports2.FileChangeType = exports2.DidChangeWatchedFilesNotification = exports2.WillSaveTextDocumentWaitUntilRequest = exports2.WillSaveTextDocumentNotification = exports2.TextDocumentSaveReason = exports2.DidSaveTextDocumentNotification = exports2.DidCloseTextDocumentNotification = exports2.DidChangeTextDocumentNotification = exports2.TextDocumentContentChangeEvent = exports2.DidOpenTextDocumentNotification = exports2.TextDocumentSyncKind = exports2.TelemetryEventNotification = exports2.LogMessageNotification = exports2.ShowMessageRequest = exports2.ShowMessageNotification = exports2.MessageType = exports2.DidChangeConfigurationNotification = exports2.ExitNotification = exports2.ShutdownRequest = exports2.InitializedNotification = exports2.InitializeError = exports2.InitializeRequest = exports2.WorkDoneProgressOptions = exports2.TextDocumentRegistrationOptions = exports2.StaticRegistrationOptions = exports2.FailureHandlingKind = exports2.ResourceOperationKind = exports2.UnregistrationRequest = exports2.RegistrationRequest = exports2.DocumentSelector = exports2.DocumentFilter = void 0;
    exports2.MonikerRequest = exports2.MonikerKind = exports2.UniquenessLevel = exports2.WillDeleteFilesRequest = exports2.DidDeleteFilesNotification = exports2.WillRenameFilesRequest = exports2.DidRenameFilesNotification = exports2.WillCreateFilesRequest = exports2.DidCreateFilesNotification = exports2.FileOperationPatternKind = exports2.LinkedEditingRangeRequest = exports2.ShowDocumentRequest = exports2.SemanticTokensRegistrationType = exports2.SemanticTokensRefreshRequest = exports2.SemanticTokensRangeRequest = exports2.SemanticTokensDeltaRequest = exports2.SemanticTokensRequest = exports2.TokenFormat = exports2.SemanticTokens = exports2.SemanticTokenModifiers = exports2.SemanticTokenTypes = exports2.CallHierarchyPrepareRequest = exports2.CallHierarchyOutgoingCallsRequest = exports2.CallHierarchyIncomingCallsRequest = exports2.WorkDoneProgressCancelNotification = exports2.WorkDoneProgressCreateRequest = exports2.WorkDoneProgress = exports2.SelectionRangeRequest = exports2.DeclarationRequest = exports2.FoldingRangeRequest = exports2.ColorPresentationRequest = exports2.DocumentColorRequest = exports2.ConfigurationRequest = exports2.DidChangeWorkspaceFoldersNotification = exports2.WorkspaceFoldersRequest = exports2.TypeDefinitionRequest = exports2.ImplementationRequest = exports2.ApplyWorkspaceEditRequest = exports2.ExecuteCommandRequest = exports2.PrepareRenameRequest = exports2.RenameRequest = exports2.PrepareSupportDefaultBehavior = exports2.DocumentOnTypeFormattingRequest = exports2.DocumentRangeFormattingRequest = exports2.DocumentFormattingRequest = exports2.DocumentLinkResolveRequest = void 0;
    var Is = require_is();
    var messages_1 = require_messages();
    var protocol_implementation_1 = require_protocol_implementation();
    Object.defineProperty(exports2, "ImplementationRequest", { enumerable: true, get: function() {
      return protocol_implementation_1.ImplementationRequest;
    } });
    var protocol_typeDefinition_1 = require_protocol_typeDefinition();
    Object.defineProperty(exports2, "TypeDefinitionRequest", { enumerable: true, get: function() {
      return protocol_typeDefinition_1.TypeDefinitionRequest;
    } });
    var protocol_workspaceFolders_1 = require_protocol_workspaceFolders();
    Object.defineProperty(exports2, "WorkspaceFoldersRequest", { enumerable: true, get: function() {
      return protocol_workspaceFolders_1.WorkspaceFoldersRequest;
    } });
    Object.defineProperty(exports2, "DidChangeWorkspaceFoldersNotification", { enumerable: true, get: function() {
      return protocol_workspaceFolders_1.DidChangeWorkspaceFoldersNotification;
    } });
    var protocol_configuration_1 = require_protocol_configuration();
    Object.defineProperty(exports2, "ConfigurationRequest", { enumerable: true, get: function() {
      return protocol_configuration_1.ConfigurationRequest;
    } });
    var protocol_colorProvider_1 = require_protocol_colorProvider();
    Object.defineProperty(exports2, "DocumentColorRequest", { enumerable: true, get: function() {
      return protocol_colorProvider_1.DocumentColorRequest;
    } });
    Object.defineProperty(exports2, "ColorPresentationRequest", { enumerable: true, get: function() {
      return protocol_colorProvider_1.ColorPresentationRequest;
    } });
    var protocol_foldingRange_1 = require_protocol_foldingRange();
    Object.defineProperty(exports2, "FoldingRangeRequest", { enumerable: true, get: function() {
      return protocol_foldingRange_1.FoldingRangeRequest;
    } });
    var protocol_declaration_1 = require_protocol_declaration();
    Object.defineProperty(exports2, "DeclarationRequest", { enumerable: true, get: function() {
      return protocol_declaration_1.DeclarationRequest;
    } });
    var protocol_selectionRange_1 = require_protocol_selectionRange();
    Object.defineProperty(exports2, "SelectionRangeRequest", { enumerable: true, get: function() {
      return protocol_selectionRange_1.SelectionRangeRequest;
    } });
    var protocol_progress_1 = require_protocol_progress();
    Object.defineProperty(exports2, "WorkDoneProgress", { enumerable: true, get: function() {
      return protocol_progress_1.WorkDoneProgress;
    } });
    Object.defineProperty(exports2, "WorkDoneProgressCreateRequest", { enumerable: true, get: function() {
      return protocol_progress_1.WorkDoneProgressCreateRequest;
    } });
    Object.defineProperty(exports2, "WorkDoneProgressCancelNotification", { enumerable: true, get: function() {
      return protocol_progress_1.WorkDoneProgressCancelNotification;
    } });
    var protocol_callHierarchy_1 = require_protocol_callHierarchy();
    Object.defineProperty(exports2, "CallHierarchyIncomingCallsRequest", { enumerable: true, get: function() {
      return protocol_callHierarchy_1.CallHierarchyIncomingCallsRequest;
    } });
    Object.defineProperty(exports2, "CallHierarchyOutgoingCallsRequest", { enumerable: true, get: function() {
      return protocol_callHierarchy_1.CallHierarchyOutgoingCallsRequest;
    } });
    Object.defineProperty(exports2, "CallHierarchyPrepareRequest", { enumerable: true, get: function() {
      return protocol_callHierarchy_1.CallHierarchyPrepareRequest;
    } });
    var protocol_semanticTokens_1 = require_protocol_semanticTokens();
    Object.defineProperty(exports2, "SemanticTokenTypes", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokenTypes;
    } });
    Object.defineProperty(exports2, "SemanticTokenModifiers", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokenModifiers;
    } });
    Object.defineProperty(exports2, "SemanticTokens", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokens;
    } });
    Object.defineProperty(exports2, "TokenFormat", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.TokenFormat;
    } });
    Object.defineProperty(exports2, "SemanticTokensRequest", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensRequest;
    } });
    Object.defineProperty(exports2, "SemanticTokensDeltaRequest", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensDeltaRequest;
    } });
    Object.defineProperty(exports2, "SemanticTokensRangeRequest", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensRangeRequest;
    } });
    Object.defineProperty(exports2, "SemanticTokensRefreshRequest", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensRefreshRequest;
    } });
    Object.defineProperty(exports2, "SemanticTokensRegistrationType", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensRegistrationType;
    } });
    var protocol_showDocument_1 = require_protocol_showDocument();
    Object.defineProperty(exports2, "ShowDocumentRequest", { enumerable: true, get: function() {
      return protocol_showDocument_1.ShowDocumentRequest;
    } });
    var protocol_linkedEditingRange_1 = require_protocol_linkedEditingRange();
    Object.defineProperty(exports2, "LinkedEditingRangeRequest", { enumerable: true, get: function() {
      return protocol_linkedEditingRange_1.LinkedEditingRangeRequest;
    } });
    var protocol_fileOperations_1 = require_protocol_fileOperations();
    Object.defineProperty(exports2, "FileOperationPatternKind", { enumerable: true, get: function() {
      return protocol_fileOperations_1.FileOperationPatternKind;
    } });
    Object.defineProperty(exports2, "DidCreateFilesNotification", { enumerable: true, get: function() {
      return protocol_fileOperations_1.DidCreateFilesNotification;
    } });
    Object.defineProperty(exports2, "WillCreateFilesRequest", { enumerable: true, get: function() {
      return protocol_fileOperations_1.WillCreateFilesRequest;
    } });
    Object.defineProperty(exports2, "DidRenameFilesNotification", { enumerable: true, get: function() {
      return protocol_fileOperations_1.DidRenameFilesNotification;
    } });
    Object.defineProperty(exports2, "WillRenameFilesRequest", { enumerable: true, get: function() {
      return protocol_fileOperations_1.WillRenameFilesRequest;
    } });
    Object.defineProperty(exports2, "DidDeleteFilesNotification", { enumerable: true, get: function() {
      return protocol_fileOperations_1.DidDeleteFilesNotification;
    } });
    Object.defineProperty(exports2, "WillDeleteFilesRequest", { enumerable: true, get: function() {
      return protocol_fileOperations_1.WillDeleteFilesRequest;
    } });
    var protocol_moniker_1 = require_protocol_moniker();
    Object.defineProperty(exports2, "UniquenessLevel", { enumerable: true, get: function() {
      return protocol_moniker_1.UniquenessLevel;
    } });
    Object.defineProperty(exports2, "MonikerKind", { enumerable: true, get: function() {
      return protocol_moniker_1.MonikerKind;
    } });
    Object.defineProperty(exports2, "MonikerRequest", { enumerable: true, get: function() {
      return protocol_moniker_1.MonikerRequest;
    } });
    var DocumentFilter;
    (function(DocumentFilter2) {
      function is(value) {
        const candidate = value;
        return Is.string(candidate.language) || Is.string(candidate.scheme) || Is.string(candidate.pattern);
      }
      DocumentFilter2.is = is;
    })(DocumentFilter = exports2.DocumentFilter || (exports2.DocumentFilter = {}));
    var DocumentSelector;
    (function(DocumentSelector2) {
      function is(value) {
        if (!Array.isArray(value)) {
          return false;
        }
        for (let elem of value) {
          if (!Is.string(elem) && !DocumentFilter.is(elem)) {
            return false;
          }
        }
        return true;
      }
      DocumentSelector2.is = is;
    })(DocumentSelector = exports2.DocumentSelector || (exports2.DocumentSelector = {}));
    var RegistrationRequest;
    (function(RegistrationRequest2) {
      RegistrationRequest2.type = new messages_1.ProtocolRequestType("client/registerCapability");
    })(RegistrationRequest = exports2.RegistrationRequest || (exports2.RegistrationRequest = {}));
    var UnregistrationRequest;
    (function(UnregistrationRequest2) {
      UnregistrationRequest2.type = new messages_1.ProtocolRequestType("client/unregisterCapability");
    })(UnregistrationRequest = exports2.UnregistrationRequest || (exports2.UnregistrationRequest = {}));
    var ResourceOperationKind;
    (function(ResourceOperationKind2) {
      ResourceOperationKind2.Create = "create";
      ResourceOperationKind2.Rename = "rename";
      ResourceOperationKind2.Delete = "delete";
    })(ResourceOperationKind = exports2.ResourceOperationKind || (exports2.ResourceOperationKind = {}));
    var FailureHandlingKind;
    (function(FailureHandlingKind2) {
      FailureHandlingKind2.Abort = "abort";
      FailureHandlingKind2.Transactional = "transactional";
      FailureHandlingKind2.TextOnlyTransactional = "textOnlyTransactional";
      FailureHandlingKind2.Undo = "undo";
    })(FailureHandlingKind = exports2.FailureHandlingKind || (exports2.FailureHandlingKind = {}));
    var StaticRegistrationOptions;
    (function(StaticRegistrationOptions2) {
      function hasId(value) {
        const candidate = value;
        return candidate && Is.string(candidate.id) && candidate.id.length > 0;
      }
      StaticRegistrationOptions2.hasId = hasId;
    })(StaticRegistrationOptions = exports2.StaticRegistrationOptions || (exports2.StaticRegistrationOptions = {}));
    var TextDocumentRegistrationOptions;
    (function(TextDocumentRegistrationOptions2) {
      function is(value) {
        const candidate = value;
        return candidate && (candidate.documentSelector === null || DocumentSelector.is(candidate.documentSelector));
      }
      TextDocumentRegistrationOptions2.is = is;
    })(TextDocumentRegistrationOptions = exports2.TextDocumentRegistrationOptions || (exports2.TextDocumentRegistrationOptions = {}));
    var WorkDoneProgressOptions;
    (function(WorkDoneProgressOptions2) {
      function is(value) {
        const candidate = value;
        return Is.objectLiteral(candidate) && (candidate.workDoneProgress === void 0 || Is.boolean(candidate.workDoneProgress));
      }
      WorkDoneProgressOptions2.is = is;
      function hasWorkDoneProgress(value) {
        const candidate = value;
        return candidate && Is.boolean(candidate.workDoneProgress);
      }
      WorkDoneProgressOptions2.hasWorkDoneProgress = hasWorkDoneProgress;
    })(WorkDoneProgressOptions = exports2.WorkDoneProgressOptions || (exports2.WorkDoneProgressOptions = {}));
    var InitializeRequest;
    (function(InitializeRequest2) {
      InitializeRequest2.type = new messages_1.ProtocolRequestType("initialize");
    })(InitializeRequest = exports2.InitializeRequest || (exports2.InitializeRequest = {}));
    var InitializeError;
    (function(InitializeError2) {
      InitializeError2.unknownProtocolVersion = 1;
    })(InitializeError = exports2.InitializeError || (exports2.InitializeError = {}));
    var InitializedNotification;
    (function(InitializedNotification2) {
      InitializedNotification2.type = new messages_1.ProtocolNotificationType("initialized");
    })(InitializedNotification = exports2.InitializedNotification || (exports2.InitializedNotification = {}));
    var ShutdownRequest;
    (function(ShutdownRequest2) {
      ShutdownRequest2.type = new messages_1.ProtocolRequestType0("shutdown");
    })(ShutdownRequest = exports2.ShutdownRequest || (exports2.ShutdownRequest = {}));
    var ExitNotification;
    (function(ExitNotification2) {
      ExitNotification2.type = new messages_1.ProtocolNotificationType0("exit");
    })(ExitNotification = exports2.ExitNotification || (exports2.ExitNotification = {}));
    var DidChangeConfigurationNotification;
    (function(DidChangeConfigurationNotification2) {
      DidChangeConfigurationNotification2.type = new messages_1.ProtocolNotificationType("workspace/didChangeConfiguration");
    })(DidChangeConfigurationNotification = exports2.DidChangeConfigurationNotification || (exports2.DidChangeConfigurationNotification = {}));
    var MessageType;
    (function(MessageType2) {
      MessageType2.Error = 1;
      MessageType2.Warning = 2;
      MessageType2.Info = 3;
      MessageType2.Log = 4;
    })(MessageType = exports2.MessageType || (exports2.MessageType = {}));
    var ShowMessageNotification;
    (function(ShowMessageNotification2) {
      ShowMessageNotification2.type = new messages_1.ProtocolNotificationType("window/showMessage");
    })(ShowMessageNotification = exports2.ShowMessageNotification || (exports2.ShowMessageNotification = {}));
    var ShowMessageRequest;
    (function(ShowMessageRequest2) {
      ShowMessageRequest2.type = new messages_1.ProtocolRequestType("window/showMessageRequest");
    })(ShowMessageRequest = exports2.ShowMessageRequest || (exports2.ShowMessageRequest = {}));
    var LogMessageNotification;
    (function(LogMessageNotification2) {
      LogMessageNotification2.type = new messages_1.ProtocolNotificationType("window/logMessage");
    })(LogMessageNotification = exports2.LogMessageNotification || (exports2.LogMessageNotification = {}));
    var TelemetryEventNotification;
    (function(TelemetryEventNotification2) {
      TelemetryEventNotification2.type = new messages_1.ProtocolNotificationType("telemetry/event");
    })(TelemetryEventNotification = exports2.TelemetryEventNotification || (exports2.TelemetryEventNotification = {}));
    var TextDocumentSyncKind;
    (function(TextDocumentSyncKind2) {
      TextDocumentSyncKind2.None = 0;
      TextDocumentSyncKind2.Full = 1;
      TextDocumentSyncKind2.Incremental = 2;
    })(TextDocumentSyncKind = exports2.TextDocumentSyncKind || (exports2.TextDocumentSyncKind = {}));
    var DidOpenTextDocumentNotification;
    (function(DidOpenTextDocumentNotification2) {
      DidOpenTextDocumentNotification2.method = "textDocument/didOpen";
      DidOpenTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidOpenTextDocumentNotification2.method);
    })(DidOpenTextDocumentNotification = exports2.DidOpenTextDocumentNotification || (exports2.DidOpenTextDocumentNotification = {}));
    var TextDocumentContentChangeEvent;
    (function(TextDocumentContentChangeEvent2) {
      function isIncremental(event) {
        let candidate = event;
        return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range !== void 0 && (candidate.rangeLength === void 0 || typeof candidate.rangeLength === "number");
      }
      TextDocumentContentChangeEvent2.isIncremental = isIncremental;
      function isFull(event) {
        let candidate = event;
        return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range === void 0 && candidate.rangeLength === void 0;
      }
      TextDocumentContentChangeEvent2.isFull = isFull;
    })(TextDocumentContentChangeEvent = exports2.TextDocumentContentChangeEvent || (exports2.TextDocumentContentChangeEvent = {}));
    var DidChangeTextDocumentNotification;
    (function(DidChangeTextDocumentNotification2) {
      DidChangeTextDocumentNotification2.method = "textDocument/didChange";
      DidChangeTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidChangeTextDocumentNotification2.method);
    })(DidChangeTextDocumentNotification = exports2.DidChangeTextDocumentNotification || (exports2.DidChangeTextDocumentNotification = {}));
    var DidCloseTextDocumentNotification;
    (function(DidCloseTextDocumentNotification2) {
      DidCloseTextDocumentNotification2.method = "textDocument/didClose";
      DidCloseTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidCloseTextDocumentNotification2.method);
    })(DidCloseTextDocumentNotification = exports2.DidCloseTextDocumentNotification || (exports2.DidCloseTextDocumentNotification = {}));
    var DidSaveTextDocumentNotification;
    (function(DidSaveTextDocumentNotification2) {
      DidSaveTextDocumentNotification2.method = "textDocument/didSave";
      DidSaveTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidSaveTextDocumentNotification2.method);
    })(DidSaveTextDocumentNotification = exports2.DidSaveTextDocumentNotification || (exports2.DidSaveTextDocumentNotification = {}));
    var TextDocumentSaveReason;
    (function(TextDocumentSaveReason2) {
      TextDocumentSaveReason2.Manual = 1;
      TextDocumentSaveReason2.AfterDelay = 2;
      TextDocumentSaveReason2.FocusOut = 3;
    })(TextDocumentSaveReason = exports2.TextDocumentSaveReason || (exports2.TextDocumentSaveReason = {}));
    var WillSaveTextDocumentNotification;
    (function(WillSaveTextDocumentNotification2) {
      WillSaveTextDocumentNotification2.method = "textDocument/willSave";
      WillSaveTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(WillSaveTextDocumentNotification2.method);
    })(WillSaveTextDocumentNotification = exports2.WillSaveTextDocumentNotification || (exports2.WillSaveTextDocumentNotification = {}));
    var WillSaveTextDocumentWaitUntilRequest;
    (function(WillSaveTextDocumentWaitUntilRequest2) {
      WillSaveTextDocumentWaitUntilRequest2.method = "textDocument/willSaveWaitUntil";
      WillSaveTextDocumentWaitUntilRequest2.type = new messages_1.ProtocolRequestType(WillSaveTextDocumentWaitUntilRequest2.method);
    })(WillSaveTextDocumentWaitUntilRequest = exports2.WillSaveTextDocumentWaitUntilRequest || (exports2.WillSaveTextDocumentWaitUntilRequest = {}));
    var DidChangeWatchedFilesNotification;
    (function(DidChangeWatchedFilesNotification2) {
      DidChangeWatchedFilesNotification2.type = new messages_1.ProtocolNotificationType("workspace/didChangeWatchedFiles");
    })(DidChangeWatchedFilesNotification = exports2.DidChangeWatchedFilesNotification || (exports2.DidChangeWatchedFilesNotification = {}));
    var FileChangeType;
    (function(FileChangeType2) {
      FileChangeType2.Created = 1;
      FileChangeType2.Changed = 2;
      FileChangeType2.Deleted = 3;
    })(FileChangeType = exports2.FileChangeType || (exports2.FileChangeType = {}));
    var WatchKind;
    (function(WatchKind2) {
      WatchKind2.Create = 1;
      WatchKind2.Change = 2;
      WatchKind2.Delete = 4;
    })(WatchKind = exports2.WatchKind || (exports2.WatchKind = {}));
    var PublishDiagnosticsNotification;
    (function(PublishDiagnosticsNotification2) {
      PublishDiagnosticsNotification2.type = new messages_1.ProtocolNotificationType("textDocument/publishDiagnostics");
    })(PublishDiagnosticsNotification = exports2.PublishDiagnosticsNotification || (exports2.PublishDiagnosticsNotification = {}));
    var CompletionTriggerKind;
    (function(CompletionTriggerKind2) {
      CompletionTriggerKind2.Invoked = 1;
      CompletionTriggerKind2.TriggerCharacter = 2;
      CompletionTriggerKind2.TriggerForIncompleteCompletions = 3;
    })(CompletionTriggerKind = exports2.CompletionTriggerKind || (exports2.CompletionTriggerKind = {}));
    var CompletionRequest;
    (function(CompletionRequest2) {
      CompletionRequest2.method = "textDocument/completion";
      CompletionRequest2.type = new messages_1.ProtocolRequestType(CompletionRequest2.method);
    })(CompletionRequest = exports2.CompletionRequest || (exports2.CompletionRequest = {}));
    var CompletionResolveRequest;
    (function(CompletionResolveRequest2) {
      CompletionResolveRequest2.method = "completionItem/resolve";
      CompletionResolveRequest2.type = new messages_1.ProtocolRequestType(CompletionResolveRequest2.method);
    })(CompletionResolveRequest = exports2.CompletionResolveRequest || (exports2.CompletionResolveRequest = {}));
    var HoverRequest;
    (function(HoverRequest2) {
      HoverRequest2.method = "textDocument/hover";
      HoverRequest2.type = new messages_1.ProtocolRequestType(HoverRequest2.method);
    })(HoverRequest = exports2.HoverRequest || (exports2.HoverRequest = {}));
    var SignatureHelpTriggerKind;
    (function(SignatureHelpTriggerKind2) {
      SignatureHelpTriggerKind2.Invoked = 1;
      SignatureHelpTriggerKind2.TriggerCharacter = 2;
      SignatureHelpTriggerKind2.ContentChange = 3;
    })(SignatureHelpTriggerKind = exports2.SignatureHelpTriggerKind || (exports2.SignatureHelpTriggerKind = {}));
    var SignatureHelpRequest;
    (function(SignatureHelpRequest2) {
      SignatureHelpRequest2.method = "textDocument/signatureHelp";
      SignatureHelpRequest2.type = new messages_1.ProtocolRequestType(SignatureHelpRequest2.method);
    })(SignatureHelpRequest = exports2.SignatureHelpRequest || (exports2.SignatureHelpRequest = {}));
    var DefinitionRequest;
    (function(DefinitionRequest2) {
      DefinitionRequest2.method = "textDocument/definition";
      DefinitionRequest2.type = new messages_1.ProtocolRequestType(DefinitionRequest2.method);
    })(DefinitionRequest = exports2.DefinitionRequest || (exports2.DefinitionRequest = {}));
    var ReferencesRequest;
    (function(ReferencesRequest2) {
      ReferencesRequest2.method = "textDocument/references";
      ReferencesRequest2.type = new messages_1.ProtocolRequestType(ReferencesRequest2.method);
    })(ReferencesRequest = exports2.ReferencesRequest || (exports2.ReferencesRequest = {}));
    var DocumentHighlightRequest;
    (function(DocumentHighlightRequest2) {
      DocumentHighlightRequest2.method = "textDocument/documentHighlight";
      DocumentHighlightRequest2.type = new messages_1.ProtocolRequestType(DocumentHighlightRequest2.method);
    })(DocumentHighlightRequest = exports2.DocumentHighlightRequest || (exports2.DocumentHighlightRequest = {}));
    var DocumentSymbolRequest;
    (function(DocumentSymbolRequest2) {
      DocumentSymbolRequest2.method = "textDocument/documentSymbol";
      DocumentSymbolRequest2.type = new messages_1.ProtocolRequestType(DocumentSymbolRequest2.method);
    })(DocumentSymbolRequest = exports2.DocumentSymbolRequest || (exports2.DocumentSymbolRequest = {}));
    var CodeActionRequest;
    (function(CodeActionRequest2) {
      CodeActionRequest2.method = "textDocument/codeAction";
      CodeActionRequest2.type = new messages_1.ProtocolRequestType(CodeActionRequest2.method);
    })(CodeActionRequest = exports2.CodeActionRequest || (exports2.CodeActionRequest = {}));
    var CodeActionResolveRequest;
    (function(CodeActionResolveRequest2) {
      CodeActionResolveRequest2.method = "codeAction/resolve";
      CodeActionResolveRequest2.type = new messages_1.ProtocolRequestType(CodeActionResolveRequest2.method);
    })(CodeActionResolveRequest = exports2.CodeActionResolveRequest || (exports2.CodeActionResolveRequest = {}));
    var WorkspaceSymbolRequest;
    (function(WorkspaceSymbolRequest2) {
      WorkspaceSymbolRequest2.method = "workspace/symbol";
      WorkspaceSymbolRequest2.type = new messages_1.ProtocolRequestType(WorkspaceSymbolRequest2.method);
    })(WorkspaceSymbolRequest = exports2.WorkspaceSymbolRequest || (exports2.WorkspaceSymbolRequest = {}));
    var CodeLensRequest;
    (function(CodeLensRequest2) {
      CodeLensRequest2.method = "textDocument/codeLens";
      CodeLensRequest2.type = new messages_1.ProtocolRequestType(CodeLensRequest2.method);
    })(CodeLensRequest = exports2.CodeLensRequest || (exports2.CodeLensRequest = {}));
    var CodeLensResolveRequest;
    (function(CodeLensResolveRequest2) {
      CodeLensResolveRequest2.method = "codeLens/resolve";
      CodeLensResolveRequest2.type = new messages_1.ProtocolRequestType(CodeLensResolveRequest2.method);
    })(CodeLensResolveRequest = exports2.CodeLensResolveRequest || (exports2.CodeLensResolveRequest = {}));
    var CodeLensRefreshRequest;
    (function(CodeLensRefreshRequest2) {
      CodeLensRefreshRequest2.method = `workspace/codeLens/refresh`;
      CodeLensRefreshRequest2.type = new messages_1.ProtocolRequestType0(CodeLensRefreshRequest2.method);
    })(CodeLensRefreshRequest = exports2.CodeLensRefreshRequest || (exports2.CodeLensRefreshRequest = {}));
    var DocumentLinkRequest;
    (function(DocumentLinkRequest2) {
      DocumentLinkRequest2.method = "textDocument/documentLink";
      DocumentLinkRequest2.type = new messages_1.ProtocolRequestType(DocumentLinkRequest2.method);
    })(DocumentLinkRequest = exports2.DocumentLinkRequest || (exports2.DocumentLinkRequest = {}));
    var DocumentLinkResolveRequest;
    (function(DocumentLinkResolveRequest2) {
      DocumentLinkResolveRequest2.method = "documentLink/resolve";
      DocumentLinkResolveRequest2.type = new messages_1.ProtocolRequestType(DocumentLinkResolveRequest2.method);
    })(DocumentLinkResolveRequest = exports2.DocumentLinkResolveRequest || (exports2.DocumentLinkResolveRequest = {}));
    var DocumentFormattingRequest;
    (function(DocumentFormattingRequest2) {
      DocumentFormattingRequest2.method = "textDocument/formatting";
      DocumentFormattingRequest2.type = new messages_1.ProtocolRequestType(DocumentFormattingRequest2.method);
    })(DocumentFormattingRequest = exports2.DocumentFormattingRequest || (exports2.DocumentFormattingRequest = {}));
    var DocumentRangeFormattingRequest;
    (function(DocumentRangeFormattingRequest2) {
      DocumentRangeFormattingRequest2.method = "textDocument/rangeFormatting";
      DocumentRangeFormattingRequest2.type = new messages_1.ProtocolRequestType(DocumentRangeFormattingRequest2.method);
    })(DocumentRangeFormattingRequest = exports2.DocumentRangeFormattingRequest || (exports2.DocumentRangeFormattingRequest = {}));
    var DocumentOnTypeFormattingRequest;
    (function(DocumentOnTypeFormattingRequest2) {
      DocumentOnTypeFormattingRequest2.method = "textDocument/onTypeFormatting";
      DocumentOnTypeFormattingRequest2.type = new messages_1.ProtocolRequestType(DocumentOnTypeFormattingRequest2.method);
    })(DocumentOnTypeFormattingRequest = exports2.DocumentOnTypeFormattingRequest || (exports2.DocumentOnTypeFormattingRequest = {}));
    var PrepareSupportDefaultBehavior;
    (function(PrepareSupportDefaultBehavior2) {
      PrepareSupportDefaultBehavior2.Identifier = 1;
    })(PrepareSupportDefaultBehavior = exports2.PrepareSupportDefaultBehavior || (exports2.PrepareSupportDefaultBehavior = {}));
    var RenameRequest;
    (function(RenameRequest2) {
      RenameRequest2.method = "textDocument/rename";
      RenameRequest2.type = new messages_1.ProtocolRequestType(RenameRequest2.method);
    })(RenameRequest = exports2.RenameRequest || (exports2.RenameRequest = {}));
    var PrepareRenameRequest;
    (function(PrepareRenameRequest2) {
      PrepareRenameRequest2.method = "textDocument/prepareRename";
      PrepareRenameRequest2.type = new messages_1.ProtocolRequestType(PrepareRenameRequest2.method);
    })(PrepareRenameRequest = exports2.PrepareRenameRequest || (exports2.PrepareRenameRequest = {}));
    var ExecuteCommandRequest;
    (function(ExecuteCommandRequest2) {
      ExecuteCommandRequest2.type = new messages_1.ProtocolRequestType("workspace/executeCommand");
    })(ExecuteCommandRequest = exports2.ExecuteCommandRequest || (exports2.ExecuteCommandRequest = {}));
    var ApplyWorkspaceEditRequest;
    (function(ApplyWorkspaceEditRequest2) {
      ApplyWorkspaceEditRequest2.type = new messages_1.ProtocolRequestType("workspace/applyEdit");
    })(ApplyWorkspaceEditRequest = exports2.ApplyWorkspaceEditRequest || (exports2.ApplyWorkspaceEditRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/connection.js
var require_connection = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/connection.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createProtocolConnection = void 0;
    var vscode_jsonrpc_1 = require("vscode-jsonrpc");
    function createProtocolConnection(input, output, logger, options2) {
      if (vscode_jsonrpc_1.ConnectionStrategy.is(options2)) {
        options2 = { connectionStrategy: options2 };
      }
      return vscode_jsonrpc_1.createMessageConnection(input, output, logger, options2);
    }
    exports2.createProtocolConnection = createProtocolConnection;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/api.js
var require_api = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/common/api.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LSPErrorCodes = exports2.createProtocolConnection = void 0;
    __exportStar(require("vscode-jsonrpc"), exports2);
    __exportStar(require_main(), exports2);
    __exportStar(require_messages(), exports2);
    __exportStar(require_protocol(), exports2);
    var connection_1 = require_connection();
    Object.defineProperty(exports2, "createProtocolConnection", { enumerable: true, get: function() {
      return connection_1.createProtocolConnection;
    } });
    var LSPErrorCodes;
    (function(LSPErrorCodes2) {
      LSPErrorCodes2.lspReservedErrorRangeStart = -32899;
      LSPErrorCodes2.ContentModified = -32801;
      LSPErrorCodes2.RequestCancelled = -32800;
      LSPErrorCodes2.lspReservedErrorRangeEnd = -32800;
    })(LSPErrorCodes = exports2.LSPErrorCodes || (exports2.LSPErrorCodes = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/node/main.js
var require_main2 = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol@3.16.0/node_modules/vscode-languageserver-protocol/lib/node/main.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createProtocolConnection = void 0;
    var node_1 = require("vscode-jsonrpc/node");
    __exportStar(require("vscode-jsonrpc/node"), exports2);
    __exportStar(require_api(), exports2);
    function createProtocolConnection(input, output, logger, options2) {
      return node_1.createMessageConnection(input, output, logger, options2);
    }
    exports2.createProtocolConnection = createProtocolConnection;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/common/requests.js
var require_requests = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/common/requests.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.IsInAngularProject = exports2.GetTcbRequest = exports2.GetTemplateLocationForComponent = exports2.GetComponentsWithTemplateFile = void 0;
    var lsp = __importStar(require_main2());
    exports2.GetComponentsWithTemplateFile = new lsp.RequestType("angular/getComponentsWithTemplateFile");
    exports2.GetTemplateLocationForComponent = new lsp.RequestType("angular/getTemplateLocationForComponent");
    exports2.GetTcbRequest = new lsp.RequestType("angular/getTcb");
    exports2.IsInAngularProject = new lsp.RequestType("angular/isAngularCoreInOwningProject");
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/utils.js
var require_utils = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/utils.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getMappedDefinitionInfo = exports2.tsDisplayPartsToText = exports2.MruTracker = exports2.isConfiguredProject = exports2.tsRelatedInformationToLspRelatedInformation = exports2.lspRangeToTsPositions = exports2.lspPositionToTsPosition = exports2.tsTextSpanToLspRange = exports2.tsFileTextChangesToLspWorkspaceEdit = exports2.filePathToUri = exports2.uriToFilePath = exports2.isDebugMode = void 0;
    var ts = __importStar(require("typescript/lib/tsserverlibrary"));
    var lsp = __importStar(require("vscode-languageserver"));
    var vscode_uri_1 = require("vscode-uri");
    exports2.isDebugMode = process.env["NG_DEBUG"] === "true";
    var Scheme;
    (function(Scheme2) {
      Scheme2["File"] = "file";
    })(Scheme || (Scheme = {}));
    function uriToFilePath(uri) {
      const { scheme, fsPath } = vscode_uri_1.URI.parse(uri);
      if (scheme !== Scheme.File) {
        return "";
      }
      return fsPath;
    }
    exports2.uriToFilePath = uriToFilePath;
    function filePathToUri(filePath) {
      return vscode_uri_1.URI.file(filePath).toString();
    }
    exports2.filePathToUri = filePathToUri;
    function tsFileTextChangesToLspWorkspaceEdit(changes, getScriptInfo) {
      const workspaceChanges = {};
      for (const change of changes) {
        const scriptInfo = getScriptInfo(change.fileName);
        const uri = filePathToUri(change.fileName);
        if (scriptInfo === void 0) {
          continue;
        }
        if (!workspaceChanges[uri]) {
          workspaceChanges[uri] = [];
        }
        for (const textChange of change.textChanges) {
          const textEdit = {
            newText: textChange.newText,
            range: tsTextSpanToLspRange(scriptInfo, textChange.span)
          };
          workspaceChanges[uri].push(textEdit);
        }
      }
      return {
        changes: workspaceChanges
      };
    }
    exports2.tsFileTextChangesToLspWorkspaceEdit = tsFileTextChangesToLspWorkspaceEdit;
    function tsTextSpanToLspRange(scriptInfo, textSpan) {
      const start = scriptInfo.positionToLineOffset(textSpan.start);
      const end = scriptInfo.positionToLineOffset(textSpan.start + textSpan.length);
      return lsp.Range.create(start.line - 1, start.offset - 1, end.line - 1, end.offset - 1);
    }
    exports2.tsTextSpanToLspRange = tsTextSpanToLspRange;
    function lspPositionToTsPosition(scriptInfo, position) {
      const { line, character } = position;
      return scriptInfo.lineOffsetToPosition(line + 1, character + 1);
    }
    exports2.lspPositionToTsPosition = lspPositionToTsPosition;
    function lspRangeToTsPositions(scriptInfo, range) {
      const start = lspPositionToTsPosition(scriptInfo, range.start);
      const end = lspPositionToTsPosition(scriptInfo, range.end);
      return [start, end];
    }
    exports2.lspRangeToTsPositions = lspRangeToTsPositions;
    function tsRelatedInformationToLspRelatedInformation(scriptInfo, relatedInfo) {
      if (relatedInfo === void 0)
        return;
      const lspRelatedInfo = [];
      for (const info of relatedInfo) {
        if (info.file === void 0 || info.start === void 0 || info.length === void 0)
          continue;
        const textSpan = {
          start: info.start,
          length: info.length
        };
        const location = lsp.Location.create(filePathToUri(info.file.fileName), tsTextSpanToLspRange(scriptInfo, textSpan));
        lspRelatedInfo.push(lsp.DiagnosticRelatedInformation.create(location, ts.flattenDiagnosticMessageText(info.messageText, "\n")));
      }
      return lspRelatedInfo;
    }
    exports2.tsRelatedInformationToLspRelatedInformation = tsRelatedInformationToLspRelatedInformation;
    function isConfiguredProject(project) {
      return project.projectKind === ts.server.ProjectKind.Configured;
    }
    exports2.isConfiguredProject = isConfiguredProject;
    var MruTracker = class {
      constructor() {
        this.set = /* @__PURE__ */ new Set();
      }
      update(item) {
        if (this.set.has(item)) {
          this.set.delete(item);
        }
        this.set.add(item);
      }
      delete(item) {
        this.set.delete(item);
      }
      /**
       * Returns all items sorted by most recently used.
       */
      getAll() {
        return [...this.set].reverse();
      }
    };
    exports2.MruTracker = MruTracker;
    function tsDisplayPartsToText(parts) {
      return parts.map((dp) => dp.text).join("");
    }
    exports2.tsDisplayPartsToText = tsDisplayPartsToText;
    function getMappedDefinitionInfo(info, project) {
      try {
        const mappedDocumentSpan = getMappedDocumentSpan(info, project);
        return Object.assign(Object.assign({}, info), mappedDocumentSpan);
      } catch (_a) {
        return info;
      }
    }
    exports2.getMappedDefinitionInfo = getMappedDefinitionInfo;
    function getMappedDocumentSpan(documentSpan, project) {
      const newPosition = getMappedLocation(documentSpanLocation(documentSpan), project);
      if (!newPosition)
        return void 0;
      return {
        fileName: newPosition.fileName,
        textSpan: { start: newPosition.pos, length: documentSpan.textSpan.length },
        originalFileName: documentSpan.fileName,
        originalTextSpan: documentSpan.textSpan,
        contextSpan: getMappedContextSpan(documentSpan, project),
        originalContextSpan: documentSpan.contextSpan
      };
    }
    function getMappedLocation(location, project) {
      const mapsTo = project.getSourceMapper().tryGetSourcePosition(location);
      return mapsTo && project.projectService.fileExists(ts.server.toNormalizedPath(mapsTo.fileName)) ? mapsTo : void 0;
    }
    function documentSpanLocation({ fileName, textSpan }) {
      return { fileName, pos: textSpan.start };
    }
    function getMappedContextSpan(documentSpan, project) {
      const contextSpanStart = documentSpan.contextSpan && getMappedLocation({ fileName: documentSpan.fileName, pos: documentSpan.contextSpan.start }, project);
      const contextSpanEnd = documentSpan.contextSpan && getMappedLocation({
        fileName: documentSpan.fileName,
        pos: documentSpan.contextSpan.start + documentSpan.contextSpan.length
      }, project);
      return contextSpanStart && contextSpanEnd ? { start: contextSpanStart.pos, length: contextSpanEnd.pos - contextSpanStart.pos } : void 0;
    }
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/completion.js
var require_completion = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/completion.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.tsCompletionEntryToLspCompletionItem = exports2.readNgCompletionData = void 0;
    var lsp = __importStar(require("vscode-languageserver"));
    var utils_1 = require_utils();
    var CompletionKind;
    (function(CompletionKind2) {
      CompletionKind2["attribute"] = "attribute";
      CompletionKind2["block"] = "block";
      CompletionKind2["htmlAttribute"] = "html attribute";
      CompletionKind2["property"] = "property";
      CompletionKind2["component"] = "component";
      CompletionKind2["directive"] = "directive";
      CompletionKind2["element"] = "element";
      CompletionKind2["event"] = "event";
      CompletionKind2["key"] = "key";
      CompletionKind2["method"] = "method";
      CompletionKind2["pipe"] = "pipe";
      CompletionKind2["type"] = "type";
      CompletionKind2["reference"] = "reference";
      CompletionKind2["variable"] = "variable";
      CompletionKind2["entity"] = "entity";
    })(CompletionKind || (CompletionKind = {}));
    function readNgCompletionData(item) {
      if (item.data === void 0) {
        return null;
      }
      const data = item.data;
      if (data.kind !== "ngCompletionOriginData") {
        return null;
      }
      return data;
    }
    exports2.readNgCompletionData = readNgCompletionData;
    function ngCompletionKindToLspCompletionItemKind(kind) {
      switch (kind) {
        case CompletionKind.attribute:
        case CompletionKind.htmlAttribute:
        case CompletionKind.property:
        case CompletionKind.event:
          return lsp.CompletionItemKind.Property;
        case CompletionKind.directive:
        case CompletionKind.component:
        case CompletionKind.element:
        case CompletionKind.key:
          return lsp.CompletionItemKind.Class;
        case CompletionKind.method:
          return lsp.CompletionItemKind.Method;
        case CompletionKind.pipe:
          return lsp.CompletionItemKind.Function;
        case CompletionKind.type:
          return lsp.CompletionItemKind.Interface;
        case CompletionKind.reference:
        case CompletionKind.variable:
          return lsp.CompletionItemKind.Variable;
        case CompletionKind.block:
          return lsp.CompletionItemKind.Keyword;
        case CompletionKind.entity:
        default:
          return lsp.CompletionItemKind.Text;
      }
    }
    function tsCompletionEntryToLspCompletionItem(entry, position, scriptInfo, insertReplaceSupport) {
      const item = lsp.CompletionItem.create(entry.name);
      const kind = entry.kind;
      item.kind = ngCompletionKindToLspCompletionItemKind(kind);
      item.detail = entry.kind;
      item.sortText = entry.sortText;
      const insertText = entry.insertText || entry.name;
      item.textEdit = createTextEdit(scriptInfo, entry, position, insertText, insertReplaceSupport);
      item.filterText = entry.insertText;
      if (entry.isSnippet) {
        item.insertTextFormat = lsp.InsertTextFormat.Snippet;
      }
      item.data = {
        kind: "ngCompletionOriginData",
        filePath: scriptInfo.fileName,
        position
      };
      return item;
    }
    exports2.tsCompletionEntryToLspCompletionItem = tsCompletionEntryToLspCompletionItem;
    function createTextEdit(scriptInfo, entry, position, insertText, insertReplaceSupport) {
      if (entry.replacementSpan === void 0) {
        return lsp.TextEdit.insert(position, insertText);
      } else if (insertReplaceSupport) {
        const replacementRange = (0, utils_1.tsTextSpanToLspRange)(scriptInfo, entry.replacementSpan);
        const tsPosition = (0, utils_1.lspPositionToTsPosition)(scriptInfo, position);
        const insertLength = tsPosition - entry.replacementSpan.start;
        const insertionRange = (0, utils_1.tsTextSpanToLspRange)(scriptInfo, Object.assign(Object.assign({}, entry.replacementSpan), { length: insertLength }));
        return lsp.InsertReplaceEdit.create(insertText, insertionRange, replacementRange);
      } else {
        return lsp.TextEdit.replace((0, utils_1.tsTextSpanToLspRange)(scriptInfo, entry.replacementSpan), insertText);
      }
    }
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/diagnostic.js
var require_diagnostic = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/server/src/diagnostic.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.tsDiagnosticToLspDiagnostic = void 0;
    var ts = __importStar(require("typescript/lib/tsserverlibrary"));
    var lsp = __importStar(require("vscode-languageserver"));
    var utils_1 = require_utils();
    function tsDiagnosticCategoryToLspDiagnosticSeverity(category) {
      switch (category) {
        case ts.DiagnosticCategory.Warning:
          return lsp.DiagnosticSeverity.Warning;
        case ts.DiagnosticCategory.Error:
          return lsp.DiagnosticSeverity.Error;
        case ts.DiagnosticCategory.Suggestion:
          return lsp.DiagnosticSeverity.Hint;
        case ts.DiagnosticCategory.Message:
        default:
          return lsp.DiagnosticSeverity.Information;
      }
    }
    function tsDiagnosticToLspDiagnostic(tsDiag, scriptInfo) {
      const textSpan = {
        start: tsDiag.start || 0,
        length: tsDiag.length || 0
      };
      return lsp.Diagnostic.create((0, utils_1.tsTextSpanToLspRange)(scriptInfo, textSpan), ts.flattenDiagnosticMessageText(tsDiag.messageText, "\n"), tsDiagnosticCategoryToLspDiagnosticSeverity(tsDiag.category), tsDiag.code, tsDiag.source, (0, utils_1.tsRelatedInformationToLspRelatedInformation)(scriptInfo, tsDiag.relatedInformation));
    }
    exports2.tsDiagnosticToLspDiagnostic = tsDiagnosticToLspDiagnostic;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/base64.js
var require_base64 = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/base64.js"(exports2) {
    var intToCharMap = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split("");
    exports2.encode = function(number) {
      if (0 <= number && number < intToCharMap.length) {
        return intToCharMap[number];
      }
      throw new TypeError("Must be between 0 and 63: " + number);
    };
    exports2.decode = function(charCode) {
      var bigA = 65;
      var bigZ = 90;
      var littleA = 97;
      var littleZ = 122;
      var zero = 48;
      var nine = 57;
      var plus = 43;
      var slash = 47;
      var littleOffset = 26;
      var numberOffset = 52;
      if (bigA <= charCode && charCode <= bigZ) {
        return charCode - bigA;
      }
      if (littleA <= charCode && charCode <= littleZ) {
        return charCode - littleA + littleOffset;
      }
      if (zero <= charCode && charCode <= nine) {
        return charCode - zero + numberOffset;
      }
      if (charCode == plus) {
        return 62;
      }
      if (charCode == slash) {
        return 63;
      }
      return -1;
    };
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/base64-vlq.js
var require_base64_vlq = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/base64-vlq.js"(exports2) {
    var base64 = require_base64();
    var VLQ_BASE_SHIFT = 5;
    var VLQ_BASE = 1 << VLQ_BASE_SHIFT;
    var VLQ_BASE_MASK = VLQ_BASE - 1;
    var VLQ_CONTINUATION_BIT = VLQ_BASE;
    function toVLQSigned(aValue) {
      return aValue < 0 ? (-aValue << 1) + 1 : (aValue << 1) + 0;
    }
    function fromVLQSigned(aValue) {
      var isNegative = (aValue & 1) === 1;
      var shifted = aValue >> 1;
      return isNegative ? -shifted : shifted;
    }
    exports2.encode = function base64VLQ_encode(aValue) {
      var encoded = "";
      var digit;
      var vlq = toVLQSigned(aValue);
      do {
        digit = vlq & VLQ_BASE_MASK;
        vlq >>>= VLQ_BASE_SHIFT;
        if (vlq > 0) {
          digit |= VLQ_CONTINUATION_BIT;
        }
        encoded += base64.encode(digit);
      } while (vlq > 0);
      return encoded;
    };
    exports2.decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
      var strLen = aStr.length;
      var result = 0;
      var shift = 0;
      var continuation, digit;
      do {
        if (aIndex >= strLen) {
          throw new Error("Expected more digits in base 64 VLQ value.");
        }
        digit = base64.decode(aStr.charCodeAt(aIndex++));
        if (digit === -1) {
          throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
        }
        continuation = !!(digit & VLQ_CONTINUATION_BIT);
        digit &= VLQ_BASE_MASK;
        result = result + (digit << shift);
        shift += VLQ_BASE_SHIFT;
      } while (continuation);
      aOutParam.value = fromVLQSigned(result);
      aOutParam.rest = aIndex;
    };
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/util.js
var require_util = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/util.js"(exports2) {
    function getArg(aArgs, aName, aDefaultValue) {
      if (aName in aArgs) {
        return aArgs[aName];
      } else if (arguments.length === 3) {
        return aDefaultValue;
      } else {
        throw new Error('"' + aName + '" is a required argument.');
      }
    }
    exports2.getArg = getArg;
    var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
    var dataUrlRegexp = /^data:.+\,.+$/;
    function urlParse(aUrl) {
      var match = aUrl.match(urlRegexp);
      if (!match) {
        return null;
      }
      return {
        scheme: match[1],
        auth: match[2],
        host: match[3],
        port: match[4],
        path: match[5]
      };
    }
    exports2.urlParse = urlParse;
    function urlGenerate(aParsedUrl) {
      var url = "";
      if (aParsedUrl.scheme) {
        url += aParsedUrl.scheme + ":";
      }
      url += "//";
      if (aParsedUrl.auth) {
        url += aParsedUrl.auth + "@";
      }
      if (aParsedUrl.host) {
        url += aParsedUrl.host;
      }
      if (aParsedUrl.port) {
        url += ":" + aParsedUrl.port;
      }
      if (aParsedUrl.path) {
        url += aParsedUrl.path;
      }
      return url;
    }
    exports2.urlGenerate = urlGenerate;
    function normalize(aPath) {
      var path = aPath;
      var url = urlParse(aPath);
      if (url) {
        if (!url.path) {
          return aPath;
        }
        path = url.path;
      }
      var isAbsolute = exports2.isAbsolute(path);
      var parts = path.split(/\/+/);
      for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
        part = parts[i];
        if (part === ".") {
          parts.splice(i, 1);
        } else if (part === "..") {
          up++;
        } else if (up > 0) {
          if (part === "") {
            parts.splice(i + 1, up);
            up = 0;
          } else {
            parts.splice(i, 2);
            up--;
          }
        }
      }
      path = parts.join("/");
      if (path === "") {
        path = isAbsolute ? "/" : ".";
      }
      if (url) {
        url.path = path;
        return urlGenerate(url);
      }
      return path;
    }
    exports2.normalize = normalize;
    function join(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      if (aPath === "") {
        aPath = ".";
      }
      var aPathUrl = urlParse(aPath);
      var aRootUrl = urlParse(aRoot);
      if (aRootUrl) {
        aRoot = aRootUrl.path || "/";
      }
      if (aPathUrl && !aPathUrl.scheme) {
        if (aRootUrl) {
          aPathUrl.scheme = aRootUrl.scheme;
        }
        return urlGenerate(aPathUrl);
      }
      if (aPathUrl || aPath.match(dataUrlRegexp)) {
        return aPath;
      }
      if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
        aRootUrl.host = aPath;
        return urlGenerate(aRootUrl);
      }
      var joined = aPath.charAt(0) === "/" ? aPath : normalize(aRoot.replace(/\/+$/, "") + "/" + aPath);
      if (aRootUrl) {
        aRootUrl.path = joined;
        return urlGenerate(aRootUrl);
      }
      return joined;
    }
    exports2.join = join;
    exports2.isAbsolute = function(aPath) {
      return aPath.charAt(0) === "/" || urlRegexp.test(aPath);
    };
    function relative(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      aRoot = aRoot.replace(/\/$/, "");
      var level = 0;
      while (aPath.indexOf(aRoot + "/") !== 0) {
        var index = aRoot.lastIndexOf("/");
        if (index < 0) {
          return aPath;
        }
        aRoot = aRoot.slice(0, index);
        if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
          return aPath;
        }
        ++level;
      }
      return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
    }
    exports2.relative = relative;
    var supportsNullProto = function() {
      var obj = /* @__PURE__ */ Object.create(null);
      return !("__proto__" in obj);
    }();
    function identity(s) {
      return s;
    }
    function toSetString(aStr) {
      if (isProtoString(aStr)) {
        return "$" + aStr;
      }
      return aStr;
    }
    exports2.toSetString = supportsNullProto ? identity : toSetString;
    function fromSetString(aStr) {
      if (isProtoString(aStr)) {
        return aStr.slice(1);
      }
      return aStr;
    }
    exports2.fromSetString = supportsNullProto ? identity : fromSetString;
    function isProtoString(s) {
      if (!s) {
        return false;
      }
      var length = s.length;
      if (length < 9) {
        return false;
      }
      if (s.charCodeAt(length - 1) !== 95 || s.charCodeAt(length - 2) !== 95 || s.charCodeAt(length - 3) !== 111 || s.charCodeAt(length - 4) !== 116 || s.charCodeAt(length - 5) !== 111 || s.charCodeAt(length - 6) !== 114 || s.charCodeAt(length - 7) !== 112 || s.charCodeAt(length - 8) !== 95 || s.charCodeAt(length - 9) !== 95) {
        return false;
      }
      for (var i = length - 10; i >= 0; i--) {
        if (s.charCodeAt(i) !== 36) {
          return false;
        }
      }
      return true;
    }
    function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
      var cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0 || onlyCompareOriginal) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByOriginalPositions = compareByOriginalPositions;
    function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0 || onlyCompareGenerated) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;
    function strcmp(aStr1, aStr2) {
      if (aStr1 === aStr2) {
        return 0;
      }
      if (aStr1 === null) {
        return 1;
      }
      if (aStr2 === null) {
        return -1;
      }
      if (aStr1 > aStr2) {
        return 1;
      }
      return -1;
    }
    function compareByGeneratedPositionsInflated(mappingA, mappingB) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;
    function parseSourceMapInput(str) {
      return JSON.parse(str.replace(/^\)]}'[^\n]*\n/, ""));
    }
    exports2.parseSourceMapInput = parseSourceMapInput;
    function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
      sourceURL = sourceURL || "";
      if (sourceRoot) {
        if (sourceRoot[sourceRoot.length - 1] !== "/" && sourceURL[0] !== "/") {
          sourceRoot += "/";
        }
        sourceURL = sourceRoot + sourceURL;
      }
      if (sourceMapURL) {
        var parsed = urlParse(sourceMapURL);
        if (!parsed) {
          throw new Error("sourceMapURL could not be parsed");
        }
        if (parsed.path) {
          var index = parsed.path.lastIndexOf("/");
          if (index >= 0) {
            parsed.path = parsed.path.substring(0, index + 1);
          }
        }
        sourceURL = join(urlGenerate(parsed), sourceURL);
      }
      return normalize(sourceURL);
    }
    exports2.computeSourceURL = computeSourceURL;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/array-set.js
var require_array_set = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/array-set.js"(exports2) {
    var util = require_util();
    var has = Object.prototype.hasOwnProperty;
    var hasNativeMap = typeof Map !== "undefined";
    function ArraySet() {
      this._array = [];
      this._set = hasNativeMap ? /* @__PURE__ */ new Map() : /* @__PURE__ */ Object.create(null);
    }
    ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
      var set = new ArraySet();
      for (var i = 0, len = aArray.length; i < len; i++) {
        set.add(aArray[i], aAllowDuplicates);
      }
      return set;
    };
    ArraySet.prototype.size = function ArraySet_size() {
      return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
    };
    ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
      var sStr = hasNativeMap ? aStr : util.toSetString(aStr);
      var isDuplicate = hasNativeMap ? this.has(aStr) : has.call(this._set, sStr);
      var idx = this._array.length;
      if (!isDuplicate || aAllowDuplicates) {
        this._array.push(aStr);
      }
      if (!isDuplicate) {
        if (hasNativeMap) {
          this._set.set(aStr, idx);
        } else {
          this._set[sStr] = idx;
        }
      }
    };
    ArraySet.prototype.has = function ArraySet_has(aStr) {
      if (hasNativeMap) {
        return this._set.has(aStr);
      } else {
        var sStr = util.toSetString(aStr);
        return has.call(this._set, sStr);
      }
    };
    ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
      if (hasNativeMap) {
        var idx = this._set.get(aStr);
        if (idx >= 0) {
          return idx;
        }
      } else {
        var sStr = util.toSetString(aStr);
        if (has.call(this._set, sStr)) {
          return this._set[sStr];
        }
      }
      throw new Error('"' + aStr + '" is not in the set.');
    };
    ArraySet.prototype.at = function ArraySet_at(aIdx) {
      if (aIdx >= 0 && aIdx < this._array.length) {
        return this._array[aIdx];
      }
      throw new Error("No element indexed by " + aIdx);
    };
    ArraySet.prototype.toArray = function ArraySet_toArray() {
      return this._array.slice();
    };
    exports2.ArraySet = ArraySet;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/mapping-list.js
var require_mapping_list = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/mapping-list.js"(exports2) {
    var util = require_util();
    function generatedPositionAfter(mappingA, mappingB) {
      var lineA = mappingA.generatedLine;
      var lineB = mappingB.generatedLine;
      var columnA = mappingA.generatedColumn;
      var columnB = mappingB.generatedColumn;
      return lineB > lineA || lineB == lineA && columnB >= columnA || util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
    }
    function MappingList() {
      this._array = [];
      this._sorted = true;
      this._last = { generatedLine: -1, generatedColumn: 0 };
    }
    MappingList.prototype.unsortedForEach = function MappingList_forEach(aCallback, aThisArg) {
      this._array.forEach(aCallback, aThisArg);
    };
    MappingList.prototype.add = function MappingList_add(aMapping) {
      if (generatedPositionAfter(this._last, aMapping)) {
        this._last = aMapping;
        this._array.push(aMapping);
      } else {
        this._sorted = false;
        this._array.push(aMapping);
      }
    };
    MappingList.prototype.toArray = function MappingList_toArray() {
      if (!this._sorted) {
        this._array.sort(util.compareByGeneratedPositionsInflated);
        this._sorted = true;
      }
      return this._array;
    };
    exports2.MappingList = MappingList;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/source-map-generator.js
var require_source_map_generator = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/source-map-generator.js"(exports2) {
    var base64VLQ = require_base64_vlq();
    var util = require_util();
    var ArraySet = require_array_set().ArraySet;
    var MappingList = require_mapping_list().MappingList;
    function SourceMapGenerator(aArgs) {
      if (!aArgs) {
        aArgs = {};
      }
      this._file = util.getArg(aArgs, "file", null);
      this._sourceRoot = util.getArg(aArgs, "sourceRoot", null);
      this._skipValidation = util.getArg(aArgs, "skipValidation", false);
      this._sources = new ArraySet();
      this._names = new ArraySet();
      this._mappings = new MappingList();
      this._sourcesContents = null;
    }
    SourceMapGenerator.prototype._version = 3;
    SourceMapGenerator.fromSourceMap = function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
      var sourceRoot = aSourceMapConsumer.sourceRoot;
      var generator = new SourceMapGenerator({
        file: aSourceMapConsumer.file,
        sourceRoot
      });
      aSourceMapConsumer.eachMapping(function(mapping) {
        var newMapping = {
          generated: {
            line: mapping.generatedLine,
            column: mapping.generatedColumn
          }
        };
        if (mapping.source != null) {
          newMapping.source = mapping.source;
          if (sourceRoot != null) {
            newMapping.source = util.relative(sourceRoot, newMapping.source);
          }
          newMapping.original = {
            line: mapping.originalLine,
            column: mapping.originalColumn
          };
          if (mapping.name != null) {
            newMapping.name = mapping.name;
          }
        }
        generator.addMapping(newMapping);
      });
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var sourceRelative = sourceFile;
        if (sourceRoot !== null) {
          sourceRelative = util.relative(sourceRoot, sourceFile);
        }
        if (!generator._sources.has(sourceRelative)) {
          generator._sources.add(sourceRelative);
        }
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          generator.setSourceContent(sourceFile, content);
        }
      });
      return generator;
    };
    SourceMapGenerator.prototype.addMapping = function SourceMapGenerator_addMapping(aArgs) {
      var generated = util.getArg(aArgs, "generated");
      var original = util.getArg(aArgs, "original", null);
      var source = util.getArg(aArgs, "source", null);
      var name = util.getArg(aArgs, "name", null);
      if (!this._skipValidation) {
        this._validateMapping(generated, original, source, name);
      }
      if (source != null) {
        source = String(source);
        if (!this._sources.has(source)) {
          this._sources.add(source);
        }
      }
      if (name != null) {
        name = String(name);
        if (!this._names.has(name)) {
          this._names.add(name);
        }
      }
      this._mappings.add({
        generatedLine: generated.line,
        generatedColumn: generated.column,
        originalLine: original != null && original.line,
        originalColumn: original != null && original.column,
        source,
        name
      });
    };
    SourceMapGenerator.prototype.setSourceContent = function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
      var source = aSourceFile;
      if (this._sourceRoot != null) {
        source = util.relative(this._sourceRoot, source);
      }
      if (aSourceContent != null) {
        if (!this._sourcesContents) {
          this._sourcesContents = /* @__PURE__ */ Object.create(null);
        }
        this._sourcesContents[util.toSetString(source)] = aSourceContent;
      } else if (this._sourcesContents) {
        delete this._sourcesContents[util.toSetString(source)];
        if (Object.keys(this._sourcesContents).length === 0) {
          this._sourcesContents = null;
        }
      }
    };
    SourceMapGenerator.prototype.applySourceMap = function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
      var sourceFile = aSourceFile;
      if (aSourceFile == null) {
        if (aSourceMapConsumer.file == null) {
          throw new Error(
            `SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map's "file" property. Both were omitted.`
          );
        }
        sourceFile = aSourceMapConsumer.file;
      }
      var sourceRoot = this._sourceRoot;
      if (sourceRoot != null) {
        sourceFile = util.relative(sourceRoot, sourceFile);
      }
      var newSources = new ArraySet();
      var newNames = new ArraySet();
      this._mappings.unsortedForEach(function(mapping) {
        if (mapping.source === sourceFile && mapping.originalLine != null) {
          var original = aSourceMapConsumer.originalPositionFor({
            line: mapping.originalLine,
            column: mapping.originalColumn
          });
          if (original.source != null) {
            mapping.source = original.source;
            if (aSourceMapPath != null) {
              mapping.source = util.join(aSourceMapPath, mapping.source);
            }
            if (sourceRoot != null) {
              mapping.source = util.relative(sourceRoot, mapping.source);
            }
            mapping.originalLine = original.line;
            mapping.originalColumn = original.column;
            if (original.name != null) {
              mapping.name = original.name;
            }
          }
        }
        var source = mapping.source;
        if (source != null && !newSources.has(source)) {
          newSources.add(source);
        }
        var name = mapping.name;
        if (name != null && !newNames.has(name)) {
          newNames.add(name);
        }
      }, this);
      this._sources = newSources;
      this._names = newNames;
      aSourceMapConsumer.sources.forEach(function(sourceFile2) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile2);
        if (content != null) {
          if (aSourceMapPath != null) {
            sourceFile2 = util.join(aSourceMapPath, sourceFile2);
          }
          if (sourceRoot != null) {
            sourceFile2 = util.relative(sourceRoot, sourceFile2);
          }
          this.setSourceContent(sourceFile2, content);
        }
      }, this);
    };
    SourceMapGenerator.prototype._validateMapping = function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource, aName) {
      if (aOriginal && typeof aOriginal.line !== "number" && typeof aOriginal.column !== "number") {
        throw new Error(
          "original.line and original.column are not numbers -- you probably meant to omit the original mapping entirely and only map the generated position. If so, pass null for the original mapping instead of an object with empty or null values."
        );
      }
      if (aGenerated && "line" in aGenerated && "column" in aGenerated && aGenerated.line > 0 && aGenerated.column >= 0 && !aOriginal && !aSource && !aName) {
        return;
      } else if (aGenerated && "line" in aGenerated && "column" in aGenerated && aOriginal && "line" in aOriginal && "column" in aOriginal && aGenerated.line > 0 && aGenerated.column >= 0 && aOriginal.line > 0 && aOriginal.column >= 0 && aSource) {
        return;
      } else {
        throw new Error("Invalid mapping: " + JSON.stringify({
          generated: aGenerated,
          source: aSource,
          original: aOriginal,
          name: aName
        }));
      }
    };
    SourceMapGenerator.prototype._serializeMappings = function SourceMapGenerator_serializeMappings() {
      var previousGeneratedColumn = 0;
      var previousGeneratedLine = 1;
      var previousOriginalColumn = 0;
      var previousOriginalLine = 0;
      var previousName = 0;
      var previousSource = 0;
      var result = "";
      var next;
      var mapping;
      var nameIdx;
      var sourceIdx;
      var mappings = this._mappings.toArray();
      for (var i = 0, len = mappings.length; i < len; i++) {
        mapping = mappings[i];
        next = "";
        if (mapping.generatedLine !== previousGeneratedLine) {
          previousGeneratedColumn = 0;
          while (mapping.generatedLine !== previousGeneratedLine) {
            next += ";";
            previousGeneratedLine++;
          }
        } else {
          if (i > 0) {
            if (!util.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
              continue;
            }
            next += ",";
          }
        }
        next += base64VLQ.encode(mapping.generatedColumn - previousGeneratedColumn);
        previousGeneratedColumn = mapping.generatedColumn;
        if (mapping.source != null) {
          sourceIdx = this._sources.indexOf(mapping.source);
          next += base64VLQ.encode(sourceIdx - previousSource);
          previousSource = sourceIdx;
          next += base64VLQ.encode(mapping.originalLine - 1 - previousOriginalLine);
          previousOriginalLine = mapping.originalLine - 1;
          next += base64VLQ.encode(mapping.originalColumn - previousOriginalColumn);
          previousOriginalColumn = mapping.originalColumn;
          if (mapping.name != null) {
            nameIdx = this._names.indexOf(mapping.name);
            next += base64VLQ.encode(nameIdx - previousName);
            previousName = nameIdx;
          }
        }
        result += next;
      }
      return result;
    };
    SourceMapGenerator.prototype._generateSourcesContent = function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
      return aSources.map(function(source) {
        if (!this._sourcesContents) {
          return null;
        }
        if (aSourceRoot != null) {
          source = util.relative(aSourceRoot, source);
        }
        var key = util.toSetString(source);
        return Object.prototype.hasOwnProperty.call(this._sourcesContents, key) ? this._sourcesContents[key] : null;
      }, this);
    };
    SourceMapGenerator.prototype.toJSON = function SourceMapGenerator_toJSON() {
      var map = {
        version: this._version,
        sources: this._sources.toArray(),
        names: this._names.toArray(),
        mappings: this._serializeMappings()
      };
      if (this._file != null) {
        map.file = this._file;
      }
      if (this._sourceRoot != null) {
        map.sourceRoot = this._sourceRoot;
      }
      if (this._sourcesContents) {
        map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
      }
      return map;
    };
    SourceMapGenerator.prototype.toString = function SourceMapGenerator_toString() {
      return JSON.stringify(this.toJSON());
    };
    exports2.SourceMapGenerator = SourceMapGenerator;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/binary-search.js
var require_binary_search = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/binary-search.js"(exports2) {
    exports2.GREATEST_LOWER_BOUND = 1;
    exports2.LEAST_UPPER_BOUND = 2;
    function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
      var mid = Math.floor((aHigh - aLow) / 2) + aLow;
      var cmp = aCompare(aNeedle, aHaystack[mid], true);
      if (cmp === 0) {
        return mid;
      } else if (cmp > 0) {
        if (aHigh - mid > 1) {
          return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports2.LEAST_UPPER_BOUND) {
          return aHigh < aHaystack.length ? aHigh : -1;
        } else {
          return mid;
        }
      } else {
        if (mid - aLow > 1) {
          return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports2.LEAST_UPPER_BOUND) {
          return mid;
        } else {
          return aLow < 0 ? -1 : aLow;
        }
      }
    }
    exports2.search = function search(aNeedle, aHaystack, aCompare, aBias) {
      if (aHaystack.length === 0) {
        return -1;
      }
      var index = recursiveSearch(
        -1,
        aHaystack.length,
        aNeedle,
        aHaystack,
        aCompare,
        aBias || exports2.GREATEST_LOWER_BOUND
      );
      if (index < 0) {
        return -1;
      }
      while (index - 1 >= 0) {
        if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
          break;
        }
        --index;
      }
      return index;
    };
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/quick-sort.js
var require_quick_sort = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/quick-sort.js"(exports2) {
    function swap(ary, x, y) {
      var temp = ary[x];
      ary[x] = ary[y];
      ary[y] = temp;
    }
    function randomIntInRange(low, high) {
      return Math.round(low + Math.random() * (high - low));
    }
    function doQuickSort(ary, comparator, p, r) {
      if (p < r) {
        var pivotIndex = randomIntInRange(p, r);
        var i = p - 1;
        swap(ary, pivotIndex, r);
        var pivot = ary[r];
        for (var j = p; j < r; j++) {
          if (comparator(ary[j], pivot) <= 0) {
            i += 1;
            swap(ary, i, j);
          }
        }
        swap(ary, i + 1, j);
        var q = i + 1;
        doQuickSort(ary, comparator, p, q - 1);
        doQuickSort(ary, comparator, q + 1, r);
      }
    }
    exports2.quickSort = function(ary, comparator) {
      doQuickSort(ary, comparator, 0, ary.length - 1);
    };
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/source-map-consumer.js
var require_source_map_consumer = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/source-map-consumer.js"(exports2) {
    var util = require_util();
    var binarySearch = require_binary_search();
    var ArraySet = require_array_set().ArraySet;
    var base64VLQ = require_base64_vlq();
    var quickSort = require_quick_sort().quickSort;
    function SourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      return sourceMap.sections != null ? new IndexedSourceMapConsumer(sourceMap, aSourceMapURL) : new BasicSourceMapConsumer(sourceMap, aSourceMapURL);
    }
    SourceMapConsumer.fromSourceMap = function(aSourceMap, aSourceMapURL) {
      return BasicSourceMapConsumer.fromSourceMap(aSourceMap, aSourceMapURL);
    };
    SourceMapConsumer.prototype._version = 3;
    SourceMapConsumer.prototype.__generatedMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, "_generatedMappings", {
      configurable: true,
      enumerable: true,
      get: function() {
        if (!this.__generatedMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__generatedMappings;
      }
    });
    SourceMapConsumer.prototype.__originalMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, "_originalMappings", {
      configurable: true,
      enumerable: true,
      get: function() {
        if (!this.__originalMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__originalMappings;
      }
    });
    SourceMapConsumer.prototype._charIsMappingSeparator = function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
      var c = aStr.charAt(index);
      return c === ";" || c === ",";
    };
    SourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      throw new Error("Subclasses must implement _parseMappings");
    };
    SourceMapConsumer.GENERATED_ORDER = 1;
    SourceMapConsumer.ORIGINAL_ORDER = 2;
    SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
    SourceMapConsumer.LEAST_UPPER_BOUND = 2;
    SourceMapConsumer.prototype.eachMapping = function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
      var context = aContext || null;
      var order = aOrder || SourceMapConsumer.GENERATED_ORDER;
      var mappings;
      switch (order) {
        case SourceMapConsumer.GENERATED_ORDER:
          mappings = this._generatedMappings;
          break;
        case SourceMapConsumer.ORIGINAL_ORDER:
          mappings = this._originalMappings;
          break;
        default:
          throw new Error("Unknown order of iteration.");
      }
      var sourceRoot = this.sourceRoot;
      mappings.map(function(mapping) {
        var source = mapping.source === null ? null : this._sources.at(mapping.source);
        source = util.computeSourceURL(sourceRoot, source, this._sourceMapURL);
        return {
          source,
          generatedLine: mapping.generatedLine,
          generatedColumn: mapping.generatedColumn,
          originalLine: mapping.originalLine,
          originalColumn: mapping.originalColumn,
          name: mapping.name === null ? null : this._names.at(mapping.name)
        };
      }, this).forEach(aCallback, context);
    };
    SourceMapConsumer.prototype.allGeneratedPositionsFor = function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
      var line = util.getArg(aArgs, "line");
      var needle = {
        source: util.getArg(aArgs, "source"),
        originalLine: line,
        originalColumn: util.getArg(aArgs, "column", 0)
      };
      needle.source = this._findSourceIndex(needle.source);
      if (needle.source < 0) {
        return [];
      }
      var mappings = [];
      var index = this._findMapping(
        needle,
        this._originalMappings,
        "originalLine",
        "originalColumn",
        util.compareByOriginalPositions,
        binarySearch.LEAST_UPPER_BOUND
      );
      if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (aArgs.column === void 0) {
          var originalLine = mapping.originalLine;
          while (mapping && mapping.originalLine === originalLine) {
            mappings.push({
              line: util.getArg(mapping, "generatedLine", null),
              column: util.getArg(mapping, "generatedColumn", null),
              lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
            });
            mapping = this._originalMappings[++index];
          }
        } else {
          var originalColumn = mapping.originalColumn;
          while (mapping && mapping.originalLine === line && mapping.originalColumn == originalColumn) {
            mappings.push({
              line: util.getArg(mapping, "generatedLine", null),
              column: util.getArg(mapping, "generatedColumn", null),
              lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
            });
            mapping = this._originalMappings[++index];
          }
        }
      }
      return mappings;
    };
    exports2.SourceMapConsumer = SourceMapConsumer;
    function BasicSourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      var version = util.getArg(sourceMap, "version");
      var sources = util.getArg(sourceMap, "sources");
      var names = util.getArg(sourceMap, "names", []);
      var sourceRoot = util.getArg(sourceMap, "sourceRoot", null);
      var sourcesContent = util.getArg(sourceMap, "sourcesContent", null);
      var mappings = util.getArg(sourceMap, "mappings");
      var file = util.getArg(sourceMap, "file", null);
      if (version != this._version) {
        throw new Error("Unsupported version: " + version);
      }
      if (sourceRoot) {
        sourceRoot = util.normalize(sourceRoot);
      }
      sources = sources.map(String).map(util.normalize).map(function(source) {
        return sourceRoot && util.isAbsolute(sourceRoot) && util.isAbsolute(source) ? util.relative(sourceRoot, source) : source;
      });
      this._names = ArraySet.fromArray(names.map(String), true);
      this._sources = ArraySet.fromArray(sources, true);
      this._absoluteSources = this._sources.toArray().map(function(s) {
        return util.computeSourceURL(sourceRoot, s, aSourceMapURL);
      });
      this.sourceRoot = sourceRoot;
      this.sourcesContent = sourcesContent;
      this._mappings = mappings;
      this._sourceMapURL = aSourceMapURL;
      this.file = file;
    }
    BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
    BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;
    BasicSourceMapConsumer.prototype._findSourceIndex = function(aSource) {
      var relativeSource = aSource;
      if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
      }
      if (this._sources.has(relativeSource)) {
        return this._sources.indexOf(relativeSource);
      }
      var i;
      for (i = 0; i < this._absoluteSources.length; ++i) {
        if (this._absoluteSources[i] == aSource) {
          return i;
        }
      }
      return -1;
    };
    BasicSourceMapConsumer.fromSourceMap = function SourceMapConsumer_fromSourceMap(aSourceMap, aSourceMapURL) {
      var smc = Object.create(BasicSourceMapConsumer.prototype);
      var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
      var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
      smc.sourceRoot = aSourceMap._sourceRoot;
      smc.sourcesContent = aSourceMap._generateSourcesContent(
        smc._sources.toArray(),
        smc.sourceRoot
      );
      smc.file = aSourceMap._file;
      smc._sourceMapURL = aSourceMapURL;
      smc._absoluteSources = smc._sources.toArray().map(function(s) {
        return util.computeSourceURL(smc.sourceRoot, s, aSourceMapURL);
      });
      var generatedMappings = aSourceMap._mappings.toArray().slice();
      var destGeneratedMappings = smc.__generatedMappings = [];
      var destOriginalMappings = smc.__originalMappings = [];
      for (var i = 0, length = generatedMappings.length; i < length; i++) {
        var srcMapping = generatedMappings[i];
        var destMapping = new Mapping();
        destMapping.generatedLine = srcMapping.generatedLine;
        destMapping.generatedColumn = srcMapping.generatedColumn;
        if (srcMapping.source) {
          destMapping.source = sources.indexOf(srcMapping.source);
          destMapping.originalLine = srcMapping.originalLine;
          destMapping.originalColumn = srcMapping.originalColumn;
          if (srcMapping.name) {
            destMapping.name = names.indexOf(srcMapping.name);
          }
          destOriginalMappings.push(destMapping);
        }
        destGeneratedMappings.push(destMapping);
      }
      quickSort(smc.__originalMappings, util.compareByOriginalPositions);
      return smc;
    };
    BasicSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(BasicSourceMapConsumer.prototype, "sources", {
      get: function() {
        return this._absoluteSources.slice();
      }
    });
    function Mapping() {
      this.generatedLine = 0;
      this.generatedColumn = 0;
      this.source = null;
      this.originalLine = null;
      this.originalColumn = null;
      this.name = null;
    }
    BasicSourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      var generatedLine = 1;
      var previousGeneratedColumn = 0;
      var previousOriginalLine = 0;
      var previousOriginalColumn = 0;
      var previousSource = 0;
      var previousName = 0;
      var length = aStr.length;
      var index = 0;
      var cachedSegments = {};
      var temp = {};
      var originalMappings = [];
      var generatedMappings = [];
      var mapping, str, segment, end, value;
      while (index < length) {
        if (aStr.charAt(index) === ";") {
          generatedLine++;
          index++;
          previousGeneratedColumn = 0;
        } else if (aStr.charAt(index) === ",") {
          index++;
        } else {
          mapping = new Mapping();
          mapping.generatedLine = generatedLine;
          for (end = index; end < length; end++) {
            if (this._charIsMappingSeparator(aStr, end)) {
              break;
            }
          }
          str = aStr.slice(index, end);
          segment = cachedSegments[str];
          if (segment) {
            index += str.length;
          } else {
            segment = [];
            while (index < end) {
              base64VLQ.decode(aStr, index, temp);
              value = temp.value;
              index = temp.rest;
              segment.push(value);
            }
            if (segment.length === 2) {
              throw new Error("Found a source, but no line and column");
            }
            if (segment.length === 3) {
              throw new Error("Found a source and line, but no column");
            }
            cachedSegments[str] = segment;
          }
          mapping.generatedColumn = previousGeneratedColumn + segment[0];
          previousGeneratedColumn = mapping.generatedColumn;
          if (segment.length > 1) {
            mapping.source = previousSource + segment[1];
            previousSource += segment[1];
            mapping.originalLine = previousOriginalLine + segment[2];
            previousOriginalLine = mapping.originalLine;
            mapping.originalLine += 1;
            mapping.originalColumn = previousOriginalColumn + segment[3];
            previousOriginalColumn = mapping.originalColumn;
            if (segment.length > 4) {
              mapping.name = previousName + segment[4];
              previousName += segment[4];
            }
          }
          generatedMappings.push(mapping);
          if (typeof mapping.originalLine === "number") {
            originalMappings.push(mapping);
          }
        }
      }
      quickSort(generatedMappings, util.compareByGeneratedPositionsDeflated);
      this.__generatedMappings = generatedMappings;
      quickSort(originalMappings, util.compareByOriginalPositions);
      this.__originalMappings = originalMappings;
    };
    BasicSourceMapConsumer.prototype._findMapping = function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName, aColumnName, aComparator, aBias) {
      if (aNeedle[aLineName] <= 0) {
        throw new TypeError("Line must be greater than or equal to 1, got " + aNeedle[aLineName]);
      }
      if (aNeedle[aColumnName] < 0) {
        throw new TypeError("Column must be greater than or equal to 0, got " + aNeedle[aColumnName]);
      }
      return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
    };
    BasicSourceMapConsumer.prototype.computeColumnSpans = function SourceMapConsumer_computeColumnSpans() {
      for (var index = 0; index < this._generatedMappings.length; ++index) {
        var mapping = this._generatedMappings[index];
        if (index + 1 < this._generatedMappings.length) {
          var nextMapping = this._generatedMappings[index + 1];
          if (mapping.generatedLine === nextMapping.generatedLine) {
            mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
            continue;
          }
        }
        mapping.lastGeneratedColumn = Infinity;
      }
    };
    BasicSourceMapConsumer.prototype.originalPositionFor = function SourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, "line"),
        generatedColumn: util.getArg(aArgs, "column")
      };
      var index = this._findMapping(
        needle,
        this._generatedMappings,
        "generatedLine",
        "generatedColumn",
        util.compareByGeneratedPositionsDeflated,
        util.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND)
      );
      if (index >= 0) {
        var mapping = this._generatedMappings[index];
        if (mapping.generatedLine === needle.generatedLine) {
          var source = util.getArg(mapping, "source", null);
          if (source !== null) {
            source = this._sources.at(source);
            source = util.computeSourceURL(this.sourceRoot, source, this._sourceMapURL);
          }
          var name = util.getArg(mapping, "name", null);
          if (name !== null) {
            name = this._names.at(name);
          }
          return {
            source,
            line: util.getArg(mapping, "originalLine", null),
            column: util.getArg(mapping, "originalColumn", null),
            name
          };
        }
      }
      return {
        source: null,
        line: null,
        column: null,
        name: null
      };
    };
    BasicSourceMapConsumer.prototype.hasContentsOfAllSources = function BasicSourceMapConsumer_hasContentsOfAllSources() {
      if (!this.sourcesContent) {
        return false;
      }
      return this.sourcesContent.length >= this._sources.size() && !this.sourcesContent.some(function(sc) {
        return sc == null;
      });
    };
    BasicSourceMapConsumer.prototype.sourceContentFor = function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      if (!this.sourcesContent) {
        return null;
      }
      var index = this._findSourceIndex(aSource);
      if (index >= 0) {
        return this.sourcesContent[index];
      }
      var relativeSource = aSource;
      if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
      }
      var url;
      if (this.sourceRoot != null && (url = util.urlParse(this.sourceRoot))) {
        var fileUriAbsPath = relativeSource.replace(/^file:\/\//, "");
        if (url.scheme == "file" && this._sources.has(fileUriAbsPath)) {
          return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)];
        }
        if ((!url.path || url.path == "/") && this._sources.has("/" + relativeSource)) {
          return this.sourcesContent[this._sources.indexOf("/" + relativeSource)];
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + relativeSource + '" is not in the SourceMap.');
      }
    };
    BasicSourceMapConsumer.prototype.generatedPositionFor = function SourceMapConsumer_generatedPositionFor(aArgs) {
      var source = util.getArg(aArgs, "source");
      source = this._findSourceIndex(source);
      if (source < 0) {
        return {
          line: null,
          column: null,
          lastColumn: null
        };
      }
      var needle = {
        source,
        originalLine: util.getArg(aArgs, "line"),
        originalColumn: util.getArg(aArgs, "column")
      };
      var index = this._findMapping(
        needle,
        this._originalMappings,
        "originalLine",
        "originalColumn",
        util.compareByOriginalPositions,
        util.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND)
      );
      if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (mapping.source === needle.source) {
          return {
            line: util.getArg(mapping, "generatedLine", null),
            column: util.getArg(mapping, "generatedColumn", null),
            lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
          };
        }
      }
      return {
        line: null,
        column: null,
        lastColumn: null
      };
    };
    exports2.BasicSourceMapConsumer = BasicSourceMapConsumer;
    function IndexedSourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      var version = util.getArg(sourceMap, "version");
      var sections = util.getArg(sourceMap, "sections");
      if (version != this._version) {
        throw new Error("Unsupported version: " + version);
      }
      this._sources = new ArraySet();
      this._names = new ArraySet();
      var lastOffset = {
        line: -1,
        column: 0
      };
      this._sections = sections.map(function(s) {
        if (s.url) {
          throw new Error("Support for url field in sections not implemented.");
        }
        var offset = util.getArg(s, "offset");
        var offsetLine = util.getArg(offset, "line");
        var offsetColumn = util.getArg(offset, "column");
        if (offsetLine < lastOffset.line || offsetLine === lastOffset.line && offsetColumn < lastOffset.column) {
          throw new Error("Section offsets must be ordered and non-overlapping.");
        }
        lastOffset = offset;
        return {
          generatedOffset: {
            // The offset fields are 0-based, but we use 1-based indices when
            // encoding/decoding from VLQ.
            generatedLine: offsetLine + 1,
            generatedColumn: offsetColumn + 1
          },
          consumer: new SourceMapConsumer(util.getArg(s, "map"), aSourceMapURL)
        };
      });
    }
    IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
    IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;
    IndexedSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(IndexedSourceMapConsumer.prototype, "sources", {
      get: function() {
        var sources = [];
        for (var i = 0; i < this._sections.length; i++) {
          for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
            sources.push(this._sections[i].consumer.sources[j]);
          }
        }
        return sources;
      }
    });
    IndexedSourceMapConsumer.prototype.originalPositionFor = function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, "line"),
        generatedColumn: util.getArg(aArgs, "column")
      };
      var sectionIndex = binarySearch.search(
        needle,
        this._sections,
        function(needle2, section2) {
          var cmp = needle2.generatedLine - section2.generatedOffset.generatedLine;
          if (cmp) {
            return cmp;
          }
          return needle2.generatedColumn - section2.generatedOffset.generatedColumn;
        }
      );
      var section = this._sections[sectionIndex];
      if (!section) {
        return {
          source: null,
          line: null,
          column: null,
          name: null
        };
      }
      return section.consumer.originalPositionFor({
        line: needle.generatedLine - (section.generatedOffset.generatedLine - 1),
        column: needle.generatedColumn - (section.generatedOffset.generatedLine === needle.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
        bias: aArgs.bias
      });
    };
    IndexedSourceMapConsumer.prototype.hasContentsOfAllSources = function IndexedSourceMapConsumer_hasContentsOfAllSources() {
      return this._sections.every(function(s) {
        return s.consumer.hasContentsOfAllSources();
      });
    };
    IndexedSourceMapConsumer.prototype.sourceContentFor = function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var content = section.consumer.sourceContentFor(aSource, true);
        if (content) {
          return content;
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + aSource + '" is not in the SourceMap.');
      }
    };
    IndexedSourceMapConsumer.prototype.generatedPositionFor = function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        if (section.consumer._findSourceIndex(util.getArg(aArgs, "source")) === -1) {
          continue;
        }
        var generatedPosition = section.consumer.generatedPositionFor(aArgs);
        if (generatedPosition) {
          var ret = {
            line: generatedPosition.line + (section.generatedOffset.generatedLine - 1),
            column: generatedPosition.column + (section.generatedOffset.generatedLine === generatedPosition.line ? section.generatedOffset.generatedColumn - 1 : 0)
          };
          return ret;
        }
      }
      return {
        line: null,
        column: null
      };
    };
    IndexedSourceMapConsumer.prototype._parseMappings = function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      this.__generatedMappings = [];
      this.__originalMappings = [];
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var sectionMappings = section.consumer._generatedMappings;
        for (var j = 0; j < sectionMappings.length; j++) {
          var mapping = sectionMappings[j];
          var source = section.consumer._sources.at(mapping.source);
          source = util.computeSourceURL(section.consumer.sourceRoot, source, this._sourceMapURL);
          this._sources.add(source);
          source = this._sources.indexOf(source);
          var name = null;
          if (mapping.name) {
            name = section.consumer._names.at(mapping.name);
            this._names.add(name);
            name = this._names.indexOf(name);
          }
          var adjustedMapping = {
            source,
            generatedLine: mapping.generatedLine + (section.generatedOffset.generatedLine - 1),
            generatedColumn: mapping.generatedColumn + (section.generatedOffset.generatedLine === mapping.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
            originalLine: mapping.originalLine,
            originalColumn: mapping.originalColumn,
            name
          };
          this.__generatedMappings.push(adjustedMapping);
          if (typeof adjustedMapping.originalLine === "number") {
            this.__originalMappings.push(adjustedMapping);
          }
        }
      }
      quickSort(this.__generatedMappings, util.compareByGeneratedPositionsDeflated);
      quickSort(this.__originalMappings, util.compareByOriginalPositions);
    };
    exports2.IndexedSourceMapConsumer = IndexedSourceMapConsumer;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/source-node.js
var require_source_node = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/source-node.js"(exports2) {
    var SourceMapGenerator = require_source_map_generator().SourceMapGenerator;
    var util = require_util();
    var REGEX_NEWLINE = /(\r?\n)/;
    var NEWLINE_CODE = 10;
    var isSourceNode = "$$$isSourceNode$$$";
    function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
      this.children = [];
      this.sourceContents = {};
      this.line = aLine == null ? null : aLine;
      this.column = aColumn == null ? null : aColumn;
      this.source = aSource == null ? null : aSource;
      this.name = aName == null ? null : aName;
      this[isSourceNode] = true;
      if (aChunks != null)
        this.add(aChunks);
    }
    SourceNode.fromStringWithSourceMap = function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
      var node = new SourceNode();
      var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
      var remainingLinesIndex = 0;
      var shiftNextLine = function() {
        var lineContents = getNextLine();
        var newLine = getNextLine() || "";
        return lineContents + newLine;
        function getNextLine() {
          return remainingLinesIndex < remainingLines.length ? remainingLines[remainingLinesIndex++] : void 0;
        }
      };
      var lastGeneratedLine = 1, lastGeneratedColumn = 0;
      var lastMapping = null;
      aSourceMapConsumer.eachMapping(function(mapping) {
        if (lastMapping !== null) {
          if (lastGeneratedLine < mapping.generatedLine) {
            addMappingWithCode(lastMapping, shiftNextLine());
            lastGeneratedLine++;
            lastGeneratedColumn = 0;
          } else {
            var nextLine = remainingLines[remainingLinesIndex] || "";
            var code = nextLine.substr(0, mapping.generatedColumn - lastGeneratedColumn);
            remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn - lastGeneratedColumn);
            lastGeneratedColumn = mapping.generatedColumn;
            addMappingWithCode(lastMapping, code);
            lastMapping = mapping;
            return;
          }
        }
        while (lastGeneratedLine < mapping.generatedLine) {
          node.add(shiftNextLine());
          lastGeneratedLine++;
        }
        if (lastGeneratedColumn < mapping.generatedColumn) {
          var nextLine = remainingLines[remainingLinesIndex] || "";
          node.add(nextLine.substr(0, mapping.generatedColumn));
          remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
          lastGeneratedColumn = mapping.generatedColumn;
        }
        lastMapping = mapping;
      }, this);
      if (remainingLinesIndex < remainingLines.length) {
        if (lastMapping) {
          addMappingWithCode(lastMapping, shiftNextLine());
        }
        node.add(remainingLines.splice(remainingLinesIndex).join(""));
      }
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          if (aRelativePath != null) {
            sourceFile = util.join(aRelativePath, sourceFile);
          }
          node.setSourceContent(sourceFile, content);
        }
      });
      return node;
      function addMappingWithCode(mapping, code) {
        if (mapping === null || mapping.source === void 0) {
          node.add(code);
        } else {
          var source = aRelativePath ? util.join(aRelativePath, mapping.source) : mapping.source;
          node.add(new SourceNode(
            mapping.originalLine,
            mapping.originalColumn,
            source,
            code,
            mapping.name
          ));
        }
      }
    };
    SourceNode.prototype.add = function SourceNode_add(aChunk) {
      if (Array.isArray(aChunk)) {
        aChunk.forEach(function(chunk) {
          this.add(chunk);
        }, this);
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        if (aChunk) {
          this.children.push(aChunk);
        }
      } else {
        throw new TypeError(
          "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
        );
      }
      return this;
    };
    SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
      if (Array.isArray(aChunk)) {
        for (var i = aChunk.length - 1; i >= 0; i--) {
          this.prepend(aChunk[i]);
        }
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        this.children.unshift(aChunk);
      } else {
        throw new TypeError(
          "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
        );
      }
      return this;
    };
    SourceNode.prototype.walk = function SourceNode_walk(aFn) {
      var chunk;
      for (var i = 0, len = this.children.length; i < len; i++) {
        chunk = this.children[i];
        if (chunk[isSourceNode]) {
          chunk.walk(aFn);
        } else {
          if (chunk !== "") {
            aFn(chunk, {
              source: this.source,
              line: this.line,
              column: this.column,
              name: this.name
            });
          }
        }
      }
    };
    SourceNode.prototype.join = function SourceNode_join(aSep) {
      var newChildren;
      var i;
      var len = this.children.length;
      if (len > 0) {
        newChildren = [];
        for (i = 0; i < len - 1; i++) {
          newChildren.push(this.children[i]);
          newChildren.push(aSep);
        }
        newChildren.push(this.children[i]);
        this.children = newChildren;
      }
      return this;
    };
    SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
      var lastChild = this.children[this.children.length - 1];
      if (lastChild[isSourceNode]) {
        lastChild.replaceRight(aPattern, aReplacement);
      } else if (typeof lastChild === "string") {
        this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
      } else {
        this.children.push("".replace(aPattern, aReplacement));
      }
      return this;
    };
    SourceNode.prototype.setSourceContent = function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
      this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
    };
    SourceNode.prototype.walkSourceContents = function SourceNode_walkSourceContents(aFn) {
      for (var i = 0, len = this.children.length; i < len; i++) {
        if (this.children[i][isSourceNode]) {
          this.children[i].walkSourceContents(aFn);
        }
      }
      var sources = Object.keys(this.sourceContents);
      for (var i = 0, len = sources.length; i < len; i++) {
        aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
      }
    };
    SourceNode.prototype.toString = function SourceNode_toString() {
      var str = "";
      this.walk(function(chunk) {
        str += chunk;
      });
      return str;
    };
    SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
      var generated = {
        code: "",
        line: 1,
        column: 0
      };
      var map = new SourceMapGenerator(aArgs);
      var sourceMappingActive = false;
      var lastOriginalSource = null;
      var lastOriginalLine = null;
      var lastOriginalColumn = null;
      var lastOriginalName = null;
      this.walk(function(chunk, original) {
        generated.code += chunk;
        if (original.source !== null && original.line !== null && original.column !== null) {
          if (lastOriginalSource !== original.source || lastOriginalLine !== original.line || lastOriginalColumn !== original.column || lastOriginalName !== original.name) {
            map.addMapping({
              source: original.source,
              original: {
                line: original.line,
                column: original.column
              },
              generated: {
                line: generated.line,
                column: generated.column
              },
              name: original.name
            });
          }
          lastOriginalSource = original.source;
          lastOriginalLine = original.line;
          lastOriginalColumn = original.column;
          lastOriginalName = original.name;
          sourceMappingActive = true;
        } else if (sourceMappingActive) {
          map.addMapping({
            generated: {
              line: generated.line,
              column: generated.column
            }
          });
          lastOriginalSource = null;
          sourceMappingActive = false;
        }
        for (var idx = 0, length = chunk.length; idx < length; idx++) {
          if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
            generated.line++;
            generated.column = 0;
            if (idx + 1 === length) {
              lastOriginalSource = null;
              sourceMappingActive = false;
            } else if (sourceMappingActive) {
              map.addMapping({
                source: original.source,
                original: {
                  line: original.line,
                  column: original.column
                },
                generated: {
                  line: generated.line,
                  column: generated.column
                },
                name: original.name
              });
            }
          } else {
            generated.column++;
          }
        }
      });
      this.walkSourceContents(function(sourceFile, sourceContent) {
        map.setSourceContent(sourceFile, sourceContent);
      });
      return { code: generated.code, map };
    };
    exports2.SourceNode = SourceNode;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/source-map.js
var require_source_map = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/source-map.js"(exports2) {
    exports2.SourceMapGenerator = require_source_map_generator().SourceMapGenerator;
    exports2.SourceMapConsumer = require_source_map_consumer().SourceMapConsumer;
    exports2.SourceNode = require_source_node().SourceNode;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/buffer-from/index.js
var require_buffer_from = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/buffer-from/index.js"(exports2, module2) {
    var toString = Object.prototype.toString;
    var isModern = typeof Buffer.alloc === "function" && typeof Buffer.allocUnsafe === "function" && typeof Buffer.from === "function";
    function isArrayBuffer(input) {
      return toString.call(input).slice(8, -1) === "ArrayBuffer";
    }
    function fromArrayBuffer(obj, byteOffset, length) {
      byteOffset >>>= 0;
      var maxLength = obj.byteLength - byteOffset;
      if (maxLength < 0) {
        throw new RangeError("'offset' is out of bounds");
      }
      if (length === void 0) {
        length = maxLength;
      } else {
        length >>>= 0;
        if (length > maxLength) {
          throw new RangeError("'length' is out of bounds");
        }
      }
      return isModern ? Buffer.from(obj.slice(byteOffset, byteOffset + length)) : new Buffer(new Uint8Array(obj.slice(byteOffset, byteOffset + length)));
    }
    function fromString(string, encoding) {
      if (typeof encoding !== "string" || encoding === "") {
        encoding = "utf8";
      }
      if (!Buffer.isEncoding(encoding)) {
        throw new TypeError('"encoding" must be a valid string encoding');
      }
      return isModern ? Buffer.from(string, encoding) : new Buffer(string, encoding);
    }
    function bufferFrom(value, encodingOrOffset, length) {
      if (typeof value === "number") {
        throw new TypeError('"value" argument must not be a number');
      }
      if (isArrayBuffer(value)) {
        return fromArrayBuffer(value, encodingOrOffset, length);
      }
      if (typeof value === "string") {
        return fromString(value, encodingOrOffset);
      }
      return isModern ? Buffer.from(value) : new Buffer(value);
    }
    module2.exports = bufferFrom;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map-support/source-map-support.js
var require_source_map_support = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map-support/source-map-support.js"(exports2, module2) {
    var SourceMapConsumer = require_source_map().SourceMapConsumer;
    var path = require("path");
    var fs;
    try {
      fs = require("fs");
      if (!fs.existsSync || !fs.readFileSync) {
        fs = null;
      }
    } catch (err) {
    }
    var bufferFrom = require_buffer_from();
    function dynamicRequire(mod, request) {
      return mod.require(request);
    }
    var errorFormatterInstalled = false;
    var uncaughtShimInstalled = false;
    var emptyCacheBetweenOperations = false;
    var environment = "auto";
    var fileContentsCache = {};
    var sourceMapCache = {};
    var reSourceMap = /^data:application\/json[^,]+base64,/;
    var retrieveFileHandlers = [];
    var retrieveMapHandlers = [];
    function isInBrowser() {
      if (environment === "browser")
        return true;
      if (environment === "node")
        return false;
      return typeof window !== "undefined" && typeof XMLHttpRequest === "function" && !(window.require && window.module && window.process && window.process.type === "renderer");
    }
    function hasGlobalProcessEventEmitter() {
      return typeof process === "object" && process !== null && typeof process.on === "function";
    }
    function globalProcessVersion() {
      if (typeof process === "object" && process !== null) {
        return process.version;
      } else {
        return "";
      }
    }
    function globalProcessStderr() {
      if (typeof process === "object" && process !== null) {
        return process.stderr;
      }
    }
    function globalProcessExit(code) {
      if (typeof process === "object" && process !== null && typeof process.exit === "function") {
        return process.exit(code);
      }
    }
    function handlerExec(list) {
      return function(arg) {
        for (var i = 0; i < list.length; i++) {
          var ret = list[i](arg);
          if (ret) {
            return ret;
          }
        }
        return null;
      };
    }
    var retrieveFile = handlerExec(retrieveFileHandlers);
    retrieveFileHandlers.push(function(path2) {
      path2 = path2.trim();
      if (/^file:/.test(path2)) {
        path2 = path2.replace(/file:\/\/\/(\w:)?/, function(protocol, drive) {
          return drive ? "" : (
            // file:///C:/dir/file -> C:/dir/file
            "/"
          );
        });
      }
      if (path2 in fileContentsCache) {
        return fileContentsCache[path2];
      }
      var contents = "";
      try {
        if (!fs) {
          var xhr = new XMLHttpRequest();
          xhr.open(
            "GET",
            path2,
            /** async */
            false
          );
          xhr.send(null);
          if (xhr.readyState === 4 && xhr.status === 200) {
            contents = xhr.responseText;
          }
        } else if (fs.existsSync(path2)) {
          contents = fs.readFileSync(path2, "utf8");
        }
      } catch (er) {
      }
      return fileContentsCache[path2] = contents;
    });
    function supportRelativeURL(file, url) {
      if (!file)
        return url;
      var dir = path.dirname(file);
      var match = /^\w+:\/\/[^\/]*/.exec(dir);
      var protocol = match ? match[0] : "";
      var startPath = dir.slice(protocol.length);
      if (protocol && /^\/\w\:/.test(startPath)) {
        protocol += "/";
        return protocol + path.resolve(dir.slice(protocol.length), url).replace(/\\/g, "/");
      }
      return protocol + path.resolve(dir.slice(protocol.length), url);
    }
    function retrieveSourceMapURL(source) {
      var fileData;
      if (isInBrowser()) {
        try {
          var xhr = new XMLHttpRequest();
          xhr.open("GET", source, false);
          xhr.send(null);
          fileData = xhr.readyState === 4 ? xhr.responseText : null;
          var sourceMapHeader = xhr.getResponseHeader("SourceMap") || xhr.getResponseHeader("X-SourceMap");
          if (sourceMapHeader) {
            return sourceMapHeader;
          }
        } catch (e) {
        }
      }
      fileData = retrieveFile(source);
      var re = /(?:\/\/[@#][\s]*sourceMappingURL=([^\s'"]+)[\s]*$)|(?:\/\*[@#][\s]*sourceMappingURL=([^\s*'"]+)[\s]*(?:\*\/)[\s]*$)/mg;
      var lastMatch, match;
      while (match = re.exec(fileData))
        lastMatch = match;
      if (!lastMatch)
        return null;
      return lastMatch[1];
    }
    var retrieveSourceMap = handlerExec(retrieveMapHandlers);
    retrieveMapHandlers.push(function(source) {
      var sourceMappingURL = retrieveSourceMapURL(source);
      if (!sourceMappingURL)
        return null;
      var sourceMapData;
      if (reSourceMap.test(sourceMappingURL)) {
        var rawData = sourceMappingURL.slice(sourceMappingURL.indexOf(",") + 1);
        sourceMapData = bufferFrom(rawData, "base64").toString();
        sourceMappingURL = source;
      } else {
        sourceMappingURL = supportRelativeURL(source, sourceMappingURL);
        sourceMapData = retrieveFile(sourceMappingURL);
      }
      if (!sourceMapData) {
        return null;
      }
      return {
        url: sourceMappingURL,
        map: sourceMapData
      };
    });
    function mapSourcePosition(position) {
      var sourceMap = sourceMapCache[position.source];
      if (!sourceMap) {
        var urlAndMap = retrieveSourceMap(position.source);
        if (urlAndMap) {
          sourceMap = sourceMapCache[position.source] = {
            url: urlAndMap.url,
            map: new SourceMapConsumer(urlAndMap.map)
          };
          if (sourceMap.map.sourcesContent) {
            sourceMap.map.sources.forEach(function(source, i) {
              var contents = sourceMap.map.sourcesContent[i];
              if (contents) {
                var url = supportRelativeURL(sourceMap.url, source);
                fileContentsCache[url] = contents;
              }
            });
          }
        } else {
          sourceMap = sourceMapCache[position.source] = {
            url: null,
            map: null
          };
        }
      }
      if (sourceMap && sourceMap.map && typeof sourceMap.map.originalPositionFor === "function") {
        var originalPosition = sourceMap.map.originalPositionFor(position);
        if (originalPosition.source !== null) {
          originalPosition.source = supportRelativeURL(
            sourceMap.url,
            originalPosition.source
          );
          return originalPosition;
        }
      }
      return position;
    }
    function mapEvalOrigin(origin) {
      var match = /^eval at ([^(]+) \((.+):(\d+):(\d+)\)$/.exec(origin);
      if (match) {
        var position = mapSourcePosition({
          source: match[2],
          line: +match[3],
          column: match[4] - 1
        });
        return "eval at " + match[1] + " (" + position.source + ":" + position.line + ":" + (position.column + 1) + ")";
      }
      match = /^eval at ([^(]+) \((.+)\)$/.exec(origin);
      if (match) {
        return "eval at " + match[1] + " (" + mapEvalOrigin(match[2]) + ")";
      }
      return origin;
    }
    function CallSiteToString() {
      var fileName;
      var fileLocation = "";
      if (this.isNative()) {
        fileLocation = "native";
      } else {
        fileName = this.getScriptNameOrSourceURL();
        if (!fileName && this.isEval()) {
          fileLocation = this.getEvalOrigin();
          fileLocation += ", ";
        }
        if (fileName) {
          fileLocation += fileName;
        } else {
          fileLocation += "<anonymous>";
        }
        var lineNumber = this.getLineNumber();
        if (lineNumber != null) {
          fileLocation += ":" + lineNumber;
          var columnNumber = this.getColumnNumber();
          if (columnNumber) {
            fileLocation += ":" + columnNumber;
          }
        }
      }
      var line = "";
      var functionName = this.getFunctionName();
      var addSuffix = true;
      var isConstructor = this.isConstructor();
      var isMethodCall = !(this.isToplevel() || isConstructor);
      if (isMethodCall) {
        var typeName = this.getTypeName();
        if (typeName === "[object Object]") {
          typeName = "null";
        }
        var methodName = this.getMethodName();
        if (functionName) {
          if (typeName && functionName.indexOf(typeName) != 0) {
            line += typeName + ".";
          }
          line += functionName;
          if (methodName && functionName.indexOf("." + methodName) != functionName.length - methodName.length - 1) {
            line += " [as " + methodName + "]";
          }
        } else {
          line += typeName + "." + (methodName || "<anonymous>");
        }
      } else if (isConstructor) {
        line += "new " + (functionName || "<anonymous>");
      } else if (functionName) {
        line += functionName;
      } else {
        line += fileLocation;
        addSuffix = false;
      }
      if (addSuffix) {
        line += " (" + fileLocation + ")";
      }
      return line;
    }
    function cloneCallSite(frame) {
      var object = {};
      Object.getOwnPropertyNames(Object.getPrototypeOf(frame)).forEach(function(name) {
        object[name] = /^(?:is|get)/.test(name) ? function() {
          return frame[name].call(frame);
        } : frame[name];
      });
      object.toString = CallSiteToString;
      return object;
    }
    function wrapCallSite(frame, state) {
      if (state === void 0) {
        state = { nextPosition: null, curPosition: null };
      }
      if (frame.isNative()) {
        state.curPosition = null;
        return frame;
      }
      var source = frame.getFileName() || frame.getScriptNameOrSourceURL();
      if (source) {
        var line = frame.getLineNumber();
        var column = frame.getColumnNumber() - 1;
        var noHeader = /^v(10\.1[6-9]|10\.[2-9][0-9]|10\.[0-9]{3,}|1[2-9]\d*|[2-9]\d|\d{3,}|11\.11)/;
        var headerLength = noHeader.test(globalProcessVersion()) ? 0 : 62;
        if (line === 1 && column > headerLength && !isInBrowser() && !frame.isEval()) {
          column -= headerLength;
        }
        var position = mapSourcePosition({
          source,
          line,
          column
        });
        state.curPosition = position;
        frame = cloneCallSite(frame);
        var originalFunctionName = frame.getFunctionName;
        frame.getFunctionName = function() {
          if (state.nextPosition == null) {
            return originalFunctionName();
          }
          return state.nextPosition.name || originalFunctionName();
        };
        frame.getFileName = function() {
          return position.source;
        };
        frame.getLineNumber = function() {
          return position.line;
        };
        frame.getColumnNumber = function() {
          return position.column + 1;
        };
        frame.getScriptNameOrSourceURL = function() {
          return position.source;
        };
        return frame;
      }
      var origin = frame.isEval() && frame.getEvalOrigin();
      if (origin) {
        origin = mapEvalOrigin(origin);
        frame = cloneCallSite(frame);
        frame.getEvalOrigin = function() {
          return origin;
        };
        return frame;
      }
      return frame;
    }
    function prepareStackTrace(error, stack) {
      if (emptyCacheBetweenOperations) {
        fileContentsCache = {};
        sourceMapCache = {};
      }
      var name = error.name || "Error";
      var message = error.message || "";
      var errorString = name + ": " + message;
      var state = { nextPosition: null, curPosition: null };
      var processedStack = [];
      for (var i = stack.length - 1; i >= 0; i--) {
        processedStack.push("\n    at " + wrapCallSite(stack[i], state));
        state.nextPosition = state.curPosition;
      }
      state.curPosition = state.nextPosition = null;
      return errorString + processedStack.reverse().join("");
    }
    function getErrorSource(error) {
      var match = /\n    at [^(]+ \((.*):(\d+):(\d+)\)/.exec(error.stack);
      if (match) {
        var source = match[1];
        var line = +match[2];
        var column = +match[3];
        var contents = fileContentsCache[source];
        if (!contents && fs && fs.existsSync(source)) {
          try {
            contents = fs.readFileSync(source, "utf8");
          } catch (er) {
            contents = "";
          }
        }
        if (contents) {
          var code = contents.split(/(?:\r\n|\r|\n)/)[line - 1];
          if (code) {
            return source + ":" + line + "\n" + code + "\n" + new Array(column).join(" ") + "^";
          }
        }
      }
      return null;
    }
    function printErrorAndExit(error) {
      var source = getErrorSource(error);
      var stderr = globalProcessStderr();
      if (stderr && stderr._handle && stderr._handle.setBlocking) {
        stderr._handle.setBlocking(true);
      }
      if (source) {
        console.error();
        console.error(source);
      }
      console.error(error.stack);
      globalProcessExit(1);
    }
    function shimEmitUncaughtException() {
      var origEmit = process.emit;
      process.emit = function(type) {
        if (type === "uncaughtException") {
          var hasStack = arguments[1] && arguments[1].stack;
          var hasListeners = this.listeners(type).length > 0;
          if (hasStack && !hasListeners) {
            return printErrorAndExit(arguments[1]);
          }
        }
        return origEmit.apply(this, arguments);
      };
    }
    var originalRetrieveFileHandlers = retrieveFileHandlers.slice(0);
    var originalRetrieveMapHandlers = retrieveMapHandlers.slice(0);
    exports2.wrapCallSite = wrapCallSite;
    exports2.getErrorSource = getErrorSource;
    exports2.mapSourcePosition = mapSourcePosition;
    exports2.retrieveSourceMap = retrieveSourceMap;
    exports2.install = function(options2) {
      options2 = options2 || {};
      if (options2.environment) {
        environment = options2.environment;
        if (["node", "browser", "auto"].indexOf(environment) === -1) {
          throw new Error("environment " + environment + " was unknown. Available options are {auto, browser, node}");
        }
      }
      if (options2.retrieveFile) {
        if (options2.overrideRetrieveFile) {
          retrieveFileHandlers.length = 0;
        }
        retrieveFileHandlers.unshift(options2.retrieveFile);
      }
      if (options2.retrieveSourceMap) {
        if (options2.overrideRetrieveSourceMap) {
          retrieveMapHandlers.length = 0;
        }
        retrieveMapHandlers.unshift(options2.retrieveSourceMap);
      }
      if (options2.hookRequire && !isInBrowser()) {
        var Module = dynamicRequire(module2, "module");
        var $compile = Module.prototype._compile;
        if (!$compile.__sourceMapSupport) {
          Module.prototype._compile = function(content, filename) {
            fileContentsCache[filename] = content;
            sourceMapCache[filename] = void 0;
            return $compile.call(this, content, filename);
          };
          Module.prototype._compile.__sourceMapSupport = true;
        }
      }
      if (!emptyCacheBetweenOperations) {
        emptyCacheBetweenOperations = "emptyCacheBetweenOperations" in options2 ? options2.emptyCacheBetweenOperations : false;
      }
      if (!errorFormatterInstalled) {
        errorFormatterInstalled = true;
        Error.prepareStackTrace = prepareStackTrace;
      }
      if (!uncaughtShimInstalled) {
        var installHandler = "handleUncaughtExceptions" in options2 ? options2.handleUncaughtExceptions : true;
        try {
          var worker_threads = dynamicRequire(module2, "worker_threads");
          if (worker_threads.isMainThread === false) {
            installHandler = false;
          }
        } catch (e) {
        }
        if (installHandler && hasGlobalProcessEventEmitter()) {
          uncaughtShimInstalled = true;
          shimEmitUncaughtException();
        }
      }
    };
    exports2.resetRetrieveHandlers = function() {
      retrieveFileHandlers.length = 0;
      retrieveMapHandlers.length = 0;
      retrieveFileHandlers = originalRetrieveFileHandlers.slice(0);
      retrieveMapHandlers = originalRetrieveMapHandlers.slice(0);
      retrieveSourceMap = handlerExec(retrieveMapHandlers);
      retrieveFile = handlerExec(retrieveFileHandlers);
    };
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/typescript@registry.npmjs.org+typescript@5.3.2/node_modules/typescript/lib/typescript.js
var require_typescript = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin_arm64-fastbuild/bin/node_modules/.aspect_rules_js/typescript@registry.npmjs.org+typescript@5.3.2/node_modules/typescript/lib/typescript.js"(exports2, module2) {
    "use strict";
    var ts = (() => {
      var __defProp2 = Object.defineProperty;
      var __getOwnPropNames2 = Object.getOwnPropertyNames;
      var __esm = (fn, res) => function __init() {
        return fn && (res = (0, fn[__getOwnPropNames2(fn)[0]])(fn = 0)), res;
      };
      var __commonJS2 = (cb, mod) => function __require() {
        return mod || (0, cb[__getOwnPropNames2(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
      };
      var __export = (target, all) => {
        for (var name in all)
          __defProp2(target, name, { get: all[name], enumerable: true });
      };
      var versionMajorMinor, version, Comparison;
      var init_corePublic = __esm({
        "src/compiler/corePublic.ts"() {
          "use strict";
          versionMajorMinor = "5.3";
          version = "5.3.2";
          Comparison = ((Comparison3) => {
            Comparison3[Comparison3["LessThan"] = -1] = "LessThan";
            Comparison3[Comparison3["EqualTo"] = 0] = "EqualTo";
            Comparison3[Comparison3["GreaterThan"] = 1] = "GreaterThan";
            return Comparison3;
          })(Comparison || {});
        }
      });
      function length(array) {
        return array ? array.length : 0;
      }
      function forEach(array, callback) {
        if (array) {
          for (let i = 0; i < array.length; i++) {
            const result = callback(array[i], i);
            if (result) {
              return result;
            }
          }
        }
        return void 0;
      }
      function forEachRight(array, callback) {
        if (array) {
          for (let i = array.length - 1; i >= 0; i--) {
            const result = callback(array[i], i);
            if (result) {
              return result;
            }
          }
        }
        return void 0;
      }
      function firstDefined(array, callback) {
        if (array === void 0) {
          return void 0;
        }
        for (let i = 0; i < array.length; i++) {
          const result = callback(array[i], i);
          if (result !== void 0) {
            return result;
          }
        }
        return void 0;
      }
      function firstDefinedIterator(iter, callback) {
        for (const value of iter) {
          const result = callback(value);
          if (result !== void 0) {
            return result;
          }
        }
        return void 0;
      }
      function reduceLeftIterator(iterator, f, initial) {
        let result = initial;
        if (iterator) {
          let pos = 0;
          for (const value of iterator) {
            result = f(result, value, pos);
            pos++;
          }
        }
        return result;
      }
      function zipWith(arrayA, arrayB, callback) {
        const result = [];
        Debug.assertEqual(arrayA.length, arrayB.length);
        for (let i = 0; i < arrayA.length; i++) {
          result.push(callback(arrayA[i], arrayB[i], i));
        }
        return result;
      }
      function intersperse(input, element) {
        if (input.length <= 1) {
          return input;
        }
        const result = [];
        for (let i = 0, n = input.length; i < n; i++) {
          if (i)
            result.push(element);
          result.push(input[i]);
        }
        return result;
      }
      function every(array, callback) {
        if (array) {
          for (let i = 0; i < array.length; i++) {
            if (!callback(array[i], i)) {
              return false;
            }
          }
        }
        return true;
      }
      function find(array, predicate, startIndex) {
        if (array === void 0)
          return void 0;
        for (let i = startIndex != null ? startIndex : 0; i < array.length; i++) {
          const value = array[i];
          if (predicate(value, i)) {
            return value;
          }
        }
        return void 0;
      }
      function findLast(array, predicate, startIndex) {
        if (array === void 0)
          return void 0;
        for (let i = startIndex != null ? startIndex : array.length - 1; i >= 0; i--) {
          const value = array[i];
          if (predicate(value, i)) {
            return value;
          }
        }
        return void 0;
      }
      function findIndex(array, predicate, startIndex) {
        if (array === void 0)
          return -1;
        for (let i = startIndex != null ? startIndex : 0; i < array.length; i++) {
          if (predicate(array[i], i)) {
            return i;
          }
        }
        return -1;
      }
      function findLastIndex(array, predicate, startIndex) {
        if (array === void 0)
          return -1;
        for (let i = startIndex != null ? startIndex : array.length - 1; i >= 0; i--) {
          if (predicate(array[i], i)) {
            return i;
          }
        }
        return -1;
      }
      function findMap(array, callback) {
        for (let i = 0; i < array.length; i++) {
          const result = callback(array[i], i);
          if (result) {
            return result;
          }
        }
        return Debug.fail();
      }
      function contains(array, value, equalityComparer = equateValues) {
        if (array) {
          for (const v of array) {
            if (equalityComparer(v, value)) {
              return true;
            }
          }
        }
        return false;
      }
      function arraysEqual(a, b, equalityComparer = equateValues) {
        return a.length === b.length && a.every((x, i) => equalityComparer(x, b[i]));
      }
      function indexOfAnyCharCode(text, charCodes, start) {
        for (let i = start || 0; i < text.length; i++) {
          if (contains(charCodes, text.charCodeAt(i))) {
            return i;
          }
        }
        return -1;
      }
      function countWhere(array, predicate) {
        let count = 0;
        if (array) {
          for (let i = 0; i < array.length; i++) {
            const v = array[i];
            if (predicate(v, i)) {
              count++;
            }
          }
        }
        return count;
      }
      function filter(array, f) {
        if (array) {
          const len = array.length;
          let i = 0;
          while (i < len && f(array[i]))
            i++;
          if (i < len) {
            const result = array.slice(0, i);
            i++;
            while (i < len) {
              const item = array[i];
              if (f(item)) {
                result.push(item);
              }
              i++;
            }
            return result;
          }
        }
        return array;
      }
      function filterMutate(array, f) {
        let outIndex = 0;
        for (let i = 0; i < array.length; i++) {
          if (f(array[i], i, array)) {
            array[outIndex] = array[i];
            outIndex++;
          }
        }
        array.length = outIndex;
      }
      function clear(array) {
        array.length = 0;
      }
      function map(array, f) {
        let result;
        if (array) {
          result = [];
          for (let i = 0; i < array.length; i++) {
            result.push(f(array[i], i));
          }
        }
        return result;
      }
      function* mapIterator(iter, mapFn) {
        for (const x of iter) {
          yield mapFn(x);
        }
      }
      function sameMap(array, f) {
        if (array) {
          for (let i = 0; i < array.length; i++) {
            const item = array[i];
            const mapped = f(item, i);
            if (item !== mapped) {
              const result = array.slice(0, i);
              result.push(mapped);
              for (i++; i < array.length; i++) {
                result.push(f(array[i], i));
              }
              return result;
            }
          }
        }
        return array;
      }
      function flatten(array) {
        const result = [];
        for (const v of array) {
          if (v) {
            if (isArray(v)) {
              addRange(result, v);
            } else {
              result.push(v);
            }
          }
        }
        return result;
      }
      function flatMap(array, mapfn) {
        let result;
        if (array) {
          for (let i = 0; i < array.length; i++) {
            const v = mapfn(array[i], i);
            if (v) {
              if (isArray(v)) {
                result = addRange(result, v);
              } else {
                result = append(result, v);
              }
            }
          }
        }
        return result || emptyArray;
      }
      function flatMapToMutable(array, mapfn) {
        const result = [];
        if (array) {
          for (let i = 0; i < array.length; i++) {
            const v = mapfn(array[i], i);
            if (v) {
              if (isArray(v)) {
                addRange(result, v);
              } else {
                result.push(v);
              }
            }
          }
        }
        return result;
      }
      function* flatMapIterator(iter, mapfn) {
        for (const x of iter) {
          const iter2 = mapfn(x);
          if (!iter2)
            continue;
          yield* iter2;
        }
      }
      function sameFlatMap(array, mapfn) {
        let result;
        if (array) {
          for (let i = 0; i < array.length; i++) {
            const item = array[i];
            const mapped = mapfn(item, i);
            if (result || item !== mapped || isArray(mapped)) {
              if (!result) {
                result = array.slice(0, i);
              }
              if (isArray(mapped)) {
                addRange(result, mapped);
              } else {
                result.push(mapped);
              }
            }
          }
        }
        return result || array;
      }
      function mapAllOrFail(array, mapFn) {
        const result = [];
        for (let i = 0; i < array.length; i++) {
          const mapped = mapFn(array[i], i);
          if (mapped === void 0) {
            return void 0;
          }
          result.push(mapped);
        }
        return result;
      }
      function mapDefined(array, mapFn) {
        const result = [];
        if (array) {
          for (let i = 0; i < array.length; i++) {
            const mapped = mapFn(array[i], i);
            if (mapped !== void 0) {
              result.push(mapped);
            }
          }
        }
        return result;
      }
      function* mapDefinedIterator(iter, mapFn) {
        for (const x of iter) {
          const value = mapFn(x);
          if (value !== void 0) {
            yield value;
          }
        }
      }
      function mapDefinedEntries(map2, f) {
        if (!map2) {
          return void 0;
        }
        const result = /* @__PURE__ */ new Map();
        map2.forEach((value, key) => {
          const entry = f(key, value);
          if (entry !== void 0) {
            const [newKey, newValue] = entry;
            if (newKey !== void 0 && newValue !== void 0) {
              result.set(newKey, newValue);
            }
          }
        });
        return result;
      }
      function getOrUpdate(map2, key, callback) {
        if (map2.has(key)) {
          return map2.get(key);
        }
        const value = callback();
        map2.set(key, value);
        return value;
      }
      function tryAddToSet(set, value) {
        if (!set.has(value)) {
          set.add(value);
          return true;
        }
        return false;
      }
      function* singleIterator(value) {
        yield value;
      }
      function spanMap(array, keyfn, mapfn) {
        let result;
        if (array) {
          result = [];
          const len = array.length;
          let previousKey;
          let key;
          let start = 0;
          let pos = 0;
          while (start < len) {
            while (pos < len) {
              const value = array[pos];
              key = keyfn(value, pos);
              if (pos === 0) {
                previousKey = key;
              } else if (key !== previousKey) {
                break;
              }
              pos++;
            }
            if (start < pos) {
              const v = mapfn(array.slice(start, pos), previousKey, start, pos);
              if (v) {
                result.push(v);
              }
              start = pos;
            }
            previousKey = key;
            pos++;
          }
        }
        return result;
      }
      function mapEntries(map2, f) {
        if (!map2) {
          return void 0;
        }
        const result = /* @__PURE__ */ new Map();
        map2.forEach((value, key) => {
          const [newKey, newValue] = f(key, value);
          result.set(newKey, newValue);
        });
        return result;
      }
      function some(array, predicate) {
        if (array) {
          if (predicate) {
            for (const v of array) {
              if (predicate(v)) {
                return true;
              }
            }
          } else {
            return array.length > 0;
          }
        }
        return false;
      }
      function getRangesWhere(arr, pred, cb) {
        let start;
        for (let i = 0; i < arr.length; i++) {
          if (pred(arr[i])) {
            start = start === void 0 ? i : start;
          } else {
            if (start !== void 0) {
              cb(start, i);
              start = void 0;
            }
          }
        }
        if (start !== void 0)
          cb(start, arr.length);
      }
      function concatenate(array1, array2) {
        if (!some(array2))
          return array1;
        if (!some(array1))
          return array2;
        return [...array1, ...array2];
      }
      function selectIndex(_, i) {
        return i;
      }
      function indicesOf(array) {
        return array.map(selectIndex);
      }
      function deduplicateRelational(array, equalityComparer, comparer) {
        const indices = indicesOf(array);
        stableSortIndices(array, indices, comparer);
        let last2 = array[indices[0]];
        const deduplicated = [indices[0]];
        for (let i = 1; i < indices.length; i++) {
          const index = indices[i];
          const item = array[index];
          if (!equalityComparer(last2, item)) {
            deduplicated.push(index);
            last2 = item;
          }
        }
        deduplicated.sort();
        return deduplicated.map((i) => array[i]);
      }
      function deduplicateEquality(array, equalityComparer) {
        const result = [];
        for (const item of array) {
          pushIfUnique(result, item, equalityComparer);
        }
        return result;
      }
      function deduplicate(array, equalityComparer, comparer) {
        return array.length === 0 ? [] : array.length === 1 ? array.slice() : comparer ? deduplicateRelational(array, equalityComparer, comparer) : deduplicateEquality(array, equalityComparer);
      }
      function deduplicateSorted(array, comparer) {
        if (array.length === 0)
          return emptyArray;
        let last2 = array[0];
        const deduplicated = [last2];
        for (let i = 1; i < array.length; i++) {
          const next = array[i];
          switch (comparer(next, last2)) {
            case true:
            case 0:
              continue;
            case -1:
              return Debug.fail("Array is unsorted.");
          }
          deduplicated.push(last2 = next);
        }
        return deduplicated;
      }
      function createSortedArray() {
        return [];
      }
      function insertSorted(array, insert, compare, allowDuplicates) {
        if (array.length === 0) {
          array.push(insert);
          return true;
        }
        const insertIndex = binarySearch(array, insert, identity, compare);
        if (insertIndex < 0) {
          array.splice(~insertIndex, 0, insert);
          return true;
        }
        if (allowDuplicates) {
          array.splice(insertIndex, 0, insert);
          return true;
        }
        return false;
      }
      function sortAndDeduplicate(array, comparer, equalityComparer) {
        return deduplicateSorted(sort(array, comparer), equalityComparer || comparer || compareStringsCaseSensitive);
      }
      function arrayIsSorted(array, comparer) {
        if (array.length < 2)
          return true;
        for (let i = 1, len = array.length; i < len; i++) {
          if (comparer(array[i - 1], array[i]) === 1) {
            return false;
          }
        }
        return true;
      }
      function detectSortCaseSensitivity(array, getString, compareStringsCaseSensitive2, compareStringsCaseInsensitive2) {
        let kind = 3;
        if (array.length < 2)
          return kind;
        let prevElement = getString(array[0]);
        for (let i = 1, len = array.length; i < len && kind !== 0; i++) {
          const element = getString(array[i]);
          if (kind & 1 && compareStringsCaseSensitive2(prevElement, element) > 0) {
            kind &= ~1;
          }
          if (kind & 2 && compareStringsCaseInsensitive2(prevElement, element) > 0) {
            kind &= ~2;
          }
          prevElement = element;
        }
        return kind;
      }
      function arrayIsEqualTo(array1, array2, equalityComparer = equateValues) {
        if (!array1 || !array2) {
          return array1 === array2;
        }
        if (array1.length !== array2.length) {
          return false;
        }
        for (let i = 0; i < array1.length; i++) {
          if (!equalityComparer(array1[i], array2[i], i)) {
            return false;
          }
        }
        return true;
      }
      function compact(array) {
        let result;
        if (array) {
          for (let i = 0; i < array.length; i++) {
            const v = array[i];
            if (result || !v) {
              if (!result) {
                result = array.slice(0, i);
              }
              if (v) {
                result.push(v);
              }
            }
          }
        }
        return result || array;
      }
      function relativeComplement(arrayA, arrayB, comparer) {
        if (!arrayB || !arrayA || arrayB.length === 0 || arrayA.length === 0)
          return arrayB;
        const result = [];
        loopB:
          for (let offsetA = 0, offsetB = 0; offsetB < arrayB.length; offsetB++) {
            if (offsetB > 0) {
              Debug.assertGreaterThanOrEqual(
                comparer(arrayB[offsetB], arrayB[offsetB - 1]),
                0
                /* EqualTo */
              );
            }
            loopA:
              for (const startA = offsetA; offsetA < arrayA.length; offsetA++) {
                if (offsetA > startA) {
                  Debug.assertGreaterThanOrEqual(
                    comparer(arrayA[offsetA], arrayA[offsetA - 1]),
                    0
                    /* EqualTo */
                  );
                }
                switch (comparer(arrayB[offsetB], arrayA[offsetA])) {
                  case -1:
                    result.push(arrayB[offsetB]);
                    continue loopB;
                  case 0:
                    continue loopB;
                  case 1:
                    continue loopA;
                }
              }
          }
        return result;
      }
      function append(to, value) {
        if (value === void 0)
          return to;
        if (to === void 0)
          return [value];
        to.push(value);
        return to;
      }
      function combine(xs, ys) {
        if (xs === void 0)
          return ys;
        if (ys === void 0)
          return xs;
        if (isArray(xs))
          return isArray(ys) ? concatenate(xs, ys) : append(xs, ys);
        if (isArray(ys))
          return append(ys, xs);
        return [xs, ys];
      }
      function toOffset(array, offset) {
        return offset < 0 ? array.length + offset : offset;
      }
      function addRange(to, from, start, end) {
        if (from === void 0 || from.length === 0)
          return to;
        if (to === void 0)
          return from.slice(start, end);
        start = start === void 0 ? 0 : toOffset(from, start);
        end = end === void 0 ? from.length : toOffset(from, end);
        for (let i = start; i < end && i < from.length; i++) {
          if (from[i] !== void 0) {
            to.push(from[i]);
          }
        }
        return to;
      }
      function pushIfUnique(array, toAdd, equalityComparer) {
        if (contains(array, toAdd, equalityComparer)) {
          return false;
        } else {
          array.push(toAdd);
          return true;
        }
      }
      function appendIfUnique(array, toAdd, equalityComparer) {
        if (array) {
          pushIfUnique(array, toAdd, equalityComparer);
          return array;
        } else {
          return [toAdd];
        }
      }
      function stableSortIndices(array, indices, comparer) {
        indices.sort((x, y) => comparer(array[x], array[y]) || compareValues(x, y));
      }
      function sort(array, comparer) {
        return array.length === 0 ? array : array.slice().sort(comparer);
      }
      function* arrayReverseIterator(array) {
        for (let i = array.length - 1; i >= 0; i--) {
          yield array[i];
        }
      }
      function stableSort(array, comparer) {
        const indices = indicesOf(array);
        stableSortIndices(array, indices, comparer);
        return indices.map((i) => array[i]);
      }
      function rangeEquals(array1, array2, pos, end) {
        while (pos < end) {
          if (array1[pos] !== array2[pos]) {
            return false;
          }
          pos++;
        }
        return true;
      }
      function firstOrUndefined(array) {
        return array === void 0 || array.length === 0 ? void 0 : array[0];
      }
      function firstOrUndefinedIterator(iter) {
        if (iter) {
          for (const value of iter) {
            return value;
          }
        }
        return void 0;
      }
      function first(array) {
        Debug.assert(array.length !== 0);
        return array[0];
      }
      function firstIterator(iter) {
        for (const value of iter) {
          return value;
        }
        Debug.fail("iterator is empty");
      }
      function lastOrUndefined(array) {
        return array === void 0 || array.length === 0 ? void 0 : array[array.length - 1];
      }
      function last(array) {
        Debug.assert(array.length !== 0);
        return array[array.length - 1];
      }
      function singleOrUndefined(array) {
        return array && array.length === 1 ? array[0] : void 0;
      }
      function single(array) {
        return Debug.checkDefined(singleOrUndefined(array));
      }
      function singleOrMany(array) {
        return array && array.length === 1 ? array[0] : array;
      }
      function replaceElement(array, index, value) {
        const result = array.slice(0);
        result[index] = value;
        return result;
      }
      function binarySearch(array, value, keySelector, keyComparer, offset) {
        return binarySearchKey(array, keySelector(value), keySelector, keyComparer, offset);
      }
      function binarySearchKey(array, key, keySelector, keyComparer, offset) {
        if (!some(array)) {
          return -1;
        }
        let low = offset || 0;
        let high = array.length - 1;
        while (low <= high) {
          const middle = low + (high - low >> 1);
          const midKey = keySelector(array[middle], middle);
          switch (keyComparer(midKey, key)) {
            case -1:
              low = middle + 1;
              break;
            case 0:
              return middle;
            case 1:
              high = middle - 1;
              break;
          }
        }
        return ~low;
      }
      function reduceLeft(array, f, initial, start, count) {
        if (array && array.length > 0) {
          const size = array.length;
          if (size > 0) {
            let pos = start === void 0 || start < 0 ? 0 : start;
            const end = count === void 0 || pos + count > size - 1 ? size - 1 : pos + count;
            let result;
            if (arguments.length <= 2) {
              result = array[pos];
              pos++;
            } else {
              result = initial;
            }
            while (pos <= end) {
              result = f(result, array[pos], pos);
              pos++;
            }
            return result;
          }
        }
        return initial;
      }
      function hasProperty(map2, key) {
        return hasOwnProperty.call(map2, key);
      }
      function getProperty(map2, key) {
        return hasOwnProperty.call(map2, key) ? map2[key] : void 0;
      }
      function getOwnKeys(map2) {
        const keys = [];
        for (const key in map2) {
          if (hasOwnProperty.call(map2, key)) {
            keys.push(key);
          }
        }
        return keys;
      }
      function getAllKeys(obj) {
        const result = [];
        do {
          const names = Object.getOwnPropertyNames(obj);
          for (const name of names) {
            pushIfUnique(result, name);
          }
        } while (obj = Object.getPrototypeOf(obj));
        return result;
      }
      function getOwnValues(collection) {
        const values = [];
        for (const key in collection) {
          if (hasOwnProperty.call(collection, key)) {
            values.push(collection[key]);
          }
        }
        return values;
      }
      function arrayOf(count, f) {
        const result = new Array(count);
        for (let i = 0; i < count; i++) {
          result[i] = f(i);
        }
        return result;
      }
      function arrayFrom(iterator, map2) {
        const result = [];
        for (const value of iterator) {
          result.push(map2 ? map2(value) : value);
        }
        return result;
      }
      function assign(t, ...args) {
        for (const arg of args) {
          if (arg === void 0)
            continue;
          for (const p in arg) {
            if (hasProperty(arg, p)) {
              t[p] = arg[p];
            }
          }
        }
        return t;
      }
      function equalOwnProperties(left, right, equalityComparer = equateValues) {
        if (left === right)
          return true;
        if (!left || !right)
          return false;
        for (const key in left) {
          if (hasOwnProperty.call(left, key)) {
            if (!hasOwnProperty.call(right, key))
              return false;
            if (!equalityComparer(left[key], right[key]))
              return false;
          }
        }
        for (const key in right) {
          if (hasOwnProperty.call(right, key)) {
            if (!hasOwnProperty.call(left, key))
              return false;
          }
        }
        return true;
      }
      function arrayToMap(array, makeKey, makeValue = identity) {
        const result = /* @__PURE__ */ new Map();
        for (const value of array) {
          const key = makeKey(value);
          if (key !== void 0)
            result.set(key, makeValue(value));
        }
        return result;
      }
      function arrayToNumericMap(array, makeKey, makeValue = identity) {
        const result = [];
        for (const value of array) {
          result[makeKey(value)] = makeValue(value);
        }
        return result;
      }
      function arrayToMultiMap(values, makeKey, makeValue = identity) {
        const result = createMultiMap();
        for (const value of values) {
          result.add(makeKey(value), makeValue(value));
        }
        return result;
      }
      function group(values, getGroupId, resultSelector = identity) {
        return arrayFrom(arrayToMultiMap(values, getGroupId).values(), resultSelector);
      }
      function groupBy(values, keySelector) {
        var _a;
        const result = {};
        if (values) {
          for (const value of values) {
            const key = `${keySelector(value)}`;
            const array = (_a = result[key]) != null ? _a : result[key] = [];
            array.push(value);
          }
        }
        return result;
      }
      function clone(object) {
        const result = {};
        for (const id in object) {
          if (hasOwnProperty.call(object, id)) {
            result[id] = object[id];
          }
        }
        return result;
      }
      function extend(first2, second) {
        const result = {};
        for (const id in second) {
          if (hasOwnProperty.call(second, id)) {
            result[id] = second[id];
          }
        }
        for (const id in first2) {
          if (hasOwnProperty.call(first2, id)) {
            result[id] = first2[id];
          }
        }
        return result;
      }
      function copyProperties(first2, second) {
        for (const id in second) {
          if (hasOwnProperty.call(second, id)) {
            first2[id] = second[id];
          }
        }
      }
      function maybeBind(obj, fn) {
        return fn ? fn.bind(obj) : void 0;
      }
      function createMultiMap() {
        const map2 = /* @__PURE__ */ new Map();
        map2.add = multiMapAdd;
        map2.remove = multiMapRemove;
        return map2;
      }
      function multiMapAdd(key, value) {
        let values = this.get(key);
        if (values) {
          values.push(value);
        } else {
          this.set(key, values = [value]);
        }
        return values;
      }
      function multiMapRemove(key, value) {
        const values = this.get(key);
        if (values) {
          unorderedRemoveItem(values, value);
          if (!values.length) {
            this.delete(key);
          }
        }
      }
      function createQueue(items) {
        const elements = (items == null ? void 0 : items.slice()) || [];
        let headIndex = 0;
        function isEmpty() {
          return headIndex === elements.length;
        }
        function enqueue(...items2) {
          elements.push(...items2);
        }
        function dequeue() {
          if (isEmpty()) {
            throw new Error("Queue is empty");
          }
          const result = elements[headIndex];
          elements[headIndex] = void 0;
          headIndex++;
          if (headIndex > 100 && headIndex > elements.length >> 1) {
            const newLength = elements.length - headIndex;
            elements.copyWithin(
              /*target*/
              0,
              /*start*/
              headIndex
            );
            elements.length = newLength;
            headIndex = 0;
          }
          return result;
        }
        return {
          enqueue,
          dequeue,
          isEmpty
        };
      }
      function createSet(getHashCode, equals) {
        const multiMap = /* @__PURE__ */ new Map();
        let size = 0;
        function* getElementIterator() {
          for (const value of multiMap.values()) {
            if (isArray(value)) {
              yield* value;
            } else {
              yield value;
            }
          }
        }
        const set = {
          has(element) {
            const hash = getHashCode(element);
            if (!multiMap.has(hash))
              return false;
            const candidates = multiMap.get(hash);
            if (!isArray(candidates))
              return equals(candidates, element);
            for (const candidate of candidates) {
              if (equals(candidate, element)) {
                return true;
              }
            }
            return false;
          },
          add(element) {
            const hash = getHashCode(element);
            if (multiMap.has(hash)) {
              const values = multiMap.get(hash);
              if (isArray(values)) {
                if (!contains(values, element, equals)) {
                  values.push(element);
                  size++;
                }
              } else {
                const value = values;
                if (!equals(value, element)) {
                  multiMap.set(hash, [value, element]);
                  size++;
                }
              }
            } else {
              multiMap.set(hash, element);
              size++;
            }
            return this;
          },
          delete(element) {
            const hash = getHashCode(element);
            if (!multiMap.has(hash))
              return false;
            const candidates = multiMap.get(hash);
            if (isArray(candidates)) {
              for (let i = 0; i < candidates.length; i++) {
                if (equals(candidates[i], element)) {
                  if (candidates.length === 1) {
                    multiMap.delete(hash);
                  } else if (candidates.length === 2) {
                    multiMap.set(hash, candidates[1 - i]);
                  } else {
                    unorderedRemoveItemAt(candidates, i);
                  }
                  size--;
                  return true;
                }
              }
            } else {
              const candidate = candidates;
              if (equals(candidate, element)) {
                multiMap.delete(hash);
                size--;
                return true;
              }
            }
            return false;
          },
          clear() {
            multiMap.clear();
            size = 0;
          },
          get size() {
            return size;
          },
          forEach(action) {
            for (const elements of arrayFrom(multiMap.values())) {
              if (isArray(elements)) {
                for (const element of elements) {
                  action(element, element, set);
                }
              } else {
                const element = elements;
                action(element, element, set);
              }
            }
          },
          keys() {
            return getElementIterator();
          },
          values() {
            return getElementIterator();
          },
          *entries() {
            for (const value of getElementIterator()) {
              yield [value, value];
            }
          },
          [Symbol.iterator]: () => {
            return getElementIterator();
          },
          [Symbol.toStringTag]: multiMap[Symbol.toStringTag]
        };
        return set;
      }
      function isArray(value) {
        return Array.isArray(value);
      }
      function toArray(value) {
        return isArray(value) ? value : [value];
      }
      function isString(text) {
        return typeof text === "string";
      }
      function isNumber(x) {
        return typeof x === "number";
      }
      function tryCast(value, test) {
        return value !== void 0 && test(value) ? value : void 0;
      }
      function cast(value, test) {
        if (value !== void 0 && test(value))
          return value;
        return Debug.fail(`Invalid cast. The supplied value ${value} did not pass the test '${Debug.getFunctionName(test)}'.`);
      }
      function noop(_) {
      }
      function returnFalse() {
        return false;
      }
      function returnTrue() {
        return true;
      }
      function returnUndefined() {
        return void 0;
      }
      function identity(x) {
        return x;
      }
      function toLowerCase(x) {
        return x.toLowerCase();
      }
      function toFileNameLowerCase(x) {
        return fileNameLowerCaseRegExp.test(x) ? x.replace(fileNameLowerCaseRegExp, toLowerCase) : x;
      }
      function notImplemented() {
        throw new Error("Not implemented");
      }
      function memoize(callback) {
        let value;
        return () => {
          if (callback) {
            value = callback();
            callback = void 0;
          }
          return value;
        };
      }
      function memoizeOne(callback) {
        const map2 = /* @__PURE__ */ new Map();
        return (arg) => {
          const key = `${typeof arg}:${arg}`;
          let value = map2.get(key);
          if (value === void 0 && !map2.has(key)) {
            value = callback(arg);
            map2.set(key, value);
          }
          return value;
        };
      }
      function memoizeWeak(callback) {
        const map2 = /* @__PURE__ */ new WeakMap();
        return (arg) => {
          let value = map2.get(arg);
          if (value === void 0 && !map2.has(arg)) {
            value = callback(arg);
            map2.set(arg, value);
          }
          return value;
        };
      }
      function memoizeCached(callback, cache) {
        return (...args) => {
          let value = cache.get(args);
          if (value === void 0 && !cache.has(args)) {
            value = callback(...args);
            cache.set(args, value);
          }
          return value;
        };
      }
      function compose(a, b, c, d, e) {
        if (!!e) {
          const args = [];
          for (let i = 0; i < arguments.length; i++) {
            args[i] = arguments[i];
          }
          return (t) => reduceLeft(args, (u, f) => f(u), t);
        } else if (d) {
          return (t) => d(c(b(a(t))));
        } else if (c) {
          return (t) => c(b(a(t)));
        } else if (b) {
          return (t) => b(a(t));
        } else if (a) {
          return (t) => a(t);
        } else {
          return (t) => t;
        }
      }
      function equateValues(a, b) {
        return a === b;
      }
      function equateStringsCaseInsensitive(a, b) {
        return a === b || a !== void 0 && b !== void 0 && a.toUpperCase() === b.toUpperCase();
      }
      function equateStringsCaseSensitive(a, b) {
        return equateValues(a, b);
      }
      function compareComparableValues(a, b) {
        return a === b ? 0 : a === void 0 ? -1 : b === void 0 ? 1 : a < b ? -1 : 1;
      }
      function compareValues(a, b) {
        return compareComparableValues(a, b);
      }
      function compareTextSpans(a, b) {
        return compareValues(a == null ? void 0 : a.start, b == null ? void 0 : b.start) || compareValues(a == null ? void 0 : a.length, b == null ? void 0 : b.length);
      }
      function min(items, compare) {
        return reduceLeft(items, (x, y) => compare(x, y) === -1 ? x : y);
      }
      function compareStringsCaseInsensitive(a, b) {
        if (a === b)
          return 0;
        if (a === void 0)
          return -1;
        if (b === void 0)
          return 1;
        a = a.toUpperCase();
        b = b.toUpperCase();
        return a < b ? -1 : a > b ? 1 : 0;
      }
      function compareStringsCaseInsensitiveEslintCompatible(a, b) {
        if (a === b)
          return 0;
        if (a === void 0)
          return -1;
        if (b === void 0)
          return 1;
        a = a.toLowerCase();
        b = b.toLowerCase();
        return a < b ? -1 : a > b ? 1 : 0;
      }
      function compareStringsCaseSensitive(a, b) {
        return compareComparableValues(a, b);
      }
      function getStringComparer(ignoreCase) {
        return ignoreCase ? compareStringsCaseInsensitive : compareStringsCaseSensitive;
      }
      function getUILocale() {
        return uiLocale;
      }
      function setUILocale(value) {
        if (uiLocale !== value) {
          uiLocale = value;
          uiComparerCaseSensitive = void 0;
        }
      }
      function compareStringsCaseSensitiveUI(a, b) {
        const comparer = uiComparerCaseSensitive || (uiComparerCaseSensitive = createUIStringComparer(uiLocale));
        return comparer(a, b);
      }
      function compareProperties(a, b, key, comparer) {
        return a === b ? 0 : a === void 0 ? -1 : b === void 0 ? 1 : comparer(a[key], b[key]);
      }
      function compareBooleans(a, b) {
        return compareValues(a ? 1 : 0, b ? 1 : 0);
      }
      function getSpellingSuggestion(name, candidates, getName) {
        const maximumLengthDifference = Math.max(2, Math.floor(name.length * 0.34));
        let bestDistance = Math.floor(name.length * 0.4) + 1;
        let bestCandidate;
        for (const candidate of candidates) {
          const candidateName = getName(candidate);
          if (candidateName !== void 0 && Math.abs(candidateName.length - name.length) <= maximumLengthDifference) {
            if (candidateName === name) {
              continue;
            }
            if (candidateName.length < 3 && candidateName.toLowerCase() !== name.toLowerCase()) {
              continue;
            }
            const distance = levenshteinWithMax(name, candidateName, bestDistance - 0.1);
            if (distance === void 0) {
              continue;
            }
            Debug.assert(distance < bestDistance);
            bestDistance = distance;
            bestCandidate = candidate;
          }
        }
        return bestCandidate;
      }
      function levenshteinWithMax(s1, s2, max) {
        let previous = new Array(s2.length + 1);
        let current = new Array(s2.length + 1);
        const big = max + 0.01;
        for (let i = 0; i <= s2.length; i++) {
          previous[i] = i;
        }
        for (let i = 1; i <= s1.length; i++) {
          const c1 = s1.charCodeAt(i - 1);
          const minJ = Math.ceil(i > max ? i - max : 1);
          const maxJ = Math.floor(s2.length > max + i ? max + i : s2.length);
          current[0] = i;
          let colMin = i;
          for (let j = 1; j < minJ; j++) {
            current[j] = big;
          }
          for (let j = minJ; j <= maxJ; j++) {
            const substitutionDistance = s1[i - 1].toLowerCase() === s2[j - 1].toLowerCase() ? previous[j - 1] + 0.1 : previous[j - 1] + 2;
            const dist = c1 === s2.charCodeAt(j - 1) ? previous[j - 1] : Math.min(
              /*delete*/
              previous[j] + 1,
              /*insert*/
              current[j - 1] + 1,
              /*substitute*/
              substitutionDistance
            );
            current[j] = dist;
            colMin = Math.min(colMin, dist);
          }
          for (let j = maxJ + 1; j <= s2.length; j++) {
            current[j] = big;
          }
          if (colMin > max) {
            return void 0;
          }
          const temp = previous;
          previous = current;
          current = temp;
        }
        const res = previous[s2.length];
        return res > max ? void 0 : res;
      }
      function endsWith(str, suffix) {
        const expectedPos = str.length - suffix.length;
        return expectedPos >= 0 && str.indexOf(suffix, expectedPos) === expectedPos;
      }
      function removeSuffix(str, suffix) {
        return endsWith(str, suffix) ? str.slice(0, str.length - suffix.length) : str;
      }
      function tryRemoveSuffix(str, suffix) {
        return endsWith(str, suffix) ? str.slice(0, str.length - suffix.length) : void 0;
      }
      function removeMinAndVersionNumbers(fileName) {
        let end = fileName.length;
        for (let pos = end - 1; pos > 0; pos--) {
          let ch = fileName.charCodeAt(pos);
          if (ch >= 48 && ch <= 57) {
            do {
              --pos;
              ch = fileName.charCodeAt(pos);
            } while (pos > 0 && ch >= 48 && ch <= 57);
          } else if (pos > 4 && (ch === 110 || ch === 78)) {
            --pos;
            ch = fileName.charCodeAt(pos);
            if (ch !== 105 && ch !== 73) {
              break;
            }
            --pos;
            ch = fileName.charCodeAt(pos);
            if (ch !== 109 && ch !== 77) {
              break;
            }
            --pos;
            ch = fileName.charCodeAt(pos);
          } else {
            break;
          }
          if (ch !== 45 && ch !== 46) {
            break;
          }
          end = pos;
        }
        return end === fileName.length ? fileName : fileName.slice(0, end);
      }
      function orderedRemoveItem(array, item) {
        for (let i = 0; i < array.length; i++) {
          if (array[i] === item) {
            orderedRemoveItemAt(array, i);
            return true;
          }
        }
        return false;
      }
      function orderedRemoveItemAt(array, index) {
        for (let i = index; i < array.length - 1; i++) {
          array[i] = array[i + 1];
        }
        array.pop();
      }
      function unorderedRemoveItemAt(array, index) {
        array[index] = array[array.length - 1];
        array.pop();
      }
      function unorderedRemoveItem(array, item) {
        return unorderedRemoveFirstItemWhere(array, (element) => element === item);
      }
      function unorderedRemoveFirstItemWhere(array, predicate) {
        for (let i = 0; i < array.length; i++) {
          if (predicate(array[i])) {
            unorderedRemoveItemAt(array, i);
            return true;
          }
        }
        return false;
      }
      function createGetCanonicalFileName(useCaseSensitiveFileNames2) {
        return useCaseSensitiveFileNames2 ? identity : toFileNameLowerCase;
      }
      function patternText({ prefix, suffix }) {
        return `${prefix}*${suffix}`;
      }
      function matchedText(pattern, candidate) {
        Debug.assert(isPatternMatch(pattern, candidate));
        return candidate.substring(pattern.prefix.length, candidate.length - pattern.suffix.length);
      }
      function findBestPatternMatch(values, getPattern, candidate) {
        let matchedValue;
        let longestMatchPrefixLength = -1;
        for (const v of values) {
          const pattern = getPattern(v);
          if (isPatternMatch(pattern, candidate) && pattern.prefix.length > longestMatchPrefixLength) {
            longestMatchPrefixLength = pattern.prefix.length;
            matchedValue = v;
          }
        }
        return matchedValue;
      }
      function startsWith(str, prefix) {
        return str.lastIndexOf(prefix, 0) === 0;
      }
      function removePrefix(str, prefix) {
        return startsWith(str, prefix) ? str.substr(prefix.length) : str;
      }
      function tryRemovePrefix(str, prefix, getCanonicalFileName = identity) {
        return startsWith(getCanonicalFileName(str), getCanonicalFileName(prefix)) ? str.substring(prefix.length) : void 0;
      }
      function isPatternMatch({ prefix, suffix }, candidate) {
        return candidate.length >= prefix.length + suffix.length && startsWith(candidate, prefix) && endsWith(candidate, suffix);
      }
      function and(f, g) {
        return (arg) => f(arg) && g(arg);
      }
      function or(...fs) {
        return (...args) => {
          let lastResult;
          for (const f of fs) {
            lastResult = f(...args);
            if (lastResult) {
              return lastResult;
            }
          }
          return lastResult;
        };
      }
      function not(fn) {
        return (...args) => !fn(...args);
      }
      function assertType(_) {
      }
      function singleElementArray(t) {
        return t === void 0 ? void 0 : [t];
      }
      function enumerateInsertsAndDeletes(newItems, oldItems, comparer, inserted, deleted, unchanged) {
        unchanged = unchanged || noop;
        let newIndex = 0;
        let oldIndex = 0;
        const newLen = newItems.length;
        const oldLen = oldItems.length;
        let hasChanges = false;
        while (newIndex < newLen && oldIndex < oldLen) {
          const newItem = newItems[newIndex];
          const oldItem = oldItems[oldIndex];
          const compareResult = comparer(newItem, oldItem);
          if (compareResult === -1) {
            inserted(newItem);
            newIndex++;
            hasChanges = true;
          } else if (compareResult === 1) {
            deleted(oldItem);
            oldIndex++;
            hasChanges = true;
          } else {
            unchanged(oldItem, newItem);
            newIndex++;
            oldIndex++;
          }
        }
        while (newIndex < newLen) {
          inserted(newItems[newIndex++]);
          hasChanges = true;
        }
        while (oldIndex < oldLen) {
          deleted(oldItems[oldIndex++]);
          hasChanges = true;
        }
        return hasChanges;
      }
      function cartesianProduct(arrays) {
        const result = [];
        cartesianProductWorker(
          arrays,
          result,
          /*outer*/
          void 0,
          0
        );
        return result;
      }
      function cartesianProductWorker(arrays, result, outer, index) {
        for (const element of arrays[index]) {
          let inner;
          if (outer) {
            inner = outer.slice();
            inner.push(element);
          } else {
            inner = [element];
          }
          if (index === arrays.length - 1) {
            result.push(inner);
          } else {
            cartesianProductWorker(arrays, result, inner, index + 1);
          }
        }
      }
      function takeWhile(array, predicate) {
        if (array) {
          const len = array.length;
          let index = 0;
          while (index < len && predicate(array[index])) {
            index++;
          }
          return array.slice(0, index);
        }
      }
      function skipWhile(array, predicate) {
        if (array) {
          const len = array.length;
          let index = 0;
          while (index < len && predicate(array[index])) {
            index++;
          }
          return array.slice(index);
        }
      }
      function isNodeLikeSystem() {
        return typeof process !== "undefined" && !!process.nextTick && !process.browser && typeof module2 === "object";
      }
      var emptyArray, emptyMap, emptySet, SortKind, elementAt, hasOwnProperty, fileNameLowerCaseRegExp, AssertionLevel, createUIStringComparer, uiComparerCaseSensitive, uiLocale;
      var init_core = __esm({
        "src/compiler/core.ts"() {
          "use strict";
          init_ts2();
          emptyArray = [];
          emptyMap = /* @__PURE__ */ new Map();
          emptySet = /* @__PURE__ */ new Set();
          SortKind = ((SortKind2) => {
            SortKind2[SortKind2["None"] = 0] = "None";
            SortKind2[SortKind2["CaseSensitive"] = 1] = "CaseSensitive";
            SortKind2[SortKind2["CaseInsensitive"] = 2] = "CaseInsensitive";
            SortKind2[SortKind2["Both"] = 3] = "Both";
            return SortKind2;
          })(SortKind || {});
          elementAt = !!Array.prototype.at ? (array, offset) => array == null ? void 0 : array.at(offset) : (array, offset) => {
            if (array) {
              offset = toOffset(array, offset);
              if (offset < array.length) {
                return array[offset];
              }
            }
            return void 0;
          };
          hasOwnProperty = Object.prototype.hasOwnProperty;
          fileNameLowerCaseRegExp = /[^\u0130\u0131\u00DFa-z0-9\\/:\-_. ]+/g;
          AssertionLevel = ((AssertionLevel2) => {
            AssertionLevel2[AssertionLevel2["None"] = 0] = "None";
            AssertionLevel2[AssertionLevel2["Normal"] = 1] = "Normal";
            AssertionLevel2[AssertionLevel2["Aggressive"] = 2] = "Aggressive";
            AssertionLevel2[AssertionLevel2["VeryAggressive"] = 3] = "VeryAggressive";
            return AssertionLevel2;
          })(AssertionLevel || {});
          createUIStringComparer = (() => {
            return createIntlCollatorStringComparer;
            function compareWithCallback(a, b, comparer) {
              if (a === b)
                return 0;
              if (a === void 0)
                return -1;
              if (b === void 0)
                return 1;
              const value = comparer(a, b);
              return value < 0 ? -1 : value > 0 ? 1 : 0;
            }
            function createIntlCollatorStringComparer(locale) {
              const comparer = new Intl.Collator(locale, { usage: "sort", sensitivity: "variant" }).compare;
              return (a, b) => compareWithCallback(a, b, comparer);
            }
          })();
        }
      });
      var LogLevel, Debug;
      var init_debug = __esm({
        "src/compiler/debug.ts"() {
          "use strict";
          init_ts2();
          init_ts2();
          LogLevel = ((LogLevel3) => {
            LogLevel3[LogLevel3["Off"] = 0] = "Off";
            LogLevel3[LogLevel3["Error"] = 1] = "Error";
            LogLevel3[LogLevel3["Warning"] = 2] = "Warning";
            LogLevel3[LogLevel3["Info"] = 3] = "Info";
            LogLevel3[LogLevel3["Verbose"] = 4] = "Verbose";
            return LogLevel3;
          })(LogLevel || {});
          ((Debug2) => {
            let currentAssertionLevel = 0;
            Debug2.currentLogLevel = 2;
            Debug2.isDebugging = false;
            function shouldLog(level) {
              return Debug2.currentLogLevel <= level;
            }
            Debug2.shouldLog = shouldLog;
            function logMessage(level, s) {
              if (Debug2.loggingHost && shouldLog(level)) {
                Debug2.loggingHost.log(level, s);
              }
            }
            function log(s) {
              logMessage(3, s);
            }
            Debug2.log = log;
            ((_log) => {
              function error2(s) {
                logMessage(1, s);
              }
              _log.error = error2;
              function warn(s) {
                logMessage(2, s);
              }
              _log.warn = warn;
              function log2(s) {
                logMessage(3, s);
              }
              _log.log = log2;
              function trace2(s) {
                logMessage(4, s);
              }
              _log.trace = trace2;
            })(log = Debug2.log || (Debug2.log = {}));
            const assertionCache = {};
            function getAssertionLevel() {
              return currentAssertionLevel;
            }
            Debug2.getAssertionLevel = getAssertionLevel;
            function setAssertionLevel(level) {
              const prevAssertionLevel = currentAssertionLevel;
              currentAssertionLevel = level;
              if (level > prevAssertionLevel) {
                for (const key of getOwnKeys(assertionCache)) {
                  const cachedFunc = assertionCache[key];
                  if (cachedFunc !== void 0 && Debug2[key] !== cachedFunc.assertion && level >= cachedFunc.level) {
                    Debug2[key] = cachedFunc;
                    assertionCache[key] = void 0;
                  }
                }
              }
            }
            Debug2.setAssertionLevel = setAssertionLevel;
            function shouldAssert(level) {
              return currentAssertionLevel >= level;
            }
            Debug2.shouldAssert = shouldAssert;
            function shouldAssertFunction(level, name) {
              if (!shouldAssert(level)) {
                assertionCache[name] = { level, assertion: Debug2[name] };
                Debug2[name] = noop;
                return false;
              }
              return true;
            }
            function fail(message, stackCrawlMark) {
              debugger;
              const e = new Error(message ? `Debug Failure. ${message}` : "Debug Failure.");
              if (Error.captureStackTrace) {
                Error.captureStackTrace(e, stackCrawlMark || fail);
              }
              throw e;
            }
            Debug2.fail = fail;
            function failBadSyntaxKind(node, message, stackCrawlMark) {
              return fail(
                `${message || "Unexpected node."}\r
Node ${formatSyntaxKind(node.kind)} was unexpected.`,
                stackCrawlMark || failBadSyntaxKind
              );
            }
            Debug2.failBadSyntaxKind = failBadSyntaxKind;
            function assert(expression, message, verboseDebugInfo, stackCrawlMark) {
              if (!expression) {
                message = message ? `False expression: ${message}` : "False expression.";
                if (verboseDebugInfo) {
                  message += "\r\nVerbose Debug Information: " + (typeof verboseDebugInfo === "string" ? verboseDebugInfo : verboseDebugInfo());
                }
                fail(message, stackCrawlMark || assert);
              }
            }
            Debug2.assert = assert;
            function assertEqual(a, b, msg, msg2, stackCrawlMark) {
              if (a !== b) {
                const message = msg ? msg2 ? `${msg} ${msg2}` : msg : "";
                fail(`Expected ${a} === ${b}. ${message}`, stackCrawlMark || assertEqual);
              }
            }
            Debug2.assertEqual = assertEqual;
            function assertLessThan(a, b, msg, stackCrawlMark) {
              if (a >= b) {
                fail(`Expected ${a} < ${b}. ${msg || ""}`, stackCrawlMark || assertLessThan);
              }
            }
            Debug2.assertLessThan = assertLessThan;
            function assertLessThanOrEqual(a, b, stackCrawlMark) {
              if (a > b) {
                fail(`Expected ${a} <= ${b}`, stackCrawlMark || assertLessThanOrEqual);
              }
            }
            Debug2.assertLessThanOrEqual = assertLessThanOrEqual;
            function assertGreaterThanOrEqual(a, b, stackCrawlMark) {
              if (a < b) {
                fail(`Expected ${a} >= ${b}`, stackCrawlMark || assertGreaterThanOrEqual);
              }
            }
            Debug2.assertGreaterThanOrEqual = assertGreaterThanOrEqual;
            function assertIsDefined(value, message, stackCrawlMark) {
              if (value === void 0 || value === null) {
                fail(message, stackCrawlMark || assertIsDefined);
              }
            }
            Debug2.assertIsDefined = assertIsDefined;
            function checkDefined(value, message, stackCrawlMark) {
              assertIsDefined(value, message, stackCrawlMark || checkDefined);
              return value;
            }
            Debug2.checkDefined = checkDefined;
            function assertEachIsDefined(value, message, stackCrawlMark) {
              for (const v of value) {
                assertIsDefined(v, message, stackCrawlMark || assertEachIsDefined);
              }
            }
            Debug2.assertEachIsDefined = assertEachIsDefined;
            function checkEachDefined(value, message, stackCrawlMark) {
              assertEachIsDefined(value, message, stackCrawlMark || checkEachDefined);
              return value;
            }
            Debug2.checkEachDefined = checkEachDefined;
            function assertNever(member, message = "Illegal value:", stackCrawlMark) {
              const detail = typeof member === "object" && hasProperty(member, "kind") && hasProperty(member, "pos") ? "SyntaxKind: " + formatSyntaxKind(member.kind) : JSON.stringify(member);
              return fail(`${message} ${detail}`, stackCrawlMark || assertNever);
            }
            Debug2.assertNever = assertNever;
            function assertEachNode(nodes, test, message, stackCrawlMark) {
              if (shouldAssertFunction(1, "assertEachNode")) {
                assert(
                  test === void 0 || every(nodes, test),
                  message || "Unexpected node.",
                  () => `Node array did not pass test '${getFunctionName(test)}'.`,
                  stackCrawlMark || assertEachNode
                );
              }
            }
            Debug2.assertEachNode = assertEachNode;
            function assertNode(node, test, message, stackCrawlMark) {
              if (shouldAssertFunction(1, "assertNode")) {
                assert(
                  node !== void 0 && (test === void 0 || test(node)),
                  message || "Unexpected node.",
                  () => `Node ${formatSyntaxKind(node == null ? void 0 : node.kind)} did not pass test '${getFunctionName(test)}'.`,
                  stackCrawlMark || assertNode
                );
              }
            }
            Debug2.assertNode = assertNode;
            function assertNotNode(node, test, message, stackCrawlMark) {
              if (shouldAssertFunction(1, "assertNotNode")) {
                assert(
                  node === void 0 || test === void 0 || !test(node),
                  message || "Unexpected node.",
                  () => `Node ${formatSyntaxKind(node.kind)} should not have passed test '${getFunctionName(test)}'.`,
                  stackCrawlMark || assertNotNode
                );
              }
            }
            Debug2.assertNotNode = assertNotNode;
            function assertOptionalNode(node, test, message, stackCrawlMark) {
              if (shouldAssertFunction(1, "assertOptionalNode")) {
                assert(
                  test === void 0 || node === void 0 || test(node),
                  message || "Unexpected node.",
                  () => `Node ${formatSyntaxKind(node == null ? void 0 : node.kind)} did not pass test '${getFunctionName(test)}'.`,
                  stackCrawlMark || assertOptionalNode
                );
              }
            }
            Debug2.assertOptionalNode = assertOptionalNode;
            function assertOptionalToken(node, kind, message, stackCrawlMark) {
              if (shouldAssertFunction(1, "assertOptionalToken")) {
                assert(
                  kind === void 0 || node === void 0 || node.kind === kind,
                  message || "Unexpected node.",
                  () => `Node ${formatSyntaxKind(node == null ? void 0 : node.kind)} was not a '${formatSyntaxKind(kind)}' token.`,
                  stackCrawlMark || assertOptionalToken
                );
              }
            }
            Debug2.assertOptionalToken = assertOptionalToken;
            function assertMissingNode(node, message, stackCrawlMark) {
              if (shouldAssertFunction(1, "assertMissingNode")) {
                assert(
                  node === void 0,
                  message || "Unexpected node.",
                  () => `Node ${formatSyntaxKind(node.kind)} was unexpected'.`,
                  stackCrawlMark || assertMissingNode
                );
              }
            }
            Debug2.assertMissingNode = assertMissingNode;
            function type(_value) {
            }
            Debug2.type = type;
            function getFunctionName(func) {
              if (typeof func !== "function") {
                return "";
              } else if (hasProperty(func, "name")) {
                return func.name;
              } else {
                const text = Function.prototype.toString.call(func);
                const match = /^function\s+([\w$]+)\s*\(/.exec(text);
                return match ? match[1] : "";
              }
            }
            Debug2.getFunctionName = getFunctionName;
            function formatSymbol(symbol) {
              return `{ name: ${unescapeLeadingUnderscores(symbol.escapedName)}; flags: ${formatSymbolFlags(symbol.flags)}; declarations: ${map(symbol.declarations, (node) => formatSyntaxKind(node.kind))} }`;
            }
            Debug2.formatSymbol = formatSymbol;
            function formatEnum(value = 0, enumObject, isFlags) {
              const members = getEnumMembers(enumObject);
              if (value === 0) {
                return members.length > 0 && members[0][0] === 0 ? members[0][1] : "0";
              }
              if (isFlags) {
                const result = [];
                let remainingFlags = value;
                for (const [enumValue, enumName] of members) {
                  if (enumValue > value) {
                    break;
                  }
                  if (enumValue !== 0 && enumValue & value) {
                    result.push(enumName);
                    remainingFlags &= ~enumValue;
                  }
                }
                if (remainingFlags === 0) {
                  return result.join("|");
                }
              } else {
                for (const [enumValue, enumName] of members) {
                  if (enumValue === value) {
                    return enumName;
                  }
                }
              }
              return value.toString();
            }
            Debug2.formatEnum = formatEnum;
            const enumMemberCache = /* @__PURE__ */ new Map();
            function getEnumMembers(enumObject) {
              const existing = enumMemberCache.get(enumObject);
              if (existing) {
                return existing;
              }
              const result = [];
              for (const name in enumObject) {
                const value = enumObject[name];
                if (typeof value === "number") {
                  result.push([value, name]);
                }
              }
              const sorted = stableSort(result, (x, y) => compareValues(x[0], y[0]));
              enumMemberCache.set(enumObject, sorted);
              return sorted;
            }
            function formatSyntaxKind(kind) {
              return formatEnum(
                kind,
                SyntaxKind,
                /*isFlags*/
                false
              );
            }
            Debug2.formatSyntaxKind = formatSyntaxKind;
            function formatSnippetKind(kind) {
              return formatEnum(
                kind,
                SnippetKind,
                /*isFlags*/
                false
              );
            }
            Debug2.formatSnippetKind = formatSnippetKind;
            function formatScriptKind(kind) {
              return formatEnum(
                kind,
                ScriptKind,
                /*isFlags*/
                false
              );
            }
            Debug2.formatScriptKind = formatScriptKind;
            function formatNodeFlags(flags) {
              return formatEnum(
                flags,
                NodeFlags,
                /*isFlags*/
                true
              );
            }
            Debug2.formatNodeFlags = formatNodeFlags;
            function formatModifierFlags(flags) {
              return formatEnum(
                flags,
                ModifierFlags,
                /*isFlags*/
                true
              );
            }
            Debug2.formatModifierFlags = formatModifierFlags;
            function formatTransformFlags(flags) {
              return formatEnum(
                flags,
                TransformFlags,
                /*isFlags*/
                true
              );
            }
            Debug2.formatTransformFlags = formatTransformFlags;
            function formatEmitFlags(flags) {
              return formatEnum(
                flags,
                EmitFlags,
                /*isFlags*/
                true
              );
            }
            Debug2.formatEmitFlags = formatEmitFlags;
            function formatSymbolFlags(flags) {
              return formatEnum(
                flags,
                SymbolFlags,
                /*isFlags*/
                true
              );
            }
            Debug2.formatSymbolFlags = formatSymbolFlags;
            function formatTypeFlags(flags) {
              return formatEnum(
                flags,
                TypeFlags,
                /*isFlags*/
                true
              );
            }
            Debug2.formatTypeFlags = formatTypeFlags;
            function formatSignatureFlags(flags) {
              return formatEnum(
                flags,
                SignatureFlags,
                /*isFlags*/
                true
              );
            }
            Debug2.formatSignatureFlags = formatSignatureFlags;
            function formatObjectFlags(flags) {
              return formatEnum(
                flags,
                ObjectFlags,
                /*isFlags*/
                true
              );
            }
            Debug2.formatObjectFlags = formatObjectFlags;
            function formatFlowFlags(flags) {
              return formatEnum(
                flags,
                FlowFlags,
                /*isFlags*/
                true
              );
            }
            Debug2.formatFlowFlags = formatFlowFlags;
            function formatRelationComparisonResult(result) {
              return formatEnum(
                result,
                RelationComparisonResult,
                /*isFlags*/
                true
              );
            }
            Debug2.formatRelationComparisonResult = formatRelationComparisonResult;
            function formatCheckMode(mode) {
              return formatEnum(
                mode,
                CheckMode,
                /*isFlags*/
                true
              );
            }
            Debug2.formatCheckMode = formatCheckMode;
            function formatSignatureCheckMode(mode) {
              return formatEnum(
                mode,
                SignatureCheckMode,
                /*isFlags*/
                true
              );
            }
            Debug2.formatSignatureCheckMode = formatSignatureCheckMode;
            function formatTypeFacts(facts) {
              return formatEnum(
                facts,
                TypeFacts,
                /*isFlags*/
                true
              );
            }
            Debug2.formatTypeFacts = formatTypeFacts;
            let isDebugInfoEnabled = false;
            let flowNodeProto;
            function attachFlowNodeDebugInfoWorker(flowNode) {
              if (!("__debugFlowFlags" in flowNode)) {
                Object.defineProperties(flowNode, {
                  // for use with vscode-js-debug's new customDescriptionGenerator in launch.json
                  __tsDebuggerDisplay: {
                    value() {
                      const flowHeader = this.flags & 2 ? "FlowStart" : this.flags & 4 ? "FlowBranchLabel" : this.flags & 8 ? "FlowLoopLabel" : this.flags & 16 ? "FlowAssignment" : this.flags & 32 ? "FlowTrueCondition" : this.flags & 64 ? "FlowFalseCondition" : this.flags & 128 ? "FlowSwitchClause" : this.flags & 256 ? "FlowArrayMutation" : this.flags & 512 ? "FlowCall" : this.flags & 1024 ? "FlowReduceLabel" : this.flags & 1 ? "FlowUnreachable" : "UnknownFlow";
                      const remainingFlags = this.flags & ~(2048 - 1);
                      return `${flowHeader}${remainingFlags ? ` (${formatFlowFlags(remainingFlags)})` : ""}`;
                    }
                  },
                  __debugFlowFlags: {
                    get() {
                      return formatEnum(
                        this.flags,
                        FlowFlags,
                        /*isFlags*/
                        true
                      );
                    }
                  },
                  __debugToString: {
                    value() {
                      return formatControlFlowGraph(this);
                    }
                  }
                });
              }
            }
            function attachFlowNodeDebugInfo(flowNode) {
              if (isDebugInfoEnabled) {
                if (typeof Object.setPrototypeOf === "function") {
                  if (!flowNodeProto) {
                    flowNodeProto = Object.create(Object.prototype);
                    attachFlowNodeDebugInfoWorker(flowNodeProto);
                  }
                  Object.setPrototypeOf(flowNode, flowNodeProto);
                } else {
                  attachFlowNodeDebugInfoWorker(flowNode);
                }
              }
            }
            Debug2.attachFlowNodeDebugInfo = attachFlowNodeDebugInfo;
            let nodeArrayProto;
            function attachNodeArrayDebugInfoWorker(array) {
              if (!("__tsDebuggerDisplay" in array)) {
                Object.defineProperties(array, {
                  __tsDebuggerDisplay: {
                    value(defaultValue) {
                      defaultValue = String(defaultValue).replace(/(?:,[\s\w\d_]+:[^,]+)+\]$/, "]");
                      return `NodeArray ${defaultValue}`;
                    }
                  }
                });
              }
            }
            function attachNodeArrayDebugInfo(array) {
              if (isDebugInfoEnabled) {
                if (typeof Object.setPrototypeOf === "function") {
                  if (!nodeArrayProto) {
                    nodeArrayProto = Object.create(Array.prototype);
                    attachNodeArrayDebugInfoWorker(nodeArrayProto);
                  }
                  Object.setPrototypeOf(array, nodeArrayProto);
                } else {
                  attachNodeArrayDebugInfoWorker(array);
                }
              }
            }
            Debug2.attachNodeArrayDebugInfo = attachNodeArrayDebugInfo;
            function enableDebugInfo() {
              if (isDebugInfoEnabled)
                return;
              const weakTypeTextMap = /* @__PURE__ */ new WeakMap();
              const weakNodeTextMap = /* @__PURE__ */ new WeakMap();
              Object.defineProperties(objectAllocator.getSymbolConstructor().prototype, {
                // for use with vscode-js-debug's new customDescriptionGenerator in launch.json
                __tsDebuggerDisplay: {
                  value() {
                    const symbolHeader = this.flags & 33554432 ? "TransientSymbol" : "Symbol";
                    const remainingSymbolFlags = this.flags & ~33554432;
                    return `${symbolHeader} '${symbolName(this)}'${remainingSymbolFlags ? ` (${formatSymbolFlags(remainingSymbolFlags)})` : ""}`;
                  }
                },
                __debugFlags: {
                  get() {
                    return formatSymbolFlags(this.flags);
                  }
                }
              });
              Object.defineProperties(objectAllocator.getTypeConstructor().prototype, {
                // for use with vscode-js-debug's new customDescriptionGenerator in launch.json
                __tsDebuggerDisplay: {
                  value() {
                    const typeHeader = this.flags & 67359327 ? `IntrinsicType ${this.intrinsicName}${this.debugIntrinsicName ? ` (${this.debugIntrinsicName})` : ""}` : this.flags & 98304 ? "NullableType" : this.flags & 384 ? `LiteralType ${JSON.stringify(this.value)}` : this.flags & 2048 ? `LiteralType ${this.value.negative ? "-" : ""}${this.value.base10Value}n` : this.flags & 8192 ? "UniqueESSymbolType" : this.flags & 32 ? "EnumType" : this.flags & 1048576 ? "UnionType" : this.flags & 2097152 ? "IntersectionType" : this.flags & 4194304 ? "IndexType" : this.flags & 8388608 ? "IndexedAccessType" : this.flags & 16777216 ? "ConditionalType" : this.flags & 33554432 ? "SubstitutionType" : this.flags & 262144 ? "TypeParameter" : this.flags & 524288 ? this.objectFlags & 3 ? "InterfaceType" : this.objectFlags & 4 ? "TypeReference" : this.objectFlags & 8 ? "TupleType" : this.objectFlags & 16 ? "AnonymousType" : this.objectFlags & 32 ? "MappedType" : this.objectFlags & 1024 ? "ReverseMappedType" : this.objectFlags & 256 ? "EvolvingArrayType" : "ObjectType" : "Type";
                    const remainingObjectFlags = this.flags & 524288 ? this.objectFlags & ~1343 : 0;
                    return `${typeHeader}${this.symbol ? ` '${symbolName(this.symbol)}'` : ""}${remainingObjectFlags ? ` (${formatObjectFlags(remainingObjectFlags)})` : ""}`;
                  }
                },
                __debugFlags: {
                  get() {
                    return formatTypeFlags(this.flags);
                  }
                },
                __debugObjectFlags: {
                  get() {
                    return this.flags & 524288 ? formatObjectFlags(this.objectFlags) : "";
                  }
                },
                __debugTypeToString: {
                  value() {
                    let text = weakTypeTextMap.get(this);
                    if (text === void 0) {
                      text = this.checker.typeToString(this);
                      weakTypeTextMap.set(this, text);
                    }
                    return text;
                  }
                }
              });
              Object.defineProperties(objectAllocator.getSignatureConstructor().prototype, {
                __debugFlags: {
                  get() {
                    return formatSignatureFlags(this.flags);
                  }
                },
                __debugSignatureToString: {
                  value() {
                    var _a;
                    return (_a = this.checker) == null ? void 0 : _a.signatureToString(this);
                  }
                }
              });
              const nodeConstructors = [
                objectAllocator.getNodeConstructor(),
                objectAllocator.getIdentifierConstructor(),
                objectAllocator.getTokenConstructor(),
                objectAllocator.getSourceFileConstructor()
              ];
              for (const ctor of nodeConstructors) {
                if (!hasProperty(ctor.prototype, "__debugKind")) {
                  Object.defineProperties(ctor.prototype, {
                    // for use with vscode-js-debug's new customDescriptionGenerator in launch.json
                    __tsDebuggerDisplay: {
                      value() {
                        const nodeHeader = isGeneratedIdentifier(this) ? "GeneratedIdentifier" : isIdentifier(this) ? `Identifier '${idText(this)}'` : isPrivateIdentifier(this) ? `PrivateIdentifier '${idText(this)}'` : isStringLiteral(this) ? `StringLiteral ${JSON.stringify(this.text.length < 10 ? this.text : this.text.slice(10) + "...")}` : isNumericLiteral(this) ? `NumericLiteral ${this.text}` : isBigIntLiteral(this) ? `BigIntLiteral ${this.text}n` : isTypeParameterDeclaration(this) ? "TypeParameterDeclaration" : isParameter(this) ? "ParameterDeclaration" : isConstructorDeclaration(this) ? "ConstructorDeclaration" : isGetAccessorDeclaration(this) ? "GetAccessorDeclaration" : isSetAccessorDeclaration(this) ? "SetAccessorDeclaration" : isCallSignatureDeclaration(this) ? "CallSignatureDeclaration" : isConstructSignatureDeclaration(this) ? "ConstructSignatureDeclaration" : isIndexSignatureDeclaration(this) ? "IndexSignatureDeclaration" : isTypePredicateNode(this) ? "TypePredicateNode" : isTypeReferenceNode(this) ? "TypeReferenceNode" : isFunctionTypeNode(this) ? "FunctionTypeNode" : isConstructorTypeNode(this) ? "ConstructorTypeNode" : isTypeQueryNode(this) ? "TypeQueryNode" : isTypeLiteralNode(this) ? "TypeLiteralNode" : isArrayTypeNode(this) ? "ArrayTypeNode" : isTupleTypeNode(this) ? "TupleTypeNode" : isOptionalTypeNode(this) ? "OptionalTypeNode" : isRestTypeNode(this) ? "RestTypeNode" : isUnionTypeNode(this) ? "UnionTypeNode" : isIntersectionTypeNode(this) ? "IntersectionTypeNode" : isConditionalTypeNode(this) ? "ConditionalTypeNode" : isInferTypeNode(this) ? "InferTypeNode" : isParenthesizedTypeNode(this) ? "ParenthesizedTypeNode" : isThisTypeNode(this) ? "ThisTypeNode" : isTypeOperatorNode(this) ? "TypeOperatorNode" : isIndexedAccessTypeNode(this) ? "IndexedAccessTypeNode" : isMappedTypeNode(this) ? "MappedTypeNode" : isLiteralTypeNode(this) ? "LiteralTypeNode" : isNamedTupleMember(this) ? "NamedTupleMember" : isImportTypeNode(this) ? "ImportTypeNode" : formatSyntaxKind(this.kind);
                        return `${nodeHeader}${this.flags ? ` (${formatNodeFlags(this.flags)})` : ""}`;
                      }
                    },
                    __debugKind: {
                      get() {
                        return formatSyntaxKind(this.kind);
                      }
                    },
                    __debugNodeFlags: {
                      get() {
                        return formatNodeFlags(this.flags);
                      }
                    },
                    __debugModifierFlags: {
                      get() {
                        return formatModifierFlags(getEffectiveModifierFlagsNoCache(this));
                      }
                    },
                    __debugTransformFlags: {
                      get() {
                        return formatTransformFlags(this.transformFlags);
                      }
                    },
                    __debugIsParseTreeNode: {
                      get() {
                        return isParseTreeNode(this);
                      }
                    },
                    __debugEmitFlags: {
                      get() {
                        return formatEmitFlags(getEmitFlags(this));
                      }
                    },
                    __debugGetText: {
                      value(includeTrivia) {
                        if (nodeIsSynthesized(this))
                          return "";
                        let text = weakNodeTextMap.get(this);
                        if (text === void 0) {
                          const parseNode = getParseTreeNode(this);
                          const sourceFile = parseNode && getSourceFileOfNode(parseNode);
                          text = sourceFile ? getSourceTextOfNodeFromSourceFile(sourceFile, parseNode, includeTrivia) : "";
                          weakNodeTextMap.set(this, text);
                        }
                        return text;
                      }
                    }
                  });
                }
              }
              isDebugInfoEnabled = true;
            }
            Debug2.enableDebugInfo = enableDebugInfo;
            function formatVariance(varianceFlags) {
              const variance = varianceFlags & 7;
              let result = variance === 0 ? "in out" : variance === 3 ? "[bivariant]" : variance === 2 ? "in" : variance === 1 ? "out" : variance === 4 ? "[independent]" : "";
              if (varianceFlags & 8) {
                result += " (unmeasurable)";
              } else if (varianceFlags & 16) {
                result += " (unreliable)";
              }
              return result;
            }
            Debug2.formatVariance = formatVariance;
            class DebugTypeMapper {
              __debugToString() {
                var _a;
                type(this);
                switch (this.kind) {
                  case 3:
                    return ((_a = this.debugInfo) == null ? void 0 : _a.call(this)) || "(function mapper)";
                  case 0:
                    return `${this.source.__debugTypeToString()} -> ${this.target.__debugTypeToString()}`;
                  case 1:
                    return zipWith(
                      this.sources,
                      this.targets || map(this.sources, () => "any"),
                      (s, t) => `${s.__debugTypeToString()} -> ${typeof t === "string" ? t : t.__debugTypeToString()}`
                    ).join(", ");
                  case 2:
                    return zipWith(
                      this.sources,
                      this.targets,
                      (s, t) => `${s.__debugTypeToString()} -> ${t().__debugTypeToString()}`
                    ).join(", ");
                  case 5:
                  case 4:
                    return `m1: ${this.mapper1.__debugToString().split("\n").join("\n    ")}
m2: ${this.mapper2.__debugToString().split("\n").join("\n    ")}`;
                  default:
                    return assertNever(this);
                }
              }
            }
            Debug2.DebugTypeMapper = DebugTypeMapper;
            function attachDebugPrototypeIfDebug(mapper) {
              if (Debug2.isDebugging) {
                return Object.setPrototypeOf(mapper, DebugTypeMapper.prototype);
              }
              return mapper;
            }
            Debug2.attachDebugPrototypeIfDebug = attachDebugPrototypeIfDebug;
            function printControlFlowGraph(flowNode) {
              return console.log(formatControlFlowGraph(flowNode));
            }
            Debug2.printControlFlowGraph = printControlFlowGraph;
            function formatControlFlowGraph(flowNode) {
              let nextDebugFlowId = -1;
              function getDebugFlowNodeId(f) {
                if (!f.id) {
                  f.id = nextDebugFlowId;
                  nextDebugFlowId--;
                }
                return f.id;
              }
              let BoxCharacter;
              ((BoxCharacter2) => {
                BoxCharacter2["lr"] = "\u2500";
                BoxCharacter2["ud"] = "\u2502";
                BoxCharacter2["dr"] = "\u256D";
                BoxCharacter2["dl"] = "\u256E";
                BoxCharacter2["ul"] = "\u256F";
                BoxCharacter2["ur"] = "\u2570";
                BoxCharacter2["udr"] = "\u251C";
                BoxCharacter2["udl"] = "\u2524";
                BoxCharacter2["dlr"] = "\u252C";
                BoxCharacter2["ulr"] = "\u2534";
                BoxCharacter2["udlr"] = "\u256B";
              })(BoxCharacter || (BoxCharacter = {}));
              let Connection;
              ((Connection2) => {
                Connection2[Connection2["None"] = 0] = "None";
                Connection2[Connection2["Up"] = 1] = "Up";
                Connection2[Connection2["Down"] = 2] = "Down";
                Connection2[Connection2["Left"] = 4] = "Left";
                Connection2[Connection2["Right"] = 8] = "Right";
                Connection2[Connection2["UpDown"] = 3] = "UpDown";
                Connection2[Connection2["LeftRight"] = 12] = "LeftRight";
                Connection2[Connection2["UpLeft"] = 5] = "UpLeft";
                Connection2[Connection2["UpRight"] = 9] = "UpRight";
                Connection2[Connection2["DownLeft"] = 6] = "DownLeft";
                Connection2[Connection2["DownRight"] = 10] = "DownRight";
                Connection2[Connection2["UpDownLeft"] = 7] = "UpDownLeft";
                Connection2[Connection2["UpDownRight"] = 11] = "UpDownRight";
                Connection2[Connection2["UpLeftRight"] = 13] = "UpLeftRight";
                Connection2[Connection2["DownLeftRight"] = 14] = "DownLeftRight";
                Connection2[Connection2["UpDownLeftRight"] = 15] = "UpDownLeftRight";
                Connection2[Connection2["NoChildren"] = 16] = "NoChildren";
              })(Connection || (Connection = {}));
              const hasAntecedentFlags = 16 | 96 | 128 | 256 | 512 | 1024;
              const hasNodeFlags = 2 | 16 | 512 | 96 | 256;
              const links = /* @__PURE__ */ Object.create(
                /*o*/
                null
              );
              const nodes = [];
              const edges = [];
              const root = buildGraphNode(flowNode, /* @__PURE__ */ new Set());
              for (const node of nodes) {
                node.text = renderFlowNode(node.flowNode, node.circular);
                computeLevel(node);
              }
              const height = computeHeight(root);
              const columnWidths = computeColumnWidths(height);
              computeLanes(root, 0);
              return renderGraph();
              function isFlowSwitchClause(f) {
                return !!(f.flags & 128);
              }
              function hasAntecedents(f) {
                return !!(f.flags & 12) && !!f.antecedents;
              }
              function hasAntecedent(f) {
                return !!(f.flags & hasAntecedentFlags);
              }
              function hasNode(f) {
                return !!(f.flags & hasNodeFlags);
              }
              function getChildren(node) {
                const children = [];
                for (const edge of node.edges) {
                  if (edge.source === node) {
                    children.push(edge.target);
                  }
                }
                return children;
              }
              function getParents(node) {
                const parents = [];
                for (const edge of node.edges) {
                  if (edge.target === node) {
                    parents.push(edge.source);
                  }
                }
                return parents;
              }
              function buildGraphNode(flowNode2, seen) {
                const id = getDebugFlowNodeId(flowNode2);
                let graphNode = links[id];
                if (graphNode && seen.has(flowNode2)) {
                  graphNode.circular = true;
                  graphNode = {
                    id: -1,
                    flowNode: flowNode2,
                    edges: [],
                    text: "",
                    lane: -1,
                    endLane: -1,
                    level: -1,
                    circular: "circularity"
                  };
                  nodes.push(graphNode);
                  return graphNode;
                }
                seen.add(flowNode2);
                if (!graphNode) {
                  links[id] = graphNode = { id, flowNode: flowNode2, edges: [], text: "", lane: -1, endLane: -1, level: -1, circular: false };
                  nodes.push(graphNode);
                  if (hasAntecedents(flowNode2)) {
                    for (const antecedent of flowNode2.antecedents) {
                      buildGraphEdge(graphNode, antecedent, seen);
                    }
                  } else if (hasAntecedent(flowNode2)) {
                    buildGraphEdge(graphNode, flowNode2.antecedent, seen);
                  }
                }
                seen.delete(flowNode2);
                return graphNode;
              }
              function buildGraphEdge(source, antecedent, seen) {
                const target = buildGraphNode(antecedent, seen);
                const edge = { source, target };
                edges.push(edge);
                source.edges.push(edge);
                target.edges.push(edge);
              }
              function computeLevel(node) {
                if (node.level !== -1) {
                  return node.level;
                }
                let level = 0;
                for (const parent2 of getParents(node)) {
                  level = Math.max(level, computeLevel(parent2) + 1);
                }
                return node.level = level;
              }
              function computeHeight(node) {
                let height2 = 0;
                for (const child of getChildren(node)) {
                  height2 = Math.max(height2, computeHeight(child));
                }
                return height2 + 1;
              }
              function computeColumnWidths(height2) {
                const columns = fill(Array(height2), 0);
                for (const node of nodes) {
                  columns[node.level] = Math.max(columns[node.level], node.text.length);
                }
                return columns;
              }
              function computeLanes(node, lane) {
                if (node.lane === -1) {
                  node.lane = lane;
                  node.endLane = lane;
                  const children = getChildren(node);
                  for (let i = 0; i < children.length; i++) {
                    if (i > 0)
                      lane++;
                    const child = children[i];
                    computeLanes(child, lane);
                    if (child.endLane > node.endLane) {
                      lane = child.endLane;
                    }
                  }
                  node.endLane = lane;
                }
              }
              function getHeader(flags) {
                if (flags & 2)
                  return "Start";
                if (flags & 4)
                  return "Branch";
                if (flags & 8)
                  return "Loop";
                if (flags & 16)
                  return "Assignment";
                if (flags & 32)
                  return "True";
                if (flags & 64)
                  return "False";
                if (flags & 128)
                  return "SwitchClause";
                if (flags & 256)
                  return "ArrayMutation";
                if (flags & 512)
                  return "Call";
                if (flags & 1024)
                  return "ReduceLabel";
                if (flags & 1)
                  return "Unreachable";
                throw new Error();
              }
              function getNodeText(node) {
                const sourceFile = getSourceFileOfNode(node);
                return getSourceTextOfNodeFromSourceFile(
                  sourceFile,
                  node,
                  /*includeTrivia*/
                  false
                );
              }
              function renderFlowNode(flowNode2, circular) {
                let text = getHeader(flowNode2.flags);
                if (circular) {
                  text = `${text}#${getDebugFlowNodeId(flowNode2)}`;
                }
                if (hasNode(flowNode2)) {
                  if (flowNode2.node) {
                    text += ` (${getNodeText(flowNode2.node)})`;
                  }
                } else if (isFlowSwitchClause(flowNode2)) {
                  const clauses = [];
                  for (let i = flowNode2.clauseStart; i < flowNode2.clauseEnd; i++) {
                    const clause = flowNode2.switchStatement.caseBlock.clauses[i];
                    if (isDefaultClause(clause)) {
                      clauses.push("default");
                    } else {
                      clauses.push(getNodeText(clause.expression));
                    }
                  }
                  text += ` (${clauses.join(", ")})`;
                }
                return circular === "circularity" ? `Circular(${text})` : text;
              }
              function renderGraph() {
                const columnCount = columnWidths.length;
                const laneCount = nodes.reduce((x, n) => Math.max(x, n.lane), 0) + 1;
                const lanes = fill(Array(laneCount), "");
                const grid = columnWidths.map(() => Array(laneCount));
                const connectors = columnWidths.map(() => fill(Array(laneCount), 0));
                for (const node of nodes) {
                  grid[node.level][node.lane] = node;
                  const children = getChildren(node);
                  for (let i = 0; i < children.length; i++) {
                    const child = children[i];
                    let connector = 8;
                    if (child.lane === node.lane)
                      connector |= 4;
                    if (i > 0)
                      connector |= 1;
                    if (i < children.length - 1)
                      connector |= 2;
                    connectors[node.level][child.lane] |= connector;
                  }
                  if (children.length === 0) {
                    connectors[node.level][node.lane] |= 16;
                  }
                  const parents = getParents(node);
                  for (let i = 0; i < parents.length; i++) {
                    const parent2 = parents[i];
                    let connector = 4;
                    if (i > 0)
                      connector |= 1;
                    if (i < parents.length - 1)
                      connector |= 2;
                    connectors[node.level - 1][parent2.lane] |= connector;
                  }
                }
                for (let column = 0; column < columnCount; column++) {
                  for (let lane = 0; lane < laneCount; lane++) {
                    const left = column > 0 ? connectors[column - 1][lane] : 0;
                    const above = lane > 0 ? connectors[column][lane - 1] : 0;
                    let connector = connectors[column][lane];
                    if (!connector) {
                      if (left & 8)
                        connector |= 12;
                      if (above & 2)
                        connector |= 3;
                      connectors[column][lane] = connector;
                    }
                  }
                }
                for (let column = 0; column < columnCount; column++) {
                  for (let lane = 0; lane < lanes.length; lane++) {
                    const connector = connectors[column][lane];
                    const fill2 = connector & 4 ? "\u2500" : " ";
                    const node = grid[column][lane];
                    if (!node) {
                      if (column < columnCount - 1) {
                        writeLane(lane, repeat(fill2, columnWidths[column] + 1));
                      }
                    } else {
                      writeLane(lane, node.text);
                      if (column < columnCount - 1) {
                        writeLane(lane, " ");
                        writeLane(lane, repeat(fill2, columnWidths[column] - node.text.length));
                      }
                    }
                    writeLane(lane, getBoxCharacter(connector));
                    writeLane(lane, connector & 8 && column < columnCount - 1 && !grid[column + 1][lane] ? "\u2500" : " ");
                  }
                }
                return `
${lanes.join("\n")}
`;
                function writeLane(lane, text) {
                  lanes[lane] += text;
                }
              }
              function getBoxCharacter(connector) {
                switch (connector) {
                  case 3:
                    return "\u2502";
                  case 12:
                    return "\u2500";
                  case 5:
                    return "\u256F";
                  case 9:
                    return "\u2570";
                  case 6:
                    return "\u256E";
                  case 10:
                    return "\u256D";
                  case 7:
                    return "\u2524";
                  case 11:
                    return "\u251C";
                  case 13:
                    return "\u2534";
                  case 14:
                    return "\u252C";
                  case 15:
                    return "\u256B";
                }
                return " ";
              }
              function fill(array, value) {
                if (array.fill) {
                  array.fill(value);
                } else {
                  for (let i = 0; i < array.length; i++) {
                    array[i] = value;
                  }
                }
                return array;
              }
              function repeat(ch, length2) {
                if (ch.repeat) {
                  return length2 > 0 ? ch.repeat(length2) : "";
                }
                let s = "";
                while (s.length < length2) {
                  s += ch;
                }
                return s;
              }
            }
            Debug2.formatControlFlowGraph = formatControlFlowGraph;
          })(Debug || (Debug = {}));
        }
      });
      function tryParseComponents(text) {
        const match = versionRegExp.exec(text);
        if (!match)
          return void 0;
        const [, major, minor = "0", patch = "0", prerelease = "", build2 = ""] = match;
        if (prerelease && !prereleaseRegExp.test(prerelease))
          return void 0;
        if (build2 && !buildRegExp.test(build2))
          return void 0;
        return {
          major: parseInt(major, 10),
          minor: parseInt(minor, 10),
          patch: parseInt(patch, 10),
          prerelease,
          build: build2
        };
      }
      function comparePrereleaseIdentifiers(left, right) {
        if (left === right)
          return 0;
        if (left.length === 0)
          return right.length === 0 ? 0 : 1;
        if (right.length === 0)
          return -1;
        const length2 = Math.min(left.length, right.length);
        for (let i = 0; i < length2; i++) {
          const leftIdentifier = left[i];
          const rightIdentifier = right[i];
          if (leftIdentifier === rightIdentifier)
            continue;
          const leftIsNumeric = numericIdentifierRegExp.test(leftIdentifier);
          const rightIsNumeric = numericIdentifierRegExp.test(rightIdentifier);
          if (leftIsNumeric || rightIsNumeric) {
            if (leftIsNumeric !== rightIsNumeric)
              return leftIsNumeric ? -1 : 1;
            const result = compareValues(+leftIdentifier, +rightIdentifier);
            if (result)
              return result;
          } else {
            const result = compareStringsCaseSensitive(leftIdentifier, rightIdentifier);
            if (result)
              return result;
          }
        }
        return compareValues(left.length, right.length);
      }
      function parseRange(text) {
        const alternatives = [];
        for (let range of text.trim().split(logicalOrRegExp)) {
          if (!range)
            continue;
          const comparators = [];
          range = range.trim();
          const match = hyphenRegExp.exec(range);
          if (match) {
            if (!parseHyphen(match[1], match[2], comparators))
              return void 0;
          } else {
            for (const simple of range.split(whitespaceRegExp)) {
              const match2 = rangeRegExp.exec(simple.trim());
              if (!match2 || !parseComparator(match2[1], match2[2], comparators))
                return void 0;
            }
          }
          alternatives.push(comparators);
        }
        return alternatives;
      }
      function parsePartial(text) {
        const match = partialRegExp.exec(text);
        if (!match)
          return void 0;
        const [, major, minor = "*", patch = "*", prerelease, build2] = match;
        const version2 = new Version(
          isWildcard(major) ? 0 : parseInt(major, 10),
          isWildcard(major) || isWildcard(minor) ? 0 : parseInt(minor, 10),
          isWildcard(major) || isWildcard(minor) || isWildcard(patch) ? 0 : parseInt(patch, 10),
          prerelease,
          build2
        );
        return { version: version2, major, minor, patch };
      }
      function parseHyphen(left, right, comparators) {
        const leftResult = parsePartial(left);
        if (!leftResult)
          return false;
        const rightResult = parsePartial(right);
        if (!rightResult)
          return false;
        if (!isWildcard(leftResult.major)) {
          comparators.push(createComparator(">=", leftResult.version));
        }
        if (!isWildcard(rightResult.major)) {
          comparators.push(
            isWildcard(rightResult.minor) ? createComparator("<", rightResult.version.increment("major")) : isWildcard(rightResult.patch) ? createComparator("<", rightResult.version.increment("minor")) : createComparator("<=", rightResult.version)
          );
        }
        return true;
      }
      function parseComparator(operator, text, comparators) {
        const result = parsePartial(text);
        if (!result)
          return false;
        const { version: version2, major, minor, patch } = result;
        if (!isWildcard(major)) {
          switch (operator) {
            case "~":
              comparators.push(createComparator(">=", version2));
              comparators.push(createComparator(
                "<",
                version2.increment(
                  isWildcard(minor) ? "major" : "minor"
                )
              ));
              break;
            case "^":
              comparators.push(createComparator(">=", version2));
              comparators.push(createComparator(
                "<",
                version2.increment(
                  version2.major > 0 || isWildcard(minor) ? "major" : version2.minor > 0 || isWildcard(patch) ? "minor" : "patch"
                )
              ));
              break;
            case "<":
            case ">=":
              comparators.push(
                isWildcard(minor) || isWildcard(patch) ? createComparator(operator, version2.with({ prerelease: "0" })) : createComparator(operator, version2)
              );
              break;
            case "<=":
            case ">":
              comparators.push(
                isWildcard(minor) ? createComparator(operator === "<=" ? "<" : ">=", version2.increment("major").with({ prerelease: "0" })) : isWildcard(patch) ? createComparator(operator === "<=" ? "<" : ">=", version2.increment("minor").with({ prerelease: "0" })) : createComparator(operator, version2)
              );
              break;
            case "=":
            case void 0:
              if (isWildcard(minor) || isWildcard(patch)) {
                comparators.push(createComparator(">=", version2.with({ prerelease: "0" })));
                comparators.push(createComparator("<", version2.increment(isWildcard(minor) ? "major" : "minor").with({ prerelease: "0" })));
              } else {
                comparators.push(createComparator("=", version2));
              }
              break;
            default:
              return false;
          }
        } else if (operator === "<" || operator === ">") {
          comparators.push(createComparator("<", Version.zero));
        }
        return true;
      }
      function isWildcard(part) {
        return part === "*" || part === "x" || part === "X";
      }
      function createComparator(operator, operand) {
        return { operator, operand };
      }
      function testDisjunction(version2, alternatives) {
        if (alternatives.length === 0)
          return true;
        for (const alternative of alternatives) {
          if (testAlternative(version2, alternative))
            return true;
        }
        return false;
      }
      function testAlternative(version2, comparators) {
        for (const comparator of comparators) {
          if (!testComparator(version2, comparator.operator, comparator.operand))
            return false;
        }
        return true;
      }
      function testComparator(version2, operator, operand) {
        const cmp = version2.compareTo(operand);
        switch (operator) {
          case "<":
            return cmp < 0;
          case "<=":
            return cmp <= 0;
          case ">":
            return cmp > 0;
          case ">=":
            return cmp >= 0;
          case "=":
            return cmp === 0;
          default:
            return Debug.assertNever(operator);
        }
      }
      function formatDisjunction(alternatives) {
        return map(alternatives, formatAlternative).join(" || ") || "*";
      }
      function formatAlternative(comparators) {
        return map(comparators, formatComparator).join(" ");
      }
      function formatComparator(comparator) {
        return `${comparator.operator}${comparator.operand}`;
      }
      var versionRegExp, prereleaseRegExp, prereleasePartRegExp, buildRegExp, buildPartRegExp, numericIdentifierRegExp, _Version, Version, VersionRange, logicalOrRegExp, whitespaceRegExp, partialRegExp, hyphenRegExp, rangeRegExp;
      var init_semver = __esm({
        "src/compiler/semver.ts"() {
          "use strict";
          init_ts2();
          versionRegExp = /^(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i;
          prereleaseRegExp = /^(?:0|[1-9]\d*|[a-z-][a-z0-9-]*)(?:\.(?:0|[1-9]\d*|[a-z-][a-z0-9-]*))*$/i;
          prereleasePartRegExp = /^(?:0|[1-9]\d*|[a-z-][a-z0-9-]*)$/i;
          buildRegExp = /^[a-z0-9-]+(?:\.[a-z0-9-]+)*$/i;
          buildPartRegExp = /^[a-z0-9-]+$/i;
          numericIdentifierRegExp = /^(0|[1-9]\d*)$/;
          _Version = class _Version2 {
            constructor(major, minor = 0, patch = 0, prerelease = "", build2 = "") {
              if (typeof major === "string") {
                const result = Debug.checkDefined(tryParseComponents(major), "Invalid version");
                ({ major, minor, patch, prerelease, build: build2 } = result);
              }
              Debug.assert(major >= 0, "Invalid argument: major");
              Debug.assert(minor >= 0, "Invalid argument: minor");
              Debug.assert(patch >= 0, "Invalid argument: patch");
              const prereleaseArray = prerelease ? isArray(prerelease) ? prerelease : prerelease.split(".") : emptyArray;
              const buildArray = build2 ? isArray(build2) ? build2 : build2.split(".") : emptyArray;
              Debug.assert(every(prereleaseArray, (s) => prereleasePartRegExp.test(s)), "Invalid argument: prerelease");
              Debug.assert(every(buildArray, (s) => buildPartRegExp.test(s)), "Invalid argument: build");
              this.major = major;
              this.minor = minor;
              this.patch = patch;
              this.prerelease = prereleaseArray;
              this.build = buildArray;
            }
            static tryParse(text) {
              const result = tryParseComponents(text);
              if (!result)
                return void 0;
              const { major, minor, patch, prerelease, build: build2 } = result;
              return new _Version2(major, minor, patch, prerelease, build2);
            }
            compareTo(other) {
              if (this === other)
                return 0;
              if (other === void 0)
                return 1;
              return compareValues(this.major, other.major) || compareValues(this.minor, other.minor) || compareValues(this.patch, other.patch) || comparePrereleaseIdentifiers(this.prerelease, other.prerelease);
            }
            increment(field) {
              switch (field) {
                case "major":
                  return new _Version2(this.major + 1, 0, 0);
                case "minor":
                  return new _Version2(this.major, this.minor + 1, 0);
                case "patch":
                  return new _Version2(this.major, this.minor, this.patch + 1);
                default:
                  return Debug.assertNever(field);
              }
            }
            with(fields) {
              const {
                major = this.major,
                minor = this.minor,
                patch = this.patch,
                prerelease = this.prerelease,
                build: build2 = this.build
              } = fields;
              return new _Version2(major, minor, patch, prerelease, build2);
            }
            toString() {
              let result = `${this.major}.${this.minor}.${this.patch}`;
              if (some(this.prerelease))
                result += `-${this.prerelease.join(".")}`;
              if (some(this.build))
                result += `+${this.build.join(".")}`;
              return result;
            }
          };
          _Version.zero = new _Version(0, 0, 0, ["0"]);
          Version = _Version;
          VersionRange = class _VersionRange {
            constructor(spec) {
              this._alternatives = spec ? Debug.checkDefined(parseRange(spec), "Invalid range spec.") : emptyArray;
            }
            static tryParse(text) {
              const sets = parseRange(text);
              if (sets) {
                const range = new _VersionRange("");
                range._alternatives = sets;
                return range;
              }
              return void 0;
            }
            /**
             * Tests whether a version matches the range. This is equivalent to `satisfies(version, range, { includePrerelease: true })`.
             * in `node-semver`.
             */
            test(version2) {
              if (typeof version2 === "string")
                version2 = new Version(version2);
              return testDisjunction(version2, this._alternatives);
            }
            toString() {
              return formatDisjunction(this._alternatives);
            }
          };
          logicalOrRegExp = /\|\|/g;
          whitespaceRegExp = /\s+/g;
          partialRegExp = /^([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i;
          hyphenRegExp = /^\s*([a-z0-9-+.*]+)\s+-\s+([a-z0-9-+.*]+)\s*$/i;
          rangeRegExp = /^(~|\^|<|<=|>|>=|=)?\s*([a-z0-9-+.*]+)$/i;
        }
      });
      function hasRequiredAPI(performance2, PerformanceObserver2) {
        return typeof performance2 === "object" && typeof performance2.timeOrigin === "number" && typeof performance2.mark === "function" && typeof performance2.measure === "function" && typeof performance2.now === "function" && typeof performance2.clearMarks === "function" && typeof performance2.clearMeasures === "function" && typeof PerformanceObserver2 === "function";
      }
      function tryGetWebPerformanceHooks() {
        if (typeof performance === "object" && typeof PerformanceObserver === "function" && hasRequiredAPI(performance, PerformanceObserver)) {
          return {
            // For now we always write native performance events when running in the browser. We may
            // make this conditional in the future if we find that native web performance hooks
            // in the browser also slow down compilation.
            shouldWriteNativeEvents: true,
            performance,
            PerformanceObserver
          };
        }
      }
      function tryGetNodePerformanceHooks() {
        if (isNodeLikeSystem()) {
          try {
            const { performance: performance2, PerformanceObserver: PerformanceObserver2 } = require("perf_hooks");
            if (hasRequiredAPI(performance2, PerformanceObserver2)) {
              return {
                // By default, only write native events when generating a cpu profile or using the v8 profiler.
                shouldWriteNativeEvents: false,
                performance: performance2,
                PerformanceObserver: PerformanceObserver2
              };
            }
          } catch (e) {
          }
        }
      }
      function tryGetNativePerformanceHooks() {
        return nativePerformanceHooks;
      }
      var nativePerformanceHooks, nativePerformance, timestamp;
      var init_performanceCore = __esm({
        "src/compiler/performanceCore.ts"() {
          "use strict";
          init_ts2();
          nativePerformanceHooks = tryGetWebPerformanceHooks() || tryGetNodePerformanceHooks();
          nativePerformance = nativePerformanceHooks == null ? void 0 : nativePerformanceHooks.performance;
          timestamp = nativePerformance ? () => nativePerformance.now() : Date.now ? Date.now : () => +/* @__PURE__ */ new Date();
        }
      });
      var etwModule, perfLogger;
      var init_perfLogger = __esm({
        "src/compiler/perfLogger.ts"() {
          var _a;
          "use strict";
          try {
            const etwModulePath = (_a = process.env.TS_ETW_MODULE_PATH) != null ? _a : "./node_modules/@microsoft/typescript-etw";
            etwModule = require(etwModulePath);
          } catch (e) {
            etwModule = void 0;
          }
          perfLogger = (etwModule == null ? void 0 : etwModule.logEvent) ? etwModule : void 0;
        }
      });
      function createTimerIf(condition, measureName, startMarkName, endMarkName) {
        return condition ? createTimer(measureName, startMarkName, endMarkName) : nullTimer;
      }
      function createTimer(measureName, startMarkName, endMarkName) {
        let enterCount = 0;
        return {
          enter,
          exit
        };
        function enter() {
          if (++enterCount === 1) {
            mark(startMarkName);
          }
        }
        function exit() {
          if (--enterCount === 0) {
            mark(endMarkName);
            measure(measureName, startMarkName, endMarkName);
          } else if (enterCount < 0) {
            Debug.fail("enter/exit count does not match.");
          }
        }
      }
      function mark(markName) {
        var _a;
        if (enabled) {
          const count = (_a = counts.get(markName)) != null ? _a : 0;
          counts.set(markName, count + 1);
          marks.set(markName, timestamp());
          performanceImpl == null ? void 0 : performanceImpl.mark(markName);
          if (typeof onProfilerEvent === "function") {
            onProfilerEvent(markName);
          }
        }
      }
      function measure(measureName, startMarkName, endMarkName) {
        var _a, _b;
        if (enabled) {
          const end = (_a = endMarkName !== void 0 ? marks.get(endMarkName) : void 0) != null ? _a : timestamp();
          const start = (_b = startMarkName !== void 0 ? marks.get(startMarkName) : void 0) != null ? _b : timeorigin;
          const previousDuration = durations.get(measureName) || 0;
          durations.set(measureName, previousDuration + (end - start));
          performanceImpl == null ? void 0 : performanceImpl.measure(measureName, startMarkName, endMarkName);
        }
      }
      function getCount(markName) {
        return counts.get(markName) || 0;
      }
      function getDuration(measureName) {
        return durations.get(measureName) || 0;
      }
      function forEachMeasure(cb) {
        durations.forEach((duration, measureName) => cb(measureName, duration));
      }
      function forEachMark(cb) {
        marks.forEach((_time, markName) => cb(markName));
      }
      function clearMeasures(name) {
        if (name !== void 0)
          durations.delete(name);
        else
          durations.clear();
        performanceImpl == null ? void 0 : performanceImpl.clearMeasures(name);
      }
      function clearMarks(name) {
        if (name !== void 0) {
          counts.delete(name);
          marks.delete(name);
        } else {
          counts.clear();
          marks.clear();
        }
        performanceImpl == null ? void 0 : performanceImpl.clearMarks(name);
      }
      function isEnabled() {
        return enabled;
      }
      function enable(system = sys) {
        var _a;
        if (!enabled) {
          enabled = true;
          perfHooks || (perfHooks = tryGetNativePerformanceHooks());
          if (perfHooks) {
            timeorigin = perfHooks.performance.timeOrigin;
            if (perfHooks.shouldWriteNativeEvents || ((_a = system == null ? void 0 : system.cpuProfilingEnabled) == null ? void 0 : _a.call(system)) || (system == null ? void 0 : system.debugMode)) {
              performanceImpl = perfHooks.performance;
            }
          }
        }
        return true;
      }
      function disable() {
        if (enabled) {
          marks.clear();
          counts.clear();
          durations.clear();
          performanceImpl = void 0;
          enabled = false;
        }
      }
      var perfHooks, performanceImpl, nullTimer, enabled, timeorigin, marks, counts, durations;
      var init_performance = __esm({
        "src/compiler/performance.ts"() {
          "use strict";
          init_ts2();
          nullTimer = { enter: noop, exit: noop };
          enabled = false;
          timeorigin = timestamp();
          marks = /* @__PURE__ */ new Map();
          counts = /* @__PURE__ */ new Map();
          durations = /* @__PURE__ */ new Map();
        }
      });
      var ts_performance_exports = {};
      __export(ts_performance_exports, {
        clearMarks: () => clearMarks,
        clearMeasures: () => clearMeasures,
        createTimer: () => createTimer,
        createTimerIf: () => createTimerIf,
        disable: () => disable,
        enable: () => enable,
        forEachMark: () => forEachMark,
        forEachMeasure: () => forEachMeasure,
        getCount: () => getCount,
        getDuration: () => getDuration,
        isEnabled: () => isEnabled,
        mark: () => mark,
        measure: () => measure,
        nullTimer: () => nullTimer
      });
      var init_ts_performance = __esm({
        "src/compiler/_namespaces/ts.performance.ts"() {
          "use strict";
          init_performance();
        }
      });
      var tracing, tracingEnabled, startTracing, dumpTracingLegend;
      var init_tracing = __esm({
        "src/compiler/tracing.ts"() {
          "use strict";
          init_ts2();
          init_ts_performance();
          ((tracingEnabled2) => {
            let fs;
            let traceCount = 0;
            let traceFd = 0;
            let mode;
            const typeCatalog = [];
            let legendPath;
            const legend = [];
            function startTracing2(tracingMode, traceDir, configFilePath) {
              Debug.assert(!tracing, "Tracing already started");
              if (fs === void 0) {
                try {
                  fs = require("fs");
                } catch (e) {
                  throw new Error(`tracing requires having fs
(original error: ${e.message || e})`);
                }
              }
              mode = tracingMode;
              typeCatalog.length = 0;
              if (legendPath === void 0) {
                legendPath = combinePaths(traceDir, "legend.json");
              }
              if (!fs.existsSync(traceDir)) {
                fs.mkdirSync(traceDir, { recursive: true });
              }
              const countPart = mode === "build" ? `.${process.pid}-${++traceCount}` : mode === "server" ? `.${process.pid}` : ``;
              const tracePath = combinePaths(traceDir, `trace${countPart}.json`);
              const typesPath = combinePaths(traceDir, `types${countPart}.json`);
              legend.push({
                configFilePath,
                tracePath,
                typesPath
              });
              traceFd = fs.openSync(tracePath, "w");
              tracing = tracingEnabled2;
              const meta = { cat: "__metadata", ph: "M", ts: 1e3 * timestamp(), pid: 1, tid: 1 };
              fs.writeSync(
                traceFd,
                "[\n" + [__spreadValues({ name: "process_name", args: { name: "tsc" } }, meta), __spreadValues({ name: "thread_name", args: { name: "Main" } }, meta), __spreadProps(__spreadValues({ name: "TracingStartedInBrowser" }, meta), { cat: "disabled-by-default-devtools.timeline" })].map((v) => JSON.stringify(v)).join(",\n")
              );
            }
            tracingEnabled2.startTracing = startTracing2;
            function stopTracing() {
              Debug.assert(tracing, "Tracing is not in progress");
              Debug.assert(!!typeCatalog.length === (mode !== "server"));
              fs.writeSync(traceFd, `
]
`);
              fs.closeSync(traceFd);
              tracing = void 0;
              if (typeCatalog.length) {
                dumpTypes(typeCatalog);
              } else {
                legend[legend.length - 1].typesPath = void 0;
              }
            }
            tracingEnabled2.stopTracing = stopTracing;
            function recordType(type) {
              if (mode !== "server") {
                typeCatalog.push(type);
              }
            }
            tracingEnabled2.recordType = recordType;
            let Phase;
            ((Phase2) => {
              Phase2["Parse"] = "parse";
              Phase2["Program"] = "program";
              Phase2["Bind"] = "bind";
              Phase2["Check"] = "check";
              Phase2["CheckTypes"] = "checkTypes";
              Phase2["Emit"] = "emit";
              Phase2["Session"] = "session";
            })(Phase = tracingEnabled2.Phase || (tracingEnabled2.Phase = {}));
            function instant(phase, name, args) {
              writeEvent("I", phase, name, args, `"s":"g"`);
            }
            tracingEnabled2.instant = instant;
            const eventStack = [];
            function push(phase, name, args, separateBeginAndEnd = false) {
              if (separateBeginAndEnd) {
                writeEvent("B", phase, name, args);
              }
              eventStack.push({ phase, name, args, time: 1e3 * timestamp(), separateBeginAndEnd });
            }
            tracingEnabled2.push = push;
            function pop(results) {
              Debug.assert(eventStack.length > 0);
              writeStackEvent(eventStack.length - 1, 1e3 * timestamp(), results);
              eventStack.length--;
            }
            tracingEnabled2.pop = pop;
            function popAll() {
              const endTime = 1e3 * timestamp();
              for (let i = eventStack.length - 1; i >= 0; i--) {
                writeStackEvent(i, endTime);
              }
              eventStack.length = 0;
            }
            tracingEnabled2.popAll = popAll;
            const sampleInterval = 1e3 * 10;
            function writeStackEvent(index, endTime, results) {
              const { phase, name, args, time, separateBeginAndEnd } = eventStack[index];
              if (separateBeginAndEnd) {
                Debug.assert(!results, "`results` are not supported for events with `separateBeginAndEnd`");
                writeEvent(
                  "E",
                  phase,
                  name,
                  args,
                  /*extras*/
                  void 0,
                  endTime
                );
              } else if (sampleInterval - time % sampleInterval <= endTime - time) {
                writeEvent("X", phase, name, __spreadProps(__spreadValues({}, args), { results }), `"dur":${endTime - time}`, time);
              }
            }
            function writeEvent(eventType, phase, name, args, extras, time = 1e3 * timestamp()) {
              if (mode === "server" && phase === "checkTypes")
                return;
              mark("beginTracing");
              fs.writeSync(traceFd, `,
{"pid":1,"tid":1,"ph":"${eventType}","cat":"${phase}","ts":${time},"name":"${name}"`);
              if (extras)
                fs.writeSync(traceFd, `,${extras}`);
              if (args)
                fs.writeSync(traceFd, `,"args":${JSON.stringify(args)}`);
              fs.writeSync(traceFd, `}`);
              mark("endTracing");
              measure("Tracing", "beginTracing", "endTracing");
            }
            function getLocation(node) {
              const file = getSourceFileOfNode(node);
              return !file ? void 0 : {
                path: file.path,
                start: indexFromOne(getLineAndCharacterOfPosition(file, node.pos)),
                end: indexFromOne(getLineAndCharacterOfPosition(file, node.end))
              };
              function indexFromOne(lc) {
                return {
                  line: lc.line + 1,
                  character: lc.character + 1
                };
              }
            }
            function dumpTypes(types) {
              var _a2, _b2, _c2;
              var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s;
              mark("beginDumpTypes");
              const typesPath = legend[legend.length - 1].typesPath;
              const typesFd = fs.openSync(typesPath, "w");
              const recursionIdentityMap = /* @__PURE__ */ new Map();
              fs.writeSync(typesFd, "[");
              const numTypes = types.length;
              for (let i = 0; i < numTypes; i++) {
                const type = types[i];
                const objectFlags = type.objectFlags;
                const symbol = (_a2 = type.aliasSymbol) != null ? _a2 : type.symbol;
                let display;
                if (objectFlags & 16 | type.flags & 2944) {
                  try {
                    display = (_a = type.checker) == null ? void 0 : _a.typeToString(type);
                  } catch (e) {
                    display = void 0;
                  }
                }
                let indexedAccessProperties = {};
                if (type.flags & 8388608) {
                  const indexedAccessType = type;
                  indexedAccessProperties = {
                    indexedAccessObjectType: (_b = indexedAccessType.objectType) == null ? void 0 : _b.id,
                    indexedAccessIndexType: (_c = indexedAccessType.indexType) == null ? void 0 : _c.id
                  };
                }
                let referenceProperties = {};
                if (objectFlags & 4) {
                  const referenceType = type;
                  referenceProperties = {
                    instantiatedType: (_d = referenceType.target) == null ? void 0 : _d.id,
                    typeArguments: (_e = referenceType.resolvedTypeArguments) == null ? void 0 : _e.map((t) => t.id),
                    referenceLocation: getLocation(referenceType.node)
                  };
                }
                let conditionalProperties = {};
                if (type.flags & 16777216) {
                  const conditionalType = type;
                  conditionalProperties = {
                    conditionalCheckType: (_f = conditionalType.checkType) == null ? void 0 : _f.id,
                    conditionalExtendsType: (_g = conditionalType.extendsType) == null ? void 0 : _g.id,
                    conditionalTrueType: (_b2 = (_h = conditionalType.resolvedTrueType) == null ? void 0 : _h.id) != null ? _b2 : -1,
                    conditionalFalseType: (_c2 = (_i = conditionalType.resolvedFalseType) == null ? void 0 : _i.id) != null ? _c2 : -1
                  };
                }
                let substitutionProperties = {};
                if (type.flags & 33554432) {
                  const substitutionType = type;
                  substitutionProperties = {
                    substitutionBaseType: (_j = substitutionType.baseType) == null ? void 0 : _j.id,
                    constraintType: (_k = substitutionType.constraint) == null ? void 0 : _k.id
                  };
                }
                let reverseMappedProperties = {};
                if (objectFlags & 1024) {
                  const reverseMappedType = type;
                  reverseMappedProperties = {
                    reverseMappedSourceType: (_l = reverseMappedType.source) == null ? void 0 : _l.id,
                    reverseMappedMappedType: (_m = reverseMappedType.mappedType) == null ? void 0 : _m.id,
                    reverseMappedConstraintType: (_n = reverseMappedType.constraintType) == null ? void 0 : _n.id
                  };
                }
                let evolvingArrayProperties = {};
                if (objectFlags & 256) {
                  const evolvingArrayType = type;
                  evolvingArrayProperties = {
                    evolvingArrayElementType: evolvingArrayType.elementType.id,
                    evolvingArrayFinalType: (_o = evolvingArrayType.finalArrayType) == null ? void 0 : _o.id
                  };
                }
                let recursionToken;
                const recursionIdentity = type.checker.getRecursionIdentity(type);
                if (recursionIdentity) {
                  recursionToken = recursionIdentityMap.get(recursionIdentity);
                  if (!recursionToken) {
                    recursionToken = recursionIdentityMap.size;
                    recursionIdentityMap.set(recursionIdentity, recursionToken);
                  }
                }
                const descriptor = __spreadProps(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues({
                  id: type.id,
                  intrinsicName: type.intrinsicName,
                  symbolName: (symbol == null ? void 0 : symbol.escapedName) && unescapeLeadingUnderscores(symbol.escapedName),
                  recursionId: recursionToken,
                  isTuple: objectFlags & 8 ? true : void 0,
                  unionTypes: type.flags & 1048576 ? (_p = type.types) == null ? void 0 : _p.map((t) => t.id) : void 0,
                  intersectionTypes: type.flags & 2097152 ? type.types.map((t) => t.id) : void 0,
                  aliasTypeArguments: (_q = type.aliasTypeArguments) == null ? void 0 : _q.map((t) => t.id),
                  keyofType: type.flags & 4194304 ? (_r = type.type) == null ? void 0 : _r.id : void 0
                }, indexedAccessProperties), referenceProperties), conditionalProperties), substitutionProperties), reverseMappedProperties), evolvingArrayProperties), {
                  destructuringPattern: getLocation(type.pattern),
                  firstDeclaration: getLocation((_s = symbol == null ? void 0 : symbol.declarations) == null ? void 0 : _s[0]),
                  flags: Debug.formatTypeFlags(type.flags).split("|"),
                  display
                });
                fs.writeSync(typesFd, JSON.stringify(descriptor));
                if (i < numTypes - 1) {
                  fs.writeSync(typesFd, ",\n");
                }
              }
              fs.writeSync(typesFd, "]\n");
              fs.closeSync(typesFd);
              mark("endDumpTypes");
              measure("Dump types", "beginDumpTypes", "endDumpTypes");
            }
            function dumpLegend() {
              if (!legendPath) {
                return;
              }
              fs.writeFileSync(legendPath, JSON.stringify(legend));
            }
            tracingEnabled2.dumpLegend = dumpLegend;
          })(tracingEnabled || (tracingEnabled = {}));
          startTracing = tracingEnabled.startTracing;
          dumpTracingLegend = tracingEnabled.dumpLegend;
        }
      });
      function diagnosticCategoryName(d, lowerCase = true) {
        const name = DiagnosticCategory[d.category];
        return lowerCase ? name.toLowerCase() : name;
      }
      var SyntaxKind, NodeFlags, ModifierFlags, JsxFlags, RelationComparisonResult, GeneratedIdentifierFlags, TokenFlags, FlowFlags, CommentDirectiveType, OperationCanceledException, FileIncludeKind, FilePreprocessingDiagnosticsKind, EmitOnly, StructureIsReused, ExitStatus, MemberOverrideStatus, UnionReduction, ContextFlags, NodeBuilderFlags, TypeFormatFlags, SymbolFormatFlags, SymbolAccessibility, SyntheticSymbolKind, TypePredicateKind, TypeReferenceSerializationKind, SymbolFlags, EnumKind, CheckFlags, InternalSymbolName, NodeCheckFlags, TypeFlags, ObjectFlags, VarianceFlags, ElementFlags, AccessFlags, IndexFlags, JsxReferenceKind, SignatureKind, SignatureFlags, IndexKind, TypeMapKind, InferencePriority, InferenceFlags, Ternary, AssignmentDeclarationKind, DiagnosticCategory, ModuleResolutionKind, ModuleDetectionKind, WatchFileKind, WatchDirectoryKind, PollingWatchKind, ModuleKind, JsxEmit, ImportsNotUsedAsValues, NewLineKind, ScriptKind, ScriptTarget, LanguageVariant, WatchDirectoryFlags, CharacterCodes, Extension, TransformFlags, SnippetKind, EmitFlags, InternalEmitFlags, ExternalEmitHelpers, EmitHint, OuterExpressionKinds, LexicalEnvironmentFlags, BundleFileSectionKind, ListFormat, PragmaKindFlags, commentPragmas, JSDocParsingMode;
      var init_types = __esm({
        "src/compiler/types.ts"() {
          "use strict";
          SyntaxKind = ((SyntaxKind5) => {
            SyntaxKind5[SyntaxKind5["Unknown"] = 0] = "Unknown";
            SyntaxKind5[SyntaxKind5["EndOfFileToken"] = 1] = "EndOfFileToken";
            SyntaxKind5[SyntaxKind5["SingleLineCommentTrivia"] = 2] = "SingleLineCommentTrivia";
            SyntaxKind5[SyntaxKind5["MultiLineCommentTrivia"] = 3] = "MultiLineCommentTrivia";
            SyntaxKind5[SyntaxKind5["NewLineTrivia"] = 4] = "NewLineTrivia";
            SyntaxKind5[SyntaxKind5["WhitespaceTrivia"] = 5] = "WhitespaceTrivia";
            SyntaxKind5[SyntaxKind5["ShebangTrivia"] = 6] = "ShebangTrivia";
            SyntaxKind5[SyntaxKind5["ConflictMarkerTrivia"] = 7] = "ConflictMarkerTrivia";
            SyntaxKind5[SyntaxKind5["NonTextFileMarkerTrivia"] = 8] = "NonTextFileMarkerTrivia";
            SyntaxKind5[SyntaxKind5["NumericLiteral"] = 9] = "NumericLiteral";
            SyntaxKind5[SyntaxKind5["BigIntLiteral"] = 10] = "BigIntLiteral";
            SyntaxKind5[SyntaxKind5["StringLiteral"] = 11] = "StringLiteral";
            SyntaxKind5[SyntaxKind5["JsxText"] = 12] = "JsxText";
            SyntaxKind5[SyntaxKind5["JsxTextAllWhiteSpaces"] = 13] = "JsxTextAllWhiteSpaces";
            SyntaxKind5[SyntaxKind5["RegularExpressionLiteral"] = 14] = "RegularExpressionLiteral";
            SyntaxKind5[SyntaxKind5["NoSubstitutionTemplateLiteral"] = 15] = "NoSubstitutionTemplateLiteral";
            SyntaxKind5[SyntaxKind5["TemplateHead"] = 16] = "TemplateHead";
            SyntaxKind5[SyntaxKind5["TemplateMiddle"] = 17] = "TemplateMiddle";
            SyntaxKind5[SyntaxKind5["TemplateTail"] = 18] = "TemplateTail";
            SyntaxKind5[SyntaxKind5["OpenBraceToken"] = 19] = "OpenBraceToken";
            SyntaxKind5[SyntaxKind5["CloseBraceToken"] = 20] = "CloseBraceToken";
            SyntaxKind5[SyntaxKind5["OpenParenToken"] = 21] = "OpenParenToken";
            SyntaxKind5[SyntaxKind5["CloseParenToken"] = 22] = "CloseParenToken";
            SyntaxKind5[SyntaxKind5["OpenBracketToken"] = 23] = "OpenBracketToken";
            SyntaxKind5[SyntaxKind5["CloseBracketToken"] = 24] = "CloseBracketToken";
            SyntaxKind5[SyntaxKind5["DotToken"] = 25] = "DotToken";
            SyntaxKind5[SyntaxKind5["DotDotDotToken"] = 26] = "DotDotDotToken";
            SyntaxKind5[SyntaxKind5["SemicolonToken"] = 27] = "SemicolonToken";
            SyntaxKind5[SyntaxKind5["CommaToken"] = 28] = "CommaToken";
            SyntaxKind5[SyntaxKind5["QuestionDotToken"] = 29] = "QuestionDotToken";
            SyntaxKind5[SyntaxKind5["LessThanToken"] = 30] = "LessThanToken";
            SyntaxKind5[SyntaxKind5["LessThanSlashToken"] = 31] = "LessThanSlashToken";
            SyntaxKind5[SyntaxKind5["GreaterThanToken"] = 32] = "GreaterThanToken";
            SyntaxKind5[SyntaxKind5["LessThanEqualsToken"] = 33] = "LessThanEqualsToken";
            SyntaxKind5[SyntaxKind5["GreaterThanEqualsToken"] = 34] = "GreaterThanEqualsToken";
            SyntaxKind5[SyntaxKind5["EqualsEqualsToken"] = 35] = "EqualsEqualsToken";
            SyntaxKind5[SyntaxKind5["ExclamationEqualsToken"] = 36] = "ExclamationEqualsToken";
            SyntaxKind5[SyntaxKind5["EqualsEqualsEqualsToken"] = 37] = "EqualsEqualsEqualsToken";
            SyntaxKind5[SyntaxKind5["ExclamationEqualsEqualsToken"] = 38] = "ExclamationEqualsEqualsToken";
            SyntaxKind5[SyntaxKind5["EqualsGreaterThanToken"] = 39] = "EqualsGreaterThanToken";
            SyntaxKind5[SyntaxKind5["PlusToken"] = 40] = "PlusToken";
            SyntaxKind5[SyntaxKind5["MinusToken"] = 41] = "MinusToken";
            SyntaxKind5[SyntaxKind5["AsteriskToken"] = 42] = "AsteriskToken";
            SyntaxKind5[SyntaxKind5["AsteriskAsteriskToken"] = 43] = "AsteriskAsteriskToken";
            SyntaxKind5[SyntaxKind5["SlashToken"] = 44] = "SlashToken";
            SyntaxKind5[SyntaxKind5["PercentToken"] = 45] = "PercentToken";
            SyntaxKind5[SyntaxKind5["PlusPlusToken"] = 46] = "PlusPlusToken";
            SyntaxKind5[SyntaxKind5["MinusMinusToken"] = 47] = "MinusMinusToken";
            SyntaxKind5[SyntaxKind5["LessThanLessThanToken"] = 48] = "LessThanLessThanToken";
            SyntaxKind5[SyntaxKind5["GreaterThanGreaterThanToken"] = 49] = "GreaterThanGreaterThanToken";
            SyntaxKind5[SyntaxKind5["GreaterThanGreaterThanGreaterThanToken"] = 50] = "GreaterThanGreaterThanGreaterThanToken";
            SyntaxKind5[SyntaxKind5["AmpersandToken"] = 51] = "AmpersandToken";
            SyntaxKind5[SyntaxKind5["BarToken"] = 52] = "BarToken";
            SyntaxKind5[SyntaxKind5["CaretToken"] = 53] = "CaretToken";
            SyntaxKind5[SyntaxKind5["ExclamationToken"] = 54] = "ExclamationToken";
            SyntaxKind5[SyntaxKind5["TildeToken"] = 55] = "TildeToken";
            SyntaxKind5[SyntaxKind5["AmpersandAmpersandToken"] = 56] = "AmpersandAmpersandToken";
            SyntaxKind5[SyntaxKind5["BarBarToken"] = 57] = "BarBarToken";
            SyntaxKind5[SyntaxKind5["QuestionToken"] = 58] = "QuestionToken";
            SyntaxKind5[SyntaxKind5["ColonToken"] = 59] = "ColonToken";
            SyntaxKind5[SyntaxKind5["AtToken"] = 60] = "AtToken";
            SyntaxKind5[SyntaxKind5["QuestionQuestionToken"] = 61] = "QuestionQuestionToken";
            SyntaxKind5[SyntaxKind5["BacktickToken"] = 62] = "BacktickToken";
            SyntaxKind5[SyntaxKind5["HashToken"] = 63] = "HashToken";
            SyntaxKind5[SyntaxKind5["EqualsToken"] = 64] = "EqualsToken";
            SyntaxKind5[SyntaxKind5["PlusEqualsToken"] = 65] = "PlusEqualsToken";
            SyntaxKind5[SyntaxKind5["MinusEqualsToken"] = 66] = "MinusEqualsToken";
            SyntaxKind5[SyntaxKind5["AsteriskEqualsToken"] = 67] = "AsteriskEqualsToken";
            SyntaxKind5[SyntaxKind5["AsteriskAsteriskEqualsToken"] = 68] = "AsteriskAsteriskEqualsToken";
            SyntaxKind5[SyntaxKind5["SlashEqualsToken"] = 69] = "SlashEqualsToken";
            SyntaxKind5[SyntaxKind5["PercentEqualsToken"] = 70] = "PercentEqualsToken";
            SyntaxKind5[SyntaxKind5["LessThanLessThanEqualsToken"] = 71] = "LessThanLessThanEqualsToken";
            SyntaxKind5[SyntaxKind5["GreaterThanGreaterThanEqualsToken"] = 72] = "GreaterThanGreaterThanEqualsToken";
            SyntaxKind5[SyntaxKind5["GreaterThanGreaterThanGreaterThanEqualsToken"] = 73] = "GreaterThanGreaterThanGreaterThanEqualsToken";
            SyntaxKind5[SyntaxKind5["AmpersandEqualsToken"] = 74] = "AmpersandEqualsToken";
            SyntaxKind5[SyntaxKind5["BarEqualsToken"] = 75] = "BarEqualsToken";
            SyntaxKind5[SyntaxKind5["BarBarEqualsToken"] = 76] = "BarBarEqualsToken";
            SyntaxKind5[SyntaxKind5["AmpersandAmpersandEqualsToken"] = 77] = "AmpersandAmpersandEqualsToken";
            SyntaxKind5[SyntaxKind5["QuestionQuestionEqualsToken"] = 78] = "QuestionQuestionEqualsToken";
            SyntaxKind5[SyntaxKind5["CaretEqualsToken"] = 79] = "CaretEqualsToken";
            SyntaxKind5[SyntaxKind5["Identifier"] = 80] = "Identifier";
            SyntaxKind5[SyntaxKind5["PrivateIdentifier"] = 81] = "PrivateIdentifier";
            SyntaxKind5[SyntaxKind5["JSDocCommentTextToken"] = 82] = "JSDocCommentTextToken";
            SyntaxKind5[SyntaxKind5["BreakKeyword"] = 83] = "BreakKeyword";
            SyntaxKind5[SyntaxKind5["CaseKeyword"] = 84] = "CaseKeyword";
            SyntaxKind5[SyntaxKind5["CatchKeyword"] = 85] = "CatchKeyword";
            SyntaxKind5[SyntaxKind5["ClassKeyword"] = 86] = "ClassKeyword";
            SyntaxKind5[SyntaxKind5["ConstKeyword"] = 87] = "ConstKeyword";
            SyntaxKind5[SyntaxKind5["ContinueKeyword"] = 88] = "ContinueKeyword";
            SyntaxKind5[SyntaxKind5["DebuggerKeyword"] = 89] = "DebuggerKeyword";
            SyntaxKind5[SyntaxKind5["DefaultKeyword"] = 90] = "DefaultKeyword";
            SyntaxKind5[SyntaxKind5["DeleteKeyword"] = 91] = "DeleteKeyword";
            SyntaxKind5[SyntaxKind5["DoKeyword"] = 92] = "DoKeyword";
            SyntaxKind5[SyntaxKind5["ElseKeyword"] = 93] = "ElseKeyword";
            SyntaxKind5[SyntaxKind5["EnumKeyword"] = 94] = "EnumKeyword";
            SyntaxKind5[SyntaxKind5["ExportKeyword"] = 95] = "ExportKeyword";
            SyntaxKind5[SyntaxKind5["ExtendsKeyword"] = 96] = "ExtendsKeyword";
            SyntaxKind5[SyntaxKind5["FalseKeyword"] = 97] = "FalseKeyword";
            SyntaxKind5[SyntaxKind5["FinallyKeyword"] = 98] = "FinallyKeyword";
            SyntaxKind5[SyntaxKind5["ForKeyword"] = 99] = "ForKeyword";
            SyntaxKind5[SyntaxKind5["FunctionKeyword"] = 100] = "FunctionKeyword";
            SyntaxKind5[SyntaxKind5["IfKeyword"] = 101] = "IfKeyword";
            SyntaxKind5[SyntaxKind5["ImportKeyword"] = 102] = "ImportKeyword";
            SyntaxKind5[SyntaxKind5["InKeyword"] = 103] = "InKeyword";
            SyntaxKind5[SyntaxKind5["InstanceOfKeyword"] = 104] = "InstanceOfKeyword";
            SyntaxKind5[SyntaxKind5["NewKeyword"] = 105] = "NewKeyword";
            SyntaxKind5[SyntaxKind5["NullKeyword"] = 106] = "NullKeyword";
            SyntaxKind5[SyntaxKind5["ReturnKeyword"] = 107] = "ReturnKeyword";
            SyntaxKind5[SyntaxKind5["SuperKeyword"] = 108] = "SuperKeyword";
            SyntaxKind5[SyntaxKind5["SwitchKeyword"] = 109] = "SwitchKeyword";
            SyntaxKind5[SyntaxKind5["ThisKeyword"] = 110] = "ThisKeyword";
            SyntaxKind5[SyntaxKind5["ThrowKeyword"] = 111] = "ThrowKeyword";
            SyntaxKind5[SyntaxKind5["TrueKeyword"] = 112] = "TrueKeyword";
            SyntaxKind5[SyntaxKind5["TryKeyword"] = 113] = "TryKeyword";
            SyntaxKind5[SyntaxKind5["TypeOfKeyword"] = 114] = "TypeOfKeyword";
            SyntaxKind5[SyntaxKind5["VarKeyword"] = 115] = "VarKeyword";
            SyntaxKind5[SyntaxKind5["VoidKeyword"] = 116] = "VoidKeyword";
            SyntaxKind5[SyntaxKind5["WhileKeyword"] = 117] = "WhileKeyword";
            SyntaxKind5[SyntaxKind5["WithKeyword"] = 118] = "WithKeyword";
            SyntaxKind5[SyntaxKind5["ImplementsKeyword"] = 119] = "ImplementsKeyword";
            SyntaxKind5[SyntaxKind5["InterfaceKeyword"] = 120] = "InterfaceKeyword";
            SyntaxKind5[SyntaxKind5["LetKeyword"] = 121] = "LetKeyword";
            SyntaxKind5[SyntaxKind5["PackageKeyword"] = 122] = "PackageKeyword";
            SyntaxKind5[SyntaxKind5["PrivateKeyword"] = 123] = "PrivateKeyword";
            SyntaxKind5[SyntaxKind5["ProtectedKeyword"] = 124] = "ProtectedKeyword";
            SyntaxKind5[SyntaxKind5["PublicKeyword"] = 125] = "PublicKeyword";
            SyntaxKind5[SyntaxKind5["StaticKeyword"] = 126] = "StaticKeyword";
            SyntaxKind5[SyntaxKind5["YieldKeyword"] = 127] = "YieldKeyword";
            SyntaxKind5[SyntaxKind5["AbstractKeyword"] = 128] = "AbstractKeyword";
            SyntaxKind5[SyntaxKind5["AccessorKeyword"] = 129] = "AccessorKeyword";
            SyntaxKind5[SyntaxKind5["AsKeyword"] = 130] = "AsKeyword";
            SyntaxKind5[SyntaxKind5["AssertsKeyword"] = 131] = "AssertsKeyword";
            SyntaxKind5[SyntaxKind5["AssertKeyword"] = 132] = "AssertKeyword";
            SyntaxKind5[SyntaxKind5["AnyKeyword"] = 133] = "AnyKeyword";
            SyntaxKind5[SyntaxKind5["AsyncKeyword"] = 134] = "AsyncKeyword";
            SyntaxKind5[SyntaxKind5["AwaitKeyword"] = 135] = "AwaitKeyword";
            SyntaxKind5[SyntaxKind5["BooleanKeyword"] = 136] = "BooleanKeyword";
            SyntaxKind5[SyntaxKind5["ConstructorKeyword"] = 137] = "ConstructorKeyword";
            SyntaxKind5[SyntaxKind5["DeclareKeyword"] = 138] = "DeclareKeyword";
            SyntaxKind5[SyntaxKind5["GetKeyword"] = 139] = "GetKeyword";
            SyntaxKind5[SyntaxKind5["InferKeyword"] = 140] = "InferKeyword";
            SyntaxKind5[SyntaxKind5["IntrinsicKeyword"] = 141] = "IntrinsicKeyword";
            SyntaxKind5[SyntaxKind5["IsKeyword"] = 142] = "IsKeyword";
            SyntaxKind5[SyntaxKind5["KeyOfKeyword"] = 143] = "KeyOfKeyword";
            SyntaxKind5[SyntaxKind5["ModuleKeyword"] = 144] = "ModuleKeyword";
            SyntaxKind5[SyntaxKind5["NamespaceKeyword"] = 145] = "NamespaceKeyword";
            SyntaxKind5[SyntaxKind5["NeverKeyword"] = 146] = "NeverKeyword";
            SyntaxKind5[SyntaxKind5["OutKeyword"] = 147] = "OutKeyword";
            SyntaxKind5[SyntaxKind5["ReadonlyKeyword"] = 148] = "ReadonlyKeyword";
            SyntaxKind5[SyntaxKind5["RequireKeyword"] = 149] = "RequireKeyword";
            SyntaxKind5[SyntaxKind5["NumberKeyword"] = 150] = "NumberKeyword";
            SyntaxKind5[SyntaxKind5["ObjectKeyword"] = 151] = "ObjectKeyword";
            SyntaxKind5[SyntaxKind5["SatisfiesKeyword"] = 152] = "SatisfiesKeyword";
            SyntaxKind5[SyntaxKind5["SetKeyword"] = 153] = "SetKeyword";
            SyntaxKind5[SyntaxKind5["StringKeyword"] = 154] = "StringKeyword";
            SyntaxKind5[SyntaxKind5["SymbolKeyword"] = 155] = "SymbolKeyword";
            SyntaxKind5[SyntaxKind5["TypeKeyword"] = 156] = "TypeKeyword";
            SyntaxKind5[SyntaxKind5["UndefinedKeyword"] = 157] = "UndefinedKeyword";
            SyntaxKind5[SyntaxKind5["UniqueKeyword"] = 158] = "UniqueKeyword";
            SyntaxKind5[SyntaxKind5["UnknownKeyword"] = 159] = "UnknownKeyword";
            SyntaxKind5[SyntaxKind5["UsingKeyword"] = 160] = "UsingKeyword";
            SyntaxKind5[SyntaxKind5["FromKeyword"] = 161] = "FromKeyword";
            SyntaxKind5[SyntaxKind5["GlobalKeyword"] = 162] = "GlobalKeyword";
            SyntaxKind5[SyntaxKind5["BigIntKeyword"] = 163] = "BigIntKeyword";
            SyntaxKind5[SyntaxKind5["OverrideKeyword"] = 164] = "OverrideKeyword";
            SyntaxKind5[SyntaxKind5["OfKeyword"] = 165] = "OfKeyword";
            SyntaxKind5[SyntaxKind5["QualifiedName"] = 166] = "QualifiedName";
            SyntaxKind5[SyntaxKind5["ComputedPropertyName"] = 167] = "ComputedPropertyName";
            SyntaxKind5[SyntaxKind5["TypeParameter"] = 168] = "TypeParameter";
            SyntaxKind5[SyntaxKind5["Parameter"] = 169] = "Parameter";
            SyntaxKind5[SyntaxKind5["Decorator"] = 170] = "Decorator";
            SyntaxKind5[SyntaxKind5["PropertySignature"] = 171] = "PropertySignature";
            SyntaxKind5[SyntaxKind5["PropertyDeclaration"] = 172] = "PropertyDeclaration";
            SyntaxKind5[SyntaxKind5["MethodSignature"] = 173] = "MethodSignature";
            SyntaxKind5[SyntaxKind5["MethodDeclaration"] = 174] = "MethodDeclaration";
            SyntaxKind5[SyntaxKind5["ClassStaticBlockDeclaration"] = 175] = "ClassStaticBlockDeclaration";
            SyntaxKind5[SyntaxKind5["Constructor"] = 176] = "Constructor";
            SyntaxKind5[SyntaxKind5["GetAccessor"] = 177] = "GetAccessor";
            SyntaxKind5[SyntaxKind5["SetAccessor"] = 178] = "SetAccessor";
            SyntaxKind5[SyntaxKind5["CallSignature"] = 179] = "CallSignature";
            SyntaxKind5[SyntaxKind5["ConstructSignature"] = 180] = "ConstructSignature";
            SyntaxKind5[SyntaxKind5["IndexSignature"] = 181] = "IndexSignature";
            SyntaxKind5[SyntaxKind5["TypePredicate"] = 182] = "TypePredicate";
            SyntaxKind5[SyntaxKind5["TypeReference"] = 183] = "TypeReference";
            SyntaxKind5[SyntaxKind5["FunctionType"] = 184] = "FunctionType";
            SyntaxKind5[SyntaxKind5["ConstructorType"] = 185] = "ConstructorType";
            SyntaxKind5[SyntaxKind5["TypeQuery"] = 186] = "TypeQuery";
            SyntaxKind5[SyntaxKind5["TypeLiteral"] = 187] = "TypeLiteral";
            SyntaxKind5[SyntaxKind5["ArrayType"] = 188] = "ArrayType";
            SyntaxKind5[SyntaxKind5["TupleType"] = 189] = "TupleType";
            SyntaxKind5[SyntaxKind5["OptionalType"] = 190] = "OptionalType";
            SyntaxKind5[SyntaxKind5["RestType"] = 191] = "RestType";
            SyntaxKind5[SyntaxKind5["UnionType"] = 192] = "UnionType";
            SyntaxKind5[SyntaxKind5["IntersectionType"] = 193] = "IntersectionType";
            SyntaxKind5[SyntaxKind5["ConditionalType"] = 194] = "ConditionalType";
            SyntaxKind5[SyntaxKind5["InferType"] = 195] = "InferType";
            SyntaxKind5[SyntaxKind5["ParenthesizedType"] = 196] = "ParenthesizedType";
            SyntaxKind5[SyntaxKind5["ThisType"] = 197] = "ThisType";
            SyntaxKind5[SyntaxKind5["TypeOperator"] = 198] = "TypeOperator";
            SyntaxKind5[SyntaxKind5["IndexedAccessType"] = 199] = "IndexedAccessType";
            SyntaxKind5[SyntaxKind5["MappedType"] = 200] = "MappedType";
            SyntaxKind5[SyntaxKind5["LiteralType"] = 201] = "LiteralType";
            SyntaxKind5[SyntaxKind5["NamedTupleMember"] = 202] = "NamedTupleMember";
            SyntaxKind5[SyntaxKind5["TemplateLiteralType"] = 203] = "TemplateLiteralType";
            SyntaxKind5[SyntaxKind5["TemplateLiteralTypeSpan"] = 204] = "TemplateLiteralTypeSpan";
            SyntaxKind5[SyntaxKind5["ImportType"] = 205] = "ImportType";
            SyntaxKind5[SyntaxKind5["ObjectBindingPattern"] = 206] = "ObjectBindingPattern";
            SyntaxKind5[SyntaxKind5["ArrayBindingPattern"] = 207] = "ArrayBindingPattern";
            SyntaxKind5[SyntaxKind5["BindingElement"] = 208] = "BindingElement";
            SyntaxKind5[SyntaxKind5["ArrayLiteralExpression"] = 209] = "ArrayLiteralExpression";
            SyntaxKind5[SyntaxKind5["ObjectLiteralExpression"] = 210] = "ObjectLiteralExpression";
            SyntaxKind5[SyntaxKind5["PropertyAccessExpression"] = 211] = "PropertyAccessExpression";
            SyntaxKind5[SyntaxKind5["ElementAccessExpression"] = 212] = "ElementAccessExpression";
            SyntaxKind5[SyntaxKind5["CallExpression"] = 213] = "CallExpression";
            SyntaxKind5[SyntaxKind5["NewExpression"] = 214] = "NewExpression";
            SyntaxKind5[SyntaxKind5["TaggedTemplateExpression"] = 215] = "TaggedTemplateExpression";
            SyntaxKind5[SyntaxKind5["TypeAssertionExpression"] = 216] = "TypeAssertionExpression";
            SyntaxKind5[SyntaxKind5["ParenthesizedExpression"] = 217] = "ParenthesizedExpression";
            SyntaxKind5[SyntaxKind5["FunctionExpression"] = 218] = "FunctionExpression";
            SyntaxKind5[SyntaxKind5["ArrowFunction"] = 219] = "ArrowFunction";
            SyntaxKind5[SyntaxKind5["DeleteExpression"] = 220] = "DeleteExpression";
            SyntaxKind5[SyntaxKind5["TypeOfExpression"] = 221] = "TypeOfExpression";
            SyntaxKind5[SyntaxKind5["VoidExpression"] = 222] = "VoidExpression";
            SyntaxKind5[SyntaxKind5["AwaitExpression"] = 223] = "AwaitExpression";
            SyntaxKind5[SyntaxKind5["PrefixUnaryExpression"] = 224] = "PrefixUnaryExpression";
            SyntaxKind5[SyntaxKind5["PostfixUnaryExpression"] = 225] = "PostfixUnaryExpression";
            SyntaxKind5[SyntaxKind5["BinaryExpression"] = 226] = "BinaryExpression";
            SyntaxKind5[SyntaxKind5["ConditionalExpression"] = 227] = "ConditionalExpression";
            SyntaxKind5[SyntaxKind5["TemplateExpression"] = 228] = "TemplateExpression";
            SyntaxKind5[SyntaxKind5["YieldExpression"] = 229] = "YieldExpression";
            SyntaxKind5[SyntaxKind5["SpreadElement"] = 230] = "SpreadElement";
            SyntaxKind5[SyntaxKind5["ClassExpression"] = 231] = "ClassExpression";
            SyntaxKind5[SyntaxKind5["OmittedExpression"] = 232] = "OmittedExpression";
            SyntaxKind5[SyntaxKind5["ExpressionWithTypeArguments"] = 233] = "ExpressionWithTypeArguments";
            SyntaxKind5[SyntaxKind5["AsExpression"] = 234] = "AsExpression";
            SyntaxKind5[SyntaxKind5["NonNullExpression"] = 235] = "NonNullExpression";
            SyntaxKind5[SyntaxKind5["MetaProperty"] = 236] = "MetaProperty";
            SyntaxKind5[SyntaxKind5["SyntheticExpression"] = 237] = "SyntheticExpression";
            SyntaxKind5[SyntaxKind5["SatisfiesExpression"] = 238] = "SatisfiesExpression";
            SyntaxKind5[SyntaxKind5["TemplateSpan"] = 239] = "TemplateSpan";
            SyntaxKind5[SyntaxKind5["SemicolonClassElement"] = 240] = "SemicolonClassElement";
            SyntaxKind5[SyntaxKind5["Block"] = 241] = "Block";
            SyntaxKind5[SyntaxKind5["EmptyStatement"] = 242] = "EmptyStatement";
            SyntaxKind5[SyntaxKind5["VariableStatement"] = 243] = "VariableStatement";
            SyntaxKind5[SyntaxKind5["ExpressionStatement"] = 244] = "ExpressionStatement";
            SyntaxKind5[SyntaxKind5["IfStatement"] = 245] = "IfStatement";
            SyntaxKind5[SyntaxKind5["DoStatement"] = 246] = "DoStatement";
            SyntaxKind5[SyntaxKind5["WhileStatement"] = 247] = "WhileStatement";
            SyntaxKind5[SyntaxKind5["ForStatement"] = 248] = "ForStatement";
            SyntaxKind5[SyntaxKind5["ForInStatement"] = 249] = "ForInStatement";
            SyntaxKind5[SyntaxKind5["ForOfStatement"] = 250] = "ForOfStatement";
            SyntaxKind5[SyntaxKind5["ContinueStatement"] = 251] = "ContinueStatement";
            SyntaxKind5[SyntaxKind5["BreakStatement"] = 252] = "BreakStatement";
            SyntaxKind5[SyntaxKind5["ReturnStatement"] = 253] = "ReturnStatement";
            SyntaxKind5[SyntaxKind5["WithStatement"] = 254] = "WithStatement";
            SyntaxKind5[SyntaxKind5["SwitchStatement"] = 255] = "SwitchStatement";
            SyntaxKind5[SyntaxKind5["LabeledStatement"] = 256] = "LabeledStatement";
            SyntaxKind5[SyntaxKind5["ThrowStatement"] = 257] = "ThrowStatement";
            SyntaxKind5[SyntaxKind5["TryStatement"] = 258] = "TryStatement";
            SyntaxKind5[SyntaxKind5["DebuggerStatement"] = 259] = "DebuggerStatement";
            SyntaxKind5[SyntaxKind5["VariableDeclaration"] = 260] = "VariableDeclaration";
            SyntaxKind5[SyntaxKind5["VariableDeclarationList"] = 261] = "VariableDeclarationList";
            SyntaxKind5[SyntaxKind5["FunctionDeclaration"] = 262] = "FunctionDeclaration";
            SyntaxKind5[SyntaxKind5["ClassDeclaration"] = 263] = "ClassDeclaration";
            SyntaxKind5[SyntaxKind5["InterfaceDeclaration"] = 264] = "InterfaceDeclaration";
            SyntaxKind5[SyntaxKind5["TypeAliasDeclaration"] = 265] = "TypeAliasDeclaration";
            SyntaxKind5[SyntaxKind5["EnumDeclaration"] = 266] = "EnumDeclaration";
            SyntaxKind5[SyntaxKind5["ModuleDeclaration"] = 267] = "ModuleDeclaration";
            SyntaxKind5[SyntaxKind5["ModuleBlock"] = 268] = "ModuleBlock";
            SyntaxKind5[SyntaxKind5["CaseBlock"] = 269] = "CaseBlock";
            SyntaxKind5[SyntaxKind5["NamespaceExportDeclaration"] = 270] = "NamespaceExportDeclaration";
            SyntaxKind5[SyntaxKind5["ImportEqualsDeclaration"] = 271] = "ImportEqualsDeclaration";
            SyntaxKind5[SyntaxKind5["ImportDeclaration"] = 272] = "ImportDeclaration";
            SyntaxKind5[SyntaxKind5["ImportClause"] = 273] = "ImportClause";
            SyntaxKind5[SyntaxKind5["NamespaceImport"] = 274] = "NamespaceImport";
            SyntaxKind5[SyntaxKind5["NamedImports"] = 275] = "NamedImports";
            SyntaxKind5[SyntaxKind5["ImportSpecifier"] = 276] = "ImportSpecifier";
            SyntaxKind5[SyntaxKind5["ExportAssignment"] = 277] = "ExportAssignment";
            SyntaxKind5[SyntaxKind5["ExportDeclaration"] = 278] = "ExportDeclaration";
            SyntaxKind5[SyntaxKind5["NamedExports"] = 279] = "NamedExports";
            SyntaxKind5[SyntaxKind5["NamespaceExport"] = 280] = "NamespaceExport";
            SyntaxKind5[SyntaxKind5["ExportSpecifier"] = 281] = "ExportSpecifier";
            SyntaxKind5[SyntaxKind5["MissingDeclaration"] = 282] = "MissingDeclaration";
            SyntaxKind5[SyntaxKind5["ExternalModuleReference"] = 283] = "ExternalModuleReference";
            SyntaxKind5[SyntaxKind5["JsxElement"] = 284] = "JsxElement";
            SyntaxKind5[SyntaxKind5["JsxSelfClosingElement"] = 285] = "JsxSelfClosingElement";
            SyntaxKind5[SyntaxKind5["JsxOpeningElement"] = 286] = "JsxOpeningElement";
            SyntaxKind5[SyntaxKind5["JsxClosingElement"] = 287] = "JsxClosingElement";
            SyntaxKind5[SyntaxKind5["JsxFragment"] = 288] = "JsxFragment";
            SyntaxKind5[SyntaxKind5["JsxOpeningFragment"] = 289] = "JsxOpeningFragment";
            SyntaxKind5[SyntaxKind5["JsxClosingFragment"] = 290] = "JsxClosingFragment";
            SyntaxKind5[SyntaxKind5["JsxAttribute"] = 291] = "JsxAttribute";
            SyntaxKind5[SyntaxKind5["JsxAttributes"] = 292] = "JsxAttributes";
            SyntaxKind5[SyntaxKind5["JsxSpreadAttribute"] = 293] = "JsxSpreadAttribute";
            SyntaxKind5[SyntaxKind5["JsxExpression"] = 294] = "JsxExpression";
            SyntaxKind5[SyntaxKind5["JsxNamespacedName"] = 295] = "JsxNamespacedName";
            SyntaxKind5[SyntaxKind5["CaseClause"] = 296] = "CaseClause";
            SyntaxKind5[SyntaxKind5["DefaultClause"] = 297] = "DefaultClause";
            SyntaxKind5[SyntaxKind5["HeritageClause"] = 298] = "HeritageClause";
            SyntaxKind5[SyntaxKind5["CatchClause"] = 299] = "CatchClause";
            SyntaxKind5[SyntaxKind5["ImportAttributes"] = 300] = "ImportAttributes";
            SyntaxKind5[SyntaxKind5["ImportAttribute"] = 301] = "ImportAttribute";
            SyntaxKind5[
              SyntaxKind5["AssertClause"] = 300
              /* ImportAttributes */
            ] = "AssertClause";
            SyntaxKind5[
              SyntaxKind5["AssertEntry"] = 301
              /* ImportAttribute */
            ] = "AssertEntry";
            SyntaxKind5[SyntaxKind5["ImportTypeAssertionContainer"] = 302] = "ImportTypeAssertionContainer";
            SyntaxKind5[SyntaxKind5["PropertyAssignment"] = 303] = "PropertyAssignment";
            SyntaxKind5[SyntaxKind5["ShorthandPropertyAssignment"] = 304] = "ShorthandPropertyAssignment";
            SyntaxKind5[SyntaxKind5["SpreadAssignment"] = 305] = "SpreadAssignment";
            SyntaxKind5[SyntaxKind5["EnumMember"] = 306] = "EnumMember";
            SyntaxKind5[SyntaxKind5["UnparsedPrologue"] = 307] = "UnparsedPrologue";
            SyntaxKind5[SyntaxKind5["UnparsedPrepend"] = 308] = "UnparsedPrepend";
            SyntaxKind5[SyntaxKind5["UnparsedText"] = 309] = "UnparsedText";
            SyntaxKind5[SyntaxKind5["UnparsedInternalText"] = 310] = "UnparsedInternalText";
            SyntaxKind5[SyntaxKind5["UnparsedSyntheticReference"] = 311] = "UnparsedSyntheticReference";
            SyntaxKind5[SyntaxKind5["SourceFile"] = 312] = "SourceFile";
            SyntaxKind5[SyntaxKind5["Bundle"] = 313] = "Bundle";
            SyntaxKind5[SyntaxKind5["UnparsedSource"] = 314] = "UnparsedSource";
            SyntaxKind5[SyntaxKind5["InputFiles"] = 315] = "InputFiles";
            SyntaxKind5[SyntaxKind5["JSDocTypeExpression"] = 316] = "JSDocTypeExpression";
            SyntaxKind5[SyntaxKind5["JSDocNameReference"] = 317] = "JSDocNameReference";
            SyntaxKind5[SyntaxKind5["JSDocMemberName"] = 318] = "JSDocMemberName";
            SyntaxKind5[SyntaxKind5["JSDocAllType"] = 319] = "JSDocAllType";
            SyntaxKind5[SyntaxKind5["JSDocUnknownType"] = 320] = "JSDocUnknownType";
            SyntaxKind5[SyntaxKind5["JSDocNullableType"] = 321] = "JSDocNullableType";
            SyntaxKind5[SyntaxKind5["JSDocNonNullableType"] = 322] = "JSDocNonNullableType";
            SyntaxKind5[SyntaxKind5["JSDocOptionalType"] = 323] = "JSDocOptionalType";
            SyntaxKind5[SyntaxKind5["JSDocFunctionType"] = 324] = "JSDocFunctionType";
            SyntaxKind5[SyntaxKind5["JSDocVariadicType"] = 325] = "JSDocVariadicType";
            SyntaxKind5[SyntaxKind5["JSDocNamepathType"] = 326] = "JSDocNamepathType";
            SyntaxKind5[SyntaxKind5["JSDoc"] = 327] = "JSDoc";
            SyntaxKind5[
              SyntaxKind5["JSDocComment"] = 327
              /* JSDoc */
            ] = "JSDocComment";
            SyntaxKind5[SyntaxKind5["JSDocText"] = 328] = "JSDocText";
            SyntaxKind5[SyntaxKind5["JSDocTypeLiteral"] = 329] = "JSDocTypeLiteral";
            SyntaxKind5[SyntaxKind5["JSDocSignature"] = 330] = "JSDocSignature";
            SyntaxKind5[SyntaxKind5["JSDocLink"] = 331] = "JSDocLink";
            SyntaxKind5[SyntaxKind5["JSDocLinkCode"] = 332] = "JSDocLinkCode";
            SyntaxKind5[SyntaxKind5["JSDocLinkPlain"] = 333] = "JSDocLinkPlain";
            SyntaxKind5[SyntaxKind5["JSDocTag"] = 334] = "JSDocTag";
            SyntaxKind5[SyntaxKind5["JSDocAugmentsTag"] = 335] = "JSDocAugmentsTag";
            SyntaxKind5[SyntaxKind5["JSDocImplementsTag"] = 336] = "JSDocImplementsTag";
            SyntaxKind5[SyntaxKind5["JSDocAuthorTag"] = 337] = "JSDocAuthorTag";
            SyntaxKind5[SyntaxKind5["JSDocDeprecatedTag"] = 338] = "JSDocDeprecatedTag";
            SyntaxKind5[SyntaxKind5["JSDocClassTag"] = 339] = "JSDocClassTag";
            SyntaxKind5[SyntaxKind5["JSDocPublicTag"] = 340] = "JSDocPublicTag";
            SyntaxKind5[SyntaxKind5["JSDocPrivateTag"] = 341] = "JSDocPrivateTag";
            SyntaxKind5[SyntaxKind5["JSDocProtectedTag"] = 342] = "JSDocProtectedTag";
            SyntaxKind5[SyntaxKind5["JSDocReadonlyTag"] = 343] = "JSDocReadonlyTag";
            SyntaxKind5[SyntaxKind5["JSDocOverrideTag"] = 344] = "JSDocOverrideTag";
            SyntaxKind5[SyntaxKind5["JSDocCallbackTag"] = 345] = "JSDocCallbackTag";
            SyntaxKind5[SyntaxKind5["JSDocOverloadTag"] = 346] = "JSDocOverloadTag";
            SyntaxKind5[SyntaxKind5["JSDocEnumTag"] = 347] = "JSDocEnumTag";
            SyntaxKind5[SyntaxKind5["JSDocParameterTag"] = 348] = "JSDocParameterTag";
            SyntaxKind5[SyntaxKind5["JSDocReturnTag"] = 349] = "JSDocReturnTag";
            SyntaxKind5[SyntaxKind5["JSDocThisTag"] = 350] = "JSDocThisTag";
            SyntaxKind5[SyntaxKind5["JSDocTypeTag"] = 351] = "JSDocTypeTag";
            SyntaxKind5[SyntaxKind5["JSDocTemplateTag"] = 352] = "JSDocTemplateTag";
            SyntaxKind5[SyntaxKind5["JSDocTypedefTag"] = 353] = "JSDocTypedefTag";
            SyntaxKind5[SyntaxKind5["JSDocSeeTag"] = 354] = "JSDocSeeTag";
            SyntaxKind5[SyntaxKind5["JSDocPropertyTag"] = 355] = "JSDocPropertyTag";
            SyntaxKind5[SyntaxKind5["JSDocThrowsTag"] = 356] = "JSDocThrowsTag";
            SyntaxKind5[SyntaxKind5["JSDocSatisfiesTag"] = 357] = "JSDocSatisfiesTag";
            SyntaxKind5[SyntaxKind5["SyntaxList"] = 358] = "SyntaxList";
            SyntaxKind5[SyntaxKind5["NotEmittedStatement"] = 359] = "NotEmittedStatement";
            SyntaxKind5[SyntaxKind5["PartiallyEmittedExpression"] = 360] = "PartiallyEmittedExpression";
            SyntaxKind5[SyntaxKind5["CommaListExpression"] = 361] = "CommaListExpression";
            SyntaxKind5[SyntaxKind5["SyntheticReferenceExpression"] = 362] = "SyntheticReferenceExpression";
            SyntaxKind5[SyntaxKind5["Count"] = 363] = "Count";
            SyntaxKind5[
              SyntaxKind5["FirstAssignment"] = 64
              /* EqualsToken */
            ] = "FirstAssignment";
            SyntaxKind5[
              SyntaxKind5["LastAssignment"] = 79
              /* CaretEqualsToken */
            ] = "LastAssignment";
            SyntaxKind5[
              SyntaxKind5["FirstCompoundAssignment"] = 65
              /* PlusEqualsToken */
            ] = "FirstCompoundAssignment";
            SyntaxKind5[
              SyntaxKind5["LastCompoundAssignment"] = 79
              /* CaretEqualsToken */
            ] = "LastCompoundAssignment";
            SyntaxKind5[
              SyntaxKind5["FirstReservedWord"] = 83
              /* BreakKeyword */
            ] = "FirstReservedWord";
            SyntaxKind5[
              SyntaxKind5["LastReservedWord"] = 118
              /* WithKeyword */
            ] = "LastReservedWord";
            SyntaxKind5[
              SyntaxKind5["FirstKeyword"] = 83
              /* BreakKeyword */
            ] = "FirstKeyword";
            SyntaxKind5[
              SyntaxKind5["LastKeyword"] = 165
              /* OfKeyword */
            ] = "LastKeyword";
            SyntaxKind5[
              SyntaxKind5["FirstFutureReservedWord"] = 119
              /* ImplementsKeyword */
            ] = "FirstFutureReservedWord";
            SyntaxKind5[
              SyntaxKind5["LastFutureReservedWord"] = 127
              /* YieldKeyword */
            ] = "LastFutureReservedWord";
            SyntaxKind5[
              SyntaxKind5["FirstTypeNode"] = 182
              /* TypePredicate */
            ] = "FirstTypeNode";
            SyntaxKind5[
              SyntaxKind5["LastTypeNode"] = 205
              /* ImportType */
            ] = "LastTypeNode";
            SyntaxKind5[
              SyntaxKind5["FirstPunctuation"] = 19
              /* OpenBraceToken */
            ] = "FirstPunctuation";
            SyntaxKind5[
              SyntaxKind5["LastPunctuation"] = 79
              /* CaretEqualsToken */
            ] = "LastPunctuation";
            SyntaxKind5[
              SyntaxKind5["FirstToken"] = 0
              /* Unknown */
            ] = "FirstToken";
            SyntaxKind5[
              SyntaxKind5["LastToken"] = 165
              /* LastKeyword */
            ] = "LastToken";
            SyntaxKind5[
              SyntaxKind5["FirstTriviaToken"] = 2
              /* SingleLineCommentTrivia */
            ] = "FirstTriviaToken";
            SyntaxKind5[
              SyntaxKind5["LastTriviaToken"] = 7
              /* ConflictMarkerTrivia */
            ] = "LastTriviaToken";
            SyntaxKind5[
              SyntaxKind5["FirstLiteralToken"] = 9
              /* NumericLiteral */
            ] = "FirstLiteralToken";
            SyntaxKind5[
              SyntaxKind5["LastLiteralToken"] = 15
              /* NoSubstitutionTemplateLiteral */
            ] = "LastLiteralToken";
            SyntaxKind5[
              SyntaxKind5["FirstTemplateToken"] = 15
              /* NoSubstitutionTemplateLiteral */
            ] = "FirstTemplateToken";
            SyntaxKind5[
              SyntaxKind5["LastTemplateToken"] = 18
              /* TemplateTail */
            ] = "LastTemplateToken";
            SyntaxKind5[
              SyntaxKind5["FirstBinaryOperator"] = 30
              /* LessThanToken */
            ] = "FirstBinaryOperator";
            SyntaxKind5[
              SyntaxKind5["LastBinaryOperator"] = 79
              /* CaretEqualsToken */
            ] = "LastBinaryOperator";
            SyntaxKind5[
              SyntaxKind5["FirstStatement"] = 243
              /* VariableStatement */
            ] = "FirstStatement";
            SyntaxKind5[
              SyntaxKind5["LastStatement"] = 259
              /* DebuggerStatement */
            ] = "LastStatement";
            SyntaxKind5[
              SyntaxKind5["FirstNode"] = 166
              /* QualifiedName */
            ] = "FirstNode";
            SyntaxKind5[
              SyntaxKind5["FirstJSDocNode"] = 316
              /* JSDocTypeExpression */
            ] = "FirstJSDocNode";
            SyntaxKind5[
              SyntaxKind5["LastJSDocNode"] = 357
              /* JSDocSatisfiesTag */
            ] = "LastJSDocNode";
            SyntaxKind5[
              SyntaxKind5["FirstJSDocTagNode"] = 334
              /* JSDocTag */
            ] = "FirstJSDocTagNode";
            SyntaxKind5[
              SyntaxKind5["LastJSDocTagNode"] = 357
              /* JSDocSatisfiesTag */
            ] = "LastJSDocTagNode";
            SyntaxKind5[
              SyntaxKind5["FirstContextualKeyword"] = 128
              /* AbstractKeyword */
            ] = "FirstContextualKeyword";
            SyntaxKind5[
              SyntaxKind5["LastContextualKeyword"] = 165
              /* OfKeyword */
            ] = "LastContextualKeyword";
            return SyntaxKind5;
          })(SyntaxKind || {});
          NodeFlags = ((NodeFlags3) => {
            NodeFlags3[NodeFlags3["None"] = 0] = "None";
            NodeFlags3[NodeFlags3["Let"] = 1] = "Let";
            NodeFlags3[NodeFlags3["Const"] = 2] = "Const";
            NodeFlags3[NodeFlags3["Using"] = 4] = "Using";
            NodeFlags3[NodeFlags3["AwaitUsing"] = 6] = "AwaitUsing";
            NodeFlags3[NodeFlags3["NestedNamespace"] = 8] = "NestedNamespace";
            NodeFlags3[NodeFlags3["Synthesized"] = 16] = "Synthesized";
            NodeFlags3[NodeFlags3["Namespace"] = 32] = "Namespace";
            NodeFlags3[NodeFlags3["OptionalChain"] = 64] = "OptionalChain";
            NodeFlags3[NodeFlags3["ExportContext"] = 128] = "ExportContext";
            NodeFlags3[NodeFlags3["ContainsThis"] = 256] = "ContainsThis";
            NodeFlags3[NodeFlags3["HasImplicitReturn"] = 512] = "HasImplicitReturn";
            NodeFlags3[NodeFlags3["HasExplicitReturn"] = 1024] = "HasExplicitReturn";
            NodeFlags3[NodeFlags3["GlobalAugmentation"] = 2048] = "GlobalAugmentation";
            NodeFlags3[NodeFlags3["HasAsyncFunctions"] = 4096] = "HasAsyncFunctions";
            NodeFlags3[NodeFlags3["DisallowInContext"] = 8192] = "DisallowInContext";
            NodeFlags3[NodeFlags3["YieldContext"] = 16384] = "YieldContext";
            NodeFlags3[NodeFlags3["DecoratorContext"] = 32768] = "DecoratorContext";
            NodeFlags3[NodeFlags3["AwaitContext"] = 65536] = "AwaitContext";
            NodeFlags3[NodeFlags3["DisallowConditionalTypesContext"] = 131072] = "DisallowConditionalTypesContext";
            NodeFlags3[NodeFlags3["ThisNodeHasError"] = 262144] = "ThisNodeHasError";
            NodeFlags3[NodeFlags3["JavaScriptFile"] = 524288] = "JavaScriptFile";
            NodeFlags3[NodeFlags3["ThisNodeOrAnySubNodesHasError"] = 1048576] = "ThisNodeOrAnySubNodesHasError";
            NodeFlags3[NodeFlags3["HasAggregatedChildData"] = 2097152] = "HasAggregatedChildData";
            NodeFlags3[NodeFlags3["PossiblyContainsDynamicImport"] = 4194304] = "PossiblyContainsDynamicImport";
            NodeFlags3[NodeFlags3["PossiblyContainsImportMeta"] = 8388608] = "PossiblyContainsImportMeta";
            NodeFlags3[NodeFlags3["JSDoc"] = 16777216] = "JSDoc";
            NodeFlags3[NodeFlags3["Ambient"] = 33554432] = "Ambient";
            NodeFlags3[NodeFlags3["InWithStatement"] = 67108864] = "InWithStatement";
            NodeFlags3[NodeFlags3["JsonFile"] = 134217728] = "JsonFile";
            NodeFlags3[NodeFlags3["TypeCached"] = 268435456] = "TypeCached";
            NodeFlags3[NodeFlags3["Deprecated"] = 536870912] = "Deprecated";
            NodeFlags3[NodeFlags3["BlockScoped"] = 7] = "BlockScoped";
            NodeFlags3[NodeFlags3["Constant"] = 6] = "Constant";
            NodeFlags3[NodeFlags3["ReachabilityCheckFlags"] = 1536] = "ReachabilityCheckFlags";
            NodeFlags3[NodeFlags3["ReachabilityAndEmitFlags"] = 5632] = "ReachabilityAndEmitFlags";
            NodeFlags3[NodeFlags3["ContextFlags"] = 101441536] = "ContextFlags";
            NodeFlags3[NodeFlags3["TypeExcludesFlags"] = 81920] = "TypeExcludesFlags";
            NodeFlags3[NodeFlags3["PermanentlySetIncrementalFlags"] = 12582912] = "PermanentlySetIncrementalFlags";
            NodeFlags3[
              NodeFlags3["IdentifierHasExtendedUnicodeEscape"] = 256
              /* ContainsThis */
            ] = "IdentifierHasExtendedUnicodeEscape";
            NodeFlags3[
              NodeFlags3["IdentifierIsInJSDocNamespace"] = 4096
              /* HasAsyncFunctions */
            ] = "IdentifierIsInJSDocNamespace";
            return NodeFlags3;
          })(NodeFlags || {});
          ModifierFlags = ((ModifierFlags3) => {
            ModifierFlags3[ModifierFlags3["None"] = 0] = "None";
            ModifierFlags3[ModifierFlags3["Public"] = 1] = "Public";
            ModifierFlags3[ModifierFlags3["Private"] = 2] = "Private";
            ModifierFlags3[ModifierFlags3["Protected"] = 4] = "Protected";
            ModifierFlags3[ModifierFlags3["Readonly"] = 8] = "Readonly";
            ModifierFlags3[ModifierFlags3["Override"] = 16] = "Override";
            ModifierFlags3[ModifierFlags3["Export"] = 32] = "Export";
            ModifierFlags3[ModifierFlags3["Abstract"] = 64] = "Abstract";
            ModifierFlags3[ModifierFlags3["Ambient"] = 128] = "Ambient";
            ModifierFlags3[ModifierFlags3["Static"] = 256] = "Static";
            ModifierFlags3[ModifierFlags3["Accessor"] = 512] = "Accessor";
            ModifierFlags3[ModifierFlags3["Async"] = 1024] = "Async";
            ModifierFlags3[ModifierFlags3["Default"] = 2048] = "Default";
            ModifierFlags3[ModifierFlags3["Const"] = 4096] = "Const";
            ModifierFlags3[ModifierFlags3["In"] = 8192] = "In";
            ModifierFlags3[ModifierFlags3["Out"] = 16384] = "Out";
            ModifierFlags3[ModifierFlags3["Decorator"] = 32768] = "Decorator";
            ModifierFlags3[ModifierFlags3["Deprecated"] = 65536] = "Deprecated";
            ModifierFlags3[ModifierFlags3["JSDocPublic"] = 8388608] = "JSDocPublic";
            ModifierFlags3[ModifierFlags3["JSDocPrivate"] = 16777216] = "JSDocPrivate";
            ModifierFlags3[ModifierFlags3["JSDocProtected"] = 33554432] = "JSDocProtected";
            ModifierFlags3[ModifierFlags3["JSDocReadonly"] = 67108864] = "JSDocReadonly";
            ModifierFlags3[ModifierFlags3["JSDocOverride"] = 134217728] = "JSDocOverride";
            ModifierFlags3[ModifierFlags3["SyntacticOrJSDocModifiers"] = 31] = "SyntacticOrJSDocModifiers";
            ModifierFlags3[ModifierFlags3["SyntacticOnlyModifiers"] = 65504] = "SyntacticOnlyModifiers";
            ModifierFlags3[ModifierFlags3["SyntacticModifiers"] = 65535] = "SyntacticModifiers";
            ModifierFlags3[ModifierFlags3["JSDocCacheOnlyModifiers"] = 260046848] = "JSDocCacheOnlyModifiers";
            ModifierFlags3[
              ModifierFlags3["JSDocOnlyModifiers"] = 65536
              /* Deprecated */
            ] = "JSDocOnlyModifiers";
            ModifierFlags3[ModifierFlags3["NonCacheOnlyModifiers"] = 131071] = "NonCacheOnlyModifiers";
            ModifierFlags3[ModifierFlags3["HasComputedJSDocModifiers"] = 268435456] = "HasComputedJSDocModifiers";
            ModifierFlags3[ModifierFlags3["HasComputedFlags"] = 536870912] = "HasComputedFlags";
            ModifierFlags3[ModifierFlags3["AccessibilityModifier"] = 7] = "AccessibilityModifier";
            ModifierFlags3[ModifierFlags3["ParameterPropertyModifier"] = 31] = "ParameterPropertyModifier";
            ModifierFlags3[ModifierFlags3["NonPublicAccessibilityModifier"] = 6] = "NonPublicAccessibilityModifier";
            ModifierFlags3[ModifierFlags3["TypeScriptModifier"] = 28895] = "TypeScriptModifier";
            ModifierFlags3[ModifierFlags3["ExportDefault"] = 2080] = "ExportDefault";
            ModifierFlags3[ModifierFlags3["All"] = 131071] = "All";
            ModifierFlags3[ModifierFlags3["Modifier"] = 98303] = "Modifier";
            return ModifierFlags3;
          })(ModifierFlags || {});
          JsxFlags = ((JsxFlags2) => {
            JsxFlags2[JsxFlags2["None"] = 0] = "None";
            JsxFlags2[JsxFlags2["IntrinsicNamedElement"] = 1] = "IntrinsicNamedElement";
            JsxFlags2[JsxFlags2["IntrinsicIndexedElement"] = 2] = "IntrinsicIndexedElement";
            JsxFlags2[JsxFlags2["IntrinsicElement"] = 3] = "IntrinsicElement";
            return JsxFlags2;
          })(JsxFlags || {});
          RelationComparisonResult = ((RelationComparisonResult3) => {
            RelationComparisonResult3[RelationComparisonResult3["Succeeded"] = 1] = "Succeeded";
            RelationComparisonResult3[RelationComparisonResult3["Failed"] = 2] = "Failed";
            RelationComparisonResult3[RelationComparisonResult3["Reported"] = 4] = "Reported";
            RelationComparisonResult3[RelationComparisonResult3["ReportsUnmeasurable"] = 8] = "ReportsUnmeasurable";
            RelationComparisonResult3[RelationComparisonResult3["ReportsUnreliable"] = 16] = "ReportsUnreliable";
            RelationComparisonResult3[RelationComparisonResult3["ReportsMask"] = 24] = "ReportsMask";
            return RelationComparisonResult3;
          })(RelationComparisonResult || {});
          GeneratedIdentifierFlags = ((GeneratedIdentifierFlags2) => {
            GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["None"] = 0] = "None";
            GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Auto"] = 1] = "Auto";
            GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Loop"] = 2] = "Loop";
            GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Unique"] = 3] = "Unique";
            GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Node"] = 4] = "Node";
            GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["KindMask"] = 7] = "KindMask";
            GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["ReservedInNestedScopes"] = 8] = "ReservedInNestedScopes";
            GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Optimistic"] = 16] = "Optimistic";
            GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["FileLevel"] = 32] = "FileLevel";
            GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["AllowNameSubstitution"] = 64] = "AllowNameSubstitution";
            return GeneratedIdentifierFlags2;
          })(GeneratedIdentifierFlags || {});
          TokenFlags = ((TokenFlags2) => {
            TokenFlags2[TokenFlags2["None"] = 0] = "None";
            TokenFlags2[TokenFlags2["PrecedingLineBreak"] = 1] = "PrecedingLineBreak";
            TokenFlags2[TokenFlags2["PrecedingJSDocComment"] = 2] = "PrecedingJSDocComment";
            TokenFlags2[TokenFlags2["Unterminated"] = 4] = "Unterminated";
            TokenFlags2[TokenFlags2["ExtendedUnicodeEscape"] = 8] = "ExtendedUnicodeEscape";
            TokenFlags2[TokenFlags2["Scientific"] = 16] = "Scientific";
            TokenFlags2[TokenFlags2["Octal"] = 32] = "Octal";
            TokenFlags2[TokenFlags2["HexSpecifier"] = 64] = "HexSpecifier";
            TokenFlags2[TokenFlags2["BinarySpecifier"] = 128] = "BinarySpecifier";
            TokenFlags2[TokenFlags2["OctalSpecifier"] = 256] = "OctalSpecifier";
            TokenFlags2[TokenFlags2["ContainsSeparator"] = 512] = "ContainsSeparator";
            TokenFlags2[TokenFlags2["UnicodeEscape"] = 1024] = "UnicodeEscape";
            TokenFlags2[TokenFlags2["ContainsInvalidEscape"] = 2048] = "ContainsInvalidEscape";
            TokenFlags2[TokenFlags2["HexEscape"] = 4096] = "HexEscape";
            TokenFlags2[TokenFlags2["ContainsLeadingZero"] = 8192] = "ContainsLeadingZero";
            TokenFlags2[TokenFlags2["ContainsInvalidSeparator"] = 16384] = "ContainsInvalidSeparator";
            TokenFlags2[TokenFlags2["BinaryOrOctalSpecifier"] = 384] = "BinaryOrOctalSpecifier";
            TokenFlags2[TokenFlags2["WithSpecifier"] = 448] = "WithSpecifier";
            TokenFlags2[TokenFlags2["StringLiteralFlags"] = 7176] = "StringLiteralFlags";
            TokenFlags2[TokenFlags2["NumericLiteralFlags"] = 25584] = "NumericLiteralFlags";
            TokenFlags2[TokenFlags2["TemplateLiteralLikeFlags"] = 7176] = "TemplateLiteralLikeFlags";
            TokenFlags2[TokenFlags2["IsInvalid"] = 26656] = "IsInvalid";
            return TokenFlags2;
          })(TokenFlags || {});
          FlowFlags = ((FlowFlags2) => {
            FlowFlags2[FlowFlags2["Unreachable"] = 1] = "Unreachable";
            FlowFlags2[FlowFlags2["Start"] = 2] = "Start";
            FlowFlags2[FlowFlags2["BranchLabel"] = 4] = "BranchLabel";
            FlowFlags2[FlowFlags2["LoopLabel"] = 8] = "LoopLabel";
            FlowFlags2[FlowFlags2["Assignment"] = 16] = "Assignment";
            FlowFlags2[FlowFlags2["TrueCondition"] = 32] = "TrueCondition";
            FlowFlags2[FlowFlags2["FalseCondition"] = 64] = "FalseCondition";
            FlowFlags2[FlowFlags2["SwitchClause"] = 128] = "SwitchClause";
            FlowFlags2[FlowFlags2["ArrayMutation"] = 256] = "ArrayMutation";
            FlowFlags2[FlowFlags2["Call"] = 512] = "Call";
            FlowFlags2[FlowFlags2["ReduceLabel"] = 1024] = "ReduceLabel";
            FlowFlags2[FlowFlags2["Referenced"] = 2048] = "Referenced";
            FlowFlags2[FlowFlags2["Shared"] = 4096] = "Shared";
            FlowFlags2[FlowFlags2["Label"] = 12] = "Label";
            FlowFlags2[FlowFlags2["Condition"] = 96] = "Condition";
            return FlowFlags2;
          })(FlowFlags || {});
          CommentDirectiveType = ((CommentDirectiveType2) => {
            CommentDirectiveType2[CommentDirectiveType2["ExpectError"] = 0] = "ExpectError";
            CommentDirectiveType2[CommentDirectiveType2["Ignore"] = 1] = "Ignore";
            return CommentDirectiveType2;
          })(CommentDirectiveType || {});
          OperationCanceledException = class {
          };
          FileIncludeKind = ((FileIncludeKind2) => {
            FileIncludeKind2[FileIncludeKind2["RootFile"] = 0] = "RootFile";
            FileIncludeKind2[FileIncludeKind2["SourceFromProjectReference"] = 1] = "SourceFromProjectReference";
            FileIncludeKind2[FileIncludeKind2["OutputFromProjectReference"] = 2] = "OutputFromProjectReference";
            FileIncludeKind2[FileIncludeKind2["Import"] = 3] = "Import";
            FileIncludeKind2[FileIncludeKind2["ReferenceFile"] = 4] = "ReferenceFile";
            FileIncludeKind2[FileIncludeKind2["TypeReferenceDirective"] = 5] = "TypeReferenceDirective";
            FileIncludeKind2[FileIncludeKind2["LibFile"] = 6] = "LibFile";
            FileIncludeKind2[FileIncludeKind2["LibReferenceDirective"] = 7] = "LibReferenceDirective";
            FileIncludeKind2[FileIncludeKind2["AutomaticTypeDirectiveFile"] = 8] = "AutomaticTypeDirectiveFile";
            return FileIncludeKind2;
          })(FileIncludeKind || {});
          FilePreprocessingDiagnosticsKind = ((FilePreprocessingDiagnosticsKind2) => {
            FilePreprocessingDiagnosticsKind2[FilePreprocessingDiagnosticsKind2["FilePreprocessingReferencedDiagnostic"] = 0] = "FilePreprocessingReferencedDiagnostic";
            FilePreprocessingDiagnosticsKind2[FilePreprocessingDiagnosticsKind2["FilePreprocessingFileExplainingDiagnostic"] = 1] = "FilePreprocessingFileExplainingDiagnostic";
            FilePreprocessingDiagnosticsKind2[FilePreprocessingDiagnosticsKind2["ResolutionDiagnostics"] = 2] = "ResolutionDiagnostics";
            return FilePreprocessingDiagnosticsKind2;
          })(FilePreprocessingDiagnosticsKind || {});
          EmitOnly = ((EmitOnly4) => {
            EmitOnly4[EmitOnly4["Js"] = 0] = "Js";
            EmitOnly4[EmitOnly4["Dts"] = 1] = "Dts";
            return EmitOnly4;
          })(EmitOnly || {});
          StructureIsReused = ((StructureIsReused2) => {
            StructureIsReused2[StructureIsReused2["Not"] = 0] = "Not";
            StructureIsReused2[StructureIsReused2["SafeModules"] = 1] = "SafeModules";
            StructureIsReused2[StructureIsReused2["Completely"] = 2] = "Completely";
            return StructureIsReused2;
          })(StructureIsReused || {});
          ExitStatus = ((ExitStatus2) => {
            ExitStatus2[ExitStatus2["Success"] = 0] = "Success";
            ExitStatus2[ExitStatus2["DiagnosticsPresent_OutputsSkipped"] = 1] = "DiagnosticsPresent_OutputsSkipped";
            ExitStatus2[ExitStatus2["DiagnosticsPresent_OutputsGenerated"] = 2] = "DiagnosticsPresent_OutputsGenerated";
            ExitStatus2[ExitStatus2["InvalidProject_OutputsSkipped"] = 3] = "InvalidProject_OutputsSkipped";
            ExitStatus2[ExitStatus2["ProjectReferenceCycle_OutputsSkipped"] = 4] = "ProjectReferenceCycle_OutputsSkipped";
            return ExitStatus2;
          })(ExitStatus || {});
          MemberOverrideStatus = ((MemberOverrideStatus2) => {
            MemberOverrideStatus2[MemberOverrideStatus2["Ok"] = 0] = "Ok";
            MemberOverrideStatus2[MemberOverrideStatus2["NeedsOverride"] = 1] = "NeedsOverride";
            MemberOverrideStatus2[MemberOverrideStatus2["HasInvalidOverride"] = 2] = "HasInvalidOverride";
            return MemberOverrideStatus2;
          })(MemberOverrideStatus || {});
          UnionReduction = ((UnionReduction2) => {
            UnionReduction2[UnionReduction2["None"] = 0] = "None";
            UnionReduction2[UnionReduction2["Literal"] = 1] = "Literal";
            UnionReduction2[UnionReduction2["Subtype"] = 2] = "Subtype";
            return UnionReduction2;
          })(UnionReduction || {});
          ContextFlags = ((ContextFlags3) => {
            ContextFlags3[ContextFlags3["None"] = 0] = "None";
            ContextFlags3[ContextFlags3["Signature"] = 1] = "Signature";
            ContextFlags3[ContextFlags3["NoConstraints"] = 2] = "NoConstraints";
            ContextFlags3[ContextFlags3["Completions"] = 4] = "Completions";
            ContextFlags3[ContextFlags3["SkipBindingPatterns"] = 8] = "SkipBindingPatterns";
            return ContextFlags3;
          })(ContextFlags || {});
          NodeBuilderFlags = ((NodeBuilderFlags2) => {
            NodeBuilderFlags2[NodeBuilderFlags2["None"] = 0] = "None";
            NodeBuilderFlags2[NodeBuilderFlags2["NoTruncation"] = 1] = "NoTruncation";
            NodeBuilderFlags2[NodeBuilderFlags2["WriteArrayAsGenericType"] = 2] = "WriteArrayAsGenericType";
            NodeBuilderFlags2[NodeBuilderFlags2["GenerateNamesForShadowedTypeParams"] = 4] = "GenerateNamesForShadowedTypeParams";
            NodeBuilderFlags2[NodeBuilderFlags2["UseStructuralFallback"] = 8] = "UseStructuralFallback";
            NodeBuilderFlags2[NodeBuilderFlags2["ForbidIndexedAccessSymbolReferences"] = 16] = "ForbidIndexedAccessSymbolReferences";
            NodeBuilderFlags2[NodeBuilderFlags2["WriteTypeArgumentsOfSignature"] = 32] = "WriteTypeArgumentsOfSignature";
            NodeBuilderFlags2[NodeBuilderFlags2["UseFullyQualifiedType"] = 64] = "UseFullyQualifiedType";
            NodeBuilderFlags2[NodeBuilderFlags2["UseOnlyExternalAliasing"] = 128] = "UseOnlyExternalAliasing";
            NodeBuilderFlags2[NodeBuilderFlags2["SuppressAnyReturnType"] = 256] = "SuppressAnyReturnType";
            NodeBuilderFlags2[NodeBuilderFlags2["WriteTypeParametersInQualifiedName"] = 512] = "WriteTypeParametersInQualifiedName";
            NodeBuilderFlags2[NodeBuilderFlags2["MultilineObjectLiterals"] = 1024] = "MultilineObjectLiterals";
            NodeBuilderFlags2[NodeBuilderFlags2["WriteClassExpressionAsTypeLiteral"] = 2048] = "WriteClassExpressionAsTypeLiteral";
            NodeBuilderFlags2[NodeBuilderFlags2["UseTypeOfFunction"] = 4096] = "UseTypeOfFunction";
            NodeBuilderFlags2[NodeBuilderFlags2["OmitParameterModifiers"] = 8192] = "OmitParameterModifiers";
            NodeBuilderFlags2[NodeBuilderFlags2["UseAliasDefinedOutsideCurrentScope"] = 16384] = "UseAliasDefinedOutsideCurrentScope";
            NodeBuilderFlags2[NodeBuilderFlags2["UseSingleQuotesForStringLiteralType"] = 268435456] = "UseSingleQuotesForStringLiteralType";
            NodeBuilderFlags2[NodeBuilderFlags2["NoTypeReduction"] = 536870912] = "NoTypeReduction";
            NodeBuilderFlags2[NodeBuilderFlags2["OmitThisParameter"] = 33554432] = "OmitThisParameter";
            NodeBuilderFlags2[NodeBuilderFlags2["AllowThisInObjectLiteral"] = 32768] = "AllowThisInObjectLiteral";
            NodeBuilderFlags2[NodeBuilderFlags2["AllowQualifiedNameInPlaceOfIdentifier"] = 65536] = "AllowQualifiedNameInPlaceOfIdentifier";
            NodeBuilderFlags2[NodeBuilderFlags2["AllowAnonymousIdentifier"] = 131072] = "AllowAnonymousIdentifier";
            NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyUnionOrIntersection"] = 262144] = "AllowEmptyUnionOrIntersection";
            NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyTuple"] = 524288] = "AllowEmptyTuple";
            NodeBuilderFlags2[NodeBuilderFlags2["AllowUniqueESSymbolType"] = 1048576] = "AllowUniqueESSymbolType";
            NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyIndexInfoType"] = 2097152] = "AllowEmptyIndexInfoType";
            NodeBuilderFlags2[NodeBuilderFlags2["WriteComputedProps"] = 1073741824] = "WriteComputedProps";
            NodeBuilderFlags2[NodeBuilderFlags2["AllowNodeModulesRelativePaths"] = 67108864] = "AllowNodeModulesRelativePaths";
            NodeBuilderFlags2[NodeBuilderFlags2["DoNotIncludeSymbolChain"] = 134217728] = "DoNotIncludeSymbolChain";
            NodeBuilderFlags2[NodeBuilderFlags2["IgnoreErrors"] = 70221824] = "IgnoreErrors";
            NodeBuilderFlags2[NodeBuilderFlags2["InObjectTypeLiteral"] = 4194304] = "InObjectTypeLiteral";
            NodeBuilderFlags2[NodeBuilderFlags2["InTypeAlias"] = 8388608] = "InTypeAlias";
            NodeBuilderFlags2[NodeBuilderFlags2["InInitialEntityName"] = 16777216] = "InInitialEntityName";
            return NodeBuilderFlags2;
          })(NodeBuilderFlags || {});
          TypeFormatFlags = ((TypeFormatFlags2) => {
            TypeFormatFlags2[TypeFormatFlags2["None"] = 0] = "None";
            TypeFormatFlags2[TypeFormatFlags2["NoTruncation"] = 1] = "NoTruncation";
            TypeFormatFlags2[TypeFormatFlags2["WriteArrayAsGenericType"] = 2] = "WriteArrayAsGenericType";
            TypeFormatFlags2[TypeFormatFlags2["UseStructuralFallback"] = 8] = "UseStructuralFallback";
            TypeFormatFlags2[TypeFormatFlags2["WriteTypeArgumentsOfSignature"] = 32] = "WriteTypeArgumentsOfSignature";
            TypeFormatFlags2[TypeFormatFlags2["UseFullyQualifiedType"] = 64] = "UseFullyQualifiedType";
            TypeFormatFlags2[TypeFormatFlags2["SuppressAnyReturnType"] = 256] = "SuppressAnyReturnType";
            TypeFormatFlags2[TypeFormatFlags2["MultilineObjectLiterals"] = 1024] = "MultilineObjectLiterals";
            TypeFormatFlags2[TypeFormatFlags2["WriteClassExpressionAsTypeLiteral"] = 2048] = "WriteClassExpressionAsTypeLiteral";
            TypeFormatFlags2[TypeFormatFlags2["UseTypeOfFunction"] = 4096] = "UseTypeOfFunction";
            TypeFormatFlags2[TypeFormatFlags2["OmitParameterModifiers"] = 8192] = "OmitParameterModifiers";
            TypeFormatFlags2[TypeFormatFlags2["UseAliasDefinedOutsideCurrentScope"] = 16384] = "UseAliasDefinedOutsideCurrentScope";
            TypeFormatFlags2[TypeFormatFlags2["UseSingleQuotesForStringLiteralType"] = 268435456] = "UseSingleQuotesForStringLiteralType";
            TypeFormatFlags2[TypeFormatFlags2["NoTypeReduction"] = 536870912] = "NoTypeReduction";
            TypeFormatFlags2[TypeFormatFlags2["OmitThisParameter"] = 33554432] = "OmitThisParameter";
            TypeFormatFlags2[TypeFormatFlags2["AllowUniqueESSymbolType"] = 1048576] = "AllowUniqueESSymbolType";
            TypeFormatFlags2[TypeFormatFlags2["AddUndefined"] = 131072] = "AddUndefined";
            TypeFormatFlags2[TypeFormatFlags2["WriteArrowStyleSignature"] = 262144] = "WriteArrowStyleSignature";
            TypeFormatFlags2[TypeFormatFlags2["InArrayType"] = 524288] = "InArrayType";
            TypeFormatFlags2[TypeFormatFlags2["InElementType"] = 2097152] = "InElementType";
            TypeFormatFlags2[TypeFormatFlags2["InFirstTypeArgument"] = 4194304] = "InFirstTypeArgument";
            TypeFormatFlags2[TypeFormatFlags2["InTypeAlias"] = 8388608] = "InTypeAlias";
            TypeFormatFlags2[TypeFormatFlags2["NodeBuilderFlagsMask"] = 848330091] = "NodeBuilderFlagsMask";
            return TypeFormatFlags2;
          })(TypeFormatFlags || {});
          SymbolFormatFlags = ((SymbolFormatFlags2) => {
            SymbolFormatFlags2[SymbolFormatFlags2["None"] = 0] = "None";
            SymbolFormatFlags2[SymbolFormatFlags2["WriteTypeParametersOrArguments"] = 1] = "WriteTypeParametersOrArguments";
            SymbolFormatFlags2[SymbolFormatFlags2["UseOnlyExternalAliasing"] = 2] = "UseOnlyExternalAliasing";
            SymbolFormatFlags2[SymbolFormatFlags2["AllowAnyNodeKind"] = 4] = "AllowAnyNodeKind";
            SymbolFormatFlags2[SymbolFormatFlags2["UseAliasDefinedOutsideCurrentScope"] = 8] = "UseAliasDefinedOutsideCurrentScope";
            SymbolFormatFlags2[SymbolFormatFlags2["WriteComputedProps"] = 16] = "WriteComputedProps";
            SymbolFormatFlags2[SymbolFormatFlags2["DoNotIncludeSymbolChain"] = 32] = "DoNotIncludeSymbolChain";
            return SymbolFormatFlags2;
          })(SymbolFormatFlags || {});
          SymbolAccessibility = ((SymbolAccessibility2) => {
            SymbolAccessibility2[SymbolAccessibility2["Accessible"] = 0] = "Accessible";
            SymbolAccessibility2[SymbolAccessibility2["NotAccessible"] = 1] = "NotAccessible";
            SymbolAccessibility2[SymbolAccessibility2["CannotBeNamed"] = 2] = "CannotBeNamed";
            return SymbolAccessibility2;
          })(SymbolAccessibility || {});
          SyntheticSymbolKind = ((SyntheticSymbolKind2) => {
            SyntheticSymbolKind2[SyntheticSymbolKind2["UnionOrIntersection"] = 0] = "UnionOrIntersection";
            SyntheticSymbolKind2[SyntheticSymbolKind2["Spread"] = 1] = "Spread";
            return SyntheticSymbolKind2;
          })(SyntheticSymbolKind || {});
          TypePredicateKind = ((TypePredicateKind2) => {
            TypePredicateKind2[TypePredicateKind2["This"] = 0] = "This";
            TypePredicateKind2[TypePredicateKind2["Identifier"] = 1] = "Identifier";
            TypePredicateKind2[TypePredicateKind2["AssertsThis"] = 2] = "AssertsThis";
            TypePredicateKind2[TypePredicateKind2["AssertsIdentifier"] = 3] = "AssertsIdentifier";
            return TypePredicateKind2;
          })(TypePredicateKind || {});
          TypeReferenceSerializationKind = ((TypeReferenceSerializationKind2) => {
            TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["Unknown"] = 0] = "Unknown";
            TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["TypeWithConstructSignatureAndValue"] = 1] = "TypeWithConstructSignatureAndValue";
            TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["VoidNullableOrNeverType"] = 2] = "VoidNullableOrNeverType";
            TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["NumberLikeType"] = 3] = "NumberLikeType";
            TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["BigIntLikeType"] = 4] = "BigIntLikeType";
            TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["StringLikeType"] = 5] = "StringLikeType";
            TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["BooleanType"] = 6] = "BooleanType";
            TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ArrayLikeType"] = 7] = "ArrayLikeType";
            TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ESSymbolType"] = 8] = "ESSymbolType";
            TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["Promise"] = 9] = "Promise";
            TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["TypeWithCallSignature"] = 10] = "TypeWithCallSignature";
            TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ObjectType"] = 11] = "ObjectType";
            return TypeReferenceSerializationKind2;
          })(TypeReferenceSerializationKind || {});
          SymbolFlags = ((SymbolFlags3) => {
            SymbolFlags3[SymbolFlags3["None"] = 0] = "None";
            SymbolFlags3[SymbolFlags3["FunctionScopedVariable"] = 1] = "FunctionScopedVariable";
            SymbolFlags3[SymbolFlags3["BlockScopedVariable"] = 2] = "BlockScopedVariable";
            SymbolFlags3[SymbolFlags3["Property"] = 4] = "Property";
            SymbolFlags3[SymbolFlags3["EnumMember"] = 8] = "EnumMember";
            SymbolFlags3[SymbolFlags3["Function"] = 16] = "Function";
            SymbolFlags3[SymbolFlags3["Class"] = 32] = "Class";
            SymbolFlags3[SymbolFlags3["Interface"] = 64] = "Interface";
            SymbolFlags3[SymbolFlags3["ConstEnum"] = 128] = "ConstEnum";
            SymbolFlags3[SymbolFlags3["RegularEnum"] = 256] = "RegularEnum";
            SymbolFlags3[SymbolFlags3["ValueModule"] = 512] = "ValueModule";
            SymbolFlags3[SymbolFlags3["NamespaceModule"] = 1024] = "NamespaceModule";
            SymbolFlags3[SymbolFlags3["TypeLiteral"] = 2048] = "TypeLiteral";
            SymbolFlags3[SymbolFlags3["ObjectLiteral"] = 4096] = "ObjectLiteral";
            SymbolFlags3[SymbolFlags3["Method"] = 8192] = "Method";
            SymbolFlags3[SymbolFlags3["Constructor"] = 16384] = "Constructor";
            SymbolFlags3[SymbolFlags3["GetAccessor"] = 32768] = "GetAccessor";
            SymbolFlags3[SymbolFlags3["SetAccessor"] = 65536] = "SetAccessor";
            SymbolFlags3[SymbolFlags3["Signature"] = 131072] = "Signature";
            SymbolFlags3[SymbolFlags3["TypeParameter"] = 262144] = "TypeParameter";
            SymbolFlags3[SymbolFlags3["TypeAlias"] = 524288] = "TypeAlias";
            SymbolFlags3[SymbolFlags3["ExportValue"] = 1048576] = "ExportValue";
            SymbolFlags3[SymbolFlags3["Alias"] = 2097152] = "Alias";
            SymbolFlags3[SymbolFlags3["Prototype"] = 4194304] = "Prototype";
            SymbolFlags3[SymbolFlags3["ExportStar"] = 8388608] = "ExportStar";
            SymbolFlags3[SymbolFlags3["Optional"] = 16777216] = "Optional";
            SymbolFlags3[SymbolFlags3["Transient"] = 33554432] = "Transient";
            SymbolFlags3[SymbolFlags3["Assignment"] = 67108864] = "Assignment";
            SymbolFlags3[SymbolFlags3["ModuleExports"] = 134217728] = "ModuleExports";
            SymbolFlags3[SymbolFlags3["All"] = 67108863] = "All";
            SymbolFlags3[SymbolFlags3["Enum"] = 384] = "Enum";
            SymbolFlags3[SymbolFlags3["Variable"] = 3] = "Variable";
            SymbolFlags3[SymbolFlags3["Value"] = 111551] = "Value";
            SymbolFlags3[SymbolFlags3["Type"] = 788968] = "Type";
            SymbolFlags3[SymbolFlags3["Namespace"] = 1920] = "Namespace";
            SymbolFlags3[SymbolFlags3["Module"] = 1536] = "Module";
            SymbolFlags3[SymbolFlags3["Accessor"] = 98304] = "Accessor";
            SymbolFlags3[SymbolFlags3["FunctionScopedVariableExcludes"] = 111550] = "FunctionScopedVariableExcludes";
            SymbolFlags3[
              SymbolFlags3["BlockScopedVariableExcludes"] = 111551
              /* Value */
            ] = "BlockScopedVariableExcludes";
            SymbolFlags3[
              SymbolFlags3["ParameterExcludes"] = 111551
              /* Value */
            ] = "ParameterExcludes";
            SymbolFlags3[
              SymbolFlags3["PropertyExcludes"] = 0
              /* None */
            ] = "PropertyExcludes";
            SymbolFlags3[SymbolFlags3["EnumMemberExcludes"] = 900095] = "EnumMemberExcludes";
            SymbolFlags3[SymbolFlags3["FunctionExcludes"] = 110991] = "FunctionExcludes";
            SymbolFlags3[SymbolFlags3["ClassExcludes"] = 899503] = "ClassExcludes";
            SymbolFlags3[SymbolFlags3["InterfaceExcludes"] = 788872] = "InterfaceExcludes";
            SymbolFlags3[SymbolFlags3["RegularEnumExcludes"] = 899327] = "RegularEnumExcludes";
            SymbolFlags3[SymbolFlags3["ConstEnumExcludes"] = 899967] = "ConstEnumExcludes";
            SymbolFlags3[SymbolFlags3["ValueModuleExcludes"] = 110735] = "ValueModuleExcludes";
            SymbolFlags3[SymbolFlags3["NamespaceModuleExcludes"] = 0] = "NamespaceModuleExcludes";
            SymbolFlags3[SymbolFlags3["MethodExcludes"] = 103359] = "MethodExcludes";
            SymbolFlags3[SymbolFlags3["GetAccessorExcludes"] = 46015] = "GetAccessorExcludes";
            SymbolFlags3[SymbolFlags3["SetAccessorExcludes"] = 78783] = "SetAccessorExcludes";
            SymbolFlags3[SymbolFlags3["AccessorExcludes"] = 13247] = "AccessorExcludes";
            SymbolFlags3[SymbolFlags3["TypeParameterExcludes"] = 526824] = "TypeParameterExcludes";
            SymbolFlags3[
              SymbolFlags3["TypeAliasExcludes"] = 788968
              /* Type */
            ] = "TypeAliasExcludes";
            SymbolFlags3[
              SymbolFlags3["AliasExcludes"] = 2097152
              /* Alias */
            ] = "AliasExcludes";
            SymbolFlags3[SymbolFlags3["ModuleMember"] = 2623475] = "ModuleMember";
            SymbolFlags3[SymbolFlags3["ExportHasLocal"] = 944] = "ExportHasLocal";
            SymbolFlags3[SymbolFlags3["BlockScoped"] = 418] = "BlockScoped";
            SymbolFlags3[SymbolFlags3["PropertyOrAccessor"] = 98308] = "PropertyOrAccessor";
            SymbolFlags3[SymbolFlags3["ClassMember"] = 106500] = "ClassMember";
            SymbolFlags3[SymbolFlags3["ExportSupportsDefaultModifier"] = 112] = "ExportSupportsDefaultModifier";
            SymbolFlags3[SymbolFlags3["ExportDoesNotSupportDefaultModifier"] = -113] = "ExportDoesNotSupportDefaultModifier";
            SymbolFlags3[SymbolFlags3["Classifiable"] = 2885600] = "Classifiable";
            SymbolFlags3[SymbolFlags3["LateBindingContainer"] = 6256] = "LateBindingContainer";
            return SymbolFlags3;
          })(SymbolFlags || {});
          EnumKind = ((EnumKind2) => {
            EnumKind2[EnumKind2["Numeric"] = 0] = "Numeric";
            EnumKind2[EnumKind2["Literal"] = 1] = "Literal";
            return EnumKind2;
          })(EnumKind || {});
          CheckFlags = ((CheckFlags2) => {
            CheckFlags2[CheckFlags2["None"] = 0] = "None";
            CheckFlags2[CheckFlags2["Instantiated"] = 1] = "Instantiated";
            CheckFlags2[CheckFlags2["SyntheticProperty"] = 2] = "SyntheticProperty";
            CheckFlags2[CheckFlags2["SyntheticMethod"] = 4] = "SyntheticMethod";
            CheckFlags2[CheckFlags2["Readonly"] = 8] = "Readonly";
            CheckFlags2[CheckFlags2["ReadPartial"] = 16] = "ReadPartial";
            CheckFlags2[CheckFlags2["WritePartial"] = 32] = "WritePartial";
            CheckFlags2[CheckFlags2["HasNonUniformType"] = 64] = "HasNonUniformType";
            CheckFlags2[CheckFlags2["HasLiteralType"] = 128] = "HasLiteralType";
            CheckFlags2[CheckFlags2["ContainsPublic"] = 256] = "ContainsPublic";
            CheckFlags2[CheckFlags2["ContainsProtected"] = 512] = "ContainsProtected";
            CheckFlags2[CheckFlags2["ContainsPrivate"] = 1024] = "ContainsPrivate";
            CheckFlags2[CheckFlags2["ContainsStatic"] = 2048] = "ContainsStatic";
            CheckFlags2[CheckFlags2["Late"] = 4096] = "Late";
            CheckFlags2[CheckFlags2["ReverseMapped"] = 8192] = "ReverseMapped";
            CheckFlags2[CheckFlags2["OptionalParameter"] = 16384] = "OptionalParameter";
            CheckFlags2[CheckFlags2["RestParameter"] = 32768] = "RestParameter";
            CheckFlags2[CheckFlags2["DeferredType"] = 65536] = "DeferredType";
            CheckFlags2[CheckFlags2["HasNeverType"] = 131072] = "HasNeverType";
            CheckFlags2[CheckFlags2["Mapped"] = 262144] = "Mapped";
            CheckFlags2[CheckFlags2["StripOptional"] = 524288] = "StripOptional";
            CheckFlags2[CheckFlags2["Unresolved"] = 1048576] = "Unresolved";
            CheckFlags2[CheckFlags2["Synthetic"] = 6] = "Synthetic";
            CheckFlags2[CheckFlags2["Discriminant"] = 192] = "Discriminant";
            CheckFlags2[CheckFlags2["Partial"] = 48] = "Partial";
            return CheckFlags2;
          })(CheckFlags || {});
          InternalSymbolName = ((InternalSymbolName2) => {
            InternalSymbolName2["Call"] = "__call";
            InternalSymbolName2["Constructor"] = "__constructor";
            InternalSymbolName2["New"] = "__new";
            InternalSymbolName2["Index"] = "__index";
            InternalSymbolName2["ExportStar"] = "__export";
            InternalSymbolName2["Global"] = "__global";
            InternalSymbolName2["Missing"] = "__missing";
            InternalSymbolName2["Type"] = "__type";
            InternalSymbolName2["Object"] = "__object";
            InternalSymbolName2["JSXAttributes"] = "__jsxAttributes";
            InternalSymbolName2["Class"] = "__class";
            InternalSymbolName2["Function"] = "__function";
            InternalSymbolName2["Computed"] = "__computed";
            InternalSymbolName2["Resolving"] = "__resolving__";
            InternalSymbolName2["ExportEquals"] = "export=";
            InternalSymbolName2["Default"] = "default";
            InternalSymbolName2["This"] = "this";
            return InternalSymbolName2;
          })(InternalSymbolName || {});
          NodeCheckFlags = ((NodeCheckFlags2) => {
            NodeCheckFlags2[NodeCheckFlags2["None"] = 0] = "None";
            NodeCheckFlags2[NodeCheckFlags2["TypeChecked"] = 1] = "TypeChecked";
            NodeCheckFlags2[NodeCheckFlags2["LexicalThis"] = 2] = "LexicalThis";
            NodeCheckFlags2[NodeCheckFlags2["CaptureThis"] = 4] = "CaptureThis";
            NodeCheckFlags2[NodeCheckFlags2["CaptureNewTarget"] = 8] = "CaptureNewTarget";
            NodeCheckFlags2[NodeCheckFlags2["SuperInstance"] = 16] = "SuperInstance";
            NodeCheckFlags2[NodeCheckFlags2["SuperStatic"] = 32] = "SuperStatic";
            NodeCheckFlags2[NodeCheckFlags2["ContextChecked"] = 64] = "ContextChecked";
            NodeCheckFlags2[NodeCheckFlags2["MethodWithSuperPropertyAccessInAsync"] = 128] = "MethodWithSuperPropertyAccessInAsync";
            NodeCheckFlags2[NodeCheckFlags2["MethodWithSuperPropertyAssignmentInAsync"] = 256] = "MethodWithSuperPropertyAssignmentInAsync";
            NodeCheckFlags2[NodeCheckFlags2["CaptureArguments"] = 512] = "CaptureArguments";
            NodeCheckFlags2[NodeCheckFlags2["EnumValuesComputed"] = 1024] = "EnumValuesComputed";
            NodeCheckFlags2[NodeCheckFlags2["LexicalModuleMergesWithClass"] = 2048] = "LexicalModuleMergesWithClass";
            NodeCheckFlags2[NodeCheckFlags2["LoopWithCapturedBlockScopedBinding"] = 4096] = "LoopWithCapturedBlockScopedBinding";
            NodeCheckFlags2[NodeCheckFlags2["ContainsCapturedBlockScopeBinding"] = 8192] = "ContainsCapturedBlockScopeBinding";
            NodeCheckFlags2[NodeCheckFlags2["CapturedBlockScopedBinding"] = 16384] = "CapturedBlockScopedBinding";
            NodeCheckFlags2[NodeCheckFlags2["BlockScopedBindingInLoop"] = 32768] = "BlockScopedBindingInLoop";
            NodeCheckFlags2[NodeCheckFlags2["NeedsLoopOutParameter"] = 65536] = "NeedsLoopOutParameter";
            NodeCheckFlags2[NodeCheckFlags2["AssignmentsMarked"] = 131072] = "AssignmentsMarked";
            NodeCheckFlags2[NodeCheckFlags2["ContainsConstructorReference"] = 262144] = "ContainsConstructorReference";
            NodeCheckFlags2[NodeCheckFlags2["ConstructorReference"] = 536870912] = "ConstructorReference";
            NodeCheckFlags2[NodeCheckFlags2["ContainsClassWithPrivateIdentifiers"] = 1048576] = "ContainsClassWithPrivateIdentifiers";
            NodeCheckFlags2[NodeCheckFlags2["ContainsSuperPropertyInStaticInitializer"] = 2097152] = "ContainsSuperPropertyInStaticInitializer";
            NodeCheckFlags2[NodeCheckFlags2["InCheckIdentifier"] = 4194304] = "InCheckIdentifier";
            return NodeCheckFlags2;
          })(NodeCheckFlags || {});
          TypeFlags = ((TypeFlags2) => {
            TypeFlags2[TypeFlags2["Any"] = 1] = "Any";
            TypeFlags2[TypeFlags2["Unknown"] = 2] = "Unknown";
            TypeFlags2[TypeFlags2["String"] = 4] = "String";
            TypeFlags2[TypeFlags2["Number"] = 8] = "Number";
            TypeFlags2[TypeFlags2["Boolean"] = 16] = "Boolean";
            TypeFlags2[TypeFlags2["Enum"] = 32] = "Enum";
            TypeFlags2[TypeFlags2["BigInt"] = 64] = "BigInt";
            TypeFlags2[TypeFlags2["StringLiteral"] = 128] = "StringLiteral";
            TypeFlags2[TypeFlags2["NumberLiteral"] = 256] = "NumberLiteral";
            TypeFlags2[TypeFlags2["BooleanLiteral"] = 512] = "BooleanLiteral";
            TypeFlags2[TypeFlags2["EnumLiteral"] = 1024] = "EnumLiteral";
            TypeFlags2[TypeFlags2["BigIntLiteral"] = 2048] = "BigIntLiteral";
            TypeFlags2[TypeFlags2["ESSymbol"] = 4096] = "ESSymbol";
            TypeFlags2[TypeFlags2["UniqueESSymbol"] = 8192] = "UniqueESSymbol";
            TypeFlags2[TypeFlags2["Void"] = 16384] = "Void";
            TypeFlags2[TypeFlags2["Undefined"] = 32768] = "Undefined";
            TypeFlags2[TypeFlags2["Null"] = 65536] = "Null";
            TypeFlags2[TypeFlags2["Never"] = 131072] = "Never";
            TypeFlags2[TypeFlags2["TypeParameter"] = 262144] = "TypeParameter";
            TypeFlags2[TypeFlags2["Object"] = 524288] = "Object";
            TypeFlags2[TypeFlags2["Union"] = 1048576] = "Union";
            TypeFlags2[TypeFlags2["Intersection"] = 2097152] = "Intersection";
            TypeFlags2[TypeFlags2["Index"] = 4194304] = "Index";
            TypeFlags2[TypeFlags2["IndexedAccess"] = 8388608] = "IndexedAccess";
            TypeFlags2[TypeFlags2["Conditional"] = 16777216] = "Conditional";
            TypeFlags2[TypeFlags2["Substitution"] = 33554432] = "Substitution";
            TypeFlags2[TypeFlags2["NonPrimitive"] = 67108864] = "NonPrimitive";
            TypeFlags2[TypeFlags2["TemplateLiteral"] = 134217728] = "TemplateLiteral";
            TypeFlags2[TypeFlags2["StringMapping"] = 268435456] = "StringMapping";
            TypeFlags2[TypeFlags2["AnyOrUnknown"] = 3] = "AnyOrUnknown";
            TypeFlags2[TypeFlags2["Nullable"] = 98304] = "Nullable";
            TypeFlags2[TypeFlags2["Literal"] = 2944] = "Literal";
            TypeFlags2[TypeFlags2["Unit"] = 109472] = "Unit";
            TypeFlags2[TypeFlags2["Freshable"] = 2976] = "Freshable";
            TypeFlags2[TypeFlags2["StringOrNumberLiteral"] = 384] = "StringOrNumberLiteral";
            TypeFlags2[TypeFlags2["StringOrNumberLiteralOrUnique"] = 8576] = "StringOrNumberLiteralOrUnique";
            TypeFlags2[TypeFlags2["DefinitelyFalsy"] = 117632] = "DefinitelyFalsy";
            TypeFlags2[TypeFlags2["PossiblyFalsy"] = 117724] = "PossiblyFalsy";
            TypeFlags2[TypeFlags2["Intrinsic"] = 67359327] = "Intrinsic";
            TypeFlags2[TypeFlags2["StringLike"] = 402653316] = "StringLike";
            TypeFlags2[TypeFlags2["NumberLike"] = 296] = "NumberLike";
            TypeFlags2[TypeFlags2["BigIntLike"] = 2112] = "BigIntLike";
            TypeFlags2[TypeFlags2["BooleanLike"] = 528] = "BooleanLike";
            TypeFlags2[TypeFlags2["EnumLike"] = 1056] = "EnumLike";
            TypeFlags2[TypeFlags2["ESSymbolLike"] = 12288] = "ESSymbolLike";
            TypeFlags2[TypeFlags2["VoidLike"] = 49152] = "VoidLike";
            TypeFlags2[TypeFlags2["Primitive"] = 402784252] = "Primitive";
            TypeFlags2[TypeFlags2["DefinitelyNonNullable"] = 470302716] = "DefinitelyNonNullable";
            TypeFlags2[TypeFlags2["DisjointDomains"] = 469892092] = "DisjointDomains";
            TypeFlags2[TypeFlags2["UnionOrIntersection"] = 3145728] = "UnionOrIntersection";
            TypeFlags2[TypeFlags2["StructuredType"] = 3670016] = "StructuredType";
            TypeFlags2[TypeFlags2["TypeVariable"] = 8650752] = "TypeVariable";
            TypeFlags2[TypeFlags2["InstantiableNonPrimitive"] = 58982400] = "InstantiableNonPrimitive";
            TypeFlags2[TypeFlags2["InstantiablePrimitive"] = 406847488] = "InstantiablePrimitive";
            TypeFlags2[TypeFlags2["Instantiable"] = 465829888] = "Instantiable";
            TypeFlags2[TypeFlags2["StructuredOrInstantiable"] = 469499904] = "StructuredOrInstantiable";
            TypeFlags2[TypeFlags2["ObjectFlagsType"] = 138117121] = "ObjectFlagsType";
            TypeFlags2[TypeFlags2["Simplifiable"] = 25165824] = "Simplifiable";
            TypeFlags2[TypeFlags2["Singleton"] = 67358815] = "Singleton";
            TypeFlags2[TypeFlags2["Narrowable"] = 536624127] = "Narrowable";
            TypeFlags2[TypeFlags2["IncludesMask"] = 473694207] = "IncludesMask";
            TypeFlags2[
              TypeFlags2["IncludesMissingType"] = 262144
              /* TypeParameter */
            ] = "IncludesMissingType";
            TypeFlags2[
              TypeFlags2["IncludesNonWideningType"] = 4194304
              /* Index */
            ] = "IncludesNonWideningType";
            TypeFlags2[
              TypeFlags2["IncludesWildcard"] = 8388608
              /* IndexedAccess */
            ] = "IncludesWildcard";
            TypeFlags2[
              TypeFlags2["IncludesEmptyObject"] = 16777216
              /* Conditional */
            ] = "IncludesEmptyObject";
            TypeFlags2[
              TypeFlags2["IncludesInstantiable"] = 33554432
              /* Substitution */
            ] = "IncludesInstantiable";
            TypeFlags2[TypeFlags2["NotPrimitiveUnion"] = 36323331] = "NotPrimitiveUnion";
            return TypeFlags2;
          })(TypeFlags || {});
          ObjectFlags = ((ObjectFlags3) => {
            ObjectFlags3[ObjectFlags3["None"] = 0] = "None";
            ObjectFlags3[ObjectFlags3["Class"] = 1] = "Class";
            ObjectFlags3[ObjectFlags3["Interface"] = 2] = "Interface";
            ObjectFlags3[ObjectFlags3["Reference"] = 4] = "Reference";
            ObjectFlags3[ObjectFlags3["Tuple"] = 8] = "Tuple";
            ObjectFlags3[ObjectFlags3["Anonymous"] = 16] = "Anonymous";
            ObjectFlags3[ObjectFlags3["Mapped"] = 32] = "Mapped";
            ObjectFlags3[ObjectFlags3["Instantiated"] = 64] = "Instantiated";
            ObjectFlags3[ObjectFlags3["ObjectLiteral"] = 128] = "ObjectLiteral";
            ObjectFlags3[ObjectFlags3["EvolvingArray"] = 256] = "EvolvingArray";
            ObjectFlags3[ObjectFlags3["ObjectLiteralPatternWithComputedProperties"] = 512] = "ObjectLiteralPatternWithComputedProperties";
            ObjectFlags3[ObjectFlags3["ReverseMapped"] = 1024] = "ReverseMapped";
            ObjectFlags3[ObjectFlags3["JsxAttributes"] = 2048] = "JsxAttributes";
            ObjectFlags3[ObjectFlags3["JSLiteral"] = 4096] = "JSLiteral";
            ObjectFlags3[ObjectFlags3["FreshLiteral"] = 8192] = "FreshLiteral";
            ObjectFlags3[ObjectFlags3["ArrayLiteral"] = 16384] = "ArrayLiteral";
            ObjectFlags3[ObjectFlags3["PrimitiveUnion"] = 32768] = "PrimitiveUnion";
            ObjectFlags3[ObjectFlags3["ContainsWideningType"] = 65536] = "ContainsWideningType";
            ObjectFlags3[ObjectFlags3["ContainsObjectOrArrayLiteral"] = 131072] = "ContainsObjectOrArrayLiteral";
            ObjectFlags3[ObjectFlags3["NonInferrableType"] = 262144] = "NonInferrableType";
            ObjectFlags3[ObjectFlags3["CouldContainTypeVariablesComputed"] = 524288] = "CouldContainTypeVariablesComputed";
            ObjectFlags3[ObjectFlags3["CouldContainTypeVariables"] = 1048576] = "CouldContainTypeVariables";
            ObjectFlags3[ObjectFlags3["ClassOrInterface"] = 3] = "ClassOrInterface";
            ObjectFlags3[ObjectFlags3["RequiresWidening"] = 196608] = "RequiresWidening";
            ObjectFlags3[ObjectFlags3["PropagatingFlags"] = 458752] = "PropagatingFlags";
            ObjectFlags3[ObjectFlags3["InstantiatedMapped"] = 96] = "InstantiatedMapped";
            ObjectFlags3[ObjectFlags3["ObjectTypeKindMask"] = 1343] = "ObjectTypeKindMask";
            ObjectFlags3[ObjectFlags3["ContainsSpread"] = 2097152] = "ContainsSpread";
            ObjectFlags3[ObjectFlags3["ObjectRestType"] = 4194304] = "ObjectRestType";
            ObjectFlags3[ObjectFlags3["InstantiationExpressionType"] = 8388608] = "InstantiationExpressionType";
            ObjectFlags3[ObjectFlags3["IsClassInstanceClone"] = 16777216] = "IsClassInstanceClone";
            ObjectFlags3[ObjectFlags3["IdenticalBaseTypeCalculated"] = 33554432] = "IdenticalBaseTypeCalculated";
            ObjectFlags3[ObjectFlags3["IdenticalBaseTypeExists"] = 67108864] = "IdenticalBaseTypeExists";
            ObjectFlags3[ObjectFlags3["IsGenericTypeComputed"] = 2097152] = "IsGenericTypeComputed";
            ObjectFlags3[ObjectFlags3["IsGenericObjectType"] = 4194304] = "IsGenericObjectType";
            ObjectFlags3[ObjectFlags3["IsGenericIndexType"] = 8388608] = "IsGenericIndexType";
            ObjectFlags3[ObjectFlags3["IsGenericType"] = 12582912] = "IsGenericType";
            ObjectFlags3[ObjectFlags3["ContainsIntersections"] = 16777216] = "ContainsIntersections";
            ObjectFlags3[ObjectFlags3["IsUnknownLikeUnionComputed"] = 33554432] = "IsUnknownLikeUnionComputed";
            ObjectFlags3[ObjectFlags3["IsUnknownLikeUnion"] = 67108864] = "IsUnknownLikeUnion";
            ObjectFlags3[ObjectFlags3["IsNeverIntersectionComputed"] = 16777216] = "IsNeverIntersectionComputed";
            ObjectFlags3[ObjectFlags3["IsNeverIntersection"] = 33554432] = "IsNeverIntersection";
            return ObjectFlags3;
          })(ObjectFlags || {});
          VarianceFlags = ((VarianceFlags2) => {
            VarianceFlags2[VarianceFlags2["Invariant"] = 0] = "Invariant";
            VarianceFlags2[VarianceFlags2["Covariant"] = 1] = "Covariant";
            VarianceFlags2[VarianceFlags2["Contravariant"] = 2] = "Contravariant";
            VarianceFlags2[VarianceFlags2["Bivariant"] = 3] = "Bivariant";
            VarianceFlags2[VarianceFlags2["Independent"] = 4] = "Independent";
            VarianceFlags2[VarianceFlags2["VarianceMask"] = 7] = "VarianceMask";
            VarianceFlags2[VarianceFlags2["Unmeasurable"] = 8] = "Unmeasurable";
            VarianceFlags2[VarianceFlags2["Unreliable"] = 16] = "Unreliable";
            VarianceFlags2[VarianceFlags2["AllowsStructuralFallback"] = 24] = "AllowsStructuralFallback";
            return VarianceFlags2;
          })(VarianceFlags || {});
          ElementFlags = ((ElementFlags2) => {
            ElementFlags2[ElementFlags2["Required"] = 1] = "Required";
            ElementFlags2[ElementFlags2["Optional"] = 2] = "Optional";
            ElementFlags2[ElementFlags2["Rest"] = 4] = "Rest";
            ElementFlags2[ElementFlags2["Variadic"] = 8] = "Variadic";
            ElementFlags2[ElementFlags2["Fixed"] = 3] = "Fixed";
            ElementFlags2[ElementFlags2["Variable"] = 12] = "Variable";
            ElementFlags2[ElementFlags2["NonRequired"] = 14] = "NonRequired";
            ElementFlags2[ElementFlags2["NonRest"] = 11] = "NonRest";
            return ElementFlags2;
          })(ElementFlags || {});
          AccessFlags = ((AccessFlags2) => {
            AccessFlags2[AccessFlags2["None"] = 0] = "None";
            AccessFlags2[AccessFlags2["IncludeUndefined"] = 1] = "IncludeUndefined";
            AccessFlags2[AccessFlags2["NoIndexSignatures"] = 2] = "NoIndexSignatures";
            AccessFlags2[AccessFlags2["Writing"] = 4] = "Writing";
            AccessFlags2[AccessFlags2["CacheSymbol"] = 8] = "CacheSymbol";
            AccessFlags2[AccessFlags2["NoTupleBoundsCheck"] = 16] = "NoTupleBoundsCheck";
            AccessFlags2[AccessFlags2["ExpressionPosition"] = 32] = "ExpressionPosition";
            AccessFlags2[AccessFlags2["ReportDeprecated"] = 64] = "ReportDeprecated";
            AccessFlags2[AccessFlags2["SuppressNoImplicitAnyError"] = 128] = "SuppressNoImplicitAnyError";
            AccessFlags2[AccessFlags2["Contextual"] = 256] = "Contextual";
            AccessFlags2[
              AccessFlags2["Persistent"] = 1
              /* IncludeUndefined */
            ] = "Persistent";
            return AccessFlags2;
          })(AccessFlags || {});
          IndexFlags = ((IndexFlags2) => {
            IndexFlags2[IndexFlags2["None"] = 0] = "None";
            IndexFlags2[IndexFlags2["StringsOnly"] = 1] = "StringsOnly";
            IndexFlags2[IndexFlags2["NoIndexSignatures"] = 2] = "NoIndexSignatures";
            IndexFlags2[IndexFlags2["NoReducibleCheck"] = 4] = "NoReducibleCheck";
            return IndexFlags2;
          })(IndexFlags || {});
          JsxReferenceKind = ((JsxReferenceKind2) => {
            JsxReferenceKind2[JsxReferenceKind2["Component"] = 0] = "Component";
            JsxReferenceKind2[JsxReferenceKind2["Function"] = 1] = "Function";
            JsxReferenceKind2[JsxReferenceKind2["Mixed"] = 2] = "Mixed";
            return JsxReferenceKind2;
          })(JsxReferenceKind || {});
          SignatureKind = ((SignatureKind2) => {
            SignatureKind2[SignatureKind2["Call"] = 0] = "Call";
            SignatureKind2[SignatureKind2["Construct"] = 1] = "Construct";
            return SignatureKind2;
          })(SignatureKind || {});
          SignatureFlags = ((SignatureFlags5) => {
            SignatureFlags5[SignatureFlags5["None"] = 0] = "None";
            SignatureFlags5[SignatureFlags5["HasRestParameter"] = 1] = "HasRestParameter";
            SignatureFlags5[SignatureFlags5["HasLiteralTypes"] = 2] = "HasLiteralTypes";
            SignatureFlags5[SignatureFlags5["Abstract"] = 4] = "Abstract";
            SignatureFlags5[SignatureFlags5["IsInnerCallChain"] = 8] = "IsInnerCallChain";
            SignatureFlags5[SignatureFlags5["IsOuterCallChain"] = 16] = "IsOuterCallChain";
            SignatureFlags5[SignatureFlags5["IsUntypedSignatureInJSFile"] = 32] = "IsUntypedSignatureInJSFile";
            SignatureFlags5[SignatureFlags5["IsNonInferrable"] = 64] = "IsNonInferrable";
            SignatureFlags5[SignatureFlags5["IsSignatureCandidateForOverloadFailure"] = 128] = "IsSignatureCandidateForOverloadFailure";
            SignatureFlags5[SignatureFlags5["PropagatingFlags"] = 167] = "PropagatingFlags";
            SignatureFlags5[SignatureFlags5["CallChainFlags"] = 24] = "CallChainFlags";
            return SignatureFlags5;
          })(SignatureFlags || {});
          IndexKind = ((IndexKind2) => {
            IndexKind2[IndexKind2["String"] = 0] = "String";
            IndexKind2[IndexKind2["Number"] = 1] = "Number";
            return IndexKind2;
          })(IndexKind || {});
          TypeMapKind = ((TypeMapKind2) => {
            TypeMapKind2[TypeMapKind2["Simple"] = 0] = "Simple";
            TypeMapKind2[TypeMapKind2["Array"] = 1] = "Array";
            TypeMapKind2[TypeMapKind2["Deferred"] = 2] = "Deferred";
            TypeMapKind2[TypeMapKind2["Function"] = 3] = "Function";
            TypeMapKind2[TypeMapKind2["Composite"] = 4] = "Composite";
            TypeMapKind2[TypeMapKind2["Merged"] = 5] = "Merged";
            return TypeMapKind2;
          })(TypeMapKind || {});
          InferencePriority = ((InferencePriority2) => {
            InferencePriority2[InferencePriority2["None"] = 0] = "None";
            InferencePriority2[InferencePriority2["NakedTypeVariable"] = 1] = "NakedTypeVariable";
            InferencePriority2[InferencePriority2["SpeculativeTuple"] = 2] = "SpeculativeTuple";
            InferencePriority2[InferencePriority2["SubstituteSource"] = 4] = "SubstituteSource";
            InferencePriority2[InferencePriority2["HomomorphicMappedType"] = 8] = "HomomorphicMappedType";
            InferencePriority2[InferencePriority2["PartialHomomorphicMappedType"] = 16] = "PartialHomomorphicMappedType";
            InferencePriority2[InferencePriority2["MappedTypeConstraint"] = 32] = "MappedTypeConstraint";
            InferencePriority2[InferencePriority2["ContravariantConditional"] = 64] = "ContravariantConditional";
            InferencePriority2[InferencePriority2["ReturnType"] = 128] = "ReturnType";
            InferencePriority2[InferencePriority2["LiteralKeyof"] = 256] = "LiteralKeyof";
            InferencePriority2[InferencePriority2["NoConstraints"] = 512] = "NoConstraints";
            InferencePriority2[InferencePriority2["AlwaysStrict"] = 1024] = "AlwaysStrict";
            InferencePriority2[InferencePriority2["MaxValue"] = 2048] = "MaxValue";
            InferencePriority2[InferencePriority2["PriorityImpliesCombination"] = 416] = "PriorityImpliesCombination";
            InferencePriority2[InferencePriority2["Circularity"] = -1] = "Circularity";
            return InferencePriority2;
          })(InferencePriority || {});
          InferenceFlags = ((InferenceFlags2) => {
            InferenceFlags2[InferenceFlags2["None"] = 0] = "None";
            InferenceFlags2[InferenceFlags2["NoDefault"] = 1] = "NoDefault";
            InferenceFlags2[InferenceFlags2["AnyDefault"] = 2] = "AnyDefault";
            InferenceFlags2[InferenceFlags2["SkippedGenericFunction"] = 4] = "SkippedGenericFunction";
            return InferenceFlags2;
          })(InferenceFlags || {});
          Ternary = ((Ternary2) => {
            Ternary2[Ternary2["False"] = 0] = "False";
            Ternary2[Ternary2["Unknown"] = 1] = "Unknown";
            Ternary2[Ternary2["Maybe"] = 3] = "Maybe";
            Ternary2[Ternary2["True"] = -1] = "True";
            return Ternary2;
          })(Ternary || {});
          AssignmentDeclarationKind = ((AssignmentDeclarationKind2) => {
            AssignmentDeclarationKind2[AssignmentDeclarationKind2["None"] = 0] = "None";
            AssignmentDeclarationKind2[AssignmentDeclarationKind2["ExportsProperty"] = 1] = "ExportsProperty";
            AssignmentDeclarationKind2[AssignmentDeclarationKind2["ModuleExports"] = 2] = "ModuleExports";
            AssignmentDeclarationKind2[AssignmentDeclarationKind2["PrototypeProperty"] = 3] = "PrototypeProperty";
            AssignmentDeclarationKind2[AssignmentDeclarationKind2["ThisProperty"] = 4] = "ThisProperty";
            AssignmentDeclarationKind2[AssignmentDeclarationKind2["Property"] = 5] = "Property";
            AssignmentDeclarationKind2[AssignmentDeclarationKind2["Prototype"] = 6] = "Prototype";
            AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePropertyValue"] = 7] = "ObjectDefinePropertyValue";
            AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePropertyExports"] = 8] = "ObjectDefinePropertyExports";
            AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePrototypeProperty"] = 9] = "ObjectDefinePrototypeProperty";
            return AssignmentDeclarationKind2;
          })(AssignmentDeclarationKind || {});
          DiagnosticCategory = ((DiagnosticCategory2) => {
            DiagnosticCategory2[DiagnosticCategory2["Warning"] = 0] = "Warning";
            DiagnosticCategory2[DiagnosticCategory2["Error"] = 1] = "Error";
            DiagnosticCategory2[DiagnosticCategory2["Suggestion"] = 2] = "Suggestion";
            DiagnosticCategory2[DiagnosticCategory2["Message"] = 3] = "Message";
            return DiagnosticCategory2;
          })(DiagnosticCategory || {});
          ModuleResolutionKind = ((ModuleResolutionKind3) => {
            ModuleResolutionKind3[ModuleResolutionKind3["Classic"] = 1] = "Classic";
            ModuleResolutionKind3[ModuleResolutionKind3["NodeJs"] = 2] = "NodeJs";
            ModuleResolutionKind3[ModuleResolutionKind3["Node10"] = 2] = "Node10";
            ModuleResolutionKind3[ModuleResolutionKind3["Node16"] = 3] = "Node16";
            ModuleResolutionKind3[ModuleResolutionKind3["NodeNext"] = 99] = "NodeNext";
            ModuleResolutionKind3[ModuleResolutionKind3["Bundler"] = 100] = "Bundler";
            return ModuleResolutionKind3;
          })(ModuleResolutionKind || {});
          ModuleDetectionKind = ((ModuleDetectionKind2) => {
            ModuleDetectionKind2[ModuleDetectionKind2["Legacy"] = 1] = "Legacy";
            ModuleDetectionKind2[ModuleDetectionKind2["Auto"] = 2] = "Auto";
            ModuleDetectionKind2[ModuleDetectionKind2["Force"] = 3] = "Force";
            return ModuleDetectionKind2;
          })(ModuleDetectionKind || {});
          WatchFileKind = ((WatchFileKind3) => {
            WatchFileKind3[WatchFileKind3["FixedPollingInterval"] = 0] = "FixedPollingInterval";
            WatchFileKind3[WatchFileKind3["PriorityPollingInterval"] = 1] = "PriorityPollingInterval";
            WatchFileKind3[WatchFileKind3["DynamicPriorityPolling"] = 2] = "DynamicPriorityPolling";
            WatchFileKind3[WatchFileKind3["FixedChunkSizePolling"] = 3] = "FixedChunkSizePolling";
            WatchFileKind3[WatchFileKind3["UseFsEvents"] = 4] = "UseFsEvents";
            WatchFileKind3[WatchFileKind3["UseFsEventsOnParentDirectory"] = 5] = "UseFsEventsOnParentDirectory";
            return WatchFileKind3;
          })(WatchFileKind || {});
          WatchDirectoryKind = ((WatchDirectoryKind3) => {
            WatchDirectoryKind3[WatchDirectoryKind3["UseFsEvents"] = 0] = "UseFsEvents";
            WatchDirectoryKind3[WatchDirectoryKind3["FixedPollingInterval"] = 1] = "FixedPollingInterval";
            WatchDirectoryKind3[WatchDirectoryKind3["DynamicPriorityPolling"] = 2] = "DynamicPriorityPolling";
            WatchDirectoryKind3[WatchDirectoryKind3["FixedChunkSizePolling"] = 3] = "FixedChunkSizePolling";
            return WatchDirectoryKind3;
          })(WatchDirectoryKind || {});
          PollingWatchKind = ((PollingWatchKind3) => {
            PollingWatchKind3[PollingWatchKind3["FixedInterval"] = 0] = "FixedInterval";
            PollingWatchKind3[PollingWatchKind3["PriorityInterval"] = 1] = "PriorityInterval";
            PollingWatchKind3[PollingWatchKind3["DynamicPriority"] = 2] = "DynamicPriority";
            PollingWatchKind3[PollingWatchKind3["FixedChunkSize"] = 3] = "FixedChunkSize";
            return PollingWatchKind3;
          })(PollingWatchKind || {});
          ModuleKind = ((ModuleKind3) => {
            ModuleKind3[ModuleKind3["None"] = 0] = "None";
            ModuleKind3[ModuleKind3["CommonJS"] = 1] = "CommonJS";
            ModuleKind3[ModuleKind3["AMD"] = 2] = "AMD";
            ModuleKind3[ModuleKind3["UMD"] = 3] = "UMD";
            ModuleKind3[ModuleKind3["System"] = 4] = "System";
            ModuleKind3[ModuleKind3["ES2015"] = 5] = "ES2015";
            ModuleKind3[ModuleKind3["ES2020"] = 6] = "ES2020";
            ModuleKind3[ModuleKind3["ES2022"] = 7] = "ES2022";
            ModuleKind3[ModuleKind3["ESNext"] = 99] = "ESNext";
            ModuleKind3[ModuleKind3["Node16"] = 100] = "Node16";
            ModuleKind3[ModuleKind3["NodeNext"] = 199] = "NodeNext";
            return ModuleKind3;
          })(ModuleKind || {});
          JsxEmit = ((JsxEmit3) => {
            JsxEmit3[JsxEmit3["None"] = 0] = "None";
            JsxEmit3[JsxEmit3["Preserve"] = 1] = "Preserve";
            JsxEmit3[JsxEmit3["React"] = 2] = "React";
            JsxEmit3[JsxEmit3["ReactNative"] = 3] = "ReactNative";
            JsxEmit3[JsxEmit3["ReactJSX"] = 4] = "ReactJSX";
            JsxEmit3[JsxEmit3["ReactJSXDev"] = 5] = "ReactJSXDev";
            return JsxEmit3;
          })(JsxEmit || {});
          ImportsNotUsedAsValues = ((ImportsNotUsedAsValues2) => {
            ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Remove"] = 0] = "Remove";
            ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Preserve"] = 1] = "Preserve";
            ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Error"] = 2] = "Error";
            return ImportsNotUsedAsValues2;
          })(ImportsNotUsedAsValues || {});
          NewLineKind = ((NewLineKind3) => {
            NewLineKind3[NewLineKind3["CarriageReturnLineFeed"] = 0] = "CarriageReturnLineFeed";
            NewLineKind3[NewLineKind3["LineFeed"] = 1] = "LineFeed";
            return NewLineKind3;
          })(NewLineKind || {});
          ScriptKind = ((ScriptKind7) => {
            ScriptKind7[ScriptKind7["Unknown"] = 0] = "Unknown";
            ScriptKind7[ScriptKind7["JS"] = 1] = "JS";
            ScriptKind7[ScriptKind7["JSX"] = 2] = "JSX";
            ScriptKind7[ScriptKind7["TS"] = 3] = "TS";
            ScriptKind7[ScriptKind7["TSX"] = 4] = "TSX";
            ScriptKind7[ScriptKind7["External"] = 5] = "External";
            ScriptKind7[ScriptKind7["JSON"] = 6] = "JSON";
            ScriptKind7[ScriptKind7["Deferred"] = 7] = "Deferred";
            return ScriptKind7;
          })(ScriptKind || {});
          ScriptTarget = ((ScriptTarget11) => {
            ScriptTarget11[ScriptTarget11["ES3"] = 0] = "ES3";
            ScriptTarget11[ScriptTarget11["ES5"] = 1] = "ES5";
            ScriptTarget11[ScriptTarget11["ES2015"] = 2] = "ES2015";
            ScriptTarget11[ScriptTarget11["ES2016"] = 3] = "ES2016";
            ScriptTarget11[ScriptTarget11["ES2017"] = 4] = "ES2017";
            ScriptTarget11[ScriptTarget11["ES2018"] = 5] = "ES2018";
            ScriptTarget11[ScriptTarget11["ES2019"] = 6] = "ES2019";
            ScriptTarget11[ScriptTarget11["ES2020"] = 7] = "ES2020";
            ScriptTarget11[ScriptTarget11["ES2021"] = 8] = "ES2021";
            ScriptTarget11[ScriptTarget11["ES2022"] = 9] = "ES2022";
            ScriptTarget11[ScriptTarget11["ESNext"] = 99] = "ESNext";
            ScriptTarget11[ScriptTarget11["JSON"] = 100] = "JSON";
            ScriptTarget11[
              ScriptTarget11["Latest"] = 99
              /* ESNext */
            ] = "Latest";
            return ScriptTarget11;
          })(ScriptTarget || {});
          LanguageVariant = ((LanguageVariant4) => {
            LanguageVariant4[LanguageVariant4["Standard"] = 0] = "Standard";
            LanguageVariant4[LanguageVariant4["JSX"] = 1] = "JSX";
            return LanguageVariant4;
          })(LanguageVariant || {});
          WatchDirectoryFlags = ((WatchDirectoryFlags3) => {
            WatchDirectoryFlags3[WatchDirectoryFlags3["None"] = 0] = "None";
            WatchDirectoryFlags3[WatchDirectoryFlags3["Recursive"] = 1] = "Recursive";
            return WatchDirectoryFlags3;
          })(WatchDirectoryFlags || {});
          CharacterCodes = ((CharacterCodes2) => {
            CharacterCodes2[CharacterCodes2["nullCharacter"] = 0] = "nullCharacter";
            CharacterCodes2[CharacterCodes2["maxAsciiCharacter"] = 127] = "maxAsciiCharacter";
            CharacterCodes2[CharacterCodes2["lineFeed"] = 10] = "lineFeed";
            CharacterCodes2[CharacterCodes2["carriageReturn"] = 13] = "carriageReturn";
            CharacterCodes2[CharacterCodes2["lineSeparator"] = 8232] = "lineSeparator";
            CharacterCodes2[CharacterCodes2["paragraphSeparator"] = 8233] = "paragraphSeparator";
            CharacterCodes2[CharacterCodes2["nextLine"] = 133] = "nextLine";
            CharacterCodes2[CharacterCodes2["space"] = 32] = "space";
            CharacterCodes2[CharacterCodes2["nonBreakingSpace"] = 160] = "nonBreakingSpace";
            CharacterCodes2[CharacterCodes2["enQuad"] = 8192] = "enQuad";
            CharacterCodes2[CharacterCodes2["emQuad"] = 8193] = "emQuad";
            CharacterCodes2[CharacterCodes2["enSpace"] = 8194] = "enSpace";
            CharacterCodes2[CharacterCodes2["emSpace"] = 8195] = "emSpace";
            CharacterCodes2[CharacterCodes2["threePerEmSpace"] = 8196] = "threePerEmSpace";
            CharacterCodes2[CharacterCodes2["fourPerEmSpace"] = 8197] = "fourPerEmSpace";
            CharacterCodes2[CharacterCodes2["sixPerEmSpace"] = 8198] = "sixPerEmSpace";
            CharacterCodes2[CharacterCodes2["figureSpace"] = 8199] = "figureSpace";
            CharacterCodes2[CharacterCodes2["punctuationSpace"] = 8200] = "punctuationSpace";
            CharacterCodes2[CharacterCodes2["thinSpace"] = 8201] = "thinSpace";
            CharacterCodes2[CharacterCodes2["hairSpace"] = 8202] = "hairSpace";
            CharacterCodes2[CharacterCodes2["zeroWidthSpace"] = 8203] = "zeroWidthSpace";
            CharacterCodes2[CharacterCodes2["narrowNoBreakSpace"] = 8239] = "narrowNoBreakSpace";
            CharacterCodes2[CharacterCodes2["ideographicSpace"] = 12288] = "ideographicSpace";
            CharacterCodes2[CharacterCodes2["mathematicalSpace"] = 8287] = "mathematicalSpace";
            CharacterCodes2[CharacterCodes2["ogham"] = 5760] = "ogham";
            CharacterCodes2[CharacterCodes2["replacementCharacter"] = 65533] = "replacementCharacter";
            CharacterCodes2[CharacterCodes2["_"] = 95] = "_";
            CharacterCodes2[CharacterCodes2["$"] = 36] = "$";
            CharacterCodes2[CharacterCodes2["_0"] = 48] = "_0";
            CharacterCodes2[CharacterCodes2["_1"] = 49] = "_1";
            CharacterCodes2[CharacterCodes2["_2"] = 50] = "_2";
            CharacterCodes2[CharacterCodes2["_3"] = 51] = "_3";
            CharacterCodes2[CharacterCodes2["_4"] = 52] = "_4";
            CharacterCodes2[CharacterCodes2["_5"] = 53] = "_5";
            CharacterCodes2[CharacterCodes2["_6"] = 54] = "_6";
            CharacterCodes2[CharacterCodes2["_7"] = 55] = "_7";
            CharacterCodes2[CharacterCodes2["_8"] = 56] = "_8";
            CharacterCodes2[CharacterCodes2["_9"] = 57] = "_9";
            CharacterCodes2[CharacterCodes2["a"] = 97] = "a";
            CharacterCodes2[CharacterCodes2["b"] = 98] = "b";
            CharacterCodes2[CharacterCodes2["c"] = 99] = "c";
            CharacterCodes2[CharacterCodes2["d"] = 100] = "d";
            CharacterCodes2[CharacterCodes2["e"] = 101] = "e";
            CharacterCodes2[CharacterCodes2["f"] = 102] = "f";
            CharacterCodes2[CharacterCodes2["g"] = 103] = "g";
            CharacterCodes2[CharacterCodes2["h"] = 104] = "h";
            CharacterCodes2[CharacterCodes2["i"] = 105] = "i";
            CharacterCodes2[CharacterCodes2["j"] = 106] = "j";
            CharacterCodes2[CharacterCodes2["k"] = 107] = "k";
            CharacterCodes2[CharacterCodes2["l"] = 108] = "l";
            CharacterCodes2[CharacterCodes2["m"] = 109] = "m";
            CharacterCodes2[CharacterCodes2["n"] = 110] = "n";
            CharacterCodes2[CharacterCodes2["o"] = 111] = "o";
            CharacterCodes2[CharacterCodes2["p"] = 112] = "p";
            CharacterCodes2[CharacterCodes2["q"] = 113] = "q";
            CharacterCodes2[CharacterCodes2["r"] = 114] = "r";
            CharacterCodes2[CharacterCodes2["s"] = 115] = "s";
            CharacterCodes2[CharacterCodes2["t"] = 116] = "t";
            CharacterCodes2[CharacterCodes2["u"] = 117] = "u";
            CharacterCodes2[CharacterCodes2["v"] = 118] = "v";
            CharacterCodes2[CharacterCodes2["w"] = 119] = "w";
            CharacterCodes2[CharacterCodes2["x"] = 120] = "x";
            CharacterCodes2[CharacterCodes2["y"] = 121] = "y";
            CharacterCodes2[CharacterCodes2["z"] = 122] = "z";
            CharacterCodes2[CharacterCodes2["A"] = 65] = "A";
            CharacterCodes2[CharacterCodes2["B"] = 66] = "B";
            CharacterCodes2[CharacterCodes2["C"] = 67] = "C";
            CharacterCodes2[CharacterCodes2["D"] = 68] = "D";
            CharacterCodes2[CharacterCodes2["E"] = 69] = "E";
            CharacterCodes2[CharacterCodes2["F"] = 70] = "F";
            CharacterCodes2[CharacterCodes2["G"] = 71] = "G";
            CharacterCodes2[CharacterCodes2["H"] = 72] = "H";
            CharacterCodes2[CharacterCodes2["I"] = 73] = "I";
            CharacterCodes2[CharacterCodes2["J"] = 74] = "J";
            CharacterCodes2[CharacterCodes2["K"] = 75] = "K";
            CharacterCodes2[CharacterCodes2["L"] = 76] = "L";
            CharacterCodes2[CharacterCodes2["M"] = 77] = "M";
            CharacterCodes2[CharacterCodes2["N"] = 78] = "N";
            CharacterCodes2[CharacterCodes2["O"] = 79] = "O";
            CharacterCodes2[CharacterCodes2["P"] = 80] = "P";
            CharacterCodes2[CharacterCodes2["Q"] = 81] = "Q";
            CharacterCodes2[CharacterCodes2["R"] = 82] = "R";
            CharacterCodes2[CharacterCodes2["S"] = 83] = "S";
            CharacterCodes2[CharacterCodes2["T"] = 84] = "T";
            CharacterCodes2[CharacterCodes2["U"] = 85] = "U";
            CharacterCodes2[CharacterCodes2["V"] = 86] = "V";
            CharacterCodes2[CharacterCodes2["W"] = 87] = "W";
            CharacterCodes2[CharacterCodes2["X"] = 88] = "X";
            CharacterCodes2[CharacterCodes2["Y"] = 89] = "Y";
            CharacterCodes2[CharacterCodes2["Z"] = 90] = "Z";
            CharacterCodes2[CharacterCodes2["ampersand"] = 38] = "ampersand";
            CharacterCodes2[CharacterCodes2["asterisk"] = 42] = "asterisk";
            CharacterCodes2[CharacterCodes2["at"] = 64] = "at";
            CharacterCodes2[CharacterCodes2["backslash"] = 92] = "backslash";
            CharacterCodes2[CharacterCodes2["backtick"] = 96] = "backtick";
            CharacterCodes2[CharacterCodes2["bar"] = 124] = "bar";
            CharacterCodes2[CharacterCodes2["caret"] = 94] = "caret";
            CharacterCodes2[CharacterCodes2["closeBrace"] = 125] = "closeBrace";
            CharacterCodes2[CharacterCodes2["closeBracket"] = 93] = "closeBracket";
            CharacterCodes2[CharacterCodes2["closeParen"] = 41] = "closeParen";
            CharacterCodes2[CharacterCodes2["colon"] = 58] = "colon";
            CharacterCodes2[CharacterCodes2["comma"] = 44] = "comma";
            CharacterCodes2[CharacterCodes2["dot"] = 46] = "dot";
            CharacterCodes2[CharacterCodes2["doubleQuote"] = 34] = "doubleQuote";
            CharacterCodes2[CharacterCodes2["equals"] = 61] = "equals";
            CharacterCodes2[CharacterCodes2["exclamation"] = 33] = "exclamation";
            CharacterCodes2[CharacterCodes2["greaterThan"] = 62] = "greaterThan";
            CharacterCodes2[CharacterCodes2["hash"] = 35] = "hash";
            CharacterCodes2[CharacterCodes2["lessThan"] = 60] = "lessThan";
            CharacterCodes2[CharacterCodes2["minus"] = 45] = "minus";
            CharacterCodes2[CharacterCodes2["openBrace"] = 123] = "openBrace";
            CharacterCodes2[CharacterCodes2["openBracket"] = 91] = "openBracket";
            CharacterCodes2[CharacterCodes2["openParen"] = 40] = "openParen";
            CharacterCodes2[CharacterCodes2["percent"] = 37] = "percent";
            CharacterCodes2[CharacterCodes2["plus"] = 43] = "plus";
            CharacterCodes2[CharacterCodes2["question"] = 63] = "question";
            CharacterCodes2[CharacterCodes2["semicolon"] = 59] = "semicolon";
            CharacterCodes2[CharacterCodes2["singleQuote"] = 39] = "singleQuote";
            CharacterCodes2[CharacterCodes2["slash"] = 47] = "slash";
            CharacterCodes2[CharacterCodes2["tilde"] = 126] = "tilde";
            CharacterCodes2[CharacterCodes2["backspace"] = 8] = "backspace";
            CharacterCodes2[CharacterCodes2["formFeed"] = 12] = "formFeed";
            CharacterCodes2[CharacterCodes2["byteOrderMark"] = 65279] = "byteOrderMark";
            CharacterCodes2[CharacterCodes2["tab"] = 9] = "tab";
            CharacterCodes2[CharacterCodes2["verticalTab"] = 11] = "verticalTab";
            return CharacterCodes2;
          })(CharacterCodes || {});
          Extension = ((Extension2) => {
            Extension2["Ts"] = ".ts";
            Extension2["Tsx"] = ".tsx";
            Extension2["Dts"] = ".d.ts";
            Extension2["Js"] = ".js";
            Extension2["Jsx"] = ".jsx";
            Extension2["Json"] = ".json";
            Extension2["TsBuildInfo"] = ".tsbuildinfo";
            Extension2["Mjs"] = ".mjs";
            Extension2["Mts"] = ".mts";
            Extension2["Dmts"] = ".d.mts";
            Extension2["Cjs"] = ".cjs";
            Extension2["Cts"] = ".cts";
            Extension2["Dcts"] = ".d.cts";
            return Extension2;
          })(Extension || {});
          TransformFlags = ((TransformFlags3) => {
            TransformFlags3[TransformFlags3["None"] = 0] = "None";
            TransformFlags3[TransformFlags3["ContainsTypeScript"] = 1] = "ContainsTypeScript";
            TransformFlags3[TransformFlags3["ContainsJsx"] = 2] = "ContainsJsx";
            TransformFlags3[TransformFlags3["ContainsESNext"] = 4] = "ContainsESNext";
            TransformFlags3[TransformFlags3["ContainsES2022"] = 8] = "ContainsES2022";
            TransformFlags3[TransformFlags3["ContainsES2021"] = 16] = "ContainsES2021";
            TransformFlags3[TransformFlags3["ContainsES2020"] = 32] = "ContainsES2020";
            TransformFlags3[TransformFlags3["ContainsES2019"] = 64] = "ContainsES2019";
            TransformFlags3[TransformFlags3["ContainsES2018"] = 128] = "ContainsES2018";
            TransformFlags3[TransformFlags3["ContainsES2017"] = 256] = "ContainsES2017";
            TransformFlags3[TransformFlags3["ContainsES2016"] = 512] = "ContainsES2016";
            TransformFlags3[TransformFlags3["ContainsES2015"] = 1024] = "ContainsES2015";
            TransformFlags3[TransformFlags3["ContainsGenerator"] = 2048] = "ContainsGenerator";
            TransformFlags3[TransformFlags3["ContainsDestructuringAssignment"] = 4096] = "ContainsDestructuringAssignment";
            TransformFlags3[TransformFlags3["ContainsTypeScriptClassSyntax"] = 8192] = "ContainsTypeScriptClassSyntax";
            TransformFlags3[TransformFlags3["ContainsLexicalThis"] = 16384] = "ContainsLexicalThis";
            TransformFlags3[TransformFlags3["ContainsRestOrSpread"] = 32768] = "ContainsRestOrSpread";
            TransformFlags3[TransformFlags3["ContainsObjectRestOrSpread"] = 65536] = "ContainsObjectRestOrSpread";
            TransformFlags3[TransformFlags3["ContainsComputedPropertyName"] = 131072] = "ContainsComputedPropertyName";
            TransformFlags3[TransformFlags3["ContainsBlockScopedBinding"] = 262144] = "ContainsBlockScopedBinding";
            TransformFlags3[TransformFlags3["ContainsBindingPattern"] = 524288] = "ContainsBindingPattern";
            TransformFlags3[TransformFlags3["ContainsYield"] = 1048576] = "ContainsYield";
            TransformFlags3[TransformFlags3["ContainsAwait"] = 2097152] = "ContainsAwait";
            TransformFlags3[TransformFlags3["ContainsHoistedDeclarationOrCompletion"] = 4194304] = "ContainsHoistedDeclarationOrCompletion";
            TransformFlags3[TransformFlags3["ContainsDynamicImport"] = 8388608] = "ContainsDynamicImport";
            TransformFlags3[TransformFlags3["ContainsClassFields"] = 16777216] = "ContainsClassFields";
            TransformFlags3[TransformFlags3["ContainsDecorators"] = 33554432] = "ContainsDecorators";
            TransformFlags3[TransformFlags3["ContainsPossibleTopLevelAwait"] = 67108864] = "ContainsPossibleTopLevelAwait";
            TransformFlags3[TransformFlags3["ContainsLexicalSuper"] = 134217728] = "ContainsLexicalSuper";
            TransformFlags3[TransformFlags3["ContainsUpdateExpressionForIdentifier"] = 268435456] = "ContainsUpdateExpressionForIdentifier";
            TransformFlags3[TransformFlags3["ContainsPrivateIdentifierInExpression"] = 536870912] = "ContainsPrivateIdentifierInExpression";
            TransformFlags3[TransformFlags3["HasComputedFlags"] = -2147483648] = "HasComputedFlags";
            TransformFlags3[
              TransformFlags3["AssertTypeScript"] = 1
              /* ContainsTypeScript */
            ] = "AssertTypeScript";
            TransformFlags3[
              TransformFlags3["AssertJsx"] = 2
              /* ContainsJsx */
            ] = "AssertJsx";
            TransformFlags3[
              TransformFlags3["AssertESNext"] = 4
              /* ContainsESNext */
            ] = "AssertESNext";
            TransformFlags3[
              TransformFlags3["AssertES2022"] = 8
              /* ContainsES2022 */
            ] = "AssertES2022";
            TransformFlags3[
              TransformFlags3["AssertES2021"] = 16
              /* ContainsES2021 */
            ] = "AssertES2021";
            TransformFlags3[
              TransformFlags3["AssertES2020"] = 32
              /* ContainsES2020 */
            ] = "AssertES2020";
            TransformFlags3[
              TransformFlags3["AssertES2019"] = 64
              /* ContainsES2019 */
            ] = "AssertES2019";
            TransformFlags3[
              TransformFlags3["AssertES2018"] = 128
              /* ContainsES2018 */
            ] = "AssertES2018";
            TransformFlags3[
              TransformFlags3["AssertES2017"] = 256
              /* ContainsES2017 */
            ] = "AssertES2017";
            TransformFlags3[
              TransformFlags3["AssertES2016"] = 512
              /* ContainsES2016 */
            ] = "AssertES2016";
            TransformFlags3[
              TransformFlags3["AssertES2015"] = 1024
              /* ContainsES2015 */
            ] = "AssertES2015";
            TransformFlags3[
              TransformFlags3["AssertGenerator"] = 2048
              /* ContainsGenerator */
            ] = "AssertGenerator";
            TransformFlags3[
              TransformFlags3["AssertDestructuringAssignment"] = 4096
              /* ContainsDestructuringAssignment */
            ] = "AssertDestructuringAssignment";
            TransformFlags3[
              TransformFlags3["OuterExpressionExcludes"] = -2147483648
              /* HasComputedFlags */
            ] = "OuterExpressionExcludes";
            TransformFlags3[
              TransformFlags3["PropertyAccessExcludes"] = -2147483648
              /* OuterExpressionExcludes */
            ] = "PropertyAccessExcludes";
            TransformFlags3[
              TransformFlags3["NodeExcludes"] = -2147483648
              /* PropertyAccessExcludes */
            ] = "NodeExcludes";
            TransformFlags3[TransformFlags3["ArrowFunctionExcludes"] = -2072174592] = "ArrowFunctionExcludes";
            TransformFlags3[TransformFlags3["FunctionExcludes"] = -1937940480] = "FunctionExcludes";
            TransformFlags3[TransformFlags3["ConstructorExcludes"] = -1937948672] = "ConstructorExcludes";
            TransformFlags3[TransformFlags3["MethodOrAccessorExcludes"] = -2005057536] = "MethodOrAccessorExcludes";
            TransformFlags3[TransformFlags3["PropertyExcludes"] = -2013249536] = "PropertyExcludes";
            TransformFlags3[TransformFlags3["ClassExcludes"] = -2147344384] = "ClassExcludes";
            TransformFlags3[TransformFlags3["ModuleExcludes"] = -1941676032] = "ModuleExcludes";
            TransformFlags3[TransformFlags3["TypeExcludes"] = -2] = "TypeExcludes";
            TransformFlags3[TransformFlags3["ObjectLiteralExcludes"] = -2147278848] = "ObjectLiteralExcludes";
            TransformFlags3[TransformFlags3["ArrayLiteralOrCallOrNewExcludes"] = -2147450880] = "ArrayLiteralOrCallOrNewExcludes";
            TransformFlags3[TransformFlags3["VariableDeclarationListExcludes"] = -2146893824] = "VariableDeclarationListExcludes";
            TransformFlags3[
              TransformFlags3["ParameterExcludes"] = -2147483648
              /* NodeExcludes */
            ] = "ParameterExcludes";
            TransformFlags3[TransformFlags3["CatchClauseExcludes"] = -2147418112] = "CatchClauseExcludes";
            TransformFlags3[TransformFlags3["BindingPatternExcludes"] = -2147450880] = "BindingPatternExcludes";
            TransformFlags3[TransformFlags3["ContainsLexicalThisOrSuper"] = 134234112] = "ContainsLexicalThisOrSuper";
            TransformFlags3[TransformFlags3["PropertyNamePropagatingFlags"] = 134234112] = "PropertyNamePropagatingFlags";
            return TransformFlags3;
          })(TransformFlags || {});
          SnippetKind = ((SnippetKind3) => {
            SnippetKind3[SnippetKind3["TabStop"] = 0] = "TabStop";
            SnippetKind3[SnippetKind3["Placeholder"] = 1] = "Placeholder";
            SnippetKind3[SnippetKind3["Choice"] = 2] = "Choice";
            SnippetKind3[SnippetKind3["Variable"] = 3] = "Variable";
            return SnippetKind3;
          })(SnippetKind || {});
          EmitFlags = ((EmitFlags3) => {
            EmitFlags3[EmitFlags3["None"] = 0] = "None";
            EmitFlags3[EmitFlags3["SingleLine"] = 1] = "SingleLine";
            EmitFlags3[EmitFlags3["MultiLine"] = 2] = "MultiLine";
            EmitFlags3[EmitFlags3["AdviseOnEmitNode"] = 4] = "AdviseOnEmitNode";
            EmitFlags3[EmitFlags3["NoSubstitution"] = 8] = "NoSubstitution";
            EmitFlags3[EmitFlags3["CapturesThis"] = 16] = "CapturesThis";
            EmitFlags3[EmitFlags3["NoLeadingSourceMap"] = 32] = "NoLeadingSourceMap";
            EmitFlags3[EmitFlags3["NoTrailingSourceMap"] = 64] = "NoTrailingSourceMap";
            EmitFlags3[EmitFlags3["NoSourceMap"] = 96] = "NoSourceMap";
            EmitFlags3[EmitFlags3["NoNestedSourceMaps"] = 128] = "NoNestedSourceMaps";
            EmitFlags3[EmitFlags3["NoTokenLeadingSourceMaps"] = 256] = "NoTokenLeadingSourceMaps";
            EmitFlags3[EmitFlags3["NoTokenTrailingSourceMaps"] = 512] = "NoTokenTrailingSourceMaps";
            EmitFlags3[EmitFlags3["NoTokenSourceMaps"] = 768] = "NoTokenSourceMaps";
            EmitFlags3[EmitFlags3["NoLeadingComments"] = 1024] = "NoLeadingComments";
            EmitFlags3[EmitFlags3["NoTrailingComments"] = 2048] = "NoTrailingComments";
            EmitFlags3[EmitFlags3["NoComments"] = 3072] = "NoComments";
            EmitFlags3[EmitFlags3["NoNestedComments"] = 4096] = "NoNestedComments";
            EmitFlags3[EmitFlags3["HelperName"] = 8192] = "HelperName";
            EmitFlags3[EmitFlags3["ExportName"] = 16384] = "ExportName";
            EmitFlags3[EmitFlags3["LocalName"] = 32768] = "LocalName";
            EmitFlags3[EmitFlags3["InternalName"] = 65536] = "InternalName";
            EmitFlags3[EmitFlags3["Indented"] = 131072] = "Indented";
            EmitFlags3[EmitFlags3["NoIndentation"] = 262144] = "NoIndentation";
            EmitFlags3[EmitFlags3["AsyncFunctionBody"] = 524288] = "AsyncFunctionBody";
            EmitFlags3[EmitFlags3["ReuseTempVariableScope"] = 1048576] = "ReuseTempVariableScope";
            EmitFlags3[EmitFlags3["CustomPrologue"] = 2097152] = "CustomPrologue";
            EmitFlags3[EmitFlags3["NoHoisting"] = 4194304] = "NoHoisting";
            EmitFlags3[EmitFlags3["Iterator"] = 8388608] = "Iterator";
            EmitFlags3[EmitFlags3["NoAsciiEscaping"] = 16777216] = "NoAsciiEscaping";
            return EmitFlags3;
          })(EmitFlags || {});
          InternalEmitFlags = ((InternalEmitFlags3) => {
            InternalEmitFlags3[InternalEmitFlags3["None"] = 0] = "None";
            InternalEmitFlags3[InternalEmitFlags3["TypeScriptClassWrapper"] = 1] = "TypeScriptClassWrapper";
            InternalEmitFlags3[InternalEmitFlags3["NeverApplyImportHelper"] = 2] = "NeverApplyImportHelper";
            InternalEmitFlags3[InternalEmitFlags3["IgnoreSourceNewlines"] = 4] = "IgnoreSourceNewlines";
            InternalEmitFlags3[InternalEmitFlags3["Immutable"] = 8] = "Immutable";
            InternalEmitFlags3[InternalEmitFlags3["IndirectCall"] = 16] = "IndirectCall";
            InternalEmitFlags3[InternalEmitFlags3["TransformPrivateStaticElements"] = 32] = "TransformPrivateStaticElements";
            return InternalEmitFlags3;
          })(InternalEmitFlags || {});
          ExternalEmitHelpers = ((ExternalEmitHelpers2) => {
            ExternalEmitHelpers2[ExternalEmitHelpers2["Extends"] = 1] = "Extends";
            ExternalEmitHelpers2[ExternalEmitHelpers2["Assign"] = 2] = "Assign";
            ExternalEmitHelpers2[ExternalEmitHelpers2["Rest"] = 4] = "Rest";
            ExternalEmitHelpers2[ExternalEmitHelpers2["Decorate"] = 8] = "Decorate";
            ExternalEmitHelpers2[
              ExternalEmitHelpers2["ESDecorateAndRunInitializers"] = 8
              /* Decorate */
            ] = "ESDecorateAndRunInitializers";
            ExternalEmitHelpers2[ExternalEmitHelpers2["Metadata"] = 16] = "Metadata";
            ExternalEmitHelpers2[ExternalEmitHelpers2["Param"] = 32] = "Param";
            ExternalEmitHelpers2[ExternalEmitHelpers2["Awaiter"] = 64] = "Awaiter";
            ExternalEmitHelpers2[ExternalEmitHelpers2["Generator"] = 128] = "Generator";
            ExternalEmitHelpers2[ExternalEmitHelpers2["Values"] = 256] = "Values";
            ExternalEmitHelpers2[ExternalEmitHelpers2["Read"] = 512] = "Read";
            ExternalEmitHelpers2[ExternalEmitHelpers2["SpreadArray"] = 1024] = "SpreadArray";
            ExternalEmitHelpers2[ExternalEmitHelpers2["Await"] = 2048] = "Await";
            ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncGenerator"] = 4096] = "AsyncGenerator";
            ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncDelegator"] = 8192] = "AsyncDelegator";
            ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncValues"] = 16384] = "AsyncValues";
            ExternalEmitHelpers2[ExternalEmitHelpers2["ExportStar"] = 32768] = "ExportStar";
            ExternalEmitHelpers2[ExternalEmitHelpers2["ImportStar"] = 65536] = "ImportStar";
            ExternalEmitHelpers2[ExternalEmitHelpers2["ImportDefault"] = 131072] = "ImportDefault";
            ExternalEmitHelpers2[ExternalEmitHelpers2["MakeTemplateObject"] = 262144] = "MakeTemplateObject";
            ExternalEmitHelpers2[ExternalEmitHelpers2["ClassPrivateFieldGet"] = 524288] = "ClassPrivateFieldGet";
            ExternalEmitHelpers2[ExternalEmitHelpers2["ClassPrivateFieldSet"] = 1048576] = "ClassPrivateFieldSet";
            ExternalEmitHelpers2[ExternalEmitHelpers2["ClassPrivateFieldIn"] = 2097152] = "ClassPrivateFieldIn";
            ExternalEmitHelpers2[ExternalEmitHelpers2["CreateBinding"] = 4194304] = "CreateBinding";
            ExternalEmitHelpers2[ExternalEmitHelpers2["SetFunctionName"] = 8388608] = "SetFunctionName";
            ExternalEmitHelpers2[ExternalEmitHelpers2["PropKey"] = 16777216] = "PropKey";
            ExternalEmitHelpers2[ExternalEmitHelpers2["AddDisposableResourceAndDisposeResources"] = 33554432] = "AddDisposableResourceAndDisposeResources";
            ExternalEmitHelpers2[
              ExternalEmitHelpers2["FirstEmitHelper"] = 1
              /* Extends */
            ] = "FirstEmitHelper";
            ExternalEmitHelpers2[
              ExternalEmitHelpers2["LastEmitHelper"] = 33554432
              /* AddDisposableResourceAndDisposeResources */
            ] = "LastEmitHelper";
            ExternalEmitHelpers2[
              ExternalEmitHelpers2["ForOfIncludes"] = 256
              /* Values */
            ] = "ForOfIncludes";
            ExternalEmitHelpers2[
              ExternalEmitHelpers2["ForAwaitOfIncludes"] = 16384
              /* AsyncValues */
            ] = "ForAwaitOfIncludes";
            ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncGeneratorIncludes"] = 6144] = "AsyncGeneratorIncludes";
            ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncDelegatorIncludes"] = 26624] = "AsyncDelegatorIncludes";
            ExternalEmitHelpers2[ExternalEmitHelpers2["SpreadIncludes"] = 1536] = "SpreadIncludes";
            return ExternalEmitHelpers2;
          })(ExternalEmitHelpers || {});
          EmitHint = ((EmitHint6) => {
            EmitHint6[EmitHint6["SourceFile"] = 0] = "SourceFile";
            EmitHint6[EmitHint6["Expression"] = 1] = "Expression";
            EmitHint6[EmitHint6["IdentifierName"] = 2] = "IdentifierName";
            EmitHint6[EmitHint6["MappedTypeParameter"] = 3] = "MappedTypeParameter";
            EmitHint6[EmitHint6["Unspecified"] = 4] = "Unspecified";
            EmitHint6[EmitHint6["EmbeddedStatement"] = 5] = "EmbeddedStatement";
            EmitHint6[EmitHint6["JsxAttributeValue"] = 6] = "JsxAttributeValue";
            return EmitHint6;
          })(EmitHint || {});
          OuterExpressionKinds = ((OuterExpressionKinds2) => {
            OuterExpressionKinds2[OuterExpressionKinds2["Parentheses"] = 1] = "Parentheses";
            OuterExpressionKinds2[OuterExpressionKinds2["TypeAssertions"] = 2] = "TypeAssertions";
            OuterExpressionKinds2[OuterExpressionKinds2["NonNullAssertions"] = 4] = "NonNullAssertions";
            OuterExpressionKinds2[OuterExpressionKinds2["PartiallyEmittedExpressions"] = 8] = "PartiallyEmittedExpressions";
            OuterExpressionKinds2[OuterExpressionKinds2["Assertions"] = 6] = "Assertions";
            OuterExpressionKinds2[OuterExpressionKinds2["All"] = 15] = "All";
            OuterExpressionKinds2[OuterExpressionKinds2["ExcludeJSDocTypeAssertion"] = 16] = "ExcludeJSDocTypeAssertion";
            return OuterExpressionKinds2;
          })(OuterExpressionKinds || {});
          LexicalEnvironmentFlags = ((LexicalEnvironmentFlags2) => {
            LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["None"] = 0] = "None";
            LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["InParameters"] = 1] = "InParameters";
            LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["VariablesHoistedInParameters"] = 2] = "VariablesHoistedInParameters";
            return LexicalEnvironmentFlags2;
          })(LexicalEnvironmentFlags || {});
          BundleFileSectionKind = ((BundleFileSectionKind2) => {
            BundleFileSectionKind2["Prologue"] = "prologue";
            BundleFileSectionKind2["EmitHelpers"] = "emitHelpers";
            BundleFileSectionKind2["NoDefaultLib"] = "no-default-lib";
            BundleFileSectionKind2["Reference"] = "reference";
            BundleFileSectionKind2["Type"] = "type";
            BundleFileSectionKind2["TypeResolutionModeRequire"] = "type-require";
            BundleFileSectionKind2["TypeResolutionModeImport"] = "type-import";
            BundleFileSectionKind2["Lib"] = "lib";
            BundleFileSectionKind2["Prepend"] = "prepend";
            BundleFileSectionKind2["Text"] = "text";
            BundleFileSectionKind2["Internal"] = "internal";
            return BundleFileSectionKind2;
          })(BundleFileSectionKind || {});
          ListFormat = ((ListFormat2) => {
            ListFormat2[ListFormat2["None"] = 0] = "None";
            ListFormat2[ListFormat2["SingleLine"] = 0] = "SingleLine";
            ListFormat2[ListFormat2["MultiLine"] = 1] = "MultiLine";
            ListFormat2[ListFormat2["PreserveLines"] = 2] = "PreserveLines";
            ListFormat2[ListFormat2["LinesMask"] = 3] = "LinesMask";
            ListFormat2[ListFormat2["NotDelimited"] = 0] = "NotDelimited";
            ListFormat2[ListFormat2["BarDelimited"] = 4] = "BarDelimited";
            ListFormat2[ListFormat2["AmpersandDelimited"] = 8] = "AmpersandDelimited";
            ListFormat2[ListFormat2["CommaDelimited"] = 16] = "CommaDelimited";
            ListFormat2[ListFormat2["AsteriskDelimited"] = 32] = "AsteriskDelimited";
            ListFormat2[ListFormat2["DelimitersMask"] = 60] = "DelimitersMask";
            ListFormat2[ListFormat2["AllowTrailingComma"] = 64] = "AllowTrailingComma";
            ListFormat2[ListFormat2["Indented"] = 128] = "Indented";
            ListFormat2[ListFormat2["SpaceBetweenBraces"] = 256] = "SpaceBetweenBraces";
            ListFormat2[ListFormat2["SpaceBetweenSiblings"] = 512] = "SpaceBetweenSiblings";
            ListFormat2[ListFormat2["Braces"] = 1024] = "Braces";
            ListFormat2[ListFormat2["Parenthesis"] = 2048] = "Parenthesis";
            ListFormat2[ListFormat2["AngleBrackets"] = 4096] = "AngleBrackets";
            ListFormat2[ListFormat2["SquareBrackets"] = 8192] = "SquareBrackets";
            ListFormat2[ListFormat2["BracketsMask"] = 15360] = "BracketsMask";
            ListFormat2[ListFormat2["OptionalIfUndefined"] = 16384] = "OptionalIfUndefined";
            ListFormat2[ListFormat2["OptionalIfEmpty"] = 32768] = "OptionalIfEmpty";
            ListFormat2[ListFormat2["Optional"] = 49152] = "Optional";
            ListFormat2[ListFormat2["PreferNewLine"] = 65536] = "PreferNewLine";
            ListFormat2[ListFormat2["NoTrailingNewLine"] = 131072] = "NoTrailingNewLine";
            ListFormat2[ListFormat2["NoInterveningComments"] = 262144] = "NoInterveningComments";
            ListFormat2[ListFormat2["NoSpaceIfEmpty"] = 524288] = "NoSpaceIfEmpty";
            ListFormat2[ListFormat2["SingleElement"] = 1048576] = "SingleElement";
            ListFormat2[ListFormat2["SpaceAfterList"] = 2097152] = "SpaceAfterList";
            ListFormat2[ListFormat2["Modifiers"] = 2359808] = "Modifiers";
            ListFormat2[ListFormat2["HeritageClauses"] = 512] = "HeritageClauses";
            ListFormat2[ListFormat2["SingleLineTypeLiteralMembers"] = 768] = "SingleLineTypeLiteralMembers";
            ListFormat2[ListFormat2["MultiLineTypeLiteralMembers"] = 32897] = "MultiLineTypeLiteralMembers";
            ListFormat2[ListFormat2["SingleLineTupleTypeElements"] = 528] = "SingleLineTupleTypeElements";
            ListFormat2[ListFormat2["MultiLineTupleTypeElements"] = 657] = "MultiLineTupleTypeElements";
            ListFormat2[ListFormat2["UnionTypeConstituents"] = 516] = "UnionTypeConstituents";
            ListFormat2[ListFormat2["IntersectionTypeConstituents"] = 520] = "IntersectionTypeConstituents";
            ListFormat2[ListFormat2["ObjectBindingPatternElements"] = 525136] = "ObjectBindingPatternElements";
            ListFormat2[ListFormat2["ArrayBindingPatternElements"] = 524880] = "ArrayBindingPatternElements";
            ListFormat2[ListFormat2["ObjectLiteralExpressionProperties"] = 526226] = "ObjectLiteralExpressionProperties";
            ListFormat2[ListFormat2["ImportAttributes"] = 526226] = "ImportAttributes";
            ListFormat2[
              ListFormat2["ImportClauseEntries"] = 526226
              /* ImportAttributes */
            ] = "ImportClauseEntries";
            ListFormat2[ListFormat2["ArrayLiteralExpressionElements"] = 8914] = "ArrayLiteralExpressionElements";
            ListFormat2[ListFormat2["CommaListElements"] = 528] = "CommaListElements";
            ListFormat2[ListFormat2["CallExpressionArguments"] = 2576] = "CallExpressionArguments";
            ListFormat2[ListFormat2["NewExpressionArguments"] = 18960] = "NewExpressionArguments";
            ListFormat2[ListFormat2["TemplateExpressionSpans"] = 262144] = "TemplateExpressionSpans";
            ListFormat2[ListFormat2["SingleLineBlockStatements"] = 768] = "SingleLineBlockStatements";
            ListFormat2[ListFormat2["MultiLineBlockStatements"] = 129] = "MultiLineBlockStatements";
            ListFormat2[ListFormat2["VariableDeclarationList"] = 528] = "VariableDeclarationList";
            ListFormat2[ListFormat2["SingleLineFunctionBodyStatements"] = 768] = "SingleLineFunctionBodyStatements";
            ListFormat2[
              ListFormat2["MultiLineFunctionBodyStatements"] = 1
              /* MultiLine */
            ] = "MultiLineFunctionBodyStatements";
            ListFormat2[
              ListFormat2["ClassHeritageClauses"] = 0
              /* SingleLine */
            ] = "ClassHeritageClauses";
            ListFormat2[ListFormat2["ClassMembers"] = 129] = "ClassMembers";
            ListFormat2[ListFormat2["InterfaceMembers"] = 129] = "InterfaceMembers";
            ListFormat2[ListFormat2["EnumMembers"] = 145] = "EnumMembers";
            ListFormat2[ListFormat2["CaseBlockClauses"] = 129] = "CaseBlockClauses";
            ListFormat2[ListFormat2["NamedImportsOrExportsElements"] = 525136] = "NamedImportsOrExportsElements";
            ListFormat2[ListFormat2["JsxElementOrFragmentChildren"] = 262144] = "JsxElementOrFragmentChildren";
            ListFormat2[ListFormat2["JsxElementAttributes"] = 262656] = "JsxElementAttributes";
            ListFormat2[ListFormat2["CaseOrDefaultClauseStatements"] = 163969] = "CaseOrDefaultClauseStatements";
            ListFormat2[ListFormat2["HeritageClauseTypes"] = 528] = "HeritageClauseTypes";
            ListFormat2[ListFormat2["SourceFileStatements"] = 131073] = "SourceFileStatements";
            ListFormat2[ListFormat2["Decorators"] = 2146305] = "Decorators";
            ListFormat2[ListFormat2["TypeArguments"] = 53776] = "TypeArguments";
            ListFormat2[ListFormat2["TypeParameters"] = 53776] = "TypeParameters";
            ListFormat2[ListFormat2["Parameters"] = 2576] = "Parameters";
            ListFormat2[ListFormat2["IndexSignatureParameters"] = 8848] = "IndexSignatureParameters";
            ListFormat2[ListFormat2["JSDocComment"] = 33] = "JSDocComment";
            return ListFormat2;
          })(ListFormat || {});
          PragmaKindFlags = ((PragmaKindFlags2) => {
            PragmaKindFlags2[PragmaKindFlags2["None"] = 0] = "None";
            PragmaKindFlags2[PragmaKindFlags2["TripleSlashXML"] = 1] = "TripleSlashXML";
            PragmaKindFlags2[PragmaKindFlags2["SingleLine"] = 2] = "SingleLine";
            PragmaKindFlags2[PragmaKindFlags2["MultiLine"] = 4] = "MultiLine";
            PragmaKindFlags2[PragmaKindFlags2["All"] = 7] = "All";
            PragmaKindFlags2[
              PragmaKindFlags2["Default"] = 7
              /* All */
            ] = "Default";
            return PragmaKindFlags2;
          })(PragmaKindFlags || {});
          commentPragmas = {
            "reference": {
              args: [
                { name: "types", optional: true, captureSpan: true },
                { name: "lib", optional: true, captureSpan: true },
                { name: "path", optional: true, captureSpan: true },
                { name: "no-default-lib", optional: true },
                { name: "resolution-mode", optional: true }
              ],
              kind: 1
              /* TripleSlashXML */
            },
            "amd-dependency": {
              args: [{ name: "path" }, { name: "name", optional: true }],
              kind: 1
              /* TripleSlashXML */
            },
            "amd-module": {
              args: [{ name: "name" }],
              kind: 1
              /* TripleSlashXML */
            },
            "ts-check": {
              kind: 2
              /* SingleLine */
            },
            "ts-nocheck": {
              kind: 2
              /* SingleLine */
            },
            "jsx": {
              args: [{ name: "factory" }],
              kind: 4
              /* MultiLine */
            },
            "jsxfrag": {
              args: [{ name: "factory" }],
              kind: 4
              /* MultiLine */
            },
            "jsximportsource": {
              args: [{ name: "factory" }],
              kind: 4
              /* MultiLine */
            },
            "jsxruntime": {
              args: [{ name: "factory" }],
              kind: 4
              /* MultiLine */
            }
          };
          JSDocParsingMode = ((JSDocParsingMode6) => {
            JSDocParsingMode6[JSDocParsingMode6["ParseAll"] = 0] = "ParseAll";
            JSDocParsingMode6[JSDocParsingMode6["ParseNone"] = 1] = "ParseNone";
            JSDocParsingMode6[JSDocParsingMode6["ParseForTypeErrors"] = 2] = "ParseForTypeErrors";
            JSDocParsingMode6[JSDocParsingMode6["ParseForTypeInfo"] = 3] = "ParseForTypeInfo";
            return JSDocParsingMode6;
          })(JSDocParsingMode || {});
        }
      });
      function generateDjb2Hash(data) {
        let acc = 5381;
        for (let i = 0; i < data.length; i++) {
          acc = (acc << 5) + acc + data.charCodeAt(i);
        }
        return acc.toString();
      }
      function setStackTraceLimit() {
        if (Error.stackTraceLimit < 100) {
          Error.stackTraceLimit = 100;
        }
      }
      function getModifiedTime(host, fileName) {
        return host.getModifiedTime(fileName) || missingFileModifiedTime;
      }
      function createPollingIntervalBasedLevels(levels) {
        return {
          [
            250
            /* Low */
          ]: levels.Low,
          [
            500
            /* Medium */
          ]: levels.Medium,
          [
            2e3
            /* High */
          ]: levels.High
        };
      }
      function setCustomPollingValues(system) {
        if (!system.getEnvironmentVariable) {
          return;
        }
        const pollingIntervalChanged = setCustomLevels("TSC_WATCH_POLLINGINTERVAL", PollingInterval);
        pollingChunkSize = getCustomPollingBasedLevels("TSC_WATCH_POLLINGCHUNKSIZE", defaultChunkLevels) || pollingChunkSize;
        unchangedPollThresholds = getCustomPollingBasedLevels("TSC_WATCH_UNCHANGEDPOLLTHRESHOLDS", defaultChunkLevels) || unchangedPollThresholds;
        function getLevel(envVar, level) {
          return system.getEnvironmentVariable(`${envVar}_${level.toUpperCase()}`);
        }
        function getCustomLevels(baseVariable) {
          let customLevels;
          setCustomLevel("Low");
          setCustomLevel("Medium");
          setCustomLevel("High");
          return customLevels;
          function setCustomLevel(level) {
            const customLevel = getLevel(baseVariable, level);
            if (customLevel) {
              (customLevels || (customLevels = {}))[level] = Number(customLevel);
            }
          }
        }
        function setCustomLevels(baseVariable, levels) {
          const customLevels = getCustomLevels(baseVariable);
          if (customLevels) {
            setLevel("Low");
            setLevel("Medium");
            setLevel("High");
            return true;
          }
          return false;
          function setLevel(level) {
            levels[level] = customLevels[level] || levels[level];
          }
        }
        function getCustomPollingBasedLevels(baseVariable, defaultLevels) {
          const customLevels = getCustomLevels(baseVariable);
          return (pollingIntervalChanged || customLevels) && createPollingIntervalBasedLevels(customLevels ? __spreadValues(__spreadValues({}, defaultLevels), customLevels) : defaultLevels);
        }
      }
      function pollWatchedFileQueue(host, queue, pollIndex, chunkSize, callbackOnWatchFileStat) {
        let definedValueCopyToIndex = pollIndex;
        for (let canVisit = queue.length; chunkSize && canVisit; nextPollIndex(), canVisit--) {
          const watchedFile = queue[pollIndex];
          if (!watchedFile) {
            continue;
          } else if (watchedFile.isClosed) {
            queue[pollIndex] = void 0;
            continue;
          }
          chunkSize--;
          const fileChanged = onWatchedFileStat(watchedFile, getModifiedTime(host, watchedFile.fileName));
          if (watchedFile.isClosed) {
            queue[pollIndex] = void 0;
            continue;
          }
          callbackOnWatchFileStat == null ? void 0 : callbackOnWatchFileStat(watchedFile, pollIndex, fileChanged);
          if (queue[pollIndex]) {
            if (definedValueCopyToIndex < pollIndex) {
              queue[definedValueCopyToIndex] = watchedFile;
              queue[pollIndex] = void 0;
            }
            definedValueCopyToIndex++;
          }
        }
        return pollIndex;
        function nextPollIndex() {
          pollIndex++;
          if (pollIndex === queue.length) {
            if (definedValueCopyToIndex < pollIndex) {
              queue.length = definedValueCopyToIndex;
            }
            pollIndex = 0;
            definedValueCopyToIndex = 0;
          }
        }
      }
      function createDynamicPriorityPollingWatchFile(host) {
        const watchedFiles = [];
        const changedFilesInLastPoll = [];
        const lowPollingIntervalQueue = createPollingIntervalQueue(
          250
          /* Low */
        );
        const mediumPollingIntervalQueue = createPollingIntervalQueue(
          500
          /* Medium */
        );
        const highPollingIntervalQueue = createPollingIntervalQueue(
          2e3
          /* High */
        );
        return watchFile2;
        function watchFile2(fileName, callback, defaultPollingInterval) {
          const file = {
            fileName,
            callback,
            unchangedPolls: 0,
            mtime: getModifiedTime(host, fileName)
          };
          watchedFiles.push(file);
          addToPollingIntervalQueue(file, defaultPollingInterval);
          return {
            close: () => {
              file.isClosed = true;
              unorderedRemoveItem(watchedFiles, file);
            }
          };
        }
        function createPollingIntervalQueue(pollingInterval) {
          const queue = [];
          queue.pollingInterval = pollingInterval;
          queue.pollIndex = 0;
          queue.pollScheduled = false;
          return queue;
        }
        function pollPollingIntervalQueue(_timeoutType, queue) {
          queue.pollIndex = pollQueue(queue, queue.pollingInterval, queue.pollIndex, pollingChunkSize[queue.pollingInterval]);
          if (queue.length) {
            scheduleNextPoll(queue.pollingInterval);
          } else {
            Debug.assert(queue.pollIndex === 0);
            queue.pollScheduled = false;
          }
        }
        function pollLowPollingIntervalQueue(_timeoutType, queue) {
          pollQueue(
            changedFilesInLastPoll,
            250,
            /*pollIndex*/
            0,
            changedFilesInLastPoll.length
          );
          pollPollingIntervalQueue(_timeoutType, queue);
          if (!queue.pollScheduled && changedFilesInLastPoll.length) {
            scheduleNextPoll(
              250
              /* Low */
            );
          }
        }
        function pollQueue(queue, pollingInterval, pollIndex, chunkSize) {
          return pollWatchedFileQueue(
            host,
            queue,
            pollIndex,
            chunkSize,
            onWatchFileStat
          );
          function onWatchFileStat(watchedFile, pollIndex2, fileChanged) {
            if (fileChanged) {
              watchedFile.unchangedPolls = 0;
              if (queue !== changedFilesInLastPoll) {
                queue[pollIndex2] = void 0;
                addChangedFileToLowPollingIntervalQueue(watchedFile);
              }
            } else if (watchedFile.unchangedPolls !== unchangedPollThresholds[pollingInterval]) {
              watchedFile.unchangedPolls++;
            } else if (queue === changedFilesInLastPoll) {
              watchedFile.unchangedPolls = 1;
              queue[pollIndex2] = void 0;
              addToPollingIntervalQueue(
                watchedFile,
                250
                /* Low */
              );
            } else if (pollingInterval !== 2e3) {
              watchedFile.unchangedPolls++;
              queue[pollIndex2] = void 0;
              addToPollingIntervalQueue(
                watchedFile,
                pollingInterval === 250 ? 500 : 2e3
                /* High */
              );
            }
          }
        }
        function pollingIntervalQueue(pollingInterval) {
          switch (pollingInterval) {
            case 250:
              return lowPollingIntervalQueue;
            case 500:
              return mediumPollingIntervalQueue;
            case 2e3:
              return highPollingIntervalQueue;
          }
        }
        function addToPollingIntervalQueue(file, pollingInterval) {
          pollingIntervalQueue(pollingInterval).push(file);
          scheduleNextPollIfNotAlreadyScheduled(pollingInterval);
        }
        function addChangedFileToLowPollingIntervalQueue(file) {
          changedFilesInLastPoll.push(file);
          scheduleNextPollIfNotAlreadyScheduled(
            250
            /* Low */
          );
        }
        function scheduleNextPollIfNotAlreadyScheduled(pollingInterval) {
          if (!pollingIntervalQueue(pollingInterval).pollScheduled) {
            scheduleNextPoll(pollingInterval);
          }
        }
        function scheduleNextPoll(pollingInterval) {
          pollingIntervalQueue(pollingInterval).pollScheduled = host.setTimeout(pollingInterval === 250 ? pollLowPollingIntervalQueue : pollPollingIntervalQueue, pollingInterval, pollingInterval === 250 ? "pollLowPollingIntervalQueue" : "pollPollingIntervalQueue", pollingIntervalQueue(pollingInterval));
        }
      }
      function createUseFsEventsOnParentDirectoryWatchFile(fsWatch, useCaseSensitiveFileNames2) {
        const fileWatcherCallbacks = createMultiMap();
        const dirWatchers = /* @__PURE__ */ new Map();
        const toCanonicalName = createGetCanonicalFileName(useCaseSensitiveFileNames2);
        return nonPollingWatchFile;
        function nonPollingWatchFile(fileName, callback, _pollingInterval, fallbackOptions) {
          const filePath = toCanonicalName(fileName);
          fileWatcherCallbacks.add(filePath, callback);
          const dirPath = getDirectoryPath(filePath) || ".";
          const watcher = dirWatchers.get(dirPath) || createDirectoryWatcher(getDirectoryPath(fileName) || ".", dirPath, fallbackOptions);
          watcher.referenceCount++;
          return {
            close: () => {
              if (watcher.referenceCount === 1) {
                watcher.close();
                dirWatchers.delete(dirPath);
              } else {
                watcher.referenceCount--;
              }
              fileWatcherCallbacks.remove(filePath, callback);
            }
          };
        }
        function createDirectoryWatcher(dirName, dirPath, fallbackOptions) {
          const watcher = fsWatch(
            dirName,
            1,
            (_eventName, relativeFileName, modifiedTime) => {
              if (!isString(relativeFileName))
                return;
              const fileName = getNormalizedAbsolutePath(relativeFileName, dirName);
              const callbacks = fileName && fileWatcherCallbacks.get(toCanonicalName(fileName));
              if (callbacks) {
                for (const fileCallback of callbacks) {
                  fileCallback(fileName, 1, modifiedTime);
                }
              }
            },
            /*recursive*/
            false,
            500,
            fallbackOptions
          );
          watcher.referenceCount = 0;
          dirWatchers.set(dirPath, watcher);
          return watcher;
        }
      }
      function createFixedChunkSizePollingWatchFile(host) {
        const watchedFiles = [];
        let pollIndex = 0;
        let pollScheduled;
        return watchFile2;
        function watchFile2(fileName, callback) {
          const file = {
            fileName,
            callback,
            mtime: getModifiedTime(host, fileName)
          };
          watchedFiles.push(file);
          scheduleNextPoll();
          return {
            close: () => {
              file.isClosed = true;
              unorderedRemoveItem(watchedFiles, file);
            }
          };
        }
        function pollQueue() {
          pollScheduled = void 0;
          pollIndex = pollWatchedFileQueue(host, watchedFiles, pollIndex, pollingChunkSize[
            250
            /* Low */
          ]);
          scheduleNextPoll();
        }
        function scheduleNextPoll() {
          if (!watchedFiles.length || pollScheduled)
            return;
          pollScheduled = host.setTimeout(pollQueue, 2e3, "pollQueue");
        }
      }
      function createSingleWatcherPerName(cache, useCaseSensitiveFileNames2, name, callback, createWatcher) {
        const toCanonicalFileName = createGetCanonicalFileName(useCaseSensitiveFileNames2);
        const path = toCanonicalFileName(name);
        const existing = cache.get(path);
        if (existing) {
          existing.callbacks.push(callback);
        } else {
          cache.set(path, {
            watcher: createWatcher(
              // Cant infer types correctly so lets satisfy checker
              (param1, param2, param3) => {
                var _a;
                return (_a = cache.get(path)) == null ? void 0 : _a.callbacks.slice().forEach((cb) => cb(param1, param2, param3));
              }
            ),
            callbacks: [callback]
          });
        }
        return {
          close: () => {
            const watcher = cache.get(path);
            if (!watcher)
              return;
            if (!orderedRemoveItem(watcher.callbacks, callback) || watcher.callbacks.length)
              return;
            cache.delete(path);
            closeFileWatcherOf(watcher);
          }
        };
      }
      function onWatchedFileStat(watchedFile, modifiedTime) {
        const oldTime = watchedFile.mtime.getTime();
        const newTime = modifiedTime.getTime();
        if (oldTime !== newTime) {
          watchedFile.mtime = modifiedTime;
          watchedFile.callback(watchedFile.fileName, getFileWatcherEventKind(oldTime, newTime), modifiedTime);
          return true;
        }
        return false;
      }
      function getFileWatcherEventKind(oldTime, newTime) {
        return oldTime === 0 ? 0 : newTime === 0 ? 2 : 1;
      }
      function sysLog(s) {
        return curSysLog(s);
      }
      function setSysLog(logger) {
        curSysLog = logger;
      }
      function createDirectoryWatcherSupportingRecursive({
        watchDirectory,
        useCaseSensitiveFileNames: useCaseSensitiveFileNames2,
        getCurrentDirectory,
        getAccessibleSortedChildDirectories,
        fileSystemEntryExists,
        realpath,
        setTimeout: setTimeout2,
        clearTimeout: clearTimeout2
      }) {
        const cache = /* @__PURE__ */ new Map();
        const callbackCache = createMultiMap();
        const cacheToUpdateChildWatches = /* @__PURE__ */ new Map();
        let timerToUpdateChildWatches;
        const filePathComparer = getStringComparer(!useCaseSensitiveFileNames2);
        const toCanonicalFilePath = createGetCanonicalFileName(useCaseSensitiveFileNames2);
        return (dirName, callback, recursive, options2) => recursive ? createDirectoryWatcher(dirName, options2, callback) : watchDirectory(dirName, callback, recursive, options2);
        function createDirectoryWatcher(dirName, options2, callback) {
          const dirPath = toCanonicalFilePath(dirName);
          let directoryWatcher = cache.get(dirPath);
          if (directoryWatcher) {
            directoryWatcher.refCount++;
          } else {
            directoryWatcher = {
              watcher: watchDirectory(
                dirName,
                (fileName) => {
                  if (isIgnoredPath(fileName, options2))
                    return;
                  if (options2 == null ? void 0 : options2.synchronousWatchDirectory) {
                    invokeCallbacks(dirPath, fileName);
                    updateChildWatches(dirName, dirPath, options2);
                  } else {
                    nonSyncUpdateChildWatches(dirName, dirPath, fileName, options2);
                  }
                },
                /*recursive*/
                false,
                options2
              ),
              refCount: 1,
              childWatches: emptyArray
            };
            cache.set(dirPath, directoryWatcher);
            updateChildWatches(dirName, dirPath, options2);
          }
          const callbackToAdd = callback && { dirName, callback };
          if (callbackToAdd) {
            callbackCache.add(dirPath, callbackToAdd);
          }
          return {
            dirName,
            close: () => {
              const directoryWatcher2 = Debug.checkDefined(cache.get(dirPath));
              if (callbackToAdd)
                callbackCache.remove(dirPath, callbackToAdd);
              directoryWatcher2.refCount--;
              if (directoryWatcher2.refCount)
                return;
              cache.delete(dirPath);
              closeFileWatcherOf(directoryWatcher2);
              directoryWatcher2.childWatches.forEach(closeFileWatcher);
            }
          };
        }
        function invokeCallbacks(dirPath, fileNameOrInvokeMap, fileNames) {
          let fileName;
          let invokeMap;
          if (isString(fileNameOrInvokeMap)) {
            fileName = fileNameOrInvokeMap;
          } else {
            invokeMap = fileNameOrInvokeMap;
          }
          callbackCache.forEach((callbacks, rootDirName) => {
            if (invokeMap && invokeMap.get(rootDirName) === true)
              return;
            if (rootDirName === dirPath || startsWith(dirPath, rootDirName) && dirPath[rootDirName.length] === directorySeparator) {
              if (invokeMap) {
                if (fileNames) {
                  const existing = invokeMap.get(rootDirName);
                  if (existing) {
                    existing.push(...fileNames);
                  } else {
                    invokeMap.set(rootDirName, fileNames.slice());
                  }
                } else {
                  invokeMap.set(rootDirName, true);
                }
              } else {
                callbacks.forEach(({ callback }) => callback(fileName));
              }
            }
          });
        }
        function nonSyncUpdateChildWatches(dirName, dirPath, fileName, options2) {
          const parentWatcher = cache.get(dirPath);
          if (parentWatcher && fileSystemEntryExists(
            dirName,
            1
            /* Directory */
          )) {
            scheduleUpdateChildWatches(dirName, dirPath, fileName, options2);
            return;
          }
          invokeCallbacks(dirPath, fileName);
          removeChildWatches(parentWatcher);
        }
        function scheduleUpdateChildWatches(dirName, dirPath, fileName, options2) {
          const existing = cacheToUpdateChildWatches.get(dirPath);
          if (existing) {
            existing.fileNames.push(fileName);
          } else {
            cacheToUpdateChildWatches.set(dirPath, { dirName, options: options2, fileNames: [fileName] });
          }
          if (timerToUpdateChildWatches) {
            clearTimeout2(timerToUpdateChildWatches);
            timerToUpdateChildWatches = void 0;
          }
          timerToUpdateChildWatches = setTimeout2(onTimerToUpdateChildWatches, 1e3, "timerToUpdateChildWatches");
        }
        function onTimerToUpdateChildWatches() {
          timerToUpdateChildWatches = void 0;
          sysLog(`sysLog:: onTimerToUpdateChildWatches:: ${cacheToUpdateChildWatches.size}`);
          const start = timestamp();
          const invokeMap = /* @__PURE__ */ new Map();
          while (!timerToUpdateChildWatches && cacheToUpdateChildWatches.size) {
            const result = cacheToUpdateChildWatches.entries().next();
            Debug.assert(!result.done);
            const { value: [dirPath, { dirName, options: options2, fileNames }] } = result;
            cacheToUpdateChildWatches.delete(dirPath);
            const hasChanges = updateChildWatches(dirName, dirPath, options2);
            invokeCallbacks(dirPath, invokeMap, hasChanges ? void 0 : fileNames);
          }
          sysLog(`sysLog:: invokingWatchers:: Elapsed:: ${timestamp() - start}ms:: ${cacheToUpdateChildWatches.size}`);
          callbackCache.forEach((callbacks, rootDirName) => {
            const existing = invokeMap.get(rootDirName);
            if (existing) {
              callbacks.forEach(({ callback, dirName }) => {
                if (isArray(existing)) {
                  existing.forEach(callback);
                } else {
                  callback(dirName);
                }
              });
            }
          });
          const elapsed = timestamp() - start;
          sysLog(`sysLog:: Elapsed:: ${elapsed}ms:: onTimerToUpdateChildWatches:: ${cacheToUpdateChildWatches.size} ${timerToUpdateChildWatches}`);
        }
        function removeChildWatches(parentWatcher) {
          if (!parentWatcher)
            return;
          const existingChildWatches = parentWatcher.childWatches;
          parentWatcher.childWatches = emptyArray;
          for (const childWatcher of existingChildWatches) {
            childWatcher.close();
            removeChildWatches(cache.get(toCanonicalFilePath(childWatcher.dirName)));
          }
        }
        function updateChildWatches(parentDir, parentDirPath, options2) {
          const parentWatcher = cache.get(parentDirPath);
          if (!parentWatcher)
            return false;
          let newChildWatches;
          const hasChanges = enumerateInsertsAndDeletes(
            fileSystemEntryExists(
              parentDir,
              1
              /* Directory */
            ) ? mapDefined(getAccessibleSortedChildDirectories(parentDir), (child) => {
              const childFullName = getNormalizedAbsolutePath(child, parentDir);
              return !isIgnoredPath(childFullName, options2) && filePathComparer(childFullName, normalizePath(realpath(childFullName))) === 0 ? childFullName : void 0;
            }) : emptyArray,
            parentWatcher.childWatches,
            (child, childWatcher) => filePathComparer(child, childWatcher.dirName),
            createAndAddChildDirectoryWatcher,
            closeFileWatcher,
            addChildDirectoryWatcher
          );
          parentWatcher.childWatches = newChildWatches || emptyArray;
          return hasChanges;
          function createAndAddChildDirectoryWatcher(childName) {
            const result = createDirectoryWatcher(childName, options2);
            addChildDirectoryWatcher(result);
          }
          function addChildDirectoryWatcher(childWatcher) {
            (newChildWatches || (newChildWatches = [])).push(childWatcher);
          }
        }
        function isIgnoredPath(path, options2) {
          return some(ignoredPaths, (searchPath) => isInPath(path, searchPath)) || isIgnoredByWatchOptions(path, options2, useCaseSensitiveFileNames2, getCurrentDirectory);
        }
        function isInPath(path, searchPath) {
          if (path.includes(searchPath))
            return true;
          if (useCaseSensitiveFileNames2)
            return false;
          return toCanonicalFilePath(path).includes(searchPath);
        }
      }
      function createFileWatcherCallback(callback) {
        return (_fileName, eventKind, modifiedTime) => callback(eventKind === 1 ? "change" : "rename", "", modifiedTime);
      }
      function createFsWatchCallbackForFileWatcherCallback(fileName, callback, getModifiedTime3) {
        return (eventName, _relativeFileName, modifiedTime) => {
          if (eventName === "rename") {
            modifiedTime || (modifiedTime = getModifiedTime3(fileName) || missingFileModifiedTime);
            callback(fileName, modifiedTime !== missingFileModifiedTime ? 0 : 2, modifiedTime);
          } else {
            callback(fileName, 1, modifiedTime);
          }
        };
      }
      function isIgnoredByWatchOptions(pathToCheck, options2, useCaseSensitiveFileNames2, getCurrentDirectory) {
        return ((options2 == null ? void 0 : options2.excludeDirectories) || (options2 == null ? void 0 : options2.excludeFiles)) && (matchesExclude(pathToCheck, options2 == null ? void 0 : options2.excludeFiles, useCaseSensitiveFileNames2, getCurrentDirectory()) || matchesExclude(pathToCheck, options2 == null ? void 0 : options2.excludeDirectories, useCaseSensitiveFileNames2, getCurrentDirectory()));
      }
      function createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback, options2, useCaseSensitiveFileNames2, getCurrentDirectory) {
        return (eventName, relativeFileName) => {
          if (eventName === "rename") {
            const fileName = !relativeFileName ? directoryName : normalizePath(combinePaths(directoryName, relativeFileName));
            if (!relativeFileName || !isIgnoredByWatchOptions(fileName, options2, useCaseSensitiveFileNames2, getCurrentDirectory)) {
              callback(fileName);
            }
          }
        };
      }
      function createSystemWatchFunctions({
        pollingWatchFileWorker,
        getModifiedTime: getModifiedTime3,
        setTimeout: setTimeout2,
        clearTimeout: clearTimeout2,
        fsWatchWorker,
        fileSystemEntryExists,
        useCaseSensitiveFileNames: useCaseSensitiveFileNames2,
        getCurrentDirectory,
        fsSupportsRecursiveFsWatch,
        getAccessibleSortedChildDirectories,
        realpath,
        tscWatchFile,
        useNonPollingWatchers,
        tscWatchDirectory,
        inodeWatching,
        sysLog: sysLog2
      }) {
        const pollingWatches = /* @__PURE__ */ new Map();
        const fsWatches = /* @__PURE__ */ new Map();
        const fsWatchesRecursive = /* @__PURE__ */ new Map();
        let dynamicPollingWatchFile;
        let fixedChunkSizePollingWatchFile;
        let nonPollingWatchFile;
        let hostRecursiveDirectoryWatcher;
        let hitSystemWatcherLimit = false;
        return {
          watchFile: watchFile2,
          watchDirectory
        };
        function watchFile2(fileName, callback, pollingInterval, options2) {
          options2 = updateOptionsForWatchFile(options2, useNonPollingWatchers);
          const watchFileKind = Debug.checkDefined(options2.watchFile);
          switch (watchFileKind) {
            case 0:
              return pollingWatchFile(
                fileName,
                callback,
                250,
                /*options*/
                void 0
              );
            case 1:
              return pollingWatchFile(
                fileName,
                callback,
                pollingInterval,
                /*options*/
                void 0
              );
            case 2:
              return ensureDynamicPollingWatchFile()(
                fileName,
                callback,
                pollingInterval,
                /*options*/
                void 0
              );
            case 3:
              return ensureFixedChunkSizePollingWatchFile()(
                fileName,
                callback,
                /* pollingInterval */
                void 0,
                /*options*/
                void 0
              );
            case 4:
              return fsWatch(
                fileName,
                0,
                createFsWatchCallbackForFileWatcherCallback(fileName, callback, getModifiedTime3),
                /*recursive*/
                false,
                pollingInterval,
                getFallbackOptions(options2)
              );
            case 5:
              if (!nonPollingWatchFile) {
                nonPollingWatchFile = createUseFsEventsOnParentDirectoryWatchFile(fsWatch, useCaseSensitiveFileNames2);
              }
              return nonPollingWatchFile(fileName, callback, pollingInterval, getFallbackOptions(options2));
            default:
              Debug.assertNever(watchFileKind);
          }
        }
        function ensureDynamicPollingWatchFile() {
          return dynamicPollingWatchFile || (dynamicPollingWatchFile = createDynamicPriorityPollingWatchFile({ getModifiedTime: getModifiedTime3, setTimeout: setTimeout2 }));
        }
        function ensureFixedChunkSizePollingWatchFile() {
          return fixedChunkSizePollingWatchFile || (fixedChunkSizePollingWatchFile = createFixedChunkSizePollingWatchFile({ getModifiedTime: getModifiedTime3, setTimeout: setTimeout2 }));
        }
        function updateOptionsForWatchFile(options2, useNonPollingWatchers2) {
          if (options2 && options2.watchFile !== void 0)
            return options2;
          switch (tscWatchFile) {
            case "PriorityPollingInterval":
              return {
                watchFile: 1
                /* PriorityPollingInterval */
              };
            case "DynamicPriorityPolling":
              return {
                watchFile: 2
                /* DynamicPriorityPolling */
              };
            case "UseFsEvents":
              return generateWatchFileOptions(4, 1, options2);
            case "UseFsEventsWithFallbackDynamicPolling":
              return generateWatchFileOptions(4, 2, options2);
            case "UseFsEventsOnParentDirectory":
              useNonPollingWatchers2 = true;
            default:
              return useNonPollingWatchers2 ? (
                // Use notifications from FS to watch with falling back to fs.watchFile
                generateWatchFileOptions(5, 1, options2)
              ) : (
                // Default to using fs events
                {
                  watchFile: 4
                  /* UseFsEvents */
                }
              );
          }
        }
        function generateWatchFileOptions(watchFile3, fallbackPolling, options2) {
          const defaultFallbackPolling = options2 == null ? void 0 : options2.fallbackPolling;
          return {
            watchFile: watchFile3,
            fallbackPolling: defaultFallbackPolling === void 0 ? fallbackPolling : defaultFallbackPolling
          };
        }
        function watchDirectory(directoryName, callback, recursive, options2) {
          if (fsSupportsRecursiveFsWatch) {
            return fsWatch(
              directoryName,
              1,
              createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback, options2, useCaseSensitiveFileNames2, getCurrentDirectory),
              recursive,
              500,
              getFallbackOptions(options2)
            );
          }
          if (!hostRecursiveDirectoryWatcher) {
            hostRecursiveDirectoryWatcher = createDirectoryWatcherSupportingRecursive({
              useCaseSensitiveFileNames: useCaseSensitiveFileNames2,
              getCurrentDirectory,
              fileSystemEntryExists,
              getAccessibleSortedChildDirectories,
              watchDirectory: nonRecursiveWatchDirectory,
              realpath,
              setTimeout: setTimeout2,
              clearTimeout: clearTimeout2
            });
          }
          return hostRecursiveDirectoryWatcher(directoryName, callback, recursive, options2);
        }
        function nonRecursiveWatchDirectory(directoryName, callback, recursive, options2) {
          Debug.assert(!recursive);
          const watchDirectoryOptions = updateOptionsForWatchDirectory(options2);
          const watchDirectoryKind = Debug.checkDefined(watchDirectoryOptions.watchDirectory);
          switch (watchDirectoryKind) {
            case 1:
              return pollingWatchFile(
                directoryName,
                () => callback(directoryName),
                500,
                /*options*/
                void 0
              );
            case 2:
              return ensureDynamicPollingWatchFile()(
                directoryName,
                () => callback(directoryName),
                500,
                /*options*/
                void 0
              );
            case 3:
              return ensureFixedChunkSizePollingWatchFile()(
                directoryName,
                () => callback(directoryName),
                /* pollingInterval */
                void 0,
                /*options*/
                void 0
              );
            case 0:
              return fsWatch(
                directoryName,
                1,
                createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback, options2, useCaseSensitiveFileNames2, getCurrentDirectory),
                recursive,
                500,
                getFallbackOptions(watchDirectoryOptions)
              );
            default:
              Debug.assertNever(watchDirectoryKind);
          }
        }
        function updateOptionsForWatchDirectory(options2) {
          if (options2 && options2.watchDirectory !== void 0)
            return options2;
          switch (tscWatchDirectory) {
            case "RecursiveDirectoryUsingFsWatchFile":
              return {
                watchDirectory: 1
                /* FixedPollingInterval */
              };
            case "RecursiveDirectoryUsingDynamicPriorityPolling":
              return {
                watchDirectory: 2
                /* DynamicPriorityPolling */
              };
            default:
              const defaultFallbackPolling = options2 == null ? void 0 : options2.fallbackPolling;
              return {
                watchDirectory: 0,
                fallbackPolling: defaultFallbackPolling !== void 0 ? defaultFallbackPolling : void 0
              };
          }
        }
        function pollingWatchFile(fileName, callback, pollingInterval, options2) {
          return createSingleWatcherPerName(
            pollingWatches,
            useCaseSensitiveFileNames2,
            fileName,
            callback,
            (cb) => pollingWatchFileWorker(fileName, cb, pollingInterval, options2)
          );
        }
        function fsWatch(fileOrDirectory, entryKind, callback, recursive, fallbackPollingInterval, fallbackOptions) {
          return createSingleWatcherPerName(
            recursive ? fsWatchesRecursive : fsWatches,
            useCaseSensitiveFileNames2,
            fileOrDirectory,
            callback,
            (cb) => fsWatchHandlingExistenceOnHost(fileOrDirectory, entryKind, cb, recursive, fallbackPollingInterval, fallbackOptions)
          );
        }
        function fsWatchHandlingExistenceOnHost(fileOrDirectory, entryKind, callback, recursive, fallbackPollingInterval, fallbackOptions) {
          let lastDirectoryPartWithDirectorySeparator;
          let lastDirectoryPart;
          if (inodeWatching) {
            lastDirectoryPartWithDirectorySeparator = fileOrDirectory.substring(fileOrDirectory.lastIndexOf(directorySeparator));
            lastDirectoryPart = lastDirectoryPartWithDirectorySeparator.slice(directorySeparator.length);
          }
          let watcher = !fileSystemEntryExists(fileOrDirectory, entryKind) ? watchMissingFileSystemEntry() : watchPresentFileSystemEntry();
          return {
            close: () => {
              if (watcher) {
                watcher.close();
                watcher = void 0;
              }
            }
          };
          function updateWatcher(createWatcher) {
            if (watcher) {
              sysLog2(`sysLog:: ${fileOrDirectory}:: Changing watcher to ${createWatcher === watchPresentFileSystemEntry ? "Present" : "Missing"}FileSystemEntryWatcher`);
              watcher.close();
              watcher = createWatcher();
            }
          }
          function watchPresentFileSystemEntry() {
            if (hitSystemWatcherLimit) {
              sysLog2(`sysLog:: ${fileOrDirectory}:: Defaulting to watchFile`);
              return watchPresentFileSystemEntryWithFsWatchFile();
            }
            try {
              const presentWatcher = fsWatchWorker(
                fileOrDirectory,
                recursive,
                inodeWatching ? callbackChangingToMissingFileSystemEntry : callback
              );
              presentWatcher.on("error", () => {
                callback("rename", "");
                updateWatcher(watchMissingFileSystemEntry);
              });
              return presentWatcher;
            } catch (e) {
              hitSystemWatcherLimit || (hitSystemWatcherLimit = e.code === "ENOSPC");
              sysLog2(`sysLog:: ${fileOrDirectory}:: Changing to watchFile`);
              return watchPresentFileSystemEntryWithFsWatchFile();
            }
          }
          function callbackChangingToMissingFileSystemEntry(event, relativeName) {
            let originalRelativeName;
            if (relativeName && endsWith(relativeName, "~")) {
              originalRelativeName = relativeName;
              relativeName = relativeName.slice(0, relativeName.length - 1);
            }
            if (event === "rename" && (!relativeName || relativeName === lastDirectoryPart || endsWith(relativeName, lastDirectoryPartWithDirectorySeparator))) {
              const modifiedTime = getModifiedTime3(fileOrDirectory) || missingFileModifiedTime;
              if (originalRelativeName)
                callback(event, originalRelativeName, modifiedTime);
              callback(event, relativeName, modifiedTime);
              if (inodeWatching) {
                updateWatcher(modifiedTime === missingFileModifiedTime ? watchMissingFileSystemEntry : watchPresentFileSystemEntry);
              } else if (modifiedTime === missingFileModifiedTime) {
                updateWatcher(watchMissingFileSystemEntry);
              }
            } else {
              if (originalRelativeName)
                callback(event, originalRelativeName);
              callback(event, relativeName);
            }
          }
          function watchPresentFileSystemEntryWithFsWatchFile() {
            return watchFile2(
              fileOrDirectory,
              createFileWatcherCallback(callback),
              fallbackPollingInterval,
              fallbackOptions
            );
          }
          function watchMissingFileSystemEntry() {
            return watchFile2(
              fileOrDirectory,
              (_fileName, eventKind, modifiedTime) => {
                if (eventKind === 0) {
                  modifiedTime || (modifiedTime = getModifiedTime3(fileOrDirectory) || missingFileModifiedTime);
                  if (modifiedTime !== missingFileModifiedTime) {
                    callback("rename", "", modifiedTime);
                    updateWatcher(watchPresentFileSystemEntry);
                  }
                }
              },
              fallbackPollingInterval,
              fallbackOptions
            );
          }
        }
      }
      function patchWriteFileEnsuringDirectory(sys2) {
        const originalWriteFile = sys2.writeFile;
        sys2.writeFile = (path, data, writeBom) => writeFileEnsuringDirectories(
          path,
          data,
          !!writeBom,
          (path2, data2, writeByteOrderMark) => originalWriteFile.call(sys2, path2, data2, writeByteOrderMark),
          (path2) => sys2.createDirectory(path2),
          (path2) => sys2.directoryExists(path2)
        );
      }
      function setSys(s) {
        sys = s;
      }
      var FileWatcherEventKind, PollingInterval, missingFileModifiedTime, defaultChunkLevels, pollingChunkSize, unchangedPollThresholds, ignoredPaths, curSysLog, FileSystemEntryKind, sys;
      var init_sys = __esm({
        "src/compiler/sys.ts"() {
          "use strict";
          init_ts2();
          FileWatcherEventKind = ((FileWatcherEventKind2) => {
            FileWatcherEventKind2[FileWatcherEventKind2["Created"] = 0] = "Created";
            FileWatcherEventKind2[FileWatcherEventKind2["Changed"] = 1] = "Changed";
            FileWatcherEventKind2[FileWatcherEventKind2["Deleted"] = 2] = "Deleted";
            return FileWatcherEventKind2;
          })(FileWatcherEventKind || {});
          PollingInterval = ((PollingInterval3) => {
            PollingInterval3[PollingInterval3["High"] = 2e3] = "High";
            PollingInterval3[PollingInterval3["Medium"] = 500] = "Medium";
            PollingInterval3[PollingInterval3["Low"] = 250] = "Low";
            return PollingInterval3;
          })(PollingInterval || {});
          missingFileModifiedTime = /* @__PURE__ */ new Date(0);
          defaultChunkLevels = { Low: 32, Medium: 64, High: 256 };
          pollingChunkSize = createPollingIntervalBasedLevels(defaultChunkLevels);
          unchangedPollThresholds = createPollingIntervalBasedLevels(defaultChunkLevels);
          ignoredPaths = ["/node_modules/.", "/.git", "/.#"];
          curSysLog = noop;
          FileSystemEntryKind = ((FileSystemEntryKind2) => {
            FileSystemEntryKind2[FileSystemEntryKind2["File"] = 0] = "File";
            FileSystemEntryKind2[FileSystemEntryKind2["Directory"] = 1] = "Directory";
            return FileSystemEntryKind2;
          })(FileSystemEntryKind || {});
          sys = (() => {
            const byteOrderMarkIndicator = "\uFEFF";
            function getNodeSystem() {
              const nativePattern = /^native |^\([^)]+\)$|^(internal[\\/]|[a-zA-Z0-9_\s]+(\.js)?$)/;
              const _fs = require("fs");
              const _path = require("path");
              const _os = require("os");
              let _crypto;
              try {
                _crypto = require("crypto");
              } catch (e) {
                _crypto = void 0;
              }
              let activeSession;
              let profilePath = "./profile.cpuprofile";
              const Buffer2 = require("buffer").Buffer;
              const isLinuxOrMacOs = process.platform === "linux" || process.platform === "darwin";
              const platform = _os.platform();
              const useCaseSensitiveFileNames2 = isFileSystemCaseSensitive();
              const fsRealpath = !!_fs.realpathSync.native ? process.platform === "win32" ? fsRealPathHandlingLongPath : _fs.realpathSync.native : _fs.realpathSync;
              const executingFilePath = __filename.endsWith("sys.js") ? _path.join(_path.dirname(__dirname), "__fake__.js") : __filename;
              const fsSupportsRecursiveFsWatch = process.platform === "win32" || process.platform === "darwin";
              const getCurrentDirectory = memoize(() => process.cwd());
              const { watchFile: watchFile2, watchDirectory } = createSystemWatchFunctions({
                pollingWatchFileWorker: fsWatchFileWorker,
                getModifiedTime: getModifiedTime3,
                setTimeout,
                clearTimeout,
                fsWatchWorker,
                useCaseSensitiveFileNames: useCaseSensitiveFileNames2,
                getCurrentDirectory,
                fileSystemEntryExists,
                // Node 4.0 `fs.watch` function supports the "recursive" option on both OSX and Windows
                // (ref: https://github.com/nodejs/node/pull/2649 and https://github.com/Microsoft/TypeScript/issues/4643)
                fsSupportsRecursiveFsWatch,
                getAccessibleSortedChildDirectories: (path) => getAccessibleFileSystemEntries(path).directories,
                realpath,
                tscWatchFile: process.env.TSC_WATCHFILE,
                useNonPollingWatchers: !!process.env.TSC_NONPOLLING_WATCHER,
                tscWatchDirectory: process.env.TSC_WATCHDIRECTORY,
                inodeWatching: isLinuxOrMacOs,
                sysLog
              });
              const nodeSystem = {
                args: process.argv.slice(2),
                newLine: _os.EOL,
                useCaseSensitiveFileNames: useCaseSensitiveFileNames2,
                write(s) {
                  process.stdout.write(s);
                },
                getWidthOfTerminal() {
                  return process.stdout.columns;
                },
                writeOutputIsTTY() {
                  return process.stdout.isTTY;
                },
                readFile,
                writeFile: writeFile2,
                watchFile: watchFile2,
                watchDirectory,
                resolvePath: (path) => _path.resolve(path),
                fileExists,
                directoryExists,
                createDirectory(directoryName) {
                  if (!nodeSystem.directoryExists(directoryName)) {
                    try {
                      _fs.mkdirSync(directoryName);
                    } catch (e) {
                      if (e.code !== "EEXIST") {
                        throw e;
                      }
                    }
                  }
                },
                getExecutingFilePath() {
                  return executingFilePath;
                },
                getCurrentDirectory,
                getDirectories,
                getEnvironmentVariable(name) {
                  return process.env[name] || "";
                },
                readDirectory,
                getModifiedTime: getModifiedTime3,
                setModifiedTime,
                deleteFile,
                createHash: _crypto ? createSHA256Hash : generateDjb2Hash,
                createSHA256Hash: _crypto ? createSHA256Hash : void 0,
                getMemoryUsage() {
                  if (global.gc) {
                    global.gc();
                  }
                  return process.memoryUsage().heapUsed;
                },
                getFileSize(path) {
                  try {
                    const stat = statSync(path);
                    if (stat == null ? void 0 : stat.isFile()) {
                      return stat.size;
                    }
                  } catch (e) {
                  }
                  return 0;
                },
                exit(exitCode) {
                  disableCPUProfiler(() => process.exit(exitCode));
                },
                enableCPUProfiler,
                disableCPUProfiler,
                cpuProfilingEnabled: () => !!activeSession || contains(process.execArgv, "--cpu-prof") || contains(process.execArgv, "--prof"),
                realpath,
                debugMode: !!process.env.NODE_INSPECTOR_IPC || !!process.env.VSCODE_INSPECTOR_OPTIONS || some(process.execArgv, (arg) => /^--(inspect|debug)(-brk)?(=\d+)?$/i.test(arg)) || !!process.recordreplay,
                tryEnableSourceMapsForHost() {
                  try {
                    require_source_map_support().install();
                  } catch (e) {
                  }
                },
                setTimeout,
                clearTimeout,
                clearScreen: () => {
                  process.stdout.write("\x1Bc");
                },
                setBlocking: () => {
                  var _a;
                  const handle = (_a = process.stdout) == null ? void 0 : _a._handle;
                  if (handle && handle.setBlocking) {
                    handle.setBlocking(true);
                  }
                },
                bufferFrom,
                base64decode: (input) => bufferFrom(input, "base64").toString("utf8"),
                base64encode: (input) => bufferFrom(input).toString("base64"),
                require: (baseDir, moduleName) => {
                  try {
                    const modulePath = resolveJSModule(moduleName, baseDir, nodeSystem);
                    return { module: require(modulePath), modulePath, error: void 0 };
                  } catch (error2) {
                    return { module: void 0, modulePath: void 0, error: error2 };
                  }
                }
              };
              return nodeSystem;
              function statSync(path) {
                return _fs.statSync(path, { throwIfNoEntry: false });
              }
              function enableCPUProfiler(path, cb) {
                if (activeSession) {
                  cb();
                  return false;
                }
                const inspector = require("inspector");
                if (!inspector || !inspector.Session) {
                  cb();
                  return false;
                }
                const session = new inspector.Session();
                session.connect();
                session.post("Profiler.enable", () => {
                  session.post("Profiler.start", () => {
                    activeSession = session;
                    profilePath = path;
                    cb();
                  });
                });
                return true;
              }
              function cleanupPaths(profile) {
                let externalFileCounter = 0;
                const remappedPaths = /* @__PURE__ */ new Map();
                const normalizedDir = normalizeSlashes(_path.dirname(executingFilePath));
                const fileUrlRoot = `file://${getRootLength(normalizedDir) === 1 ? "" : "/"}${normalizedDir}`;
                for (const node of profile.nodes) {
                  if (node.callFrame.url) {
                    const url = normalizeSlashes(node.callFrame.url);
                    if (containsPath(fileUrlRoot, url, useCaseSensitiveFileNames2)) {
                      node.callFrame.url = getRelativePathToDirectoryOrUrl(
                        fileUrlRoot,
                        url,
                        fileUrlRoot,
                        createGetCanonicalFileName(useCaseSensitiveFileNames2),
                        /*isAbsolutePathAnUrl*/
                        true
                      );
                    } else if (!nativePattern.test(url)) {
                      node.callFrame.url = (remappedPaths.has(url) ? remappedPaths : remappedPaths.set(url, `external${externalFileCounter}.js`)).get(url);
                      externalFileCounter++;
                    }
                  }
                }
                return profile;
              }
              function disableCPUProfiler(cb) {
                if (activeSession && activeSession !== "stopping") {
                  const s = activeSession;
                  activeSession.post("Profiler.stop", (err, { profile }) => {
                    var _a;
                    if (!err) {
                      try {
                        if ((_a = statSync(profilePath)) == null ? void 0 : _a.isDirectory()) {
                          profilePath = _path.join(profilePath, `${(/* @__PURE__ */ new Date()).toISOString().replace(/:/g, "-")}+P${process.pid}.cpuprofile`);
                        }
                      } catch (e) {
                      }
                      try {
                        _fs.mkdirSync(_path.dirname(profilePath), { recursive: true });
                      } catch (e) {
                      }
                      _fs.writeFileSync(profilePath, JSON.stringify(cleanupPaths(profile)));
                    }
                    activeSession = void 0;
                    s.disconnect();
                    cb();
                  });
                  activeSession = "stopping";
                  return true;
                } else {
                  cb();
                  return false;
                }
              }
              function bufferFrom(input, encoding) {
                return Buffer2.from && Buffer2.from !== Int8Array.from ? Buffer2.from(input, encoding) : new Buffer2(input, encoding);
              }
              function isFileSystemCaseSensitive() {
                if (platform === "win32" || platform === "win64") {
                  return false;
                }
                return !fileExists(swapCase(__filename));
              }
              function swapCase(s) {
                return s.replace(/\w/g, (ch) => {
                  const up = ch.toUpperCase();
                  return ch === up ? ch.toLowerCase() : up;
                });
              }
              function fsWatchFileWorker(fileName, callback, pollingInterval) {
                _fs.watchFile(fileName, { persistent: true, interval: pollingInterval }, fileChanged);
                let eventKind;
                return {
                  close: () => _fs.unwatchFile(fileName, fileChanged)
                };
                function fileChanged(curr, prev) {
                  const isPreviouslyDeleted = +prev.mtime === 0 || eventKind === 2;
                  if (+curr.mtime === 0) {
                    if (isPreviouslyDeleted) {
                      return;
                    }
                    eventKind = 2;
                  } else if (isPreviouslyDeleted) {
                    eventKind = 0;
                  } else if (+curr.mtime === +prev.mtime) {
                    return;
                  } else {
                    eventKind = 1;
                  }
                  callback(fileName, eventKind, curr.mtime);
                }
              }
              function fsWatchWorker(fileOrDirectory, recursive, callback) {
                return _fs.watch(
                  fileOrDirectory,
                  fsSupportsRecursiveFsWatch ? { persistent: true, recursive: !!recursive } : { persistent: true },
                  callback
                );
              }
              function readFileWorker(fileName, _encoding) {
                let buffer;
                try {
                  buffer = _fs.readFileSync(fileName);
                } catch (e) {
                  return void 0;
                }
                let len = buffer.length;
                if (len >= 2 && buffer[0] === 254 && buffer[1] === 255) {
                  len &= ~1;
                  for (let i = 0; i < len; i += 2) {
                    const temp = buffer[i];
                    buffer[i] = buffer[i + 1];
                    buffer[i + 1] = temp;
                  }
                  return buffer.toString("utf16le", 2);
                }
                if (len >= 2 && buffer[0] === 255 && buffer[1] === 254) {
                  return buffer.toString("utf16le", 2);
                }
                if (len >= 3 && buffer[0] === 239 && buffer[1] === 187 && buffer[2] === 191) {
                  return buffer.toString("utf8", 3);
                }
                return buffer.toString("utf8");
              }
              function readFile(fileName, _encoding) {
                var _a, _b;
                (_a = perfLogger) == null ? void 0 : _a.logStartReadFile(fileName);
                const file = readFileWorker(fileName, _encoding);
                (_b = perfLogger) == null ? void 0 : _b.logStopReadFile();
                return file;
              }
              function writeFile2(fileName, data, writeByteOrderMark) {
                var _a;
                (_a = perfLogger) == null ? void 0 : _a.logEvent("WriteFile: " + fileName);
                if (writeByteOrderMark) {
                  data = byteOrderMarkIndicator + data;
                }
                let fd;
                try {
                  fd = _fs.openSync(fileName, "w");
                  _fs.writeSync(
                    fd,
                    data,
                    /*position*/
                    void 0,
                    "utf8"
                  );
                } finally {
                  if (fd !== void 0) {
                    _fs.closeSync(fd);
                  }
                }
              }
              function getAccessibleFileSystemEntries(path) {
                var _a;
                (_a = perfLogger) == null ? void 0 : _a.logEvent("ReadDir: " + (path || "."));
                try {
                  const entries = _fs.readdirSync(path || ".", { withFileTypes: true });
                  const files = [];
                  const directories = [];
                  for (const dirent of entries) {
                    const entry = typeof dirent === "string" ? dirent : dirent.name;
                    if (entry === "." || entry === "..") {
                      continue;
                    }
                    let stat;
                    if (typeof dirent === "string" || dirent.isSymbolicLink()) {
                      const name = combinePaths(path, entry);
                      try {
                        stat = statSync(name);
                        if (!stat) {
                          continue;
                        }
                      } catch (e) {
                        continue;
                      }
                    } else {
                      stat = dirent;
                    }
                    if (stat.isFile()) {
                      files.push(entry);
                    } else if (stat.isDirectory()) {
                      directories.push(entry);
                    }
                  }
                  files.sort();
                  directories.sort();
                  return { files, directories };
                } catch (e) {
                  return emptyFileSystemEntries;
                }
              }
              function readDirectory(path, extensions, excludes, includes, depth) {
                return matchFiles(path, extensions, excludes, includes, useCaseSensitiveFileNames2, process.cwd(), depth, getAccessibleFileSystemEntries, realpath);
              }
              function fileSystemEntryExists(path, entryKind) {
                const originalStackTraceLimit = Error.stackTraceLimit;
                Error.stackTraceLimit = 0;
                try {
                  const stat = statSync(path);
                  if (!stat) {
                    return false;
                  }
                  switch (entryKind) {
                    case 0:
                      return stat.isFile();
                    case 1:
                      return stat.isDirectory();
                    default:
                      return false;
                  }
                } catch (e) {
                  return false;
                } finally {
                  Error.stackTraceLimit = originalStackTraceLimit;
                }
              }
              function fileExists(path) {
                return fileSystemEntryExists(
                  path,
                  0
                  /* File */
                );
              }
              function directoryExists(path) {
                return fileSystemEntryExists(
                  path,
                  1
                  /* Directory */
                );
              }
              function getDirectories(path) {
                return getAccessibleFileSystemEntries(path).directories.slice();
              }
              function fsRealPathHandlingLongPath(path) {
                return path.length < 260 ? _fs.realpathSync.native(path) : _fs.realpathSync(path);
              }
              function realpath(path) {
                try {
                  return fsRealpath(path);
                } catch (e) {
                  return path;
                }
              }
              function getModifiedTime3(path) {
                var _a;
                const originalStackTraceLimit = Error.stackTraceLimit;
                Error.stackTraceLimit = 0;
                try {
                  return (_a = statSync(path)) == null ? void 0 : _a.mtime;
                } catch (e) {
                  return void 0;
                } finally {
                  Error.stackTraceLimit = originalStackTraceLimit;
                }
              }
              function setModifiedTime(path, time) {
                try {
                  _fs.utimesSync(path, time, time);
                } catch (e) {
                  return;
                }
              }
              function deleteFile(path) {
                try {
                  return _fs.unlinkSync(path);
                } catch (e) {
                  return;
                }
              }
              function createSHA256Hash(data) {
                const hash = _crypto.createHash("sha256");
                hash.update(data);
                return hash.digest("hex");
              }
            }
            let sys2;
            if (isNodeLikeSystem()) {
              sys2 = getNodeSystem();
            }
            if (sys2) {
              patchWriteFileEnsuringDirectory(sys2);
            }
            return sys2;
          })();
          if (sys && sys.getEnvironmentVariable) {
            setCustomPollingValues(sys);
            Debug.setAssertionLevel(
              /^development$/i.test(sys.getEnvironmentVariable("NODE_ENV")) ? 1 : 0
              /* None */
            );
          }
          if (sys && sys.debugMode) {
            Debug.isDebugging = true;
          }
        }
      });
      function isAnyDirectorySeparator(charCode) {
        return charCode === 47 || charCode === 92;
      }
      function isUrl(path) {
        return getEncodedRootLength(path) < 0;
      }
      function isRootedDiskPath(path) {
        return getEncodedRootLength(path) > 0;
      }
      function isDiskPathRoot(path) {
        const rootLength = getEncodedRootLength(path);
        return rootLength > 0 && rootLength === path.length;
      }
      function pathIsAbsolute(path) {
        return getEncodedRootLength(path) !== 0;
      }
      function pathIsRelative(path) {
        return /^\.\.?($|[\\/])/.test(path);
      }
      function pathIsBareSpecifier(path) {
        return !pathIsAbsolute(path) && !pathIsRelative(path);
      }
      function hasExtension(fileName) {
        return getBaseFileName(fileName).includes(".");
      }
      function fileExtensionIs(path, extension) {
        return path.length > extension.length && endsWith(path, extension);
      }
      function fileExtensionIsOneOf(path, extensions) {
        for (const extension of extensions) {
          if (fileExtensionIs(path, extension)) {
            return true;
          }
        }
        return false;
      }
      function hasTrailingDirectorySeparator(path) {
        return path.length > 0 && isAnyDirectorySeparator(path.charCodeAt(path.length - 1));
      }
      function isVolumeCharacter(charCode) {
        return charCode >= 97 && charCode <= 122 || charCode >= 65 && charCode <= 90;
      }
      function getFileUrlVolumeSeparatorEnd(url, start) {
        const ch0 = url.charCodeAt(start);
        if (ch0 === 58)
          return start + 1;
        if (ch0 === 37 && url.charCodeAt(start + 1) === 51) {
          const ch2 = url.charCodeAt(start + 2);
          if (ch2 === 97 || ch2 === 65)
            return start + 3;
        }
        return -1;
      }
      function getEncodedRootLength(path) {
        if (!path)
          return 0;
        const ch0 = path.charCodeAt(0);
        if (ch0 === 47 || ch0 === 92) {
          if (path.charCodeAt(1) !== ch0)
            return 1;
          const p1 = path.indexOf(ch0 === 47 ? directorySeparator : altDirectorySeparator, 2);
          if (p1 < 0)
            return path.length;
          return p1 + 1;
        }
        if (isVolumeCharacter(ch0) && path.charCodeAt(1) === 58) {
          const ch2 = path.charCodeAt(2);
          if (ch2 === 47 || ch2 === 92)
            return 3;
          if (path.length === 2)
            return 2;
        }
        const schemeEnd = path.indexOf(urlSchemeSeparator);
        if (schemeEnd !== -1) {
          const authorityStart = schemeEnd + urlSchemeSeparator.length;
          const authorityEnd = path.indexOf(directorySeparator, authorityStart);
          if (authorityEnd !== -1) {
            const scheme = path.slice(0, schemeEnd);
            const authority = path.slice(authorityStart, authorityEnd);
            if (scheme === "file" && (authority === "" || authority === "localhost") && isVolumeCharacter(path.charCodeAt(authorityEnd + 1))) {
              const volumeSeparatorEnd = getFileUrlVolumeSeparatorEnd(path, authorityEnd + 2);
              if (volumeSeparatorEnd !== -1) {
                if (path.charCodeAt(volumeSeparatorEnd) === 47) {
                  return ~(volumeSeparatorEnd + 1);
                }
                if (volumeSeparatorEnd === path.length) {
                  return ~volumeSeparatorEnd;
                }
              }
            }
            return ~(authorityEnd + 1);
          }
          return ~path.length;
        }
        return 0;
      }
      function getRootLength(path) {
        const rootLength = getEncodedRootLength(path);
        return rootLength < 0 ? ~rootLength : rootLength;
      }
      function getDirectoryPath(path) {
        path = normalizeSlashes(path);
        const rootLength = getRootLength(path);
        if (rootLength === path.length)
          return path;
        path = removeTrailingDirectorySeparator(path);
        return path.slice(0, Math.max(rootLength, path.lastIndexOf(directorySeparator)));
      }
      function getBaseFileName(path, extensions, ignoreCase) {
        path = normalizeSlashes(path);
        const rootLength = getRootLength(path);
        if (rootLength === path.length)
          return "";
        path = removeTrailingDirectorySeparator(path);
        const name = path.slice(Math.max(getRootLength(path), path.lastIndexOf(directorySeparator) + 1));
        const extension = extensions !== void 0 && ignoreCase !== void 0 ? getAnyExtensionFromPath(name, extensions, ignoreCase) : void 0;
        return extension ? name.slice(0, name.length - extension.length) : name;
      }
      function tryGetExtensionFromPath(path, extension, stringEqualityComparer) {
        if (!startsWith(extension, "."))
          extension = "." + extension;
        if (path.length >= extension.length && path.charCodeAt(path.length - extension.length) === 46) {
          const pathExtension = path.slice(path.length - extension.length);
          if (stringEqualityComparer(pathExtension, extension)) {
            return pathExtension;
          }
        }
      }
      function getAnyExtensionFromPathWorker(path, extensions, stringEqualityComparer) {
        if (typeof extensions === "string") {
          return tryGetExtensionFromPath(path, extensions, stringEqualityComparer) || "";
        }
        for (const extension of extensions) {
          const result = tryGetExtensionFromPath(path, extension, stringEqualityComparer);
          if (result)
            return result;
        }
        return "";
      }
      function getAnyExtensionFromPath(path, extensions, ignoreCase) {
        if (extensions) {
          return getAnyExtensionFromPathWorker(removeTrailingDirectorySeparator(path), extensions, ignoreCase ? equateStringsCaseInsensitive : equateStringsCaseSensitive);
        }
        const baseFileName = getBaseFileName(path);
        const extensionIndex = baseFileName.lastIndexOf(".");
        if (extensionIndex >= 0) {
          return baseFileName.substring(extensionIndex);
        }
        return "";
      }
      function pathComponents(path, rootLength) {
        const root = path.substring(0, rootLength);
        const rest = path.substring(rootLength).split(directorySeparator);
        if (rest.length && !lastOrUndefined(rest))
          rest.pop();
        return [root, ...rest];
      }
      function getPathComponents(path, currentDirectory = "") {
        path = combinePaths(currentDirectory, path);
        return pathComponents(path, getRootLength(path));
      }
      function getPathFromPathComponents(pathComponents2, length2) {
        if (pathComponents2.length === 0)
          return "";
        const root = pathComponents2[0] && ensureTrailingDirectorySeparator(pathComponents2[0]);
        return root + pathComponents2.slice(1, length2).join(directorySeparator);
      }
      function normalizeSlashes(path) {
        return path.includes("\\") ? path.replace(backslashRegExp, directorySeparator) : path;
      }
      function reducePathComponents(components) {
        if (!some(components))
          return [];
        const reduced = [components[0]];
        for (let i = 1; i < components.length; i++) {
          const component = components[i];
          if (!component)
            continue;
          if (component === ".")
            continue;
          if (component === "..") {
            if (reduced.length > 1) {
              if (reduced[reduced.length - 1] !== "..") {
                reduced.pop();
                continue;
              }
            } else if (reduced[0])
              continue;
          }
          reduced.push(component);
        }
        return reduced;
      }
      function combinePaths(path, ...paths) {
        if (path)
          path = normalizeSlashes(path);
        for (let relativePath of paths) {
          if (!relativePath)
            continue;
          relativePath = normalizeSlashes(relativePath);
          if (!path || getRootLength(relativePath) !== 0) {
            path = relativePath;
          } else {
            path = ensureTrailingDirectorySeparator(path) + relativePath;
          }
        }
        return path;
      }
      function resolvePath(path, ...paths) {
        return normalizePath(some(paths) ? combinePaths(path, ...paths) : normalizeSlashes(path));
      }
      function getNormalizedPathComponents(path, currentDirectory) {
        return reducePathComponents(getPathComponents(path, currentDirectory));
      }
      function getNormalizedAbsolutePath(fileName, currentDirectory) {
        return getPathFromPathComponents(getNormalizedPathComponents(fileName, currentDirectory));
      }
      function normalizePath(path) {
        path = normalizeSlashes(path);
        if (!relativePathSegmentRegExp.test(path)) {
          return path;
        }
        const simplified = path.replace(/\/\.\//g, "/").replace(/^\.\//, "");
        if (simplified !== path) {
          path = simplified;
          if (!relativePathSegmentRegExp.test(path)) {
            return path;
          }
        }
        const normalized = getPathFromPathComponents(reducePathComponents(getPathComponents(path)));
        return normalized && hasTrailingDirectorySeparator(path) ? ensureTrailingDirectorySeparator(normalized) : normalized;
      }
      function getPathWithoutRoot(pathComponents2) {
        if (pathComponents2.length === 0)
          return "";
        return pathComponents2.slice(1).join(directorySeparator);
      }
      function getNormalizedAbsolutePathWithoutRoot(fileName, currentDirectory) {
        return getPathWithoutRoot(getNormalizedPathComponents(fileName, currentDirectory));
      }
      function toPath(fileName, basePath, getCanonicalFileName) {
        const nonCanonicalizedPath = isRootedDiskPath(fileName) ? normalizePath(fileName) : getNormalizedAbsolutePath(fileName, basePath);
        return getCanonicalFileName(nonCanonicalizedPath);
      }
      function removeTrailingDirectorySeparator(path) {
        if (hasTrailingDirectorySeparator(path)) {
          return path.substr(0, path.length - 1);
        }
        return path;
      }
      function ensureTrailingDirectorySeparator(path) {
        if (!hasTrailingDirectorySeparator(path)) {
          return path + directorySeparator;
        }
        return path;
      }
      function ensurePathIsNonModuleName(path) {
        return !pathIsAbsolute(path) && !pathIsRelative(path) ? "./" + path : path;
      }
      function changeAnyExtension(path, ext, extensions, ignoreCase) {
        const pathext = extensions !== void 0 && ignoreCase !== void 0 ? getAnyExtensionFromPath(path, extensions, ignoreCase) : getAnyExtensionFromPath(path);
        return pathext ? path.slice(0, path.length - pathext.length) + (startsWith(ext, ".") ? ext : "." + ext) : path;
      }
      function comparePathsWorker(a, b, componentComparer) {
        if (a === b)
          return 0;
        if (a === void 0)
          return -1;
        if (b === void 0)
          return 1;
        const aRoot = a.substring(0, getRootLength(a));
        const bRoot = b.substring(0, getRootLength(b));
        const result = compareStringsCaseInsensitive(aRoot, bRoot);
        if (result !== 0) {
          return result;
        }
        const aRest = a.substring(aRoot.length);
        const bRest = b.substring(bRoot.length);
        if (!relativePathSegmentRegExp.test(aRest) && !relativePathSegmentRegExp.test(bRest)) {
          return componentComparer(aRest, bRest);
        }
        const aComponents = reducePathComponents(getPathComponents(a));
        const bComponents = reducePathComponents(getPathComponents(b));
        const sharedLength = Math.min(aComponents.length, bComponents.length);
        for (let i = 1; i < sharedLength; i++) {
          const result2 = componentComparer(aComponents[i], bComponents[i]);
          if (result2 !== 0) {
            return result2;
          }
        }
        return compareValues(aComponents.length, bComponents.length);
      }
      function comparePathsCaseSensitive(a, b) {
        return comparePathsWorker(a, b, compareStringsCaseSensitive);
      }
      function comparePathsCaseInsensitive(a, b) {
        return comparePathsWorker(a, b, compareStringsCaseInsensitive);
      }
      function comparePaths(a, b, currentDirectory, ignoreCase) {
        if (typeof currentDirectory === "string") {
          a = combinePaths(currentDirectory, a);
          b = combinePaths(currentDirectory, b);
        } else if (typeof currentDirectory === "boolean") {
          ignoreCase = currentDirectory;
        }
        return comparePathsWorker(a, b, getStringComparer(ignoreCase));
      }
      function containsPath(parent2, child, currentDirectory, ignoreCase) {
        if (typeof currentDirectory === "string") {
          parent2 = combinePaths(currentDirectory, parent2);
          child = combinePaths(currentDirectory, child);
        } else if (typeof currentDirectory === "boolean") {
          ignoreCase = currentDirectory;
        }
        if (parent2 === void 0 || child === void 0)
          return false;
        if (parent2 === child)
          return true;
        const parentComponents = reducePathComponents(getPathComponents(parent2));
        const childComponents = reducePathComponents(getPathComponents(child));
        if (childComponents.length < parentComponents.length) {
          return false;
        }
        const componentEqualityComparer = ignoreCase ? equateStringsCaseInsensitive : equateStringsCaseSensitive;
        for (let i = 0; i < parentComponents.length; i++) {
          const equalityComparer = i === 0 ? equateStringsCaseInsensitive : componentEqualityComparer;
          if (!equalityComparer(parentComponents[i], childComponents[i])) {
            return false;
          }
        }
        return true;
      }
      function startsWithDirectory(fileName, directoryName, getCanonicalFileName) {
        const canonicalFileName = getCanonicalFileName(fileName);
        const canonicalDirectoryName = getCanonicalFileName(directoryName);
        return startsWith(canonicalFileName, canonicalDirectoryName + "/") || startsWith(canonicalFileName, canonicalDirectoryName + "\\");
      }
      function getPathComponentsRelativeTo(from, to, stringEqualityComparer, getCanonicalFileName) {
        const fromComponents = reducePathComponents(getPathComponents(from));
        const toComponents = reducePathComponents(getPathComponents(to));
        let start;
        for (start = 0; start < fromComponents.length && start < toComponents.length; start++) {
          const fromComponent = getCanonicalFileName(fromComponents[start]);
          const toComponent = getCanonicalFileName(toComponents[start]);
          const comparer = start === 0 ? equateStringsCaseInsensitive : stringEqualityComparer;
          if (!comparer(fromComponent, toComponent))
            break;
        }
        if (start === 0) {
          return toComponents;
        }
        const components = toComponents.slice(start);
        const relative = [];
        for (; start < fromComponents.length; start++) {
          relative.push("..");
        }
        return ["", ...relative, ...components];
      }
      function getRelativePathFromDirectory(fromDirectory, to, getCanonicalFileNameOrIgnoreCase) {
        Debug.assert(getRootLength(fromDirectory) > 0 === getRootLength(to) > 0, "Paths must either both be absolute or both be relative");
        const getCanonicalFileName = typeof getCanonicalFileNameOrIgnoreCase === "function" ? getCanonicalFileNameOrIgnoreCase : identity;
        const ignoreCase = typeof getCanonicalFileNameOrIgnoreCase === "boolean" ? getCanonicalFileNameOrIgnoreCase : false;
        const pathComponents2 = getPathComponentsRelativeTo(fromDirectory, to, ignoreCase ? equateStringsCaseInsensitive : equateStringsCaseSensitive, getCanonicalFileName);
        return getPathFromPathComponents(pathComponents2);
      }
      function convertToRelativePath(absoluteOrRelativePath, basePath, getCanonicalFileName) {
        return !isRootedDiskPath(absoluteOrRelativePath) ? absoluteOrRelativePath : getRelativePathToDirectoryOrUrl(
          basePath,
          absoluteOrRelativePath,
          basePath,
          getCanonicalFileName,
          /*isAbsolutePathAnUrl*/
          false
        );
      }
      function getRelativePathFromFile(from, to, getCanonicalFileName) {
        return ensurePathIsNonModuleName(getRelativePathFromDirectory(getDirectoryPath(from), to, getCanonicalFileName));
      }
      function getRelativePathToDirectoryOrUrl(directoryPathOrUrl, relativeOrAbsolutePath, currentDirectory, getCanonicalFileName, isAbsolutePathAnUrl) {
        const pathComponents2 = getPathComponentsRelativeTo(
          resolvePath(currentDirectory, directoryPathOrUrl),
          resolvePath(currentDirectory, relativeOrAbsolutePath),
          equateStringsCaseSensitive,
          getCanonicalFileName
        );
        const firstComponent = pathComponents2[0];
        if (isAbsolutePathAnUrl && isRootedDiskPath(firstComponent)) {
          const prefix = firstComponent.charAt(0) === directorySeparator ? "file://" : "file:///";
          pathComponents2[0] = prefix + firstComponent;
        }
        return getPathFromPathComponents(pathComponents2);
      }
      function forEachAncestorDirectory(directory, callback) {
        while (true) {
          const result = callback(directory);
          if (result !== void 0) {
            return result;
          }
          const parentPath = getDirectoryPath(directory);
          if (parentPath === directory) {
            return void 0;
          }
          directory = parentPath;
        }
      }
      function isNodeModulesDirectory(dirPath) {
        return endsWith(dirPath, "/node_modules");
      }
      var directorySeparator, altDirectorySeparator, urlSchemeSeparator, backslashRegExp, relativePathSegmentRegExp;
      var init_path = __esm({
        "src/compiler/path.ts"() {
          "use strict";
          init_ts2();
          directorySeparator = "/";
          altDirectorySeparator = "\\";
          urlSchemeSeparator = "://";
          backslashRegExp = /\\/g;
          relativePathSegmentRegExp = /(?:\/\/)|(?:^|\/)\.\.?(?:$|\/)/;
        }
      });
      function diag(code, category, key, message, reportsUnnecessary, elidedInCompatabilityPyramid, reportsDeprecated) {
        return { code, category, key, message, reportsUnnecessary, elidedInCompatabilityPyramid, reportsDeprecated };
      }
      var Diagnostics;
      var init_diagnosticInformationMap_generated = __esm({
        "src/compiler/diagnosticInformationMap.generated.ts"() {
          "use strict";
          init_types();
          Diagnostics = {
            Unterminated_string_literal: diag(1002, 1, "Unterminated_string_literal_1002", "Unterminated string literal."),
            Identifier_expected: diag(1003, 1, "Identifier_expected_1003", "Identifier expected."),
            _0_expected: diag(1005, 1, "_0_expected_1005", "'{0}' expected."),
            A_file_cannot_have_a_reference_to_itself: diag(1006, 1, "A_file_cannot_have_a_reference_to_itself_1006", "A file cannot have a reference to itself."),
            The_parser_expected_to_find_a_1_to_match_the_0_token_here: diag(1007, 1, "The_parser_expected_to_find_a_1_to_match_the_0_token_here_1007", "The parser expected to find a '{1}' to match the '{0}' token here."),
            Trailing_comma_not_allowed: diag(1009, 1, "Trailing_comma_not_allowed_1009", "Trailing comma not allowed."),
            Asterisk_Slash_expected: diag(1010, 1, "Asterisk_Slash_expected_1010", "'*/' expected."),
            An_element_access_expression_should_take_an_argument: diag(1011, 1, "An_element_access_expression_should_take_an_argument_1011", "An element access expression should take an argument."),
            Unexpected_token: diag(1012, 1, "Unexpected_token_1012", "Unexpected token."),
            A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma: diag(1013, 1, "A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma_1013", "A rest parameter or binding pattern may not have a trailing comma."),
            A_rest_parameter_must_be_last_in_a_parameter_list: diag(1014, 1, "A_rest_parameter_must_be_last_in_a_parameter_list_1014", "A rest parameter must be last in a parameter list."),
            Parameter_cannot_have_question_mark_and_initializer: diag(1015, 1, "Parameter_cannot_have_question_mark_and_initializer_1015", "Parameter cannot have question mark and initializer."),
            A_required_parameter_cannot_follow_an_optional_parameter: diag(1016, 1, "A_required_parameter_cannot_follow_an_optional_parameter_1016", "A required parameter cannot follow an optional parameter."),
            An_index_signature_cannot_have_a_rest_parameter: diag(1017, 1, "An_index_signature_cannot_have_a_rest_parameter_1017", "An index signature cannot have a rest parameter."),
            An_index_signature_parameter_cannot_have_an_accessibility_modifier: diag(1018, 1, "An_index_signature_parameter_cannot_have_an_accessibility_modifier_1018", "An index signature parameter cannot have an accessibility modifier."),
            An_index_signature_parameter_cannot_have_a_question_mark: diag(1019, 1, "An_index_signature_parameter_cannot_have_a_question_mark_1019", "An index signature parameter cannot have a question mark."),
            An_index_signature_parameter_cannot_have_an_initializer: diag(1020, 1, "An_index_signature_parameter_cannot_have_an_initializer_1020", "An index signature parameter cannot have an initializer."),
            An_index_signature_must_have_a_type_annotation: diag(1021, 1, "An_index_signature_must_have_a_type_annotation_1021", "An index signature must have a type annotation."),
            An_index_signature_parameter_must_have_a_type_annotation: diag(1022, 1, "An_index_signature_parameter_must_have_a_type_annotation_1022", "An index signature parameter must have a type annotation."),
            readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature: diag(1024, 1, "readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature_1024", "'readonly' modifier can only appear on a property declaration or index signature."),
            An_index_signature_cannot_have_a_trailing_comma: diag(1025, 1, "An_index_signature_cannot_have_a_trailing_comma_1025", "An index signature cannot have a trailing comma."),
            Accessibility_modifier_already_seen: diag(1028, 1, "Accessibility_modifier_already_seen_1028", "Accessibility modifier already seen."),
            _0_modifier_must_precede_1_modifier: diag(1029, 1, "_0_modifier_must_precede_1_modifier_1029", "'{0}' modifier must precede '{1}' modifier."),
            _0_modifier_already_seen: diag(1030, 1, "_0_modifier_already_seen_1030", "'{0}' modifier already seen."),
            _0_modifier_cannot_appear_on_class_elements_of_this_kind: diag(1031, 1, "_0_modifier_cannot_appear_on_class_elements_of_this_kind_1031", "'{0}' modifier cannot appear on class elements of this kind."),
            super_must_be_followed_by_an_argument_list_or_member_access: diag(1034, 1, "super_must_be_followed_by_an_argument_list_or_member_access_1034", "'super' must be followed by an argument list or member access."),
            Only_ambient_modules_can_use_quoted_names: diag(1035, 1, "Only_ambient_modules_can_use_quoted_names_1035", "Only ambient modules can use quoted names."),
            Statements_are_not_allowed_in_ambient_contexts: diag(1036, 1, "Statements_are_not_allowed_in_ambient_contexts_1036", "Statements are not allowed in ambient contexts."),
            A_declare_modifier_cannot_be_used_in_an_already_ambient_context: diag(1038, 1, "A_declare_modifier_cannot_be_used_in_an_already_ambient_context_1038", "A 'declare' modifier cannot be used in an already ambient context."),
            Initializers_are_not_allowed_in_ambient_contexts: diag(1039, 1, "Initializers_are_not_allowed_in_ambient_contexts_1039", "Initializers are not allowed in ambient contexts."),
            _0_modifier_cannot_be_used_in_an_ambient_context: diag(1040, 1, "_0_modifier_cannot_be_used_in_an_ambient_context_1040", "'{0}' modifier cannot be used in an ambient context."),
            _0_modifier_cannot_be_used_here: diag(1042, 1, "_0_modifier_cannot_be_used_here_1042", "'{0}' modifier cannot be used here."),
            _0_modifier_cannot_appear_on_a_module_or_namespace_element: diag(1044, 1, "_0_modifier_cannot_appear_on_a_module_or_namespace_element_1044", "'{0}' modifier cannot appear on a module or namespace element."),
            Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier: diag(1046, 1, "Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier_1046", "Top-level declarations in .d.ts files must start with either a 'declare' or 'export' modifier."),
            A_rest_parameter_cannot_be_optional: diag(1047, 1, "A_rest_parameter_cannot_be_optional_1047", "A rest parameter cannot be optional."),
            A_rest_parameter_cannot_have_an_initializer: diag(1048, 1, "A_rest_parameter_cannot_have_an_initializer_1048", "A rest parameter cannot have an initializer."),
            A_set_accessor_must_have_exactly_one_parameter: diag(1049, 1, "A_set_accessor_must_have_exactly_one_parameter_1049", "A 'set' accessor must have exactly one parameter."),
            A_set_accessor_cannot_have_an_optional_parameter: diag(1051, 1, "A_set_accessor_cannot_have_an_optional_parameter_1051", "A 'set' accessor cannot have an optional parameter."),
            A_set_accessor_parameter_cannot_have_an_initializer: diag(1052, 1, "A_set_accessor_parameter_cannot_have_an_initializer_1052", "A 'set' accessor parameter cannot have an initializer."),
            A_set_accessor_cannot_have_rest_parameter: diag(1053, 1, "A_set_accessor_cannot_have_rest_parameter_1053", "A 'set' accessor cannot have rest parameter."),
            A_get_accessor_cannot_have_parameters: diag(1054, 1, "A_get_accessor_cannot_have_parameters_1054", "A 'get' accessor cannot have parameters."),
            Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Promise_compatible_constructor_value: diag(1055, 1, "Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Prom_1055", "Type '{0}' is not a valid async function return type in ES5/ES3 because it does not refer to a Promise-compatible constructor value."),
            Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher: diag(1056, 1, "Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher_1056", "Accessors are only available when targeting ECMAScript 5 and higher."),
            The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1058, 1, "The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_t_1058", "The return type of an async function must either be a valid promise or must not contain a callable 'then' member."),
            A_promise_must_have_a_then_method: diag(1059, 1, "A_promise_must_have_a_then_method_1059", "A promise must have a 'then' method."),
            The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback: diag(1060, 1, "The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback_1060", "The first parameter of the 'then' method of a promise must be a callback."),
            Enum_member_must_have_initializer: diag(1061, 1, "Enum_member_must_have_initializer_1061", "Enum member must have initializer."),
            Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method: diag(1062, 1, "Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method_1062", "Type is referenced directly or indirectly in the fulfillment callback of its own 'then' method."),
            An_export_assignment_cannot_be_used_in_a_namespace: diag(1063, 1, "An_export_assignment_cannot_be_used_in_a_namespace_1063", "An export assignment cannot be used in a namespace."),
            The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_Did_you_mean_to_write_Promise_0: diag(1064, 1, "The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_Did_you_mean_to_wri_1064", "The return type of an async function or method must be the global Promise<T> type. Did you mean to write 'Promise<{0}>'?"),
            The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type: diag(1065, 1, "The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_1065", "The return type of an async function or method must be the global Promise<T> type."),
            In_ambient_enum_declarations_member_initializer_must_be_constant_expression: diag(1066, 1, "In_ambient_enum_declarations_member_initializer_must_be_constant_expression_1066", "In ambient enum declarations member initializer must be constant expression."),
            Unexpected_token_A_constructor_method_accessor_or_property_was_expected: diag(1068, 1, "Unexpected_token_A_constructor_method_accessor_or_property_was_expected_1068", "Unexpected token. A constructor, method, accessor, or property was expected."),
            Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces: diag(1069, 1, "Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces_1069", "Unexpected token. A type parameter name was expected without curly braces."),
            _0_modifier_cannot_appear_on_a_type_member: diag(1070, 1, "_0_modifier_cannot_appear_on_a_type_member_1070", "'{0}' modifier cannot appear on a type member."),
            _0_modifier_cannot_appear_on_an_index_signature: diag(1071, 1, "_0_modifier_cannot_appear_on_an_index_signature_1071", "'{0}' modifier cannot appear on an index signature."),
            A_0_modifier_cannot_be_used_with_an_import_declaration: diag(1079, 1, "A_0_modifier_cannot_be_used_with_an_import_declaration_1079", "A '{0}' modifier cannot be used with an import declaration."),
            Invalid_reference_directive_syntax: diag(1084, 1, "Invalid_reference_directive_syntax_1084", "Invalid 'reference' directive syntax."),
            _0_modifier_cannot_appear_on_a_constructor_declaration: diag(1089, 1, "_0_modifier_cannot_appear_on_a_constructor_declaration_1089", "'{0}' modifier cannot appear on a constructor declaration."),
            _0_modifier_cannot_appear_on_a_parameter: diag(1090, 1, "_0_modifier_cannot_appear_on_a_parameter_1090", "'{0}' modifier cannot appear on a parameter."),
            Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement: diag(1091, 1, "Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement_1091", "Only a single variable declaration is allowed in a 'for...in' statement."),
            Type_parameters_cannot_appear_on_a_constructor_declaration: diag(1092, 1, "Type_parameters_cannot_appear_on_a_constructor_declaration_1092", "Type parameters cannot appear on a constructor declaration."),
            Type_annotation_cannot_appear_on_a_constructor_declaration: diag(1093, 1, "Type_annotation_cannot_appear_on_a_constructor_declaration_1093", "Type annotation cannot appear on a constructor declaration."),
            An_accessor_cannot_have_type_parameters: diag(1094, 1, "An_accessor_cannot_have_type_parameters_1094", "An accessor cannot have type parameters."),
            A_set_accessor_cannot_have_a_return_type_annotation: diag(1095, 1, "A_set_accessor_cannot_have_a_return_type_annotation_1095", "A 'set' accessor cannot have a return type annotation."),
            An_index_signature_must_have_exactly_one_parameter: diag(1096, 1, "An_index_signature_must_have_exactly_one_parameter_1096", "An index signature must have exactly one parameter."),
            _0_list_cannot_be_empty: diag(1097, 1, "_0_list_cannot_be_empty_1097", "'{0}' list cannot be empty."),
            Type_parameter_list_cannot_be_empty: diag(1098, 1, "Type_parameter_list_cannot_be_empty_1098", "Type parameter list cannot be empty."),
            Type_argument_list_cannot_be_empty: diag(1099, 1, "Type_argument_list_cannot_be_empty_1099", "Type argument list cannot be empty."),
            Invalid_use_of_0_in_strict_mode: diag(1100, 1, "Invalid_use_of_0_in_strict_mode_1100", "Invalid use of '{0}' in strict mode."),
            with_statements_are_not_allowed_in_strict_mode: diag(1101, 1, "with_statements_are_not_allowed_in_strict_mode_1101", "'with' statements are not allowed in strict mode."),
            delete_cannot_be_called_on_an_identifier_in_strict_mode: diag(1102, 1, "delete_cannot_be_called_on_an_identifier_in_strict_mode_1102", "'delete' cannot be called on an identifier in strict mode."),
            for_await_loops_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules: diag(1103, 1, "for_await_loops_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules_1103", "'for await' loops are only allowed within async functions and at the top levels of modules."),
            A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement: diag(1104, 1, "A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement_1104", "A 'continue' statement can only be used within an enclosing iteration statement."),
            A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement: diag(1105, 1, "A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement_1105", "A 'break' statement can only be used within an enclosing iteration or switch statement."),
            The_left_hand_side_of_a_for_of_statement_may_not_be_async: diag(1106, 1, "The_left_hand_side_of_a_for_of_statement_may_not_be_async_1106", "The left-hand side of a 'for...of' statement may not be 'async'."),
            Jump_target_cannot_cross_function_boundary: diag(1107, 1, "Jump_target_cannot_cross_function_boundary_1107", "Jump target cannot cross function boundary."),
            A_return_statement_can_only_be_used_within_a_function_body: diag(1108, 1, "A_return_statement_can_only_be_used_within_a_function_body_1108", "A 'return' statement can only be used within a function body."),
            Expression_expected: diag(1109, 1, "Expression_expected_1109", "Expression expected."),
            Type_expected: diag(1110, 1, "Type_expected_1110", "Type expected."),
            Private_field_0_must_be_declared_in_an_enclosing_class: diag(1111, 1, "Private_field_0_must_be_declared_in_an_enclosing_class_1111", "Private field '{0}' must be declared in an enclosing class."),
            A_default_clause_cannot_appear_more_than_once_in_a_switch_statement: diag(1113, 1, "A_default_clause_cannot_appear_more_than_once_in_a_switch_statement_1113", "A 'default' clause cannot appear more than once in a 'switch' statement."),
            Duplicate_label_0: diag(1114, 1, "Duplicate_label_0_1114", "Duplicate label '{0}'."),
            A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement: diag(1115, 1, "A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement_1115", "A 'continue' statement can only jump to a label of an enclosing iteration statement."),
            A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement: diag(1116, 1, "A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement_1116", "A 'break' statement can only jump to a label of an enclosing statement."),
            An_object_literal_cannot_have_multiple_properties_with_the_same_name: diag(1117, 1, "An_object_literal_cannot_have_multiple_properties_with_the_same_name_1117", "An object literal cannot have multiple properties with the same name."),
            An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name: diag(1118, 1, "An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name_1118", "An object literal cannot have multiple get/set accessors with the same name."),
            An_object_literal_cannot_have_property_and_accessor_with_the_same_name: diag(1119, 1, "An_object_literal_cannot_have_property_and_accessor_with_the_same_name_1119", "An object literal cannot have property and accessor with the same name."),
            An_export_assignment_cannot_have_modifiers: diag(1120, 1, "An_export_assignment_cannot_have_modifiers_1120", "An export assignment cannot have modifiers."),
            Octal_literals_are_not_allowed_Use_the_syntax_0: diag(1121, 1, "Octal_literals_are_not_allowed_Use_the_syntax_0_1121", "Octal literals are not allowed. Use the syntax '{0}'."),
            Variable_declaration_list_cannot_be_empty: diag(1123, 1, "Variable_declaration_list_cannot_be_empty_1123", "Variable declaration list cannot be empty."),
            Digit_expected: diag(1124, 1, "Digit_expected_1124", "Digit expected."),
            Hexadecimal_digit_expected: diag(1125, 1, "Hexadecimal_digit_expected_1125", "Hexadecimal digit expected."),
            Unexpected_end_of_text: diag(1126, 1, "Unexpected_end_of_text_1126", "Unexpected end of text."),
            Invalid_character: diag(1127, 1, "Invalid_character_1127", "Invalid character."),
            Declaration_or_statement_expected: diag(1128, 1, "Declaration_or_statement_expected_1128", "Declaration or statement expected."),
            Statement_expected: diag(1129, 1, "Statement_expected_1129", "Statement expected."),
            case_or_default_expected: diag(1130, 1, "case_or_default_expected_1130", "'case' or 'default' expected."),
            Property_or_signature_expected: diag(1131, 1, "Property_or_signature_expected_1131", "Property or signature expected."),
            Enum_member_expected: diag(1132, 1, "Enum_member_expected_1132", "Enum member expected."),
            Variable_declaration_expected: diag(1134, 1, "Variable_declaration_expected_1134", "Variable declaration expected."),
            Argument_expression_expected: diag(1135, 1, "Argument_expression_expected_1135", "Argument expression expected."),
            Property_assignment_expected: diag(1136, 1, "Property_assignment_expected_1136", "Property assignment expected."),
            Expression_or_comma_expected: diag(1137, 1, "Expression_or_comma_expected_1137", "Expression or comma expected."),
            Parameter_declaration_expected: diag(1138, 1, "Parameter_declaration_expected_1138", "Parameter declaration expected."),
            Type_parameter_declaration_expected: diag(1139, 1, "Type_parameter_declaration_expected_1139", "Type parameter declaration expected."),
            Type_argument_expected: diag(1140, 1, "Type_argument_expected_1140", "Type argument expected."),
            String_literal_expected: diag(1141, 1, "String_literal_expected_1141", "String literal expected."),
            Line_break_not_permitted_here: diag(1142, 1, "Line_break_not_permitted_here_1142", "Line break not permitted here."),
            or_expected: diag(1144, 1, "or_expected_1144", "'{' or ';' expected."),
            or_JSX_element_expected: diag(1145, 1, "or_JSX_element_expected_1145", "'{' or JSX element expected."),
            Declaration_expected: diag(1146, 1, "Declaration_expected_1146", "Declaration expected."),
            Import_declarations_in_a_namespace_cannot_reference_a_module: diag(1147, 1, "Import_declarations_in_a_namespace_cannot_reference_a_module_1147", "Import declarations in a namespace cannot reference a module."),
            Cannot_use_imports_exports_or_module_augmentations_when_module_is_none: diag(1148, 1, "Cannot_use_imports_exports_or_module_augmentations_when_module_is_none_1148", "Cannot use imports, exports, or module augmentations when '--module' is 'none'."),
            File_name_0_differs_from_already_included_file_name_1_only_in_casing: diag(1149, 1, "File_name_0_differs_from_already_included_file_name_1_only_in_casing_1149", "File name '{0}' differs from already included file name '{1}' only in casing."),
            _0_declarations_must_be_initialized: diag(1155, 1, "_0_declarations_must_be_initialized_1155", "'{0}' declarations must be initialized."),
            _0_declarations_can_only_be_declared_inside_a_block: diag(1156, 1, "_0_declarations_can_only_be_declared_inside_a_block_1156", "'{0}' declarations can only be declared inside a block."),
            Unterminated_template_literal: diag(1160, 1, "Unterminated_template_literal_1160", "Unterminated template literal."),
            Unterminated_regular_expression_literal: diag(1161, 1, "Unterminated_regular_expression_literal_1161", "Unterminated regular expression literal."),
            An_object_member_cannot_be_declared_optional: diag(1162, 1, "An_object_member_cannot_be_declared_optional_1162", "An object member cannot be declared optional."),
            A_yield_expression_is_only_allowed_in_a_generator_body: diag(1163, 1, "A_yield_expression_is_only_allowed_in_a_generator_body_1163", "A 'yield' expression is only allowed in a generator body."),
            Computed_property_names_are_not_allowed_in_enums: diag(1164, 1, "Computed_property_names_are_not_allowed_in_enums_1164", "Computed property names are not allowed in enums."),
            A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1165, 1, "A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_t_1165", "A computed property name in an ambient context must refer to an expression whose type is a literal type or a 'unique symbol' type."),
            A_computed_property_name_in_a_class_property_declaration_must_have_a_simple_literal_type_or_a_unique_symbol_type: diag(1166, 1, "A_computed_property_name_in_a_class_property_declaration_must_have_a_simple_literal_type_or_a_unique_1166", "A computed property name in a class property declaration must have a simple literal type or a 'unique symbol' type."),
            A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1168, 1, "A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_ty_1168", "A computed property name in a method overload must refer to an expression whose type is a literal type or a 'unique symbol' type."),
            A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1169, 1, "A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_1169", "A computed property name in an interface must refer to an expression whose type is a literal type or a 'unique symbol' type."),
            A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1170, 1, "A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type__1170", "A computed property name in a type literal must refer to an expression whose type is a literal type or a 'unique symbol' type."),
            A_comma_expression_is_not_allowed_in_a_computed_property_name: diag(1171, 1, "A_comma_expression_is_not_allowed_in_a_computed_property_name_1171", "A comma expression is not allowed in a computed property name."),
            extends_clause_already_seen: diag(1172, 1, "extends_clause_already_seen_1172", "'extends' clause already seen."),
            extends_clause_must_precede_implements_clause: diag(1173, 1, "extends_clause_must_precede_implements_clause_1173", "'extends' clause must precede 'implements' clause."),
            Classes_can_only_extend_a_single_class: diag(1174, 1, "Classes_can_only_extend_a_single_class_1174", "Classes can only extend a single class."),
            implements_clause_already_seen: diag(1175, 1, "implements_clause_already_seen_1175", "'implements' clause already seen."),
            Interface_declaration_cannot_have_implements_clause: diag(1176, 1, "Interface_declaration_cannot_have_implements_clause_1176", "Interface declaration cannot have 'implements' clause."),
            Binary_digit_expected: diag(1177, 1, "Binary_digit_expected_1177", "Binary digit expected."),
            Octal_digit_expected: diag(1178, 1, "Octal_digit_expected_1178", "Octal digit expected."),
            Unexpected_token_expected: diag(1179, 1, "Unexpected_token_expected_1179", "Unexpected token. '{' expected."),
            Property_destructuring_pattern_expected: diag(1180, 1, "Property_destructuring_pattern_expected_1180", "Property destructuring pattern expected."),
            Array_element_destructuring_pattern_expected: diag(1181, 1, "Array_element_destructuring_pattern_expected_1181", "Array element destructuring pattern expected."),
            A_destructuring_declaration_must_have_an_initializer: diag(1182, 1, "A_destructuring_declaration_must_have_an_initializer_1182", "A destructuring declaration must have an initializer."),
            An_implementation_cannot_be_declared_in_ambient_contexts: diag(1183, 1, "An_implementation_cannot_be_declared_in_ambient_contexts_1183", "An implementation cannot be declared in ambient contexts."),
            Modifiers_cannot_appear_here: diag(1184, 1, "Modifiers_cannot_appear_here_1184", "Modifiers cannot appear here."),
            Merge_conflict_marker_encountered: diag(1185, 1, "Merge_conflict_marker_encountered_1185", "Merge conflict marker encountered."),
            A_rest_element_cannot_have_an_initializer: diag(1186, 1, "A_rest_element_cannot_have_an_initializer_1186", "A rest element cannot have an initializer."),
            A_parameter_property_may_not_be_declared_using_a_binding_pattern: diag(1187, 1, "A_parameter_property_may_not_be_declared_using_a_binding_pattern_1187", "A parameter property may not be declared using a binding pattern."),
            Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement: diag(1188, 1, "Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement_1188", "Only a single variable declaration is allowed in a 'for...of' statement."),
            The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer: diag(1189, 1, "The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer_1189", "The variable declaration of a 'for...in' statement cannot have an initializer."),
            The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer: diag(1190, 1, "The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer_1190", "The variable declaration of a 'for...of' statement cannot have an initializer."),
            An_import_declaration_cannot_have_modifiers: diag(1191, 1, "An_import_declaration_cannot_have_modifiers_1191", "An import declaration cannot have modifiers."),
            Module_0_has_no_default_export: diag(1192, 1, "Module_0_has_no_default_export_1192", "Module '{0}' has no default export."),
            An_export_declaration_cannot_have_modifiers: diag(1193, 1, "An_export_declaration_cannot_have_modifiers_1193", "An export declaration cannot have modifiers."),
            Export_declarations_are_not_permitted_in_a_namespace: diag(1194, 1, "Export_declarations_are_not_permitted_in_a_namespace_1194", "Export declarations are not permitted in a namespace."),
            export_Asterisk_does_not_re_export_a_default: diag(1195, 1, "export_Asterisk_does_not_re_export_a_default_1195", "'export *' does not re-export a default."),
            Catch_clause_variable_type_annotation_must_be_any_or_unknown_if_specified: diag(1196, 1, "Catch_clause_variable_type_annotation_must_be_any_or_unknown_if_specified_1196", "Catch clause variable type annotation must be 'any' or 'unknown' if specified."),
            Catch_clause_variable_cannot_have_an_initializer: diag(1197, 1, "Catch_clause_variable_cannot_have_an_initializer_1197", "Catch clause variable cannot have an initializer."),
            An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive: diag(1198, 1, "An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive_1198", "An extended Unicode escape value must be between 0x0 and 0x10FFFF inclusive."),
            Unterminated_Unicode_escape_sequence: diag(1199, 1, "Unterminated_Unicode_escape_sequence_1199", "Unterminated Unicode escape sequence."),
            Line_terminator_not_permitted_before_arrow: diag(1200, 1, "Line_terminator_not_permitted_before_arrow_1200", "Line terminator not permitted before arrow."),
            Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_ns_from_mod_import_a_from_mod_import_d_from_mod_or_another_module_format_instead: diag(1202, 1, "Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_1202", `Import assignment cannot be used when targeting ECMAScript modules. Consider using 'import * as ns from "mod"', 'import {a} from "mod"', 'import d from "mod"', or another module format instead.`),
            Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or_another_module_format_instead: diag(1203, 1, "Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or__1203", "Export assignment cannot be used when targeting ECMAScript modules. Consider using 'export default' or another module format instead."),
            Re_exporting_a_type_when_0_is_enabled_requires_using_export_type: diag(1205, 1, "Re_exporting_a_type_when_0_is_enabled_requires_using_export_type_1205", "Re-exporting a type when '{0}' is enabled requires using 'export type'."),
            Decorators_are_not_valid_here: diag(1206, 1, "Decorators_are_not_valid_here_1206", "Decorators are not valid here."),
            Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name: diag(1207, 1, "Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name_1207", "Decorators cannot be applied to multiple get/set accessors of the same name."),
            Invalid_optional_chain_from_new_expression_Did_you_mean_to_call_0: diag(1209, 1, "Invalid_optional_chain_from_new_expression_Did_you_mean_to_call_0_1209", "Invalid optional chain from new expression. Did you mean to call '{0}()'?"),
            Code_contained_in_a_class_is_evaluated_in_JavaScript_s_strict_mode_which_does_not_allow_this_use_of_0_For_more_information_see_https_Colon_Slash_Slashdeveloper_mozilla_org_Slashen_US_Slashdocs_SlashWeb_SlashJavaScript_SlashReference_SlashStrict_mode: diag(1210, 1, "Code_contained_in_a_class_is_evaluated_in_JavaScript_s_strict_mode_which_does_not_allow_this_use_of__1210", "Code contained in a class is evaluated in JavaScript's strict mode which does not allow this use of '{0}'. For more information, see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode."),
            A_class_declaration_without_the_default_modifier_must_have_a_name: diag(1211, 1, "A_class_declaration_without_the_default_modifier_must_have_a_name_1211", "A class declaration without the 'default' modifier must have a name."),
            Identifier_expected_0_is_a_reserved_word_in_strict_mode: diag(1212, 1, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_1212", "Identifier expected. '{0}' is a reserved word in strict mode."),
            Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_strict_mode: diag(1213, 1, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_stric_1213", "Identifier expected. '{0}' is a reserved word in strict mode. Class definitions are automatically in strict mode."),
            Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode: diag(1214, 1, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode_1214", "Identifier expected. '{0}' is a reserved word in strict mode. Modules are automatically in strict mode."),
            Invalid_use_of_0_Modules_are_automatically_in_strict_mode: diag(1215, 1, "Invalid_use_of_0_Modules_are_automatically_in_strict_mode_1215", "Invalid use of '{0}'. Modules are automatically in strict mode."),
            Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules: diag(1216, 1, "Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules_1216", "Identifier expected. '__esModule' is reserved as an exported marker when transforming ECMAScript modules."),
            Export_assignment_is_not_supported_when_module_flag_is_system: diag(1218, 1, "Export_assignment_is_not_supported_when_module_flag_is_system_1218", "Export assignment is not supported when '--module' flag is 'system'."),
            Generators_are_not_allowed_in_an_ambient_context: diag(1221, 1, "Generators_are_not_allowed_in_an_ambient_context_1221", "Generators are not allowed in an ambient context."),
            An_overload_signature_cannot_be_declared_as_a_generator: diag(1222, 1, "An_overload_signature_cannot_be_declared_as_a_generator_1222", "An overload signature cannot be declared as a generator."),
            _0_tag_already_specified: diag(1223, 1, "_0_tag_already_specified_1223", "'{0}' tag already specified."),
            Signature_0_must_be_a_type_predicate: diag(1224, 1, "Signature_0_must_be_a_type_predicate_1224", "Signature '{0}' must be a type predicate."),
            Cannot_find_parameter_0: diag(1225, 1, "Cannot_find_parameter_0_1225", "Cannot find parameter '{0}'."),
            Type_predicate_0_is_not_assignable_to_1: diag(1226, 1, "Type_predicate_0_is_not_assignable_to_1_1226", "Type predicate '{0}' is not assignable to '{1}'."),
            Parameter_0_is_not_in_the_same_position_as_parameter_1: diag(1227, 1, "Parameter_0_is_not_in_the_same_position_as_parameter_1_1227", "Parameter '{0}' is not in the same position as parameter '{1}'."),
            A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods: diag(1228, 1, "A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods_1228", "A type predicate is only allowed in return type position for functions and methods."),
            A_type_predicate_cannot_reference_a_rest_parameter: diag(1229, 1, "A_type_predicate_cannot_reference_a_rest_parameter_1229", "A type predicate cannot reference a rest parameter."),
            A_type_predicate_cannot_reference_element_0_in_a_binding_pattern: diag(1230, 1, "A_type_predicate_cannot_reference_element_0_in_a_binding_pattern_1230", "A type predicate cannot reference element '{0}' in a binding pattern."),
            An_export_assignment_must_be_at_the_top_level_of_a_file_or_module_declaration: diag(1231, 1, "An_export_assignment_must_be_at_the_top_level_of_a_file_or_module_declaration_1231", "An export assignment must be at the top level of a file or module declaration."),
            An_import_declaration_can_only_be_used_at_the_top_level_of_a_namespace_or_module: diag(1232, 1, "An_import_declaration_can_only_be_used_at_the_top_level_of_a_namespace_or_module_1232", "An import declaration can only be used at the top level of a namespace or module."),
            An_export_declaration_can_only_be_used_at_the_top_level_of_a_namespace_or_module: diag(1233, 1, "An_export_declaration_can_only_be_used_at_the_top_level_of_a_namespace_or_module_1233", "An export declaration can only be used at the top level of a namespace or module."),
            An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file: diag(1234, 1, "An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file_1234", "An ambient module declaration is only allowed at the top level in a file."),
            A_namespace_declaration_is_only_allowed_at_the_top_level_of_a_namespace_or_module: diag(1235, 1, "A_namespace_declaration_is_only_allowed_at_the_top_level_of_a_namespace_or_module_1235", "A namespace declaration is only allowed at the top level of a namespace or module."),
            The_return_type_of_a_property_decorator_function_must_be_either_void_or_any: diag(1236, 1, "The_return_type_of_a_property_decorator_function_must_be_either_void_or_any_1236", "The return type of a property decorator function must be either 'void' or 'any'."),
            The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any: diag(1237, 1, "The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any_1237", "The return type of a parameter decorator function must be either 'void' or 'any'."),
            Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression: diag(1238, 1, "Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression_1238", "Unable to resolve signature of class decorator when called as an expression."),
            Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression: diag(1239, 1, "Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression_1239", "Unable to resolve signature of parameter decorator when called as an expression."),
            Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression: diag(1240, 1, "Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression_1240", "Unable to resolve signature of property decorator when called as an expression."),
            Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression: diag(1241, 1, "Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression_1241", "Unable to resolve signature of method decorator when called as an expression."),
            abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration: diag(1242, 1, "abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration_1242", "'abstract' modifier can only appear on a class, method, or property declaration."),
            _0_modifier_cannot_be_used_with_1_modifier: diag(1243, 1, "_0_modifier_cannot_be_used_with_1_modifier_1243", "'{0}' modifier cannot be used with '{1}' modifier."),
            Abstract_methods_can_only_appear_within_an_abstract_class: diag(1244, 1, "Abstract_methods_can_only_appear_within_an_abstract_class_1244", "Abstract methods can only appear within an abstract class."),
            Method_0_cannot_have_an_implementation_because_it_is_marked_abstract: diag(1245, 1, "Method_0_cannot_have_an_implementation_because_it_is_marked_abstract_1245", "Method '{0}' cannot have an implementation because it is marked abstract."),
            An_interface_property_cannot_have_an_initializer: diag(1246, 1, "An_interface_property_cannot_have_an_initializer_1246", "An interface property cannot have an initializer."),
            A_type_literal_property_cannot_have_an_initializer: diag(1247, 1, "A_type_literal_property_cannot_have_an_initializer_1247", "A type literal property cannot have an initializer."),
            A_class_member_cannot_have_the_0_keyword: diag(1248, 1, "A_class_member_cannot_have_the_0_keyword_1248", "A class member cannot have the '{0}' keyword."),
            A_decorator_can_only_decorate_a_method_implementation_not_an_overload: diag(1249, 1, "A_decorator_can_only_decorate_a_method_implementation_not_an_overload_1249", "A decorator can only decorate a method implementation, not an overload."),
            Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5: diag(1250, 1, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_1250", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'."),
            Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_definitions_are_automatically_in_strict_mode: diag(1251, 1, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_d_1251", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Class definitions are automatically in strict mode."),
            Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_are_automatically_in_strict_mode: diag(1252, 1, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_1252", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Modules are automatically in strict mode."),
            Abstract_properties_can_only_appear_within_an_abstract_class: diag(1253, 1, "Abstract_properties_can_only_appear_within_an_abstract_class_1253", "Abstract properties can only appear within an abstract class."),
            A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_reference: diag(1254, 1, "A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_refere_1254", "A 'const' initializer in an ambient context must be a string or numeric literal or literal enum reference."),
            A_definite_assignment_assertion_is_not_permitted_in_this_context: diag(1255, 1, "A_definite_assignment_assertion_is_not_permitted_in_this_context_1255", "A definite assignment assertion '!' is not permitted in this context."),
            A_required_element_cannot_follow_an_optional_element: diag(1257, 1, "A_required_element_cannot_follow_an_optional_element_1257", "A required element cannot follow an optional element."),
            A_default_export_must_be_at_the_top_level_of_a_file_or_module_declaration: diag(1258, 1, "A_default_export_must_be_at_the_top_level_of_a_file_or_module_declaration_1258", "A default export must be at the top level of a file or module declaration."),
            Module_0_can_only_be_default_imported_using_the_1_flag: diag(1259, 1, "Module_0_can_only_be_default_imported_using_the_1_flag_1259", "Module '{0}' can only be default-imported using the '{1}' flag"),
            Keywords_cannot_contain_escape_characters: diag(1260, 1, "Keywords_cannot_contain_escape_characters_1260", "Keywords cannot contain escape characters."),
            Already_included_file_name_0_differs_from_file_name_1_only_in_casing: diag(1261, 1, "Already_included_file_name_0_differs_from_file_name_1_only_in_casing_1261", "Already included file name '{0}' differs from file name '{1}' only in casing."),
            Identifier_expected_0_is_a_reserved_word_at_the_top_level_of_a_module: diag(1262, 1, "Identifier_expected_0_is_a_reserved_word_at_the_top_level_of_a_module_1262", "Identifier expected. '{0}' is a reserved word at the top-level of a module."),
            Declarations_with_initializers_cannot_also_have_definite_assignment_assertions: diag(1263, 1, "Declarations_with_initializers_cannot_also_have_definite_assignment_assertions_1263", "Declarations with initializers cannot also have definite assignment assertions."),
            Declarations_with_definite_assignment_assertions_must_also_have_type_annotations: diag(1264, 1, "Declarations_with_definite_assignment_assertions_must_also_have_type_annotations_1264", "Declarations with definite assignment assertions must also have type annotations."),
            A_rest_element_cannot_follow_another_rest_element: diag(1265, 1, "A_rest_element_cannot_follow_another_rest_element_1265", "A rest element cannot follow another rest element."),
            An_optional_element_cannot_follow_a_rest_element: diag(1266, 1, "An_optional_element_cannot_follow_a_rest_element_1266", "An optional element cannot follow a rest element."),
            Property_0_cannot_have_an_initializer_because_it_is_marked_abstract: diag(1267, 1, "Property_0_cannot_have_an_initializer_because_it_is_marked_abstract_1267", "Property '{0}' cannot have an initializer because it is marked abstract."),
            An_index_signature_parameter_type_must_be_string_number_symbol_or_a_template_literal_type: diag(1268, 1, "An_index_signature_parameter_type_must_be_string_number_symbol_or_a_template_literal_type_1268", "An index signature parameter type must be 'string', 'number', 'symbol', or a template literal type."),
            Cannot_use_export_import_on_a_type_or_type_only_namespace_when_0_is_enabled: diag(1269, 1, "Cannot_use_export_import_on_a_type_or_type_only_namespace_when_0_is_enabled_1269", "Cannot use 'export import' on a type or type-only namespace when '{0}' is enabled."),
            Decorator_function_return_type_0_is_not_assignable_to_type_1: diag(1270, 1, "Decorator_function_return_type_0_is_not_assignable_to_type_1_1270", "Decorator function return type '{0}' is not assignable to type '{1}'."),
            Decorator_function_return_type_is_0_but_is_expected_to_be_void_or_any: diag(1271, 1, "Decorator_function_return_type_is_0_but_is_expected_to_be_void_or_any_1271", "Decorator function return type is '{0}' but is expected to be 'void' or 'any'."),
            A_type_referenced_in_a_decorated_signature_must_be_imported_with_import_type_or_a_namespace_import_when_isolatedModules_and_emitDecoratorMetadata_are_enabled: diag(1272, 1, "A_type_referenced_in_a_decorated_signature_must_be_imported_with_import_type_or_a_namespace_import_w_1272", "A type referenced in a decorated signature must be imported with 'import type' or a namespace import when 'isolatedModules' and 'emitDecoratorMetadata' are enabled."),
            _0_modifier_cannot_appear_on_a_type_parameter: diag(1273, 1, "_0_modifier_cannot_appear_on_a_type_parameter_1273", "'{0}' modifier cannot appear on a type parameter"),
            _0_modifier_can_only_appear_on_a_type_parameter_of_a_class_interface_or_type_alias: diag(1274, 1, "_0_modifier_can_only_appear_on_a_type_parameter_of_a_class_interface_or_type_alias_1274", "'{0}' modifier can only appear on a type parameter of a class, interface or type alias"),
            accessor_modifier_can_only_appear_on_a_property_declaration: diag(1275, 1, "accessor_modifier_can_only_appear_on_a_property_declaration_1275", "'accessor' modifier can only appear on a property declaration."),
            An_accessor_property_cannot_be_declared_optional: diag(1276, 1, "An_accessor_property_cannot_be_declared_optional_1276", "An 'accessor' property cannot be declared optional."),
            _0_modifier_can_only_appear_on_a_type_parameter_of_a_function_method_or_class: diag(1277, 1, "_0_modifier_can_only_appear_on_a_type_parameter_of_a_function_method_or_class_1277", "'{0}' modifier can only appear on a type parameter of a function, method or class"),
            The_runtime_will_invoke_the_decorator_with_1_arguments_but_the_decorator_expects_0: diag(1278, 1, "The_runtime_will_invoke_the_decorator_with_1_arguments_but_the_decorator_expects_0_1278", "The runtime will invoke the decorator with {1} arguments, but the decorator expects {0}."),
            The_runtime_will_invoke_the_decorator_with_1_arguments_but_the_decorator_expects_at_least_0: diag(1279, 1, "The_runtime_will_invoke_the_decorator_with_1_arguments_but_the_decorator_expects_at_least_0_1279", "The runtime will invoke the decorator with {1} arguments, but the decorator expects at least {0}."),
            Namespaces_are_not_allowed_in_global_script_files_when_0_is_enabled_If_this_file_is_not_intended_to_be_a_global_script_set_moduleDetection_to_force_or_add_an_empty_export_statement: diag(1280, 1, "Namespaces_are_not_allowed_in_global_script_files_when_0_is_enabled_If_this_file_is_not_intended_to__1280", "Namespaces are not allowed in global script files when '{0}' is enabled. If this file is not intended to be a global script, set 'moduleDetection' to 'force' or add an empty 'export {}' statement."),
            Cannot_access_0_from_another_file_without_qualification_when_1_is_enabled_Use_2_instead: diag(1281, 1, "Cannot_access_0_from_another_file_without_qualification_when_1_is_enabled_Use_2_instead_1281", "Cannot access '{0}' from another file without qualification when '{1}' is enabled. Use '{2}' instead."),
            An_export_declaration_must_reference_a_value_when_verbatimModuleSyntax_is_enabled_but_0_only_refers_to_a_type: diag(1282, 1, "An_export_declaration_must_reference_a_value_when_verbatimModuleSyntax_is_enabled_but_0_only_refers__1282", "An 'export =' declaration must reference a value when 'verbatimModuleSyntax' is enabled, but '{0}' only refers to a type."),
            An_export_declaration_must_reference_a_real_value_when_verbatimModuleSyntax_is_enabled_but_0_resolves_to_a_type_only_declaration: diag(1283, 1, "An_export_declaration_must_reference_a_real_value_when_verbatimModuleSyntax_is_enabled_but_0_resolve_1283", "An 'export =' declaration must reference a real value when 'verbatimModuleSyntax' is enabled, but '{0}' resolves to a type-only declaration."),
            An_export_default_must_reference_a_value_when_verbatimModuleSyntax_is_enabled_but_0_only_refers_to_a_type: diag(1284, 1, "An_export_default_must_reference_a_value_when_verbatimModuleSyntax_is_enabled_but_0_only_refers_to_a_1284", "An 'export default' must reference a value when 'verbatimModuleSyntax' is enabled, but '{0}' only refers to a type."),
            An_export_default_must_reference_a_real_value_when_verbatimModuleSyntax_is_enabled_but_0_resolves_to_a_type_only_declaration: diag(1285, 1, "An_export_default_must_reference_a_real_value_when_verbatimModuleSyntax_is_enabled_but_0_resolves_to_1285", "An 'export default' must reference a real value when 'verbatimModuleSyntax' is enabled, but '{0}' resolves to a type-only declaration."),
            ESM_syntax_is_not_allowed_in_a_CommonJS_module_when_verbatimModuleSyntax_is_enabled: diag(1286, 1, "ESM_syntax_is_not_allowed_in_a_CommonJS_module_when_verbatimModuleSyntax_is_enabled_1286", "ESM syntax is not allowed in a CommonJS module when 'verbatimModuleSyntax' is enabled."),
            A_top_level_export_modifier_cannot_be_used_on_value_declarations_in_a_CommonJS_module_when_verbatimModuleSyntax_is_enabled: diag(1287, 1, "A_top_level_export_modifier_cannot_be_used_on_value_declarations_in_a_CommonJS_module_when_verbatimM_1287", "A top-level 'export' modifier cannot be used on value declarations in a CommonJS module when 'verbatimModuleSyntax' is enabled."),
            An_import_alias_cannot_resolve_to_a_type_or_type_only_declaration_when_verbatimModuleSyntax_is_enabled: diag(1288, 1, "An_import_alias_cannot_resolve_to_a_type_or_type_only_declaration_when_verbatimModuleSyntax_is_enabl_1288", "An import alias cannot resolve to a type or type-only declaration when 'verbatimModuleSyntax' is enabled."),
            with_statements_are_not_allowed_in_an_async_function_block: diag(1300, 1, "with_statements_are_not_allowed_in_an_async_function_block_1300", "'with' statements are not allowed in an async function block."),
            await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules: diag(1308, 1, "await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules_1308", "'await' expressions are only allowed within async functions and at the top levels of modules."),
            The_current_file_is_a_CommonJS_module_and_cannot_use_await_at_the_top_level: diag(1309, 1, "The_current_file_is_a_CommonJS_module_and_cannot_use_await_at_the_top_level_1309", "The current file is a CommonJS module and cannot use 'await' at the top level."),
            Did_you_mean_to_use_a_Colon_An_can_only_follow_a_property_name_when_the_containing_object_literal_is_part_of_a_destructuring_pattern: diag(1312, 1, "Did_you_mean_to_use_a_Colon_An_can_only_follow_a_property_name_when_the_containing_object_literal_is_1312", "Did you mean to use a ':'? An '=' can only follow a property name when the containing object literal is part of a destructuring pattern."),
            The_body_of_an_if_statement_cannot_be_the_empty_statement: diag(1313, 1, "The_body_of_an_if_statement_cannot_be_the_empty_statement_1313", "The body of an 'if' statement cannot be the empty statement."),
            Global_module_exports_may_only_appear_in_module_files: diag(1314, 1, "Global_module_exports_may_only_appear_in_module_files_1314", "Global module exports may only appear in module files."),
            Global_module_exports_may_only_appear_in_declaration_files: diag(1315, 1, "Global_module_exports_may_only_appear_in_declaration_files_1315", "Global module exports may only appear in declaration files."),
            Global_module_exports_may_only_appear_at_top_level: diag(1316, 1, "Global_module_exports_may_only_appear_at_top_level_1316", "Global module exports may only appear at top level."),
            A_parameter_property_cannot_be_declared_using_a_rest_parameter: diag(1317, 1, "A_parameter_property_cannot_be_declared_using_a_rest_parameter_1317", "A parameter property cannot be declared using a rest parameter."),
            An_abstract_accessor_cannot_have_an_implementation: diag(1318, 1, "An_abstract_accessor_cannot_have_an_implementation_1318", "An abstract accessor cannot have an implementation."),
            A_default_export_can_only_be_used_in_an_ECMAScript_style_module: diag(1319, 1, "A_default_export_can_only_be_used_in_an_ECMAScript_style_module_1319", "A default export can only be used in an ECMAScript-style module."),
            Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1320, 1, "Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member_1320", "Type of 'await' operand must either be a valid promise or must not contain a callable 'then' member."),
            Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1321, 1, "Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_cal_1321", "Type of 'yield' operand in an async generator must either be a valid promise or must not contain a callable 'then' member."),
            Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1322, 1, "Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_con_1322", "Type of iterated elements of a 'yield*' operand must either be a valid promise or must not contain a callable 'then' member."),
            Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_es2022_esnext_commonjs_amd_system_umd_node16_or_nodenext: diag(1323, 1, "Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_es2022_esnext_commonjs_amd__1323", "Dynamic imports are only supported when the '--module' flag is set to 'es2020', 'es2022', 'esnext', 'commonjs', 'amd', 'system', 'umd', 'node16', or 'nodenext'."),
            Dynamic_imports_only_support_a_second_argument_when_the_module_option_is_set_to_esnext_node16_or_nodenext: diag(1324, 1, "Dynamic_imports_only_support_a_second_argument_when_the_module_option_is_set_to_esnext_node16_or_nod_1324", "Dynamic imports only support a second argument when the '--module' option is set to 'esnext', 'node16', or 'nodenext'."),
            Argument_of_dynamic_import_cannot_be_spread_element: diag(1325, 1, "Argument_of_dynamic_import_cannot_be_spread_element_1325", "Argument of dynamic import cannot be spread element."),
            This_use_of_import_is_invalid_import_calls_can_be_written_but_they_must_have_parentheses_and_cannot_have_type_arguments: diag(1326, 1, "This_use_of_import_is_invalid_import_calls_can_be_written_but_they_must_have_parentheses_and_cannot__1326", "This use of 'import' is invalid. 'import()' calls can be written, but they must have parentheses and cannot have type arguments."),
            String_literal_with_double_quotes_expected: diag(1327, 1, "String_literal_with_double_quotes_expected_1327", "String literal with double quotes expected."),
            Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_literal: diag(1328, 1, "Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_li_1328", "Property value can only be string literal, numeric literal, 'true', 'false', 'null', object literal or array literal."),
            _0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write_0: diag(1329, 1, "_0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write__1329", "'{0}' accepts too few arguments to be used as a decorator here. Did you mean to call it first and write '@{0}()'?"),
            A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly: diag(1330, 1, "A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly_1330", "A property of an interface or type literal whose type is a 'unique symbol' type must be 'readonly'."),
            A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly: diag(1331, 1, "A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly_1331", "A property of a class whose type is a 'unique symbol' type must be both 'static' and 'readonly'."),
            A_variable_whose_type_is_a_unique_symbol_type_must_be_const: diag(1332, 1, "A_variable_whose_type_is_a_unique_symbol_type_must_be_const_1332", "A variable whose type is a 'unique symbol' type must be 'const'."),
            unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name: diag(1333, 1, "unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name_1333", "'unique symbol' types may not be used on a variable declaration with a binding name."),
            unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement: diag(1334, 1, "unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement_1334", "'unique symbol' types are only allowed on variables in a variable statement."),
            unique_symbol_types_are_not_allowed_here: diag(1335, 1, "unique_symbol_types_are_not_allowed_here_1335", "'unique symbol' types are not allowed here."),
            An_index_signature_parameter_type_cannot_be_a_literal_type_or_generic_type_Consider_using_a_mapped_object_type_instead: diag(1337, 1, "An_index_signature_parameter_type_cannot_be_a_literal_type_or_generic_type_Consider_using_a_mapped_o_1337", "An index signature parameter type cannot be a literal type or generic type. Consider using a mapped object type instead."),
            infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type: diag(1338, 1, "infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type_1338", "'infer' declarations are only permitted in the 'extends' clause of a conditional type."),
            Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here: diag(1339, 1, "Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here_1339", "Module '{0}' does not refer to a value, but is used as a value here."),
            Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0: diag(1340, 1, "Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0_1340", "Module '{0}' does not refer to a type, but is used as a type here. Did you mean 'typeof import('{0}')'?"),
            Class_constructor_may_not_be_an_accessor: diag(1341, 1, "Class_constructor_may_not_be_an_accessor_1341", "Class constructor may not be an accessor."),
            The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_es2020_es2022_esnext_system_node16_or_nodenext: diag(1343, 1, "The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_es2020_es2022_esnext_system__1343", "The 'import.meta' meta-property is only allowed when the '--module' option is 'es2020', 'es2022', 'esnext', 'system', 'node16', or 'nodenext'."),
            A_label_is_not_allowed_here: diag(1344, 1, "A_label_is_not_allowed_here_1344", "'A label is not allowed here."),
            An_expression_of_type_void_cannot_be_tested_for_truthiness: diag(1345, 1, "An_expression_of_type_void_cannot_be_tested_for_truthiness_1345", "An expression of type 'void' cannot be tested for truthiness."),
            This_parameter_is_not_allowed_with_use_strict_directive: diag(1346, 1, "This_parameter_is_not_allowed_with_use_strict_directive_1346", "This parameter is not allowed with 'use strict' directive."),
            use_strict_directive_cannot_be_used_with_non_simple_parameter_list: diag(1347, 1, "use_strict_directive_cannot_be_used_with_non_simple_parameter_list_1347", "'use strict' directive cannot be used with non-simple parameter list."),
            Non_simple_parameter_declared_here: diag(1348, 1, "Non_simple_parameter_declared_here_1348", "Non-simple parameter declared here."),
            use_strict_directive_used_here: diag(1349, 1, "use_strict_directive_used_here_1349", "'use strict' directive used here."),
            Print_the_final_configuration_instead_of_building: diag(1350, 3, "Print_the_final_configuration_instead_of_building_1350", "Print the final configuration instead of building."),
            An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal: diag(1351, 1, "An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal_1351", "An identifier or keyword cannot immediately follow a numeric literal."),
            A_bigint_literal_cannot_use_exponential_notation: diag(1352, 1, "A_bigint_literal_cannot_use_exponential_notation_1352", "A bigint literal cannot use exponential notation."),
            A_bigint_literal_must_be_an_integer: diag(1353, 1, "A_bigint_literal_must_be_an_integer_1353", "A bigint literal must be an integer."),
            readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types: diag(1354, 1, "readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types_1354", "'readonly' type modifier is only permitted on array and tuple literal types."),
            A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array_or_object_literals: diag(1355, 1, "A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array__1355", "A 'const' assertions can only be applied to references to enum members, or string, number, boolean, array, or object literals."),
            Did_you_mean_to_mark_this_function_as_async: diag(1356, 1, "Did_you_mean_to_mark_this_function_as_async_1356", "Did you mean to mark this function as 'async'?"),
            An_enum_member_name_must_be_followed_by_a_or: diag(1357, 1, "An_enum_member_name_must_be_followed_by_a_or_1357", "An enum member name must be followed by a ',', '=', or '}'."),
            Tagged_template_expressions_are_not_permitted_in_an_optional_chain: diag(1358, 1, "Tagged_template_expressions_are_not_permitted_in_an_optional_chain_1358", "Tagged template expressions are not permitted in an optional chain."),
            Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here: diag(1359, 1, "Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here_1359", "Identifier expected. '{0}' is a reserved word that cannot be used here."),
            Type_0_does_not_satisfy_the_expected_type_1: diag(1360, 1, "Type_0_does_not_satisfy_the_expected_type_1_1360", "Type '{0}' does not satisfy the expected type '{1}'."),
            _0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type: diag(1361, 1, "_0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type_1361", "'{0}' cannot be used as a value because it was imported using 'import type'."),
            _0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type: diag(1362, 1, "_0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type_1362", "'{0}' cannot be used as a value because it was exported using 'export type'."),
            A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both: diag(1363, 1, "A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both_1363", "A type-only import can specify a default import or named bindings, but not both."),
            Convert_to_type_only_export: diag(1364, 3, "Convert_to_type_only_export_1364", "Convert to type-only export"),
            Convert_all_re_exported_types_to_type_only_exports: diag(1365, 3, "Convert_all_re_exported_types_to_type_only_exports_1365", "Convert all re-exported types to type-only exports"),
            Split_into_two_separate_import_declarations: diag(1366, 3, "Split_into_two_separate_import_declarations_1366", "Split into two separate import declarations"),
            Split_all_invalid_type_only_imports: diag(1367, 3, "Split_all_invalid_type_only_imports_1367", "Split all invalid type-only imports"),
            Class_constructor_may_not_be_a_generator: diag(1368, 1, "Class_constructor_may_not_be_a_generator_1368", "Class constructor may not be a generator."),
            Did_you_mean_0: diag(1369, 3, "Did_you_mean_0_1369", "Did you mean '{0}'?"),
            This_import_is_never_used_as_a_value_and_must_use_import_type_because_importsNotUsedAsValues_is_set_to_error: diag(1371, 1, "This_import_is_never_used_as_a_value_and_must_use_import_type_because_importsNotUsedAsValues_is_set__1371", "This import is never used as a value and must use 'import type' because 'importsNotUsedAsValues' is set to 'error'."),
            await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_has_no_imports_or_exports_Consider_adding_an_empty_export_to_make_this_file_a_module: diag(1375, 1, "await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_fi_1375", "'await' expressions are only allowed at the top level of a file when that file is a module, but this file has no imports or exports. Consider adding an empty 'export {}' to make this file a module."),
            _0_was_imported_here: diag(1376, 3, "_0_was_imported_here_1376", "'{0}' was imported here."),
            _0_was_exported_here: diag(1377, 3, "_0_was_exported_here_1377", "'{0}' was exported here."),
            Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_node16_or_nodenext_and_the_target_option_is_set_to_es2017_or_higher: diag(1378, 1, "Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_n_1378", "Top-level 'await' expressions are only allowed when the 'module' option is set to 'es2022', 'esnext', 'system', 'node16', or 'nodenext', and the 'target' option is set to 'es2017' or higher."),
            An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type: diag(1379, 1, "An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type_1379", "An import alias cannot reference a declaration that was exported using 'export type'."),
            An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type: diag(1380, 1, "An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type_1380", "An import alias cannot reference a declaration that was imported using 'import type'."),
            Unexpected_token_Did_you_mean_or_rbrace: diag(1381, 1, "Unexpected_token_Did_you_mean_or_rbrace_1381", "Unexpected token. Did you mean `{'}'}` or `&rbrace;`?"),
            Unexpected_token_Did_you_mean_or_gt: diag(1382, 1, "Unexpected_token_Did_you_mean_or_gt_1382", "Unexpected token. Did you mean `{'>'}` or `&gt;`?"),
            Function_type_notation_must_be_parenthesized_when_used_in_a_union_type: diag(1385, 1, "Function_type_notation_must_be_parenthesized_when_used_in_a_union_type_1385", "Function type notation must be parenthesized when used in a union type."),
            Constructor_type_notation_must_be_parenthesized_when_used_in_a_union_type: diag(1386, 1, "Constructor_type_notation_must_be_parenthesized_when_used_in_a_union_type_1386", "Constructor type notation must be parenthesized when used in a union type."),
            Function_type_notation_must_be_parenthesized_when_used_in_an_intersection_type: diag(1387, 1, "Function_type_notation_must_be_parenthesized_when_used_in_an_intersection_type_1387", "Function type notation must be parenthesized when used in an intersection type."),
            Constructor_type_notation_must_be_parenthesized_when_used_in_an_intersection_type: diag(1388, 1, "Constructor_type_notation_must_be_parenthesized_when_used_in_an_intersection_type_1388", "Constructor type notation must be parenthesized when used in an intersection type."),
            _0_is_not_allowed_as_a_variable_declaration_name: diag(1389, 1, "_0_is_not_allowed_as_a_variable_declaration_name_1389", "'{0}' is not allowed as a variable declaration name."),
            _0_is_not_allowed_as_a_parameter_name: diag(1390, 1, "_0_is_not_allowed_as_a_parameter_name_1390", "'{0}' is not allowed as a parameter name."),
            An_import_alias_cannot_use_import_type: diag(1392, 1, "An_import_alias_cannot_use_import_type_1392", "An import alias cannot use 'import type'"),
            Imported_via_0_from_file_1: diag(1393, 3, "Imported_via_0_from_file_1_1393", "Imported via {0} from file '{1}'"),
            Imported_via_0_from_file_1_with_packageId_2: diag(1394, 3, "Imported_via_0_from_file_1_with_packageId_2_1394", "Imported via {0} from file '{1}' with packageId '{2}'"),
            Imported_via_0_from_file_1_to_import_importHelpers_as_specified_in_compilerOptions: diag(1395, 3, "Imported_via_0_from_file_1_to_import_importHelpers_as_specified_in_compilerOptions_1395", "Imported via {0} from file '{1}' to import 'importHelpers' as specified in compilerOptions"),
            Imported_via_0_from_file_1_with_packageId_2_to_import_importHelpers_as_specified_in_compilerOptions: diag(1396, 3, "Imported_via_0_from_file_1_with_packageId_2_to_import_importHelpers_as_specified_in_compilerOptions_1396", "Imported via {0} from file '{1}' with packageId '{2}' to import 'importHelpers' as specified in compilerOptions"),
            Imported_via_0_from_file_1_to_import_jsx_and_jsxs_factory_functions: diag(1397, 3, "Imported_via_0_from_file_1_to_import_jsx_and_jsxs_factory_functions_1397", "Imported via {0} from file '{1}' to import 'jsx' and 'jsxs' factory functions"),
            Imported_via_0_from_file_1_with_packageId_2_to_import_jsx_and_jsxs_factory_functions: diag(1398, 3, "Imported_via_0_from_file_1_with_packageId_2_to_import_jsx_and_jsxs_factory_functions_1398", "Imported via {0} from file '{1}' with packageId '{2}' to import 'jsx' and 'jsxs' factory functions"),
            File_is_included_via_import_here: diag(1399, 3, "File_is_included_via_import_here_1399", "File is included via import here."),
            Referenced_via_0_from_file_1: diag(1400, 3, "Referenced_via_0_from_file_1_1400", "Referenced via '{0}' from file '{1}'"),
            File_is_included_via_reference_here: diag(1401, 3, "File_is_included_via_reference_here_1401", "File is included via reference here."),
            Type_library_referenced_via_0_from_file_1: diag(1402, 3, "Type_library_referenced_via_0_from_file_1_1402", "Type library referenced via '{0}' from file '{1}'"),
            Type_library_referenced_via_0_from_file_1_with_packageId_2: diag(1403, 3, "Type_library_referenced_via_0_from_file_1_with_packageId_2_1403", "Type library referenced via '{0}' from file '{1}' with packageId '{2}'"),
            File_is_included_via_type_library_reference_here: diag(1404, 3, "File_is_included_via_type_library_reference_here_1404", "File is included via type library reference here."),
            Library_referenced_via_0_from_file_1: diag(1405, 3, "Library_referenced_via_0_from_file_1_1405", "Library referenced via '{0}' from file '{1}'"),
            File_is_included_via_library_reference_here: diag(1406, 3, "File_is_included_via_library_reference_here_1406", "File is included via library reference here."),
            Matched_by_include_pattern_0_in_1: diag(1407, 3, "Matched_by_include_pattern_0_in_1_1407", "Matched by include pattern '{0}' in '{1}'"),
            File_is_matched_by_include_pattern_specified_here: diag(1408, 3, "File_is_matched_by_include_pattern_specified_here_1408", "File is matched by include pattern specified here."),
            Part_of_files_list_in_tsconfig_json: diag(1409, 3, "Part_of_files_list_in_tsconfig_json_1409", "Part of 'files' list in tsconfig.json"),
            File_is_matched_by_files_list_specified_here: diag(1410, 3, "File_is_matched_by_files_list_specified_here_1410", "File is matched by 'files' list specified here."),
            Output_from_referenced_project_0_included_because_1_specified: diag(1411, 3, "Output_from_referenced_project_0_included_because_1_specified_1411", "Output from referenced project '{0}' included because '{1}' specified"),
            Output_from_referenced_project_0_included_because_module_is_specified_as_none: diag(1412, 3, "Output_from_referenced_project_0_included_because_module_is_specified_as_none_1412", "Output from referenced project '{0}' included because '--module' is specified as 'none'"),
            File_is_output_from_referenced_project_specified_here: diag(1413, 3, "File_is_output_from_referenced_project_specified_here_1413", "File is output from referenced project specified here."),
            Source_from_referenced_project_0_included_because_1_specified: diag(1414, 3, "Source_from_referenced_project_0_included_because_1_specified_1414", "Source from referenced project '{0}' included because '{1}' specified"),
            Source_from_referenced_project_0_included_because_module_is_specified_as_none: diag(1415, 3, "Source_from_referenced_project_0_included_because_module_is_specified_as_none_1415", "Source from referenced project '{0}' included because '--module' is specified as 'none'"),
            File_is_source_from_referenced_project_specified_here: diag(1416, 3, "File_is_source_from_referenced_project_specified_here_1416", "File is source from referenced project specified here."),
            Entry_point_of_type_library_0_specified_in_compilerOptions: diag(1417, 3, "Entry_point_of_type_library_0_specified_in_compilerOptions_1417", "Entry point of type library '{0}' specified in compilerOptions"),
            Entry_point_of_type_library_0_specified_in_compilerOptions_with_packageId_1: diag(1418, 3, "Entry_point_of_type_library_0_specified_in_compilerOptions_with_packageId_1_1418", "Entry point of type library '{0}' specified in compilerOptions with packageId '{1}'"),
            File_is_entry_point_of_type_library_specified_here: diag(1419, 3, "File_is_entry_point_of_type_library_specified_here_1419", "File is entry point of type library specified here."),
            Entry_point_for_implicit_type_library_0: diag(1420, 3, "Entry_point_for_implicit_type_library_0_1420", "Entry point for implicit type library '{0}'"),
            Entry_point_for_implicit_type_library_0_with_packageId_1: diag(1421, 3, "Entry_point_for_implicit_type_library_0_with_packageId_1_1421", "Entry point for implicit type library '{0}' with packageId '{1}'"),
            Library_0_specified_in_compilerOptions: diag(1422, 3, "Library_0_specified_in_compilerOptions_1422", "Library '{0}' specified in compilerOptions"),
            File_is_library_specified_here: diag(1423, 3, "File_is_library_specified_here_1423", "File is library specified here."),
            Default_library: diag(1424, 3, "Default_library_1424", "Default library"),
            Default_library_for_target_0: diag(1425, 3, "Default_library_for_target_0_1425", "Default library for target '{0}'"),
            File_is_default_library_for_target_specified_here: diag(1426, 3, "File_is_default_library_for_target_specified_here_1426", "File is default library for target specified here."),
            Root_file_specified_for_compilation: diag(1427, 3, "Root_file_specified_for_compilation_1427", "Root file specified for compilation"),
            File_is_output_of_project_reference_source_0: diag(1428, 3, "File_is_output_of_project_reference_source_0_1428", "File is output of project reference source '{0}'"),
            File_redirects_to_file_0: diag(1429, 3, "File_redirects_to_file_0_1429", "File redirects to file '{0}'"),
            The_file_is_in_the_program_because_Colon: diag(1430, 3, "The_file_is_in_the_program_because_Colon_1430", "The file is in the program because:"),
            for_await_loops_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_has_no_imports_or_exports_Consider_adding_an_empty_export_to_make_this_file_a_module: diag(1431, 1, "for_await_loops_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_1431", "'for await' loops are only allowed at the top level of a file when that file is a module, but this file has no imports or exports. Consider adding an empty 'export {}' to make this file a module."),
            Top_level_for_await_loops_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_node16_or_nodenext_and_the_target_option_is_set_to_es2017_or_higher: diag(1432, 1, "Top_level_for_await_loops_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_nod_1432", "Top-level 'for await' loops are only allowed when the 'module' option is set to 'es2022', 'esnext', 'system', 'node16', or 'nodenext', and the 'target' option is set to 'es2017' or higher."),
            Neither_decorators_nor_modifiers_may_be_applied_to_this_parameters: diag(1433, 1, "Neither_decorators_nor_modifiers_may_be_applied_to_this_parameters_1433", "Neither decorators nor modifiers may be applied to 'this' parameters."),
            Unexpected_keyword_or_identifier: diag(1434, 1, "Unexpected_keyword_or_identifier_1434", "Unexpected keyword or identifier."),
            Unknown_keyword_or_identifier_Did_you_mean_0: diag(1435, 1, "Unknown_keyword_or_identifier_Did_you_mean_0_1435", "Unknown keyword or identifier. Did you mean '{0}'?"),
            Decorators_must_precede_the_name_and_all_keywords_of_property_declarations: diag(1436, 1, "Decorators_must_precede_the_name_and_all_keywords_of_property_declarations_1436", "Decorators must precede the name and all keywords of property declarations."),
            Namespace_must_be_given_a_name: diag(1437, 1, "Namespace_must_be_given_a_name_1437", "Namespace must be given a name."),
            Interface_must_be_given_a_name: diag(1438, 1, "Interface_must_be_given_a_name_1438", "Interface must be given a name."),
            Type_alias_must_be_given_a_name: diag(1439, 1, "Type_alias_must_be_given_a_name_1439", "Type alias must be given a name."),
            Variable_declaration_not_allowed_at_this_location: diag(1440, 1, "Variable_declaration_not_allowed_at_this_location_1440", "Variable declaration not allowed at this location."),
            Cannot_start_a_function_call_in_a_type_annotation: diag(1441, 1, "Cannot_start_a_function_call_in_a_type_annotation_1441", "Cannot start a function call in a type annotation."),
            Expected_for_property_initializer: diag(1442, 1, "Expected_for_property_initializer_1442", "Expected '=' for property initializer."),
            Module_declaration_names_may_only_use_or_quoted_strings: diag(1443, 1, "Module_declaration_names_may_only_use_or_quoted_strings_1443", `Module declaration names may only use ' or " quoted strings.`),
            _0_is_a_type_and_must_be_imported_using_a_type_only_import_when_preserveValueImports_and_isolatedModules_are_both_enabled: diag(1444, 1, "_0_is_a_type_and_must_be_imported_using_a_type_only_import_when_preserveValueImports_and_isolatedMod_1444", "'{0}' is a type and must be imported using a type-only import when 'preserveValueImports' and 'isolatedModules' are both enabled."),
            _0_resolves_to_a_type_only_declaration_and_must_be_imported_using_a_type_only_import_when_preserveValueImports_and_isolatedModules_are_both_enabled: diag(1446, 1, "_0_resolves_to_a_type_only_declaration_and_must_be_imported_using_a_type_only_import_when_preserveVa_1446", "'{0}' resolves to a type-only declaration and must be imported using a type-only import when 'preserveValueImports' and 'isolatedModules' are both enabled."),
            _0_resolves_to_a_type_only_declaration_and_must_be_re_exported_using_a_type_only_re_export_when_1_is_enabled: diag(1448, 1, "_0_resolves_to_a_type_only_declaration_and_must_be_re_exported_using_a_type_only_re_export_when_1_is_1448", "'{0}' resolves to a type-only declaration and must be re-exported using a type-only re-export when '{1}' is enabled."),
            Preserve_unused_imported_values_in_the_JavaScript_output_that_would_otherwise_be_removed: diag(1449, 3, "Preserve_unused_imported_values_in_the_JavaScript_output_that_would_otherwise_be_removed_1449", "Preserve unused imported values in the JavaScript output that would otherwise be removed."),
            Dynamic_imports_can_only_accept_a_module_specifier_and_an_optional_set_of_attributes_as_arguments: diag(1450, 3, "Dynamic_imports_can_only_accept_a_module_specifier_and_an_optional_set_of_attributes_as_arguments_1450", "Dynamic imports can only accept a module specifier and an optional set of attributes as arguments"),
            Private_identifiers_are_only_allowed_in_class_bodies_and_may_only_be_used_as_part_of_a_class_member_declaration_property_access_or_on_the_left_hand_side_of_an_in_expression: diag(1451, 1, "Private_identifiers_are_only_allowed_in_class_bodies_and_may_only_be_used_as_part_of_a_class_member__1451", "Private identifiers are only allowed in class bodies and may only be used as part of a class member declaration, property access, or on the left-hand-side of an 'in' expression"),
            resolution_mode_should_be_either_require_or_import: diag(1453, 1, "resolution_mode_should_be_either_require_or_import_1453", "`resolution-mode` should be either `require` or `import`."),
            resolution_mode_can_only_be_set_for_type_only_imports: diag(1454, 1, "resolution_mode_can_only_be_set_for_type_only_imports_1454", "`resolution-mode` can only be set for type-only imports."),
            resolution_mode_is_the_only_valid_key_for_type_import_assertions: diag(1455, 1, "resolution_mode_is_the_only_valid_key_for_type_import_assertions_1455", "`resolution-mode` is the only valid key for type import assertions."),
            Type_import_assertions_should_have_exactly_one_key_resolution_mode_with_value_import_or_require: diag(1456, 1, "Type_import_assertions_should_have_exactly_one_key_resolution_mode_with_value_import_or_require_1456", "Type import assertions should have exactly one key - `resolution-mode` - with value `import` or `require`."),
            Matched_by_default_include_pattern_Asterisk_Asterisk_Slash_Asterisk: diag(1457, 3, "Matched_by_default_include_pattern_Asterisk_Asterisk_Slash_Asterisk_1457", "Matched by default include pattern '**/*'"),
            File_is_ECMAScript_module_because_0_has_field_type_with_value_module: diag(1458, 3, "File_is_ECMAScript_module_because_0_has_field_type_with_value_module_1458", `File is ECMAScript module because '{0}' has field "type" with value "module"`),
            File_is_CommonJS_module_because_0_has_field_type_whose_value_is_not_module: diag(1459, 3, "File_is_CommonJS_module_because_0_has_field_type_whose_value_is_not_module_1459", `File is CommonJS module because '{0}' has field "type" whose value is not "module"`),
            File_is_CommonJS_module_because_0_does_not_have_field_type: diag(1460, 3, "File_is_CommonJS_module_because_0_does_not_have_field_type_1460", `File is CommonJS module because '{0}' does not have field "type"`),
            File_is_CommonJS_module_because_package_json_was_not_found: diag(1461, 3, "File_is_CommonJS_module_because_package_json_was_not_found_1461", "File is CommonJS module because 'package.json' was not found"),
            resolution_mode_is_the_only_valid_key_for_type_import_attributes: diag(1463, 1, "resolution_mode_is_the_only_valid_key_for_type_import_attributes_1463", "'resolution-mode' is the only valid key for type import attributes."),
            Type_import_attributes_should_have_exactly_one_key_resolution_mode_with_value_import_or_require: diag(1464, 1, "Type_import_attributes_should_have_exactly_one_key_resolution_mode_with_value_import_or_require_1464", "Type import attributes should have exactly one key - 'resolution-mode' - with value 'import' or 'require'."),
            The_import_meta_meta_property_is_not_allowed_in_files_which_will_build_into_CommonJS_output: diag(1470, 1, "The_import_meta_meta_property_is_not_allowed_in_files_which_will_build_into_CommonJS_output_1470", "The 'import.meta' meta-property is not allowed in files which will build into CommonJS output."),
            Module_0_cannot_be_imported_using_this_construct_The_specifier_only_resolves_to_an_ES_module_which_cannot_be_imported_with_require_Use_an_ECMAScript_import_instead: diag(1471, 1, "Module_0_cannot_be_imported_using_this_construct_The_specifier_only_resolves_to_an_ES_module_which_c_1471", "Module '{0}' cannot be imported using this construct. The specifier only resolves to an ES module, which cannot be imported with 'require'. Use an ECMAScript import instead."),
            catch_or_finally_expected: diag(1472, 1, "catch_or_finally_expected_1472", "'catch' or 'finally' expected."),
            An_import_declaration_can_only_be_used_at_the_top_level_of_a_module: diag(1473, 1, "An_import_declaration_can_only_be_used_at_the_top_level_of_a_module_1473", "An import declaration can only be used at the top level of a module."),
            An_export_declaration_can_only_be_used_at_the_top_level_of_a_module: diag(1474, 1, "An_export_declaration_can_only_be_used_at_the_top_level_of_a_module_1474", "An export declaration can only be used at the top level of a module."),
            Control_what_method_is_used_to_detect_module_format_JS_files: diag(1475, 3, "Control_what_method_is_used_to_detect_module_format_JS_files_1475", "Control what method is used to detect module-format JS files."),
            auto_Colon_Treat_files_with_imports_exports_import_meta_jsx_with_jsx_Colon_react_jsx_or_esm_format_with_module_Colon_node16_as_modules: diag(1476, 3, "auto_Colon_Treat_files_with_imports_exports_import_meta_jsx_with_jsx_Colon_react_jsx_or_esm_format_w_1476", '"auto": Treat files with imports, exports, import.meta, jsx (with jsx: react-jsx), or esm format (with module: node16+) as modules.'),
            An_instantiation_expression_cannot_be_followed_by_a_property_access: diag(1477, 1, "An_instantiation_expression_cannot_be_followed_by_a_property_access_1477", "An instantiation expression cannot be followed by a property access."),
            Identifier_or_string_literal_expected: diag(1478, 1, "Identifier_or_string_literal_expected_1478", "Identifier or string literal expected."),
            The_current_file_is_a_CommonJS_module_whose_imports_will_produce_require_calls_however_the_referenced_file_is_an_ECMAScript_module_and_cannot_be_imported_with_require_Consider_writing_a_dynamic_import_0_call_instead: diag(1479, 1, "The_current_file_is_a_CommonJS_module_whose_imports_will_produce_require_calls_however_the_reference_1479", `The current file is a CommonJS module whose imports will produce 'require' calls; however, the referenced file is an ECMAScript module and cannot be imported with 'require'. Consider writing a dynamic 'import("{0}")' call instead.`),
            To_convert_this_file_to_an_ECMAScript_module_change_its_file_extension_to_0_or_create_a_local_package_json_file_with_type_Colon_module: diag(1480, 3, "To_convert_this_file_to_an_ECMAScript_module_change_its_file_extension_to_0_or_create_a_local_packag_1480", 'To convert this file to an ECMAScript module, change its file extension to \'{0}\' or create a local package.json file with `{ "type": "module" }`.'),
            To_convert_this_file_to_an_ECMAScript_module_change_its_file_extension_to_0_or_add_the_field_type_Colon_module_to_1: diag(1481, 3, "To_convert_this_file_to_an_ECMAScript_module_change_its_file_extension_to_0_or_add_the_field_type_Co_1481", `To convert this file to an ECMAScript module, change its file extension to '{0}', or add the field \`"type": "module"\` to '{1}'.`),
            To_convert_this_file_to_an_ECMAScript_module_add_the_field_type_Colon_module_to_0: diag(1482, 3, "To_convert_this_file_to_an_ECMAScript_module_add_the_field_type_Colon_module_to_0_1482", 'To convert this file to an ECMAScript module, add the field `"type": "module"` to \'{0}\'.'),
            To_convert_this_file_to_an_ECMAScript_module_create_a_local_package_json_file_with_type_Colon_module: diag(1483, 3, "To_convert_this_file_to_an_ECMAScript_module_create_a_local_package_json_file_with_type_Colon_module_1483", 'To convert this file to an ECMAScript module, create a local package.json file with `{ "type": "module" }`.'),
            _0_is_a_type_and_must_be_imported_using_a_type_only_import_when_verbatimModuleSyntax_is_enabled: diag(1484, 1, "_0_is_a_type_and_must_be_imported_using_a_type_only_import_when_verbatimModuleSyntax_is_enabled_1484", "'{0}' is a type and must be imported using a type-only import when 'verbatimModuleSyntax' is enabled."),
            _0_resolves_to_a_type_only_declaration_and_must_be_imported_using_a_type_only_import_when_verbatimModuleSyntax_is_enabled: diag(1485, 1, "_0_resolves_to_a_type_only_declaration_and_must_be_imported_using_a_type_only_import_when_verbatimMo_1485", "'{0}' resolves to a type-only declaration and must be imported using a type-only import when 'verbatimModuleSyntax' is enabled."),
            Decorator_used_before_export_here: diag(1486, 1, "Decorator_used_before_export_here_1486", "Decorator used before 'export' here."),
            Octal_escape_sequences_are_not_allowed_Use_the_syntax_0: diag(1487, 1, "Octal_escape_sequences_are_not_allowed_Use_the_syntax_0_1487", "Octal escape sequences are not allowed. Use the syntax '{0}'."),
            Escape_sequence_0_is_not_allowed: diag(1488, 1, "Escape_sequence_0_is_not_allowed_1488", "Escape sequence '{0}' is not allowed."),
            Decimals_with_leading_zeros_are_not_allowed: diag(1489, 1, "Decimals_with_leading_zeros_are_not_allowed_1489", "Decimals with leading zeros are not allowed."),
            File_appears_to_be_binary: diag(1490, 1, "File_appears_to_be_binary_1490", "File appears to be binary."),
            _0_modifier_cannot_appear_on_a_using_declaration: diag(1491, 1, "_0_modifier_cannot_appear_on_a_using_declaration_1491", "'{0}' modifier cannot appear on a 'using' declaration."),
            _0_declarations_may_not_have_binding_patterns: diag(1492, 1, "_0_declarations_may_not_have_binding_patterns_1492", "'{0}' declarations may not have binding patterns."),
            The_left_hand_side_of_a_for_in_statement_cannot_be_a_using_declaration: diag(1493, 1, "The_left_hand_side_of_a_for_in_statement_cannot_be_a_using_declaration_1493", "The left-hand side of a 'for...in' statement cannot be a 'using' declaration."),
            The_left_hand_side_of_a_for_in_statement_cannot_be_an_await_using_declaration: diag(1494, 1, "The_left_hand_side_of_a_for_in_statement_cannot_be_an_await_using_declaration_1494", "The left-hand side of a 'for...in' statement cannot be an 'await using' declaration."),
            _0_modifier_cannot_appear_on_an_await_using_declaration: diag(1495, 1, "_0_modifier_cannot_appear_on_an_await_using_declaration_1495", "'{0}' modifier cannot appear on an 'await using' declaration."),
            Identifier_string_literal_or_number_literal_expected: diag(1496, 1, "Identifier_string_literal_or_number_literal_expected_1496", "Identifier, string literal, or number literal expected."),
            The_types_of_0_are_incompatible_between_these_types: diag(2200, 1, "The_types_of_0_are_incompatible_between_these_types_2200", "The types of '{0}' are incompatible between these types."),
            The_types_returned_by_0_are_incompatible_between_these_types: diag(2201, 1, "The_types_returned_by_0_are_incompatible_between_these_types_2201", "The types returned by '{0}' are incompatible between these types."),
            Call_signature_return_types_0_and_1_are_incompatible: diag(
              2202,
              1,
              "Call_signature_return_types_0_and_1_are_incompatible_2202",
              "Call signature return types '{0}' and '{1}' are incompatible.",
              /*reportsUnnecessary*/
              void 0,
              /*elidedInCompatabilityPyramid*/
              true
            ),
            Construct_signature_return_types_0_and_1_are_incompatible: diag(
              2203,
              1,
              "Construct_signature_return_types_0_and_1_are_incompatible_2203",
              "Construct signature return types '{0}' and '{1}' are incompatible.",
              /*reportsUnnecessary*/
              void 0,
              /*elidedInCompatabilityPyramid*/
              true
            ),
            Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1: diag(
              2204,
              1,
              "Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2204",
              "Call signatures with no arguments have incompatible return types '{0}' and '{1}'.",
              /*reportsUnnecessary*/
              void 0,
              /*elidedInCompatabilityPyramid*/
              true
            ),
            Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1: diag(
              2205,
              1,
              "Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2205",
              "Construct signatures with no arguments have incompatible return types '{0}' and '{1}'.",
              /*reportsUnnecessary*/
              void 0,
              /*elidedInCompatabilityPyramid*/
              true
            ),
            The_type_modifier_cannot_be_used_on_a_named_import_when_import_type_is_used_on_its_import_statement: diag(2206, 1, "The_type_modifier_cannot_be_used_on_a_named_import_when_import_type_is_used_on_its_import_statement_2206", "The 'type' modifier cannot be used on a named import when 'import type' is used on its import statement."),
            The_type_modifier_cannot_be_used_on_a_named_export_when_export_type_is_used_on_its_export_statement: diag(2207, 1, "The_type_modifier_cannot_be_used_on_a_named_export_when_export_type_is_used_on_its_export_statement_2207", "The 'type' modifier cannot be used on a named export when 'export type' is used on its export statement."),
            This_type_parameter_might_need_an_extends_0_constraint: diag(2208, 1, "This_type_parameter_might_need_an_extends_0_constraint_2208", "This type parameter might need an `extends {0}` constraint."),
            The_project_root_is_ambiguous_but_is_required_to_resolve_export_map_entry_0_in_file_1_Supply_the_rootDir_compiler_option_to_disambiguate: diag(2209, 1, "The_project_root_is_ambiguous_but_is_required_to_resolve_export_map_entry_0_in_file_1_Supply_the_roo_2209", "The project root is ambiguous, but is required to resolve export map entry '{0}' in file '{1}'. Supply the `rootDir` compiler option to disambiguate."),
            The_project_root_is_ambiguous_but_is_required_to_resolve_import_map_entry_0_in_file_1_Supply_the_rootDir_compiler_option_to_disambiguate: diag(2210, 1, "The_project_root_is_ambiguous_but_is_required_to_resolve_import_map_entry_0_in_file_1_Supply_the_roo_2210", "The project root is ambiguous, but is required to resolve import map entry '{0}' in file '{1}'. Supply the `rootDir` compiler option to disambiguate."),
            Add_extends_constraint: diag(2211, 3, "Add_extends_constraint_2211", "Add `extends` constraint."),
            Add_extends_constraint_to_all_type_parameters: diag(2212, 3, "Add_extends_constraint_to_all_type_parameters_2212", "Add `extends` constraint to all type parameters"),
            Duplicate_identifier_0: diag(2300, 1, "Duplicate_identifier_0_2300", "Duplicate identifier '{0}'."),
            Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor: diag(2301, 1, "Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor_2301", "Initializer of instance member variable '{0}' cannot reference identifier '{1}' declared in the constructor."),
            Static_members_cannot_reference_class_type_parameters: diag(2302, 1, "Static_members_cannot_reference_class_type_parameters_2302", "Static members cannot reference class type parameters."),
            Circular_definition_of_import_alias_0: diag(2303, 1, "Circular_definition_of_import_alias_0_2303", "Circular definition of import alias '{0}'."),
            Cannot_find_name_0: diag(2304, 1, "Cannot_find_name_0_2304", "Cannot find name '{0}'."),
            Module_0_has_no_exported_member_1: diag(2305, 1, "Module_0_has_no_exported_member_1_2305", "Module '{0}' has no exported member '{1}'."),
            File_0_is_not_a_module: diag(2306, 1, "File_0_is_not_a_module_2306", "File '{0}' is not a module."),
            Cannot_find_module_0_or_its_corresponding_type_declarations: diag(2307, 1, "Cannot_find_module_0_or_its_corresponding_type_declarations_2307", "Cannot find module '{0}' or its corresponding type declarations."),
            Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambiguity: diag(2308, 1, "Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambig_2308", "Module {0} has already exported a member named '{1}'. Consider explicitly re-exporting to resolve the ambiguity."),
            An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements: diag(2309, 1, "An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements_2309", "An export assignment cannot be used in a module with other exported elements."),
            Type_0_recursively_references_itself_as_a_base_type: diag(2310, 1, "Type_0_recursively_references_itself_as_a_base_type_2310", "Type '{0}' recursively references itself as a base type."),
            Cannot_find_name_0_Did_you_mean_to_write_this_in_an_async_function: diag(2311, 1, "Cannot_find_name_0_Did_you_mean_to_write_this_in_an_async_function_2311", "Cannot find name '{0}'. Did you mean to write this in an async function?"),
            An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2312, 1, "An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_me_2312", "An interface can only extend an object type or intersection of object types with statically known members."),
            Type_parameter_0_has_a_circular_constraint: diag(2313, 1, "Type_parameter_0_has_a_circular_constraint_2313", "Type parameter '{0}' has a circular constraint."),
            Generic_type_0_requires_1_type_argument_s: diag(2314, 1, "Generic_type_0_requires_1_type_argument_s_2314", "Generic type '{0}' requires {1} type argument(s)."),
            Type_0_is_not_generic: diag(2315, 1, "Type_0_is_not_generic_2315", "Type '{0}' is not generic."),
            Global_type_0_must_be_a_class_or_interface_type: diag(2316, 1, "Global_type_0_must_be_a_class_or_interface_type_2316", "Global type '{0}' must be a class or interface type."),
            Global_type_0_must_have_1_type_parameter_s: diag(2317, 1, "Global_type_0_must_have_1_type_parameter_s_2317", "Global type '{0}' must have {1} type parameter(s)."),
            Cannot_find_global_type_0: diag(2318, 1, "Cannot_find_global_type_0_2318", "Cannot find global type '{0}'."),
            Named_property_0_of_types_1_and_2_are_not_identical: diag(2319, 1, "Named_property_0_of_types_1_and_2_are_not_identical_2319", "Named property '{0}' of types '{1}' and '{2}' are not identical."),
            Interface_0_cannot_simultaneously_extend_types_1_and_2: diag(2320, 1, "Interface_0_cannot_simultaneously_extend_types_1_and_2_2320", "Interface '{0}' cannot simultaneously extend types '{1}' and '{2}'."),
            Excessive_stack_depth_comparing_types_0_and_1: diag(2321, 1, "Excessive_stack_depth_comparing_types_0_and_1_2321", "Excessive stack depth comparing types '{0}' and '{1}'."),
            Type_0_is_not_assignable_to_type_1: diag(2322, 1, "Type_0_is_not_assignable_to_type_1_2322", "Type '{0}' is not assignable to type '{1}'."),
            Cannot_redeclare_exported_variable_0: diag(2323, 1, "Cannot_redeclare_exported_variable_0_2323", "Cannot redeclare exported variable '{0}'."),
            Property_0_is_missing_in_type_1: diag(2324, 1, "Property_0_is_missing_in_type_1_2324", "Property '{0}' is missing in type '{1}'."),
            Property_0_is_private_in_type_1_but_not_in_type_2: diag(2325, 1, "Property_0_is_private_in_type_1_but_not_in_type_2_2325", "Property '{0}' is private in type '{1}' but not in type '{2}'."),
            Types_of_property_0_are_incompatible: diag(2326, 1, "Types_of_property_0_are_incompatible_2326", "Types of property '{0}' are incompatible."),
            Property_0_is_optional_in_type_1_but_required_in_type_2: diag(2327, 1, "Property_0_is_optional_in_type_1_but_required_in_type_2_2327", "Property '{0}' is optional in type '{1}' but required in type '{2}'."),
            Types_of_parameters_0_and_1_are_incompatible: diag(2328, 1, "Types_of_parameters_0_and_1_are_incompatible_2328", "Types of parameters '{0}' and '{1}' are incompatible."),
            Index_signature_for_type_0_is_missing_in_type_1: diag(2329, 1, "Index_signature_for_type_0_is_missing_in_type_1_2329", "Index signature for type '{0}' is missing in type '{1}'."),
            _0_and_1_index_signatures_are_incompatible: diag(2330, 1, "_0_and_1_index_signatures_are_incompatible_2330", "'{0}' and '{1}' index signatures are incompatible."),
            this_cannot_be_referenced_in_a_module_or_namespace_body: diag(2331, 1, "this_cannot_be_referenced_in_a_module_or_namespace_body_2331", "'this' cannot be referenced in a module or namespace body."),
            this_cannot_be_referenced_in_current_location: diag(2332, 1, "this_cannot_be_referenced_in_current_location_2332", "'this' cannot be referenced in current location."),
            this_cannot_be_referenced_in_constructor_arguments: diag(2333, 1, "this_cannot_be_referenced_in_constructor_arguments_2333", "'this' cannot be referenced in constructor arguments."),
            this_cannot_be_referenced_in_a_static_property_initializer: diag(2334, 1, "this_cannot_be_referenced_in_a_static_property_initializer_2334", "'this' cannot be referenced in a static property initializer."),
            super_can_only_be_referenced_in_a_derived_class: diag(2335, 1, "super_can_only_be_referenced_in_a_derived_class_2335", "'super' can only be referenced in a derived class."),
            super_cannot_be_referenced_in_constructor_arguments: diag(2336, 1, "super_cannot_be_referenced_in_constructor_arguments_2336", "'super' cannot be referenced in constructor arguments."),
            Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors: diag(2337, 1, "Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors_2337", "Super calls are not permitted outside constructors or in nested functions inside constructors."),
            super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_derived_class: diag(2338, 1, "super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_der_2338", "'super' property access is permitted only in a constructor, member function, or member accessor of a derived class."),
            Property_0_does_not_exist_on_type_1: diag(2339, 1, "Property_0_does_not_exist_on_type_1_2339", "Property '{0}' does not exist on type '{1}'."),
            Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword: diag(2340, 1, "Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword_2340", "Only public and protected methods of the base class are accessible via the 'super' keyword."),
            Property_0_is_private_and_only_accessible_within_class_1: diag(2341, 1, "Property_0_is_private_and_only_accessible_within_class_1_2341", "Property '{0}' is private and only accessible within class '{1}'."),
            This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_version_of_0: diag(2343, 1, "This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_ve_2343", "This syntax requires an imported helper named '{1}' which does not exist in '{0}'. Consider upgrading your version of '{0}'."),
            Type_0_does_not_satisfy_the_constraint_1: diag(2344, 1, "Type_0_does_not_satisfy_the_constraint_1_2344", "Type '{0}' does not satisfy the constraint '{1}'."),
            Argument_of_type_0_is_not_assignable_to_parameter_of_type_1: diag(2345, 1, "Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_2345", "Argument of type '{0}' is not assignable to parameter of type '{1}'."),
            Untyped_function_calls_may_not_accept_type_arguments: diag(2347, 1, "Untyped_function_calls_may_not_accept_type_arguments_2347", "Untyped function calls may not accept type arguments."),
            Value_of_type_0_is_not_callable_Did_you_mean_to_include_new: diag(2348, 1, "Value_of_type_0_is_not_callable_Did_you_mean_to_include_new_2348", "Value of type '{0}' is not callable. Did you mean to include 'new'?"),
            This_expression_is_not_callable: diag(2349, 1, "This_expression_is_not_callable_2349", "This expression is not callable."),
            Only_a_void_function_can_be_called_with_the_new_keyword: diag(2350, 1, "Only_a_void_function_can_be_called_with_the_new_keyword_2350", "Only a void function can be called with the 'new' keyword."),
            This_expression_is_not_constructable: diag(2351, 1, "This_expression_is_not_constructable_2351", "This expression is not constructable."),
            Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the_other_If_this_was_intentional_convert_the_expression_to_unknown_first: diag(2352, 1, "Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the__2352", "Conversion of type '{0}' to type '{1}' may be a mistake because neither type sufficiently overlaps with the other. If this was intentional, convert the expression to 'unknown' first."),
            Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1: diag(2353, 1, "Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1_2353", "Object literal may only specify known properties, and '{0}' does not exist in type '{1}'."),
            This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found: diag(2354, 1, "This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found_2354", "This syntax requires an imported helper but module '{0}' cannot be found."),
            A_function_whose_declared_type_is_neither_undefined_void_nor_any_must_return_a_value: diag(2355, 1, "A_function_whose_declared_type_is_neither_undefined_void_nor_any_must_return_a_value_2355", "A function whose declared type is neither 'undefined', 'void', nor 'any' must return a value."),
            An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2356, 1, "An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type_2356", "An arithmetic operand must be of type 'any', 'number', 'bigint' or an enum type."),
            The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access: diag(2357, 1, "The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access_2357", "The operand of an increment or decrement operator must be a variable or a property access."),
            The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_parameter: diag(2358, 1, "The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_paramete_2358", "The left-hand side of an 'instanceof' expression must be of type 'any', an object type or a type parameter."),
            The_right_hand_side_of_an_instanceof_expression_must_be_either_of_type_any_a_class_function_or_other_type_assignable_to_the_Function_interface_type_or_an_object_type_with_a_Symbol_hasInstance_method: diag(2359, 1, "The_right_hand_side_of_an_instanceof_expression_must_be_either_of_type_any_a_class_function_or_other_2359", "The right-hand side of an 'instanceof' expression must be either of type 'any', a class, function, or other type assignable to the 'Function' interface type, or an object type with a 'Symbol.hasInstance' method."),
            The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2362, 1, "The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2362", "The left-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),
            The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2363, 1, "The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2363", "The right-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),
            The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access: diag(2364, 1, "The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access_2364", "The left-hand side of an assignment expression must be a variable or a property access."),
            Operator_0_cannot_be_applied_to_types_1_and_2: diag(2365, 1, "Operator_0_cannot_be_applied_to_types_1_and_2_2365", "Operator '{0}' cannot be applied to types '{1}' and '{2}'."),
            Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined: diag(2366, 1, "Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined_2366", "Function lacks ending return statement and return type does not include 'undefined'."),
            This_comparison_appears_to_be_unintentional_because_the_types_0_and_1_have_no_overlap: diag(2367, 1, "This_comparison_appears_to_be_unintentional_because_the_types_0_and_1_have_no_overlap_2367", "This comparison appears to be unintentional because the types '{0}' and '{1}' have no overlap."),
            Type_parameter_name_cannot_be_0: diag(2368, 1, "Type_parameter_name_cannot_be_0_2368", "Type parameter name cannot be '{0}'."),
            A_parameter_property_is_only_allowed_in_a_constructor_implementation: diag(2369, 1, "A_parameter_property_is_only_allowed_in_a_constructor_implementation_2369", "A parameter property is only allowed in a constructor implementation."),
            A_rest_parameter_must_be_of_an_array_type: diag(2370, 1, "A_rest_parameter_must_be_of_an_array_type_2370", "A rest parameter must be of an array type."),
            A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation: diag(2371, 1, "A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation_2371", "A parameter initializer is only allowed in a function or constructor implementation."),
            Parameter_0_cannot_reference_itself: diag(2372, 1, "Parameter_0_cannot_reference_itself_2372", "Parameter '{0}' cannot reference itself."),
            Parameter_0_cannot_reference_identifier_1_declared_after_it: diag(2373, 1, "Parameter_0_cannot_reference_identifier_1_declared_after_it_2373", "Parameter '{0}' cannot reference identifier '{1}' declared after it."),
            Duplicate_index_signature_for_type_0: diag(2374, 1, "Duplicate_index_signature_for_type_0_2374", "Duplicate index signature for type '{0}'."),
            Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefined_to_the_types_of_the_target_s_properties: diag(2375, 1, "Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefi_2375", "Type '{0}' is not assignable to type '{1}' with 'exactOptionalPropertyTypes: true'. Consider adding 'undefined' to the types of the target's properties."),
            A_super_call_must_be_the_first_statement_in_the_constructor_to_refer_to_super_or_this_when_a_derived_class_contains_initialized_properties_parameter_properties_or_private_identifiers: diag(2376, 1, "A_super_call_must_be_the_first_statement_in_the_constructor_to_refer_to_super_or_this_when_a_derived_2376", "A 'super' call must be the first statement in the constructor to refer to 'super' or 'this' when a derived class contains initialized properties, parameter properties, or private identifiers."),
            Constructors_for_derived_classes_must_contain_a_super_call: diag(2377, 1, "Constructors_for_derived_classes_must_contain_a_super_call_2377", "Constructors for derived classes must contain a 'super' call."),
            A_get_accessor_must_return_a_value: diag(2378, 1, "A_get_accessor_must_return_a_value_2378", "A 'get' accessor must return a value."),
            Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefined_to_the_types_of_the_target_s_properties: diag(2379, 1, "Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_with_exactOptionalPropertyTypes_Colon_tr_2379", "Argument of type '{0}' is not assignable to parameter of type '{1}' with 'exactOptionalPropertyTypes: true'. Consider adding 'undefined' to the types of the target's properties."),
            Overload_signatures_must_all_be_exported_or_non_exported: diag(2383, 1, "Overload_signatures_must_all_be_exported_or_non_exported_2383", "Overload signatures must all be exported or non-exported."),
            Overload_signatures_must_all_be_ambient_or_non_ambient: diag(2384, 1, "Overload_signatures_must_all_be_ambient_or_non_ambient_2384", "Overload signatures must all be ambient or non-ambient."),
            Overload_signatures_must_all_be_public_private_or_protected: diag(2385, 1, "Overload_signatures_must_all_be_public_private_or_protected_2385", "Overload signatures must all be public, private or protected."),
            Overload_signatures_must_all_be_optional_or_required: diag(2386, 1, "Overload_signatures_must_all_be_optional_or_required_2386", "Overload signatures must all be optional or required."),
            Function_overload_must_be_static: diag(2387, 1, "Function_overload_must_be_static_2387", "Function overload must be static."),
            Function_overload_must_not_be_static: diag(2388, 1, "Function_overload_must_not_be_static_2388", "Function overload must not be static."),
            Function_implementation_name_must_be_0: diag(2389, 1, "Function_implementation_name_must_be_0_2389", "Function implementation name must be '{0}'."),
            Constructor_implementation_is_missing: diag(2390, 1, "Constructor_implementation_is_missing_2390", "Constructor implementation is missing."),
            Function_implementation_is_missing_or_not_immediately_following_the_declaration: diag(2391, 1, "Function_implementation_is_missing_or_not_immediately_following_the_declaration_2391", "Function implementation is missing or not immediately following the declaration."),
            Multiple_constructor_implementations_are_not_allowed: diag(2392, 1, "Multiple_constructor_implementations_are_not_allowed_2392", "Multiple constructor implementations are not allowed."),
            Duplicate_function_implementation: diag(2393, 1, "Duplicate_function_implementation_2393", "Duplicate function implementation."),
            This_overload_signature_is_not_compatible_with_its_implementation_signature: diag(2394, 1, "This_overload_signature_is_not_compatible_with_its_implementation_signature_2394", "This overload signature is not compatible with its implementation signature."),
            Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local: diag(2395, 1, "Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local_2395", "Individual declarations in merged declaration '{0}' must be all exported or all local."),
            Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters: diag(2396, 1, "Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters_2396", "Duplicate identifier 'arguments'. Compiler uses 'arguments' to initialize rest parameters."),
            Declaration_name_conflicts_with_built_in_global_identifier_0: diag(2397, 1, "Declaration_name_conflicts_with_built_in_global_identifier_0_2397", "Declaration name conflicts with built-in global identifier '{0}'."),
            constructor_cannot_be_used_as_a_parameter_property_name: diag(2398, 1, "constructor_cannot_be_used_as_a_parameter_property_name_2398", "'constructor' cannot be used as a parameter property name."),
            Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference: diag(2399, 1, "Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference_2399", "Duplicate identifier '_this'. Compiler uses variable declaration '_this' to capture 'this' reference."),
            Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference: diag(2400, 1, "Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference_2400", "Expression resolves to variable declaration '_this' that compiler uses to capture 'this' reference."),
            A_super_call_must_be_a_root_level_statement_within_a_constructor_of_a_derived_class_that_contains_initialized_properties_parameter_properties_or_private_identifiers: diag(2401, 1, "A_super_call_must_be_a_root_level_statement_within_a_constructor_of_a_derived_class_that_contains_in_2401", "A 'super' call must be a root-level statement within a constructor of a derived class that contains initialized properties, parameter properties, or private identifiers."),
            Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference: diag(2402, 1, "Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference_2402", "Expression resolves to '_super' that compiler uses to capture base class reference."),
            Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_type_2: diag(2403, 1, "Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_t_2403", "Subsequent variable declarations must have the same type.  Variable '{0}' must be of type '{1}', but here has type '{2}'."),
            The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation: diag(2404, 1, "The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation_2404", "The left-hand side of a 'for...in' statement cannot use a type annotation."),
            The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any: diag(2405, 1, "The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any_2405", "The left-hand side of a 'for...in' statement must be of type 'string' or 'any'."),
            The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access: diag(2406, 1, "The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access_2406", "The left-hand side of a 'for...in' statement must be a variable or a property access."),
            The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_here_has_type_0: diag(2407, 1, "The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_2407", "The right-hand side of a 'for...in' statement must be of type 'any', an object type or a type parameter, but here has type '{0}'."),
            Setters_cannot_return_a_value: diag(2408, 1, "Setters_cannot_return_a_value_2408", "Setters cannot return a value."),
            Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class: diag(2409, 1, "Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class_2409", "Return type of constructor signature must be assignable to the instance type of the class."),
            The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any: diag(2410, 1, "The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any_2410", "The 'with' statement is not supported. All symbols in a 'with' block will have type 'any'."),
            Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefined_to_the_type_of_the_target: diag(2412, 1, "Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefi_2412", "Type '{0}' is not assignable to type '{1}' with 'exactOptionalPropertyTypes: true'. Consider adding 'undefined' to the type of the target."),
            Property_0_of_type_1_is_not_assignable_to_2_index_type_3: diag(2411, 1, "Property_0_of_type_1_is_not_assignable_to_2_index_type_3_2411", "Property '{0}' of type '{1}' is not assignable to '{2}' index type '{3}'."),
            _0_index_type_1_is_not_assignable_to_2_index_type_3: diag(2413, 1, "_0_index_type_1_is_not_assignable_to_2_index_type_3_2413", "'{0}' index type '{1}' is not assignable to '{2}' index type '{3}'."),
            Class_name_cannot_be_0: diag(2414, 1, "Class_name_cannot_be_0_2414", "Class name cannot be '{0}'."),
            Class_0_incorrectly_extends_base_class_1: diag(2415, 1, "Class_0_incorrectly_extends_base_class_1_2415", "Class '{0}' incorrectly extends base class '{1}'."),
            Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2: diag(2416, 1, "Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2_2416", "Property '{0}' in type '{1}' is not assignable to the same property in base type '{2}'."),
            Class_static_side_0_incorrectly_extends_base_class_static_side_1: diag(2417, 1, "Class_static_side_0_incorrectly_extends_base_class_static_side_1_2417", "Class static side '{0}' incorrectly extends base class static side '{1}'."),
            Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1: diag(2418, 1, "Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1_2418", "Type of computed property's value is '{0}', which is not assignable to type '{1}'."),
            Types_of_construct_signatures_are_incompatible: diag(2419, 1, "Types_of_construct_signatures_are_incompatible_2419", "Types of construct signatures are incompatible."),
            Class_0_incorrectly_implements_interface_1: diag(2420, 1, "Class_0_incorrectly_implements_interface_1_2420", "Class '{0}' incorrectly implements interface '{1}'."),
            A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2422, 1, "A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_memb_2422", "A class can only implement an object type or intersection of object types with statically known members."),
            Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_accessor: diag(2423, 1, "Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_access_2423", "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member accessor."),
            Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_function: diag(2425, 1, "Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_functi_2425", "Class '{0}' defines instance member property '{1}', but extended class '{2}' defines it as instance member function."),
            Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_function: diag(2426, 1, "Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_functi_2426", "Class '{0}' defines instance member accessor '{1}', but extended class '{2}' defines it as instance member function."),
            Interface_name_cannot_be_0: diag(2427, 1, "Interface_name_cannot_be_0_2427", "Interface name cannot be '{0}'."),
            All_declarations_of_0_must_have_identical_type_parameters: diag(2428, 1, "All_declarations_of_0_must_have_identical_type_parameters_2428", "All declarations of '{0}' must have identical type parameters."),
            Interface_0_incorrectly_extends_interface_1: diag(2430, 1, "Interface_0_incorrectly_extends_interface_1_2430", "Interface '{0}' incorrectly extends interface '{1}'."),
            Enum_name_cannot_be_0: diag(2431, 1, "Enum_name_cannot_be_0_2431", "Enum name cannot be '{0}'."),
            In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enum_element: diag(2432, 1, "In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enu_2432", "In an enum with multiple declarations, only one declaration can omit an initializer for its first enum element."),
            A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merged: diag(2433, 1, "A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merg_2433", "A namespace declaration cannot be in a different file from a class or function with which it is merged."),
            A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged: diag(2434, 1, "A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged_2434", "A namespace declaration cannot be located prior to a class or function with which it is merged."),
            Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces: diag(2435, 1, "Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces_2435", "Ambient modules cannot be nested in other modules or namespaces."),
            Ambient_module_declaration_cannot_specify_relative_module_name: diag(2436, 1, "Ambient_module_declaration_cannot_specify_relative_module_name_2436", "Ambient module declaration cannot specify relative module name."),
            Module_0_is_hidden_by_a_local_declaration_with_the_same_name: diag(2437, 1, "Module_0_is_hidden_by_a_local_declaration_with_the_same_name_2437", "Module '{0}' is hidden by a local declaration with the same name."),
            Import_name_cannot_be_0: diag(2438, 1, "Import_name_cannot_be_0_2438", "Import name cannot be '{0}'."),
            Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relative_module_name: diag(2439, 1, "Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relati_2439", "Import or export declaration in an ambient module declaration cannot reference module through relative module name."),
            Import_declaration_conflicts_with_local_declaration_of_0: diag(2440, 1, "Import_declaration_conflicts_with_local_declaration_of_0_2440", "Import declaration conflicts with local declaration of '{0}'."),
            Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module: diag(2441, 1, "Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_2441", "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module."),
            Types_have_separate_declarations_of_a_private_property_0: diag(2442, 1, "Types_have_separate_declarations_of_a_private_property_0_2442", "Types have separate declarations of a private property '{0}'."),
            Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2: diag(2443, 1, "Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2_2443", "Property '{0}' is protected but type '{1}' is not a class derived from '{2}'."),
            Property_0_is_protected_in_type_1_but_public_in_type_2: diag(2444, 1, "Property_0_is_protected_in_type_1_but_public_in_type_2_2444", "Property '{0}' is protected in type '{1}' but public in type '{2}'."),
            Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses: diag(2445, 1, "Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses_2445", "Property '{0}' is protected and only accessible within class '{1}' and its subclasses."),
            Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1_This_is_an_instance_of_class_2: diag(2446, 1, "Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1_This_is_an_instance_of_cl_2446", "Property '{0}' is protected and only accessible through an instance of class '{1}'. This is an instance of class '{2}'."),
            The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead: diag(2447, 1, "The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead_2447", "The '{0}' operator is not allowed for boolean types. Consider using '{1}' instead."),
            Block_scoped_variable_0_used_before_its_declaration: diag(2448, 1, "Block_scoped_variable_0_used_before_its_declaration_2448", "Block-scoped variable '{0}' used before its declaration."),
            Class_0_used_before_its_declaration: diag(2449, 1, "Class_0_used_before_its_declaration_2449", "Class '{0}' used before its declaration."),
            Enum_0_used_before_its_declaration: diag(2450, 1, "Enum_0_used_before_its_declaration_2450", "Enum '{0}' used before its declaration."),
            Cannot_redeclare_block_scoped_variable_0: diag(2451, 1, "Cannot_redeclare_block_scoped_variable_0_2451", "Cannot redeclare block-scoped variable '{0}'."),
            An_enum_member_cannot_have_a_numeric_name: diag(2452, 1, "An_enum_member_cannot_have_a_numeric_name_2452", "An enum member cannot have a numeric name."),
            Variable_0_is_used_before_being_assigned: diag(2454, 1, "Variable_0_is_used_before_being_assigned_2454", "Variable '{0}' is used before being assigned."),
            Type_alias_0_circularly_references_itself: diag(2456, 1, "Type_alias_0_circularly_references_itself_2456", "Type alias '{0}' circularly references itself."),
            Type_alias_name_cannot_be_0: diag(2457, 1, "Type_alias_name_cannot_be_0_2457", "Type alias name cannot be '{0}'."),
            An_AMD_module_cannot_have_multiple_name_assignments: diag(2458, 1, "An_AMD_module_cannot_have_multiple_name_assignments_2458", "An AMD module cannot have multiple name assignments."),
            Module_0_declares_1_locally_but_it_is_not_exported: diag(2459, 1, "Module_0_declares_1_locally_but_it_is_not_exported_2459", "Module '{0}' declares '{1}' locally, but it is not exported."),
            Module_0_declares_1_locally_but_it_is_exported_as_2: diag(2460, 1, "Module_0_declares_1_locally_but_it_is_exported_as_2_2460", "Module '{0}' declares '{1}' locally, but it is exported as '{2}'."),
            Type_0_is_not_an_array_type: diag(2461, 1, "Type_0_is_not_an_array_type_2461", "Type '{0}' is not an array type."),
            A_rest_element_must_be_last_in_a_destructuring_pattern: diag(2462, 1, "A_rest_element_must_be_last_in_a_destructuring_pattern_2462", "A rest element must be last in a destructuring pattern."),
            A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature: diag(2463, 1, "A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature_2463", "A binding pattern parameter cannot be optional in an implementation signature."),
            A_computed_property_name_must_be_of_type_string_number_symbol_or_any: diag(2464, 1, "A_computed_property_name_must_be_of_type_string_number_symbol_or_any_2464", "A computed property name must be of type 'string', 'number', 'symbol', or 'any'."),
            this_cannot_be_referenced_in_a_computed_property_name: diag(2465, 1, "this_cannot_be_referenced_in_a_computed_property_name_2465", "'this' cannot be referenced in a computed property name."),
            super_cannot_be_referenced_in_a_computed_property_name: diag(2466, 1, "super_cannot_be_referenced_in_a_computed_property_name_2466", "'super' cannot be referenced in a computed property name."),
            A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type: diag(2467, 1, "A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type_2467", "A computed property name cannot reference a type parameter from its containing type."),
            Cannot_find_global_value_0: diag(2468, 1, "Cannot_find_global_value_0_2468", "Cannot find global value '{0}'."),
            The_0_operator_cannot_be_applied_to_type_symbol: diag(2469, 1, "The_0_operator_cannot_be_applied_to_type_symbol_2469", "The '{0}' operator cannot be applied to type 'symbol'."),
            Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher: diag(2472, 1, "Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher_2472", "Spread operator in 'new' expressions is only available when targeting ECMAScript 5 and higher."),
            Enum_declarations_must_all_be_const_or_non_const: diag(2473, 1, "Enum_declarations_must_all_be_const_or_non_const_2473", "Enum declarations must all be const or non-const."),
            const_enum_member_initializers_must_be_constant_expressions: diag(2474, 1, "const_enum_member_initializers_must_be_constant_expressions_2474", "const enum member initializers must be constant expressions."),
            const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_import_declaration_or_export_assignment_or_type_query: diag(2475, 1, "const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_im_2475", "'const' enums can only be used in property or index access expressions or the right hand side of an import declaration or export assignment or type query."),
            A_const_enum_member_can_only_be_accessed_using_a_string_literal: diag(2476, 1, "A_const_enum_member_can_only_be_accessed_using_a_string_literal_2476", "A const enum member can only be accessed using a string literal."),
            const_enum_member_initializer_was_evaluated_to_a_non_finite_value: diag(2477, 1, "const_enum_member_initializer_was_evaluated_to_a_non_finite_value_2477", "'const' enum member initializer was evaluated to a non-finite value."),
            const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN: diag(2478, 1, "const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN_2478", "'const' enum member initializer was evaluated to disallowed value 'NaN'."),
            let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations: diag(2480, 1, "let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations_2480", "'let' is not allowed to be used as a name in 'let' or 'const' declarations."),
            Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1: diag(2481, 1, "Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1_2481", "Cannot initialize outer scoped variable '{0}' in the same scope as block scoped declaration '{1}'."),
            The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation: diag(2483, 1, "The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation_2483", "The left-hand side of a 'for...of' statement cannot use a type annotation."),
            Export_declaration_conflicts_with_exported_declaration_of_0: diag(2484, 1, "Export_declaration_conflicts_with_exported_declaration_of_0_2484", "Export declaration conflicts with exported declaration of '{0}'."),
            The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access: diag(2487, 1, "The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access_2487", "The left-hand side of a 'for...of' statement must be a variable or a property access."),
            Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2488, 1, "Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator_2488", "Type '{0}' must have a '[Symbol.iterator]()' method that returns an iterator."),
            An_iterator_must_have_a_next_method: diag(2489, 1, "An_iterator_must_have_a_next_method_2489", "An iterator must have a 'next()' method."),
            The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property: diag(2490, 1, "The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property_2490", "The type returned by the '{0}()' method of an iterator must have a 'value' property."),
            The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern: diag(2491, 1, "The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern_2491", "The left-hand side of a 'for...in' statement cannot be a destructuring pattern."),
            Cannot_redeclare_identifier_0_in_catch_clause: diag(2492, 1, "Cannot_redeclare_identifier_0_in_catch_clause_2492", "Cannot redeclare identifier '{0}' in catch clause."),
            Tuple_type_0_of_length_1_has_no_element_at_index_2: diag(2493, 1, "Tuple_type_0_of_length_1_has_no_element_at_index_2_2493", "Tuple type '{0}' of length '{1}' has no element at index '{2}'."),
            Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher: diag(2494, 1, "Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher_2494", "Using a string in a 'for...of' statement is only supported in ECMAScript 5 and higher."),
            Type_0_is_not_an_array_type_or_a_string_type: diag(2495, 1, "Type_0_is_not_an_array_type_or_a_string_type_2495", "Type '{0}' is not an array type or a string type."),
            The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_standard_function_expression: diag(2496, 1, "The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_stand_2496", "The 'arguments' object cannot be referenced in an arrow function in ES3 and ES5. Consider using a standard function expression."),
            This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_referencing_its_default_export: diag(2497, 1, "This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_2497", "This module can only be referenced with ECMAScript imports/exports by turning on the '{0}' flag and referencing its default export."),
            Module_0_uses_export_and_cannot_be_used_with_export_Asterisk: diag(2498, 1, "Module_0_uses_export_and_cannot_be_used_with_export_Asterisk_2498", "Module '{0}' uses 'export =' and cannot be used with 'export *'."),
            An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments: diag(2499, 1, "An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments_2499", "An interface can only extend an identifier/qualified-name with optional type arguments."),
            A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments: diag(2500, 1, "A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments_2500", "A class can only implement an identifier/qualified-name with optional type arguments."),
            A_rest_element_cannot_contain_a_binding_pattern: diag(2501, 1, "A_rest_element_cannot_contain_a_binding_pattern_2501", "A rest element cannot contain a binding pattern."),
            _0_is_referenced_directly_or_indirectly_in_its_own_type_annotation: diag(2502, 1, "_0_is_referenced_directly_or_indirectly_in_its_own_type_annotation_2502", "'{0}' is referenced directly or indirectly in its own type annotation."),
            Cannot_find_namespace_0: diag(2503, 1, "Cannot_find_namespace_0_2503", "Cannot find namespace '{0}'."),
            Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator: diag(2504, 1, "Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator_2504", "Type '{0}' must have a '[Symbol.asyncIterator]()' method that returns an async iterator."),
            A_generator_cannot_have_a_void_type_annotation: diag(2505, 1, "A_generator_cannot_have_a_void_type_annotation_2505", "A generator cannot have a 'void' type annotation."),
            _0_is_referenced_directly_or_indirectly_in_its_own_base_expression: diag(2506, 1, "_0_is_referenced_directly_or_indirectly_in_its_own_base_expression_2506", "'{0}' is referenced directly or indirectly in its own base expression."),
            Type_0_is_not_a_constructor_function_type: diag(2507, 1, "Type_0_is_not_a_constructor_function_type_2507", "Type '{0}' is not a constructor function type."),
            No_base_constructor_has_the_specified_number_of_type_arguments: diag(2508, 1, "No_base_constructor_has_the_specified_number_of_type_arguments_2508", "No base constructor has the specified number of type arguments."),
            Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2509, 1, "Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_2509", "Base constructor return type '{0}' is not an object type or intersection of object types with statically known members."),
            Base_constructors_must_all_have_the_same_return_type: diag(2510, 1, "Base_constructors_must_all_have_the_same_return_type_2510", "Base constructors must all have the same return type."),
            Cannot_create_an_instance_of_an_abstract_class: diag(2511, 1, "Cannot_create_an_instance_of_an_abstract_class_2511", "Cannot create an instance of an abstract class."),
            Overload_signatures_must_all_be_abstract_or_non_abstract: diag(2512, 1, "Overload_signatures_must_all_be_abstract_or_non_abstract_2512", "Overload signatures must all be abstract or non-abstract."),
            Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression: diag(2513, 1, "Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression_2513", "Abstract method '{0}' in class '{1}' cannot be accessed via super expression."),
            A_tuple_type_cannot_be_indexed_with_a_negative_value: diag(2514, 1, "A_tuple_type_cannot_be_indexed_with_a_negative_value_2514", "A tuple type cannot be indexed with a negative value."),
            Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2: diag(2515, 1, "Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2_2515", "Non-abstract class '{0}' does not implement inherited abstract member '{1}' from class '{2}'."),
            All_declarations_of_an_abstract_method_must_be_consecutive: diag(2516, 1, "All_declarations_of_an_abstract_method_must_be_consecutive_2516", "All declarations of an abstract method must be consecutive."),
            Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type: diag(2517, 1, "Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type_2517", "Cannot assign an abstract constructor type to a non-abstract constructor type."),
            A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard: diag(2518, 1, "A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard_2518", "A 'this'-based type guard is not compatible with a parameter-based type guard."),
            An_async_iterator_must_have_a_next_method: diag(2519, 1, "An_async_iterator_must_have_a_next_method_2519", "An async iterator must have a 'next()' method."),
            Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions: diag(2520, 1, "Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions_2520", "Duplicate identifier '{0}'. Compiler uses declaration '{1}' to support async functions."),
            The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_using_a_standard_function_or_method: diag(2522, 1, "The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_usi_2522", "The 'arguments' object cannot be referenced in an async function or method in ES3 and ES5. Consider using a standard function or method."),
            yield_expressions_cannot_be_used_in_a_parameter_initializer: diag(2523, 1, "yield_expressions_cannot_be_used_in_a_parameter_initializer_2523", "'yield' expressions cannot be used in a parameter initializer."),
            await_expressions_cannot_be_used_in_a_parameter_initializer: diag(2524, 1, "await_expressions_cannot_be_used_in_a_parameter_initializer_2524", "'await' expressions cannot be used in a parameter initializer."),
            Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value: diag(2525, 1, "Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value_2525", "Initializer provides no value for this binding element and the binding element has no default value."),
            A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface: diag(2526, 1, "A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface_2526", "A 'this' type is available only in a non-static member of a class or interface."),
            The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary: diag(2527, 1, "The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary_2527", "The inferred type of '{0}' references an inaccessible '{1}' type. A type annotation is necessary."),
            A_module_cannot_have_multiple_default_exports: diag(2528, 1, "A_module_cannot_have_multiple_default_exports_2528", "A module cannot have multiple default exports."),
            Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_functions: diag(2529, 1, "Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_func_2529", "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module containing async functions."),
            Property_0_is_incompatible_with_index_signature: diag(2530, 1, "Property_0_is_incompatible_with_index_signature_2530", "Property '{0}' is incompatible with index signature."),
            Object_is_possibly_null: diag(2531, 1, "Object_is_possibly_null_2531", "Object is possibly 'null'."),
            Object_is_possibly_undefined: diag(2532, 1, "Object_is_possibly_undefined_2532", "Object is possibly 'undefined'."),
            Object_is_possibly_null_or_undefined: diag(2533, 1, "Object_is_possibly_null_or_undefined_2533", "Object is possibly 'null' or 'undefined'."),
            A_function_returning_never_cannot_have_a_reachable_end_point: diag(2534, 1, "A_function_returning_never_cannot_have_a_reachable_end_point_2534", "A function returning 'never' cannot have a reachable end point."),
            Type_0_cannot_be_used_to_index_type_1: diag(2536, 1, "Type_0_cannot_be_used_to_index_type_1_2536", "Type '{0}' cannot be used to index type '{1}'."),
            Type_0_has_no_matching_index_signature_for_type_1: diag(2537, 1, "Type_0_has_no_matching_index_signature_for_type_1_2537", "Type '{0}' has no matching index signature for type '{1}'."),
            Type_0_cannot_be_used_as_an_index_type: diag(2538, 1, "Type_0_cannot_be_used_as_an_index_type_2538", "Type '{0}' cannot be used as an index type."),
            Cannot_assign_to_0_because_it_is_not_a_variable: diag(2539, 1, "Cannot_assign_to_0_because_it_is_not_a_variable_2539", "Cannot assign to '{0}' because it is not a variable."),
            Cannot_assign_to_0_because_it_is_a_read_only_property: diag(2540, 1, "Cannot_assign_to_0_because_it_is_a_read_only_property_2540", "Cannot assign to '{0}' because it is a read-only property."),
            Index_signature_in_type_0_only_permits_reading: diag(2542, 1, "Index_signature_in_type_0_only_permits_reading_2542", "Index signature in type '{0}' only permits reading."),
            Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_meta_property_reference: diag(2543, 1, "Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_me_2543", "Duplicate identifier '_newTarget'. Compiler uses variable declaration '_newTarget' to capture 'new.target' meta-property reference."),
            Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta_property_reference: diag(2544, 1, "Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta__2544", "Expression resolves to variable declaration '_newTarget' that compiler uses to capture 'new.target' meta-property reference."),
            A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any: diag(2545, 1, "A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any_2545", "A mixin class must have a constructor with a single rest parameter of type 'any[]'."),
            The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_property: diag(2547, 1, "The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_pro_2547", "The type returned by the '{0}()' method of an async iterator must be a promise for a type with a 'value' property."),
            Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2548, 1, "Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator_2548", "Type '{0}' is not an array type or does not have a '[Symbol.iterator]()' method that returns an iterator."),
            Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2549, 1, "Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns__2549", "Type '{0}' is not an array type or a string type or does not have a '[Symbol.iterator]()' method that returns an iterator."),
            Property_0_does_not_exist_on_type_1_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2_or_later: diag(2550, 1, "Property_0_does_not_exist_on_type_1_Do_you_need_to_change_your_target_library_Try_changing_the_lib_c_2550", "Property '{0}' does not exist on type '{1}'. Do you need to change your target library? Try changing the 'lib' compiler option to '{2}' or later."),
            Property_0_does_not_exist_on_type_1_Did_you_mean_2: diag(2551, 1, "Property_0_does_not_exist_on_type_1_Did_you_mean_2_2551", "Property '{0}' does not exist on type '{1}'. Did you mean '{2}'?"),
            Cannot_find_name_0_Did_you_mean_1: diag(2552, 1, "Cannot_find_name_0_Did_you_mean_1_2552", "Cannot find name '{0}'. Did you mean '{1}'?"),
            Computed_values_are_not_permitted_in_an_enum_with_string_valued_members: diag(2553, 1, "Computed_values_are_not_permitted_in_an_enum_with_string_valued_members_2553", "Computed values are not permitted in an enum with string valued members."),
            Expected_0_arguments_but_got_1: diag(2554, 1, "Expected_0_arguments_but_got_1_2554", "Expected {0} arguments, but got {1}."),
            Expected_at_least_0_arguments_but_got_1: diag(2555, 1, "Expected_at_least_0_arguments_but_got_1_2555", "Expected at least {0} arguments, but got {1}."),
            A_spread_argument_must_either_have_a_tuple_type_or_be_passed_to_a_rest_parameter: diag(2556, 1, "A_spread_argument_must_either_have_a_tuple_type_or_be_passed_to_a_rest_parameter_2556", "A spread argument must either have a tuple type or be passed to a rest parameter."),
            Expected_0_type_arguments_but_got_1: diag(2558, 1, "Expected_0_type_arguments_but_got_1_2558", "Expected {0} type arguments, but got {1}."),
            Type_0_has_no_properties_in_common_with_type_1: diag(2559, 1, "Type_0_has_no_properties_in_common_with_type_1_2559", "Type '{0}' has no properties in common with type '{1}'."),
            Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it: diag(2560, 1, "Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it_2560", "Value of type '{0}' has no properties in common with type '{1}'. Did you mean to call it?"),
            Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_write_2: diag(2561, 1, "Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_writ_2561", "Object literal may only specify known properties, but '{0}' does not exist in type '{1}'. Did you mean to write '{2}'?"),
            Base_class_expressions_cannot_reference_class_type_parameters: diag(2562, 1, "Base_class_expressions_cannot_reference_class_type_parameters_2562", "Base class expressions cannot reference class type parameters."),
            The_containing_function_or_module_body_is_too_large_for_control_flow_analysis: diag(2563, 1, "The_containing_function_or_module_body_is_too_large_for_control_flow_analysis_2563", "The containing function or module body is too large for control flow analysis."),
            Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor: diag(2564, 1, "Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor_2564", "Property '{0}' has no initializer and is not definitely assigned in the constructor."),
            Property_0_is_used_before_being_assigned: diag(2565, 1, "Property_0_is_used_before_being_assigned_2565", "Property '{0}' is used before being assigned."),
            A_rest_element_cannot_have_a_property_name: diag(2566, 1, "A_rest_element_cannot_have_a_property_name_2566", "A rest element cannot have a property name."),
            Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations: diag(2567, 1, "Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations_2567", "Enum declarations can only merge with namespace or other enum declarations."),
            Property_0_may_not_exist_on_type_1_Did_you_mean_2: diag(2568, 1, "Property_0_may_not_exist_on_type_1_Did_you_mean_2_2568", "Property '{0}' may not exist on type '{1}'. Did you mean '{2}'?"),
            Could_not_find_name_0_Did_you_mean_1: diag(2570, 1, "Could_not_find_name_0_Did_you_mean_1_2570", "Could not find name '{0}'. Did you mean '{1}'?"),
            Object_is_of_type_unknown: diag(2571, 1, "Object_is_of_type_unknown_2571", "Object is of type 'unknown'."),
            A_rest_element_type_must_be_an_array_type: diag(2574, 1, "A_rest_element_type_must_be_an_array_type_2574", "A rest element type must be an array type."),
            No_overload_expects_0_arguments_but_overloads_do_exist_that_expect_either_1_or_2_arguments: diag(2575, 1, "No_overload_expects_0_arguments_but_overloads_do_exist_that_expect_either_1_or_2_arguments_2575", "No overload expects {0} arguments, but overloads do exist that expect either {1} or {2} arguments."),
            Property_0_does_not_exist_on_type_1_Did_you_mean_to_access_the_static_member_2_instead: diag(2576, 1, "Property_0_does_not_exist_on_type_1_Did_you_mean_to_access_the_static_member_2_instead_2576", "Property '{0}' does not exist on type '{1}'. Did you mean to access the static member '{2}' instead?"),
            Return_type_annotation_circularly_references_itself: diag(2577, 1, "Return_type_annotation_circularly_references_itself_2577", "Return type annotation circularly references itself."),
            Unused_ts_expect_error_directive: diag(2578, 1, "Unused_ts_expect_error_directive_2578", "Unused '@ts-expect-error' directive."),
            Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashnode: diag(2580, 1, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashno_2580", "Cannot find name '{0}'. Do you need to install type definitions for node? Try `npm i --save-dev @types/node`."),
            Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slashjquery: diag(2581, 1, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slash_2581", "Cannot find name '{0}'. Do you need to install type definitions for jQuery? Try `npm i --save-dev @types/jquery`."),
            Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_types_Slashjest_or_npm_i_save_dev_types_Slashmocha: diag(2582, 1, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_type_2582", "Cannot find name '{0}'. Do you need to install type definitions for a test runner? Try `npm i --save-dev @types/jest` or `npm i --save-dev @types/mocha`."),
            Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_1_or_later: diag(2583, 1, "Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2583", "Cannot find name '{0}'. Do you need to change your target library? Try changing the 'lib' compiler option to '{1}' or later."),
            Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_include_dom: diag(2584, 1, "Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2584", "Cannot find name '{0}'. Do you need to change your target library? Try changing the 'lib' compiler option to include 'dom'."),
            _0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_es2015_or_later: diag(2585, 1, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Do_you_need_to_change_your_target_library_2585", "'{0}' only refers to a type, but is being used as a value here. Do you need to change your target library? Try changing the 'lib' compiler option to es2015 or later."),
            Cannot_assign_to_0_because_it_is_a_constant: diag(2588, 1, "Cannot_assign_to_0_because_it_is_a_constant_2588", "Cannot assign to '{0}' because it is a constant."),
            Type_instantiation_is_excessively_deep_and_possibly_infinite: diag(2589, 1, "Type_instantiation_is_excessively_deep_and_possibly_infinite_2589", "Type instantiation is excessively deep and possibly infinite."),
            Expression_produces_a_union_type_that_is_too_complex_to_represent: diag(2590, 1, "Expression_produces_a_union_type_that_is_too_complex_to_represent_2590", "Expression produces a union type that is too complex to represent."),
            Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashnode_and_then_add_node_to_the_types_field_in_your_tsconfig: diag(2591, 1, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashno_2591", "Cannot find name '{0}'. Do you need to install type definitions for node? Try `npm i --save-dev @types/node` and then add 'node' to the types field in your tsconfig."),
            Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slashjquery_and_then_add_jquery_to_the_types_field_in_your_tsconfig: diag(2592, 1, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slash_2592", "Cannot find name '{0}'. Do you need to install type definitions for jQuery? Try `npm i --save-dev @types/jquery` and then add 'jquery' to the types field in your tsconfig."),
            Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_types_Slashjest_or_npm_i_save_dev_types_Slashmocha_and_then_add_jest_or_mocha_to_the_types_field_in_your_tsconfig: diag(2593, 1, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_type_2593", "Cannot find name '{0}'. Do you need to install type definitions for a test runner? Try `npm i --save-dev @types/jest` or `npm i --save-dev @types/mocha` and then add 'jest' or 'mocha' to the types field in your tsconfig."),
            This_module_is_declared_with_export_and_can_only_be_used_with_a_default_import_when_using_the_0_flag: diag(2594, 1, "This_module_is_declared_with_export_and_can_only_be_used_with_a_default_import_when_using_the_0_flag_2594", "This module is declared with 'export =', and can only be used with a default import when using the '{0}' flag."),
            _0_can_only_be_imported_by_using_a_default_import: diag(2595, 1, "_0_can_only_be_imported_by_using_a_default_import_2595", "'{0}' can only be imported by using a default import."),
            _0_can_only_be_imported_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2596, 1, "_0_can_only_be_imported_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import_2596", "'{0}' can only be imported by turning on the 'esModuleInterop' flag and using a default import."),
            _0_can_only_be_imported_by_using_a_require_call_or_by_using_a_default_import: diag(2597, 1, "_0_can_only_be_imported_by_using_a_require_call_or_by_using_a_default_import_2597", "'{0}' can only be imported by using a 'require' call or by using a default import."),
            _0_can_only_be_imported_by_using_a_require_call_or_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2598, 1, "_0_can_only_be_imported_by_using_a_require_call_or_by_turning_on_the_esModuleInterop_flag_and_using__2598", "'{0}' can only be imported by using a 'require' call or by turning on the 'esModuleInterop' flag and using a default import."),
            JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist: diag(2602, 1, "JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist_2602", "JSX element implicitly has type 'any' because the global type 'JSX.Element' does not exist."),
            Property_0_in_type_1_is_not_assignable_to_type_2: diag(2603, 1, "Property_0_in_type_1_is_not_assignable_to_type_2_2603", "Property '{0}' in type '{1}' is not assignable to type '{2}'."),
            JSX_element_type_0_does_not_have_any_construct_or_call_signatures: diag(2604, 1, "JSX_element_type_0_does_not_have_any_construct_or_call_signatures_2604", "JSX element type '{0}' does not have any construct or call signatures."),
            Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property: diag(2606, 1, "Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property_2606", "Property '{0}' of JSX spread attribute is not assignable to target property."),
            JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property: diag(2607, 1, "JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property_2607", "JSX element class does not support attributes because it does not have a '{0}' property."),
            The_global_type_JSX_0_may_not_have_more_than_one_property: diag(2608, 1, "The_global_type_JSX_0_may_not_have_more_than_one_property_2608", "The global type 'JSX.{0}' may not have more than one property."),
            JSX_spread_child_must_be_an_array_type: diag(2609, 1, "JSX_spread_child_must_be_an_array_type_2609", "JSX spread child must be an array type."),
            _0_is_defined_as_an_accessor_in_class_1_but_is_overridden_here_in_2_as_an_instance_property: diag(2610, 1, "_0_is_defined_as_an_accessor_in_class_1_but_is_overridden_here_in_2_as_an_instance_property_2610", "'{0}' is defined as an accessor in class '{1}', but is overridden here in '{2}' as an instance property."),
            _0_is_defined_as_a_property_in_class_1_but_is_overridden_here_in_2_as_an_accessor: diag(2611, 1, "_0_is_defined_as_a_property_in_class_1_but_is_overridden_here_in_2_as_an_accessor_2611", "'{0}' is defined as a property in class '{1}', but is overridden here in '{2}' as an accessor."),
            Property_0_will_overwrite_the_base_property_in_1_If_this_is_intentional_add_an_initializer_Otherwise_add_a_declare_modifier_or_remove_the_redundant_declaration: diag(2612, 1, "Property_0_will_overwrite_the_base_property_in_1_If_this_is_intentional_add_an_initializer_Otherwise_2612", "Property '{0}' will overwrite the base property in '{1}'. If this is intentional, add an initializer. Otherwise, add a 'declare' modifier or remove the redundant declaration."),
            Module_0_has_no_default_export_Did_you_mean_to_use_import_1_from_0_instead: diag(2613, 1, "Module_0_has_no_default_export_Did_you_mean_to_use_import_1_from_0_instead_2613", "Module '{0}' has no default export. Did you mean to use 'import { {1} } from {0}' instead?"),
            Module_0_has_no_exported_member_1_Did_you_mean_to_use_import_1_from_0_instead: diag(2614, 1, "Module_0_has_no_exported_member_1_Did_you_mean_to_use_import_1_from_0_instead_2614", "Module '{0}' has no exported member '{1}'. Did you mean to use 'import {1} from {0}' instead?"),
            Type_of_property_0_circularly_references_itself_in_mapped_type_1: diag(2615, 1, "Type_of_property_0_circularly_references_itself_in_mapped_type_1_2615", "Type of property '{0}' circularly references itself in mapped type '{1}'."),
            _0_can_only_be_imported_by_using_import_1_require_2_or_a_default_import: diag(2616, 1, "_0_can_only_be_imported_by_using_import_1_require_2_or_a_default_import_2616", "'{0}' can only be imported by using 'import {1} = require({2})' or a default import."),
            _0_can_only_be_imported_by_using_import_1_require_2_or_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2617, 1, "_0_can_only_be_imported_by_using_import_1_require_2_or_by_turning_on_the_esModuleInterop_flag_and_us_2617", "'{0}' can only be imported by using 'import {1} = require({2})' or by turning on the 'esModuleInterop' flag and using a default import."),
            Source_has_0_element_s_but_target_requires_1: diag(2618, 1, "Source_has_0_element_s_but_target_requires_1_2618", "Source has {0} element(s) but target requires {1}."),
            Source_has_0_element_s_but_target_allows_only_1: diag(2619, 1, "Source_has_0_element_s_but_target_allows_only_1_2619", "Source has {0} element(s) but target allows only {1}."),
            Target_requires_0_element_s_but_source_may_have_fewer: diag(2620, 1, "Target_requires_0_element_s_but_source_may_have_fewer_2620", "Target requires {0} element(s) but source may have fewer."),
            Target_allows_only_0_element_s_but_source_may_have_more: diag(2621, 1, "Target_allows_only_0_element_s_but_source_may_have_more_2621", "Target allows only {0} element(s) but source may have more."),
            Source_provides_no_match_for_required_element_at_position_0_in_target: diag(2623, 1, "Source_provides_no_match_for_required_element_at_position_0_in_target_2623", "Source provides no match for required element at position {0} in target."),
            Source_provides_no_match_for_variadic_element_at_position_0_in_target: diag(2624, 1, "Source_provides_no_match_for_variadic_element_at_position_0_in_target_2624", "Source provides no match for variadic element at position {0} in target."),
            Variadic_element_at_position_0_in_source_does_not_match_element_at_position_1_in_target: diag(2625, 1, "Variadic_element_at_position_0_in_source_does_not_match_element_at_position_1_in_target_2625", "Variadic element at position {0} in source does not match element at position {1} in target."),
            Type_at_position_0_in_source_is_not_compatible_with_type_at_position_1_in_target: diag(2626, 1, "Type_at_position_0_in_source_is_not_compatible_with_type_at_position_1_in_target_2626", "Type at position {0} in source is not compatible with type at position {1} in target."),
            Type_at_positions_0_through_1_in_source_is_not_compatible_with_type_at_position_2_in_target: diag(2627, 1, "Type_at_positions_0_through_1_in_source_is_not_compatible_with_type_at_position_2_in_target_2627", "Type at positions {0} through {1} in source is not compatible with type at position {2} in target."),
            Cannot_assign_to_0_because_it_is_an_enum: diag(2628, 1, "Cannot_assign_to_0_because_it_is_an_enum_2628", "Cannot assign to '{0}' because it is an enum."),
            Cannot_assign_to_0_because_it_is_a_class: diag(2629, 1, "Cannot_assign_to_0_because_it_is_a_class_2629", "Cannot assign to '{0}' because it is a class."),
            Cannot_assign_to_0_because_it_is_a_function: diag(2630, 1, "Cannot_assign_to_0_because_it_is_a_function_2630", "Cannot assign to '{0}' because it is a function."),
            Cannot_assign_to_0_because_it_is_a_namespace: diag(2631, 1, "Cannot_assign_to_0_because_it_is_a_namespace_2631", "Cannot assign to '{0}' because it is a namespace."),
            Cannot_assign_to_0_because_it_is_an_import: diag(2632, 1, "Cannot_assign_to_0_because_it_is_an_import_2632", "Cannot assign to '{0}' because it is an import."),
            JSX_property_access_expressions_cannot_include_JSX_namespace_names: diag(2633, 1, "JSX_property_access_expressions_cannot_include_JSX_namespace_names_2633", "JSX property access expressions cannot include JSX namespace names"),
            _0_index_signatures_are_incompatible: diag(2634, 1, "_0_index_signatures_are_incompatible_2634", "'{0}' index signatures are incompatible."),
            Type_0_has_no_signatures_for_which_the_type_argument_list_is_applicable: diag(2635, 1, "Type_0_has_no_signatures_for_which_the_type_argument_list_is_applicable_2635", "Type '{0}' has no signatures for which the type argument list is applicable."),
            Type_0_is_not_assignable_to_type_1_as_implied_by_variance_annotation: diag(2636, 1, "Type_0_is_not_assignable_to_type_1_as_implied_by_variance_annotation_2636", "Type '{0}' is not assignable to type '{1}' as implied by variance annotation."),
            Variance_annotations_are_only_supported_in_type_aliases_for_object_function_constructor_and_mapped_types: diag(2637, 1, "Variance_annotations_are_only_supported_in_type_aliases_for_object_function_constructor_and_mapped_t_2637", "Variance annotations are only supported in type aliases for object, function, constructor, and mapped types."),
            Type_0_may_represent_a_primitive_value_which_is_not_permitted_as_the_right_operand_of_the_in_operator: diag(2638, 1, "Type_0_may_represent_a_primitive_value_which_is_not_permitted_as_the_right_operand_of_the_in_operato_2638", "Type '{0}' may represent a primitive value, which is not permitted as the right operand of the 'in' operator."),
            React_components_cannot_include_JSX_namespace_names: diag(2639, 1, "React_components_cannot_include_JSX_namespace_names_2639", "React components cannot include JSX namespace names"),
            Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity: diag(2649, 1, "Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity_2649", "Cannot augment module '{0}' with value exports because it resolves to a non-module entity."),
            A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_members_defined_in_other_enums: diag(2651, 1, "A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_memb_2651", "A member initializer in a enum declaration cannot reference members declared after it, including members defined in other enums."),
            Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_default_0_declaration_instead: diag(2652, 1, "Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_d_2652", "Merged declaration '{0}' cannot include a default export declaration. Consider adding a separate 'export default {0}' declaration instead."),
            Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1: diag(2653, 1, "Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1_2653", "Non-abstract class expression does not implement inherited abstract member '{0}' from class '{1}'."),
            JSX_expressions_must_have_one_parent_element: diag(2657, 1, "JSX_expressions_must_have_one_parent_element_2657", "JSX expressions must have one parent element."),
            Type_0_provides_no_match_for_the_signature_1: diag(2658, 1, "Type_0_provides_no_match_for_the_signature_1_2658", "Type '{0}' provides no match for the signature '{1}'."),
            super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_higher: diag(2659, 1, "super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_highe_2659", "'super' is only allowed in members of object literal expressions when option 'target' is 'ES2015' or higher."),
            super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions: diag(2660, 1, "super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions_2660", "'super' can only be referenced in members of derived classes or object literal expressions."),
            Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module: diag(2661, 1, "Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module_2661", "Cannot export '{0}'. Only local declarations can be exported from a module."),
            Cannot_find_name_0_Did_you_mean_the_static_member_1_0: diag(2662, 1, "Cannot_find_name_0_Did_you_mean_the_static_member_1_0_2662", "Cannot find name '{0}'. Did you mean the static member '{1}.{0}'?"),
            Cannot_find_name_0_Did_you_mean_the_instance_member_this_0: diag(2663, 1, "Cannot_find_name_0_Did_you_mean_the_instance_member_this_0_2663", "Cannot find name '{0}'. Did you mean the instance member 'this.{0}'?"),
            Invalid_module_name_in_augmentation_module_0_cannot_be_found: diag(2664, 1, "Invalid_module_name_in_augmentation_module_0_cannot_be_found_2664", "Invalid module name in augmentation, module '{0}' cannot be found."),
            Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augmented: diag(2665, 1, "Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augm_2665", "Invalid module name in augmentation. Module '{0}' resolves to an untyped module at '{1}', which cannot be augmented."),
            Exports_and_export_assignments_are_not_permitted_in_module_augmentations: diag(2666, 1, "Exports_and_export_assignments_are_not_permitted_in_module_augmentations_2666", "Exports and export assignments are not permitted in module augmentations."),
            Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_module: diag(2667, 1, "Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_mod_2667", "Imports are not permitted in module augmentations. Consider moving them to the enclosing external module."),
            export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always_visible: diag(2668, 1, "export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always__2668", "'export' modifier cannot be applied to ambient modules and module augmentations since they are always visible."),
            Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_declarations: diag(2669, 1, "Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_2669", "Augmentations for the global scope can only be directly nested in external modules or ambient module declarations."),
            Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambient_context: diag(2670, 1, "Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambien_2670", "Augmentations for the global scope should have 'declare' modifier unless they appear in already ambient context."),
            Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity: diag(2671, 1, "Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity_2671", "Cannot augment module '{0}' because it resolves to a non-module entity."),
            Cannot_assign_a_0_constructor_type_to_a_1_constructor_type: diag(2672, 1, "Cannot_assign_a_0_constructor_type_to_a_1_constructor_type_2672", "Cannot assign a '{0}' constructor type to a '{1}' constructor type."),
            Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration: diag(2673, 1, "Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration_2673", "Constructor of class '{0}' is private and only accessible within the class declaration."),
            Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration: diag(2674, 1, "Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration_2674", "Constructor of class '{0}' is protected and only accessible within the class declaration."),
            Cannot_extend_a_class_0_Class_constructor_is_marked_as_private: diag(2675, 1, "Cannot_extend_a_class_0_Class_constructor_is_marked_as_private_2675", "Cannot extend a class '{0}'. Class constructor is marked as private."),
            Accessors_must_both_be_abstract_or_non_abstract: diag(2676, 1, "Accessors_must_both_be_abstract_or_non_abstract_2676", "Accessors must both be abstract or non-abstract."),
            A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type: diag(2677, 1, "A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type_2677", "A type predicate's type must be assignable to its parameter's type."),
            Type_0_is_not_comparable_to_type_1: diag(2678, 1, "Type_0_is_not_comparable_to_type_1_2678", "Type '{0}' is not comparable to type '{1}'."),
            A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void: diag(2679, 1, "A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void_2679", "A function that is called with the 'new' keyword cannot have a 'this' type that is 'void'."),
            A_0_parameter_must_be_the_first_parameter: diag(2680, 1, "A_0_parameter_must_be_the_first_parameter_2680", "A '{0}' parameter must be the first parameter."),
            A_constructor_cannot_have_a_this_parameter: diag(2681, 1, "A_constructor_cannot_have_a_this_parameter_2681", "A constructor cannot have a 'this' parameter."),
            this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation: diag(2683, 1, "this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_2683", "'this' implicitly has type 'any' because it does not have a type annotation."),
            The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1: diag(2684, 1, "The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1_2684", "The 'this' context of type '{0}' is not assignable to method's 'this' of type '{1}'."),
            The_this_types_of_each_signature_are_incompatible: diag(2685, 1, "The_this_types_of_each_signature_are_incompatible_2685", "The 'this' types of each signature are incompatible."),
            _0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead: diag(2686, 1, "_0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead_2686", "'{0}' refers to a UMD global, but the current file is a module. Consider adding an import instead."),
            All_declarations_of_0_must_have_identical_modifiers: diag(2687, 1, "All_declarations_of_0_must_have_identical_modifiers_2687", "All declarations of '{0}' must have identical modifiers."),
            Cannot_find_type_definition_file_for_0: diag(2688, 1, "Cannot_find_type_definition_file_for_0_2688", "Cannot find type definition file for '{0}'."),
            Cannot_extend_an_interface_0_Did_you_mean_implements: diag(2689, 1, "Cannot_extend_an_interface_0_Did_you_mean_implements_2689", "Cannot extend an interface '{0}'. Did you mean 'implements'?"),
            _0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Did_you_mean_to_use_1_in_0: diag(2690, 1, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Did_you_mean_to_use_1_in_0_2690", "'{0}' only refers to a type, but is being used as a value here. Did you mean to use '{1} in {0}'?"),
            _0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible: diag(2692, 1, "_0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible_2692", "'{0}' is a primitive, but '{1}' is a wrapper object. Prefer using '{0}' when possible."),
            _0_only_refers_to_a_type_but_is_being_used_as_a_value_here: diag(2693, 1, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_2693", "'{0}' only refers to a type, but is being used as a value here."),
            Namespace_0_has_no_exported_member_1: diag(2694, 1, "Namespace_0_has_no_exported_member_1_2694", "Namespace '{0}' has no exported member '{1}'."),
            Left_side_of_comma_operator_is_unused_and_has_no_side_effects: diag(
              2695,
              1,
              "Left_side_of_comma_operator_is_unused_and_has_no_side_effects_2695",
              "Left side of comma operator is unused and has no side effects.",
              /*reportsUnnecessary*/
              true
            ),
            The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead: diag(2696, 1, "The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead_2696", "The 'Object' type is assignable to very few other types. Did you mean to use the 'any' type instead?"),
            An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option: diag(2697, 1, "An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_in_2697", "An async function or method must return a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your '--lib' option."),
            Spread_types_may_only_be_created_from_object_types: diag(2698, 1, "Spread_types_may_only_be_created_from_object_types_2698", "Spread types may only be created from object types."),
            Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1: diag(2699, 1, "Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1_2699", "Static property '{0}' conflicts with built-in property 'Function.{0}' of constructor function '{1}'."),
            Rest_types_may_only_be_created_from_object_types: diag(2700, 1, "Rest_types_may_only_be_created_from_object_types_2700", "Rest types may only be created from object types."),
            The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access: diag(2701, 1, "The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access_2701", "The target of an object rest assignment must be a variable or a property access."),
            _0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here: diag(2702, 1, "_0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here_2702", "'{0}' only refers to a type, but is being used as a namespace here."),
            The_operand_of_a_delete_operator_must_be_a_property_reference: diag(2703, 1, "The_operand_of_a_delete_operator_must_be_a_property_reference_2703", "The operand of a 'delete' operator must be a property reference."),
            The_operand_of_a_delete_operator_cannot_be_a_read_only_property: diag(2704, 1, "The_operand_of_a_delete_operator_cannot_be_a_read_only_property_2704", "The operand of a 'delete' operator cannot be a read-only property."),
            An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option: diag(2705, 1, "An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_de_2705", "An async function or method in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your '--lib' option."),
            Required_type_parameters_may_not_follow_optional_type_parameters: diag(2706, 1, "Required_type_parameters_may_not_follow_optional_type_parameters_2706", "Required type parameters may not follow optional type parameters."),
            Generic_type_0_requires_between_1_and_2_type_arguments: diag(2707, 1, "Generic_type_0_requires_between_1_and_2_type_arguments_2707", "Generic type '{0}' requires between {1} and {2} type arguments."),
            Cannot_use_namespace_0_as_a_value: diag(2708, 1, "Cannot_use_namespace_0_as_a_value_2708", "Cannot use namespace '{0}' as a value."),
            Cannot_use_namespace_0_as_a_type: diag(2709, 1, "Cannot_use_namespace_0_as_a_type_2709", "Cannot use namespace '{0}' as a type."),
            _0_are_specified_twice_The_attribute_named_0_will_be_overwritten: diag(2710, 1, "_0_are_specified_twice_The_attribute_named_0_will_be_overwritten_2710", "'{0}' are specified twice. The attribute named '{0}' will be overwritten."),
            A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option: diag(2711, 1, "A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES20_2711", "A dynamic import call returns a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your '--lib' option."),
            A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option: diag(2712, 1, "A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declarat_2712", "A dynamic import call in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your '--lib' option."),
            Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_property_1_in_0_with_0_1: diag(2713, 1, "Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_p_2713", `Cannot access '{0}.{1}' because '{0}' is a type, but not a namespace. Did you mean to retrieve the type of the property '{1}' in '{0}' with '{0}["{1}"]'?`),
            The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context: diag(2714, 1, "The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context_2714", "The expression of an export assignment must be an identifier or qualified name in an ambient context."),
            Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor: diag(2715, 1, "Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor_2715", "Abstract property '{0}' in class '{1}' cannot be accessed in the constructor."),
            Type_parameter_0_has_a_circular_default: diag(2716, 1, "Type_parameter_0_has_a_circular_default_2716", "Type parameter '{0}' has a circular default."),
            Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_type_2: diag(2717, 1, "Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_t_2717", "Subsequent property declarations must have the same type.  Property '{0}' must be of type '{1}', but here has type '{2}'."),
            Duplicate_property_0: diag(2718, 1, "Duplicate_property_0_2718", "Duplicate property '{0}'."),
            Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated: diag(2719, 1, "Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated_2719", "Type '{0}' is not assignable to type '{1}'. Two different types with this name exist, but they are unrelated."),
            Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclass: diag(2720, 1, "Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclas_2720", "Class '{0}' incorrectly implements class '{1}'. Did you mean to extend '{1}' and inherit its members as a subclass?"),
            Cannot_invoke_an_object_which_is_possibly_null: diag(2721, 1, "Cannot_invoke_an_object_which_is_possibly_null_2721", "Cannot invoke an object which is possibly 'null'."),
            Cannot_invoke_an_object_which_is_possibly_undefined: diag(2722, 1, "Cannot_invoke_an_object_which_is_possibly_undefined_2722", "Cannot invoke an object which is possibly 'undefined'."),
            Cannot_invoke_an_object_which_is_possibly_null_or_undefined: diag(2723, 1, "Cannot_invoke_an_object_which_is_possibly_null_or_undefined_2723", "Cannot invoke an object which is possibly 'null' or 'undefined'."),
            _0_has_no_exported_member_named_1_Did_you_mean_2: diag(2724, 1, "_0_has_no_exported_member_named_1_Did_you_mean_2_2724", "'{0}' has no exported member named '{1}'. Did you mean '{2}'?"),
            Class_name_cannot_be_Object_when_targeting_ES5_with_module_0: diag(2725, 1, "Class_name_cannot_be_Object_when_targeting_ES5_with_module_0_2725", "Class name cannot be 'Object' when targeting ES5 with module {0}."),
            Cannot_find_lib_definition_for_0: diag(2726, 1, "Cannot_find_lib_definition_for_0_2726", "Cannot find lib definition for '{0}'."),
            Cannot_find_lib_definition_for_0_Did_you_mean_1: diag(2727, 1, "Cannot_find_lib_definition_for_0_Did_you_mean_1_2727", "Cannot find lib definition for '{0}'. Did you mean '{1}'?"),
            _0_is_declared_here: diag(2728, 3, "_0_is_declared_here_2728", "'{0}' is declared here."),
            Property_0_is_used_before_its_initialization: diag(2729, 1, "Property_0_is_used_before_its_initialization_2729", "Property '{0}' is used before its initialization."),
            An_arrow_function_cannot_have_a_this_parameter: diag(2730, 1, "An_arrow_function_cannot_have_a_this_parameter_2730", "An arrow function cannot have a 'this' parameter."),
            Implicit_conversion_of_a_symbol_to_a_string_will_fail_at_runtime_Consider_wrapping_this_expression_in_String: diag(2731, 1, "Implicit_conversion_of_a_symbol_to_a_string_will_fail_at_runtime_Consider_wrapping_this_expression_i_2731", "Implicit conversion of a 'symbol' to a 'string' will fail at runtime. Consider wrapping this expression in 'String(...)'."),
            Cannot_find_module_0_Consider_using_resolveJsonModule_to_import_module_with_json_extension: diag(2732, 1, "Cannot_find_module_0_Consider_using_resolveJsonModule_to_import_module_with_json_extension_2732", "Cannot find module '{0}'. Consider using '--resolveJsonModule' to import module with '.json' extension."),
            Property_0_was_also_declared_here: diag(2733, 1, "Property_0_was_also_declared_here_2733", "Property '{0}' was also declared here."),
            Are_you_missing_a_semicolon: diag(2734, 1, "Are_you_missing_a_semicolon_2734", "Are you missing a semicolon?"),
            Did_you_mean_for_0_to_be_constrained_to_type_new_args_Colon_any_1: diag(2735, 1, "Did_you_mean_for_0_to_be_constrained_to_type_new_args_Colon_any_1_2735", "Did you mean for '{0}' to be constrained to type 'new (...args: any[]) => {1}'?"),
            Operator_0_cannot_be_applied_to_type_1: diag(2736, 1, "Operator_0_cannot_be_applied_to_type_1_2736", "Operator '{0}' cannot be applied to type '{1}'."),
            BigInt_literals_are_not_available_when_targeting_lower_than_ES2020: diag(2737, 1, "BigInt_literals_are_not_available_when_targeting_lower_than_ES2020_2737", "BigInt literals are not available when targeting lower than ES2020."),
            An_outer_value_of_this_is_shadowed_by_this_container: diag(2738, 3, "An_outer_value_of_this_is_shadowed_by_this_container_2738", "An outer value of 'this' is shadowed by this container."),
            Type_0_is_missing_the_following_properties_from_type_1_Colon_2: diag(2739, 1, "Type_0_is_missing_the_following_properties_from_type_1_Colon_2_2739", "Type '{0}' is missing the following properties from type '{1}': {2}"),
            Type_0_is_missing_the_following_properties_from_type_1_Colon_2_and_3_more: diag(2740, 1, "Type_0_is_missing_the_following_properties_from_type_1_Colon_2_and_3_more_2740", "Type '{0}' is missing the following properties from type '{1}': {2}, and {3} more."),
            Property_0_is_missing_in_type_1_but_required_in_type_2: diag(2741, 1, "Property_0_is_missing_in_type_1_but_required_in_type_2_2741", "Property '{0}' is missing in type '{1}' but required in type '{2}'."),
            The_inferred_type_of_0_cannot_be_named_without_a_reference_to_1_This_is_likely_not_portable_A_type_annotation_is_necessary: diag(2742, 1, "The_inferred_type_of_0_cannot_be_named_without_a_reference_to_1_This_is_likely_not_portable_A_type_a_2742", "The inferred type of '{0}' cannot be named without a reference to '{1}'. This is likely not portable. A type annotation is necessary."),
            No_overload_expects_0_type_arguments_but_overloads_do_exist_that_expect_either_1_or_2_type_arguments: diag(2743, 1, "No_overload_expects_0_type_arguments_but_overloads_do_exist_that_expect_either_1_or_2_type_arguments_2743", "No overload expects {0} type arguments, but overloads do exist that expect either {1} or {2} type arguments."),
            Type_parameter_defaults_can_only_reference_previously_declared_type_parameters: diag(2744, 1, "Type_parameter_defaults_can_only_reference_previously_declared_type_parameters_2744", "Type parameter defaults can only reference previously declared type parameters."),
            This_JSX_tag_s_0_prop_expects_type_1_which_requires_multiple_children_but_only_a_single_child_was_provided: diag(2745, 1, "This_JSX_tag_s_0_prop_expects_type_1_which_requires_multiple_children_but_only_a_single_child_was_pr_2745", "This JSX tag's '{0}' prop expects type '{1}' which requires multiple children, but only a single child was provided."),
            This_JSX_tag_s_0_prop_expects_a_single_child_of_type_1_but_multiple_children_were_provided: diag(2746, 1, "This_JSX_tag_s_0_prop_expects_a_single_child_of_type_1_but_multiple_children_were_provided_2746", "This JSX tag's '{0}' prop expects a single child of type '{1}', but multiple children were provided."),
            _0_components_don_t_accept_text_as_child_elements_Text_in_JSX_has_the_type_string_but_the_expected_type_of_1_is_2: diag(2747, 1, "_0_components_don_t_accept_text_as_child_elements_Text_in_JSX_has_the_type_string_but_the_expected_t_2747", "'{0}' components don't accept text as child elements. Text in JSX has the type 'string', but the expected type of '{1}' is '{2}'."),
            Cannot_access_ambient_const_enums_when_0_is_enabled: diag(2748, 1, "Cannot_access_ambient_const_enums_when_0_is_enabled_2748", "Cannot access ambient const enums when '{0}' is enabled."),
            _0_refers_to_a_value_but_is_being_used_as_a_type_here_Did_you_mean_typeof_0: diag(2749, 1, "_0_refers_to_a_value_but_is_being_used_as_a_type_here_Did_you_mean_typeof_0_2749", "'{0}' refers to a value, but is being used as a type here. Did you mean 'typeof {0}'?"),
            The_implementation_signature_is_declared_here: diag(2750, 1, "The_implementation_signature_is_declared_here_2750", "The implementation signature is declared here."),
            Circularity_originates_in_type_at_this_location: diag(2751, 1, "Circularity_originates_in_type_at_this_location_2751", "Circularity originates in type at this location."),
            The_first_export_default_is_here: diag(2752, 1, "The_first_export_default_is_here_2752", "The first export default is here."),
            Another_export_default_is_here: diag(2753, 1, "Another_export_default_is_here_2753", "Another export default is here."),
            super_may_not_use_type_arguments: diag(2754, 1, "super_may_not_use_type_arguments_2754", "'super' may not use type arguments."),
            No_constituent_of_type_0_is_callable: diag(2755, 1, "No_constituent_of_type_0_is_callable_2755", "No constituent of type '{0}' is callable."),
            Not_all_constituents_of_type_0_are_callable: diag(2756, 1, "Not_all_constituents_of_type_0_are_callable_2756", "Not all constituents of type '{0}' are callable."),
            Type_0_has_no_call_signatures: diag(2757, 1, "Type_0_has_no_call_signatures_2757", "Type '{0}' has no call signatures."),
            Each_member_of_the_union_type_0_has_signatures_but_none_of_those_signatures_are_compatible_with_each_other: diag(2758, 1, "Each_member_of_the_union_type_0_has_signatures_but_none_of_those_signatures_are_compatible_with_each_2758", "Each member of the union type '{0}' has signatures, but none of those signatures are compatible with each other."),
            No_constituent_of_type_0_is_constructable: diag(2759, 1, "No_constituent_of_type_0_is_constructable_2759", "No constituent of type '{0}' is constructable."),
            Not_all_constituents_of_type_0_are_constructable: diag(2760, 1, "Not_all_constituents_of_type_0_are_constructable_2760", "Not all constituents of type '{0}' are constructable."),
            Type_0_has_no_construct_signatures: diag(2761, 1, "Type_0_has_no_construct_signatures_2761", "Type '{0}' has no construct signatures."),
            Each_member_of_the_union_type_0_has_construct_signatures_but_none_of_those_signatures_are_compatible_with_each_other: diag(2762, 1, "Each_member_of_the_union_type_0_has_construct_signatures_but_none_of_those_signatures_are_compatible_2762", "Each member of the union type '{0}' has construct signatures, but none of those signatures are compatible with each other."),
            Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_for_of_will_always_send_0: diag(2763, 1, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_for_of_will_always_s_2763", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but for-of will always send '{0}'."),
            Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_spread_will_always_send_0: diag(2764, 1, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_spread_will_al_2764", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but array spread will always send '{0}'."),
            Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_destructuring_will_always_send_0: diag(2765, 1, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_destructuring__2765", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but array destructuring will always send '{0}'."),
            Cannot_delegate_iteration_to_value_because_the_next_method_of_its_iterator_expects_type_1_but_the_containing_generator_will_always_send_0: diag(2766, 1, "Cannot_delegate_iteration_to_value_because_the_next_method_of_its_iterator_expects_type_1_but_the_co_2766", "Cannot delegate iteration to value because the 'next' method of its iterator expects type '{1}', but the containing generator will always send '{0}'."),
            The_0_property_of_an_iterator_must_be_a_method: diag(2767, 1, "The_0_property_of_an_iterator_must_be_a_method_2767", "The '{0}' property of an iterator must be a method."),
            The_0_property_of_an_async_iterator_must_be_a_method: diag(2768, 1, "The_0_property_of_an_async_iterator_must_be_a_method_2768", "The '{0}' property of an async iterator must be a method."),
            No_overload_matches_this_call: diag(2769, 1, "No_overload_matches_this_call_2769", "No overload matches this call."),
            The_last_overload_gave_the_following_error: diag(2770, 1, "The_last_overload_gave_the_following_error_2770", "The last overload gave the following error."),
            The_last_overload_is_declared_here: diag(2771, 1, "The_last_overload_is_declared_here_2771", "The last overload is declared here."),
            Overload_0_of_1_2_gave_the_following_error: diag(2772, 1, "Overload_0_of_1_2_gave_the_following_error_2772", "Overload {0} of {1}, '{2}', gave the following error."),
            Did_you_forget_to_use_await: diag(2773, 1, "Did_you_forget_to_use_await_2773", "Did you forget to use 'await'?"),
            This_condition_will_always_return_true_since_this_function_is_always_defined_Did_you_mean_to_call_it_instead: diag(2774, 1, "This_condition_will_always_return_true_since_this_function_is_always_defined_Did_you_mean_to_call_it_2774", "This condition will always return true since this function is always defined. Did you mean to call it instead?"),
            Assertions_require_every_name_in_the_call_target_to_be_declared_with_an_explicit_type_annotation: diag(2775, 1, "Assertions_require_every_name_in_the_call_target_to_be_declared_with_an_explicit_type_annotation_2775", "Assertions require every name in the call target to be declared with an explicit type annotation."),
            Assertions_require_the_call_target_to_be_an_identifier_or_qualified_name: diag(2776, 1, "Assertions_require_the_call_target_to_be_an_identifier_or_qualified_name_2776", "Assertions require the call target to be an identifier or qualified name."),
            The_operand_of_an_increment_or_decrement_operator_may_not_be_an_optional_property_access: diag(2777, 1, "The_operand_of_an_increment_or_decrement_operator_may_not_be_an_optional_property_access_2777", "The operand of an increment or decrement operator may not be an optional property access."),
            The_target_of_an_object_rest_assignment_may_not_be_an_optional_property_access: diag(2778, 1, "The_target_of_an_object_rest_assignment_may_not_be_an_optional_property_access_2778", "The target of an object rest assignment may not be an optional property access."),
            The_left_hand_side_of_an_assignment_expression_may_not_be_an_optional_property_access: diag(2779, 1, "The_left_hand_side_of_an_assignment_expression_may_not_be_an_optional_property_access_2779", "The left-hand side of an assignment expression may not be an optional property access."),
            The_left_hand_side_of_a_for_in_statement_may_not_be_an_optional_property_access: diag(2780, 1, "The_left_hand_side_of_a_for_in_statement_may_not_be_an_optional_property_access_2780", "The left-hand side of a 'for...in' statement may not be an optional property access."),
            The_left_hand_side_of_a_for_of_statement_may_not_be_an_optional_property_access: diag(2781, 1, "The_left_hand_side_of_a_for_of_statement_may_not_be_an_optional_property_access_2781", "The left-hand side of a 'for...of' statement may not be an optional property access."),
            _0_needs_an_explicit_type_annotation: diag(2782, 3, "_0_needs_an_explicit_type_annotation_2782", "'{0}' needs an explicit type annotation."),
            _0_is_specified_more_than_once_so_this_usage_will_be_overwritten: diag(2783, 1, "_0_is_specified_more_than_once_so_this_usage_will_be_overwritten_2783", "'{0}' is specified more than once, so this usage will be overwritten."),
            get_and_set_accessors_cannot_declare_this_parameters: diag(2784, 1, "get_and_set_accessors_cannot_declare_this_parameters_2784", "'get' and 'set' accessors cannot declare 'this' parameters."),
            This_spread_always_overwrites_this_property: diag(2785, 1, "This_spread_always_overwrites_this_property_2785", "This spread always overwrites this property."),
            _0_cannot_be_used_as_a_JSX_component: diag(2786, 1, "_0_cannot_be_used_as_a_JSX_component_2786", "'{0}' cannot be used as a JSX component."),
            Its_return_type_0_is_not_a_valid_JSX_element: diag(2787, 1, "Its_return_type_0_is_not_a_valid_JSX_element_2787", "Its return type '{0}' is not a valid JSX element."),
            Its_instance_type_0_is_not_a_valid_JSX_element: diag(2788, 1, "Its_instance_type_0_is_not_a_valid_JSX_element_2788", "Its instance type '{0}' is not a valid JSX element."),
            Its_element_type_0_is_not_a_valid_JSX_element: diag(2789, 1, "Its_element_type_0_is_not_a_valid_JSX_element_2789", "Its element type '{0}' is not a valid JSX element."),
            The_operand_of_a_delete_operator_must_be_optional: diag(2790, 1, "The_operand_of_a_delete_operator_must_be_optional_2790", "The operand of a 'delete' operator must be optional."),
            Exponentiation_cannot_be_performed_on_bigint_values_unless_the_target_option_is_set_to_es2016_or_later: diag(2791, 1, "Exponentiation_cannot_be_performed_on_bigint_values_unless_the_target_option_is_set_to_es2016_or_lat_2791", "Exponentiation cannot be performed on 'bigint' values unless the 'target' option is set to 'es2016' or later."),
            Cannot_find_module_0_Did_you_mean_to_set_the_moduleResolution_option_to_nodenext_or_to_add_aliases_to_the_paths_option: diag(2792, 1, "Cannot_find_module_0_Did_you_mean_to_set_the_moduleResolution_option_to_nodenext_or_to_add_aliases_t_2792", "Cannot find module '{0}'. Did you mean to set the 'moduleResolution' option to 'nodenext', or to add aliases to the 'paths' option?"),
            The_call_would_have_succeeded_against_this_implementation_but_implementation_signatures_of_overloads_are_not_externally_visible: diag(2793, 1, "The_call_would_have_succeeded_against_this_implementation_but_implementation_signatures_of_overloads_2793", "The call would have succeeded against this implementation, but implementation signatures of overloads are not externally visible."),
            Expected_0_arguments_but_got_1_Did_you_forget_to_include_void_in_your_type_argument_to_Promise: diag(2794, 1, "Expected_0_arguments_but_got_1_Did_you_forget_to_include_void_in_your_type_argument_to_Promise_2794", "Expected {0} arguments, but got {1}. Did you forget to include 'void' in your type argument to 'Promise'?"),
            The_intrinsic_keyword_can_only_be_used_to_declare_compiler_provided_intrinsic_types: diag(2795, 1, "The_intrinsic_keyword_can_only_be_used_to_declare_compiler_provided_intrinsic_types_2795", "The 'intrinsic' keyword can only be used to declare compiler provided intrinsic types."),
            It_is_likely_that_you_are_missing_a_comma_to_separate_these_two_template_expressions_They_form_a_tagged_template_expression_which_cannot_be_invoked: diag(2796, 1, "It_is_likely_that_you_are_missing_a_comma_to_separate_these_two_template_expressions_They_form_a_tag_2796", "It is likely that you are missing a comma to separate these two template expressions. They form a tagged template expression which cannot be invoked."),
            A_mixin_class_that_extends_from_a_type_variable_containing_an_abstract_construct_signature_must_also_be_declared_abstract: diag(2797, 1, "A_mixin_class_that_extends_from_a_type_variable_containing_an_abstract_construct_signature_must_also_2797", "A mixin class that extends from a type variable containing an abstract construct signature must also be declared 'abstract'."),
            The_declaration_was_marked_as_deprecated_here: diag(2798, 1, "The_declaration_was_marked_as_deprecated_here_2798", "The declaration was marked as deprecated here."),
            Type_produces_a_tuple_type_that_is_too_large_to_represent: diag(2799, 1, "Type_produces_a_tuple_type_that_is_too_large_to_represent_2799", "Type produces a tuple type that is too large to represent."),
            Expression_produces_a_tuple_type_that_is_too_large_to_represent: diag(2800, 1, "Expression_produces_a_tuple_type_that_is_too_large_to_represent_2800", "Expression produces a tuple type that is too large to represent."),
            This_condition_will_always_return_true_since_this_0_is_always_defined: diag(2801, 1, "This_condition_will_always_return_true_since_this_0_is_always_defined_2801", "This condition will always return true since this '{0}' is always defined."),
            Type_0_can_only_be_iterated_through_when_using_the_downlevelIteration_flag_or_with_a_target_of_es2015_or_higher: diag(2802, 1, "Type_0_can_only_be_iterated_through_when_using_the_downlevelIteration_flag_or_with_a_target_of_es201_2802", "Type '{0}' can only be iterated through when using the '--downlevelIteration' flag or with a '--target' of 'es2015' or higher."),
            Cannot_assign_to_private_method_0_Private_methods_are_not_writable: diag(2803, 1, "Cannot_assign_to_private_method_0_Private_methods_are_not_writable_2803", "Cannot assign to private method '{0}'. Private methods are not writable."),
            Duplicate_identifier_0_Static_and_instance_elements_cannot_share_the_same_private_name: diag(2804, 1, "Duplicate_identifier_0_Static_and_instance_elements_cannot_share_the_same_private_name_2804", "Duplicate identifier '{0}'. Static and instance elements cannot share the same private name."),
            Private_accessor_was_defined_without_a_getter: diag(2806, 1, "Private_accessor_was_defined_without_a_getter_2806", "Private accessor was defined without a getter."),
            This_syntax_requires_an_imported_helper_named_1_with_2_parameters_which_is_not_compatible_with_the_one_in_0_Consider_upgrading_your_version_of_0: diag(2807, 1, "This_syntax_requires_an_imported_helper_named_1_with_2_parameters_which_is_not_compatible_with_the_o_2807", "This syntax requires an imported helper named '{1}' with {2} parameters, which is not compatible with the one in '{0}'. Consider upgrading your version of '{0}'."),
            A_get_accessor_must_be_at_least_as_accessible_as_the_setter: diag(2808, 1, "A_get_accessor_must_be_at_least_as_accessible_as_the_setter_2808", "A get accessor must be at least as accessible as the setter"),
            Declaration_or_statement_expected_This_follows_a_block_of_statements_so_if_you_intended_to_write_a_destructuring_assignment_you_might_need_to_wrap_the_whole_assignment_in_parentheses: diag(2809, 1, "Declaration_or_statement_expected_This_follows_a_block_of_statements_so_if_you_intended_to_write_a_d_2809", "Declaration or statement expected. This '=' follows a block of statements, so if you intended to write a destructuring assignment, you might need to wrap the whole assignment in parentheses."),
            Expected_1_argument_but_got_0_new_Promise_needs_a_JSDoc_hint_to_produce_a_resolve_that_can_be_called_without_arguments: diag(2810, 1, "Expected_1_argument_but_got_0_new_Promise_needs_a_JSDoc_hint_to_produce_a_resolve_that_can_be_called_2810", "Expected 1 argument, but got 0. 'new Promise()' needs a JSDoc hint to produce a 'resolve' that can be called without arguments."),
            Initializer_for_property_0: diag(2811, 1, "Initializer_for_property_0_2811", "Initializer for property '{0}'"),
            Property_0_does_not_exist_on_type_1_Try_changing_the_lib_compiler_option_to_include_dom: diag(2812, 1, "Property_0_does_not_exist_on_type_1_Try_changing_the_lib_compiler_option_to_include_dom_2812", "Property '{0}' does not exist on type '{1}'. Try changing the 'lib' compiler option to include 'dom'."),
            Class_declaration_cannot_implement_overload_list_for_0: diag(2813, 1, "Class_declaration_cannot_implement_overload_list_for_0_2813", "Class declaration cannot implement overload list for '{0}'."),
            Function_with_bodies_can_only_merge_with_classes_that_are_ambient: diag(2814, 1, "Function_with_bodies_can_only_merge_with_classes_that_are_ambient_2814", "Function with bodies can only merge with classes that are ambient."),
            arguments_cannot_be_referenced_in_property_initializers: diag(2815, 1, "arguments_cannot_be_referenced_in_property_initializers_2815", "'arguments' cannot be referenced in property initializers."),
            Cannot_use_this_in_a_static_property_initializer_of_a_decorated_class: diag(2816, 1, "Cannot_use_this_in_a_static_property_initializer_of_a_decorated_class_2816", "Cannot use 'this' in a static property initializer of a decorated class."),
            Property_0_has_no_initializer_and_is_not_definitely_assigned_in_a_class_static_block: diag(2817, 1, "Property_0_has_no_initializer_and_is_not_definitely_assigned_in_a_class_static_block_2817", "Property '{0}' has no initializer and is not definitely assigned in a class static block."),
            Duplicate_identifier_0_Compiler_reserves_name_1_when_emitting_super_references_in_static_initializers: diag(2818, 1, "Duplicate_identifier_0_Compiler_reserves_name_1_when_emitting_super_references_in_static_initializer_2818", "Duplicate identifier '{0}'. Compiler reserves name '{1}' when emitting 'super' references in static initializers."),
            Namespace_name_cannot_be_0: diag(2819, 1, "Namespace_name_cannot_be_0_2819", "Namespace name cannot be '{0}'."),
            Type_0_is_not_assignable_to_type_1_Did_you_mean_2: diag(2820, 1, "Type_0_is_not_assignable_to_type_1_Did_you_mean_2_2820", "Type '{0}' is not assignable to type '{1}'. Did you mean '{2}'?"),
            Import_assertions_are_only_supported_when_the_module_option_is_set_to_esnext_or_nodenext: diag(2821, 1, "Import_assertions_are_only_supported_when_the_module_option_is_set_to_esnext_or_nodenext_2821", "Import assertions are only supported when the '--module' option is set to 'esnext' or 'nodenext'."),
            Import_assertions_cannot_be_used_with_type_only_imports_or_exports: diag(2822, 1, "Import_assertions_cannot_be_used_with_type_only_imports_or_exports_2822", "Import assertions cannot be used with type-only imports or exports."),
            Import_attributes_are_only_supported_when_the_module_option_is_set_to_esnext_or_nodenext: diag(2823, 1, "Import_attributes_are_only_supported_when_the_module_option_is_set_to_esnext_or_nodenext_2823", "Import attributes are only supported when the '--module' option is set to 'esnext' or 'nodenext'."),
            Cannot_find_namespace_0_Did_you_mean_1: diag(2833, 1, "Cannot_find_namespace_0_Did_you_mean_1_2833", "Cannot find namespace '{0}'. Did you mean '{1}'?"),
            Relative_import_paths_need_explicit_file_extensions_in_ECMAScript_imports_when_moduleResolution_is_node16_or_nodenext_Consider_adding_an_extension_to_the_import_path: diag(2834, 1, "Relative_import_paths_need_explicit_file_extensions_in_ECMAScript_imports_when_moduleResolution_is_n_2834", "Relative import paths need explicit file extensions in ECMAScript imports when '--moduleResolution' is 'node16' or 'nodenext'. Consider adding an extension to the import path."),
            Relative_import_paths_need_explicit_file_extensions_in_ECMAScript_imports_when_moduleResolution_is_node16_or_nodenext_Did_you_mean_0: diag(2835, 1, "Relative_import_paths_need_explicit_file_extensions_in_ECMAScript_imports_when_moduleResolution_is_n_2835", "Relative import paths need explicit file extensions in ECMAScript imports when '--moduleResolution' is 'node16' or 'nodenext'. Did you mean '{0}'?"),
            Import_assertions_are_not_allowed_on_statements_that_compile_to_CommonJS_require_calls: diag(2836, 1, "Import_assertions_are_not_allowed_on_statements_that_compile_to_CommonJS_require_calls_2836", "Import assertions are not allowed on statements that compile to CommonJS 'require' calls."),
            Import_assertion_values_must_be_string_literal_expressions: diag(2837, 1, "Import_assertion_values_must_be_string_literal_expressions_2837", "Import assertion values must be string literal expressions."),
            All_declarations_of_0_must_have_identical_constraints: diag(2838, 1, "All_declarations_of_0_must_have_identical_constraints_2838", "All declarations of '{0}' must have identical constraints."),
            This_condition_will_always_return_0_since_JavaScript_compares_objects_by_reference_not_value: diag(2839, 1, "This_condition_will_always_return_0_since_JavaScript_compares_objects_by_reference_not_value_2839", "This condition will always return '{0}' since JavaScript compares objects by reference, not value."),
            An_interface_cannot_extend_a_primitive_type_like_0_It_can_only_extend_other_named_object_types: diag(2840, 1, "An_interface_cannot_extend_a_primitive_type_like_0_It_can_only_extend_other_named_object_types_2840", "An interface cannot extend a primitive type like '{0}'. It can only extend other named object types."),
            _0_is_an_unused_renaming_of_1_Did_you_intend_to_use_it_as_a_type_annotation: diag(2842, 1, "_0_is_an_unused_renaming_of_1_Did_you_intend_to_use_it_as_a_type_annotation_2842", "'{0}' is an unused renaming of '{1}'. Did you intend to use it as a type annotation?"),
            We_can_only_write_a_type_for_0_by_adding_a_type_for_the_entire_parameter_here: diag(2843, 1, "We_can_only_write_a_type_for_0_by_adding_a_type_for_the_entire_parameter_here_2843", "We can only write a type for '{0}' by adding a type for the entire parameter here."),
            Type_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor: diag(2844, 1, "Type_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor_2844", "Type of instance member variable '{0}' cannot reference identifier '{1}' declared in the constructor."),
            This_condition_will_always_return_0: diag(2845, 1, "This_condition_will_always_return_0_2845", "This condition will always return '{0}'."),
            A_declaration_file_cannot_be_imported_without_import_type_Did_you_mean_to_import_an_implementation_file_0_instead: diag(2846, 1, "A_declaration_file_cannot_be_imported_without_import_type_Did_you_mean_to_import_an_implementation_f_2846", "A declaration file cannot be imported without 'import type'. Did you mean to import an implementation file '{0}' instead?"),
            The_right_hand_side_of_an_instanceof_expression_must_not_be_an_instantiation_expression: diag(2848, 1, "The_right_hand_side_of_an_instanceof_expression_must_not_be_an_instantiation_expression_2848", "The right-hand side of an 'instanceof' expression must not be an instantiation expression."),
            Target_signature_provides_too_few_arguments_Expected_0_or_more_but_got_1: diag(2849, 1, "Target_signature_provides_too_few_arguments_Expected_0_or_more_but_got_1_2849", "Target signature provides too few arguments. Expected {0} or more, but got {1}."),
            The_initializer_of_a_using_declaration_must_be_either_an_object_with_a_Symbol_dispose_method_or_be_null_or_undefined: diag(2850, 1, "The_initializer_of_a_using_declaration_must_be_either_an_object_with_a_Symbol_dispose_method_or_be_n_2850", "The initializer of a 'using' declaration must be either an object with a '[Symbol.dispose]()' method, or be 'null' or 'undefined'."),
            The_initializer_of_an_await_using_declaration_must_be_either_an_object_with_a_Symbol_asyncDispose_or_Symbol_dispose_method_or_be_null_or_undefined: diag(2851, 1, "The_initializer_of_an_await_using_declaration_must_be_either_an_object_with_a_Symbol_asyncDispose_or_2851", "The initializer of an 'await using' declaration must be either an object with a '[Symbol.asyncDispose]()' or '[Symbol.dispose]()' method, or be 'null' or 'undefined'."),
            await_using_statements_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules: diag(2852, 1, "await_using_statements_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules_2852", "'await using' statements are only allowed within async functions and at the top levels of modules."),
            await_using_statements_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_has_no_imports_or_exports_Consider_adding_an_empty_export_to_make_this_file_a_module: diag(2853, 1, "await_using_statements_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_th_2853", "'await using' statements are only allowed at the top level of a file when that file is a module, but this file has no imports or exports. Consider adding an empty 'export {}' to make this file a module."),
            Top_level_await_using_statements_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_node16_or_nodenext_and_the_target_option_is_set_to_es2017_or_higher: diag(2854, 1, "Top_level_await_using_statements_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_sys_2854", "Top-level 'await using' statements are only allowed when the 'module' option is set to 'es2022', 'esnext', 'system', 'node16', or 'nodenext', and the 'target' option is set to 'es2017' or higher."),
            Class_field_0_defined_by_the_parent_class_is_not_accessible_in_the_child_class_via_super: diag(2855, 1, "Class_field_0_defined_by_the_parent_class_is_not_accessible_in_the_child_class_via_super_2855", "Class field '{0}' defined by the parent class is not accessible in the child class via super."),
            Import_attributes_are_not_allowed_on_statements_that_compile_to_CommonJS_require_calls: diag(2856, 1, "Import_attributes_are_not_allowed_on_statements_that_compile_to_CommonJS_require_calls_2856", "Import attributes are not allowed on statements that compile to CommonJS 'require' calls."),
            Import_attributes_cannot_be_used_with_type_only_imports_or_exports: diag(2857, 1, "Import_attributes_cannot_be_used_with_type_only_imports_or_exports_2857", "Import attributes cannot be used with type-only imports or exports."),
            Import_attribute_values_must_be_string_literal_expressions: diag(2858, 1, "Import_attribute_values_must_be_string_literal_expressions_2858", "Import attribute values must be string literal expressions."),
            Excessive_complexity_comparing_types_0_and_1: diag(2859, 1, "Excessive_complexity_comparing_types_0_and_1_2859", "Excessive complexity comparing types '{0}' and '{1}'."),
            The_left_hand_side_of_an_instanceof_expression_must_be_assignable_to_the_first_argument_of_the_right_hand_side_s_Symbol_hasInstance_method: diag(2860, 1, "The_left_hand_side_of_an_instanceof_expression_must_be_assignable_to_the_first_argument_of_the_right_2860", "The left-hand side of an 'instanceof' expression must be assignable to the first argument of the right-hand side's '[Symbol.hasInstance]' method."),
            An_object_s_Symbol_hasInstance_method_must_return_a_boolean_value_for_it_to_be_used_on_the_right_hand_side_of_an_instanceof_expression: diag(2861, 1, "An_object_s_Symbol_hasInstance_method_must_return_a_boolean_value_for_it_to_be_used_on_the_right_han_2861", "An object's '[Symbol.hasInstance]' method must return a boolean value for it to be used on the right-hand side of an 'instanceof' expression."),
            Type_0_is_generic_and_can_only_be_indexed_for_reading: diag(2862, 1, "Type_0_is_generic_and_can_only_be_indexed_for_reading_2862", "Type '{0}' is generic and can only be indexed for reading."),
            A_class_cannot_extend_a_primitive_type_like_0_Classes_can_only_extend_constructable_values: diag(2863, 1, "A_class_cannot_extend_a_primitive_type_like_0_Classes_can_only_extend_constructable_values_2863", "A class cannot extend a primitive type like '{0}'. Classes can only extend constructable values."),
            A_class_cannot_implement_a_primitive_type_like_0_It_can_only_implement_other_named_object_types: diag(2864, 1, "A_class_cannot_implement_a_primitive_type_like_0_It_can_only_implement_other_named_object_types_2864", "A class cannot implement a primitive type like '{0}'. It can only implement other named object types."),
            Import_declaration_0_is_using_private_name_1: diag(4e3, 1, "Import_declaration_0_is_using_private_name_1_4000", "Import declaration '{0}' is using private name '{1}'."),
            Type_parameter_0_of_exported_class_has_or_is_using_private_name_1: diag(4002, 1, "Type_parameter_0_of_exported_class_has_or_is_using_private_name_1_4002", "Type parameter '{0}' of exported class has or is using private name '{1}'."),
            Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1: diag(4004, 1, "Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1_4004", "Type parameter '{0}' of exported interface has or is using private name '{1}'."),
            Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4006, 1, "Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4006", "Type parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),
            Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4008, 1, "Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4008", "Type parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),
            Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: diag(4010, 1, "Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4010", "Type parameter '{0}' of public static method from exported class has or is using private name '{1}'."),
            Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: diag(4012, 1, "Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4012", "Type parameter '{0}' of public method from exported class has or is using private name '{1}'."),
            Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: diag(4014, 1, "Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4014", "Type parameter '{0}' of method from exported interface has or is using private name '{1}'."),
            Type_parameter_0_of_exported_function_has_or_is_using_private_name_1: diag(4016, 1, "Type_parameter_0_of_exported_function_has_or_is_using_private_name_1_4016", "Type parameter '{0}' of exported function has or is using private name '{1}'."),
            Implements_clause_of_exported_class_0_has_or_is_using_private_name_1: diag(4019, 1, "Implements_clause_of_exported_class_0_has_or_is_using_private_name_1_4019", "Implements clause of exported class '{0}' has or is using private name '{1}'."),
            extends_clause_of_exported_class_0_has_or_is_using_private_name_1: diag(4020, 1, "extends_clause_of_exported_class_0_has_or_is_using_private_name_1_4020", "'extends' clause of exported class '{0}' has or is using private name '{1}'."),
            extends_clause_of_exported_class_has_or_is_using_private_name_0: diag(4021, 1, "extends_clause_of_exported_class_has_or_is_using_private_name_0_4021", "'extends' clause of exported class has or is using private name '{0}'."),
            extends_clause_of_exported_interface_0_has_or_is_using_private_name_1: diag(4022, 1, "extends_clause_of_exported_interface_0_has_or_is_using_private_name_1_4022", "'extends' clause of exported interface '{0}' has or is using private name '{1}'."),
            Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4023, 1, "Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4023", "Exported variable '{0}' has or is using name '{1}' from external module {2} but cannot be named."),
            Exported_variable_0_has_or_is_using_name_1_from_private_module_2: diag(4024, 1, "Exported_variable_0_has_or_is_using_name_1_from_private_module_2_4024", "Exported variable '{0}' has or is using name '{1}' from private module '{2}'."),
            Exported_variable_0_has_or_is_using_private_name_1: diag(4025, 1, "Exported_variable_0_has_or_is_using_private_name_1_4025", "Exported variable '{0}' has or is using private name '{1}'."),
            Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4026, 1, "Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot__4026", "Public static property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4027, 1, "Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4027", "Public static property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
            Public_static_property_0_of_exported_class_has_or_is_using_private_name_1: diag(4028, 1, "Public_static_property_0_of_exported_class_has_or_is_using_private_name_1_4028", "Public static property '{0}' of exported class has or is using private name '{1}'."),
            Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4029, 1, "Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_name_4029", "Public property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4030, 1, "Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4030", "Public property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
            Public_property_0_of_exported_class_has_or_is_using_private_name_1: diag(4031, 1, "Public_property_0_of_exported_class_has_or_is_using_private_name_1_4031", "Public property '{0}' of exported class has or is using private name '{1}'."),
            Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4032, 1, "Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4032", "Property '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),
            Property_0_of_exported_interface_has_or_is_using_private_name_1: diag(4033, 1, "Property_0_of_exported_interface_has_or_is_using_private_name_1_4033", "Property '{0}' of exported interface has or is using private name '{1}'."),
            Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4034, 1, "Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_mod_4034", "Parameter type of public static setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
            Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1: diag(4035, 1, "Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1_4035", "Parameter type of public static setter '{0}' from exported class has or is using private name '{1}'."),
            Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4036, 1, "Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4036", "Parameter type of public setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
            Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1: diag(4037, 1, "Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1_4037", "Parameter type of public setter '{0}' from exported class has or is using private name '{1}'."),
            Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4038, 1, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_modul_4038", "Return type of public static getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4039, 1, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_4039", "Return type of public static getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
            Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1: diag(4040, 1, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1_4040", "Return type of public static getter '{0}' from exported class has or is using private name '{1}'."),
            Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4041, 1, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_4041", "Return type of public getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4042, 1, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4042", "Return type of public getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
            Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1: diag(4043, 1, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1_4043", "Return type of public getter '{0}' from exported class has or is using private name '{1}'."),
            Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4044, 1, "Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_mod_4044", "Return type of constructor signature from exported interface has or is using name '{0}' from private module '{1}'."),
            Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4045, 1, "Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0_4045", "Return type of constructor signature from exported interface has or is using private name '{0}'."),
            Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4046, 1, "Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4046", "Return type of call signature from exported interface has or is using name '{0}' from private module '{1}'."),
            Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4047, 1, "Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0_4047", "Return type of call signature from exported interface has or is using private name '{0}'."),
            Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4048, 1, "Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4048", "Return type of index signature from exported interface has or is using name '{0}' from private module '{1}'."),
            Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4049, 1, "Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0_4049", "Return type of index signature from exported interface has or is using private name '{0}'."),
            Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4050, 1, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module__4050", "Return type of public static method from exported class has or is using name '{0}' from external module {1} but cannot be named."),
            Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: diag(4051, 1, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4051", "Return type of public static method from exported class has or is using name '{0}' from private module '{1}'."),
            Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0: diag(4052, 1, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0_4052", "Return type of public static method from exported class has or is using private name '{0}'."),
            Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4053, 1, "Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_c_4053", "Return type of public method from exported class has or is using name '{0}' from external module {1} but cannot be named."),
            Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: diag(4054, 1, "Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4054", "Return type of public method from exported class has or is using name '{0}' from private module '{1}'."),
            Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0: diag(4055, 1, "Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0_4055", "Return type of public method from exported class has or is using private name '{0}'."),
            Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4056, 1, "Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4056", "Return type of method from exported interface has or is using name '{0}' from private module '{1}'."),
            Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0: diag(4057, 1, "Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0_4057", "Return type of method from exported interface has or is using private name '{0}'."),
            Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4058, 1, "Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named_4058", "Return type of exported function has or is using name '{0}' from external module {1} but cannot be named."),
            Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1: diag(4059, 1, "Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1_4059", "Return type of exported function has or is using name '{0}' from private module '{1}'."),
            Return_type_of_exported_function_has_or_is_using_private_name_0: diag(4060, 1, "Return_type_of_exported_function_has_or_is_using_private_name_0_4060", "Return type of exported function has or is using private name '{0}'."),
            Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4061, 1, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_can_4061", "Parameter '{0}' of constructor from exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4062, 1, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2_4062", "Parameter '{0}' of constructor from exported class has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1: diag(4063, 1, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1_4063", "Parameter '{0}' of constructor from exported class has or is using private name '{1}'."),
            Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4064, 1, "Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_mod_4064", "Parameter '{0}' of constructor signature from exported interface has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4065, 1, "Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4065", "Parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),
            Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4066, 1, "Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4066", "Parameter '{0}' of call signature from exported interface has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4067, 1, "Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4067", "Parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),
            Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4068, 1, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module__4068", "Parameter '{0}' of public static method from exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4069, 1, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4069", "Parameter '{0}' of public static method from exported class has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: diag(4070, 1, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4070", "Parameter '{0}' of public static method from exported class has or is using private name '{1}'."),
            Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4071, 1, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_c_4071", "Parameter '{0}' of public method from exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4072, 1, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4072", "Parameter '{0}' of public method from exported class has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: diag(4073, 1, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4073", "Parameter '{0}' of public method from exported class has or is using private name '{1}'."),
            Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4074, 1, "Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4074", "Parameter '{0}' of method from exported interface has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: diag(4075, 1, "Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4075", "Parameter '{0}' of method from exported interface has or is using private name '{1}'."),
            Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4076, 1, "Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4076", "Parameter '{0}' of exported function has or is using name '{1}' from external module {2} but cannot be named."),
            Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2: diag(4077, 1, "Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2_4077", "Parameter '{0}' of exported function has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_exported_function_has_or_is_using_private_name_1: diag(4078, 1, "Parameter_0_of_exported_function_has_or_is_using_private_name_1_4078", "Parameter '{0}' of exported function has or is using private name '{1}'."),
            Exported_type_alias_0_has_or_is_using_private_name_1: diag(4081, 1, "Exported_type_alias_0_has_or_is_using_private_name_1_4081", "Exported type alias '{0}' has or is using private name '{1}'."),
            Default_export_of_the_module_has_or_is_using_private_name_0: diag(4082, 1, "Default_export_of_the_module_has_or_is_using_private_name_0_4082", "Default export of the module has or is using private name '{0}'."),
            Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1: diag(4083, 1, "Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1_4083", "Type parameter '{0}' of exported type alias has or is using private name '{1}'."),
            Exported_type_alias_0_has_or_is_using_private_name_1_from_module_2: diag(4084, 1, "Exported_type_alias_0_has_or_is_using_private_name_1_from_module_2_4084", "Exported type alias '{0}' has or is using private name '{1}' from module {2}."),
            Extends_clause_for_inferred_type_0_has_or_is_using_private_name_1: diag(4085, 1, "Extends_clause_for_inferred_type_0_has_or_is_using_private_name_1_4085", "Extends clause for inferred type '{0}' has or is using private name '{1}'."),
            Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_library_to_resolve_the_conflict: diag(4090, 1, "Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_librar_4090", "Conflicting definitions for '{0}' found at '{1}' and '{2}'. Consider installing a specific version of this library to resolve the conflict."),
            Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4091, 1, "Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4091", "Parameter '{0}' of index signature from exported interface has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4092, 1, "Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1_4092", "Parameter '{0}' of index signature from exported interface has or is using private name '{1}'."),
            Property_0_of_exported_class_expression_may_not_be_private_or_protected: diag(4094, 1, "Property_0_of_exported_class_expression_may_not_be_private_or_protected_4094", "Property '{0}' of exported class expression may not be private or protected."),
            Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4095, 1, "Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_4095", "Public static method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4096, 1, "Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4096", "Public static method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
            Public_static_method_0_of_exported_class_has_or_is_using_private_name_1: diag(4097, 1, "Public_static_method_0_of_exported_class_has_or_is_using_private_name_1_4097", "Public static method '{0}' of exported class has or is using private name '{1}'."),
            Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4098, 1, "Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4098", "Public method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
            Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4099, 1, "Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4099", "Public method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
            Public_method_0_of_exported_class_has_or_is_using_private_name_1: diag(4100, 1, "Public_method_0_of_exported_class_has_or_is_using_private_name_1_4100", "Public method '{0}' of exported class has or is using private name '{1}'."),
            Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4101, 1, "Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4101", "Method '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),
            Method_0_of_exported_interface_has_or_is_using_private_name_1: diag(4102, 1, "Method_0_of_exported_interface_has_or_is_using_private_name_1_4102", "Method '{0}' of exported interface has or is using private name '{1}'."),
            Type_parameter_0_of_exported_mapped_object_type_is_using_private_name_1: diag(4103, 1, "Type_parameter_0_of_exported_mapped_object_type_is_using_private_name_1_4103", "Type parameter '{0}' of exported mapped object type is using private name '{1}'."),
            The_type_0_is_readonly_and_cannot_be_assigned_to_the_mutable_type_1: diag(4104, 1, "The_type_0_is_readonly_and_cannot_be_assigned_to_the_mutable_type_1_4104", "The type '{0}' is 'readonly' and cannot be assigned to the mutable type '{1}'."),
            Private_or_protected_member_0_cannot_be_accessed_on_a_type_parameter: diag(4105, 1, "Private_or_protected_member_0_cannot_be_accessed_on_a_type_parameter_4105", "Private or protected member '{0}' cannot be accessed on a type parameter."),
            Parameter_0_of_accessor_has_or_is_using_private_name_1: diag(4106, 1, "Parameter_0_of_accessor_has_or_is_using_private_name_1_4106", "Parameter '{0}' of accessor has or is using private name '{1}'."),
            Parameter_0_of_accessor_has_or_is_using_name_1_from_private_module_2: diag(4107, 1, "Parameter_0_of_accessor_has_or_is_using_name_1_from_private_module_2_4107", "Parameter '{0}' of accessor has or is using name '{1}' from private module '{2}'."),
            Parameter_0_of_accessor_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4108, 1, "Parameter_0_of_accessor_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4108", "Parameter '{0}' of accessor has or is using name '{1}' from external module '{2}' but cannot be named."),
            Type_arguments_for_0_circularly_reference_themselves: diag(4109, 1, "Type_arguments_for_0_circularly_reference_themselves_4109", "Type arguments for '{0}' circularly reference themselves."),
            Tuple_type_arguments_circularly_reference_themselves: diag(4110, 1, "Tuple_type_arguments_circularly_reference_themselves_4110", "Tuple type arguments circularly reference themselves."),
            Property_0_comes_from_an_index_signature_so_it_must_be_accessed_with_0: diag(4111, 1, "Property_0_comes_from_an_index_signature_so_it_must_be_accessed_with_0_4111", "Property '{0}' comes from an index signature, so it must be accessed with ['{0}']."),
            This_member_cannot_have_an_override_modifier_because_its_containing_class_0_does_not_extend_another_class: diag(4112, 1, "This_member_cannot_have_an_override_modifier_because_its_containing_class_0_does_not_extend_another__4112", "This member cannot have an 'override' modifier because its containing class '{0}' does not extend another class."),
            This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0: diag(4113, 1, "This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0_4113", "This member cannot have an 'override' modifier because it is not declared in the base class '{0}'."),
            This_member_must_have_an_override_modifier_because_it_overrides_a_member_in_the_base_class_0: diag(4114, 1, "This_member_must_have_an_override_modifier_because_it_overrides_a_member_in_the_base_class_0_4114", "This member must have an 'override' modifier because it overrides a member in the base class '{0}'."),
            This_parameter_property_must_have_an_override_modifier_because_it_overrides_a_member_in_base_class_0: diag(4115, 1, "This_parameter_property_must_have_an_override_modifier_because_it_overrides_a_member_in_base_class_0_4115", "This parameter property must have an 'override' modifier because it overrides a member in base class '{0}'."),
            This_member_must_have_an_override_modifier_because_it_overrides_an_abstract_method_that_is_declared_in_the_base_class_0: diag(4116, 1, "This_member_must_have_an_override_modifier_because_it_overrides_an_abstract_method_that_is_declared__4116", "This member must have an 'override' modifier because it overrides an abstract method that is declared in the base class '{0}'."),
            This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0_Did_you_mean_1: diag(4117, 1, "This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0_Did_you__4117", "This member cannot have an 'override' modifier because it is not declared in the base class '{0}'. Did you mean '{1}'?"),
            The_type_of_this_node_cannot_be_serialized_because_its_property_0_cannot_be_serialized: diag(4118, 1, "The_type_of_this_node_cannot_be_serialized_because_its_property_0_cannot_be_serialized_4118", "The type of this node cannot be serialized because its property '{0}' cannot be serialized."),
            This_member_must_have_a_JSDoc_comment_with_an_override_tag_because_it_overrides_a_member_in_the_base_class_0: diag(4119, 1, "This_member_must_have_a_JSDoc_comment_with_an_override_tag_because_it_overrides_a_member_in_the_base_4119", "This member must have a JSDoc comment with an '@override' tag because it overrides a member in the base class '{0}'."),
            This_parameter_property_must_have_a_JSDoc_comment_with_an_override_tag_because_it_overrides_a_member_in_the_base_class_0: diag(4120, 1, "This_parameter_property_must_have_a_JSDoc_comment_with_an_override_tag_because_it_overrides_a_member_4120", "This parameter property must have a JSDoc comment with an '@override' tag because it overrides a member in the base class '{0}'."),
            This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_its_containing_class_0_does_not_extend_another_class: diag(4121, 1, "This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_its_containing_class_0_does_not_4121", "This member cannot have a JSDoc comment with an '@override' tag because its containing class '{0}' does not extend another class."),
            This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_it_is_not_declared_in_the_base_class_0: diag(4122, 1, "This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_it_is_not_declared_in_the_base__4122", "This member cannot have a JSDoc comment with an '@override' tag because it is not declared in the base class '{0}'."),
            This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_it_is_not_declared_in_the_base_class_0_Did_you_mean_1: diag(4123, 1, "This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_it_is_not_declared_in_the_base__4123", "This member cannot have a JSDoc comment with an 'override' tag because it is not declared in the base class '{0}'. Did you mean '{1}'?"),
            Compiler_option_0_of_value_1_is_unstable_Use_nightly_TypeScript_to_silence_this_error_Try_updating_with_npm_install_D_typescript_next: diag(4124, 1, "Compiler_option_0_of_value_1_is_unstable_Use_nightly_TypeScript_to_silence_this_error_Try_updating_w_4124", "Compiler option '{0}' of value '{1}' is unstable. Use nightly TypeScript to silence this error. Try updating with 'npm install -D typescript@next'."),
            The_current_host_does_not_support_the_0_option: diag(5001, 1, "The_current_host_does_not_support_the_0_option_5001", "The current host does not support the '{0}' option."),
            Cannot_find_the_common_subdirectory_path_for_the_input_files: diag(5009, 1, "Cannot_find_the_common_subdirectory_path_for_the_input_files_5009", "Cannot find the common subdirectory path for the input files."),
            File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0: diag(5010, 1, "File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0_5010", "File specification cannot end in a recursive directory wildcard ('**'): '{0}'."),
            Cannot_read_file_0_Colon_1: diag(5012, 1, "Cannot_read_file_0_Colon_1_5012", "Cannot read file '{0}': {1}."),
            Failed_to_parse_file_0_Colon_1: diag(5014, 1, "Failed_to_parse_file_0_Colon_1_5014", "Failed to parse file '{0}': {1}."),
            Unknown_compiler_option_0: diag(5023, 1, "Unknown_compiler_option_0_5023", "Unknown compiler option '{0}'."),
            Compiler_option_0_requires_a_value_of_type_1: diag(5024, 1, "Compiler_option_0_requires_a_value_of_type_1_5024", "Compiler option '{0}' requires a value of type {1}."),
            Unknown_compiler_option_0_Did_you_mean_1: diag(5025, 1, "Unknown_compiler_option_0_Did_you_mean_1_5025", "Unknown compiler option '{0}'. Did you mean '{1}'?"),
            Could_not_write_file_0_Colon_1: diag(5033, 1, "Could_not_write_file_0_Colon_1_5033", "Could not write file '{0}': {1}."),
            Option_project_cannot_be_mixed_with_source_files_on_a_command_line: diag(5042, 1, "Option_project_cannot_be_mixed_with_source_files_on_a_command_line_5042", "Option 'project' cannot be mixed with source files on a command line."),
            Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES2015_or_higher: diag(5047, 1, "Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES_5047", "Option 'isolatedModules' can only be used when either option '--module' is provided or option 'target' is 'ES2015' or higher."),
            Option_0_cannot_be_specified_when_option_target_is_ES3: diag(5048, 1, "Option_0_cannot_be_specified_when_option_target_is_ES3_5048", "Option '{0}' cannot be specified when option 'target' is 'ES3'."),
            Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided: diag(5051, 1, "Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided_5051", "Option '{0} can only be used when either option '--inlineSourceMap' or option '--sourceMap' is provided."),
            Option_0_cannot_be_specified_without_specifying_option_1: diag(5052, 1, "Option_0_cannot_be_specified_without_specifying_option_1_5052", "Option '{0}' cannot be specified without specifying option '{1}'."),
            Option_0_cannot_be_specified_with_option_1: diag(5053, 1, "Option_0_cannot_be_specified_with_option_1_5053", "Option '{0}' cannot be specified with option '{1}'."),
            A_tsconfig_json_file_is_already_defined_at_Colon_0: diag(5054, 1, "A_tsconfig_json_file_is_already_defined_at_Colon_0_5054", "A 'tsconfig.json' file is already defined at: '{0}'."),
            Cannot_write_file_0_because_it_would_overwrite_input_file: diag(5055, 1, "Cannot_write_file_0_because_it_would_overwrite_input_file_5055", "Cannot write file '{0}' because it would overwrite input file."),
            Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files: diag(5056, 1, "Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files_5056", "Cannot write file '{0}' because it would be overwritten by multiple input files."),
            Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0: diag(5057, 1, "Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0_5057", "Cannot find a tsconfig.json file at the specified directory: '{0}'."),
            The_specified_path_does_not_exist_Colon_0: diag(5058, 1, "The_specified_path_does_not_exist_Colon_0_5058", "The specified path does not exist: '{0}'."),
            Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier: diag(5059, 1, "Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier_5059", "Invalid value for '--reactNamespace'. '{0}' is not a valid identifier."),
            Pattern_0_can_have_at_most_one_Asterisk_character: diag(5061, 1, "Pattern_0_can_have_at_most_one_Asterisk_character_5061", "Pattern '{0}' can have at most one '*' character."),
            Substitution_0_in_pattern_1_can_have_at_most_one_Asterisk_character: diag(5062, 1, "Substitution_0_in_pattern_1_can_have_at_most_one_Asterisk_character_5062", "Substitution '{0}' in pattern '{1}' can have at most one '*' character."),
            Substitutions_for_pattern_0_should_be_an_array: diag(5063, 1, "Substitutions_for_pattern_0_should_be_an_array_5063", "Substitutions for pattern '{0}' should be an array."),
            Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2: diag(5064, 1, "Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2_5064", "Substitution '{0}' for pattern '{1}' has incorrect type, expected 'string', got '{2}'."),
            File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0: diag(5065, 1, "File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildca_5065", "File specification cannot contain a parent directory ('..') that appears after a recursive directory wildcard ('**'): '{0}'."),
            Substitutions_for_pattern_0_shouldn_t_be_an_empty_array: diag(5066, 1, "Substitutions_for_pattern_0_shouldn_t_be_an_empty_array_5066", "Substitutions for pattern '{0}' shouldn't be an empty array."),
            Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name: diag(5067, 1, "Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name_5067", "Invalid value for 'jsxFactory'. '{0}' is not a valid identifier or qualified-name."),
            Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript_files_Learn_more_at_https_Colon_Slash_Slashaka_ms_Slashtsconfig: diag(5068, 1, "Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript__5068", "Adding a tsconfig.json file will help organize projects that contain both TypeScript and JavaScript files. Learn more at https://aka.ms/tsconfig."),
            Option_0_cannot_be_specified_without_specifying_option_1_or_option_2: diag(5069, 1, "Option_0_cannot_be_specified_without_specifying_option_1_or_option_2_5069", "Option '{0}' cannot be specified without specifying option '{1}' or option '{2}'."),
            Option_resolveJsonModule_cannot_be_specified_when_moduleResolution_is_set_to_classic: diag(5070, 1, "Option_resolveJsonModule_cannot_be_specified_when_moduleResolution_is_set_to_classic_5070", "Option '--resolveJsonModule' cannot be specified when 'moduleResolution' is set to 'classic'."),
            Option_resolveJsonModule_can_only_be_specified_when_module_code_generation_is_commonjs_amd_es2015_or_esNext: diag(5071, 1, "Option_resolveJsonModule_can_only_be_specified_when_module_code_generation_is_commonjs_amd_es2015_or_5071", "Option '--resolveJsonModule' can only be specified when module code generation is 'commonjs', 'amd', 'es2015' or 'esNext'."),
            Unknown_build_option_0: diag(5072, 1, "Unknown_build_option_0_5072", "Unknown build option '{0}'."),
            Build_option_0_requires_a_value_of_type_1: diag(5073, 1, "Build_option_0_requires_a_value_of_type_1_5073", "Build option '{0}' requires a value of type {1}."),
            Option_incremental_can_only_be_specified_using_tsconfig_emitting_to_single_file_or_when_option_tsBuildInfoFile_is_specified: diag(5074, 1, "Option_incremental_can_only_be_specified_using_tsconfig_emitting_to_single_file_or_when_option_tsBui_5074", "Option '--incremental' can only be specified using tsconfig, emitting to single file or when option '--tsBuildInfoFile' is specified."),
            _0_is_assignable_to_the_constraint_of_type_1_but_1_could_be_instantiated_with_a_different_subtype_of_constraint_2: diag(5075, 1, "_0_is_assignable_to_the_constraint_of_type_1_but_1_could_be_instantiated_with_a_different_subtype_of_5075", "'{0}' is assignable to the constraint of type '{1}', but '{1}' could be instantiated with a different subtype of constraint '{2}'."),
            _0_and_1_operations_cannot_be_mixed_without_parentheses: diag(5076, 1, "_0_and_1_operations_cannot_be_mixed_without_parentheses_5076", "'{0}' and '{1}' operations cannot be mixed without parentheses."),
            Unknown_build_option_0_Did_you_mean_1: diag(5077, 1, "Unknown_build_option_0_Did_you_mean_1_5077", "Unknown build option '{0}'. Did you mean '{1}'?"),
            Unknown_watch_option_0: diag(5078, 1, "Unknown_watch_option_0_5078", "Unknown watch option '{0}'."),
            Unknown_watch_option_0_Did_you_mean_1: diag(5079, 1, "Unknown_watch_option_0_Did_you_mean_1_5079", "Unknown watch option '{0}'. Did you mean '{1}'?"),
            Watch_option_0_requires_a_value_of_type_1: diag(5080, 1, "Watch_option_0_requires_a_value_of_type_1_5080", "Watch option '{0}' requires a value of type {1}."),
            Cannot_find_a_tsconfig_json_file_at_the_current_directory_Colon_0: diag(5081, 1, "Cannot_find_a_tsconfig_json_file_at_the_current_directory_Colon_0_5081", "Cannot find a tsconfig.json file at the current directory: {0}."),
            _0_could_be_instantiated_with_an_arbitrary_type_which_could_be_unrelated_to_1: diag(5082, 1, "_0_could_be_instantiated_with_an_arbitrary_type_which_could_be_unrelated_to_1_5082", "'{0}' could be instantiated with an arbitrary type which could be unrelated to '{1}'."),
            Cannot_read_file_0: diag(5083, 1, "Cannot_read_file_0_5083", "Cannot read file '{0}'."),
            A_tuple_member_cannot_be_both_optional_and_rest: diag(5085, 1, "A_tuple_member_cannot_be_both_optional_and_rest_5085", "A tuple member cannot be both optional and rest."),
            A_labeled_tuple_element_is_declared_as_optional_with_a_question_mark_after_the_name_and_before_the_colon_rather_than_after_the_type: diag(5086, 1, "A_labeled_tuple_element_is_declared_as_optional_with_a_question_mark_after_the_name_and_before_the_c_5086", "A labeled tuple element is declared as optional with a question mark after the name and before the colon, rather than after the type."),
            A_labeled_tuple_element_is_declared_as_rest_with_a_before_the_name_rather_than_before_the_type: diag(5087, 1, "A_labeled_tuple_element_is_declared_as_rest_with_a_before_the_name_rather_than_before_the_type_5087", "A labeled tuple element is declared as rest with a '...' before the name, rather than before the type."),
            The_inferred_type_of_0_references_a_type_with_a_cyclic_structure_which_cannot_be_trivially_serialized_A_type_annotation_is_necessary: diag(5088, 1, "The_inferred_type_of_0_references_a_type_with_a_cyclic_structure_which_cannot_be_trivially_serialize_5088", "The inferred type of '{0}' references a type with a cyclic structure which cannot be trivially serialized. A type annotation is necessary."),
            Option_0_cannot_be_specified_when_option_jsx_is_1: diag(5089, 1, "Option_0_cannot_be_specified_when_option_jsx_is_1_5089", "Option '{0}' cannot be specified when option 'jsx' is '{1}'."),
            Non_relative_paths_are_not_allowed_when_baseUrl_is_not_set_Did_you_forget_a_leading_Slash: diag(5090, 1, "Non_relative_paths_are_not_allowed_when_baseUrl_is_not_set_Did_you_forget_a_leading_Slash_5090", "Non-relative paths are not allowed when 'baseUrl' is not set. Did you forget a leading './'?"),
            Option_preserveConstEnums_cannot_be_disabled_when_0_is_enabled: diag(5091, 1, "Option_preserveConstEnums_cannot_be_disabled_when_0_is_enabled_5091", "Option 'preserveConstEnums' cannot be disabled when '{0}' is enabled."),
            The_root_value_of_a_0_file_must_be_an_object: diag(5092, 1, "The_root_value_of_a_0_file_must_be_an_object_5092", "The root value of a '{0}' file must be an object."),
            Compiler_option_0_may_only_be_used_with_build: diag(5093, 1, "Compiler_option_0_may_only_be_used_with_build_5093", "Compiler option '--{0}' may only be used with '--build'."),
            Compiler_option_0_may_not_be_used_with_build: diag(5094, 1, "Compiler_option_0_may_not_be_used_with_build_5094", "Compiler option '--{0}' may not be used with '--build'."),
            Option_0_can_only_be_used_when_module_is_set_to_es2015_or_later: diag(5095, 1, "Option_0_can_only_be_used_when_module_is_set_to_es2015_or_later_5095", "Option '{0}' can only be used when 'module' is set to 'es2015' or later."),
            Option_allowImportingTsExtensions_can_only_be_used_when_either_noEmit_or_emitDeclarationOnly_is_set: diag(5096, 1, "Option_allowImportingTsExtensions_can_only_be_used_when_either_noEmit_or_emitDeclarationOnly_is_set_5096", "Option 'allowImportingTsExtensions' can only be used when either 'noEmit' or 'emitDeclarationOnly' is set."),
            An_import_path_can_only_end_with_a_0_extension_when_allowImportingTsExtensions_is_enabled: diag(5097, 1, "An_import_path_can_only_end_with_a_0_extension_when_allowImportingTsExtensions_is_enabled_5097", "An import path can only end with a '{0}' extension when 'allowImportingTsExtensions' is enabled."),
            Option_0_can_only_be_used_when_moduleResolution_is_set_to_node16_nodenext_or_bundler: diag(5098, 1, "Option_0_can_only_be_used_when_moduleResolution_is_set_to_node16_nodenext_or_bundler_5098", "Option '{0}' can only be used when 'moduleResolution' is set to 'node16', 'nodenext', or 'bundler'."),
            Option_0_is_deprecated_and_will_stop_functioning_in_TypeScript_1_Specify_compilerOption_ignoreDeprecations_Colon_2_to_silence_this_error: diag(5101, 1, "Option_0_is_deprecated_and_will_stop_functioning_in_TypeScript_1_Specify_compilerOption_ignoreDeprec_5101", `Option '{0}' is deprecated and will stop functioning in TypeScript {1}. Specify compilerOption '"ignoreDeprecations": "{2}"' to silence this error.`),
            Option_0_has_been_removed_Please_remove_it_from_your_configuration: diag(5102, 1, "Option_0_has_been_removed_Please_remove_it_from_your_configuration_5102", "Option '{0}' has been removed. Please remove it from your configuration."),
            Invalid_value_for_ignoreDeprecations: diag(5103, 1, "Invalid_value_for_ignoreDeprecations_5103", "Invalid value for '--ignoreDeprecations'."),
            Option_0_is_redundant_and_cannot_be_specified_with_option_1: diag(5104, 1, "Option_0_is_redundant_and_cannot_be_specified_with_option_1_5104", "Option '{0}' is redundant and cannot be specified with option '{1}'."),
            Option_verbatimModuleSyntax_cannot_be_used_when_module_is_set_to_UMD_AMD_or_System: diag(5105, 1, "Option_verbatimModuleSyntax_cannot_be_used_when_module_is_set_to_UMD_AMD_or_System_5105", "Option 'verbatimModuleSyntax' cannot be used when 'module' is set to 'UMD', 'AMD', or 'System'."),
            Use_0_instead: diag(5106, 3, "Use_0_instead_5106", "Use '{0}' instead."),
            Option_0_1_is_deprecated_and_will_stop_functioning_in_TypeScript_2_Specify_compilerOption_ignoreDeprecations_Colon_3_to_silence_this_error: diag(5107, 1, "Option_0_1_is_deprecated_and_will_stop_functioning_in_TypeScript_2_Specify_compilerOption_ignoreDepr_5107", `Option '{0}={1}' is deprecated and will stop functioning in TypeScript {2}. Specify compilerOption '"ignoreDeprecations": "{3}"' to silence this error.`),
            Option_0_1_has_been_removed_Please_remove_it_from_your_configuration: diag(5108, 1, "Option_0_1_has_been_removed_Please_remove_it_from_your_configuration_5108", "Option '{0}={1}' has been removed. Please remove it from your configuration."),
            Option_moduleResolution_must_be_set_to_0_or_left_unspecified_when_option_module_is_set_to_1: diag(5109, 1, "Option_moduleResolution_must_be_set_to_0_or_left_unspecified_when_option_module_is_set_to_1_5109", "Option 'moduleResolution' must be set to '{0}' (or left unspecified) when option 'module' is set to '{1}'."),
            Option_module_must_be_set_to_0_when_option_moduleResolution_is_set_to_1: diag(5110, 1, "Option_module_must_be_set_to_0_when_option_moduleResolution_is_set_to_1_5110", "Option 'module' must be set to '{0}' when option 'moduleResolution' is set to '{1}'."),
            Generates_a_sourcemap_for_each_corresponding_d_ts_file: diag(6e3, 3, "Generates_a_sourcemap_for_each_corresponding_d_ts_file_6000", "Generates a sourcemap for each corresponding '.d.ts' file."),
            Concatenate_and_emit_output_to_single_file: diag(6001, 3, "Concatenate_and_emit_output_to_single_file_6001", "Concatenate and emit output to single file."),
            Generates_corresponding_d_ts_file: diag(6002, 3, "Generates_corresponding_d_ts_file_6002", "Generates corresponding '.d.ts' file."),
            Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations: diag(6004, 3, "Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations_6004", "Specify the location where debugger should locate TypeScript files instead of source locations."),
            Watch_input_files: diag(6005, 3, "Watch_input_files_6005", "Watch input files."),
            Redirect_output_structure_to_the_directory: diag(6006, 3, "Redirect_output_structure_to_the_directory_6006", "Redirect output structure to the directory."),
            Do_not_erase_const_enum_declarations_in_generated_code: diag(6007, 3, "Do_not_erase_const_enum_declarations_in_generated_code_6007", "Do not erase const enum declarations in generated code."),
            Do_not_emit_outputs_if_any_errors_were_reported: diag(6008, 3, "Do_not_emit_outputs_if_any_errors_were_reported_6008", "Do not emit outputs if any errors were reported."),
            Do_not_emit_comments_to_output: diag(6009, 3, "Do_not_emit_comments_to_output_6009", "Do not emit comments to output."),
            Do_not_emit_outputs: diag(6010, 3, "Do_not_emit_outputs_6010", "Do not emit outputs."),
            Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typechecking: diag(6011, 3, "Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typech_6011", "Allow default imports from modules with no default export. This does not affect code emit, just typechecking."),
            Skip_type_checking_of_declaration_files: diag(6012, 3, "Skip_type_checking_of_declaration_files_6012", "Skip type checking of declaration files."),
            Do_not_resolve_the_real_path_of_symlinks: diag(6013, 3, "Do_not_resolve_the_real_path_of_symlinks_6013", "Do not resolve the real path of symlinks."),
            Only_emit_d_ts_declaration_files: diag(6014, 3, "Only_emit_d_ts_declaration_files_6014", "Only emit '.d.ts' declaration files."),
            Specify_ECMAScript_target_version: diag(6015, 3, "Specify_ECMAScript_target_version_6015", "Specify ECMAScript target version."),
            Specify_module_code_generation: diag(6016, 3, "Specify_module_code_generation_6016", "Specify module code generation."),
            Print_this_message: diag(6017, 3, "Print_this_message_6017", "Print this message."),
            Print_the_compiler_s_version: diag(6019, 3, "Print_the_compiler_s_version_6019", "Print the compiler's version."),
            Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json: diag(6020, 3, "Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json_6020", "Compile the project given the path to its configuration file, or to a folder with a 'tsconfig.json'."),
            Syntax_Colon_0: diag(6023, 3, "Syntax_Colon_0_6023", "Syntax: {0}"),
            options: diag(6024, 3, "options_6024", "options"),
            file: diag(6025, 3, "file_6025", "file"),
            Examples_Colon_0: diag(6026, 3, "Examples_Colon_0_6026", "Examples: {0}"),
            Options_Colon: diag(6027, 3, "Options_Colon_6027", "Options:"),
            Version_0: diag(6029, 3, "Version_0_6029", "Version {0}"),
            Insert_command_line_options_and_files_from_a_file: diag(6030, 3, "Insert_command_line_options_and_files_from_a_file_6030", "Insert command line options and files from a file."),
            Starting_compilation_in_watch_mode: diag(6031, 3, "Starting_compilation_in_watch_mode_6031", "Starting compilation in watch mode..."),
            File_change_detected_Starting_incremental_compilation: diag(6032, 3, "File_change_detected_Starting_incremental_compilation_6032", "File change detected. Starting incremental compilation..."),
            KIND: diag(6034, 3, "KIND_6034", "KIND"),
            FILE: diag(6035, 3, "FILE_6035", "FILE"),
            VERSION: diag(6036, 3, "VERSION_6036", "VERSION"),
            LOCATION: diag(6037, 3, "LOCATION_6037", "LOCATION"),
            DIRECTORY: diag(6038, 3, "DIRECTORY_6038", "DIRECTORY"),
            STRATEGY: diag(6039, 3, "STRATEGY_6039", "STRATEGY"),
            FILE_OR_DIRECTORY: diag(6040, 3, "FILE_OR_DIRECTORY_6040", "FILE OR DIRECTORY"),
            Errors_Files: diag(6041, 3, "Errors_Files_6041", "Errors  Files"),
            Generates_corresponding_map_file: diag(6043, 3, "Generates_corresponding_map_file_6043", "Generates corresponding '.map' file."),
            Compiler_option_0_expects_an_argument: diag(6044, 1, "Compiler_option_0_expects_an_argument_6044", "Compiler option '{0}' expects an argument."),
            Unterminated_quoted_string_in_response_file_0: diag(6045, 1, "Unterminated_quoted_string_in_response_file_0_6045", "Unterminated quoted string in response file '{0}'."),
            Argument_for_0_option_must_be_Colon_1: diag(6046, 1, "Argument_for_0_option_must_be_Colon_1_6046", "Argument for '{0}' option must be: {1}."),
            Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1: diag(6048, 1, "Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1_6048", "Locale must be of the form <language> or <language>-<territory>. For example '{0}' or '{1}'."),
            Unable_to_open_file_0: diag(6050, 1, "Unable_to_open_file_0_6050", "Unable to open file '{0}'."),
            Corrupted_locale_file_0: diag(6051, 1, "Corrupted_locale_file_0_6051", "Corrupted locale file {0}."),
            Raise_error_on_expressions_and_declarations_with_an_implied_any_type: diag(6052, 3, "Raise_error_on_expressions_and_declarations_with_an_implied_any_type_6052", "Raise error on expressions and declarations with an implied 'any' type."),
            File_0_not_found: diag(6053, 1, "File_0_not_found_6053", "File '{0}' not found."),
            File_0_has_an_unsupported_extension_The_only_supported_extensions_are_1: diag(6054, 1, "File_0_has_an_unsupported_extension_The_only_supported_extensions_are_1_6054", "File '{0}' has an unsupported extension. The only supported extensions are {1}."),
            Suppress_noImplicitAny_errors_for_indexing_objects_lacking_index_signatures: diag(6055, 3, "Suppress_noImplicitAny_errors_for_indexing_objects_lacking_index_signatures_6055", "Suppress noImplicitAny errors for indexing objects lacking index signatures."),
            Do_not_emit_declarations_for_code_that_has_an_internal_annotation: diag(6056, 3, "Do_not_emit_declarations_for_code_that_has_an_internal_annotation_6056", "Do not emit declarations for code that has an '@internal' annotation."),
            Specify_the_root_directory_of_input_files_Use_to_control_the_output_directory_structure_with_outDir: diag(6058, 3, "Specify_the_root_directory_of_input_files_Use_to_control_the_output_directory_structure_with_outDir_6058", "Specify the root directory of input files. Use to control the output directory structure with --outDir."),
            File_0_is_not_under_rootDir_1_rootDir_is_expected_to_contain_all_source_files: diag(6059, 1, "File_0_is_not_under_rootDir_1_rootDir_is_expected_to_contain_all_source_files_6059", "File '{0}' is not under 'rootDir' '{1}'. 'rootDir' is expected to contain all source files."),
            Specify_the_end_of_line_sequence_to_be_used_when_emitting_files_Colon_CRLF_dos_or_LF_unix: diag(6060, 3, "Specify_the_end_of_line_sequence_to_be_used_when_emitting_files_Colon_CRLF_dos_or_LF_unix_6060", "Specify the end of line sequence to be used when emitting files: 'CRLF' (dos) or 'LF' (unix)."),
            NEWLINE: diag(6061, 3, "NEWLINE_6061", "NEWLINE"),
            Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_null_on_command_line: diag(6064, 1, "Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_null_on_command_line_6064", "Option '{0}' can only be specified in 'tsconfig.json' file or set to 'null' on command line."),
            Enables_experimental_support_for_ES7_decorators: diag(6065, 3, "Enables_experimental_support_for_ES7_decorators_6065", "Enables experimental support for ES7 decorators."),
            Enables_experimental_support_for_emitting_type_metadata_for_decorators: diag(6066, 3, "Enables_experimental_support_for_emitting_type_metadata_for_decorators_6066", "Enables experimental support for emitting type metadata for decorators."),
            Initializes_a_TypeScript_project_and_creates_a_tsconfig_json_file: diag(6070, 3, "Initializes_a_TypeScript_project_and_creates_a_tsconfig_json_file_6070", "Initializes a TypeScript project and creates a tsconfig.json file."),
            Successfully_created_a_tsconfig_json_file: diag(6071, 3, "Successfully_created_a_tsconfig_json_file_6071", "Successfully created a tsconfig.json file."),
            Suppress_excess_property_checks_for_object_literals: diag(6072, 3, "Suppress_excess_property_checks_for_object_literals_6072", "Suppress excess property checks for object literals."),
            Stylize_errors_and_messages_using_color_and_context_experimental: diag(6073, 3, "Stylize_errors_and_messages_using_color_and_context_experimental_6073", "Stylize errors and messages using color and context (experimental)."),
            Do_not_report_errors_on_unused_labels: diag(6074, 3, "Do_not_report_errors_on_unused_labels_6074", "Do not report errors on unused labels."),
            Report_error_when_not_all_code_paths_in_function_return_a_value: diag(6075, 3, "Report_error_when_not_all_code_paths_in_function_return_a_value_6075", "Report error when not all code paths in function return a value."),
            Report_errors_for_fallthrough_cases_in_switch_statement: diag(6076, 3, "Report_errors_for_fallthrough_cases_in_switch_statement_6076", "Report errors for fallthrough cases in switch statement."),
            Do_not_report_errors_on_unreachable_code: diag(6077, 3, "Do_not_report_errors_on_unreachable_code_6077", "Do not report errors on unreachable code."),
            Disallow_inconsistently_cased_references_to_the_same_file: diag(6078, 3, "Disallow_inconsistently_cased_references_to_the_same_file_6078", "Disallow inconsistently-cased references to the same file."),
            Specify_library_files_to_be_included_in_the_compilation: diag(6079, 3, "Specify_library_files_to_be_included_in_the_compilation_6079", "Specify library files to be included in the compilation."),
            Specify_JSX_code_generation: diag(6080, 3, "Specify_JSX_code_generation_6080", "Specify JSX code generation."),
            File_0_has_an_unsupported_extension_so_skipping_it: diag(6081, 3, "File_0_has_an_unsupported_extension_so_skipping_it_6081", "File '{0}' has an unsupported extension, so skipping it."),
            Only_amd_and_system_modules_are_supported_alongside_0: diag(6082, 1, "Only_amd_and_system_modules_are_supported_alongside_0_6082", "Only 'amd' and 'system' modules are supported alongside --{0}."),
            Base_directory_to_resolve_non_absolute_module_names: diag(6083, 3, "Base_directory_to_resolve_non_absolute_module_names_6083", "Base directory to resolve non-absolute module names."),
            Deprecated_Use_jsxFactory_instead_Specify_the_object_invoked_for_createElement_when_targeting_react_JSX_emit: diag(6084, 3, "Deprecated_Use_jsxFactory_instead_Specify_the_object_invoked_for_createElement_when_targeting_react__6084", "[Deprecated] Use '--jsxFactory' instead. Specify the object invoked for createElement when targeting 'react' JSX emit"),
            Enable_tracing_of_the_name_resolution_process: diag(6085, 3, "Enable_tracing_of_the_name_resolution_process_6085", "Enable tracing of the name resolution process."),
            Resolving_module_0_from_1: diag(6086, 3, "Resolving_module_0_from_1_6086", "======== Resolving module '{0}' from '{1}'. ========"),
            Explicitly_specified_module_resolution_kind_Colon_0: diag(6087, 3, "Explicitly_specified_module_resolution_kind_Colon_0_6087", "Explicitly specified module resolution kind: '{0}'."),
            Module_resolution_kind_is_not_specified_using_0: diag(6088, 3, "Module_resolution_kind_is_not_specified_using_0_6088", "Module resolution kind is not specified, using '{0}'."),
            Module_name_0_was_successfully_resolved_to_1: diag(6089, 3, "Module_name_0_was_successfully_resolved_to_1_6089", "======== Module name '{0}' was successfully resolved to '{1}'. ========"),
            Module_name_0_was_not_resolved: diag(6090, 3, "Module_name_0_was_not_resolved_6090", "======== Module name '{0}' was not resolved. ========"),
            paths_option_is_specified_looking_for_a_pattern_to_match_module_name_0: diag(6091, 3, "paths_option_is_specified_looking_for_a_pattern_to_match_module_name_0_6091", "'paths' option is specified, looking for a pattern to match module name '{0}'."),
            Module_name_0_matched_pattern_1: diag(6092, 3, "Module_name_0_matched_pattern_1_6092", "Module name '{0}', matched pattern '{1}'."),
            Trying_substitution_0_candidate_module_location_Colon_1: diag(6093, 3, "Trying_substitution_0_candidate_module_location_Colon_1_6093", "Trying substitution '{0}', candidate module location: '{1}'."),
            Resolving_module_name_0_relative_to_base_url_1_2: diag(6094, 3, "Resolving_module_name_0_relative_to_base_url_1_2_6094", "Resolving module name '{0}' relative to base url '{1}' - '{2}'."),
            Loading_module_as_file_Slash_folder_candidate_module_location_0_target_file_types_Colon_1: diag(6095, 3, "Loading_module_as_file_Slash_folder_candidate_module_location_0_target_file_types_Colon_1_6095", "Loading module as file / folder, candidate module location '{0}', target file types: {1}."),
            File_0_does_not_exist: diag(6096, 3, "File_0_does_not_exist_6096", "File '{0}' does not exist."),
            File_0_exists_use_it_as_a_name_resolution_result: diag(6097, 3, "File_0_exists_use_it_as_a_name_resolution_result_6097", "File '{0}' exists - use it as a name resolution result."),
            Loading_module_0_from_node_modules_folder_target_file_types_Colon_1: diag(6098, 3, "Loading_module_0_from_node_modules_folder_target_file_types_Colon_1_6098", "Loading module '{0}' from 'node_modules' folder, target file types: {1}."),
            Found_package_json_at_0: diag(6099, 3, "Found_package_json_at_0_6099", "Found 'package.json' at '{0}'."),
            package_json_does_not_have_a_0_field: diag(6100, 3, "package_json_does_not_have_a_0_field_6100", "'package.json' does not have a '{0}' field."),
            package_json_has_0_field_1_that_references_2: diag(6101, 3, "package_json_has_0_field_1_that_references_2_6101", "'package.json' has '{0}' field '{1}' that references '{2}'."),
            Allow_javascript_files_to_be_compiled: diag(6102, 3, "Allow_javascript_files_to_be_compiled_6102", "Allow javascript files to be compiled."),
            Checking_if_0_is_the_longest_matching_prefix_for_1_2: diag(6104, 3, "Checking_if_0_is_the_longest_matching_prefix_for_1_2_6104", "Checking if '{0}' is the longest matching prefix for '{1}' - '{2}'."),
            Expected_type_of_0_field_in_package_json_to_be_1_got_2: diag(6105, 3, "Expected_type_of_0_field_in_package_json_to_be_1_got_2_6105", "Expected type of '{0}' field in 'package.json' to be '{1}', got '{2}'."),
            baseUrl_option_is_set_to_0_using_this_value_to_resolve_non_relative_module_name_1: diag(6106, 3, "baseUrl_option_is_set_to_0_using_this_value_to_resolve_non_relative_module_name_1_6106", "'baseUrl' option is set to '{0}', using this value to resolve non-relative module name '{1}'."),
            rootDirs_option_is_set_using_it_to_resolve_relative_module_name_0: diag(6107, 3, "rootDirs_option_is_set_using_it_to_resolve_relative_module_name_0_6107", "'rootDirs' option is set, using it to resolve relative module name '{0}'."),
            Longest_matching_prefix_for_0_is_1: diag(6108, 3, "Longest_matching_prefix_for_0_is_1_6108", "Longest matching prefix for '{0}' is '{1}'."),
            Loading_0_from_the_root_dir_1_candidate_location_2: diag(6109, 3, "Loading_0_from_the_root_dir_1_candidate_location_2_6109", "Loading '{0}' from the root dir '{1}', candidate location '{2}'."),
            Trying_other_entries_in_rootDirs: diag(6110, 3, "Trying_other_entries_in_rootDirs_6110", "Trying other entries in 'rootDirs'."),
            Module_resolution_using_rootDirs_has_failed: diag(6111, 3, "Module_resolution_using_rootDirs_has_failed_6111", "Module resolution using 'rootDirs' has failed."),
            Do_not_emit_use_strict_directives_in_module_output: diag(6112, 3, "Do_not_emit_use_strict_directives_in_module_output_6112", "Do not emit 'use strict' directives in module output."),
            Enable_strict_null_checks: diag(6113, 3, "Enable_strict_null_checks_6113", "Enable strict null checks."),
            Unknown_option_excludes_Did_you_mean_exclude: diag(6114, 1, "Unknown_option_excludes_Did_you_mean_exclude_6114", "Unknown option 'excludes'. Did you mean 'exclude'?"),
            Raise_error_on_this_expressions_with_an_implied_any_type: diag(6115, 3, "Raise_error_on_this_expressions_with_an_implied_any_type_6115", "Raise error on 'this' expressions with an implied 'any' type."),
            Resolving_type_reference_directive_0_containing_file_1_root_directory_2: diag(6116, 3, "Resolving_type_reference_directive_0_containing_file_1_root_directory_2_6116", "======== Resolving type reference directive '{0}', containing file '{1}', root directory '{2}'. ========"),
            Type_reference_directive_0_was_successfully_resolved_to_1_primary_Colon_2: diag(6119, 3, "Type_reference_directive_0_was_successfully_resolved_to_1_primary_Colon_2_6119", "======== Type reference directive '{0}' was successfully resolved to '{1}', primary: {2}. ========"),
            Type_reference_directive_0_was_not_resolved: diag(6120, 3, "Type_reference_directive_0_was_not_resolved_6120", "======== Type reference directive '{0}' was not resolved. ========"),
            Resolving_with_primary_search_path_0: diag(6121, 3, "Resolving_with_primary_search_path_0_6121", "Resolving with primary search path '{0}'."),
            Root_directory_cannot_be_determined_skipping_primary_search_paths: diag(6122, 3, "Root_directory_cannot_be_determined_skipping_primary_search_paths_6122", "Root directory cannot be determined, skipping primary search paths."),
            Resolving_type_reference_directive_0_containing_file_1_root_directory_not_set: diag(6123, 3, "Resolving_type_reference_directive_0_containing_file_1_root_directory_not_set_6123", "======== Resolving type reference directive '{0}', containing file '{1}', root directory not set. ========"),
            Type_declaration_files_to_be_included_in_compilation: diag(6124, 3, "Type_declaration_files_to_be_included_in_compilation_6124", "Type declaration files to be included in compilation."),
            Looking_up_in_node_modules_folder_initial_location_0: diag(6125, 3, "Looking_up_in_node_modules_folder_initial_location_0_6125", "Looking up in 'node_modules' folder, initial location '{0}'."),
            Containing_file_is_not_specified_and_root_directory_cannot_be_determined_skipping_lookup_in_node_modules_folder: diag(6126, 3, "Containing_file_is_not_specified_and_root_directory_cannot_be_determined_skipping_lookup_in_node_mod_6126", "Containing file is not specified and root directory cannot be determined, skipping lookup in 'node_modules' folder."),
            Resolving_type_reference_directive_0_containing_file_not_set_root_directory_1: diag(6127, 3, "Resolving_type_reference_directive_0_containing_file_not_set_root_directory_1_6127", "======== Resolving type reference directive '{0}', containing file not set, root directory '{1}'. ========"),
            Resolving_type_reference_directive_0_containing_file_not_set_root_directory_not_set: diag(6128, 3, "Resolving_type_reference_directive_0_containing_file_not_set_root_directory_not_set_6128", "======== Resolving type reference directive '{0}', containing file not set, root directory not set. ========"),
            Resolving_real_path_for_0_result_1: diag(6130, 3, "Resolving_real_path_for_0_result_1_6130", "Resolving real path for '{0}', result '{1}'."),
            Cannot_compile_modules_using_option_0_unless_the_module_flag_is_amd_or_system: diag(6131, 1, "Cannot_compile_modules_using_option_0_unless_the_module_flag_is_amd_or_system_6131", "Cannot compile modules using option '{0}' unless the '--module' flag is 'amd' or 'system'."),
            File_name_0_has_a_1_extension_stripping_it: diag(6132, 3, "File_name_0_has_a_1_extension_stripping_it_6132", "File name '{0}' has a '{1}' extension - stripping it."),
            _0_is_declared_but_its_value_is_never_read: diag(
              6133,
              1,
              "_0_is_declared_but_its_value_is_never_read_6133",
              "'{0}' is declared but its value is never read.",
              /*reportsUnnecessary*/
              true
            ),
            Report_errors_on_unused_locals: diag(6134, 3, "Report_errors_on_unused_locals_6134", "Report errors on unused locals."),
            Report_errors_on_unused_parameters: diag(6135, 3, "Report_errors_on_unused_parameters_6135", "Report errors on unused parameters."),
            The_maximum_dependency_depth_to_search_under_node_modules_and_load_JavaScript_files: diag(6136, 3, "The_maximum_dependency_depth_to_search_under_node_modules_and_load_JavaScript_files_6136", "The maximum dependency depth to search under node_modules and load JavaScript files."),
            Cannot_import_type_declaration_files_Consider_importing_0_instead_of_1: diag(6137, 1, "Cannot_import_type_declaration_files_Consider_importing_0_instead_of_1_6137", "Cannot import type declaration files. Consider importing '{0}' instead of '{1}'."),
            Property_0_is_declared_but_its_value_is_never_read: diag(
              6138,
              1,
              "Property_0_is_declared_but_its_value_is_never_read_6138",
              "Property '{0}' is declared but its value is never read.",
              /*reportsUnnecessary*/
              true
            ),
            Import_emit_helpers_from_tslib: diag(6139, 3, "Import_emit_helpers_from_tslib_6139", "Import emit helpers from 'tslib'."),
            Auto_discovery_for_typings_is_enabled_in_project_0_Running_extra_resolution_pass_for_module_1_using_cache_location_2: diag(6140, 1, "Auto_discovery_for_typings_is_enabled_in_project_0_Running_extra_resolution_pass_for_module_1_using__6140", "Auto discovery for typings is enabled in project '{0}'. Running extra resolution pass for module '{1}' using cache location '{2}'."),
            Parse_in_strict_mode_and_emit_use_strict_for_each_source_file: diag(6141, 3, "Parse_in_strict_mode_and_emit_use_strict_for_each_source_file_6141", 'Parse in strict mode and emit "use strict" for each source file.'),
            Module_0_was_resolved_to_1_but_jsx_is_not_set: diag(6142, 1, "Module_0_was_resolved_to_1_but_jsx_is_not_set_6142", "Module '{0}' was resolved to '{1}', but '--jsx' is not set."),
            Module_0_was_resolved_as_locally_declared_ambient_module_in_file_1: diag(6144, 3, "Module_0_was_resolved_as_locally_declared_ambient_module_in_file_1_6144", "Module '{0}' was resolved as locally declared ambient module in file '{1}'."),
            Module_0_was_resolved_as_ambient_module_declared_in_1_since_this_file_was_not_modified: diag(6145, 3, "Module_0_was_resolved_as_ambient_module_declared_in_1_since_this_file_was_not_modified_6145", "Module '{0}' was resolved as ambient module declared in '{1}' since this file was not modified."),
            Specify_the_JSX_factory_function_to_use_when_targeting_react_JSX_emit_e_g_React_createElement_or_h: diag(6146, 3, "Specify_the_JSX_factory_function_to_use_when_targeting_react_JSX_emit_e_g_React_createElement_or_h_6146", "Specify the JSX factory function to use when targeting 'react' JSX emit, e.g. 'React.createElement' or 'h'."),
            Resolution_for_module_0_was_found_in_cache_from_location_1: diag(6147, 3, "Resolution_for_module_0_was_found_in_cache_from_location_1_6147", "Resolution for module '{0}' was found in cache from location '{1}'."),
            Directory_0_does_not_exist_skipping_all_lookups_in_it: diag(6148, 3, "Directory_0_does_not_exist_skipping_all_lookups_in_it_6148", "Directory '{0}' does not exist, skipping all lookups in it."),
            Show_diagnostic_information: diag(6149, 3, "Show_diagnostic_information_6149", "Show diagnostic information."),
            Show_verbose_diagnostic_information: diag(6150, 3, "Show_verbose_diagnostic_information_6150", "Show verbose diagnostic information."),
            Emit_a_single_file_with_source_maps_instead_of_having_a_separate_file: diag(6151, 3, "Emit_a_single_file_with_source_maps_instead_of_having_a_separate_file_6151", "Emit a single file with source maps instead of having a separate file."),
            Emit_the_source_alongside_the_sourcemaps_within_a_single_file_requires_inlineSourceMap_or_sourceMap_to_be_set: diag(6152, 3, "Emit_the_source_alongside_the_sourcemaps_within_a_single_file_requires_inlineSourceMap_or_sourceMap__6152", "Emit the source alongside the sourcemaps within a single file; requires '--inlineSourceMap' or '--sourceMap' to be set."),
            Transpile_each_file_as_a_separate_module_similar_to_ts_transpileModule: diag(6153, 3, "Transpile_each_file_as_a_separate_module_similar_to_ts_transpileModule_6153", "Transpile each file as a separate module (similar to 'ts.transpileModule')."),
            Print_names_of_generated_files_part_of_the_compilation: diag(6154, 3, "Print_names_of_generated_files_part_of_the_compilation_6154", "Print names of generated files part of the compilation."),
            Print_names_of_files_part_of_the_compilation: diag(6155, 3, "Print_names_of_files_part_of_the_compilation_6155", "Print names of files part of the compilation."),
            The_locale_used_when_displaying_messages_to_the_user_e_g_en_us: diag(6156, 3, "The_locale_used_when_displaying_messages_to_the_user_e_g_en_us_6156", "The locale used when displaying messages to the user (e.g. 'en-us')"),
            Do_not_generate_custom_helper_functions_like_extends_in_compiled_output: diag(6157, 3, "Do_not_generate_custom_helper_functions_like_extends_in_compiled_output_6157", "Do not generate custom helper functions like '__extends' in compiled output."),
            Do_not_include_the_default_library_file_lib_d_ts: diag(6158, 3, "Do_not_include_the_default_library_file_lib_d_ts_6158", "Do not include the default library file (lib.d.ts)."),
            Do_not_add_triple_slash_references_or_imported_modules_to_the_list_of_compiled_files: diag(6159, 3, "Do_not_add_triple_slash_references_or_imported_modules_to_the_list_of_compiled_files_6159", "Do not add triple-slash references or imported modules to the list of compiled files."),
            Deprecated_Use_skipLibCheck_instead_Skip_type_checking_of_default_library_declaration_files: diag(6160, 3, "Deprecated_Use_skipLibCheck_instead_Skip_type_checking_of_default_library_declaration_files_6160", "[Deprecated] Use '--skipLibCheck' instead. Skip type checking of default library declaration files."),
            List_of_folders_to_include_type_definitions_from: diag(6161, 3, "List_of_folders_to_include_type_definitions_from_6161", "List of folders to include type definitions from."),
            Disable_size_limitations_on_JavaScript_projects: diag(6162, 3, "Disable_size_limitations_on_JavaScript_projects_6162", "Disable size limitations on JavaScript projects."),
            The_character_set_of_the_input_files: diag(6163, 3, "The_character_set_of_the_input_files_6163", "The character set of the input files."),
            Skipping_module_0_that_looks_like_an_absolute_URI_target_file_types_Colon_1: diag(6164, 3, "Skipping_module_0_that_looks_like_an_absolute_URI_target_file_types_Colon_1_6164", "Skipping module '{0}' that looks like an absolute URI, target file types: {1}."),
            Do_not_truncate_error_messages: diag(6165, 3, "Do_not_truncate_error_messages_6165", "Do not truncate error messages."),
            Output_directory_for_generated_declaration_files: diag(6166, 3, "Output_directory_for_generated_declaration_files_6166", "Output directory for generated declaration files."),
            A_series_of_entries_which_re_map_imports_to_lookup_locations_relative_to_the_baseUrl: diag(6167, 3, "A_series_of_entries_which_re_map_imports_to_lookup_locations_relative_to_the_baseUrl_6167", "A series of entries which re-map imports to lookup locations relative to the 'baseUrl'."),
            List_of_root_folders_whose_combined_content_represents_the_structure_of_the_project_at_runtime: diag(6168, 3, "List_of_root_folders_whose_combined_content_represents_the_structure_of_the_project_at_runtime_6168", "List of root folders whose combined content represents the structure of the project at runtime."),
            Show_all_compiler_options: diag(6169, 3, "Show_all_compiler_options_6169", "Show all compiler options."),
            Deprecated_Use_outFile_instead_Concatenate_and_emit_output_to_single_file: diag(6170, 3, "Deprecated_Use_outFile_instead_Concatenate_and_emit_output_to_single_file_6170", "[Deprecated] Use '--outFile' instead. Concatenate and emit output to single file"),
            Command_line_Options: diag(6171, 3, "Command_line_Options_6171", "Command-line Options"),
            Provide_full_support_for_iterables_in_for_of_spread_and_destructuring_when_targeting_ES5_or_ES3: diag(6179, 3, "Provide_full_support_for_iterables_in_for_of_spread_and_destructuring_when_targeting_ES5_or_ES3_6179", "Provide full support for iterables in 'for-of', spread, and destructuring when targeting 'ES5' or 'ES3'."),
            Enable_all_strict_type_checking_options: diag(6180, 3, "Enable_all_strict_type_checking_options_6180", "Enable all strict type-checking options."),
            Scoped_package_detected_looking_in_0: diag(6182, 3, "Scoped_package_detected_looking_in_0_6182", "Scoped package detected, looking in '{0}'"),
            Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2: diag(6183, 3, "Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2_6183", "Reusing resolution of module '{0}' from '{1}' of old program, it was successfully resolved to '{2}'."),
            Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2_with_Package_ID_3: diag(6184, 3, "Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2_with_Package__6184", "Reusing resolution of module '{0}' from '{1}' of old program, it was successfully resolved to '{2}' with Package ID '{3}'."),
            Enable_strict_checking_of_function_types: diag(6186, 3, "Enable_strict_checking_of_function_types_6186", "Enable strict checking of function types."),
            Enable_strict_checking_of_property_initialization_in_classes: diag(6187, 3, "Enable_strict_checking_of_property_initialization_in_classes_6187", "Enable strict checking of property initialization in classes."),
            Numeric_separators_are_not_allowed_here: diag(6188, 1, "Numeric_separators_are_not_allowed_here_6188", "Numeric separators are not allowed here."),
            Multiple_consecutive_numeric_separators_are_not_permitted: diag(6189, 1, "Multiple_consecutive_numeric_separators_are_not_permitted_6189", "Multiple consecutive numeric separators are not permitted."),
            Whether_to_keep_outdated_console_output_in_watch_mode_instead_of_clearing_the_screen: diag(6191, 3, "Whether_to_keep_outdated_console_output_in_watch_mode_instead_of_clearing_the_screen_6191", "Whether to keep outdated console output in watch mode instead of clearing the screen."),
            All_imports_in_import_declaration_are_unused: diag(
              6192,
              1,
              "All_imports_in_import_declaration_are_unused_6192",
              "All imports in import declaration are unused.",
              /*reportsUnnecessary*/
              true
            ),
            Found_1_error_Watching_for_file_changes: diag(6193, 3, "Found_1_error_Watching_for_file_changes_6193", "Found 1 error. Watching for file changes."),
            Found_0_errors_Watching_for_file_changes: diag(6194, 3, "Found_0_errors_Watching_for_file_changes_6194", "Found {0} errors. Watching for file changes."),
            Resolve_keyof_to_string_valued_property_names_only_no_numbers_or_symbols: diag(6195, 3, "Resolve_keyof_to_string_valued_property_names_only_no_numbers_or_symbols_6195", "Resolve 'keyof' to string valued property names only (no numbers or symbols)."),
            _0_is_declared_but_never_used: diag(
              6196,
              1,
              "_0_is_declared_but_never_used_6196",
              "'{0}' is declared but never used.",
              /*reportsUnnecessary*/
              true
            ),
            Include_modules_imported_with_json_extension: diag(6197, 3, "Include_modules_imported_with_json_extension_6197", "Include modules imported with '.json' extension"),
            All_destructured_elements_are_unused: diag(
              6198,
              1,
              "All_destructured_elements_are_unused_6198",
              "All destructured elements are unused.",
              /*reportsUnnecessary*/
              true
            ),
            All_variables_are_unused: diag(
              6199,
              1,
              "All_variables_are_unused_6199",
              "All variables are unused.",
              /*reportsUnnecessary*/
              true
            ),
            Definitions_of_the_following_identifiers_conflict_with_those_in_another_file_Colon_0: diag(6200, 1, "Definitions_of_the_following_identifiers_conflict_with_those_in_another_file_Colon_0_6200", "Definitions of the following identifiers conflict with those in another file: {0}"),
            Conflicts_are_in_this_file: diag(6201, 3, "Conflicts_are_in_this_file_6201", "Conflicts are in this file."),
            Project_references_may_not_form_a_circular_graph_Cycle_detected_Colon_0: diag(6202, 1, "Project_references_may_not_form_a_circular_graph_Cycle_detected_Colon_0_6202", "Project references may not form a circular graph. Cycle detected: {0}"),
            _0_was_also_declared_here: diag(6203, 3, "_0_was_also_declared_here_6203", "'{0}' was also declared here."),
            and_here: diag(6204, 3, "and_here_6204", "and here."),
            All_type_parameters_are_unused: diag(6205, 1, "All_type_parameters_are_unused_6205", "All type parameters are unused."),
            package_json_has_a_typesVersions_field_with_version_specific_path_mappings: diag(6206, 3, "package_json_has_a_typesVersions_field_with_version_specific_path_mappings_6206", "'package.json' has a 'typesVersions' field with version-specific path mappings."),
            package_json_does_not_have_a_typesVersions_entry_that_matches_version_0: diag(6207, 3, "package_json_does_not_have_a_typesVersions_entry_that_matches_version_0_6207", "'package.json' does not have a 'typesVersions' entry that matches version '{0}'."),
            package_json_has_a_typesVersions_entry_0_that_matches_compiler_version_1_looking_for_a_pattern_to_match_module_name_2: diag(6208, 3, "package_json_has_a_typesVersions_entry_0_that_matches_compiler_version_1_looking_for_a_pattern_to_ma_6208", "'package.json' has a 'typesVersions' entry '{0}' that matches compiler version '{1}', looking for a pattern to match module name '{2}'."),
            package_json_has_a_typesVersions_entry_0_that_is_not_a_valid_semver_range: diag(6209, 3, "package_json_has_a_typesVersions_entry_0_that_is_not_a_valid_semver_range_6209", "'package.json' has a 'typesVersions' entry '{0}' that is not a valid semver range."),
            An_argument_for_0_was_not_provided: diag(6210, 3, "An_argument_for_0_was_not_provided_6210", "An argument for '{0}' was not provided."),
            An_argument_matching_this_binding_pattern_was_not_provided: diag(6211, 3, "An_argument_matching_this_binding_pattern_was_not_provided_6211", "An argument matching this binding pattern was not provided."),
            Did_you_mean_to_call_this_expression: diag(6212, 3, "Did_you_mean_to_call_this_expression_6212", "Did you mean to call this expression?"),
            Did_you_mean_to_use_new_with_this_expression: diag(6213, 3, "Did_you_mean_to_use_new_with_this_expression_6213", "Did you mean to use 'new' with this expression?"),
            Enable_strict_bind_call_and_apply_methods_on_functions: diag(6214, 3, "Enable_strict_bind_call_and_apply_methods_on_functions_6214", "Enable strict 'bind', 'call', and 'apply' methods on functions."),
            Using_compiler_options_of_project_reference_redirect_0: diag(6215, 3, "Using_compiler_options_of_project_reference_redirect_0_6215", "Using compiler options of project reference redirect '{0}'."),
            Found_1_error: diag(6216, 3, "Found_1_error_6216", "Found 1 error."),
            Found_0_errors: diag(6217, 3, "Found_0_errors_6217", "Found {0} errors."),
            Module_name_0_was_successfully_resolved_to_1_with_Package_ID_2: diag(6218, 3, "Module_name_0_was_successfully_resolved_to_1_with_Package_ID_2_6218", "======== Module name '{0}' was successfully resolved to '{1}' with Package ID '{2}'. ========"),
            Type_reference_directive_0_was_successfully_resolved_to_1_with_Package_ID_2_primary_Colon_3: diag(6219, 3, "Type_reference_directive_0_was_successfully_resolved_to_1_with_Package_ID_2_primary_Colon_3_6219", "======== Type reference directive '{0}' was successfully resolved to '{1}' with Package ID '{2}', primary: {3}. ========"),
            package_json_had_a_falsy_0_field: diag(6220, 3, "package_json_had_a_falsy_0_field_6220", "'package.json' had a falsy '{0}' field."),
            Disable_use_of_source_files_instead_of_declaration_files_from_referenced_projects: diag(6221, 3, "Disable_use_of_source_files_instead_of_declaration_files_from_referenced_projects_6221", "Disable use of source files instead of declaration files from referenced projects."),
            Emit_class_fields_with_Define_instead_of_Set: diag(6222, 3, "Emit_class_fields_with_Define_instead_of_Set_6222", "Emit class fields with Define instead of Set."),
            Generates_a_CPU_profile: diag(6223, 3, "Generates_a_CPU_profile_6223", "Generates a CPU profile."),
            Disable_solution_searching_for_this_project: diag(6224, 3, "Disable_solution_searching_for_this_project_6224", "Disable solution searching for this project."),
            Specify_strategy_for_watching_file_Colon_FixedPollingInterval_default_PriorityPollingInterval_DynamicPriorityPolling_FixedChunkSizePolling_UseFsEvents_UseFsEventsOnParentDirectory: diag(6225, 3, "Specify_strategy_for_watching_file_Colon_FixedPollingInterval_default_PriorityPollingInterval_Dynami_6225", "Specify strategy for watching file: 'FixedPollingInterval' (default), 'PriorityPollingInterval', 'DynamicPriorityPolling', 'FixedChunkSizePolling', 'UseFsEvents', 'UseFsEventsOnParentDirectory'."),
            Specify_strategy_for_watching_directory_on_platforms_that_don_t_support_recursive_watching_natively_Colon_UseFsEvents_default_FixedPollingInterval_DynamicPriorityPolling_FixedChunkSizePolling: diag(6226, 3, "Specify_strategy_for_watching_directory_on_platforms_that_don_t_support_recursive_watching_natively__6226", "Specify strategy for watching directory on platforms that don't support recursive watching natively: 'UseFsEvents' (default), 'FixedPollingInterval', 'DynamicPriorityPolling', 'FixedChunkSizePolling'."),
            Specify_strategy_for_creating_a_polling_watch_when_it_fails_to_create_using_file_system_events_Colon_FixedInterval_default_PriorityInterval_DynamicPriority_FixedChunkSize: diag(6227, 3, "Specify_strategy_for_creating_a_polling_watch_when_it_fails_to_create_using_file_system_events_Colon_6227", "Specify strategy for creating a polling watch when it fails to create using file system events: 'FixedInterval' (default), 'PriorityInterval', 'DynamicPriority', 'FixedChunkSize'."),
            Tag_0_expects_at_least_1_arguments_but_the_JSX_factory_2_provides_at_most_3: diag(6229, 1, "Tag_0_expects_at_least_1_arguments_but_the_JSX_factory_2_provides_at_most_3_6229", "Tag '{0}' expects at least '{1}' arguments, but the JSX factory '{2}' provides at most '{3}'."),
            Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_false_or_null_on_command_line: diag(6230, 1, "Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_false_or_null_on_command_line_6230", "Option '{0}' can only be specified in 'tsconfig.json' file or set to 'false' or 'null' on command line."),
            Could_not_resolve_the_path_0_with_the_extensions_Colon_1: diag(6231, 1, "Could_not_resolve_the_path_0_with_the_extensions_Colon_1_6231", "Could not resolve the path '{0}' with the extensions: {1}."),
            Declaration_augments_declaration_in_another_file_This_cannot_be_serialized: diag(6232, 1, "Declaration_augments_declaration_in_another_file_This_cannot_be_serialized_6232", "Declaration augments declaration in another file. This cannot be serialized."),
            This_is_the_declaration_being_augmented_Consider_moving_the_augmenting_declaration_into_the_same_file: diag(6233, 1, "This_is_the_declaration_being_augmented_Consider_moving_the_augmenting_declaration_into_the_same_fil_6233", "This is the declaration being augmented. Consider moving the augmenting declaration into the same file."),
            This_expression_is_not_callable_because_it_is_a_get_accessor_Did_you_mean_to_use_it_without: diag(6234, 1, "This_expression_is_not_callable_because_it_is_a_get_accessor_Did_you_mean_to_use_it_without_6234", "This expression is not callable because it is a 'get' accessor. Did you mean to use it without '()'?"),
            Disable_loading_referenced_projects: diag(6235, 3, "Disable_loading_referenced_projects_6235", "Disable loading referenced projects."),
            Arguments_for_the_rest_parameter_0_were_not_provided: diag(6236, 1, "Arguments_for_the_rest_parameter_0_were_not_provided_6236", "Arguments for the rest parameter '{0}' were not provided."),
            Generates_an_event_trace_and_a_list_of_types: diag(6237, 3, "Generates_an_event_trace_and_a_list_of_types_6237", "Generates an event trace and a list of types."),
            Specify_the_module_specifier_to_be_used_to_import_the_jsx_and_jsxs_factory_functions_from_eg_react: diag(6238, 1, "Specify_the_module_specifier_to_be_used_to_import_the_jsx_and_jsxs_factory_functions_from_eg_react_6238", "Specify the module specifier to be used to import the 'jsx' and 'jsxs' factory functions from. eg, react"),
            File_0_exists_according_to_earlier_cached_lookups: diag(6239, 3, "File_0_exists_according_to_earlier_cached_lookups_6239", "File '{0}' exists according to earlier cached lookups."),
            File_0_does_not_exist_according_to_earlier_cached_lookups: diag(6240, 3, "File_0_does_not_exist_according_to_earlier_cached_lookups_6240", "File '{0}' does not exist according to earlier cached lookups."),
            Resolution_for_type_reference_directive_0_was_found_in_cache_from_location_1: diag(6241, 3, "Resolution_for_type_reference_directive_0_was_found_in_cache_from_location_1_6241", "Resolution for type reference directive '{0}' was found in cache from location '{1}'."),
            Resolving_type_reference_directive_0_containing_file_1: diag(6242, 3, "Resolving_type_reference_directive_0_containing_file_1_6242", "======== Resolving type reference directive '{0}', containing file '{1}'. ========"),
            Interpret_optional_property_types_as_written_rather_than_adding_undefined: diag(6243, 3, "Interpret_optional_property_types_as_written_rather_than_adding_undefined_6243", "Interpret optional property types as written, rather than adding 'undefined'."),
            Modules: diag(6244, 3, "Modules_6244", "Modules"),
            File_Management: diag(6245, 3, "File_Management_6245", "File Management"),
            Emit: diag(6246, 3, "Emit_6246", "Emit"),
            JavaScript_Support: diag(6247, 3, "JavaScript_Support_6247", "JavaScript Support"),
            Type_Checking: diag(6248, 3, "Type_Checking_6248", "Type Checking"),
            Editor_Support: diag(6249, 3, "Editor_Support_6249", "Editor Support"),
            Watch_and_Build_Modes: diag(6250, 3, "Watch_and_Build_Modes_6250", "Watch and Build Modes"),
            Compiler_Diagnostics: diag(6251, 3, "Compiler_Diagnostics_6251", "Compiler Diagnostics"),
            Interop_Constraints: diag(6252, 3, "Interop_Constraints_6252", "Interop Constraints"),
            Backwards_Compatibility: diag(6253, 3, "Backwards_Compatibility_6253", "Backwards Compatibility"),
            Language_and_Environment: diag(6254, 3, "Language_and_Environment_6254", "Language and Environment"),
            Projects: diag(6255, 3, "Projects_6255", "Projects"),
            Output_Formatting: diag(6256, 3, "Output_Formatting_6256", "Output Formatting"),
            Completeness: diag(6257, 3, "Completeness_6257", "Completeness"),
            _0_should_be_set_inside_the_compilerOptions_object_of_the_config_json_file: diag(6258, 1, "_0_should_be_set_inside_the_compilerOptions_object_of_the_config_json_file_6258", "'{0}' should be set inside the 'compilerOptions' object of the config json file"),
            Found_1_error_in_0: diag(6259, 3, "Found_1_error_in_0_6259", "Found 1 error in {0}"),
            Found_0_errors_in_the_same_file_starting_at_Colon_1: diag(6260, 3, "Found_0_errors_in_the_same_file_starting_at_Colon_1_6260", "Found {0} errors in the same file, starting at: {1}"),
            Found_0_errors_in_1_files: diag(6261, 3, "Found_0_errors_in_1_files_6261", "Found {0} errors in {1} files."),
            File_name_0_has_a_1_extension_looking_up_2_instead: diag(6262, 3, "File_name_0_has_a_1_extension_looking_up_2_instead_6262", "File name '{0}' has a '{1}' extension - looking up '{2}' instead."),
            Module_0_was_resolved_to_1_but_allowArbitraryExtensions_is_not_set: diag(6263, 1, "Module_0_was_resolved_to_1_but_allowArbitraryExtensions_is_not_set_6263", "Module '{0}' was resolved to '{1}', but '--allowArbitraryExtensions' is not set."),
            Enable_importing_files_with_any_extension_provided_a_declaration_file_is_present: diag(6264, 3, "Enable_importing_files_with_any_extension_provided_a_declaration_file_is_present_6264", "Enable importing files with any extension, provided a declaration file is present."),
            Resolving_type_reference_directive_for_program_that_specifies_custom_typeRoots_skipping_lookup_in_node_modules_folder: diag(6265, 3, "Resolving_type_reference_directive_for_program_that_specifies_custom_typeRoots_skipping_lookup_in_no_6265", "Resolving type reference directive for program that specifies custom typeRoots, skipping lookup in 'node_modules' folder."),
            Option_0_can_only_be_specified_on_command_line: diag(6266, 1, "Option_0_can_only_be_specified_on_command_line_6266", "Option '{0}' can only be specified on command line."),
            Directory_0_has_no_containing_package_json_scope_Imports_will_not_resolve: diag(6270, 3, "Directory_0_has_no_containing_package_json_scope_Imports_will_not_resolve_6270", "Directory '{0}' has no containing package.json scope. Imports will not resolve."),
            Import_specifier_0_does_not_exist_in_package_json_scope_at_path_1: diag(6271, 3, "Import_specifier_0_does_not_exist_in_package_json_scope_at_path_1_6271", "Import specifier '{0}' does not exist in package.json scope at path '{1}'."),
            Invalid_import_specifier_0_has_no_possible_resolutions: diag(6272, 3, "Invalid_import_specifier_0_has_no_possible_resolutions_6272", "Invalid import specifier '{0}' has no possible resolutions."),
            package_json_scope_0_has_no_imports_defined: diag(6273, 3, "package_json_scope_0_has_no_imports_defined_6273", "package.json scope '{0}' has no imports defined."),
            package_json_scope_0_explicitly_maps_specifier_1_to_null: diag(6274, 3, "package_json_scope_0_explicitly_maps_specifier_1_to_null_6274", "package.json scope '{0}' explicitly maps specifier '{1}' to null."),
            package_json_scope_0_has_invalid_type_for_target_of_specifier_1: diag(6275, 3, "package_json_scope_0_has_invalid_type_for_target_of_specifier_1_6275", "package.json scope '{0}' has invalid type for target of specifier '{1}'"),
            Export_specifier_0_does_not_exist_in_package_json_scope_at_path_1: diag(6276, 3, "Export_specifier_0_does_not_exist_in_package_json_scope_at_path_1_6276", "Export specifier '{0}' does not exist in package.json scope at path '{1}'."),
            Resolution_of_non_relative_name_failed_trying_with_modern_Node_resolution_features_disabled_to_see_if_npm_library_needs_configuration_update: diag(6277, 3, "Resolution_of_non_relative_name_failed_trying_with_modern_Node_resolution_features_disabled_to_see_i_6277", "Resolution of non-relative name failed; trying with modern Node resolution features disabled to see if npm library needs configuration update."),
            There_are_types_at_0_but_this_result_could_not_be_resolved_when_respecting_package_json_exports_The_1_library_may_need_to_update_its_package_json_or_typings: diag(6278, 3, "There_are_types_at_0_but_this_result_could_not_be_resolved_when_respecting_package_json_exports_The__6278", `There are types at '{0}', but this result could not be resolved when respecting package.json "exports". The '{1}' library may need to update its package.json or typings.`),
            Enable_project_compilation: diag(6302, 3, "Enable_project_compilation_6302", "Enable project compilation"),
            Composite_projects_may_not_disable_declaration_emit: diag(6304, 1, "Composite_projects_may_not_disable_declaration_emit_6304", "Composite projects may not disable declaration emit."),
            Output_file_0_has_not_been_built_from_source_file_1: diag(6305, 1, "Output_file_0_has_not_been_built_from_source_file_1_6305", "Output file '{0}' has not been built from source file '{1}'."),
            Referenced_project_0_must_have_setting_composite_Colon_true: diag(6306, 1, "Referenced_project_0_must_have_setting_composite_Colon_true_6306", `Referenced project '{0}' must have setting "composite": true.`),
            File_0_is_not_listed_within_the_file_list_of_project_1_Projects_must_list_all_files_or_use_an_include_pattern: diag(6307, 1, "File_0_is_not_listed_within_the_file_list_of_project_1_Projects_must_list_all_files_or_use_an_includ_6307", "File '{0}' is not listed within the file list of project '{1}'. Projects must list all files or use an 'include' pattern."),
            Cannot_prepend_project_0_because_it_does_not_have_outFile_set: diag(6308, 1, "Cannot_prepend_project_0_because_it_does_not_have_outFile_set_6308", "Cannot prepend project '{0}' because it does not have 'outFile' set"),
            Output_file_0_from_project_1_does_not_exist: diag(6309, 1, "Output_file_0_from_project_1_does_not_exist_6309", "Output file '{0}' from project '{1}' does not exist"),
            Referenced_project_0_may_not_disable_emit: diag(6310, 1, "Referenced_project_0_may_not_disable_emit_6310", "Referenced project '{0}' may not disable emit."),
            Project_0_is_out_of_date_because_output_1_is_older_than_input_2: diag(6350, 3, "Project_0_is_out_of_date_because_output_1_is_older_than_input_2_6350", "Project '{0}' is out of date because output '{1}' is older than input '{2}'"),
            Project_0_is_up_to_date_because_newest_input_1_is_older_than_output_2: diag(6351, 3, "Project_0_is_up_to_date_because_newest_input_1_is_older_than_output_2_6351", "Project '{0}' is up to date because newest input '{1}' is older than output '{2}'"),
            Project_0_is_out_of_date_because_output_file_1_does_not_exist: diag(6352, 3, "Project_0_is_out_of_date_because_output_file_1_does_not_exist_6352", "Project '{0}' is out of date because output file '{1}' does not exist"),
            Project_0_is_out_of_date_because_its_dependency_1_is_out_of_date: diag(6353, 3, "Project_0_is_out_of_date_because_its_dependency_1_is_out_of_date_6353", "Project '{0}' is out of date because its dependency '{1}' is out of date"),
            Project_0_is_up_to_date_with_d_ts_files_from_its_dependencies: diag(6354, 3, "Project_0_is_up_to_date_with_d_ts_files_from_its_dependencies_6354", "Project '{0}' is up to date with .d.ts files from its dependencies"),
            Projects_in_this_build_Colon_0: diag(6355, 3, "Projects_in_this_build_Colon_0_6355", "Projects in this build: {0}"),
            A_non_dry_build_would_delete_the_following_files_Colon_0: diag(6356, 3, "A_non_dry_build_would_delete_the_following_files_Colon_0_6356", "A non-dry build would delete the following files: {0}"),
            A_non_dry_build_would_build_project_0: diag(6357, 3, "A_non_dry_build_would_build_project_0_6357", "A non-dry build would build project '{0}'"),
            Building_project_0: diag(6358, 3, "Building_project_0_6358", "Building project '{0}'..."),
            Updating_output_timestamps_of_project_0: diag(6359, 3, "Updating_output_timestamps_of_project_0_6359", "Updating output timestamps of project '{0}'..."),
            Project_0_is_up_to_date: diag(6361, 3, "Project_0_is_up_to_date_6361", "Project '{0}' is up to date"),
            Skipping_build_of_project_0_because_its_dependency_1_has_errors: diag(6362, 3, "Skipping_build_of_project_0_because_its_dependency_1_has_errors_6362", "Skipping build of project '{0}' because its dependency '{1}' has errors"),
            Project_0_can_t_be_built_because_its_dependency_1_has_errors: diag(6363, 3, "Project_0_can_t_be_built_because_its_dependency_1_has_errors_6363", "Project '{0}' can't be built because its dependency '{1}' has errors"),
            Build_one_or_more_projects_and_their_dependencies_if_out_of_date: diag(6364, 3, "Build_one_or_more_projects_and_their_dependencies_if_out_of_date_6364", "Build one or more projects and their dependencies, if out of date"),
            Delete_the_outputs_of_all_projects: diag(6365, 3, "Delete_the_outputs_of_all_projects_6365", "Delete the outputs of all projects."),
            Show_what_would_be_built_or_deleted_if_specified_with_clean: diag(6367, 3, "Show_what_would_be_built_or_deleted_if_specified_with_clean_6367", "Show what would be built (or deleted, if specified with '--clean')"),
            Option_build_must_be_the_first_command_line_argument: diag(6369, 1, "Option_build_must_be_the_first_command_line_argument_6369", "Option '--build' must be the first command line argument."),
            Options_0_and_1_cannot_be_combined: diag(6370, 1, "Options_0_and_1_cannot_be_combined_6370", "Options '{0}' and '{1}' cannot be combined."),
            Updating_unchanged_output_timestamps_of_project_0: diag(6371, 3, "Updating_unchanged_output_timestamps_of_project_0_6371", "Updating unchanged output timestamps of project '{0}'..."),
            Project_0_is_out_of_date_because_output_of_its_dependency_1_has_changed: diag(6372, 3, "Project_0_is_out_of_date_because_output_of_its_dependency_1_has_changed_6372", "Project '{0}' is out of date because output of its dependency '{1}' has changed"),
            Updating_output_of_project_0: diag(6373, 3, "Updating_output_of_project_0_6373", "Updating output of project '{0}'..."),
            A_non_dry_build_would_update_timestamps_for_output_of_project_0: diag(6374, 3, "A_non_dry_build_would_update_timestamps_for_output_of_project_0_6374", "A non-dry build would update timestamps for output of project '{0}'"),
            A_non_dry_build_would_update_output_of_project_0: diag(6375, 3, "A_non_dry_build_would_update_output_of_project_0_6375", "A non-dry build would update output of project '{0}'"),
            Cannot_update_output_of_project_0_because_there_was_error_reading_file_1: diag(6376, 3, "Cannot_update_output_of_project_0_because_there_was_error_reading_file_1_6376", "Cannot update output of project '{0}' because there was error reading file '{1}'"),
            Cannot_write_file_0_because_it_will_overwrite_tsbuildinfo_file_generated_by_referenced_project_1: diag(6377, 1, "Cannot_write_file_0_because_it_will_overwrite_tsbuildinfo_file_generated_by_referenced_project_1_6377", "Cannot write file '{0}' because it will overwrite '.tsbuildinfo' file generated by referenced project '{1}'"),
            Composite_projects_may_not_disable_incremental_compilation: diag(6379, 1, "Composite_projects_may_not_disable_incremental_compilation_6379", "Composite projects may not disable incremental compilation."),
            Specify_file_to_store_incremental_compilation_information: diag(6380, 3, "Specify_file_to_store_incremental_compilation_information_6380", "Specify file to store incremental compilation information"),
            Project_0_is_out_of_date_because_output_for_it_was_generated_with_version_1_that_differs_with_current_version_2: diag(6381, 3, "Project_0_is_out_of_date_because_output_for_it_was_generated_with_version_1_that_differs_with_curren_6381", "Project '{0}' is out of date because output for it was generated with version '{1}' that differs with current version '{2}'"),
            Skipping_build_of_project_0_because_its_dependency_1_was_not_built: diag(6382, 3, "Skipping_build_of_project_0_because_its_dependency_1_was_not_built_6382", "Skipping build of project '{0}' because its dependency '{1}' was not built"),
            Project_0_can_t_be_built_because_its_dependency_1_was_not_built: diag(6383, 3, "Project_0_can_t_be_built_because_its_dependency_1_was_not_built_6383", "Project '{0}' can't be built because its dependency '{1}' was not built"),
            Have_recompiles_in_incremental_and_watch_assume_that_changes_within_a_file_will_only_affect_files_directly_depending_on_it: diag(6384, 3, "Have_recompiles_in_incremental_and_watch_assume_that_changes_within_a_file_will_only_affect_files_di_6384", "Have recompiles in '--incremental' and '--watch' assume that changes within a file will only affect files directly depending on it."),
            _0_is_deprecated: diag(
              6385,
              2,
              "_0_is_deprecated_6385",
              "'{0}' is deprecated.",
              /*reportsUnnecessary*/
              void 0,
              /*elidedInCompatabilityPyramid*/
              void 0,
              /*reportsDeprecated*/
              true
            ),
            Performance_timings_for_diagnostics_or_extendedDiagnostics_are_not_available_in_this_session_A_native_implementation_of_the_Web_Performance_API_could_not_be_found: diag(6386, 3, "Performance_timings_for_diagnostics_or_extendedDiagnostics_are_not_available_in_this_session_A_nativ_6386", "Performance timings for '--diagnostics' or '--extendedDiagnostics' are not available in this session. A native implementation of the Web Performance API could not be found."),
            The_signature_0_of_1_is_deprecated: diag(
              6387,
              2,
              "The_signature_0_of_1_is_deprecated_6387",
              "The signature '{0}' of '{1}' is deprecated.",
              /*reportsUnnecessary*/
              void 0,
              /*elidedInCompatabilityPyramid*/
              void 0,
              /*reportsDeprecated*/
              true
            ),
            Project_0_is_being_forcibly_rebuilt: diag(6388, 3, "Project_0_is_being_forcibly_rebuilt_6388", "Project '{0}' is being forcibly rebuilt"),
            Reusing_resolution_of_module_0_from_1_of_old_program_it_was_not_resolved: diag(6389, 3, "Reusing_resolution_of_module_0_from_1_of_old_program_it_was_not_resolved_6389", "Reusing resolution of module '{0}' from '{1}' of old program, it was not resolved."),
            Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_successfully_resolved_to_2: diag(6390, 3, "Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_successfully_resolved__6390", "Reusing resolution of type reference directive '{0}' from '{1}' of old program, it was successfully resolved to '{2}'."),
            Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_successfully_resolved_to_2_with_Package_ID_3: diag(6391, 3, "Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_successfully_resolved__6391", "Reusing resolution of type reference directive '{0}' from '{1}' of old program, it was successfully resolved to '{2}' with Package ID '{3}'."),
            Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_not_resolved: diag(6392, 3, "Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_not_resolved_6392", "Reusing resolution of type reference directive '{0}' from '{1}' of old program, it was not resolved."),
            Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_3: diag(6393, 3, "Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_6393", "Reusing resolution of module '{0}' from '{1}' found in cache from location '{2}', it was successfully resolved to '{3}'."),
            Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_3_with_Package_ID_4: diag(6394, 3, "Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_6394", "Reusing resolution of module '{0}' from '{1}' found in cache from location '{2}', it was successfully resolved to '{3}' with Package ID '{4}'."),
            Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_not_resolved: diag(6395, 3, "Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_not_resolved_6395", "Reusing resolution of module '{0}' from '{1}' found in cache from location '{2}', it was not resolved."),
            Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_3: diag(6396, 3, "Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_succes_6396", "Reusing resolution of type reference directive '{0}' from '{1}' found in cache from location '{2}', it was successfully resolved to '{3}'."),
            Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_3_with_Package_ID_4: diag(6397, 3, "Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_succes_6397", "Reusing resolution of type reference directive '{0}' from '{1}' found in cache from location '{2}', it was successfully resolved to '{3}' with Package ID '{4}'."),
            Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_not_resolved: diag(6398, 3, "Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_not_re_6398", "Reusing resolution of type reference directive '{0}' from '{1}' found in cache from location '{2}', it was not resolved."),
            Project_0_is_out_of_date_because_buildinfo_file_1_indicates_that_some_of_the_changes_were_not_emitted: diag(6399, 3, "Project_0_is_out_of_date_because_buildinfo_file_1_indicates_that_some_of_the_changes_were_not_emitte_6399", "Project '{0}' is out of date because buildinfo file '{1}' indicates that some of the changes were not emitted"),
            Project_0_is_up_to_date_but_needs_to_update_timestamps_of_output_files_that_are_older_than_input_files: diag(6400, 3, "Project_0_is_up_to_date_but_needs_to_update_timestamps_of_output_files_that_are_older_than_input_fil_6400", "Project '{0}' is up to date but needs to update timestamps of output files that are older than input files"),
            Project_0_is_out_of_date_because_there_was_error_reading_file_1: diag(6401, 3, "Project_0_is_out_of_date_because_there_was_error_reading_file_1_6401", "Project '{0}' is out of date because there was error reading file '{1}'"),
            Resolving_in_0_mode_with_conditions_1: diag(6402, 3, "Resolving_in_0_mode_with_conditions_1_6402", "Resolving in {0} mode with conditions {1}."),
            Matched_0_condition_1: diag(6403, 3, "Matched_0_condition_1_6403", "Matched '{0}' condition '{1}'."),
            Using_0_subpath_1_with_target_2: diag(6404, 3, "Using_0_subpath_1_with_target_2_6404", "Using '{0}' subpath '{1}' with target '{2}'."),
            Saw_non_matching_condition_0: diag(6405, 3, "Saw_non_matching_condition_0_6405", "Saw non-matching condition '{0}'."),
            Project_0_is_out_of_date_because_buildinfo_file_1_indicates_there_is_change_in_compilerOptions: diag(6406, 3, "Project_0_is_out_of_date_because_buildinfo_file_1_indicates_there_is_change_in_compilerOptions_6406", "Project '{0}' is out of date because buildinfo file '{1}' indicates there is change in compilerOptions"),
            Allow_imports_to_include_TypeScript_file_extensions_Requires_moduleResolution_bundler_and_either_noEmit_or_emitDeclarationOnly_to_be_set: diag(6407, 3, "Allow_imports_to_include_TypeScript_file_extensions_Requires_moduleResolution_bundler_and_either_noE_6407", "Allow imports to include TypeScript file extensions. Requires '--moduleResolution bundler' and either '--noEmit' or '--emitDeclarationOnly' to be set."),
            Use_the_package_json_exports_field_when_resolving_package_imports: diag(6408, 3, "Use_the_package_json_exports_field_when_resolving_package_imports_6408", "Use the package.json 'exports' field when resolving package imports."),
            Use_the_package_json_imports_field_when_resolving_imports: diag(6409, 3, "Use_the_package_json_imports_field_when_resolving_imports_6409", "Use the package.json 'imports' field when resolving imports."),
            Conditions_to_set_in_addition_to_the_resolver_specific_defaults_when_resolving_imports: diag(6410, 3, "Conditions_to_set_in_addition_to_the_resolver_specific_defaults_when_resolving_imports_6410", "Conditions to set in addition to the resolver-specific defaults when resolving imports."),
            true_when_moduleResolution_is_node16_nodenext_or_bundler_otherwise_false: diag(6411, 3, "true_when_moduleResolution_is_node16_nodenext_or_bundler_otherwise_false_6411", "`true` when 'moduleResolution' is 'node16', 'nodenext', or 'bundler'; otherwise `false`."),
            Project_0_is_out_of_date_because_buildinfo_file_1_indicates_that_file_2_was_root_file_of_compilation_but_not_any_more: diag(6412, 3, "Project_0_is_out_of_date_because_buildinfo_file_1_indicates_that_file_2_was_root_file_of_compilation_6412", "Project '{0}' is out of date because buildinfo file '{1}' indicates that file '{2}' was root file of compilation but not any more."),
            Entering_conditional_exports: diag(6413, 3, "Entering_conditional_exports_6413", "Entering conditional exports."),
            Resolved_under_condition_0: diag(6414, 3, "Resolved_under_condition_0_6414", "Resolved under condition '{0}'."),
            Failed_to_resolve_under_condition_0: diag(6415, 3, "Failed_to_resolve_under_condition_0_6415", "Failed to resolve under condition '{0}'."),
            Exiting_conditional_exports: diag(6416, 3, "Exiting_conditional_exports_6416", "Exiting conditional exports."),
            Searching_all_ancestor_node_modules_directories_for_preferred_extensions_Colon_0: diag(6417, 3, "Searching_all_ancestor_node_modules_directories_for_preferred_extensions_Colon_0_6417", "Searching all ancestor node_modules directories for preferred extensions: {0}."),
            Searching_all_ancestor_node_modules_directories_for_fallback_extensions_Colon_0: diag(6418, 3, "Searching_all_ancestor_node_modules_directories_for_fallback_extensions_Colon_0_6418", "Searching all ancestor node_modules directories for fallback extensions: {0}."),
            The_expected_type_comes_from_property_0_which_is_declared_here_on_type_1: diag(6500, 3, "The_expected_type_comes_from_property_0_which_is_declared_here_on_type_1_6500", "The expected type comes from property '{0}' which is declared here on type '{1}'"),
            The_expected_type_comes_from_this_index_signature: diag(6501, 3, "The_expected_type_comes_from_this_index_signature_6501", "The expected type comes from this index signature."),
            The_expected_type_comes_from_the_return_type_of_this_signature: diag(6502, 3, "The_expected_type_comes_from_the_return_type_of_this_signature_6502", "The expected type comes from the return type of this signature."),
            Print_names_of_files_that_are_part_of_the_compilation_and_then_stop_processing: diag(6503, 3, "Print_names_of_files_that_are_part_of_the_compilation_and_then_stop_processing_6503", "Print names of files that are part of the compilation and then stop processing."),
            File_0_is_a_JavaScript_file_Did_you_mean_to_enable_the_allowJs_option: diag(6504, 1, "File_0_is_a_JavaScript_file_Did_you_mean_to_enable_the_allowJs_option_6504", "File '{0}' is a JavaScript file. Did you mean to enable the 'allowJs' option?"),
            Print_names_of_files_and_the_reason_they_are_part_of_the_compilation: diag(6505, 3, "Print_names_of_files_and_the_reason_they_are_part_of_the_compilation_6505", "Print names of files and the reason they are part of the compilation."),
            Consider_adding_a_declare_modifier_to_this_class: diag(6506, 3, "Consider_adding_a_declare_modifier_to_this_class_6506", "Consider adding a 'declare' modifier to this class."),
            Allow_JavaScript_files_to_be_a_part_of_your_program_Use_the_checkJS_option_to_get_errors_from_these_files: diag(6600, 3, "Allow_JavaScript_files_to_be_a_part_of_your_program_Use_the_checkJS_option_to_get_errors_from_these__6600", "Allow JavaScript files to be a part of your program. Use the 'checkJS' option to get errors from these files."),
            Allow_import_x_from_y_when_a_module_doesn_t_have_a_default_export: diag(6601, 3, "Allow_import_x_from_y_when_a_module_doesn_t_have_a_default_export_6601", "Allow 'import x from y' when a module doesn't have a default export."),
            Allow_accessing_UMD_globals_from_modules: diag(6602, 3, "Allow_accessing_UMD_globals_from_modules_6602", "Allow accessing UMD globals from modules."),
            Disable_error_reporting_for_unreachable_code: diag(6603, 3, "Disable_error_reporting_for_unreachable_code_6603", "Disable error reporting for unreachable code."),
            Disable_error_reporting_for_unused_labels: diag(6604, 3, "Disable_error_reporting_for_unused_labels_6604", "Disable error reporting for unused labels."),
            Ensure_use_strict_is_always_emitted: diag(6605, 3, "Ensure_use_strict_is_always_emitted_6605", "Ensure 'use strict' is always emitted."),
            Have_recompiles_in_projects_that_use_incremental_and_watch_mode_assume_that_changes_within_a_file_will_only_affect_files_directly_depending_on_it: diag(6606, 3, "Have_recompiles_in_projects_that_use_incremental_and_watch_mode_assume_that_changes_within_a_file_wi_6606", "Have recompiles in projects that use 'incremental' and 'watch' mode assume that changes within a file will only affect files directly depending on it."),
            Specify_the_base_directory_to_resolve_non_relative_module_names: diag(6607, 3, "Specify_the_base_directory_to_resolve_non_relative_module_names_6607", "Specify the base directory to resolve non-relative module names."),
            No_longer_supported_In_early_versions_manually_set_the_text_encoding_for_reading_files: diag(6608, 3, "No_longer_supported_In_early_versions_manually_set_the_text_encoding_for_reading_files_6608", "No longer supported. In early versions, manually set the text encoding for reading files."),
            Enable_error_reporting_in_type_checked_JavaScript_files: diag(6609, 3, "Enable_error_reporting_in_type_checked_JavaScript_files_6609", "Enable error reporting in type-checked JavaScript files."),
            Enable_constraints_that_allow_a_TypeScript_project_to_be_used_with_project_references: diag(6611, 3, "Enable_constraints_that_allow_a_TypeScript_project_to_be_used_with_project_references_6611", "Enable constraints that allow a TypeScript project to be used with project references."),
            Generate_d_ts_files_from_TypeScript_and_JavaScript_files_in_your_project: diag(6612, 3, "Generate_d_ts_files_from_TypeScript_and_JavaScript_files_in_your_project_6612", "Generate .d.ts files from TypeScript and JavaScript files in your project."),
            Specify_the_output_directory_for_generated_declaration_files: diag(6613, 3, "Specify_the_output_directory_for_generated_declaration_files_6613", "Specify the output directory for generated declaration files."),
            Create_sourcemaps_for_d_ts_files: diag(6614, 3, "Create_sourcemaps_for_d_ts_files_6614", "Create sourcemaps for d.ts files."),
            Output_compiler_performance_information_after_building: diag(6615, 3, "Output_compiler_performance_information_after_building_6615", "Output compiler performance information after building."),
            Disables_inference_for_type_acquisition_by_looking_at_filenames_in_a_project: diag(6616, 3, "Disables_inference_for_type_acquisition_by_looking_at_filenames_in_a_project_6616", "Disables inference for type acquisition by looking at filenames in a project."),
            Reduce_the_number_of_projects_loaded_automatically_by_TypeScript: diag(6617, 3, "Reduce_the_number_of_projects_loaded_automatically_by_TypeScript_6617", "Reduce the number of projects loaded automatically by TypeScript."),
            Remove_the_20mb_cap_on_total_source_code_size_for_JavaScript_files_in_the_TypeScript_language_server: diag(6618, 3, "Remove_the_20mb_cap_on_total_source_code_size_for_JavaScript_files_in_the_TypeScript_language_server_6618", "Remove the 20mb cap on total source code size for JavaScript files in the TypeScript language server."),
            Opt_a_project_out_of_multi_project_reference_checking_when_editing: diag(6619, 3, "Opt_a_project_out_of_multi_project_reference_checking_when_editing_6619", "Opt a project out of multi-project reference checking when editing."),
            Disable_preferring_source_files_instead_of_declaration_files_when_referencing_composite_projects: diag(6620, 3, "Disable_preferring_source_files_instead_of_declaration_files_when_referencing_composite_projects_6620", "Disable preferring source files instead of declaration files when referencing composite projects."),
            Emit_more_compliant_but_verbose_and_less_performant_JavaScript_for_iteration: diag(6621, 3, "Emit_more_compliant_but_verbose_and_less_performant_JavaScript_for_iteration_6621", "Emit more compliant, but verbose and less performant JavaScript for iteration."),
            Emit_a_UTF_8_Byte_Order_Mark_BOM_in_the_beginning_of_output_files: diag(6622, 3, "Emit_a_UTF_8_Byte_Order_Mark_BOM_in_the_beginning_of_output_files_6622", "Emit a UTF-8 Byte Order Mark (BOM) in the beginning of output files."),
            Only_output_d_ts_files_and_not_JavaScript_files: diag(6623, 3, "Only_output_d_ts_files_and_not_JavaScript_files_6623", "Only output d.ts files and not JavaScript files."),
            Emit_design_type_metadata_for_decorated_declarations_in_source_files: diag(6624, 3, "Emit_design_type_metadata_for_decorated_declarations_in_source_files_6624", "Emit design-type metadata for decorated declarations in source files."),
            Disable_the_type_acquisition_for_JavaScript_projects: diag(6625, 3, "Disable_the_type_acquisition_for_JavaScript_projects_6625", "Disable the type acquisition for JavaScript projects"),
            Emit_additional_JavaScript_to_ease_support_for_importing_CommonJS_modules_This_enables_allowSyntheticDefaultImports_for_type_compatibility: diag(6626, 3, "Emit_additional_JavaScript_to_ease_support_for_importing_CommonJS_modules_This_enables_allowSyntheti_6626", "Emit additional JavaScript to ease support for importing CommonJS modules. This enables 'allowSyntheticDefaultImports' for type compatibility."),
            Filters_results_from_the_include_option: diag(6627, 3, "Filters_results_from_the_include_option_6627", "Filters results from the `include` option."),
            Remove_a_list_of_directories_from_the_watch_process: diag(6628, 3, "Remove_a_list_of_directories_from_the_watch_process_6628", "Remove a list of directories from the watch process."),
            Remove_a_list_of_files_from_the_watch_mode_s_processing: diag(6629, 3, "Remove_a_list_of_files_from_the_watch_mode_s_processing_6629", "Remove a list of files from the watch mode's processing."),
            Enable_experimental_support_for_legacy_experimental_decorators: diag(6630, 3, "Enable_experimental_support_for_legacy_experimental_decorators_6630", "Enable experimental support for legacy experimental decorators."),
            Print_files_read_during_the_compilation_including_why_it_was_included: diag(6631, 3, "Print_files_read_during_the_compilation_including_why_it_was_included_6631", "Print files read during the compilation including why it was included."),
            Output_more_detailed_compiler_performance_information_after_building: diag(6632, 3, "Output_more_detailed_compiler_performance_information_after_building_6632", "Output more detailed compiler performance information after building."),
            Specify_one_or_more_path_or_node_module_references_to_base_configuration_files_from_which_settings_are_inherited: diag(6633, 3, "Specify_one_or_more_path_or_node_module_references_to_base_configuration_files_from_which_settings_a_6633", "Specify one or more path or node module references to base configuration files from which settings are inherited."),
            Specify_what_approach_the_watcher_should_use_if_the_system_runs_out_of_native_file_watchers: diag(6634, 3, "Specify_what_approach_the_watcher_should_use_if_the_system_runs_out_of_native_file_watchers_6634", "Specify what approach the watcher should use if the system runs out of native file watchers."),
            Include_a_list_of_files_This_does_not_support_glob_patterns_as_opposed_to_include: diag(6635, 3, "Include_a_list_of_files_This_does_not_support_glob_patterns_as_opposed_to_include_6635", "Include a list of files. This does not support glob patterns, as opposed to `include`."),
            Build_all_projects_including_those_that_appear_to_be_up_to_date: diag(6636, 3, "Build_all_projects_including_those_that_appear_to_be_up_to_date_6636", "Build all projects, including those that appear to be up to date."),
            Ensure_that_casing_is_correct_in_imports: diag(6637, 3, "Ensure_that_casing_is_correct_in_imports_6637", "Ensure that casing is correct in imports."),
            Emit_a_v8_CPU_profile_of_the_compiler_run_for_debugging: diag(6638, 3, "Emit_a_v8_CPU_profile_of_the_compiler_run_for_debugging_6638", "Emit a v8 CPU profile of the compiler run for debugging."),
            Allow_importing_helper_functions_from_tslib_once_per_project_instead_of_including_them_per_file: diag(6639, 3, "Allow_importing_helper_functions_from_tslib_once_per_project_instead_of_including_them_per_file_6639", "Allow importing helper functions from tslib once per project, instead of including them per-file."),
            Specify_a_list_of_glob_patterns_that_match_files_to_be_included_in_compilation: diag(6641, 3, "Specify_a_list_of_glob_patterns_that_match_files_to_be_included_in_compilation_6641", "Specify a list of glob patterns that match files to be included in compilation."),
            Save_tsbuildinfo_files_to_allow_for_incremental_compilation_of_projects: diag(6642, 3, "Save_tsbuildinfo_files_to_allow_for_incremental_compilation_of_projects_6642", "Save .tsbuildinfo files to allow for incremental compilation of projects."),
            Include_sourcemap_files_inside_the_emitted_JavaScript: diag(6643, 3, "Include_sourcemap_files_inside_the_emitted_JavaScript_6643", "Include sourcemap files inside the emitted JavaScript."),
            Include_source_code_in_the_sourcemaps_inside_the_emitted_JavaScript: diag(6644, 3, "Include_source_code_in_the_sourcemaps_inside_the_emitted_JavaScript_6644", "Include source code in the sourcemaps inside the emitted JavaScript."),
            Ensure_that_each_file_can_be_safely_transpiled_without_relying_on_other_imports: diag(6645, 3, "Ensure_that_each_file_can_be_safely_transpiled_without_relying_on_other_imports_6645", "Ensure that each file can be safely transpiled without relying on other imports."),
            Specify_what_JSX_code_is_generated: diag(6646, 3, "Specify_what_JSX_code_is_generated_6646", "Specify what JSX code is generated."),
            Specify_the_JSX_factory_function_used_when_targeting_React_JSX_emit_e_g_React_createElement_or_h: diag(6647, 3, "Specify_the_JSX_factory_function_used_when_targeting_React_JSX_emit_e_g_React_createElement_or_h_6647", "Specify the JSX factory function used when targeting React JSX emit, e.g. 'React.createElement' or 'h'."),
            Specify_the_JSX_Fragment_reference_used_for_fragments_when_targeting_React_JSX_emit_e_g_React_Fragment_or_Fragment: diag(6648, 3, "Specify_the_JSX_Fragment_reference_used_for_fragments_when_targeting_React_JSX_emit_e_g_React_Fragme_6648", "Specify the JSX Fragment reference used for fragments when targeting React JSX emit e.g. 'React.Fragment' or 'Fragment'."),
            Specify_module_specifier_used_to_import_the_JSX_factory_functions_when_using_jsx_Colon_react_jsx_Asterisk: diag(6649, 3, "Specify_module_specifier_used_to_import_the_JSX_factory_functions_when_using_jsx_Colon_react_jsx_Ast_6649", "Specify module specifier used to import the JSX factory functions when using 'jsx: react-jsx*'."),
            Make_keyof_only_return_strings_instead_of_string_numbers_or_symbols_Legacy_option: diag(6650, 3, "Make_keyof_only_return_strings_instead_of_string_numbers_or_symbols_Legacy_option_6650", "Make keyof only return strings instead of string, numbers or symbols. Legacy option."),
            Specify_a_set_of_bundled_library_declaration_files_that_describe_the_target_runtime_environment: diag(6651, 3, "Specify_a_set_of_bundled_library_declaration_files_that_describe_the_target_runtime_environment_6651", "Specify a set of bundled library declaration files that describe the target runtime environment."),
            Print_the_names_of_emitted_files_after_a_compilation: diag(6652, 3, "Print_the_names_of_emitted_files_after_a_compilation_6652", "Print the names of emitted files after a compilation."),
            Print_all_of_the_files_read_during_the_compilation: diag(6653, 3, "Print_all_of_the_files_read_during_the_compilation_6653", "Print all of the files read during the compilation."),
            Set_the_language_of_the_messaging_from_TypeScript_This_does_not_affect_emit: diag(6654, 3, "Set_the_language_of_the_messaging_from_TypeScript_This_does_not_affect_emit_6654", "Set the language of the messaging from TypeScript. This does not affect emit."),
            Specify_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations: diag(6655, 3, "Specify_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations_6655", "Specify the location where debugger should locate map files instead of generated locations."),
            Specify_the_maximum_folder_depth_used_for_checking_JavaScript_files_from_node_modules_Only_applicable_with_allowJs: diag(6656, 3, "Specify_the_maximum_folder_depth_used_for_checking_JavaScript_files_from_node_modules_Only_applicabl_6656", "Specify the maximum folder depth used for checking JavaScript files from 'node_modules'. Only applicable with 'allowJs'."),
            Specify_what_module_code_is_generated: diag(6657, 3, "Specify_what_module_code_is_generated_6657", "Specify what module code is generated."),
            Specify_how_TypeScript_looks_up_a_file_from_a_given_module_specifier: diag(6658, 3, "Specify_how_TypeScript_looks_up_a_file_from_a_given_module_specifier_6658", "Specify how TypeScript looks up a file from a given module specifier."),
            Set_the_newline_character_for_emitting_files: diag(6659, 3, "Set_the_newline_character_for_emitting_files_6659", "Set the newline character for emitting files."),
            Disable_emitting_files_from_a_compilation: diag(6660, 3, "Disable_emitting_files_from_a_compilation_6660", "Disable emitting files from a compilation."),
            Disable_generating_custom_helper_functions_like_extends_in_compiled_output: diag(6661, 3, "Disable_generating_custom_helper_functions_like_extends_in_compiled_output_6661", "Disable generating custom helper functions like '__extends' in compiled output."),
            Disable_emitting_files_if_any_type_checking_errors_are_reported: diag(6662, 3, "Disable_emitting_files_if_any_type_checking_errors_are_reported_6662", "Disable emitting files if any type checking errors are reported."),
            Disable_truncating_types_in_error_messages: diag(6663, 3, "Disable_truncating_types_in_error_messages_6663", "Disable truncating types in error messages."),
            Enable_error_reporting_for_fallthrough_cases_in_switch_statements: diag(6664, 3, "Enable_error_reporting_for_fallthrough_cases_in_switch_statements_6664", "Enable error reporting for fallthrough cases in switch statements."),
            Enable_error_reporting_for_expressions_and_declarations_with_an_implied_any_type: diag(6665, 3, "Enable_error_reporting_for_expressions_and_declarations_with_an_implied_any_type_6665", "Enable error reporting for expressions and declarations with an implied 'any' type."),
            Ensure_overriding_members_in_derived_classes_are_marked_with_an_override_modifier: diag(6666, 3, "Ensure_overriding_members_in_derived_classes_are_marked_with_an_override_modifier_6666", "Ensure overriding members in derived classes are marked with an override modifier."),
            Enable_error_reporting_for_codepaths_that_do_not_explicitly_return_in_a_function: diag(6667, 3, "Enable_error_reporting_for_codepaths_that_do_not_explicitly_return_in_a_function_6667", "Enable error reporting for codepaths that do not explicitly return in a function."),
            Enable_error_reporting_when_this_is_given_the_type_any: diag(6668, 3, "Enable_error_reporting_when_this_is_given_the_type_any_6668", "Enable error reporting when 'this' is given the type 'any'."),
            Disable_adding_use_strict_directives_in_emitted_JavaScript_files: diag(6669, 3, "Disable_adding_use_strict_directives_in_emitted_JavaScript_files_6669", "Disable adding 'use strict' directives in emitted JavaScript files."),
            Disable_including_any_library_files_including_the_default_lib_d_ts: diag(6670, 3, "Disable_including_any_library_files_including_the_default_lib_d_ts_6670", "Disable including any library files, including the default lib.d.ts."),
            Enforces_using_indexed_accessors_for_keys_declared_using_an_indexed_type: diag(6671, 3, "Enforces_using_indexed_accessors_for_keys_declared_using_an_indexed_type_6671", "Enforces using indexed accessors for keys declared using an indexed type."),
            Disallow_import_s_require_s_or_reference_s_from_expanding_the_number_of_files_TypeScript_should_add_to_a_project: diag(6672, 3, "Disallow_import_s_require_s_or_reference_s_from_expanding_the_number_of_files_TypeScript_should_add__6672", "Disallow 'import's, 'require's or '<reference>'s from expanding the number of files TypeScript should add to a project."),
            Disable_strict_checking_of_generic_signatures_in_function_types: diag(6673, 3, "Disable_strict_checking_of_generic_signatures_in_function_types_6673", "Disable strict checking of generic signatures in function types."),
            Add_undefined_to_a_type_when_accessed_using_an_index: diag(6674, 3, "Add_undefined_to_a_type_when_accessed_using_an_index_6674", "Add 'undefined' to a type when accessed using an index."),
            Enable_error_reporting_when_local_variables_aren_t_read: diag(6675, 3, "Enable_error_reporting_when_local_variables_aren_t_read_6675", "Enable error reporting when local variables aren't read."),
            Raise_an_error_when_a_function_parameter_isn_t_read: diag(6676, 3, "Raise_an_error_when_a_function_parameter_isn_t_read_6676", "Raise an error when a function parameter isn't read."),
            Deprecated_setting_Use_outFile_instead: diag(6677, 3, "Deprecated_setting_Use_outFile_instead_6677", "Deprecated setting. Use 'outFile' instead."),
            Specify_an_output_folder_for_all_emitted_files: diag(6678, 3, "Specify_an_output_folder_for_all_emitted_files_6678", "Specify an output folder for all emitted files."),
            Specify_a_file_that_bundles_all_outputs_into_one_JavaScript_file_If_declaration_is_true_also_designates_a_file_that_bundles_all_d_ts_output: diag(6679, 3, "Specify_a_file_that_bundles_all_outputs_into_one_JavaScript_file_If_declaration_is_true_also_designa_6679", "Specify a file that bundles all outputs into one JavaScript file. If 'declaration' is true, also designates a file that bundles all .d.ts output."),
            Specify_a_set_of_entries_that_re_map_imports_to_additional_lookup_locations: diag(6680, 3, "Specify_a_set_of_entries_that_re_map_imports_to_additional_lookup_locations_6680", "Specify a set of entries that re-map imports to additional lookup locations."),
            Specify_a_list_of_language_service_plugins_to_include: diag(6681, 3, "Specify_a_list_of_language_service_plugins_to_include_6681", "Specify a list of language service plugins to include."),
            Disable_erasing_const_enum_declarations_in_generated_code: diag(6682, 3, "Disable_erasing_const_enum_declarations_in_generated_code_6682", "Disable erasing 'const enum' declarations in generated code."),
            Disable_resolving_symlinks_to_their_realpath_This_correlates_to_the_same_flag_in_node: diag(6683, 3, "Disable_resolving_symlinks_to_their_realpath_This_correlates_to_the_same_flag_in_node_6683", "Disable resolving symlinks to their realpath. This correlates to the same flag in node."),
            Disable_wiping_the_console_in_watch_mode: diag(6684, 3, "Disable_wiping_the_console_in_watch_mode_6684", "Disable wiping the console in watch mode."),
            Enable_color_and_formatting_in_TypeScript_s_output_to_make_compiler_errors_easier_to_read: diag(6685, 3, "Enable_color_and_formatting_in_TypeScript_s_output_to_make_compiler_errors_easier_to_read_6685", "Enable color and formatting in TypeScript's output to make compiler errors easier to read."),
            Specify_the_object_invoked_for_createElement_This_only_applies_when_targeting_react_JSX_emit: diag(6686, 3, "Specify_the_object_invoked_for_createElement_This_only_applies_when_targeting_react_JSX_emit_6686", "Specify the object invoked for 'createElement'. This only applies when targeting 'react' JSX emit."),
            Specify_an_array_of_objects_that_specify_paths_for_projects_Used_in_project_references: diag(6687, 3, "Specify_an_array_of_objects_that_specify_paths_for_projects_Used_in_project_references_6687", "Specify an array of objects that specify paths for projects. Used in project references."),
            Disable_emitting_comments: diag(6688, 3, "Disable_emitting_comments_6688", "Disable emitting comments."),
            Enable_importing_json_files: diag(6689, 3, "Enable_importing_json_files_6689", "Enable importing .json files."),
            Specify_the_root_folder_within_your_source_files: diag(6690, 3, "Specify_the_root_folder_within_your_source_files_6690", "Specify the root folder within your source files."),
            Allow_multiple_folders_to_be_treated_as_one_when_resolving_modules: diag(6691, 3, "Allow_multiple_folders_to_be_treated_as_one_when_resolving_modules_6691", "Allow multiple folders to be treated as one when resolving modules."),
            Skip_type_checking_d_ts_files_that_are_included_with_TypeScript: diag(6692, 3, "Skip_type_checking_d_ts_files_that_are_included_with_TypeScript_6692", "Skip type checking .d.ts files that are included with TypeScript."),
            Skip_type_checking_all_d_ts_files: diag(6693, 3, "Skip_type_checking_all_d_ts_files_6693", "Skip type checking all .d.ts files."),
            Create_source_map_files_for_emitted_JavaScript_files: diag(6694, 3, "Create_source_map_files_for_emitted_JavaScript_files_6694", "Create source map files for emitted JavaScript files."),
            Specify_the_root_path_for_debuggers_to_find_the_reference_source_code: diag(6695, 3, "Specify_the_root_path_for_debuggers_to_find_the_reference_source_code_6695", "Specify the root path for debuggers to find the reference source code."),
            Check_that_the_arguments_for_bind_call_and_apply_methods_match_the_original_function: diag(6697, 3, "Check_that_the_arguments_for_bind_call_and_apply_methods_match_the_original_function_6697", "Check that the arguments for 'bind', 'call', and 'apply' methods match the original function."),
            When_assigning_functions_check_to_ensure_parameters_and_the_return_values_are_subtype_compatible: diag(6698, 3, "When_assigning_functions_check_to_ensure_parameters_and_the_return_values_are_subtype_compatible_6698", "When assigning functions, check to ensure parameters and the return values are subtype-compatible."),
            When_type_checking_take_into_account_null_and_undefined: diag(6699, 3, "When_type_checking_take_into_account_null_and_undefined_6699", "When type checking, take into account 'null' and 'undefined'."),
            Check_for_class_properties_that_are_declared_but_not_set_in_the_constructor: diag(6700, 3, "Check_for_class_properties_that_are_declared_but_not_set_in_the_constructor_6700", "Check for class properties that are declared but not set in the constructor."),
            Disable_emitting_declarations_that_have_internal_in_their_JSDoc_comments: diag(6701, 3, "Disable_emitting_declarations_that_have_internal_in_their_JSDoc_comments_6701", "Disable emitting declarations that have '@internal' in their JSDoc comments."),
            Disable_reporting_of_excess_property_errors_during_the_creation_of_object_literals: diag(6702, 3, "Disable_reporting_of_excess_property_errors_during_the_creation_of_object_literals_6702", "Disable reporting of excess property errors during the creation of object literals."),
            Suppress_noImplicitAny_errors_when_indexing_objects_that_lack_index_signatures: diag(6703, 3, "Suppress_noImplicitAny_errors_when_indexing_objects_that_lack_index_signatures_6703", "Suppress 'noImplicitAny' errors when indexing objects that lack index signatures."),
            Synchronously_call_callbacks_and_update_the_state_of_directory_watchers_on_platforms_that_don_t_support_recursive_watching_natively: diag(6704, 3, "Synchronously_call_callbacks_and_update_the_state_of_directory_watchers_on_platforms_that_don_t_supp_6704", "Synchronously call callbacks and update the state of directory watchers on platforms that don`t support recursive watching natively."),
            Set_the_JavaScript_language_version_for_emitted_JavaScript_and_include_compatible_library_declarations: diag(6705, 3, "Set_the_JavaScript_language_version_for_emitted_JavaScript_and_include_compatible_library_declaratio_6705", "Set the JavaScript language version for emitted JavaScript and include compatible library declarations."),
            Log_paths_used_during_the_moduleResolution_process: diag(6706, 3, "Log_paths_used_during_the_moduleResolution_process_6706", "Log paths used during the 'moduleResolution' process."),
            Specify_the_path_to_tsbuildinfo_incremental_compilation_file: diag(6707, 3, "Specify_the_path_to_tsbuildinfo_incremental_compilation_file_6707", "Specify the path to .tsbuildinfo incremental compilation file."),
            Specify_options_for_automatic_acquisition_of_declaration_files: diag(6709, 3, "Specify_options_for_automatic_acquisition_of_declaration_files_6709", "Specify options for automatic acquisition of declaration files."),
            Specify_multiple_folders_that_act_like_Slashnode_modules_Slash_types: diag(6710, 3, "Specify_multiple_folders_that_act_like_Slashnode_modules_Slash_types_6710", "Specify multiple folders that act like './node_modules/@types'."),
            Specify_type_package_names_to_be_included_without_being_referenced_in_a_source_file: diag(6711, 3, "Specify_type_package_names_to_be_included_without_being_referenced_in_a_source_file_6711", "Specify type package names to be included without being referenced in a source file."),
            Emit_ECMAScript_standard_compliant_class_fields: diag(6712, 3, "Emit_ECMAScript_standard_compliant_class_fields_6712", "Emit ECMAScript-standard-compliant class fields."),
            Enable_verbose_logging: diag(6713, 3, "Enable_verbose_logging_6713", "Enable verbose logging."),
            Specify_how_directories_are_watched_on_systems_that_lack_recursive_file_watching_functionality: diag(6714, 3, "Specify_how_directories_are_watched_on_systems_that_lack_recursive_file_watching_functionality_6714", "Specify how directories are watched on systems that lack recursive file-watching functionality."),
            Specify_how_the_TypeScript_watch_mode_works: diag(6715, 3, "Specify_how_the_TypeScript_watch_mode_works_6715", "Specify how the TypeScript watch mode works."),
            Require_undeclared_properties_from_index_signatures_to_use_element_accesses: diag(6717, 3, "Require_undeclared_properties_from_index_signatures_to_use_element_accesses_6717", "Require undeclared properties from index signatures to use element accesses."),
            Specify_emit_Slashchecking_behavior_for_imports_that_are_only_used_for_types: diag(6718, 3, "Specify_emit_Slashchecking_behavior_for_imports_that_are_only_used_for_types_6718", "Specify emit/checking behavior for imports that are only used for types."),
            Default_catch_clause_variables_as_unknown_instead_of_any: diag(6803, 3, "Default_catch_clause_variables_as_unknown_instead_of_any_6803", "Default catch clause variables as 'unknown' instead of 'any'."),
            Do_not_transform_or_elide_any_imports_or_exports_not_marked_as_type_only_ensuring_they_are_written_in_the_output_file_s_format_based_on_the_module_setting: diag(6804, 3, "Do_not_transform_or_elide_any_imports_or_exports_not_marked_as_type_only_ensuring_they_are_written_i_6804", "Do not transform or elide any imports or exports not marked as type-only, ensuring they are written in the output file's format based on the 'module' setting."),
            one_of_Colon: diag(6900, 3, "one_of_Colon_6900", "one of:"),
            one_or_more_Colon: diag(6901, 3, "one_or_more_Colon_6901", "one or more:"),
            type_Colon: diag(6902, 3, "type_Colon_6902", "type:"),
            default_Colon: diag(6903, 3, "default_Colon_6903", "default:"),
            module_system_or_esModuleInterop: diag(6904, 3, "module_system_or_esModuleInterop_6904", 'module === "system" or esModuleInterop'),
            false_unless_strict_is_set: diag(6905, 3, "false_unless_strict_is_set_6905", "`false`, unless `strict` is set"),
            false_unless_composite_is_set: diag(6906, 3, "false_unless_composite_is_set_6906", "`false`, unless `composite` is set"),
            node_modules_bower_components_jspm_packages_plus_the_value_of_outDir_if_one_is_specified: diag(6907, 3, "node_modules_bower_components_jspm_packages_plus_the_value_of_outDir_if_one_is_specified_6907", '`["node_modules", "bower_components", "jspm_packages"]`, plus the value of `outDir` if one is specified.'),
            if_files_is_specified_otherwise_Asterisk_Asterisk_Slash_Asterisk: diag(6908, 3, "if_files_is_specified_otherwise_Asterisk_Asterisk_Slash_Asterisk_6908", '`[]` if `files` is specified, otherwise `["**/*"]`'),
            true_if_composite_false_otherwise: diag(6909, 3, "true_if_composite_false_otherwise_6909", "`true` if `composite`, `false` otherwise"),
            module_AMD_or_UMD_or_System_or_ES6_then_Classic_Otherwise_Node: diag(69010, 3, "module_AMD_or_UMD_or_System_or_ES6_then_Classic_Otherwise_Node_69010", "module === `AMD` or `UMD` or `System` or `ES6`, then `Classic`, Otherwise `Node`"),
            Computed_from_the_list_of_input_files: diag(6911, 3, "Computed_from_the_list_of_input_files_6911", "Computed from the list of input files"),
            Platform_specific: diag(6912, 3, "Platform_specific_6912", "Platform specific"),
            You_can_learn_about_all_of_the_compiler_options_at_0: diag(6913, 3, "You_can_learn_about_all_of_the_compiler_options_at_0_6913", "You can learn about all of the compiler options at {0}"),
            Including_watch_w_will_start_watching_the_current_project_for_the_file_changes_Once_set_you_can_config_watch_mode_with_Colon: diag(6914, 3, "Including_watch_w_will_start_watching_the_current_project_for_the_file_changes_Once_set_you_can_conf_6914", "Including --watch, -w will start watching the current project for the file changes. Once set, you can config watch mode with:"),
            Using_build_b_will_make_tsc_behave_more_like_a_build_orchestrator_than_a_compiler_This_is_used_to_trigger_building_composite_projects_which_you_can_learn_more_about_at_0: diag(6915, 3, "Using_build_b_will_make_tsc_behave_more_like_a_build_orchestrator_than_a_compiler_This_is_used_to_tr_6915", "Using --build, -b will make tsc behave more like a build orchestrator than a compiler. This is used to trigger building composite projects which you can learn more about at {0}"),
            COMMON_COMMANDS: diag(6916, 3, "COMMON_COMMANDS_6916", "COMMON COMMANDS"),
            ALL_COMPILER_OPTIONS: diag(6917, 3, "ALL_COMPILER_OPTIONS_6917", "ALL COMPILER OPTIONS"),
            WATCH_OPTIONS: diag(6918, 3, "WATCH_OPTIONS_6918", "WATCH OPTIONS"),
            BUILD_OPTIONS: diag(6919, 3, "BUILD_OPTIONS_6919", "BUILD OPTIONS"),
            COMMON_COMPILER_OPTIONS: diag(6920, 3, "COMMON_COMPILER_OPTIONS_6920", "COMMON COMPILER OPTIONS"),
            COMMAND_LINE_FLAGS: diag(6921, 3, "COMMAND_LINE_FLAGS_6921", "COMMAND LINE FLAGS"),
            tsc_Colon_The_TypeScript_Compiler: diag(6922, 3, "tsc_Colon_The_TypeScript_Compiler_6922", "tsc: The TypeScript Compiler"),
            Compiles_the_current_project_tsconfig_json_in_the_working_directory: diag(6923, 3, "Compiles_the_current_project_tsconfig_json_in_the_working_directory_6923", "Compiles the current project (tsconfig.json in the working directory.)"),
            Ignoring_tsconfig_json_compiles_the_specified_files_with_default_compiler_options: diag(6924, 3, "Ignoring_tsconfig_json_compiles_the_specified_files_with_default_compiler_options_6924", "Ignoring tsconfig.json, compiles the specified files with default compiler options."),
            Build_a_composite_project_in_the_working_directory: diag(6925, 3, "Build_a_composite_project_in_the_working_directory_6925", "Build a composite project in the working directory."),
            Creates_a_tsconfig_json_with_the_recommended_settings_in_the_working_directory: diag(6926, 3, "Creates_a_tsconfig_json_with_the_recommended_settings_in_the_working_directory_6926", "Creates a tsconfig.json with the recommended settings in the working directory."),
            Compiles_the_TypeScript_project_located_at_the_specified_path: diag(6927, 3, "Compiles_the_TypeScript_project_located_at_the_specified_path_6927", "Compiles the TypeScript project located at the specified path."),
            An_expanded_version_of_this_information_showing_all_possible_compiler_options: diag(6928, 3, "An_expanded_version_of_this_information_showing_all_possible_compiler_options_6928", "An expanded version of this information, showing all possible compiler options"),
            Compiles_the_current_project_with_additional_settings: diag(6929, 3, "Compiles_the_current_project_with_additional_settings_6929", "Compiles the current project, with additional settings."),
            true_for_ES2022_and_above_including_ESNext: diag(6930, 3, "true_for_ES2022_and_above_including_ESNext_6930", "`true` for ES2022 and above, including ESNext."),
            List_of_file_name_suffixes_to_search_when_resolving_a_module: diag(6931, 1, "List_of_file_name_suffixes_to_search_when_resolving_a_module_6931", "List of file name suffixes to search when resolving a module."),
            Variable_0_implicitly_has_an_1_type: diag(7005, 1, "Variable_0_implicitly_has_an_1_type_7005", "Variable '{0}' implicitly has an '{1}' type."),
            Parameter_0_implicitly_has_an_1_type: diag(7006, 1, "Parameter_0_implicitly_has_an_1_type_7006", "Parameter '{0}' implicitly has an '{1}' type."),
            Member_0_implicitly_has_an_1_type: diag(7008, 1, "Member_0_implicitly_has_an_1_type_7008", "Member '{0}' implicitly has an '{1}' type."),
            new_expression_whose_target_lacks_a_construct_signature_implicitly_has_an_any_type: diag(7009, 1, "new_expression_whose_target_lacks_a_construct_signature_implicitly_has_an_any_type_7009", "'new' expression, whose target lacks a construct signature, implicitly has an 'any' type."),
            _0_which_lacks_return_type_annotation_implicitly_has_an_1_return_type: diag(7010, 1, "_0_which_lacks_return_type_annotation_implicitly_has_an_1_return_type_7010", "'{0}', which lacks return-type annotation, implicitly has an '{1}' return type."),
            Function_expression_which_lacks_return_type_annotation_implicitly_has_an_0_return_type: diag(7011, 1, "Function_expression_which_lacks_return_type_annotation_implicitly_has_an_0_return_type_7011", "Function expression, which lacks return-type annotation, implicitly has an '{0}' return type."),
            This_overload_implicitly_returns_the_type_0_because_it_lacks_a_return_type_annotation: diag(7012, 1, "This_overload_implicitly_returns_the_type_0_because_it_lacks_a_return_type_annotation_7012", "This overload implicitly returns the type '{0}' because it lacks a return type annotation."),
            Construct_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type: diag(7013, 1, "Construct_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type_7013", "Construct signature, which lacks return-type annotation, implicitly has an 'any' return type."),
            Function_type_which_lacks_return_type_annotation_implicitly_has_an_0_return_type: diag(7014, 1, "Function_type_which_lacks_return_type_annotation_implicitly_has_an_0_return_type_7014", "Function type, which lacks return-type annotation, implicitly has an '{0}' return type."),
            Element_implicitly_has_an_any_type_because_index_expression_is_not_of_type_number: diag(7015, 1, "Element_implicitly_has_an_any_type_because_index_expression_is_not_of_type_number_7015", "Element implicitly has an 'any' type because index expression is not of type 'number'."),
            Could_not_find_a_declaration_file_for_module_0_1_implicitly_has_an_any_type: diag(7016, 1, "Could_not_find_a_declaration_file_for_module_0_1_implicitly_has_an_any_type_7016", "Could not find a declaration file for module '{0}'. '{1}' implicitly has an 'any' type."),
            Element_implicitly_has_an_any_type_because_type_0_has_no_index_signature: diag(7017, 1, "Element_implicitly_has_an_any_type_because_type_0_has_no_index_signature_7017", "Element implicitly has an 'any' type because type '{0}' has no index signature."),
            Object_literal_s_property_0_implicitly_has_an_1_type: diag(7018, 1, "Object_literal_s_property_0_implicitly_has_an_1_type_7018", "Object literal's property '{0}' implicitly has an '{1}' type."),
            Rest_parameter_0_implicitly_has_an_any_type: diag(7019, 1, "Rest_parameter_0_implicitly_has_an_any_type_7019", "Rest parameter '{0}' implicitly has an 'any[]' type."),
            Call_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type: diag(7020, 1, "Call_signature_which_lacks_return_type_annotation_implicitly_has_an_any_return_type_7020", "Call signature, which lacks return-type annotation, implicitly has an 'any' return type."),
            _0_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_and_is_referenced_directly_or_indirectly_in_its_own_initializer: diag(7022, 1, "_0_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_and_is_referenced_directly_or__7022", "'{0}' implicitly has type 'any' because it does not have a type annotation and is referenced directly or indirectly in its own initializer."),
            _0_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions: diag(7023, 1, "_0_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_reference_7023", "'{0}' implicitly has return type 'any' because it does not have a return type annotation and is referenced directly or indirectly in one of its return expressions."),
            Function_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_referenced_directly_or_indirectly_in_one_of_its_return_expressions: diag(7024, 1, "Function_implicitly_has_return_type_any_because_it_does_not_have_a_return_type_annotation_and_is_ref_7024", "Function implicitly has return type 'any' because it does not have a return type annotation and is referenced directly or indirectly in one of its return expressions."),
            Generator_implicitly_has_yield_type_0_because_it_does_not_yield_any_values_Consider_supplying_a_return_type_annotation: diag(7025, 1, "Generator_implicitly_has_yield_type_0_because_it_does_not_yield_any_values_Consider_supplying_a_retu_7025", "Generator implicitly has yield type '{0}' because it does not yield any values. Consider supplying a return type annotation."),
            JSX_element_implicitly_has_type_any_because_no_interface_JSX_0_exists: diag(7026, 1, "JSX_element_implicitly_has_type_any_because_no_interface_JSX_0_exists_7026", "JSX element implicitly has type 'any' because no interface 'JSX.{0}' exists."),
            Unreachable_code_detected: diag(
              7027,
              1,
              "Unreachable_code_detected_7027",
              "Unreachable code detected.",
              /*reportsUnnecessary*/
              true
            ),
            Unused_label: diag(
              7028,
              1,
              "Unused_label_7028",
              "Unused label.",
              /*reportsUnnecessary*/
              true
            ),
           