/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.references;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsp4e.operations.references.LSSearchResult;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.FileTreeContentProvider;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;

public class FileAndURIMatchContentProvider
implements ITreeContentProvider {
    private final FileTreeContentProvider delegate;
    private LSSearchResult searchResult;
    private FileSearchResult filteredFileSearchResult;

    FileAndURIMatchContentProvider(FileTreeContentProvider delegate) {
        this.delegate = delegate;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        FileSearchResult initial;
        ISearchQuery iSearchQuery;
        if (newInput instanceof FileSearchResult && (iSearchQuery = (initial = (FileSearchResult)newInput).getQuery()) instanceof FileSearchQuery) {
            FileSearchQuery query = (FileSearchQuery)iSearchQuery;
            this.filteredFileSearchResult = new FileSearchResult(query);
            Arrays.stream(initial.getElements()).flatMap(element -> Arrays.stream(initial.getMatches(element))).filter(FileMatch.class::isInstance).forEach(arg_0 -> ((FileSearchResult)this.filteredFileSearchResult).addMatch(arg_0));
            this.delegate.inputChanged(viewer, oldInput, (Object)this.filteredFileSearchResult);
        }
        if (newInput instanceof LSSearchResult) {
            LSSearchResult searchResult;
            this.searchResult = searchResult = (LSSearchResult)((Object)newInput);
        }
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Object> res = new ArrayList<Object>();
        res.addAll(Arrays.asList(this.delegate.getElements(inputElement == this.searchResult ? this.filteredFileSearchResult : inputElement)));
        if (inputElement instanceof AbstractTextSearchResult) {
            AbstractTextSearchResult searchResult = (AbstractTextSearchResult)inputElement;
            res.addAll(Arrays.stream(searchResult.getElements()).filter(URI.class::isInstance).toList());
        }
        return res.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof URI && this.searchResult != null) {
            return this.searchResult.getMatches(parentElement);
        }
        return this.delegate.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.delegate.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return this.delegate.hasChildren(element) || Arrays.asList(this.searchResult.getElements()).contains(element);
    }
}

