/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.enablement;

import java.net.URI;
import java.util.function.Supplier;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;

public final class EnablementTester {
    private final Expression expression;
    private final String description;
    private final Supplier<IEvaluationContext> parent;

    public EnablementTester(Expression expression, String description) {
        this(() -> null, expression, description);
    }

    public EnablementTester(Supplier<IEvaluationContext> parent, Expression expression, String description) {
        this.description = description;
        this.expression = expression;
        this.parent = parent;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean evaluate(URI uri) {
        boolean temporaryLoadDocument = false;
        IResource resource = null;
        try {
            IDocument document = null;
            resource = LSPEclipseUtils.findResourceFor(uri);
            if (resource != null && (document = LSPEclipseUtils.getExistingDocument(resource)) == null) {
                document = LSPEclipseUtils.getDocument(resource);
                temporaryLoadDocument = true;
            }
            if (document == null) {
                temporaryLoadDocument = false;
            }
            EvaluationContext context = new EvaluationContext(this.parent.get(), new Object());
            context.addVariable("document", document != null ? document : IEvaluationContext.UNDEFINED_VARIABLE);
            context.addVariable("resource", resource != null ? resource : IEvaluationContext.UNDEFINED_VARIABLE);
            context.addVariable("uri", uri != null ? uri : IEvaluationContext.UNDEFINED_VARIABLE);
            context.setAllowPluginActivation(true);
            boolean bl = this.expression.evaluate((IEvaluationContext)context).equals(EvaluationResult.TRUE);
            return bl;
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError("Error occured during evaluation of enablement expression", e);
        }
        finally {
            if (temporaryLoadDocument && resource != null) {
                try {
                    FileBuffers.getTextFileBufferManager().disconnect(resource.getFullPath(), LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
        return false;
    }
}

