/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.debug.internal.core.IInternalDebugCoreConstants;
import org.eclipse.debug.internal.core.Preferences;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.server.StreamConnectionProvider;

public class LaunchConfigurationStreamProvider
implements StreamConnectionProvider,
IAdaptable {
    private StreamProxyInputStream inputStream;
    private StreamProxyInputStream errorStream;
    private OutputStream outputStream;
    private ILaunch launch;
    private IProcess process;
    private final ILaunchConfiguration launchConfiguration;
    private Set<String> launchModes;

    public LaunchConfigurationStreamProvider(ILaunchConfiguration launchConfig, Set<String> launchModes) {
        Assert.isNotNull((Object)launchConfig);
        this.launchConfiguration = launchConfig;
        this.launchModes = launchModes != null ? launchModes : Collections.singleton("run");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LaunchConfigurationStreamProvider) {
            LaunchConfigurationStreamProvider other = (LaunchConfigurationStreamProvider)obj;
            if (this.launchConfiguration.equals(other.launchConfiguration) && this.launchModes.equals(other.launchModes)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.launchConfiguration.hashCode() ^ this.launchModes.hashCode();
    }

    public static ILaunchConfiguration findLaunchConfiguration(String typeId, String name) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(typeId);
        ILaunchConfiguration res = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations(type);
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration launch = iLaunchConfigurationArray[n2];
                if (launch.getName().equals(name)) {
                    res = launch;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
        }
        return res;
    }

    @Override
    public void start() throws IOException {
        block12: {
            boolean statusHandlerToUpdate = this.disableStatusHandler();
            try {
                try {
                    this.launch = this.launchConfiguration.launch(this.launchModes.iterator().next(), (IProgressMonitor)new NullProgressMonitor(), false);
                    long initialTimestamp = System.currentTimeMillis();
                    while (this.launch.getProcesses().length == 0 && System.currentTimeMillis() - initialTimestamp < 5000L) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            LanguageServerPlugin.logError(e);
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (this.launch.getProcesses().length <= 0) break block12;
                    this.process = this.launch.getProcesses()[0];
                    this.inputStream = new StreamProxyInputStream(this.process);
                    this.process.getStreamsProxy().getOutputStreamMonitor().addListener((IStreamListener)this.inputStream);
                    try {
                        Method systemProcessGetter = RuntimeProcess.class.getDeclaredMethod("getSystemProcess", new Class[0]);
                        systemProcessGetter.setAccessible(true);
                        Process systemProcess = (Process)systemProcessGetter.invoke((Object)this.process, new Object[0]);
                        this.outputStream = systemProcess.getOutputStream();
                    }
                    catch (ReflectiveOperationException ex) {
                        LanguageServerPlugin.logError(ex);
                    }
                    this.errorStream = new StreamProxyInputStream(this.process);
                    this.process.getStreamsProxy().getErrorStreamMonitor().addListener((IStreamListener)this.errorStream);
                }
                catch (Exception e) {
                    LanguageServerPlugin.logError(e);
                    if (statusHandlerToUpdate) {
                        this.setStatusHandler(true);
                    }
                }
            }
            finally {
                if (statusHandlerToUpdate) {
                    this.setStatusHandler(true);
                }
            }
        }
    }

    private boolean disableStatusHandler() {
        boolean enabled = Platform.getPreferencesService().getBoolean(DebugPlugin.getUniqueIdentifier(), IInternalDebugCoreConstants.PREF_ENABLE_STATUS_HANDLERS, false, null);
        if (enabled) {
            this.setStatusHandler(false);
        }
        return enabled;
    }

    private void setStatusHandler(boolean enabled) {
        Preferences.setBoolean((String)DebugPlugin.getUniqueIdentifier(), (String)IInternalDebugCoreConstants.PREF_ENABLE_STATUS_HANDLERS, (boolean)enabled, null);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ProcessHandle.class) {
            return (T)this.process.getAdapter(adapter);
        }
        return null;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.errorStream;
    }

    @Override
    public void stop() {
        if (this.launch == null) {
            return;
        }
        try {
            this.launch.terminate();
            IProcess[] iProcessArray = this.launch.getProcesses();
            int n = iProcessArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess p = iProcessArray[n2];
                p.terminate();
                ++n2;
            }
        }
        catch (DebugException e1) {
            LanguageServerPlugin.logError(e1);
        }
        this.launch = null;
        this.process = null;
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            LanguageServerPlugin.logError(e);
        }
        try {
            if (this.errorStream != null) {
                this.errorStream.close();
            }
        }
        catch (IOException e) {
            LanguageServerPlugin.logError(e);
        }
        this.inputStream = null;
        this.outputStream = null;
        this.errorStream = null;
    }

    protected static class StreamProxyInputStream
    extends InputStream
    implements IStreamListener {
        private final ConcurrentLinkedQueue<Byte> queue = new ConcurrentLinkedQueue();
        private final IProcess process;

        public StreamProxyInputStream(IProcess process) {
            this.process = process;
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            byte[] bytes = text.getBytes(Charset.defaultCharset());
            ArrayList<Byte> bytesAsList = new ArrayList<Byte>(bytes.length);
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                bytesAsList.add(b);
                ++n2;
            }
            this.queue.addAll(bytesAsList);
        }

        @Override
        public int read() throws IOException {
            while (this.queue.isEmpty()) {
                if (this.process.isTerminated()) {
                    return -1;
                }
                try {
                    Thread.sleep(5L, 0);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.queue.poll().byteValue();
        }

        @Override
        public int available() throws IOException {
            return this.queue.size();
        }
    }
}

