/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.ui.internal.Trace;

public class TextAction
extends Action {
    protected Display display;
    protected Clipboard clipboard;
    protected byte type;
    public static final byte CUT_ACTION = 0;
    public static final byte COPY_ACTION = 1;
    public static final byte PASTE_ACTION = 2;

    protected TextAction(Display display, byte type) {
        super("Text action: " + type);
        this.display = display;
        this.clipboard = new Clipboard(display);
        this.type = type;
    }

    protected Control getControl() {
        Control control = this.display.getFocusControl();
        return control;
    }

    protected Point getControlSelection() {
        Control control = this.getControl();
        if (control == null) {
            return null;
        }
        if (control instanceof Text) {
            Text text = (Text)control;
            return text.getSelection();
        }
        if (control instanceof Combo) {
            Combo combo = (Combo)control;
            return combo.getSelection();
        }
        return null;
    }

    protected void setControlSelection(Point sel) {
        Control control = this.getControl();
        if (control == null) {
            return;
        }
        if (control instanceof Text) {
            Text text = (Text)control;
            text.setSelection(sel);
        } else if (control instanceof Combo) {
            Combo combo = (Combo)control;
            combo.setSelection(sel);
        }
    }

    protected String getControlText() {
        Control control = this.getControl();
        if (control == null) {
            return null;
        }
        if (control instanceof Text) {
            Text text = (Text)control;
            return text.getText();
        }
        if (control instanceof Combo) {
            Combo combo = (Combo)control;
            return combo.getText();
        }
        return null;
    }

    protected void setControlText(String text) {
        Control control = this.getControl();
        if (control == null) {
            return;
        }
        if (control instanceof Text) {
            Text text2 = (Text)control;
            text2.setText(text);
        } else if (control instanceof Combo) {
            Combo combo = (Combo)control;
            combo.setText(text);
        }
    }

    public void copy() {
        Text textcontrol;
        Point selection = this.getControlSelection();
        Control control = this.getControl();
        if (control == null) {
            return;
        }
        if (control instanceof Text && ((textcontrol = (Text)control).getStyle() & 0x400000) != 0) {
            return;
        }
        String text = this.getControlText();
        if (selection == null || text == null) {
            return;
        }
        int length = selection.y - selection.x;
        if (length > 0) {
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.clipboard.setContents((Object[])new String[]{text.substring(selection.x, selection.y)}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError sWTError) {}
        }
    }

    public void cut() {
        Text textcontrol;
        Point selection = this.getControlSelection();
        if (selection == null) {
            return;
        }
        Control control = this.getControl();
        if (control == null) {
            return;
        }
        if (control instanceof Text && ((textcontrol = (Text)control).getStyle() & 0x400000) != 0) {
            return;
        }
        if (selection.y > selection.x) {
            this.copy();
            this.delete();
        }
    }

    public void delete() {
        Point selection = this.getControlSelection();
        String text = this.getControlText();
        if (selection == null || text == null) {
            return;
        }
        if (selection.x != selection.y) {
            text = String.valueOf(text.substring(0, selection.x)) + text.substring(selection.y);
            this.setControlText(text);
            this.setControlSelection(new Point(selection.x, selection.x));
        }
    }

    public void paste() {
        TextTransfer transfer = TextTransfer.getInstance();
        Point selection = this.getControlSelection();
        String text = this.getControlText();
        if (selection == null) {
            return;
        }
        String newText = (String)this.clipboard.getContents((Transfer)transfer);
        if (newText != null && newText.length() > 0) {
            text = text == null ? newText : String.valueOf(text.substring(0, selection.x)) + newText + text.substring(selection.y);
            this.setControlText(text);
            int x = selection.x + newText.length();
            this.setControlSelection(new Point(x, x));
        }
    }

    public void run() {
        if (this.display == null) {
            return;
        }
        if (this.type == 0) {
            this.cut();
        } else if (this.type == 1) {
            this.copy();
        } else if (this.type == 2) {
            this.paste();
        }
    }

    protected void update() {
        block11: {
            if (this.getControl() == null) {
                this.setEnabled(false);
                return;
            }
            Point selection = this.getControlSelection();
            String text = this.getControlText();
            try {
                if (this.type == 0) {
                    this.setEnabled(text != null && text.length() > 0 && selection != null && selection.x < selection.y);
                } else if (this.type == 1) {
                    this.setEnabled(text != null && text.length() > 0 && selection != null && selection.x < selection.y);
                } else if (this.type == 2) {
                    Control control = this.getControl();
                    if (!control.isEnabled()) {
                        this.setEnabled(false);
                        return;
                    }
                    if (!(control instanceof Text)) {
                        this.setEnabled(false);
                        return;
                    }
                    Text text2 = (Text)control;
                    if (!text2.getEditable()) {
                        this.setEnabled(false);
                        return;
                    }
                    TextTransfer transfer = TextTransfer.getInstance();
                    String newText = (String)this.clipboard.getContents((Transfer)transfer);
                    this.setEnabled(newText != null && newText.length() > 0);
                }
            }
            catch (Exception e) {
                if (!Trace.SEVERE) break block11;
                Trace.trace("/severe", "Error updating text action", e);
            }
        }
    }
}

