/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.Trace;

public class ServerPropertyPage
extends PropertyPage {
    protected IServer server;
    protected IServer defaultServer;

    protected Control createContents(Composite parent) {
        try {
            IAdaptable element = this.getElement();
            this.server = (IServer)element.getAdapter(IServer.class);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 3;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
            whs.setHelp((Control)composite, "org.eclipse.wst.server.ui.svcp0004");
            Label label = new Label(composite, 0);
            label.setText(Messages.propServerInfoName);
            label = new Label(composite, 0);
            label.setText(this.server.getName());
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
            label = new Label(composite, 0);
            label.setText(Messages.propServerInfoType);
            IServerType serverType = this.server.getServerType();
            label = new Label(composite, 0);
            if (serverType != null) {
                label.setText(serverType.getName());
            } else {
                label.setText(Messages.elementUnknownName);
            }
            data = new GridData(768);
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
            label = new Label(composite, 0);
            label.setText(Messages.propServerInfoVendor);
            IRuntimeType runtimeType = null;
            if (serverType != null) {
                runtimeType = serverType.getRuntimeType();
            }
            label = new Label(composite, 0);
            if (runtimeType != null) {
                label.setText(runtimeType.getVendor());
            } else {
                label.setText(Messages.elementUnknownName);
            }
            data = new GridData(768);
            data.horizontalSpan = 2;
            label.setLayoutData((Object)data);
            label = new Label(composite, 0);
            label.setText(Messages.switchServerLocation);
            label.setLayoutData((Object)new GridData(258));
            final Label serverLocation = new Label(composite, 0);
            final Server svr = (Server)this.server;
            if (svr.getFile() != null) {
                serverLocation.setText(svr.getFile().getFullPath().toPortableString());
            } else {
                serverLocation.setText(Messages.switchServerLocationMetadata);
            }
            serverLocation.setLayoutData((Object)new GridData(770));
            Button switchLocation = new Button(composite, 8);
            switchLocation.setText(Messages.actionSwitchServerLocation);
            switchLocation.setLayoutData((Object)new GridData(128));
            switchLocation.setEnabled(!this.server.isReadOnly());
            switchLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    block4: {
                        try {
                            Server.switchLocation((Server)svr, null);
                        }
                        catch (CoreException ce) {
                            if (!Trace.SEVERE) break block4;
                            Trace.trace("/severe", "Error switching server location", ce);
                        }
                    }
                    if (svr.getFile() != null) {
                        serverLocation.setText(svr.getFile().getFullPath().toPortableString());
                    } else {
                        serverLocation.setText(Messages.switchServerLocationMetadata);
                    }
                }
            });
            Dialog.applyDialogFont((Control)composite);
            return composite;
        }
        catch (Exception e) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Error creating property page", e);
            }
            return null;
        }
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        return super.performOk();
    }
}

