/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.twiki.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.HeadingAttributes;
import org.eclipse.mylyn.wikitext.parser.markup.Block;

public class HeadingBlock
extends Block {
    private static final Pattern startPattern = Pattern.compile("---(\\+{1,6})\\s*(!!\\s*)?(.*)");
    private Matcher matcher;

    public int processLineContent(String line, int offset) {
        offset = this.matcher.start(3);
        int level = this.matcher.group(1).length();
        String bangEscape = this.matcher.group(2);
        boolean omitFromToc = false;
        if (bangEscape != null && bangEscape.length() > 0) {
            omitFromToc = true;
        }
        if (offset > 0 && level > 0) {
            HeadingAttributes attributes = new HeadingAttributes();
            attributes.setOmitFromTableOfContents(omitFromToc);
            attributes.setId(this.state.getIdGenerator().newId("h" + level, line.substring(offset)));
            this.builder.beginHeading(level, (Attributes)attributes);
            this.builder.characters(line.substring(offset).trim());
            this.builder.endHeading();
        }
        this.setClosed(true);
        return -1;
    }

    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }
}

