/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.discovery;

import org.eclipse.epp.internal.mpc.ui.Messages;
import org.eclipse.equinox.internal.p2.ui.discovery.DiscoveryImages;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ShowFileSupportProposalsDialog
extends TitleAreaDialog {
    private final String fileExtensionLabel;
    private final IEditorDescriptor currentEditor;
    private Button showProposalsRadio;
    private Button associateRadio;
    private boolean showProposals;
    private boolean associate;
    private Image wizban;

    protected ShowFileSupportProposalsDialog(Shell shell, String fileExtensionLabel, IEditorDescriptor currentEditor) {
        super(shell);
        this.fileExtensionLabel = fileExtensionLabel;
        this.currentEditor = currentEditor;
        this.setHelpAvailable(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.MarketplaceOrAssociateDialog_title);
    }

    public Control createDialogArea(Composite parent) {
        this.setTitle(Messages.MarketplaceOrAssociateDialog_title);
        this.setMessage(NLS.bind((String)Messages.MarketplaceOrAssociateDialog_message, (Object)this.fileExtensionLabel));
        this.wizban = DiscoveryImages.BANNER_DISOVERY.createImage();
        this.setTitleImage(this.wizban);
        Composite res = new Composite(parent, 0);
        GridData resGridData = GridDataFactory.fillDefaults().grab(true, true).hint(-1, -1).create();
        res.setLayoutData((Object)resGridData);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).equalWidth(false).applyTo(res);
        Label label = new Label(res, 64);
        label.setText(this.createDescription());
        GridData labelGridData = GridDataFactory.swtDefaults().align(4, 128).grab(true, false).create();
        label.setLayoutData((Object)labelGridData);
        this.showProposalsRadio = new Button(res, 16);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).indent(0, LayoutConstants.getMargins().y).applyTo((Control)this.showProposalsRadio);
        this.showProposalsRadio.setText(Messages.MarketplaceOrAssociateDialog_showProposals);
        this.showProposalsRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowFileSupportProposalsDialog.this.updateSelection();
            }
        });
        this.associateRadio = new Button(res, 16);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).applyTo((Control)this.associateRadio);
        this.associateRadio.setText(NLS.bind((String)Messages.MarketplaceOrAssociateDialog_associate, (Object)this.fileExtensionLabel, (Object)this.currentEditor.getLabel()));
        this.associateRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowFileSupportProposalsDialog.this.updateSelection();
            }
        });
        Link linkToPreferences = new Link(res, 0);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, true).indent(0, LayoutConstants.getMargins().y).applyTo((Control)linkToPreferences);
        linkToPreferences.setText(Messages.MarketplaceOrAssociateDialog_linkToPreferences);
        linkToPreferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog pref = PreferencesUtil.createPreferenceDialogOn((Shell)ShowFileSupportProposalsDialog.this.getShell(), (String)"org.eclipse.ui.preferencePages.FileEditors", null, null);
                pref.setBlockOnOpen(false);
                if (pref != null) {
                    pref.open();
                }
            }
        });
        Point hint = res.computeSize(0, -1);
        labelGridData.widthHint = hint.x + 20;
        labelGridData.heightHint = -1;
        hint = res.computeSize(-1, -1);
        resGridData.widthHint = hint.x;
        resGridData.heightHint = -1;
        this.showProposalsRadio.setSelection(true);
        this.updateSelection();
        return res;
    }

    private String createDescription() {
        String editorId;
        String string = editorId = this.currentEditor == null ? null : this.currentEditor.getId();
        if ("org.eclipse.ui.systemInPlaceEditor".equals(editorId)) {
            return NLS.bind((String)Messages.MarketplaceOrAssociateDialog_descriptionEmbeddedSystemEditor, (Object)this.fileExtensionLabel);
        }
        if ("org.eclipse.ui.systemExternalEditor".equals(editorId)) {
            return NLS.bind((String)Messages.MarketplaceOrAssociateDialog_descriptionExternalSystemEditor, (Object)this.fileExtensionLabel);
        }
        if ("org.eclipse.ui.DefaultTextEditor".equals(editorId)) {
            return NLS.bind((String)Messages.MarketplaceOrAssociateDialog_descriptionSimpleTextEditor, (Object)this.fileExtensionLabel);
        }
        return NLS.bind((String)Messages.MarketplaceOrAssociateDialog_message, (Object)this.fileExtensionLabel);
    }

    private void updateSelection() {
        this.showProposals = this.showProposalsRadio.getSelection();
        this.associate = this.associateRadio.getSelection();
    }

    public boolean close() {
        if (super.close()) {
            this.wizban.dispose();
        }
        return false;
    }

    public boolean isShowProposals() {
        return this.showProposals;
    }

    public boolean isAssociateToExtension() {
        return this.associate;
    }
}

