/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.model;

import org.eclipse.rse.core.events.ISystemRemoteChangeEvent;
import org.eclipse.rse.core.events.ISystemRemoteChangeListener;

public class SystemRemoteChangeEventManager {
    private ISystemRemoteChangeListener[] listeners = new ISystemRemoteChangeListener[0];
    private Object lockObject = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRegisteredSystemRemoteChangeListener(ISystemRemoteChangeListener l) {
        Object object = this.lockObject;
        synchronized (object) {
            int i = 0;
            while (true) {
                if (i >= this.listeners.length) {
                    return false;
                }
                if (this.listeners[i].equals(l)) {
                    return true;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemRemoteChangeListener(ISystemRemoteChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (!this.isRegisteredSystemRemoteChangeListener(l)) {
                int len = this.listeners.length;
                ISystemRemoteChangeListener[] oldListeners = this.listeners;
                this.listeners = new ISystemRemoteChangeListener[len + 1];
                System.arraycopy(oldListeners, 0, this.listeners, 0, len);
                this.listeners[len] = l;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSystemRemoteChangeListener(ISystemRemoteChangeListener l) {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.isRegisteredSystemRemoteChangeListener(l)) {
                int len = this.listeners.length;
                ISystemRemoteChangeListener[] oldListeners = this.listeners;
                this.listeners = new ISystemRemoteChangeListener[len - 1];
                int i = 0;
                int j = 0;
                while (i < len) {
                    if (!oldListeners[i].equals(l)) {
                        this.listeners[j++] = oldListeners[i];
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(ISystemRemoteChangeEvent event) {
        ISystemRemoteChangeListener[] currentListeners;
        Object object = this.lockObject;
        synchronized (object) {
            currentListeners = this.listeners;
        }
        int idx = 0;
        while (idx < currentListeners.length) {
            currentListeners[idx].systemRemoteResourceChanged(event);
            ++idx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        boolean result = false;
        Object object = this.lockObject;
        synchronized (object) {
            result = this.listeners.length > 0;
        }
        return result;
    }
}

