/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.security;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.internal.dstore.security.UniversalSecurityPlugin;
import org.eclipse.swt.graphics.Image;

public class ImageRegistry {
    private static URL fgIconBaseURL = null;
    public static final String T_OBJ = "obj16";
    public static final String T_WIZBAN = "wizban";
    public static final String IMG_CERTIF_FILE = "certif_file.gif";
    public static final String IMG_WZ_IMPORT_CERTIF = "import_cert_wiz.gif";
    public static final ImageDescriptor DESC_IMG_CERTIF_FILE;
    public static final ImageDescriptor DESC_IMG_WZ_IMPORT_CERTIF;
    protected static HashMap _images;
    protected static HashMap _imageDescriptors;

    static {
        try {
            fgIconBaseURL = new URL(UniversalSecurityPlugin.getDefault().getBundle().getEntry("/"), "icons/full/");
        }
        catch (MalformedURLException e) {
            UniversalSecurityPlugin.getDefault().log(e);
        }
        DESC_IMG_CERTIF_FILE = ImageRegistry.createManaged(T_OBJ, IMG_CERTIF_FILE);
        DESC_IMG_WZ_IMPORT_CERTIF = ImageRegistry.createManaged(T_WIZBAN, IMG_WZ_IMPORT_CERTIF);
    }

    public static Image getImage(String name) {
        return (Image)_images.get(name);
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return (ImageDescriptor)_imageDescriptors.get(name);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)ImageRegistry.makeIconFileURL(prefix, name));
            if (_images == null || _imageDescriptors == null) {
                _images = new HashMap();
                _imageDescriptors = new HashMap();
            }
            _imageDescriptors.put(name, result);
            _images.put(name, result.createImage());
            return result;
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id2;
        try {
            id2 = ImageDescriptor.createFromURL((URL)ImageRegistry.makeIconFileURL("d" + type, relPath));
            if (id2 != null) {
                action.setDisabledImageDescriptor(id2);
            }
        }
        catch (MalformedURLException id2) {
            // empty catch block
        }
        try {
            id2 = ImageDescriptor.createFromURL((URL)ImageRegistry.makeIconFileURL("c" + type, relPath));
            if (id2 != null) {
                action.setHoverImageDescriptor(id2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        action.setImageDescriptor(ImageRegistry.create("e" + type, relPath));
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        StringBuffer buffer;
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        if (prefix != null) {
            buffer = new StringBuffer(prefix);
            buffer.append('/');
            buffer.append(name);
        } else {
            buffer = new StringBuffer(name);
        }
        return new URL(fgIconBaseURL, buffer.toString());
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)ImageRegistry.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static void shutdown() {
        if (_images == null) {
            return;
        }
        Iterator e = _images.values().iterator();
        while (e.hasNext()) {
            Object next = e.next();
            if (!(next instanceof Image) || ((Image)next).isDisposed()) continue;
            ((Image)next).dispose();
        }
        _images.clear();
        _images = null;
        _imageDescriptors.clear();
        _imageDescriptors = null;
    }
}

