/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.subsystems;

import java.util.Hashtable;
import java.util.Set;
import org.eclipse.rse.core.model.DummyHost;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IConnectorServiceManager;
import org.eclipse.rse.core.subsystems.ISubSystem;

public abstract class AbstractConnectorServiceManager
implements IConnectorServiceManager {
    private Hashtable systemConnectionRegistry = new Hashtable();

    protected AbstractConnectorServiceManager() {
    }

    public void setConnectorService(IHost host, Class commonSSinterface, IConnectorService connectorService) {
        Hashtable<Class, IConnectorService> connHT = (Hashtable<Class, IConnectorService>)this.systemConnectionRegistry.get(host);
        if (connHT == null) {
            connHT = new Hashtable<Class, IConnectorService>();
            this.systemConnectionRegistry.put(host, connHT);
        }
        connHT.put(commonSSinterface, connectorService);
    }

    public IConnectorService getConnectorService(IHost host, Class commonSSinterface) {
        IConnectorService systemObject;
        Hashtable<Class, IConnectorService> connHT = (Hashtable<Class, IConnectorService>)this.systemConnectionRegistry.get(host);
        if (connHT == null) {
            if (host instanceof DummyHost) {
                connHT = this.findConnHTForDummyHost(host);
            }
            if (connHT == null) {
                connHT = new Hashtable<Class, IConnectorService>();
                this.systemConnectionRegistry.put(host, connHT);
            }
        }
        if ((systemObject = (IConnectorService)connHT.get(commonSSinterface)) == null) {
            systemObject = this.createConnectorService(host);
            connHT.put(commonSSinterface, systemObject);
        } else {
            IHost currentHost = systemObject.getHost();
            if (currentHost instanceof DummyHost && host != currentHost) {
                systemObject.setHost(host);
            }
        }
        return systemObject;
    }

    protected Hashtable findConnHTForDummyHost(IHost newHost) {
        Set keyset = this.systemConnectionRegistry.keySet();
        Object[] keys = keyset.toArray();
        int i = 0;
        while (i < keys.length) {
            IHost host;
            Object key = keys[i];
            if (key instanceof DummyHost && (host = (IHost)key).equals(newHost)) {
                Hashtable table = (Hashtable)this.systemConnectionRegistry.remove(host);
                this.systemConnectionRegistry.put(newHost, table);
                return table;
            }
            ++i;
        }
        return null;
    }

    public abstract IConnectorService createConnectorService(IHost var1);

    public abstract boolean sharesSystem(ISubSystem var1);

    public abstract Class getSubSystemCommonInterface(ISubSystem var1);
}

