/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.html.autoinsert;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.html.HTMLLanguageServerAPI;
import org.eclipse.wildwebdeveloper.html.autoinsert.AutoInsertParams;

public class HTMLAutoInsertReconciler
implements IReconciler {
    private IDocument document;
    private ITextViewer viewer;
    private Listener listener;

    private void autoInsert(DocumentEvent event) {
        boolean autoClosingTag = this.isAutoClosingTagEnabled();
        boolean autoCreateQuotes = this.isAutoCreateQuotesEnabled();
        if (!autoClosingTag && !autoCreateQuotes) {
            return;
        }
        if (event == null || this.viewer == null) {
            return;
        }
        IDocument document = event.getDocument();
        if (document == null || event == null || event.getLength() != 0 || event.getText().length() != 1) {
            return;
        }
        int offset = event.getOffset() + 1;
        char c = event.getText().charAt(0);
        if (c != '>' && c != '/' && c != '=') {
            return;
        }
        URI uri = LSPEclipseUtils.toUri((IDocument)document);
        if (uri == null) {
            return;
        }
        AutoInsertParams.AutoInsertKind autoInsertKind = c == '=' ? AutoInsertParams.AutoInsertKind.autoQuote : AutoInsertParams.AutoInsertKind.autoClose;
        switch (autoInsertKind) {
            case autoClose: {
                if (autoClosingTag) break;
                return;
            }
            case autoQuote: {
                if (autoCreateQuotes) break;
                return;
            }
        }
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri.toString());
        LanguageServers.forDocument((IDocument)document).collectAll((w, ls) -> CompletableFuture.completedFuture(ls)).thenAccept(lss -> lss.stream().filter(HTMLLanguageServerAPI.class::isInstance).map(HTMLLanguageServerAPI.class::cast).findAny().ifPresent(info -> {
            Display display = this.viewer.getTextWidget().getDisplay();
            CompletableFuture.supplyAsync(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                }
                try {
                    AutoInsertParams params = new AutoInsertParams();
                    params.setTextDocument(identifier);
                    params.setKind(autoInsertKind.name());
                    params.setPosition(LSPEclipseUtils.toPosition((int)offset, (IDocument)document));
                    info.autoInsert(params).thenAccept(r -> {
                        if (r != null) {
                            display.asyncExec(() -> {
                                try {
                                    String text = r.replace("$0", "").replace("$1", "");
                                    int index = r.indexOf("$1");
                                    int replaceLength = 0;
                                    document.replace(offset, replaceLength, text);
                                    if (index != -1) {
                                        this.viewer.setSelectedRange(offset + index, 0);
                                    }
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            });
                        }
                    });
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return null;
            });
        }));
    }

    private boolean isAutoClosingTagEnabled() {
        return Activator.getDefault().getPreferenceStore().getBoolean("wildwebdeveloper.html.autoClosingTags");
    }

    private boolean isAutoCreateQuotesEnabled() {
        return Activator.getDefault().getPreferenceStore().getBoolean("wildwebdeveloper.html.autoCreateQuotes");
    }

    public void install(ITextViewer viewer) {
        this.viewer = viewer;
        this.listener = new Listener();
        viewer.addTextInputListener((ITextInputListener)this.listener);
    }

    public void uninstall() {
        if (this.listener != null) {
            this.viewer.removeTextInputListener((ITextInputListener)this.listener);
            if (this.document != null) {
                this.document.removeDocumentListener((IDocumentListener)this.listener);
            }
            this.listener = null;
        }
        this.viewer = null;
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return null;
    }

    class Listener
    implements IDocumentListener,
    ITextInputListener {
        Listener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            HTMLAutoInsertReconciler.this.autoInsert(e);
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == HTMLAutoInsertReconciler.this.document) {
                if (HTMLAutoInsertReconciler.this.document != null) {
                    HTMLAutoInsertReconciler.this.document.removeDocumentListener((IDocumentListener)this);
                }
                HTMLAutoInsertReconciler.this.document = null;
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            HTMLAutoInsertReconciler.this.document = newInput;
            if (HTMLAutoInsertReconciler.this.document == null) {
                return;
            }
            HTMLAutoInsertReconciler.this.document.addDocumentListener((IDocumentListener)this);
        }
    }
}

