/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.EditorSelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.LargeFileLimitsPreferenceHandler;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.DialogUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;

public class LargeFileAssociationsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private static final String DATA_EDITOR = "editor";
    private static final String DATA_PROMPT = "prompt";
    private static final String DIALOG_PROMPT_EDITOR_TABLE_TEXT = IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_EditorTable_DialogPrompt;
    private static final int EDITOR_TABLE_CELL_INDEX_EDITOR = 0;
    private static final int EDITOR_TABLE_CELL_INDEX_SIZE = 1;
    private static final String[] SIZE_UNITS = new String[]{"B", "KB", "MB", "GB"};
    private static final int MEGABYTE_UNIT_INDEX = 2;
    private static final long B = 1L;
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long[] SIZE_MULTIPLIERS = new long[]{1L, 1024L, 0x100000L, 0x40000000L};
    private static final String SIZE_TEXT_PREFIX = "> ";
    private static final int DEFAULT_SIZE_UNIT = 2;
    private static final Comparator<EditorForSize> EDITOR_COMPARATOR = LargeFileAssociationsPreferencePage::compareEditors;
    private Table resourceTypeTable;
    private Button addResourceTypeButton;
    private Button removeResourceTypeButton;
    private Table editorTable;
    private Button addEditorButton;
    private Button editEditorButton;
    private Button removeEditorButton;
    private Button enableDefaultPreference;
    private Text defaultPreferenceFileSize;
    private Combo defaultPreferenceUnit;
    private Label editorLabel;
    private IWorkbench workbench;
    private List<Image> imagesToDispose;
    private Map<IEditorDescriptor, Image> editorsToImages;

    public void addResourceType(String newExtension) {
        LargeFileAssociation association;
        Assert.isTrue((newExtension != null && newExtension.length() != 0 ? 1 : 0) != 0);
        TableItem[] items = this.resourceTypeTable.getItems();
        boolean found = false;
        int i = 0;
        while (i < items.length && !found) {
            association = (LargeFileAssociation)items[i].getData();
            int result = newExtension.compareToIgnoreCase(association.extension);
            if (result == 0) {
                MessageBox msgBox = new MessageBox(this.getShell(), 34);
                msgBox.setMessage(WorkbenchMessages.FileEditorPreference_existsMessage);
                msgBox.setText(WorkbenchMessages.FileEditorPreference_existsTitle);
                msgBox.open();
                return;
            }
            if (result < 0) {
                found = true;
                continue;
            }
            ++i;
        }
        association = new LargeFileAssociation(newExtension);
        EditorForSize defaultPromptEditor = LargeFileAssociationsPreferencePage.defaultPromptEditor();
        association.addEditor(defaultPromptEditor);
        TableItem item = this.newResourceTableItem(association, i, true);
        this.resourceTypeTable.setFocus();
        this.resourceTypeTable.showItem(item);
        this.fillEditorTable();
    }

    protected Control createContents(Composite parent) {
        boolean isLegacyPreferenceSet = LargeFileLimitsPreferenceHandler.isLargeDocumentLegacyPreferenceSet();
        Composite pageComponent = new Composite(parent, 0);
        if (isLegacyPreferenceSet) {
            LargeFileAssociationsPreferencePage.createDisabledPreferencePageContents(pageComponent);
        } else {
            this.createPreferencePageContents(pageComponent);
        }
        this.workbench.getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.large_file_associations_preference_page_context");
        return pageComponent;
    }

    private static void createDisabledPreferencePageContents(Composite pageComponent) {
        pageComponent.setLayout((Layout)new FillLayout());
        String disabledPageText = NLS.bind((String)IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_DisabledPageText, (Object)"LARGE_DOC_SIZE_FOR_EDITORS");
        Label legacyPreferenceSetLabel = new Label(pageComponent, 0);
        legacyPreferenceSetLabel.setText(disabledPageText);
    }

    private void createPreferencePageContents(Composite pageComponent) {
        this.imagesToDispose = new ArrayList<Image>();
        this.editorsToImages = new HashMap<IEditorDescriptor, Image>(50);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pageComponent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        pageComponent.setLayoutData((Object)data);
        Group defaultLimitGroup = new Group(pageComponent, 0);
        defaultLimitGroup.setText(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_DefaultLimitGroup_Label);
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupLayout.numColumns = 3;
        defaultLimitGroup.setLayout((Layout)groupLayout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        defaultLimitGroup.setLayoutData((Object)data);
        this.enableDefaultPreference = new Button((Composite)defaultLimitGroup, 32);
        this.enableDefaultPreference.setText(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_DefaultPreference_Label);
        this.defaultPreferenceFileSize = LargeFileAssociationsPreferencePage.createFileSizeText((Composite)defaultLimitGroup);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.minimumWidth = 6;
        this.defaultPreferenceFileSize.setLayoutData((Object)data);
        this.defaultPreferenceUnit = LargeFileAssociationsPreferencePage.createSizeUnitCombo((Composite)defaultLimitGroup);
        this.enableDefaultPreference.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LargeFileAssociationsPreferencePage.this.updateDefaultPreferenceWidgetsEnabledState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LargeFileAssociationsPreferencePage.this.updateDefaultPreferenceWidgetsEnabledState();
            }
        });
        this.setDefaultPreferenceWidgetValues();
        Label label = new Label(pageComponent, 16384);
        label.setText(WorkbenchMessages.FileEditorPreference_fileTypes);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.resourceTypeTable = new Table(pageComponent, 67618);
        this.resourceTypeTable.addListener(13, (Listener)this);
        this.resourceTypeTable.addListener(14, (Listener)this);
        data = new GridData(768);
        int availableRows = DialogUtil.availableRows((Composite)pageComponent);
        data.heightHint = this.resourceTypeTable.getItemHeight() * (availableRows / 16);
        this.resourceTypeTable.setLayoutData((Object)data);
        this.resourceTypeTable.addListener(13, event -> {
            if (event.detail == 32) {
                TableItem item = (TableItem)event.item;
                LargeFileAssociation association = (LargeFileAssociation)item.getData();
                boolean newEnabled = item.getChecked();
                boolean oldEnabled = association.enabled;
                association.enabled = newEnabled;
                if (oldEnabled != newEnabled) {
                    String extensionText = LargeFileAssociationsPreferencePage.getExtensionText(association);
                    item.setText(extensionText);
                    this.fillEditorTable();
                }
            }
        });
        Composite groupComponent = new Composite(pageComponent, 0);
        groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        this.addResourceTypeButton = new Button(groupComponent, 8);
        this.addResourceTypeButton.setText(WorkbenchMessages.FileEditorPreference_add);
        this.addResourceTypeButton.addListener(13, (Listener)this);
        this.setButtonLayoutData(this.addResourceTypeButton);
        this.removeResourceTypeButton = new Button(groupComponent, 8);
        this.removeResourceTypeButton.setText(WorkbenchMessages.FileEditorPreference_remove);
        this.removeResourceTypeButton.addListener(13, (Listener)this);
        this.setButtonLayoutData(this.removeResourceTypeButton);
        label = new Label(pageComponent, 16384);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.editorLabel = new Label(pageComponent, 16384);
        this.editorLabel.setText(WorkbenchMessages.FileEditorPreference_associatedEditors);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        this.editorLabel.setLayoutData((Object)data);
        this.editorTable = new Table(pageComponent, 2050);
        TableColumn editorColumn = new TableColumn(this.editorTable, 0);
        editorColumn.setText(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_ColumnHeader_Editor);
        editorColumn.setWidth(300);
        TableColumn sizeColumn = new TableColumn(this.editorTable, 0);
        sizeColumn.setText(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_ColumnHeader_Size);
        sizeColumn.setWidth(100);
        this.editorTable.addListener(13, (Listener)this);
        this.editorTable.addListener(14, (Listener)this);
        data = new GridData(1808);
        data.heightHint = this.editorTable.getItemHeight() * 7;
        this.editorTable.setLayoutData((Object)data);
        this.editorTable.setHeaderVisible(true);
        groupComponent = new Composite(pageComponent, 0);
        groupLayout = new GridLayout();
        groupLayout.marginWidth = 0;
        groupLayout.marginHeight = 0;
        groupComponent.setLayout((Layout)groupLayout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)data);
        this.addEditorButton = new Button(groupComponent, 8);
        this.addEditorButton.setText(WorkbenchMessages.FileEditorPreference_addEditor);
        this.addEditorButton.addListener(13, (Listener)this);
        this.addEditorButton.setLayoutData((Object)data);
        this.setButtonLayoutData(this.addEditorButton);
        this.editEditorButton = new Button(groupComponent, 8);
        this.editEditorButton.setText(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_EditEditorButton_Label);
        this.editEditorButton.addListener(13, (Listener)this);
        this.editEditorButton.setLayoutData((Object)data);
        this.setButtonLayoutData(this.editEditorButton);
        this.removeEditorButton = new Button(groupComponent, 8);
        this.removeEditorButton.setText(WorkbenchMessages.FileEditorPreference_removeEditor);
        this.removeEditorButton.addListener(13, (Listener)this);
        this.setButtonLayoutData(this.removeEditorButton);
        this.fillResourceTypeTable();
        if (this.resourceTypeTable.getItemCount() > 0) {
            this.resourceTypeTable.setSelection(0);
        }
        this.fillEditorTable();
        this.updateEnabledState();
        this.applyDialogFont(pageComponent);
    }

    private void updateDefaultPreferenceWidgetsEnabledState() {
        boolean enabled = this.enableDefaultPreference.getSelection();
        this.defaultPreferenceFileSize.setEnabled(enabled);
        this.defaultPreferenceUnit.setEnabled(enabled);
    }

    private void setDefaultPreferenceWidgetValues() {
        this.enableDefaultPreference.setSelection(LargeFileLimitsPreferenceHandler.isDefaultLimitEnabled());
        SizeAndUnit sizeAndUnit = LargeFileAssociationsPreferencePage.defaultLimit();
        this.defaultPreferenceFileSize.setText(sizeAndUnit.sizeString);
        this.defaultPreferenceUnit.select(sizeAndUnit.unitIndex);
        this.updateDefaultPreferenceWidgetsEnabledState();
    }

    public void dispose() {
        super.dispose();
        if (this.imagesToDispose != null) {
            for (Image image : this.imagesToDispose) {
                image.dispose();
            }
            this.imagesToDispose = null;
        }
        if (this.editorsToImages != null) {
            for (Image image : this.editorsToImages.values()) {
                image.dispose();
            }
            this.editorsToImages = null;
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    protected void fillEditorTable() {
        this.editorTable.removeAll();
        LargeFileAssociation association = this.getSelectedLargeFileAssociation();
        if (association != null) {
            this.editorTable.setEnabled(association.enabled);
            if (association.enabled) {
                for (EditorForSize editorForSize : association.editors) {
                    String label;
                    TableItem item = new TableItem(this.editorTable, 0);
                    if (editorForSize.isPrompt) {
                        label = DIALOG_PROMPT_EDITOR_TABLE_TEXT;
                        item.setData(DATA_PROMPT, (Object)DATA_PROMPT);
                    } else {
                        label = editorForSize.editor.getLabel();
                        item.setData(DATA_EDITOR, (Object)editorForSize.editor);
                        item.setImage(this.getImage(editorForSize.editor));
                    }
                    String[] text = new String[]{label, LargeFileAssociationsPreferencePage.getSizeText(editorForSize.size)};
                    item.setText(text);
                }
            }
        }
    }

    protected void fillResourceTypeTable() {
        this.resourceTypeTable.removeAll();
        String[] configured = LargeFileLimitsPreferenceHandler.getConfiguredExtensionTypes();
        String[] disabled = LargeFileLimitsPreferenceHandler.getDisabledExtensionTypes();
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.addAll(Arrays.asList(configured));
        extensions.addAll(Arrays.asList(disabled));
        HashSet<String> disabledSet = new HashSet<String>(Arrays.asList(disabled));
        ArrayList<LargeFileAssociation> associations = new ArrayList<LargeFileAssociation>();
        for (String extension : extensions) {
            List fileLimits = LargeFileLimitsPreferenceHandler.getFileLimitsForExtension((String)extension);
            LargeFileAssociation association = new LargeFileAssociation(extension);
            association.enabled = !disabledSet.contains(extension);
            long lowestPromptSize = Long.MAX_VALUE;
            for (LargeFileLimitsPreferenceHandler.FileLimit fileLimit : fileLimits) {
                long newSize;
                long size = fileLimit.fileSize;
                String editorIdString = fileLimit.editorId;
                SizeAndUnit promptSize = null;
                IEditorDescriptor editorDescriptor = this.findEditor(editorIdString);
                if (editorDescriptor != null) {
                    SizeAndUnit sizeAndUnit = LargeFileAssociationsPreferencePage.getSizeAndUnit(size);
                    EditorForSize editorForSize = new EditorForSize(editorDescriptor, sizeAndUnit);
                    association.addEditor(editorForSize);
                } else if (LargeFileLimitsPreferenceHandler.isPromptPreferenceValue((String)editorIdString) && (newSize = Long.valueOf(size).longValue()) < lowestPromptSize) {
                    lowestPromptSize = newSize;
                    promptSize = LargeFileAssociationsPreferencePage.getSizeAndUnit(size);
                }
                if (promptSize == null) continue;
                EditorForSize promptEditor = new EditorForSize(promptSize);
                association.addEditor(promptEditor);
            }
            associations.add(association);
        }
        int index = 0;
        for (LargeFileAssociation association : associations) {
            this.newResourceTableItem(association, index, false);
            ++index;
        }
    }

    protected Image getImage(IEditorDescriptor editor) {
        Image image = this.editorsToImages.get(editor);
        if (image == null) {
            image = editor.getImageDescriptor().createImage();
            this.editorsToImages.put(editor, image);
        }
        return image;
    }

    protected LargeFileAssociation getSelectedLargeFileAssociation() {
        TableItem[] items = this.resourceTypeTable.getSelection();
        if (items.length == 1) {
            return (LargeFileAssociation)items[0].getData();
        }
        return null;
    }

    protected IEditorDescriptor[] getAssociatedEditors() {
        if (this.getSelectedLargeFileAssociation() == null) {
            return null;
        }
        if (this.editorTable.getItemCount() > 0) {
            ArrayList<IEditorDescriptor> editorList = new ArrayList<IEditorDescriptor>();
            int i = 0;
            while (i < this.editorTable.getItemCount()) {
                IEditorDescriptor editorDescriptor = (IEditorDescriptor)this.editorTable.getItem(i).getData(DATA_EDITOR);
                if (editorDescriptor != null) {
                    editorList.add(editorDescriptor);
                }
                ++i;
            }
            return editorList.toArray(new IEditorDescriptor[editorList.size()]);
        }
        return null;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addResourceTypeButton) {
            this.promptForResourceType();
        } else if (event.widget == this.removeResourceTypeButton) {
            this.removeSelectedResourceType();
        } else if (event.widget == this.addEditorButton) {
            this.promptForEditor();
        } else if (event.widget == this.editEditorButton) {
            this.editSelectedEditor();
        } else if (event.widget == this.removeEditorButton) {
            this.removeSelectedEditor();
        } else if (event.widget == this.resourceTypeTable) {
            this.fillEditorTable();
        }
        this.updateEnabledState();
    }

    public void init(IWorkbench aWorkbench) {
        this.workbench = aWorkbench;
    }

    protected TableItem newResourceTableItem(LargeFileAssociation association, int index, boolean selected) {
        Image image;
        IEditorRegistry editorRegistry = this.workbench.getEditorRegistry();
        ImageDescriptor imageDescriptor = editorRegistry.getImageDescriptor("tmp." + association.extension);
        if (imageDescriptor == null) {
            imageDescriptor = LargeFileAssociationsPreferencePage.getImageDescriptor();
        }
        if ((image = imageDescriptor.createImage(false)) != null) {
            this.imagesToDispose.add(image);
        }
        TableItem item = new TableItem(this.resourceTypeTable, 0, index);
        if (image != null) {
            item.setImage(image);
        }
        String extensionText = LargeFileAssociationsPreferencePage.getExtensionText(association);
        item.setText(extensionText);
        item.setChecked(association.enabled);
        item.setData((Object)association);
        if (selected) {
            this.resourceTypeTable.setSelection(index);
        }
        return item;
    }

    public boolean performOk() {
        this.updateDefaultPreference();
        this.updateExtensionPreferences();
        PrefUtil.savePrefs();
        return true;
    }

    public void performDefaults() {
        LargeFileLimitsPreferenceHandler.restoreDefaults();
        this.setDefaultPreferenceWidgetValues();
        this.fillResourceTypeTable();
        this.fillEditorTable();
        this.updateEnabledState();
    }

    private void updateDefaultPreference() {
        boolean isDefaultPreferenceEnabled = this.enableDefaultPreference.getSelection();
        if (isDefaultPreferenceEnabled) {
            SizeAndUnit size = LargeFileAssociationsPreferencePage.getSizeAndUnit(this.defaultPreferenceFileSize, this.defaultPreferenceUnit);
            LargeFileLimitsPreferenceHandler.setDefaultLimit((long)size.bytes);
        } else {
            LargeFileLimitsPreferenceHandler.disableDefaultLimit();
        }
    }

    private void updateExtensionPreferences() {
        TableItem[] items;
        String[] previousConfiguredExtensions = LargeFileLimitsPreferenceHandler.getConfiguredExtensionTypes();
        String[] previousDisabledExtensions = LargeFileLimitsPreferenceHandler.getDisabledExtensionTypes();
        ArrayList<String> configuredExtensions = new ArrayList<String>();
        ArrayList<String> disabledExtensions = new ArrayList<String>();
        ArrayList<String> newExtensions = new ArrayList<String>();
        TableItem[] tableItemArray = items = this.resourceTypeTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            LargeFileAssociation association = (LargeFileAssociation)item.getData();
            String extension = association.extension;
            if (!association.enabled) {
                disabledExtensions.add(extension);
            }
            ArrayList<LargeFileLimitsPreferenceHandler.FileLimit> fileLimits = new ArrayList<LargeFileLimitsPreferenceHandler.FileLimit>();
            for (EditorForSize editorForSize : association.editors) {
                String editorId = editorForSize.isPrompt ? "largeFileLimits_prompt" : editorForSize.editor.getId();
                long fileSize = editorForSize.size.bytes;
                LargeFileLimitsPreferenceHandler.FileLimit fileLimit = new LargeFileLimitsPreferenceHandler.FileLimit(editorId, fileSize);
                fileLimits.add(fileLimit);
            }
            if (!fileLimits.isEmpty()) {
                if (association.enabled) {
                    configuredExtensions.add(extension);
                }
                newExtensions.add(extension);
                LargeFileLimitsPreferenceHandler.setFileLimitsForExtension((String)extension, fileLimits);
            }
            ++n2;
        }
        LargeFileLimitsPreferenceHandler.setConfiguredExtensionTypes((String[])((String[])configuredExtensions.toArray(String[]::new)));
        LargeFileLimitsPreferenceHandler.setDisabledExtensionTypes((String[])((String[])disabledExtensions.toArray(String[]::new)));
        HashSet<String> removedExtensions = new HashSet<String>();
        removedExtensions.addAll(Arrays.asList(previousConfiguredExtensions));
        removedExtensions.addAll(Arrays.asList(previousDisabledExtensions));
        removedExtensions.removeAll(newExtensions);
        for (String removedExtension : removedExtensions) {
            LargeFileLimitsPreferenceHandler.removeFileLimitsForExtension((String)removedExtension);
        }
    }

    public void promptForEditor() {
        String extension;
        EditorForSize initialValues;
        IEditorDescriptor[] filteredEditors = this.getAssociatedEditors();
        long[] configuredFileSizes = this.getConfiguredFileSizes();
        Shell shell = this.getControl().getShell();
        EditorForSizeDialog editorForSizeDialog = new EditorForSizeDialog(shell, filteredEditors, configuredFileSizes, initialValues = LargeFileAssociationsPreferencePage.defaultPromptEditor(), extension = this.getSelectedLargeFileAssociation().extension);
        if (editorForSizeDialog.open() == 0) {
            this.addEditor(editorForSizeDialog.chosenValues);
        }
    }

    void editSelectedEditor() {
        LargeFileAssociation association = this.getSelectedLargeFileAssociation();
        int selectionIndex = this.editorTable.getSelectionIndex();
        TableItem item = this.editorTable.getItem(selectionIndex);
        String editorIdString = item.getText(0);
        boolean promptForEditor = IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_EditorTable_DialogPrompt.equals(editorIdString);
        String sizeString = item.getText(1);
        SizeAndUnit selectedSize = LargeFileAssociationsPreferencePage.parseSizeString(sizeString);
        IEditorDescriptor[] filteredEditors = this.getAssociatedEditors();
        IEditorDescriptor selectedEditor = (IEditorDescriptor)item.getData(DATA_EDITOR);
        if (selectedEditor != null) {
            IEditorDescriptor[] filteredEditorsWithoutSelected = (IEditorDescriptor[])Arrays.stream(filteredEditors).filter(e -> e != selectedEditor).toArray(IEditorDescriptor[]::new);
            filteredEditors = filteredEditorsWithoutSelected;
        }
        long[] configuredFileSizes = this.getConfiguredFileSizes();
        long[] filteredFileSizes = Arrays.stream(configuredFileSizes).filter(l -> l != sizeAndUnit.bytes).toArray();
        EditorForSize initialValues = new EditorForSize(selectedEditor, promptForEditor, selectedSize);
        String extension = this.getSelectedLargeFileAssociation().extension;
        Shell shell = this.getControl().getShell();
        EditorForSizeDialog editorForSizeDialog = new EditorForSizeDialog(shell, filteredEditors, filteredFileSizes, initialValues, extension);
        if (editorForSizeDialog.open() == 0) {
            EditorDescriptor previousEditor = (EditorDescriptor)item.getData(DATA_EDITOR);
            Object promptData = item.getData(DATA_PROMPT);
            if (previousEditor != null) {
                association.removeEditor((IEditorDescriptor)previousEditor);
            } else if (promptData != null) {
                association.removePromptEditor();
            }
            this.editorTable.remove(selectionIndex);
            this.addEditor(editorForSizeDialog.chosenValues);
        }
    }

    private void addEditor(EditorForSize editorForSize) {
        String editorText;
        LargeFileAssociation association = this.getSelectedLargeFileAssociation();
        if (!editorForSize.isPrompt) {
            association.addEditor(editorForSize);
        } else {
            int promptIndex = this.getIndexOfPromptItem();
            if (promptIndex != -1) {
                this.editorTable.remove(promptIndex);
            }
            association.setPromptEditorSize(editorForSize.size);
        }
        int index = association.indexOfEditor(editorForSize);
        TableItem item = index >= this.editorTable.getItemCount() ? new TableItem(this.editorTable, 0) : new TableItem(this.editorTable, 0, index);
        if (!editorForSize.isPrompt) {
            item.setData(DATA_EDITOR, (Object)editorForSize.editor);
            item.setImage(this.getImage(editorForSize.editor));
            editorText = editorForSize.editor.getLabel();
        } else {
            item.setData(DATA_PROMPT, (Object)DATA_PROMPT);
            editorText = DIALOG_PROMPT_EDITOR_TABLE_TEXT;
        }
        String[] text = new String[]{editorText, LargeFileAssociationsPreferencePage.getSizeText(editorForSize.size)};
        item.setText(text);
        this.editorTable.setSelection(index);
        this.editorTable.setFocus();
    }

    private static EditorDescriptor promptForEditorWithDialog(Shell shell, IEditorDescriptor[] filteredEditors, String extension) {
        EditorDescriptor selectedEditor = null;
        EditorSelectionDialog editorSelectionDialog = new EditorSelectionDialog(shell);
        editorSelectionDialog.setEditorsToFilter(filteredEditors);
        editorSelectionDialog.setMessage(NLS.bind((String)WorkbenchMessages.Choose_the_editor_for_file, (Object)extension));
        if (editorSelectionDialog.open() == 0) {
            selectedEditor = (EditorDescriptor)editorSelectionDialog.getSelectedEditor();
        }
        return selectedEditor;
    }

    private IEditorDescriptor findEditor(String editorIdString) {
        IEditorDescriptor editorDescriptor = this.workbench.getEditorRegistry().findEditor(editorIdString);
        return editorDescriptor;
    }

    private int getIndexOfPromptItem() {
        int promptIndex = -1;
        TableItem[] editorTableItems = this.editorTable.getItems();
        int j = 0;
        while (j < editorTableItems.length) {
            TableItem editorTableItem = editorTableItems[j];
            if (editorTableItem.getData(DATA_PROMPT) != null) {
                promptIndex = j;
                break;
            }
            ++j;
        }
        return promptIndex;
    }

    private long[] getConfiguredFileSizes() {
        LargeFileAssociation association = this.getSelectedLargeFileAssociation();
        int numberOfSizes = association.editors.size();
        long[] configuredFileSizes = new long[numberOfSizes];
        int index = 0;
        for (EditorForSize editor : association.editors) {
            configuredFileSizes[index] = editor.size.bytes;
            ++index;
        }
        return configuredFileSizes;
    }

    public void promptForResourceType() {
        ExtensionDialog dialog = new ExtensionDialog(this.getControl().getShell());
        if (dialog.open() == 0) {
            String extension = dialog.getExtension();
            this.addResourceType(extension);
        }
    }

    public void removeSelectedEditor() {
        TableItem[] items = this.editorTable.getSelection();
        if (items.length > 0) {
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                LargeFileAssociation association = this.getSelectedLargeFileAssociation();
                IEditorDescriptor editorDescriptor = (IEditorDescriptor)item.getData(DATA_EDITOR);
                if (editorDescriptor != null) {
                    association.removeEditor(editorDescriptor);
                } else if (item.getData(DATA_PROMPT) != null) {
                    association.removePromptEditor();
                }
                item.dispose();
                ++n2;
            }
        }
        this.editorTable.deselectAll();
    }

    public void removeSelectedResourceType() {
        TableItem[] tableItemArray = this.resourceTypeTable.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.dispose();
            ++n2;
        }
        this.editorTable.removeAll();
    }

    public void updateEnabledState() {
        int selectedResources = this.resourceTypeTable.getSelectionCount();
        this.removeResourceTypeButton.setEnabled(selectedResources != 0);
        this.editorLabel.setEnabled(selectedResources == 1);
        this.addEditorButton.setEnabled(selectedResources == 1);
        int selectedEditors = this.editorTable.getSelectionCount();
        int editorsCount = this.editorTable.getItemCount();
        boolean removeEditorsEnabled = editorsCount > 1 && selectedEditors > 0;
        this.editEditorButton.setEnabled(selectedEditors == 1);
        this.removeEditorButton.setEnabled(removeEditorsEnabled);
    }

    private static ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor((String)"IMG_OBJ_FILE");
    }

    private static String getExtensionText(LargeFileAssociation association) {
        String text = association.extension;
        if (!association.enabled) {
            text = String.valueOf(text) + " " + IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_ExtensionsTable_DisabledClarification;
        }
        return text;
    }

    private static String getSizeText(SizeAndUnit size) {
        String sizeText = SIZE_TEXT_PREFIX + size.sizeString;
        sizeText = String.valueOf(sizeText) + LargeFileAssociationsPreferencePage.getSizeSuffix(size.unitIndex);
        return sizeText;
    }

    private static Text createFileSizeText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.addVerifyListener((VerifyListener)new NumberVerifyListener());
        text.addModifyListener((ModifyListener)new NumberModifyListener());
        text.setText(LargeFileAssociationsPreferencePage.defaultLimit().sizeString);
        return text;
    }

    private static Combo createSizeUnitCombo(Composite parent) {
        Combo sizeUnitCombo = new Combo(parent, 8);
        String[] stringArray = SIZE_UNITS;
        int n = SIZE_UNITS.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            sizeUnitCombo.add(unit);
            ++n2;
        }
        sizeUnitCombo.select(2);
        return sizeUnitCombo;
    }

    private static SizeAndUnit getSizeAndUnit(Text fileSizeText, Combo sizeUnitCombo) {
        String fileSizeString = fileSizeText.getText();
        int sizeUnitSelectionIndex = sizeUnitCombo.getSelectionIndex();
        SizeAndUnit size = new SizeAndUnit(fileSizeString, sizeUnitSelectionIndex);
        return size;
    }

    private static SizeAndUnit getSizeAndUnit(long bytes) {
        long largestSizeMultiplier = 1L;
        int sizeUnitIndex = 0;
        int i = 0;
        while (i < SIZE_UNITS.length) {
            long sizeMultiplier = SIZE_MULTIPLIERS[i];
            if (bytes % sizeMultiplier == 0L && largestSizeMultiplier < sizeMultiplier) {
                largestSizeMultiplier = sizeMultiplier;
                sizeUnitIndex = i;
            }
            ++i;
        }
        long sizeInUnit = bytes / largestSizeMultiplier;
        String sizeString = String.valueOf(sizeInUnit);
        SizeAndUnit sizeAndUnit = new SizeAndUnit(sizeString, sizeUnitIndex);
        return sizeAndUnit;
    }

    private static long computeSize(String sizeString, int unitIndex) {
        long bytesWithoutUnit = Long.valueOf(sizeString);
        long unitMultiplier = SIZE_MULTIPLIERS[unitIndex];
        long size = bytesWithoutUnit * unitMultiplier;
        return size;
    }

    private static SizeAndUnit parseSizeString(String sizeString) {
        if (sizeString.startsWith(SIZE_TEXT_PREFIX)) {
            sizeString = sizeString.substring(SIZE_TEXT_PREFIX.length());
        }
        sizeString = sizeString.strip();
        int unitIndex = 0;
        int i = 0;
        while (i < SIZE_UNITS.length) {
            String sizeSuffix = LargeFileAssociationsPreferencePage.getSizeSuffix(i);
            if (sizeString.endsWith(sizeSuffix)) {
                int newLength = sizeString.length() - sizeSuffix.length();
                sizeString = sizeString.substring(0, newLength);
                unitIndex = i;
                break;
            }
            ++i;
        }
        long sizeMultiplier = SIZE_MULTIPLIERS[unitIndex];
        sizeString = sizeString.strip();
        long size = Long.valueOf(sizeString);
        return new SizeAndUnit(sizeString, unitIndex, size *= sizeMultiplier);
    }

    private static String getSizeSuffix(int unitIndex) {
        return " " + SIZE_UNITS[unitIndex];
    }

    private static int compareEditors(EditorForSize e1, EditorForSize e2) {
        return Long.compare(e1.size.bytes, e2.size.bytes);
    }

    private static EditorForSize defaultPromptEditor() {
        SizeAndUnit size = LargeFileAssociationsPreferencePage.defaultLimit();
        EditorForSize defaultPromptEditor = new EditorForSize(size);
        return defaultPromptEditor;
    }

    private static SizeAndUnit defaultLimit() {
        return LargeFileAssociationsPreferencePage.getSizeAndUnit(LargeFileLimitsPreferenceHandler.getDefaultLimit());
    }

    private static class EditorForSize {
        final IEditorDescriptor editor;
        final boolean isPrompt;
        final SizeAndUnit size;

        EditorForSize(SizeAndUnit size) {
            this(null, true, size);
        }

        EditorForSize(IEditorDescriptor editor, SizeAndUnit size) {
            this(editor, false, size);
        }

        private EditorForSize(IEditorDescriptor editor, boolean isPrompt, SizeAndUnit size) {
            this.editor = editor;
            this.isPrompt = isPrompt;
            this.size = size;
        }
    }

    private static class EditorForSizeDialog
    extends TitleAreaDialog {
        private final long[] filteredFileSizes;
        private final IEditorDescriptor[] filteredEditors;
        private final EditorForSize initialValues;
        private final String extension;
        private Text sizeText;
        private Combo sizeUnitCombo;
        private Button promptEditorOnOpen;
        private Button chooseEditorWithDialog;
        private Button okButton;
        private IEditorDescriptor selectedEditor;
        EditorForSize chosenValues;

        EditorForSizeDialog(Shell shell, IEditorDescriptor[] filteredEditors, long[] filteredFileSizes, EditorForSize initialValues, String extension) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x10000000);
            this.filteredFileSizes = filteredFileSizes;
            this.filteredEditors = filteredEditors;
            this.initialValues = initialValues;
            this.extension = extension;
            this.selectedEditor = initialValues.editor;
            this.chosenValues = initialValues;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_EditorDialog_ShellTitle);
        }

        protected Control createDialogArea(Composite parent) {
            Composite parentComposite = (Composite)super.createDialogArea(parent);
            Composite contents = new Composite(parentComposite, 0);
            contents.setLayoutData((Object)new GridData(4, 4, true, true));
            this.setTitle(NLS.bind((String)IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_EditorDialog_Title, (Object)this.extension));
            this.setMessage(NLS.bind((String)IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_EditorDialog_Message, (Object)this.extension));
            Group editorTypeGroup = new Group(contents, 0);
            editorTypeGroup.setText(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_EditorDialog_Label_Editor);
            editorTypeGroup.setLayout((Layout)new GridLayout(2, false));
            editorTypeGroup.setLayoutData((Object)new GridData(4, 1, true, false));
            this.promptEditorOnOpen = new Button((Composite)editorTypeGroup, 16);
            this.promptEditorOnOpen.setSelection(this.initialValues.isPrompt);
            this.promptEditorOnOpen.setText(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_EditorDialog_Radio_Prompt);
            GridData data = new GridData();
            data.horizontalSpan = 2;
            this.promptEditorOnOpen.setLayoutData((Object)data);
            this.chooseEditorWithDialog = new Button((Composite)editorTypeGroup, 16);
            this.chooseEditorWithDialog.setLayoutData((Object)new GridData(4, 1, false, false));
            this.chooseEditorWithDialog.setSelection(!this.initialValues.isPrompt);
            final Hyperlink chooseEditorLink = new Hyperlink((Composite)editorTypeGroup, 0);
            chooseEditorLink.setUnderlined(true);
            chooseEditorLink.setFont(JFaceResources.getDialogFont());
            if (this.selectedEditor != null) {
                chooseEditorLink.setText(this.selectedEditor.getLabel());
            } else {
                chooseEditorLink.setText(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_EditorDialog_Radio_Specific);
            }
            chooseEditorLink.setForeground(JFaceColors.getHyperlinkText((Display)chooseEditorLink.getDisplay()));
            chooseEditorLink.setLayoutData((Object)new GridData(4, 1, true, false));
            chooseEditorLink.setEnabled(!this.initialValues.isPrompt);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            chooseEditorLink.setLayoutData((Object)data);
            this.chooseEditorWithDialog.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean selectEditorWithDialog = chooseEditorWithDialog.getSelection();
                    chooseEditorLink.setEnabled(selectEditorWithDialog);
                    okButton.setEnabled(this.validateValues());
                }
            });
            chooseEditorLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    selectedEditor = LargeFileAssociationsPreferencePage.promptForEditorWithDialog(this.getShell(), filteredEditors, extension);
                    if (selectedEditor != null) {
                        chooseEditorLink.setText(selectedEditor.getLabel());
                    } else {
                        chooseEditorLink.setText(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_EditorDialog_Radio_Specific);
                    }
                    okButton.setEnabled(this.validateValues());
                }
            });
            Group fileSizeGroup = new Group(contents, 0);
            fileSizeGroup.setText(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_EditorDialog_Label_FileSize);
            fileSizeGroup.setLayout((Layout)new FillLayout(256));
            fileSizeGroup.setLayoutData((Object)new GridData(16384, 1, true, false));
            this.sizeText = LargeFileAssociationsPreferencePage.createFileSizeText((Composite)fileSizeGroup);
            this.sizeText.setText(this.initialValues.size.sizeString);
            this.sizeUnitCombo = LargeFileAssociationsPreferencePage.createSizeUnitCombo((Composite)fileSizeGroup);
            this.sizeUnitCombo.select(this.initialValues.size.unitIndex);
            this.sizeText.setFocus();
            this.sizeText.addModifyListener(event -> {
                if (event.widget == this.sizeText) {
                    this.okButton.setEnabled(this.validateValues());
                }
            });
            this.sizeUnitCombo.addModifyListener(event -> {
                if (event.widget == this.sizeUnitCombo) {
                    this.okButton.setEnabled(this.validateValues());
                }
            });
            Dialog.applyDialogFont((Control)contents);
            Point defaultMargins = LayoutConstants.getMargins();
            GridLayoutFactory.fillDefaults().numColumns(1).margins(defaultMargins.x, defaultMargins.y).generateLayout(contents);
            return contents;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.okButton.setEnabled(this.validateSize());
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void okPressed() {
            boolean promptForEditor = this.promptEditorOnOpen.getSelection();
            SizeAndUnit size = LargeFileAssociationsPreferencePage.getSizeAndUnit(this.sizeText, this.sizeUnitCombo);
            this.chosenValues = new EditorForSize(this.selectedEditor, promptForEditor, size);
            super.okPressed();
        }

        protected boolean isResizable() {
            return true;
        }

        private boolean validateValues() {
            if (!this.validateSelectedEditor()) {
                return false;
            }
            return this.validateSize();
        }

        private boolean validateSelectedEditor() {
            boolean selectEditorWithDialog = this.chooseEditorWithDialog.getSelection();
            if (selectEditorWithDialog && this.selectedEditor == null) {
                this.setErrorMessage(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_EditorDialog_Error_NoEditorSelected);
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }

        private boolean validateSize() {
            SizeAndUnit currentSize = LargeFileAssociationsPreferencePage.getSizeAndUnit(this.sizeText, this.sizeUnitCombo);
            long currentFileSize = currentSize.bytes;
            boolean editorConfiguredForBytes = false;
            long[] lArray = this.filteredFileSizes;
            int n = this.filteredFileSizes.length;
            int n2 = 0;
            while (n2 < n) {
                long configuredFileSize = lArray[n2];
                if (currentFileSize == configuredFileSize) {
                    editorConfiguredForBytes = true;
                    break;
                }
                ++n2;
            }
            if (editorConfiguredForBytes) {
                this.setErrorMessage(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_EditorDialog_Error_DuplicateSize);
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }
    }

    private static class ExtensionDialog
    extends TitleAreaDialog {
        private static final String ASTERIX_PREFIX = "*.";
        private Button okButton;
        private Text extensionText;
        private String extension = "";

        ExtensionDialog(Shell shell) {
            super(shell);
            this.setShellStyle(this.getShellStyle() | 0x10000000);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(WorkbenchMessages.FileExtension_shellTitle);
        }

        protected Control createDialogArea(Composite parent) {
            Composite parentComposite = (Composite)super.createDialogArea(parent);
            Composite contents = new Composite(parentComposite, 0);
            contents.setLayoutData((Object)new GridData(4, 4, true, true));
            this.setTitle(WorkbenchMessages.FileExtension_shellTitle);
            this.setMessage(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_ExtensionDialog_Message);
            new Label(contents, 16384).setText(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_ExtensionDialog_Label);
            this.extensionText = new Text(contents, 2052);
            this.extensionText.addModifyListener(event -> {
                if (event.widget == this.extensionText) {
                    this.extension = this.extensionText.getText().trim();
                    this.okButton.setEnabled(this.validateExtension());
                }
            });
            this.extensionText.setFocus();
            Dialog.applyDialogFont((Control)parentComposite);
            Point defaultMargins = LayoutConstants.getMargins();
            GridLayoutFactory.fillDefaults().numColumns(2).margins(defaultMargins.x, defaultMargins.y).generateLayout(contents);
            return contents;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.okButton.setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        private boolean validateExtension() {
            if (this.extension.isEmpty()) {
                this.setErrorMessage(WorkbenchMessages.FileExtension_extensionEmptyMessage);
                return false;
            }
            int dotIndex = this.extension.indexOf(46);
            int asterixIndex = this.extension.indexOf(42);
            if (!(dotIndex == -1 && asterixIndex == -1 || this.extension.startsWith(ASTERIX_PREFIX) && !this.extension.equals(ASTERIX_PREFIX))) {
                this.setErrorMessage(IDEWorkbenchMessages.LargeFileAssociationsPreferencePage_ExtensionDialog_Error_WildcardAndDot);
                return false;
            }
            this.setErrorMessage(null);
            return true;
        }

        String getExtension() {
            if (this.extension.startsWith(ASTERIX_PREFIX)) {
                return this.extension.substring(ASTERIX_PREFIX.length());
            }
            return this.extension;
        }

        protected boolean isResizable() {
            return true;
        }
    }

    private static class LargeFileAssociation {
        private final String extension;
        private final List<EditorForSize> editors;
        private boolean enabled;

        LargeFileAssociation(String extension) {
            this.extension = extension;
            this.editors = new ArrayList<EditorForSize>();
            this.enabled = true;
        }

        void addEditor(EditorForSize editor) {
            int index = this.indexOfEditor(editor);
            this.editors.add(index, editor);
        }

        int indexOfEditor(EditorForSize editor) {
            int index = Collections.binarySearch(this.editors, editor, EDITOR_COMPARATOR);
            if (index < 0) {
                index = -index - 1;
            }
            return index;
        }

        void removeEditor(IEditorDescriptor editor) {
            if (editor != null) {
                this.editors.removeIf(e -> e.editor != null && e.editor.equals(editor));
            }
        }

        void removePromptEditor() {
            this.editors.removeIf(e -> e.isPrompt);
        }

        void setPromptEditorSize(SizeAndUnit size) {
            this.removePromptEditor();
            EditorForSize promptEditor = new EditorForSize(size);
            this.addEditor(promptEditor);
        }
    }

    private static class NumberModifyListener
    implements ModifyListener {
        private NumberModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            String contents = text.getText();
            if (contents.isBlank()) {
                text.setText("0");
            }
        }
    }

    private static class NumberVerifyListener
    implements VerifyListener {
        private NumberVerifyListener() {
        }

        public void verifyText(VerifyEvent e) {
            Text text = (Text)e.getSource();
            String oldText = text.getText();
            String prefix = oldText.substring(0, e.start);
            String suffix = oldText.substring(e.end);
            String newText = String.valueOf(prefix) + e.text + suffix;
            if (newText.startsWith("0") && newText.length() > 1) {
                e.doit = false;
            } else if (newText.startsWith("-") || newText.startsWith("+")) {
                e.doit = false;
            } else if (!newText.isEmpty()) {
                try {
                    long size = Long.parseLong(newText);
                    if (size < 0L) {
                        e.doit = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        }
    }

    private static class SizeAndUnit {
        final String sizeString;
        final int unitIndex;
        final long bytes;

        SizeAndUnit(String sizeString, int unitIndex) {
            this(sizeString, unitIndex, LargeFileAssociationsPreferencePage.computeSize(sizeString, unitIndex));
        }

        SizeAndUnit(String sizeString, int unitIndex, long bytes) {
            this.sizeString = sizeString;
            this.unitIndex = unitIndex;
            this.bytes = bytes;
        }
    }
}

