/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize.provisional;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.internal.synchronize.RSESyncUtils;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemMergeContext;
import org.eclipse.rse.internal.synchronize.filesystem.subscriber.FileSystemSubscriber;
import org.eclipse.rse.internal.synchronize.filesystem.ui.FileSystemOperation;
import org.eclipse.rse.internal.synchronize.filesystem.ui.FileSystemSynchronizeParticipant;
import org.eclipse.rse.internal.synchronize.provisional.ISynchronizePerspectiveSelector;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IContributorResourceAdapter2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizePerspectiveSelector
implements ISynchronizePerspectiveSelector {
    private IWorkbenchPart targetPart;

    @Override
    public void openSynchronizePerspective(List<IResource> synchronizeElement) {
        ResourceMapping[] mappings = this.getSelectedResourceMappings(RSESyncUtils.PROVIDER_ID, synchronizeElement);
        if (mappings.length == 0) {
            return;
        }
        SubscriberScopeManager manager = FileSystemOperation.createScopeManager(FileSystemSubscriber.getInstance().getName(), mappings);
        FileSystemMergeContext context = new FileSystemMergeContext((ISynchronizationScopeManager)manager);
        FileSystemSynchronizeParticipant participant = new FileSystemSynchronizeParticipant((SynchronizationContext)context);
        TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
        participant.run(this.getTargetPart());
    }

    protected ResourceMapping[] getSelectedResourceMappings(String providerId, List synchronizeResources) {
        Object[] elements = synchronizeResources.toArray();
        ArrayList<ResourceMapping> providerMappings = new ArrayList<ResourceMapping>();
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            Object adapted = this.getResourceMapping(object);
            if (adapted instanceof ResourceMapping) {
                ResourceMapping mapping = (ResourceMapping)adapted;
                if (providerId == null || this.isMappedToProvider(mapping, providerId)) {
                    providerMappings.add(mapping);
                }
            }
            ++i;
        }
        return providerMappings.toArray(new ResourceMapping[providerMappings.size()]);
    }

    private boolean isMappedToProvider(ResourceMapping element, String providerId) {
        IProject[] projects = element.getProjects();
        int k = 0;
        while (k < projects.length) {
            IProject project = projects[k];
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
            if (provider != null && provider.getID().equals(providerId)) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private Object getResourceMapping(Object object) {
        if (object instanceof ResourceMapping) {
            return object;
        }
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            Object adapted = adaptable.getAdapter(ResourceMapping.class);
            if (adapted instanceof ResourceMapping) {
                return adapted;
            }
            adapted = adaptable.getAdapter(IContributorResourceAdapter.class);
            if (adapted instanceof IContributorResourceAdapter2) {
                IContributorResourceAdapter2 cra = (IContributorResourceAdapter2)adapted;
                return cra.getAdaptedResourceMapping(adaptable);
            }
        } else {
            Object adapted = Platform.getAdapterManager().getAdapter(object, ResourceMapping.class);
            if (adapted instanceof ResourceMapping) {
                return adapted;
            }
        }
        return null;
    }

    protected IWorkbenchPart getTargetPart() {
        IWorkbenchPage page;
        if (this.targetPart == null && (page = RSESyncUtils.getActivePage()) != null) {
            this.targetPart = page.getActivePart();
        }
        return this.targetPart;
    }
}

