/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.NoHttpResponseException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.ServiceHelperImpl;
import org.eclipse.epp.internal.mpc.core.util.ITransport;
import org.eclipse.epp.internal.mpc.core.util.Messages;
import org.eclipse.epp.mpc.core.service.ITransportFactory;
import org.eclipse.epp.mpc.core.service.ServiceUnavailableException;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public abstract class TransportFactory
implements ITransportFactory {
    public static final String LEGACY_TRANSPORT_KEY = "org.eclipse.epp.mpc.core.service.transport.legacy";
    public static final String LEGACY_TRANSPORT_COMPONENT_NAME = "org.eclipse.epp.mpc.core.transportfactory.legacy";
    public static final String DISABLED_TRANSPORTS_KEY = "org.eclipse.epp.mpc.core.service.transport.disabled";
    private static final String[] factoryClasses = new String[]{"org.eclipse.epp.internal.mpc.core.util.P2TransportFactory", "org.eclipse.epp.internal.mpc.core.util.Eclipse36TransportFactory", "org.eclipse.epp.internal.mpc.core.util.JavaPlatformTransportFactory"};
    private static final String HTTP_TRANSPORT_FACTORY_ID = "org.eclipse.epp.mpc.core.transport.http.factory";
    private static final String HTTP_TRANSPORT_WRAPPER_ID = "org.eclipse.epp.mpc.core.transport.http.wrapper";
    private static final String ECF_HTTPCLIENT4_TRANSPORT_ID = "org.eclipse.ecf.provider.filetransfer.httpclient4";
    private static final String ECF_EXCLUDES_PROPERTY = "org.eclipse.ecf.provider.filetransfer.excludeContributors";
    private static String lastFallbackTransport = null;
    private ITransport transport;

    public static String computeDisabledTransportsFilter() {
        String excludeContributors;
        BundleContext bundleContext = FrameworkUtil.getBundle(TransportFactory.class).getBundleContext();
        String disabledTransportsStr = bundleContext.getProperty(DISABLED_TRANSPORTS_KEY);
        if (disabledTransportsStr == null) {
            disabledTransportsStr = "";
        }
        if ((excludeContributors = bundleContext.getProperty(ECF_EXCLUDES_PROPERTY)) != null && excludeContributors.contains(ECF_HTTPCLIENT4_TRANSPORT_ID)) {
            disabledTransportsStr = String.valueOf(disabledTransportsStr) + ",org.eclipse.epp.mpc.core.transport.http.wrapper,org.eclipse.epp.mpc.core.transport.http.factory";
        } else if (disabledTransportsStr.contains(HTTP_TRANSPORT_WRAPPER_ID)) {
            disabledTransportsStr = String.valueOf(disabledTransportsStr) + ",org.eclipse.epp.mpc.core.transport.http.factory";
        } else if (disabledTransportsStr.contains(HTTP_TRANSPORT_FACTORY_ID)) {
            disabledTransportsStr = String.valueOf(disabledTransportsStr) + ",org.eclipse.epp.mpc.core.transport.http.wrapper";
        }
        HashSet<String> disabledTransports = new HashSet<String>();
        StringBuilder bldr = new StringBuilder("(&");
        String[] stringArray = disabledTransportsStr.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String transportName = stringArray[n2];
            if (!"".equals(transportName = transportName.trim()) && disabledTransports.add(transportName)) {
                bldr.append("(!(").append("component.name").append("=").append(transportName).append("))");
            }
            ++n2;
        }
        bldr.append(")");
        String disabledTransportsFilter = disabledTransports.isEmpty() ? "" : bldr.toString();
        return disabledTransportsFilter;
    }

    @Deprecated
    public static synchronized TransportFactory instance() {
        TransportFactory legacyTransportFactory = ServiceHelperImpl.getImplInstance().getLegacyTransportFactory();
        if (legacyTransportFactory == null) {
            throw new IllegalStateException();
        }
        return legacyTransportFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static org.eclipse.epp.mpc.core.service.ITransport createTransport() {
        BundleContext context = FrameworkUtil.getBundle(TransportFactory.class).getBundleContext();
        Collection<ServiceReference<ITransportFactory>> serviceReferences = TransportFactory.getTransportServiceReferences(context);
        MultiStatus serviceError = null;
        ServiceReference<ITransportFactory> defaultServiceReference = null;
        for (ServiceReference<ITransportFactory> serviceReference : serviceReferences) {
            ITransportFactory transportService = (ITransportFactory)context.getService(serviceReference);
            if (transportService != null) {
                try {
                    Class<TransportFactory> clazz = TransportFactory.class;
                    // MONITORENTER : org.eclipse.epp.internal.mpc.core.util.TransportFactory.class
                    if (serviceError != null) {
                        TransportFactory.logTransportServiceFallback(serviceError, defaultServiceReference, serviceReference, transportService);
                    } else {
                        lastFallbackTransport = null;
                    }
                    // MONITOREXIT : clazz
                    org.eclipse.epp.mpc.core.service.ITransport transport = transportService.getTransport();
                    if (transport != null) {
                        org.eclipse.epp.mpc.core.service.ITransport iTransport = transport;
                        return iTransport;
                    }
                }
                finally {
                    context.ungetService(serviceReference);
                }
            }
            if (defaultServiceReference == null) {
                defaultServiceReference = serviceReference;
            }
            if (serviceError != null) continue;
            serviceError = TransportFactory.diagnoseTransportServiceRegistration(context, serviceReference);
        }
        if (serviceError == null) {
            serviceError = TransportFactory.diagnoseTransportServiceRegistration(context, null);
        }
        try {
            for (ITransportFactory factory : TransportFactory.listAvailableFactories()) {
                try {
                    org.eclipse.epp.mpc.core.service.ITransport transport = factory.getTransport();
                    if (transport != null) {
                        TransportFactory.logTransportServiceFallback(serviceError, defaultServiceReference, null, factory);
                        return transport;
                    }
                    serviceError.add((IStatus)new Status(4, "org.eclipse.epp.mpc.core", NLS.bind((String)Messages.TransportFactory_LegacyFallbackCreationError, (Object)factory.getClass().getName()), (Throwable)new NullPointerException("Factory returned null transport")));
                }
                catch (Exception ex) {
                    serviceError.add((IStatus)new Status(4, "org.eclipse.epp.mpc.core", NLS.bind((String)Messages.TransportFactory_LegacyFallbackCreationError, (Object)factory.getClass().getName()), (Throwable)ex));
                }
            }
        }
        catch (Exception ex) {
            serviceError.add((IStatus)new Status(4, "org.eclipse.epp.mpc.core", Messages.TransportFactory_LegacyFallbacksError, (Throwable)ex));
        }
        MarketplaceClientCore.getLog().log((IStatus)serviceError);
        CoreException coreException = new CoreException((IStatus)serviceError);
        throw new IllegalStateException(serviceError.toString(), coreException);
    }

    private static void logTransportServiceFallback(MultiStatus serviceError, ServiceReference<ITransportFactory> defaultServiceReference, ServiceReference<ITransportFactory> serviceReference, ITransportFactory factory) {
        String transportName = factory.getClass().getName();
        if (lastFallbackTransport != null && lastFallbackTransport.equals(transportName)) {
            return;
        }
        lastFallbackTransport = transportName;
        MultiStatus transportFallbackStatus = new MultiStatus("org.eclipse.epp.mpc.core", 0, NLS.bind((String)Messages.TransportFactory_DefaultTransportUnavailable_UseFallback, (Object)transportName), null);
        if (defaultServiceReference != null) {
            transportFallbackStatus.add((IStatus)new Status(1, "org.eclipse.epp.mpc.core", NLS.bind((String)Messages.TransportFactory_DefaultService, (Object)defaultServiceReference.toString())));
        }
        if (serviceReference != null) {
            transportFallbackStatus.add((IStatus)new Status(1, "org.eclipse.epp.mpc.core", NLS.bind((String)Messages.TransportFactory_FallbackService, (Object)serviceReference.toString())));
        } else {
            transportFallbackStatus.add((IStatus)new Status(1, "org.eclipse.epp.mpc.core", NLS.bind((String)Messages.TransportFactory_UseLegacyFallback, (Object)transportName)));
        }
        transportFallbackStatus.add((IStatus)serviceError);
        MarketplaceClientCore.getLog().log((IStatus)transportFallbackStatus);
    }

    private static MultiStatus diagnoseTransportServiceRegistration(BundleContext context, ServiceReference<ITransportFactory> serviceReference) {
        MultiStatus serviceError = null;
        if (serviceReference != null) {
            serviceError = new MultiStatus("org.eclipse.epp.mpc.core", 0, Messages.TransportFactory_ServiceErrorUnregistered, null);
            serviceError.add((IStatus)new Status(4, "org.eclipse.epp.mpc.core", NLS.bind((String)Messages.TransportFactory_ServiceErrorServiceReference, serviceReference)));
        } else {
            serviceError = new MultiStatus("org.eclipse.epp.mpc.core", 0, Messages.TransportFactory_ServiceErrorNotFound, null);
        }
        try {
            Collection allServiceReferences = context.getServiceReferences(ITransportFactory.class, null);
            if (allServiceReferences.isEmpty()) {
                serviceError.add((IStatus)new Status(4, "org.eclipse.epp.mpc.core", Messages.TransportFactory_ServiceErrorNoneAvailable));
            } else {
                String filter = TransportFactory.computeDisabledTransportsFilter();
                if (!"".equals(filter)) {
                    serviceError.add((IStatus)new Status(4, "org.eclipse.epp.mpc.core", NLS.bind((String)Messages.TransportFactory_ServiceErrorAppliedFilter, (Object)filter)));
                }
            }
            for (ServiceReference availableReference : allServiceReferences) {
                serviceError.add((IStatus)new Status(1, "org.eclipse.epp.mpc.core", NLS.bind((String)Messages.TransportFactory_ServiceErrorRegisteredService, (Object)availableReference.toString())));
            }
            for (ITransportFactory factory : TransportFactory.listAvailableFactories(true)) {
                serviceError.add((IStatus)new Status(1, "org.eclipse.epp.mpc.core", NLS.bind((String)Messages.TransportFactory_StaticFactoryInfo, (Object)factory.getClass().getName(), (Object)(((TransportFactory)factory).isAvailable() ? Messages.TransportFactory_available : Messages.TransportFactory_unavailable))));
            }
        }
        catch (Exception e) {
            serviceError.add((IStatus)new Status(4, "org.eclipse.epp.mpc.core", Messages.TransportFactory_ServiceErrorDetails, (Throwable)e));
        }
        return serviceError;
    }

    public static Collection<ServiceReference<ITransportFactory>> getTransportServiceReferences(BundleContext context) {
        String disabledTransportsFilter = TransportFactory.computeDisabledTransportsFilter();
        if ("".equals(disabledTransportsFilter)) {
            disabledTransportsFilter = null;
        }
        try {
            return context.getServiceReferences(ITransportFactory.class, disabledTransportsFilter);
        }
        catch (InvalidSyntaxException e) {
            MarketplaceClientCore.error(e);
            ServiceReference serviceReference = context.getServiceReference(ITransportFactory.class);
            return serviceReference == null ? Collections.emptySet() : Collections.singleton(serviceReference);
        }
    }

    public static List<ITransportFactory> listAvailableFactories() {
        return TransportFactory.listAvailableFactories(false);
    }

    private static List<ITransportFactory> listAvailableFactories(boolean includeUnavailable) {
        ArrayList<ITransportFactory> factories = new ArrayList<ITransportFactory>();
        String[] stringArray = factoryClasses;
        int n = factoryClasses.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                TransportFactory factory;
                String factoryClass = stringArray[n2];
                try {
                    factory = (TransportFactory)Class.forName(factoryClass, true, TransportFactory.class.getClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    break block6;
                }
                try {
                    if (includeUnavailable || factory.isAvailable()) {
                        factories.add(factory);
                    }
                }
                catch (Throwable t) {
                    MarketplaceClientCore.getLog().log((IStatus)new Status(2, "org.eclipse.epp.mpc.core", Messages.TransportFactory_transportAvailabilityError, t));
                }
            }
            ++n2;
        }
        return factories;
    }

    @Override
    public synchronized ITransport getTransport() {
        if (this.transport == null && this.isAvailable()) {
            this.transport = (location, monitor) -> {
                try {
                    return this.invokeStream(location, monitor);
                }
                catch (Exception e) {
                    this.handleStreamExceptions(e);
                    return null;
                }
            };
        }
        return this.transport;
    }

    protected abstract boolean isAvailable();

    protected abstract InputStream invokeStream(URI var1, IProgressMonitor var2) throws Exception;

    protected void handleStreamExceptions(Exception e) throws ServiceUnavailableException, CoreException, FileNotFoundException {
        if (e instanceof InvocationTargetException) {
            InvocationTargetException targetException = (InvocationTargetException)e;
            Throwable cause = targetException.getCause();
            if (cause instanceof CoreException) {
                CoreException coreCause = (CoreException)cause;
                TransportFactory.handleServiceUnavailable(coreCause);
                throw coreCause;
            }
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.epp.mpc.core", e.getMessage(), (Throwable)e));
        }
    }

    protected static void handleServiceUnavailable(CoreException e) throws ServiceUnavailableException {
        Throwable cause;
        if (e.getStatus().getCode() == 1002 && (cause = e.getCause()) != null && (cause instanceof NoHttpResponseException || cause.getMessage() != null && cause.getMessage().indexOf("503") != -1)) {
            throw new ServiceUnavailableException((IStatus)new Status(4, "org.eclipse.epp.mpc.core", 503, Messages.DefaultMarketplaceService_serviceUnavailable503, (Throwable)e));
        }
    }

    @Component(name="org.eclipse.epp.mpc.core.transportfactory.legacy", property={"org.eclipse.epp.mpc.core.service.transport.legacy:Boolean=true", "service.ranking:Integer=-2147483647"})
    public static final class LegacyFactory
    implements ITransportFactory {
        private ITransportFactory delegate;
        private ServiceReference<ITransportFactory> delegateReference;

        public ITransportFactory getDelegate() {
            return this.delegate;
        }

        @Override
        public org.eclipse.epp.mpc.core.service.ITransport getTransport() {
            return this.delegate.getTransport();
        }

        @Activate
        public void activate(ComponentContext context) throws InvalidSyntaxException {
            List<ITransportFactory> availableFactories;
            BundleContext bundleContext = context.getBundleContext();
            Collection serviceReferences = bundleContext.getServiceReferences(ITransportFactory.class, "(&(org.eclipse.epp.mpc.core.service.transport.legacy=true)(!(component.name=org.eclipse.epp.mpc.core.transportfactory.legacy))" + TransportFactory.computeDisabledTransportsFilter() + ")");
            if (!serviceReferences.isEmpty()) {
                for (ServiceReference serviceReference : serviceReferences) {
                    ITransportFactory service = (ITransportFactory)bundleContext.getService(serviceReference);
                    if (service instanceof TransportFactory) {
                        this.delegate = service;
                        this.delegateReference = serviceReference;
                        return;
                    }
                    bundleContext.ungetService(serviceReference);
                }
            }
            if ((availableFactories = TransportFactory.listAvailableFactories()).isEmpty()) {
                context.disableComponent(TransportFactory.LEGACY_TRANSPORT_COMPONENT_NAME);
                throw new IllegalStateException(Messages.TransportFactory_NoLegacyTransportFactoriesError);
            }
            this.delegate = availableFactories.get(0);
            this.delegateReference = null;
        }

        @Deactivate
        public void deactivate(ComponentContext context) {
            this.delegate = null;
            if (this.delegateReference != null) {
                context.getBundleContext().ungetService(this.delegateReference);
                this.delegateReference = null;
            }
        }
    }

    public static class LegacyTransportFactoryTracker
    extends ServiceTracker<ITransportFactory, TransportFactory> {
        public LegacyTransportFactoryTracker(BundleContext context) {
            super(context, ITransportFactory.class, (ServiceTrackerCustomizer)new LegacyTransportFactoryTrackerCustomizer(context));
        }
    }

    public static class LegacyTransportFactoryTrackerCustomizer
    implements ServiceTrackerCustomizer<ITransportFactory, TransportFactory> {
        private final BundleContext context;
        private final Map<ServiceReference<ITransportFactory>, TransportFactory> trackedServices = new HashMap<ServiceReference<ITransportFactory>, TransportFactory>();

        private LegacyTransportFactoryTrackerCustomizer(BundleContext context) {
            this.context = context;
        }

        public TransportFactory addingService(ServiceReference<ITransportFactory> reference) {
            TransportFactory transportFactory;
            Object legacyProperty = reference.getProperty(TransportFactory.LEGACY_TRANSPORT_KEY);
            if (!Boolean.parseBoolean(String.valueOf(legacyProperty))) {
                return null;
            }
            ITransportFactory service = (ITransportFactory)this.context.getService(reference);
            if (service instanceof LegacyFactory) {
                LegacyFactory legacyFactory = (LegacyFactory)service;
                service = legacyFactory.getDelegate();
            }
            if (service instanceof TransportFactory && !this.trackedServices.containsValue(transportFactory = (TransportFactory)service)) {
                this.trackedServices.put(reference, transportFactory);
                return transportFactory;
            }
            return null;
        }

        public void modifiedService(ServiceReference<ITransportFactory> reference, TransportFactory service) {
        }

        public void removedService(ServiceReference<ITransportFactory> reference, TransportFactory service) {
            this.trackedServices.remove(reference);
        }
    }
}

