/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.RefreshUtil;

public class RefreshScopeComparator
implements Comparator<String> {
    private static final Comparator<IResource> RESOURCE = Comparator.nullsFirst(Comparator.comparing(r -> r.toString()));
    private static final Comparator<IResource[]> ARRAY = Comparator.nullsFirst((s1, s2) -> Arrays.compare(s1, s2, RESOURCE));
    private static final Comparator<String> MEMENTO = Comparator.nullsFirst(Comparator.comparing(m -> RefreshScopeComparator.toResources(m), ARRAY));

    private static IResource[] toResources(String memento) {
        try {
            return RefreshUtil.toResources(memento);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    public int compare(String o1, String o2) {
        return MEMENTO.compare(o1, o2);
    }
}

