/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Collection;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.lucene.search.SliceExecutor;

class QueueSizeBasedExecutor
extends SliceExecutor {
    private static final double LIMITING_FACTOR = 1.5;
    private final ThreadPoolExecutor threadPoolExecutor;

    public QueueSizeBasedExecutor(ThreadPoolExecutor threadPoolExecutor) {
        super(threadPoolExecutor);
        this.threadPoolExecutor = threadPoolExecutor;
    }

    @Override
    public void invokeAll(Collection<? extends Runnable> tasks) {
        int i = 0;
        for (Runnable runnable : tasks) {
            boolean shouldExecuteOnCallerThread = false;
            if (i == tasks.size() - 1) {
                shouldExecuteOnCallerThread = true;
            }
            if ((double)this.threadPoolExecutor.getQueue().size() >= (double)this.threadPoolExecutor.getMaximumPoolSize() * 1.5) {
                shouldExecuteOnCallerThread = true;
            }
            this.processTask(runnable, shouldExecuteOnCallerThread);
            ++i;
        }
    }
}

