/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.efs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.internal.efs.EgitFileSystem;
import org.eclipse.egit.core.internal.efs.OursVersionInputStream;
import org.eclipse.jgit.util.StringUtils;

class FilteredWorktreeFileStore
extends FileStore {
    private final IFileStore base;
    private final EgitFileSystem.UriComponents uri;
    private final boolean diff3Style;
    private final int conflictMarkerSize;

    public FilteredWorktreeFileStore(EgitFileSystem.UriComponents uri) throws URISyntaxException {
        try {
            String args = uri.getArguments();
            if (StringUtils.isEmptyOrNull((String)args)) {
                throw new URISyntaxException(uri.toString(), "Missing selector arguments");
            }
            switch (args.charAt(0)) {
                case 'o': {
                    this.diff3Style = false;
                    break;
                }
                case 'O': {
                    this.diff3Style = true;
                    break;
                }
                default: {
                    throw new URISyntaxException(uri.toString(), MessageFormat.format("Unknown selector arguments {0}", args));
                }
            }
            int markerSize = 7;
            if (args.length() > 1) {
                try {
                    markerSize = Integer.parseUnsignedInt(args.substring(1));
                }
                catch (NumberFormatException e) {
                    throw new URISyntaxException(uri.toString(), MessageFormat.format("Unknown selector arguments {0}", args));
                }
            }
            this.base = uri.getBaseFile();
            this.conflictMarkerSize = markerSize;
        }
        catch (IOException e) {
            URISyntaxException ue = new URISyntaxException(uri.toString(), "Cannot determine repository");
            ue.initCause(e);
            throw ue;
        }
        this.uri = uri;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return this.base.childNames(options, monitor);
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        return this.base.fetchInfo(options, monitor);
    }

    public IFileStore getChild(String name) {
        return this.base.getChild(name);
    }

    public String getName() {
        return this.base.getName();
    }

    public IFileStore getParent() {
        return this.base.getParent();
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return new OursVersionInputStream(this.base.openInputStream(options, monitor), this.conflictMarkerSize, this.diff3Style);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        return this.base.openOutputStream(options, monitor);
    }

    public URI toURI() {
        return this.uri.toUri();
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        this.base.delete(options, monitor);
    }
}

