/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.testing.dumps;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.testing.dumps.AwtScreenshot;
import org.osgi.framework.Bundle;

public class TimeoutDumpTimer
extends TimerTask {
    private static final String PLUGIN_ID = "org.eclipse.e4.ui.workbench3";
    private static final int SECONDS_BEFORE_TIMEOUT_BUFFER = 120;
    private static final int SECONDS_BETWEEN_DUMPS = 5;
    private volatile boolean assumeUiThreadIsResponsive;
    private final String timeoutArg;
    private final File outputDirectory;

    private TimeoutDumpTimer(String timeoutArg, File outputDirectory) {
        this.timeoutArg = timeoutArg;
        this.outputDirectory = outputDirectory;
    }

    public static void startTimeoutDumpTimer(String timeoutArg) {
        TimeoutDumpTimer.startTimeoutDumpTimer(timeoutArg, null);
    }

    public static void startTimeoutDumpTimer(String timeoutArg, File outputDirectory) {
        try {
            int delay = 120000;
            int timeout = Integer.parseInt(timeoutArg) - delay;
            String time0 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US).format(new Date());
            TimeoutDumpTimer.logInfo("starting DumpStackTracesTimer with timeout=" + timeout + " at " + time0);
            if (timeout > 0) {
                new Timer("DumpStackTracesTimer", true).schedule((TimerTask)new TimeoutDumpTimer(timeoutArg, outputDirectory), timeout);
            } else {
                TimeoutDumpTimer.logWarning("DumpStackTracesTimer argument error: '-timeout " + timeoutArg + "' was too short to accommodate time delay required (" + delay + ").");
            }
        }
        catch (NumberFormatException e) {
            TimeoutDumpTimer.logError("Error parsing timeout argument: " + timeoutArg, e);
        }
    }

    @Override
    public void run() {
        this.dump(0);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {}
        this.dump(5);
    }

    private void dump(int num) {
        long start = System.currentTimeMillis();
        this.dumpStackTraces(num, System.err);
        this.dumpStackTraces(num, System.out);
        this.logStackTraces(num);
        if (this.outputDirectory != null && !this.dumpSwtDisplay(num)) {
            String screenshotFile = this.getScreenshotFile(num);
            TimeoutDumpTimer.dumpAwtScreenshot(screenshotFile);
        }
        long elapsedTimeMillis = System.currentTimeMillis() - start;
        float elapsedTimeSec = (float)elapsedTimeMillis / 1000.0f;
        TimeoutDumpTimer.logInfo("Seconds to do dump " + num + ": " + elapsedTimeSec);
    }

    private static void dumpAwtScreenshot(String screenshotFile) {
        try {
            URL location = AwtScreenshot.class.getProtectionDomain().getCodeSource().getLocation();
            String cp = location.toURI().getPath();
            String javaHome = System.getProperty("java.home");
            String javaExe = String.valueOf(javaHome) + File.separatorChar + "bin" + File.separatorChar + "java";
            if (File.separatorChar == '\\') {
                javaExe = String.valueOf(javaExe) + ".exe";
            }
            String[] args = new String[]{javaExe, "-cp", cp, AwtScreenshot.class.getName(), screenshotFile};
            TimeoutDumpTimer.logInfo("Start process: " + Arrays.asList(args));
            ProcessBuilder processBuilder = new ProcessBuilder(args);
            if ("Mac OS X".equals(System.getProperty("os.name"))) {
                processBuilder.environment().put("AWT_TOOLKIT", "CToolkit");
            }
            Process process = processBuilder.start();
            new StreamForwarder(process.getErrorStream(), System.err).start();
            new StreamForwarder(process.getInputStream(), System.err).start();
            int screenshotTimeout = 15;
            long end = System.currentTimeMillis() + (long)(screenshotTimeout * 1000);
            boolean done = false;
            do {
                try {
                    process.exitValue();
                    done = true;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } while (!done && System.currentTimeMillis() < end);
            if (done) {
                TimeoutDumpTimer.logInfo("AwtScreenshot VM finished with exit code " + process.exitValue() + ".");
            } else {
                process.destroy();
                TimeoutDumpTimer.logWarning("Killed AwtScreenshot VM after " + screenshotTimeout + " seconds.");
            }
        }
        catch (IOException | URISyntaxException e) {
            TimeoutDumpTimer.logError("Failed to create AWT screenshot", e);
        }
    }

    private void logStackTraces(int num) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.dumpStackTraces(num, new PrintStream(outputStream));
        TimeoutDumpTimer.logWarning(outputStream.toString());
    }

    private void dumpStackTraces(int num, PrintStream out) {
        out.println("DumpStackTracesTimer almost reached timeout '" + this.timeoutArg + "'.");
        out.println("totalMemory:            " + Runtime.getRuntime().totalMemory());
        out.println("freeMemory (before GC): " + Runtime.getRuntime().freeMemory());
        out.flush();
        System.gc();
        out.println("freeMemory (after GC):  " + Runtime.getRuntime().freeMemory());
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US).format(new Date());
        out.println("Thread dump " + num + " at " + time + ":");
        out.flush();
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            String name = entry.getKey().getName();
            StackTraceElement[] stack = entry.getValue();
            Exception exception = new Exception("ThreadDump for thread \"" + name + "\"");
            exception.setStackTrace(stack);
            exception.printStackTrace(out);
        }
        out.flush();
    }

    private boolean dumpSwtDisplay(final int num) {
        try {
            final Display display = Display.getDefault();
            if (!this.assumeUiThreadIsResponsive) {
                String message = "trying to make UI thread respond";
                IllegalStateException toThrow = new IllegalStateException(message);
                Thread t = display.getThread();
                toThrow.initCause(new RuntimeException(message));
                toThrow.setStackTrace(t.getStackTrace());
                try {
                    Method stop0 = Thread.class.getDeclaredMethod("stop0", Object.class);
                    stop0.setAccessible(true);
                    stop0.invoke((Object)t, toThrow);
                }
                catch (Exception e1) {
                    TimeoutDumpTimer.logError("Exception occurred while trying to stop UI thread", e1);
                }
            }
            this.assumeUiThreadIsResponsive = false;
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TimeoutDumpTimer.this.assumeUiThreadIsResponsive = true;
                    this.dumpDisplayState(System.err);
                    this.dumpDisplayState(System.out);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    this.dumpDisplayState(new PrintStream(outputStream));
                    TimeoutDumpTimer.logWarning(outputStream.toString());
                    GC gc = new GC((Drawable)display);
                    Image image = new Image((Device)display, display.getBounds());
                    gc.copyArea(image, 0, 0);
                    gc.dispose();
                    ImageLoader loader = new ImageLoader();
                    loader.data = new ImageData[]{image.getImageData()};
                    String filename = TimeoutDumpTimer.this.getScreenshotFile(num);
                    loader.save(filename, 5);
                    TimeoutDumpTimer.logInfo("Screenshot saved to: " + filename);
                    image.dispose();
                }

                private void dumpDisplayState(PrintStream out) {
                    Shell[] shells;
                    Control focusControl = display.getFocusControl();
                    if (focusControl != null) {
                        out.println("FocusControl: ");
                        StringBuilder indent = new StringBuilder("  ");
                        do {
                            out.println(String.valueOf(indent.toString()) + focusControl);
                            focusControl = focusControl.getParent();
                            indent.append("  ");
                        } while (focusControl != null);
                    }
                    if ((shells = display.getShells()).length > 0) {
                        out.println("Shells: ");
                        Shell[] shellArray = shells;
                        int n = shells.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Shell shell = shellArray[n2];
                            out.println(String.valueOf(shell.isVisible() ? "  visible: " : "  invisible: ") + shell);
                            ++n2;
                        }
                    }
                    out.flush();
                }
            });
            return true;
        }
        catch (SWTException e) {
            TimeoutDumpTimer.logError("Failed to create screenshot", (Exception)((Object)e));
            return false;
        }
    }

    String getScreenshotFile(int num) {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return String.valueOf(this.outputDirectory.getAbsolutePath()) + "/dump_screen" + num + ".png";
    }

    private static void logInfo(String message) {
        Status warningStatus = new Status(1, PLUGIN_ID, message);
        TimeoutDumpTimer.log((IStatus)warningStatus);
    }

    private static void logWarning(String message) {
        Status warningStatus = new Status(2, PLUGIN_ID, message);
        TimeoutDumpTimer.log((IStatus)warningStatus);
    }

    private static void logError(String message, Exception exception) {
        Status errorStatus = new Status(4, PLUGIN_ID, message, (Throwable)exception);
        TimeoutDumpTimer.log((IStatus)errorStatus);
    }

    private static void log(IStatus warningStatus) {
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID));
        log.log(warningStatus);
    }

    private static class StreamForwarder
    extends Thread {
        private InputStream fProcessOutput;
        private PrintStream fStream;

        public StreamForwarder(InputStream processOutput, PrintStream stream) {
            this.fProcessOutput = processOutput;
            this.fStream = stream;
        }

        @Override
        public void run() {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.fProcessOutput));){
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        this.fStream.println(line);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                TimeoutDumpTimer.logError("Exception while reading stream", e);
            }
        }
    }
}

