/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.model;

import com.google.common.base.Strings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

final class DocumentHelper {
    DocumentHelper() {
    }

    static DocumentEventType getEventType(DocumentEvent event) {
        if (Strings.isNullOrEmpty((String)event.getText())) {
            return DocumentEventType.REMOVE;
        }
        return event.getLength() == 0 ? DocumentEventType.INSERT : DocumentEventType.REPLACE;
    }

    static int getStartLineCharIndex(DocumentEvent event) throws BadLocationException {
        return event.getOffset() - event.getDocument().getLineOffset(DocumentHelper.getStartLineIndex(event));
    }

    static int getStartLineIndex(DocumentEvent event) throws BadLocationException {
        return event.getDocument().getLineOfOffset(event.getOffset());
    }

    static int getEndLineIndexOfAddedText(DocumentEvent event) throws BadLocationException {
        boolean isAppendToDocumentEnd;
        IDocument doc = event.getDocument();
        int offsetAfterAddedText = event.getOffset() + event.getText().length();
        boolean bl = isAppendToDocumentEnd = offsetAfterAddedText == doc.getLength();
        if (isAppendToDocumentEnd) {
            return doc.getNumberOfLines() - 1;
        }
        return doc.getLineOfOffset(offsetAfterAddedText);
    }

    static int getEndLineIndexOfRemovedText(DocumentEvent event) throws BadLocationException {
        return event.getDocument().getLineOfOffset(event.getOffset() + event.getLength());
    }

    static String getLineText(IDocument document, int lineIndex, boolean withLineDelimiter) throws BadLocationException {
        int lo = document.getLineOffset(lineIndex);
        int ll = document.getLineLength(lineIndex);
        if (!withLineDelimiter) {
            String delim = document.getLineDelimiter(lineIndex);
            ll -= delim != null ? delim.length() : 0;
        }
        return document.get(lo, ll);
    }

    private static IRegion getRegion(IDocument document, int fromLineIndex, int toLineIndex) throws BadLocationException {
        int startOffset = document.getLineOffset(fromLineIndex);
        int endOffset = document.getLineOffset(toLineIndex) + document.getLineLength(toLineIndex);
        return new Region(startOffset, endOffset - startOffset);
    }

    static enum DocumentEventType {
        INSERT,
        REPLACE,
        REMOVE;

    }
}

