/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.codeactions.CodeActionCompletionProposal;
import org.eclipse.lsp4e.operations.codeactions.LSPCodeActionMarkerResolution;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.internal.progress.ProgressInfoItem;

public class LSPCodeActionQuickAssistProcessor
implements IQuickAssistProcessor {
    private List<LanguageServiceAccessor.LSPDocumentInfo> infos;
    private Object lock = new Object();
    private IQuickAssistInvocationContext cachedContext;
    private List<ICompletionProposal> proposals = Collections.synchronizedList(new ArrayList());
    private static final ICompletionProposal COMPUTING = new ICompletionProposal(){

        public void apply(IDocument document) {
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public String getDisplayString() {
            return Messages.computing;
        }

        public Image getImage() {
            return JFaceResources.getImage((String)(String.valueOf(ProgressInfoItem.class.getPackage().getName()) + ".PROGRESS_DEFAULT"));
        }

        public IContextInformation getContextInformation() {
            return null;
        }
    };
    CompletionProposal[] NO_PROPOSALS = new CompletionProposal[0];

    public String getErrorMessage() {
        return "CodeActions not implemented on this Language Server";
    }

    public boolean canFix(Annotation annotation) {
        return true;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        IDocument document = invocationContext.getSourceViewer().getDocument();
        if (this.infos == null || this.infos.isEmpty() || this.infos.get(0).getDocument() != document) {
            this.infos = LSPCodeActionQuickAssistProcessor.getLSPDocumentInfos(document);
            if (this.infos.isEmpty()) {
                return false;
            }
        }
        CodeActionParams params = LSPCodeActionQuickAssistProcessor.prepareCodeActionParams(this.infos, invocationContext.getOffset(), invocationContext.getLength());
        List possibleProposals = Collections.synchronizedList(new ArrayList());
        List<CompletableFuture> futures = this.infos.stream().map(info -> info.getInitializedLanguageClient().thenComposeAsync(ls -> ls.getTextDocumentService().codeAction(params).thenAcceptAsync(actions -> actions.stream().filter(Objects::nonNull).forEach(possibleProposals::add)))).collect(Collectors.toList());
        CompletableFuture<Void> aggregateFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        try {
            aggregateFutures.get(200L, TimeUnit.MILLISECONDS);
            return !possibleProposals.isEmpty();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LanguageServerPlugin.logError(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        block12: {
            document = invocationContext.getSourceViewer().getDocument();
            if (this.infos == null || this.infos.isEmpty() || this.infos.get(0).getDocument() != document) {
                this.infos = LSPCodeActionQuickAssistProcessor.getLSPDocumentInfos(document);
                if (this.infos.isEmpty()) {
                    return this.NO_PROPOSALS;
                }
            }
            proposalsRefreshInProgress = false;
            var4_4 = this.lock;
            synchronized (var4_4) {
                if (this.cachedContext != invocationContext) {
                    this.cachedContext = invocationContext;
                    this.proposals.clear();
                } else {
                    proposalsRefreshInProgress = true;
                    this.proposals.remove(LSPCodeActionQuickAssistProcessor.COMPUTING);
                }
            }
            params = LSPCodeActionQuickAssistProcessor.prepareCodeActionParams(this.infos, invocationContext.getOffset(), invocationContext.getLength());
            futures = Collections.emptyList();
            try {
                if (!proposalsRefreshInProgress) {
                    this.proposals.clear();
                    futures = this.infos.stream().map((Function<LanguageServiceAccessor.LSPDocumentInfo, CompletableFuture>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$5(org.eclipse.lsp4j.CodeActionParams org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext org.eclipse.lsp4e.LanguageServiceAccessor$LSPDocumentInfo ), (Lorg/eclipse/lsp4e/LanguageServiceAccessor$LSPDocumentInfo;)Ljava/util/concurrent/CompletableFuture;)((LSPCodeActionQuickAssistProcessor)this, (CodeActionParams)params, (IQuickAssistInvocationContext)invocationContext)).collect(Collectors.toList());
                    aggregateFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
                    aggregateFutures.get(200L, TimeUnit.MILLISECONDS);
                }
                break block12;
            }
            catch (InterruptedException | ExecutionException e) {
                LanguageServerPlugin.logError(e);
                break block12;
            }
            catch (TimeoutException e) {
                ** for (future : futures)
            }
lbl-1000:
            // 1 sources

            {
                future.whenComplete((BiConsumer<Void, Throwable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$11(org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext java.lang.Void java.lang.Throwable ), (Ljava/lang/Void;Ljava/lang/Throwable;)V)((LSPCodeActionQuickAssistProcessor)this, (IQuickAssistInvocationContext)invocationContext));
                continue;
            }
lbl38:
            // 1 sources

            this.proposals.add(LSPCodeActionQuickAssistProcessor.COMPUTING);
        }
        return this.proposals.toArray(new ICompletionProposal[this.proposals.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNewProposal(IQuickAssistInvocationContext invocationContext, ICompletionProposal p) {
        Object object = this.lock;
        synchronized (object) {
            if (this.cachedContext == invocationContext) {
                this.proposals.add(p);
            }
        }
    }

    private void refreshProposals(IQuickAssistInvocationContext invocationContext) {
        invocationContext.getSourceViewer().getTextWidget().getDisplay().asyncExec(() -> invocationContext.getSourceViewer().getTextOperationTarget().doOperation(22));
    }

    private static List<LanguageServiceAccessor.LSPDocumentInfo> getLSPDocumentInfos(IDocument document) {
        if (document == null) {
            return Collections.emptyList();
        }
        return LanguageServiceAccessor.getLSPDocumentInfosFor(document, LSPCodeActionMarkerResolution::providesCodeActions);
    }

    private static CodeActionParams prepareCodeActionParams(List<LanguageServiceAccessor.LSPDocumentInfo> infos, int offset, int length) {
        CodeActionContext context = new CodeActionContext(Collections.emptyList());
        CodeActionParams params = new CodeActionParams();
        params.setTextDocument(new TextDocumentIdentifier(infos.get(0).getFileUri().toString()));
        try {
            params.setRange(new Range(LSPEclipseUtils.toPosition(offset, infos.get(0).getDocument()), LSPEclipseUtils.toPosition(offset + length, infos.get(0).getDocument())));
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        params.setContext(context);
        return params;
    }

    private /* synthetic */ CompletableFuture lambda$5(CodeActionParams codeActionParams, IQuickAssistInvocationContext iQuickAssistInvocationContext, LanguageServiceAccessor.LSPDocumentInfo info) {
        return info.getInitializedLanguageClient().thenComposeAsync(ls -> ls.getTextDocumentService().codeAction(codeActionParams).thenAcceptAsync(actions -> actions.stream().filter(Objects::nonNull).map(action -> new CodeActionCompletionProposal((Either<Command, CodeAction>)action, info)).forEach(p -> this.processNewProposal(iQuickAssistInvocationContext, (ICompletionProposal)p))));
    }

    private /* synthetic */ void lambda$11(IQuickAssistInvocationContext iQuickAssistInvocationContext, Void r, Throwable t) {
        this.refreshProposals(iQuickAssistInvocationContext);
    }
}

