/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.fragment;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.wizard.fragment.SelectClientWizardFragment;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class OptionalClientWizardFragment
extends WizardFragment {
    protected IClient[] clients;
    protected IModuleArtifact moduleArtifact;
    protected IServer lastServer;
    protected Object lastLaunchable;

    public OptionalClientWizardFragment(IModuleArtifact moduleArtifact) {
        this.moduleArtifact = moduleArtifact;
    }

    @Override
    protected void createChildFragments(List<WizardFragment> list) {
        if (this.clients != null && this.clients.length > 1) {
            list.add(new SelectClientWizardFragment());
        }
    }

    protected void updateClients() {
        if (this.getTaskModel() == null) {
            return;
        }
        try {
            IServer server = (IServer)this.getTaskModel().getObject("server");
            if (server == null) {
                this.getTaskModel().putObject("launchableAdapter", null);
                this.getTaskModel().putObject("launchable", null);
                this.getTaskModel().putObject("clients", null);
                this.getTaskModel().putObject("hasClients", (Object)new Boolean(false));
                return;
            }
            Object launchable = null;
            try {
                Object[] obj = ServerUIPlugin.getLaunchableAdapter(server, this.moduleArtifact);
                this.getTaskModel().putObject("launchableAdapter", obj[0]);
                this.getTaskModel().putObject("launchable", obj[1]);
                launchable = obj[1];
            }
            catch (CoreException ce) {
                this.getTaskModel().putObject("launchableAdapter", null);
                this.getTaskModel().putObject("launchable", null);
                this.getTaskModel().putObject("clients", null);
                this.getTaskModel().putObject("hasClients", (Object)new Boolean(false));
                EclipseUtil.openError(null, ce.getStatus());
                return;
            }
            if (this.lastServer != null && this.lastServer.equals(server)) {
                if (this.lastLaunchable == null && launchable == null) {
                    return;
                }
                if (this.lastLaunchable != null && this.lastLaunchable.equals(launchable)) {
                    return;
                }
            }
            this.lastServer = server;
            this.lastLaunchable = launchable;
            String launchMode = (String)this.getTaskModel().getObject("launch-mode");
            this.clients = ServerUIPlugin.getClients(server, launchable, launchMode);
            this.getTaskModel().putObject("clients", null);
            this.getTaskModel().putObject("hasClients", (Object)new Boolean(false));
            if (this.clients != null) {
                if (this.clients.length > 1) {
                    this.getTaskModel().putObject("clients", (Object)this.clients);
                    this.getTaskModel().putObject("hasClients", (Object)new Boolean(true));
                } else {
                    this.getTaskModel().putObject("client", (Object)this.clients[0]);
                }
            }
            this.updateChildFragments();
        }
        catch (Exception exception) {}
    }

    @Override
    public void enter() {
        this.updateClients();
    }

    @Override
    public List getChildFragments() {
        this.updateClients();
        return super.getChildFragments();
    }

    @Override
    public void setTaskModel(TaskModel taskModel) {
        super.setTaskModel(taskModel);
        this.updateClients();
    }
}

