/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;

public class ServerLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private static final String READ_ONLY = "read-only";
    private String[] serverTypeIds;
    private Combo serverCombo;
    private Label runtimeLabel;
    private Label hostname;
    private IServer server;
    private List<IServer> servers;
    private ILaunchConfigurationWorkingCopy wc;

    public ServerLaunchConfigurationTab() {
        this(new String[]{"*"});
    }

    public ServerLaunchConfigurationTab(String[] serverTypeIds) {
        this.serverTypeIds = serverTypeIds;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 64);
        label.setText(Messages.serverLaunchDescription);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        data.grabExcessHorizontalSpace = false;
        data.widthHint = 300;
        label.setLayoutData((Object)data);
        label = new Label(composite, 0);
        label.setText(Messages.serverLaunchServer);
        this.serverCombo = new Combo(composite, 2060);
        this.serverCombo.setLayoutData((Object)new GridData(768));
        this.serverCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ServerLaunchConfigurationTab.this.handleServerSelection();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.serverCombo, "org.eclipse.wst.server.ui.swsl0000");
        label = new Label(composite, 0);
        label.setText(Messages.serverLaunchRuntime);
        this.runtimeLabel = new Label(composite, 0);
        this.runtimeLabel.setLayoutData((Object)new GridData(768));
        label = new Label(composite, 0);
        label.setText(Messages.serverLaunchHost);
        this.hostname = new Label(composite, 0);
        this.hostname.setLayoutData((Object)new GridData(768));
        IServer[] servers2 = ServerCore.getServers();
        this.servers = new ArrayList<IServer>();
        if (servers2 != null) {
            int size = servers2.length;
            int i = 0;
            while (i < size) {
                IServer server2 = servers2[i];
                if (server2.getServerType() != null && this.isSupportedServer(server2.getServerType().getId())) {
                    this.serverCombo.add(server2.getName());
                    this.servers.add(server2);
                }
                ++i;
            }
        }
        if (this.serverCombo.getItemCount() > 0) {
            this.serverCombo.select(0);
        }
        this.handleServerSelection();
        this.serverCombo.forceFocus();
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    private boolean isSupportedServer(String serverTypeId) {
        if (this.serverTypeIds == null) {
            return true;
        }
        int size = this.serverTypeIds.length;
        int i = 0;
        while (i < size) {
            if (ServerLaunchConfigurationTab.matches(serverTypeId, this.serverTypeIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean matches(String a, String b) {
        return a == null || b == null || "*".equals(a) || "*".equals(b) || a.startsWith(b) || b.startsWith(a);
    }

    protected void handleServerSelection() {
        this.server = this.servers.isEmpty() ? null : this.servers.get(this.serverCombo.getSelectionIndex());
        IRuntime runtime = null;
        if (this.server != null) {
            runtime = this.server.getRuntime();
            this.hostname.setText(this.server.getHost());
        } else {
            this.hostname.setText("");
        }
        if (runtime != null && this.server != null && this.server.getServerType() != null && this.server.getServerType().hasRuntime()) {
            this.runtimeLabel.setText(runtime.getName());
        } else {
            this.runtimeLabel.setText("");
        }
        try {
            if (this.wc != null) {
                ((Server)this.server).setupLaunchConfiguration(this.wc, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception exception) {}
        if (this.server == null) {
            this.setErrorMessage(Messages.errorNoServerSelected);
        } else if (this.server.getServerState() != 4) {
            this.setErrorMessage(Messages.errorServerAlreadyRunning);
        } else {
            this.setErrorMessage(null);
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.setErrorMessage(null);
        if (this.serverCombo != null) {
            this.serverCombo.setEnabled(true);
            if (this.serverCombo.getItemCount() > 0) {
                this.serverCombo.select(0);
            }
        }
        if (this.servers != null) {
            this.server = this.servers.get(this.serverCombo.getSelectionIndex());
            if (this.server != null) {
                ((Server)this.server).setupLaunchConfiguration(configuration, null);
            }
        }
        this.wc = configuration;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.serverCombo.setEnabled(true);
        this.setErrorMessage(null);
        try {
            String serverId = configuration.getAttribute("server-id", "");
            if (serverId != null && !serverId.equals("")) {
                this.server = ServerCore.findServer((String)serverId);
                if (this.server == null) {
                    this.setErrorMessage(Messages.errorInvalidServer);
                    this.serverCombo.setEnabled(false);
                    return;
                }
                this.serverCombo.setText(this.server.getName());
                if (this.server.getServerState() != 4) {
                    this.setErrorMessage(Messages.errorServerAlreadyRunning);
                }
            } else if (this.serverCombo.getItemCount() > 0) {
                this.serverCombo.select(0);
            }
            this.handleServerSelection();
            if (configuration.getAttribute(READ_ONLY, false)) {
                this.serverCombo.setEnabled(false);
            }
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.server != null) {
            configuration.setAttribute("server-id", this.server.getId());
        } else {
            configuration.setAttribute("server-id", null);
        }
        this.wc = configuration;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        block4: {
            IServer server2;
            block5: {
                try {
                    String id = launchConfig.getAttribute("server-id", "");
                    if (id == null || id.equals("")) break block4;
                    server2 = ServerCore.findServer((String)id);
                    if (server2 != null) break block5;
                    return false;
                }
                catch (CoreException coreException) {}
            }
            if (server2.getServerState() == 4) {
                return true;
            }
        }
        return false;
    }

    public Image getImage() {
        return ImageResource.getImage("server");
    }

    public String getName() {
        return Messages.serverLaunchConfigurationTab;
    }
}

