"use strict";
var __getOwnPropNames = Object.getOwnPropertyNames;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/cmdline_utils.js
var require_cmdline_utils = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/cmdline_utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.generateHelpMessage = exports2.parseCommandLine = void 0;
    function findArgument(argv, argName) {
      const index = argv.indexOf(argName);
      if (index < 0 || index === argv.length - 1) {
        return;
      }
      return argv[index + 1];
    }
    function parseStringArray(argv, argName) {
      const arg = findArgument(argv, argName);
      if (!arg) {
        return [];
      }
      return arg.split(",");
    }
    function hasArgument(argv, argName) {
      return argv.includes(argName);
    }
    function parseCommandLine(argv) {
      return {
        help: hasArgument(argv, "--help"),
        ivy: !hasArgument(argv, "--viewEngine"),
        disableAutomaticNgcc: hasArgument(argv, "--disableAutomaticNgcc"),
        logFile: findArgument(argv, "--logFile"),
        logVerbosity: findArgument(argv, "--logVerbosity"),
        logToConsole: hasArgument(argv, "--logToConsole"),
        ngProbeLocations: parseStringArray(argv, "--ngProbeLocations"),
        tsProbeLocations: parseStringArray(argv, "--tsProbeLocations"),
        includeAutomaticOptionalChainCompletions: hasArgument(argv, "--includeAutomaticOptionalChainCompletions"),
        includeCompletionsWithSnippetText: hasArgument(argv, "--includeCompletionsWithSnippetText"),
        forceStrictTemplates: hasArgument(argv, "--forceStrictTemplates"),
        untrustedWorkspace: hasArgument(argv, "--untrustedWorkspace")
      };
    }
    exports2.parseCommandLine = parseCommandLine;
    function generateHelpMessage(argv) {
      return `Angular Language Service that implements the Language Server Protocol (LSP).

  Usage: ${argv[0]} ${argv[1]} [options]

  Options:
    --help: Prints help message.
    --viewEngine: Use legacy View Engine language service. Defaults to false.
    --logFile: Location to log messages. Logging to file is disabled if not provided.
    --logVerbosity: terse|normal|verbose|requestTime. See ts.server.LogLevel.
    --logToConsole: Enables logging to console via 'window/logMessage'. Defaults to false.
    --ngProbeLocations: Path of @angular/language-service. Required.
    --tsProbeLocations: Path of typescript. Required.

  Additional options supported by vscode-languageserver:
    --clientProcessId=<number>: Automatically kills the server if the client process dies.
    --node-ipc: Communicate using Node's IPC. This is the default.
    --stdio: Communicate over stdin/stdout.
    --socket=<number>: Communicate using Unix socket.
  `;
    }
    exports2.generateHelpMessage = generateHelpMessage;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/common/resolver.js
var require_resolver = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/common/resolver.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Version = exports2.resolve = void 0;
    var fs = __importStar(require("fs"));
    function resolve(packageName, location, rootPackage) {
      rootPackage = rootPackage || packageName;
      try {
        const packageJsonPath = require.resolve(`${rootPackage}/package.json`, {
          paths: [location]
        });
        const packageJson = JSON.parse(fs.readFileSync(packageJsonPath, "utf8"));
        const resolvedPath = require.resolve(packageName, {
          paths: [location]
        });
        return {
          name: packageName,
          resolvedPath,
          version: new Version(packageJson.version)
        };
      } catch (_a) {
      }
    }
    exports2.resolve = resolve;
    var Version = class {
      constructor(versionStr) {
        this.versionStr = versionStr;
        const [major, minor, patch] = Version.parseVersionStr(versionStr);
        this.major = major;
        this.minor = minor;
        this.patch = patch;
      }
      greaterThanOrEqual(other) {
        if (this.major < other.major) {
          return false;
        }
        if (this.major > other.major) {
          return true;
        }
        if (this.minor < other.minor) {
          return false;
        }
        if (this.minor > other.minor) {
          return true;
        }
        return this.patch >= other.patch;
      }
      toString() {
        return this.versionStr;
      }
      static parseVersionStr(versionStr) {
        const [major, minor, patch] = versionStr.split(".").map(parseNonNegativeInt);
        return [
          major === void 0 ? 0 : major,
          minor === void 0 ? 0 : minor,
          patch === void 0 ? 0 : patch
        ];
      }
    };
    exports2.Version = Version;
    function parseNonNegativeInt(a) {
      const i = parseInt(a, 10);
      return isNaN(i) ? -1 : i;
    }
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/version_provider.js
var require_version_provider = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/version_provider.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.resolveNgcc = exports2.resolveNgLangSvc = exports2.loadEsmModule = exports2.resolveTsServer = void 0;
    var fs = __importStar(require("fs"));
    var path = __importStar(require("path"));
    var url_1 = __importDefault(require("url"));
    var resolver_1 = require_resolver();
    var MIN_TS_VERSION = "4.8";
    var MIN_NG_VERSION = "13.0";
    var TSSERVERLIB = "typescript/lib/tsserverlibrary";
    function resolveWithMinVersion(packageName, minVersionStr, probeLocations, rootPackage) {
      if (!packageName.startsWith(rootPackage)) {
        throw new Error(`${packageName} must be in the root package`);
      }
      const minVersion = new resolver_1.Version(minVersionStr);
      for (const location of probeLocations) {
        const nodeModule = (0, resolver_1.resolve)(packageName, location, rootPackage);
        if (nodeModule && nodeModule.version.greaterThanOrEqual(minVersion)) {
          return nodeModule;
        }
      }
      throw new Error(`Failed to resolve '${packageName}' with minimum version '${minVersion}' from ` + JSON.stringify(probeLocations, null, 2));
    }
    function resolveTsServer(probeLocations) {
      if (probeLocations.length > 0) {
        const resolvedFromTsdk = resolveTsServerFromTsdk(probeLocations[0], probeLocations.slice(1));
        const minVersion = new resolver_1.Version(MIN_TS_VERSION);
        if (resolvedFromTsdk !== void 0) {
          if (resolvedFromTsdk.version.greaterThanOrEqual(minVersion)) {
            return resolvedFromTsdk;
          } else {
            console.warn(`Ignoring TSDK version specified in the TypeScript extension options ${resolvedFromTsdk.version} because it is lower than the required TS version for the language service (${MIN_TS_VERSION}).`);
          }
        }
      }
      return resolveWithMinVersion(TSSERVERLIB, MIN_TS_VERSION, probeLocations, "typescript");
    }
    exports2.resolveTsServer = resolveTsServer;
    function resolveTsServerFromTsdk(tsdk, probeLocations) {
      if (path.isAbsolute(tsdk)) {
        probeLocations = [tsdk];
      } else {
        probeLocations = probeLocations.map((location) => path.join(location, tsdk));
      }
      for (const location of probeLocations) {
        const tsserverlib = path.join(location, "tsserverlibrary.js");
        if (!fs.existsSync(tsserverlib)) {
          continue;
        }
        const packageJson = path.resolve(tsserverlib, "../../package.json");
        if (!fs.existsSync(packageJson)) {
          continue;
        }
        try {
          const json = JSON.parse(fs.readFileSync(packageJson, "utf8"));
          return {
            name: TSSERVERLIB,
            resolvedPath: tsserverlib,
            version: new resolver_1.Version(json.version)
          };
        } catch (_a) {
          continue;
        }
      }
      return void 0;
    }
    function loadEsmModule(modulePath) {
      return new Function("modulePath", `return import(modulePath);`)(modulePath);
    }
    exports2.loadEsmModule = loadEsmModule;
    function resolveNgLangSvc(probeLocations) {
      const ngls = "@angular/language-service";
      return resolveWithMinVersion(ngls, MIN_NG_VERSION, probeLocations, ngls);
    }
    exports2.resolveNgLangSvc = resolveNgLangSvc;
    function resolveNgcc(directory) {
      return __async(this, null, function* () {
        try {
          const ngcc = (0, resolver_1.resolve)("@angular/compiler-cli/ngcc", directory, "@angular/compiler-cli");
          if (ngcc === void 0) {
            throw new Error("Could not resolve ngcc");
          }
          const ngccModule = yield loadEsmModule(url_1.default.pathToFileURL(ngcc.resolvedPath));
          const resolvedPath = ngccModule.ngccMainFilePath;
          if (resolvedPath === void 0) {
            throw new Error("could not resolve ngcc path.");
          }
          return Object.assign(Object.assign({}, ngcc), { resolvedPath });
        } catch (e) {
          return (0, resolver_1.resolve)("@angular/compiler-cli/ngcc/main-ngcc.js", directory, "@angular/compiler-cli");
        }
      });
    }
    exports2.resolveNgcc = resolveNgcc;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/banner.js
Object.defineProperty(exports, "__esModule", { value: true });
exports.requireOverride = void 0;
var cmdline_utils_1 = require_cmdline_utils();
var version_provider_1 = require_version_provider();
var originalRequire = require;
function requireOverride(moduleName) {
  const TSSERVER = "typescript/lib/tsserverlibrary";
  if (moduleName === "typescript") {
    throw new Error(`Import '${TSSERVER}' instead of 'typescript'`);
  }
  if (moduleName === TSSERVER) {
    const { tsProbeLocations } = (0, cmdline_utils_1.parseCommandLine)(process.argv);
    moduleName = (0, version_provider_1.resolveTsServer)(tsProbeLocations).resolvedPath;
  }
  return originalRequire(moduleName);
}
exports.requireOverride = requireOverride;
requireOverride.resolve = originalRequire.resolve;
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
require = requireOverride;

"use strict";
var __getOwnPropNames = Object.getOwnPropertyNames;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/cmdline_utils.js
var require_cmdline_utils = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/cmdline_utils.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.generateHelpMessage = exports2.parseCommandLine = void 0;
    function findArgument(argv, argName) {
      const index = argv.indexOf(argName);
      if (index < 0 || index === argv.length - 1) {
        return;
      }
      return argv[index + 1];
    }
    function parseStringArray(argv, argName) {
      const arg = findArgument(argv, argName);
      if (!arg) {
        return [];
      }
      return arg.split(",");
    }
    function hasArgument(argv, argName) {
      return argv.includes(argName);
    }
    function parseCommandLine(argv) {
      return {
        help: hasArgument(argv, "--help"),
        ivy: !hasArgument(argv, "--viewEngine"),
        disableAutomaticNgcc: hasArgument(argv, "--disableAutomaticNgcc"),
        logFile: findArgument(argv, "--logFile"),
        logVerbosity: findArgument(argv, "--logVerbosity"),
        logToConsole: hasArgument(argv, "--logToConsole"),
        ngProbeLocations: parseStringArray(argv, "--ngProbeLocations"),
        tsProbeLocations: parseStringArray(argv, "--tsProbeLocations"),
        includeAutomaticOptionalChainCompletions: hasArgument(argv, "--includeAutomaticOptionalChainCompletions"),
        includeCompletionsWithSnippetText: hasArgument(argv, "--includeCompletionsWithSnippetText"),
        forceStrictTemplates: hasArgument(argv, "--forceStrictTemplates"),
        untrustedWorkspace: hasArgument(argv, "--untrustedWorkspace")
      };
    }
    exports2.parseCommandLine = parseCommandLine;
    function generateHelpMessage(argv) {
      return `Angular Language Service that implements the Language Server Protocol (LSP).

  Usage: ${argv[0]} ${argv[1]} [options]

  Options:
    --help: Prints help message.
    --viewEngine: Use legacy View Engine language service. Defaults to false.
    --logFile: Location to log messages. Logging to file is disabled if not provided.
    --logVerbosity: terse|normal|verbose|requestTime. See ts.server.LogLevel.
    --logToConsole: Enables logging to console via 'window/logMessage'. Defaults to false.
    --ngProbeLocations: Path of @angular/language-service. Required.
    --tsProbeLocations: Path of typescript. Required.

  Additional options supported by vscode-languageserver:
    --clientProcessId=<number>: Automatically kills the server if the client process dies.
    --node-ipc: Communicate using Node's IPC. This is the default.
    --stdio: Communicate over stdin/stdout.
    --socket=<number>: Communicate using Unix socket.
  `;
    }
    exports2.generateHelpMessage = generateHelpMessage;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/logger.js
var require_logger = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/logger.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createLogger = void 0;
    var fs = __importStar(require("fs"));
    var path = __importStar(require("path"));
    var ts = __importStar(require("typescript/lib/tsserverlibrary"));
    function createLogger(options) {
      let logLevel;
      switch (options.logVerbosity) {
        case "requestTime":
          logLevel = ts.server.LogLevel.requestTime;
          break;
        case "verbose":
          logLevel = ts.server.LogLevel.verbose;
          break;
        case "normal":
          logLevel = ts.server.LogLevel.normal;
          break;
        case "terse":
        default:
          logLevel = ts.server.LogLevel.terse;
          break;
      }
      return new Logger(logLevel, options.logFile);
    }
    exports2.createLogger = createLogger;
    function noop(_) {
    }
    function nowString() {
      const d = new Date();
      return `${d.getHours()}:${d.getMinutes()}:${d.getSeconds()}.${d.getMilliseconds()}`;
    }
    var Logger = class {
      constructor(level, logFilename) {
        this.level = level;
        this.logFilename = logFilename;
        this.seq = 0;
        this.inGroup = false;
        this.firstInGroup = true;
        this.fd = -1;
        if (logFilename) {
          try {
            const dir = path.dirname(logFilename);
            if (!fs.existsSync(dir)) {
              fs.mkdirSync(dir);
            }
            this.fd = fs.openSync(logFilename, "w");
          } catch (_a) {
          }
        }
      }
      close() {
        if (this.loggingEnabled()) {
          fs.close(this.fd, noop);
        }
      }
      getLogFileName() {
        return this.logFilename;
      }
      perftrc(s) {
        this.msg(s, ts.server.Msg.Perf);
      }
      info(s) {
        this.msg(s, ts.server.Msg.Info);
      }
      startGroup() {
        this.inGroup = true;
        this.firstInGroup = true;
      }
      endGroup() {
        this.inGroup = false;
      }
      loggingEnabled() {
        return this.fd >= 0;
      }
      hasLevel(level) {
        return this.loggingEnabled() && this.level >= level;
      }
      msg(s, type = ts.server.Msg.Err) {
        if (!this.loggingEnabled()) {
          return;
        }
        let prefix = "";
        if (!this.inGroup || this.firstInGroup) {
          this.firstInGroup = false;
          prefix = `${type} ${this.seq}`.padEnd(10) + `[${nowString()}] `;
        }
        const entry = prefix + s + "\n";
        fs.writeSync(this.fd, entry);
        if (!this.inGroup) {
          this.seq++;
        }
      }
    };
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/server_host.js
var require_server_host = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/server_host.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ServerHost = void 0;
    var ts = __importStar(require("typescript/lib/tsserverlibrary"));
    var NOOP_WATCHER = {
      close() {
      }
    };
    var ServerHost = class {
      constructor(isG3) {
        this.isG3 = isG3;
        this.args = ts.sys.args;
        this.newLine = ts.sys.newLine;
        this.useCaseSensitiveFileNames = ts.sys.useCaseSensitiveFileNames;
      }
      write(s) {
        ts.sys.write(s);
      }
      writeOutputIsTTY() {
        return ts.sys.writeOutputIsTTY();
      }
      readFile(path, encoding) {
        return ts.sys.readFile(path, encoding);
      }
      getFileSize(path) {
        return ts.sys.getFileSize(path);
      }
      writeFile(path, data, writeByteOrderMark) {
        return ts.sys.writeFile(path, data, writeByteOrderMark);
      }
      watchFile(path, callback, pollingInterval, options) {
        return ts.sys.watchFile(path, callback, pollingInterval, options);
      }
      watchDirectory(path, callback, recursive, options) {
        if (this.isG3 && path.startsWith("/google/src")) {
          return NOOP_WATCHER;
        }
        return ts.sys.watchDirectory(path, callback, recursive, options);
      }
      resolvePath(path) {
        return ts.sys.resolvePath(path);
      }
      fileExists(path) {
        if (path.endsWith(".ngtypecheck.ts")) {
          return true;
        }
        return ts.sys.fileExists(path);
      }
      directoryExists(path) {
        return ts.sys.directoryExists(path);
      }
      createDirectory(path) {
        return ts.sys.createDirectory(path);
      }
      getExecutingFilePath() {
        return ts.sys.getExecutingFilePath();
      }
      getCurrentDirectory() {
        return ts.sys.getCurrentDirectory();
      }
      getDirectories(path) {
        return ts.sys.getDirectories(path);
      }
      readDirectory(path, extensions, exclude, include, depth) {
        return ts.sys.readDirectory(path, extensions, exclude, include, depth);
      }
      getModifiedTime(path) {
        return ts.sys.getModifiedTime(path);
      }
      setModifiedTime(path, time) {
        return ts.sys.setModifiedTime(path, time);
      }
      deleteFile(path) {
        return ts.sys.deleteFile(path);
      }
      createHash(data) {
        return ts.sys.createHash(data);
      }
      createSHA256Hash(data) {
        return ts.sys.createSHA256Hash(data);
      }
      getMemoryUsage() {
        return ts.sys.getMemoryUsage();
      }
      exit(exitCode) {
        return ts.sys.exit(exitCode);
      }
      realpath(path) {
        return ts.sys.realpath(path);
      }
      setTimeout(callback, ms, ...args) {
        return ts.sys.setTimeout(callback, ms, ...args);
      }
      clearTimeout(timeoutId) {
        return ts.sys.clearTimeout(timeoutId);
      }
      clearScreen() {
        return ts.sys.clearScreen();
      }
      base64decode(input) {
        return ts.sys.base64decode(input);
      }
      base64encode(input) {
        return ts.sys.base64encode(input);
      }
      setImmediate(callback, ...args) {
        return setImmediate(callback, ...args);
      }
      clearImmediate(timeoutId) {
        return clearImmediate(timeoutId);
      }
      require(initialPath, moduleName) {
        if (moduleName !== "@angular/language-service") {
          return {
            module: void 0,
            error: new Error(`Angular server will not load plugin '${moduleName}'.`)
          };
        }
        try {
          const modulePath = require.resolve(moduleName, {
            paths: [initialPath]
          });
          return {
            module: require(modulePath),
            error: void 0
          };
        } catch (e) {
          return {
            module: void 0,
            error: e
          };
        }
      }
    };
    exports2.ServerHost = ServerHost;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/@angular+language-service@registry.npmjs.org+@angular+language-service+15.2.0/node_modules/@angular/language-service/api_bundle.js
var require_api_bundle = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/@angular+language-service@registry.npmjs.org+@angular+language-service+15.2.0/node_modules/@angular/language-service/api_bundle.js"(exports2, module2) {
    var __defProp = Object.defineProperty;
    var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
    var __getOwnPropNames2 = Object.getOwnPropertyNames;
    var __hasOwnProp = Object.prototype.hasOwnProperty;
    var __export = (target, all) => {
      for (var name in all)
        __defProp(target, name, { get: all[name], enumerable: true });
    };
    var __copyProps = (to, from, except, desc) => {
      if (from && typeof from === "object" || typeof from === "function") {
        for (let key of __getOwnPropNames2(from))
          if (!__hasOwnProp.call(to, key) && key !== except)
            __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
      }
      return to;
    };
    var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
    var api_exports = {};
    __export(api_exports, {
      isNgLanguageService: () => isNgLanguageService
    });
    module2.exports = __toCommonJS(api_exports);
    function isNgLanguageService(ls) {
      return "getTcb" in ls;
    }
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/common/notifications.js
var require_notifications = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/common/notifications.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.OpenOutputChannel = exports2.NgccProgressEnd = exports2.SuggestStrictMode = exports2.ProjectLanguageService = exports2.ProjectLoadingFinish = exports2.ProjectLoadingStart = void 0;
    var vscode_jsonrpc_1 = require("vscode-jsonrpc");
    exports2.ProjectLoadingStart = new vscode_jsonrpc_1.NotificationType0("angular/projectLoadingStart");
    exports2.ProjectLoadingFinish = new vscode_jsonrpc_1.NotificationType0("angular/projectLoadingFinish");
    exports2.ProjectLanguageService = new vscode_jsonrpc_1.NotificationType("angular/projectLanguageService");
    exports2.SuggestStrictMode = new vscode_jsonrpc_1.NotificationType("angular/suggestStrictMode");
    exports2.NgccProgressEnd = new vscode_jsonrpc_1.NotificationType("angular/NgccProgressEnd");
    exports2.OpenOutputChannel = new vscode_jsonrpc_1.NotificationType("angular/OpenOutputChannel");
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-types@registry.npmjs.org+vscode-languageserver-types+3.16.0/node_modules/vscode-languageserver-types/lib/umd/main.js
var require_main = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-types@registry.npmjs.org+vscode-languageserver-types+3.16.0/node_modules/vscode-languageserver-types/lib/umd/main.js"(exports2, module2) {
    (function(factory) {
      if (typeof module2 === "object" && typeof module2.exports === "object") {
        var v = factory(require, exports2);
        if (v !== void 0)
          module2.exports = v;
      } else if (typeof define === "function" && define.amd) {
        define(["require", "exports"], factory);
      }
    })(function(require2, exports3) {
      "use strict";
      Object.defineProperty(exports3, "__esModule", { value: true });
      exports3.TextDocument = exports3.EOL = exports3.SelectionRange = exports3.DocumentLink = exports3.FormattingOptions = exports3.CodeLens = exports3.CodeAction = exports3.CodeActionContext = exports3.CodeActionKind = exports3.DocumentSymbol = exports3.SymbolInformation = exports3.SymbolTag = exports3.SymbolKind = exports3.DocumentHighlight = exports3.DocumentHighlightKind = exports3.SignatureInformation = exports3.ParameterInformation = exports3.Hover = exports3.MarkedString = exports3.CompletionList = exports3.CompletionItem = exports3.InsertTextMode = exports3.InsertReplaceEdit = exports3.CompletionItemTag = exports3.InsertTextFormat = exports3.CompletionItemKind = exports3.MarkupContent = exports3.MarkupKind = exports3.TextDocumentItem = exports3.OptionalVersionedTextDocumentIdentifier = exports3.VersionedTextDocumentIdentifier = exports3.TextDocumentIdentifier = exports3.WorkspaceChange = exports3.WorkspaceEdit = exports3.DeleteFile = exports3.RenameFile = exports3.CreateFile = exports3.TextDocumentEdit = exports3.AnnotatedTextEdit = exports3.ChangeAnnotationIdentifier = exports3.ChangeAnnotation = exports3.TextEdit = exports3.Command = exports3.Diagnostic = exports3.CodeDescription = exports3.DiagnosticTag = exports3.DiagnosticSeverity = exports3.DiagnosticRelatedInformation = exports3.FoldingRange = exports3.FoldingRangeKind = exports3.ColorPresentation = exports3.ColorInformation = exports3.Color = exports3.LocationLink = exports3.Location = exports3.Range = exports3.Position = exports3.uinteger = exports3.integer = void 0;
      var integer;
      (function(integer2) {
        integer2.MIN_VALUE = -2147483648;
        integer2.MAX_VALUE = 2147483647;
      })(integer = exports3.integer || (exports3.integer = {}));
      var uinteger;
      (function(uinteger2) {
        uinteger2.MIN_VALUE = 0;
        uinteger2.MAX_VALUE = 2147483647;
      })(uinteger = exports3.uinteger || (exports3.uinteger = {}));
      var Position;
      (function(Position2) {
        function create(line, character) {
          if (line === Number.MAX_VALUE) {
            line = uinteger.MAX_VALUE;
          }
          if (character === Number.MAX_VALUE) {
            character = uinteger.MAX_VALUE;
          }
          return { line, character };
        }
        Position2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Is.uinteger(candidate.line) && Is.uinteger(candidate.character);
        }
        Position2.is = is;
      })(Position = exports3.Position || (exports3.Position = {}));
      var Range;
      (function(Range2) {
        function create(one, two, three, four) {
          if (Is.uinteger(one) && Is.uinteger(two) && Is.uinteger(three) && Is.uinteger(four)) {
            return { start: Position.create(one, two), end: Position.create(three, four) };
          } else if (Position.is(one) && Position.is(two)) {
            return { start: one, end: two };
          } else {
            throw new Error("Range#create called with invalid arguments[" + one + ", " + two + ", " + three + ", " + four + "]");
          }
        }
        Range2.create = create;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Position.is(candidate.start) && Position.is(candidate.end);
        }
        Range2.is = is;
      })(Range = exports3.Range || (exports3.Range = {}));
      var Location;
      (function(Location2) {
        function create(uri, range) {
          return { uri, range };
        }
        Location2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Range.is(candidate.range) && (Is.string(candidate.uri) || Is.undefined(candidate.uri));
        }
        Location2.is = is;
      })(Location = exports3.Location || (exports3.Location = {}));
      var LocationLink;
      (function(LocationLink2) {
        function create(targetUri, targetRange, targetSelectionRange, originSelectionRange) {
          return { targetUri, targetRange, targetSelectionRange, originSelectionRange };
        }
        LocationLink2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Range.is(candidate.targetRange) && Is.string(candidate.targetUri) && (Range.is(candidate.targetSelectionRange) || Is.undefined(candidate.targetSelectionRange)) && (Range.is(candidate.originSelectionRange) || Is.undefined(candidate.originSelectionRange));
        }
        LocationLink2.is = is;
      })(LocationLink = exports3.LocationLink || (exports3.LocationLink = {}));
      var Color;
      (function(Color2) {
        function create(red, green, blue, alpha) {
          return {
            red,
            green,
            blue,
            alpha
          };
        }
        Color2.create = create;
        function is(value) {
          var candidate = value;
          return Is.numberRange(candidate.red, 0, 1) && Is.numberRange(candidate.green, 0, 1) && Is.numberRange(candidate.blue, 0, 1) && Is.numberRange(candidate.alpha, 0, 1);
        }
        Color2.is = is;
      })(Color = exports3.Color || (exports3.Color = {}));
      var ColorInformation;
      (function(ColorInformation2) {
        function create(range, color) {
          return {
            range,
            color
          };
        }
        ColorInformation2.create = create;
        function is(value) {
          var candidate = value;
          return Range.is(candidate.range) && Color.is(candidate.color);
        }
        ColorInformation2.is = is;
      })(ColorInformation = exports3.ColorInformation || (exports3.ColorInformation = {}));
      var ColorPresentation;
      (function(ColorPresentation2) {
        function create(label, textEdit, additionalTextEdits) {
          return {
            label,
            textEdit,
            additionalTextEdits
          };
        }
        ColorPresentation2.create = create;
        function is(value) {
          var candidate = value;
          return Is.string(candidate.label) && (Is.undefined(candidate.textEdit) || TextEdit.is(candidate)) && (Is.undefined(candidate.additionalTextEdits) || Is.typedArray(candidate.additionalTextEdits, TextEdit.is));
        }
        ColorPresentation2.is = is;
      })(ColorPresentation = exports3.ColorPresentation || (exports3.ColorPresentation = {}));
      var FoldingRangeKind;
      (function(FoldingRangeKind2) {
        FoldingRangeKind2["Comment"] = "comment";
        FoldingRangeKind2["Imports"] = "imports";
        FoldingRangeKind2["Region"] = "region";
      })(FoldingRangeKind = exports3.FoldingRangeKind || (exports3.FoldingRangeKind = {}));
      var FoldingRange;
      (function(FoldingRange2) {
        function create(startLine, endLine, startCharacter, endCharacter, kind) {
          var result = {
            startLine,
            endLine
          };
          if (Is.defined(startCharacter)) {
            result.startCharacter = startCharacter;
          }
          if (Is.defined(endCharacter)) {
            result.endCharacter = endCharacter;
          }
          if (Is.defined(kind)) {
            result.kind = kind;
          }
          return result;
        }
        FoldingRange2.create = create;
        function is(value) {
          var candidate = value;
          return Is.uinteger(candidate.startLine) && Is.uinteger(candidate.startLine) && (Is.undefined(candidate.startCharacter) || Is.uinteger(candidate.startCharacter)) && (Is.undefined(candidate.endCharacter) || Is.uinteger(candidate.endCharacter)) && (Is.undefined(candidate.kind) || Is.string(candidate.kind));
        }
        FoldingRange2.is = is;
      })(FoldingRange = exports3.FoldingRange || (exports3.FoldingRange = {}));
      var DiagnosticRelatedInformation;
      (function(DiagnosticRelatedInformation2) {
        function create(location, message) {
          return {
            location,
            message
          };
        }
        DiagnosticRelatedInformation2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Location.is(candidate.location) && Is.string(candidate.message);
        }
        DiagnosticRelatedInformation2.is = is;
      })(DiagnosticRelatedInformation = exports3.DiagnosticRelatedInformation || (exports3.DiagnosticRelatedInformation = {}));
      var DiagnosticSeverity;
      (function(DiagnosticSeverity2) {
        DiagnosticSeverity2.Error = 1;
        DiagnosticSeverity2.Warning = 2;
        DiagnosticSeverity2.Information = 3;
        DiagnosticSeverity2.Hint = 4;
      })(DiagnosticSeverity = exports3.DiagnosticSeverity || (exports3.DiagnosticSeverity = {}));
      var DiagnosticTag;
      (function(DiagnosticTag2) {
        DiagnosticTag2.Unnecessary = 1;
        DiagnosticTag2.Deprecated = 2;
      })(DiagnosticTag = exports3.DiagnosticTag || (exports3.DiagnosticTag = {}));
      var CodeDescription;
      (function(CodeDescription2) {
        function is(value) {
          var candidate = value;
          return candidate !== void 0 && candidate !== null && Is.string(candidate.href);
        }
        CodeDescription2.is = is;
      })(CodeDescription = exports3.CodeDescription || (exports3.CodeDescription = {}));
      var Diagnostic;
      (function(Diagnostic2) {
        function create(range, message, severity, code, source, relatedInformation) {
          var result = { range, message };
          if (Is.defined(severity)) {
            result.severity = severity;
          }
          if (Is.defined(code)) {
            result.code = code;
          }
          if (Is.defined(source)) {
            result.source = source;
          }
          if (Is.defined(relatedInformation)) {
            result.relatedInformation = relatedInformation;
          }
          return result;
        }
        Diagnostic2.create = create;
        function is(value) {
          var _a;
          var candidate = value;
          return Is.defined(candidate) && Range.is(candidate.range) && Is.string(candidate.message) && (Is.number(candidate.severity) || Is.undefined(candidate.severity)) && (Is.integer(candidate.code) || Is.string(candidate.code) || Is.undefined(candidate.code)) && (Is.undefined(candidate.codeDescription) || Is.string((_a = candidate.codeDescription) === null || _a === void 0 ? void 0 : _a.href)) && (Is.string(candidate.source) || Is.undefined(candidate.source)) && (Is.undefined(candidate.relatedInformation) || Is.typedArray(candidate.relatedInformation, DiagnosticRelatedInformation.is));
        }
        Diagnostic2.is = is;
      })(Diagnostic = exports3.Diagnostic || (exports3.Diagnostic = {}));
      var Command;
      (function(Command2) {
        function create(title, command) {
          var args = [];
          for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
          }
          var result = { title, command };
          if (Is.defined(args) && args.length > 0) {
            result.arguments = args;
          }
          return result;
        }
        Command2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.title) && Is.string(candidate.command);
        }
        Command2.is = is;
      })(Command = exports3.Command || (exports3.Command = {}));
      var TextEdit;
      (function(TextEdit2) {
        function replace(range, newText) {
          return { range, newText };
        }
        TextEdit2.replace = replace;
        function insert(position, newText) {
          return { range: { start: position, end: position }, newText };
        }
        TextEdit2.insert = insert;
        function del(range) {
          return { range, newText: "" };
        }
        TextEdit2.del = del;
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(candidate) && Is.string(candidate.newText) && Range.is(candidate.range);
        }
        TextEdit2.is = is;
      })(TextEdit = exports3.TextEdit || (exports3.TextEdit = {}));
      var ChangeAnnotation;
      (function(ChangeAnnotation2) {
        function create(label, needsConfirmation, description) {
          var result = { label };
          if (needsConfirmation !== void 0) {
            result.needsConfirmation = needsConfirmation;
          }
          if (description !== void 0) {
            result.description = description;
          }
          return result;
        }
        ChangeAnnotation2.create = create;
        function is(value) {
          var candidate = value;
          return candidate !== void 0 && Is.objectLiteral(candidate) && Is.string(candidate.label) && (Is.boolean(candidate.needsConfirmation) || candidate.needsConfirmation === void 0) && (Is.string(candidate.description) || candidate.description === void 0);
        }
        ChangeAnnotation2.is = is;
      })(ChangeAnnotation = exports3.ChangeAnnotation || (exports3.ChangeAnnotation = {}));
      var ChangeAnnotationIdentifier;
      (function(ChangeAnnotationIdentifier2) {
        function is(value) {
          var candidate = value;
          return typeof candidate === "string";
        }
        ChangeAnnotationIdentifier2.is = is;
      })(ChangeAnnotationIdentifier = exports3.ChangeAnnotationIdentifier || (exports3.ChangeAnnotationIdentifier = {}));
      var AnnotatedTextEdit;
      (function(AnnotatedTextEdit2) {
        function replace(range, newText, annotation) {
          return { range, newText, annotationId: annotation };
        }
        AnnotatedTextEdit2.replace = replace;
        function insert(position, newText, annotation) {
          return { range: { start: position, end: position }, newText, annotationId: annotation };
        }
        AnnotatedTextEdit2.insert = insert;
        function del(range, annotation) {
          return { range, newText: "", annotationId: annotation };
        }
        AnnotatedTextEdit2.del = del;
        function is(value) {
          var candidate = value;
          return TextEdit.is(candidate) && (ChangeAnnotation.is(candidate.annotationId) || ChangeAnnotationIdentifier.is(candidate.annotationId));
        }
        AnnotatedTextEdit2.is = is;
      })(AnnotatedTextEdit = exports3.AnnotatedTextEdit || (exports3.AnnotatedTextEdit = {}));
      var TextDocumentEdit;
      (function(TextDocumentEdit2) {
        function create(textDocument, edits) {
          return { textDocument, edits };
        }
        TextDocumentEdit2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && OptionalVersionedTextDocumentIdentifier.is(candidate.textDocument) && Array.isArray(candidate.edits);
        }
        TextDocumentEdit2.is = is;
      })(TextDocumentEdit = exports3.TextDocumentEdit || (exports3.TextDocumentEdit = {}));
      var CreateFile;
      (function(CreateFile2) {
        function create(uri, options, annotation) {
          var result = {
            kind: "create",
            uri
          };
          if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
            result.options = options;
          }
          if (annotation !== void 0) {
            result.annotationId = annotation;
          }
          return result;
        }
        CreateFile2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && candidate.kind === "create" && Is.string(candidate.uri) && (candidate.options === void 0 || (candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
        }
        CreateFile2.is = is;
      })(CreateFile = exports3.CreateFile || (exports3.CreateFile = {}));
      var RenameFile;
      (function(RenameFile2) {
        function create(oldUri, newUri, options, annotation) {
          var result = {
            kind: "rename",
            oldUri,
            newUri
          };
          if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
            result.options = options;
          }
          if (annotation !== void 0) {
            result.annotationId = annotation;
          }
          return result;
        }
        RenameFile2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && candidate.kind === "rename" && Is.string(candidate.oldUri) && Is.string(candidate.newUri) && (candidate.options === void 0 || (candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
        }
        RenameFile2.is = is;
      })(RenameFile = exports3.RenameFile || (exports3.RenameFile = {}));
      var DeleteFile;
      (function(DeleteFile2) {
        function create(uri, options, annotation) {
          var result = {
            kind: "delete",
            uri
          };
          if (options !== void 0 && (options.recursive !== void 0 || options.ignoreIfNotExists !== void 0)) {
            result.options = options;
          }
          if (annotation !== void 0) {
            result.annotationId = annotation;
          }
          return result;
        }
        DeleteFile2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && candidate.kind === "delete" && Is.string(candidate.uri) && (candidate.options === void 0 || (candidate.options.recursive === void 0 || Is.boolean(candidate.options.recursive)) && (candidate.options.ignoreIfNotExists === void 0 || Is.boolean(candidate.options.ignoreIfNotExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
        }
        DeleteFile2.is = is;
      })(DeleteFile = exports3.DeleteFile || (exports3.DeleteFile = {}));
      var WorkspaceEdit;
      (function(WorkspaceEdit2) {
        function is(value) {
          var candidate = value;
          return candidate && (candidate.changes !== void 0 || candidate.documentChanges !== void 0) && (candidate.documentChanges === void 0 || candidate.documentChanges.every(function(change) {
            if (Is.string(change.kind)) {
              return CreateFile.is(change) || RenameFile.is(change) || DeleteFile.is(change);
            } else {
              return TextDocumentEdit.is(change);
            }
          }));
        }
        WorkspaceEdit2.is = is;
      })(WorkspaceEdit = exports3.WorkspaceEdit || (exports3.WorkspaceEdit = {}));
      var TextEditChangeImpl = function() {
        function TextEditChangeImpl2(edits, changeAnnotations) {
          this.edits = edits;
          this.changeAnnotations = changeAnnotations;
        }
        TextEditChangeImpl2.prototype.insert = function(position, newText, annotation) {
          var edit;
          var id;
          if (annotation === void 0) {
            edit = TextEdit.insert(position, newText);
          } else if (ChangeAnnotationIdentifier.is(annotation)) {
            id = annotation;
            edit = AnnotatedTextEdit.insert(position, newText, annotation);
          } else {
            this.assertChangeAnnotations(this.changeAnnotations);
            id = this.changeAnnotations.manage(annotation);
            edit = AnnotatedTextEdit.insert(position, newText, id);
          }
          this.edits.push(edit);
          if (id !== void 0) {
            return id;
          }
        };
        TextEditChangeImpl2.prototype.replace = function(range, newText, annotation) {
          var edit;
          var id;
          if (annotation === void 0) {
            edit = TextEdit.replace(range, newText);
          } else if (ChangeAnnotationIdentifier.is(annotation)) {
            id = annotation;
            edit = AnnotatedTextEdit.replace(range, newText, annotation);
          } else {
            this.assertChangeAnnotations(this.changeAnnotations);
            id = this.changeAnnotations.manage(annotation);
            edit = AnnotatedTextEdit.replace(range, newText, id);
          }
          this.edits.push(edit);
          if (id !== void 0) {
            return id;
          }
        };
        TextEditChangeImpl2.prototype.delete = function(range, annotation) {
          var edit;
          var id;
          if (annotation === void 0) {
            edit = TextEdit.del(range);
          } else if (ChangeAnnotationIdentifier.is(annotation)) {
            id = annotation;
            edit = AnnotatedTextEdit.del(range, annotation);
          } else {
            this.assertChangeAnnotations(this.changeAnnotations);
            id = this.changeAnnotations.manage(annotation);
            edit = AnnotatedTextEdit.del(range, id);
          }
          this.edits.push(edit);
          if (id !== void 0) {
            return id;
          }
        };
        TextEditChangeImpl2.prototype.add = function(edit) {
          this.edits.push(edit);
        };
        TextEditChangeImpl2.prototype.all = function() {
          return this.edits;
        };
        TextEditChangeImpl2.prototype.clear = function() {
          this.edits.splice(0, this.edits.length);
        };
        TextEditChangeImpl2.prototype.assertChangeAnnotations = function(value) {
          if (value === void 0) {
            throw new Error("Text edit change is not configured to manage change annotations.");
          }
        };
        return TextEditChangeImpl2;
      }();
      var ChangeAnnotations = function() {
        function ChangeAnnotations2(annotations) {
          this._annotations = annotations === void 0 ? /* @__PURE__ */ Object.create(null) : annotations;
          this._counter = 0;
          this._size = 0;
        }
        ChangeAnnotations2.prototype.all = function() {
          return this._annotations;
        };
        Object.defineProperty(ChangeAnnotations2.prototype, "size", {
          get: function() {
            return this._size;
          },
          enumerable: false,
          configurable: true
        });
        ChangeAnnotations2.prototype.manage = function(idOrAnnotation, annotation) {
          var id;
          if (ChangeAnnotationIdentifier.is(idOrAnnotation)) {
            id = idOrAnnotation;
          } else {
            id = this.nextId();
            annotation = idOrAnnotation;
          }
          if (this._annotations[id] !== void 0) {
            throw new Error("Id " + id + " is already in use.");
          }
          if (annotation === void 0) {
            throw new Error("No annotation provided for id " + id);
          }
          this._annotations[id] = annotation;
          this._size++;
          return id;
        };
        ChangeAnnotations2.prototype.nextId = function() {
          this._counter++;
          return this._counter.toString();
        };
        return ChangeAnnotations2;
      }();
      var WorkspaceChange = function() {
        function WorkspaceChange2(workspaceEdit) {
          var _this = this;
          this._textEditChanges = /* @__PURE__ */ Object.create(null);
          if (workspaceEdit !== void 0) {
            this._workspaceEdit = workspaceEdit;
            if (workspaceEdit.documentChanges) {
              this._changeAnnotations = new ChangeAnnotations(workspaceEdit.changeAnnotations);
              workspaceEdit.changeAnnotations = this._changeAnnotations.all();
              workspaceEdit.documentChanges.forEach(function(change) {
                if (TextDocumentEdit.is(change)) {
                  var textEditChange = new TextEditChangeImpl(change.edits, _this._changeAnnotations);
                  _this._textEditChanges[change.textDocument.uri] = textEditChange;
                }
              });
            } else if (workspaceEdit.changes) {
              Object.keys(workspaceEdit.changes).forEach(function(key) {
                var textEditChange = new TextEditChangeImpl(workspaceEdit.changes[key]);
                _this._textEditChanges[key] = textEditChange;
              });
            }
          } else {
            this._workspaceEdit = {};
          }
        }
        Object.defineProperty(WorkspaceChange2.prototype, "edit", {
          get: function() {
            this.initDocumentChanges();
            if (this._changeAnnotations !== void 0) {
              if (this._changeAnnotations.size === 0) {
                this._workspaceEdit.changeAnnotations = void 0;
              } else {
                this._workspaceEdit.changeAnnotations = this._changeAnnotations.all();
              }
            }
            return this._workspaceEdit;
          },
          enumerable: false,
          configurable: true
        });
        WorkspaceChange2.prototype.getTextEditChange = function(key) {
          if (OptionalVersionedTextDocumentIdentifier.is(key)) {
            this.initDocumentChanges();
            if (this._workspaceEdit.documentChanges === void 0) {
              throw new Error("Workspace edit is not configured for document changes.");
            }
            var textDocument = { uri: key.uri, version: key.version };
            var result = this._textEditChanges[textDocument.uri];
            if (!result) {
              var edits = [];
              var textDocumentEdit = {
                textDocument,
                edits
              };
              this._workspaceEdit.documentChanges.push(textDocumentEdit);
              result = new TextEditChangeImpl(edits, this._changeAnnotations);
              this._textEditChanges[textDocument.uri] = result;
            }
            return result;
          } else {
            this.initChanges();
            if (this._workspaceEdit.changes === void 0) {
              throw new Error("Workspace edit is not configured for normal text edit changes.");
            }
            var result = this._textEditChanges[key];
            if (!result) {
              var edits = [];
              this._workspaceEdit.changes[key] = edits;
              result = new TextEditChangeImpl(edits);
              this._textEditChanges[key] = result;
            }
            return result;
          }
        };
        WorkspaceChange2.prototype.initDocumentChanges = function() {
          if (this._workspaceEdit.documentChanges === void 0 && this._workspaceEdit.changes === void 0) {
            this._changeAnnotations = new ChangeAnnotations();
            this._workspaceEdit.documentChanges = [];
            this._workspaceEdit.changeAnnotations = this._changeAnnotations.all();
          }
        };
        WorkspaceChange2.prototype.initChanges = function() {
          if (this._workspaceEdit.documentChanges === void 0 && this._workspaceEdit.changes === void 0) {
            this._workspaceEdit.changes = /* @__PURE__ */ Object.create(null);
          }
        };
        WorkspaceChange2.prototype.createFile = function(uri, optionsOrAnnotation, options) {
          this.initDocumentChanges();
          if (this._workspaceEdit.documentChanges === void 0) {
            throw new Error("Workspace edit is not configured for document changes.");
          }
          var annotation;
          if (ChangeAnnotation.is(optionsOrAnnotation) || ChangeAnnotationIdentifier.is(optionsOrAnnotation)) {
            annotation = optionsOrAnnotation;
          } else {
            options = optionsOrAnnotation;
          }
          var operation;
          var id;
          if (annotation === void 0) {
            operation = CreateFile.create(uri, options);
          } else {
            id = ChangeAnnotationIdentifier.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
            operation = CreateFile.create(uri, options, id);
          }
          this._workspaceEdit.documentChanges.push(operation);
          if (id !== void 0) {
            return id;
          }
        };
        WorkspaceChange2.prototype.renameFile = function(oldUri, newUri, optionsOrAnnotation, options) {
          this.initDocumentChanges();
          if (this._workspaceEdit.documentChanges === void 0) {
            throw new Error("Workspace edit is not configured for document changes.");
          }
          var annotation;
          if (ChangeAnnotation.is(optionsOrAnnotation) || ChangeAnnotationIdentifier.is(optionsOrAnnotation)) {
            annotation = optionsOrAnnotation;
          } else {
            options = optionsOrAnnotation;
          }
          var operation;
          var id;
          if (annotation === void 0) {
            operation = RenameFile.create(oldUri, newUri, options);
          } else {
            id = ChangeAnnotationIdentifier.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
            operation = RenameFile.create(oldUri, newUri, options, id);
          }
          this._workspaceEdit.documentChanges.push(operation);
          if (id !== void 0) {
            return id;
          }
        };
        WorkspaceChange2.prototype.deleteFile = function(uri, optionsOrAnnotation, options) {
          this.initDocumentChanges();
          if (this._workspaceEdit.documentChanges === void 0) {
            throw new Error("Workspace edit is not configured for document changes.");
          }
          var annotation;
          if (ChangeAnnotation.is(optionsOrAnnotation) || ChangeAnnotationIdentifier.is(optionsOrAnnotation)) {
            annotation = optionsOrAnnotation;
          } else {
            options = optionsOrAnnotation;
          }
          var operation;
          var id;
          if (annotation === void 0) {
            operation = DeleteFile.create(uri, options);
          } else {
            id = ChangeAnnotationIdentifier.is(annotation) ? annotation : this._changeAnnotations.manage(annotation);
            operation = DeleteFile.create(uri, options, id);
          }
          this._workspaceEdit.documentChanges.push(operation);
          if (id !== void 0) {
            return id;
          }
        };
        return WorkspaceChange2;
      }();
      exports3.WorkspaceChange = WorkspaceChange;
      var TextDocumentIdentifier;
      (function(TextDocumentIdentifier2) {
        function create(uri) {
          return { uri };
        }
        TextDocumentIdentifier2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri);
        }
        TextDocumentIdentifier2.is = is;
      })(TextDocumentIdentifier = exports3.TextDocumentIdentifier || (exports3.TextDocumentIdentifier = {}));
      var VersionedTextDocumentIdentifier;
      (function(VersionedTextDocumentIdentifier2) {
        function create(uri, version) {
          return { uri, version };
        }
        VersionedTextDocumentIdentifier2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri) && Is.integer(candidate.version);
        }
        VersionedTextDocumentIdentifier2.is = is;
      })(VersionedTextDocumentIdentifier = exports3.VersionedTextDocumentIdentifier || (exports3.VersionedTextDocumentIdentifier = {}));
      var OptionalVersionedTextDocumentIdentifier;
      (function(OptionalVersionedTextDocumentIdentifier2) {
        function create(uri, version) {
          return { uri, version };
        }
        OptionalVersionedTextDocumentIdentifier2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri) && (candidate.version === null || Is.integer(candidate.version));
        }
        OptionalVersionedTextDocumentIdentifier2.is = is;
      })(OptionalVersionedTextDocumentIdentifier = exports3.OptionalVersionedTextDocumentIdentifier || (exports3.OptionalVersionedTextDocumentIdentifier = {}));
      var TextDocumentItem;
      (function(TextDocumentItem2) {
        function create(uri, languageId, version, text) {
          return { uri, languageId, version, text };
        }
        TextDocumentItem2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri) && Is.string(candidate.languageId) && Is.integer(candidate.version) && Is.string(candidate.text);
        }
        TextDocumentItem2.is = is;
      })(TextDocumentItem = exports3.TextDocumentItem || (exports3.TextDocumentItem = {}));
      var MarkupKind;
      (function(MarkupKind2) {
        MarkupKind2.PlainText = "plaintext";
        MarkupKind2.Markdown = "markdown";
      })(MarkupKind = exports3.MarkupKind || (exports3.MarkupKind = {}));
      (function(MarkupKind2) {
        function is(value) {
          var candidate = value;
          return candidate === MarkupKind2.PlainText || candidate === MarkupKind2.Markdown;
        }
        MarkupKind2.is = is;
      })(MarkupKind = exports3.MarkupKind || (exports3.MarkupKind = {}));
      var MarkupContent;
      (function(MarkupContent2) {
        function is(value) {
          var candidate = value;
          return Is.objectLiteral(value) && MarkupKind.is(candidate.kind) && Is.string(candidate.value);
        }
        MarkupContent2.is = is;
      })(MarkupContent = exports3.MarkupContent || (exports3.MarkupContent = {}));
      var CompletionItemKind;
      (function(CompletionItemKind2) {
        CompletionItemKind2.Text = 1;
        CompletionItemKind2.Method = 2;
        CompletionItemKind2.Function = 3;
        CompletionItemKind2.Constructor = 4;
        CompletionItemKind2.Field = 5;
        CompletionItemKind2.Variable = 6;
        CompletionItemKind2.Class = 7;
        CompletionItemKind2.Interface = 8;
        CompletionItemKind2.Module = 9;
        CompletionItemKind2.Property = 10;
        CompletionItemKind2.Unit = 11;
        CompletionItemKind2.Value = 12;
        CompletionItemKind2.Enum = 13;
        CompletionItemKind2.Keyword = 14;
        CompletionItemKind2.Snippet = 15;
        CompletionItemKind2.Color = 16;
        CompletionItemKind2.File = 17;
        CompletionItemKind2.Reference = 18;
        CompletionItemKind2.Folder = 19;
        CompletionItemKind2.EnumMember = 20;
        CompletionItemKind2.Constant = 21;
        CompletionItemKind2.Struct = 22;
        CompletionItemKind2.Event = 23;
        CompletionItemKind2.Operator = 24;
        CompletionItemKind2.TypeParameter = 25;
      })(CompletionItemKind = exports3.CompletionItemKind || (exports3.CompletionItemKind = {}));
      var InsertTextFormat;
      (function(InsertTextFormat2) {
        InsertTextFormat2.PlainText = 1;
        InsertTextFormat2.Snippet = 2;
      })(InsertTextFormat = exports3.InsertTextFormat || (exports3.InsertTextFormat = {}));
      var CompletionItemTag;
      (function(CompletionItemTag2) {
        CompletionItemTag2.Deprecated = 1;
      })(CompletionItemTag = exports3.CompletionItemTag || (exports3.CompletionItemTag = {}));
      var InsertReplaceEdit;
      (function(InsertReplaceEdit2) {
        function create(newText, insert, replace) {
          return { newText, insert, replace };
        }
        InsertReplaceEdit2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && Is.string(candidate.newText) && Range.is(candidate.insert) && Range.is(candidate.replace);
        }
        InsertReplaceEdit2.is = is;
      })(InsertReplaceEdit = exports3.InsertReplaceEdit || (exports3.InsertReplaceEdit = {}));
      var InsertTextMode;
      (function(InsertTextMode2) {
        InsertTextMode2.asIs = 1;
        InsertTextMode2.adjustIndentation = 2;
      })(InsertTextMode = exports3.InsertTextMode || (exports3.InsertTextMode = {}));
      var CompletionItem;
      (function(CompletionItem2) {
        function create(label) {
          return { label };
        }
        CompletionItem2.create = create;
      })(CompletionItem = exports3.CompletionItem || (exports3.CompletionItem = {}));
      var CompletionList;
      (function(CompletionList2) {
        function create(items, isIncomplete) {
          return { items: items ? items : [], isIncomplete: !!isIncomplete };
        }
        CompletionList2.create = create;
      })(CompletionList = exports3.CompletionList || (exports3.CompletionList = {}));
      var MarkedString;
      (function(MarkedString2) {
        function fromPlainText(plainText) {
          return plainText.replace(/[\\`*_{}[\]()#+\-.!]/g, "\\$&");
        }
        MarkedString2.fromPlainText = fromPlainText;
        function is(value) {
          var candidate = value;
          return Is.string(candidate) || Is.objectLiteral(candidate) && Is.string(candidate.language) && Is.string(candidate.value);
        }
        MarkedString2.is = is;
      })(MarkedString = exports3.MarkedString || (exports3.MarkedString = {}));
      var Hover;
      (function(Hover2) {
        function is(value) {
          var candidate = value;
          return !!candidate && Is.objectLiteral(candidate) && (MarkupContent.is(candidate.contents) || MarkedString.is(candidate.contents) || Is.typedArray(candidate.contents, MarkedString.is)) && (value.range === void 0 || Range.is(value.range));
        }
        Hover2.is = is;
      })(Hover = exports3.Hover || (exports3.Hover = {}));
      var ParameterInformation;
      (function(ParameterInformation2) {
        function create(label, documentation) {
          return documentation ? { label, documentation } : { label };
        }
        ParameterInformation2.create = create;
      })(ParameterInformation = exports3.ParameterInformation || (exports3.ParameterInformation = {}));
      var SignatureInformation;
      (function(SignatureInformation2) {
        function create(label, documentation) {
          var parameters = [];
          for (var _i = 2; _i < arguments.length; _i++) {
            parameters[_i - 2] = arguments[_i];
          }
          var result = { label };
          if (Is.defined(documentation)) {
            result.documentation = documentation;
          }
          if (Is.defined(parameters)) {
            result.parameters = parameters;
          } else {
            result.parameters = [];
          }
          return result;
        }
        SignatureInformation2.create = create;
      })(SignatureInformation = exports3.SignatureInformation || (exports3.SignatureInformation = {}));
      var DocumentHighlightKind;
      (function(DocumentHighlightKind2) {
        DocumentHighlightKind2.Text = 1;
        DocumentHighlightKind2.Read = 2;
        DocumentHighlightKind2.Write = 3;
      })(DocumentHighlightKind = exports3.DocumentHighlightKind || (exports3.DocumentHighlightKind = {}));
      var DocumentHighlight;
      (function(DocumentHighlight2) {
        function create(range, kind) {
          var result = { range };
          if (Is.number(kind)) {
            result.kind = kind;
          }
          return result;
        }
        DocumentHighlight2.create = create;
      })(DocumentHighlight = exports3.DocumentHighlight || (exports3.DocumentHighlight = {}));
      var SymbolKind;
      (function(SymbolKind2) {
        SymbolKind2.File = 1;
        SymbolKind2.Module = 2;
        SymbolKind2.Namespace = 3;
        SymbolKind2.Package = 4;
        SymbolKind2.Class = 5;
        SymbolKind2.Method = 6;
        SymbolKind2.Property = 7;
        SymbolKind2.Field = 8;
        SymbolKind2.Constructor = 9;
        SymbolKind2.Enum = 10;
        SymbolKind2.Interface = 11;
        SymbolKind2.Function = 12;
        SymbolKind2.Variable = 13;
        SymbolKind2.Constant = 14;
        SymbolKind2.String = 15;
        SymbolKind2.Number = 16;
        SymbolKind2.Boolean = 17;
        SymbolKind2.Array = 18;
        SymbolKind2.Object = 19;
        SymbolKind2.Key = 20;
        SymbolKind2.Null = 21;
        SymbolKind2.EnumMember = 22;
        SymbolKind2.Struct = 23;
        SymbolKind2.Event = 24;
        SymbolKind2.Operator = 25;
        SymbolKind2.TypeParameter = 26;
      })(SymbolKind = exports3.SymbolKind || (exports3.SymbolKind = {}));
      var SymbolTag;
      (function(SymbolTag2) {
        SymbolTag2.Deprecated = 1;
      })(SymbolTag = exports3.SymbolTag || (exports3.SymbolTag = {}));
      var SymbolInformation;
      (function(SymbolInformation2) {
        function create(name, kind, range, uri, containerName) {
          var result = {
            name,
            kind,
            location: { uri, range }
          };
          if (containerName) {
            result.containerName = containerName;
          }
          return result;
        }
        SymbolInformation2.create = create;
      })(SymbolInformation = exports3.SymbolInformation || (exports3.SymbolInformation = {}));
      var DocumentSymbol;
      (function(DocumentSymbol2) {
        function create(name, detail, kind, range, selectionRange, children) {
          var result = {
            name,
            detail,
            kind,
            range,
            selectionRange
          };
          if (children !== void 0) {
            result.children = children;
          }
          return result;
        }
        DocumentSymbol2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && Is.string(candidate.name) && Is.number(candidate.kind) && Range.is(candidate.range) && Range.is(candidate.selectionRange) && (candidate.detail === void 0 || Is.string(candidate.detail)) && (candidate.deprecated === void 0 || Is.boolean(candidate.deprecated)) && (candidate.children === void 0 || Array.isArray(candidate.children)) && (candidate.tags === void 0 || Array.isArray(candidate.tags));
        }
        DocumentSymbol2.is = is;
      })(DocumentSymbol = exports3.DocumentSymbol || (exports3.DocumentSymbol = {}));
      var CodeActionKind;
      (function(CodeActionKind2) {
        CodeActionKind2.Empty = "";
        CodeActionKind2.QuickFix = "quickfix";
        CodeActionKind2.Refactor = "refactor";
        CodeActionKind2.RefactorExtract = "refactor.extract";
        CodeActionKind2.RefactorInline = "refactor.inline";
        CodeActionKind2.RefactorRewrite = "refactor.rewrite";
        CodeActionKind2.Source = "source";
        CodeActionKind2.SourceOrganizeImports = "source.organizeImports";
        CodeActionKind2.SourceFixAll = "source.fixAll";
      })(CodeActionKind = exports3.CodeActionKind || (exports3.CodeActionKind = {}));
      var CodeActionContext;
      (function(CodeActionContext2) {
        function create(diagnostics, only) {
          var result = { diagnostics };
          if (only !== void 0 && only !== null) {
            result.only = only;
          }
          return result;
        }
        CodeActionContext2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.typedArray(candidate.diagnostics, Diagnostic.is) && (candidate.only === void 0 || Is.typedArray(candidate.only, Is.string));
        }
        CodeActionContext2.is = is;
      })(CodeActionContext = exports3.CodeActionContext || (exports3.CodeActionContext = {}));
      var CodeAction;
      (function(CodeAction2) {
        function create(title, kindOrCommandOrEdit, kind) {
          var result = { title };
          var checkKind = true;
          if (typeof kindOrCommandOrEdit === "string") {
            checkKind = false;
            result.kind = kindOrCommandOrEdit;
          } else if (Command.is(kindOrCommandOrEdit)) {
            result.command = kindOrCommandOrEdit;
          } else {
            result.edit = kindOrCommandOrEdit;
          }
          if (checkKind && kind !== void 0) {
            result.kind = kind;
          }
          return result;
        }
        CodeAction2.create = create;
        function is(value) {
          var candidate = value;
          return candidate && Is.string(candidate.title) && (candidate.diagnostics === void 0 || Is.typedArray(candidate.diagnostics, Diagnostic.is)) && (candidate.kind === void 0 || Is.string(candidate.kind)) && (candidate.edit !== void 0 || candidate.command !== void 0) && (candidate.command === void 0 || Command.is(candidate.command)) && (candidate.isPreferred === void 0 || Is.boolean(candidate.isPreferred)) && (candidate.edit === void 0 || WorkspaceEdit.is(candidate.edit));
        }
        CodeAction2.is = is;
      })(CodeAction = exports3.CodeAction || (exports3.CodeAction = {}));
      var CodeLens;
      (function(CodeLens2) {
        function create(range, data) {
          var result = { range };
          if (Is.defined(data)) {
            result.data = data;
          }
          return result;
        }
        CodeLens2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.command) || Command.is(candidate.command));
        }
        CodeLens2.is = is;
      })(CodeLens = exports3.CodeLens || (exports3.CodeLens = {}));
      var FormattingOptions;
      (function(FormattingOptions2) {
        function create(tabSize, insertSpaces) {
          return { tabSize, insertSpaces };
        }
        FormattingOptions2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.uinteger(candidate.tabSize) && Is.boolean(candidate.insertSpaces);
        }
        FormattingOptions2.is = is;
      })(FormattingOptions = exports3.FormattingOptions || (exports3.FormattingOptions = {}));
      var DocumentLink;
      (function(DocumentLink2) {
        function create(range, target, data) {
          return { range, target, data };
        }
        DocumentLink2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.target) || Is.string(candidate.target));
        }
        DocumentLink2.is = is;
      })(DocumentLink = exports3.DocumentLink || (exports3.DocumentLink = {}));
      var SelectionRange;
      (function(SelectionRange2) {
        function create(range, parent) {
          return { range, parent };
        }
        SelectionRange2.create = create;
        function is(value) {
          var candidate = value;
          return candidate !== void 0 && Range.is(candidate.range) && (candidate.parent === void 0 || SelectionRange2.is(candidate.parent));
        }
        SelectionRange2.is = is;
      })(SelectionRange = exports3.SelectionRange || (exports3.SelectionRange = {}));
      exports3.EOL = ["\n", "\r\n", "\r"];
      var TextDocument;
      (function(TextDocument2) {
        function create(uri, languageId, version, content) {
          return new FullTextDocument(uri, languageId, version, content);
        }
        TextDocument2.create = create;
        function is(value) {
          var candidate = value;
          return Is.defined(candidate) && Is.string(candidate.uri) && (Is.undefined(candidate.languageId) || Is.string(candidate.languageId)) && Is.uinteger(candidate.lineCount) && Is.func(candidate.getText) && Is.func(candidate.positionAt) && Is.func(candidate.offsetAt) ? true : false;
        }
        TextDocument2.is = is;
        function applyEdits(document, edits) {
          var text = document.getText();
          var sortedEdits = mergeSort(edits, function(a, b) {
            var diff = a.range.start.line - b.range.start.line;
            if (diff === 0) {
              return a.range.start.character - b.range.start.character;
            }
            return diff;
          });
          var lastModifiedOffset = text.length;
          for (var i = sortedEdits.length - 1; i >= 0; i--) {
            var e = sortedEdits[i];
            var startOffset = document.offsetAt(e.range.start);
            var endOffset = document.offsetAt(e.range.end);
            if (endOffset <= lastModifiedOffset) {
              text = text.substring(0, startOffset) + e.newText + text.substring(endOffset, text.length);
            } else {
              throw new Error("Overlapping edit");
            }
            lastModifiedOffset = startOffset;
          }
          return text;
        }
        TextDocument2.applyEdits = applyEdits;
        function mergeSort(data, compare) {
          if (data.length <= 1) {
            return data;
          }
          var p = data.length / 2 | 0;
          var left = data.slice(0, p);
          var right = data.slice(p);
          mergeSort(left, compare);
          mergeSort(right, compare);
          var leftIdx = 0;
          var rightIdx = 0;
          var i = 0;
          while (leftIdx < left.length && rightIdx < right.length) {
            var ret = compare(left[leftIdx], right[rightIdx]);
            if (ret <= 0) {
              data[i++] = left[leftIdx++];
            } else {
              data[i++] = right[rightIdx++];
            }
          }
          while (leftIdx < left.length) {
            data[i++] = left[leftIdx++];
          }
          while (rightIdx < right.length) {
            data[i++] = right[rightIdx++];
          }
          return data;
        }
      })(TextDocument = exports3.TextDocument || (exports3.TextDocument = {}));
      var FullTextDocument = function() {
        function FullTextDocument2(uri, languageId, version, content) {
          this._uri = uri;
          this._languageId = languageId;
          this._version = version;
          this._content = content;
          this._lineOffsets = void 0;
        }
        Object.defineProperty(FullTextDocument2.prototype, "uri", {
          get: function() {
            return this._uri;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(FullTextDocument2.prototype, "languageId", {
          get: function() {
            return this._languageId;
          },
          enumerable: false,
          configurable: true
        });
        Object.defineProperty(FullTextDocument2.prototype, "version", {
          get: function() {
            return this._version;
          },
          enumerable: false,
          configurable: true
        });
        FullTextDocument2.prototype.getText = function(range) {
          if (range) {
            var start = this.offsetAt(range.start);
            var end = this.offsetAt(range.end);
            return this._content.substring(start, end);
          }
          return this._content;
        };
        FullTextDocument2.prototype.update = function(event, version) {
          this._content = event.text;
          this._version = version;
          this._lineOffsets = void 0;
        };
        FullTextDocument2.prototype.getLineOffsets = function() {
          if (this._lineOffsets === void 0) {
            var lineOffsets = [];
            var text = this._content;
            var isLineStart = true;
            for (var i = 0; i < text.length; i++) {
              if (isLineStart) {
                lineOffsets.push(i);
                isLineStart = false;
              }
              var ch = text.charAt(i);
              isLineStart = ch === "\r" || ch === "\n";
              if (ch === "\r" && i + 1 < text.length && text.charAt(i + 1) === "\n") {
                i++;
              }
            }
            if (isLineStart && text.length > 0) {
              lineOffsets.push(text.length);
            }
            this._lineOffsets = lineOffsets;
          }
          return this._lineOffsets;
        };
        FullTextDocument2.prototype.positionAt = function(offset) {
          offset = Math.max(Math.min(offset, this._content.length), 0);
          var lineOffsets = this.getLineOffsets();
          var low = 0, high = lineOffsets.length;
          if (high === 0) {
            return Position.create(0, offset);
          }
          while (low < high) {
            var mid = Math.floor((low + high) / 2);
            if (lineOffsets[mid] > offset) {
              high = mid;
            } else {
              low = mid + 1;
            }
          }
          var line = low - 1;
          return Position.create(line, offset - lineOffsets[line]);
        };
        FullTextDocument2.prototype.offsetAt = function(position) {
          var lineOffsets = this.getLineOffsets();
          if (position.line >= lineOffsets.length) {
            return this._content.length;
          } else if (position.line < 0) {
            return 0;
          }
          var lineOffset = lineOffsets[position.line];
          var nextLineOffset = position.line + 1 < lineOffsets.length ? lineOffsets[position.line + 1] : this._content.length;
          return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
        };
        Object.defineProperty(FullTextDocument2.prototype, "lineCount", {
          get: function() {
            return this.getLineOffsets().length;
          },
          enumerable: false,
          configurable: true
        });
        return FullTextDocument2;
      }();
      var Is;
      (function(Is2) {
        var toString = Object.prototype.toString;
        function defined(value) {
          return typeof value !== "undefined";
        }
        Is2.defined = defined;
        function undefined2(value) {
          return typeof value === "undefined";
        }
        Is2.undefined = undefined2;
        function boolean(value) {
          return value === true || value === false;
        }
        Is2.boolean = boolean;
        function string(value) {
          return toString.call(value) === "[object String]";
        }
        Is2.string = string;
        function number(value) {
          return toString.call(value) === "[object Number]";
        }
        Is2.number = number;
        function numberRange(value, min, max) {
          return toString.call(value) === "[object Number]" && min <= value && value <= max;
        }
        Is2.numberRange = numberRange;
        function integer2(value) {
          return toString.call(value) === "[object Number]" && -2147483648 <= value && value <= 2147483647;
        }
        Is2.integer = integer2;
        function uinteger2(value) {
          return toString.call(value) === "[object Number]" && 0 <= value && value <= 2147483647;
        }
        Is2.uinteger = uinteger2;
        function func(value) {
          return toString.call(value) === "[object Function]";
        }
        Is2.func = func;
        function objectLiteral(value) {
          return value !== null && typeof value === "object";
        }
        Is2.objectLiteral = objectLiteral;
        function typedArray(value, check) {
          return Array.isArray(value) && value.every(check);
        }
        Is2.typedArray = typedArray;
      })(Is || (Is = {}));
    });
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/messages.js
var require_messages = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/messages.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ProtocolNotificationType = exports2.ProtocolNotificationType0 = exports2.ProtocolRequestType = exports2.ProtocolRequestType0 = exports2.RegistrationType = void 0;
    var vscode_jsonrpc_1 = require("vscode-jsonrpc");
    var RegistrationType = class {
      constructor(method) {
        this.method = method;
      }
    };
    exports2.RegistrationType = RegistrationType;
    var ProtocolRequestType0 = class extends vscode_jsonrpc_1.RequestType0 {
      constructor(method) {
        super(method);
      }
    };
    exports2.ProtocolRequestType0 = ProtocolRequestType0;
    var ProtocolRequestType = class extends vscode_jsonrpc_1.RequestType {
      constructor(method) {
        super(method, vscode_jsonrpc_1.ParameterStructures.byName);
      }
    };
    exports2.ProtocolRequestType = ProtocolRequestType;
    var ProtocolNotificationType0 = class extends vscode_jsonrpc_1.NotificationType0 {
      constructor(method) {
        super(method);
      }
    };
    exports2.ProtocolNotificationType0 = ProtocolNotificationType0;
    var ProtocolNotificationType = class extends vscode_jsonrpc_1.NotificationType {
      constructor(method) {
        super(method, vscode_jsonrpc_1.ParameterStructures.byName);
      }
    };
    exports2.ProtocolNotificationType = ProtocolNotificationType;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/utils/is.js
var require_is = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/utils/is.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.objectLiteral = exports2.typedArray = exports2.stringArray = exports2.array = exports2.func = exports2.error = exports2.number = exports2.string = exports2.boolean = void 0;
    function boolean(value) {
      return value === true || value === false;
    }
    exports2.boolean = boolean;
    function string(value) {
      return typeof value === "string" || value instanceof String;
    }
    exports2.string = string;
    function number(value) {
      return typeof value === "number" || value instanceof Number;
    }
    exports2.number = number;
    function error(value) {
      return value instanceof Error;
    }
    exports2.error = error;
    function func(value) {
      return typeof value === "function";
    }
    exports2.func = func;
    function array(value) {
      return Array.isArray(value);
    }
    exports2.array = array;
    function stringArray(value) {
      return array(value) && value.every((elem) => string(elem));
    }
    exports2.stringArray = stringArray;
    function typedArray(value, check) {
      return Array.isArray(value) && value.every(check);
    }
    exports2.typedArray = typedArray;
    function objectLiteral(value) {
      return value !== null && typeof value === "object";
    }
    exports2.objectLiteral = objectLiteral;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.implementation.js
var require_protocol_implementation = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.implementation.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ImplementationRequest = void 0;
    var messages_1 = require_messages();
    var ImplementationRequest;
    (function(ImplementationRequest2) {
      ImplementationRequest2.method = "textDocument/implementation";
      ImplementationRequest2.type = new messages_1.ProtocolRequestType(ImplementationRequest2.method);
    })(ImplementationRequest = exports2.ImplementationRequest || (exports2.ImplementationRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.typeDefinition.js
var require_protocol_typeDefinition = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.typeDefinition.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.TypeDefinitionRequest = void 0;
    var messages_1 = require_messages();
    var TypeDefinitionRequest;
    (function(TypeDefinitionRequest2) {
      TypeDefinitionRequest2.method = "textDocument/typeDefinition";
      TypeDefinitionRequest2.type = new messages_1.ProtocolRequestType(TypeDefinitionRequest2.method);
    })(TypeDefinitionRequest = exports2.TypeDefinitionRequest || (exports2.TypeDefinitionRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.workspaceFolders.js
var require_protocol_workspaceFolders = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.workspaceFolders.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DidChangeWorkspaceFoldersNotification = exports2.WorkspaceFoldersRequest = void 0;
    var messages_1 = require_messages();
    var WorkspaceFoldersRequest;
    (function(WorkspaceFoldersRequest2) {
      WorkspaceFoldersRequest2.type = new messages_1.ProtocolRequestType0("workspace/workspaceFolders");
    })(WorkspaceFoldersRequest = exports2.WorkspaceFoldersRequest || (exports2.WorkspaceFoldersRequest = {}));
    var DidChangeWorkspaceFoldersNotification;
    (function(DidChangeWorkspaceFoldersNotification2) {
      DidChangeWorkspaceFoldersNotification2.type = new messages_1.ProtocolNotificationType("workspace/didChangeWorkspaceFolders");
    })(DidChangeWorkspaceFoldersNotification = exports2.DidChangeWorkspaceFoldersNotification || (exports2.DidChangeWorkspaceFoldersNotification = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.configuration.js
var require_protocol_configuration = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.configuration.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ConfigurationRequest = void 0;
    var messages_1 = require_messages();
    var ConfigurationRequest;
    (function(ConfigurationRequest2) {
      ConfigurationRequest2.type = new messages_1.ProtocolRequestType("workspace/configuration");
    })(ConfigurationRequest = exports2.ConfigurationRequest || (exports2.ConfigurationRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.colorProvider.js
var require_protocol_colorProvider = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.colorProvider.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ColorPresentationRequest = exports2.DocumentColorRequest = void 0;
    var messages_1 = require_messages();
    var DocumentColorRequest;
    (function(DocumentColorRequest2) {
      DocumentColorRequest2.method = "textDocument/documentColor";
      DocumentColorRequest2.type = new messages_1.ProtocolRequestType(DocumentColorRequest2.method);
    })(DocumentColorRequest = exports2.DocumentColorRequest || (exports2.DocumentColorRequest = {}));
    var ColorPresentationRequest;
    (function(ColorPresentationRequest2) {
      ColorPresentationRequest2.type = new messages_1.ProtocolRequestType("textDocument/colorPresentation");
    })(ColorPresentationRequest = exports2.ColorPresentationRequest || (exports2.ColorPresentationRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.foldingRange.js
var require_protocol_foldingRange = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.foldingRange.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.FoldingRangeRequest = exports2.FoldingRangeKind = void 0;
    var messages_1 = require_messages();
    var FoldingRangeKind;
    (function(FoldingRangeKind2) {
      FoldingRangeKind2["Comment"] = "comment";
      FoldingRangeKind2["Imports"] = "imports";
      FoldingRangeKind2["Region"] = "region";
    })(FoldingRangeKind = exports2.FoldingRangeKind || (exports2.FoldingRangeKind = {}));
    var FoldingRangeRequest;
    (function(FoldingRangeRequest2) {
      FoldingRangeRequest2.method = "textDocument/foldingRange";
      FoldingRangeRequest2.type = new messages_1.ProtocolRequestType(FoldingRangeRequest2.method);
    })(FoldingRangeRequest = exports2.FoldingRangeRequest || (exports2.FoldingRangeRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.declaration.js
var require_protocol_declaration = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.declaration.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DeclarationRequest = void 0;
    var messages_1 = require_messages();
    var DeclarationRequest;
    (function(DeclarationRequest2) {
      DeclarationRequest2.method = "textDocument/declaration";
      DeclarationRequest2.type = new messages_1.ProtocolRequestType(DeclarationRequest2.method);
    })(DeclarationRequest = exports2.DeclarationRequest || (exports2.DeclarationRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.selectionRange.js
var require_protocol_selectionRange = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.selectionRange.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SelectionRangeRequest = void 0;
    var messages_1 = require_messages();
    var SelectionRangeRequest;
    (function(SelectionRangeRequest2) {
      SelectionRangeRequest2.method = "textDocument/selectionRange";
      SelectionRangeRequest2.type = new messages_1.ProtocolRequestType(SelectionRangeRequest2.method);
    })(SelectionRangeRequest = exports2.SelectionRangeRequest || (exports2.SelectionRangeRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.progress.js
var require_protocol_progress = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.progress.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.WorkDoneProgressCancelNotification = exports2.WorkDoneProgressCreateRequest = exports2.WorkDoneProgress = void 0;
    var vscode_jsonrpc_1 = require("vscode-jsonrpc");
    var messages_1 = require_messages();
    var WorkDoneProgress;
    (function(WorkDoneProgress2) {
      WorkDoneProgress2.type = new vscode_jsonrpc_1.ProgressType();
      function is(value) {
        return value === WorkDoneProgress2.type;
      }
      WorkDoneProgress2.is = is;
    })(WorkDoneProgress = exports2.WorkDoneProgress || (exports2.WorkDoneProgress = {}));
    var WorkDoneProgressCreateRequest;
    (function(WorkDoneProgressCreateRequest2) {
      WorkDoneProgressCreateRequest2.type = new messages_1.ProtocolRequestType("window/workDoneProgress/create");
    })(WorkDoneProgressCreateRequest = exports2.WorkDoneProgressCreateRequest || (exports2.WorkDoneProgressCreateRequest = {}));
    var WorkDoneProgressCancelNotification;
    (function(WorkDoneProgressCancelNotification2) {
      WorkDoneProgressCancelNotification2.type = new messages_1.ProtocolNotificationType("window/workDoneProgress/cancel");
    })(WorkDoneProgressCancelNotification = exports2.WorkDoneProgressCancelNotification || (exports2.WorkDoneProgressCancelNotification = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.callHierarchy.js
var require_protocol_callHierarchy = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.callHierarchy.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.CallHierarchyOutgoingCallsRequest = exports2.CallHierarchyIncomingCallsRequest = exports2.CallHierarchyPrepareRequest = void 0;
    var messages_1 = require_messages();
    var CallHierarchyPrepareRequest;
    (function(CallHierarchyPrepareRequest2) {
      CallHierarchyPrepareRequest2.method = "textDocument/prepareCallHierarchy";
      CallHierarchyPrepareRequest2.type = new messages_1.ProtocolRequestType(CallHierarchyPrepareRequest2.method);
    })(CallHierarchyPrepareRequest = exports2.CallHierarchyPrepareRequest || (exports2.CallHierarchyPrepareRequest = {}));
    var CallHierarchyIncomingCallsRequest;
    (function(CallHierarchyIncomingCallsRequest2) {
      CallHierarchyIncomingCallsRequest2.method = "callHierarchy/incomingCalls";
      CallHierarchyIncomingCallsRequest2.type = new messages_1.ProtocolRequestType(CallHierarchyIncomingCallsRequest2.method);
    })(CallHierarchyIncomingCallsRequest = exports2.CallHierarchyIncomingCallsRequest || (exports2.CallHierarchyIncomingCallsRequest = {}));
    var CallHierarchyOutgoingCallsRequest;
    (function(CallHierarchyOutgoingCallsRequest2) {
      CallHierarchyOutgoingCallsRequest2.method = "callHierarchy/outgoingCalls";
      CallHierarchyOutgoingCallsRequest2.type = new messages_1.ProtocolRequestType(CallHierarchyOutgoingCallsRequest2.method);
    })(CallHierarchyOutgoingCallsRequest = exports2.CallHierarchyOutgoingCallsRequest || (exports2.CallHierarchyOutgoingCallsRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.semanticTokens.js
var require_protocol_semanticTokens = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.semanticTokens.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.SemanticTokensRefreshRequest = exports2.SemanticTokensRangeRequest = exports2.SemanticTokensDeltaRequest = exports2.SemanticTokensRequest = exports2.SemanticTokensRegistrationType = exports2.TokenFormat = exports2.SemanticTokens = exports2.SemanticTokenModifiers = exports2.SemanticTokenTypes = void 0;
    var messages_1 = require_messages();
    var SemanticTokenTypes;
    (function(SemanticTokenTypes2) {
      SemanticTokenTypes2["namespace"] = "namespace";
      SemanticTokenTypes2["type"] = "type";
      SemanticTokenTypes2["class"] = "class";
      SemanticTokenTypes2["enum"] = "enum";
      SemanticTokenTypes2["interface"] = "interface";
      SemanticTokenTypes2["struct"] = "struct";
      SemanticTokenTypes2["typeParameter"] = "typeParameter";
      SemanticTokenTypes2["parameter"] = "parameter";
      SemanticTokenTypes2["variable"] = "variable";
      SemanticTokenTypes2["property"] = "property";
      SemanticTokenTypes2["enumMember"] = "enumMember";
      SemanticTokenTypes2["event"] = "event";
      SemanticTokenTypes2["function"] = "function";
      SemanticTokenTypes2["method"] = "method";
      SemanticTokenTypes2["macro"] = "macro";
      SemanticTokenTypes2["keyword"] = "keyword";
      SemanticTokenTypes2["modifier"] = "modifier";
      SemanticTokenTypes2["comment"] = "comment";
      SemanticTokenTypes2["string"] = "string";
      SemanticTokenTypes2["number"] = "number";
      SemanticTokenTypes2["regexp"] = "regexp";
      SemanticTokenTypes2["operator"] = "operator";
    })(SemanticTokenTypes = exports2.SemanticTokenTypes || (exports2.SemanticTokenTypes = {}));
    var SemanticTokenModifiers;
    (function(SemanticTokenModifiers2) {
      SemanticTokenModifiers2["declaration"] = "declaration";
      SemanticTokenModifiers2["definition"] = "definition";
      SemanticTokenModifiers2["readonly"] = "readonly";
      SemanticTokenModifiers2["static"] = "static";
      SemanticTokenModifiers2["deprecated"] = "deprecated";
      SemanticTokenModifiers2["abstract"] = "abstract";
      SemanticTokenModifiers2["async"] = "async";
      SemanticTokenModifiers2["modification"] = "modification";
      SemanticTokenModifiers2["documentation"] = "documentation";
      SemanticTokenModifiers2["defaultLibrary"] = "defaultLibrary";
    })(SemanticTokenModifiers = exports2.SemanticTokenModifiers || (exports2.SemanticTokenModifiers = {}));
    var SemanticTokens;
    (function(SemanticTokens2) {
      function is(value) {
        const candidate = value;
        return candidate !== void 0 && (candidate.resultId === void 0 || typeof candidate.resultId === "string") && Array.isArray(candidate.data) && (candidate.data.length === 0 || typeof candidate.data[0] === "number");
      }
      SemanticTokens2.is = is;
    })(SemanticTokens = exports2.SemanticTokens || (exports2.SemanticTokens = {}));
    var TokenFormat;
    (function(TokenFormat2) {
      TokenFormat2.Relative = "relative";
    })(TokenFormat = exports2.TokenFormat || (exports2.TokenFormat = {}));
    var SemanticTokensRegistrationType;
    (function(SemanticTokensRegistrationType2) {
      SemanticTokensRegistrationType2.method = "textDocument/semanticTokens";
      SemanticTokensRegistrationType2.type = new messages_1.RegistrationType(SemanticTokensRegistrationType2.method);
    })(SemanticTokensRegistrationType = exports2.SemanticTokensRegistrationType || (exports2.SemanticTokensRegistrationType = {}));
    var SemanticTokensRequest;
    (function(SemanticTokensRequest2) {
      SemanticTokensRequest2.method = "textDocument/semanticTokens/full";
      SemanticTokensRequest2.type = new messages_1.ProtocolRequestType(SemanticTokensRequest2.method);
    })(SemanticTokensRequest = exports2.SemanticTokensRequest || (exports2.SemanticTokensRequest = {}));
    var SemanticTokensDeltaRequest;
    (function(SemanticTokensDeltaRequest2) {
      SemanticTokensDeltaRequest2.method = "textDocument/semanticTokens/full/delta";
      SemanticTokensDeltaRequest2.type = new messages_1.ProtocolRequestType(SemanticTokensDeltaRequest2.method);
    })(SemanticTokensDeltaRequest = exports2.SemanticTokensDeltaRequest || (exports2.SemanticTokensDeltaRequest = {}));
    var SemanticTokensRangeRequest;
    (function(SemanticTokensRangeRequest2) {
      SemanticTokensRangeRequest2.method = "textDocument/semanticTokens/range";
      SemanticTokensRangeRequest2.type = new messages_1.ProtocolRequestType(SemanticTokensRangeRequest2.method);
    })(SemanticTokensRangeRequest = exports2.SemanticTokensRangeRequest || (exports2.SemanticTokensRangeRequest = {}));
    var SemanticTokensRefreshRequest;
    (function(SemanticTokensRefreshRequest2) {
      SemanticTokensRefreshRequest2.method = `workspace/semanticTokens/refresh`;
      SemanticTokensRefreshRequest2.type = new messages_1.ProtocolRequestType0(SemanticTokensRefreshRequest2.method);
    })(SemanticTokensRefreshRequest = exports2.SemanticTokensRefreshRequest || (exports2.SemanticTokensRefreshRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.showDocument.js
var require_protocol_showDocument = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.showDocument.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.ShowDocumentRequest = void 0;
    var messages_1 = require_messages();
    var ShowDocumentRequest;
    (function(ShowDocumentRequest2) {
      ShowDocumentRequest2.method = "window/showDocument";
      ShowDocumentRequest2.type = new messages_1.ProtocolRequestType(ShowDocumentRequest2.method);
    })(ShowDocumentRequest = exports2.ShowDocumentRequest || (exports2.ShowDocumentRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.linkedEditingRange.js
var require_protocol_linkedEditingRange = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.linkedEditingRange.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LinkedEditingRangeRequest = void 0;
    var messages_1 = require_messages();
    var LinkedEditingRangeRequest;
    (function(LinkedEditingRangeRequest2) {
      LinkedEditingRangeRequest2.method = "textDocument/linkedEditingRange";
      LinkedEditingRangeRequest2.type = new messages_1.ProtocolRequestType(LinkedEditingRangeRequest2.method);
    })(LinkedEditingRangeRequest = exports2.LinkedEditingRangeRequest || (exports2.LinkedEditingRangeRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.fileOperations.js
var require_protocol_fileOperations = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.fileOperations.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.WillDeleteFilesRequest = exports2.DidDeleteFilesNotification = exports2.DidRenameFilesNotification = exports2.WillRenameFilesRequest = exports2.DidCreateFilesNotification = exports2.WillCreateFilesRequest = exports2.FileOperationPatternKind = void 0;
    var messages_1 = require_messages();
    var FileOperationPatternKind;
    (function(FileOperationPatternKind2) {
      FileOperationPatternKind2.file = "file";
      FileOperationPatternKind2.folder = "folder";
    })(FileOperationPatternKind = exports2.FileOperationPatternKind || (exports2.FileOperationPatternKind = {}));
    var WillCreateFilesRequest;
    (function(WillCreateFilesRequest2) {
      WillCreateFilesRequest2.method = "workspace/willCreateFiles";
      WillCreateFilesRequest2.type = new messages_1.ProtocolRequestType(WillCreateFilesRequest2.method);
    })(WillCreateFilesRequest = exports2.WillCreateFilesRequest || (exports2.WillCreateFilesRequest = {}));
    var DidCreateFilesNotification;
    (function(DidCreateFilesNotification2) {
      DidCreateFilesNotification2.method = "workspace/didCreateFiles";
      DidCreateFilesNotification2.type = new messages_1.ProtocolNotificationType(DidCreateFilesNotification2.method);
    })(DidCreateFilesNotification = exports2.DidCreateFilesNotification || (exports2.DidCreateFilesNotification = {}));
    var WillRenameFilesRequest;
    (function(WillRenameFilesRequest2) {
      WillRenameFilesRequest2.method = "workspace/willRenameFiles";
      WillRenameFilesRequest2.type = new messages_1.ProtocolRequestType(WillRenameFilesRequest2.method);
    })(WillRenameFilesRequest = exports2.WillRenameFilesRequest || (exports2.WillRenameFilesRequest = {}));
    var DidRenameFilesNotification;
    (function(DidRenameFilesNotification2) {
      DidRenameFilesNotification2.method = "workspace/didRenameFiles";
      DidRenameFilesNotification2.type = new messages_1.ProtocolNotificationType(DidRenameFilesNotification2.method);
    })(DidRenameFilesNotification = exports2.DidRenameFilesNotification || (exports2.DidRenameFilesNotification = {}));
    var DidDeleteFilesNotification;
    (function(DidDeleteFilesNotification2) {
      DidDeleteFilesNotification2.method = "workspace/didDeleteFiles";
      DidDeleteFilesNotification2.type = new messages_1.ProtocolNotificationType(DidDeleteFilesNotification2.method);
    })(DidDeleteFilesNotification = exports2.DidDeleteFilesNotification || (exports2.DidDeleteFilesNotification = {}));
    var WillDeleteFilesRequest;
    (function(WillDeleteFilesRequest2) {
      WillDeleteFilesRequest2.method = "workspace/willDeleteFiles";
      WillDeleteFilesRequest2.type = new messages_1.ProtocolRequestType(WillDeleteFilesRequest2.method);
    })(WillDeleteFilesRequest = exports2.WillDeleteFilesRequest || (exports2.WillDeleteFilesRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.moniker.js
var require_protocol_moniker = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.moniker.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.MonikerRequest = exports2.MonikerKind = exports2.UniquenessLevel = void 0;
    var messages_1 = require_messages();
    var UniquenessLevel;
    (function(UniquenessLevel2) {
      UniquenessLevel2["document"] = "document";
      UniquenessLevel2["project"] = "project";
      UniquenessLevel2["group"] = "group";
      UniquenessLevel2["scheme"] = "scheme";
      UniquenessLevel2["global"] = "global";
    })(UniquenessLevel = exports2.UniquenessLevel || (exports2.UniquenessLevel = {}));
    var MonikerKind;
    (function(MonikerKind2) {
      MonikerKind2["import"] = "import";
      MonikerKind2["export"] = "export";
      MonikerKind2["local"] = "local";
    })(MonikerKind = exports2.MonikerKind || (exports2.MonikerKind = {}));
    var MonikerRequest;
    (function(MonikerRequest2) {
      MonikerRequest2.method = "textDocument/moniker";
      MonikerRequest2.type = new messages_1.ProtocolRequestType(MonikerRequest2.method);
    })(MonikerRequest = exports2.MonikerRequest || (exports2.MonikerRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.js
var require_protocol = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/protocol.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.DocumentLinkRequest = exports2.CodeLensRefreshRequest = exports2.CodeLensResolveRequest = exports2.CodeLensRequest = exports2.WorkspaceSymbolRequest = exports2.CodeActionResolveRequest = exports2.CodeActionRequest = exports2.DocumentSymbolRequest = exports2.DocumentHighlightRequest = exports2.ReferencesRequest = exports2.DefinitionRequest = exports2.SignatureHelpRequest = exports2.SignatureHelpTriggerKind = exports2.HoverRequest = exports2.CompletionResolveRequest = exports2.CompletionRequest = exports2.CompletionTriggerKind = exports2.PublishDiagnosticsNotification = exports2.WatchKind = exports2.FileChangeType = exports2.DidChangeWatchedFilesNotification = exports2.WillSaveTextDocumentWaitUntilRequest = exports2.WillSaveTextDocumentNotification = exports2.TextDocumentSaveReason = exports2.DidSaveTextDocumentNotification = exports2.DidCloseTextDocumentNotification = exports2.DidChangeTextDocumentNotification = exports2.TextDocumentContentChangeEvent = exports2.DidOpenTextDocumentNotification = exports2.TextDocumentSyncKind = exports2.TelemetryEventNotification = exports2.LogMessageNotification = exports2.ShowMessageRequest = exports2.ShowMessageNotification = exports2.MessageType = exports2.DidChangeConfigurationNotification = exports2.ExitNotification = exports2.ShutdownRequest = exports2.InitializedNotification = exports2.InitializeError = exports2.InitializeRequest = exports2.WorkDoneProgressOptions = exports2.TextDocumentRegistrationOptions = exports2.StaticRegistrationOptions = exports2.FailureHandlingKind = exports2.ResourceOperationKind = exports2.UnregistrationRequest = exports2.RegistrationRequest = exports2.DocumentSelector = exports2.DocumentFilter = void 0;
    exports2.MonikerRequest = exports2.MonikerKind = exports2.UniquenessLevel = exports2.WillDeleteFilesRequest = exports2.DidDeleteFilesNotification = exports2.WillRenameFilesRequest = exports2.DidRenameFilesNotification = exports2.WillCreateFilesRequest = exports2.DidCreateFilesNotification = exports2.FileOperationPatternKind = exports2.LinkedEditingRangeRequest = exports2.ShowDocumentRequest = exports2.SemanticTokensRegistrationType = exports2.SemanticTokensRefreshRequest = exports2.SemanticTokensRangeRequest = exports2.SemanticTokensDeltaRequest = exports2.SemanticTokensRequest = exports2.TokenFormat = exports2.SemanticTokens = exports2.SemanticTokenModifiers = exports2.SemanticTokenTypes = exports2.CallHierarchyPrepareRequest = exports2.CallHierarchyOutgoingCallsRequest = exports2.CallHierarchyIncomingCallsRequest = exports2.WorkDoneProgressCancelNotification = exports2.WorkDoneProgressCreateRequest = exports2.WorkDoneProgress = exports2.SelectionRangeRequest = exports2.DeclarationRequest = exports2.FoldingRangeRequest = exports2.ColorPresentationRequest = exports2.DocumentColorRequest = exports2.ConfigurationRequest = exports2.DidChangeWorkspaceFoldersNotification = exports2.WorkspaceFoldersRequest = exports2.TypeDefinitionRequest = exports2.ImplementationRequest = exports2.ApplyWorkspaceEditRequest = exports2.ExecuteCommandRequest = exports2.PrepareRenameRequest = exports2.RenameRequest = exports2.PrepareSupportDefaultBehavior = exports2.DocumentOnTypeFormattingRequest = exports2.DocumentRangeFormattingRequest = exports2.DocumentFormattingRequest = exports2.DocumentLinkResolveRequest = void 0;
    var Is = require_is();
    var messages_1 = require_messages();
    var protocol_implementation_1 = require_protocol_implementation();
    Object.defineProperty(exports2, "ImplementationRequest", { enumerable: true, get: function() {
      return protocol_implementation_1.ImplementationRequest;
    } });
    var protocol_typeDefinition_1 = require_protocol_typeDefinition();
    Object.defineProperty(exports2, "TypeDefinitionRequest", { enumerable: true, get: function() {
      return protocol_typeDefinition_1.TypeDefinitionRequest;
    } });
    var protocol_workspaceFolders_1 = require_protocol_workspaceFolders();
    Object.defineProperty(exports2, "WorkspaceFoldersRequest", { enumerable: true, get: function() {
      return protocol_workspaceFolders_1.WorkspaceFoldersRequest;
    } });
    Object.defineProperty(exports2, "DidChangeWorkspaceFoldersNotification", { enumerable: true, get: function() {
      return protocol_workspaceFolders_1.DidChangeWorkspaceFoldersNotification;
    } });
    var protocol_configuration_1 = require_protocol_configuration();
    Object.defineProperty(exports2, "ConfigurationRequest", { enumerable: true, get: function() {
      return protocol_configuration_1.ConfigurationRequest;
    } });
    var protocol_colorProvider_1 = require_protocol_colorProvider();
    Object.defineProperty(exports2, "DocumentColorRequest", { enumerable: true, get: function() {
      return protocol_colorProvider_1.DocumentColorRequest;
    } });
    Object.defineProperty(exports2, "ColorPresentationRequest", { enumerable: true, get: function() {
      return protocol_colorProvider_1.ColorPresentationRequest;
    } });
    var protocol_foldingRange_1 = require_protocol_foldingRange();
    Object.defineProperty(exports2, "FoldingRangeRequest", { enumerable: true, get: function() {
      return protocol_foldingRange_1.FoldingRangeRequest;
    } });
    var protocol_declaration_1 = require_protocol_declaration();
    Object.defineProperty(exports2, "DeclarationRequest", { enumerable: true, get: function() {
      return protocol_declaration_1.DeclarationRequest;
    } });
    var protocol_selectionRange_1 = require_protocol_selectionRange();
    Object.defineProperty(exports2, "SelectionRangeRequest", { enumerable: true, get: function() {
      return protocol_selectionRange_1.SelectionRangeRequest;
    } });
    var protocol_progress_1 = require_protocol_progress();
    Object.defineProperty(exports2, "WorkDoneProgress", { enumerable: true, get: function() {
      return protocol_progress_1.WorkDoneProgress;
    } });
    Object.defineProperty(exports2, "WorkDoneProgressCreateRequest", { enumerable: true, get: function() {
      return protocol_progress_1.WorkDoneProgressCreateRequest;
    } });
    Object.defineProperty(exports2, "WorkDoneProgressCancelNotification", { enumerable: true, get: function() {
      return protocol_progress_1.WorkDoneProgressCancelNotification;
    } });
    var protocol_callHierarchy_1 = require_protocol_callHierarchy();
    Object.defineProperty(exports2, "CallHierarchyIncomingCallsRequest", { enumerable: true, get: function() {
      return protocol_callHierarchy_1.CallHierarchyIncomingCallsRequest;
    } });
    Object.defineProperty(exports2, "CallHierarchyOutgoingCallsRequest", { enumerable: true, get: function() {
      return protocol_callHierarchy_1.CallHierarchyOutgoingCallsRequest;
    } });
    Object.defineProperty(exports2, "CallHierarchyPrepareRequest", { enumerable: true, get: function() {
      return protocol_callHierarchy_1.CallHierarchyPrepareRequest;
    } });
    var protocol_semanticTokens_1 = require_protocol_semanticTokens();
    Object.defineProperty(exports2, "SemanticTokenTypes", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokenTypes;
    } });
    Object.defineProperty(exports2, "SemanticTokenModifiers", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokenModifiers;
    } });
    Object.defineProperty(exports2, "SemanticTokens", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokens;
    } });
    Object.defineProperty(exports2, "TokenFormat", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.TokenFormat;
    } });
    Object.defineProperty(exports2, "SemanticTokensRequest", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensRequest;
    } });
    Object.defineProperty(exports2, "SemanticTokensDeltaRequest", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensDeltaRequest;
    } });
    Object.defineProperty(exports2, "SemanticTokensRangeRequest", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensRangeRequest;
    } });
    Object.defineProperty(exports2, "SemanticTokensRefreshRequest", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensRefreshRequest;
    } });
    Object.defineProperty(exports2, "SemanticTokensRegistrationType", { enumerable: true, get: function() {
      return protocol_semanticTokens_1.SemanticTokensRegistrationType;
    } });
    var protocol_showDocument_1 = require_protocol_showDocument();
    Object.defineProperty(exports2, "ShowDocumentRequest", { enumerable: true, get: function() {
      return protocol_showDocument_1.ShowDocumentRequest;
    } });
    var protocol_linkedEditingRange_1 = require_protocol_linkedEditingRange();
    Object.defineProperty(exports2, "LinkedEditingRangeRequest", { enumerable: true, get: function() {
      return protocol_linkedEditingRange_1.LinkedEditingRangeRequest;
    } });
    var protocol_fileOperations_1 = require_protocol_fileOperations();
    Object.defineProperty(exports2, "FileOperationPatternKind", { enumerable: true, get: function() {
      return protocol_fileOperations_1.FileOperationPatternKind;
    } });
    Object.defineProperty(exports2, "DidCreateFilesNotification", { enumerable: true, get: function() {
      return protocol_fileOperations_1.DidCreateFilesNotification;
    } });
    Object.defineProperty(exports2, "WillCreateFilesRequest", { enumerable: true, get: function() {
      return protocol_fileOperations_1.WillCreateFilesRequest;
    } });
    Object.defineProperty(exports2, "DidRenameFilesNotification", { enumerable: true, get: function() {
      return protocol_fileOperations_1.DidRenameFilesNotification;
    } });
    Object.defineProperty(exports2, "WillRenameFilesRequest", { enumerable: true, get: function() {
      return protocol_fileOperations_1.WillRenameFilesRequest;
    } });
    Object.defineProperty(exports2, "DidDeleteFilesNotification", { enumerable: true, get: function() {
      return protocol_fileOperations_1.DidDeleteFilesNotification;
    } });
    Object.defineProperty(exports2, "WillDeleteFilesRequest", { enumerable: true, get: function() {
      return protocol_fileOperations_1.WillDeleteFilesRequest;
    } });
    var protocol_moniker_1 = require_protocol_moniker();
    Object.defineProperty(exports2, "UniquenessLevel", { enumerable: true, get: function() {
      return protocol_moniker_1.UniquenessLevel;
    } });
    Object.defineProperty(exports2, "MonikerKind", { enumerable: true, get: function() {
      return protocol_moniker_1.MonikerKind;
    } });
    Object.defineProperty(exports2, "MonikerRequest", { enumerable: true, get: function() {
      return protocol_moniker_1.MonikerRequest;
    } });
    var DocumentFilter;
    (function(DocumentFilter2) {
      function is(value) {
        const candidate = value;
        return Is.string(candidate.language) || Is.string(candidate.scheme) || Is.string(candidate.pattern);
      }
      DocumentFilter2.is = is;
    })(DocumentFilter = exports2.DocumentFilter || (exports2.DocumentFilter = {}));
    var DocumentSelector;
    (function(DocumentSelector2) {
      function is(value) {
        if (!Array.isArray(value)) {
          return false;
        }
        for (let elem of value) {
          if (!Is.string(elem) && !DocumentFilter.is(elem)) {
            return false;
          }
        }
        return true;
      }
      DocumentSelector2.is = is;
    })(DocumentSelector = exports2.DocumentSelector || (exports2.DocumentSelector = {}));
    var RegistrationRequest;
    (function(RegistrationRequest2) {
      RegistrationRequest2.type = new messages_1.ProtocolRequestType("client/registerCapability");
    })(RegistrationRequest = exports2.RegistrationRequest || (exports2.RegistrationRequest = {}));
    var UnregistrationRequest;
    (function(UnregistrationRequest2) {
      UnregistrationRequest2.type = new messages_1.ProtocolRequestType("client/unregisterCapability");
    })(UnregistrationRequest = exports2.UnregistrationRequest || (exports2.UnregistrationRequest = {}));
    var ResourceOperationKind;
    (function(ResourceOperationKind2) {
      ResourceOperationKind2.Create = "create";
      ResourceOperationKind2.Rename = "rename";
      ResourceOperationKind2.Delete = "delete";
    })(ResourceOperationKind = exports2.ResourceOperationKind || (exports2.ResourceOperationKind = {}));
    var FailureHandlingKind;
    (function(FailureHandlingKind2) {
      FailureHandlingKind2.Abort = "abort";
      FailureHandlingKind2.Transactional = "transactional";
      FailureHandlingKind2.TextOnlyTransactional = "textOnlyTransactional";
      FailureHandlingKind2.Undo = "undo";
    })(FailureHandlingKind = exports2.FailureHandlingKind || (exports2.FailureHandlingKind = {}));
    var StaticRegistrationOptions;
    (function(StaticRegistrationOptions2) {
      function hasId(value) {
        const candidate = value;
        return candidate && Is.string(candidate.id) && candidate.id.length > 0;
      }
      StaticRegistrationOptions2.hasId = hasId;
    })(StaticRegistrationOptions = exports2.StaticRegistrationOptions || (exports2.StaticRegistrationOptions = {}));
    var TextDocumentRegistrationOptions;
    (function(TextDocumentRegistrationOptions2) {
      function is(value) {
        const candidate = value;
        return candidate && (candidate.documentSelector === null || DocumentSelector.is(candidate.documentSelector));
      }
      TextDocumentRegistrationOptions2.is = is;
    })(TextDocumentRegistrationOptions = exports2.TextDocumentRegistrationOptions || (exports2.TextDocumentRegistrationOptions = {}));
    var WorkDoneProgressOptions;
    (function(WorkDoneProgressOptions2) {
      function is(value) {
        const candidate = value;
        return Is.objectLiteral(candidate) && (candidate.workDoneProgress === void 0 || Is.boolean(candidate.workDoneProgress));
      }
      WorkDoneProgressOptions2.is = is;
      function hasWorkDoneProgress(value) {
        const candidate = value;
        return candidate && Is.boolean(candidate.workDoneProgress);
      }
      WorkDoneProgressOptions2.hasWorkDoneProgress = hasWorkDoneProgress;
    })(WorkDoneProgressOptions = exports2.WorkDoneProgressOptions || (exports2.WorkDoneProgressOptions = {}));
    var InitializeRequest;
    (function(InitializeRequest2) {
      InitializeRequest2.type = new messages_1.ProtocolRequestType("initialize");
    })(InitializeRequest = exports2.InitializeRequest || (exports2.InitializeRequest = {}));
    var InitializeError;
    (function(InitializeError2) {
      InitializeError2.unknownProtocolVersion = 1;
    })(InitializeError = exports2.InitializeError || (exports2.InitializeError = {}));
    var InitializedNotification;
    (function(InitializedNotification2) {
      InitializedNotification2.type = new messages_1.ProtocolNotificationType("initialized");
    })(InitializedNotification = exports2.InitializedNotification || (exports2.InitializedNotification = {}));
    var ShutdownRequest;
    (function(ShutdownRequest2) {
      ShutdownRequest2.type = new messages_1.ProtocolRequestType0("shutdown");
    })(ShutdownRequest = exports2.ShutdownRequest || (exports2.ShutdownRequest = {}));
    var ExitNotification;
    (function(ExitNotification2) {
      ExitNotification2.type = new messages_1.ProtocolNotificationType0("exit");
    })(ExitNotification = exports2.ExitNotification || (exports2.ExitNotification = {}));
    var DidChangeConfigurationNotification;
    (function(DidChangeConfigurationNotification2) {
      DidChangeConfigurationNotification2.type = new messages_1.ProtocolNotificationType("workspace/didChangeConfiguration");
    })(DidChangeConfigurationNotification = exports2.DidChangeConfigurationNotification || (exports2.DidChangeConfigurationNotification = {}));
    var MessageType;
    (function(MessageType2) {
      MessageType2.Error = 1;
      MessageType2.Warning = 2;
      MessageType2.Info = 3;
      MessageType2.Log = 4;
    })(MessageType = exports2.MessageType || (exports2.MessageType = {}));
    var ShowMessageNotification;
    (function(ShowMessageNotification2) {
      ShowMessageNotification2.type = new messages_1.ProtocolNotificationType("window/showMessage");
    })(ShowMessageNotification = exports2.ShowMessageNotification || (exports2.ShowMessageNotification = {}));
    var ShowMessageRequest;
    (function(ShowMessageRequest2) {
      ShowMessageRequest2.type = new messages_1.ProtocolRequestType("window/showMessageRequest");
    })(ShowMessageRequest = exports2.ShowMessageRequest || (exports2.ShowMessageRequest = {}));
    var LogMessageNotification;
    (function(LogMessageNotification2) {
      LogMessageNotification2.type = new messages_1.ProtocolNotificationType("window/logMessage");
    })(LogMessageNotification = exports2.LogMessageNotification || (exports2.LogMessageNotification = {}));
    var TelemetryEventNotification;
    (function(TelemetryEventNotification2) {
      TelemetryEventNotification2.type = new messages_1.ProtocolNotificationType("telemetry/event");
    })(TelemetryEventNotification = exports2.TelemetryEventNotification || (exports2.TelemetryEventNotification = {}));
    var TextDocumentSyncKind;
    (function(TextDocumentSyncKind2) {
      TextDocumentSyncKind2.None = 0;
      TextDocumentSyncKind2.Full = 1;
      TextDocumentSyncKind2.Incremental = 2;
    })(TextDocumentSyncKind = exports2.TextDocumentSyncKind || (exports2.TextDocumentSyncKind = {}));
    var DidOpenTextDocumentNotification;
    (function(DidOpenTextDocumentNotification2) {
      DidOpenTextDocumentNotification2.method = "textDocument/didOpen";
      DidOpenTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidOpenTextDocumentNotification2.method);
    })(DidOpenTextDocumentNotification = exports2.DidOpenTextDocumentNotification || (exports2.DidOpenTextDocumentNotification = {}));
    var TextDocumentContentChangeEvent;
    (function(TextDocumentContentChangeEvent2) {
      function isIncremental(event) {
        let candidate = event;
        return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range !== void 0 && (candidate.rangeLength === void 0 || typeof candidate.rangeLength === "number");
      }
      TextDocumentContentChangeEvent2.isIncremental = isIncremental;
      function isFull(event) {
        let candidate = event;
        return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range === void 0 && candidate.rangeLength === void 0;
      }
      TextDocumentContentChangeEvent2.isFull = isFull;
    })(TextDocumentContentChangeEvent = exports2.TextDocumentContentChangeEvent || (exports2.TextDocumentContentChangeEvent = {}));
    var DidChangeTextDocumentNotification;
    (function(DidChangeTextDocumentNotification2) {
      DidChangeTextDocumentNotification2.method = "textDocument/didChange";
      DidChangeTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidChangeTextDocumentNotification2.method);
    })(DidChangeTextDocumentNotification = exports2.DidChangeTextDocumentNotification || (exports2.DidChangeTextDocumentNotification = {}));
    var DidCloseTextDocumentNotification;
    (function(DidCloseTextDocumentNotification2) {
      DidCloseTextDocumentNotification2.method = "textDocument/didClose";
      DidCloseTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidCloseTextDocumentNotification2.method);
    })(DidCloseTextDocumentNotification = exports2.DidCloseTextDocumentNotification || (exports2.DidCloseTextDocumentNotification = {}));
    var DidSaveTextDocumentNotification;
    (function(DidSaveTextDocumentNotification2) {
      DidSaveTextDocumentNotification2.method = "textDocument/didSave";
      DidSaveTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(DidSaveTextDocumentNotification2.method);
    })(DidSaveTextDocumentNotification = exports2.DidSaveTextDocumentNotification || (exports2.DidSaveTextDocumentNotification = {}));
    var TextDocumentSaveReason;
    (function(TextDocumentSaveReason2) {
      TextDocumentSaveReason2.Manual = 1;
      TextDocumentSaveReason2.AfterDelay = 2;
      TextDocumentSaveReason2.FocusOut = 3;
    })(TextDocumentSaveReason = exports2.TextDocumentSaveReason || (exports2.TextDocumentSaveReason = {}));
    var WillSaveTextDocumentNotification;
    (function(WillSaveTextDocumentNotification2) {
      WillSaveTextDocumentNotification2.method = "textDocument/willSave";
      WillSaveTextDocumentNotification2.type = new messages_1.ProtocolNotificationType(WillSaveTextDocumentNotification2.method);
    })(WillSaveTextDocumentNotification = exports2.WillSaveTextDocumentNotification || (exports2.WillSaveTextDocumentNotification = {}));
    var WillSaveTextDocumentWaitUntilRequest;
    (function(WillSaveTextDocumentWaitUntilRequest2) {
      WillSaveTextDocumentWaitUntilRequest2.method = "textDocument/willSaveWaitUntil";
      WillSaveTextDocumentWaitUntilRequest2.type = new messages_1.ProtocolRequestType(WillSaveTextDocumentWaitUntilRequest2.method);
    })(WillSaveTextDocumentWaitUntilRequest = exports2.WillSaveTextDocumentWaitUntilRequest || (exports2.WillSaveTextDocumentWaitUntilRequest = {}));
    var DidChangeWatchedFilesNotification;
    (function(DidChangeWatchedFilesNotification2) {
      DidChangeWatchedFilesNotification2.type = new messages_1.ProtocolNotificationType("workspace/didChangeWatchedFiles");
    })(DidChangeWatchedFilesNotification = exports2.DidChangeWatchedFilesNotification || (exports2.DidChangeWatchedFilesNotification = {}));
    var FileChangeType;
    (function(FileChangeType2) {
      FileChangeType2.Created = 1;
      FileChangeType2.Changed = 2;
      FileChangeType2.Deleted = 3;
    })(FileChangeType = exports2.FileChangeType || (exports2.FileChangeType = {}));
    var WatchKind;
    (function(WatchKind2) {
      WatchKind2.Create = 1;
      WatchKind2.Change = 2;
      WatchKind2.Delete = 4;
    })(WatchKind = exports2.WatchKind || (exports2.WatchKind = {}));
    var PublishDiagnosticsNotification;
    (function(PublishDiagnosticsNotification2) {
      PublishDiagnosticsNotification2.type = new messages_1.ProtocolNotificationType("textDocument/publishDiagnostics");
    })(PublishDiagnosticsNotification = exports2.PublishDiagnosticsNotification || (exports2.PublishDiagnosticsNotification = {}));
    var CompletionTriggerKind;
    (function(CompletionTriggerKind2) {
      CompletionTriggerKind2.Invoked = 1;
      CompletionTriggerKind2.TriggerCharacter = 2;
      CompletionTriggerKind2.TriggerForIncompleteCompletions = 3;
    })(CompletionTriggerKind = exports2.CompletionTriggerKind || (exports2.CompletionTriggerKind = {}));
    var CompletionRequest;
    (function(CompletionRequest2) {
      CompletionRequest2.method = "textDocument/completion";
      CompletionRequest2.type = new messages_1.ProtocolRequestType(CompletionRequest2.method);
    })(CompletionRequest = exports2.CompletionRequest || (exports2.CompletionRequest = {}));
    var CompletionResolveRequest;
    (function(CompletionResolveRequest2) {
      CompletionResolveRequest2.method = "completionItem/resolve";
      CompletionResolveRequest2.type = new messages_1.ProtocolRequestType(CompletionResolveRequest2.method);
    })(CompletionResolveRequest = exports2.CompletionResolveRequest || (exports2.CompletionResolveRequest = {}));
    var HoverRequest;
    (function(HoverRequest2) {
      HoverRequest2.method = "textDocument/hover";
      HoverRequest2.type = new messages_1.ProtocolRequestType(HoverRequest2.method);
    })(HoverRequest = exports2.HoverRequest || (exports2.HoverRequest = {}));
    var SignatureHelpTriggerKind;
    (function(SignatureHelpTriggerKind2) {
      SignatureHelpTriggerKind2.Invoked = 1;
      SignatureHelpTriggerKind2.TriggerCharacter = 2;
      SignatureHelpTriggerKind2.ContentChange = 3;
    })(SignatureHelpTriggerKind = exports2.SignatureHelpTriggerKind || (exports2.SignatureHelpTriggerKind = {}));
    var SignatureHelpRequest;
    (function(SignatureHelpRequest2) {
      SignatureHelpRequest2.method = "textDocument/signatureHelp";
      SignatureHelpRequest2.type = new messages_1.ProtocolRequestType(SignatureHelpRequest2.method);
    })(SignatureHelpRequest = exports2.SignatureHelpRequest || (exports2.SignatureHelpRequest = {}));
    var DefinitionRequest;
    (function(DefinitionRequest2) {
      DefinitionRequest2.method = "textDocument/definition";
      DefinitionRequest2.type = new messages_1.ProtocolRequestType(DefinitionRequest2.method);
    })(DefinitionRequest = exports2.DefinitionRequest || (exports2.DefinitionRequest = {}));
    var ReferencesRequest;
    (function(ReferencesRequest2) {
      ReferencesRequest2.method = "textDocument/references";
      ReferencesRequest2.type = new messages_1.ProtocolRequestType(ReferencesRequest2.method);
    })(ReferencesRequest = exports2.ReferencesRequest || (exports2.ReferencesRequest = {}));
    var DocumentHighlightRequest;
    (function(DocumentHighlightRequest2) {
      DocumentHighlightRequest2.method = "textDocument/documentHighlight";
      DocumentHighlightRequest2.type = new messages_1.ProtocolRequestType(DocumentHighlightRequest2.method);
    })(DocumentHighlightRequest = exports2.DocumentHighlightRequest || (exports2.DocumentHighlightRequest = {}));
    var DocumentSymbolRequest;
    (function(DocumentSymbolRequest2) {
      DocumentSymbolRequest2.method = "textDocument/documentSymbol";
      DocumentSymbolRequest2.type = new messages_1.ProtocolRequestType(DocumentSymbolRequest2.method);
    })(DocumentSymbolRequest = exports2.DocumentSymbolRequest || (exports2.DocumentSymbolRequest = {}));
    var CodeActionRequest;
    (function(CodeActionRequest2) {
      CodeActionRequest2.method = "textDocument/codeAction";
      CodeActionRequest2.type = new messages_1.ProtocolRequestType(CodeActionRequest2.method);
    })(CodeActionRequest = exports2.CodeActionRequest || (exports2.CodeActionRequest = {}));
    var CodeActionResolveRequest;
    (function(CodeActionResolveRequest2) {
      CodeActionResolveRequest2.method = "codeAction/resolve";
      CodeActionResolveRequest2.type = new messages_1.ProtocolRequestType(CodeActionResolveRequest2.method);
    })(CodeActionResolveRequest = exports2.CodeActionResolveRequest || (exports2.CodeActionResolveRequest = {}));
    var WorkspaceSymbolRequest;
    (function(WorkspaceSymbolRequest2) {
      WorkspaceSymbolRequest2.method = "workspace/symbol";
      WorkspaceSymbolRequest2.type = new messages_1.ProtocolRequestType(WorkspaceSymbolRequest2.method);
    })(WorkspaceSymbolRequest = exports2.WorkspaceSymbolRequest || (exports2.WorkspaceSymbolRequest = {}));
    var CodeLensRequest;
    (function(CodeLensRequest2) {
      CodeLensRequest2.method = "textDocument/codeLens";
      CodeLensRequest2.type = new messages_1.ProtocolRequestType(CodeLensRequest2.method);
    })(CodeLensRequest = exports2.CodeLensRequest || (exports2.CodeLensRequest = {}));
    var CodeLensResolveRequest;
    (function(CodeLensResolveRequest2) {
      CodeLensResolveRequest2.method = "codeLens/resolve";
      CodeLensResolveRequest2.type = new messages_1.ProtocolRequestType(CodeLensResolveRequest2.method);
    })(CodeLensResolveRequest = exports2.CodeLensResolveRequest || (exports2.CodeLensResolveRequest = {}));
    var CodeLensRefreshRequest;
    (function(CodeLensRefreshRequest2) {
      CodeLensRefreshRequest2.method = `workspace/codeLens/refresh`;
      CodeLensRefreshRequest2.type = new messages_1.ProtocolRequestType0(CodeLensRefreshRequest2.method);
    })(CodeLensRefreshRequest = exports2.CodeLensRefreshRequest || (exports2.CodeLensRefreshRequest = {}));
    var DocumentLinkRequest;
    (function(DocumentLinkRequest2) {
      DocumentLinkRequest2.method = "textDocument/documentLink";
      DocumentLinkRequest2.type = new messages_1.ProtocolRequestType(DocumentLinkRequest2.method);
    })(DocumentLinkRequest = exports2.DocumentLinkRequest || (exports2.DocumentLinkRequest = {}));
    var DocumentLinkResolveRequest;
    (function(DocumentLinkResolveRequest2) {
      DocumentLinkResolveRequest2.method = "documentLink/resolve";
      DocumentLinkResolveRequest2.type = new messages_1.ProtocolRequestType(DocumentLinkResolveRequest2.method);
    })(DocumentLinkResolveRequest = exports2.DocumentLinkResolveRequest || (exports2.DocumentLinkResolveRequest = {}));
    var DocumentFormattingRequest;
    (function(DocumentFormattingRequest2) {
      DocumentFormattingRequest2.method = "textDocument/formatting";
      DocumentFormattingRequest2.type = new messages_1.ProtocolRequestType(DocumentFormattingRequest2.method);
    })(DocumentFormattingRequest = exports2.DocumentFormattingRequest || (exports2.DocumentFormattingRequest = {}));
    var DocumentRangeFormattingRequest;
    (function(DocumentRangeFormattingRequest2) {
      DocumentRangeFormattingRequest2.method = "textDocument/rangeFormatting";
      DocumentRangeFormattingRequest2.type = new messages_1.ProtocolRequestType(DocumentRangeFormattingRequest2.method);
    })(DocumentRangeFormattingRequest = exports2.DocumentRangeFormattingRequest || (exports2.DocumentRangeFormattingRequest = {}));
    var DocumentOnTypeFormattingRequest;
    (function(DocumentOnTypeFormattingRequest2) {
      DocumentOnTypeFormattingRequest2.method = "textDocument/onTypeFormatting";
      DocumentOnTypeFormattingRequest2.type = new messages_1.ProtocolRequestType(DocumentOnTypeFormattingRequest2.method);
    })(DocumentOnTypeFormattingRequest = exports2.DocumentOnTypeFormattingRequest || (exports2.DocumentOnTypeFormattingRequest = {}));
    var PrepareSupportDefaultBehavior;
    (function(PrepareSupportDefaultBehavior2) {
      PrepareSupportDefaultBehavior2.Identifier = 1;
    })(PrepareSupportDefaultBehavior = exports2.PrepareSupportDefaultBehavior || (exports2.PrepareSupportDefaultBehavior = {}));
    var RenameRequest;
    (function(RenameRequest2) {
      RenameRequest2.method = "textDocument/rename";
      RenameRequest2.type = new messages_1.ProtocolRequestType(RenameRequest2.method);
    })(RenameRequest = exports2.RenameRequest || (exports2.RenameRequest = {}));
    var PrepareRenameRequest;
    (function(PrepareRenameRequest2) {
      PrepareRenameRequest2.method = "textDocument/prepareRename";
      PrepareRenameRequest2.type = new messages_1.ProtocolRequestType(PrepareRenameRequest2.method);
    })(PrepareRenameRequest = exports2.PrepareRenameRequest || (exports2.PrepareRenameRequest = {}));
    var ExecuteCommandRequest;
    (function(ExecuteCommandRequest2) {
      ExecuteCommandRequest2.type = new messages_1.ProtocolRequestType("workspace/executeCommand");
    })(ExecuteCommandRequest = exports2.ExecuteCommandRequest || (exports2.ExecuteCommandRequest = {}));
    var ApplyWorkspaceEditRequest;
    (function(ApplyWorkspaceEditRequest2) {
      ApplyWorkspaceEditRequest2.type = new messages_1.ProtocolRequestType("workspace/applyEdit");
    })(ApplyWorkspaceEditRequest = exports2.ApplyWorkspaceEditRequest || (exports2.ApplyWorkspaceEditRequest = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/connection.js
var require_connection = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/connection.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createProtocolConnection = void 0;
    var vscode_jsonrpc_1 = require("vscode-jsonrpc");
    function createProtocolConnection(input, output, logger, options) {
      if (vscode_jsonrpc_1.ConnectionStrategy.is(options)) {
        options = { connectionStrategy: options };
      }
      return vscode_jsonrpc_1.createMessageConnection(input, output, logger, options);
    }
    exports2.createProtocolConnection = createProtocolConnection;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/api.js
var require_api = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/common/api.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LSPErrorCodes = exports2.createProtocolConnection = void 0;
    __exportStar(require("vscode-jsonrpc"), exports2);
    __exportStar(require_main(), exports2);
    __exportStar(require_messages(), exports2);
    __exportStar(require_protocol(), exports2);
    var connection_1 = require_connection();
    Object.defineProperty(exports2, "createProtocolConnection", { enumerable: true, get: function() {
      return connection_1.createProtocolConnection;
    } });
    var LSPErrorCodes;
    (function(LSPErrorCodes2) {
      LSPErrorCodes2.lspReservedErrorRangeStart = -32899;
      LSPErrorCodes2.ContentModified = -32801;
      LSPErrorCodes2.RequestCancelled = -32800;
      LSPErrorCodes2.lspReservedErrorRangeEnd = -32800;
    })(LSPErrorCodes = exports2.LSPErrorCodes || (exports2.LSPErrorCodes = {}));
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/node/main.js
var require_main2 = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/vscode-languageserver-protocol@registry.npmjs.org+vscode-languageserver-protocol+3.16.0/node_modules/vscode-languageserver-protocol/lib/node/main.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports2 && exports2.__exportStar || function(m, exports3) {
      for (var p in m)
        if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports3, p))
          __createBinding(exports3, m, p);
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.createProtocolConnection = void 0;
    var node_1 = require("vscode-jsonrpc/node");
    __exportStar(require("vscode-jsonrpc/node"), exports2);
    __exportStar(require_api(), exports2);
    function createProtocolConnection(input, output, logger, options) {
      return node_1.createMessageConnection(input, output, logger, options);
    }
    exports2.createProtocolConnection = createProtocolConnection;
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/common/requests.js
var require_requests = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/common/requests.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.IsInAngularProject = exports2.RunNgccRequest = exports2.GetTcbRequest = exports2.GetTemplateLocationForComponent = exports2.GetComponentsWithTemplateFile = void 0;
    var lsp = __importStar(require_main2());
    exports2.GetComponentsWithTemplateFile = new lsp.RequestType("angular/getComponentsWithTemplateFile");
    exports2.GetTemplateLocationForComponent = new lsp.RequestType("angular/getTemplateLocationForComponent");
    exports2.GetTcbRequest = new lsp.RequestType("angular/getTcb");
    exports2.RunNgccRequest = new lsp.RequestType("angular/runNgcc");
    exports2.IsInAngularProject = new lsp.RequestType("angular/isAngularCoreInOwningProject");
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/utils.js
var require_utils = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/utils.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.getMappedDefinitionInfo = exports2.tsDisplayPartsToText = exports2.MruTracker = exports2.isConfiguredProject = exports2.tsRelatedInformationToLspRelatedInformation = exports2.lspRangeToTsPositions = exports2.lspPositionToTsPosition = exports2.tsTextSpanToLspRange = exports2.tsFileTextChangesToLspWorkspaceEdit = exports2.filePathToUri = exports2.uriToFilePath = exports2.isDebugMode = void 0;
    var ts = __importStar(require("typescript/lib/tsserverlibrary"));
    var lsp = __importStar(require("vscode-languageserver"));
    var vscode_uri_1 = require("vscode-uri");
    exports2.isDebugMode = process.env["NG_DEBUG"] === "true";
    var Scheme;
    (function(Scheme2) {
      Scheme2["File"] = "file";
    })(Scheme || (Scheme = {}));
    function uriToFilePath(uri) {
      const { scheme, fsPath } = vscode_uri_1.URI.parse(uri);
      if (scheme !== Scheme.File) {
        return "";
      }
      return fsPath;
    }
    exports2.uriToFilePath = uriToFilePath;
    function filePathToUri(filePath) {
      return vscode_uri_1.URI.file(filePath).toString();
    }
    exports2.filePathToUri = filePathToUri;
    function tsFileTextChangesToLspWorkspaceEdit(changes, getScriptInfo) {
      const workspaceChanges = {};
      for (const change of changes) {
        const scriptInfo = getScriptInfo(change.fileName);
        const uri = filePathToUri(change.fileName);
        if (scriptInfo === void 0) {
          continue;
        }
        if (!workspaceChanges[uri]) {
          workspaceChanges[uri] = [];
        }
        for (const textChange of change.textChanges) {
          const textEdit = {
            newText: textChange.newText,
            range: tsTextSpanToLspRange(scriptInfo, textChange.span)
          };
          workspaceChanges[uri].push(textEdit);
        }
      }
      return {
        changes: workspaceChanges
      };
    }
    exports2.tsFileTextChangesToLspWorkspaceEdit = tsFileTextChangesToLspWorkspaceEdit;
    function tsTextSpanToLspRange(scriptInfo, textSpan) {
      const start = scriptInfo.positionToLineOffset(textSpan.start);
      const end = scriptInfo.positionToLineOffset(textSpan.start + textSpan.length);
      return lsp.Range.create(start.line - 1, start.offset - 1, end.line - 1, end.offset - 1);
    }
    exports2.tsTextSpanToLspRange = tsTextSpanToLspRange;
    function lspPositionToTsPosition(scriptInfo, position) {
      const { line, character } = position;
      return scriptInfo.lineOffsetToPosition(line + 1, character + 1);
    }
    exports2.lspPositionToTsPosition = lspPositionToTsPosition;
    function lspRangeToTsPositions(scriptInfo, range) {
      const start = lspPositionToTsPosition(scriptInfo, range.start);
      const end = lspPositionToTsPosition(scriptInfo, range.end);
      return [start, end];
    }
    exports2.lspRangeToTsPositions = lspRangeToTsPositions;
    function tsRelatedInformationToLspRelatedInformation(scriptInfo, relatedInfo) {
      if (relatedInfo === void 0)
        return;
      const lspRelatedInfo = [];
      for (const info of relatedInfo) {
        if (info.file === void 0 || info.start === void 0 || info.length === void 0)
          continue;
        const textSpan = {
          start: info.start,
          length: info.length
        };
        const location = lsp.Location.create(filePathToUri(info.file.fileName), tsTextSpanToLspRange(scriptInfo, textSpan));
        lspRelatedInfo.push(lsp.DiagnosticRelatedInformation.create(location, ts.flattenDiagnosticMessageText(info.messageText, "\n")));
      }
      return lspRelatedInfo;
    }
    exports2.tsRelatedInformationToLspRelatedInformation = tsRelatedInformationToLspRelatedInformation;
    function isConfiguredProject(project) {
      return project.projectKind === ts.server.ProjectKind.Configured;
    }
    exports2.isConfiguredProject = isConfiguredProject;
    var MruTracker = class {
      constructor() {
        this.set = /* @__PURE__ */ new Set();
      }
      update(item) {
        if (this.set.has(item)) {
          this.set.delete(item);
        }
        this.set.add(item);
      }
      delete(item) {
        this.set.delete(item);
      }
      getAll() {
        return [...this.set].reverse();
      }
    };
    exports2.MruTracker = MruTracker;
    function tsDisplayPartsToText(parts) {
      return parts.map((dp) => dp.text).join("");
    }
    exports2.tsDisplayPartsToText = tsDisplayPartsToText;
    function getMappedDefinitionInfo(info, project) {
      try {
        const mappedDocumentSpan = getMappedDocumentSpan(info, project);
        return Object.assign(Object.assign({}, info), mappedDocumentSpan);
      } catch (_a) {
        return info;
      }
    }
    exports2.getMappedDefinitionInfo = getMappedDefinitionInfo;
    function getMappedDocumentSpan(documentSpan, project) {
      const newPosition = getMappedLocation(documentSpanLocation(documentSpan), project);
      if (!newPosition)
        return void 0;
      return {
        fileName: newPosition.fileName,
        textSpan: { start: newPosition.pos, length: documentSpan.textSpan.length },
        originalFileName: documentSpan.fileName,
        originalTextSpan: documentSpan.textSpan,
        contextSpan: getMappedContextSpan(documentSpan, project),
        originalContextSpan: documentSpan.contextSpan
      };
    }
    function getMappedLocation(location, project) {
      const mapsTo = project.getSourceMapper().tryGetSourcePosition(location);
      return mapsTo && project.projectService.fileExists(ts.server.toNormalizedPath(mapsTo.fileName)) ? mapsTo : void 0;
    }
    function documentSpanLocation({ fileName, textSpan }) {
      return { fileName, pos: textSpan.start };
    }
    function getMappedContextSpan(documentSpan, project) {
      const contextSpanStart = documentSpan.contextSpan && getMappedLocation({ fileName: documentSpan.fileName, pos: documentSpan.contextSpan.start }, project);
      const contextSpanEnd = documentSpan.contextSpan && getMappedLocation({
        fileName: documentSpan.fileName,
        pos: documentSpan.contextSpan.start + documentSpan.contextSpan.length
      }, project);
      return contextSpanStart && contextSpanEnd ? { start: contextSpanStart.pos, length: contextSpanEnd.pos - contextSpanStart.pos } : void 0;
    }
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/completion.js
var require_completion = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/completion.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.tsCompletionEntryToLspCompletionItem = exports2.readNgCompletionData = void 0;
    var lsp = __importStar(require("vscode-languageserver"));
    var utils_1 = require_utils();
    var CompletionKind;
    (function(CompletionKind2) {
      CompletionKind2["attribute"] = "attribute";
      CompletionKind2["htmlAttribute"] = "html attribute";
      CompletionKind2["property"] = "property";
      CompletionKind2["component"] = "component";
      CompletionKind2["directive"] = "directive";
      CompletionKind2["element"] = "element";
      CompletionKind2["event"] = "event";
      CompletionKind2["key"] = "key";
      CompletionKind2["method"] = "method";
      CompletionKind2["pipe"] = "pipe";
      CompletionKind2["type"] = "type";
      CompletionKind2["reference"] = "reference";
      CompletionKind2["variable"] = "variable";
      CompletionKind2["entity"] = "entity";
    })(CompletionKind || (CompletionKind = {}));
    function readNgCompletionData(item) {
      if (item.data === void 0) {
        return null;
      }
      const data = item.data;
      if (data.kind !== "ngCompletionOriginData") {
        return null;
      }
      return data;
    }
    exports2.readNgCompletionData = readNgCompletionData;
    function ngCompletionKindToLspCompletionItemKind(kind) {
      switch (kind) {
        case CompletionKind.attribute:
        case CompletionKind.htmlAttribute:
        case CompletionKind.property:
        case CompletionKind.event:
          return lsp.CompletionItemKind.Property;
        case CompletionKind.directive:
        case CompletionKind.component:
        case CompletionKind.element:
        case CompletionKind.key:
          return lsp.CompletionItemKind.Class;
        case CompletionKind.method:
          return lsp.CompletionItemKind.Method;
        case CompletionKind.pipe:
          return lsp.CompletionItemKind.Function;
        case CompletionKind.type:
          return lsp.CompletionItemKind.Interface;
        case CompletionKind.reference:
        case CompletionKind.variable:
          return lsp.CompletionItemKind.Variable;
        case CompletionKind.entity:
        default:
          return lsp.CompletionItemKind.Text;
      }
    }
    function tsCompletionEntryToLspCompletionItem(entry, position, scriptInfo, insertReplaceSupport, isIvy) {
      const item = lsp.CompletionItem.create(entry.name);
      const kind = entry.kind;
      item.kind = ngCompletionKindToLspCompletionItemKind(kind);
      item.detail = entry.kind;
      item.sortText = entry.sortText;
      const insertText = entry.insertText || entry.name;
      item.textEdit = createTextEdit(scriptInfo, entry, position, insertText, insertReplaceSupport);
      if (isIvy) {
        item.filterText = entry.insertText;
        if (entry.isSnippet) {
          item.insertTextFormat = lsp.InsertTextFormat.Snippet;
        }
      }
      item.data = {
        kind: "ngCompletionOriginData",
        filePath: scriptInfo.fileName,
        position
      };
      return item;
    }
    exports2.tsCompletionEntryToLspCompletionItem = tsCompletionEntryToLspCompletionItem;
    function createTextEdit(scriptInfo, entry, position, insertText, insertReplaceSupport) {
      if (entry.replacementSpan === void 0) {
        return lsp.TextEdit.insert(position, insertText);
      } else if (insertReplaceSupport) {
        const replacementRange = (0, utils_1.tsTextSpanToLspRange)(scriptInfo, entry.replacementSpan);
        const tsPosition = (0, utils_1.lspPositionToTsPosition)(scriptInfo, position);
        const insertLength = tsPosition - entry.replacementSpan.start;
        const insertionRange = (0, utils_1.tsTextSpanToLspRange)(scriptInfo, Object.assign(Object.assign({}, entry.replacementSpan), { length: insertLength }));
        return lsp.InsertReplaceEdit.create(insertText, insertionRange, replacementRange);
      } else {
        return lsp.TextEdit.replace((0, utils_1.tsTextSpanToLspRange)(scriptInfo, entry.replacementSpan), insertText);
      }
    }
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/diagnostic.js
var require_diagnostic = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/server/src/diagnostic.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.tsDiagnosticToLspDiagnostic = void 0;
    var ts = __importStar(require("typescript/lib/tsserverlibrary"));
    var lsp = __importStar(require("vscode-languageserver"));
    var utils_1 = require_utils();
    function tsDiagnosticCategoryToLspDiagnosticSeverity(category) {
      switch (category) {
        case ts.DiagnosticCategory.Warning:
          return lsp.DiagnosticSeverity.Warning;
        case ts.DiagnosticCategory.Error:
          return lsp.DiagnosticSeverity.Error;
        case ts.DiagnosticCategory.Suggestion:
          return lsp.DiagnosticSeverity.Hint;
        case ts.DiagnosticCategory.Message:
        default:
          return lsp.DiagnosticSeverity.Information;
      }
    }
    function tsDiagnosticToLspDiagnostic(tsDiag, scriptInfo) {
      const textSpan = {
        start: tsDiag.start || 0,
        length: tsDiag.length || 0
      };
      return lsp.Diagnostic.create((0, utils_1.tsTextSpanToLspRange)(scriptInfo, textSpan), ts.flattenDiagnosticMessageText(tsDiag.messageText, "\n"), tsDiagnosticCategoryToLspDiagnosticSeverity(tsDiag.category), tsDiag.code, tsDiag.source, (0, utils_1.tsRelatedInformationToLspRelatedInformation)(scriptInfo, tsDiag.relatedInformation));
    }
    exports2.tsDiagnosticToLspDiagnostic = tsDiagnosticToLspDiagnostic;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/base64.js
var require_base64 = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/base64.js"(exports2) {
    var intToCharMap = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split("");
    exports2.encode = function(number) {
      if (0 <= number && number < intToCharMap.length) {
        return intToCharMap[number];
      }
      throw new TypeError("Must be between 0 and 63: " + number);
    };
    exports2.decode = function(charCode) {
      var bigA = 65;
      var bigZ = 90;
      var littleA = 97;
      var littleZ = 122;
      var zero = 48;
      var nine = 57;
      var plus = 43;
      var slash = 47;
      var littleOffset = 26;
      var numberOffset = 52;
      if (bigA <= charCode && charCode <= bigZ) {
        return charCode - bigA;
      }
      if (littleA <= charCode && charCode <= littleZ) {
        return charCode - littleA + littleOffset;
      }
      if (zero <= charCode && charCode <= nine) {
        return charCode - zero + numberOffset;
      }
      if (charCode == plus) {
        return 62;
      }
      if (charCode == slash) {
        return 63;
      }
      return -1;
    };
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/base64-vlq.js
var require_base64_vlq = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/base64-vlq.js"(exports2) {
    var base64 = require_base64();
    var VLQ_BASE_SHIFT = 5;
    var VLQ_BASE = 1 << VLQ_BASE_SHIFT;
    var VLQ_BASE_MASK = VLQ_BASE - 1;
    var VLQ_CONTINUATION_BIT = VLQ_BASE;
    function toVLQSigned(aValue) {
      return aValue < 0 ? (-aValue << 1) + 1 : (aValue << 1) + 0;
    }
    function fromVLQSigned(aValue) {
      var isNegative = (aValue & 1) === 1;
      var shifted = aValue >> 1;
      return isNegative ? -shifted : shifted;
    }
    exports2.encode = function base64VLQ_encode(aValue) {
      var encoded = "";
      var digit;
      var vlq = toVLQSigned(aValue);
      do {
        digit = vlq & VLQ_BASE_MASK;
        vlq >>>= VLQ_BASE_SHIFT;
        if (vlq > 0) {
          digit |= VLQ_CONTINUATION_BIT;
        }
        encoded += base64.encode(digit);
      } while (vlq > 0);
      return encoded;
    };
    exports2.decode = function base64VLQ_decode(aStr, aIndex, aOutParam) {
      var strLen = aStr.length;
      var result = 0;
      var shift = 0;
      var continuation, digit;
      do {
        if (aIndex >= strLen) {
          throw new Error("Expected more digits in base 64 VLQ value.");
        }
        digit = base64.decode(aStr.charCodeAt(aIndex++));
        if (digit === -1) {
          throw new Error("Invalid base64 digit: " + aStr.charAt(aIndex - 1));
        }
        continuation = !!(digit & VLQ_CONTINUATION_BIT);
        digit &= VLQ_BASE_MASK;
        result = result + (digit << shift);
        shift += VLQ_BASE_SHIFT;
      } while (continuation);
      aOutParam.value = fromVLQSigned(result);
      aOutParam.rest = aIndex;
    };
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/util.js
var require_util = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/util.js"(exports2) {
    function getArg(aArgs, aName, aDefaultValue) {
      if (aName in aArgs) {
        return aArgs[aName];
      } else if (arguments.length === 3) {
        return aDefaultValue;
      } else {
        throw new Error('"' + aName + '" is a required argument.');
      }
    }
    exports2.getArg = getArg;
    var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.-]*)(?::(\d+))?(.*)$/;
    var dataUrlRegexp = /^data:.+\,.+$/;
    function urlParse(aUrl) {
      var match = aUrl.match(urlRegexp);
      if (!match) {
        return null;
      }
      return {
        scheme: match[1],
        auth: match[2],
        host: match[3],
        port: match[4],
        path: match[5]
      };
    }
    exports2.urlParse = urlParse;
    function urlGenerate(aParsedUrl) {
      var url = "";
      if (aParsedUrl.scheme) {
        url += aParsedUrl.scheme + ":";
      }
      url += "//";
      if (aParsedUrl.auth) {
        url += aParsedUrl.auth + "@";
      }
      if (aParsedUrl.host) {
        url += aParsedUrl.host;
      }
      if (aParsedUrl.port) {
        url += ":" + aParsedUrl.port;
      }
      if (aParsedUrl.path) {
        url += aParsedUrl.path;
      }
      return url;
    }
    exports2.urlGenerate = urlGenerate;
    function normalize(aPath) {
      var path = aPath;
      var url = urlParse(aPath);
      if (url) {
        if (!url.path) {
          return aPath;
        }
        path = url.path;
      }
      var isAbsolute = exports2.isAbsolute(path);
      var parts = path.split(/\/+/);
      for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
        part = parts[i];
        if (part === ".") {
          parts.splice(i, 1);
        } else if (part === "..") {
          up++;
        } else if (up > 0) {
          if (part === "") {
            parts.splice(i + 1, up);
            up = 0;
          } else {
            parts.splice(i, 2);
            up--;
          }
        }
      }
      path = parts.join("/");
      if (path === "") {
        path = isAbsolute ? "/" : ".";
      }
      if (url) {
        url.path = path;
        return urlGenerate(url);
      }
      return path;
    }
    exports2.normalize = normalize;
    function join(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      if (aPath === "") {
        aPath = ".";
      }
      var aPathUrl = urlParse(aPath);
      var aRootUrl = urlParse(aRoot);
      if (aRootUrl) {
        aRoot = aRootUrl.path || "/";
      }
      if (aPathUrl && !aPathUrl.scheme) {
        if (aRootUrl) {
          aPathUrl.scheme = aRootUrl.scheme;
        }
        return urlGenerate(aPathUrl);
      }
      if (aPathUrl || aPath.match(dataUrlRegexp)) {
        return aPath;
      }
      if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
        aRootUrl.host = aPath;
        return urlGenerate(aRootUrl);
      }
      var joined = aPath.charAt(0) === "/" ? aPath : normalize(aRoot.replace(/\/+$/, "") + "/" + aPath);
      if (aRootUrl) {
        aRootUrl.path = joined;
        return urlGenerate(aRootUrl);
      }
      return joined;
    }
    exports2.join = join;
    exports2.isAbsolute = function(aPath) {
      return aPath.charAt(0) === "/" || urlRegexp.test(aPath);
    };
    function relative(aRoot, aPath) {
      if (aRoot === "") {
        aRoot = ".";
      }
      aRoot = aRoot.replace(/\/$/, "");
      var level = 0;
      while (aPath.indexOf(aRoot + "/") !== 0) {
        var index = aRoot.lastIndexOf("/");
        if (index < 0) {
          return aPath;
        }
        aRoot = aRoot.slice(0, index);
        if (aRoot.match(/^([^\/]+:\/)?\/*$/)) {
          return aPath;
        }
        ++level;
      }
      return Array(level + 1).join("../") + aPath.substr(aRoot.length + 1);
    }
    exports2.relative = relative;
    var supportsNullProto = function() {
      var obj = /* @__PURE__ */ Object.create(null);
      return !("__proto__" in obj);
    }();
    function identity(s) {
      return s;
    }
    function toSetString(aStr) {
      if (isProtoString(aStr)) {
        return "$" + aStr;
      }
      return aStr;
    }
    exports2.toSetString = supportsNullProto ? identity : toSetString;
    function fromSetString(aStr) {
      if (isProtoString(aStr)) {
        return aStr.slice(1);
      }
      return aStr;
    }
    exports2.fromSetString = supportsNullProto ? identity : fromSetString;
    function isProtoString(s) {
      if (!s) {
        return false;
      }
      var length = s.length;
      if (length < 9) {
        return false;
      }
      if (s.charCodeAt(length - 1) !== 95 || s.charCodeAt(length - 2) !== 95 || s.charCodeAt(length - 3) !== 111 || s.charCodeAt(length - 4) !== 116 || s.charCodeAt(length - 5) !== 111 || s.charCodeAt(length - 6) !== 114 || s.charCodeAt(length - 7) !== 112 || s.charCodeAt(length - 8) !== 95 || s.charCodeAt(length - 9) !== 95) {
        return false;
      }
      for (var i = length - 10; i >= 0; i--) {
        if (s.charCodeAt(i) !== 36) {
          return false;
        }
      }
      return true;
    }
    function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
      var cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0 || onlyCompareOriginal) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByOriginalPositions = compareByOriginalPositions;
    function compareByGeneratedPositionsDeflated(mappingA, mappingB, onlyCompareGenerated) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0 || onlyCompareGenerated) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByGeneratedPositionsDeflated = compareByGeneratedPositionsDeflated;
    function strcmp(aStr1, aStr2) {
      if (aStr1 === aStr2) {
        return 0;
      }
      if (aStr1 === null) {
        return 1;
      }
      if (aStr2 === null) {
        return -1;
      }
      if (aStr1 > aStr2) {
        return 1;
      }
      return -1;
    }
    function compareByGeneratedPositionsInflated(mappingA, mappingB) {
      var cmp = mappingA.generatedLine - mappingB.generatedLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.generatedColumn - mappingB.generatedColumn;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = strcmp(mappingA.source, mappingB.source);
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalLine - mappingB.originalLine;
      if (cmp !== 0) {
        return cmp;
      }
      cmp = mappingA.originalColumn - mappingB.originalColumn;
      if (cmp !== 0) {
        return cmp;
      }
      return strcmp(mappingA.name, mappingB.name);
    }
    exports2.compareByGeneratedPositionsInflated = compareByGeneratedPositionsInflated;
    function parseSourceMapInput(str) {
      return JSON.parse(str.replace(/^\)]}'[^\n]*\n/, ""));
    }
    exports2.parseSourceMapInput = parseSourceMapInput;
    function computeSourceURL(sourceRoot, sourceURL, sourceMapURL) {
      sourceURL = sourceURL || "";
      if (sourceRoot) {
        if (sourceRoot[sourceRoot.length - 1] !== "/" && sourceURL[0] !== "/") {
          sourceRoot += "/";
        }
        sourceURL = sourceRoot + sourceURL;
      }
      if (sourceMapURL) {
        var parsed = urlParse(sourceMapURL);
        if (!parsed) {
          throw new Error("sourceMapURL could not be parsed");
        }
        if (parsed.path) {
          var index = parsed.path.lastIndexOf("/");
          if (index >= 0) {
            parsed.path = parsed.path.substring(0, index + 1);
          }
        }
        sourceURL = join(urlGenerate(parsed), sourceURL);
      }
      return normalize(sourceURL);
    }
    exports2.computeSourceURL = computeSourceURL;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/array-set.js
var require_array_set = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/array-set.js"(exports2) {
    var util = require_util();
    var has = Object.prototype.hasOwnProperty;
    var hasNativeMap = typeof Map !== "undefined";
    function ArraySet() {
      this._array = [];
      this._set = hasNativeMap ? /* @__PURE__ */ new Map() : /* @__PURE__ */ Object.create(null);
    }
    ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
      var set = new ArraySet();
      for (var i = 0, len = aArray.length; i < len; i++) {
        set.add(aArray[i], aAllowDuplicates);
      }
      return set;
    };
    ArraySet.prototype.size = function ArraySet_size() {
      return hasNativeMap ? this._set.size : Object.getOwnPropertyNames(this._set).length;
    };
    ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
      var sStr = hasNativeMap ? aStr : util.toSetString(aStr);
      var isDuplicate = hasNativeMap ? this.has(aStr) : has.call(this._set, sStr);
      var idx = this._array.length;
      if (!isDuplicate || aAllowDuplicates) {
        this._array.push(aStr);
      }
      if (!isDuplicate) {
        if (hasNativeMap) {
          this._set.set(aStr, idx);
        } else {
          this._set[sStr] = idx;
        }
      }
    };
    ArraySet.prototype.has = function ArraySet_has(aStr) {
      if (hasNativeMap) {
        return this._set.has(aStr);
      } else {
        var sStr = util.toSetString(aStr);
        return has.call(this._set, sStr);
      }
    };
    ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
      if (hasNativeMap) {
        var idx = this._set.get(aStr);
        if (idx >= 0) {
          return idx;
        }
      } else {
        var sStr = util.toSetString(aStr);
        if (has.call(this._set, sStr)) {
          return this._set[sStr];
        }
      }
      throw new Error('"' + aStr + '" is not in the set.');
    };
    ArraySet.prototype.at = function ArraySet_at(aIdx) {
      if (aIdx >= 0 && aIdx < this._array.length) {
        return this._array[aIdx];
      }
      throw new Error("No element indexed by " + aIdx);
    };
    ArraySet.prototype.toArray = function ArraySet_toArray() {
      return this._array.slice();
    };
    exports2.ArraySet = ArraySet;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/mapping-list.js
var require_mapping_list = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/mapping-list.js"(exports2) {
    var util = require_util();
    function generatedPositionAfter(mappingA, mappingB) {
      var lineA = mappingA.generatedLine;
      var lineB = mappingB.generatedLine;
      var columnA = mappingA.generatedColumn;
      var columnB = mappingB.generatedColumn;
      return lineB > lineA || lineB == lineA && columnB >= columnA || util.compareByGeneratedPositionsInflated(mappingA, mappingB) <= 0;
    }
    function MappingList() {
      this._array = [];
      this._sorted = true;
      this._last = { generatedLine: -1, generatedColumn: 0 };
    }
    MappingList.prototype.unsortedForEach = function MappingList_forEach(aCallback, aThisArg) {
      this._array.forEach(aCallback, aThisArg);
    };
    MappingList.prototype.add = function MappingList_add(aMapping) {
      if (generatedPositionAfter(this._last, aMapping)) {
        this._last = aMapping;
        this._array.push(aMapping);
      } else {
        this._sorted = false;
        this._array.push(aMapping);
      }
    };
    MappingList.prototype.toArray = function MappingList_toArray() {
      if (!this._sorted) {
        this._array.sort(util.compareByGeneratedPositionsInflated);
        this._sorted = true;
      }
      return this._array;
    };
    exports2.MappingList = MappingList;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/source-map-generator.js
var require_source_map_generator = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/source-map-generator.js"(exports2) {
    var base64VLQ = require_base64_vlq();
    var util = require_util();
    var ArraySet = require_array_set().ArraySet;
    var MappingList = require_mapping_list().MappingList;
    function SourceMapGenerator(aArgs) {
      if (!aArgs) {
        aArgs = {};
      }
      this._file = util.getArg(aArgs, "file", null);
      this._sourceRoot = util.getArg(aArgs, "sourceRoot", null);
      this._skipValidation = util.getArg(aArgs, "skipValidation", false);
      this._sources = new ArraySet();
      this._names = new ArraySet();
      this._mappings = new MappingList();
      this._sourcesContents = null;
    }
    SourceMapGenerator.prototype._version = 3;
    SourceMapGenerator.fromSourceMap = function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
      var sourceRoot = aSourceMapConsumer.sourceRoot;
      var generator = new SourceMapGenerator({
        file: aSourceMapConsumer.file,
        sourceRoot
      });
      aSourceMapConsumer.eachMapping(function(mapping) {
        var newMapping = {
          generated: {
            line: mapping.generatedLine,
            column: mapping.generatedColumn
          }
        };
        if (mapping.source != null) {
          newMapping.source = mapping.source;
          if (sourceRoot != null) {
            newMapping.source = util.relative(sourceRoot, newMapping.source);
          }
          newMapping.original = {
            line: mapping.originalLine,
            column: mapping.originalColumn
          };
          if (mapping.name != null) {
            newMapping.name = mapping.name;
          }
        }
        generator.addMapping(newMapping);
      });
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var sourceRelative = sourceFile;
        if (sourceRoot !== null) {
          sourceRelative = util.relative(sourceRoot, sourceFile);
        }
        if (!generator._sources.has(sourceRelative)) {
          generator._sources.add(sourceRelative);
        }
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          generator.setSourceContent(sourceFile, content);
        }
      });
      return generator;
    };
    SourceMapGenerator.prototype.addMapping = function SourceMapGenerator_addMapping(aArgs) {
      var generated = util.getArg(aArgs, "generated");
      var original = util.getArg(aArgs, "original", null);
      var source = util.getArg(aArgs, "source", null);
      var name = util.getArg(aArgs, "name", null);
      if (!this._skipValidation) {
        this._validateMapping(generated, original, source, name);
      }
      if (source != null) {
        source = String(source);
        if (!this._sources.has(source)) {
          this._sources.add(source);
        }
      }
      if (name != null) {
        name = String(name);
        if (!this._names.has(name)) {
          this._names.add(name);
        }
      }
      this._mappings.add({
        generatedLine: generated.line,
        generatedColumn: generated.column,
        originalLine: original != null && original.line,
        originalColumn: original != null && original.column,
        source,
        name
      });
    };
    SourceMapGenerator.prototype.setSourceContent = function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
      var source = aSourceFile;
      if (this._sourceRoot != null) {
        source = util.relative(this._sourceRoot, source);
      }
      if (aSourceContent != null) {
        if (!this._sourcesContents) {
          this._sourcesContents = /* @__PURE__ */ Object.create(null);
        }
        this._sourcesContents[util.toSetString(source)] = aSourceContent;
      } else if (this._sourcesContents) {
        delete this._sourcesContents[util.toSetString(source)];
        if (Object.keys(this._sourcesContents).length === 0) {
          this._sourcesContents = null;
        }
      }
    };
    SourceMapGenerator.prototype.applySourceMap = function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
      var sourceFile = aSourceFile;
      if (aSourceFile == null) {
        if (aSourceMapConsumer.file == null) {
          throw new Error(
            `SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, or the source map's "file" property. Both were omitted.`
          );
        }
        sourceFile = aSourceMapConsumer.file;
      }
      var sourceRoot = this._sourceRoot;
      if (sourceRoot != null) {
        sourceFile = util.relative(sourceRoot, sourceFile);
      }
      var newSources = new ArraySet();
      var newNames = new ArraySet();
      this._mappings.unsortedForEach(function(mapping) {
        if (mapping.source === sourceFile && mapping.originalLine != null) {
          var original = aSourceMapConsumer.originalPositionFor({
            line: mapping.originalLine,
            column: mapping.originalColumn
          });
          if (original.source != null) {
            mapping.source = original.source;
            if (aSourceMapPath != null) {
              mapping.source = util.join(aSourceMapPath, mapping.source);
            }
            if (sourceRoot != null) {
              mapping.source = util.relative(sourceRoot, mapping.source);
            }
            mapping.originalLine = original.line;
            mapping.originalColumn = original.column;
            if (original.name != null) {
              mapping.name = original.name;
            }
          }
        }
        var source = mapping.source;
        if (source != null && !newSources.has(source)) {
          newSources.add(source);
        }
        var name = mapping.name;
        if (name != null && !newNames.has(name)) {
          newNames.add(name);
        }
      }, this);
      this._sources = newSources;
      this._names = newNames;
      aSourceMapConsumer.sources.forEach(function(sourceFile2) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile2);
        if (content != null) {
          if (aSourceMapPath != null) {
            sourceFile2 = util.join(aSourceMapPath, sourceFile2);
          }
          if (sourceRoot != null) {
            sourceFile2 = util.relative(sourceRoot, sourceFile2);
          }
          this.setSourceContent(sourceFile2, content);
        }
      }, this);
    };
    SourceMapGenerator.prototype._validateMapping = function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource, aName) {
      if (aOriginal && typeof aOriginal.line !== "number" && typeof aOriginal.column !== "number") {
        throw new Error(
          "original.line and original.column are not numbers -- you probably meant to omit the original mapping entirely and only map the generated position. If so, pass null for the original mapping instead of an object with empty or null values."
        );
      }
      if (aGenerated && "line" in aGenerated && "column" in aGenerated && aGenerated.line > 0 && aGenerated.column >= 0 && !aOriginal && !aSource && !aName) {
        return;
      } else if (aGenerated && "line" in aGenerated && "column" in aGenerated && aOriginal && "line" in aOriginal && "column" in aOriginal && aGenerated.line > 0 && aGenerated.column >= 0 && aOriginal.line > 0 && aOriginal.column >= 0 && aSource) {
        return;
      } else {
        throw new Error("Invalid mapping: " + JSON.stringify({
          generated: aGenerated,
          source: aSource,
          original: aOriginal,
          name: aName
        }));
      }
    };
    SourceMapGenerator.prototype._serializeMappings = function SourceMapGenerator_serializeMappings() {
      var previousGeneratedColumn = 0;
      var previousGeneratedLine = 1;
      var previousOriginalColumn = 0;
      var previousOriginalLine = 0;
      var previousName = 0;
      var previousSource = 0;
      var result = "";
      var next;
      var mapping;
      var nameIdx;
      var sourceIdx;
      var mappings = this._mappings.toArray();
      for (var i = 0, len = mappings.length; i < len; i++) {
        mapping = mappings[i];
        next = "";
        if (mapping.generatedLine !== previousGeneratedLine) {
          previousGeneratedColumn = 0;
          while (mapping.generatedLine !== previousGeneratedLine) {
            next += ";";
            previousGeneratedLine++;
          }
        } else {
          if (i > 0) {
            if (!util.compareByGeneratedPositionsInflated(mapping, mappings[i - 1])) {
              continue;
            }
            next += ",";
          }
        }
        next += base64VLQ.encode(mapping.generatedColumn - previousGeneratedColumn);
        previousGeneratedColumn = mapping.generatedColumn;
        if (mapping.source != null) {
          sourceIdx = this._sources.indexOf(mapping.source);
          next += base64VLQ.encode(sourceIdx - previousSource);
          previousSource = sourceIdx;
          next += base64VLQ.encode(mapping.originalLine - 1 - previousOriginalLine);
          previousOriginalLine = mapping.originalLine - 1;
          next += base64VLQ.encode(mapping.originalColumn - previousOriginalColumn);
          previousOriginalColumn = mapping.originalColumn;
          if (mapping.name != null) {
            nameIdx = this._names.indexOf(mapping.name);
            next += base64VLQ.encode(nameIdx - previousName);
            previousName = nameIdx;
          }
        }
        result += next;
      }
      return result;
    };
    SourceMapGenerator.prototype._generateSourcesContent = function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
      return aSources.map(function(source) {
        if (!this._sourcesContents) {
          return null;
        }
        if (aSourceRoot != null) {
          source = util.relative(aSourceRoot, source);
        }
        var key = util.toSetString(source);
        return Object.prototype.hasOwnProperty.call(this._sourcesContents, key) ? this._sourcesContents[key] : null;
      }, this);
    };
    SourceMapGenerator.prototype.toJSON = function SourceMapGenerator_toJSON() {
      var map = {
        version: this._version,
        sources: this._sources.toArray(),
        names: this._names.toArray(),
        mappings: this._serializeMappings()
      };
      if (this._file != null) {
        map.file = this._file;
      }
      if (this._sourceRoot != null) {
        map.sourceRoot = this._sourceRoot;
      }
      if (this._sourcesContents) {
        map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
      }
      return map;
    };
    SourceMapGenerator.prototype.toString = function SourceMapGenerator_toString() {
      return JSON.stringify(this.toJSON());
    };
    exports2.SourceMapGenerator = SourceMapGenerator;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/binary-search.js
var require_binary_search = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/binary-search.js"(exports2) {
    exports2.GREATEST_LOWER_BOUND = 1;
    exports2.LEAST_UPPER_BOUND = 2;
    function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare, aBias) {
      var mid = Math.floor((aHigh - aLow) / 2) + aLow;
      var cmp = aCompare(aNeedle, aHaystack[mid], true);
      if (cmp === 0) {
        return mid;
      } else if (cmp > 0) {
        if (aHigh - mid > 1) {
          return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports2.LEAST_UPPER_BOUND) {
          return aHigh < aHaystack.length ? aHigh : -1;
        } else {
          return mid;
        }
      } else {
        if (mid - aLow > 1) {
          return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare, aBias);
        }
        if (aBias == exports2.LEAST_UPPER_BOUND) {
          return mid;
        } else {
          return aLow < 0 ? -1 : aLow;
        }
      }
    }
    exports2.search = function search(aNeedle, aHaystack, aCompare, aBias) {
      if (aHaystack.length === 0) {
        return -1;
      }
      var index = recursiveSearch(
        -1,
        aHaystack.length,
        aNeedle,
        aHaystack,
        aCompare,
        aBias || exports2.GREATEST_LOWER_BOUND
      );
      if (index < 0) {
        return -1;
      }
      while (index - 1 >= 0) {
        if (aCompare(aHaystack[index], aHaystack[index - 1], true) !== 0) {
          break;
        }
        --index;
      }
      return index;
    };
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/quick-sort.js
var require_quick_sort = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/quick-sort.js"(exports2) {
    function swap(ary, x, y) {
      var temp = ary[x];
      ary[x] = ary[y];
      ary[y] = temp;
    }
    function randomIntInRange(low, high) {
      return Math.round(low + Math.random() * (high - low));
    }
    function doQuickSort(ary, comparator, p, r) {
      if (p < r) {
        var pivotIndex = randomIntInRange(p, r);
        var i = p - 1;
        swap(ary, pivotIndex, r);
        var pivot = ary[r];
        for (var j = p; j < r; j++) {
          if (comparator(ary[j], pivot) <= 0) {
            i += 1;
            swap(ary, i, j);
          }
        }
        swap(ary, i + 1, j);
        var q = i + 1;
        doQuickSort(ary, comparator, p, q - 1);
        doQuickSort(ary, comparator, q + 1, r);
      }
    }
    exports2.quickSort = function(ary, comparator) {
      doQuickSort(ary, comparator, 0, ary.length - 1);
    };
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/source-map-consumer.js
var require_source_map_consumer = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/source-map-consumer.js"(exports2) {
    var util = require_util();
    var binarySearch = require_binary_search();
    var ArraySet = require_array_set().ArraySet;
    var base64VLQ = require_base64_vlq();
    var quickSort = require_quick_sort().quickSort;
    function SourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      return sourceMap.sections != null ? new IndexedSourceMapConsumer(sourceMap, aSourceMapURL) : new BasicSourceMapConsumer(sourceMap, aSourceMapURL);
    }
    SourceMapConsumer.fromSourceMap = function(aSourceMap, aSourceMapURL) {
      return BasicSourceMapConsumer.fromSourceMap(aSourceMap, aSourceMapURL);
    };
    SourceMapConsumer.prototype._version = 3;
    SourceMapConsumer.prototype.__generatedMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, "_generatedMappings", {
      configurable: true,
      enumerable: true,
      get: function() {
        if (!this.__generatedMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__generatedMappings;
      }
    });
    SourceMapConsumer.prototype.__originalMappings = null;
    Object.defineProperty(SourceMapConsumer.prototype, "_originalMappings", {
      configurable: true,
      enumerable: true,
      get: function() {
        if (!this.__originalMappings) {
          this._parseMappings(this._mappings, this.sourceRoot);
        }
        return this.__originalMappings;
      }
    });
    SourceMapConsumer.prototype._charIsMappingSeparator = function SourceMapConsumer_charIsMappingSeparator(aStr, index) {
      var c = aStr.charAt(index);
      return c === ";" || c === ",";
    };
    SourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      throw new Error("Subclasses must implement _parseMappings");
    };
    SourceMapConsumer.GENERATED_ORDER = 1;
    SourceMapConsumer.ORIGINAL_ORDER = 2;
    SourceMapConsumer.GREATEST_LOWER_BOUND = 1;
    SourceMapConsumer.LEAST_UPPER_BOUND = 2;
    SourceMapConsumer.prototype.eachMapping = function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
      var context = aContext || null;
      var order = aOrder || SourceMapConsumer.GENERATED_ORDER;
      var mappings;
      switch (order) {
        case SourceMapConsumer.GENERATED_ORDER:
          mappings = this._generatedMappings;
          break;
        case SourceMapConsumer.ORIGINAL_ORDER:
          mappings = this._originalMappings;
          break;
        default:
          throw new Error("Unknown order of iteration.");
      }
      var sourceRoot = this.sourceRoot;
      mappings.map(function(mapping) {
        var source = mapping.source === null ? null : this._sources.at(mapping.source);
        source = util.computeSourceURL(sourceRoot, source, this._sourceMapURL);
        return {
          source,
          generatedLine: mapping.generatedLine,
          generatedColumn: mapping.generatedColumn,
          originalLine: mapping.originalLine,
          originalColumn: mapping.originalColumn,
          name: mapping.name === null ? null : this._names.at(mapping.name)
        };
      }, this).forEach(aCallback, context);
    };
    SourceMapConsumer.prototype.allGeneratedPositionsFor = function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
      var line = util.getArg(aArgs, "line");
      var needle = {
        source: util.getArg(aArgs, "source"),
        originalLine: line,
        originalColumn: util.getArg(aArgs, "column", 0)
      };
      needle.source = this._findSourceIndex(needle.source);
      if (needle.source < 0) {
        return [];
      }
      var mappings = [];
      var index = this._findMapping(
        needle,
        this._originalMappings,
        "originalLine",
        "originalColumn",
        util.compareByOriginalPositions,
        binarySearch.LEAST_UPPER_BOUND
      );
      if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (aArgs.column === void 0) {
          var originalLine = mapping.originalLine;
          while (mapping && mapping.originalLine === originalLine) {
            mappings.push({
              line: util.getArg(mapping, "generatedLine", null),
              column: util.getArg(mapping, "generatedColumn", null),
              lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
            });
            mapping = this._originalMappings[++index];
          }
        } else {
          var originalColumn = mapping.originalColumn;
          while (mapping && mapping.originalLine === line && mapping.originalColumn == originalColumn) {
            mappings.push({
              line: util.getArg(mapping, "generatedLine", null),
              column: util.getArg(mapping, "generatedColumn", null),
              lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
            });
            mapping = this._originalMappings[++index];
          }
        }
      }
      return mappings;
    };
    exports2.SourceMapConsumer = SourceMapConsumer;
    function BasicSourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      var version = util.getArg(sourceMap, "version");
      var sources = util.getArg(sourceMap, "sources");
      var names = util.getArg(sourceMap, "names", []);
      var sourceRoot = util.getArg(sourceMap, "sourceRoot", null);
      var sourcesContent = util.getArg(sourceMap, "sourcesContent", null);
      var mappings = util.getArg(sourceMap, "mappings");
      var file = util.getArg(sourceMap, "file", null);
      if (version != this._version) {
        throw new Error("Unsupported version: " + version);
      }
      if (sourceRoot) {
        sourceRoot = util.normalize(sourceRoot);
      }
      sources = sources.map(String).map(util.normalize).map(function(source) {
        return sourceRoot && util.isAbsolute(sourceRoot) && util.isAbsolute(source) ? util.relative(sourceRoot, source) : source;
      });
      this._names = ArraySet.fromArray(names.map(String), true);
      this._sources = ArraySet.fromArray(sources, true);
      this._absoluteSources = this._sources.toArray().map(function(s) {
        return util.computeSourceURL(sourceRoot, s, aSourceMapURL);
      });
      this.sourceRoot = sourceRoot;
      this.sourcesContent = sourcesContent;
      this._mappings = mappings;
      this._sourceMapURL = aSourceMapURL;
      this.file = file;
    }
    BasicSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
    BasicSourceMapConsumer.prototype.consumer = SourceMapConsumer;
    BasicSourceMapConsumer.prototype._findSourceIndex = function(aSource) {
      var relativeSource = aSource;
      if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
      }
      if (this._sources.has(relativeSource)) {
        return this._sources.indexOf(relativeSource);
      }
      var i;
      for (i = 0; i < this._absoluteSources.length; ++i) {
        if (this._absoluteSources[i] == aSource) {
          return i;
        }
      }
      return -1;
    };
    BasicSourceMapConsumer.fromSourceMap = function SourceMapConsumer_fromSourceMap(aSourceMap, aSourceMapURL) {
      var smc = Object.create(BasicSourceMapConsumer.prototype);
      var names = smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
      var sources = smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
      smc.sourceRoot = aSourceMap._sourceRoot;
      smc.sourcesContent = aSourceMap._generateSourcesContent(
        smc._sources.toArray(),
        smc.sourceRoot
      );
      smc.file = aSourceMap._file;
      smc._sourceMapURL = aSourceMapURL;
      smc._absoluteSources = smc._sources.toArray().map(function(s) {
        return util.computeSourceURL(smc.sourceRoot, s, aSourceMapURL);
      });
      var generatedMappings = aSourceMap._mappings.toArray().slice();
      var destGeneratedMappings = smc.__generatedMappings = [];
      var destOriginalMappings = smc.__originalMappings = [];
      for (var i = 0, length = generatedMappings.length; i < length; i++) {
        var srcMapping = generatedMappings[i];
        var destMapping = new Mapping();
        destMapping.generatedLine = srcMapping.generatedLine;
        destMapping.generatedColumn = srcMapping.generatedColumn;
        if (srcMapping.source) {
          destMapping.source = sources.indexOf(srcMapping.source);
          destMapping.originalLine = srcMapping.originalLine;
          destMapping.originalColumn = srcMapping.originalColumn;
          if (srcMapping.name) {
            destMapping.name = names.indexOf(srcMapping.name);
          }
          destOriginalMappings.push(destMapping);
        }
        destGeneratedMappings.push(destMapping);
      }
      quickSort(smc.__originalMappings, util.compareByOriginalPositions);
      return smc;
    };
    BasicSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(BasicSourceMapConsumer.prototype, "sources", {
      get: function() {
        return this._absoluteSources.slice();
      }
    });
    function Mapping() {
      this.generatedLine = 0;
      this.generatedColumn = 0;
      this.source = null;
      this.originalLine = null;
      this.originalColumn = null;
      this.name = null;
    }
    BasicSourceMapConsumer.prototype._parseMappings = function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      var generatedLine = 1;
      var previousGeneratedColumn = 0;
      var previousOriginalLine = 0;
      var previousOriginalColumn = 0;
      var previousSource = 0;
      var previousName = 0;
      var length = aStr.length;
      var index = 0;
      var cachedSegments = {};
      var temp = {};
      var originalMappings = [];
      var generatedMappings = [];
      var mapping, str, segment, end, value;
      while (index < length) {
        if (aStr.charAt(index) === ";") {
          generatedLine++;
          index++;
          previousGeneratedColumn = 0;
        } else if (aStr.charAt(index) === ",") {
          index++;
        } else {
          mapping = new Mapping();
          mapping.generatedLine = generatedLine;
          for (end = index; end < length; end++) {
            if (this._charIsMappingSeparator(aStr, end)) {
              break;
            }
          }
          str = aStr.slice(index, end);
          segment = cachedSegments[str];
          if (segment) {
            index += str.length;
          } else {
            segment = [];
            while (index < end) {
              base64VLQ.decode(aStr, index, temp);
              value = temp.value;
              index = temp.rest;
              segment.push(value);
            }
            if (segment.length === 2) {
              throw new Error("Found a source, but no line and column");
            }
            if (segment.length === 3) {
              throw new Error("Found a source and line, but no column");
            }
            cachedSegments[str] = segment;
          }
          mapping.generatedColumn = previousGeneratedColumn + segment[0];
          previousGeneratedColumn = mapping.generatedColumn;
          if (segment.length > 1) {
            mapping.source = previousSource + segment[1];
            previousSource += segment[1];
            mapping.originalLine = previousOriginalLine + segment[2];
            previousOriginalLine = mapping.originalLine;
            mapping.originalLine += 1;
            mapping.originalColumn = previousOriginalColumn + segment[3];
            previousOriginalColumn = mapping.originalColumn;
            if (segment.length > 4) {
              mapping.name = previousName + segment[4];
              previousName += segment[4];
            }
          }
          generatedMappings.push(mapping);
          if (typeof mapping.originalLine === "number") {
            originalMappings.push(mapping);
          }
        }
      }
      quickSort(generatedMappings, util.compareByGeneratedPositionsDeflated);
      this.__generatedMappings = generatedMappings;
      quickSort(originalMappings, util.compareByOriginalPositions);
      this.__originalMappings = originalMappings;
    };
    BasicSourceMapConsumer.prototype._findMapping = function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName, aColumnName, aComparator, aBias) {
      if (aNeedle[aLineName] <= 0) {
        throw new TypeError("Line must be greater than or equal to 1, got " + aNeedle[aLineName]);
      }
      if (aNeedle[aColumnName] < 0) {
        throw new TypeError("Column must be greater than or equal to 0, got " + aNeedle[aColumnName]);
      }
      return binarySearch.search(aNeedle, aMappings, aComparator, aBias);
    };
    BasicSourceMapConsumer.prototype.computeColumnSpans = function SourceMapConsumer_computeColumnSpans() {
      for (var index = 0; index < this._generatedMappings.length; ++index) {
        var mapping = this._generatedMappings[index];
        if (index + 1 < this._generatedMappings.length) {
          var nextMapping = this._generatedMappings[index + 1];
          if (mapping.generatedLine === nextMapping.generatedLine) {
            mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
            continue;
          }
        }
        mapping.lastGeneratedColumn = Infinity;
      }
    };
    BasicSourceMapConsumer.prototype.originalPositionFor = function SourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, "line"),
        generatedColumn: util.getArg(aArgs, "column")
      };
      var index = this._findMapping(
        needle,
        this._generatedMappings,
        "generatedLine",
        "generatedColumn",
        util.compareByGeneratedPositionsDeflated,
        util.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND)
      );
      if (index >= 0) {
        var mapping = this._generatedMappings[index];
        if (mapping.generatedLine === needle.generatedLine) {
          var source = util.getArg(mapping, "source", null);
          if (source !== null) {
            source = this._sources.at(source);
            source = util.computeSourceURL(this.sourceRoot, source, this._sourceMapURL);
          }
          var name = util.getArg(mapping, "name", null);
          if (name !== null) {
            name = this._names.at(name);
          }
          return {
            source,
            line: util.getArg(mapping, "originalLine", null),
            column: util.getArg(mapping, "originalColumn", null),
            name
          };
        }
      }
      return {
        source: null,
        line: null,
        column: null,
        name: null
      };
    };
    BasicSourceMapConsumer.prototype.hasContentsOfAllSources = function BasicSourceMapConsumer_hasContentsOfAllSources() {
      if (!this.sourcesContent) {
        return false;
      }
      return this.sourcesContent.length >= this._sources.size() && !this.sourcesContent.some(function(sc) {
        return sc == null;
      });
    };
    BasicSourceMapConsumer.prototype.sourceContentFor = function SourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      if (!this.sourcesContent) {
        return null;
      }
      var index = this._findSourceIndex(aSource);
      if (index >= 0) {
        return this.sourcesContent[index];
      }
      var relativeSource = aSource;
      if (this.sourceRoot != null) {
        relativeSource = util.relative(this.sourceRoot, relativeSource);
      }
      var url;
      if (this.sourceRoot != null && (url = util.urlParse(this.sourceRoot))) {
        var fileUriAbsPath = relativeSource.replace(/^file:\/\//, "");
        if (url.scheme == "file" && this._sources.has(fileUriAbsPath)) {
          return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)];
        }
        if ((!url.path || url.path == "/") && this._sources.has("/" + relativeSource)) {
          return this.sourcesContent[this._sources.indexOf("/" + relativeSource)];
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + relativeSource + '" is not in the SourceMap.');
      }
    };
    BasicSourceMapConsumer.prototype.generatedPositionFor = function SourceMapConsumer_generatedPositionFor(aArgs) {
      var source = util.getArg(aArgs, "source");
      source = this._findSourceIndex(source);
      if (source < 0) {
        return {
          line: null,
          column: null,
          lastColumn: null
        };
      }
      var needle = {
        source,
        originalLine: util.getArg(aArgs, "line"),
        originalColumn: util.getArg(aArgs, "column")
      };
      var index = this._findMapping(
        needle,
        this._originalMappings,
        "originalLine",
        "originalColumn",
        util.compareByOriginalPositions,
        util.getArg(aArgs, "bias", SourceMapConsumer.GREATEST_LOWER_BOUND)
      );
      if (index >= 0) {
        var mapping = this._originalMappings[index];
        if (mapping.source === needle.source) {
          return {
            line: util.getArg(mapping, "generatedLine", null),
            column: util.getArg(mapping, "generatedColumn", null),
            lastColumn: util.getArg(mapping, "lastGeneratedColumn", null)
          };
        }
      }
      return {
        line: null,
        column: null,
        lastColumn: null
      };
    };
    exports2.BasicSourceMapConsumer = BasicSourceMapConsumer;
    function IndexedSourceMapConsumer(aSourceMap, aSourceMapURL) {
      var sourceMap = aSourceMap;
      if (typeof aSourceMap === "string") {
        sourceMap = util.parseSourceMapInput(aSourceMap);
      }
      var version = util.getArg(sourceMap, "version");
      var sections = util.getArg(sourceMap, "sections");
      if (version != this._version) {
        throw new Error("Unsupported version: " + version);
      }
      this._sources = new ArraySet();
      this._names = new ArraySet();
      var lastOffset = {
        line: -1,
        column: 0
      };
      this._sections = sections.map(function(s) {
        if (s.url) {
          throw new Error("Support for url field in sections not implemented.");
        }
        var offset = util.getArg(s, "offset");
        var offsetLine = util.getArg(offset, "line");
        var offsetColumn = util.getArg(offset, "column");
        if (offsetLine < lastOffset.line || offsetLine === lastOffset.line && offsetColumn < lastOffset.column) {
          throw new Error("Section offsets must be ordered and non-overlapping.");
        }
        lastOffset = offset;
        return {
          generatedOffset: {
            generatedLine: offsetLine + 1,
            generatedColumn: offsetColumn + 1
          },
          consumer: new SourceMapConsumer(util.getArg(s, "map"), aSourceMapURL)
        };
      });
    }
    IndexedSourceMapConsumer.prototype = Object.create(SourceMapConsumer.prototype);
    IndexedSourceMapConsumer.prototype.constructor = SourceMapConsumer;
    IndexedSourceMapConsumer.prototype._version = 3;
    Object.defineProperty(IndexedSourceMapConsumer.prototype, "sources", {
      get: function() {
        var sources = [];
        for (var i = 0; i < this._sections.length; i++) {
          for (var j = 0; j < this._sections[i].consumer.sources.length; j++) {
            sources.push(this._sections[i].consumer.sources[j]);
          }
        }
        return sources;
      }
    });
    IndexedSourceMapConsumer.prototype.originalPositionFor = function IndexedSourceMapConsumer_originalPositionFor(aArgs) {
      var needle = {
        generatedLine: util.getArg(aArgs, "line"),
        generatedColumn: util.getArg(aArgs, "column")
      };
      var sectionIndex = binarySearch.search(
        needle,
        this._sections,
        function(needle2, section2) {
          var cmp = needle2.generatedLine - section2.generatedOffset.generatedLine;
          if (cmp) {
            return cmp;
          }
          return needle2.generatedColumn - section2.generatedOffset.generatedColumn;
        }
      );
      var section = this._sections[sectionIndex];
      if (!section) {
        return {
          source: null,
          line: null,
          column: null,
          name: null
        };
      }
      return section.consumer.originalPositionFor({
        line: needle.generatedLine - (section.generatedOffset.generatedLine - 1),
        column: needle.generatedColumn - (section.generatedOffset.generatedLine === needle.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
        bias: aArgs.bias
      });
    };
    IndexedSourceMapConsumer.prototype.hasContentsOfAllSources = function IndexedSourceMapConsumer_hasContentsOfAllSources() {
      return this._sections.every(function(s) {
        return s.consumer.hasContentsOfAllSources();
      });
    };
    IndexedSourceMapConsumer.prototype.sourceContentFor = function IndexedSourceMapConsumer_sourceContentFor(aSource, nullOnMissing) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var content = section.consumer.sourceContentFor(aSource, true);
        if (content) {
          return content;
        }
      }
      if (nullOnMissing) {
        return null;
      } else {
        throw new Error('"' + aSource + '" is not in the SourceMap.');
      }
    };
    IndexedSourceMapConsumer.prototype.generatedPositionFor = function IndexedSourceMapConsumer_generatedPositionFor(aArgs) {
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        if (section.consumer._findSourceIndex(util.getArg(aArgs, "source")) === -1) {
          continue;
        }
        var generatedPosition = section.consumer.generatedPositionFor(aArgs);
        if (generatedPosition) {
          var ret = {
            line: generatedPosition.line + (section.generatedOffset.generatedLine - 1),
            column: generatedPosition.column + (section.generatedOffset.generatedLine === generatedPosition.line ? section.generatedOffset.generatedColumn - 1 : 0)
          };
          return ret;
        }
      }
      return {
        line: null,
        column: null
      };
    };
    IndexedSourceMapConsumer.prototype._parseMappings = function IndexedSourceMapConsumer_parseMappings(aStr, aSourceRoot) {
      this.__generatedMappings = [];
      this.__originalMappings = [];
      for (var i = 0; i < this._sections.length; i++) {
        var section = this._sections[i];
        var sectionMappings = section.consumer._generatedMappings;
        for (var j = 0; j < sectionMappings.length; j++) {
          var mapping = sectionMappings[j];
          var source = section.consumer._sources.at(mapping.source);
          source = util.computeSourceURL(section.consumer.sourceRoot, source, this._sourceMapURL);
          this._sources.add(source);
          source = this._sources.indexOf(source);
          var name = null;
          if (mapping.name) {
            name = section.consumer._names.at(mapping.name);
            this._names.add(name);
            name = this._names.indexOf(name);
          }
          var adjustedMapping = {
            source,
            generatedLine: mapping.generatedLine + (section.generatedOffset.generatedLine - 1),
            generatedColumn: mapping.generatedColumn + (section.generatedOffset.generatedLine === mapping.generatedLine ? section.generatedOffset.generatedColumn - 1 : 0),
            originalLine: mapping.originalLine,
            originalColumn: mapping.originalColumn,
            name
          };
          this.__generatedMappings.push(adjustedMapping);
          if (typeof adjustedMapping.originalLine === "number") {
            this.__originalMappings.push(adjustedMapping);
          }
        }
      }
      quickSort(this.__generatedMappings, util.compareByGeneratedPositionsDeflated);
      quickSort(this.__originalMappings, util.compareByOriginalPositions);
    };
    exports2.IndexedSourceMapConsumer = IndexedSourceMapConsumer;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/source-node.js
var require_source_node = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/lib/source-node.js"(exports2) {
    var SourceMapGenerator = require_source_map_generator().SourceMapGenerator;
    var util = require_util();
    var REGEX_NEWLINE = /(\r?\n)/;
    var NEWLINE_CODE = 10;
    var isSourceNode = "$$$isSourceNode$$$";
    function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
      this.children = [];
      this.sourceContents = {};
      this.line = aLine == null ? null : aLine;
      this.column = aColumn == null ? null : aColumn;
      this.source = aSource == null ? null : aSource;
      this.name = aName == null ? null : aName;
      this[isSourceNode] = true;
      if (aChunks != null)
        this.add(aChunks);
    }
    SourceNode.fromStringWithSourceMap = function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
      var node = new SourceNode();
      var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
      var remainingLinesIndex = 0;
      var shiftNextLine = function() {
        var lineContents = getNextLine();
        var newLine = getNextLine() || "";
        return lineContents + newLine;
        function getNextLine() {
          return remainingLinesIndex < remainingLines.length ? remainingLines[remainingLinesIndex++] : void 0;
        }
      };
      var lastGeneratedLine = 1, lastGeneratedColumn = 0;
      var lastMapping = null;
      aSourceMapConsumer.eachMapping(function(mapping) {
        if (lastMapping !== null) {
          if (lastGeneratedLine < mapping.generatedLine) {
            addMappingWithCode(lastMapping, shiftNextLine());
            lastGeneratedLine++;
            lastGeneratedColumn = 0;
          } else {
            var nextLine = remainingLines[remainingLinesIndex] || "";
            var code = nextLine.substr(0, mapping.generatedColumn - lastGeneratedColumn);
            remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn - lastGeneratedColumn);
            lastGeneratedColumn = mapping.generatedColumn;
            addMappingWithCode(lastMapping, code);
            lastMapping = mapping;
            return;
          }
        }
        while (lastGeneratedLine < mapping.generatedLine) {
          node.add(shiftNextLine());
          lastGeneratedLine++;
        }
        if (lastGeneratedColumn < mapping.generatedColumn) {
          var nextLine = remainingLines[remainingLinesIndex] || "";
          node.add(nextLine.substr(0, mapping.generatedColumn));
          remainingLines[remainingLinesIndex] = nextLine.substr(mapping.generatedColumn);
          lastGeneratedColumn = mapping.generatedColumn;
        }
        lastMapping = mapping;
      }, this);
      if (remainingLinesIndex < remainingLines.length) {
        if (lastMapping) {
          addMappingWithCode(lastMapping, shiftNextLine());
        }
        node.add(remainingLines.splice(remainingLinesIndex).join(""));
      }
      aSourceMapConsumer.sources.forEach(function(sourceFile) {
        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
        if (content != null) {
          if (aRelativePath != null) {
            sourceFile = util.join(aRelativePath, sourceFile);
          }
          node.setSourceContent(sourceFile, content);
        }
      });
      return node;
      function addMappingWithCode(mapping, code) {
        if (mapping === null || mapping.source === void 0) {
          node.add(code);
        } else {
          var source = aRelativePath ? util.join(aRelativePath, mapping.source) : mapping.source;
          node.add(new SourceNode(
            mapping.originalLine,
            mapping.originalColumn,
            source,
            code,
            mapping.name
          ));
        }
      }
    };
    SourceNode.prototype.add = function SourceNode_add(aChunk) {
      if (Array.isArray(aChunk)) {
        aChunk.forEach(function(chunk) {
          this.add(chunk);
        }, this);
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        if (aChunk) {
          this.children.push(aChunk);
        }
      } else {
        throw new TypeError(
          "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
        );
      }
      return this;
    };
    SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
      if (Array.isArray(aChunk)) {
        for (var i = aChunk.length - 1; i >= 0; i--) {
          this.prepend(aChunk[i]);
        }
      } else if (aChunk[isSourceNode] || typeof aChunk === "string") {
        this.children.unshift(aChunk);
      } else {
        throw new TypeError(
          "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
        );
      }
      return this;
    };
    SourceNode.prototype.walk = function SourceNode_walk(aFn) {
      var chunk;
      for (var i = 0, len = this.children.length; i < len; i++) {
        chunk = this.children[i];
        if (chunk[isSourceNode]) {
          chunk.walk(aFn);
        } else {
          if (chunk !== "") {
            aFn(chunk, {
              source: this.source,
              line: this.line,
              column: this.column,
              name: this.name
            });
          }
        }
      }
    };
    SourceNode.prototype.join = function SourceNode_join(aSep) {
      var newChildren;
      var i;
      var len = this.children.length;
      if (len > 0) {
        newChildren = [];
        for (i = 0; i < len - 1; i++) {
          newChildren.push(this.children[i]);
          newChildren.push(aSep);
        }
        newChildren.push(this.children[i]);
        this.children = newChildren;
      }
      return this;
    };
    SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
      var lastChild = this.children[this.children.length - 1];
      if (lastChild[isSourceNode]) {
        lastChild.replaceRight(aPattern, aReplacement);
      } else if (typeof lastChild === "string") {
        this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
      } else {
        this.children.push("".replace(aPattern, aReplacement));
      }
      return this;
    };
    SourceNode.prototype.setSourceContent = function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
      this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
    };
    SourceNode.prototype.walkSourceContents = function SourceNode_walkSourceContents(aFn) {
      for (var i = 0, len = this.children.length; i < len; i++) {
        if (this.children[i][isSourceNode]) {
          this.children[i].walkSourceContents(aFn);
        }
      }
      var sources = Object.keys(this.sourceContents);
      for (var i = 0, len = sources.length; i < len; i++) {
        aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
      }
    };
    SourceNode.prototype.toString = function SourceNode_toString() {
      var str = "";
      this.walk(function(chunk) {
        str += chunk;
      });
      return str;
    };
    SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
      var generated = {
        code: "",
        line: 1,
        column: 0
      };
      var map = new SourceMapGenerator(aArgs);
      var sourceMappingActive = false;
      var lastOriginalSource = null;
      var lastOriginalLine = null;
      var lastOriginalColumn = null;
      var lastOriginalName = null;
      this.walk(function(chunk, original) {
        generated.code += chunk;
        if (original.source !== null && original.line !== null && original.column !== null) {
          if (lastOriginalSource !== original.source || lastOriginalLine !== original.line || lastOriginalColumn !== original.column || lastOriginalName !== original.name) {
            map.addMapping({
              source: original.source,
              original: {
                line: original.line,
                column: original.column
              },
              generated: {
                line: generated.line,
                column: generated.column
              },
              name: original.name
            });
          }
          lastOriginalSource = original.source;
          lastOriginalLine = original.line;
          lastOriginalColumn = original.column;
          lastOriginalName = original.name;
          sourceMappingActive = true;
        } else if (sourceMappingActive) {
          map.addMapping({
            generated: {
              line: generated.line,
              column: generated.column
            }
          });
          lastOriginalSource = null;
          sourceMappingActive = false;
        }
        for (var idx = 0, length = chunk.length; idx < length; idx++) {
          if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
            generated.line++;
            generated.column = 0;
            if (idx + 1 === length) {
              lastOriginalSource = null;
              sourceMappingActive = false;
            } else if (sourceMappingActive) {
              map.addMapping({
                source: original.source,
                original: {
                  line: original.line,
                  column: original.column
                },
                generated: {
                  line: generated.line,
                  column: generated.column
                },
                name: original.name
              });
            }
          } else {
            generated.column++;
          }
        }
      });
      this.walkSourceContents(function(sourceFile, sourceContent) {
        map.setSourceContent(sourceFile, sourceContent);
      });
      return { code: generated.code, map };
    };
    exports2.SourceNode = SourceNode;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/source-map.js
var require_source_map = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map/source-map.js"(exports2) {
    exports2.SourceMapGenerator = require_source_map_generator().SourceMapGenerator;
    exports2.SourceMapConsumer = require_source_map_consumer().SourceMapConsumer;
    exports2.SourceNode = require_source_node().SourceNode;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/buffer-from/index.js
var require_buffer_from = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/buffer-from/index.js"(exports2, module2) {
    var toString = Object.prototype.toString;
    var isModern = typeof Buffer.alloc === "function" && typeof Buffer.allocUnsafe === "function" && typeof Buffer.from === "function";
    function isArrayBuffer(input) {
      return toString.call(input).slice(8, -1) === "ArrayBuffer";
    }
    function fromArrayBuffer(obj, byteOffset, length) {
      byteOffset >>>= 0;
      var maxLength = obj.byteLength - byteOffset;
      if (maxLength < 0) {
        throw new RangeError("'offset' is out of bounds");
      }
      if (length === void 0) {
        length = maxLength;
      } else {
        length >>>= 0;
        if (length > maxLength) {
          throw new RangeError("'length' is out of bounds");
        }
      }
      return isModern ? Buffer.from(obj.slice(byteOffset, byteOffset + length)) : new Buffer(new Uint8Array(obj.slice(byteOffset, byteOffset + length)));
    }
    function fromString(string, encoding) {
      if (typeof encoding !== "string" || encoding === "") {
        encoding = "utf8";
      }
      if (!Buffer.isEncoding(encoding)) {
        throw new TypeError('"encoding" must be a valid string encoding');
      }
      return isModern ? Buffer.from(string, encoding) : new Buffer(string, encoding);
    }
    function bufferFrom(value, encodingOrOffset, length) {
      if (typeof value === "number") {
        throw new TypeError('"value" argument must not be a number');
      }
      if (isArrayBuffer(value)) {
        return fromArrayBuffer(value, encodingOrOffset, length);
      }
      if (typeof value === "string") {
        return fromString(value, encodingOrOffset);
      }
      return isModern ? Buffer.from(value) : new Buffer(value);
    }
    module2.exports = bufferFrom;
  }
});

// ../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map-support/source-map-support.js
var require_source_map_support = __commonJS({
  "../../../../../../../../../../../../../Users/atscott/github/vscode-ng-language-service/node_modules/source-map-support/source-map-support.js"(exports2, module2) {
    var SourceMapConsumer = require_source_map().SourceMapConsumer;
    var path = require("path");
    var fs;
    try {
      fs = require("fs");
      if (!fs.existsSync || !fs.readFileSync) {
        fs = null;
      }
    } catch (err) {
    }
    var bufferFrom = require_buffer_from();
    function dynamicRequire(mod, request) {
      return mod.require(request);
    }
    var errorFormatterInstalled = false;
    var uncaughtShimInstalled = false;
    var emptyCacheBetweenOperations = false;
    var environment = "auto";
    var fileContentsCache = {};
    var sourceMapCache = {};
    var reSourceMap = /^data:application\/json[^,]+base64,/;
    var retrieveFileHandlers = [];
    var retrieveMapHandlers = [];
    function isInBrowser() {
      if (environment === "browser")
        return true;
      if (environment === "node")
        return false;
      return typeof window !== "undefined" && typeof XMLHttpRequest === "function" && !(window.require && window.module && window.process && window.process.type === "renderer");
    }
    function hasGlobalProcessEventEmitter() {
      return typeof process === "object" && process !== null && typeof process.on === "function";
    }
    function globalProcessVersion() {
      if (typeof process === "object" && process !== null) {
        return process.version;
      } else {
        return "";
      }
    }
    function globalProcessStderr() {
      if (typeof process === "object" && process !== null) {
        return process.stderr;
      }
    }
    function globalProcessExit(code) {
      if (typeof process === "object" && process !== null && typeof process.exit === "function") {
        return process.exit(code);
      }
    }
    function handlerExec(list) {
      return function(arg) {
        for (var i = 0; i < list.length; i++) {
          var ret = list[i](arg);
          if (ret) {
            return ret;
          }
        }
        return null;
      };
    }
    var retrieveFile = handlerExec(retrieveFileHandlers);
    retrieveFileHandlers.push(function(path2) {
      path2 = path2.trim();
      if (/^file:/.test(path2)) {
        path2 = path2.replace(/file:\/\/\/(\w:)?/, function(protocol, drive) {
          return drive ? "" : "/";
        });
      }
      if (path2 in fileContentsCache) {
        return fileContentsCache[path2];
      }
      var contents = "";
      try {
        if (!fs) {
          var xhr = new XMLHttpRequest();
          xhr.open("GET", path2, false);
          xhr.send(null);
          if (xhr.readyState === 4 && xhr.status === 200) {
            contents = xhr.responseText;
          }
        } else if (fs.existsSync(path2)) {
          contents = fs.readFileSync(path2, "utf8");
        }
      } catch (er) {
      }
      return fileContentsCache[path2] = contents;
    });
    function supportRelativeURL(file, url) {
      if (!file)
        return url;
      var dir = path.dirname(file);
      var match = /^\w+:\/\/[^\/]*/.exec(dir);
      var protocol = match ? match[0] : "";
      var startPath = dir.slice(protocol.length);
      if (protocol && /^\/\w\:/.test(startPath)) {
        protocol += "/";
        return protocol + path.resolve(dir.slice(protocol.length), url).replace(/\\/g, "/");
      }
      return protocol + path.resolve(dir.slice(protocol.length), url);
    }
    function retrieveSourceMapURL(source) {
      var fileData;
      if (isInBrowser()) {
        try {
          var xhr = new XMLHttpRequest();
          xhr.open("GET", source, false);
          xhr.send(null);
          fileData = xhr.readyState === 4 ? xhr.responseText : null;
          var sourceMapHeader = xhr.getResponseHeader("SourceMap") || xhr.getResponseHeader("X-SourceMap");
          if (sourceMapHeader) {
            return sourceMapHeader;
          }
        } catch (e) {
        }
      }
      fileData = retrieveFile(source);
      var re = /(?:\/\/[@#][\s]*sourceMappingURL=([^\s'"]+)[\s]*$)|(?:\/\*[@#][\s]*sourceMappingURL=([^\s*'"]+)[\s]*(?:\*\/)[\s]*$)/mg;
      var lastMatch, match;
      while (match = re.exec(fileData))
        lastMatch = match;
      if (!lastMatch)
        return null;
      return lastMatch[1];
    }
    var retrieveSourceMap = handlerExec(retrieveMapHandlers);
    retrieveMapHandlers.push(function(source) {
      var sourceMappingURL = retrieveSourceMapURL(source);
      if (!sourceMappingURL)
        return null;
      var sourceMapData;
      if (reSourceMap.test(sourceMappingURL)) {
        var rawData = sourceMappingURL.slice(sourceMappingURL.indexOf(",") + 1);
        sourceMapData = bufferFrom(rawData, "base64").toString();
        sourceMappingURL = source;
      } else {
        sourceMappingURL = supportRelativeURL(source, sourceMappingURL);
        sourceMapData = retrieveFile(sourceMappingURL);
      }
      if (!sourceMapData) {
        return null;
      }
      return {
        url: sourceMappingURL,
        map: sourceMapData
      };
    });
    function mapSourcePosition(position) {
      var sourceMap = sourceMapCache[position.source];
      if (!sourceMap) {
        var urlAndMap = retrieveSourceMap(position.source);
        if (urlAndMap) {
          sourceMap = sourceMapCache[position.source] = {
            url: urlAndMap.url,
            map: new SourceMapConsumer(urlAndMap.map)
          };
          if (sourceMap.map.sourcesContent) {
            sourceMap.map.sources.forEach(function(source, i) {
              var contents = sourceMap.map.sourcesContent[i];
              if (contents) {
                var url = supportRelativeURL(sourceMap.url, source);
                fileContentsCache[url] = contents;
              }
            });
          }
        } else {
          sourceMap = sourceMapCache[position.source] = {
            url: null,
            map: null
          };
        }
      }
      if (sourceMap && sourceMap.map && typeof sourceMap.map.originalPositionFor === "function") {
        var originalPosition = sourceMap.map.originalPositionFor(position);
        if (originalPosition.source !== null) {
          originalPosition.source = supportRelativeURL(
            sourceMap.url,
            originalPosition.source
          );
          return originalPosition;
        }
      }
      return position;
    }
    function mapEvalOrigin(origin) {
      var match = /^eval at ([^(]+) \((.+):(\d+):(\d+)\)$/.exec(origin);
      if (match) {
        var position = mapSourcePosition({
          source: match[2],
          line: +match[3],
          column: match[4] - 1
        });
        return "eval at " + match[1] + " (" + position.source + ":" + position.line + ":" + (position.column + 1) + ")";
      }
      match = /^eval at ([^(]+) \((.+)\)$/.exec(origin);
      if (match) {
        return "eval at " + match[1] + " (" + mapEvalOrigin(match[2]) + ")";
      }
      return origin;
    }
    function CallSiteToString() {
      var fileName;
      var fileLocation = "";
      if (this.isNative()) {
        fileLocation = "native";
      } else {
        fileName = this.getScriptNameOrSourceURL();
        if (!fileName && this.isEval()) {
          fileLocation = this.getEvalOrigin();
          fileLocation += ", ";
        }
        if (fileName) {
          fileLocation += fileName;
        } else {
          fileLocation += "<anonymous>";
        }
        var lineNumber = this.getLineNumber();
        if (lineNumber != null) {
          fileLocation += ":" + lineNumber;
          var columnNumber = this.getColumnNumber();
          if (columnNumber) {
            fileLocation += ":" + columnNumber;
          }
        }
      }
      var line = "";
      var functionName = this.getFunctionName();
      var addSuffix = true;
      var isConstructor = this.isConstructor();
      var isMethodCall = !(this.isToplevel() || isConstructor);
      if (isMethodCall) {
        var typeName = this.getTypeName();
        if (typeName === "[object Object]") {
          typeName = "null";
        }
        var methodName = this.getMethodName();
        if (functionName) {
          if (typeName && functionName.indexOf(typeName) != 0) {
            line += typeName + ".";
          }
          line += functionName;
          if (methodName && functionName.indexOf("." + methodName) != functionName.length - methodName.length - 1) {
            line += " [as " + methodName + "]";
          }
        } else {
          line += typeName + "." + (methodName || "<anonymous>");
        }
      } else if (isConstructor) {
        line += "new " + (functionName || "<anonymous>");
      } else if (functionName) {
        line += functionName;
      } else {
        line += fileLocation;
        addSuffix = false;
      }
      if (addSuffix) {
        line += " (" + fileLocation + ")";
      }
      return line;
    }
    function cloneCallSite(frame) {
      var object = {};
      Object.getOwnPropertyNames(Object.getPrototypeOf(frame)).forEach(function(name) {
        object[name] = /^(?:is|get)/.test(name) ? function() {
          return frame[name].call(frame);
        } : frame[name];
      });
      object.toString = CallSiteToString;
      return object;
    }
    function wrapCallSite(frame, state) {
      if (state === void 0) {
        state = { nextPosition: null, curPosition: null };
      }
      if (frame.isNative()) {
        state.curPosition = null;
        return frame;
      }
      var source = frame.getFileName() || frame.getScriptNameOrSourceURL();
      if (source) {
        var line = frame.getLineNumber();
        var column = frame.getColumnNumber() - 1;
        var noHeader = /^v(10\.1[6-9]|10\.[2-9][0-9]|10\.[0-9]{3,}|1[2-9]\d*|[2-9]\d|\d{3,}|11\.11)/;
        var headerLength = noHeader.test(globalProcessVersion()) ? 0 : 62;
        if (line === 1 && column > headerLength && !isInBrowser() && !frame.isEval()) {
          column -= headerLength;
        }
        var position = mapSourcePosition({
          source,
          line,
          column
        });
        state.curPosition = position;
        frame = cloneCallSite(frame);
        var originalFunctionName = frame.getFunctionName;
        frame.getFunctionName = function() {
          if (state.nextPosition == null) {
            return originalFunctionName();
          }
          return state.nextPosition.name || originalFunctionName();
        };
        frame.getFileName = function() {
          return position.source;
        };
        frame.getLineNumber = function() {
          return position.line;
        };
        frame.getColumnNumber = function() {
          return position.column + 1;
        };
        frame.getScriptNameOrSourceURL = function() {
          return position.source;
        };
        return frame;
      }
      var origin = frame.isEval() && frame.getEvalOrigin();
      if (origin) {
        origin = mapEvalOrigin(origin);
        frame = cloneCallSite(frame);
        frame.getEvalOrigin = function() {
          return origin;
        };
        return frame;
      }
      return frame;
    }
    function prepareStackTrace(error, stack) {
      if (emptyCacheBetweenOperations) {
        fileContentsCache = {};
        sourceMapCache = {};
      }
      var name = error.name || "Error";
      var message = error.message || "";
      var errorString = name + ": " + message;
      var state = { nextPosition: null, curPosition: null };
      var processedStack = [];
      for (var i = stack.length - 1; i >= 0; i--) {
        processedStack.push("\n    at " + wrapCallSite(stack[i], state));
        state.nextPosition = state.curPosition;
      }
      state.curPosition = state.nextPosition = null;
      return errorString + processedStack.reverse().join("");
    }
    function getErrorSource(error) {
      var match = /\n    at [^(]+ \((.*):(\d+):(\d+)\)/.exec(error.stack);
      if (match) {
        var source = match[1];
        var line = +match[2];
        var column = +match[3];
        var contents = fileContentsCache[source];
        if (!contents && fs && fs.existsSync(source)) {
          try {
            contents = fs.readFileSync(source, "utf8");
          } catch (er) {
            contents = "";
          }
        }
        if (contents) {
          var code = contents.split(/(?:\r\n|\r|\n)/)[line - 1];
          if (code) {
            return source + ":" + line + "\n" + code + "\n" + new Array(column).join(" ") + "^";
          }
        }
      }
      return null;
    }
    function printErrorAndExit(error) {
      var source = getErrorSource(error);
      var stderr = globalProcessStderr();
      if (stderr && stderr._handle && stderr._handle.setBlocking) {
        stderr._handle.setBlocking(true);
      }
      if (source) {
        console.error();
        console.error(source);
      }
      console.error(error.stack);
      globalProcessExit(1);
    }
    function shimEmitUncaughtException() {
      var origEmit = process.emit;
      process.emit = function(type) {
        if (type === "uncaughtException") {
          var hasStack = arguments[1] && arguments[1].stack;
          var hasListeners = this.listeners(type).length > 0;
          if (hasStack && !hasListeners) {
            return printErrorAndExit(arguments[1]);
          }
        }
        return origEmit.apply(this, arguments);
      };
    }
    var originalRetrieveFileHandlers = retrieveFileHandlers.slice(0);
    var originalRetrieveMapHandlers = retrieveMapHandlers.slice(0);
    exports2.wrapCallSite = wrapCallSite;
    exports2.getErrorSource = getErrorSource;
    exports2.mapSourcePosition = mapSourcePosition;
    exports2.retrieveSourceMap = retrieveSourceMap;
    exports2.install = function(options) {
      options = options || {};
      if (options.environment) {
        environment = options.environment;
        if (["node", "browser", "auto"].indexOf(environment) === -1) {
          throw new Error("environment " + environment + " was unknown. Available options are {auto, browser, node}");
        }
      }
      if (options.retrieveFile) {
        if (options.overrideRetrieveFile) {
          retrieveFileHandlers.length = 0;
        }
        retrieveFileHandlers.unshift(options.retrieveFile);
      }
      if (options.retrieveSourceMap) {
        if (options.overrideRetrieveSourceMap) {
          retrieveMapHandlers.length = 0;
        }
        retrieveMapHandlers.unshift(options.retrieveSourceMap);
      }
      if (options.hookRequire && !isInBrowser()) {
        var Module = dynamicRequire(module2, "module");
        var $compile = Module.prototype._compile;
        if (!$compile.__sourceMapSupport) {
          Module.prototype._compile = function(content, filename) {
            fileContentsCache[filename] = content;
            sourceMapCache[filename] = void 0;
            return $compile.call(this, content, filename);
          };
          Module.prototype._compile.__sourceMapSupport = true;
        }
      }
      if (!emptyCacheBetweenOperations) {
        emptyCacheBetweenOperations = "emptyCacheBetweenOperations" in options ? options.emptyCacheBetweenOperations : false;
      }
      if (!errorFormatterInstalled) {
        errorFormatterInstalled = true;
        Error.prepareStackTrace = prepareStackTrace;
      }
      if (!uncaughtShimInstalled) {
        var installHandler = "handleUncaughtExceptions" in options ? options.handleUncaughtExceptions : true;
        try {
          var worker_threads = dynamicRequire(module2, "worker_threads");
          if (worker_threads.isMainThread === false) {
            installHandler = false;
          }
        } catch (e) {
        }
        if (installHandler && hasGlobalProcessEventEmitter()) {
          uncaughtShimInstalled = true;
          shimEmitUncaughtException();
        }
      }
    };
    exports2.resetRetrieveHandlers = function() {
      retrieveFileHandlers.length = 0;
      retrieveMapHandlers.length = 0;
      retrieveFileHandlers = originalRetrieveFileHandlers.slice(0);
      retrieveMapHandlers = originalRetrieveMapHandlers.slice(0);
      retrieveSourceMap = handlerExec(retrieveMapHandlers);
      retrieveFile = handlerExec(retrieveFileHandlers);
    };
  }
});

// ../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/typescript@registry.npmjs.org+typescript+4.8.2/node_modules/typescript/lib/typescript.js
var require_typescript = __commonJS({
  "../../../../../../../../execroot/__main__/bazel-out/darwin-fastbuild/bin/node_modules/.aspect_rules_js/typescript@registry.npmjs.org+typescript+4.8.2/node_modules/typescript/lib/typescript.js"(exports2, module2) {
    "use strict";
    var __spreadArray = exports2 && exports2.__spreadArray || function(to, from, pack) {
      if (pack || arguments.length === 2)
        for (var i = 0, l = from.length, ar; i < l; i++) {
          if (ar || !(i in from)) {
            if (!ar)
              ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
          }
        }
      return to.concat(ar || Array.prototype.slice.call(from));
    };
    var __assign = exports2 && exports2.__assign || function() {
      __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
          s = arguments[i];
          for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p))
              t[p] = s[p];
        }
        return t;
      };
      return __assign.apply(this, arguments);
    };
    var __makeTemplateObject = exports2 && exports2.__makeTemplateObject || function(cooked, raw) {
      if (Object.defineProperty) {
        Object.defineProperty(cooked, "raw", { value: raw });
      } else {
        cooked.raw = raw;
      }
      return cooked;
    };
    var __generator = exports2 && exports2.__generator || function(thisArg, body) {
      var _ = { label: 0, sent: function() {
        if (t[0] & 1)
          throw t[1];
        return t[1];
      }, trys: [], ops: [] }, f, y, t, g;
      return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() {
        return this;
      }), g;
      function verb(n) {
        return function(v) {
          return step([n, v]);
        };
      }
      function step(op) {
        if (f)
          throw new TypeError("Generator is already executing.");
        while (_)
          try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
              return t;
            if (y = 0, t)
              op = [op[0] & 2, t.value];
            switch (op[0]) {
              case 0:
              case 1:
                t = op;
                break;
              case 4:
                _.label++;
                return { value: op[1], done: false };
              case 5:
                _.label++;
                y = op[1];
                op = [0];
                continue;
              case 7:
                op = _.ops.pop();
                _.trys.pop();
                continue;
              default:
                if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                  _ = 0;
                  continue;
                }
                if (op[0] === 3 && (!t || op[1] > t[0] && op[1] < t[3])) {
                  _.label = op[1];
                  break;
                }
                if (op[0] === 6 && _.label < t[1]) {
                  _.label = t[1];
                  t = op;
                  break;
                }
                if (t && _.label < t[2]) {
                  _.label = t[2];
                  _.ops.push(op);
                  break;
                }
                if (t[2])
                  _.ops.pop();
                _.trys.pop();
                continue;
            }
            op = body.call(thisArg, _);
          } catch (e) {
            op = [6, e];
            y = 0;
          } finally {
            f = t = 0;
          }
        if (op[0] & 5)
          throw op[1];
        return { value: op[0] ? op[1] : void 0, done: true };
      }
    };
    var __rest = exports2 && exports2.__rest || function(s, e) {
      var t = {};
      for (var p in s)
        if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
          t[p] = s[p];
      if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
          if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
            t[p[i]] = s[p[i]];
        }
      return t;
    };
    var __extends = exports2 && exports2.__extends || function() {
      var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf || { __proto__: [] } instanceof Array && function(d2, b2) {
          d2.__proto__ = b2;
        } || function(d2, b2) {
          for (var p in b2)
            if (Object.prototype.hasOwnProperty.call(b2, p))
              d2[p] = b2[p];
        };
        return extendStatics(d, b);
      };
      return function(d, b) {
        if (typeof b !== "function" && b !== null)
          throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() {
          this.constructor = d;
        }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
      };
    }();
    var ts;
    (function(ts2) {
      function createMapData() {
        var sentinel = {};
        sentinel.prev = sentinel;
        return { head: sentinel, tail: sentinel, size: 0 };
      }
      function createMapEntry(key, value) {
        return { key, value, next: void 0, prev: void 0 };
      }
      function sameValueZero(x, y) {
        return x === y || x !== x && y !== y;
      }
      function getPrev(entry) {
        var prev = entry.prev;
        if (!prev || prev === entry)
          throw new Error("Illegal state");
        return prev;
      }
      function getNext(entry) {
        while (entry) {
          var skipNext = !entry.prev;
          entry = entry.next;
          if (skipNext) {
            continue;
          }
          return entry;
        }
      }
      function getEntry(data, key) {
        for (var entry = data.tail; entry !== data.head; entry = getPrev(entry)) {
          if (sameValueZero(entry.key, key)) {
            return entry;
          }
        }
      }
      function addOrUpdateEntry(data, key, value) {
        var existing = getEntry(data, key);
        if (existing) {
          existing.value = value;
          return;
        }
        var entry = createMapEntry(key, value);
        entry.prev = data.tail;
        data.tail.next = entry;
        data.tail = entry;
        data.size++;
        return entry;
      }
      function deleteEntry(data, key) {
        for (var entry = data.tail; entry !== data.head; entry = getPrev(entry)) {
          if (entry.prev === void 0)
            throw new Error("Illegal state");
          if (sameValueZero(entry.key, key)) {
            if (entry.next) {
              entry.next.prev = entry.prev;
            } else {
              if (data.tail !== entry)
                throw new Error("Illegal state");
              data.tail = entry.prev;
            }
            entry.prev.next = entry.next;
            entry.next = entry.prev;
            entry.prev = void 0;
            data.size--;
            return entry;
          }
        }
      }
      function clearEntries(data) {
        var node = data.tail;
        while (node !== data.head) {
          var prev = getPrev(node);
          node.next = data.head;
          node.prev = void 0;
          node = prev;
        }
        data.head.next = void 0;
        data.tail = data.head;
        data.size = 0;
      }
      function forEachEntry(data, action) {
        var entry = data.head;
        while (entry) {
          entry = getNext(entry);
          if (entry) {
            action(entry.value, entry.key);
          }
        }
      }
      function forEachIteration(iterator, action) {
        if (iterator) {
          for (var step = iterator.next(); !step.done; step = iterator.next()) {
            action(step.value);
          }
        }
      }
      function createIteratorData(data, selector) {
        return { current: data.head, selector };
      }
      function iteratorNext(data) {
        data.current = getNext(data.current);
        if (data.current) {
          return { value: data.selector(data.current.key, data.current.value), done: false };
        } else {
          return { value: void 0, done: true };
        }
      }
      var ShimCollections;
      (function(ShimCollections2) {
        function createMapShim(getIterator) {
          var MapIterator = function() {
            function MapIterator2(data, selector) {
              this._data = createIteratorData(data, selector);
            }
            MapIterator2.prototype.next = function() {
              return iteratorNext(this._data);
            };
            return MapIterator2;
          }();
          return function() {
            function Map2(iterable) {
              var _this = this;
              this._mapData = createMapData();
              forEachIteration(getIterator(iterable), function(_a) {
                var key = _a[0], value = _a[1];
                return _this.set(key, value);
              });
            }
            Object.defineProperty(Map2.prototype, "size", {
              get: function() {
                return this._mapData.size;
              },
              enumerable: false,
              configurable: true
            });
            Map2.prototype.get = function(key) {
              var _a;
              return (_a = getEntry(this._mapData, key)) === null || _a === void 0 ? void 0 : _a.value;
            };
            Map2.prototype.set = function(key, value) {
              return addOrUpdateEntry(this._mapData, key, value), this;
            };
            Map2.prototype.has = function(key) {
              return !!getEntry(this._mapData, key);
            };
            Map2.prototype.delete = function(key) {
              return !!deleteEntry(this._mapData, key);
            };
            Map2.prototype.clear = function() {
              clearEntries(this._mapData);
            };
            Map2.prototype.keys = function() {
              return new MapIterator(this._mapData, function(key, _value) {
                return key;
              });
            };
            Map2.prototype.values = function() {
              return new MapIterator(this._mapData, function(_key, value) {
                return value;
              });
            };
            Map2.prototype.entries = function() {
              return new MapIterator(this._mapData, function(key, value) {
                return [key, value];
              });
            };
            Map2.prototype.forEach = function(action) {
              forEachEntry(this._mapData, action);
            };
            return Map2;
          }();
        }
        ShimCollections2.createMapShim = createMapShim;
        function createSetShim(getIterator) {
          var SetIterator = function() {
            function SetIterator2(data, selector) {
              this._data = createIteratorData(data, selector);
            }
            SetIterator2.prototype.next = function() {
              return iteratorNext(this._data);
            };
            return SetIterator2;
          }();
          return function() {
            function Set2(iterable) {
              var _this = this;
              this._mapData = createMapData();
              forEachIteration(getIterator(iterable), function(value) {
                return _this.add(value);
              });
            }
            Object.defineProperty(Set2.prototype, "size", {
              get: function() {
                return this._mapData.size;
              },
              enumerable: false,
              configurable: true
            });
            Set2.prototype.add = function(value) {
              return addOrUpdateEntry(this._mapData, value, value), this;
            };
            Set2.prototype.has = function(value) {
              return !!getEntry(this._mapData, value);
            };
            Set2.prototype.delete = function(value) {
              return !!deleteEntry(this._mapData, value);
            };
            Set2.prototype.clear = function() {
              clearEntries(this._mapData);
            };
            Set2.prototype.keys = function() {
              return new SetIterator(this._mapData, function(key, _value) {
                return key;
              });
            };
            Set2.prototype.values = function() {
              return new SetIterator(this._mapData, function(_key, value) {
                return value;
              });
            };
            Set2.prototype.entries = function() {
              return new SetIterator(this._mapData, function(key, value) {
                return [key, value];
              });
            };
            Set2.prototype.forEach = function(action) {
              forEachEntry(this._mapData, action);
            };
            return Set2;
          }();
        }
        ShimCollections2.createSetShim = createSetShim;
      })(ShimCollections = ts2.ShimCollections || (ts2.ShimCollections = {}));
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      ts2.versionMajorMinor = "4.8";
      ts2.version = "4.8.2";
      var Comparison;
      (function(Comparison2) {
        Comparison2[Comparison2["LessThan"] = -1] = "LessThan";
        Comparison2[Comparison2["EqualTo"] = 0] = "EqualTo";
        Comparison2[Comparison2["GreaterThan"] = 1] = "GreaterThan";
      })(Comparison = ts2.Comparison || (ts2.Comparison = {}));
      var NativeCollections;
      (function(NativeCollections2) {
        var globals = typeof globalThis !== "undefined" ? globalThis : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : void 0;
        function tryGetNativeMap() {
          var gMap = globals === null || globals === void 0 ? void 0 : globals.Map;
          return typeof gMap !== "undefined" && "entries" in gMap.prototype && new gMap([[0, 0]]).size === 1 ? gMap : void 0;
        }
        NativeCollections2.tryGetNativeMap = tryGetNativeMap;
        function tryGetNativeSet() {
          var gSet = globals === null || globals === void 0 ? void 0 : globals.Set;
          return typeof gSet !== "undefined" && "entries" in gSet.prototype && new gSet([0]).size === 1 ? gSet : void 0;
        }
        NativeCollections2.tryGetNativeSet = tryGetNativeSet;
      })(NativeCollections || (NativeCollections = {}));
      ts2.Map = getCollectionImplementation("Map", "tryGetNativeMap", "createMapShim");
      ts2.Set = getCollectionImplementation("Set", "tryGetNativeSet", "createSetShim");
      function getCollectionImplementation(name, nativeFactory, shimFactory) {
        var _a;
        var constructor = (_a = NativeCollections[nativeFactory]()) !== null && _a !== void 0 ? _a : ts2.ShimCollections === null || ts2.ShimCollections === void 0 ? void 0 : ts2.ShimCollections[shimFactory](ts2.getIterator);
        if (constructor)
          return constructor;
        throw new Error("TypeScript requires an environment that provides a compatible native ".concat(name, " implementation."));
      }
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      function getIterator(iterable) {
        if (iterable) {
          if (isArray(iterable))
            return arrayIterator(iterable);
          if (iterable instanceof ts2.Map)
            return iterable.entries();
          if (iterable instanceof ts2.Set)
            return iterable.values();
          throw new Error("Iteration not supported.");
        }
      }
      ts2.getIterator = getIterator;
      ts2.emptyArray = [];
      ts2.emptyMap = new ts2.Map();
      ts2.emptySet = new ts2.Set();
      function length(array) {
        return array ? array.length : 0;
      }
      ts2.length = length;
      function forEach(array, callback) {
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var result = callback(array[i], i);
            if (result) {
              return result;
            }
          }
        }
        return void 0;
      }
      ts2.forEach = forEach;
      function forEachRight(array, callback) {
        if (array) {
          for (var i = array.length - 1; i >= 0; i--) {
            var result = callback(array[i], i);
            if (result) {
              return result;
            }
          }
        }
        return void 0;
      }
      ts2.forEachRight = forEachRight;
      function firstDefined(array, callback) {
        if (array === void 0) {
          return void 0;
        }
        for (var i = 0; i < array.length; i++) {
          var result = callback(array[i], i);
          if (result !== void 0) {
            return result;
          }
        }
        return void 0;
      }
      ts2.firstDefined = firstDefined;
      function firstDefinedIterator(iter, callback) {
        while (true) {
          var iterResult = iter.next();
          if (iterResult.done) {
            return void 0;
          }
          var result = callback(iterResult.value);
          if (result !== void 0) {
            return result;
          }
        }
      }
      ts2.firstDefinedIterator = firstDefinedIterator;
      function reduceLeftIterator(iterator, f, initial) {
        var result = initial;
        if (iterator) {
          for (var step = iterator.next(), pos = 0; !step.done; step = iterator.next(), pos++) {
            result = f(result, step.value, pos);
          }
        }
        return result;
      }
      ts2.reduceLeftIterator = reduceLeftIterator;
      function zipWith(arrayA, arrayB, callback) {
        var result = [];
        ts2.Debug.assertEqual(arrayA.length, arrayB.length);
        for (var i = 0; i < arrayA.length; i++) {
          result.push(callback(arrayA[i], arrayB[i], i));
        }
        return result;
      }
      ts2.zipWith = zipWith;
      function zipToIterator(arrayA, arrayB) {
        ts2.Debug.assertEqual(arrayA.length, arrayB.length);
        var i = 0;
        return {
          next: function() {
            if (i === arrayA.length) {
              return { value: void 0, done: true };
            }
            i++;
            return { value: [arrayA[i - 1], arrayB[i - 1]], done: false };
          }
        };
      }
      ts2.zipToIterator = zipToIterator;
      function zipToMap(keys, values) {
        ts2.Debug.assert(keys.length === values.length);
        var map2 = new ts2.Map();
        for (var i = 0; i < keys.length; ++i) {
          map2.set(keys[i], values[i]);
        }
        return map2;
      }
      ts2.zipToMap = zipToMap;
      function intersperse(input, element) {
        if (input.length <= 1) {
          return input;
        }
        var result = [];
        for (var i = 0, n = input.length; i < n; i++) {
          if (i)
            result.push(element);
          result.push(input[i]);
        }
        return result;
      }
      ts2.intersperse = intersperse;
      function every(array, callback) {
        if (array) {
          for (var i = 0; i < array.length; i++) {
            if (!callback(array[i], i)) {
              return false;
            }
          }
        }
        return true;
      }
      ts2.every = every;
      function find(array, predicate, startIndex) {
        if (array === void 0)
          return void 0;
        for (var i = startIndex !== null && startIndex !== void 0 ? startIndex : 0; i < array.length; i++) {
          var value = array[i];
          if (predicate(value, i)) {
            return value;
          }
        }
        return void 0;
      }
      ts2.find = find;
      function findLast(array, predicate, startIndex) {
        if (array === void 0)
          return void 0;
        for (var i = startIndex !== null && startIndex !== void 0 ? startIndex : array.length - 1; i >= 0; i--) {
          var value = array[i];
          if (predicate(value, i)) {
            return value;
          }
        }
        return void 0;
      }
      ts2.findLast = findLast;
      function findIndex(array, predicate, startIndex) {
        if (array === void 0)
          return -1;
        for (var i = startIndex !== null && startIndex !== void 0 ? startIndex : 0; i < array.length; i++) {
          if (predicate(array[i], i)) {
            return i;
          }
        }
        return -1;
      }
      ts2.findIndex = findIndex;
      function findLastIndex(array, predicate, startIndex) {
        if (array === void 0)
          return -1;
        for (var i = startIndex !== null && startIndex !== void 0 ? startIndex : array.length - 1; i >= 0; i--) {
          if (predicate(array[i], i)) {
            return i;
          }
        }
        return -1;
      }
      ts2.findLastIndex = findLastIndex;
      function findMap(array, callback) {
        for (var i = 0; i < array.length; i++) {
          var result = callback(array[i], i);
          if (result) {
            return result;
          }
        }
        return ts2.Debug.fail();
      }
      ts2.findMap = findMap;
      function contains(array, value, equalityComparer) {
        if (equalityComparer === void 0) {
          equalityComparer = equateValues;
        }
        if (array) {
          for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
            var v = array_1[_i];
            if (equalityComparer(v, value)) {
              return true;
            }
          }
        }
        return false;
      }
      ts2.contains = contains;
      function arraysEqual(a, b, equalityComparer) {
        if (equalityComparer === void 0) {
          equalityComparer = equateValues;
        }
        return a.length === b.length && a.every(function(x, i) {
          return equalityComparer(x, b[i]);
        });
      }
      ts2.arraysEqual = arraysEqual;
      function indexOfAnyCharCode(text, charCodes, start) {
        for (var i = start || 0; i < text.length; i++) {
          if (contains(charCodes, text.charCodeAt(i))) {
            return i;
          }
        }
        return -1;
      }
      ts2.indexOfAnyCharCode = indexOfAnyCharCode;
      function countWhere(array, predicate) {
        var count = 0;
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var v = array[i];
            if (predicate(v, i)) {
              count++;
            }
          }
        }
        return count;
      }
      ts2.countWhere = countWhere;
      function filter(array, f) {
        if (array) {
          var len = array.length;
          var i = 0;
          while (i < len && f(array[i]))
            i++;
          if (i < len) {
            var result = array.slice(0, i);
            i++;
            while (i < len) {
              var item = array[i];
              if (f(item)) {
                result.push(item);
              }
              i++;
            }
            return result;
          }
        }
        return array;
      }
      ts2.filter = filter;
      function filterMutate(array, f) {
        var outIndex = 0;
        for (var i = 0; i < array.length; i++) {
          if (f(array[i], i, array)) {
            array[outIndex] = array[i];
            outIndex++;
          }
        }
        array.length = outIndex;
      }
      ts2.filterMutate = filterMutate;
      function clear(array) {
        array.length = 0;
      }
      ts2.clear = clear;
      function map(array, f) {
        var result;
        if (array) {
          result = [];
          for (var i = 0; i < array.length; i++) {
            result.push(f(array[i], i));
          }
        }
        return result;
      }
      ts2.map = map;
      function mapIterator(iter, mapFn) {
        return {
          next: function() {
            var iterRes = iter.next();
            return iterRes.done ? iterRes : { value: mapFn(iterRes.value), done: false };
          }
        };
      }
      ts2.mapIterator = mapIterator;
      function sameMap(array, f) {
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var item = array[i];
            var mapped = f(item, i);
            if (item !== mapped) {
              var result = array.slice(0, i);
              result.push(mapped);
              for (i++; i < array.length; i++) {
                result.push(f(array[i], i));
              }
              return result;
            }
          }
        }
        return array;
      }
      ts2.sameMap = sameMap;
      function flatten(array) {
        var result = [];
        for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
          var v = array_2[_i];
          if (v) {
            if (isArray(v)) {
              addRange(result, v);
            } else {
              result.push(v);
            }
          }
        }
        return result;
      }
      ts2.flatten = flatten;
      function flatMap(array, mapfn) {
        var result;
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var v = mapfn(array[i], i);
            if (v) {
              if (isArray(v)) {
                result = addRange(result, v);
              } else {
                result = append(result, v);
              }
            }
          }
        }
        return result || ts2.emptyArray;
      }
      ts2.flatMap = flatMap;
      function flatMapToMutable(array, mapfn) {
        var result = [];
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var v = mapfn(array[i], i);
            if (v) {
              if (isArray(v)) {
                addRange(result, v);
              } else {
                result.push(v);
              }
            }
          }
        }
        return result;
      }
      ts2.flatMapToMutable = flatMapToMutable;
      function flatMapIterator(iter, mapfn) {
        var first2 = iter.next();
        if (first2.done) {
          return ts2.emptyIterator;
        }
        var currentIter = getIterator2(first2.value);
        return {
          next: function() {
            while (true) {
              var currentRes = currentIter.next();
              if (!currentRes.done) {
                return currentRes;
              }
              var iterRes = iter.next();
              if (iterRes.done) {
                return iterRes;
              }
              currentIter = getIterator2(iterRes.value);
            }
          }
        };
        function getIterator2(x) {
          var res = mapfn(x);
          return res === void 0 ? ts2.emptyIterator : isArray(res) ? arrayIterator(res) : res;
        }
      }
      ts2.flatMapIterator = flatMapIterator;
      function sameFlatMap(array, mapfn) {
        var result;
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var item = array[i];
            var mapped = mapfn(item, i);
            if (result || item !== mapped || isArray(mapped)) {
              if (!result) {
                result = array.slice(0, i);
              }
              if (isArray(mapped)) {
                addRange(result, mapped);
              } else {
                result.push(mapped);
              }
            }
          }
        }
        return result || array;
      }
      ts2.sameFlatMap = sameFlatMap;
      function mapAllOrFail(array, mapFn) {
        var result = [];
        for (var i = 0; i < array.length; i++) {
          var mapped = mapFn(array[i], i);
          if (mapped === void 0) {
            return void 0;
          }
          result.push(mapped);
        }
        return result;
      }
      ts2.mapAllOrFail = mapAllOrFail;
      function mapDefined(array, mapFn) {
        var result = [];
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var mapped = mapFn(array[i], i);
            if (mapped !== void 0) {
              result.push(mapped);
            }
          }
        }
        return result;
      }
      ts2.mapDefined = mapDefined;
      function mapDefinedIterator(iter, mapFn) {
        return {
          next: function() {
            while (true) {
              var res = iter.next();
              if (res.done) {
                return res;
              }
              var value = mapFn(res.value);
              if (value !== void 0) {
                return { value, done: false };
              }
            }
          }
        };
      }
      ts2.mapDefinedIterator = mapDefinedIterator;
      function mapDefinedEntries(map2, f) {
        if (!map2) {
          return void 0;
        }
        var result = new ts2.Map();
        map2.forEach(function(value, key) {
          var entry = f(key, value);
          if (entry !== void 0) {
            var newKey = entry[0], newValue = entry[1];
            if (newKey !== void 0 && newValue !== void 0) {
              result.set(newKey, newValue);
            }
          }
        });
        return result;
      }
      ts2.mapDefinedEntries = mapDefinedEntries;
      function mapDefinedValues(set, f) {
        if (set) {
          var result_1 = new ts2.Set();
          set.forEach(function(value) {
            var newValue = f(value);
            if (newValue !== void 0) {
              result_1.add(newValue);
            }
          });
          return result_1;
        }
      }
      ts2.mapDefinedValues = mapDefinedValues;
      function getOrUpdate(map2, key, callback) {
        if (map2.has(key)) {
          return map2.get(key);
        }
        var value = callback();
        map2.set(key, value);
        return value;
      }
      ts2.getOrUpdate = getOrUpdate;
      function tryAddToSet(set, value) {
        if (!set.has(value)) {
          set.add(value);
          return true;
        }
        return false;
      }
      ts2.tryAddToSet = tryAddToSet;
      ts2.emptyIterator = { next: function() {
        return { value: void 0, done: true };
      } };
      function singleIterator(value) {
        var done = false;
        return {
          next: function() {
            var wasDone = done;
            done = true;
            return wasDone ? { value: void 0, done: true } : { value, done: false };
          }
        };
      }
      ts2.singleIterator = singleIterator;
      function spanMap(array, keyfn, mapfn) {
        var result;
        if (array) {
          result = [];
          var len = array.length;
          var previousKey = void 0;
          var key = void 0;
          var start = 0;
          var pos = 0;
          while (start < len) {
            while (pos < len) {
              var value = array[pos];
              key = keyfn(value, pos);
              if (pos === 0) {
                previousKey = key;
              } else if (key !== previousKey) {
                break;
              }
              pos++;
            }
            if (start < pos) {
              var v = mapfn(array.slice(start, pos), previousKey, start, pos);
              if (v) {
                result.push(v);
              }
              start = pos;
            }
            previousKey = key;
            pos++;
          }
        }
        return result;
      }
      ts2.spanMap = spanMap;
      function mapEntries(map2, f) {
        if (!map2) {
          return void 0;
        }
        var result = new ts2.Map();
        map2.forEach(function(value, key) {
          var _a = f(key, value), newKey = _a[0], newValue = _a[1];
          result.set(newKey, newValue);
        });
        return result;
      }
      ts2.mapEntries = mapEntries;
      function some(array, predicate) {
        if (array) {
          if (predicate) {
            for (var _i = 0, array_3 = array; _i < array_3.length; _i++) {
              var v = array_3[_i];
              if (predicate(v)) {
                return true;
              }
            }
          } else {
            return array.length > 0;
          }
        }
        return false;
      }
      ts2.some = some;
      function getRangesWhere(arr, pred, cb) {
        var start;
        for (var i = 0; i < arr.length; i++) {
          if (pred(arr[i])) {
            start = start === void 0 ? i : start;
          } else {
            if (start !== void 0) {
              cb(start, i);
              start = void 0;
            }
          }
        }
        if (start !== void 0)
          cb(start, arr.length);
      }
      ts2.getRangesWhere = getRangesWhere;
      function concatenate(array1, array2) {
        if (!some(array2))
          return array1;
        if (!some(array1))
          return array2;
        return __spreadArray(__spreadArray([], array1, true), array2, true);
      }
      ts2.concatenate = concatenate;
      function selectIndex(_, i) {
        return i;
      }
      function indicesOf(array) {
        return array.map(selectIndex);
      }
      ts2.indicesOf = indicesOf;
      function deduplicateRelational(array, equalityComparer, comparer) {
        var indices = indicesOf(array);
        stableSortIndices(array, indices, comparer);
        var last2 = array[indices[0]];
        var deduplicated = [indices[0]];
        for (var i = 1; i < indices.length; i++) {
          var index = indices[i];
          var item = array[index];
          if (!equalityComparer(last2, item)) {
            deduplicated.push(index);
            last2 = item;
          }
        }
        deduplicated.sort();
        return deduplicated.map(function(i2) {
          return array[i2];
        });
      }
      function deduplicateEquality(array, equalityComparer) {
        var result = [];
        for (var _i = 0, array_4 = array; _i < array_4.length; _i++) {
          var item = array_4[_i];
          pushIfUnique(result, item, equalityComparer);
        }
        return result;
      }
      function deduplicate(array, equalityComparer, comparer) {
        return array.length === 0 ? [] : array.length === 1 ? array.slice() : comparer ? deduplicateRelational(array, equalityComparer, comparer) : deduplicateEquality(array, equalityComparer);
      }
      ts2.deduplicate = deduplicate;
      function deduplicateSorted(array, comparer) {
        if (array.length === 0)
          return ts2.emptyArray;
        var last2 = array[0];
        var deduplicated = [last2];
        for (var i = 1; i < array.length; i++) {
          var next = array[i];
          switch (comparer(next, last2)) {
            case true:
            case 0:
              continue;
            case -1:
              return ts2.Debug.fail("Array is unsorted.");
          }
          deduplicated.push(last2 = next);
        }
        return deduplicated;
      }
      function createSortedArray() {
        return [];
      }
      ts2.createSortedArray = createSortedArray;
      function insertSorted(array, insert, compare, allowDuplicates) {
        if (array.length === 0) {
          array.push(insert);
          return;
        }
        var insertIndex = binarySearch(array, insert, identity, compare);
        if (insertIndex < 0) {
          array.splice(~insertIndex, 0, insert);
        } else if (allowDuplicates) {
          array.splice(insertIndex, 0, insert);
        }
      }
      ts2.insertSorted = insertSorted;
      function sortAndDeduplicate(array, comparer, equalityComparer) {
        return deduplicateSorted(sort(array, comparer), equalityComparer || comparer || compareStringsCaseSensitive);
      }
      ts2.sortAndDeduplicate = sortAndDeduplicate;
      function arrayIsSorted(array, comparer) {
        if (array.length < 2)
          return true;
        var prevElement = array[0];
        for (var _i = 0, _a = array.slice(1); _i < _a.length; _i++) {
          var element = _a[_i];
          if (comparer(prevElement, element) === 1) {
            return false;
          }
          prevElement = element;
        }
        return true;
      }
      ts2.arrayIsSorted = arrayIsSorted;
      function arrayIsEqualTo(array1, array2, equalityComparer) {
        if (equalityComparer === void 0) {
          equalityComparer = equateValues;
        }
        if (!array1 || !array2) {
          return array1 === array2;
        }
        if (array1.length !== array2.length) {
          return false;
        }
        for (var i = 0; i < array1.length; i++) {
          if (!equalityComparer(array1[i], array2[i], i)) {
            return false;
          }
        }
        return true;
      }
      ts2.arrayIsEqualTo = arrayIsEqualTo;
      function compact(array) {
        var result;
        if (array) {
          for (var i = 0; i < array.length; i++) {
            var v = array[i];
            if (result || !v) {
              if (!result) {
                result = array.slice(0, i);
              }
              if (v) {
                result.push(v);
              }
            }
          }
        }
        return result || array;
      }
      ts2.compact = compact;
      function relativeComplement(arrayA, arrayB, comparer) {
        if (!arrayB || !arrayA || arrayB.length === 0 || arrayA.length === 0)
          return arrayB;
        var result = [];
        loopB:
          for (var offsetA = 0, offsetB = 0; offsetB < arrayB.length; offsetB++) {
            if (offsetB > 0) {
              ts2.Debug.assertGreaterThanOrEqual(comparer(arrayB[offsetB], arrayB[offsetB - 1]), 0);
            }
            loopA:
              for (var startA = offsetA; offsetA < arrayA.length; offsetA++) {
                if (offsetA > startA) {
                  ts2.Debug.assertGreaterThanOrEqual(comparer(arrayA[offsetA], arrayA[offsetA - 1]), 0);
                }
                switch (comparer(arrayB[offsetB], arrayA[offsetA])) {
                  case -1:
                    result.push(arrayB[offsetB]);
                    continue loopB;
                  case 0:
                    continue loopB;
                  case 1:
                    continue loopA;
                }
              }
          }
        return result;
      }
      ts2.relativeComplement = relativeComplement;
      function sum(array, prop) {
        var result = 0;
        for (var _i = 0, array_5 = array; _i < array_5.length; _i++) {
          var v = array_5[_i];
          result += v[prop];
        }
        return result;
      }
      ts2.sum = sum;
      function append(to, value) {
        if (value === void 0)
          return to;
        if (to === void 0)
          return [value];
        to.push(value);
        return to;
      }
      ts2.append = append;
      function combine(xs, ys) {
        if (xs === void 0)
          return ys;
        if (ys === void 0)
          return xs;
        if (isArray(xs))
          return isArray(ys) ? concatenate(xs, ys) : append(xs, ys);
        if (isArray(ys))
          return append(ys, xs);
        return [xs, ys];
      }
      ts2.combine = combine;
      function toOffset(array, offset) {
        return offset < 0 ? array.length + offset : offset;
      }
      function addRange(to, from, start, end) {
        if (from === void 0 || from.length === 0)
          return to;
        if (to === void 0)
          return from.slice(start, end);
        start = start === void 0 ? 0 : toOffset(from, start);
        end = end === void 0 ? from.length : toOffset(from, end);
        for (var i = start; i < end && i < from.length; i++) {
          if (from[i] !== void 0) {
            to.push(from[i]);
          }
        }
        return to;
      }
      ts2.addRange = addRange;
      function pushIfUnique(array, toAdd, equalityComparer) {
        if (contains(array, toAdd, equalityComparer)) {
          return false;
        } else {
          array.push(toAdd);
          return true;
        }
      }
      ts2.pushIfUnique = pushIfUnique;
      function appendIfUnique(array, toAdd, equalityComparer) {
        if (array) {
          pushIfUnique(array, toAdd, equalityComparer);
          return array;
        } else {
          return [toAdd];
        }
      }
      ts2.appendIfUnique = appendIfUnique;
      function stableSortIndices(array, indices, comparer) {
        indices.sort(function(x, y) {
          return comparer(array[x], array[y]) || compareValues(x, y);
        });
      }
      function sort(array, comparer) {
        return array.length === 0 ? array : array.slice().sort(comparer);
      }
      ts2.sort = sort;
      function arrayIterator(array) {
        var i = 0;
        return { next: function() {
          if (i === array.length) {
            return { value: void 0, done: true };
          } else {
            i++;
            return { value: array[i - 1], done: false };
          }
        } };
      }
      ts2.arrayIterator = arrayIterator;
      function arrayReverseIterator(array) {
        var i = array.length;
        return {
          next: function() {
            if (i === 0) {
              return { value: void 0, done: true };
            } else {
              i--;
              return { value: array[i], done: false };
            }
          }
        };
      }
      ts2.arrayReverseIterator = arrayReverseIterator;
      function stableSort(array, comparer) {
        var indices = indicesOf(array);
        stableSortIndices(array, indices, comparer);
        return indices.map(function(i) {
          return array[i];
        });
      }
      ts2.stableSort = stableSort;
      function rangeEquals(array1, array2, pos, end) {
        while (pos < end) {
          if (array1[pos] !== array2[pos]) {
            return false;
          }
          pos++;
        }
        return true;
      }
      ts2.rangeEquals = rangeEquals;
      function elementAt(array, offset) {
        if (array) {
          offset = toOffset(array, offset);
          if (offset < array.length) {
            return array[offset];
          }
        }
        return void 0;
      }
      ts2.elementAt = elementAt;
      function firstOrUndefined(array) {
        return array === void 0 || array.length === 0 ? void 0 : array[0];
      }
      ts2.firstOrUndefined = firstOrUndefined;
      function first(array) {
        ts2.Debug.assert(array.length !== 0);
        return array[0];
      }
      ts2.first = first;
      function lastOrUndefined(array) {
        return array === void 0 || array.length === 0 ? void 0 : array[array.length - 1];
      }
      ts2.lastOrUndefined = lastOrUndefined;
      function last(array) {
        ts2.Debug.assert(array.length !== 0);
        return array[array.length - 1];
      }
      ts2.last = last;
      function singleOrUndefined(array) {
        return array && array.length === 1 ? array[0] : void 0;
      }
      ts2.singleOrUndefined = singleOrUndefined;
      function singleOrMany(array) {
        return array && array.length === 1 ? array[0] : array;
      }
      ts2.singleOrMany = singleOrMany;
      function replaceElement(array, index, value) {
        var result = array.slice(0);
        result[index] = value;
        return result;
      }
      ts2.replaceElement = replaceElement;
      function binarySearch(array, value, keySelector, keyComparer, offset) {
        return binarySearchKey(array, keySelector(value), keySelector, keyComparer, offset);
      }
      ts2.binarySearch = binarySearch;
      function binarySearchKey(array, key, keySelector, keyComparer, offset) {
        if (!some(array)) {
          return -1;
        }
        var low = offset || 0;
        var high = array.length - 1;
        while (low <= high) {
          var middle = low + (high - low >> 1);
          var midKey = keySelector(array[middle], middle);
          switch (keyComparer(midKey, key)) {
            case -1:
              low = middle + 1;
              break;
            case 0:
              return middle;
            case 1:
              high = middle - 1;
              break;
          }
        }
        return ~low;
      }
      ts2.binarySearchKey = binarySearchKey;
      function reduceLeft(array, f, initial, start, count) {
        if (array && array.length > 0) {
          var size = array.length;
          if (size > 0) {
            var pos = start === void 0 || start < 0 ? 0 : start;
            var end = count === void 0 || pos + count > size - 1 ? size - 1 : pos + count;
            var result = void 0;
            if (arguments.length <= 2) {
              result = array[pos];
              pos++;
            } else {
              result = initial;
            }
            while (pos <= end) {
              result = f(result, array[pos], pos);
              pos++;
            }
            return result;
          }
        }
        return initial;
      }
      ts2.reduceLeft = reduceLeft;
      var hasOwnProperty = Object.prototype.hasOwnProperty;
      function hasProperty(map2, key) {
        return hasOwnProperty.call(map2, key);
      }
      ts2.hasProperty = hasProperty;
      function getProperty(map2, key) {
        return hasOwnProperty.call(map2, key) ? map2[key] : void 0;
      }
      ts2.getProperty = getProperty;
      function getOwnKeys(map2) {
        var keys = [];
        for (var key in map2) {
          if (hasOwnProperty.call(map2, key)) {
            keys.push(key);
          }
        }
        return keys;
      }
      ts2.getOwnKeys = getOwnKeys;
      function getAllKeys(obj) {
        var result = [];
        do {
          var names = Object.getOwnPropertyNames(obj);
          for (var _i = 0, names_1 = names; _i < names_1.length; _i++) {
            var name = names_1[_i];
            pushIfUnique(result, name);
          }
        } while (obj = Object.getPrototypeOf(obj));
        return result;
      }
      ts2.getAllKeys = getAllKeys;
      function getOwnValues(collection) {
        var values = [];
        for (var key in collection) {
          if (hasOwnProperty.call(collection, key)) {
            values.push(collection[key]);
          }
        }
        return values;
      }
      ts2.getOwnValues = getOwnValues;
      var _entries = Object.entries || function(obj) {
        var keys = getOwnKeys(obj);
        var result = Array(keys.length);
        for (var i = 0; i < keys.length; i++) {
          result[i] = [keys[i], obj[keys[i]]];
        }
        return result;
      };
      function getEntries(obj) {
        return obj ? _entries(obj) : [];
      }
      ts2.getEntries = getEntries;
      function arrayOf(count, f) {
        var result = new Array(count);
        for (var i = 0; i < count; i++) {
          result[i] = f(i);
        }
        return result;
      }
      ts2.arrayOf = arrayOf;
      function arrayFrom(iterator, map2) {
        var result = [];
        for (var iterResult = iterator.next(); !iterResult.done; iterResult = iterator.next()) {
          result.push(map2 ? map2(iterResult.value) : iterResult.value);
        }
        return result;
      }
      ts2.arrayFrom = arrayFrom;
      function assign(t) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
          args[_i - 1] = arguments[_i];
        }
        for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {
          var arg = args_1[_a];
          if (arg === void 0)
            continue;
          for (var p in arg) {
            if (hasProperty(arg, p)) {
              t[p] = arg[p];
            }
          }
        }
        return t;
      }
      ts2.assign = assign;
      function equalOwnProperties(left, right, equalityComparer) {
        if (equalityComparer === void 0) {
          equalityComparer = equateValues;
        }
        if (left === right)
          return true;
        if (!left || !right)
          return false;
        for (var key in left) {
          if (hasOwnProperty.call(left, key)) {
            if (!hasOwnProperty.call(right, key))
              return false;
            if (!equalityComparer(left[key], right[key]))
              return false;
          }
        }
        for (var key in right) {
          if (hasOwnProperty.call(right, key)) {
            if (!hasOwnProperty.call(left, key))
              return false;
          }
        }
        return true;
      }
      ts2.equalOwnProperties = equalOwnProperties;
      function arrayToMap(array, makeKey, makeValue) {
        if (makeValue === void 0) {
          makeValue = identity;
        }
        var result = new ts2.Map();
        for (var _i = 0, array_6 = array; _i < array_6.length; _i++) {
          var value = array_6[_i];
          var key = makeKey(value);
          if (key !== void 0)
            result.set(key, makeValue(value));
        }
        return result;
      }
      ts2.arrayToMap = arrayToMap;
      function arrayToNumericMap(array, makeKey, makeValue) {
        if (makeValue === void 0) {
          makeValue = identity;
        }
        var result = [];
        for (var _i = 0, array_7 = array; _i < array_7.length; _i++) {
          var value = array_7[_i];
          result[makeKey(value)] = makeValue(value);
        }
        return result;
      }
      ts2.arrayToNumericMap = arrayToNumericMap;
      function arrayToMultiMap(values, makeKey, makeValue) {
        if (makeValue === void 0) {
          makeValue = identity;
        }
        var result = createMultiMap();
        for (var _i = 0, values_1 = values; _i < values_1.length; _i++) {
          var value = values_1[_i];
          result.add(makeKey(value), makeValue(value));
        }
        return result;
      }
      ts2.arrayToMultiMap = arrayToMultiMap;
      function group(values, getGroupId, resultSelector) {
        if (resultSelector === void 0) {
          resultSelector = identity;
        }
        return arrayFrom(arrayToMultiMap(values, getGroupId).values(), resultSelector);
      }
      ts2.group = group;
      function clone(object) {
        var result = {};
        for (var id in object) {
          if (hasOwnProperty.call(object, id)) {
            result[id] = object[id];
          }
        }
        return result;
      }
      ts2.clone = clone;
      function extend(first2, second) {
        var result = {};
        for (var id in second) {
          if (hasOwnProperty.call(second, id)) {
            result[id] = second[id];
          }
        }
        for (var id in first2) {
          if (hasOwnProperty.call(first2, id)) {
            result[id] = first2[id];
          }
        }
        return result;
      }
      ts2.extend = extend;
      function copyProperties(first2, second) {
        for (var id in second) {
          if (hasOwnProperty.call(second, id)) {
            first2[id] = second[id];
          }
        }
      }
      ts2.copyProperties = copyProperties;
      function maybeBind(obj, fn) {
        return fn ? fn.bind(obj) : void 0;
      }
      ts2.maybeBind = maybeBind;
      function createMultiMap() {
        var map2 = new ts2.Map();
        map2.add = multiMapAdd;
        map2.remove = multiMapRemove;
        return map2;
      }
      ts2.createMultiMap = createMultiMap;
      function multiMapAdd(key, value) {
        var values = this.get(key);
        if (values) {
          values.push(value);
        } else {
          this.set(key, values = [value]);
        }
        return values;
      }
      function multiMapRemove(key, value) {
        var values = this.get(key);
        if (values) {
          unorderedRemoveItem(values, value);
          if (!values.length) {
            this.delete(key);
          }
        }
      }
      function createUnderscoreEscapedMultiMap() {
        return createMultiMap();
      }
      ts2.createUnderscoreEscapedMultiMap = createUnderscoreEscapedMultiMap;
      function createQueue(items) {
        var elements = (items === null || items === void 0 ? void 0 : items.slice()) || [];
        var headIndex = 0;
        function isEmpty() {
          return headIndex === elements.length;
        }
        function enqueue() {
          var items2 = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            items2[_i] = arguments[_i];
          }
          elements.push.apply(elements, items2);
        }
        function dequeue() {
          if (isEmpty()) {
            throw new Error("Queue is empty");
          }
          var result = elements[headIndex];
          elements[headIndex] = void 0;
          headIndex++;
          if (headIndex > 100 && headIndex > elements.length >> 1) {
            var newLength = elements.length - headIndex;
            elements.copyWithin(0, headIndex);
            elements.length = newLength;
            headIndex = 0;
          }
          return result;
        }
        return {
          enqueue,
          dequeue,
          isEmpty
        };
      }
      ts2.createQueue = createQueue;
      function createSet(getHashCode, equals) {
        var multiMap = new ts2.Map();
        var size = 0;
        function getElementIterator() {
          var valueIt = multiMap.values();
          var arrayIt;
          return {
            next: function() {
              while (true) {
                if (arrayIt) {
                  var n = arrayIt.next();
                  if (!n.done) {
                    return { value: n.value };
                  }
                  arrayIt = void 0;
                } else {
                  var n = valueIt.next();
                  if (n.done) {
                    return { value: void 0, done: true };
                  }
                  if (!isArray(n.value)) {
                    return { value: n.value };
                  }
                  arrayIt = arrayIterator(n.value);
                }
              }
            }
          };
        }
        var set = {
          has: function(element) {
            var hash = getHashCode(element);
            if (!multiMap.has(hash))
              return false;
            var candidates = multiMap.get(hash);
            if (!isArray(candidates))
              return equals(candidates, element);
            for (var _i = 0, candidates_1 = candidates; _i < candidates_1.length; _i++) {
              var candidate = candidates_1[_i];
              if (equals(candidate, element)) {
                return true;
              }
            }
            return false;
          },
          add: function(element) {
            var hash = getHashCode(element);
            if (multiMap.has(hash)) {
              var values = multiMap.get(hash);
              if (isArray(values)) {
                if (!contains(values, element, equals)) {
                  values.push(element);
                  size++;
                }
              } else {
                var value = values;
                if (!equals(value, element)) {
                  multiMap.set(hash, [value, element]);
                  size++;
                }
              }
            } else {
              multiMap.set(hash, element);
              size++;
            }
            return this;
          },
          delete: function(element) {
            var hash = getHashCode(element);
            if (!multiMap.has(hash))
              return false;
            var candidates = multiMap.get(hash);
            if (isArray(candidates)) {
              for (var i = 0; i < candidates.length; i++) {
                if (equals(candidates[i], element)) {
                  if (candidates.length === 1) {
                    multiMap.delete(hash);
                  } else if (candidates.length === 2) {
                    multiMap.set(hash, candidates[1 - i]);
                  } else {
                    unorderedRemoveItemAt(candidates, i);
                  }
                  size--;
                  return true;
                }
              }
            } else {
              var candidate = candidates;
              if (equals(candidate, element)) {
                multiMap.delete(hash);
                size--;
                return true;
              }
            }
            return false;
          },
          clear: function() {
            multiMap.clear();
            size = 0;
          },
          get size() {
            return size;
          },
          forEach: function(action) {
            for (var _i = 0, _a = arrayFrom(multiMap.values()); _i < _a.length; _i++) {
              var elements = _a[_i];
              if (isArray(elements)) {
                for (var _b = 0, elements_1 = elements; _b < elements_1.length; _b++) {
                  var element = elements_1[_b];
                  action(element, element);
                }
              } else {
                var element = elements;
                action(element, element);
              }
            }
          },
          keys: function() {
            return getElementIterator();
          },
          values: function() {
            return getElementIterator();
          },
          entries: function() {
            var it = getElementIterator();
            return {
              next: function() {
                var n = it.next();
                return n.done ? n : { value: [n.value, n.value] };
              }
            };
          }
        };
        return set;
      }
      ts2.createSet = createSet;
      function isArray(value) {
        return Array.isArray ? Array.isArray(value) : value instanceof Array;
      }
      ts2.isArray = isArray;
      function toArray(value) {
        return isArray(value) ? value : [value];
      }
      ts2.toArray = toArray;
      function isString(text) {
        return typeof text === "string";
      }
      ts2.isString = isString;
      function isNumber(x) {
        return typeof x === "number";
      }
      ts2.isNumber = isNumber;
      function tryCast(value, test) {
        return value !== void 0 && test(value) ? value : void 0;
      }
      ts2.tryCast = tryCast;
      function cast(value, test) {
        if (value !== void 0 && test(value))
          return value;
        return ts2.Debug.fail("Invalid cast. The supplied value ".concat(value, " did not pass the test '").concat(ts2.Debug.getFunctionName(test), "'."));
      }
      ts2.cast = cast;
      function noop(_) {
      }
      ts2.noop = noop;
      ts2.noopPush = {
        push: noop,
        length: 0
      };
      function returnFalse() {
        return false;
      }
      ts2.returnFalse = returnFalse;
      function returnTrue() {
        return true;
      }
      ts2.returnTrue = returnTrue;
      function returnUndefined() {
        return void 0;
      }
      ts2.returnUndefined = returnUndefined;
      function identity(x) {
        return x;
      }
      ts2.identity = identity;
      function toLowerCase(x) {
        return x.toLowerCase();
      }
      ts2.toLowerCase = toLowerCase;
      var fileNameLowerCaseRegExp = /[^\u0130\u0131\u00DFa-z0-9\\/:\-_\. ]+/g;
      function toFileNameLowerCase(x) {
        return fileNameLowerCaseRegExp.test(x) ? x.replace(fileNameLowerCaseRegExp, toLowerCase) : x;
      }
      ts2.toFileNameLowerCase = toFileNameLowerCase;
      function notImplemented() {
        throw new Error("Not implemented");
      }
      ts2.notImplemented = notImplemented;
      function memoize(callback) {
        var value;
        return function() {
          if (callback) {
            value = callback();
            callback = void 0;
          }
          return value;
        };
      }
      ts2.memoize = memoize;
      function memoizeOne(callback) {
        var map2 = new ts2.Map();
        return function(arg) {
          var key = "".concat(typeof arg, ":").concat(arg);
          var value = map2.get(key);
          if (value === void 0 && !map2.has(key)) {
            value = callback(arg);
            map2.set(key, value);
          }
          return value;
        };
      }
      ts2.memoizeOne = memoizeOne;
      function compose(a, b, c, d, e) {
        if (!!e) {
          var args_2 = [];
          for (var i = 0; i < arguments.length; i++) {
            args_2[i] = arguments[i];
          }
          return function(t) {
            return reduceLeft(args_2, function(u, f) {
              return f(u);
            }, t);
          };
        } else if (d) {
          return function(t) {
            return d(c(b(a(t))));
          };
        } else if (c) {
          return function(t) {
            return c(b(a(t)));
          };
        } else if (b) {
          return function(t) {
            return b(a(t));
          };
        } else if (a) {
          return function(t) {
            return a(t);
          };
        } else {
          return function(t) {
            return t;
          };
        }
      }
      ts2.compose = compose;
      var AssertionLevel;
      (function(AssertionLevel2) {
        AssertionLevel2[AssertionLevel2["None"] = 0] = "None";
        AssertionLevel2[AssertionLevel2["Normal"] = 1] = "Normal";
        AssertionLevel2[AssertionLevel2["Aggressive"] = 2] = "Aggressive";
        AssertionLevel2[AssertionLevel2["VeryAggressive"] = 3] = "VeryAggressive";
      })(AssertionLevel = ts2.AssertionLevel || (ts2.AssertionLevel = {}));
      function equateValues(a, b) {
        return a === b;
      }
      ts2.equateValues = equateValues;
      function equateStringsCaseInsensitive(a, b) {
        return a === b || a !== void 0 && b !== void 0 && a.toUpperCase() === b.toUpperCase();
      }
      ts2.equateStringsCaseInsensitive = equateStringsCaseInsensitive;
      function equateStringsCaseSensitive(a, b) {
        return equateValues(a, b);
      }
      ts2.equateStringsCaseSensitive = equateStringsCaseSensitive;
      function compareComparableValues(a, b) {
        return a === b ? 0 : a === void 0 ? -1 : b === void 0 ? 1 : a < b ? -1 : 1;
      }
      function compareValues(a, b) {
        return compareComparableValues(a, b);
      }
      ts2.compareValues = compareValues;
      function compareTextSpans(a, b) {
        return compareValues(a === null || a === void 0 ? void 0 : a.start, b === null || b === void 0 ? void 0 : b.start) || compareValues(a === null || a === void 0 ? void 0 : a.length, b === null || b === void 0 ? void 0 : b.length);
      }
      ts2.compareTextSpans = compareTextSpans;
      function min(a, b, compare) {
        return compare(a, b) === -1 ? a : b;
      }
      ts2.min = min;
      function compareStringsCaseInsensitive(a, b) {
        if (a === b)
          return 0;
        if (a === void 0)
          return -1;
        if (b === void 0)
          return 1;
        a = a.toUpperCase();
        b = b.toUpperCase();
        return a < b ? -1 : a > b ? 1 : 0;
      }
      ts2.compareStringsCaseInsensitive = compareStringsCaseInsensitive;
      function compareStringsCaseSensitive(a, b) {
        return compareComparableValues(a, b);
      }
      ts2.compareStringsCaseSensitive = compareStringsCaseSensitive;
      function getStringComparer(ignoreCase) {
        return ignoreCase ? compareStringsCaseInsensitive : compareStringsCaseSensitive;
      }
      ts2.getStringComparer = getStringComparer;
      var createUIStringComparer = function() {
        var defaultComparer;
        var enUSComparer;
        var stringComparerFactory = getStringComparerFactory();
        return createStringComparer;
        function compareWithCallback(a, b, comparer) {
          if (a === b)
            return 0;
          if (a === void 0)
            return -1;
          if (b === void 0)
            return 1;
          var value = comparer(a, b);
          return value < 0 ? -1 : value > 0 ? 1 : 0;
        }
        function createIntlCollatorStringComparer(locale) {
          var comparer = new Intl.Collator(locale, { usage: "sort", sensitivity: "variant" }).compare;
          return function(a, b) {
            return compareWithCallback(a, b, comparer);
          };
        }
        function createLocaleCompareStringComparer(locale) {
          if (locale !== void 0)
            return createFallbackStringComparer();
          return function(a, b) {
            return compareWithCallback(a, b, compareStrings);
          };
          function compareStrings(a, b) {
            return a.localeCompare(b);
          }
        }
        function createFallbackStringComparer() {
          return function(a, b) {
            return compareWithCallback(a, b, compareDictionaryOrder);
          };
          function compareDictionaryOrder(a, b) {
            return compareStrings(a.toUpperCase(), b.toUpperCase()) || compareStrings(a, b);
          }
          function compareStrings(a, b) {
            return a < b ? -1 : a > b ? 1 : 0;
          }
        }
        function getStringComparerFactory() {
          if (typeof Intl === "object" && typeof Intl.Collator === "function") {
            return createIntlCollatorStringComparer;
          }
          if (typeof String.prototype.localeCompare === "function" && typeof String.prototype.toLocaleUpperCase === "function" && "a".localeCompare("B") < 0) {
            return createLocaleCompareStringComparer;
          }
          return createFallbackStringComparer;
        }
        function createStringComparer(locale) {
          if (locale === void 0) {
            return defaultComparer || (defaultComparer = stringComparerFactory(locale));
          } else if (locale === "en-US") {
            return enUSComparer || (enUSComparer = stringComparerFactory(locale));
          } else {
            return stringComparerFactory(locale);
          }
        }
      }();
      var uiComparerCaseSensitive;
      var uiLocale;
      function getUILocale() {
        return uiLocale;
      }
      ts2.getUILocale = getUILocale;
      function setUILocale(value) {
        if (uiLocale !== value) {
          uiLocale = value;
          uiComparerCaseSensitive = void 0;
        }
      }
      ts2.setUILocale = setUILocale;
      function compareStringsCaseSensitiveUI(a, b) {
        var comparer = uiComparerCaseSensitive || (uiComparerCaseSensitive = createUIStringComparer(uiLocale));
        return comparer(a, b);
      }
      ts2.compareStringsCaseSensitiveUI = compareStringsCaseSensitiveUI;
      function compareProperties(a, b, key, comparer) {
        return a === b ? 0 : a === void 0 ? -1 : b === void 0 ? 1 : comparer(a[key], b[key]);
      }
      ts2.compareProperties = compareProperties;
      function compareBooleans(a, b) {
        return compareValues(a ? 1 : 0, b ? 1 : 0);
      }
      ts2.compareBooleans = compareBooleans;
      function getSpellingSuggestion(name, candidates, getName) {
        var maximumLengthDifference = Math.max(2, Math.floor(name.length * 0.34));
        var bestDistance = Math.floor(name.length * 0.4) + 1;
        var bestCandidate;
        for (var _i = 0, candidates_2 = candidates; _i < candidates_2.length; _i++) {
          var candidate = candidates_2[_i];
          var candidateName = getName(candidate);
          if (candidateName !== void 0 && Math.abs(candidateName.length - name.length) <= maximumLengthDifference) {
            if (candidateName === name) {
              continue;
            }
            if (candidateName.length < 3 && candidateName.toLowerCase() !== name.toLowerCase()) {
              continue;
            }
            var distance = levenshteinWithMax(name, candidateName, bestDistance - 0.1);
            if (distance === void 0) {
              continue;
            }
            ts2.Debug.assert(distance < bestDistance);
            bestDistance = distance;
            bestCandidate = candidate;
          }
        }
        return bestCandidate;
      }
      ts2.getSpellingSuggestion = getSpellingSuggestion;
      function levenshteinWithMax(s1, s2, max) {
        var previous = new Array(s2.length + 1);
        var current = new Array(s2.length + 1);
        var big = max + 0.01;
        for (var i = 0; i <= s2.length; i++) {
          previous[i] = i;
        }
        for (var i = 1; i <= s1.length; i++) {
          var c1 = s1.charCodeAt(i - 1);
          var minJ = Math.ceil(i > max ? i - max : 1);
          var maxJ = Math.floor(s2.length > max + i ? max + i : s2.length);
          current[0] = i;
          var colMin = i;
          for (var j = 1; j < minJ; j++) {
            current[j] = big;
          }
          for (var j = minJ; j <= maxJ; j++) {
            var substitutionDistance = s1[i - 1].toLowerCase() === s2[j - 1].toLowerCase() ? previous[j - 1] + 0.1 : previous[j - 1] + 2;
            var dist = c1 === s2.charCodeAt(j - 1) ? previous[j - 1] : Math.min(previous[j] + 1, current[j - 1] + 1, substitutionDistance);
            current[j] = dist;
            colMin = Math.min(colMin, dist);
          }
          for (var j = maxJ + 1; j <= s2.length; j++) {
            current[j] = big;
          }
          if (colMin > max) {
            return void 0;
          }
          var temp = previous;
          previous = current;
          current = temp;
        }
        var res = previous[s2.length];
        return res > max ? void 0 : res;
      }
      function endsWith(str, suffix) {
        var expectedPos = str.length - suffix.length;
        return expectedPos >= 0 && str.indexOf(suffix, expectedPos) === expectedPos;
      }
      ts2.endsWith = endsWith;
      function removeSuffix(str, suffix) {
        return endsWith(str, suffix) ? str.slice(0, str.length - suffix.length) : str;
      }
      ts2.removeSuffix = removeSuffix;
      function tryRemoveSuffix(str, suffix) {
        return endsWith(str, suffix) ? str.slice(0, str.length - suffix.length) : void 0;
      }
      ts2.tryRemoveSuffix = tryRemoveSuffix;
      function stringContains(str, substring) {
        return str.indexOf(substring) !== -1;
      }
      ts2.stringContains = stringContains;
      function removeMinAndVersionNumbers(fileName) {
        var end = fileName.length;
        for (var pos = end - 1; pos > 0; pos--) {
          var ch = fileName.charCodeAt(pos);
          if (ch >= 48 && ch <= 57) {
            do {
              --pos;
              ch = fileName.charCodeAt(pos);
            } while (pos > 0 && ch >= 48 && ch <= 57);
          } else if (pos > 4 && (ch === 110 || ch === 78)) {
            --pos;
            ch = fileName.charCodeAt(pos);
            if (ch !== 105 && ch !== 73) {
              break;
            }
            --pos;
            ch = fileName.charCodeAt(pos);
            if (ch !== 109 && ch !== 77) {
              break;
            }
            --pos;
            ch = fileName.charCodeAt(pos);
          } else {
            break;
          }
          if (ch !== 45 && ch !== 46) {
            break;
          }
          end = pos;
        }
        return end === fileName.length ? fileName : fileName.slice(0, end);
      }
      ts2.removeMinAndVersionNumbers = removeMinAndVersionNumbers;
      function orderedRemoveItem(array, item) {
        for (var i = 0; i < array.length; i++) {
          if (array[i] === item) {
            orderedRemoveItemAt(array, i);
            return true;
          }
        }
        return false;
      }
      ts2.orderedRemoveItem = orderedRemoveItem;
      function orderedRemoveItemAt(array, index) {
        for (var i = index; i < array.length - 1; i++) {
          array[i] = array[i + 1];
        }
        array.pop();
      }
      ts2.orderedRemoveItemAt = orderedRemoveItemAt;
      function unorderedRemoveItemAt(array, index) {
        array[index] = array[array.length - 1];
        array.pop();
      }
      ts2.unorderedRemoveItemAt = unorderedRemoveItemAt;
      function unorderedRemoveItem(array, item) {
        return unorderedRemoveFirstItemWhere(array, function(element) {
          return element === item;
        });
      }
      ts2.unorderedRemoveItem = unorderedRemoveItem;
      function unorderedRemoveFirstItemWhere(array, predicate) {
        for (var i = 0; i < array.length; i++) {
          if (predicate(array[i])) {
            unorderedRemoveItemAt(array, i);
            return true;
          }
        }
        return false;
      }
      function createGetCanonicalFileName(useCaseSensitiveFileNames) {
        return useCaseSensitiveFileNames ? identity : toFileNameLowerCase;
      }
      ts2.createGetCanonicalFileName = createGetCanonicalFileName;
      function patternText(_a) {
        var prefix = _a.prefix, suffix = _a.suffix;
        return "".concat(prefix, "*").concat(suffix);
      }
      ts2.patternText = patternText;
      function matchedText(pattern, candidate) {
        ts2.Debug.assert(isPatternMatch(pattern, candidate));
        return candidate.substring(pattern.prefix.length, candidate.length - pattern.suffix.length);
      }
      ts2.matchedText = matchedText;
      function findBestPatternMatch(values, getPattern, candidate) {
        var matchedValue;
        var longestMatchPrefixLength = -1;
        for (var _i = 0, values_2 = values; _i < values_2.length; _i++) {
          var v = values_2[_i];
          var pattern = getPattern(v);
          if (isPatternMatch(pattern, candidate) && pattern.prefix.length > longestMatchPrefixLength) {
            longestMatchPrefixLength = pattern.prefix.length;
            matchedValue = v;
          }
        }
        return matchedValue;
      }
      ts2.findBestPatternMatch = findBestPatternMatch;
      function startsWith(str, prefix) {
        return str.lastIndexOf(prefix, 0) === 0;
      }
      ts2.startsWith = startsWith;
      function removePrefix(str, prefix) {
        return startsWith(str, prefix) ? str.substr(prefix.length) : str;
      }
      ts2.removePrefix = removePrefix;
      function tryRemovePrefix(str, prefix, getCanonicalFileName) {
        if (getCanonicalFileName === void 0) {
          getCanonicalFileName = identity;
        }
        return startsWith(getCanonicalFileName(str), getCanonicalFileName(prefix)) ? str.substring(prefix.length) : void 0;
      }
      ts2.tryRemovePrefix = tryRemovePrefix;
      function isPatternMatch(_a, candidate) {
        var prefix = _a.prefix, suffix = _a.suffix;
        return candidate.length >= prefix.length + suffix.length && startsWith(candidate, prefix) && endsWith(candidate, suffix);
      }
      ts2.isPatternMatch = isPatternMatch;
      function and(f, g) {
        return function(arg) {
          return f(arg) && g(arg);
        };
      }
      ts2.and = and;
      function or() {
        var fs = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          fs[_i] = arguments[_i];
        }
        return function() {
          var args = [];
          for (var _i2 = 0; _i2 < arguments.length; _i2++) {
            args[_i2] = arguments[_i2];
          }
          var lastResult;
          for (var _a = 0, fs_1 = fs; _a < fs_1.length; _a++) {
            var f = fs_1[_a];
            lastResult = f.apply(void 0, args);
            if (lastResult) {
              return lastResult;
            }
          }
          return lastResult;
        };
      }
      ts2.or = or;
      function not(fn) {
        return function() {
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }
          return !fn.apply(void 0, args);
        };
      }
      ts2.not = not;
      function assertType(_) {
      }
      ts2.assertType = assertType;
      function singleElementArray(t) {
        return t === void 0 ? void 0 : [t];
      }
      ts2.singleElementArray = singleElementArray;
      function enumerateInsertsAndDeletes(newItems, oldItems, comparer, inserted, deleted, unchanged) {
        unchanged = unchanged || noop;
        var newIndex = 0;
        var oldIndex = 0;
        var newLen = newItems.length;
        var oldLen = oldItems.length;
        var hasChanges = false;
        while (newIndex < newLen && oldIndex < oldLen) {
          var newItem = newItems[newIndex];
          var oldItem = oldItems[oldIndex];
          var compareResult = comparer(newItem, oldItem);
          if (compareResult === -1) {
            inserted(newItem);
            newIndex++;
            hasChanges = true;
          } else if (compareResult === 1) {
            deleted(oldItem);
            oldIndex++;
            hasChanges = true;
          } else {
            unchanged(oldItem, newItem);
            newIndex++;
            oldIndex++;
          }
        }
        while (newIndex < newLen) {
          inserted(newItems[newIndex++]);
          hasChanges = true;
        }
        while (oldIndex < oldLen) {
          deleted(oldItems[oldIndex++]);
          hasChanges = true;
        }
        return hasChanges;
      }
      ts2.enumerateInsertsAndDeletes = enumerateInsertsAndDeletes;
      function fill(length2, cb) {
        var result = Array(length2);
        for (var i = 0; i < length2; i++) {
          result[i] = cb(i);
        }
        return result;
      }
      ts2.fill = fill;
      function cartesianProduct(arrays) {
        var result = [];
        cartesianProductWorker(arrays, result, void 0, 0);
        return result;
      }
      ts2.cartesianProduct = cartesianProduct;
      function cartesianProductWorker(arrays, result, outer, index) {
        for (var _i = 0, _a = arrays[index]; _i < _a.length; _i++) {
          var element = _a[_i];
          var inner = void 0;
          if (outer) {
            inner = outer.slice();
            inner.push(element);
          } else {
            inner = [element];
          }
          if (index === arrays.length - 1) {
            result.push(inner);
          } else {
            cartesianProductWorker(arrays, result, inner, index + 1);
          }
        }
      }
      function padLeft(s, length2, padString) {
        if (padString === void 0) {
          padString = " ";
        }
        return length2 <= s.length ? s : padString.repeat(length2 - s.length) + s;
      }
      ts2.padLeft = padLeft;
      function padRight(s, length2, padString) {
        if (padString === void 0) {
          padString = " ";
        }
        return length2 <= s.length ? s : s + padString.repeat(length2 - s.length);
      }
      ts2.padRight = padRight;
      function takeWhile(array, predicate) {
        var len = array.length;
        var index = 0;
        while (index < len && predicate(array[index])) {
          index++;
        }
        return array.slice(0, index);
      }
      ts2.takeWhile = takeWhile;
      ts2.trimString = !!String.prototype.trim ? function(s) {
        return s.trim();
      } : function(s) {
        return ts2.trimStringEnd(ts2.trimStringStart(s));
      };
      ts2.trimStringEnd = !!String.prototype.trimEnd ? function(s) {
        return s.trimEnd();
      } : trimEndImpl;
      ts2.trimStringStart = !!String.prototype.trimStart ? function(s) {
        return s.trimStart();
      } : function(s) {
        return s.replace(/^\s+/g, "");
      };
      function trimEndImpl(s) {
        var end = s.length - 1;
        while (end >= 0) {
          if (!ts2.isWhiteSpaceLike(s.charCodeAt(end)))
            break;
          end--;
        }
        return s.slice(0, end + 1);
      }
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      var LogLevel;
      (function(LogLevel2) {
        LogLevel2[LogLevel2["Off"] = 0] = "Off";
        LogLevel2[LogLevel2["Error"] = 1] = "Error";
        LogLevel2[LogLevel2["Warning"] = 2] = "Warning";
        LogLevel2[LogLevel2["Info"] = 3] = "Info";
        LogLevel2[LogLevel2["Verbose"] = 4] = "Verbose";
      })(LogLevel = ts2.LogLevel || (ts2.LogLevel = {}));
      var Debug;
      (function(Debug2) {
        var typeScriptVersion;
        var currentAssertionLevel = 0;
        Debug2.currentLogLevel = LogLevel.Warning;
        Debug2.isDebugging = false;
        Debug2.enableDeprecationWarnings = true;
        function getTypeScriptVersion() {
          return typeScriptVersion !== null && typeScriptVersion !== void 0 ? typeScriptVersion : typeScriptVersion = new ts2.Version(ts2.version);
        }
        Debug2.getTypeScriptVersion = getTypeScriptVersion;
        function shouldLog(level) {
          return Debug2.currentLogLevel <= level;
        }
        Debug2.shouldLog = shouldLog;
        function logMessage(level, s) {
          if (Debug2.loggingHost && shouldLog(level)) {
            Debug2.loggingHost.log(level, s);
          }
        }
        function log(s) {
          logMessage(LogLevel.Info, s);
        }
        Debug2.log = log;
        (function(log_1) {
          function error(s) {
            logMessage(LogLevel.Error, s);
          }
          log_1.error = error;
          function warn(s) {
            logMessage(LogLevel.Warning, s);
          }
          log_1.warn = warn;
          function log2(s) {
            logMessage(LogLevel.Info, s);
          }
          log_1.log = log2;
          function trace(s) {
            logMessage(LogLevel.Verbose, s);
          }
          log_1.trace = trace;
        })(log = Debug2.log || (Debug2.log = {}));
        var assertionCache = {};
        function getAssertionLevel() {
          return currentAssertionLevel;
        }
        Debug2.getAssertionLevel = getAssertionLevel;
        function setAssertionLevel(level) {
          var prevAssertionLevel = currentAssertionLevel;
          currentAssertionLevel = level;
          if (level > prevAssertionLevel) {
            for (var _i = 0, _a = ts2.getOwnKeys(assertionCache); _i < _a.length; _i++) {
              var key = _a[_i];
              var cachedFunc = assertionCache[key];
              if (cachedFunc !== void 0 && Debug2[key] !== cachedFunc.assertion && level >= cachedFunc.level) {
                Debug2[key] = cachedFunc;
                assertionCache[key] = void 0;
              }
            }
          }
        }
        Debug2.setAssertionLevel = setAssertionLevel;
        function shouldAssert(level) {
          return currentAssertionLevel >= level;
        }
        Debug2.shouldAssert = shouldAssert;
        function shouldAssertFunction(level, name) {
          if (!shouldAssert(level)) {
            assertionCache[name] = { level, assertion: Debug2[name] };
            Debug2[name] = ts2.noop;
            return false;
          }
          return true;
        }
        function fail(message, stackCrawlMark) {
          debugger;
          var e = new Error(message ? "Debug Failure. ".concat(message) : "Debug Failure.");
          if (Error.captureStackTrace) {
            Error.captureStackTrace(e, stackCrawlMark || fail);
          }
          throw e;
        }
        Debug2.fail = fail;
        function failBadSyntaxKind(node, message, stackCrawlMark) {
          return fail("".concat(message || "Unexpected node.", "\r\nNode ").concat(formatSyntaxKind(node.kind), " was unexpected."), stackCrawlMark || failBadSyntaxKind);
        }
        Debug2.failBadSyntaxKind = failBadSyntaxKind;
        function assert(expression, message, verboseDebugInfo, stackCrawlMark) {
          if (!expression) {
            message = message ? "False expression: ".concat(message) : "False expression.";
            if (verboseDebugInfo) {
              message += "\r\nVerbose Debug Information: " + (typeof verboseDebugInfo === "string" ? verboseDebugInfo : verboseDebugInfo());
            }
            fail(message, stackCrawlMark || assert);
          }
        }
        Debug2.assert = assert;
        function assertEqual(a, b, msg, msg2, stackCrawlMark) {
          if (a !== b) {
            var message = msg ? msg2 ? "".concat(msg, " ").concat(msg2) : msg : "";
            fail("Expected ".concat(a, " === ").concat(b, ". ").concat(message), stackCrawlMark || assertEqual);
          }
        }
        Debug2.assertEqual = assertEqual;
        function assertLessThan(a, b, msg, stackCrawlMark) {
          if (a >= b) {
            fail("Expected ".concat(a, " < ").concat(b, ". ").concat(msg || ""), stackCrawlMark || assertLessThan);
          }
        }
        Debug2.assertLessThan = assertLessThan;
        function assertLessThanOrEqual(a, b, stackCrawlMark) {
          if (a > b) {
            fail("Expected ".concat(a, " <= ").concat(b), stackCrawlMark || assertLessThanOrEqual);
          }
        }
        Debug2.assertLessThanOrEqual = assertLessThanOrEqual;
        function assertGreaterThanOrEqual(a, b, stackCrawlMark) {
          if (a < b) {
            fail("Expected ".concat(a, " >= ").concat(b), stackCrawlMark || assertGreaterThanOrEqual);
          }
        }
        Debug2.assertGreaterThanOrEqual = assertGreaterThanOrEqual;
        function assertIsDefined(value, message, stackCrawlMark) {
          if (value === void 0 || value === null) {
            fail(message, stackCrawlMark || assertIsDefined);
          }
        }
        Debug2.assertIsDefined = assertIsDefined;
        function checkDefined(value, message, stackCrawlMark) {
          assertIsDefined(value, message, stackCrawlMark || checkDefined);
          return value;
        }
        Debug2.checkDefined = checkDefined;
        function assertEachIsDefined(value, message, stackCrawlMark) {
          for (var _i = 0, value_1 = value; _i < value_1.length; _i++) {
            var v = value_1[_i];
            assertIsDefined(v, message, stackCrawlMark || assertEachIsDefined);
          }
        }
        Debug2.assertEachIsDefined = assertEachIsDefined;
        function checkEachDefined(value, message, stackCrawlMark) {
          assertEachIsDefined(value, message, stackCrawlMark || checkEachDefined);
          return value;
        }
        Debug2.checkEachDefined = checkEachDefined;
        function assertNever(member, message, stackCrawlMark) {
          if (message === void 0) {
            message = "Illegal value:";
          }
          var detail = typeof member === "object" && ts2.hasProperty(member, "kind") && ts2.hasProperty(member, "pos") ? "SyntaxKind: " + formatSyntaxKind(member.kind) : JSON.stringify(member);
          return fail("".concat(message, " ").concat(detail), stackCrawlMark || assertNever);
        }
        Debug2.assertNever = assertNever;
        function assertEachNode(nodes, test, message, stackCrawlMark) {
          if (shouldAssertFunction(1, "assertEachNode")) {
            assert(test === void 0 || ts2.every(nodes, test), message || "Unexpected node.", function() {
              return "Node array did not pass test '".concat(getFunctionName(test), "'.");
            }, stackCrawlMark || assertEachNode);
          }
        }
        Debug2.assertEachNode = assertEachNode;
        function assertNode(node, test, message, stackCrawlMark) {
          if (shouldAssertFunction(1, "assertNode")) {
            assert(node !== void 0 && (test === void 0 || test(node)), message || "Unexpected node.", function() {
              return "Node ".concat(formatSyntaxKind(node === null || node === void 0 ? void 0 : node.kind), " did not pass test '").concat(getFunctionName(test), "'.");
            }, stackCrawlMark || assertNode);
          }
        }
        Debug2.assertNode = assertNode;
        function assertNotNode(node, test, message, stackCrawlMark) {
          if (shouldAssertFunction(1, "assertNotNode")) {
            assert(node === void 0 || test === void 0 || !test(node), message || "Unexpected node.", function() {
              return "Node ".concat(formatSyntaxKind(node.kind), " should not have passed test '").concat(getFunctionName(test), "'.");
            }, stackCrawlMark || assertNotNode);
          }
        }
        Debug2.assertNotNode = assertNotNode;
        function assertOptionalNode(node, test, message, stackCrawlMark) {
          if (shouldAssertFunction(1, "assertOptionalNode")) {
            assert(test === void 0 || node === void 0 || test(node), message || "Unexpected node.", function() {
              return "Node ".concat(formatSyntaxKind(node === null || node === void 0 ? void 0 : node.kind), " did not pass test '").concat(getFunctionName(test), "'.");
            }, stackCrawlMark || assertOptionalNode);
          }
        }
        Debug2.assertOptionalNode = assertOptionalNode;
        function assertOptionalToken(node, kind, message, stackCrawlMark) {
          if (shouldAssertFunction(1, "assertOptionalToken")) {
            assert(kind === void 0 || node === void 0 || node.kind === kind, message || "Unexpected node.", function() {
              return "Node ".concat(formatSyntaxKind(node === null || node === void 0 ? void 0 : node.kind), " was not a '").concat(formatSyntaxKind(kind), "' token.");
            }, stackCrawlMark || assertOptionalToken);
          }
        }
        Debug2.assertOptionalToken = assertOptionalToken;
        function assertMissingNode(node, message, stackCrawlMark) {
          if (shouldAssertFunction(1, "assertMissingNode")) {
            assert(node === void 0, message || "Unexpected node.", function() {
              return "Node ".concat(formatSyntaxKind(node.kind), " was unexpected'.");
            }, stackCrawlMark || assertMissingNode);
          }
        }
        Debug2.assertMissingNode = assertMissingNode;
        function type(_value) {
        }
        Debug2.type = type;
        function getFunctionName(func) {
          if (typeof func !== "function") {
            return "";
          } else if (func.hasOwnProperty("name")) {
            return func.name;
          } else {
            var text = Function.prototype.toString.call(func);
            var match = /^function\s+([\w\$]+)\s*\(/.exec(text);
            return match ? match[1] : "";
          }
        }
        Debug2.getFunctionName = getFunctionName;
        function formatSymbol(symbol) {
          return "{ name: ".concat(ts2.unescapeLeadingUnderscores(symbol.escapedName), "; flags: ").concat(formatSymbolFlags(symbol.flags), "; declarations: ").concat(ts2.map(symbol.declarations, function(node) {
            return formatSyntaxKind(node.kind);
          }), " }");
        }
        Debug2.formatSymbol = formatSymbol;
        function formatEnum(value, enumObject, isFlags) {
          if (value === void 0) {
            value = 0;
          }
          var members = getEnumMembers(enumObject);
          if (value === 0) {
            return members.length > 0 && members[0][0] === 0 ? members[0][1] : "0";
          }
          if (isFlags) {
            var result = [];
            var remainingFlags = value;
            for (var _i = 0, members_1 = members; _i < members_1.length; _i++) {
              var _a = members_1[_i], enumValue = _a[0], enumName = _a[1];
              if (enumValue > value) {
                break;
              }
              if (enumValue !== 0 && enumValue & value) {
                result.push(enumName);
                remainingFlags &= ~enumValue;
              }
            }
            if (remainingFlags === 0) {
              return result.join("|");
            }
          } else {
            for (var _b = 0, members_2 = members; _b < members_2.length; _b++) {
              var _c = members_2[_b], enumValue = _c[0], enumName = _c[1];
              if (enumValue === value) {
                return enumName;
              }
            }
          }
          return value.toString();
        }
        Debug2.formatEnum = formatEnum;
        var enumMemberCache = new ts2.Map();
        function getEnumMembers(enumObject) {
          var existing = enumMemberCache.get(enumObject);
          if (existing) {
            return existing;
          }
          var result = [];
          for (var name in enumObject) {
            var value = enumObject[name];
            if (typeof value === "number") {
              result.push([value, name]);
            }
          }
          var sorted = ts2.stableSort(result, function(x, y) {
            return ts2.compareValues(x[0], y[0]);
          });
          enumMemberCache.set(enumObject, sorted);
          return sorted;
        }
        function formatSyntaxKind(kind) {
          return formatEnum(kind, ts2.SyntaxKind, false);
        }
        Debug2.formatSyntaxKind = formatSyntaxKind;
        function formatSnippetKind(kind) {
          return formatEnum(kind, ts2.SnippetKind, false);
        }
        Debug2.formatSnippetKind = formatSnippetKind;
        function formatNodeFlags(flags) {
          return formatEnum(flags, ts2.NodeFlags, true);
        }
        Debug2.formatNodeFlags = formatNodeFlags;
        function formatModifierFlags(flags) {
          return formatEnum(flags, ts2.ModifierFlags, true);
        }
        Debug2.formatModifierFlags = formatModifierFlags;
        function formatTransformFlags(flags) {
          return formatEnum(flags, ts2.TransformFlags, true);
        }
        Debug2.formatTransformFlags = formatTransformFlags;
        function formatEmitFlags(flags) {
          return formatEnum(flags, ts2.EmitFlags, true);
        }
        Debug2.formatEmitFlags = formatEmitFlags;
        function formatSymbolFlags(flags) {
          return formatEnum(flags, ts2.SymbolFlags, true);
        }
        Debug2.formatSymbolFlags = formatSymbolFlags;
        function formatTypeFlags(flags) {
          return formatEnum(flags, ts2.TypeFlags, true);
        }
        Debug2.formatTypeFlags = formatTypeFlags;
        function formatSignatureFlags(flags) {
          return formatEnum(flags, ts2.SignatureFlags, true);
        }
        Debug2.formatSignatureFlags = formatSignatureFlags;
        function formatObjectFlags(flags) {
          return formatEnum(flags, ts2.ObjectFlags, true);
        }
        Debug2.formatObjectFlags = formatObjectFlags;
        function formatFlowFlags(flags) {
          return formatEnum(flags, ts2.FlowFlags, true);
        }
        Debug2.formatFlowFlags = formatFlowFlags;
        function formatRelationComparisonResult(result) {
          return formatEnum(result, ts2.RelationComparisonResult, true);
        }
        Debug2.formatRelationComparisonResult = formatRelationComparisonResult;
        function formatCheckMode(mode) {
          return formatEnum(mode, ts2.CheckMode, true);
        }
        Debug2.formatCheckMode = formatCheckMode;
        function formatSignatureCheckMode(mode) {
          return formatEnum(mode, ts2.SignatureCheckMode, true);
        }
        Debug2.formatSignatureCheckMode = formatSignatureCheckMode;
        function formatTypeFacts(facts) {
          return formatEnum(facts, ts2.TypeFacts, true);
        }
        Debug2.formatTypeFacts = formatTypeFacts;
        var isDebugInfoEnabled = false;
        var extendedDebugModule;
        function extendedDebug() {
          enableDebugInfo();
          if (!extendedDebugModule) {
            throw new Error("Debugging helpers could not be loaded.");
          }
          return extendedDebugModule;
        }
        function printControlFlowGraph(flowNode) {
          return console.log(formatControlFlowGraph(flowNode));
        }
        Debug2.printControlFlowGraph = printControlFlowGraph;
        function formatControlFlowGraph(flowNode) {
          return extendedDebug().formatControlFlowGraph(flowNode);
        }
        Debug2.formatControlFlowGraph = formatControlFlowGraph;
        var flowNodeProto;
        function attachFlowNodeDebugInfoWorker(flowNode) {
          if (!("__debugFlowFlags" in flowNode)) {
            Object.defineProperties(flowNode, {
              __tsDebuggerDisplay: {
                value: function() {
                  var flowHeader = this.flags & 2 ? "FlowStart" : this.flags & 4 ? "FlowBranchLabel" : this.flags & 8 ? "FlowLoopLabel" : this.flags & 16 ? "FlowAssignment" : this.flags & 32 ? "FlowTrueCondition" : this.flags & 64 ? "FlowFalseCondition" : this.flags & 128 ? "FlowSwitchClause" : this.flags & 256 ? "FlowArrayMutation" : this.flags & 512 ? "FlowCall" : this.flags & 1024 ? "FlowReduceLabel" : this.flags & 1 ? "FlowUnreachable" : "UnknownFlow";
                  var remainingFlags = this.flags & ~(2048 - 1);
                  return "".concat(flowHeader).concat(remainingFlags ? " (".concat(formatFlowFlags(remainingFlags), ")") : "");
                }
              },
              __debugFlowFlags: { get: function() {
                return formatEnum(this.flags, ts2.FlowFlags, true);
              } },
              __debugToString: { value: function() {
                return formatControlFlowGraph(this);
              } }
            });
          }
        }
        function attachFlowNodeDebugInfo(flowNode) {
          if (isDebugInfoEnabled) {
            if (typeof Object.setPrototypeOf === "function") {
              if (!flowNodeProto) {
                flowNodeProto = Object.create(Object.prototype);
                attachFlowNodeDebugInfoWorker(flowNodeProto);
              }
              Object.setPrototypeOf(flowNode, flowNodeProto);
            } else {
              attachFlowNodeDebugInfoWorker(flowNode);
            }
          }
        }
        Debug2.attachFlowNodeDebugInfo = attachFlowNodeDebugInfo;
        var nodeArrayProto;
        function attachNodeArrayDebugInfoWorker(array) {
          if (!("__tsDebuggerDisplay" in array)) {
            Object.defineProperties(array, {
              __tsDebuggerDisplay: {
                value: function(defaultValue) {
                  defaultValue = String(defaultValue).replace(/(?:,[\s\w\d_]+:[^,]+)+\]$/, "]");
                  return "NodeArray ".concat(defaultValue);
                }
              }
            });
          }
        }
        function attachNodeArrayDebugInfo(array) {
          if (isDebugInfoEnabled) {
            if (typeof Object.setPrototypeOf === "function") {
              if (!nodeArrayProto) {
                nodeArrayProto = Object.create(Array.prototype);
                attachNodeArrayDebugInfoWorker(nodeArrayProto);
              }
              Object.setPrototypeOf(array, nodeArrayProto);
            } else {
              attachNodeArrayDebugInfoWorker(array);
            }
          }
        }
        Debug2.attachNodeArrayDebugInfo = attachNodeArrayDebugInfo;
        function enableDebugInfo() {
          if (isDebugInfoEnabled)
            return;
          var weakTypeTextMap;
          var weakNodeTextMap;
          function getWeakTypeTextMap() {
            if (weakTypeTextMap === void 0) {
              if (typeof WeakMap === "function")
                weakTypeTextMap = /* @__PURE__ */ new WeakMap();
            }
            return weakTypeTextMap;
          }
          function getWeakNodeTextMap() {
            if (weakNodeTextMap === void 0) {
              if (typeof WeakMap === "function")
                weakNodeTextMap = /* @__PURE__ */ new WeakMap();
            }
            return weakNodeTextMap;
          }
          Object.defineProperties(ts2.objectAllocator.getSymbolConstructor().prototype, {
            __tsDebuggerDisplay: {
              value: function() {
                var symbolHeader = this.flags & 33554432 ? "TransientSymbol" : "Symbol";
                var remainingSymbolFlags = this.flags & ~33554432;
                return "".concat(symbolHeader, " '").concat(ts2.symbolName(this), "'").concat(remainingSymbolFlags ? " (".concat(formatSymbolFlags(remainingSymbolFlags), ")") : "");
              }
            },
            __debugFlags: { get: function() {
              return formatSymbolFlags(this.flags);
            } }
          });
          Object.defineProperties(ts2.objectAllocator.getTypeConstructor().prototype, {
            __tsDebuggerDisplay: {
              value: function() {
                var typeHeader = this.flags & 98304 ? "NullableType" : this.flags & 384 ? "LiteralType ".concat(JSON.stringify(this.value)) : this.flags & 2048 ? "LiteralType ".concat(this.value.negative ? "-" : "").concat(this.value.base10Value, "n") : this.flags & 8192 ? "UniqueESSymbolType" : this.flags & 32 ? "EnumType" : this.flags & 67359327 ? "IntrinsicType ".concat(this.intrinsicName) : this.flags & 1048576 ? "UnionType" : this.flags & 2097152 ? "IntersectionType" : this.flags & 4194304 ? "IndexType" : this.flags & 8388608 ? "IndexedAccessType" : this.flags & 16777216 ? "ConditionalType" : this.flags & 33554432 ? "SubstitutionType" : this.flags & 262144 ? "TypeParameter" : this.flags & 524288 ? this.objectFlags & 3 ? "InterfaceType" : this.objectFlags & 4 ? "TypeReference" : this.objectFlags & 8 ? "TupleType" : this.objectFlags & 16 ? "AnonymousType" : this.objectFlags & 32 ? "MappedType" : this.objectFlags & 1024 ? "ReverseMappedType" : this.objectFlags & 256 ? "EvolvingArrayType" : "ObjectType" : "Type";
                var remainingObjectFlags = this.flags & 524288 ? this.objectFlags & ~1343 : 0;
                return "".concat(typeHeader).concat(this.symbol ? " '".concat(ts2.symbolName(this.symbol), "'") : "").concat(remainingObjectFlags ? " (".concat(formatObjectFlags(remainingObjectFlags), ")") : "");
              }
            },
            __debugFlags: { get: function() {
              return formatTypeFlags(this.flags);
            } },
            __debugObjectFlags: { get: function() {
              return this.flags & 524288 ? formatObjectFlags(this.objectFlags) : "";
            } },
            __debugTypeToString: {
              value: function() {
                var map = getWeakTypeTextMap();
                var text = map === null || map === void 0 ? void 0 : map.get(this);
                if (text === void 0) {
                  text = this.checker.typeToString(this);
                  map === null || map === void 0 ? void 0 : map.set(this, text);
                }
                return text;
              }
            }
          });
          Object.defineProperties(ts2.objectAllocator.getSignatureConstructor().prototype, {
            __debugFlags: { get: function() {
              return formatSignatureFlags(this.flags);
            } },
            __debugSignatureToString: { value: function() {
              var _a;
              return (_a = this.checker) === null || _a === void 0 ? void 0 : _a.signatureToString(this);
            } }
          });
          var nodeConstructors = [
            ts2.objectAllocator.getNodeConstructor(),
            ts2.objectAllocator.getIdentifierConstructor(),
            ts2.objectAllocator.getTokenConstructor(),
            ts2.objectAllocator.getSourceFileConstructor()
          ];
          for (var _i = 0, nodeConstructors_1 = nodeConstructors; _i < nodeConstructors_1.length; _i++) {
            var ctor = nodeConstructors_1[_i];
            if (!ctor.prototype.hasOwnProperty("__debugKind")) {
              Object.defineProperties(ctor.prototype, {
                __tsDebuggerDisplay: {
                  value: function() {
                    var nodeHeader = ts2.isGeneratedIdentifier(this) ? "GeneratedIdentifier" : ts2.isIdentifier(this) ? "Identifier '".concat(ts2.idText(this), "'") : ts2.isPrivateIdentifier(this) ? "PrivateIdentifier '".concat(ts2.idText(this), "'") : ts2.isStringLiteral(this) ? "StringLiteral ".concat(JSON.stringify(this.text.length < 10 ? this.text : this.text.slice(10) + "...")) : ts2.isNumericLiteral(this) ? "NumericLiteral ".concat(this.text) : ts2.isBigIntLiteral(this) ? "BigIntLiteral ".concat(this.text, "n") : ts2.isTypeParameterDeclaration(this) ? "TypeParameterDeclaration" : ts2.isParameter(this) ? "ParameterDeclaration" : ts2.isConstructorDeclaration(this) ? "ConstructorDeclaration" : ts2.isGetAccessorDeclaration(this) ? "GetAccessorDeclaration" : ts2.isSetAccessorDeclaration(this) ? "SetAccessorDeclaration" : ts2.isCallSignatureDeclaration(this) ? "CallSignatureDeclaration" : ts2.isConstructSignatureDeclaration(this) ? "ConstructSignatureDeclaration" : ts2.isIndexSignatureDeclaration(this) ? "IndexSignatureDeclaration" : ts2.isTypePredicateNode(this) ? "TypePredicateNode" : ts2.isTypeReferenceNode(this) ? "TypeReferenceNode" : ts2.isFunctionTypeNode(this) ? "FunctionTypeNode" : ts2.isConstructorTypeNode(this) ? "ConstructorTypeNode" : ts2.isTypeQueryNode(this) ? "TypeQueryNode" : ts2.isTypeLiteralNode(this) ? "TypeLiteralNode" : ts2.isArrayTypeNode(this) ? "ArrayTypeNode" : ts2.isTupleTypeNode(this) ? "TupleTypeNode" : ts2.isOptionalTypeNode(this) ? "OptionalTypeNode" : ts2.isRestTypeNode(this) ? "RestTypeNode" : ts2.isUnionTypeNode(this) ? "UnionTypeNode" : ts2.isIntersectionTypeNode(this) ? "IntersectionTypeNode" : ts2.isConditionalTypeNode(this) ? "ConditionalTypeNode" : ts2.isInferTypeNode(this) ? "InferTypeNode" : ts2.isParenthesizedTypeNode(this) ? "ParenthesizedTypeNode" : ts2.isThisTypeNode(this) ? "ThisTypeNode" : ts2.isTypeOperatorNode(this) ? "TypeOperatorNode" : ts2.isIndexedAccessTypeNode(this) ? "IndexedAccessTypeNode" : ts2.isMappedTypeNode(this) ? "MappedTypeNode" : ts2.isLiteralTypeNode(this) ? "LiteralTypeNode" : ts2.isNamedTupleMember(this) ? "NamedTupleMember" : ts2.isImportTypeNode(this) ? "ImportTypeNode" : formatSyntaxKind(this.kind);
                    return "".concat(nodeHeader).concat(this.flags ? " (".concat(formatNodeFlags(this.flags), ")") : "");
                  }
                },
                __debugKind: { get: function() {
                  return formatSyntaxKind(this.kind);
                } },
                __debugNodeFlags: { get: function() {
                  return formatNodeFlags(this.flags);
                } },
                __debugModifierFlags: { get: function() {
                  return formatModifierFlags(ts2.getEffectiveModifierFlagsNoCache(this));
                } },
                __debugTransformFlags: { get: function() {
                  return formatTransformFlags(this.transformFlags);
                } },
                __debugIsParseTreeNode: { get: function() {
                  return ts2.isParseTreeNode(this);
                } },
                __debugEmitFlags: { get: function() {
                  return formatEmitFlags(ts2.getEmitFlags(this));
                } },
                __debugGetText: {
                  value: function(includeTrivia) {
                    if (ts2.nodeIsSynthesized(this))
                      return "";
                    var map = getWeakNodeTextMap();
                    var text = map === null || map === void 0 ? void 0 : map.get(this);
                    if (text === void 0) {
                      var parseNode = ts2.getParseTreeNode(this);
                      var sourceFile = parseNode && ts2.getSourceFileOfNode(parseNode);
                      text = sourceFile ? ts2.getSourceTextOfNodeFromSourceFile(sourceFile, parseNode, includeTrivia) : "";
                      map === null || map === void 0 ? void 0 : map.set(this, text);
                    }
                    return text;
                  }
                }
              });
            }
          }
          try {
            if (ts2.sys && ts2.sys.require) {
              var basePath = ts2.getDirectoryPath(ts2.resolvePath(ts2.sys.getExecutingFilePath()));
              var result = ts2.sys.require(basePath, "./compiler-debug");
              if (!result.error) {
                result.module.init(ts2);
                extendedDebugModule = result.module;
              }
            }
          } catch (_a) {
          }
          isDebugInfoEnabled = true;
        }
        Debug2.enableDebugInfo = enableDebugInfo;
        function formatDeprecationMessage(name, error, errorAfter, since, message) {
          var deprecationMessage = error ? "DeprecationError: " : "DeprecationWarning: ";
          deprecationMessage += "'".concat(name, "' ");
          deprecationMessage += since ? "has been deprecated since v".concat(since) : "is deprecated";
          deprecationMessage += error ? " and can no longer be used." : errorAfter ? " and will no longer be usable after v".concat(errorAfter, ".") : ".";
          deprecationMessage += message ? " ".concat(ts2.formatStringFromArgs(message, [name], 0)) : "";
          return deprecationMessage;
        }
        function createErrorDeprecation(name, errorAfter, since, message) {
          var deprecationMessage = formatDeprecationMessage(name, true, errorAfter, since, message);
          return function() {
            throw new TypeError(deprecationMessage);
          };
        }
        function createWarningDeprecation(name, errorAfter, since, message) {
          var hasWrittenDeprecation = false;
          return function() {
            if (Debug2.enableDeprecationWarnings && !hasWrittenDeprecation) {
              log.warn(formatDeprecationMessage(name, false, errorAfter, since, message));
              hasWrittenDeprecation = true;
            }
          };
        }
        function createDeprecation(name, options) {
          var _a, _b;
          if (options === void 0) {
            options = {};
          }
          var version = typeof options.typeScriptVersion === "string" ? new ts2.Version(options.typeScriptVersion) : (_a = options.typeScriptVersion) !== null && _a !== void 0 ? _a : getTypeScriptVersion();
          var errorAfter = typeof options.errorAfter === "string" ? new ts2.Version(options.errorAfter) : options.errorAfter;
          var warnAfter = typeof options.warnAfter === "string" ? new ts2.Version(options.warnAfter) : options.warnAfter;
          var since = typeof options.since === "string" ? new ts2.Version(options.since) : (_b = options.since) !== null && _b !== void 0 ? _b : warnAfter;
          var error = options.error || errorAfter && version.compareTo(errorAfter) <= 0;
          var warn = !warnAfter || version.compareTo(warnAfter) >= 0;
          return error ? createErrorDeprecation(name, errorAfter, since, options.message) : warn ? createWarningDeprecation(name, errorAfter, since, options.message) : ts2.noop;
        }
        Debug2.createDeprecation = createDeprecation;
        function wrapFunction(deprecation, func) {
          return function() {
            deprecation();
            return func.apply(this, arguments);
          };
        }
        function deprecate(func, options) {
          var _a;
          var deprecation = createDeprecation((_a = options === null || options === void 0 ? void 0 : options.name) !== null && _a !== void 0 ? _a : getFunctionName(func), options);
          return wrapFunction(deprecation, func);
        }
        Debug2.deprecate = deprecate;
        function formatVariance(varianceFlags) {
          var variance = varianceFlags & 7;
          var result = variance === 0 ? "in out" : variance === 3 ? "[bivariant]" : variance === 2 ? "in" : variance === 1 ? "out" : variance === 4 ? "[independent]" : "";
          if (varianceFlags & 8) {
            result += " (unmeasurable)";
          } else if (varianceFlags & 16) {
            result += " (unreliable)";
          }
          return result;
        }
        Debug2.formatVariance = formatVariance;
        var DebugTypeMapper = function() {
          function DebugTypeMapper2() {
          }
          DebugTypeMapper2.prototype.__debugToString = function() {
            var _a;
            type(this);
            switch (this.kind) {
              case 3:
                return ((_a = this.debugInfo) === null || _a === void 0 ? void 0 : _a.call(this)) || "(function mapper)";
              case 0:
                return "".concat(this.source.__debugTypeToString(), " -> ").concat(this.target.__debugTypeToString());
              case 1:
                return ts2.zipWith(this.sources, this.targets || ts2.map(this.sources, function() {
                  return "any";
                }), function(s, t) {
                  return "".concat(s.__debugTypeToString(), " -> ").concat(typeof t === "string" ? t : t.__debugTypeToString());
                }).join(", ");
              case 2:
                return ts2.zipWith(this.sources, this.targets, function(s, t) {
                  return "".concat(s.__debugTypeToString(), " -> ").concat(t().__debugTypeToString());
                }).join(", ");
              case 5:
              case 4:
                return "m1: ".concat(this.mapper1.__debugToString().split("\n").join("\n    "), "\nm2: ").concat(this.mapper2.__debugToString().split("\n").join("\n    "));
              default:
                return assertNever(this);
            }
          };
          return DebugTypeMapper2;
        }();
        Debug2.DebugTypeMapper = DebugTypeMapper;
        function attachDebugPrototypeIfDebug(mapper) {
          if (Debug2.isDebugging) {
            return Object.setPrototypeOf(mapper, DebugTypeMapper.prototype);
          }
          return mapper;
        }
        Debug2.attachDebugPrototypeIfDebug = attachDebugPrototypeIfDebug;
      })(Debug = ts2.Debug || (ts2.Debug = {}));
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      var versionRegExp = /^(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:\.(0|[1-9]\d*)(?:\-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i;
      var prereleaseRegExp = /^(?:0|[1-9]\d*|[a-z-][a-z0-9-]*)(?:\.(?:0|[1-9]\d*|[a-z-][a-z0-9-]*))*$/i;
      var buildRegExp = /^[a-z0-9-]+(?:\.[a-z0-9-]+)*$/i;
      var numericIdentifierRegExp = /^(0|[1-9]\d*)$/;
      var Version = function() {
        function Version2(major, minor, patch, prerelease, build) {
          if (minor === void 0) {
            minor = 0;
          }
          if (patch === void 0) {
            patch = 0;
          }
          if (prerelease === void 0) {
            prerelease = "";
          }
          if (build === void 0) {
            build = "";
          }
          if (typeof major === "string") {
            var result = ts2.Debug.checkDefined(tryParseComponents(major), "Invalid version");
            major = result.major, minor = result.minor, patch = result.patch, prerelease = result.prerelease, build = result.build;
          }
          ts2.Debug.assert(major >= 0, "Invalid argument: major");
          ts2.Debug.assert(minor >= 0, "Invalid argument: minor");
          ts2.Debug.assert(patch >= 0, "Invalid argument: patch");
          ts2.Debug.assert(!prerelease || prereleaseRegExp.test(prerelease), "Invalid argument: prerelease");
          ts2.Debug.assert(!build || buildRegExp.test(build), "Invalid argument: build");
          this.major = major;
          this.minor = minor;
          this.patch = patch;
          this.prerelease = prerelease ? prerelease.split(".") : ts2.emptyArray;
          this.build = build ? build.split(".") : ts2.emptyArray;
        }
        Version2.tryParse = function(text) {
          var result = tryParseComponents(text);
          if (!result)
            return void 0;
          var major = result.major, minor = result.minor, patch = result.patch, prerelease = result.prerelease, build = result.build;
          return new Version2(major, minor, patch, prerelease, build);
        };
        Version2.prototype.compareTo = function(other) {
          if (this === other)
            return 0;
          if (other === void 0)
            return 1;
          return ts2.compareValues(this.major, other.major) || ts2.compareValues(this.minor, other.minor) || ts2.compareValues(this.patch, other.patch) || comparePrereleaseIdentifiers(this.prerelease, other.prerelease);
        };
        Version2.prototype.increment = function(field) {
          switch (field) {
            case "major":
              return new Version2(this.major + 1, 0, 0);
            case "minor":
              return new Version2(this.major, this.minor + 1, 0);
            case "patch":
              return new Version2(this.major, this.minor, this.patch + 1);
            default:
              return ts2.Debug.assertNever(field);
          }
        };
        Version2.prototype.toString = function() {
          var result = "".concat(this.major, ".").concat(this.minor, ".").concat(this.patch);
          if (ts2.some(this.prerelease))
            result += "-".concat(this.prerelease.join("."));
          if (ts2.some(this.build))
            result += "+".concat(this.build.join("."));
          return result;
        };
        Version2.zero = new Version2(0, 0, 0);
        return Version2;
      }();
      ts2.Version = Version;
      function tryParseComponents(text) {
        var match = versionRegExp.exec(text);
        if (!match)
          return void 0;
        var major = match[1], _a = match[2], minor = _a === void 0 ? "0" : _a, _b = match[3], patch = _b === void 0 ? "0" : _b, _c = match[4], prerelease = _c === void 0 ? "" : _c, _d = match[5], build = _d === void 0 ? "" : _d;
        if (prerelease && !prereleaseRegExp.test(prerelease))
          return void 0;
        if (build && !buildRegExp.test(build))
          return void 0;
        return {
          major: parseInt(major, 10),
          minor: parseInt(minor, 10),
          patch: parseInt(patch, 10),
          prerelease,
          build
        };
      }
      function comparePrereleaseIdentifiers(left, right) {
        if (left === right)
          return 0;
        if (left.length === 0)
          return right.length === 0 ? 0 : 1;
        if (right.length === 0)
          return -1;
        var length = Math.min(left.length, right.length);
        for (var i = 0; i < length; i++) {
          var leftIdentifier = left[i];
          var rightIdentifier = right[i];
          if (leftIdentifier === rightIdentifier)
            continue;
          var leftIsNumeric = numericIdentifierRegExp.test(leftIdentifier);
          var rightIsNumeric = numericIdentifierRegExp.test(rightIdentifier);
          if (leftIsNumeric || rightIsNumeric) {
            if (leftIsNumeric !== rightIsNumeric)
              return leftIsNumeric ? -1 : 1;
            var result = ts2.compareValues(+leftIdentifier, +rightIdentifier);
            if (result)
              return result;
          } else {
            var result = ts2.compareStringsCaseSensitive(leftIdentifier, rightIdentifier);
            if (result)
              return result;
          }
        }
        return ts2.compareValues(left.length, right.length);
      }
      var VersionRange = function() {
        function VersionRange2(spec) {
          this._alternatives = spec ? ts2.Debug.checkDefined(parseRange(spec), "Invalid range spec.") : ts2.emptyArray;
        }
        VersionRange2.tryParse = function(text) {
          var sets = parseRange(text);
          if (sets) {
            var range = new VersionRange2("");
            range._alternatives = sets;
            return range;
          }
          return void 0;
        };
        VersionRange2.prototype.test = function(version) {
          if (typeof version === "string")
            version = new Version(version);
          return testDisjunction(version, this._alternatives);
        };
        VersionRange2.prototype.toString = function() {
          return formatDisjunction(this._alternatives);
        };
        return VersionRange2;
      }();
      ts2.VersionRange = VersionRange;
      var logicalOrRegExp = /\|\|/g;
      var whitespaceRegExp = /\s+/g;
      var partialRegExp = /^([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:\.([xX*0]|[1-9]\d*)(?:-([a-z0-9-.]+))?(?:\+([a-z0-9-.]+))?)?)?$/i;
      var hyphenRegExp = /^\s*([a-z0-9-+.*]+)\s+-\s+([a-z0-9-+.*]+)\s*$/i;
      var rangeRegExp = /^(~|\^|<|<=|>|>=|=)?\s*([a-z0-9-+.*]+)$/i;
      function parseRange(text) {
        var alternatives = [];
        for (var _i = 0, _a = ts2.trimString(text).split(logicalOrRegExp); _i < _a.length; _i++) {
          var range = _a[_i];
          if (!range)
            continue;
          var comparators = [];
          range = ts2.trimString(range);
          var match = hyphenRegExp.exec(range);
          if (match) {
            if (!parseHyphen(match[1], match[2], comparators))
              return void 0;
          } else {
            for (var _b = 0, _c = range.split(whitespaceRegExp); _b < _c.length; _b++) {
              var simple = _c[_b];
              var match_1 = rangeRegExp.exec(ts2.trimString(simple));
              if (!match_1 || !parseComparator(match_1[1], match_1[2], comparators))
                return void 0;
            }
          }
          alternatives.push(comparators);
        }
        return alternatives;
      }
      function parsePartial(text) {
        var match = partialRegExp.exec(text);
        if (!match)
          return void 0;
        var major = match[1], _a = match[2], minor = _a === void 0 ? "*" : _a, _b = match[3], patch = _b === void 0 ? "*" : _b, prerelease = match[4], build = match[5];
        var version = new Version(isWildcard(major) ? 0 : parseInt(major, 10), isWildcard(major) || isWildcard(minor) ? 0 : parseInt(minor, 10), isWildcard(major) || isWildcard(minor) || isWildcard(patch) ? 0 : parseInt(patch, 10), prerelease, build);
        return { version, major, minor, patch };
      }
      function parseHyphen(left, right, comparators) {
        var leftResult = parsePartial(left);
        if (!leftResult)
          return false;
        var rightResult = parsePartial(right);
        if (!rightResult)
          return false;
        if (!isWildcard(leftResult.major)) {
          comparators.push(createComparator(">=", leftResult.version));
        }
        if (!isWildcard(rightResult.major)) {
          comparators.push(isWildcard(rightResult.minor) ? createComparator("<", rightResult.version.increment("major")) : isWildcard(rightResult.patch) ? createComparator("<", rightResult.version.increment("minor")) : createComparator("<=", rightResult.version));
        }
        return true;
      }
      function parseComparator(operator, text, comparators) {
        var result = parsePartial(text);
        if (!result)
          return false;
        var version = result.version, major = result.major, minor = result.minor, patch = result.patch;
        if (!isWildcard(major)) {
          switch (operator) {
            case "~":
              comparators.push(createComparator(">=", version));
              comparators.push(createComparator("<", version.increment(isWildcard(minor) ? "major" : "minor")));
              break;
            case "^":
              comparators.push(createComparator(">=", version));
              comparators.push(createComparator("<", version.increment(version.major > 0 || isWildcard(minor) ? "major" : version.minor > 0 || isWildcard(patch) ? "minor" : "patch")));
              break;
            case "<":
            case ">=":
              comparators.push(createComparator(operator, version));
              break;
            case "<=":
            case ">":
              comparators.push(isWildcard(minor) ? createComparator(operator === "<=" ? "<" : ">=", version.increment("major")) : isWildcard(patch) ? createComparator(operator === "<=" ? "<" : ">=", version.increment("minor")) : createComparator(operator, version));
              break;
            case "=":
            case void 0:
              if (isWildcard(minor) || isWildcard(patch)) {
                comparators.push(createComparator(">=", version));
                comparators.push(createComparator("<", version.increment(isWildcard(minor) ? "major" : "minor")));
              } else {
                comparators.push(createComparator("=", version));
              }
              break;
            default:
              return false;
          }
        } else if (operator === "<" || operator === ">") {
          comparators.push(createComparator("<", Version.zero));
        }
        return true;
      }
      function isWildcard(part) {
        return part === "*" || part === "x" || part === "X";
      }
      function createComparator(operator, operand) {
        return { operator, operand };
      }
      function testDisjunction(version, alternatives) {
        if (alternatives.length === 0)
          return true;
        for (var _i = 0, alternatives_1 = alternatives; _i < alternatives_1.length; _i++) {
          var alternative = alternatives_1[_i];
          if (testAlternative(version, alternative))
            return true;
        }
        return false;
      }
      function testAlternative(version, comparators) {
        for (var _i = 0, comparators_1 = comparators; _i < comparators_1.length; _i++) {
          var comparator = comparators_1[_i];
          if (!testComparator(version, comparator.operator, comparator.operand))
            return false;
        }
        return true;
      }
      function testComparator(version, operator, operand) {
        var cmp = version.compareTo(operand);
        switch (operator) {
          case "<":
            return cmp < 0;
          case "<=":
            return cmp <= 0;
          case ">":
            return cmp > 0;
          case ">=":
            return cmp >= 0;
          case "=":
            return cmp === 0;
          default:
            return ts2.Debug.assertNever(operator);
        }
      }
      function formatDisjunction(alternatives) {
        return ts2.map(alternatives, formatAlternative).join(" || ") || "*";
      }
      function formatAlternative(comparators) {
        return ts2.map(comparators, formatComparator).join(" ");
      }
      function formatComparator(comparator) {
        return "".concat(comparator.operator).concat(comparator.operand);
      }
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      function hasRequiredAPI(performance2, PerformanceObserver2) {
        return typeof performance2 === "object" && typeof performance2.timeOrigin === "number" && typeof performance2.mark === "function" && typeof performance2.measure === "function" && typeof performance2.now === "function" && typeof PerformanceObserver2 === "function";
      }
      function tryGetWebPerformanceHooks() {
        if (typeof performance === "object" && typeof PerformanceObserver === "function" && hasRequiredAPI(performance, PerformanceObserver)) {
          return {
            shouldWriteNativeEvents: true,
            performance,
            PerformanceObserver
          };
        }
      }
      function tryGetNodePerformanceHooks() {
        if (typeof process !== "undefined" && process.nextTick && !process.browser && typeof module2 === "object" && typeof require === "function") {
          try {
            var performance_1;
            var _a = require("perf_hooks"), nodePerformance_1 = _a.performance, PerformanceObserver_1 = _a.PerformanceObserver;
            if (hasRequiredAPI(nodePerformance_1, PerformanceObserver_1)) {
              performance_1 = nodePerformance_1;
              var version_1 = new ts2.Version(process.versions.node);
              var range = new ts2.VersionRange("<12.16.3 || 13 <13.13");
              if (range.test(version_1)) {
                performance_1 = {
                  get timeOrigin() {
                    return nodePerformance_1.timeOrigin;
                  },
                  now: function() {
                    return nodePerformance_1.now();
                  },
                  mark: function(name) {
                    return nodePerformance_1.mark(name);
                  },
                  measure: function(name, start, end) {
                    if (start === void 0) {
                      start = "nodeStart";
                    }
                    if (end === void 0) {
                      end = "__performance.measure-fix__";
                      nodePerformance_1.mark(end);
                    }
                    nodePerformance_1.measure(name, start, end);
                    if (end === "__performance.measure-fix__") {
                      nodePerformance_1.clearMarks("__performance.measure-fix__");
                    }
                  }
                };
              }
              return {
                shouldWriteNativeEvents: false,
                performance: performance_1,
                PerformanceObserver: PerformanceObserver_1
              };
            }
          } catch (_b) {
          }
        }
      }
      var nativePerformanceHooks = tryGetWebPerformanceHooks() || tryGetNodePerformanceHooks();
      var nativePerformance = nativePerformanceHooks === null || nativePerformanceHooks === void 0 ? void 0 : nativePerformanceHooks.performance;
      function tryGetNativePerformanceHooks() {
        return nativePerformanceHooks;
      }
      ts2.tryGetNativePerformanceHooks = tryGetNativePerformanceHooks;
      ts2.timestamp = nativePerformance ? function() {
        return nativePerformance.now();
      } : Date.now ? Date.now : function() {
        return +new Date();
      };
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      var performance2;
      (function(performance3) {
        var perfHooks;
        var performanceImpl;
        function createTimerIf(condition, measureName, startMarkName, endMarkName) {
          return condition ? createTimer(measureName, startMarkName, endMarkName) : performance3.nullTimer;
        }
        performance3.createTimerIf = createTimerIf;
        function createTimer(measureName, startMarkName, endMarkName) {
          var enterCount = 0;
          return {
            enter,
            exit
          };
          function enter() {
            if (++enterCount === 1) {
              mark(startMarkName);
            }
          }
          function exit() {
            if (--enterCount === 0) {
              mark(endMarkName);
              measure(measureName, startMarkName, endMarkName);
            } else if (enterCount < 0) {
              ts2.Debug.fail("enter/exit count does not match.");
            }
          }
        }
        performance3.createTimer = createTimer;
        performance3.nullTimer = { enter: ts2.noop, exit: ts2.noop };
        var enabled = false;
        var timeorigin = ts2.timestamp();
        var marks = new ts2.Map();
        var counts = new ts2.Map();
        var durations = new ts2.Map();
        function mark(markName) {
          var _a;
          if (enabled) {
            var count = (_a = counts.get(markName)) !== null && _a !== void 0 ? _a : 0;
            counts.set(markName, count + 1);
            marks.set(markName, ts2.timestamp());
            performanceImpl === null || performanceImpl === void 0 ? void 0 : performanceImpl.mark(markName);
          }
        }
        performance3.mark = mark;
        function measure(measureName, startMarkName, endMarkName) {
          var _a, _b;
          if (enabled) {
            var end = (_a = endMarkName !== void 0 ? marks.get(endMarkName) : void 0) !== null && _a !== void 0 ? _a : ts2.timestamp();
            var start = (_b = startMarkName !== void 0 ? marks.get(startMarkName) : void 0) !== null && _b !== void 0 ? _b : timeorigin;
            var previousDuration = durations.get(measureName) || 0;
            durations.set(measureName, previousDuration + (end - start));
            performanceImpl === null || performanceImpl === void 0 ? void 0 : performanceImpl.measure(measureName, startMarkName, endMarkName);
          }
        }
        performance3.measure = measure;
        function getCount(markName) {
          return counts.get(markName) || 0;
        }
        performance3.getCount = getCount;
        function getDuration(measureName) {
          return durations.get(measureName) || 0;
        }
        performance3.getDuration = getDuration;
        function forEachMeasure(cb) {
          durations.forEach(function(duration, measureName) {
            return cb(measureName, duration);
          });
        }
        performance3.forEachMeasure = forEachMeasure;
        function isEnabled() {
          return enabled;
        }
        performance3.isEnabled = isEnabled;
        function enable(system) {
          var _a;
          if (system === void 0) {
            system = ts2.sys;
          }
          if (!enabled) {
            enabled = true;
            perfHooks || (perfHooks = ts2.tryGetNativePerformanceHooks());
            if (perfHooks) {
              timeorigin = perfHooks.performance.timeOrigin;
              if (perfHooks.shouldWriteNativeEvents || ((_a = system === null || system === void 0 ? void 0 : system.cpuProfilingEnabled) === null || _a === void 0 ? void 0 : _a.call(system)) || (system === null || system === void 0 ? void 0 : system.debugMode)) {
                performanceImpl = perfHooks.performance;
              }
            }
          }
          return true;
        }
        performance3.enable = enable;
        function disable() {
          if (enabled) {
            marks.clear();
            counts.clear();
            durations.clear();
            performanceImpl = void 0;
            enabled = false;
          }
        }
        performance3.disable = disable;
      })(performance2 = ts2.performance || (ts2.performance = {}));
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      var _a;
      var nullLogger = {
        logEvent: ts2.noop,
        logErrEvent: ts2.noop,
        logPerfEvent: ts2.noop,
        logInfoEvent: ts2.noop,
        logStartCommand: ts2.noop,
        logStopCommand: ts2.noop,
        logStartUpdateProgram: ts2.noop,
        logStopUpdateProgram: ts2.noop,
        logStartUpdateGraph: ts2.noop,
        logStopUpdateGraph: ts2.noop,
        logStartResolveModule: ts2.noop,
        logStopResolveModule: ts2.noop,
        logStartParseSourceFile: ts2.noop,
        logStopParseSourceFile: ts2.noop,
        logStartReadFile: ts2.noop,
        logStopReadFile: ts2.noop,
        logStartBindFile: ts2.noop,
        logStopBindFile: ts2.noop,
        logStartScheduledOperation: ts2.noop,
        logStopScheduledOperation: ts2.noop
      };
      var etwModule;
      try {
        var etwModulePath = (_a = process.env.TS_ETW_MODULE_PATH) !== null && _a !== void 0 ? _a : "./node_modules/@microsoft/typescript-etw";
        etwModule = require(etwModulePath);
      } catch (e) {
        etwModule = void 0;
      }
      ts2.perfLogger = etwModule && etwModule.logEvent ? etwModule : nullLogger;
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      var tracingEnabled;
      (function(tracingEnabled2) {
        var fs;
        var traceCount = 0;
        var traceFd = 0;
        var mode;
        var typeCatalog = [];
        var legendPath;
        var legend = [];
        ;
        function startTracing(tracingMode, traceDir, configFilePath) {
          ts2.Debug.assert(!ts2.tracing, "Tracing already started");
          if (fs === void 0) {
            try {
              fs = require("fs");
            } catch (e) {
              throw new Error("tracing requires having fs\n(original error: ".concat(e.message || e, ")"));
            }
          }
          mode = tracingMode;
          typeCatalog.length = 0;
          if (legendPath === void 0) {
            legendPath = ts2.combinePaths(traceDir, "legend.json");
          }
          if (!fs.existsSync(traceDir)) {
            fs.mkdirSync(traceDir, { recursive: true });
          }
          var countPart = mode === "build" ? ".".concat(process.pid, "-").concat(++traceCount) : mode === "server" ? ".".concat(process.pid) : "";
          var tracePath = ts2.combinePaths(traceDir, "trace".concat(countPart, ".json"));
          var typesPath = ts2.combinePaths(traceDir, "types".concat(countPart, ".json"));
          legend.push({
            configFilePath,
            tracePath,
            typesPath
          });
          traceFd = fs.openSync(tracePath, "w");
          ts2.tracing = tracingEnabled2;
          var meta = { cat: "__metadata", ph: "M", ts: 1e3 * ts2.timestamp(), pid: 1, tid: 1 };
          fs.writeSync(traceFd, "[\n" + [__assign({ name: "process_name", args: { name: "tsc" } }, meta), __assign({ name: "thread_name", args: { name: "Main" } }, meta), __assign(__assign({ name: "TracingStartedInBrowser" }, meta), { cat: "disabled-by-default-devtools.timeline" })].map(function(v) {
            return JSON.stringify(v);
          }).join(",\n"));
        }
        tracingEnabled2.startTracing = startTracing;
        function stopTracing() {
          ts2.Debug.assert(ts2.tracing, "Tracing is not in progress");
          ts2.Debug.assert(!!typeCatalog.length === (mode !== "server"));
          fs.writeSync(traceFd, "\n]\n");
          fs.closeSync(traceFd);
          ts2.tracing = void 0;
          if (typeCatalog.length) {
            dumpTypes(typeCatalog);
          } else {
            legend[legend.length - 1].typesPath = void 0;
          }
        }
        tracingEnabled2.stopTracing = stopTracing;
        function recordType(type) {
          if (mode !== "server") {
            typeCatalog.push(type);
          }
        }
        tracingEnabled2.recordType = recordType;
        var Phase;
        (function(Phase2) {
          Phase2["Parse"] = "parse";
          Phase2["Program"] = "program";
          Phase2["Bind"] = "bind";
          Phase2["Check"] = "check";
          Phase2["CheckTypes"] = "checkTypes";
          Phase2["Emit"] = "emit";
          Phase2["Session"] = "session";
        })(Phase = tracingEnabled2.Phase || (tracingEnabled2.Phase = {}));
        function instant(phase, name, args) {
          writeEvent("I", phase, name, args, '"s":"g"');
        }
        tracingEnabled2.instant = instant;
        var eventStack = [];
        function push(phase, name, args, separateBeginAndEnd) {
          if (separateBeginAndEnd === void 0) {
            separateBeginAndEnd = false;
          }
          if (separateBeginAndEnd) {
            writeEvent("B", phase, name, args);
          }
          eventStack.push({ phase, name, args, time: 1e3 * ts2.timestamp(), separateBeginAndEnd });
        }
        tracingEnabled2.push = push;
        function pop(results) {
          ts2.Debug.assert(eventStack.length > 0);
          writeStackEvent(eventStack.length - 1, 1e3 * ts2.timestamp(), results);
          eventStack.length--;
        }
        tracingEnabled2.pop = pop;
        function popAll() {
          var endTime = 1e3 * ts2.timestamp();
          for (var i = eventStack.length - 1; i >= 0; i--) {
            writeStackEvent(i, endTime);
          }
          eventStack.length = 0;
        }
        tracingEnabled2.popAll = popAll;
        var sampleInterval = 1e3 * 10;
        function writeStackEvent(index, endTime, results) {
          var _a = eventStack[index], phase = _a.phase, name = _a.name, args = _a.args, time = _a.time, separateBeginAndEnd = _a.separateBeginAndEnd;
          if (separateBeginAndEnd) {
            ts2.Debug.assert(!results, "`results` are not supported for events with `separateBeginAndEnd`");
            writeEvent("E", phase, name, args, void 0, endTime);
          } else if (sampleInterval - time % sampleInterval <= endTime - time) {
            writeEvent("X", phase, name, __assign(__assign({}, args), { results }), '"dur":'.concat(endTime - time), time);
          }
        }
        function writeEvent(eventType, phase, name, args, extras, time) {
          if (time === void 0) {
            time = 1e3 * ts2.timestamp();
          }
          if (mode === "server" && phase === "checkTypes")
            return;
          ts2.performance.mark("beginTracing");
          fs.writeSync(traceFd, ',\n{"pid":1,"tid":1,"ph":"'.concat(eventType, '","cat":"').concat(phase, '","ts":').concat(time, ',"name":"').concat(name, '"'));
          if (extras)
            fs.writeSync(traceFd, ",".concat(extras));
          if (args)
            fs.writeSync(traceFd, ',"args":'.concat(JSON.stringify(args)));
          fs.writeSync(traceFd, "}");
          ts2.performance.mark("endTracing");
          ts2.performance.measure("Tracing", "beginTracing", "endTracing");
        }
        function getLocation(node) {
          var file = ts2.getSourceFileOfNode(node);
          return !file ? void 0 : {
            path: file.path,
            start: indexFromOne(ts2.getLineAndCharacterOfPosition(file, node.pos)),
            end: indexFromOne(ts2.getLineAndCharacterOfPosition(file, node.end))
          };
          function indexFromOne(lc) {
            return {
              line: lc.line + 1,
              character: lc.character + 1
            };
          }
        }
        function dumpTypes(types) {
          var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x;
          ts2.performance.mark("beginDumpTypes");
          var typesPath = legend[legend.length - 1].typesPath;
          var typesFd = fs.openSync(typesPath, "w");
          var recursionIdentityMap = new ts2.Map();
          fs.writeSync(typesFd, "[");
          var numTypes = types.length;
          for (var i = 0; i < numTypes; i++) {
            var type = types[i];
            var objectFlags = type.objectFlags;
            var symbol = (_a = type.aliasSymbol) !== null && _a !== void 0 ? _a : type.symbol;
            var display = void 0;
            if (objectFlags & 16 | type.flags & 2944) {
              try {
                display = (_b = type.checker) === null || _b === void 0 ? void 0 : _b.typeToString(type);
              } catch (_y) {
                display = void 0;
              }
            }
            var indexedAccessProperties = {};
            if (type.flags & 8388608) {
              var indexedAccessType = type;
              indexedAccessProperties = {
                indexedAccessObjectType: (_c = indexedAccessType.objectType) === null || _c === void 0 ? void 0 : _c.id,
                indexedAccessIndexType: (_d = indexedAccessType.indexType) === null || _d === void 0 ? void 0 : _d.id
              };
            }
            var referenceProperties = {};
            if (objectFlags & 4) {
              var referenceType = type;
              referenceProperties = {
                instantiatedType: (_e = referenceType.target) === null || _e === void 0 ? void 0 : _e.id,
                typeArguments: (_f = referenceType.resolvedTypeArguments) === null || _f === void 0 ? void 0 : _f.map(function(t) {
                  return t.id;
                }),
                referenceLocation: getLocation(referenceType.node)
              };
            }
            var conditionalProperties = {};
            if (type.flags & 16777216) {
              var conditionalType = type;
              conditionalProperties = {
                conditionalCheckType: (_g = conditionalType.checkType) === null || _g === void 0 ? void 0 : _g.id,
                conditionalExtendsType: (_h = conditionalType.extendsType) === null || _h === void 0 ? void 0 : _h.id,
                conditionalTrueType: (_k = (_j = conditionalType.resolvedTrueType) === null || _j === void 0 ? void 0 : _j.id) !== null && _k !== void 0 ? _k : -1,
                conditionalFalseType: (_m = (_l = conditionalType.resolvedFalseType) === null || _l === void 0 ? void 0 : _l.id) !== null && _m !== void 0 ? _m : -1
              };
            }
            var substitutionProperties = {};
            if (type.flags & 33554432) {
              var substitutionType = type;
              substitutionProperties = {
                substitutionBaseType: (_o = substitutionType.baseType) === null || _o === void 0 ? void 0 : _o.id,
                substituteType: (_p = substitutionType.substitute) === null || _p === void 0 ? void 0 : _p.id
              };
            }
            var reverseMappedProperties = {};
            if (objectFlags & 1024) {
              var reverseMappedType = type;
              reverseMappedProperties = {
                reverseMappedSourceType: (_q = reverseMappedType.source) === null || _q === void 0 ? void 0 : _q.id,
                reverseMappedMappedType: (_r = reverseMappedType.mappedType) === null || _r === void 0 ? void 0 : _r.id,
                reverseMappedConstraintType: (_s = reverseMappedType.constraintType) === null || _s === void 0 ? void 0 : _s.id
              };
            }
            var evolvingArrayProperties = {};
            if (objectFlags & 256) {
              var evolvingArrayType = type;
              evolvingArrayProperties = {
                evolvingArrayElementType: evolvingArrayType.elementType.id,
                evolvingArrayFinalType: (_t = evolvingArrayType.finalArrayType) === null || _t === void 0 ? void 0 : _t.id
              };
            }
            var recursionToken = void 0;
            var recursionIdentity = type.checker.getRecursionIdentity(type);
            if (recursionIdentity) {
              recursionToken = recursionIdentityMap.get(recursionIdentity);
              if (!recursionToken) {
                recursionToken = recursionIdentityMap.size;
                recursionIdentityMap.set(recursionIdentity, recursionToken);
              }
            }
            var descriptor = __assign(__assign(__assign(__assign(__assign(__assign(__assign({ id: type.id, intrinsicName: type.intrinsicName, symbolName: (symbol === null || symbol === void 0 ? void 0 : symbol.escapedName) && ts2.unescapeLeadingUnderscores(symbol.escapedName), recursionId: recursionToken, isTuple: objectFlags & 8 ? true : void 0, unionTypes: type.flags & 1048576 ? (_u = type.types) === null || _u === void 0 ? void 0 : _u.map(function(t) {
              return t.id;
            }) : void 0, intersectionTypes: type.flags & 2097152 ? type.types.map(function(t) {
              return t.id;
            }) : void 0, aliasTypeArguments: (_v = type.aliasTypeArguments) === null || _v === void 0 ? void 0 : _v.map(function(t) {
              return t.id;
            }), keyofType: type.flags & 4194304 ? (_w = type.type) === null || _w === void 0 ? void 0 : _w.id : void 0 }, indexedAccessProperties), referenceProperties), conditionalProperties), substitutionProperties), reverseMappedProperties), evolvingArrayProperties), { destructuringPattern: getLocation(type.pattern), firstDeclaration: getLocation((_x = symbol === null || symbol === void 0 ? void 0 : symbol.declarations) === null || _x === void 0 ? void 0 : _x[0]), flags: ts2.Debug.formatTypeFlags(type.flags).split("|"), display });
            fs.writeSync(typesFd, JSON.stringify(descriptor));
            if (i < numTypes - 1) {
              fs.writeSync(typesFd, ",\n");
            }
          }
          fs.writeSync(typesFd, "]\n");
          fs.closeSync(typesFd);
          ts2.performance.mark("endDumpTypes");
          ts2.performance.measure("Dump types", "beginDumpTypes", "endDumpTypes");
        }
        function dumpLegend() {
          if (!legendPath) {
            return;
          }
          fs.writeFileSync(legendPath, JSON.stringify(legend));
        }
        tracingEnabled2.dumpLegend = dumpLegend;
      })(tracingEnabled || (tracingEnabled = {}));
      ts2.startTracing = tracingEnabled.startTracing;
      ts2.dumpTracingLegend = tracingEnabled.dumpLegend;
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      var SyntaxKind;
      (function(SyntaxKind2) {
        SyntaxKind2[SyntaxKind2["Unknown"] = 0] = "Unknown";
        SyntaxKind2[SyntaxKind2["EndOfFileToken"] = 1] = "EndOfFileToken";
        SyntaxKind2[SyntaxKind2["SingleLineCommentTrivia"] = 2] = "SingleLineCommentTrivia";
        SyntaxKind2[SyntaxKind2["MultiLineCommentTrivia"] = 3] = "MultiLineCommentTrivia";
        SyntaxKind2[SyntaxKind2["NewLineTrivia"] = 4] = "NewLineTrivia";
        SyntaxKind2[SyntaxKind2["WhitespaceTrivia"] = 5] = "WhitespaceTrivia";
        SyntaxKind2[SyntaxKind2["ShebangTrivia"] = 6] = "ShebangTrivia";
        SyntaxKind2[SyntaxKind2["ConflictMarkerTrivia"] = 7] = "ConflictMarkerTrivia";
        SyntaxKind2[SyntaxKind2["NumericLiteral"] = 8] = "NumericLiteral";
        SyntaxKind2[SyntaxKind2["BigIntLiteral"] = 9] = "BigIntLiteral";
        SyntaxKind2[SyntaxKind2["StringLiteral"] = 10] = "StringLiteral";
        SyntaxKind2[SyntaxKind2["JsxText"] = 11] = "JsxText";
        SyntaxKind2[SyntaxKind2["JsxTextAllWhiteSpaces"] = 12] = "JsxTextAllWhiteSpaces";
        SyntaxKind2[SyntaxKind2["RegularExpressionLiteral"] = 13] = "RegularExpressionLiteral";
        SyntaxKind2[SyntaxKind2["NoSubstitutionTemplateLiteral"] = 14] = "NoSubstitutionTemplateLiteral";
        SyntaxKind2[SyntaxKind2["TemplateHead"] = 15] = "TemplateHead";
        SyntaxKind2[SyntaxKind2["TemplateMiddle"] = 16] = "TemplateMiddle";
        SyntaxKind2[SyntaxKind2["TemplateTail"] = 17] = "TemplateTail";
        SyntaxKind2[SyntaxKind2["OpenBraceToken"] = 18] = "OpenBraceToken";
        SyntaxKind2[SyntaxKind2["CloseBraceToken"] = 19] = "CloseBraceToken";
        SyntaxKind2[SyntaxKind2["OpenParenToken"] = 20] = "OpenParenToken";
        SyntaxKind2[SyntaxKind2["CloseParenToken"] = 21] = "CloseParenToken";
        SyntaxKind2[SyntaxKind2["OpenBracketToken"] = 22] = "OpenBracketToken";
        SyntaxKind2[SyntaxKind2["CloseBracketToken"] = 23] = "CloseBracketToken";
        SyntaxKind2[SyntaxKind2["DotToken"] = 24] = "DotToken";
        SyntaxKind2[SyntaxKind2["DotDotDotToken"] = 25] = "DotDotDotToken";
        SyntaxKind2[SyntaxKind2["SemicolonToken"] = 26] = "SemicolonToken";
        SyntaxKind2[SyntaxKind2["CommaToken"] = 27] = "CommaToken";
        SyntaxKind2[SyntaxKind2["QuestionDotToken"] = 28] = "QuestionDotToken";
        SyntaxKind2[SyntaxKind2["LessThanToken"] = 29] = "LessThanToken";
        SyntaxKind2[SyntaxKind2["LessThanSlashToken"] = 30] = "LessThanSlashToken";
        SyntaxKind2[SyntaxKind2["GreaterThanToken"] = 31] = "GreaterThanToken";
        SyntaxKind2[SyntaxKind2["LessThanEqualsToken"] = 32] = "LessThanEqualsToken";
        SyntaxKind2[SyntaxKind2["GreaterThanEqualsToken"] = 33] = "GreaterThanEqualsToken";
        SyntaxKind2[SyntaxKind2["EqualsEqualsToken"] = 34] = "EqualsEqualsToken";
        SyntaxKind2[SyntaxKind2["ExclamationEqualsToken"] = 35] = "ExclamationEqualsToken";
        SyntaxKind2[SyntaxKind2["EqualsEqualsEqualsToken"] = 36] = "EqualsEqualsEqualsToken";
        SyntaxKind2[SyntaxKind2["ExclamationEqualsEqualsToken"] = 37] = "ExclamationEqualsEqualsToken";
        SyntaxKind2[SyntaxKind2["EqualsGreaterThanToken"] = 38] = "EqualsGreaterThanToken";
        SyntaxKind2[SyntaxKind2["PlusToken"] = 39] = "PlusToken";
        SyntaxKind2[SyntaxKind2["MinusToken"] = 40] = "MinusToken";
        SyntaxKind2[SyntaxKind2["AsteriskToken"] = 41] = "AsteriskToken";
        SyntaxKind2[SyntaxKind2["AsteriskAsteriskToken"] = 42] = "AsteriskAsteriskToken";
        SyntaxKind2[SyntaxKind2["SlashToken"] = 43] = "SlashToken";
        SyntaxKind2[SyntaxKind2["PercentToken"] = 44] = "PercentToken";
        SyntaxKind2[SyntaxKind2["PlusPlusToken"] = 45] = "PlusPlusToken";
        SyntaxKind2[SyntaxKind2["MinusMinusToken"] = 46] = "MinusMinusToken";
        SyntaxKind2[SyntaxKind2["LessThanLessThanToken"] = 47] = "LessThanLessThanToken";
        SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanToken"] = 48] = "GreaterThanGreaterThanToken";
        SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanGreaterThanToken"] = 49] = "GreaterThanGreaterThanGreaterThanToken";
        SyntaxKind2[SyntaxKind2["AmpersandToken"] = 50] = "AmpersandToken";
        SyntaxKind2[SyntaxKind2["BarToken"] = 51] = "BarToken";
        SyntaxKind2[SyntaxKind2["CaretToken"] = 52] = "CaretToken";
        SyntaxKind2[SyntaxKind2["ExclamationToken"] = 53] = "ExclamationToken";
        SyntaxKind2[SyntaxKind2["TildeToken"] = 54] = "TildeToken";
        SyntaxKind2[SyntaxKind2["AmpersandAmpersandToken"] = 55] = "AmpersandAmpersandToken";
        SyntaxKind2[SyntaxKind2["BarBarToken"] = 56] = "BarBarToken";
        SyntaxKind2[SyntaxKind2["QuestionToken"] = 57] = "QuestionToken";
        SyntaxKind2[SyntaxKind2["ColonToken"] = 58] = "ColonToken";
        SyntaxKind2[SyntaxKind2["AtToken"] = 59] = "AtToken";
        SyntaxKind2[SyntaxKind2["QuestionQuestionToken"] = 60] = "QuestionQuestionToken";
        SyntaxKind2[SyntaxKind2["BacktickToken"] = 61] = "BacktickToken";
        SyntaxKind2[SyntaxKind2["HashToken"] = 62] = "HashToken";
        SyntaxKind2[SyntaxKind2["EqualsToken"] = 63] = "EqualsToken";
        SyntaxKind2[SyntaxKind2["PlusEqualsToken"] = 64] = "PlusEqualsToken";
        SyntaxKind2[SyntaxKind2["MinusEqualsToken"] = 65] = "MinusEqualsToken";
        SyntaxKind2[SyntaxKind2["AsteriskEqualsToken"] = 66] = "AsteriskEqualsToken";
        SyntaxKind2[SyntaxKind2["AsteriskAsteriskEqualsToken"] = 67] = "AsteriskAsteriskEqualsToken";
        SyntaxKind2[SyntaxKind2["SlashEqualsToken"] = 68] = "SlashEqualsToken";
        SyntaxKind2[SyntaxKind2["PercentEqualsToken"] = 69] = "PercentEqualsToken";
        SyntaxKind2[SyntaxKind2["LessThanLessThanEqualsToken"] = 70] = "LessThanLessThanEqualsToken";
        SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanEqualsToken"] = 71] = "GreaterThanGreaterThanEqualsToken";
        SyntaxKind2[SyntaxKind2["GreaterThanGreaterThanGreaterThanEqualsToken"] = 72] = "GreaterThanGreaterThanGreaterThanEqualsToken";
        SyntaxKind2[SyntaxKind2["AmpersandEqualsToken"] = 73] = "AmpersandEqualsToken";
        SyntaxKind2[SyntaxKind2["BarEqualsToken"] = 74] = "BarEqualsToken";
        SyntaxKind2[SyntaxKind2["BarBarEqualsToken"] = 75] = "BarBarEqualsToken";
        SyntaxKind2[SyntaxKind2["AmpersandAmpersandEqualsToken"] = 76] = "AmpersandAmpersandEqualsToken";
        SyntaxKind2[SyntaxKind2["QuestionQuestionEqualsToken"] = 77] = "QuestionQuestionEqualsToken";
        SyntaxKind2[SyntaxKind2["CaretEqualsToken"] = 78] = "CaretEqualsToken";
        SyntaxKind2[SyntaxKind2["Identifier"] = 79] = "Identifier";
        SyntaxKind2[SyntaxKind2["PrivateIdentifier"] = 80] = "PrivateIdentifier";
        SyntaxKind2[SyntaxKind2["BreakKeyword"] = 81] = "BreakKeyword";
        SyntaxKind2[SyntaxKind2["CaseKeyword"] = 82] = "CaseKeyword";
        SyntaxKind2[SyntaxKind2["CatchKeyword"] = 83] = "CatchKeyword";
        SyntaxKind2[SyntaxKind2["ClassKeyword"] = 84] = "ClassKeyword";
        SyntaxKind2[SyntaxKind2["ConstKeyword"] = 85] = "ConstKeyword";
        SyntaxKind2[SyntaxKind2["ContinueKeyword"] = 86] = "ContinueKeyword";
        SyntaxKind2[SyntaxKind2["DebuggerKeyword"] = 87] = "DebuggerKeyword";
        SyntaxKind2[SyntaxKind2["DefaultKeyword"] = 88] = "DefaultKeyword";
        SyntaxKind2[SyntaxKind2["DeleteKeyword"] = 89] = "DeleteKeyword";
        SyntaxKind2[SyntaxKind2["DoKeyword"] = 90] = "DoKeyword";
        SyntaxKind2[SyntaxKind2["ElseKeyword"] = 91] = "ElseKeyword";
        SyntaxKind2[SyntaxKind2["EnumKeyword"] = 92] = "EnumKeyword";
        SyntaxKind2[SyntaxKind2["ExportKeyword"] = 93] = "ExportKeyword";
        SyntaxKind2[SyntaxKind2["ExtendsKeyword"] = 94] = "ExtendsKeyword";
        SyntaxKind2[SyntaxKind2["FalseKeyword"] = 95] = "FalseKeyword";
        SyntaxKind2[SyntaxKind2["FinallyKeyword"] = 96] = "FinallyKeyword";
        SyntaxKind2[SyntaxKind2["ForKeyword"] = 97] = "ForKeyword";
        SyntaxKind2[SyntaxKind2["FunctionKeyword"] = 98] = "FunctionKeyword";
        SyntaxKind2[SyntaxKind2["IfKeyword"] = 99] = "IfKeyword";
        SyntaxKind2[SyntaxKind2["ImportKeyword"] = 100] = "ImportKeyword";
        SyntaxKind2[SyntaxKind2["InKeyword"] = 101] = "InKeyword";
        SyntaxKind2[SyntaxKind2["InstanceOfKeyword"] = 102] = "InstanceOfKeyword";
        SyntaxKind2[SyntaxKind2["NewKeyword"] = 103] = "NewKeyword";
        SyntaxKind2[SyntaxKind2["NullKeyword"] = 104] = "NullKeyword";
        SyntaxKind2[SyntaxKind2["ReturnKeyword"] = 105] = "ReturnKeyword";
        SyntaxKind2[SyntaxKind2["SuperKeyword"] = 106] = "SuperKeyword";
        SyntaxKind2[SyntaxKind2["SwitchKeyword"] = 107] = "SwitchKeyword";
        SyntaxKind2[SyntaxKind2["ThisKeyword"] = 108] = "ThisKeyword";
        SyntaxKind2[SyntaxKind2["ThrowKeyword"] = 109] = "ThrowKeyword";
        SyntaxKind2[SyntaxKind2["TrueKeyword"] = 110] = "TrueKeyword";
        SyntaxKind2[SyntaxKind2["TryKeyword"] = 111] = "TryKeyword";
        SyntaxKind2[SyntaxKind2["TypeOfKeyword"] = 112] = "TypeOfKeyword";
        SyntaxKind2[SyntaxKind2["VarKeyword"] = 113] = "VarKeyword";
        SyntaxKind2[SyntaxKind2["VoidKeyword"] = 114] = "VoidKeyword";
        SyntaxKind2[SyntaxKind2["WhileKeyword"] = 115] = "WhileKeyword";
        SyntaxKind2[SyntaxKind2["WithKeyword"] = 116] = "WithKeyword";
        SyntaxKind2[SyntaxKind2["ImplementsKeyword"] = 117] = "ImplementsKeyword";
        SyntaxKind2[SyntaxKind2["InterfaceKeyword"] = 118] = "InterfaceKeyword";
        SyntaxKind2[SyntaxKind2["LetKeyword"] = 119] = "LetKeyword";
        SyntaxKind2[SyntaxKind2["PackageKeyword"] = 120] = "PackageKeyword";
        SyntaxKind2[SyntaxKind2["PrivateKeyword"] = 121] = "PrivateKeyword";
        SyntaxKind2[SyntaxKind2["ProtectedKeyword"] = 122] = "ProtectedKeyword";
        SyntaxKind2[SyntaxKind2["PublicKeyword"] = 123] = "PublicKeyword";
        SyntaxKind2[SyntaxKind2["StaticKeyword"] = 124] = "StaticKeyword";
        SyntaxKind2[SyntaxKind2["YieldKeyword"] = 125] = "YieldKeyword";
        SyntaxKind2[SyntaxKind2["AbstractKeyword"] = 126] = "AbstractKeyword";
        SyntaxKind2[SyntaxKind2["AsKeyword"] = 127] = "AsKeyword";
        SyntaxKind2[SyntaxKind2["AssertsKeyword"] = 128] = "AssertsKeyword";
        SyntaxKind2[SyntaxKind2["AssertKeyword"] = 129] = "AssertKeyword";
        SyntaxKind2[SyntaxKind2["AnyKeyword"] = 130] = "AnyKeyword";
        SyntaxKind2[SyntaxKind2["AsyncKeyword"] = 131] = "AsyncKeyword";
        SyntaxKind2[SyntaxKind2["AwaitKeyword"] = 132] = "AwaitKeyword";
        SyntaxKind2[SyntaxKind2["BooleanKeyword"] = 133] = "BooleanKeyword";
        SyntaxKind2[SyntaxKind2["ConstructorKeyword"] = 134] = "ConstructorKeyword";
        SyntaxKind2[SyntaxKind2["DeclareKeyword"] = 135] = "DeclareKeyword";
        SyntaxKind2[SyntaxKind2["GetKeyword"] = 136] = "GetKeyword";
        SyntaxKind2[SyntaxKind2["InferKeyword"] = 137] = "InferKeyword";
        SyntaxKind2[SyntaxKind2["IntrinsicKeyword"] = 138] = "IntrinsicKeyword";
        SyntaxKind2[SyntaxKind2["IsKeyword"] = 139] = "IsKeyword";
        SyntaxKind2[SyntaxKind2["KeyOfKeyword"] = 140] = "KeyOfKeyword";
        SyntaxKind2[SyntaxKind2["ModuleKeyword"] = 141] = "ModuleKeyword";
        SyntaxKind2[SyntaxKind2["NamespaceKeyword"] = 142] = "NamespaceKeyword";
        SyntaxKind2[SyntaxKind2["NeverKeyword"] = 143] = "NeverKeyword";
        SyntaxKind2[SyntaxKind2["OutKeyword"] = 144] = "OutKeyword";
        SyntaxKind2[SyntaxKind2["ReadonlyKeyword"] = 145] = "ReadonlyKeyword";
        SyntaxKind2[SyntaxKind2["RequireKeyword"] = 146] = "RequireKeyword";
        SyntaxKind2[SyntaxKind2["NumberKeyword"] = 147] = "NumberKeyword";
        SyntaxKind2[SyntaxKind2["ObjectKeyword"] = 148] = "ObjectKeyword";
        SyntaxKind2[SyntaxKind2["SetKeyword"] = 149] = "SetKeyword";
        SyntaxKind2[SyntaxKind2["StringKeyword"] = 150] = "StringKeyword";
        SyntaxKind2[SyntaxKind2["SymbolKeyword"] = 151] = "SymbolKeyword";
        SyntaxKind2[SyntaxKind2["TypeKeyword"] = 152] = "TypeKeyword";
        SyntaxKind2[SyntaxKind2["UndefinedKeyword"] = 153] = "UndefinedKeyword";
        SyntaxKind2[SyntaxKind2["UniqueKeyword"] = 154] = "UniqueKeyword";
        SyntaxKind2[SyntaxKind2["UnknownKeyword"] = 155] = "UnknownKeyword";
        SyntaxKind2[SyntaxKind2["FromKeyword"] = 156] = "FromKeyword";
        SyntaxKind2[SyntaxKind2["GlobalKeyword"] = 157] = "GlobalKeyword";
        SyntaxKind2[SyntaxKind2["BigIntKeyword"] = 158] = "BigIntKeyword";
        SyntaxKind2[SyntaxKind2["OverrideKeyword"] = 159] = "OverrideKeyword";
        SyntaxKind2[SyntaxKind2["OfKeyword"] = 160] = "OfKeyword";
        SyntaxKind2[SyntaxKind2["QualifiedName"] = 161] = "QualifiedName";
        SyntaxKind2[SyntaxKind2["ComputedPropertyName"] = 162] = "ComputedPropertyName";
        SyntaxKind2[SyntaxKind2["TypeParameter"] = 163] = "TypeParameter";
        SyntaxKind2[SyntaxKind2["Parameter"] = 164] = "Parameter";
        SyntaxKind2[SyntaxKind2["Decorator"] = 165] = "Decorator";
        SyntaxKind2[SyntaxKind2["PropertySignature"] = 166] = "PropertySignature";
        SyntaxKind2[SyntaxKind2["PropertyDeclaration"] = 167] = "PropertyDeclaration";
        SyntaxKind2[SyntaxKind2["MethodSignature"] = 168] = "MethodSignature";
        SyntaxKind2[SyntaxKind2["MethodDeclaration"] = 169] = "MethodDeclaration";
        SyntaxKind2[SyntaxKind2["ClassStaticBlockDeclaration"] = 170] = "ClassStaticBlockDeclaration";
        SyntaxKind2[SyntaxKind2["Constructor"] = 171] = "Constructor";
        SyntaxKind2[SyntaxKind2["GetAccessor"] = 172] = "GetAccessor";
        SyntaxKind2[SyntaxKind2["SetAccessor"] = 173] = "SetAccessor";
        SyntaxKind2[SyntaxKind2["CallSignature"] = 174] = "CallSignature";
        SyntaxKind2[SyntaxKind2["ConstructSignature"] = 175] = "ConstructSignature";
        SyntaxKind2[SyntaxKind2["IndexSignature"] = 176] = "IndexSignature";
        SyntaxKind2[SyntaxKind2["TypePredicate"] = 177] = "TypePredicate";
        SyntaxKind2[SyntaxKind2["TypeReference"] = 178] = "TypeReference";
        SyntaxKind2[SyntaxKind2["FunctionType"] = 179] = "FunctionType";
        SyntaxKind2[SyntaxKind2["ConstructorType"] = 180] = "ConstructorType";
        SyntaxKind2[SyntaxKind2["TypeQuery"] = 181] = "TypeQuery";
        SyntaxKind2[SyntaxKind2["TypeLiteral"] = 182] = "TypeLiteral";
        SyntaxKind2[SyntaxKind2["ArrayType"] = 183] = "ArrayType";
        SyntaxKind2[SyntaxKind2["TupleType"] = 184] = "TupleType";
        SyntaxKind2[SyntaxKind2["OptionalType"] = 185] = "OptionalType";
        SyntaxKind2[SyntaxKind2["RestType"] = 186] = "RestType";
        SyntaxKind2[SyntaxKind2["UnionType"] = 187] = "UnionType";
        SyntaxKind2[SyntaxKind2["IntersectionType"] = 188] = "IntersectionType";
        SyntaxKind2[SyntaxKind2["ConditionalType"] = 189] = "ConditionalType";
        SyntaxKind2[SyntaxKind2["InferType"] = 190] = "InferType";
        SyntaxKind2[SyntaxKind2["ParenthesizedType"] = 191] = "ParenthesizedType";
        SyntaxKind2[SyntaxKind2["ThisType"] = 192] = "ThisType";
        SyntaxKind2[SyntaxKind2["TypeOperator"] = 193] = "TypeOperator";
        SyntaxKind2[SyntaxKind2["IndexedAccessType"] = 194] = "IndexedAccessType";
        SyntaxKind2[SyntaxKind2["MappedType"] = 195] = "MappedType";
        SyntaxKind2[SyntaxKind2["LiteralType"] = 196] = "LiteralType";
        SyntaxKind2[SyntaxKind2["NamedTupleMember"] = 197] = "NamedTupleMember";
        SyntaxKind2[SyntaxKind2["TemplateLiteralType"] = 198] = "TemplateLiteralType";
        SyntaxKind2[SyntaxKind2["TemplateLiteralTypeSpan"] = 199] = "TemplateLiteralTypeSpan";
        SyntaxKind2[SyntaxKind2["ImportType"] = 200] = "ImportType";
        SyntaxKind2[SyntaxKind2["ObjectBindingPattern"] = 201] = "ObjectBindingPattern";
        SyntaxKind2[SyntaxKind2["ArrayBindingPattern"] = 202] = "ArrayBindingPattern";
        SyntaxKind2[SyntaxKind2["BindingElement"] = 203] = "BindingElement";
        SyntaxKind2[SyntaxKind2["ArrayLiteralExpression"] = 204] = "ArrayLiteralExpression";
        SyntaxKind2[SyntaxKind2["ObjectLiteralExpression"] = 205] = "ObjectLiteralExpression";
        SyntaxKind2[SyntaxKind2["PropertyAccessExpression"] = 206] = "PropertyAccessExpression";
        SyntaxKind2[SyntaxKind2["ElementAccessExpression"] = 207] = "ElementAccessExpression";
        SyntaxKind2[SyntaxKind2["CallExpression"] = 208] = "CallExpression";
        SyntaxKind2[SyntaxKind2["NewExpression"] = 209] = "NewExpression";
        SyntaxKind2[SyntaxKind2["TaggedTemplateExpression"] = 210] = "TaggedTemplateExpression";
        SyntaxKind2[SyntaxKind2["TypeAssertionExpression"] = 211] = "TypeAssertionExpression";
        SyntaxKind2[SyntaxKind2["ParenthesizedExpression"] = 212] = "ParenthesizedExpression";
        SyntaxKind2[SyntaxKind2["FunctionExpression"] = 213] = "FunctionExpression";
        SyntaxKind2[SyntaxKind2["ArrowFunction"] = 214] = "ArrowFunction";
        SyntaxKind2[SyntaxKind2["DeleteExpression"] = 215] = "DeleteExpression";
        SyntaxKind2[SyntaxKind2["TypeOfExpression"] = 216] = "TypeOfExpression";
        SyntaxKind2[SyntaxKind2["VoidExpression"] = 217] = "VoidExpression";
        SyntaxKind2[SyntaxKind2["AwaitExpression"] = 218] = "AwaitExpression";
        SyntaxKind2[SyntaxKind2["PrefixUnaryExpression"] = 219] = "PrefixUnaryExpression";
        SyntaxKind2[SyntaxKind2["PostfixUnaryExpression"] = 220] = "PostfixUnaryExpression";
        SyntaxKind2[SyntaxKind2["BinaryExpression"] = 221] = "BinaryExpression";
        SyntaxKind2[SyntaxKind2["ConditionalExpression"] = 222] = "ConditionalExpression";
        SyntaxKind2[SyntaxKind2["TemplateExpression"] = 223] = "TemplateExpression";
        SyntaxKind2[SyntaxKind2["YieldExpression"] = 224] = "YieldExpression";
        SyntaxKind2[SyntaxKind2["SpreadElement"] = 225] = "SpreadElement";
        SyntaxKind2[SyntaxKind2["ClassExpression"] = 226] = "ClassExpression";
        SyntaxKind2[SyntaxKind2["OmittedExpression"] = 227] = "OmittedExpression";
        SyntaxKind2[SyntaxKind2["ExpressionWithTypeArguments"] = 228] = "ExpressionWithTypeArguments";
        SyntaxKind2[SyntaxKind2["AsExpression"] = 229] = "AsExpression";
        SyntaxKind2[SyntaxKind2["NonNullExpression"] = 230] = "NonNullExpression";
        SyntaxKind2[SyntaxKind2["MetaProperty"] = 231] = "MetaProperty";
        SyntaxKind2[SyntaxKind2["SyntheticExpression"] = 232] = "SyntheticExpression";
        SyntaxKind2[SyntaxKind2["TemplateSpan"] = 233] = "TemplateSpan";
        SyntaxKind2[SyntaxKind2["SemicolonClassElement"] = 234] = "SemicolonClassElement";
        SyntaxKind2[SyntaxKind2["Block"] = 235] = "Block";
        SyntaxKind2[SyntaxKind2["EmptyStatement"] = 236] = "EmptyStatement";
        SyntaxKind2[SyntaxKind2["VariableStatement"] = 237] = "VariableStatement";
        SyntaxKind2[SyntaxKind2["ExpressionStatement"] = 238] = "ExpressionStatement";
        SyntaxKind2[SyntaxKind2["IfStatement"] = 239] = "IfStatement";
        SyntaxKind2[SyntaxKind2["DoStatement"] = 240] = "DoStatement";
        SyntaxKind2[SyntaxKind2["WhileStatement"] = 241] = "WhileStatement";
        SyntaxKind2[SyntaxKind2["ForStatement"] = 242] = "ForStatement";
        SyntaxKind2[SyntaxKind2["ForInStatement"] = 243] = "ForInStatement";
        SyntaxKind2[SyntaxKind2["ForOfStatement"] = 244] = "ForOfStatement";
        SyntaxKind2[SyntaxKind2["ContinueStatement"] = 245] = "ContinueStatement";
        SyntaxKind2[SyntaxKind2["BreakStatement"] = 246] = "BreakStatement";
        SyntaxKind2[SyntaxKind2["ReturnStatement"] = 247] = "ReturnStatement";
        SyntaxKind2[SyntaxKind2["WithStatement"] = 248] = "WithStatement";
        SyntaxKind2[SyntaxKind2["SwitchStatement"] = 249] = "SwitchStatement";
        SyntaxKind2[SyntaxKind2["LabeledStatement"] = 250] = "LabeledStatement";
        SyntaxKind2[SyntaxKind2["ThrowStatement"] = 251] = "ThrowStatement";
        SyntaxKind2[SyntaxKind2["TryStatement"] = 252] = "TryStatement";
        SyntaxKind2[SyntaxKind2["DebuggerStatement"] = 253] = "DebuggerStatement";
        SyntaxKind2[SyntaxKind2["VariableDeclaration"] = 254] = "VariableDeclaration";
        SyntaxKind2[SyntaxKind2["VariableDeclarationList"] = 255] = "VariableDeclarationList";
        SyntaxKind2[SyntaxKind2["FunctionDeclaration"] = 256] = "FunctionDeclaration";
        SyntaxKind2[SyntaxKind2["ClassDeclaration"] = 257] = "ClassDeclaration";
        SyntaxKind2[SyntaxKind2["InterfaceDeclaration"] = 258] = "InterfaceDeclaration";
        SyntaxKind2[SyntaxKind2["TypeAliasDeclaration"] = 259] = "TypeAliasDeclaration";
        SyntaxKind2[SyntaxKind2["EnumDeclaration"] = 260] = "EnumDeclaration";
        SyntaxKind2[SyntaxKind2["ModuleDeclaration"] = 261] = "ModuleDeclaration";
        SyntaxKind2[SyntaxKind2["ModuleBlock"] = 262] = "ModuleBlock";
        SyntaxKind2[SyntaxKind2["CaseBlock"] = 263] = "CaseBlock";
        SyntaxKind2[SyntaxKind2["NamespaceExportDeclaration"] = 264] = "NamespaceExportDeclaration";
        SyntaxKind2[SyntaxKind2["ImportEqualsDeclaration"] = 265] = "ImportEqualsDeclaration";
        SyntaxKind2[SyntaxKind2["ImportDeclaration"] = 266] = "ImportDeclaration";
        SyntaxKind2[SyntaxKind2["ImportClause"] = 267] = "ImportClause";
        SyntaxKind2[SyntaxKind2["NamespaceImport"] = 268] = "NamespaceImport";
        SyntaxKind2[SyntaxKind2["NamedImports"] = 269] = "NamedImports";
        SyntaxKind2[SyntaxKind2["ImportSpecifier"] = 270] = "ImportSpecifier";
        SyntaxKind2[SyntaxKind2["ExportAssignment"] = 271] = "ExportAssignment";
        SyntaxKind2[SyntaxKind2["ExportDeclaration"] = 272] = "ExportDeclaration";
        SyntaxKind2[SyntaxKind2["NamedExports"] = 273] = "NamedExports";
        SyntaxKind2[SyntaxKind2["NamespaceExport"] = 274] = "NamespaceExport";
        SyntaxKind2[SyntaxKind2["ExportSpecifier"] = 275] = "ExportSpecifier";
        SyntaxKind2[SyntaxKind2["MissingDeclaration"] = 276] = "MissingDeclaration";
        SyntaxKind2[SyntaxKind2["ExternalModuleReference"] = 277] = "ExternalModuleReference";
        SyntaxKind2[SyntaxKind2["JsxElement"] = 278] = "JsxElement";
        SyntaxKind2[SyntaxKind2["JsxSelfClosingElement"] = 279] = "JsxSelfClosingElement";
        SyntaxKind2[SyntaxKind2["JsxOpeningElement"] = 280] = "JsxOpeningElement";
        SyntaxKind2[SyntaxKind2["JsxClosingElement"] = 281] = "JsxClosingElement";
        SyntaxKind2[SyntaxKind2["JsxFragment"] = 282] = "JsxFragment";
        SyntaxKind2[SyntaxKind2["JsxOpeningFragment"] = 283] = "JsxOpeningFragment";
        SyntaxKind2[SyntaxKind2["JsxClosingFragment"] = 284] = "JsxClosingFragment";
        SyntaxKind2[SyntaxKind2["JsxAttribute"] = 285] = "JsxAttribute";
        SyntaxKind2[SyntaxKind2["JsxAttributes"] = 286] = "JsxAttributes";
        SyntaxKind2[SyntaxKind2["JsxSpreadAttribute"] = 287] = "JsxSpreadAttribute";
        SyntaxKind2[SyntaxKind2["JsxExpression"] = 288] = "JsxExpression";
        SyntaxKind2[SyntaxKind2["CaseClause"] = 289] = "CaseClause";
        SyntaxKind2[SyntaxKind2["DefaultClause"] = 290] = "DefaultClause";
        SyntaxKind2[SyntaxKind2["HeritageClause"] = 291] = "HeritageClause";
        SyntaxKind2[SyntaxKind2["CatchClause"] = 292] = "CatchClause";
        SyntaxKind2[SyntaxKind2["AssertClause"] = 293] = "AssertClause";
        SyntaxKind2[SyntaxKind2["AssertEntry"] = 294] = "AssertEntry";
        SyntaxKind2[SyntaxKind2["ImportTypeAssertionContainer"] = 295] = "ImportTypeAssertionContainer";
        SyntaxKind2[SyntaxKind2["PropertyAssignment"] = 296] = "PropertyAssignment";
        SyntaxKind2[SyntaxKind2["ShorthandPropertyAssignment"] = 297] = "ShorthandPropertyAssignment";
        SyntaxKind2[SyntaxKind2["SpreadAssignment"] = 298] = "SpreadAssignment";
        SyntaxKind2[SyntaxKind2["EnumMember"] = 299] = "EnumMember";
        SyntaxKind2[SyntaxKind2["UnparsedPrologue"] = 300] = "UnparsedPrologue";
        SyntaxKind2[SyntaxKind2["UnparsedPrepend"] = 301] = "UnparsedPrepend";
        SyntaxKind2[SyntaxKind2["UnparsedText"] = 302] = "UnparsedText";
        SyntaxKind2[SyntaxKind2["UnparsedInternalText"] = 303] = "UnparsedInternalText";
        SyntaxKind2[SyntaxKind2["UnparsedSyntheticReference"] = 304] = "UnparsedSyntheticReference";
        SyntaxKind2[SyntaxKind2["SourceFile"] = 305] = "SourceFile";
        SyntaxKind2[SyntaxKind2["Bundle"] = 306] = "Bundle";
        SyntaxKind2[SyntaxKind2["UnparsedSource"] = 307] = "UnparsedSource";
        SyntaxKind2[SyntaxKind2["InputFiles"] = 308] = "InputFiles";
        SyntaxKind2[SyntaxKind2["JSDocTypeExpression"] = 309] = "JSDocTypeExpression";
        SyntaxKind2[SyntaxKind2["JSDocNameReference"] = 310] = "JSDocNameReference";
        SyntaxKind2[SyntaxKind2["JSDocMemberName"] = 311] = "JSDocMemberName";
        SyntaxKind2[SyntaxKind2["JSDocAllType"] = 312] = "JSDocAllType";
        SyntaxKind2[SyntaxKind2["JSDocUnknownType"] = 313] = "JSDocUnknownType";
        SyntaxKind2[SyntaxKind2["JSDocNullableType"] = 314] = "JSDocNullableType";
        SyntaxKind2[SyntaxKind2["JSDocNonNullableType"] = 315] = "JSDocNonNullableType";
        SyntaxKind2[SyntaxKind2["JSDocOptionalType"] = 316] = "JSDocOptionalType";
        SyntaxKind2[SyntaxKind2["JSDocFunctionType"] = 317] = "JSDocFunctionType";
        SyntaxKind2[SyntaxKind2["JSDocVariadicType"] = 318] = "JSDocVariadicType";
        SyntaxKind2[SyntaxKind2["JSDocNamepathType"] = 319] = "JSDocNamepathType";
        SyntaxKind2[SyntaxKind2["JSDoc"] = 320] = "JSDoc";
        SyntaxKind2[SyntaxKind2["JSDocComment"] = 320] = "JSDocComment";
        SyntaxKind2[SyntaxKind2["JSDocText"] = 321] = "JSDocText";
        SyntaxKind2[SyntaxKind2["JSDocTypeLiteral"] = 322] = "JSDocTypeLiteral";
        SyntaxKind2[SyntaxKind2["JSDocSignature"] = 323] = "JSDocSignature";
        SyntaxKind2[SyntaxKind2["JSDocLink"] = 324] = "JSDocLink";
        SyntaxKind2[SyntaxKind2["JSDocLinkCode"] = 325] = "JSDocLinkCode";
        SyntaxKind2[SyntaxKind2["JSDocLinkPlain"] = 326] = "JSDocLinkPlain";
        SyntaxKind2[SyntaxKind2["JSDocTag"] = 327] = "JSDocTag";
        SyntaxKind2[SyntaxKind2["JSDocAugmentsTag"] = 328] = "JSDocAugmentsTag";
        SyntaxKind2[SyntaxKind2["JSDocImplementsTag"] = 329] = "JSDocImplementsTag";
        SyntaxKind2[SyntaxKind2["JSDocAuthorTag"] = 330] = "JSDocAuthorTag";
        SyntaxKind2[SyntaxKind2["JSDocDeprecatedTag"] = 331] = "JSDocDeprecatedTag";
        SyntaxKind2[SyntaxKind2["JSDocClassTag"] = 332] = "JSDocClassTag";
        SyntaxKind2[SyntaxKind2["JSDocPublicTag"] = 333] = "JSDocPublicTag";
        SyntaxKind2[SyntaxKind2["JSDocPrivateTag"] = 334] = "JSDocPrivateTag";
        SyntaxKind2[SyntaxKind2["JSDocProtectedTag"] = 335] = "JSDocProtectedTag";
        SyntaxKind2[SyntaxKind2["JSDocReadonlyTag"] = 336] = "JSDocReadonlyTag";
        SyntaxKind2[SyntaxKind2["JSDocOverrideTag"] = 337] = "JSDocOverrideTag";
        SyntaxKind2[SyntaxKind2["JSDocCallbackTag"] = 338] = "JSDocCallbackTag";
        SyntaxKind2[SyntaxKind2["JSDocEnumTag"] = 339] = "JSDocEnumTag";
        SyntaxKind2[SyntaxKind2["JSDocParameterTag"] = 340] = "JSDocParameterTag";
        SyntaxKind2[SyntaxKind2["JSDocReturnTag"] = 341] = "JSDocReturnTag";
        SyntaxKind2[SyntaxKind2["JSDocThisTag"] = 342] = "JSDocThisTag";
        SyntaxKind2[SyntaxKind2["JSDocTypeTag"] = 343] = "JSDocTypeTag";
        SyntaxKind2[SyntaxKind2["JSDocTemplateTag"] = 344] = "JSDocTemplateTag";
        SyntaxKind2[SyntaxKind2["JSDocTypedefTag"] = 345] = "JSDocTypedefTag";
        SyntaxKind2[SyntaxKind2["JSDocSeeTag"] = 346] = "JSDocSeeTag";
        SyntaxKind2[SyntaxKind2["JSDocPropertyTag"] = 347] = "JSDocPropertyTag";
        SyntaxKind2[SyntaxKind2["SyntaxList"] = 348] = "SyntaxList";
        SyntaxKind2[SyntaxKind2["NotEmittedStatement"] = 349] = "NotEmittedStatement";
        SyntaxKind2[SyntaxKind2["PartiallyEmittedExpression"] = 350] = "PartiallyEmittedExpression";
        SyntaxKind2[SyntaxKind2["CommaListExpression"] = 351] = "CommaListExpression";
        SyntaxKind2[SyntaxKind2["MergeDeclarationMarker"] = 352] = "MergeDeclarationMarker";
        SyntaxKind2[SyntaxKind2["EndOfDeclarationMarker"] = 353] = "EndOfDeclarationMarker";
        SyntaxKind2[SyntaxKind2["SyntheticReferenceExpression"] = 354] = "SyntheticReferenceExpression";
        SyntaxKind2[SyntaxKind2["Count"] = 355] = "Count";
        SyntaxKind2[SyntaxKind2["FirstAssignment"] = 63] = "FirstAssignment";
        SyntaxKind2[SyntaxKind2["LastAssignment"] = 78] = "LastAssignment";
        SyntaxKind2[SyntaxKind2["FirstCompoundAssignment"] = 64] = "FirstCompoundAssignment";
        SyntaxKind2[SyntaxKind2["LastCompoundAssignment"] = 78] = "LastCompoundAssignment";
        SyntaxKind2[SyntaxKind2["FirstReservedWord"] = 81] = "FirstReservedWord";
        SyntaxKind2[SyntaxKind2["LastReservedWord"] = 116] = "LastReservedWord";
        SyntaxKind2[SyntaxKind2["FirstKeyword"] = 81] = "FirstKeyword";
        SyntaxKind2[SyntaxKind2["LastKeyword"] = 160] = "LastKeyword";
        SyntaxKind2[SyntaxKind2["FirstFutureReservedWord"] = 117] = "FirstFutureReservedWord";
        SyntaxKind2[SyntaxKind2["LastFutureReservedWord"] = 125] = "LastFutureReservedWord";
        SyntaxKind2[SyntaxKind2["FirstTypeNode"] = 177] = "FirstTypeNode";
        SyntaxKind2[SyntaxKind2["LastTypeNode"] = 200] = "LastTypeNode";
        SyntaxKind2[SyntaxKind2["FirstPunctuation"] = 18] = "FirstPunctuation";
        SyntaxKind2[SyntaxKind2["LastPunctuation"] = 78] = "LastPunctuation";
        SyntaxKind2[SyntaxKind2["FirstToken"] = 0] = "FirstToken";
        SyntaxKind2[SyntaxKind2["LastToken"] = 160] = "LastToken";
        SyntaxKind2[SyntaxKind2["FirstTriviaToken"] = 2] = "FirstTriviaToken";
        SyntaxKind2[SyntaxKind2["LastTriviaToken"] = 7] = "LastTriviaToken";
        SyntaxKind2[SyntaxKind2["FirstLiteralToken"] = 8] = "FirstLiteralToken";
        SyntaxKind2[SyntaxKind2["LastLiteralToken"] = 14] = "LastLiteralToken";
        SyntaxKind2[SyntaxKind2["FirstTemplateToken"] = 14] = "FirstTemplateToken";
        SyntaxKind2[SyntaxKind2["LastTemplateToken"] = 17] = "LastTemplateToken";
        SyntaxKind2[SyntaxKind2["FirstBinaryOperator"] = 29] = "FirstBinaryOperator";
        SyntaxKind2[SyntaxKind2["LastBinaryOperator"] = 78] = "LastBinaryOperator";
        SyntaxKind2[SyntaxKind2["FirstStatement"] = 237] = "FirstStatement";
        SyntaxKind2[SyntaxKind2["LastStatement"] = 253] = "LastStatement";
        SyntaxKind2[SyntaxKind2["FirstNode"] = 161] = "FirstNode";
        SyntaxKind2[SyntaxKind2["FirstJSDocNode"] = 309] = "FirstJSDocNode";
        SyntaxKind2[SyntaxKind2["LastJSDocNode"] = 347] = "LastJSDocNode";
        SyntaxKind2[SyntaxKind2["FirstJSDocTagNode"] = 327] = "FirstJSDocTagNode";
        SyntaxKind2[SyntaxKind2["LastJSDocTagNode"] = 347] = "LastJSDocTagNode";
        SyntaxKind2[SyntaxKind2["FirstContextualKeyword"] = 126] = "FirstContextualKeyword";
        SyntaxKind2[SyntaxKind2["LastContextualKeyword"] = 160] = "LastContextualKeyword";
      })(SyntaxKind = ts2.SyntaxKind || (ts2.SyntaxKind = {}));
      var NodeFlags;
      (function(NodeFlags2) {
        NodeFlags2[NodeFlags2["None"] = 0] = "None";
        NodeFlags2[NodeFlags2["Let"] = 1] = "Let";
        NodeFlags2[NodeFlags2["Const"] = 2] = "Const";
        NodeFlags2[NodeFlags2["NestedNamespace"] = 4] = "NestedNamespace";
        NodeFlags2[NodeFlags2["Synthesized"] = 8] = "Synthesized";
        NodeFlags2[NodeFlags2["Namespace"] = 16] = "Namespace";
        NodeFlags2[NodeFlags2["OptionalChain"] = 32] = "OptionalChain";
        NodeFlags2[NodeFlags2["ExportContext"] = 64] = "ExportContext";
        NodeFlags2[NodeFlags2["ContainsThis"] = 128] = "ContainsThis";
        NodeFlags2[NodeFlags2["HasImplicitReturn"] = 256] = "HasImplicitReturn";
        NodeFlags2[NodeFlags2["HasExplicitReturn"] = 512] = "HasExplicitReturn";
        NodeFlags2[NodeFlags2["GlobalAugmentation"] = 1024] = "GlobalAugmentation";
        NodeFlags2[NodeFlags2["HasAsyncFunctions"] = 2048] = "HasAsyncFunctions";
        NodeFlags2[NodeFlags2["DisallowInContext"] = 4096] = "DisallowInContext";
        NodeFlags2[NodeFlags2["YieldContext"] = 8192] = "YieldContext";
        NodeFlags2[NodeFlags2["DecoratorContext"] = 16384] = "DecoratorContext";
        NodeFlags2[NodeFlags2["AwaitContext"] = 32768] = "AwaitContext";
        NodeFlags2[NodeFlags2["DisallowConditionalTypesContext"] = 65536] = "DisallowConditionalTypesContext";
        NodeFlags2[NodeFlags2["ThisNodeHasError"] = 131072] = "ThisNodeHasError";
        NodeFlags2[NodeFlags2["JavaScriptFile"] = 262144] = "JavaScriptFile";
        NodeFlags2[NodeFlags2["ThisNodeOrAnySubNodesHasError"] = 524288] = "ThisNodeOrAnySubNodesHasError";
        NodeFlags2[NodeFlags2["HasAggregatedChildData"] = 1048576] = "HasAggregatedChildData";
        NodeFlags2[NodeFlags2["PossiblyContainsDynamicImport"] = 2097152] = "PossiblyContainsDynamicImport";
        NodeFlags2[NodeFlags2["PossiblyContainsImportMeta"] = 4194304] = "PossiblyContainsImportMeta";
        NodeFlags2[NodeFlags2["JSDoc"] = 8388608] = "JSDoc";
        NodeFlags2[NodeFlags2["Ambient"] = 16777216] = "Ambient";
        NodeFlags2[NodeFlags2["InWithStatement"] = 33554432] = "InWithStatement";
        NodeFlags2[NodeFlags2["JsonFile"] = 67108864] = "JsonFile";
        NodeFlags2[NodeFlags2["TypeCached"] = 134217728] = "TypeCached";
        NodeFlags2[NodeFlags2["Deprecated"] = 268435456] = "Deprecated";
        NodeFlags2[NodeFlags2["BlockScoped"] = 3] = "BlockScoped";
        NodeFlags2[NodeFlags2["ReachabilityCheckFlags"] = 768] = "ReachabilityCheckFlags";
        NodeFlags2[NodeFlags2["ReachabilityAndEmitFlags"] = 2816] = "ReachabilityAndEmitFlags";
        NodeFlags2[NodeFlags2["ContextFlags"] = 50720768] = "ContextFlags";
        NodeFlags2[NodeFlags2["TypeExcludesFlags"] = 40960] = "TypeExcludesFlags";
        NodeFlags2[NodeFlags2["PermanentlySetIncrementalFlags"] = 6291456] = "PermanentlySetIncrementalFlags";
      })(NodeFlags = ts2.NodeFlags || (ts2.NodeFlags = {}));
      var ModifierFlags;
      (function(ModifierFlags2) {
        ModifierFlags2[ModifierFlags2["None"] = 0] = "None";
        ModifierFlags2[ModifierFlags2["Export"] = 1] = "Export";
        ModifierFlags2[ModifierFlags2["Ambient"] = 2] = "Ambient";
        ModifierFlags2[ModifierFlags2["Public"] = 4] = "Public";
        ModifierFlags2[ModifierFlags2["Private"] = 8] = "Private";
        ModifierFlags2[ModifierFlags2["Protected"] = 16] = "Protected";
        ModifierFlags2[ModifierFlags2["Static"] = 32] = "Static";
        ModifierFlags2[ModifierFlags2["Readonly"] = 64] = "Readonly";
        ModifierFlags2[ModifierFlags2["Abstract"] = 128] = "Abstract";
        ModifierFlags2[ModifierFlags2["Async"] = 256] = "Async";
        ModifierFlags2[ModifierFlags2["Default"] = 512] = "Default";
        ModifierFlags2[ModifierFlags2["Const"] = 2048] = "Const";
        ModifierFlags2[ModifierFlags2["HasComputedJSDocModifiers"] = 4096] = "HasComputedJSDocModifiers";
        ModifierFlags2[ModifierFlags2["Deprecated"] = 8192] = "Deprecated";
        ModifierFlags2[ModifierFlags2["Override"] = 16384] = "Override";
        ModifierFlags2[ModifierFlags2["In"] = 32768] = "In";
        ModifierFlags2[ModifierFlags2["Out"] = 65536] = "Out";
        ModifierFlags2[ModifierFlags2["Decorator"] = 131072] = "Decorator";
        ModifierFlags2[ModifierFlags2["HasComputedFlags"] = 536870912] = "HasComputedFlags";
        ModifierFlags2[ModifierFlags2["AccessibilityModifier"] = 28] = "AccessibilityModifier";
        ModifierFlags2[ModifierFlags2["ParameterPropertyModifier"] = 16476] = "ParameterPropertyModifier";
        ModifierFlags2[ModifierFlags2["NonPublicAccessibilityModifier"] = 24] = "NonPublicAccessibilityModifier";
        ModifierFlags2[ModifierFlags2["TypeScriptModifier"] = 116958] = "TypeScriptModifier";
        ModifierFlags2[ModifierFlags2["ExportDefault"] = 513] = "ExportDefault";
        ModifierFlags2[ModifierFlags2["All"] = 257023] = "All";
        ModifierFlags2[ModifierFlags2["Modifier"] = 125951] = "Modifier";
      })(ModifierFlags = ts2.ModifierFlags || (ts2.ModifierFlags = {}));
      var JsxFlags;
      (function(JsxFlags2) {
        JsxFlags2[JsxFlags2["None"] = 0] = "None";
        JsxFlags2[JsxFlags2["IntrinsicNamedElement"] = 1] = "IntrinsicNamedElement";
        JsxFlags2[JsxFlags2["IntrinsicIndexedElement"] = 2] = "IntrinsicIndexedElement";
        JsxFlags2[JsxFlags2["IntrinsicElement"] = 3] = "IntrinsicElement";
      })(JsxFlags = ts2.JsxFlags || (ts2.JsxFlags = {}));
      var RelationComparisonResult;
      (function(RelationComparisonResult2) {
        RelationComparisonResult2[RelationComparisonResult2["Succeeded"] = 1] = "Succeeded";
        RelationComparisonResult2[RelationComparisonResult2["Failed"] = 2] = "Failed";
        RelationComparisonResult2[RelationComparisonResult2["Reported"] = 4] = "Reported";
        RelationComparisonResult2[RelationComparisonResult2["ReportsUnmeasurable"] = 8] = "ReportsUnmeasurable";
        RelationComparisonResult2[RelationComparisonResult2["ReportsUnreliable"] = 16] = "ReportsUnreliable";
        RelationComparisonResult2[RelationComparisonResult2["ReportsMask"] = 24] = "ReportsMask";
      })(RelationComparisonResult = ts2.RelationComparisonResult || (ts2.RelationComparisonResult = {}));
      var GeneratedIdentifierFlags;
      (function(GeneratedIdentifierFlags2) {
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["None"] = 0] = "None";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Auto"] = 1] = "Auto";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Loop"] = 2] = "Loop";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Unique"] = 3] = "Unique";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Node"] = 4] = "Node";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["KindMask"] = 7] = "KindMask";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["ReservedInNestedScopes"] = 8] = "ReservedInNestedScopes";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["Optimistic"] = 16] = "Optimistic";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["FileLevel"] = 32] = "FileLevel";
        GeneratedIdentifierFlags2[GeneratedIdentifierFlags2["AllowNameSubstitution"] = 64] = "AllowNameSubstitution";
      })(GeneratedIdentifierFlags = ts2.GeneratedIdentifierFlags || (ts2.GeneratedIdentifierFlags = {}));
      var TokenFlags;
      (function(TokenFlags2) {
        TokenFlags2[TokenFlags2["None"] = 0] = "None";
        TokenFlags2[TokenFlags2["PrecedingLineBreak"] = 1] = "PrecedingLineBreak";
        TokenFlags2[TokenFlags2["PrecedingJSDocComment"] = 2] = "PrecedingJSDocComment";
        TokenFlags2[TokenFlags2["Unterminated"] = 4] = "Unterminated";
        TokenFlags2[TokenFlags2["ExtendedUnicodeEscape"] = 8] = "ExtendedUnicodeEscape";
        TokenFlags2[TokenFlags2["Scientific"] = 16] = "Scientific";
        TokenFlags2[TokenFlags2["Octal"] = 32] = "Octal";
        TokenFlags2[TokenFlags2["HexSpecifier"] = 64] = "HexSpecifier";
        TokenFlags2[TokenFlags2["BinarySpecifier"] = 128] = "BinarySpecifier";
        TokenFlags2[TokenFlags2["OctalSpecifier"] = 256] = "OctalSpecifier";
        TokenFlags2[TokenFlags2["ContainsSeparator"] = 512] = "ContainsSeparator";
        TokenFlags2[TokenFlags2["UnicodeEscape"] = 1024] = "UnicodeEscape";
        TokenFlags2[TokenFlags2["ContainsInvalidEscape"] = 2048] = "ContainsInvalidEscape";
        TokenFlags2[TokenFlags2["BinaryOrOctalSpecifier"] = 384] = "BinaryOrOctalSpecifier";
        TokenFlags2[TokenFlags2["NumericLiteralFlags"] = 1008] = "NumericLiteralFlags";
        TokenFlags2[TokenFlags2["TemplateLiteralLikeFlags"] = 2048] = "TemplateLiteralLikeFlags";
      })(TokenFlags = ts2.TokenFlags || (ts2.TokenFlags = {}));
      var FlowFlags;
      (function(FlowFlags2) {
        FlowFlags2[FlowFlags2["Unreachable"] = 1] = "Unreachable";
        FlowFlags2[FlowFlags2["Start"] = 2] = "Start";
        FlowFlags2[FlowFlags2["BranchLabel"] = 4] = "BranchLabel";
        FlowFlags2[FlowFlags2["LoopLabel"] = 8] = "LoopLabel";
        FlowFlags2[FlowFlags2["Assignment"] = 16] = "Assignment";
        FlowFlags2[FlowFlags2["TrueCondition"] = 32] = "TrueCondition";
        FlowFlags2[FlowFlags2["FalseCondition"] = 64] = "FalseCondition";
        FlowFlags2[FlowFlags2["SwitchClause"] = 128] = "SwitchClause";
        FlowFlags2[FlowFlags2["ArrayMutation"] = 256] = "ArrayMutation";
        FlowFlags2[FlowFlags2["Call"] = 512] = "Call";
        FlowFlags2[FlowFlags2["ReduceLabel"] = 1024] = "ReduceLabel";
        FlowFlags2[FlowFlags2["Referenced"] = 2048] = "Referenced";
        FlowFlags2[FlowFlags2["Shared"] = 4096] = "Shared";
        FlowFlags2[FlowFlags2["Label"] = 12] = "Label";
        FlowFlags2[FlowFlags2["Condition"] = 96] = "Condition";
      })(FlowFlags = ts2.FlowFlags || (ts2.FlowFlags = {}));
      var CommentDirectiveType;
      (function(CommentDirectiveType2) {
        CommentDirectiveType2[CommentDirectiveType2["ExpectError"] = 0] = "ExpectError";
        CommentDirectiveType2[CommentDirectiveType2["Ignore"] = 1] = "Ignore";
      })(CommentDirectiveType = ts2.CommentDirectiveType || (ts2.CommentDirectiveType = {}));
      var OperationCanceledException = function() {
        function OperationCanceledException2() {
        }
        return OperationCanceledException2;
      }();
      ts2.OperationCanceledException = OperationCanceledException;
      var FileIncludeKind;
      (function(FileIncludeKind2) {
        FileIncludeKind2[FileIncludeKind2["RootFile"] = 0] = "RootFile";
        FileIncludeKind2[FileIncludeKind2["SourceFromProjectReference"] = 1] = "SourceFromProjectReference";
        FileIncludeKind2[FileIncludeKind2["OutputFromProjectReference"] = 2] = "OutputFromProjectReference";
        FileIncludeKind2[FileIncludeKind2["Import"] = 3] = "Import";
        FileIncludeKind2[FileIncludeKind2["ReferenceFile"] = 4] = "ReferenceFile";
        FileIncludeKind2[FileIncludeKind2["TypeReferenceDirective"] = 5] = "TypeReferenceDirective";
        FileIncludeKind2[FileIncludeKind2["LibFile"] = 6] = "LibFile";
        FileIncludeKind2[FileIncludeKind2["LibReferenceDirective"] = 7] = "LibReferenceDirective";
        FileIncludeKind2[FileIncludeKind2["AutomaticTypeDirectiveFile"] = 8] = "AutomaticTypeDirectiveFile";
      })(FileIncludeKind = ts2.FileIncludeKind || (ts2.FileIncludeKind = {}));
      var FilePreprocessingDiagnosticsKind;
      (function(FilePreprocessingDiagnosticsKind2) {
        FilePreprocessingDiagnosticsKind2[FilePreprocessingDiagnosticsKind2["FilePreprocessingReferencedDiagnostic"] = 0] = "FilePreprocessingReferencedDiagnostic";
        FilePreprocessingDiagnosticsKind2[FilePreprocessingDiagnosticsKind2["FilePreprocessingFileExplainingDiagnostic"] = 1] = "FilePreprocessingFileExplainingDiagnostic";
      })(FilePreprocessingDiagnosticsKind = ts2.FilePreprocessingDiagnosticsKind || (ts2.FilePreprocessingDiagnosticsKind = {}));
      var StructureIsReused;
      (function(StructureIsReused2) {
        StructureIsReused2[StructureIsReused2["Not"] = 0] = "Not";
        StructureIsReused2[StructureIsReused2["SafeModules"] = 1] = "SafeModules";
        StructureIsReused2[StructureIsReused2["Completely"] = 2] = "Completely";
      })(StructureIsReused = ts2.StructureIsReused || (ts2.StructureIsReused = {}));
      var ExitStatus;
      (function(ExitStatus2) {
        ExitStatus2[ExitStatus2["Success"] = 0] = "Success";
        ExitStatus2[ExitStatus2["DiagnosticsPresent_OutputsSkipped"] = 1] = "DiagnosticsPresent_OutputsSkipped";
        ExitStatus2[ExitStatus2["DiagnosticsPresent_OutputsGenerated"] = 2] = "DiagnosticsPresent_OutputsGenerated";
        ExitStatus2[ExitStatus2["InvalidProject_OutputsSkipped"] = 3] = "InvalidProject_OutputsSkipped";
        ExitStatus2[ExitStatus2["ProjectReferenceCycle_OutputsSkipped"] = 4] = "ProjectReferenceCycle_OutputsSkipped";
        ExitStatus2[ExitStatus2["ProjectReferenceCycle_OutputsSkupped"] = 4] = "ProjectReferenceCycle_OutputsSkupped";
      })(ExitStatus = ts2.ExitStatus || (ts2.ExitStatus = {}));
      var MemberOverrideStatus;
      (function(MemberOverrideStatus2) {
        MemberOverrideStatus2[MemberOverrideStatus2["Ok"] = 0] = "Ok";
        MemberOverrideStatus2[MemberOverrideStatus2["NeedsOverride"] = 1] = "NeedsOverride";
        MemberOverrideStatus2[MemberOverrideStatus2["HasInvalidOverride"] = 2] = "HasInvalidOverride";
      })(MemberOverrideStatus = ts2.MemberOverrideStatus || (ts2.MemberOverrideStatus = {}));
      var UnionReduction;
      (function(UnionReduction2) {
        UnionReduction2[UnionReduction2["None"] = 0] = "None";
        UnionReduction2[UnionReduction2["Literal"] = 1] = "Literal";
        UnionReduction2[UnionReduction2["Subtype"] = 2] = "Subtype";
      })(UnionReduction = ts2.UnionReduction || (ts2.UnionReduction = {}));
      var ContextFlags;
      (function(ContextFlags2) {
        ContextFlags2[ContextFlags2["None"] = 0] = "None";
        ContextFlags2[ContextFlags2["Signature"] = 1] = "Signature";
        ContextFlags2[ContextFlags2["NoConstraints"] = 2] = "NoConstraints";
        ContextFlags2[ContextFlags2["Completions"] = 4] = "Completions";
        ContextFlags2[ContextFlags2["SkipBindingPatterns"] = 8] = "SkipBindingPatterns";
      })(ContextFlags = ts2.ContextFlags || (ts2.ContextFlags = {}));
      var NodeBuilderFlags;
      (function(NodeBuilderFlags2) {
        NodeBuilderFlags2[NodeBuilderFlags2["None"] = 0] = "None";
        NodeBuilderFlags2[NodeBuilderFlags2["NoTruncation"] = 1] = "NoTruncation";
        NodeBuilderFlags2[NodeBuilderFlags2["WriteArrayAsGenericType"] = 2] = "WriteArrayAsGenericType";
        NodeBuilderFlags2[NodeBuilderFlags2["GenerateNamesForShadowedTypeParams"] = 4] = "GenerateNamesForShadowedTypeParams";
        NodeBuilderFlags2[NodeBuilderFlags2["UseStructuralFallback"] = 8] = "UseStructuralFallback";
        NodeBuilderFlags2[NodeBuilderFlags2["ForbidIndexedAccessSymbolReferences"] = 16] = "ForbidIndexedAccessSymbolReferences";
        NodeBuilderFlags2[NodeBuilderFlags2["WriteTypeArgumentsOfSignature"] = 32] = "WriteTypeArgumentsOfSignature";
        NodeBuilderFlags2[NodeBuilderFlags2["UseFullyQualifiedType"] = 64] = "UseFullyQualifiedType";
        NodeBuilderFlags2[NodeBuilderFlags2["UseOnlyExternalAliasing"] = 128] = "UseOnlyExternalAliasing";
        NodeBuilderFlags2[NodeBuilderFlags2["SuppressAnyReturnType"] = 256] = "SuppressAnyReturnType";
        NodeBuilderFlags2[NodeBuilderFlags2["WriteTypeParametersInQualifiedName"] = 512] = "WriteTypeParametersInQualifiedName";
        NodeBuilderFlags2[NodeBuilderFlags2["MultilineObjectLiterals"] = 1024] = "MultilineObjectLiterals";
        NodeBuilderFlags2[NodeBuilderFlags2["WriteClassExpressionAsTypeLiteral"] = 2048] = "WriteClassExpressionAsTypeLiteral";
        NodeBuilderFlags2[NodeBuilderFlags2["UseTypeOfFunction"] = 4096] = "UseTypeOfFunction";
        NodeBuilderFlags2[NodeBuilderFlags2["OmitParameterModifiers"] = 8192] = "OmitParameterModifiers";
        NodeBuilderFlags2[NodeBuilderFlags2["UseAliasDefinedOutsideCurrentScope"] = 16384] = "UseAliasDefinedOutsideCurrentScope";
        NodeBuilderFlags2[NodeBuilderFlags2["UseSingleQuotesForStringLiteralType"] = 268435456] = "UseSingleQuotesForStringLiteralType";
        NodeBuilderFlags2[NodeBuilderFlags2["NoTypeReduction"] = 536870912] = "NoTypeReduction";
        NodeBuilderFlags2[NodeBuilderFlags2["OmitThisParameter"] = 33554432] = "OmitThisParameter";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowThisInObjectLiteral"] = 32768] = "AllowThisInObjectLiteral";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowQualifiedNameInPlaceOfIdentifier"] = 65536] = "AllowQualifiedNameInPlaceOfIdentifier";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowQualifedNameInPlaceOfIdentifier"] = 65536] = "AllowQualifedNameInPlaceOfIdentifier";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowAnonymousIdentifier"] = 131072] = "AllowAnonymousIdentifier";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyUnionOrIntersection"] = 262144] = "AllowEmptyUnionOrIntersection";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyTuple"] = 524288] = "AllowEmptyTuple";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowUniqueESSymbolType"] = 1048576] = "AllowUniqueESSymbolType";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowEmptyIndexInfoType"] = 2097152] = "AllowEmptyIndexInfoType";
        NodeBuilderFlags2[NodeBuilderFlags2["AllowNodeModulesRelativePaths"] = 67108864] = "AllowNodeModulesRelativePaths";
        NodeBuilderFlags2[NodeBuilderFlags2["DoNotIncludeSymbolChain"] = 134217728] = "DoNotIncludeSymbolChain";
        NodeBuilderFlags2[NodeBuilderFlags2["IgnoreErrors"] = 70221824] = "IgnoreErrors";
        NodeBuilderFlags2[NodeBuilderFlags2["InObjectTypeLiteral"] = 4194304] = "InObjectTypeLiteral";
        NodeBuilderFlags2[NodeBuilderFlags2["InTypeAlias"] = 8388608] = "InTypeAlias";
        NodeBuilderFlags2[NodeBuilderFlags2["InInitialEntityName"] = 16777216] = "InInitialEntityName";
      })(NodeBuilderFlags = ts2.NodeBuilderFlags || (ts2.NodeBuilderFlags = {}));
      var TypeFormatFlags;
      (function(TypeFormatFlags2) {
        TypeFormatFlags2[TypeFormatFlags2["None"] = 0] = "None";
        TypeFormatFlags2[TypeFormatFlags2["NoTruncation"] = 1] = "NoTruncation";
        TypeFormatFlags2[TypeFormatFlags2["WriteArrayAsGenericType"] = 2] = "WriteArrayAsGenericType";
        TypeFormatFlags2[TypeFormatFlags2["UseStructuralFallback"] = 8] = "UseStructuralFallback";
        TypeFormatFlags2[TypeFormatFlags2["WriteTypeArgumentsOfSignature"] = 32] = "WriteTypeArgumentsOfSignature";
        TypeFormatFlags2[TypeFormatFlags2["UseFullyQualifiedType"] = 64] = "UseFullyQualifiedType";
        TypeFormatFlags2[TypeFormatFlags2["SuppressAnyReturnType"] = 256] = "SuppressAnyReturnType";
        TypeFormatFlags2[TypeFormatFlags2["MultilineObjectLiterals"] = 1024] = "MultilineObjectLiterals";
        TypeFormatFlags2[TypeFormatFlags2["WriteClassExpressionAsTypeLiteral"] = 2048] = "WriteClassExpressionAsTypeLiteral";
        TypeFormatFlags2[TypeFormatFlags2["UseTypeOfFunction"] = 4096] = "UseTypeOfFunction";
        TypeFormatFlags2[TypeFormatFlags2["OmitParameterModifiers"] = 8192] = "OmitParameterModifiers";
        TypeFormatFlags2[TypeFormatFlags2["UseAliasDefinedOutsideCurrentScope"] = 16384] = "UseAliasDefinedOutsideCurrentScope";
        TypeFormatFlags2[TypeFormatFlags2["UseSingleQuotesForStringLiteralType"] = 268435456] = "UseSingleQuotesForStringLiteralType";
        TypeFormatFlags2[TypeFormatFlags2["NoTypeReduction"] = 536870912] = "NoTypeReduction";
        TypeFormatFlags2[TypeFormatFlags2["OmitThisParameter"] = 33554432] = "OmitThisParameter";
        TypeFormatFlags2[TypeFormatFlags2["AllowUniqueESSymbolType"] = 1048576] = "AllowUniqueESSymbolType";
        TypeFormatFlags2[TypeFormatFlags2["AddUndefined"] = 131072] = "AddUndefined";
        TypeFormatFlags2[TypeFormatFlags2["WriteArrowStyleSignature"] = 262144] = "WriteArrowStyleSignature";
        TypeFormatFlags2[TypeFormatFlags2["InArrayType"] = 524288] = "InArrayType";
        TypeFormatFlags2[TypeFormatFlags2["InElementType"] = 2097152] = "InElementType";
        TypeFormatFlags2[TypeFormatFlags2["InFirstTypeArgument"] = 4194304] = "InFirstTypeArgument";
        TypeFormatFlags2[TypeFormatFlags2["InTypeAlias"] = 8388608] = "InTypeAlias";
        TypeFormatFlags2[TypeFormatFlags2["WriteOwnNameForAnyLike"] = 0] = "WriteOwnNameForAnyLike";
        TypeFormatFlags2[TypeFormatFlags2["NodeBuilderFlagsMask"] = 848330091] = "NodeBuilderFlagsMask";
      })(TypeFormatFlags = ts2.TypeFormatFlags || (ts2.TypeFormatFlags = {}));
      var SymbolFormatFlags;
      (function(SymbolFormatFlags2) {
        SymbolFormatFlags2[SymbolFormatFlags2["None"] = 0] = "None";
        SymbolFormatFlags2[SymbolFormatFlags2["WriteTypeParametersOrArguments"] = 1] = "WriteTypeParametersOrArguments";
        SymbolFormatFlags2[SymbolFormatFlags2["UseOnlyExternalAliasing"] = 2] = "UseOnlyExternalAliasing";
        SymbolFormatFlags2[SymbolFormatFlags2["AllowAnyNodeKind"] = 4] = "AllowAnyNodeKind";
        SymbolFormatFlags2[SymbolFormatFlags2["UseAliasDefinedOutsideCurrentScope"] = 8] = "UseAliasDefinedOutsideCurrentScope";
        SymbolFormatFlags2[SymbolFormatFlags2["DoNotIncludeSymbolChain"] = 16] = "DoNotIncludeSymbolChain";
      })(SymbolFormatFlags = ts2.SymbolFormatFlags || (ts2.SymbolFormatFlags = {}));
      var SymbolAccessibility;
      (function(SymbolAccessibility2) {
        SymbolAccessibility2[SymbolAccessibility2["Accessible"] = 0] = "Accessible";
        SymbolAccessibility2[SymbolAccessibility2["NotAccessible"] = 1] = "NotAccessible";
        SymbolAccessibility2[SymbolAccessibility2["CannotBeNamed"] = 2] = "CannotBeNamed";
      })(SymbolAccessibility = ts2.SymbolAccessibility || (ts2.SymbolAccessibility = {}));
      var SyntheticSymbolKind;
      (function(SyntheticSymbolKind2) {
        SyntheticSymbolKind2[SyntheticSymbolKind2["UnionOrIntersection"] = 0] = "UnionOrIntersection";
        SyntheticSymbolKind2[SyntheticSymbolKind2["Spread"] = 1] = "Spread";
      })(SyntheticSymbolKind = ts2.SyntheticSymbolKind || (ts2.SyntheticSymbolKind = {}));
      var TypePredicateKind;
      (function(TypePredicateKind2) {
        TypePredicateKind2[TypePredicateKind2["This"] = 0] = "This";
        TypePredicateKind2[TypePredicateKind2["Identifier"] = 1] = "Identifier";
        TypePredicateKind2[TypePredicateKind2["AssertsThis"] = 2] = "AssertsThis";
        TypePredicateKind2[TypePredicateKind2["AssertsIdentifier"] = 3] = "AssertsIdentifier";
      })(TypePredicateKind = ts2.TypePredicateKind || (ts2.TypePredicateKind = {}));
      var TypeReferenceSerializationKind;
      (function(TypeReferenceSerializationKind2) {
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["Unknown"] = 0] = "Unknown";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["TypeWithConstructSignatureAndValue"] = 1] = "TypeWithConstructSignatureAndValue";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["VoidNullableOrNeverType"] = 2] = "VoidNullableOrNeverType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["NumberLikeType"] = 3] = "NumberLikeType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["BigIntLikeType"] = 4] = "BigIntLikeType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["StringLikeType"] = 5] = "StringLikeType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["BooleanType"] = 6] = "BooleanType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ArrayLikeType"] = 7] = "ArrayLikeType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ESSymbolType"] = 8] = "ESSymbolType";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["Promise"] = 9] = "Promise";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["TypeWithCallSignature"] = 10] = "TypeWithCallSignature";
        TypeReferenceSerializationKind2[TypeReferenceSerializationKind2["ObjectType"] = 11] = "ObjectType";
      })(TypeReferenceSerializationKind = ts2.TypeReferenceSerializationKind || (ts2.TypeReferenceSerializationKind = {}));
      var SymbolFlags;
      (function(SymbolFlags2) {
        SymbolFlags2[SymbolFlags2["None"] = 0] = "None";
        SymbolFlags2[SymbolFlags2["FunctionScopedVariable"] = 1] = "FunctionScopedVariable";
        SymbolFlags2[SymbolFlags2["BlockScopedVariable"] = 2] = "BlockScopedVariable";
        SymbolFlags2[SymbolFlags2["Property"] = 4] = "Property";
        SymbolFlags2[SymbolFlags2["EnumMember"] = 8] = "EnumMember";
        SymbolFlags2[SymbolFlags2["Function"] = 16] = "Function";
        SymbolFlags2[SymbolFlags2["Class"] = 32] = "Class";
        SymbolFlags2[SymbolFlags2["Interface"] = 64] = "Interface";
        SymbolFlags2[SymbolFlags2["ConstEnum"] = 128] = "ConstEnum";
        SymbolFlags2[SymbolFlags2["RegularEnum"] = 256] = "RegularEnum";
        SymbolFlags2[SymbolFlags2["ValueModule"] = 512] = "ValueModule";
        SymbolFlags2[SymbolFlags2["NamespaceModule"] = 1024] = "NamespaceModule";
        SymbolFlags2[SymbolFlags2["TypeLiteral"] = 2048] = "TypeLiteral";
        SymbolFlags2[SymbolFlags2["ObjectLiteral"] = 4096] = "ObjectLiteral";
        SymbolFlags2[SymbolFlags2["Method"] = 8192] = "Method";
        SymbolFlags2[SymbolFlags2["Constructor"] = 16384] = "Constructor";
        SymbolFlags2[SymbolFlags2["GetAccessor"] = 32768] = "GetAccessor";
        SymbolFlags2[SymbolFlags2["SetAccessor"] = 65536] = "SetAccessor";
        SymbolFlags2[SymbolFlags2["Signature"] = 131072] = "Signature";
        SymbolFlags2[SymbolFlags2["TypeParameter"] = 262144] = "TypeParameter";
        SymbolFlags2[SymbolFlags2["TypeAlias"] = 524288] = "TypeAlias";
        SymbolFlags2[SymbolFlags2["ExportValue"] = 1048576] = "ExportValue";
        SymbolFlags2[SymbolFlags2["Alias"] = 2097152] = "Alias";
        SymbolFlags2[SymbolFlags2["Prototype"] = 4194304] = "Prototype";
        SymbolFlags2[SymbolFlags2["ExportStar"] = 8388608] = "ExportStar";
        SymbolFlags2[SymbolFlags2["Optional"] = 16777216] = "Optional";
        SymbolFlags2[SymbolFlags2["Transient"] = 33554432] = "Transient";
        SymbolFlags2[SymbolFlags2["Assignment"] = 67108864] = "Assignment";
        SymbolFlags2[SymbolFlags2["ModuleExports"] = 134217728] = "ModuleExports";
        SymbolFlags2[SymbolFlags2["All"] = 67108863] = "All";
        SymbolFlags2[SymbolFlags2["Enum"] = 384] = "Enum";
        SymbolFlags2[SymbolFlags2["Variable"] = 3] = "Variable";
        SymbolFlags2[SymbolFlags2["Value"] = 111551] = "Value";
        SymbolFlags2[SymbolFlags2["Type"] = 788968] = "Type";
        SymbolFlags2[SymbolFlags2["Namespace"] = 1920] = "Namespace";
        SymbolFlags2[SymbolFlags2["Module"] = 1536] = "Module";
        SymbolFlags2[SymbolFlags2["Accessor"] = 98304] = "Accessor";
        SymbolFlags2[SymbolFlags2["FunctionScopedVariableExcludes"] = 111550] = "FunctionScopedVariableExcludes";
        SymbolFlags2[SymbolFlags2["BlockScopedVariableExcludes"] = 111551] = "BlockScopedVariableExcludes";
        SymbolFlags2[SymbolFlags2["ParameterExcludes"] = 111551] = "ParameterExcludes";
        SymbolFlags2[SymbolFlags2["PropertyExcludes"] = 0] = "PropertyExcludes";
        SymbolFlags2[SymbolFlags2["EnumMemberExcludes"] = 900095] = "EnumMemberExcludes";
        SymbolFlags2[SymbolFlags2["FunctionExcludes"] = 110991] = "FunctionExcludes";
        SymbolFlags2[SymbolFlags2["ClassExcludes"] = 899503] = "ClassExcludes";
        SymbolFlags2[SymbolFlags2["InterfaceExcludes"] = 788872] = "InterfaceExcludes";
        SymbolFlags2[SymbolFlags2["RegularEnumExcludes"] = 899327] = "RegularEnumExcludes";
        SymbolFlags2[SymbolFlags2["ConstEnumExcludes"] = 899967] = "ConstEnumExcludes";
        SymbolFlags2[SymbolFlags2["ValueModuleExcludes"] = 110735] = "ValueModuleExcludes";
        SymbolFlags2[SymbolFlags2["NamespaceModuleExcludes"] = 0] = "NamespaceModuleExcludes";
        SymbolFlags2[SymbolFlags2["MethodExcludes"] = 103359] = "MethodExcludes";
        SymbolFlags2[SymbolFlags2["GetAccessorExcludes"] = 46015] = "GetAccessorExcludes";
        SymbolFlags2[SymbolFlags2["SetAccessorExcludes"] = 78783] = "SetAccessorExcludes";
        SymbolFlags2[SymbolFlags2["TypeParameterExcludes"] = 526824] = "TypeParameterExcludes";
        SymbolFlags2[SymbolFlags2["TypeAliasExcludes"] = 788968] = "TypeAliasExcludes";
        SymbolFlags2[SymbolFlags2["AliasExcludes"] = 2097152] = "AliasExcludes";
        SymbolFlags2[SymbolFlags2["ModuleMember"] = 2623475] = "ModuleMember";
        SymbolFlags2[SymbolFlags2["ExportHasLocal"] = 944] = "ExportHasLocal";
        SymbolFlags2[SymbolFlags2["BlockScoped"] = 418] = "BlockScoped";
        SymbolFlags2[SymbolFlags2["PropertyOrAccessor"] = 98308] = "PropertyOrAccessor";
        SymbolFlags2[SymbolFlags2["ClassMember"] = 106500] = "ClassMember";
        SymbolFlags2[SymbolFlags2["ExportSupportsDefaultModifier"] = 112] = "ExportSupportsDefaultModifier";
        SymbolFlags2[SymbolFlags2["ExportDoesNotSupportDefaultModifier"] = -113] = "ExportDoesNotSupportDefaultModifier";
        SymbolFlags2[SymbolFlags2["Classifiable"] = 2885600] = "Classifiable";
        SymbolFlags2[SymbolFlags2["LateBindingContainer"] = 6256] = "LateBindingContainer";
      })(SymbolFlags = ts2.SymbolFlags || (ts2.SymbolFlags = {}));
      var EnumKind;
      (function(EnumKind2) {
        EnumKind2[EnumKind2["Numeric"] = 0] = "Numeric";
        EnumKind2[EnumKind2["Literal"] = 1] = "Literal";
      })(EnumKind = ts2.EnumKind || (ts2.EnumKind = {}));
      var CheckFlags;
      (function(CheckFlags2) {
        CheckFlags2[CheckFlags2["Instantiated"] = 1] = "Instantiated";
        CheckFlags2[CheckFlags2["SyntheticProperty"] = 2] = "SyntheticProperty";
        CheckFlags2[CheckFlags2["SyntheticMethod"] = 4] = "SyntheticMethod";
        CheckFlags2[CheckFlags2["Readonly"] = 8] = "Readonly";
        CheckFlags2[CheckFlags2["ReadPartial"] = 16] = "ReadPartial";
        CheckFlags2[CheckFlags2["WritePartial"] = 32] = "WritePartial";
        CheckFlags2[CheckFlags2["HasNonUniformType"] = 64] = "HasNonUniformType";
        CheckFlags2[CheckFlags2["HasLiteralType"] = 128] = "HasLiteralType";
        CheckFlags2[CheckFlags2["ContainsPublic"] = 256] = "ContainsPublic";
        CheckFlags2[CheckFlags2["ContainsProtected"] = 512] = "ContainsProtected";
        CheckFlags2[CheckFlags2["ContainsPrivate"] = 1024] = "ContainsPrivate";
        CheckFlags2[CheckFlags2["ContainsStatic"] = 2048] = "ContainsStatic";
        CheckFlags2[CheckFlags2["Late"] = 4096] = "Late";
        CheckFlags2[CheckFlags2["ReverseMapped"] = 8192] = "ReverseMapped";
        CheckFlags2[CheckFlags2["OptionalParameter"] = 16384] = "OptionalParameter";
        CheckFlags2[CheckFlags2["RestParameter"] = 32768] = "RestParameter";
        CheckFlags2[CheckFlags2["DeferredType"] = 65536] = "DeferredType";
        CheckFlags2[CheckFlags2["HasNeverType"] = 131072] = "HasNeverType";
        CheckFlags2[CheckFlags2["Mapped"] = 262144] = "Mapped";
        CheckFlags2[CheckFlags2["StripOptional"] = 524288] = "StripOptional";
        CheckFlags2[CheckFlags2["Unresolved"] = 1048576] = "Unresolved";
        CheckFlags2[CheckFlags2["Synthetic"] = 6] = "Synthetic";
        CheckFlags2[CheckFlags2["Discriminant"] = 192] = "Discriminant";
        CheckFlags2[CheckFlags2["Partial"] = 48] = "Partial";
      })(CheckFlags = ts2.CheckFlags || (ts2.CheckFlags = {}));
      var InternalSymbolName;
      (function(InternalSymbolName2) {
        InternalSymbolName2["Call"] = "__call";
        InternalSymbolName2["Constructor"] = "__constructor";
        InternalSymbolName2["New"] = "__new";
        InternalSymbolName2["Index"] = "__index";
        InternalSymbolName2["ExportStar"] = "__export";
        InternalSymbolName2["Global"] = "__global";
        InternalSymbolName2["Missing"] = "__missing";
        InternalSymbolName2["Type"] = "__type";
        InternalSymbolName2["Object"] = "__object";
        InternalSymbolName2["JSXAttributes"] = "__jsxAttributes";
        InternalSymbolName2["Class"] = "__class";
        InternalSymbolName2["Function"] = "__function";
        InternalSymbolName2["Computed"] = "__computed";
        InternalSymbolName2["Resolving"] = "__resolving__";
        InternalSymbolName2["ExportEquals"] = "export=";
        InternalSymbolName2["Default"] = "default";
        InternalSymbolName2["This"] = "this";
      })(InternalSymbolName = ts2.InternalSymbolName || (ts2.InternalSymbolName = {}));
      var NodeCheckFlags;
      (function(NodeCheckFlags2) {
        NodeCheckFlags2[NodeCheckFlags2["TypeChecked"] = 1] = "TypeChecked";
        NodeCheckFlags2[NodeCheckFlags2["LexicalThis"] = 2] = "LexicalThis";
        NodeCheckFlags2[NodeCheckFlags2["CaptureThis"] = 4] = "CaptureThis";
        NodeCheckFlags2[NodeCheckFlags2["CaptureNewTarget"] = 8] = "CaptureNewTarget";
        NodeCheckFlags2[NodeCheckFlags2["SuperInstance"] = 256] = "SuperInstance";
        NodeCheckFlags2[NodeCheckFlags2["SuperStatic"] = 512] = "SuperStatic";
        NodeCheckFlags2[NodeCheckFlags2["ContextChecked"] = 1024] = "ContextChecked";
        NodeCheckFlags2[NodeCheckFlags2["AsyncMethodWithSuper"] = 2048] = "AsyncMethodWithSuper";
        NodeCheckFlags2[NodeCheckFlags2["AsyncMethodWithSuperBinding"] = 4096] = "AsyncMethodWithSuperBinding";
        NodeCheckFlags2[NodeCheckFlags2["CaptureArguments"] = 8192] = "CaptureArguments";
        NodeCheckFlags2[NodeCheckFlags2["EnumValuesComputed"] = 16384] = "EnumValuesComputed";
        NodeCheckFlags2[NodeCheckFlags2["LexicalModuleMergesWithClass"] = 32768] = "LexicalModuleMergesWithClass";
        NodeCheckFlags2[NodeCheckFlags2["LoopWithCapturedBlockScopedBinding"] = 65536] = "LoopWithCapturedBlockScopedBinding";
        NodeCheckFlags2[NodeCheckFlags2["ContainsCapturedBlockScopeBinding"] = 131072] = "ContainsCapturedBlockScopeBinding";
        NodeCheckFlags2[NodeCheckFlags2["CapturedBlockScopedBinding"] = 262144] = "CapturedBlockScopedBinding";
        NodeCheckFlags2[NodeCheckFlags2["BlockScopedBindingInLoop"] = 524288] = "BlockScopedBindingInLoop";
        NodeCheckFlags2[NodeCheckFlags2["ClassWithBodyScopedClassBinding"] = 1048576] = "ClassWithBodyScopedClassBinding";
        NodeCheckFlags2[NodeCheckFlags2["BodyScopedClassBinding"] = 2097152] = "BodyScopedClassBinding";
        NodeCheckFlags2[NodeCheckFlags2["NeedsLoopOutParameter"] = 4194304] = "NeedsLoopOutParameter";
        NodeCheckFlags2[NodeCheckFlags2["AssignmentsMarked"] = 8388608] = "AssignmentsMarked";
        NodeCheckFlags2[NodeCheckFlags2["ClassWithConstructorReference"] = 16777216] = "ClassWithConstructorReference";
        NodeCheckFlags2[NodeCheckFlags2["ConstructorReferenceInClass"] = 33554432] = "ConstructorReferenceInClass";
        NodeCheckFlags2[NodeCheckFlags2["ContainsClassWithPrivateIdentifiers"] = 67108864] = "ContainsClassWithPrivateIdentifiers";
        NodeCheckFlags2[NodeCheckFlags2["ContainsSuperPropertyInStaticInitializer"] = 134217728] = "ContainsSuperPropertyInStaticInitializer";
        NodeCheckFlags2[NodeCheckFlags2["InCheckIdentifier"] = 268435456] = "InCheckIdentifier";
      })(NodeCheckFlags = ts2.NodeCheckFlags || (ts2.NodeCheckFlags = {}));
      var TypeFlags;
      (function(TypeFlags2) {
        TypeFlags2[TypeFlags2["Any"] = 1] = "Any";
        TypeFlags2[TypeFlags2["Unknown"] = 2] = "Unknown";
        TypeFlags2[TypeFlags2["String"] = 4] = "String";
        TypeFlags2[TypeFlags2["Number"] = 8] = "Number";
        TypeFlags2[TypeFlags2["Boolean"] = 16] = "Boolean";
        TypeFlags2[TypeFlags2["Enum"] = 32] = "Enum";
        TypeFlags2[TypeFlags2["BigInt"] = 64] = "BigInt";
        TypeFlags2[TypeFlags2["StringLiteral"] = 128] = "StringLiteral";
        TypeFlags2[TypeFlags2["NumberLiteral"] = 256] = "NumberLiteral";
        TypeFlags2[TypeFlags2["BooleanLiteral"] = 512] = "BooleanLiteral";
        TypeFlags2[TypeFlags2["EnumLiteral"] = 1024] = "EnumLiteral";
        TypeFlags2[TypeFlags2["BigIntLiteral"] = 2048] = "BigIntLiteral";
        TypeFlags2[TypeFlags2["ESSymbol"] = 4096] = "ESSymbol";
        TypeFlags2[TypeFlags2["UniqueESSymbol"] = 8192] = "UniqueESSymbol";
        TypeFlags2[TypeFlags2["Void"] = 16384] = "Void";
        TypeFlags2[TypeFlags2["Undefined"] = 32768] = "Undefined";
        TypeFlags2[TypeFlags2["Null"] = 65536] = "Null";
        TypeFlags2[TypeFlags2["Never"] = 131072] = "Never";
        TypeFlags2[TypeFlags2["TypeParameter"] = 262144] = "TypeParameter";
        TypeFlags2[TypeFlags2["Object"] = 524288] = "Object";
        TypeFlags2[TypeFlags2["Union"] = 1048576] = "Union";
        TypeFlags2[TypeFlags2["Intersection"] = 2097152] = "Intersection";
        TypeFlags2[TypeFlags2["Index"] = 4194304] = "Index";
        TypeFlags2[TypeFlags2["IndexedAccess"] = 8388608] = "IndexedAccess";
        TypeFlags2[TypeFlags2["Conditional"] = 16777216] = "Conditional";
        TypeFlags2[TypeFlags2["Substitution"] = 33554432] = "Substitution";
        TypeFlags2[TypeFlags2["NonPrimitive"] = 67108864] = "NonPrimitive";
        TypeFlags2[TypeFlags2["TemplateLiteral"] = 134217728] = "TemplateLiteral";
        TypeFlags2[TypeFlags2["StringMapping"] = 268435456] = "StringMapping";
        TypeFlags2[TypeFlags2["AnyOrUnknown"] = 3] = "AnyOrUnknown";
        TypeFlags2[TypeFlags2["Nullable"] = 98304] = "Nullable";
        TypeFlags2[TypeFlags2["Literal"] = 2944] = "Literal";
        TypeFlags2[TypeFlags2["Unit"] = 109440] = "Unit";
        TypeFlags2[TypeFlags2["StringOrNumberLiteral"] = 384] = "StringOrNumberLiteral";
        TypeFlags2[TypeFlags2["StringOrNumberLiteralOrUnique"] = 8576] = "StringOrNumberLiteralOrUnique";
        TypeFlags2[TypeFlags2["DefinitelyFalsy"] = 117632] = "DefinitelyFalsy";
        TypeFlags2[TypeFlags2["PossiblyFalsy"] = 117724] = "PossiblyFalsy";
        TypeFlags2[TypeFlags2["Intrinsic"] = 67359327] = "Intrinsic";
        TypeFlags2[TypeFlags2["Primitive"] = 131068] = "Primitive";
        TypeFlags2[TypeFlags2["StringLike"] = 402653316] = "StringLike";
        TypeFlags2[TypeFlags2["NumberLike"] = 296] = "NumberLike";
        TypeFlags2[TypeFlags2["BigIntLike"] = 2112] = "BigIntLike";
        TypeFlags2[TypeFlags2["BooleanLike"] = 528] = "BooleanLike";
        TypeFlags2[TypeFlags2["EnumLike"] = 1056] = "EnumLike";
        TypeFlags2[TypeFlags2["ESSymbolLike"] = 12288] = "ESSymbolLike";
        TypeFlags2[TypeFlags2["VoidLike"] = 49152] = "VoidLike";
        TypeFlags2[TypeFlags2["DefinitelyNonNullable"] = 470302716] = "DefinitelyNonNullable";
        TypeFlags2[TypeFlags2["DisjointDomains"] = 469892092] = "DisjointDomains";
        TypeFlags2[TypeFlags2["UnionOrIntersection"] = 3145728] = "UnionOrIntersection";
        TypeFlags2[TypeFlags2["StructuredType"] = 3670016] = "StructuredType";
        TypeFlags2[TypeFlags2["TypeVariable"] = 8650752] = "TypeVariable";
        TypeFlags2[TypeFlags2["InstantiableNonPrimitive"] = 58982400] = "InstantiableNonPrimitive";
        TypeFlags2[TypeFlags2["InstantiablePrimitive"] = 406847488] = "InstantiablePrimitive";
        TypeFlags2[TypeFlags2["Instantiable"] = 465829888] = "Instantiable";
        TypeFlags2[TypeFlags2["StructuredOrInstantiable"] = 469499904] = "StructuredOrInstantiable";
        TypeFlags2[TypeFlags2["ObjectFlagsType"] = 3899393] = "ObjectFlagsType";
        TypeFlags2[TypeFlags2["Simplifiable"] = 25165824] = "Simplifiable";
        TypeFlags2[TypeFlags2["Singleton"] = 67358815] = "Singleton";
        TypeFlags2[TypeFlags2["Narrowable"] = 536624127] = "Narrowable";
        TypeFlags2[TypeFlags2["IncludesMask"] = 205258751] = "IncludesMask";
        TypeFlags2[TypeFlags2["IncludesMissingType"] = 262144] = "IncludesMissingType";
        TypeFlags2[TypeFlags2["IncludesNonWideningType"] = 4194304] = "IncludesNonWideningType";
        TypeFlags2[TypeFlags2["IncludesWildcard"] = 8388608] = "IncludesWildcard";
        TypeFlags2[TypeFlags2["IncludesEmptyObject"] = 16777216] = "IncludesEmptyObject";
        TypeFlags2[TypeFlags2["IncludesInstantiable"] = 33554432] = "IncludesInstantiable";
        TypeFlags2[TypeFlags2["NotPrimitiveUnion"] = 36323363] = "NotPrimitiveUnion";
      })(TypeFlags = ts2.TypeFlags || (ts2.TypeFlags = {}));
      var ObjectFlags;
      (function(ObjectFlags2) {
        ObjectFlags2[ObjectFlags2["Class"] = 1] = "Class";
        ObjectFlags2[ObjectFlags2["Interface"] = 2] = "Interface";
        ObjectFlags2[ObjectFlags2["Reference"] = 4] = "Reference";
        ObjectFlags2[ObjectFlags2["Tuple"] = 8] = "Tuple";
        ObjectFlags2[ObjectFlags2["Anonymous"] = 16] = "Anonymous";
        ObjectFlags2[ObjectFlags2["Mapped"] = 32] = "Mapped";
        ObjectFlags2[ObjectFlags2["Instantiated"] = 64] = "Instantiated";
        ObjectFlags2[ObjectFlags2["ObjectLiteral"] = 128] = "ObjectLiteral";
        ObjectFlags2[ObjectFlags2["EvolvingArray"] = 256] = "EvolvingArray";
        ObjectFlags2[ObjectFlags2["ObjectLiteralPatternWithComputedProperties"] = 512] = "ObjectLiteralPatternWithComputedProperties";
        ObjectFlags2[ObjectFlags2["ReverseMapped"] = 1024] = "ReverseMapped";
        ObjectFlags2[ObjectFlags2["JsxAttributes"] = 2048] = "JsxAttributes";
        ObjectFlags2[ObjectFlags2["JSLiteral"] = 4096] = "JSLiteral";
        ObjectFlags2[ObjectFlags2["FreshLiteral"] = 8192] = "FreshLiteral";
        ObjectFlags2[ObjectFlags2["ArrayLiteral"] = 16384] = "ArrayLiteral";
        ObjectFlags2[ObjectFlags2["PrimitiveUnion"] = 32768] = "PrimitiveUnion";
        ObjectFlags2[ObjectFlags2["ContainsWideningType"] = 65536] = "ContainsWideningType";
        ObjectFlags2[ObjectFlags2["ContainsObjectOrArrayLiteral"] = 131072] = "ContainsObjectOrArrayLiteral";
        ObjectFlags2[ObjectFlags2["NonInferrableType"] = 262144] = "NonInferrableType";
        ObjectFlags2[ObjectFlags2["CouldContainTypeVariablesComputed"] = 524288] = "CouldContainTypeVariablesComputed";
        ObjectFlags2[ObjectFlags2["CouldContainTypeVariables"] = 1048576] = "CouldContainTypeVariables";
        ObjectFlags2[ObjectFlags2["ClassOrInterface"] = 3] = "ClassOrInterface";
        ObjectFlags2[ObjectFlags2["RequiresWidening"] = 196608] = "RequiresWidening";
        ObjectFlags2[ObjectFlags2["PropagatingFlags"] = 458752] = "PropagatingFlags";
        ObjectFlags2[ObjectFlags2["ObjectTypeKindMask"] = 1343] = "ObjectTypeKindMask";
        ObjectFlags2[ObjectFlags2["ContainsSpread"] = 2097152] = "ContainsSpread";
        ObjectFlags2[ObjectFlags2["ObjectRestType"] = 4194304] = "ObjectRestType";
        ObjectFlags2[ObjectFlags2["InstantiationExpressionType"] = 8388608] = "InstantiationExpressionType";
        ObjectFlags2[ObjectFlags2["IsClassInstanceClone"] = 16777216] = "IsClassInstanceClone";
        ObjectFlags2[ObjectFlags2["IdenticalBaseTypeCalculated"] = 33554432] = "IdenticalBaseTypeCalculated";
        ObjectFlags2[ObjectFlags2["IdenticalBaseTypeExists"] = 67108864] = "IdenticalBaseTypeExists";
        ObjectFlags2[ObjectFlags2["IsGenericTypeComputed"] = 2097152] = "IsGenericTypeComputed";
        ObjectFlags2[ObjectFlags2["IsGenericObjectType"] = 4194304] = "IsGenericObjectType";
        ObjectFlags2[ObjectFlags2["IsGenericIndexType"] = 8388608] = "IsGenericIndexType";
        ObjectFlags2[ObjectFlags2["IsGenericType"] = 12582912] = "IsGenericType";
        ObjectFlags2[ObjectFlags2["ContainsIntersections"] = 16777216] = "ContainsIntersections";
        ObjectFlags2[ObjectFlags2["IsUnknownLikeUnionComputed"] = 33554432] = "IsUnknownLikeUnionComputed";
        ObjectFlags2[ObjectFlags2["IsUnknownLikeUnion"] = 67108864] = "IsUnknownLikeUnion";
        ObjectFlags2[ObjectFlags2["IsNeverIntersectionComputed"] = 16777216] = "IsNeverIntersectionComputed";
        ObjectFlags2[ObjectFlags2["IsNeverIntersection"] = 33554432] = "IsNeverIntersection";
      })(ObjectFlags = ts2.ObjectFlags || (ts2.ObjectFlags = {}));
      var VarianceFlags;
      (function(VarianceFlags2) {
        VarianceFlags2[VarianceFlags2["Invariant"] = 0] = "Invariant";
        VarianceFlags2[VarianceFlags2["Covariant"] = 1] = "Covariant";
        VarianceFlags2[VarianceFlags2["Contravariant"] = 2] = "Contravariant";
        VarianceFlags2[VarianceFlags2["Bivariant"] = 3] = "Bivariant";
        VarianceFlags2[VarianceFlags2["Independent"] = 4] = "Independent";
        VarianceFlags2[VarianceFlags2["VarianceMask"] = 7] = "VarianceMask";
        VarianceFlags2[VarianceFlags2["Unmeasurable"] = 8] = "Unmeasurable";
        VarianceFlags2[VarianceFlags2["Unreliable"] = 16] = "Unreliable";
        VarianceFlags2[VarianceFlags2["AllowsStructuralFallback"] = 24] = "AllowsStructuralFallback";
      })(VarianceFlags = ts2.VarianceFlags || (ts2.VarianceFlags = {}));
      var ElementFlags;
      (function(ElementFlags2) {
        ElementFlags2[ElementFlags2["Required"] = 1] = "Required";
        ElementFlags2[ElementFlags2["Optional"] = 2] = "Optional";
        ElementFlags2[ElementFlags2["Rest"] = 4] = "Rest";
        ElementFlags2[ElementFlags2["Variadic"] = 8] = "Variadic";
        ElementFlags2[ElementFlags2["Fixed"] = 3] = "Fixed";
        ElementFlags2[ElementFlags2["Variable"] = 12] = "Variable";
        ElementFlags2[ElementFlags2["NonRequired"] = 14] = "NonRequired";
        ElementFlags2[ElementFlags2["NonRest"] = 11] = "NonRest";
      })(ElementFlags = ts2.ElementFlags || (ts2.ElementFlags = {}));
      var AccessFlags;
      (function(AccessFlags2) {
        AccessFlags2[AccessFlags2["None"] = 0] = "None";
        AccessFlags2[AccessFlags2["IncludeUndefined"] = 1] = "IncludeUndefined";
        AccessFlags2[AccessFlags2["NoIndexSignatures"] = 2] = "NoIndexSignatures";
        AccessFlags2[AccessFlags2["Writing"] = 4] = "Writing";
        AccessFlags2[AccessFlags2["CacheSymbol"] = 8] = "CacheSymbol";
        AccessFlags2[AccessFlags2["NoTupleBoundsCheck"] = 16] = "NoTupleBoundsCheck";
        AccessFlags2[AccessFlags2["ExpressionPosition"] = 32] = "ExpressionPosition";
        AccessFlags2[AccessFlags2["ReportDeprecated"] = 64] = "ReportDeprecated";
        AccessFlags2[AccessFlags2["SuppressNoImplicitAnyError"] = 128] = "SuppressNoImplicitAnyError";
        AccessFlags2[AccessFlags2["Contextual"] = 256] = "Contextual";
        AccessFlags2[AccessFlags2["Persistent"] = 1] = "Persistent";
      })(AccessFlags = ts2.AccessFlags || (ts2.AccessFlags = {}));
      var JsxReferenceKind;
      (function(JsxReferenceKind2) {
        JsxReferenceKind2[JsxReferenceKind2["Component"] = 0] = "Component";
        JsxReferenceKind2[JsxReferenceKind2["Function"] = 1] = "Function";
        JsxReferenceKind2[JsxReferenceKind2["Mixed"] = 2] = "Mixed";
      })(JsxReferenceKind = ts2.JsxReferenceKind || (ts2.JsxReferenceKind = {}));
      var SignatureKind;
      (function(SignatureKind2) {
        SignatureKind2[SignatureKind2["Call"] = 0] = "Call";
        SignatureKind2[SignatureKind2["Construct"] = 1] = "Construct";
      })(SignatureKind = ts2.SignatureKind || (ts2.SignatureKind = {}));
      var SignatureFlags;
      (function(SignatureFlags2) {
        SignatureFlags2[SignatureFlags2["None"] = 0] = "None";
        SignatureFlags2[SignatureFlags2["HasRestParameter"] = 1] = "HasRestParameter";
        SignatureFlags2[SignatureFlags2["HasLiteralTypes"] = 2] = "HasLiteralTypes";
        SignatureFlags2[SignatureFlags2["Abstract"] = 4] = "Abstract";
        SignatureFlags2[SignatureFlags2["IsInnerCallChain"] = 8] = "IsInnerCallChain";
        SignatureFlags2[SignatureFlags2["IsOuterCallChain"] = 16] = "IsOuterCallChain";
        SignatureFlags2[SignatureFlags2["IsUntypedSignatureInJSFile"] = 32] = "IsUntypedSignatureInJSFile";
        SignatureFlags2[SignatureFlags2["PropagatingFlags"] = 39] = "PropagatingFlags";
        SignatureFlags2[SignatureFlags2["CallChainFlags"] = 24] = "CallChainFlags";
      })(SignatureFlags = ts2.SignatureFlags || (ts2.SignatureFlags = {}));
      var IndexKind;
      (function(IndexKind2) {
        IndexKind2[IndexKind2["String"] = 0] = "String";
        IndexKind2[IndexKind2["Number"] = 1] = "Number";
      })(IndexKind = ts2.IndexKind || (ts2.IndexKind = {}));
      var TypeMapKind;
      (function(TypeMapKind2) {
        TypeMapKind2[TypeMapKind2["Simple"] = 0] = "Simple";
        TypeMapKind2[TypeMapKind2["Array"] = 1] = "Array";
        TypeMapKind2[TypeMapKind2["Deferred"] = 2] = "Deferred";
        TypeMapKind2[TypeMapKind2["Function"] = 3] = "Function";
        TypeMapKind2[TypeMapKind2["Composite"] = 4] = "Composite";
        TypeMapKind2[TypeMapKind2["Merged"] = 5] = "Merged";
      })(TypeMapKind = ts2.TypeMapKind || (ts2.TypeMapKind = {}));
      var InferencePriority;
      (function(InferencePriority2) {
        InferencePriority2[InferencePriority2["NakedTypeVariable"] = 1] = "NakedTypeVariable";
        InferencePriority2[InferencePriority2["SpeculativeTuple"] = 2] = "SpeculativeTuple";
        InferencePriority2[InferencePriority2["SubstituteSource"] = 4] = "SubstituteSource";
        InferencePriority2[InferencePriority2["HomomorphicMappedType"] = 8] = "HomomorphicMappedType";
        InferencePriority2[InferencePriority2["PartialHomomorphicMappedType"] = 16] = "PartialHomomorphicMappedType";
        InferencePriority2[InferencePriority2["MappedTypeConstraint"] = 32] = "MappedTypeConstraint";
        InferencePriority2[InferencePriority2["ContravariantConditional"] = 64] = "ContravariantConditional";
        InferencePriority2[InferencePriority2["ReturnType"] = 128] = "ReturnType";
        InferencePriority2[InferencePriority2["LiteralKeyof"] = 256] = "LiteralKeyof";
        InferencePriority2[InferencePriority2["NoConstraints"] = 512] = "NoConstraints";
        InferencePriority2[InferencePriority2["AlwaysStrict"] = 1024] = "AlwaysStrict";
        InferencePriority2[InferencePriority2["MaxValue"] = 2048] = "MaxValue";
        InferencePriority2[InferencePriority2["PriorityImpliesCombination"] = 416] = "PriorityImpliesCombination";
        InferencePriority2[InferencePriority2["Circularity"] = -1] = "Circularity";
      })(InferencePriority = ts2.InferencePriority || (ts2.InferencePriority = {}));
      var InferenceFlags;
      (function(InferenceFlags2) {
        InferenceFlags2[InferenceFlags2["None"] = 0] = "None";
        InferenceFlags2[InferenceFlags2["NoDefault"] = 1] = "NoDefault";
        InferenceFlags2[InferenceFlags2["AnyDefault"] = 2] = "AnyDefault";
        InferenceFlags2[InferenceFlags2["SkippedGenericFunction"] = 4] = "SkippedGenericFunction";
      })(InferenceFlags = ts2.InferenceFlags || (ts2.InferenceFlags = {}));
      var Ternary;
      (function(Ternary2) {
        Ternary2[Ternary2["False"] = 0] = "False";
        Ternary2[Ternary2["Unknown"] = 1] = "Unknown";
        Ternary2[Ternary2["Maybe"] = 3] = "Maybe";
        Ternary2[Ternary2["True"] = -1] = "True";
      })(Ternary = ts2.Ternary || (ts2.Ternary = {}));
      var AssignmentDeclarationKind;
      (function(AssignmentDeclarationKind2) {
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["None"] = 0] = "None";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["ExportsProperty"] = 1] = "ExportsProperty";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["ModuleExports"] = 2] = "ModuleExports";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["PrototypeProperty"] = 3] = "PrototypeProperty";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["ThisProperty"] = 4] = "ThisProperty";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["Property"] = 5] = "Property";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["Prototype"] = 6] = "Prototype";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePropertyValue"] = 7] = "ObjectDefinePropertyValue";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePropertyExports"] = 8] = "ObjectDefinePropertyExports";
        AssignmentDeclarationKind2[AssignmentDeclarationKind2["ObjectDefinePrototypeProperty"] = 9] = "ObjectDefinePrototypeProperty";
      })(AssignmentDeclarationKind = ts2.AssignmentDeclarationKind || (ts2.AssignmentDeclarationKind = {}));
      var DiagnosticCategory;
      (function(DiagnosticCategory2) {
        DiagnosticCategory2[DiagnosticCategory2["Warning"] = 0] = "Warning";
        DiagnosticCategory2[DiagnosticCategory2["Error"] = 1] = "Error";
        DiagnosticCategory2[DiagnosticCategory2["Suggestion"] = 2] = "Suggestion";
        DiagnosticCategory2[DiagnosticCategory2["Message"] = 3] = "Message";
      })(DiagnosticCategory = ts2.DiagnosticCategory || (ts2.DiagnosticCategory = {}));
      function diagnosticCategoryName(d, lowerCase) {
        if (lowerCase === void 0) {
          lowerCase = true;
        }
        var name = DiagnosticCategory[d.category];
        return lowerCase ? name.toLowerCase() : name;
      }
      ts2.diagnosticCategoryName = diagnosticCategoryName;
      var ModuleResolutionKind;
      (function(ModuleResolutionKind2) {
        ModuleResolutionKind2[ModuleResolutionKind2["Classic"] = 1] = "Classic";
        ModuleResolutionKind2[ModuleResolutionKind2["NodeJs"] = 2] = "NodeJs";
        ModuleResolutionKind2[ModuleResolutionKind2["Node16"] = 3] = "Node16";
        ModuleResolutionKind2[ModuleResolutionKind2["NodeNext"] = 99] = "NodeNext";
      })(ModuleResolutionKind = ts2.ModuleResolutionKind || (ts2.ModuleResolutionKind = {}));
      var ModuleDetectionKind;
      (function(ModuleDetectionKind2) {
        ModuleDetectionKind2[ModuleDetectionKind2["Legacy"] = 1] = "Legacy";
        ModuleDetectionKind2[ModuleDetectionKind2["Auto"] = 2] = "Auto";
        ModuleDetectionKind2[ModuleDetectionKind2["Force"] = 3] = "Force";
      })(ModuleDetectionKind = ts2.ModuleDetectionKind || (ts2.ModuleDetectionKind = {}));
      var WatchFileKind;
      (function(WatchFileKind2) {
        WatchFileKind2[WatchFileKind2["FixedPollingInterval"] = 0] = "FixedPollingInterval";
        WatchFileKind2[WatchFileKind2["PriorityPollingInterval"] = 1] = "PriorityPollingInterval";
        WatchFileKind2[WatchFileKind2["DynamicPriorityPolling"] = 2] = "DynamicPriorityPolling";
        WatchFileKind2[WatchFileKind2["FixedChunkSizePolling"] = 3] = "FixedChunkSizePolling";
        WatchFileKind2[WatchFileKind2["UseFsEvents"] = 4] = "UseFsEvents";
        WatchFileKind2[WatchFileKind2["UseFsEventsOnParentDirectory"] = 5] = "UseFsEventsOnParentDirectory";
      })(WatchFileKind = ts2.WatchFileKind || (ts2.WatchFileKind = {}));
      var WatchDirectoryKind;
      (function(WatchDirectoryKind2) {
        WatchDirectoryKind2[WatchDirectoryKind2["UseFsEvents"] = 0] = "UseFsEvents";
        WatchDirectoryKind2[WatchDirectoryKind2["FixedPollingInterval"] = 1] = "FixedPollingInterval";
        WatchDirectoryKind2[WatchDirectoryKind2["DynamicPriorityPolling"] = 2] = "DynamicPriorityPolling";
        WatchDirectoryKind2[WatchDirectoryKind2["FixedChunkSizePolling"] = 3] = "FixedChunkSizePolling";
      })(WatchDirectoryKind = ts2.WatchDirectoryKind || (ts2.WatchDirectoryKind = {}));
      var PollingWatchKind;
      (function(PollingWatchKind2) {
        PollingWatchKind2[PollingWatchKind2["FixedInterval"] = 0] = "FixedInterval";
        PollingWatchKind2[PollingWatchKind2["PriorityInterval"] = 1] = "PriorityInterval";
        PollingWatchKind2[PollingWatchKind2["DynamicPriority"] = 2] = "DynamicPriority";
        PollingWatchKind2[PollingWatchKind2["FixedChunkSize"] = 3] = "FixedChunkSize";
      })(PollingWatchKind = ts2.PollingWatchKind || (ts2.PollingWatchKind = {}));
      var ModuleKind;
      (function(ModuleKind2) {
        ModuleKind2[ModuleKind2["None"] = 0] = "None";
        ModuleKind2[ModuleKind2["CommonJS"] = 1] = "CommonJS";
        ModuleKind2[ModuleKind2["AMD"] = 2] = "AMD";
        ModuleKind2[ModuleKind2["UMD"] = 3] = "UMD";
        ModuleKind2[ModuleKind2["System"] = 4] = "System";
        ModuleKind2[ModuleKind2["ES2015"] = 5] = "ES2015";
        ModuleKind2[ModuleKind2["ES2020"] = 6] = "ES2020";
        ModuleKind2[ModuleKind2["ES2022"] = 7] = "ES2022";
        ModuleKind2[ModuleKind2["ESNext"] = 99] = "ESNext";
        ModuleKind2[ModuleKind2["Node16"] = 100] = "Node16";
        ModuleKind2[ModuleKind2["NodeNext"] = 199] = "NodeNext";
      })(ModuleKind = ts2.ModuleKind || (ts2.ModuleKind = {}));
      var JsxEmit;
      (function(JsxEmit2) {
        JsxEmit2[JsxEmit2["None"] = 0] = "None";
        JsxEmit2[JsxEmit2["Preserve"] = 1] = "Preserve";
        JsxEmit2[JsxEmit2["React"] = 2] = "React";
        JsxEmit2[JsxEmit2["ReactNative"] = 3] = "ReactNative";
        JsxEmit2[JsxEmit2["ReactJSX"] = 4] = "ReactJSX";
        JsxEmit2[JsxEmit2["ReactJSXDev"] = 5] = "ReactJSXDev";
      })(JsxEmit = ts2.JsxEmit || (ts2.JsxEmit = {}));
      var ImportsNotUsedAsValues;
      (function(ImportsNotUsedAsValues2) {
        ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Remove"] = 0] = "Remove";
        ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Preserve"] = 1] = "Preserve";
        ImportsNotUsedAsValues2[ImportsNotUsedAsValues2["Error"] = 2] = "Error";
      })(ImportsNotUsedAsValues = ts2.ImportsNotUsedAsValues || (ts2.ImportsNotUsedAsValues = {}));
      var NewLineKind;
      (function(NewLineKind2) {
        NewLineKind2[NewLineKind2["CarriageReturnLineFeed"] = 0] = "CarriageReturnLineFeed";
        NewLineKind2[NewLineKind2["LineFeed"] = 1] = "LineFeed";
      })(NewLineKind = ts2.NewLineKind || (ts2.NewLineKind = {}));
      var ScriptKind;
      (function(ScriptKind2) {
        ScriptKind2[ScriptKind2["Unknown"] = 0] = "Unknown";
        ScriptKind2[ScriptKind2["JS"] = 1] = "JS";
        ScriptKind2[ScriptKind2["JSX"] = 2] = "JSX";
        ScriptKind2[ScriptKind2["TS"] = 3] = "TS";
        ScriptKind2[ScriptKind2["TSX"] = 4] = "TSX";
        ScriptKind2[ScriptKind2["External"] = 5] = "External";
        ScriptKind2[ScriptKind2["JSON"] = 6] = "JSON";
        ScriptKind2[ScriptKind2["Deferred"] = 7] = "Deferred";
      })(ScriptKind = ts2.ScriptKind || (ts2.ScriptKind = {}));
      var ScriptTarget;
      (function(ScriptTarget2) {
        ScriptTarget2[ScriptTarget2["ES3"] = 0] = "ES3";
        ScriptTarget2[ScriptTarget2["ES5"] = 1] = "ES5";
        ScriptTarget2[ScriptTarget2["ES2015"] = 2] = "ES2015";
        ScriptTarget2[ScriptTarget2["ES2016"] = 3] = "ES2016";
        ScriptTarget2[ScriptTarget2["ES2017"] = 4] = "ES2017";
        ScriptTarget2[ScriptTarget2["ES2018"] = 5] = "ES2018";
        ScriptTarget2[ScriptTarget2["ES2019"] = 6] = "ES2019";
        ScriptTarget2[ScriptTarget2["ES2020"] = 7] = "ES2020";
        ScriptTarget2[ScriptTarget2["ES2021"] = 8] = "ES2021";
        ScriptTarget2[ScriptTarget2["ES2022"] = 9] = "ES2022";
        ScriptTarget2[ScriptTarget2["ESNext"] = 99] = "ESNext";
        ScriptTarget2[ScriptTarget2["JSON"] = 100] = "JSON";
        ScriptTarget2[ScriptTarget2["Latest"] = 99] = "Latest";
      })(ScriptTarget = ts2.ScriptTarget || (ts2.ScriptTarget = {}));
      var LanguageVariant;
      (function(LanguageVariant2) {
        LanguageVariant2[LanguageVariant2["Standard"] = 0] = "Standard";
        LanguageVariant2[LanguageVariant2["JSX"] = 1] = "JSX";
      })(LanguageVariant = ts2.LanguageVariant || (ts2.LanguageVariant = {}));
      var WatchDirectoryFlags;
      (function(WatchDirectoryFlags2) {
        WatchDirectoryFlags2[WatchDirectoryFlags2["None"] = 0] = "None";
        WatchDirectoryFlags2[WatchDirectoryFlags2["Recursive"] = 1] = "Recursive";
      })(WatchDirectoryFlags = ts2.WatchDirectoryFlags || (ts2.WatchDirectoryFlags = {}));
      var CharacterCodes;
      (function(CharacterCodes2) {
        CharacterCodes2[CharacterCodes2["nullCharacter"] = 0] = "nullCharacter";
        CharacterCodes2[CharacterCodes2["maxAsciiCharacter"] = 127] = "maxAsciiCharacter";
        CharacterCodes2[CharacterCodes2["lineFeed"] = 10] = "lineFeed";
        CharacterCodes2[CharacterCodes2["carriageReturn"] = 13] = "carriageReturn";
        CharacterCodes2[CharacterCodes2["lineSeparator"] = 8232] = "lineSeparator";
        CharacterCodes2[CharacterCodes2["paragraphSeparator"] = 8233] = "paragraphSeparator";
        CharacterCodes2[CharacterCodes2["nextLine"] = 133] = "nextLine";
        CharacterCodes2[CharacterCodes2["space"] = 32] = "space";
        CharacterCodes2[CharacterCodes2["nonBreakingSpace"] = 160] = "nonBreakingSpace";
        CharacterCodes2[CharacterCodes2["enQuad"] = 8192] = "enQuad";
        CharacterCodes2[CharacterCodes2["emQuad"] = 8193] = "emQuad";
        CharacterCodes2[CharacterCodes2["enSpace"] = 8194] = "enSpace";
        CharacterCodes2[CharacterCodes2["emSpace"] = 8195] = "emSpace";
        CharacterCodes2[CharacterCodes2["threePerEmSpace"] = 8196] = "threePerEmSpace";
        CharacterCodes2[CharacterCodes2["fourPerEmSpace"] = 8197] = "fourPerEmSpace";
        CharacterCodes2[CharacterCodes2["sixPerEmSpace"] = 8198] = "sixPerEmSpace";
        CharacterCodes2[CharacterCodes2["figureSpace"] = 8199] = "figureSpace";
        CharacterCodes2[CharacterCodes2["punctuationSpace"] = 8200] = "punctuationSpace";
        CharacterCodes2[CharacterCodes2["thinSpace"] = 8201] = "thinSpace";
        CharacterCodes2[CharacterCodes2["hairSpace"] = 8202] = "hairSpace";
        CharacterCodes2[CharacterCodes2["zeroWidthSpace"] = 8203] = "zeroWidthSpace";
        CharacterCodes2[CharacterCodes2["narrowNoBreakSpace"] = 8239] = "narrowNoBreakSpace";
        CharacterCodes2[CharacterCodes2["ideographicSpace"] = 12288] = "ideographicSpace";
        CharacterCodes2[CharacterCodes2["mathematicalSpace"] = 8287] = "mathematicalSpace";
        CharacterCodes2[CharacterCodes2["ogham"] = 5760] = "ogham";
        CharacterCodes2[CharacterCodes2["_"] = 95] = "_";
        CharacterCodes2[CharacterCodes2["$"] = 36] = "$";
        CharacterCodes2[CharacterCodes2["_0"] = 48] = "_0";
        CharacterCodes2[CharacterCodes2["_1"] = 49] = "_1";
        CharacterCodes2[CharacterCodes2["_2"] = 50] = "_2";
        CharacterCodes2[CharacterCodes2["_3"] = 51] = "_3";
        CharacterCodes2[CharacterCodes2["_4"] = 52] = "_4";
        CharacterCodes2[CharacterCodes2["_5"] = 53] = "_5";
        CharacterCodes2[CharacterCodes2["_6"] = 54] = "_6";
        CharacterCodes2[CharacterCodes2["_7"] = 55] = "_7";
        CharacterCodes2[CharacterCodes2["_8"] = 56] = "_8";
        CharacterCodes2[CharacterCodes2["_9"] = 57] = "_9";
        CharacterCodes2[CharacterCodes2["a"] = 97] = "a";
        CharacterCodes2[CharacterCodes2["b"] = 98] = "b";
        CharacterCodes2[CharacterCodes2["c"] = 99] = "c";
        CharacterCodes2[CharacterCodes2["d"] = 100] = "d";
        CharacterCodes2[CharacterCodes2["e"] = 101] = "e";
        CharacterCodes2[CharacterCodes2["f"] = 102] = "f";
        CharacterCodes2[CharacterCodes2["g"] = 103] = "g";
        CharacterCodes2[CharacterCodes2["h"] = 104] = "h";
        CharacterCodes2[CharacterCodes2["i"] = 105] = "i";
        CharacterCodes2[CharacterCodes2["j"] = 106] = "j";
        CharacterCodes2[CharacterCodes2["k"] = 107] = "k";
        CharacterCodes2[CharacterCodes2["l"] = 108] = "l";
        CharacterCodes2[CharacterCodes2["m"] = 109] = "m";
        CharacterCodes2[CharacterCodes2["n"] = 110] = "n";
        CharacterCodes2[CharacterCodes2["o"] = 111] = "o";
        CharacterCodes2[CharacterCodes2["p"] = 112] = "p";
        CharacterCodes2[CharacterCodes2["q"] = 113] = "q";
        CharacterCodes2[CharacterCodes2["r"] = 114] = "r";
        CharacterCodes2[CharacterCodes2["s"] = 115] = "s";
        CharacterCodes2[CharacterCodes2["t"] = 116] = "t";
        CharacterCodes2[CharacterCodes2["u"] = 117] = "u";
        CharacterCodes2[CharacterCodes2["v"] = 118] = "v";
        CharacterCodes2[CharacterCodes2["w"] = 119] = "w";
        CharacterCodes2[CharacterCodes2["x"] = 120] = "x";
        CharacterCodes2[CharacterCodes2["y"] = 121] = "y";
        CharacterCodes2[CharacterCodes2["z"] = 122] = "z";
        CharacterCodes2[CharacterCodes2["A"] = 65] = "A";
        CharacterCodes2[CharacterCodes2["B"] = 66] = "B";
        CharacterCodes2[CharacterCodes2["C"] = 67] = "C";
        CharacterCodes2[CharacterCodes2["D"] = 68] = "D";
        CharacterCodes2[CharacterCodes2["E"] = 69] = "E";
        CharacterCodes2[CharacterCodes2["F"] = 70] = "F";
        CharacterCodes2[CharacterCodes2["G"] = 71] = "G";
        CharacterCodes2[CharacterCodes2["H"] = 72] = "H";
        CharacterCodes2[CharacterCodes2["I"] = 73] = "I";
        CharacterCodes2[CharacterCodes2["J"] = 74] = "J";
        CharacterCodes2[CharacterCodes2["K"] = 75] = "K";
        CharacterCodes2[CharacterCodes2["L"] = 76] = "L";
        CharacterCodes2[CharacterCodes2["M"] = 77] = "M";
        CharacterCodes2[CharacterCodes2["N"] = 78] = "N";
        CharacterCodes2[CharacterCodes2["O"] = 79] = "O";
        CharacterCodes2[CharacterCodes2["P"] = 80] = "P";
        CharacterCodes2[CharacterCodes2["Q"] = 81] = "Q";
        CharacterCodes2[CharacterCodes2["R"] = 82] = "R";
        CharacterCodes2[CharacterCodes2["S"] = 83] = "S";
        CharacterCodes2[CharacterCodes2["T"] = 84] = "T";
        CharacterCodes2[CharacterCodes2["U"] = 85] = "U";
        CharacterCodes2[CharacterCodes2["V"] = 86] = "V";
        CharacterCodes2[CharacterCodes2["W"] = 87] = "W";
        CharacterCodes2[CharacterCodes2["X"] = 88] = "X";
        CharacterCodes2[CharacterCodes2["Y"] = 89] = "Y";
        CharacterCodes2[CharacterCodes2["Z"] = 90] = "Z";
        CharacterCodes2[CharacterCodes2["ampersand"] = 38] = "ampersand";
        CharacterCodes2[CharacterCodes2["asterisk"] = 42] = "asterisk";
        CharacterCodes2[CharacterCodes2["at"] = 64] = "at";
        CharacterCodes2[CharacterCodes2["backslash"] = 92] = "backslash";
        CharacterCodes2[CharacterCodes2["backtick"] = 96] = "backtick";
        CharacterCodes2[CharacterCodes2["bar"] = 124] = "bar";
        CharacterCodes2[CharacterCodes2["caret"] = 94] = "caret";
        CharacterCodes2[CharacterCodes2["closeBrace"] = 125] = "closeBrace";
        CharacterCodes2[CharacterCodes2["closeBracket"] = 93] = "closeBracket";
        CharacterCodes2[CharacterCodes2["closeParen"] = 41] = "closeParen";
        CharacterCodes2[CharacterCodes2["colon"] = 58] = "colon";
        CharacterCodes2[CharacterCodes2["comma"] = 44] = "comma";
        CharacterCodes2[CharacterCodes2["dot"] = 46] = "dot";
        CharacterCodes2[CharacterCodes2["doubleQuote"] = 34] = "doubleQuote";
        CharacterCodes2[CharacterCodes2["equals"] = 61] = "equals";
        CharacterCodes2[CharacterCodes2["exclamation"] = 33] = "exclamation";
        CharacterCodes2[CharacterCodes2["greaterThan"] = 62] = "greaterThan";
        CharacterCodes2[CharacterCodes2["hash"] = 35] = "hash";
        CharacterCodes2[CharacterCodes2["lessThan"] = 60] = "lessThan";
        CharacterCodes2[CharacterCodes2["minus"] = 45] = "minus";
        CharacterCodes2[CharacterCodes2["openBrace"] = 123] = "openBrace";
        CharacterCodes2[CharacterCodes2["openBracket"] = 91] = "openBracket";
        CharacterCodes2[CharacterCodes2["openParen"] = 40] = "openParen";
        CharacterCodes2[CharacterCodes2["percent"] = 37] = "percent";
        CharacterCodes2[CharacterCodes2["plus"] = 43] = "plus";
        CharacterCodes2[CharacterCodes2["question"] = 63] = "question";
        CharacterCodes2[CharacterCodes2["semicolon"] = 59] = "semicolon";
        CharacterCodes2[CharacterCodes2["singleQuote"] = 39] = "singleQuote";
        CharacterCodes2[CharacterCodes2["slash"] = 47] = "slash";
        CharacterCodes2[CharacterCodes2["tilde"] = 126] = "tilde";
        CharacterCodes2[CharacterCodes2["backspace"] = 8] = "backspace";
        CharacterCodes2[CharacterCodes2["formFeed"] = 12] = "formFeed";
        CharacterCodes2[CharacterCodes2["byteOrderMark"] = 65279] = "byteOrderMark";
        CharacterCodes2[CharacterCodes2["tab"] = 9] = "tab";
        CharacterCodes2[CharacterCodes2["verticalTab"] = 11] = "verticalTab";
      })(CharacterCodes = ts2.CharacterCodes || (ts2.CharacterCodes = {}));
      var Extension;
      (function(Extension2) {
        Extension2["Ts"] = ".ts";
        Extension2["Tsx"] = ".tsx";
        Extension2["Dts"] = ".d.ts";
        Extension2["Js"] = ".js";
        Extension2["Jsx"] = ".jsx";
        Extension2["Json"] = ".json";
        Extension2["TsBuildInfo"] = ".tsbuildinfo";
        Extension2["Mjs"] = ".mjs";
        Extension2["Mts"] = ".mts";
        Extension2["Dmts"] = ".d.mts";
        Extension2["Cjs"] = ".cjs";
        Extension2["Cts"] = ".cts";
        Extension2["Dcts"] = ".d.cts";
      })(Extension = ts2.Extension || (ts2.Extension = {}));
      var TransformFlags;
      (function(TransformFlags2) {
        TransformFlags2[TransformFlags2["None"] = 0] = "None";
        TransformFlags2[TransformFlags2["ContainsTypeScript"] = 1] = "ContainsTypeScript";
        TransformFlags2[TransformFlags2["ContainsJsx"] = 2] = "ContainsJsx";
        TransformFlags2[TransformFlags2["ContainsESNext"] = 4] = "ContainsESNext";
        TransformFlags2[TransformFlags2["ContainsES2022"] = 8] = "ContainsES2022";
        TransformFlags2[TransformFlags2["ContainsES2021"] = 16] = "ContainsES2021";
        TransformFlags2[TransformFlags2["ContainsES2020"] = 32] = "ContainsES2020";
        TransformFlags2[TransformFlags2["ContainsES2019"] = 64] = "ContainsES2019";
        TransformFlags2[TransformFlags2["ContainsES2018"] = 128] = "ContainsES2018";
        TransformFlags2[TransformFlags2["ContainsES2017"] = 256] = "ContainsES2017";
        TransformFlags2[TransformFlags2["ContainsES2016"] = 512] = "ContainsES2016";
        TransformFlags2[TransformFlags2["ContainsES2015"] = 1024] = "ContainsES2015";
        TransformFlags2[TransformFlags2["ContainsGenerator"] = 2048] = "ContainsGenerator";
        TransformFlags2[TransformFlags2["ContainsDestructuringAssignment"] = 4096] = "ContainsDestructuringAssignment";
        TransformFlags2[TransformFlags2["ContainsTypeScriptClassSyntax"] = 8192] = "ContainsTypeScriptClassSyntax";
        TransformFlags2[TransformFlags2["ContainsLexicalThis"] = 16384] = "ContainsLexicalThis";
        TransformFlags2[TransformFlags2["ContainsRestOrSpread"] = 32768] = "ContainsRestOrSpread";
        TransformFlags2[TransformFlags2["ContainsObjectRestOrSpread"] = 65536] = "ContainsObjectRestOrSpread";
        TransformFlags2[TransformFlags2["ContainsComputedPropertyName"] = 131072] = "ContainsComputedPropertyName";
        TransformFlags2[TransformFlags2["ContainsBlockScopedBinding"] = 262144] = "ContainsBlockScopedBinding";
        TransformFlags2[TransformFlags2["ContainsBindingPattern"] = 524288] = "ContainsBindingPattern";
        TransformFlags2[TransformFlags2["ContainsYield"] = 1048576] = "ContainsYield";
        TransformFlags2[TransformFlags2["ContainsAwait"] = 2097152] = "ContainsAwait";
        TransformFlags2[TransformFlags2["ContainsHoistedDeclarationOrCompletion"] = 4194304] = "ContainsHoistedDeclarationOrCompletion";
        TransformFlags2[TransformFlags2["ContainsDynamicImport"] = 8388608] = "ContainsDynamicImport";
        TransformFlags2[TransformFlags2["ContainsClassFields"] = 16777216] = "ContainsClassFields";
        TransformFlags2[TransformFlags2["ContainsDecorators"] = 33554432] = "ContainsDecorators";
        TransformFlags2[TransformFlags2["ContainsPossibleTopLevelAwait"] = 67108864] = "ContainsPossibleTopLevelAwait";
        TransformFlags2[TransformFlags2["ContainsLexicalSuper"] = 134217728] = "ContainsLexicalSuper";
        TransformFlags2[TransformFlags2["ContainsUpdateExpressionForIdentifier"] = 268435456] = "ContainsUpdateExpressionForIdentifier";
        TransformFlags2[TransformFlags2["ContainsPrivateIdentifierInExpression"] = 536870912] = "ContainsPrivateIdentifierInExpression";
        TransformFlags2[TransformFlags2["HasComputedFlags"] = -2147483648] = "HasComputedFlags";
        TransformFlags2[TransformFlags2["AssertTypeScript"] = 1] = "AssertTypeScript";
        TransformFlags2[TransformFlags2["AssertJsx"] = 2] = "AssertJsx";
        TransformFlags2[TransformFlags2["AssertESNext"] = 4] = "AssertESNext";
        TransformFlags2[TransformFlags2["AssertES2022"] = 8] = "AssertES2022";
        TransformFlags2[TransformFlags2["AssertES2021"] = 16] = "AssertES2021";
        TransformFlags2[TransformFlags2["AssertES2020"] = 32] = "AssertES2020";
        TransformFlags2[TransformFlags2["AssertES2019"] = 64] = "AssertES2019";
        TransformFlags2[TransformFlags2["AssertES2018"] = 128] = "AssertES2018";
        TransformFlags2[TransformFlags2["AssertES2017"] = 256] = "AssertES2017";
        TransformFlags2[TransformFlags2["AssertES2016"] = 512] = "AssertES2016";
        TransformFlags2[TransformFlags2["AssertES2015"] = 1024] = "AssertES2015";
        TransformFlags2[TransformFlags2["AssertGenerator"] = 2048] = "AssertGenerator";
        TransformFlags2[TransformFlags2["AssertDestructuringAssignment"] = 4096] = "AssertDestructuringAssignment";
        TransformFlags2[TransformFlags2["OuterExpressionExcludes"] = -2147483648] = "OuterExpressionExcludes";
        TransformFlags2[TransformFlags2["PropertyAccessExcludes"] = -2147483648] = "PropertyAccessExcludes";
        TransformFlags2[TransformFlags2["NodeExcludes"] = -2147483648] = "NodeExcludes";
        TransformFlags2[TransformFlags2["ArrowFunctionExcludes"] = -2072174592] = "ArrowFunctionExcludes";
        TransformFlags2[TransformFlags2["FunctionExcludes"] = -1937940480] = "FunctionExcludes";
        TransformFlags2[TransformFlags2["ConstructorExcludes"] = -1937948672] = "ConstructorExcludes";
        TransformFlags2[TransformFlags2["MethodOrAccessorExcludes"] = -2005057536] = "MethodOrAccessorExcludes";
        TransformFlags2[TransformFlags2["PropertyExcludes"] = -2013249536] = "PropertyExcludes";
        TransformFlags2[TransformFlags2["ClassExcludes"] = -2147344384] = "ClassExcludes";
        TransformFlags2[TransformFlags2["ModuleExcludes"] = -1941676032] = "ModuleExcludes";
        TransformFlags2[TransformFlags2["TypeExcludes"] = -2] = "TypeExcludes";
        TransformFlags2[TransformFlags2["ObjectLiteralExcludes"] = -2147278848] = "ObjectLiteralExcludes";
        TransformFlags2[TransformFlags2["ArrayLiteralOrCallOrNewExcludes"] = -2147450880] = "ArrayLiteralOrCallOrNewExcludes";
        TransformFlags2[TransformFlags2["VariableDeclarationListExcludes"] = -2146893824] = "VariableDeclarationListExcludes";
        TransformFlags2[TransformFlags2["ParameterExcludes"] = -2147483648] = "ParameterExcludes";
        TransformFlags2[TransformFlags2["CatchClauseExcludes"] = -2147418112] = "CatchClauseExcludes";
        TransformFlags2[TransformFlags2["BindingPatternExcludes"] = -2147450880] = "BindingPatternExcludes";
        TransformFlags2[TransformFlags2["ContainsLexicalThisOrSuper"] = 134234112] = "ContainsLexicalThisOrSuper";
        TransformFlags2[TransformFlags2["PropertyNamePropagatingFlags"] = 134234112] = "PropertyNamePropagatingFlags";
      })(TransformFlags = ts2.TransformFlags || (ts2.TransformFlags = {}));
      var SnippetKind;
      (function(SnippetKind2) {
        SnippetKind2[SnippetKind2["TabStop"] = 0] = "TabStop";
        SnippetKind2[SnippetKind2["Placeholder"] = 1] = "Placeholder";
        SnippetKind2[SnippetKind2["Choice"] = 2] = "Choice";
        SnippetKind2[SnippetKind2["Variable"] = 3] = "Variable";
      })(SnippetKind = ts2.SnippetKind || (ts2.SnippetKind = {}));
      var EmitFlags;
      (function(EmitFlags2) {
        EmitFlags2[EmitFlags2["None"] = 0] = "None";
        EmitFlags2[EmitFlags2["SingleLine"] = 1] = "SingleLine";
        EmitFlags2[EmitFlags2["AdviseOnEmitNode"] = 2] = "AdviseOnEmitNode";
        EmitFlags2[EmitFlags2["NoSubstitution"] = 4] = "NoSubstitution";
        EmitFlags2[EmitFlags2["CapturesThis"] = 8] = "CapturesThis";
        EmitFlags2[EmitFlags2["NoLeadingSourceMap"] = 16] = "NoLeadingSourceMap";
        EmitFlags2[EmitFlags2["NoTrailingSourceMap"] = 32] = "NoTrailingSourceMap";
        EmitFlags2[EmitFlags2["NoSourceMap"] = 48] = "NoSourceMap";
        EmitFlags2[EmitFlags2["NoNestedSourceMaps"] = 64] = "NoNestedSourceMaps";
        EmitFlags2[EmitFlags2["NoTokenLeadingSourceMaps"] = 128] = "NoTokenLeadingSourceMaps";
        EmitFlags2[EmitFlags2["NoTokenTrailingSourceMaps"] = 256] = "NoTokenTrailingSourceMaps";
        EmitFlags2[EmitFlags2["NoTokenSourceMaps"] = 384] = "NoTokenSourceMaps";
        EmitFlags2[EmitFlags2["NoLeadingComments"] = 512] = "NoLeadingComments";
        EmitFlags2[EmitFlags2["NoTrailingComments"] = 1024] = "NoTrailingComments";
        EmitFlags2[EmitFlags2["NoComments"] = 1536] = "NoComments";
        EmitFlags2[EmitFlags2["NoNestedComments"] = 2048] = "NoNestedComments";
        EmitFlags2[EmitFlags2["HelperName"] = 4096] = "HelperName";
        EmitFlags2[EmitFlags2["ExportName"] = 8192] = "ExportName";
        EmitFlags2[EmitFlags2["LocalName"] = 16384] = "LocalName";
        EmitFlags2[EmitFlags2["InternalName"] = 32768] = "InternalName";
        EmitFlags2[EmitFlags2["Indented"] = 65536] = "Indented";
        EmitFlags2[EmitFlags2["NoIndentation"] = 131072] = "NoIndentation";
        EmitFlags2[EmitFlags2["AsyncFunctionBody"] = 262144] = "AsyncFunctionBody";
        EmitFlags2[EmitFlags2["ReuseTempVariableScope"] = 524288] = "ReuseTempVariableScope";
        EmitFlags2[EmitFlags2["CustomPrologue"] = 1048576] = "CustomPrologue";
        EmitFlags2[EmitFlags2["NoHoisting"] = 2097152] = "NoHoisting";
        EmitFlags2[EmitFlags2["HasEndOfDeclarationMarker"] = 4194304] = "HasEndOfDeclarationMarker";
        EmitFlags2[EmitFlags2["Iterator"] = 8388608] = "Iterator";
        EmitFlags2[EmitFlags2["NoAsciiEscaping"] = 16777216] = "NoAsciiEscaping";
        EmitFlags2[EmitFlags2["TypeScriptClassWrapper"] = 33554432] = "TypeScriptClassWrapper";
        EmitFlags2[EmitFlags2["NeverApplyImportHelper"] = 67108864] = "NeverApplyImportHelper";
        EmitFlags2[EmitFlags2["IgnoreSourceNewlines"] = 134217728] = "IgnoreSourceNewlines";
        EmitFlags2[EmitFlags2["Immutable"] = 268435456] = "Immutable";
        EmitFlags2[EmitFlags2["IndirectCall"] = 536870912] = "IndirectCall";
      })(EmitFlags = ts2.EmitFlags || (ts2.EmitFlags = {}));
      var ExternalEmitHelpers;
      (function(ExternalEmitHelpers2) {
        ExternalEmitHelpers2[ExternalEmitHelpers2["Extends"] = 1] = "Extends";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Assign"] = 2] = "Assign";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Rest"] = 4] = "Rest";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Decorate"] = 8] = "Decorate";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Metadata"] = 16] = "Metadata";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Param"] = 32] = "Param";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Awaiter"] = 64] = "Awaiter";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Generator"] = 128] = "Generator";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Values"] = 256] = "Values";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Read"] = 512] = "Read";
        ExternalEmitHelpers2[ExternalEmitHelpers2["SpreadArray"] = 1024] = "SpreadArray";
        ExternalEmitHelpers2[ExternalEmitHelpers2["Await"] = 2048] = "Await";
        ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncGenerator"] = 4096] = "AsyncGenerator";
        ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncDelegator"] = 8192] = "AsyncDelegator";
        ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncValues"] = 16384] = "AsyncValues";
        ExternalEmitHelpers2[ExternalEmitHelpers2["ExportStar"] = 32768] = "ExportStar";
        ExternalEmitHelpers2[ExternalEmitHelpers2["ImportStar"] = 65536] = "ImportStar";
        ExternalEmitHelpers2[ExternalEmitHelpers2["ImportDefault"] = 131072] = "ImportDefault";
        ExternalEmitHelpers2[ExternalEmitHelpers2["MakeTemplateObject"] = 262144] = "MakeTemplateObject";
        ExternalEmitHelpers2[ExternalEmitHelpers2["ClassPrivateFieldGet"] = 524288] = "ClassPrivateFieldGet";
        ExternalEmitHelpers2[ExternalEmitHelpers2["ClassPrivateFieldSet"] = 1048576] = "ClassPrivateFieldSet";
        ExternalEmitHelpers2[ExternalEmitHelpers2["ClassPrivateFieldIn"] = 2097152] = "ClassPrivateFieldIn";
        ExternalEmitHelpers2[ExternalEmitHelpers2["CreateBinding"] = 4194304] = "CreateBinding";
        ExternalEmitHelpers2[ExternalEmitHelpers2["FirstEmitHelper"] = 1] = "FirstEmitHelper";
        ExternalEmitHelpers2[ExternalEmitHelpers2["LastEmitHelper"] = 4194304] = "LastEmitHelper";
        ExternalEmitHelpers2[ExternalEmitHelpers2["ForOfIncludes"] = 256] = "ForOfIncludes";
        ExternalEmitHelpers2[ExternalEmitHelpers2["ForAwaitOfIncludes"] = 16384] = "ForAwaitOfIncludes";
        ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncGeneratorIncludes"] = 6144] = "AsyncGeneratorIncludes";
        ExternalEmitHelpers2[ExternalEmitHelpers2["AsyncDelegatorIncludes"] = 26624] = "AsyncDelegatorIncludes";
        ExternalEmitHelpers2[ExternalEmitHelpers2["SpreadIncludes"] = 1536] = "SpreadIncludes";
      })(ExternalEmitHelpers = ts2.ExternalEmitHelpers || (ts2.ExternalEmitHelpers = {}));
      var EmitHint;
      (function(EmitHint2) {
        EmitHint2[EmitHint2["SourceFile"] = 0] = "SourceFile";
        EmitHint2[EmitHint2["Expression"] = 1] = "Expression";
        EmitHint2[EmitHint2["IdentifierName"] = 2] = "IdentifierName";
        EmitHint2[EmitHint2["MappedTypeParameter"] = 3] = "MappedTypeParameter";
        EmitHint2[EmitHint2["Unspecified"] = 4] = "Unspecified";
        EmitHint2[EmitHint2["EmbeddedStatement"] = 5] = "EmbeddedStatement";
        EmitHint2[EmitHint2["JsxAttributeValue"] = 6] = "JsxAttributeValue";
      })(EmitHint = ts2.EmitHint || (ts2.EmitHint = {}));
      var OuterExpressionKinds;
      (function(OuterExpressionKinds2) {
        OuterExpressionKinds2[OuterExpressionKinds2["Parentheses"] = 1] = "Parentheses";
        OuterExpressionKinds2[OuterExpressionKinds2["TypeAssertions"] = 2] = "TypeAssertions";
        OuterExpressionKinds2[OuterExpressionKinds2["NonNullAssertions"] = 4] = "NonNullAssertions";
        OuterExpressionKinds2[OuterExpressionKinds2["PartiallyEmittedExpressions"] = 8] = "PartiallyEmittedExpressions";
        OuterExpressionKinds2[OuterExpressionKinds2["Assertions"] = 6] = "Assertions";
        OuterExpressionKinds2[OuterExpressionKinds2["All"] = 15] = "All";
        OuterExpressionKinds2[OuterExpressionKinds2["ExcludeJSDocTypeAssertion"] = 16] = "ExcludeJSDocTypeAssertion";
      })(OuterExpressionKinds = ts2.OuterExpressionKinds || (ts2.OuterExpressionKinds = {}));
      var LexicalEnvironmentFlags;
      (function(LexicalEnvironmentFlags2) {
        LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["None"] = 0] = "None";
        LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["InParameters"] = 1] = "InParameters";
        LexicalEnvironmentFlags2[LexicalEnvironmentFlags2["VariablesHoistedInParameters"] = 2] = "VariablesHoistedInParameters";
      })(LexicalEnvironmentFlags = ts2.LexicalEnvironmentFlags || (ts2.LexicalEnvironmentFlags = {}));
      var BundleFileSectionKind;
      (function(BundleFileSectionKind2) {
        BundleFileSectionKind2["Prologue"] = "prologue";
        BundleFileSectionKind2["EmitHelpers"] = "emitHelpers";
        BundleFileSectionKind2["NoDefaultLib"] = "no-default-lib";
        BundleFileSectionKind2["Reference"] = "reference";
        BundleFileSectionKind2["Type"] = "type";
        BundleFileSectionKind2["TypeResolutionModeRequire"] = "type-require";
        BundleFileSectionKind2["TypeResolutionModeImport"] = "type-import";
        BundleFileSectionKind2["Lib"] = "lib";
        BundleFileSectionKind2["Prepend"] = "prepend";
        BundleFileSectionKind2["Text"] = "text";
        BundleFileSectionKind2["Internal"] = "internal";
      })(BundleFileSectionKind = ts2.BundleFileSectionKind || (ts2.BundleFileSectionKind = {}));
      var ListFormat;
      (function(ListFormat2) {
        ListFormat2[ListFormat2["None"] = 0] = "None";
        ListFormat2[ListFormat2["SingleLine"] = 0] = "SingleLine";
        ListFormat2[ListFormat2["MultiLine"] = 1] = "MultiLine";
        ListFormat2[ListFormat2["PreserveLines"] = 2] = "PreserveLines";
        ListFormat2[ListFormat2["LinesMask"] = 3] = "LinesMask";
        ListFormat2[ListFormat2["NotDelimited"] = 0] = "NotDelimited";
        ListFormat2[ListFormat2["BarDelimited"] = 4] = "BarDelimited";
        ListFormat2[ListFormat2["AmpersandDelimited"] = 8] = "AmpersandDelimited";
        ListFormat2[ListFormat2["CommaDelimited"] = 16] = "CommaDelimited";
        ListFormat2[ListFormat2["AsteriskDelimited"] = 32] = "AsteriskDelimited";
        ListFormat2[ListFormat2["DelimitersMask"] = 60] = "DelimitersMask";
        ListFormat2[ListFormat2["AllowTrailingComma"] = 64] = "AllowTrailingComma";
        ListFormat2[ListFormat2["Indented"] = 128] = "Indented";
        ListFormat2[ListFormat2["SpaceBetweenBraces"] = 256] = "SpaceBetweenBraces";
        ListFormat2[ListFormat2["SpaceBetweenSiblings"] = 512] = "SpaceBetweenSiblings";
        ListFormat2[ListFormat2["Braces"] = 1024] = "Braces";
        ListFormat2[ListFormat2["Parenthesis"] = 2048] = "Parenthesis";
        ListFormat2[ListFormat2["AngleBrackets"] = 4096] = "AngleBrackets";
        ListFormat2[ListFormat2["SquareBrackets"] = 8192] = "SquareBrackets";
        ListFormat2[ListFormat2["BracketsMask"] = 15360] = "BracketsMask";
        ListFormat2[ListFormat2["OptionalIfUndefined"] = 16384] = "OptionalIfUndefined";
        ListFormat2[ListFormat2["OptionalIfEmpty"] = 32768] = "OptionalIfEmpty";
        ListFormat2[ListFormat2["Optional"] = 49152] = "Optional";
        ListFormat2[ListFormat2["PreferNewLine"] = 65536] = "PreferNewLine";
        ListFormat2[ListFormat2["NoTrailingNewLine"] = 131072] = "NoTrailingNewLine";
        ListFormat2[ListFormat2["NoInterveningComments"] = 262144] = "NoInterveningComments";
        ListFormat2[ListFormat2["NoSpaceIfEmpty"] = 524288] = "NoSpaceIfEmpty";
        ListFormat2[ListFormat2["SingleElement"] = 1048576] = "SingleElement";
        ListFormat2[ListFormat2["SpaceAfterList"] = 2097152] = "SpaceAfterList";
        ListFormat2[ListFormat2["Modifiers"] = 2359808] = "Modifiers";
        ListFormat2[ListFormat2["HeritageClauses"] = 512] = "HeritageClauses";
        ListFormat2[ListFormat2["SingleLineTypeLiteralMembers"] = 768] = "SingleLineTypeLiteralMembers";
        ListFormat2[ListFormat2["MultiLineTypeLiteralMembers"] = 32897] = "MultiLineTypeLiteralMembers";
        ListFormat2[ListFormat2["SingleLineTupleTypeElements"] = 528] = "SingleLineTupleTypeElements";
        ListFormat2[ListFormat2["MultiLineTupleTypeElements"] = 657] = "MultiLineTupleTypeElements";
        ListFormat2[ListFormat2["UnionTypeConstituents"] = 516] = "UnionTypeConstituents";
        ListFormat2[ListFormat2["IntersectionTypeConstituents"] = 520] = "IntersectionTypeConstituents";
        ListFormat2[ListFormat2["ObjectBindingPatternElements"] = 525136] = "ObjectBindingPatternElements";
        ListFormat2[ListFormat2["ArrayBindingPatternElements"] = 524880] = "ArrayBindingPatternElements";
        ListFormat2[ListFormat2["ObjectLiteralExpressionProperties"] = 526226] = "ObjectLiteralExpressionProperties";
        ListFormat2[ListFormat2["ImportClauseEntries"] = 526226] = "ImportClauseEntries";
        ListFormat2[ListFormat2["ArrayLiteralExpressionElements"] = 8914] = "ArrayLiteralExpressionElements";
        ListFormat2[ListFormat2["CommaListElements"] = 528] = "CommaListElements";
        ListFormat2[ListFormat2["CallExpressionArguments"] = 2576] = "CallExpressionArguments";
        ListFormat2[ListFormat2["NewExpressionArguments"] = 18960] = "NewExpressionArguments";
        ListFormat2[ListFormat2["TemplateExpressionSpans"] = 262144] = "TemplateExpressionSpans";
        ListFormat2[ListFormat2["SingleLineBlockStatements"] = 768] = "SingleLineBlockStatements";
        ListFormat2[ListFormat2["MultiLineBlockStatements"] = 129] = "MultiLineBlockStatements";
        ListFormat2[ListFormat2["VariableDeclarationList"] = 528] = "VariableDeclarationList";
        ListFormat2[ListFormat2["SingleLineFunctionBodyStatements"] = 768] = "SingleLineFunctionBodyStatements";
        ListFormat2[ListFormat2["MultiLineFunctionBodyStatements"] = 1] = "MultiLineFunctionBodyStatements";
        ListFormat2[ListFormat2["ClassHeritageClauses"] = 0] = "ClassHeritageClauses";
        ListFormat2[ListFormat2["ClassMembers"] = 129] = "ClassMembers";
        ListFormat2[ListFormat2["InterfaceMembers"] = 129] = "InterfaceMembers";
        ListFormat2[ListFormat2["EnumMembers"] = 145] = "EnumMembers";
        ListFormat2[ListFormat2["CaseBlockClauses"] = 129] = "CaseBlockClauses";
        ListFormat2[ListFormat2["NamedImportsOrExportsElements"] = 525136] = "NamedImportsOrExportsElements";
        ListFormat2[ListFormat2["JsxElementOrFragmentChildren"] = 262144] = "JsxElementOrFragmentChildren";
        ListFormat2[ListFormat2["JsxElementAttributes"] = 262656] = "JsxElementAttributes";
        ListFormat2[ListFormat2["CaseOrDefaultClauseStatements"] = 163969] = "CaseOrDefaultClauseStatements";
        ListFormat2[ListFormat2["HeritageClauseTypes"] = 528] = "HeritageClauseTypes";
        ListFormat2[ListFormat2["SourceFileStatements"] = 131073] = "SourceFileStatements";
        ListFormat2[ListFormat2["Decorators"] = 2146305] = "Decorators";
        ListFormat2[ListFormat2["TypeArguments"] = 53776] = "TypeArguments";
        ListFormat2[ListFormat2["TypeParameters"] = 53776] = "TypeParameters";
        ListFormat2[ListFormat2["Parameters"] = 2576] = "Parameters";
        ListFormat2[ListFormat2["IndexSignatureParameters"] = 8848] = "IndexSignatureParameters";
        ListFormat2[ListFormat2["JSDocComment"] = 33] = "JSDocComment";
      })(ListFormat = ts2.ListFormat || (ts2.ListFormat = {}));
      var PragmaKindFlags;
      (function(PragmaKindFlags2) {
        PragmaKindFlags2[PragmaKindFlags2["None"] = 0] = "None";
        PragmaKindFlags2[PragmaKindFlags2["TripleSlashXML"] = 1] = "TripleSlashXML";
        PragmaKindFlags2[PragmaKindFlags2["SingleLine"] = 2] = "SingleLine";
        PragmaKindFlags2[PragmaKindFlags2["MultiLine"] = 4] = "MultiLine";
        PragmaKindFlags2[PragmaKindFlags2["All"] = 7] = "All";
        PragmaKindFlags2[PragmaKindFlags2["Default"] = 7] = "Default";
      })(PragmaKindFlags = ts2.PragmaKindFlags || (ts2.PragmaKindFlags = {}));
      ts2.commentPragmas = {
        "reference": {
          args: [
            { name: "types", optional: true, captureSpan: true },
            { name: "lib", optional: true, captureSpan: true },
            { name: "path", optional: true, captureSpan: true },
            { name: "no-default-lib", optional: true },
            { name: "resolution-mode", optional: true }
          ],
          kind: 1
        },
        "amd-dependency": {
          args: [{ name: "path" }, { name: "name", optional: true }],
          kind: 1
        },
        "amd-module": {
          args: [{ name: "name" }],
          kind: 1
        },
        "ts-check": {
          kind: 2
        },
        "ts-nocheck": {
          kind: 2
        },
        "jsx": {
          args: [{ name: "factory" }],
          kind: 4
        },
        "jsxfrag": {
          args: [{ name: "factory" }],
          kind: 4
        },
        "jsximportsource": {
          args: [{ name: "factory" }],
          kind: 4
        },
        "jsxruntime": {
          args: [{ name: "factory" }],
          kind: 4
        }
      };
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      function generateDjb2Hash(data) {
        var acc = 5381;
        for (var i = 0; i < data.length; i++) {
          acc = (acc << 5) + acc + data.charCodeAt(i);
        }
        return acc.toString();
      }
      ts2.generateDjb2Hash = generateDjb2Hash;
      function setStackTraceLimit() {
        if (Error.stackTraceLimit < 100) {
          Error.stackTraceLimit = 100;
        }
      }
      ts2.setStackTraceLimit = setStackTraceLimit;
      var FileWatcherEventKind;
      (function(FileWatcherEventKind2) {
        FileWatcherEventKind2[FileWatcherEventKind2["Created"] = 0] = "Created";
        FileWatcherEventKind2[FileWatcherEventKind2["Changed"] = 1] = "Changed";
        FileWatcherEventKind2[FileWatcherEventKind2["Deleted"] = 2] = "Deleted";
      })(FileWatcherEventKind = ts2.FileWatcherEventKind || (ts2.FileWatcherEventKind = {}));
      var PollingInterval;
      (function(PollingInterval2) {
        PollingInterval2[PollingInterval2["High"] = 2e3] = "High";
        PollingInterval2[PollingInterval2["Medium"] = 500] = "Medium";
        PollingInterval2[PollingInterval2["Low"] = 250] = "Low";
      })(PollingInterval = ts2.PollingInterval || (ts2.PollingInterval = {}));
      ts2.missingFileModifiedTime = new Date(0);
      function getModifiedTime(host, fileName) {
        return host.getModifiedTime(fileName) || ts2.missingFileModifiedTime;
      }
      ts2.getModifiedTime = getModifiedTime;
      function createPollingIntervalBasedLevels(levels) {
        var _a;
        return _a = {}, _a[PollingInterval.Low] = levels.Low, _a[PollingInterval.Medium] = levels.Medium, _a[PollingInterval.High] = levels.High, _a;
      }
      var defaultChunkLevels = { Low: 32, Medium: 64, High: 256 };
      var pollingChunkSize = createPollingIntervalBasedLevels(defaultChunkLevels);
      ts2.unchangedPollThresholds = createPollingIntervalBasedLevels(defaultChunkLevels);
      function setCustomPollingValues(system) {
        if (!system.getEnvironmentVariable) {
          return;
        }
        var pollingIntervalChanged = setCustomLevels("TSC_WATCH_POLLINGINTERVAL", PollingInterval);
        pollingChunkSize = getCustomPollingBasedLevels("TSC_WATCH_POLLINGCHUNKSIZE", defaultChunkLevels) || pollingChunkSize;
        ts2.unchangedPollThresholds = getCustomPollingBasedLevels("TSC_WATCH_UNCHANGEDPOLLTHRESHOLDS", defaultChunkLevels) || ts2.unchangedPollThresholds;
        function getLevel(envVar, level) {
          return system.getEnvironmentVariable("".concat(envVar, "_").concat(level.toUpperCase()));
        }
        function getCustomLevels(baseVariable) {
          var customLevels;
          setCustomLevel("Low");
          setCustomLevel("Medium");
          setCustomLevel("High");
          return customLevels;
          function setCustomLevel(level) {
            var customLevel = getLevel(baseVariable, level);
            if (customLevel) {
              (customLevels || (customLevels = {}))[level] = Number(customLevel);
            }
          }
        }
        function setCustomLevels(baseVariable, levels) {
          var customLevels = getCustomLevels(baseVariable);
          if (customLevels) {
            setLevel("Low");
            setLevel("Medium");
            setLevel("High");
            return true;
          }
          return false;
          function setLevel(level) {
            levels[level] = customLevels[level] || levels[level];
          }
        }
        function getCustomPollingBasedLevels(baseVariable, defaultLevels) {
          var customLevels = getCustomLevels(baseVariable);
          return (pollingIntervalChanged || customLevels) && createPollingIntervalBasedLevels(customLevels ? __assign(__assign({}, defaultLevels), customLevels) : defaultLevels);
        }
      }
      ts2.setCustomPollingValues = setCustomPollingValues;
      function pollWatchedFileQueue(host, queue, pollIndex, chunkSize, callbackOnWatchFileStat) {
        var definedValueCopyToIndex = pollIndex;
        for (var canVisit = queue.length; chunkSize && canVisit; nextPollIndex(), canVisit--) {
          var watchedFile = queue[pollIndex];
          if (!watchedFile) {
            continue;
          } else if (watchedFile.isClosed) {
            queue[pollIndex] = void 0;
            continue;
          }
          chunkSize--;
          var fileChanged = onWatchedFileStat(watchedFile, getModifiedTime(host, watchedFile.fileName));
          if (watchedFile.isClosed) {
            queue[pollIndex] = void 0;
            continue;
          }
          callbackOnWatchFileStat === null || callbackOnWatchFileStat === void 0 ? void 0 : callbackOnWatchFileStat(watchedFile, pollIndex, fileChanged);
          if (queue[pollIndex]) {
            if (definedValueCopyToIndex < pollIndex) {
              queue[definedValueCopyToIndex] = watchedFile;
              queue[pollIndex] = void 0;
            }
            definedValueCopyToIndex++;
          }
        }
        return pollIndex;
        function nextPollIndex() {
          pollIndex++;
          if (pollIndex === queue.length) {
            if (definedValueCopyToIndex < pollIndex) {
              queue.length = definedValueCopyToIndex;
            }
            pollIndex = 0;
            definedValueCopyToIndex = 0;
          }
        }
      }
      function createDynamicPriorityPollingWatchFile(host) {
        var watchedFiles = [];
        var changedFilesInLastPoll = [];
        var lowPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.Low);
        var mediumPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.Medium);
        var highPollingIntervalQueue = createPollingIntervalQueue(PollingInterval.High);
        return watchFile;
        function watchFile(fileName, callback, defaultPollingInterval) {
          var file = {
            fileName,
            callback,
            unchangedPolls: 0,
            mtime: getModifiedTime(host, fileName)
          };
          watchedFiles.push(file);
          addToPollingIntervalQueue(file, defaultPollingInterval);
          return {
            close: function() {
              file.isClosed = true;
              ts2.unorderedRemoveItem(watchedFiles, file);
            }
          };
        }
        function createPollingIntervalQueue(pollingInterval) {
          var queue = [];
          queue.pollingInterval = pollingInterval;
          queue.pollIndex = 0;
          queue.pollScheduled = false;
          return queue;
        }
        function pollPollingIntervalQueue(queue) {
          queue.pollIndex = pollQueue(queue, queue.pollingInterval, queue.pollIndex, pollingChunkSize[queue.pollingInterval]);
          if (queue.length) {
            scheduleNextPoll(queue.pollingInterval);
          } else {
            ts2.Debug.assert(queue.pollIndex === 0);
            queue.pollScheduled = false;
          }
        }
        function pollLowPollingIntervalQueue(queue) {
          pollQueue(changedFilesInLastPoll, PollingInterval.Low, 0, changedFilesInLastPoll.length);
          pollPollingIntervalQueue(queue);
          if (!queue.pollScheduled && changedFilesInLastPoll.length) {
            scheduleNextPoll(PollingInterval.Low);
          }
        }
        function pollQueue(queue, pollingInterval, pollIndex, chunkSize) {
          return pollWatchedFileQueue(host, queue, pollIndex, chunkSize, onWatchFileStat);
          function onWatchFileStat(watchedFile, pollIndex2, fileChanged) {
            if (fileChanged) {
              watchedFile.unchangedPolls = 0;
              if (queue !== changedFilesInLastPoll) {
                queue[pollIndex2] = void 0;
                addChangedFileToLowPollingIntervalQueue(watchedFile);
              }
            } else if (watchedFile.unchangedPolls !== ts2.unchangedPollThresholds[pollingInterval]) {
              watchedFile.unchangedPolls++;
            } else if (queue === changedFilesInLastPoll) {
              watchedFile.unchangedPolls = 1;
              queue[pollIndex2] = void 0;
              addToPollingIntervalQueue(watchedFile, PollingInterval.Low);
            } else if (pollingInterval !== PollingInterval.High) {
              watchedFile.unchangedPolls++;
              queue[pollIndex2] = void 0;
              addToPollingIntervalQueue(watchedFile, pollingInterval === PollingInterval.Low ? PollingInterval.Medium : PollingInterval.High);
            }
          }
        }
        function pollingIntervalQueue(pollingInterval) {
          switch (pollingInterval) {
            case PollingInterval.Low:
              return lowPollingIntervalQueue;
            case PollingInterval.Medium:
              return mediumPollingIntervalQueue;
            case PollingInterval.High:
              return highPollingIntervalQueue;
          }
        }
        function addToPollingIntervalQueue(file, pollingInterval) {
          pollingIntervalQueue(pollingInterval).push(file);
          scheduleNextPollIfNotAlreadyScheduled(pollingInterval);
        }
        function addChangedFileToLowPollingIntervalQueue(file) {
          changedFilesInLastPoll.push(file);
          scheduleNextPollIfNotAlreadyScheduled(PollingInterval.Low);
        }
        function scheduleNextPollIfNotAlreadyScheduled(pollingInterval) {
          if (!pollingIntervalQueue(pollingInterval).pollScheduled) {
            scheduleNextPoll(pollingInterval);
          }
        }
        function scheduleNextPoll(pollingInterval) {
          pollingIntervalQueue(pollingInterval).pollScheduled = host.setTimeout(pollingInterval === PollingInterval.Low ? pollLowPollingIntervalQueue : pollPollingIntervalQueue, pollingInterval, pollingIntervalQueue(pollingInterval));
        }
      }
      ts2.createDynamicPriorityPollingWatchFile = createDynamicPriorityPollingWatchFile;
      function createUseFsEventsOnParentDirectoryWatchFile(fsWatch, useCaseSensitiveFileNames) {
        var fileWatcherCallbacks = ts2.createMultiMap();
        var dirWatchers = new ts2.Map();
        var toCanonicalName = ts2.createGetCanonicalFileName(useCaseSensitiveFileNames);
        return nonPollingWatchFile;
        function nonPollingWatchFile(fileName, callback, _pollingInterval, fallbackOptions) {
          var filePath = toCanonicalName(fileName);
          fileWatcherCallbacks.add(filePath, callback);
          var dirPath = ts2.getDirectoryPath(filePath) || ".";
          var watcher = dirWatchers.get(dirPath) || createDirectoryWatcher(ts2.getDirectoryPath(fileName) || ".", dirPath, fallbackOptions);
          watcher.referenceCount++;
          return {
            close: function() {
              if (watcher.referenceCount === 1) {
                watcher.close();
                dirWatchers.delete(dirPath);
              } else {
                watcher.referenceCount--;
              }
              fileWatcherCallbacks.remove(filePath, callback);
            }
          };
        }
        function createDirectoryWatcher(dirName, dirPath, fallbackOptions) {
          var watcher = fsWatch(
            dirName,
            1,
            function(_eventName, relativeFileName, modifiedTime) {
              if (!ts2.isString(relativeFileName))
                return;
              var fileName = ts2.getNormalizedAbsolutePath(relativeFileName, dirName);
              var callbacks = fileName && fileWatcherCallbacks.get(toCanonicalName(fileName));
              if (callbacks) {
                for (var _i = 0, callbacks_1 = callbacks; _i < callbacks_1.length; _i++) {
                  var fileCallback = callbacks_1[_i];
                  fileCallback(fileName, FileWatcherEventKind.Changed, modifiedTime);
                }
              }
            },
            false,
            PollingInterval.Medium,
            fallbackOptions
          );
          watcher.referenceCount = 0;
          dirWatchers.set(dirPath, watcher);
          return watcher;
        }
      }
      function createFixedChunkSizePollingWatchFile(host) {
        var watchedFiles = [];
        var pollIndex = 0;
        var pollScheduled;
        return watchFile;
        function watchFile(fileName, callback) {
          var file = {
            fileName,
            callback,
            mtime: getModifiedTime(host, fileName)
          };
          watchedFiles.push(file);
          scheduleNextPoll();
          return {
            close: function() {
              file.isClosed = true;
              ts2.unorderedRemoveItem(watchedFiles, file);
            }
          };
        }
        function pollQueue() {
          pollScheduled = void 0;
          pollIndex = pollWatchedFileQueue(host, watchedFiles, pollIndex, pollingChunkSize[PollingInterval.Low]);
          scheduleNextPoll();
        }
        function scheduleNextPoll() {
          if (!watchedFiles.length || pollScheduled)
            return;
          pollScheduled = host.setTimeout(pollQueue, PollingInterval.High);
        }
      }
      function createSingleFileWatcherPerName(watchFile, useCaseSensitiveFileNames) {
        var cache = new ts2.Map();
        var callbacksCache = ts2.createMultiMap();
        var toCanonicalFileName = ts2.createGetCanonicalFileName(useCaseSensitiveFileNames);
        return function(fileName, callback, pollingInterval, options) {
          var path = toCanonicalFileName(fileName);
          var existing = cache.get(path);
          if (existing) {
            existing.refCount++;
          } else {
            cache.set(path, {
              watcher: watchFile(fileName, function(fileName2, eventKind, modifiedTime) {
                return ts2.forEach(callbacksCache.get(path), function(cb) {
                  return cb(fileName2, eventKind, modifiedTime);
                });
              }, pollingInterval, options),
              refCount: 1
            });
          }
          callbacksCache.add(path, callback);
          return {
            close: function() {
              var watcher = ts2.Debug.checkDefined(cache.get(path));
              callbacksCache.remove(path, callback);
              watcher.refCount--;
              if (watcher.refCount)
                return;
              cache.delete(path);
              ts2.closeFileWatcherOf(watcher);
            }
          };
        };
      }
      ts2.createSingleFileWatcherPerName = createSingleFileWatcherPerName;
      function onWatchedFileStat(watchedFile, modifiedTime) {
        var oldTime = watchedFile.mtime.getTime();
        var newTime = modifiedTime.getTime();
        if (oldTime !== newTime) {
          watchedFile.mtime = modifiedTime;
          watchedFile.callback(watchedFile.fileName, getFileWatcherEventKind(oldTime, newTime), modifiedTime);
          return true;
        }
        return false;
      }
      ts2.onWatchedFileStat = onWatchedFileStat;
      function getFileWatcherEventKind(oldTime, newTime) {
        return oldTime === 0 ? FileWatcherEventKind.Created : newTime === 0 ? FileWatcherEventKind.Deleted : FileWatcherEventKind.Changed;
      }
      ts2.getFileWatcherEventKind = getFileWatcherEventKind;
      ts2.ignoredPaths = ["/node_modules/.", "/.git", "/.#"];
      var curSysLog = ts2.noop;
      function sysLog(s) {
        return curSysLog(s);
      }
      ts2.sysLog = sysLog;
      function setSysLog(logger) {
        curSysLog = logger;
      }
      ts2.setSysLog = setSysLog;
      function createDirectoryWatcherSupportingRecursive(_a) {
        var watchDirectory = _a.watchDirectory, useCaseSensitiveFileNames = _a.useCaseSensitiveFileNames, getCurrentDirectory = _a.getCurrentDirectory, getAccessibleSortedChildDirectories = _a.getAccessibleSortedChildDirectories, fileSystemEntryExists = _a.fileSystemEntryExists, realpath = _a.realpath, setTimeout2 = _a.setTimeout, clearTimeout2 = _a.clearTimeout;
        var cache = new ts2.Map();
        var callbackCache = ts2.createMultiMap();
        var cacheToUpdateChildWatches = new ts2.Map();
        var timerToUpdateChildWatches;
        var filePathComparer = ts2.getStringComparer(!useCaseSensitiveFileNames);
        var toCanonicalFilePath = ts2.createGetCanonicalFileName(useCaseSensitiveFileNames);
        return function(dirName, callback, recursive, options) {
          return recursive ? createDirectoryWatcher(dirName, options, callback) : watchDirectory(dirName, callback, recursive, options);
        };
        function createDirectoryWatcher(dirName, options, callback) {
          var dirPath = toCanonicalFilePath(dirName);
          var directoryWatcher = cache.get(dirPath);
          if (directoryWatcher) {
            directoryWatcher.refCount++;
          } else {
            directoryWatcher = {
              watcher: watchDirectory(dirName, function(fileName) {
                if (isIgnoredPath(fileName, options))
                  return;
                if (options === null || options === void 0 ? void 0 : options.synchronousWatchDirectory) {
                  invokeCallbacks(dirPath, fileName);
                  updateChildWatches(dirName, dirPath, options);
                } else {
                  nonSyncUpdateChildWatches(dirName, dirPath, fileName, options);
                }
              }, false, options),
              refCount: 1,
              childWatches: ts2.emptyArray
            };
            cache.set(dirPath, directoryWatcher);
            updateChildWatches(dirName, dirPath, options);
          }
          var callbackToAdd = callback && { dirName, callback };
          if (callbackToAdd) {
            callbackCache.add(dirPath, callbackToAdd);
          }
          return {
            dirName,
            close: function() {
              var directoryWatcher2 = ts2.Debug.checkDefined(cache.get(dirPath));
              if (callbackToAdd)
                callbackCache.remove(dirPath, callbackToAdd);
              directoryWatcher2.refCount--;
              if (directoryWatcher2.refCount)
                return;
              cache.delete(dirPath);
              ts2.closeFileWatcherOf(directoryWatcher2);
              directoryWatcher2.childWatches.forEach(ts2.closeFileWatcher);
            }
          };
        }
        function invokeCallbacks(dirPath, fileNameOrInvokeMap, fileNames) {
          var fileName;
          var invokeMap;
          if (ts2.isString(fileNameOrInvokeMap)) {
            fileName = fileNameOrInvokeMap;
          } else {
            invokeMap = fileNameOrInvokeMap;
          }
          callbackCache.forEach(function(callbacks, rootDirName) {
            var _a2;
            if (invokeMap && invokeMap.get(rootDirName) === true)
              return;
            if (rootDirName === dirPath || ts2.startsWith(dirPath, rootDirName) && dirPath[rootDirName.length] === ts2.directorySeparator) {
              if (invokeMap) {
                if (fileNames) {
                  var existing = invokeMap.get(rootDirName);
                  if (existing) {
                    (_a2 = existing).push.apply(_a2, fileNames);
                  } else {
                    invokeMap.set(rootDirName, fileNames.slice());
                  }
                } else {
                  invokeMap.set(rootDirName, true);
                }
              } else {
                callbacks.forEach(function(_a3) {
                  var callback = _a3.callback;
                  return callback(fileName);
                });
              }
            }
          });
        }
        function nonSyncUpdateChildWatches(dirName, dirPath, fileName, options) {
          var parentWatcher = cache.get(dirPath);
          if (parentWatcher && fileSystemEntryExists(dirName, 1)) {
            scheduleUpdateChildWatches(dirName, dirPath, fileName, options);
            return;
          }
          invokeCallbacks(dirPath, fileName);
          removeChildWatches(parentWatcher);
        }
        function scheduleUpdateChildWatches(dirName, dirPath, fileName, options) {
          var existing = cacheToUpdateChildWatches.get(dirPath);
          if (existing) {
            existing.fileNames.push(fileName);
          } else {
            cacheToUpdateChildWatches.set(dirPath, { dirName, options, fileNames: [fileName] });
          }
          if (timerToUpdateChildWatches) {
            clearTimeout2(timerToUpdateChildWatches);
            timerToUpdateChildWatches = void 0;
          }
          timerToUpdateChildWatches = setTimeout2(onTimerToUpdateChildWatches, 1e3);
        }
        function onTimerToUpdateChildWatches() {
          timerToUpdateChildWatches = void 0;
          sysLog("sysLog:: onTimerToUpdateChildWatches:: ".concat(cacheToUpdateChildWatches.size));
          var start = ts2.timestamp();
          var invokeMap = new ts2.Map();
          while (!timerToUpdateChildWatches && cacheToUpdateChildWatches.size) {
            var result = cacheToUpdateChildWatches.entries().next();
            ts2.Debug.assert(!result.done);
            var _a2 = result.value, dirPath = _a2[0], _b = _a2[1], dirName = _b.dirName, options = _b.options, fileNames = _b.fileNames;
            cacheToUpdateChildWatches.delete(dirPath);
            var hasChanges = updateChildWatches(dirName, dirPath, options);
            invokeCallbacks(dirPath, invokeMap, hasChanges ? void 0 : fileNames);
          }
          sysLog("sysLog:: invokingWatchers:: Elapsed:: ".concat(ts2.timestamp() - start, "ms:: ").concat(cacheToUpdateChildWatches.size));
          callbackCache.forEach(function(callbacks, rootDirName) {
            var existing = invokeMap.get(rootDirName);
            if (existing) {
              callbacks.forEach(function(_a3) {
                var callback = _a3.callback, dirName2 = _a3.dirName;
                if (ts2.isArray(existing)) {
                  existing.forEach(callback);
                } else {
                  callback(dirName2);
                }
              });
            }
          });
          var elapsed = ts2.timestamp() - start;
          sysLog("sysLog:: Elapsed:: ".concat(elapsed, "ms:: onTimerToUpdateChildWatches:: ").concat(cacheToUpdateChildWatches.size, " ").concat(timerToUpdateChildWatches));
        }
        function removeChildWatches(parentWatcher) {
          if (!parentWatcher)
            return;
          var existingChildWatches = parentWatcher.childWatches;
          parentWatcher.childWatches = ts2.emptyArray;
          for (var _i = 0, existingChildWatches_1 = existingChildWatches; _i < existingChildWatches_1.length; _i++) {
            var childWatcher = existingChildWatches_1[_i];
            childWatcher.close();
            removeChildWatches(cache.get(toCanonicalFilePath(childWatcher.dirName)));
          }
        }
        function updateChildWatches(parentDir, parentDirPath, options) {
          var parentWatcher = cache.get(parentDirPath);
          if (!parentWatcher)
            return false;
          var newChildWatches;
          var hasChanges = ts2.enumerateInsertsAndDeletes(fileSystemEntryExists(parentDir, 1) ? ts2.mapDefined(getAccessibleSortedChildDirectories(parentDir), function(child) {
            var childFullName = ts2.getNormalizedAbsolutePath(child, parentDir);
            return !isIgnoredPath(childFullName, options) && filePathComparer(childFullName, ts2.normalizePath(realpath(childFullName))) === 0 ? childFullName : void 0;
          }) : ts2.emptyArray, parentWatcher.childWatches, function(child, childWatcher) {
            return filePathComparer(child, childWatcher.dirName);
          }, createAndAddChildDirectoryWatcher, ts2.closeFileWatcher, addChildDirectoryWatcher);
          parentWatcher.childWatches = newChildWatches || ts2.emptyArray;
          return hasChanges;
          function createAndAddChildDirectoryWatcher(childName) {
            var result = createDirectoryWatcher(childName, options);
            addChildDirectoryWatcher(result);
          }
          function addChildDirectoryWatcher(childWatcher) {
            (newChildWatches || (newChildWatches = [])).push(childWatcher);
          }
        }
        function isIgnoredPath(path, options) {
          return ts2.some(ts2.ignoredPaths, function(searchPath) {
            return isInPath(path, searchPath);
          }) || isIgnoredByWatchOptions(path, options, useCaseSensitiveFileNames, getCurrentDirectory);
        }
        function isInPath(path, searchPath) {
          if (ts2.stringContains(path, searchPath))
            return true;
          if (useCaseSensitiveFileNames)
            return false;
          return ts2.stringContains(toCanonicalFilePath(path), searchPath);
        }
      }
      ts2.createDirectoryWatcherSupportingRecursive = createDirectoryWatcherSupportingRecursive;
      var FileSystemEntryKind;
      (function(FileSystemEntryKind2) {
        FileSystemEntryKind2[FileSystemEntryKind2["File"] = 0] = "File";
        FileSystemEntryKind2[FileSystemEntryKind2["Directory"] = 1] = "Directory";
      })(FileSystemEntryKind = ts2.FileSystemEntryKind || (ts2.FileSystemEntryKind = {}));
      function createFileWatcherCallback(callback) {
        return function(_fileName, eventKind, modifiedTime) {
          return callback(eventKind === FileWatcherEventKind.Changed ? "change" : "rename", "", modifiedTime);
        };
      }
      ts2.createFileWatcherCallback = createFileWatcherCallback;
      function createFsWatchCallbackForFileWatcherCallback(fileName, callback, getModifiedTime2) {
        return function(eventName, _relativeFileName, modifiedTime) {
          if (eventName === "rename") {
            modifiedTime || (modifiedTime = getModifiedTime2(fileName) || ts2.missingFileModifiedTime);
            callback(fileName, modifiedTime !== ts2.missingFileModifiedTime ? FileWatcherEventKind.Created : FileWatcherEventKind.Deleted, modifiedTime);
          } else {
            callback(fileName, FileWatcherEventKind.Changed, modifiedTime);
          }
        };
      }
      function isIgnoredByWatchOptions(pathToCheck, options, useCaseSensitiveFileNames, getCurrentDirectory) {
        return ((options === null || options === void 0 ? void 0 : options.excludeDirectories) || (options === null || options === void 0 ? void 0 : options.excludeFiles)) && (ts2.matchesExclude(pathToCheck, options === null || options === void 0 ? void 0 : options.excludeFiles, useCaseSensitiveFileNames, getCurrentDirectory()) || ts2.matchesExclude(pathToCheck, options === null || options === void 0 ? void 0 : options.excludeDirectories, useCaseSensitiveFileNames, getCurrentDirectory()));
      }
      function createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback, options, useCaseSensitiveFileNames, getCurrentDirectory) {
        return function(eventName, relativeFileName) {
          if (eventName === "rename") {
            var fileName = !relativeFileName ? directoryName : ts2.normalizePath(ts2.combinePaths(directoryName, relativeFileName));
            if (!relativeFileName || !isIgnoredByWatchOptions(fileName, options, useCaseSensitiveFileNames, getCurrentDirectory)) {
              callback(fileName);
            }
          }
        };
      }
      function createSystemWatchFunctions(_a) {
        var pollingWatchFile = _a.pollingWatchFile, getModifiedTime2 = _a.getModifiedTime, setTimeout2 = _a.setTimeout, clearTimeout2 = _a.clearTimeout, fsWatchWorker = _a.fsWatchWorker, fileSystemEntryExists = _a.fileSystemEntryExists, useCaseSensitiveFileNames = _a.useCaseSensitiveFileNames, getCurrentDirectory = _a.getCurrentDirectory, fsSupportsRecursiveFsWatch = _a.fsSupportsRecursiveFsWatch, getAccessibleSortedChildDirectories = _a.getAccessibleSortedChildDirectories, realpath = _a.realpath, tscWatchFile = _a.tscWatchFile, useNonPollingWatchers = _a.useNonPollingWatchers, tscWatchDirectory = _a.tscWatchDirectory, defaultWatchFileKind = _a.defaultWatchFileKind, inodeWatching = _a.inodeWatching, sysLog2 = _a.sysLog;
        var dynamicPollingWatchFile;
        var fixedChunkSizePollingWatchFile;
        var nonPollingWatchFile;
        var hostRecursiveDirectoryWatcher;
        var hitSystemWatcherLimit = false;
        return {
          watchFile,
          watchDirectory
        };
        function watchFile(fileName, callback, pollingInterval, options) {
          options = updateOptionsForWatchFile(options, useNonPollingWatchers);
          var watchFileKind = ts2.Debug.checkDefined(options.watchFile);
          switch (watchFileKind) {
            case ts2.WatchFileKind.FixedPollingInterval:
              return pollingWatchFile(fileName, callback, PollingInterval.Low, void 0);
            case ts2.WatchFileKind.PriorityPollingInterval:
              return pollingWatchFile(fileName, callback, pollingInterval, void 0);
            case ts2.WatchFileKind.DynamicPriorityPolling:
              return ensureDynamicPollingWatchFile()(fileName, callback, pollingInterval, void 0);
            case ts2.WatchFileKind.FixedChunkSizePolling:
              return ensureFixedChunkSizePollingWatchFile()(fileName, callback, void 0, void 0);
            case ts2.WatchFileKind.UseFsEvents:
              return fsWatch(
                fileName,
                0,
                createFsWatchCallbackForFileWatcherCallback(fileName, callback, getModifiedTime2),
                false,
                pollingInterval,
                ts2.getFallbackOptions(options)
              );
            case ts2.WatchFileKind.UseFsEventsOnParentDirectory:
              if (!nonPollingWatchFile) {
                nonPollingWatchFile = createUseFsEventsOnParentDirectoryWatchFile(fsWatch, useCaseSensitiveFileNames);
              }
              return nonPollingWatchFile(fileName, callback, pollingInterval, ts2.getFallbackOptions(options));
            default:
              ts2.Debug.assertNever(watchFileKind);
          }
        }
        function ensureDynamicPollingWatchFile() {
          return dynamicPollingWatchFile || (dynamicPollingWatchFile = createDynamicPriorityPollingWatchFile({ getModifiedTime: getModifiedTime2, setTimeout: setTimeout2 }));
        }
        function ensureFixedChunkSizePollingWatchFile() {
          return fixedChunkSizePollingWatchFile || (fixedChunkSizePollingWatchFile = createFixedChunkSizePollingWatchFile({ getModifiedTime: getModifiedTime2, setTimeout: setTimeout2 }));
        }
        function updateOptionsForWatchFile(options, useNonPollingWatchers2) {
          if (options && options.watchFile !== void 0)
            return options;
          switch (tscWatchFile) {
            case "PriorityPollingInterval":
              return { watchFile: ts2.WatchFileKind.PriorityPollingInterval };
            case "DynamicPriorityPolling":
              return { watchFile: ts2.WatchFileKind.DynamicPriorityPolling };
            case "UseFsEvents":
              return generateWatchFileOptions(ts2.WatchFileKind.UseFsEvents, ts2.PollingWatchKind.PriorityInterval, options);
            case "UseFsEventsWithFallbackDynamicPolling":
              return generateWatchFileOptions(ts2.WatchFileKind.UseFsEvents, ts2.PollingWatchKind.DynamicPriority, options);
            case "UseFsEventsOnParentDirectory":
              useNonPollingWatchers2 = true;
            default:
              return useNonPollingWatchers2 ? generateWatchFileOptions(ts2.WatchFileKind.UseFsEventsOnParentDirectory, ts2.PollingWatchKind.PriorityInterval, options) : { watchFile: (defaultWatchFileKind === null || defaultWatchFileKind === void 0 ? void 0 : defaultWatchFileKind()) || ts2.WatchFileKind.FixedPollingInterval };
          }
        }
        function generateWatchFileOptions(watchFile2, fallbackPolling, options) {
          var defaultFallbackPolling = options === null || options === void 0 ? void 0 : options.fallbackPolling;
          return {
            watchFile: watchFile2,
            fallbackPolling: defaultFallbackPolling === void 0 ? fallbackPolling : defaultFallbackPolling
          };
        }
        function watchDirectory(directoryName, callback, recursive, options) {
          if (fsSupportsRecursiveFsWatch) {
            return fsWatch(directoryName, 1, createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback, options, useCaseSensitiveFileNames, getCurrentDirectory), recursive, PollingInterval.Medium, ts2.getFallbackOptions(options));
          }
          if (!hostRecursiveDirectoryWatcher) {
            hostRecursiveDirectoryWatcher = createDirectoryWatcherSupportingRecursive({
              useCaseSensitiveFileNames,
              getCurrentDirectory,
              fileSystemEntryExists,
              getAccessibleSortedChildDirectories,
              watchDirectory: nonRecursiveWatchDirectory,
              realpath,
              setTimeout: setTimeout2,
              clearTimeout: clearTimeout2
            });
          }
          return hostRecursiveDirectoryWatcher(directoryName, callback, recursive, options);
        }
        function nonRecursiveWatchDirectory(directoryName, callback, recursive, options) {
          ts2.Debug.assert(!recursive);
          var watchDirectoryOptions = updateOptionsForWatchDirectory(options);
          var watchDirectoryKind = ts2.Debug.checkDefined(watchDirectoryOptions.watchDirectory);
          switch (watchDirectoryKind) {
            case ts2.WatchDirectoryKind.FixedPollingInterval:
              return pollingWatchFile(
                directoryName,
                function() {
                  return callback(directoryName);
                },
                PollingInterval.Medium,
                void 0
              );
            case ts2.WatchDirectoryKind.DynamicPriorityPolling:
              return ensureDynamicPollingWatchFile()(
                directoryName,
                function() {
                  return callback(directoryName);
                },
                PollingInterval.Medium,
                void 0
              );
            case ts2.WatchDirectoryKind.FixedChunkSizePolling:
              return ensureFixedChunkSizePollingWatchFile()(
                directoryName,
                function() {
                  return callback(directoryName);
                },
                void 0,
                void 0
              );
            case ts2.WatchDirectoryKind.UseFsEvents:
              return fsWatch(directoryName, 1, createFsWatchCallbackForDirectoryWatcherCallback(directoryName, callback, options, useCaseSensitiveFileNames, getCurrentDirectory), recursive, PollingInterval.Medium, ts2.getFallbackOptions(watchDirectoryOptions));
            default:
              ts2.Debug.assertNever(watchDirectoryKind);
          }
        }
        function updateOptionsForWatchDirectory(options) {
          if (options && options.watchDirectory !== void 0)
            return options;
          switch (tscWatchDirectory) {
            case "RecursiveDirectoryUsingFsWatchFile":
              return { watchDirectory: ts2.WatchDirectoryKind.FixedPollingInterval };
            case "RecursiveDirectoryUsingDynamicPriorityPolling":
              return { watchDirectory: ts2.WatchDirectoryKind.DynamicPriorityPolling };
            default:
              var defaultFallbackPolling = options === null || options === void 0 ? void 0 : options.fallbackPolling;
              return {
                watchDirectory: ts2.WatchDirectoryKind.UseFsEvents,
                fallbackPolling: defaultFallbackPolling !== void 0 ? defaultFallbackPolling : void 0
              };
          }
        }
        function fsWatch(fileOrDirectory, entryKind, callback, recursive, fallbackPollingInterval, fallbackOptions) {
          var lastDirectoryPartWithDirectorySeparator;
          var lastDirectoryPart;
          if (inodeWatching) {
            lastDirectoryPartWithDirectorySeparator = fileOrDirectory.substring(fileOrDirectory.lastIndexOf(ts2.directorySeparator));
            lastDirectoryPart = lastDirectoryPartWithDirectorySeparator.slice(ts2.directorySeparator.length);
          }
          var watcher = !fileSystemEntryExists(fileOrDirectory, entryKind) ? watchMissingFileSystemEntry() : watchPresentFileSystemEntry();
          return {
            close: function() {
              if (watcher) {
                watcher.close();
                watcher = void 0;
              }
            }
          };
          function updateWatcher(createWatcher) {
            if (watcher) {
              sysLog2("sysLog:: ".concat(fileOrDirectory, ":: Changing watcher to ").concat(createWatcher === watchPresentFileSystemEntry ? "Present" : "Missing", "FileSystemEntryWatcher"));
              watcher.close();
              watcher = createWatcher();
            }
          }
          function watchPresentFileSystemEntry() {
            if (hitSystemWatcherLimit) {
              sysLog2("sysLog:: ".concat(fileOrDirectory, ":: Defaulting to watchFile"));
              return watchPresentFileSystemEntryWithFsWatchFile();
            }
            try {
              var presentWatcher = fsWatchWorker(fileOrDirectory, recursive, inodeWatching ? callbackChangingToMissingFileSystemEntry : callback);
              presentWatcher.on("error", function() {
                callback("rename", "");
                updateWatcher(watchMissingFileSystemEntry);
              });
              return presentWatcher;
            } catch (e) {
              hitSystemWatcherLimit || (hitSystemWatcherLimit = e.code === "ENOSPC");
              sysLog2("sysLog:: ".concat(fileOrDirectory, ":: Changing to watchFile"));
              return watchPresentFileSystemEntryWithFsWatchFile();
            }
          }
          function callbackChangingToMissingFileSystemEntry(event, relativeName) {
            var originalRelativeName;
            if (relativeName && ts2.endsWith(relativeName, "~")) {
              originalRelativeName = relativeName;
              relativeName = relativeName.slice(0, relativeName.length - 1);
            }
            if (event === "rename" && (!relativeName || relativeName === lastDirectoryPart || ts2.endsWith(relativeName, lastDirectoryPartWithDirectorySeparator))) {
              var modifiedTime = getModifiedTime2(fileOrDirectory) || ts2.missingFileModifiedTime;
              if (originalRelativeName)
                callback(event, originalRelativeName, modifiedTime);
              callback(event, relativeName, modifiedTime);
              if (inodeWatching) {
                updateWatcher(modifiedTime === ts2.missingFileModifiedTime ? watchMissingFileSystemEntry : watchPresentFileSystemEntry);
              } else if (modifiedTime === ts2.missingFileModifiedTime) {
                updateWatcher(watchMissingFileSystemEntry);
              }
            } else {
              if (originalRelativeName)
                callback(event, originalRelativeName);
              callback(event, relativeName);
            }
          }
          function watchPresentFileSystemEntryWithFsWatchFile() {
            return watchFile(fileOrDirectory, createFileWatcherCallback(callback), fallbackPollingInterval, fallbackOptions);
          }
          function watchMissingFileSystemEntry() {
            return watchFile(fileOrDirectory, function(_fileName, eventKind, modifiedTime) {
              if (eventKind === FileWatcherEventKind.Created) {
                modifiedTime || (modifiedTime = getModifiedTime2(fileOrDirectory) || ts2.missingFileModifiedTime);
                if (modifiedTime !== ts2.missingFileModifiedTime) {
                  callback("rename", "", modifiedTime);
                  updateWatcher(watchPresentFileSystemEntry);
                }
              }
            }, fallbackPollingInterval, fallbackOptions);
          }
        }
      }
      ts2.createSystemWatchFunctions = createSystemWatchFunctions;
      function patchWriteFileEnsuringDirectory(sys) {
        var originalWriteFile = sys.writeFile;
        sys.writeFile = function(path, data, writeBom) {
          return ts2.writeFileEnsuringDirectories(path, data, !!writeBom, function(path2, data2, writeByteOrderMark) {
            return originalWriteFile.call(sys, path2, data2, writeByteOrderMark);
          }, function(path2) {
            return sys.createDirectory(path2);
          }, function(path2) {
            return sys.directoryExists(path2);
          });
        };
      }
      ts2.patchWriteFileEnsuringDirectory = patchWriteFileEnsuringDirectory;
      function getNodeMajorVersion() {
        if (typeof process === "undefined") {
          return void 0;
        }
        var version = process.version;
        if (!version) {
          return void 0;
        }
        var dot = version.indexOf(".");
        if (dot === -1) {
          return void 0;
        }
        return parseInt(version.substring(1, dot));
      }
      ts2.getNodeMajorVersion = getNodeMajorVersion;
      ts2.sys = function() {
        var byteOrderMarkIndicator = "\uFEFF";
        function getNodeSystem() {
          var nativePattern = /^native |^\([^)]+\)$|^(internal[\\/]|[a-zA-Z0-9_\s]+(\.js)?$)/;
          var _fs = require("fs");
          var _path = require("path");
          var _os = require("os");
          var _crypto;
          try {
            _crypto = require("crypto");
          } catch (_a) {
            _crypto = void 0;
          }
          var activeSession;
          var profilePath = "./profile.cpuprofile";
          var Buffer2 = require("buffer").Buffer;
          var nodeVersion = getNodeMajorVersion();
          var isNode4OrLater = nodeVersion >= 4;
          var isLinuxOrMacOs = process.platform === "linux" || process.platform === "darwin";
          var platform = _os.platform();
          var useCaseSensitiveFileNames = isFileSystemCaseSensitive();
          var fsRealpath = !!_fs.realpathSync.native ? process.platform === "win32" ? fsRealPathHandlingLongPath : _fs.realpathSync.native : _fs.realpathSync;
          var fsSupportsRecursiveFsWatch = isNode4OrLater && (process.platform === "win32" || process.platform === "darwin");
          var getCurrentDirectory = ts2.memoize(function() {
            return process.cwd();
          });
          var _b = createSystemWatchFunctions({
            pollingWatchFile: createSingleFileWatcherPerName(fsWatchFileWorker, useCaseSensitiveFileNames),
            getModifiedTime: getModifiedTime2,
            setTimeout,
            clearTimeout,
            fsWatchWorker,
            useCaseSensitiveFileNames,
            getCurrentDirectory,
            fileSystemEntryExists,
            fsSupportsRecursiveFsWatch,
            getAccessibleSortedChildDirectories: function(path) {
              return getAccessibleFileSystemEntries(path).directories;
            },
            realpath,
            tscWatchFile: process.env.TSC_WATCHFILE,
            useNonPollingWatchers: process.env.TSC_NONPOLLING_WATCHER,
            tscWatchDirectory: process.env.TSC_WATCHDIRECTORY,
            defaultWatchFileKind: function() {
              var _a, _b2;
              return (_b2 = (_a = sys).defaultWatchFileKind) === null || _b2 === void 0 ? void 0 : _b2.call(_a);
            },
            inodeWatching: isLinuxOrMacOs,
            sysLog
          }), watchFile = _b.watchFile, watchDirectory = _b.watchDirectory;
          var nodeSystem = {
            args: process.argv.slice(2),
            newLine: _os.EOL,
            useCaseSensitiveFileNames,
            write: function(s) {
              process.stdout.write(s);
            },
            getWidthOfTerminal: function() {
              return process.stdout.columns;
            },
            writeOutputIsTTY: function() {
              return process.stdout.isTTY;
            },
            readFile,
            writeFile,
            watchFile,
            watchDirectory,
            resolvePath: function(path) {
              return _path.resolve(path);
            },
            fileExists,
            directoryExists,
            createDirectory: function(directoryName) {
              if (!nodeSystem.directoryExists(directoryName)) {
                try {
                  _fs.mkdirSync(directoryName);
                } catch (e) {
                  if (e.code !== "EEXIST") {
                    throw e;
                  }
                }
              }
            },
            getExecutingFilePath: function() {
              return __filename;
            },
            getCurrentDirectory,
            getDirectories,
            getEnvironmentVariable: function(name) {
              return process.env[name] || "";
            },
            readDirectory,
            getModifiedTime: getModifiedTime2,
            setModifiedTime,
            deleteFile,
            createHash: _crypto ? createSHA256Hash : generateDjb2Hash,
            createSHA256Hash: _crypto ? createSHA256Hash : void 0,
            getMemoryUsage: function() {
              if (global.gc) {
                global.gc();
              }
              return process.memoryUsage().heapUsed;
            },
            getFileSize: function(path) {
              try {
                var stat = statSync(path);
                if (stat === null || stat === void 0 ? void 0 : stat.isFile()) {
                  return stat.size;
                }
              } catch (_a) {
              }
              return 0;
            },
            exit: function(exitCode) {
              disableCPUProfiler(function() {
                return process.exit(exitCode);
              });
            },
            enableCPUProfiler,
            disableCPUProfiler,
            cpuProfilingEnabled: function() {
              return !!activeSession || ts2.contains(process.execArgv, "--cpu-prof") || ts2.contains(process.execArgv, "--prof");
            },
            realpath,
            debugMode: !!process.env.NODE_INSPECTOR_IPC || !!process.env.VSCODE_INSPECTOR_OPTIONS || ts2.some(process.execArgv, function(arg) {
              return /^--(inspect|debug)(-brk)?(=\d+)?$/i.test(arg);
            }),
            tryEnableSourceMapsForHost: function() {
              try {
                require_source_map_support().install();
              } catch (_a) {
              }
            },
            setTimeout,
            clearTimeout,
            clearScreen: function() {
              process.stdout.write("\x1Bc");
            },
            setBlocking: function() {
              if (process.stdout && process.stdout._handle && process.stdout._handle.setBlocking) {
                process.stdout._handle.setBlocking(true);
              }
            },
            bufferFrom,
            base64decode: function(input) {
              return bufferFrom(input, "base64").toString("utf8");
            },
            base64encode: function(input) {
              return bufferFrom(input).toString("base64");
            },
            require: function(baseDir, moduleName) {
              try {
                var modulePath = ts2.resolveJSModule(moduleName, baseDir, nodeSystem);
                return { module: require(modulePath), modulePath, error: void 0 };
              } catch (error) {
                return { module: void 0, modulePath: void 0, error };
              }
            }
          };
          return nodeSystem;
          function statSync(path) {
            return _fs.statSync(path, { throwIfNoEntry: false });
          }
          function enableCPUProfiler(path, cb) {
            if (activeSession) {
              cb();
              return false;
            }
            var inspector = require("inspector");
            if (!inspector || !inspector.Session) {
              cb();
              return false;
            }
            var session = new inspector.Session();
            session.connect();
            session.post("Profiler.enable", function() {
              session.post("Profiler.start", function() {
                activeSession = session;
                profilePath = path;
                cb();
              });
            });
            return true;
          }
          function cleanupPaths(profile) {
            var externalFileCounter = 0;
            var remappedPaths = new ts2.Map();
            var normalizedDir = ts2.normalizeSlashes(__dirname);
            var fileUrlRoot = "file://".concat(ts2.getRootLength(normalizedDir) === 1 ? "" : "/").concat(normalizedDir);
            for (var _i = 0, _a = profile.nodes; _i < _a.length; _i++) {
              var node = _a[_i];
              if (node.callFrame.url) {
                var url = ts2.normalizeSlashes(node.callFrame.url);
                if (ts2.containsPath(fileUrlRoot, url, useCaseSensitiveFileNames)) {
                  node.callFrame.url = ts2.getRelativePathToDirectoryOrUrl(fileUrlRoot, url, fileUrlRoot, ts2.createGetCanonicalFileName(useCaseSensitiveFileNames), true);
                } else if (!nativePattern.test(url)) {
                  node.callFrame.url = (remappedPaths.has(url) ? remappedPaths : remappedPaths.set(url, "external".concat(externalFileCounter, ".js"))).get(url);
                  externalFileCounter++;
                }
              }
            }
            return profile;
          }
          function disableCPUProfiler(cb) {
            if (activeSession && activeSession !== "stopping") {
              var s_1 = activeSession;
              activeSession.post("Profiler.stop", function(err, _a) {
                var _b2;
                var profile = _a.profile;
                if (!err) {
                  try {
                    if ((_b2 = statSync(profilePath)) === null || _b2 === void 0 ? void 0 : _b2.isDirectory()) {
                      profilePath = _path.join(profilePath, "".concat(new Date().toISOString().replace(/:/g, "-"), "+P").concat(process.pid, ".cpuprofile"));
                    }
                  } catch (_c) {
                  }
                  try {
                    _fs.mkdirSync(_path.dirname(profilePath), { recursive: true });
                  } catch (_d) {
                  }
                  _fs.writeFileSync(profilePath, JSON.stringify(cleanupPaths(profile)));
                }
                activeSession = void 0;
                s_1.disconnect();
                cb();
              });
              activeSession = "stopping";
              return true;
            } else {
              cb();
              return false;
            }
          }
          function bufferFrom(input, encoding) {
            return Buffer2.from && Buffer2.from !== Int8Array.from ? Buffer2.from(input, encoding) : new Buffer2(input, encoding);
          }
          function isFileSystemCaseSensitive() {
            if (platform === "win32" || platform === "win64") {
              return false;
            }
            return !fileExists(swapCase(__filename));
          }
          function swapCase(s) {
            return s.replace(/\w/g, function(ch) {
              var up = ch.toUpperCase();
              return ch === up ? ch.toLowerCase() : up;
            });
          }
          function fsWatchFileWorker(fileName, callback, pollingInterval) {
            _fs.watchFile(fileName, { persistent: true, interval: pollingInterval }, fileChanged);
            var eventKind;
            return {
              close: function() {
                return _fs.unwatchFile(fileName, fileChanged);
              }
            };
            function fileChanged(curr, prev) {
              var isPreviouslyDeleted = +prev.mtime === 0 || eventKind === FileWatcherEventKind.Deleted;
              if (+curr.mtime === 0) {
                if (isPreviouslyDeleted) {
                  return;
                }
                eventKind = FileWatcherEventKind.Deleted;
              } else if (isPreviouslyDeleted) {
                eventKind = FileWatcherEventKind.Created;
              } else if (+curr.mtime === +prev.mtime) {
                return;
              } else {
                eventKind = FileWatcherEventKind.Changed;
              }
              callback(fileName, eventKind, curr.mtime);
            }
          }
          function fsWatchWorker(fileOrDirectory, recursive, callback) {
            return _fs.watch(fileOrDirectory, fsSupportsRecursiveFsWatch ? { persistent: true, recursive: !!recursive } : { persistent: true }, callback);
          }
          function readFileWorker(fileName, _encoding) {
            var buffer;
            try {
              buffer = _fs.readFileSync(fileName);
            } catch (e) {
              return void 0;
            }
            var len = buffer.length;
            if (len >= 2 && buffer[0] === 254 && buffer[1] === 255) {
              len &= ~1;
              for (var i = 0; i < len; i += 2) {
                var temp = buffer[i];
                buffer[i] = buffer[i + 1];
                buffer[i + 1] = temp;
              }
              return buffer.toString("utf16le", 2);
            }
            if (len >= 2 && buffer[0] === 255 && buffer[1] === 254) {
              return buffer.toString("utf16le", 2);
            }
            if (len >= 3 && buffer[0] === 239 && buffer[1] === 187 && buffer[2] === 191) {
              return buffer.toString("utf8", 3);
            }
            return buffer.toString("utf8");
          }
          function readFile(fileName, _encoding) {
            ts2.perfLogger.logStartReadFile(fileName);
            var file = readFileWorker(fileName, _encoding);
            ts2.perfLogger.logStopReadFile();
            return file;
          }
          function writeFile(fileName, data, writeByteOrderMark) {
            ts2.perfLogger.logEvent("WriteFile: " + fileName);
            if (writeByteOrderMark) {
              data = byteOrderMarkIndicator + data;
            }
            var fd;
            try {
              fd = _fs.openSync(fileName, "w");
              _fs.writeSync(fd, data, void 0, "utf8");
            } finally {
              if (fd !== void 0) {
                _fs.closeSync(fd);
              }
            }
          }
          function getAccessibleFileSystemEntries(path) {
            ts2.perfLogger.logEvent("ReadDir: " + (path || "."));
            try {
              var entries = _fs.readdirSync(path || ".", { withFileTypes: true });
              var files = [];
              var directories = [];
              for (var _i = 0, entries_1 = entries; _i < entries_1.length; _i++) {
                var dirent = entries_1[_i];
                var entry = typeof dirent === "string" ? dirent : dirent.name;
                if (entry === "." || entry === "..") {
                  continue;
                }
                var stat = void 0;
                if (typeof dirent === "string" || dirent.isSymbolicLink()) {
                  var name = ts2.combinePaths(path, entry);
                  try {
                    stat = statSync(name);
                    if (!stat) {
                      continue;
                    }
                  } catch (e) {
                    continue;
                  }
                } else {
                  stat = dirent;
                }
                if (stat.isFile()) {
                  files.push(entry);
                } else if (stat.isDirectory()) {
                  directories.push(entry);
                }
              }
              files.sort();
              directories.sort();
              return { files, directories };
            } catch (e) {
              return ts2.emptyFileSystemEntries;
            }
          }
          function readDirectory(path, extensions, excludes, includes, depth) {
            return ts2.matchFiles(path, extensions, excludes, includes, useCaseSensitiveFileNames, process.cwd(), depth, getAccessibleFileSystemEntries, realpath);
          }
          function fileSystemEntryExists(path, entryKind) {
            var originalStackTraceLimit = Error.stackTraceLimit;
            Error.stackTraceLimit = 0;
            try {
              var stat = statSync(path);
              if (!stat) {
                return false;
              }
              switch (entryKind) {
                case 0:
                  return stat.isFile();
                case 1:
                  return stat.isDirectory();
                default:
                  return false;
              }
            } catch (e) {
              return false;
            } finally {
              Error.stackTraceLimit = originalStackTraceLimit;
            }
          }
          function fileExists(path) {
            return fileSystemEntryExists(path, 0);
          }
          function directoryExists(path) {
            return fileSystemEntryExists(path, 1);
          }
          function getDirectories(path) {
            return getAccessibleFileSystemEntries(path).directories.slice();
          }
          function fsRealPathHandlingLongPath(path) {
            return path.length < 260 ? _fs.realpathSync.native(path) : _fs.realpathSync(path);
          }
          function realpath(path) {
            try {
              return fsRealpath(path);
            } catch (_a) {
              return path;
            }
          }
          function getModifiedTime2(path) {
            var _a;
            var originalStackTraceLimit = Error.stackTraceLimit;
            Error.stackTraceLimit = 0;
            try {
              return (_a = statSync(path)) === null || _a === void 0 ? void 0 : _a.mtime;
            } catch (e) {
              return void 0;
            } finally {
              Error.stackTraceLimit = originalStackTraceLimit;
            }
          }
          function setModifiedTime(path, time) {
            try {
              _fs.utimesSync(path, time, time);
            } catch (e) {
              return;
            }
          }
          function deleteFile(path) {
            try {
              return _fs.unlinkSync(path);
            } catch (e) {
              return;
            }
          }
          function createSHA256Hash(data) {
            var hash = _crypto.createHash("sha256");
            hash.update(data);
            return hash.digest("hex");
          }
        }
        var sys;
        if (typeof process !== "undefined" && process.nextTick && !process.browser && typeof require !== "undefined") {
          sys = getNodeSystem();
        }
        if (sys) {
          patchWriteFileEnsuringDirectory(sys);
        }
        return sys;
      }();
      function setSys(s) {
        ts2.sys = s;
      }
      ts2.setSys = setSys;
      if (ts2.sys && ts2.sys.getEnvironmentVariable) {
        setCustomPollingValues(ts2.sys);
        ts2.Debug.setAssertionLevel(/^development$/i.test(ts2.sys.getEnvironmentVariable("NODE_ENV")) ? 1 : 0);
      }
      if (ts2.sys && ts2.sys.debugMode) {
        ts2.Debug.isDebugging = true;
      }
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      ts2.directorySeparator = "/";
      ts2.altDirectorySeparator = "\\";
      var urlSchemeSeparator = "://";
      var backslashRegExp = /\\/g;
      function isAnyDirectorySeparator(charCode) {
        return charCode === 47 || charCode === 92;
      }
      ts2.isAnyDirectorySeparator = isAnyDirectorySeparator;
      function isUrl(path) {
        return getEncodedRootLength(path) < 0;
      }
      ts2.isUrl = isUrl;
      function isRootedDiskPath(path) {
        return getEncodedRootLength(path) > 0;
      }
      ts2.isRootedDiskPath = isRootedDiskPath;
      function isDiskPathRoot(path) {
        var rootLength = getEncodedRootLength(path);
        return rootLength > 0 && rootLength === path.length;
      }
      ts2.isDiskPathRoot = isDiskPathRoot;
      function pathIsAbsolute(path) {
        return getEncodedRootLength(path) !== 0;
      }
      ts2.pathIsAbsolute = pathIsAbsolute;
      function pathIsRelative(path) {
        return /^\.\.?($|[\\/])/.test(path);
      }
      ts2.pathIsRelative = pathIsRelative;
      function pathIsBareSpecifier(path) {
        return !pathIsAbsolute(path) && !pathIsRelative(path);
      }
      ts2.pathIsBareSpecifier = pathIsBareSpecifier;
      function hasExtension(fileName) {
        return ts2.stringContains(getBaseFileName(fileName), ".");
      }
      ts2.hasExtension = hasExtension;
      function fileExtensionIs(path, extension) {
        return path.length > extension.length && ts2.endsWith(path, extension);
      }
      ts2.fileExtensionIs = fileExtensionIs;
      function fileExtensionIsOneOf(path, extensions) {
        for (var _i = 0, extensions_1 = extensions; _i < extensions_1.length; _i++) {
          var extension = extensions_1[_i];
          if (fileExtensionIs(path, extension)) {
            return true;
          }
        }
        return false;
      }
      ts2.fileExtensionIsOneOf = fileExtensionIsOneOf;
      function hasTrailingDirectorySeparator(path) {
        return path.length > 0 && isAnyDirectorySeparator(path.charCodeAt(path.length - 1));
      }
      ts2.hasTrailingDirectorySeparator = hasTrailingDirectorySeparator;
      function isVolumeCharacter(charCode) {
        return charCode >= 97 && charCode <= 122 || charCode >= 65 && charCode <= 90;
      }
      function getFileUrlVolumeSeparatorEnd(url, start) {
        var ch0 = url.charCodeAt(start);
        if (ch0 === 58)
          return start + 1;
        if (ch0 === 37 && url.charCodeAt(start + 1) === 51) {
          var ch2 = url.charCodeAt(start + 2);
          if (ch2 === 97 || ch2 === 65)
            return start + 3;
        }
        return -1;
      }
      function getEncodedRootLength(path) {
        if (!path)
          return 0;
        var ch0 = path.charCodeAt(0);
        if (ch0 === 47 || ch0 === 92) {
          if (path.charCodeAt(1) !== ch0)
            return 1;
          var p1 = path.indexOf(ch0 === 47 ? ts2.directorySeparator : ts2.altDirectorySeparator, 2);
          if (p1 < 0)
            return path.length;
          return p1 + 1;
        }
        if (isVolumeCharacter(ch0) && path.charCodeAt(1) === 58) {
          var ch2 = path.charCodeAt(2);
          if (ch2 === 47 || ch2 === 92)
            return 3;
          if (path.length === 2)
            return 2;
        }
        var schemeEnd = path.indexOf(urlSchemeSeparator);
        if (schemeEnd !== -1) {
          var authorityStart = schemeEnd + urlSchemeSeparator.length;
          var authorityEnd = path.indexOf(ts2.directorySeparator, authorityStart);
          if (authorityEnd !== -1) {
            var scheme = path.slice(0, schemeEnd);
            var authority = path.slice(authorityStart, authorityEnd);
            if (scheme === "file" && (authority === "" || authority === "localhost") && isVolumeCharacter(path.charCodeAt(authorityEnd + 1))) {
              var volumeSeparatorEnd = getFileUrlVolumeSeparatorEnd(path, authorityEnd + 2);
              if (volumeSeparatorEnd !== -1) {
                if (path.charCodeAt(volumeSeparatorEnd) === 47) {
                  return ~(volumeSeparatorEnd + 1);
                }
                if (volumeSeparatorEnd === path.length) {
                  return ~volumeSeparatorEnd;
                }
              }
            }
            return ~(authorityEnd + 1);
          }
          return ~path.length;
        }
        return 0;
      }
      function getRootLength(path) {
        var rootLength = getEncodedRootLength(path);
        return rootLength < 0 ? ~rootLength : rootLength;
      }
      ts2.getRootLength = getRootLength;
      function getDirectoryPath(path) {
        path = normalizeSlashes(path);
        var rootLength = getRootLength(path);
        if (rootLength === path.length)
          return path;
        path = removeTrailingDirectorySeparator(path);
        return path.slice(0, Math.max(rootLength, path.lastIndexOf(ts2.directorySeparator)));
      }
      ts2.getDirectoryPath = getDirectoryPath;
      function getBaseFileName(path, extensions, ignoreCase) {
        path = normalizeSlashes(path);
        var rootLength = getRootLength(path);
        if (rootLength === path.length)
          return "";
        path = removeTrailingDirectorySeparator(path);
        var name = path.slice(Math.max(getRootLength(path), path.lastIndexOf(ts2.directorySeparator) + 1));
        var extension = extensions !== void 0 && ignoreCase !== void 0 ? getAnyExtensionFromPath(name, extensions, ignoreCase) : void 0;
        return extension ? name.slice(0, name.length - extension.length) : name;
      }
      ts2.getBaseFileName = getBaseFileName;
      function tryGetExtensionFromPath(path, extension, stringEqualityComparer) {
        if (!ts2.startsWith(extension, "."))
          extension = "." + extension;
        if (path.length >= extension.length && path.charCodeAt(path.length - extension.length) === 46) {
          var pathExtension = path.slice(path.length - extension.length);
          if (stringEqualityComparer(pathExtension, extension)) {
            return pathExtension;
          }
        }
      }
      function getAnyExtensionFromPathWorker(path, extensions, stringEqualityComparer) {
        if (typeof extensions === "string") {
          return tryGetExtensionFromPath(path, extensions, stringEqualityComparer) || "";
        }
        for (var _i = 0, extensions_2 = extensions; _i < extensions_2.length; _i++) {
          var extension = extensions_2[_i];
          var result = tryGetExtensionFromPath(path, extension, stringEqualityComparer);
          if (result)
            return result;
        }
        return "";
      }
      function getAnyExtensionFromPath(path, extensions, ignoreCase) {
        if (extensions) {
          return getAnyExtensionFromPathWorker(removeTrailingDirectorySeparator(path), extensions, ignoreCase ? ts2.equateStringsCaseInsensitive : ts2.equateStringsCaseSensitive);
        }
        var baseFileName = getBaseFileName(path);
        var extensionIndex = baseFileName.lastIndexOf(".");
        if (extensionIndex >= 0) {
          return baseFileName.substring(extensionIndex);
        }
        return "";
      }
      ts2.getAnyExtensionFromPath = getAnyExtensionFromPath;
      function pathComponents(path, rootLength) {
        var root = path.substring(0, rootLength);
        var rest = path.substring(rootLength).split(ts2.directorySeparator);
        if (rest.length && !ts2.lastOrUndefined(rest))
          rest.pop();
        return __spreadArray([root], rest, true);
      }
      function getPathComponents(path, currentDirectory) {
        if (currentDirectory === void 0) {
          currentDirectory = "";
        }
        path = combinePaths(currentDirectory, path);
        return pathComponents(path, getRootLength(path));
      }
      ts2.getPathComponents = getPathComponents;
      function getPathFromPathComponents(pathComponents2) {
        if (pathComponents2.length === 0)
          return "";
        var root = pathComponents2[0] && ensureTrailingDirectorySeparator(pathComponents2[0]);
        return root + pathComponents2.slice(1).join(ts2.directorySeparator);
      }
      ts2.getPathFromPathComponents = getPathFromPathComponents;
      function normalizeSlashes(path) {
        var index = path.indexOf("\\");
        if (index === -1) {
          return path;
        }
        backslashRegExp.lastIndex = index;
        return path.replace(backslashRegExp, ts2.directorySeparator);
      }
      ts2.normalizeSlashes = normalizeSlashes;
      function reducePathComponents(components) {
        if (!ts2.some(components))
          return [];
        var reduced = [components[0]];
        for (var i = 1; i < components.length; i++) {
          var component = components[i];
          if (!component)
            continue;
          if (component === ".")
            continue;
          if (component === "..") {
            if (reduced.length > 1) {
              if (reduced[reduced.length - 1] !== "..") {
                reduced.pop();
                continue;
              }
            } else if (reduced[0])
              continue;
          }
          reduced.push(component);
        }
        return reduced;
      }
      ts2.reducePathComponents = reducePathComponents;
      function combinePaths(path) {
        var paths = [];
        for (var _i = 1; _i < arguments.length; _i++) {
          paths[_i - 1] = arguments[_i];
        }
        if (path)
          path = normalizeSlashes(path);
        for (var _a = 0, paths_1 = paths; _a < paths_1.length; _a++) {
          var relativePath = paths_1[_a];
          if (!relativePath)
            continue;
          relativePath = normalizeSlashes(relativePath);
          if (!path || getRootLength(relativePath) !== 0) {
            path = relativePath;
          } else {
            path = ensureTrailingDirectorySeparator(path) + relativePath;
          }
        }
        return path;
      }
      ts2.combinePaths = combinePaths;
      function resolvePath(path) {
        var paths = [];
        for (var _i = 1; _i < arguments.length; _i++) {
          paths[_i - 1] = arguments[_i];
        }
        return normalizePath(ts2.some(paths) ? combinePaths.apply(void 0, __spreadArray([path], paths, false)) : normalizeSlashes(path));
      }
      ts2.resolvePath = resolvePath;
      function getNormalizedPathComponents(path, currentDirectory) {
        return reducePathComponents(getPathComponents(path, currentDirectory));
      }
      ts2.getNormalizedPathComponents = getNormalizedPathComponents;
      function getNormalizedAbsolutePath(fileName, currentDirectory) {
        return getPathFromPathComponents(getNormalizedPathComponents(fileName, currentDirectory));
      }
      ts2.getNormalizedAbsolutePath = getNormalizedAbsolutePath;
      function normalizePath(path) {
        path = normalizeSlashes(path);
        if (!relativePathSegmentRegExp.test(path)) {
          return path;
        }
        var simplified = path.replace(/\/\.\//g, "/").replace(/^\.\//, "");
        if (simplified !== path) {
          path = simplified;
          if (!relativePathSegmentRegExp.test(path)) {
            return path;
          }
        }
        var normalized = getPathFromPathComponents(reducePathComponents(getPathComponents(path)));
        return normalized && hasTrailingDirectorySeparator(path) ? ensureTrailingDirectorySeparator(normalized) : normalized;
      }
      ts2.normalizePath = normalizePath;
      function getPathWithoutRoot(pathComponents2) {
        if (pathComponents2.length === 0)
          return "";
        return pathComponents2.slice(1).join(ts2.directorySeparator);
      }
      function getNormalizedAbsolutePathWithoutRoot(fileName, currentDirectory) {
        return getPathWithoutRoot(getNormalizedPathComponents(fileName, currentDirectory));
      }
      ts2.getNormalizedAbsolutePathWithoutRoot = getNormalizedAbsolutePathWithoutRoot;
      function toPath(fileName, basePath, getCanonicalFileName) {
        var nonCanonicalizedPath = isRootedDiskPath(fileName) ? normalizePath(fileName) : getNormalizedAbsolutePath(fileName, basePath);
        return getCanonicalFileName(nonCanonicalizedPath);
      }
      ts2.toPath = toPath;
      function removeTrailingDirectorySeparator(path) {
        if (hasTrailingDirectorySeparator(path)) {
          return path.substr(0, path.length - 1);
        }
        return path;
      }
      ts2.removeTrailingDirectorySeparator = removeTrailingDirectorySeparator;
      function ensureTrailingDirectorySeparator(path) {
        if (!hasTrailingDirectorySeparator(path)) {
          return path + ts2.directorySeparator;
        }
        return path;
      }
      ts2.ensureTrailingDirectorySeparator = ensureTrailingDirectorySeparator;
      function ensurePathIsNonModuleName(path) {
        return !pathIsAbsolute(path) && !pathIsRelative(path) ? "./" + path : path;
      }
      ts2.ensurePathIsNonModuleName = ensurePathIsNonModuleName;
      function changeAnyExtension(path, ext, extensions, ignoreCase) {
        var pathext = extensions !== void 0 && ignoreCase !== void 0 ? getAnyExtensionFromPath(path, extensions, ignoreCase) : getAnyExtensionFromPath(path);
        return pathext ? path.slice(0, path.length - pathext.length) + (ts2.startsWith(ext, ".") ? ext : "." + ext) : path;
      }
      ts2.changeAnyExtension = changeAnyExtension;
      var relativePathSegmentRegExp = /(?:\/\/)|(?:^|\/)\.\.?(?:$|\/)/;
      function comparePathsWorker(a, b, componentComparer) {
        if (a === b)
          return 0;
        if (a === void 0)
          return -1;
        if (b === void 0)
          return 1;
        var aRoot = a.substring(0, getRootLength(a));
        var bRoot = b.substring(0, getRootLength(b));
        var result = ts2.compareStringsCaseInsensitive(aRoot, bRoot);
        if (result !== 0) {
          return result;
        }
        var aRest = a.substring(aRoot.length);
        var bRest = b.substring(bRoot.length);
        if (!relativePathSegmentRegExp.test(aRest) && !relativePathSegmentRegExp.test(bRest)) {
          return componentComparer(aRest, bRest);
        }
        var aComponents = reducePathComponents(getPathComponents(a));
        var bComponents = reducePathComponents(getPathComponents(b));
        var sharedLength = Math.min(aComponents.length, bComponents.length);
        for (var i = 1; i < sharedLength; i++) {
          var result_2 = componentComparer(aComponents[i], bComponents[i]);
          if (result_2 !== 0) {
            return result_2;
          }
        }
        return ts2.compareValues(aComponents.length, bComponents.length);
      }
      function comparePathsCaseSensitive(a, b) {
        return comparePathsWorker(a, b, ts2.compareStringsCaseSensitive);
      }
      ts2.comparePathsCaseSensitive = comparePathsCaseSensitive;
      function comparePathsCaseInsensitive(a, b) {
        return comparePathsWorker(a, b, ts2.compareStringsCaseInsensitive);
      }
      ts2.comparePathsCaseInsensitive = comparePathsCaseInsensitive;
      function comparePaths(a, b, currentDirectory, ignoreCase) {
        if (typeof currentDirectory === "string") {
          a = combinePaths(currentDirectory, a);
          b = combinePaths(currentDirectory, b);
        } else if (typeof currentDirectory === "boolean") {
          ignoreCase = currentDirectory;
        }
        return comparePathsWorker(a, b, ts2.getStringComparer(ignoreCase));
      }
      ts2.comparePaths = comparePaths;
      function containsPath(parent, child, currentDirectory, ignoreCase) {
        if (typeof currentDirectory === "string") {
          parent = combinePaths(currentDirectory, parent);
          child = combinePaths(currentDirectory, child);
        } else if (typeof currentDirectory === "boolean") {
          ignoreCase = currentDirectory;
        }
        if (parent === void 0 || child === void 0)
          return false;
        if (parent === child)
          return true;
        var parentComponents = reducePathComponents(getPathComponents(parent));
        var childComponents = reducePathComponents(getPathComponents(child));
        if (childComponents.length < parentComponents.length) {
          return false;
        }
        var componentEqualityComparer = ignoreCase ? ts2.equateStringsCaseInsensitive : ts2.equateStringsCaseSensitive;
        for (var i = 0; i < parentComponents.length; i++) {
          var equalityComparer = i === 0 ? ts2.equateStringsCaseInsensitive : componentEqualityComparer;
          if (!equalityComparer(parentComponents[i], childComponents[i])) {
            return false;
          }
        }
        return true;
      }
      ts2.containsPath = containsPath;
      function startsWithDirectory(fileName, directoryName, getCanonicalFileName) {
        var canonicalFileName = getCanonicalFileName(fileName);
        var canonicalDirectoryName = getCanonicalFileName(directoryName);
        return ts2.startsWith(canonicalFileName, canonicalDirectoryName + "/") || ts2.startsWith(canonicalFileName, canonicalDirectoryName + "\\");
      }
      ts2.startsWithDirectory = startsWithDirectory;
      function getPathComponentsRelativeTo(from, to, stringEqualityComparer, getCanonicalFileName) {
        var fromComponents = reducePathComponents(getPathComponents(from));
        var toComponents = reducePathComponents(getPathComponents(to));
        var start;
        for (start = 0; start < fromComponents.length && start < toComponents.length; start++) {
          var fromComponent = getCanonicalFileName(fromComponents[start]);
          var toComponent = getCanonicalFileName(toComponents[start]);
          var comparer = start === 0 ? ts2.equateStringsCaseInsensitive : stringEqualityComparer;
          if (!comparer(fromComponent, toComponent))
            break;
        }
        if (start === 0) {
          return toComponents;
        }
        var components = toComponents.slice(start);
        var relative = [];
        for (; start < fromComponents.length; start++) {
          relative.push("..");
        }
        return __spreadArray(__spreadArray([""], relative, true), components, true);
      }
      ts2.getPathComponentsRelativeTo = getPathComponentsRelativeTo;
      function getRelativePathFromDirectory(fromDirectory, to, getCanonicalFileNameOrIgnoreCase) {
        ts2.Debug.assert(getRootLength(fromDirectory) > 0 === getRootLength(to) > 0, "Paths must either both be absolute or both be relative");
        var getCanonicalFileName = typeof getCanonicalFileNameOrIgnoreCase === "function" ? getCanonicalFileNameOrIgnoreCase : ts2.identity;
        var ignoreCase = typeof getCanonicalFileNameOrIgnoreCase === "boolean" ? getCanonicalFileNameOrIgnoreCase : false;
        var pathComponents2 = getPathComponentsRelativeTo(fromDirectory, to, ignoreCase ? ts2.equateStringsCaseInsensitive : ts2.equateStringsCaseSensitive, getCanonicalFileName);
        return getPathFromPathComponents(pathComponents2);
      }
      ts2.getRelativePathFromDirectory = getRelativePathFromDirectory;
      function convertToRelativePath(absoluteOrRelativePath, basePath, getCanonicalFileName) {
        return !isRootedDiskPath(absoluteOrRelativePath) ? absoluteOrRelativePath : getRelativePathToDirectoryOrUrl(basePath, absoluteOrRelativePath, basePath, getCanonicalFileName, false);
      }
      ts2.convertToRelativePath = convertToRelativePath;
      function getRelativePathFromFile(from, to, getCanonicalFileName) {
        return ensurePathIsNonModuleName(getRelativePathFromDirectory(getDirectoryPath(from), to, getCanonicalFileName));
      }
      ts2.getRelativePathFromFile = getRelativePathFromFile;
      function getRelativePathToDirectoryOrUrl(directoryPathOrUrl, relativeOrAbsolutePath, currentDirectory, getCanonicalFileName, isAbsolutePathAnUrl) {
        var pathComponents2 = getPathComponentsRelativeTo(resolvePath(currentDirectory, directoryPathOrUrl), resolvePath(currentDirectory, relativeOrAbsolutePath), ts2.equateStringsCaseSensitive, getCanonicalFileName);
        var firstComponent = pathComponents2[0];
        if (isAbsolutePathAnUrl && isRootedDiskPath(firstComponent)) {
          var prefix = firstComponent.charAt(0) === ts2.directorySeparator ? "file://" : "file:///";
          pathComponents2[0] = prefix + firstComponent;
        }
        return getPathFromPathComponents(pathComponents2);
      }
      ts2.getRelativePathToDirectoryOrUrl = getRelativePathToDirectoryOrUrl;
      function forEachAncestorDirectory(directory, callback) {
        while (true) {
          var result = callback(directory);
          if (result !== void 0) {
            return result;
          }
          var parentPath = getDirectoryPath(directory);
          if (parentPath === directory) {
            return void 0;
          }
          directory = parentPath;
        }
      }
      ts2.forEachAncestorDirectory = forEachAncestorDirectory;
      function isNodeModulesDirectory(dirPath) {
        return ts2.endsWith(dirPath, "/node_modules");
      }
      ts2.isNodeModulesDirectory = isNodeModulesDirectory;
    })(ts || (ts = {}));
    var ts;
    (function(ts2) {
      function diag(code, category, key, message, reportsUnnecessary, elidedInCompatabilityPyramid, reportsDeprecated) {
        return { code, category, key, message, reportsUnnecessary, elidedInCompatabilityPyramid, reportsDeprecated };
      }
      ts2.Diagnostics = {
        Unterminated_string_literal: diag(1002, ts2.DiagnosticCategory.Error, "Unterminated_string_literal_1002", "Unterminated string literal."),
        Identifier_expected: diag(1003, ts2.DiagnosticCategory.Error, "Identifier_expected_1003", "Identifier expected."),
        _0_expected: diag(1005, ts2.DiagnosticCategory.Error, "_0_expected_1005", "'{0}' expected."),
        A_file_cannot_have_a_reference_to_itself: diag(1006, ts2.DiagnosticCategory.Error, "A_file_cannot_have_a_reference_to_itself_1006", "A file cannot have a reference to itself."),
        The_parser_expected_to_find_a_1_to_match_the_0_token_here: diag(1007, ts2.DiagnosticCategory.Error, "The_parser_expected_to_find_a_1_to_match_the_0_token_here_1007", "The parser expected to find a '{1}' to match the '{0}' token here."),
        Trailing_comma_not_allowed: diag(1009, ts2.DiagnosticCategory.Error, "Trailing_comma_not_allowed_1009", "Trailing comma not allowed."),
        Asterisk_Slash_expected: diag(1010, ts2.DiagnosticCategory.Error, "Asterisk_Slash_expected_1010", "'*/' expected."),
        An_element_access_expression_should_take_an_argument: diag(1011, ts2.DiagnosticCategory.Error, "An_element_access_expression_should_take_an_argument_1011", "An element access expression should take an argument."),
        Unexpected_token: diag(1012, ts2.DiagnosticCategory.Error, "Unexpected_token_1012", "Unexpected token."),
        A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma: diag(1013, ts2.DiagnosticCategory.Error, "A_rest_parameter_or_binding_pattern_may_not_have_a_trailing_comma_1013", "A rest parameter or binding pattern may not have a trailing comma."),
        A_rest_parameter_must_be_last_in_a_parameter_list: diag(1014, ts2.DiagnosticCategory.Error, "A_rest_parameter_must_be_last_in_a_parameter_list_1014", "A rest parameter must be last in a parameter list."),
        Parameter_cannot_have_question_mark_and_initializer: diag(1015, ts2.DiagnosticCategory.Error, "Parameter_cannot_have_question_mark_and_initializer_1015", "Parameter cannot have question mark and initializer."),
        A_required_parameter_cannot_follow_an_optional_parameter: diag(1016, ts2.DiagnosticCategory.Error, "A_required_parameter_cannot_follow_an_optional_parameter_1016", "A required parameter cannot follow an optional parameter."),
        An_index_signature_cannot_have_a_rest_parameter: diag(1017, ts2.DiagnosticCategory.Error, "An_index_signature_cannot_have_a_rest_parameter_1017", "An index signature cannot have a rest parameter."),
        An_index_signature_parameter_cannot_have_an_accessibility_modifier: diag(1018, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_an_accessibility_modifier_1018", "An index signature parameter cannot have an accessibility modifier."),
        An_index_signature_parameter_cannot_have_a_question_mark: diag(1019, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_a_question_mark_1019", "An index signature parameter cannot have a question mark."),
        An_index_signature_parameter_cannot_have_an_initializer: diag(1020, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_cannot_have_an_initializer_1020", "An index signature parameter cannot have an initializer."),
        An_index_signature_must_have_a_type_annotation: diag(1021, ts2.DiagnosticCategory.Error, "An_index_signature_must_have_a_type_annotation_1021", "An index signature must have a type annotation."),
        An_index_signature_parameter_must_have_a_type_annotation: diag(1022, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_must_have_a_type_annotation_1022", "An index signature parameter must have a type annotation."),
        readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature: diag(1024, ts2.DiagnosticCategory.Error, "readonly_modifier_can_only_appear_on_a_property_declaration_or_index_signature_1024", "'readonly' modifier can only appear on a property declaration or index signature."),
        An_index_signature_cannot_have_a_trailing_comma: diag(1025, ts2.DiagnosticCategory.Error, "An_index_signature_cannot_have_a_trailing_comma_1025", "An index signature cannot have a trailing comma."),
        Accessibility_modifier_already_seen: diag(1028, ts2.DiagnosticCategory.Error, "Accessibility_modifier_already_seen_1028", "Accessibility modifier already seen."),
        _0_modifier_must_precede_1_modifier: diag(1029, ts2.DiagnosticCategory.Error, "_0_modifier_must_precede_1_modifier_1029", "'{0}' modifier must precede '{1}' modifier."),
        _0_modifier_already_seen: diag(1030, ts2.DiagnosticCategory.Error, "_0_modifier_already_seen_1030", "'{0}' modifier already seen."),
        _0_modifier_cannot_appear_on_class_elements_of_this_kind: diag(1031, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_class_elements_of_this_kind_1031", "'{0}' modifier cannot appear on class elements of this kind."),
        super_must_be_followed_by_an_argument_list_or_member_access: diag(1034, ts2.DiagnosticCategory.Error, "super_must_be_followed_by_an_argument_list_or_member_access_1034", "'super' must be followed by an argument list or member access."),
        Only_ambient_modules_can_use_quoted_names: diag(1035, ts2.DiagnosticCategory.Error, "Only_ambient_modules_can_use_quoted_names_1035", "Only ambient modules can use quoted names."),
        Statements_are_not_allowed_in_ambient_contexts: diag(1036, ts2.DiagnosticCategory.Error, "Statements_are_not_allowed_in_ambient_contexts_1036", "Statements are not allowed in ambient contexts."),
        A_declare_modifier_cannot_be_used_in_an_already_ambient_context: diag(1038, ts2.DiagnosticCategory.Error, "A_declare_modifier_cannot_be_used_in_an_already_ambient_context_1038", "A 'declare' modifier cannot be used in an already ambient context."),
        Initializers_are_not_allowed_in_ambient_contexts: diag(1039, ts2.DiagnosticCategory.Error, "Initializers_are_not_allowed_in_ambient_contexts_1039", "Initializers are not allowed in ambient contexts."),
        _0_modifier_cannot_be_used_in_an_ambient_context: diag(1040, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_in_an_ambient_context_1040", "'{0}' modifier cannot be used in an ambient context."),
        _0_modifier_cannot_be_used_here: diag(1042, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_here_1042", "'{0}' modifier cannot be used here."),
        _0_modifier_cannot_appear_on_a_module_or_namespace_element: diag(1044, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_module_or_namespace_element_1044", "'{0}' modifier cannot appear on a module or namespace element."),
        Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier: diag(1046, ts2.DiagnosticCategory.Error, "Top_level_declarations_in_d_ts_files_must_start_with_either_a_declare_or_export_modifier_1046", "Top-level declarations in .d.ts files must start with either a 'declare' or 'export' modifier."),
        A_rest_parameter_cannot_be_optional: diag(1047, ts2.DiagnosticCategory.Error, "A_rest_parameter_cannot_be_optional_1047", "A rest parameter cannot be optional."),
        A_rest_parameter_cannot_have_an_initializer: diag(1048, ts2.DiagnosticCategory.Error, "A_rest_parameter_cannot_have_an_initializer_1048", "A rest parameter cannot have an initializer."),
        A_set_accessor_must_have_exactly_one_parameter: diag(1049, ts2.DiagnosticCategory.Error, "A_set_accessor_must_have_exactly_one_parameter_1049", "A 'set' accessor must have exactly one parameter."),
        A_set_accessor_cannot_have_an_optional_parameter: diag(1051, ts2.DiagnosticCategory.Error, "A_set_accessor_cannot_have_an_optional_parameter_1051", "A 'set' accessor cannot have an optional parameter."),
        A_set_accessor_parameter_cannot_have_an_initializer: diag(1052, ts2.DiagnosticCategory.Error, "A_set_accessor_parameter_cannot_have_an_initializer_1052", "A 'set' accessor parameter cannot have an initializer."),
        A_set_accessor_cannot_have_rest_parameter: diag(1053, ts2.DiagnosticCategory.Error, "A_set_accessor_cannot_have_rest_parameter_1053", "A 'set' accessor cannot have rest parameter."),
        A_get_accessor_cannot_have_parameters: diag(1054, ts2.DiagnosticCategory.Error, "A_get_accessor_cannot_have_parameters_1054", "A 'get' accessor cannot have parameters."),
        Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Promise_compatible_constructor_value: diag(1055, ts2.DiagnosticCategory.Error, "Type_0_is_not_a_valid_async_function_return_type_in_ES5_SlashES3_because_it_does_not_refer_to_a_Prom_1055", "Type '{0}' is not a valid async function return type in ES5/ES3 because it does not refer to a Promise-compatible constructor value."),
        Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher: diag(1056, ts2.DiagnosticCategory.Error, "Accessors_are_only_available_when_targeting_ECMAScript_5_and_higher_1056", "Accessors are only available when targeting ECMAScript 5 and higher."),
        The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1058, ts2.DiagnosticCategory.Error, "The_return_type_of_an_async_function_must_either_be_a_valid_promise_or_must_not_contain_a_callable_t_1058", "The return type of an async function must either be a valid promise or must not contain a callable 'then' member."),
        A_promise_must_have_a_then_method: diag(1059, ts2.DiagnosticCategory.Error, "A_promise_must_have_a_then_method_1059", "A promise must have a 'then' method."),
        The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback: diag(1060, ts2.DiagnosticCategory.Error, "The_first_parameter_of_the_then_method_of_a_promise_must_be_a_callback_1060", "The first parameter of the 'then' method of a promise must be a callback."),
        Enum_member_must_have_initializer: diag(1061, ts2.DiagnosticCategory.Error, "Enum_member_must_have_initializer_1061", "Enum member must have initializer."),
        Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method: diag(1062, ts2.DiagnosticCategory.Error, "Type_is_referenced_directly_or_indirectly_in_the_fulfillment_callback_of_its_own_then_method_1062", "Type is referenced directly or indirectly in the fulfillment callback of its own 'then' method."),
        An_export_assignment_cannot_be_used_in_a_namespace: diag(1063, ts2.DiagnosticCategory.Error, "An_export_assignment_cannot_be_used_in_a_namespace_1063", "An export assignment cannot be used in a namespace."),
        The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_Did_you_mean_to_write_Promise_0: diag(1064, ts2.DiagnosticCategory.Error, "The_return_type_of_an_async_function_or_method_must_be_the_global_Promise_T_type_Did_you_mean_to_wri_1064", "The return type of an async function or method must be the global Promise<T> type. Did you mean to write 'Promise<{0}>'?"),
        In_ambient_enum_declarations_member_initializer_must_be_constant_expression: diag(1066, ts2.DiagnosticCategory.Error, "In_ambient_enum_declarations_member_initializer_must_be_constant_expression_1066", "In ambient enum declarations member initializer must be constant expression."),
        Unexpected_token_A_constructor_method_accessor_or_property_was_expected: diag(1068, ts2.DiagnosticCategory.Error, "Unexpected_token_A_constructor_method_accessor_or_property_was_expected_1068", "Unexpected token. A constructor, method, accessor, or property was expected."),
        Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces: diag(1069, ts2.DiagnosticCategory.Error, "Unexpected_token_A_type_parameter_name_was_expected_without_curly_braces_1069", "Unexpected token. A type parameter name was expected without curly braces."),
        _0_modifier_cannot_appear_on_a_type_member: diag(1070, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_type_member_1070", "'{0}' modifier cannot appear on a type member."),
        _0_modifier_cannot_appear_on_an_index_signature: diag(1071, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_an_index_signature_1071", "'{0}' modifier cannot appear on an index signature."),
        A_0_modifier_cannot_be_used_with_an_import_declaration: diag(1079, ts2.DiagnosticCategory.Error, "A_0_modifier_cannot_be_used_with_an_import_declaration_1079", "A '{0}' modifier cannot be used with an import declaration."),
        Invalid_reference_directive_syntax: diag(1084, ts2.DiagnosticCategory.Error, "Invalid_reference_directive_syntax_1084", "Invalid 'reference' directive syntax."),
        Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0: diag(1085, ts2.DiagnosticCategory.Error, "Octal_literals_are_not_available_when_targeting_ECMAScript_5_and_higher_Use_the_syntax_0_1085", "Octal literals are not available when targeting ECMAScript 5 and higher. Use the syntax '{0}'."),
        _0_modifier_cannot_appear_on_a_constructor_declaration: diag(1089, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_constructor_declaration_1089", "'{0}' modifier cannot appear on a constructor declaration."),
        _0_modifier_cannot_appear_on_a_parameter: diag(1090, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_parameter_1090", "'{0}' modifier cannot appear on a parameter."),
        Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement: diag(1091, ts2.DiagnosticCategory.Error, "Only_a_single_variable_declaration_is_allowed_in_a_for_in_statement_1091", "Only a single variable declaration is allowed in a 'for...in' statement."),
        Type_parameters_cannot_appear_on_a_constructor_declaration: diag(1092, ts2.DiagnosticCategory.Error, "Type_parameters_cannot_appear_on_a_constructor_declaration_1092", "Type parameters cannot appear on a constructor declaration."),
        Type_annotation_cannot_appear_on_a_constructor_declaration: diag(1093, ts2.DiagnosticCategory.Error, "Type_annotation_cannot_appear_on_a_constructor_declaration_1093", "Type annotation cannot appear on a constructor declaration."),
        An_accessor_cannot_have_type_parameters: diag(1094, ts2.DiagnosticCategory.Error, "An_accessor_cannot_have_type_parameters_1094", "An accessor cannot have type parameters."),
        A_set_accessor_cannot_have_a_return_type_annotation: diag(1095, ts2.DiagnosticCategory.Error, "A_set_accessor_cannot_have_a_return_type_annotation_1095", "A 'set' accessor cannot have a return type annotation."),
        An_index_signature_must_have_exactly_one_parameter: diag(1096, ts2.DiagnosticCategory.Error, "An_index_signature_must_have_exactly_one_parameter_1096", "An index signature must have exactly one parameter."),
        _0_list_cannot_be_empty: diag(1097, ts2.DiagnosticCategory.Error, "_0_list_cannot_be_empty_1097", "'{0}' list cannot be empty."),
        Type_parameter_list_cannot_be_empty: diag(1098, ts2.DiagnosticCategory.Error, "Type_parameter_list_cannot_be_empty_1098", "Type parameter list cannot be empty."),
        Type_argument_list_cannot_be_empty: diag(1099, ts2.DiagnosticCategory.Error, "Type_argument_list_cannot_be_empty_1099", "Type argument list cannot be empty."),
        Invalid_use_of_0_in_strict_mode: diag(1100, ts2.DiagnosticCategory.Error, "Invalid_use_of_0_in_strict_mode_1100", "Invalid use of '{0}' in strict mode."),
        with_statements_are_not_allowed_in_strict_mode: diag(1101, ts2.DiagnosticCategory.Error, "with_statements_are_not_allowed_in_strict_mode_1101", "'with' statements are not allowed in strict mode."),
        delete_cannot_be_called_on_an_identifier_in_strict_mode: diag(1102, ts2.DiagnosticCategory.Error, "delete_cannot_be_called_on_an_identifier_in_strict_mode_1102", "'delete' cannot be called on an identifier in strict mode."),
        for_await_loops_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules: diag(1103, ts2.DiagnosticCategory.Error, "for_await_loops_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules_1103", "'for await' loops are only allowed within async functions and at the top levels of modules."),
        A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement: diag(1104, ts2.DiagnosticCategory.Error, "A_continue_statement_can_only_be_used_within_an_enclosing_iteration_statement_1104", "A 'continue' statement can only be used within an enclosing iteration statement."),
        A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement: diag(1105, ts2.DiagnosticCategory.Error, "A_break_statement_can_only_be_used_within_an_enclosing_iteration_or_switch_statement_1105", "A 'break' statement can only be used within an enclosing iteration or switch statement."),
        The_left_hand_side_of_a_for_of_statement_may_not_be_async: diag(1106, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_may_not_be_async_1106", "The left-hand side of a 'for...of' statement may not be 'async'."),
        Jump_target_cannot_cross_function_boundary: diag(1107, ts2.DiagnosticCategory.Error, "Jump_target_cannot_cross_function_boundary_1107", "Jump target cannot cross function boundary."),
        A_return_statement_can_only_be_used_within_a_function_body: diag(1108, ts2.DiagnosticCategory.Error, "A_return_statement_can_only_be_used_within_a_function_body_1108", "A 'return' statement can only be used within a function body."),
        Expression_expected: diag(1109, ts2.DiagnosticCategory.Error, "Expression_expected_1109", "Expression expected."),
        Type_expected: diag(1110, ts2.DiagnosticCategory.Error, "Type_expected_1110", "Type expected."),
        A_default_clause_cannot_appear_more_than_once_in_a_switch_statement: diag(1113, ts2.DiagnosticCategory.Error, "A_default_clause_cannot_appear_more_than_once_in_a_switch_statement_1113", "A 'default' clause cannot appear more than once in a 'switch' statement."),
        Duplicate_label_0: diag(1114, ts2.DiagnosticCategory.Error, "Duplicate_label_0_1114", "Duplicate label '{0}'."),
        A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement: diag(1115, ts2.DiagnosticCategory.Error, "A_continue_statement_can_only_jump_to_a_label_of_an_enclosing_iteration_statement_1115", "A 'continue' statement can only jump to a label of an enclosing iteration statement."),
        A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement: diag(1116, ts2.DiagnosticCategory.Error, "A_break_statement_can_only_jump_to_a_label_of_an_enclosing_statement_1116", "A 'break' statement can only jump to a label of an enclosing statement."),
        An_object_literal_cannot_have_multiple_properties_with_the_same_name: diag(1117, ts2.DiagnosticCategory.Error, "An_object_literal_cannot_have_multiple_properties_with_the_same_name_1117", "An object literal cannot have multiple properties with the same name."),
        An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name: diag(1118, ts2.DiagnosticCategory.Error, "An_object_literal_cannot_have_multiple_get_Slashset_accessors_with_the_same_name_1118", "An object literal cannot have multiple get/set accessors with the same name."),
        An_object_literal_cannot_have_property_and_accessor_with_the_same_name: diag(1119, ts2.DiagnosticCategory.Error, "An_object_literal_cannot_have_property_and_accessor_with_the_same_name_1119", "An object literal cannot have property and accessor with the same name."),
        An_export_assignment_cannot_have_modifiers: diag(1120, ts2.DiagnosticCategory.Error, "An_export_assignment_cannot_have_modifiers_1120", "An export assignment cannot have modifiers."),
        Octal_literals_are_not_allowed_in_strict_mode: diag(1121, ts2.DiagnosticCategory.Error, "Octal_literals_are_not_allowed_in_strict_mode_1121", "Octal literals are not allowed in strict mode."),
        Variable_declaration_list_cannot_be_empty: diag(1123, ts2.DiagnosticCategory.Error, "Variable_declaration_list_cannot_be_empty_1123", "Variable declaration list cannot be empty."),
        Digit_expected: diag(1124, ts2.DiagnosticCategory.Error, "Digit_expected_1124", "Digit expected."),
        Hexadecimal_digit_expected: diag(1125, ts2.DiagnosticCategory.Error, "Hexadecimal_digit_expected_1125", "Hexadecimal digit expected."),
        Unexpected_end_of_text: diag(1126, ts2.DiagnosticCategory.Error, "Unexpected_end_of_text_1126", "Unexpected end of text."),
        Invalid_character: diag(1127, ts2.DiagnosticCategory.Error, "Invalid_character_1127", "Invalid character."),
        Declaration_or_statement_expected: diag(1128, ts2.DiagnosticCategory.Error, "Declaration_or_statement_expected_1128", "Declaration or statement expected."),
        Statement_expected: diag(1129, ts2.DiagnosticCategory.Error, "Statement_expected_1129", "Statement expected."),
        case_or_default_expected: diag(1130, ts2.DiagnosticCategory.Error, "case_or_default_expected_1130", "'case' or 'default' expected."),
        Property_or_signature_expected: diag(1131, ts2.DiagnosticCategory.Error, "Property_or_signature_expected_1131", "Property or signature expected."),
        Enum_member_expected: diag(1132, ts2.DiagnosticCategory.Error, "Enum_member_expected_1132", "Enum member expected."),
        Variable_declaration_expected: diag(1134, ts2.DiagnosticCategory.Error, "Variable_declaration_expected_1134", "Variable declaration expected."),
        Argument_expression_expected: diag(1135, ts2.DiagnosticCategory.Error, "Argument_expression_expected_1135", "Argument expression expected."),
        Property_assignment_expected: diag(1136, ts2.DiagnosticCategory.Error, "Property_assignment_expected_1136", "Property assignment expected."),
        Expression_or_comma_expected: diag(1137, ts2.DiagnosticCategory.Error, "Expression_or_comma_expected_1137", "Expression or comma expected."),
        Parameter_declaration_expected: diag(1138, ts2.DiagnosticCategory.Error, "Parameter_declaration_expected_1138", "Parameter declaration expected."),
        Type_parameter_declaration_expected: diag(1139, ts2.DiagnosticCategory.Error, "Type_parameter_declaration_expected_1139", "Type parameter declaration expected."),
        Type_argument_expected: diag(1140, ts2.DiagnosticCategory.Error, "Type_argument_expected_1140", "Type argument expected."),
        String_literal_expected: diag(1141, ts2.DiagnosticCategory.Error, "String_literal_expected_1141", "String literal expected."),
        Line_break_not_permitted_here: diag(1142, ts2.DiagnosticCategory.Error, "Line_break_not_permitted_here_1142", "Line break not permitted here."),
        or_expected: diag(1144, ts2.DiagnosticCategory.Error, "or_expected_1144", "'{' or ';' expected."),
        or_JSX_element_expected: diag(1145, ts2.DiagnosticCategory.Error, "or_JSX_element_expected_1145", "'{' or JSX element expected."),
        Declaration_expected: diag(1146, ts2.DiagnosticCategory.Error, "Declaration_expected_1146", "Declaration expected."),
        Import_declarations_in_a_namespace_cannot_reference_a_module: diag(1147, ts2.DiagnosticCategory.Error, "Import_declarations_in_a_namespace_cannot_reference_a_module_1147", "Import declarations in a namespace cannot reference a module."),
        Cannot_use_imports_exports_or_module_augmentations_when_module_is_none: diag(1148, ts2.DiagnosticCategory.Error, "Cannot_use_imports_exports_or_module_augmentations_when_module_is_none_1148", "Cannot use imports, exports, or module augmentations when '--module' is 'none'."),
        File_name_0_differs_from_already_included_file_name_1_only_in_casing: diag(1149, ts2.DiagnosticCategory.Error, "File_name_0_differs_from_already_included_file_name_1_only_in_casing_1149", "File name '{0}' differs from already included file name '{1}' only in casing."),
        const_declarations_must_be_initialized: diag(1155, ts2.DiagnosticCategory.Error, "const_declarations_must_be_initialized_1155", "'const' declarations must be initialized."),
        const_declarations_can_only_be_declared_inside_a_block: diag(1156, ts2.DiagnosticCategory.Error, "const_declarations_can_only_be_declared_inside_a_block_1156", "'const' declarations can only be declared inside a block."),
        let_declarations_can_only_be_declared_inside_a_block: diag(1157, ts2.DiagnosticCategory.Error, "let_declarations_can_only_be_declared_inside_a_block_1157", "'let' declarations can only be declared inside a block."),
        Unterminated_template_literal: diag(1160, ts2.DiagnosticCategory.Error, "Unterminated_template_literal_1160", "Unterminated template literal."),
        Unterminated_regular_expression_literal: diag(1161, ts2.DiagnosticCategory.Error, "Unterminated_regular_expression_literal_1161", "Unterminated regular expression literal."),
        An_object_member_cannot_be_declared_optional: diag(1162, ts2.DiagnosticCategory.Error, "An_object_member_cannot_be_declared_optional_1162", "An object member cannot be declared optional."),
        A_yield_expression_is_only_allowed_in_a_generator_body: diag(1163, ts2.DiagnosticCategory.Error, "A_yield_expression_is_only_allowed_in_a_generator_body_1163", "A 'yield' expression is only allowed in a generator body."),
        Computed_property_names_are_not_allowed_in_enums: diag(1164, ts2.DiagnosticCategory.Error, "Computed_property_names_are_not_allowed_in_enums_1164", "Computed property names are not allowed in enums."),
        A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1165, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_an_ambient_context_must_refer_to_an_expression_whose_type_is_a_literal_t_1165", "A computed property name in an ambient context must refer to an expression whose type is a literal type or a 'unique symbol' type."),
        A_computed_property_name_in_a_class_property_declaration_must_have_a_simple_literal_type_or_a_unique_symbol_type: diag(1166, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_a_class_property_declaration_must_have_a_simple_literal_type_or_a_unique_1166", "A computed property name in a class property declaration must have a simple literal type or a 'unique symbol' type."),
        A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1168, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_a_method_overload_must_refer_to_an_expression_whose_type_is_a_literal_ty_1168", "A computed property name in a method overload must refer to an expression whose type is a literal type or a 'unique symbol' type."),
        A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1169, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_an_interface_must_refer_to_an_expression_whose_type_is_a_literal_type_or_1169", "A computed property name in an interface must refer to an expression whose type is a literal type or a 'unique symbol' type."),
        A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type_or_a_unique_symbol_type: diag(1170, ts2.DiagnosticCategory.Error, "A_computed_property_name_in_a_type_literal_must_refer_to_an_expression_whose_type_is_a_literal_type__1170", "A computed property name in a type literal must refer to an expression whose type is a literal type or a 'unique symbol' type."),
        A_comma_expression_is_not_allowed_in_a_computed_property_name: diag(1171, ts2.DiagnosticCategory.Error, "A_comma_expression_is_not_allowed_in_a_computed_property_name_1171", "A comma expression is not allowed in a computed property name."),
        extends_clause_already_seen: diag(1172, ts2.DiagnosticCategory.Error, "extends_clause_already_seen_1172", "'extends' clause already seen."),
        extends_clause_must_precede_implements_clause: diag(1173, ts2.DiagnosticCategory.Error, "extends_clause_must_precede_implements_clause_1173", "'extends' clause must precede 'implements' clause."),
        Classes_can_only_extend_a_single_class: diag(1174, ts2.DiagnosticCategory.Error, "Classes_can_only_extend_a_single_class_1174", "Classes can only extend a single class."),
        implements_clause_already_seen: diag(1175, ts2.DiagnosticCategory.Error, "implements_clause_already_seen_1175", "'implements' clause already seen."),
        Interface_declaration_cannot_have_implements_clause: diag(1176, ts2.DiagnosticCategory.Error, "Interface_declaration_cannot_have_implements_clause_1176", "Interface declaration cannot have 'implements' clause."),
        Binary_digit_expected: diag(1177, ts2.DiagnosticCategory.Error, "Binary_digit_expected_1177", "Binary digit expected."),
        Octal_digit_expected: diag(1178, ts2.DiagnosticCategory.Error, "Octal_digit_expected_1178", "Octal digit expected."),
        Unexpected_token_expected: diag(1179, ts2.DiagnosticCategory.Error, "Unexpected_token_expected_1179", "Unexpected token. '{' expected."),
        Property_destructuring_pattern_expected: diag(1180, ts2.DiagnosticCategory.Error, "Property_destructuring_pattern_expected_1180", "Property destructuring pattern expected."),
        Array_element_destructuring_pattern_expected: diag(1181, ts2.DiagnosticCategory.Error, "Array_element_destructuring_pattern_expected_1181", "Array element destructuring pattern expected."),
        A_destructuring_declaration_must_have_an_initializer: diag(1182, ts2.DiagnosticCategory.Error, "A_destructuring_declaration_must_have_an_initializer_1182", "A destructuring declaration must have an initializer."),
        An_implementation_cannot_be_declared_in_ambient_contexts: diag(1183, ts2.DiagnosticCategory.Error, "An_implementation_cannot_be_declared_in_ambient_contexts_1183", "An implementation cannot be declared in ambient contexts."),
        Modifiers_cannot_appear_here: diag(1184, ts2.DiagnosticCategory.Error, "Modifiers_cannot_appear_here_1184", "Modifiers cannot appear here."),
        Merge_conflict_marker_encountered: diag(1185, ts2.DiagnosticCategory.Error, "Merge_conflict_marker_encountered_1185", "Merge conflict marker encountered."),
        A_rest_element_cannot_have_an_initializer: diag(1186, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_have_an_initializer_1186", "A rest element cannot have an initializer."),
        A_parameter_property_may_not_be_declared_using_a_binding_pattern: diag(1187, ts2.DiagnosticCategory.Error, "A_parameter_property_may_not_be_declared_using_a_binding_pattern_1187", "A parameter property may not be declared using a binding pattern."),
        Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement: diag(1188, ts2.DiagnosticCategory.Error, "Only_a_single_variable_declaration_is_allowed_in_a_for_of_statement_1188", "Only a single variable declaration is allowed in a 'for...of' statement."),
        The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer: diag(1189, ts2.DiagnosticCategory.Error, "The_variable_declaration_of_a_for_in_statement_cannot_have_an_initializer_1189", "The variable declaration of a 'for...in' statement cannot have an initializer."),
        The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer: diag(1190, ts2.DiagnosticCategory.Error, "The_variable_declaration_of_a_for_of_statement_cannot_have_an_initializer_1190", "The variable declaration of a 'for...of' statement cannot have an initializer."),
        An_import_declaration_cannot_have_modifiers: diag(1191, ts2.DiagnosticCategory.Error, "An_import_declaration_cannot_have_modifiers_1191", "An import declaration cannot have modifiers."),
        Module_0_has_no_default_export: diag(1192, ts2.DiagnosticCategory.Error, "Module_0_has_no_default_export_1192", "Module '{0}' has no default export."),
        An_export_declaration_cannot_have_modifiers: diag(1193, ts2.DiagnosticCategory.Error, "An_export_declaration_cannot_have_modifiers_1193", "An export declaration cannot have modifiers."),
        Export_declarations_are_not_permitted_in_a_namespace: diag(1194, ts2.DiagnosticCategory.Error, "Export_declarations_are_not_permitted_in_a_namespace_1194", "Export declarations are not permitted in a namespace."),
        export_Asterisk_does_not_re_export_a_default: diag(1195, ts2.DiagnosticCategory.Error, "export_Asterisk_does_not_re_export_a_default_1195", "'export *' does not re-export a default."),
        Catch_clause_variable_type_annotation_must_be_any_or_unknown_if_specified: diag(1196, ts2.DiagnosticCategory.Error, "Catch_clause_variable_type_annotation_must_be_any_or_unknown_if_specified_1196", "Catch clause variable type annotation must be 'any' or 'unknown' if specified."),
        Catch_clause_variable_cannot_have_an_initializer: diag(1197, ts2.DiagnosticCategory.Error, "Catch_clause_variable_cannot_have_an_initializer_1197", "Catch clause variable cannot have an initializer."),
        An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive: diag(1198, ts2.DiagnosticCategory.Error, "An_extended_Unicode_escape_value_must_be_between_0x0_and_0x10FFFF_inclusive_1198", "An extended Unicode escape value must be between 0x0 and 0x10FFFF inclusive."),
        Unterminated_Unicode_escape_sequence: diag(1199, ts2.DiagnosticCategory.Error, "Unterminated_Unicode_escape_sequence_1199", "Unterminated Unicode escape sequence."),
        Line_terminator_not_permitted_before_arrow: diag(1200, ts2.DiagnosticCategory.Error, "Line_terminator_not_permitted_before_arrow_1200", "Line terminator not permitted before arrow."),
        Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_ns_from_mod_import_a_from_mod_import_d_from_mod_or_another_module_format_instead: diag(1202, ts2.DiagnosticCategory.Error, "Import_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_import_Asterisk_as_1202", `Import assignment cannot be used when targeting ECMAScript modules. Consider using 'import * as ns from "mod"', 'import {a} from "mod"', 'import d from "mod"', or another module format instead.`),
        Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or_another_module_format_instead: diag(1203, ts2.DiagnosticCategory.Error, "Export_assignment_cannot_be_used_when_targeting_ECMAScript_modules_Consider_using_export_default_or__1203", "Export assignment cannot be used when targeting ECMAScript modules. Consider using 'export default' or another module format instead."),
        Re_exporting_a_type_when_the_isolatedModules_flag_is_provided_requires_using_export_type: diag(1205, ts2.DiagnosticCategory.Error, "Re_exporting_a_type_when_the_isolatedModules_flag_is_provided_requires_using_export_type_1205", "Re-exporting a type when the '--isolatedModules' flag is provided requires using 'export type'."),
        Decorators_are_not_valid_here: diag(1206, ts2.DiagnosticCategory.Error, "Decorators_are_not_valid_here_1206", "Decorators are not valid here."),
        Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name: diag(1207, ts2.DiagnosticCategory.Error, "Decorators_cannot_be_applied_to_multiple_get_Slashset_accessors_of_the_same_name_1207", "Decorators cannot be applied to multiple get/set accessors of the same name."),
        _0_cannot_be_compiled_under_isolatedModules_because_it_is_considered_a_global_script_file_Add_an_import_export_or_an_empty_export_statement_to_make_it_a_module: diag(1208, ts2.DiagnosticCategory.Error, "_0_cannot_be_compiled_under_isolatedModules_because_it_is_considered_a_global_script_file_Add_an_imp_1208", "'{0}' cannot be compiled under '--isolatedModules' because it is considered a global script file. Add an import, export, or an empty 'export {}' statement to make it a module."),
        Invalid_optional_chain_from_new_expression_Did_you_mean_to_call_0: diag(1209, ts2.DiagnosticCategory.Error, "Invalid_optional_chain_from_new_expression_Did_you_mean_to_call_0_1209", "Invalid optional chain from new expression. Did you mean to call '{0}()'?"),
        Code_contained_in_a_class_is_evaluated_in_JavaScript_s_strict_mode_which_does_not_allow_this_use_of_0_For_more_information_see_https_Colon_Slash_Slashdeveloper_mozilla_org_Slashen_US_Slashdocs_SlashWeb_SlashJavaScript_SlashReference_SlashStrict_mode: diag(1210, ts2.DiagnosticCategory.Error, "Code_contained_in_a_class_is_evaluated_in_JavaScript_s_strict_mode_which_does_not_allow_this_use_of__1210", "Code contained in a class is evaluated in JavaScript's strict mode which does not allow this use of '{0}'. For more information, see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode."),
        A_class_declaration_without_the_default_modifier_must_have_a_name: diag(1211, ts2.DiagnosticCategory.Error, "A_class_declaration_without_the_default_modifier_must_have_a_name_1211", "A class declaration without the 'default' modifier must have a name."),
        Identifier_expected_0_is_a_reserved_word_in_strict_mode: diag(1212, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_1212", "Identifier expected. '{0}' is a reserved word in strict mode."),
        Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_strict_mode: diag(1213, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_Class_definitions_are_automatically_in_stric_1213", "Identifier expected. '{0}' is a reserved word in strict mode. Class definitions are automatically in strict mode."),
        Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode: diag(1214, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_in_strict_mode_Modules_are_automatically_in_strict_mode_1214", "Identifier expected. '{0}' is a reserved word in strict mode. Modules are automatically in strict mode."),
        Invalid_use_of_0_Modules_are_automatically_in_strict_mode: diag(1215, ts2.DiagnosticCategory.Error, "Invalid_use_of_0_Modules_are_automatically_in_strict_mode_1215", "Invalid use of '{0}'. Modules are automatically in strict mode."),
        Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules: diag(1216, ts2.DiagnosticCategory.Error, "Identifier_expected_esModule_is_reserved_as_an_exported_marker_when_transforming_ECMAScript_modules_1216", "Identifier expected. '__esModule' is reserved as an exported marker when transforming ECMAScript modules."),
        Export_assignment_is_not_supported_when_module_flag_is_system: diag(1218, ts2.DiagnosticCategory.Error, "Export_assignment_is_not_supported_when_module_flag_is_system_1218", "Export assignment is not supported when '--module' flag is 'system'."),
        Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_the_experimentalDecorators_option_in_your_tsconfig_or_jsconfig_to_remove_this_warning: diag(1219, ts2.DiagnosticCategory.Error, "Experimental_support_for_decorators_is_a_feature_that_is_subject_to_change_in_a_future_release_Set_t_1219", "Experimental support for decorators is a feature that is subject to change in a future release. Set the 'experimentalDecorators' option in your 'tsconfig' or 'jsconfig' to remove this warning."),
        Generators_are_not_allowed_in_an_ambient_context: diag(1221, ts2.DiagnosticCategory.Error, "Generators_are_not_allowed_in_an_ambient_context_1221", "Generators are not allowed in an ambient context."),
        An_overload_signature_cannot_be_declared_as_a_generator: diag(1222, ts2.DiagnosticCategory.Error, "An_overload_signature_cannot_be_declared_as_a_generator_1222", "An overload signature cannot be declared as a generator."),
        _0_tag_already_specified: diag(1223, ts2.DiagnosticCategory.Error, "_0_tag_already_specified_1223", "'{0}' tag already specified."),
        Signature_0_must_be_a_type_predicate: diag(1224, ts2.DiagnosticCategory.Error, "Signature_0_must_be_a_type_predicate_1224", "Signature '{0}' must be a type predicate."),
        Cannot_find_parameter_0: diag(1225, ts2.DiagnosticCategory.Error, "Cannot_find_parameter_0_1225", "Cannot find parameter '{0}'."),
        Type_predicate_0_is_not_assignable_to_1: diag(1226, ts2.DiagnosticCategory.Error, "Type_predicate_0_is_not_assignable_to_1_1226", "Type predicate '{0}' is not assignable to '{1}'."),
        Parameter_0_is_not_in_the_same_position_as_parameter_1: diag(1227, ts2.DiagnosticCategory.Error, "Parameter_0_is_not_in_the_same_position_as_parameter_1_1227", "Parameter '{0}' is not in the same position as parameter '{1}'."),
        A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods: diag(1228, ts2.DiagnosticCategory.Error, "A_type_predicate_is_only_allowed_in_return_type_position_for_functions_and_methods_1228", "A type predicate is only allowed in return type position for functions and methods."),
        A_type_predicate_cannot_reference_a_rest_parameter: diag(1229, ts2.DiagnosticCategory.Error, "A_type_predicate_cannot_reference_a_rest_parameter_1229", "A type predicate cannot reference a rest parameter."),
        A_type_predicate_cannot_reference_element_0_in_a_binding_pattern: diag(1230, ts2.DiagnosticCategory.Error, "A_type_predicate_cannot_reference_element_0_in_a_binding_pattern_1230", "A type predicate cannot reference element '{0}' in a binding pattern."),
        An_export_assignment_must_be_at_the_top_level_of_a_file_or_module_declaration: diag(1231, ts2.DiagnosticCategory.Error, "An_export_assignment_must_be_at_the_top_level_of_a_file_or_module_declaration_1231", "An export assignment must be at the top level of a file or module declaration."),
        An_import_declaration_can_only_be_used_at_the_top_level_of_a_namespace_or_module: diag(1232, ts2.DiagnosticCategory.Error, "An_import_declaration_can_only_be_used_at_the_top_level_of_a_namespace_or_module_1232", "An import declaration can only be used at the top level of a namespace or module."),
        An_export_declaration_can_only_be_used_at_the_top_level_of_a_namespace_or_module: diag(1233, ts2.DiagnosticCategory.Error, "An_export_declaration_can_only_be_used_at_the_top_level_of_a_namespace_or_module_1233", "An export declaration can only be used at the top level of a namespace or module."),
        An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file: diag(1234, ts2.DiagnosticCategory.Error, "An_ambient_module_declaration_is_only_allowed_at_the_top_level_in_a_file_1234", "An ambient module declaration is only allowed at the top level in a file."),
        A_namespace_declaration_is_only_allowed_at_the_top_level_of_a_namespace_or_module: diag(1235, ts2.DiagnosticCategory.Error, "A_namespace_declaration_is_only_allowed_at_the_top_level_of_a_namespace_or_module_1235", "A namespace declaration is only allowed at the top level of a namespace or module."),
        The_return_type_of_a_property_decorator_function_must_be_either_void_or_any: diag(1236, ts2.DiagnosticCategory.Error, "The_return_type_of_a_property_decorator_function_must_be_either_void_or_any_1236", "The return type of a property decorator function must be either 'void' or 'any'."),
        The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any: diag(1237, ts2.DiagnosticCategory.Error, "The_return_type_of_a_parameter_decorator_function_must_be_either_void_or_any_1237", "The return type of a parameter decorator function must be either 'void' or 'any'."),
        Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression: diag(1238, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_class_decorator_when_called_as_an_expression_1238", "Unable to resolve signature of class decorator when called as an expression."),
        Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression: diag(1239, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_parameter_decorator_when_called_as_an_expression_1239", "Unable to resolve signature of parameter decorator when called as an expression."),
        Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression: diag(1240, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_property_decorator_when_called_as_an_expression_1240", "Unable to resolve signature of property decorator when called as an expression."),
        Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression: diag(1241, ts2.DiagnosticCategory.Error, "Unable_to_resolve_signature_of_method_decorator_when_called_as_an_expression_1241", "Unable to resolve signature of method decorator when called as an expression."),
        abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration: diag(1242, ts2.DiagnosticCategory.Error, "abstract_modifier_can_only_appear_on_a_class_method_or_property_declaration_1242", "'abstract' modifier can only appear on a class, method, or property declaration."),
        _0_modifier_cannot_be_used_with_1_modifier: diag(1243, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_be_used_with_1_modifier_1243", "'{0}' modifier cannot be used with '{1}' modifier."),
        Abstract_methods_can_only_appear_within_an_abstract_class: diag(1244, ts2.DiagnosticCategory.Error, "Abstract_methods_can_only_appear_within_an_abstract_class_1244", "Abstract methods can only appear within an abstract class."),
        Method_0_cannot_have_an_implementation_because_it_is_marked_abstract: diag(1245, ts2.DiagnosticCategory.Error, "Method_0_cannot_have_an_implementation_because_it_is_marked_abstract_1245", "Method '{0}' cannot have an implementation because it is marked abstract."),
        An_interface_property_cannot_have_an_initializer: diag(1246, ts2.DiagnosticCategory.Error, "An_interface_property_cannot_have_an_initializer_1246", "An interface property cannot have an initializer."),
        A_type_literal_property_cannot_have_an_initializer: diag(1247, ts2.DiagnosticCategory.Error, "A_type_literal_property_cannot_have_an_initializer_1247", "A type literal property cannot have an initializer."),
        A_class_member_cannot_have_the_0_keyword: diag(1248, ts2.DiagnosticCategory.Error, "A_class_member_cannot_have_the_0_keyword_1248", "A class member cannot have the '{0}' keyword."),
        A_decorator_can_only_decorate_a_method_implementation_not_an_overload: diag(1249, ts2.DiagnosticCategory.Error, "A_decorator_can_only_decorate_a_method_implementation_not_an_overload_1249", "A decorator can only decorate a method implementation, not an overload."),
        Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5: diag(1250, ts2.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_1250", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'."),
        Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_definitions_are_automatically_in_strict_mode: diag(1251, ts2.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Class_d_1251", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Class definitions are automatically in strict mode."),
        Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_are_automatically_in_strict_mode: diag(1252, ts2.DiagnosticCategory.Error, "Function_declarations_are_not_allowed_inside_blocks_in_strict_mode_when_targeting_ES3_or_ES5_Modules_1252", "Function declarations are not allowed inside blocks in strict mode when targeting 'ES3' or 'ES5'. Modules are automatically in strict mode."),
        A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_reference: diag(1254, ts2.DiagnosticCategory.Error, "A_const_initializer_in_an_ambient_context_must_be_a_string_or_numeric_literal_or_literal_enum_refere_1254", "A 'const' initializer in an ambient context must be a string or numeric literal or literal enum reference."),
        A_definite_assignment_assertion_is_not_permitted_in_this_context: diag(1255, ts2.DiagnosticCategory.Error, "A_definite_assignment_assertion_is_not_permitted_in_this_context_1255", "A definite assignment assertion '!' is not permitted in this context."),
        A_required_element_cannot_follow_an_optional_element: diag(1257, ts2.DiagnosticCategory.Error, "A_required_element_cannot_follow_an_optional_element_1257", "A required element cannot follow an optional element."),
        A_default_export_must_be_at_the_top_level_of_a_file_or_module_declaration: diag(1258, ts2.DiagnosticCategory.Error, "A_default_export_must_be_at_the_top_level_of_a_file_or_module_declaration_1258", "A default export must be at the top level of a file or module declaration."),
        Module_0_can_only_be_default_imported_using_the_1_flag: diag(1259, ts2.DiagnosticCategory.Error, "Module_0_can_only_be_default_imported_using_the_1_flag_1259", "Module '{0}' can only be default-imported using the '{1}' flag"),
        Keywords_cannot_contain_escape_characters: diag(1260, ts2.DiagnosticCategory.Error, "Keywords_cannot_contain_escape_characters_1260", "Keywords cannot contain escape characters."),
        Already_included_file_name_0_differs_from_file_name_1_only_in_casing: diag(1261, ts2.DiagnosticCategory.Error, "Already_included_file_name_0_differs_from_file_name_1_only_in_casing_1261", "Already included file name '{0}' differs from file name '{1}' only in casing."),
        Identifier_expected_0_is_a_reserved_word_at_the_top_level_of_a_module: diag(1262, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_at_the_top_level_of_a_module_1262", "Identifier expected. '{0}' is a reserved word at the top-level of a module."),
        Declarations_with_initializers_cannot_also_have_definite_assignment_assertions: diag(1263, ts2.DiagnosticCategory.Error, "Declarations_with_initializers_cannot_also_have_definite_assignment_assertions_1263", "Declarations with initializers cannot also have definite assignment assertions."),
        Declarations_with_definite_assignment_assertions_must_also_have_type_annotations: diag(1264, ts2.DiagnosticCategory.Error, "Declarations_with_definite_assignment_assertions_must_also_have_type_annotations_1264", "Declarations with definite assignment assertions must also have type annotations."),
        A_rest_element_cannot_follow_another_rest_element: diag(1265, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_follow_another_rest_element_1265", "A rest element cannot follow another rest element."),
        An_optional_element_cannot_follow_a_rest_element: diag(1266, ts2.DiagnosticCategory.Error, "An_optional_element_cannot_follow_a_rest_element_1266", "An optional element cannot follow a rest element."),
        Property_0_cannot_have_an_initializer_because_it_is_marked_abstract: diag(1267, ts2.DiagnosticCategory.Error, "Property_0_cannot_have_an_initializer_because_it_is_marked_abstract_1267", "Property '{0}' cannot have an initializer because it is marked abstract."),
        An_index_signature_parameter_type_must_be_string_number_symbol_or_a_template_literal_type: diag(1268, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_type_must_be_string_number_symbol_or_a_template_literal_type_1268", "An index signature parameter type must be 'string', 'number', 'symbol', or a template literal type."),
        Cannot_use_export_import_on_a_type_or_type_only_namespace_when_the_isolatedModules_flag_is_provided: diag(1269, ts2.DiagnosticCategory.Error, "Cannot_use_export_import_on_a_type_or_type_only_namespace_when_the_isolatedModules_flag_is_provided_1269", "Cannot use 'export import' on a type or type-only namespace when the '--isolatedModules' flag is provided."),
        Decorator_function_return_type_0_is_not_assignable_to_type_1: diag(1270, ts2.DiagnosticCategory.Error, "Decorator_function_return_type_0_is_not_assignable_to_type_1_1270", "Decorator function return type '{0}' is not assignable to type '{1}'."),
        Decorator_function_return_type_is_0_but_is_expected_to_be_void_or_any: diag(1271, ts2.DiagnosticCategory.Error, "Decorator_function_return_type_is_0_but_is_expected_to_be_void_or_any_1271", "Decorator function return type is '{0}' but is expected to be 'void' or 'any'."),
        A_type_referenced_in_a_decorated_signature_must_be_imported_with_import_type_or_a_namespace_import_when_isolatedModules_and_emitDecoratorMetadata_are_enabled: diag(1272, ts2.DiagnosticCategory.Error, "A_type_referenced_in_a_decorated_signature_must_be_imported_with_import_type_or_a_namespace_import_w_1272", "A type referenced in a decorated signature must be imported with 'import type' or a namespace import when 'isolatedModules' and 'emitDecoratorMetadata' are enabled."),
        _0_modifier_cannot_appear_on_a_type_parameter: diag(1273, ts2.DiagnosticCategory.Error, "_0_modifier_cannot_appear_on_a_type_parameter_1273", "'{0}' modifier cannot appear on a type parameter"),
        _0_modifier_can_only_appear_on_a_type_parameter_of_a_class_interface_or_type_alias: diag(1274, ts2.DiagnosticCategory.Error, "_0_modifier_can_only_appear_on_a_type_parameter_of_a_class_interface_or_type_alias_1274", "'{0}' modifier can only appear on a type parameter of a class, interface or type alias"),
        with_statements_are_not_allowed_in_an_async_function_block: diag(1300, ts2.DiagnosticCategory.Error, "with_statements_are_not_allowed_in_an_async_function_block_1300", "'with' statements are not allowed in an async function block."),
        await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules: diag(1308, ts2.DiagnosticCategory.Error, "await_expressions_are_only_allowed_within_async_functions_and_at_the_top_levels_of_modules_1308", "'await' expressions are only allowed within async functions and at the top levels of modules."),
        The_current_file_is_a_CommonJS_module_and_cannot_use_await_at_the_top_level: diag(1309, ts2.DiagnosticCategory.Error, "The_current_file_is_a_CommonJS_module_and_cannot_use_await_at_the_top_level_1309", "The current file is a CommonJS module and cannot use 'await' at the top level."),
        Did_you_mean_to_use_a_Colon_An_can_only_follow_a_property_name_when_the_containing_object_literal_is_part_of_a_destructuring_pattern: diag(1312, ts2.DiagnosticCategory.Error, "Did_you_mean_to_use_a_Colon_An_can_only_follow_a_property_name_when_the_containing_object_literal_is_1312", "Did you mean to use a ':'? An '=' can only follow a property name when the containing object literal is part of a destructuring pattern."),
        The_body_of_an_if_statement_cannot_be_the_empty_statement: diag(1313, ts2.DiagnosticCategory.Error, "The_body_of_an_if_statement_cannot_be_the_empty_statement_1313", "The body of an 'if' statement cannot be the empty statement."),
        Global_module_exports_may_only_appear_in_module_files: diag(1314, ts2.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_in_module_files_1314", "Global module exports may only appear in module files."),
        Global_module_exports_may_only_appear_in_declaration_files: diag(1315, ts2.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_in_declaration_files_1315", "Global module exports may only appear in declaration files."),
        Global_module_exports_may_only_appear_at_top_level: diag(1316, ts2.DiagnosticCategory.Error, "Global_module_exports_may_only_appear_at_top_level_1316", "Global module exports may only appear at top level."),
        A_parameter_property_cannot_be_declared_using_a_rest_parameter: diag(1317, ts2.DiagnosticCategory.Error, "A_parameter_property_cannot_be_declared_using_a_rest_parameter_1317", "A parameter property cannot be declared using a rest parameter."),
        An_abstract_accessor_cannot_have_an_implementation: diag(1318, ts2.DiagnosticCategory.Error, "An_abstract_accessor_cannot_have_an_implementation_1318", "An abstract accessor cannot have an implementation."),
        A_default_export_can_only_be_used_in_an_ECMAScript_style_module: diag(1319, ts2.DiagnosticCategory.Error, "A_default_export_can_only_be_used_in_an_ECMAScript_style_module_1319", "A default export can only be used in an ECMAScript-style module."),
        Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1320, ts2.DiagnosticCategory.Error, "Type_of_await_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member_1320", "Type of 'await' operand must either be a valid promise or must not contain a callable 'then' member."),
        Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1321, ts2.DiagnosticCategory.Error, "Type_of_yield_operand_in_an_async_generator_must_either_be_a_valid_promise_or_must_not_contain_a_cal_1321", "Type of 'yield' operand in an async generator must either be a valid promise or must not contain a callable 'then' member."),
        Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_contain_a_callable_then_member: diag(1322, ts2.DiagnosticCategory.Error, "Type_of_iterated_elements_of_a_yield_Asterisk_operand_must_either_be_a_valid_promise_or_must_not_con_1322", "Type of iterated elements of a 'yield*' operand must either be a valid promise or must not contain a callable 'then' member."),
        Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_es2022_esnext_commonjs_amd_system_umd_node16_or_nodenext: diag(1323, ts2.DiagnosticCategory.Error, "Dynamic_imports_are_only_supported_when_the_module_flag_is_set_to_es2020_es2022_esnext_commonjs_amd__1323", "Dynamic imports are only supported when the '--module' flag is set to 'es2020', 'es2022', 'esnext', 'commonjs', 'amd', 'system', 'umd', 'node16', or 'nodenext'."),
        Dynamic_imports_only_support_a_second_argument_when_the_module_option_is_set_to_esnext_node16_or_nodenext: diag(1324, ts2.DiagnosticCategory.Error, "Dynamic_imports_only_support_a_second_argument_when_the_module_option_is_set_to_esnext_node16_or_nod_1324", "Dynamic imports only support a second argument when the '--module' option is set to 'esnext', 'node16', or 'nodenext'."),
        Argument_of_dynamic_import_cannot_be_spread_element: diag(1325, ts2.DiagnosticCategory.Error, "Argument_of_dynamic_import_cannot_be_spread_element_1325", "Argument of dynamic import cannot be spread element."),
        This_use_of_import_is_invalid_import_calls_can_be_written_but_they_must_have_parentheses_and_cannot_have_type_arguments: diag(1326, ts2.DiagnosticCategory.Error, "This_use_of_import_is_invalid_import_calls_can_be_written_but_they_must_have_parentheses_and_cannot__1326", "This use of 'import' is invalid. 'import()' calls can be written, but they must have parentheses and cannot have type arguments."),
        String_literal_with_double_quotes_expected: diag(1327, ts2.DiagnosticCategory.Error, "String_literal_with_double_quotes_expected_1327", "String literal with double quotes expected."),
        Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_literal: diag(1328, ts2.DiagnosticCategory.Error, "Property_value_can_only_be_string_literal_numeric_literal_true_false_null_object_literal_or_array_li_1328", "Property value can only be string literal, numeric literal, 'true', 'false', 'null', object literal or array literal."),
        _0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write_0: diag(1329, ts2.DiagnosticCategory.Error, "_0_accepts_too_few_arguments_to_be_used_as_a_decorator_here_Did_you_mean_to_call_it_first_and_write__1329", "'{0}' accepts too few arguments to be used as a decorator here. Did you mean to call it first and write '@{0}()'?"),
        A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly: diag(1330, ts2.DiagnosticCategory.Error, "A_property_of_an_interface_or_type_literal_whose_type_is_a_unique_symbol_type_must_be_readonly_1330", "A property of an interface or type literal whose type is a 'unique symbol' type must be 'readonly'."),
        A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly: diag(1331, ts2.DiagnosticCategory.Error, "A_property_of_a_class_whose_type_is_a_unique_symbol_type_must_be_both_static_and_readonly_1331", "A property of a class whose type is a 'unique symbol' type must be both 'static' and 'readonly'."),
        A_variable_whose_type_is_a_unique_symbol_type_must_be_const: diag(1332, ts2.DiagnosticCategory.Error, "A_variable_whose_type_is_a_unique_symbol_type_must_be_const_1332", "A variable whose type is a 'unique symbol' type must be 'const'."),
        unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name: diag(1333, ts2.DiagnosticCategory.Error, "unique_symbol_types_may_not_be_used_on_a_variable_declaration_with_a_binding_name_1333", "'unique symbol' types may not be used on a variable declaration with a binding name."),
        unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement: diag(1334, ts2.DiagnosticCategory.Error, "unique_symbol_types_are_only_allowed_on_variables_in_a_variable_statement_1334", "'unique symbol' types are only allowed on variables in a variable statement."),
        unique_symbol_types_are_not_allowed_here: diag(1335, ts2.DiagnosticCategory.Error, "unique_symbol_types_are_not_allowed_here_1335", "'unique symbol' types are not allowed here."),
        An_index_signature_parameter_type_cannot_be_a_literal_type_or_generic_type_Consider_using_a_mapped_object_type_instead: diag(1337, ts2.DiagnosticCategory.Error, "An_index_signature_parameter_type_cannot_be_a_literal_type_or_generic_type_Consider_using_a_mapped_o_1337", "An index signature parameter type cannot be a literal type or generic type. Consider using a mapped object type instead."),
        infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type: diag(1338, ts2.DiagnosticCategory.Error, "infer_declarations_are_only_permitted_in_the_extends_clause_of_a_conditional_type_1338", "'infer' declarations are only permitted in the 'extends' clause of a conditional type."),
        Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here: diag(1339, ts2.DiagnosticCategory.Error, "Module_0_does_not_refer_to_a_value_but_is_used_as_a_value_here_1339", "Module '{0}' does not refer to a value, but is used as a value here."),
        Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0: diag(1340, ts2.DiagnosticCategory.Error, "Module_0_does_not_refer_to_a_type_but_is_used_as_a_type_here_Did_you_mean_typeof_import_0_1340", "Module '{0}' does not refer to a type, but is used as a type here. Did you mean 'typeof import('{0}')'?"),
        Class_constructor_may_not_be_an_accessor: diag(1341, ts2.DiagnosticCategory.Error, "Class_constructor_may_not_be_an_accessor_1341", "Class constructor may not be an accessor."),
        Type_arguments_cannot_be_used_here: diag(1342, ts2.DiagnosticCategory.Error, "Type_arguments_cannot_be_used_here_1342", "Type arguments cannot be used here."),
        The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_es2020_es2022_esnext_system_node16_or_nodenext: diag(1343, ts2.DiagnosticCategory.Error, "The_import_meta_meta_property_is_only_allowed_when_the_module_option_is_es2020_es2022_esnext_system__1343", "The 'import.meta' meta-property is only allowed when the '--module' option is 'es2020', 'es2022', 'esnext', 'system', 'node16', or 'nodenext'."),
        A_label_is_not_allowed_here: diag(1344, ts2.DiagnosticCategory.Error, "A_label_is_not_allowed_here_1344", "'A label is not allowed here."),
        An_expression_of_type_void_cannot_be_tested_for_truthiness: diag(1345, ts2.DiagnosticCategory.Error, "An_expression_of_type_void_cannot_be_tested_for_truthiness_1345", "An expression of type 'void' cannot be tested for truthiness."),
        This_parameter_is_not_allowed_with_use_strict_directive: diag(1346, ts2.DiagnosticCategory.Error, "This_parameter_is_not_allowed_with_use_strict_directive_1346", "This parameter is not allowed with 'use strict' directive."),
        use_strict_directive_cannot_be_used_with_non_simple_parameter_list: diag(1347, ts2.DiagnosticCategory.Error, "use_strict_directive_cannot_be_used_with_non_simple_parameter_list_1347", "'use strict' directive cannot be used with non-simple parameter list."),
        Non_simple_parameter_declared_here: diag(1348, ts2.DiagnosticCategory.Error, "Non_simple_parameter_declared_here_1348", "Non-simple parameter declared here."),
        use_strict_directive_used_here: diag(1349, ts2.DiagnosticCategory.Error, "use_strict_directive_used_here_1349", "'use strict' directive used here."),
        Print_the_final_configuration_instead_of_building: diag(1350, ts2.DiagnosticCategory.Message, "Print_the_final_configuration_instead_of_building_1350", "Print the final configuration instead of building."),
        An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal: diag(1351, ts2.DiagnosticCategory.Error, "An_identifier_or_keyword_cannot_immediately_follow_a_numeric_literal_1351", "An identifier or keyword cannot immediately follow a numeric literal."),
        A_bigint_literal_cannot_use_exponential_notation: diag(1352, ts2.DiagnosticCategory.Error, "A_bigint_literal_cannot_use_exponential_notation_1352", "A bigint literal cannot use exponential notation."),
        A_bigint_literal_must_be_an_integer: diag(1353, ts2.DiagnosticCategory.Error, "A_bigint_literal_must_be_an_integer_1353", "A bigint literal must be an integer."),
        readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types: diag(1354, ts2.DiagnosticCategory.Error, "readonly_type_modifier_is_only_permitted_on_array_and_tuple_literal_types_1354", "'readonly' type modifier is only permitted on array and tuple literal types."),
        A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array_or_object_literals: diag(1355, ts2.DiagnosticCategory.Error, "A_const_assertions_can_only_be_applied_to_references_to_enum_members_or_string_number_boolean_array__1355", "A 'const' assertions can only be applied to references to enum members, or string, number, boolean, array, or object literals."),
        Did_you_mean_to_mark_this_function_as_async: diag(1356, ts2.DiagnosticCategory.Error, "Did_you_mean_to_mark_this_function_as_async_1356", "Did you mean to mark this function as 'async'?"),
        An_enum_member_name_must_be_followed_by_a_or: diag(1357, ts2.DiagnosticCategory.Error, "An_enum_member_name_must_be_followed_by_a_or_1357", "An enum member name must be followed by a ',', '=', or '}'."),
        Tagged_template_expressions_are_not_permitted_in_an_optional_chain: diag(1358, ts2.DiagnosticCategory.Error, "Tagged_template_expressions_are_not_permitted_in_an_optional_chain_1358", "Tagged template expressions are not permitted in an optional chain."),
        Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here: diag(1359, ts2.DiagnosticCategory.Error, "Identifier_expected_0_is_a_reserved_word_that_cannot_be_used_here_1359", "Identifier expected. '{0}' is a reserved word that cannot be used here."),
        Class_constructor_may_not_be_a_generator: diag(1360, ts2.DiagnosticCategory.Error, "Class_constructor_may_not_be_a_generator_1360", "Class constructor may not be a generator."),
        _0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type: diag(1361, ts2.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_value_because_it_was_imported_using_import_type_1361", "'{0}' cannot be used as a value because it was imported using 'import type'."),
        _0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type: diag(1362, ts2.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_value_because_it_was_exported_using_export_type_1362", "'{0}' cannot be used as a value because it was exported using 'export type'."),
        A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both: diag(1363, ts2.DiagnosticCategory.Error, "A_type_only_import_can_specify_a_default_import_or_named_bindings_but_not_both_1363", "A type-only import can specify a default import or named bindings, but not both."),
        Convert_to_type_only_export: diag(1364, ts2.DiagnosticCategory.Message, "Convert_to_type_only_export_1364", "Convert to type-only export"),
        Convert_all_re_exported_types_to_type_only_exports: diag(1365, ts2.DiagnosticCategory.Message, "Convert_all_re_exported_types_to_type_only_exports_1365", "Convert all re-exported types to type-only exports"),
        Split_into_two_separate_import_declarations: diag(1366, ts2.DiagnosticCategory.Message, "Split_into_two_separate_import_declarations_1366", "Split into two separate import declarations"),
        Split_all_invalid_type_only_imports: diag(1367, ts2.DiagnosticCategory.Message, "Split_all_invalid_type_only_imports_1367", "Split all invalid type-only imports"),
        Did_you_mean_0: diag(1369, ts2.DiagnosticCategory.Message, "Did_you_mean_0_1369", "Did you mean '{0}'?"),
        This_import_is_never_used_as_a_value_and_must_use_import_type_because_importsNotUsedAsValues_is_set_to_error: diag(1371, ts2.DiagnosticCategory.Error, "This_import_is_never_used_as_a_value_and_must_use_import_type_because_importsNotUsedAsValues_is_set__1371", "This import is never used as a value and must use 'import type' because 'importsNotUsedAsValues' is set to 'error'."),
        Convert_to_type_only_import: diag(1373, ts2.DiagnosticCategory.Message, "Convert_to_type_only_import_1373", "Convert to type-only import"),
        Convert_all_imports_not_used_as_a_value_to_type_only_imports: diag(1374, ts2.DiagnosticCategory.Message, "Convert_all_imports_not_used_as_a_value_to_type_only_imports_1374", "Convert all imports not used as a value to type-only imports"),
        await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_has_no_imports_or_exports_Consider_adding_an_empty_export_to_make_this_file_a_module: diag(1375, ts2.DiagnosticCategory.Error, "await_expressions_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_fi_1375", "'await' expressions are only allowed at the top level of a file when that file is a module, but this file has no imports or exports. Consider adding an empty 'export {}' to make this file a module."),
        _0_was_imported_here: diag(1376, ts2.DiagnosticCategory.Message, "_0_was_imported_here_1376", "'{0}' was imported here."),
        _0_was_exported_here: diag(1377, ts2.DiagnosticCategory.Message, "_0_was_exported_here_1377", "'{0}' was exported here."),
        Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_node16_or_nodenext_and_the_target_option_is_set_to_es2017_or_higher: diag(1378, ts2.DiagnosticCategory.Error, "Top_level_await_expressions_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_n_1378", "Top-level 'await' expressions are only allowed when the 'module' option is set to 'es2022', 'esnext', 'system', 'node16', or 'nodenext', and the 'target' option is set to 'es2017' or higher."),
        An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type: diag(1379, ts2.DiagnosticCategory.Error, "An_import_alias_cannot_reference_a_declaration_that_was_exported_using_export_type_1379", "An import alias cannot reference a declaration that was exported using 'export type'."),
        An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type: diag(1380, ts2.DiagnosticCategory.Error, "An_import_alias_cannot_reference_a_declaration_that_was_imported_using_import_type_1380", "An import alias cannot reference a declaration that was imported using 'import type'."),
        Unexpected_token_Did_you_mean_or_rbrace: diag(1381, ts2.DiagnosticCategory.Error, "Unexpected_token_Did_you_mean_or_rbrace_1381", "Unexpected token. Did you mean `{'}'}` or `&rbrace;`?"),
        Unexpected_token_Did_you_mean_or_gt: diag(1382, ts2.DiagnosticCategory.Error, "Unexpected_token_Did_you_mean_or_gt_1382", "Unexpected token. Did you mean `{'>'}` or `&gt;`?"),
        Only_named_exports_may_use_export_type: diag(1383, ts2.DiagnosticCategory.Error, "Only_named_exports_may_use_export_type_1383", "Only named exports may use 'export type'."),
        Function_type_notation_must_be_parenthesized_when_used_in_a_union_type: diag(1385, ts2.DiagnosticCategory.Error, "Function_type_notation_must_be_parenthesized_when_used_in_a_union_type_1385", "Function type notation must be parenthesized when used in a union type."),
        Constructor_type_notation_must_be_parenthesized_when_used_in_a_union_type: diag(1386, ts2.DiagnosticCategory.Error, "Constructor_type_notation_must_be_parenthesized_when_used_in_a_union_type_1386", "Constructor type notation must be parenthesized when used in a union type."),
        Function_type_notation_must_be_parenthesized_when_used_in_an_intersection_type: diag(1387, ts2.DiagnosticCategory.Error, "Function_type_notation_must_be_parenthesized_when_used_in_an_intersection_type_1387", "Function type notation must be parenthesized when used in an intersection type."),
        Constructor_type_notation_must_be_parenthesized_when_used_in_an_intersection_type: diag(1388, ts2.DiagnosticCategory.Error, "Constructor_type_notation_must_be_parenthesized_when_used_in_an_intersection_type_1388", "Constructor type notation must be parenthesized when used in an intersection type."),
        _0_is_not_allowed_as_a_variable_declaration_name: diag(1389, ts2.DiagnosticCategory.Error, "_0_is_not_allowed_as_a_variable_declaration_name_1389", "'{0}' is not allowed as a variable declaration name."),
        _0_is_not_allowed_as_a_parameter_name: diag(1390, ts2.DiagnosticCategory.Error, "_0_is_not_allowed_as_a_parameter_name_1390", "'{0}' is not allowed as a parameter name."),
        An_import_alias_cannot_use_import_type: diag(1392, ts2.DiagnosticCategory.Error, "An_import_alias_cannot_use_import_type_1392", "An import alias cannot use 'import type'"),
        Imported_via_0_from_file_1: diag(1393, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_1393", "Imported via {0} from file '{1}'"),
        Imported_via_0_from_file_1_with_packageId_2: diag(1394, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_with_packageId_2_1394", "Imported via {0} from file '{1}' with packageId '{2}'"),
        Imported_via_0_from_file_1_to_import_importHelpers_as_specified_in_compilerOptions: diag(1395, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_to_import_importHelpers_as_specified_in_compilerOptions_1395", "Imported via {0} from file '{1}' to import 'importHelpers' as specified in compilerOptions"),
        Imported_via_0_from_file_1_with_packageId_2_to_import_importHelpers_as_specified_in_compilerOptions: diag(1396, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_with_packageId_2_to_import_importHelpers_as_specified_in_compilerOptions_1396", "Imported via {0} from file '{1}' with packageId '{2}' to import 'importHelpers' as specified in compilerOptions"),
        Imported_via_0_from_file_1_to_import_jsx_and_jsxs_factory_functions: diag(1397, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_to_import_jsx_and_jsxs_factory_functions_1397", "Imported via {0} from file '{1}' to import 'jsx' and 'jsxs' factory functions"),
        Imported_via_0_from_file_1_with_packageId_2_to_import_jsx_and_jsxs_factory_functions: diag(1398, ts2.DiagnosticCategory.Message, "Imported_via_0_from_file_1_with_packageId_2_to_import_jsx_and_jsxs_factory_functions_1398", "Imported via {0} from file '{1}' with packageId '{2}' to import 'jsx' and 'jsxs' factory functions"),
        File_is_included_via_import_here: diag(1399, ts2.DiagnosticCategory.Message, "File_is_included_via_import_here_1399", "File is included via import here."),
        Referenced_via_0_from_file_1: diag(1400, ts2.DiagnosticCategory.Message, "Referenced_via_0_from_file_1_1400", "Referenced via '{0}' from file '{1}'"),
        File_is_included_via_reference_here: diag(1401, ts2.DiagnosticCategory.Message, "File_is_included_via_reference_here_1401", "File is included via reference here."),
        Type_library_referenced_via_0_from_file_1: diag(1402, ts2.DiagnosticCategory.Message, "Type_library_referenced_via_0_from_file_1_1402", "Type library referenced via '{0}' from file '{1}'"),
        Type_library_referenced_via_0_from_file_1_with_packageId_2: diag(1403, ts2.DiagnosticCategory.Message, "Type_library_referenced_via_0_from_file_1_with_packageId_2_1403", "Type library referenced via '{0}' from file '{1}' with packageId '{2}'"),
        File_is_included_via_type_library_reference_here: diag(1404, ts2.DiagnosticCategory.Message, "File_is_included_via_type_library_reference_here_1404", "File is included via type library reference here."),
        Library_referenced_via_0_from_file_1: diag(1405, ts2.DiagnosticCategory.Message, "Library_referenced_via_0_from_file_1_1405", "Library referenced via '{0}' from file '{1}'"),
        File_is_included_via_library_reference_here: diag(1406, ts2.DiagnosticCategory.Message, "File_is_included_via_library_reference_here_1406", "File is included via library reference here."),
        Matched_by_include_pattern_0_in_1: diag(1407, ts2.DiagnosticCategory.Message, "Matched_by_include_pattern_0_in_1_1407", "Matched by include pattern '{0}' in '{1}'"),
        File_is_matched_by_include_pattern_specified_here: diag(1408, ts2.DiagnosticCategory.Message, "File_is_matched_by_include_pattern_specified_here_1408", "File is matched by include pattern specified here."),
        Part_of_files_list_in_tsconfig_json: diag(1409, ts2.DiagnosticCategory.Message, "Part_of_files_list_in_tsconfig_json_1409", "Part of 'files' list in tsconfig.json"),
        File_is_matched_by_files_list_specified_here: diag(1410, ts2.DiagnosticCategory.Message, "File_is_matched_by_files_list_specified_here_1410", "File is matched by 'files' list specified here."),
        Output_from_referenced_project_0_included_because_1_specified: diag(1411, ts2.DiagnosticCategory.Message, "Output_from_referenced_project_0_included_because_1_specified_1411", "Output from referenced project '{0}' included because '{1}' specified"),
        Output_from_referenced_project_0_included_because_module_is_specified_as_none: diag(1412, ts2.DiagnosticCategory.Message, "Output_from_referenced_project_0_included_because_module_is_specified_as_none_1412", "Output from referenced project '{0}' included because '--module' is specified as 'none'"),
        File_is_output_from_referenced_project_specified_here: diag(1413, ts2.DiagnosticCategory.Message, "File_is_output_from_referenced_project_specified_here_1413", "File is output from referenced project specified here."),
        Source_from_referenced_project_0_included_because_1_specified: diag(1414, ts2.DiagnosticCategory.Message, "Source_from_referenced_project_0_included_because_1_specified_1414", "Source from referenced project '{0}' included because '{1}' specified"),
        Source_from_referenced_project_0_included_because_module_is_specified_as_none: diag(1415, ts2.DiagnosticCategory.Message, "Source_from_referenced_project_0_included_because_module_is_specified_as_none_1415", "Source from referenced project '{0}' included because '--module' is specified as 'none'"),
        File_is_source_from_referenced_project_specified_here: diag(1416, ts2.DiagnosticCategory.Message, "File_is_source_from_referenced_project_specified_here_1416", "File is source from referenced project specified here."),
        Entry_point_of_type_library_0_specified_in_compilerOptions: diag(1417, ts2.DiagnosticCategory.Message, "Entry_point_of_type_library_0_specified_in_compilerOptions_1417", "Entry point of type library '{0}' specified in compilerOptions"),
        Entry_point_of_type_library_0_specified_in_compilerOptions_with_packageId_1: diag(1418, ts2.DiagnosticCategory.Message, "Entry_point_of_type_library_0_specified_in_compilerOptions_with_packageId_1_1418", "Entry point of type library '{0}' specified in compilerOptions with packageId '{1}'"),
        File_is_entry_point_of_type_library_specified_here: diag(1419, ts2.DiagnosticCategory.Message, "File_is_entry_point_of_type_library_specified_here_1419", "File is entry point of type library specified here."),
        Entry_point_for_implicit_type_library_0: diag(1420, ts2.DiagnosticCategory.Message, "Entry_point_for_implicit_type_library_0_1420", "Entry point for implicit type library '{0}'"),
        Entry_point_for_implicit_type_library_0_with_packageId_1: diag(1421, ts2.DiagnosticCategory.Message, "Entry_point_for_implicit_type_library_0_with_packageId_1_1421", "Entry point for implicit type library '{0}' with packageId '{1}'"),
        Library_0_specified_in_compilerOptions: diag(1422, ts2.DiagnosticCategory.Message, "Library_0_specified_in_compilerOptions_1422", "Library '{0}' specified in compilerOptions"),
        File_is_library_specified_here: diag(1423, ts2.DiagnosticCategory.Message, "File_is_library_specified_here_1423", "File is library specified here."),
        Default_library: diag(1424, ts2.DiagnosticCategory.Message, "Default_library_1424", "Default library"),
        Default_library_for_target_0: diag(1425, ts2.DiagnosticCategory.Message, "Default_library_for_target_0_1425", "Default library for target '{0}'"),
        File_is_default_library_for_target_specified_here: diag(1426, ts2.DiagnosticCategory.Message, "File_is_default_library_for_target_specified_here_1426", "File is default library for target specified here."),
        Root_file_specified_for_compilation: diag(1427, ts2.DiagnosticCategory.Message, "Root_file_specified_for_compilation_1427", "Root file specified for compilation"),
        File_is_output_of_project_reference_source_0: diag(1428, ts2.DiagnosticCategory.Message, "File_is_output_of_project_reference_source_0_1428", "File is output of project reference source '{0}'"),
        File_redirects_to_file_0: diag(1429, ts2.DiagnosticCategory.Message, "File_redirects_to_file_0_1429", "File redirects to file '{0}'"),
        The_file_is_in_the_program_because_Colon: diag(1430, ts2.DiagnosticCategory.Message, "The_file_is_in_the_program_because_Colon_1430", "The file is in the program because:"),
        for_await_loops_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_has_no_imports_or_exports_Consider_adding_an_empty_export_to_make_this_file_a_module: diag(1431, ts2.DiagnosticCategory.Error, "for_await_loops_are_only_allowed_at_the_top_level_of_a_file_when_that_file_is_a_module_but_this_file_1431", "'for await' loops are only allowed at the top level of a file when that file is a module, but this file has no imports or exports. Consider adding an empty 'export {}' to make this file a module."),
        Top_level_for_await_loops_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_node16_or_nodenext_and_the_target_option_is_set_to_es2017_or_higher: diag(1432, ts2.DiagnosticCategory.Error, "Top_level_for_await_loops_are_only_allowed_when_the_module_option_is_set_to_es2022_esnext_system_nod_1432", "Top-level 'for await' loops are only allowed when the 'module' option is set to 'es2022', 'esnext', 'system', 'node16', or 'nodenext', and the 'target' option is set to 'es2017' or higher."),
        Decorators_may_not_be_applied_to_this_parameters: diag(1433, ts2.DiagnosticCategory.Error, "Decorators_may_not_be_applied_to_this_parameters_1433", "Decorators may not be applied to 'this' parameters."),
        Unexpected_keyword_or_identifier: diag(1434, ts2.DiagnosticCategory.Error, "Unexpected_keyword_or_identifier_1434", "Unexpected keyword or identifier."),
        Unknown_keyword_or_identifier_Did_you_mean_0: diag(1435, ts2.DiagnosticCategory.Error, "Unknown_keyword_or_identifier_Did_you_mean_0_1435", "Unknown keyword or identifier. Did you mean '{0}'?"),
        Decorators_must_precede_the_name_and_all_keywords_of_property_declarations: diag(1436, ts2.DiagnosticCategory.Error, "Decorators_must_precede_the_name_and_all_keywords_of_property_declarations_1436", "Decorators must precede the name and all keywords of property declarations."),
        Namespace_must_be_given_a_name: diag(1437, ts2.DiagnosticCategory.Error, "Namespace_must_be_given_a_name_1437", "Namespace must be given a name."),
        Interface_must_be_given_a_name: diag(1438, ts2.DiagnosticCategory.Error, "Interface_must_be_given_a_name_1438", "Interface must be given a name."),
        Type_alias_must_be_given_a_name: diag(1439, ts2.DiagnosticCategory.Error, "Type_alias_must_be_given_a_name_1439", "Type alias must be given a name."),
        Variable_declaration_not_allowed_at_this_location: diag(1440, ts2.DiagnosticCategory.Error, "Variable_declaration_not_allowed_at_this_location_1440", "Variable declaration not allowed at this location."),
        Cannot_start_a_function_call_in_a_type_annotation: diag(1441, ts2.DiagnosticCategory.Error, "Cannot_start_a_function_call_in_a_type_annotation_1441", "Cannot start a function call in a type annotation."),
        Expected_for_property_initializer: diag(1442, ts2.DiagnosticCategory.Error, "Expected_for_property_initializer_1442", "Expected '=' for property initializer."),
        Module_declaration_names_may_only_use_or_quoted_strings: diag(1443, ts2.DiagnosticCategory.Error, "Module_declaration_names_may_only_use_or_quoted_strings_1443", `Module declaration names may only use ' or " quoted strings.`),
        _0_is_a_type_and_must_be_imported_using_a_type_only_import_when_preserveValueImports_and_isolatedModules_are_both_enabled: diag(1444, ts2.DiagnosticCategory.Error, "_0_is_a_type_and_must_be_imported_using_a_type_only_import_when_preserveValueImports_and_isolatedMod_1444", "'{0}' is a type and must be imported using a type-only import when 'preserveValueImports' and 'isolatedModules' are both enabled."),
        _0_resolves_to_a_type_only_declaration_and_must_be_imported_using_a_type_only_import_when_preserveValueImports_and_isolatedModules_are_both_enabled: diag(1446, ts2.DiagnosticCategory.Error, "_0_resolves_to_a_type_only_declaration_and_must_be_imported_using_a_type_only_import_when_preserveVa_1446", "'{0}' resolves to a type-only declaration and must be imported using a type-only import when 'preserveValueImports' and 'isolatedModules' are both enabled."),
        _0_resolves_to_a_type_only_declaration_and_must_be_re_exported_using_a_type_only_re_export_when_isolatedModules_is_enabled: diag(1448, ts2.DiagnosticCategory.Error, "_0_resolves_to_a_type_only_declaration_and_must_be_re_exported_using_a_type_only_re_export_when_isol_1448", "'{0}' resolves to a type-only declaration and must be re-exported using a type-only re-export when 'isolatedModules' is enabled."),
        Preserve_unused_imported_values_in_the_JavaScript_output_that_would_otherwise_be_removed: diag(1449, ts2.DiagnosticCategory.Message, "Preserve_unused_imported_values_in_the_JavaScript_output_that_would_otherwise_be_removed_1449", "Preserve unused imported values in the JavaScript output that would otherwise be removed."),
        Dynamic_imports_can_only_accept_a_module_specifier_and_an_optional_assertion_as_arguments: diag(1450, ts2.DiagnosticCategory.Message, "Dynamic_imports_can_only_accept_a_module_specifier_and_an_optional_assertion_as_arguments_1450", "Dynamic imports can only accept a module specifier and an optional assertion as arguments"),
        Private_identifiers_are_only_allowed_in_class_bodies_and_may_only_be_used_as_part_of_a_class_member_declaration_property_access_or_on_the_left_hand_side_of_an_in_expression: diag(1451, ts2.DiagnosticCategory.Error, "Private_identifiers_are_only_allowed_in_class_bodies_and_may_only_be_used_as_part_of_a_class_member__1451", "Private identifiers are only allowed in class bodies and may only be used as part of a class member declaration, property access, or on the left-hand-side of an 'in' expression"),
        resolution_mode_assertions_are_only_supported_when_moduleResolution_is_node16_or_nodenext: diag(1452, ts2.DiagnosticCategory.Error, "resolution_mode_assertions_are_only_supported_when_moduleResolution_is_node16_or_nodenext_1452", "'resolution-mode' assertions are only supported when `moduleResolution` is `node16` or `nodenext`."),
        resolution_mode_should_be_either_require_or_import: diag(1453, ts2.DiagnosticCategory.Error, "resolution_mode_should_be_either_require_or_import_1453", "`resolution-mode` should be either `require` or `import`."),
        resolution_mode_can_only_be_set_for_type_only_imports: diag(1454, ts2.DiagnosticCategory.Error, "resolution_mode_can_only_be_set_for_type_only_imports_1454", "`resolution-mode` can only be set for type-only imports."),
        resolution_mode_is_the_only_valid_key_for_type_import_assertions: diag(1455, ts2.DiagnosticCategory.Error, "resolution_mode_is_the_only_valid_key_for_type_import_assertions_1455", "`resolution-mode` is the only valid key for type import assertions."),
        Type_import_assertions_should_have_exactly_one_key_resolution_mode_with_value_import_or_require: diag(1456, ts2.DiagnosticCategory.Error, "Type_import_assertions_should_have_exactly_one_key_resolution_mode_with_value_import_or_require_1456", "Type import assertions should have exactly one key - `resolution-mode` - with value `import` or `require`."),
        Matched_by_default_include_pattern_Asterisk_Asterisk_Slash_Asterisk: diag(1457, ts2.DiagnosticCategory.Message, "Matched_by_default_include_pattern_Asterisk_Asterisk_Slash_Asterisk_1457", "Matched by default include pattern '**/*'"),
        File_is_ECMAScript_module_because_0_has_field_type_with_value_module: diag(1458, ts2.DiagnosticCategory.Message, "File_is_ECMAScript_module_because_0_has_field_type_with_value_module_1458", `File is ECMAScript module because '{0}' has field "type" with value "module"`),
        File_is_CommonJS_module_because_0_has_field_type_whose_value_is_not_module: diag(1459, ts2.DiagnosticCategory.Message, "File_is_CommonJS_module_because_0_has_field_type_whose_value_is_not_module_1459", `File is CommonJS module because '{0}' has field "type" whose value is not "module"`),
        File_is_CommonJS_module_because_0_does_not_have_field_type: diag(1460, ts2.DiagnosticCategory.Message, "File_is_CommonJS_module_because_0_does_not_have_field_type_1460", `File is CommonJS module because '{0}' does not have field "type"`),
        File_is_CommonJS_module_because_package_json_was_not_found: diag(1461, ts2.DiagnosticCategory.Message, "File_is_CommonJS_module_because_package_json_was_not_found_1461", "File is CommonJS module because 'package.json' was not found"),
        The_import_meta_meta_property_is_not_allowed_in_files_which_will_build_into_CommonJS_output: diag(1470, ts2.DiagnosticCategory.Error, "The_import_meta_meta_property_is_not_allowed_in_files_which_will_build_into_CommonJS_output_1470", "The 'import.meta' meta-property is not allowed in files which will build into CommonJS output."),
        Module_0_cannot_be_imported_using_this_construct_The_specifier_only_resolves_to_an_ES_module_which_cannot_be_imported_with_require_Use_an_ECMAScript_import_instead: diag(1471, ts2.DiagnosticCategory.Error, "Module_0_cannot_be_imported_using_this_construct_The_specifier_only_resolves_to_an_ES_module_which_c_1471", "Module '{0}' cannot be imported using this construct. The specifier only resolves to an ES module, which cannot be imported with 'require'. Use an ECMAScript import instead."),
        catch_or_finally_expected: diag(1472, ts2.DiagnosticCategory.Error, "catch_or_finally_expected_1472", "'catch' or 'finally' expected."),
        An_import_declaration_can_only_be_used_at_the_top_level_of_a_module: diag(1473, ts2.DiagnosticCategory.Error, "An_import_declaration_can_only_be_used_at_the_top_level_of_a_module_1473", "An import declaration can only be used at the top level of a module."),
        An_export_declaration_can_only_be_used_at_the_top_level_of_a_module: diag(1474, ts2.DiagnosticCategory.Error, "An_export_declaration_can_only_be_used_at_the_top_level_of_a_module_1474", "An export declaration can only be used at the top level of a module."),
        Control_what_method_is_used_to_detect_module_format_JS_files: diag(1475, ts2.DiagnosticCategory.Message, "Control_what_method_is_used_to_detect_module_format_JS_files_1475", "Control what method is used to detect module-format JS files."),
        auto_Colon_Treat_files_with_imports_exports_import_meta_jsx_with_jsx_Colon_react_jsx_or_esm_format_with_module_Colon_node16_as_modules: diag(1476, ts2.DiagnosticCategory.Message, "auto_Colon_Treat_files_with_imports_exports_import_meta_jsx_with_jsx_Colon_react_jsx_or_esm_format_w_1476", '"auto": Treat files with imports, exports, import.meta, jsx (with jsx: react-jsx), or esm format (with module: node16+) as modules.'),
        An_instantiation_expression_cannot_be_followed_by_a_property_access: diag(1477, ts2.DiagnosticCategory.Error, "An_instantiation_expression_cannot_be_followed_by_a_property_access_1477", "An instantiation expression cannot be followed by a property access."),
        Identifier_or_string_literal_expected: diag(1478, ts2.DiagnosticCategory.Error, "Identifier_or_string_literal_expected_1478", "Identifier or string literal expected."),
        The_current_file_is_a_CommonJS_module_whose_imports_will_produce_require_calls_however_the_referenced_file_is_an_ECMAScript_module_and_cannot_be_imported_with_require_Consider_writing_a_dynamic_import_0_call_instead: diag(1479, ts2.DiagnosticCategory.Error, "The_current_file_is_a_CommonJS_module_whose_imports_will_produce_require_calls_however_the_reference_1479", `The current file is a CommonJS module whose imports will produce 'require' calls; however, the referenced file is an ECMAScript module and cannot be imported with 'require'. Consider writing a dynamic 'import("{0}")' call instead.`),
        To_convert_this_file_to_an_ECMAScript_module_change_its_file_extension_to_0_or_create_a_local_package_json_file_with_type_Colon_module: diag(1480, ts2.DiagnosticCategory.Message, "To_convert_this_file_to_an_ECMAScript_module_change_its_file_extension_to_0_or_create_a_local_packag_1480", 'To convert this file to an ECMAScript module, change its file extension to \'{0}\' or create a local package.json file with `{ "type": "module" }`.'),
        To_convert_this_file_to_an_ECMAScript_module_change_its_file_extension_to_0_or_add_the_field_type_Colon_module_to_1: diag(1481, ts2.DiagnosticCategory.Message, "To_convert_this_file_to_an_ECMAScript_module_change_its_file_extension_to_0_or_add_the_field_type_Co_1481", `To convert this file to an ECMAScript module, change its file extension to '{0}', or add the field \`"type": "module"\` to '{1}'.`),
        To_convert_this_file_to_an_ECMAScript_module_add_the_field_type_Colon_module_to_0: diag(1482, ts2.DiagnosticCategory.Message, "To_convert_this_file_to_an_ECMAScript_module_add_the_field_type_Colon_module_to_0_1482", 'To convert this file to an ECMAScript module, add the field `"type": "module"` to \'{0}\'.'),
        To_convert_this_file_to_an_ECMAScript_module_create_a_local_package_json_file_with_type_Colon_module: diag(1483, ts2.DiagnosticCategory.Message, "To_convert_this_file_to_an_ECMAScript_module_create_a_local_package_json_file_with_type_Colon_module_1483", 'To convert this file to an ECMAScript module, create a local package.json file with `{ "type": "module" }`.'),
        The_types_of_0_are_incompatible_between_these_types: diag(2200, ts2.DiagnosticCategory.Error, "The_types_of_0_are_incompatible_between_these_types_2200", "The types of '{0}' are incompatible between these types."),
        The_types_returned_by_0_are_incompatible_between_these_types: diag(2201, ts2.DiagnosticCategory.Error, "The_types_returned_by_0_are_incompatible_between_these_types_2201", "The types returned by '{0}' are incompatible between these types."),
        Call_signature_return_types_0_and_1_are_incompatible: diag(2202, ts2.DiagnosticCategory.Error, "Call_signature_return_types_0_and_1_are_incompatible_2202", "Call signature return types '{0}' and '{1}' are incompatible.", void 0, true),
        Construct_signature_return_types_0_and_1_are_incompatible: diag(2203, ts2.DiagnosticCategory.Error, "Construct_signature_return_types_0_and_1_are_incompatible_2203", "Construct signature return types '{0}' and '{1}' are incompatible.", void 0, true),
        Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1: diag(2204, ts2.DiagnosticCategory.Error, "Call_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2204", "Call signatures with no arguments have incompatible return types '{0}' and '{1}'.", void 0, true),
        Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1: diag(2205, ts2.DiagnosticCategory.Error, "Construct_signatures_with_no_arguments_have_incompatible_return_types_0_and_1_2205", "Construct signatures with no arguments have incompatible return types '{0}' and '{1}'.", void 0, true),
        The_type_modifier_cannot_be_used_on_a_named_import_when_import_type_is_used_on_its_import_statement: diag(2206, ts2.DiagnosticCategory.Error, "The_type_modifier_cannot_be_used_on_a_named_import_when_import_type_is_used_on_its_import_statement_2206", "The 'type' modifier cannot be used on a named import when 'import type' is used on its import statement."),
        The_type_modifier_cannot_be_used_on_a_named_export_when_export_type_is_used_on_its_export_statement: diag(2207, ts2.DiagnosticCategory.Error, "The_type_modifier_cannot_be_used_on_a_named_export_when_export_type_is_used_on_its_export_statement_2207", "The 'type' modifier cannot be used on a named export when 'export type' is used on its export statement."),
        This_type_parameter_might_need_an_extends_0_constraint: diag(2208, ts2.DiagnosticCategory.Error, "This_type_parameter_might_need_an_extends_0_constraint_2208", "This type parameter might need an `extends {0}` constraint."),
        The_project_root_is_ambiguous_but_is_required_to_resolve_export_map_entry_0_in_file_1_Supply_the_rootDir_compiler_option_to_disambiguate: diag(2209, ts2.DiagnosticCategory.Error, "The_project_root_is_ambiguous_but_is_required_to_resolve_export_map_entry_0_in_file_1_Supply_the_roo_2209", "The project root is ambiguous, but is required to resolve export map entry '{0}' in file '{1}'. Supply the `rootDir` compiler option to disambiguate."),
        The_project_root_is_ambiguous_but_is_required_to_resolve_import_map_entry_0_in_file_1_Supply_the_rootDir_compiler_option_to_disambiguate: diag(2210, ts2.DiagnosticCategory.Error, "The_project_root_is_ambiguous_but_is_required_to_resolve_import_map_entry_0_in_file_1_Supply_the_roo_2210", "The project root is ambiguous, but is required to resolve import map entry '{0}' in file '{1}'. Supply the `rootDir` compiler option to disambiguate."),
        Add_extends_constraint: diag(2211, ts2.DiagnosticCategory.Message, "Add_extends_constraint_2211", "Add `extends` constraint."),
        Add_extends_constraint_to_all_type_parameters: diag(2212, ts2.DiagnosticCategory.Message, "Add_extends_constraint_to_all_type_parameters_2212", "Add `extends` constraint to all type parameters"),
        Duplicate_identifier_0: diag(2300, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_2300", "Duplicate identifier '{0}'."),
        Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor: diag(2301, ts2.DiagnosticCategory.Error, "Initializer_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor_2301", "Initializer of instance member variable '{0}' cannot reference identifier '{1}' declared in the constructor."),
        Static_members_cannot_reference_class_type_parameters: diag(2302, ts2.DiagnosticCategory.Error, "Static_members_cannot_reference_class_type_parameters_2302", "Static members cannot reference class type parameters."),
        Circular_definition_of_import_alias_0: diag(2303, ts2.DiagnosticCategory.Error, "Circular_definition_of_import_alias_0_2303", "Circular definition of import alias '{0}'."),
        Cannot_find_name_0: diag(2304, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_2304", "Cannot find name '{0}'."),
        Module_0_has_no_exported_member_1: diag(2305, ts2.DiagnosticCategory.Error, "Module_0_has_no_exported_member_1_2305", "Module '{0}' has no exported member '{1}'."),
        File_0_is_not_a_module: diag(2306, ts2.DiagnosticCategory.Error, "File_0_is_not_a_module_2306", "File '{0}' is not a module."),
        Cannot_find_module_0_or_its_corresponding_type_declarations: diag(2307, ts2.DiagnosticCategory.Error, "Cannot_find_module_0_or_its_corresponding_type_declarations_2307", "Cannot find module '{0}' or its corresponding type declarations."),
        Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambiguity: diag(2308, ts2.DiagnosticCategory.Error, "Module_0_has_already_exported_a_member_named_1_Consider_explicitly_re_exporting_to_resolve_the_ambig_2308", "Module {0} has already exported a member named '{1}'. Consider explicitly re-exporting to resolve the ambiguity."),
        An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements: diag(2309, ts2.DiagnosticCategory.Error, "An_export_assignment_cannot_be_used_in_a_module_with_other_exported_elements_2309", "An export assignment cannot be used in a module with other exported elements."),
        Type_0_recursively_references_itself_as_a_base_type: diag(2310, ts2.DiagnosticCategory.Error, "Type_0_recursively_references_itself_as_a_base_type_2310", "Type '{0}' recursively references itself as a base type."),
        Cannot_find_name_0_Did_you_mean_to_write_this_in_an_async_function: diag(2311, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_to_write_this_in_an_async_function_2311", "Cannot find name '{0}'. Did you mean to write this in an async function?"),
        An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2312, ts2.DiagnosticCategory.Error, "An_interface_can_only_extend_an_object_type_or_intersection_of_object_types_with_statically_known_me_2312", "An interface can only extend an object type or intersection of object types with statically known members."),
        Type_parameter_0_has_a_circular_constraint: diag(2313, ts2.DiagnosticCategory.Error, "Type_parameter_0_has_a_circular_constraint_2313", "Type parameter '{0}' has a circular constraint."),
        Generic_type_0_requires_1_type_argument_s: diag(2314, ts2.DiagnosticCategory.Error, "Generic_type_0_requires_1_type_argument_s_2314", "Generic type '{0}' requires {1} type argument(s)."),
        Type_0_is_not_generic: diag(2315, ts2.DiagnosticCategory.Error, "Type_0_is_not_generic_2315", "Type '{0}' is not generic."),
        Global_type_0_must_be_a_class_or_interface_type: diag(2316, ts2.DiagnosticCategory.Error, "Global_type_0_must_be_a_class_or_interface_type_2316", "Global type '{0}' must be a class or interface type."),
        Global_type_0_must_have_1_type_parameter_s: diag(2317, ts2.DiagnosticCategory.Error, "Global_type_0_must_have_1_type_parameter_s_2317", "Global type '{0}' must have {1} type parameter(s)."),
        Cannot_find_global_type_0: diag(2318, ts2.DiagnosticCategory.Error, "Cannot_find_global_type_0_2318", "Cannot find global type '{0}'."),
        Named_property_0_of_types_1_and_2_are_not_identical: diag(2319, ts2.DiagnosticCategory.Error, "Named_property_0_of_types_1_and_2_are_not_identical_2319", "Named property '{0}' of types '{1}' and '{2}' are not identical."),
        Interface_0_cannot_simultaneously_extend_types_1_and_2: diag(2320, ts2.DiagnosticCategory.Error, "Interface_0_cannot_simultaneously_extend_types_1_and_2_2320", "Interface '{0}' cannot simultaneously extend types '{1}' and '{2}'."),
        Excessive_stack_depth_comparing_types_0_and_1: diag(2321, ts2.DiagnosticCategory.Error, "Excessive_stack_depth_comparing_types_0_and_1_2321", "Excessive stack depth comparing types '{0}' and '{1}'."),
        Type_0_is_not_assignable_to_type_1: diag(2322, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_2322", "Type '{0}' is not assignable to type '{1}'."),
        Cannot_redeclare_exported_variable_0: diag(2323, ts2.DiagnosticCategory.Error, "Cannot_redeclare_exported_variable_0_2323", "Cannot redeclare exported variable '{0}'."),
        Property_0_is_missing_in_type_1: diag(2324, ts2.DiagnosticCategory.Error, "Property_0_is_missing_in_type_1_2324", "Property '{0}' is missing in type '{1}'."),
        Property_0_is_private_in_type_1_but_not_in_type_2: diag(2325, ts2.DiagnosticCategory.Error, "Property_0_is_private_in_type_1_but_not_in_type_2_2325", "Property '{0}' is private in type '{1}' but not in type '{2}'."),
        Types_of_property_0_are_incompatible: diag(2326, ts2.DiagnosticCategory.Error, "Types_of_property_0_are_incompatible_2326", "Types of property '{0}' are incompatible."),
        Property_0_is_optional_in_type_1_but_required_in_type_2: diag(2327, ts2.DiagnosticCategory.Error, "Property_0_is_optional_in_type_1_but_required_in_type_2_2327", "Property '{0}' is optional in type '{1}' but required in type '{2}'."),
        Types_of_parameters_0_and_1_are_incompatible: diag(2328, ts2.DiagnosticCategory.Error, "Types_of_parameters_0_and_1_are_incompatible_2328", "Types of parameters '{0}' and '{1}' are incompatible."),
        Index_signature_for_type_0_is_missing_in_type_1: diag(2329, ts2.DiagnosticCategory.Error, "Index_signature_for_type_0_is_missing_in_type_1_2329", "Index signature for type '{0}' is missing in type '{1}'."),
        _0_and_1_index_signatures_are_incompatible: diag(2330, ts2.DiagnosticCategory.Error, "_0_and_1_index_signatures_are_incompatible_2330", "'{0}' and '{1}' index signatures are incompatible."),
        this_cannot_be_referenced_in_a_module_or_namespace_body: diag(2331, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_module_or_namespace_body_2331", "'this' cannot be referenced in a module or namespace body."),
        this_cannot_be_referenced_in_current_location: diag(2332, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_current_location_2332", "'this' cannot be referenced in current location."),
        this_cannot_be_referenced_in_constructor_arguments: diag(2333, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_constructor_arguments_2333", "'this' cannot be referenced in constructor arguments."),
        this_cannot_be_referenced_in_a_static_property_initializer: diag(2334, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_static_property_initializer_2334", "'this' cannot be referenced in a static property initializer."),
        super_can_only_be_referenced_in_a_derived_class: diag(2335, ts2.DiagnosticCategory.Error, "super_can_only_be_referenced_in_a_derived_class_2335", "'super' can only be referenced in a derived class."),
        super_cannot_be_referenced_in_constructor_arguments: diag(2336, ts2.DiagnosticCategory.Error, "super_cannot_be_referenced_in_constructor_arguments_2336", "'super' cannot be referenced in constructor arguments."),
        Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors: diag(2337, ts2.DiagnosticCategory.Error, "Super_calls_are_not_permitted_outside_constructors_or_in_nested_functions_inside_constructors_2337", "Super calls are not permitted outside constructors or in nested functions inside constructors."),
        super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_derived_class: diag(2338, ts2.DiagnosticCategory.Error, "super_property_access_is_permitted_only_in_a_constructor_member_function_or_member_accessor_of_a_der_2338", "'super' property access is permitted only in a constructor, member function, or member accessor of a derived class."),
        Property_0_does_not_exist_on_type_1: diag(2339, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_2339", "Property '{0}' does not exist on type '{1}'."),
        Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword: diag(2340, ts2.DiagnosticCategory.Error, "Only_public_and_protected_methods_of_the_base_class_are_accessible_via_the_super_keyword_2340", "Only public and protected methods of the base class are accessible via the 'super' keyword."),
        Property_0_is_private_and_only_accessible_within_class_1: diag(2341, ts2.DiagnosticCategory.Error, "Property_0_is_private_and_only_accessible_within_class_1_2341", "Property '{0}' is private and only accessible within class '{1}'."),
        This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_version_of_0: diag(2343, ts2.DiagnosticCategory.Error, "This_syntax_requires_an_imported_helper_named_1_which_does_not_exist_in_0_Consider_upgrading_your_ve_2343", "This syntax requires an imported helper named '{1}' which does not exist in '{0}'. Consider upgrading your version of '{0}'."),
        Type_0_does_not_satisfy_the_constraint_1: diag(2344, ts2.DiagnosticCategory.Error, "Type_0_does_not_satisfy_the_constraint_1_2344", "Type '{0}' does not satisfy the constraint '{1}'."),
        Argument_of_type_0_is_not_assignable_to_parameter_of_type_1: diag(2345, ts2.DiagnosticCategory.Error, "Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_2345", "Argument of type '{0}' is not assignable to parameter of type '{1}'."),
        Call_target_does_not_contain_any_signatures: diag(2346, ts2.DiagnosticCategory.Error, "Call_target_does_not_contain_any_signatures_2346", "Call target does not contain any signatures."),
        Untyped_function_calls_may_not_accept_type_arguments: diag(2347, ts2.DiagnosticCategory.Error, "Untyped_function_calls_may_not_accept_type_arguments_2347", "Untyped function calls may not accept type arguments."),
        Value_of_type_0_is_not_callable_Did_you_mean_to_include_new: diag(2348, ts2.DiagnosticCategory.Error, "Value_of_type_0_is_not_callable_Did_you_mean_to_include_new_2348", "Value of type '{0}' is not callable. Did you mean to include 'new'?"),
        This_expression_is_not_callable: diag(2349, ts2.DiagnosticCategory.Error, "This_expression_is_not_callable_2349", "This expression is not callable."),
        Only_a_void_function_can_be_called_with_the_new_keyword: diag(2350, ts2.DiagnosticCategory.Error, "Only_a_void_function_can_be_called_with_the_new_keyword_2350", "Only a void function can be called with the 'new' keyword."),
        This_expression_is_not_constructable: diag(2351, ts2.DiagnosticCategory.Error, "This_expression_is_not_constructable_2351", "This expression is not constructable."),
        Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the_other_If_this_was_intentional_convert_the_expression_to_unknown_first: diag(2352, ts2.DiagnosticCategory.Error, "Conversion_of_type_0_to_type_1_may_be_a_mistake_because_neither_type_sufficiently_overlaps_with_the__2352", "Conversion of type '{0}' to type '{1}' may be a mistake because neither type sufficiently overlaps with the other. If this was intentional, convert the expression to 'unknown' first."),
        Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1: diag(2353, ts2.DiagnosticCategory.Error, "Object_literal_may_only_specify_known_properties_and_0_does_not_exist_in_type_1_2353", "Object literal may only specify known properties, and '{0}' does not exist in type '{1}'."),
        This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found: diag(2354, ts2.DiagnosticCategory.Error, "This_syntax_requires_an_imported_helper_but_module_0_cannot_be_found_2354", "This syntax requires an imported helper but module '{0}' cannot be found."),
        A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value: diag(2355, ts2.DiagnosticCategory.Error, "A_function_whose_declared_type_is_neither_void_nor_any_must_return_a_value_2355", "A function whose declared type is neither 'void' nor 'any' must return a value."),
        An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2356, ts2.DiagnosticCategory.Error, "An_arithmetic_operand_must_be_of_type_any_number_bigint_or_an_enum_type_2356", "An arithmetic operand must be of type 'any', 'number', 'bigint' or an enum type."),
        The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access: diag(2357, ts2.DiagnosticCategory.Error, "The_operand_of_an_increment_or_decrement_operator_must_be_a_variable_or_a_property_access_2357", "The operand of an increment or decrement operator must be a variable or a property access."),
        The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_parameter: diag(2358, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_instanceof_expression_must_be_of_type_any_an_object_type_or_a_type_paramete_2358", "The left-hand side of an 'instanceof' expression must be of type 'any', an object type or a type parameter."),
        The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_Function_interface_type: diag(2359, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_an_instanceof_expression_must_be_of_type_any_or_of_a_type_assignable_to_the_F_2359", "The right-hand side of an 'instanceof' expression must be of type 'any' or of a type assignable to the 'Function' interface type."),
        The_left_hand_side_of_an_in_expression_must_be_a_private_identifier_or_of_type_any_string_number_or_symbol: diag(2360, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_in_expression_must_be_a_private_identifier_or_of_type_any_string_number_or__2360", "The left-hand side of an 'in' expression must be a private identifier or of type 'any', 'string', 'number', or 'symbol'."),
        The_right_hand_side_of_an_in_expression_must_not_be_a_primitive: diag(2361, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_an_in_expression_must_not_be_a_primitive_2361", "The right-hand side of an 'in' expression must not be a primitive."),
        The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2362, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2362", "The left-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),
        The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type: diag(2363, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_an_arithmetic_operation_must_be_of_type_any_number_bigint_or_an_enum_type_2363", "The right-hand side of an arithmetic operation must be of type 'any', 'number', 'bigint' or an enum type."),
        The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access: diag(2364, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_assignment_expression_must_be_a_variable_or_a_property_access_2364", "The left-hand side of an assignment expression must be a variable or a property access."),
        Operator_0_cannot_be_applied_to_types_1_and_2: diag(2365, ts2.DiagnosticCategory.Error, "Operator_0_cannot_be_applied_to_types_1_and_2_2365", "Operator '{0}' cannot be applied to types '{1}' and '{2}'."),
        Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined: diag(2366, ts2.DiagnosticCategory.Error, "Function_lacks_ending_return_statement_and_return_type_does_not_include_undefined_2366", "Function lacks ending return statement and return type does not include 'undefined'."),
        This_condition_will_always_return_0_since_the_types_1_and_2_have_no_overlap: diag(2367, ts2.DiagnosticCategory.Error, "This_condition_will_always_return_0_since_the_types_1_and_2_have_no_overlap_2367", "This condition will always return '{0}' since the types '{1}' and '{2}' have no overlap."),
        Type_parameter_name_cannot_be_0: diag(2368, ts2.DiagnosticCategory.Error, "Type_parameter_name_cannot_be_0_2368", "Type parameter name cannot be '{0}'."),
        A_parameter_property_is_only_allowed_in_a_constructor_implementation: diag(2369, ts2.DiagnosticCategory.Error, "A_parameter_property_is_only_allowed_in_a_constructor_implementation_2369", "A parameter property is only allowed in a constructor implementation."),
        A_rest_parameter_must_be_of_an_array_type: diag(2370, ts2.DiagnosticCategory.Error, "A_rest_parameter_must_be_of_an_array_type_2370", "A rest parameter must be of an array type."),
        A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation: diag(2371, ts2.DiagnosticCategory.Error, "A_parameter_initializer_is_only_allowed_in_a_function_or_constructor_implementation_2371", "A parameter initializer is only allowed in a function or constructor implementation."),
        Parameter_0_cannot_reference_itself: diag(2372, ts2.DiagnosticCategory.Error, "Parameter_0_cannot_reference_itself_2372", "Parameter '{0}' cannot reference itself."),
        Parameter_0_cannot_reference_identifier_1_declared_after_it: diag(2373, ts2.DiagnosticCategory.Error, "Parameter_0_cannot_reference_identifier_1_declared_after_it_2373", "Parameter '{0}' cannot reference identifier '{1}' declared after it."),
        Duplicate_index_signature_for_type_0: diag(2374, ts2.DiagnosticCategory.Error, "Duplicate_index_signature_for_type_0_2374", "Duplicate index signature for type '{0}'."),
        Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefined_to_the_types_of_the_target_s_properties: diag(2375, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefi_2375", "Type '{0}' is not assignable to type '{1}' with 'exactOptionalPropertyTypes: true'. Consider adding 'undefined' to the types of the target's properties."),
        A_super_call_must_be_the_first_statement_in_the_constructor_to_refer_to_super_or_this_when_a_derived_class_contains_initialized_properties_parameter_properties_or_private_identifiers: diag(2376, ts2.DiagnosticCategory.Error, "A_super_call_must_be_the_first_statement_in_the_constructor_to_refer_to_super_or_this_when_a_derived_2376", "A 'super' call must be the first statement in the constructor to refer to 'super' or 'this' when a derived class contains initialized properties, parameter properties, or private identifiers."),
        Constructors_for_derived_classes_must_contain_a_super_call: diag(2377, ts2.DiagnosticCategory.Error, "Constructors_for_derived_classes_must_contain_a_super_call_2377", "Constructors for derived classes must contain a 'super' call."),
        A_get_accessor_must_return_a_value: diag(2378, ts2.DiagnosticCategory.Error, "A_get_accessor_must_return_a_value_2378", "A 'get' accessor must return a value."),
        Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefined_to_the_types_of_the_target_s_properties: diag(2379, ts2.DiagnosticCategory.Error, "Argument_of_type_0_is_not_assignable_to_parameter_of_type_1_with_exactOptionalPropertyTypes_Colon_tr_2379", "Argument of type '{0}' is not assignable to parameter of type '{1}' with 'exactOptionalPropertyTypes: true'. Consider adding 'undefined' to the types of the target's properties."),
        The_return_type_of_a_get_accessor_must_be_assignable_to_its_set_accessor_type: diag(2380, ts2.DiagnosticCategory.Error, "The_return_type_of_a_get_accessor_must_be_assignable_to_its_set_accessor_type_2380", "The return type of a 'get' accessor must be assignable to its 'set' accessor type"),
        Overload_signatures_must_all_be_exported_or_non_exported: diag(2383, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_exported_or_non_exported_2383", "Overload signatures must all be exported or non-exported."),
        Overload_signatures_must_all_be_ambient_or_non_ambient: diag(2384, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_ambient_or_non_ambient_2384", "Overload signatures must all be ambient or non-ambient."),
        Overload_signatures_must_all_be_public_private_or_protected: diag(2385, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_public_private_or_protected_2385", "Overload signatures must all be public, private or protected."),
        Overload_signatures_must_all_be_optional_or_required: diag(2386, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_optional_or_required_2386", "Overload signatures must all be optional or required."),
        Function_overload_must_be_static: diag(2387, ts2.DiagnosticCategory.Error, "Function_overload_must_be_static_2387", "Function overload must be static."),
        Function_overload_must_not_be_static: diag(2388, ts2.DiagnosticCategory.Error, "Function_overload_must_not_be_static_2388", "Function overload must not be static."),
        Function_implementation_name_must_be_0: diag(2389, ts2.DiagnosticCategory.Error, "Function_implementation_name_must_be_0_2389", "Function implementation name must be '{0}'."),
        Constructor_implementation_is_missing: diag(2390, ts2.DiagnosticCategory.Error, "Constructor_implementation_is_missing_2390", "Constructor implementation is missing."),
        Function_implementation_is_missing_or_not_immediately_following_the_declaration: diag(2391, ts2.DiagnosticCategory.Error, "Function_implementation_is_missing_or_not_immediately_following_the_declaration_2391", "Function implementation is missing or not immediately following the declaration."),
        Multiple_constructor_implementations_are_not_allowed: diag(2392, ts2.DiagnosticCategory.Error, "Multiple_constructor_implementations_are_not_allowed_2392", "Multiple constructor implementations are not allowed."),
        Duplicate_function_implementation: diag(2393, ts2.DiagnosticCategory.Error, "Duplicate_function_implementation_2393", "Duplicate function implementation."),
        This_overload_signature_is_not_compatible_with_its_implementation_signature: diag(2394, ts2.DiagnosticCategory.Error, "This_overload_signature_is_not_compatible_with_its_implementation_signature_2394", "This overload signature is not compatible with its implementation signature."),
        Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local: diag(2395, ts2.DiagnosticCategory.Error, "Individual_declarations_in_merged_declaration_0_must_be_all_exported_or_all_local_2395", "Individual declarations in merged declaration '{0}' must be all exported or all local."),
        Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters: diag(2396, ts2.DiagnosticCategory.Error, "Duplicate_identifier_arguments_Compiler_uses_arguments_to_initialize_rest_parameters_2396", "Duplicate identifier 'arguments'. Compiler uses 'arguments' to initialize rest parameters."),
        Declaration_name_conflicts_with_built_in_global_identifier_0: diag(2397, ts2.DiagnosticCategory.Error, "Declaration_name_conflicts_with_built_in_global_identifier_0_2397", "Declaration name conflicts with built-in global identifier '{0}'."),
        constructor_cannot_be_used_as_a_parameter_property_name: diag(2398, ts2.DiagnosticCategory.Error, "constructor_cannot_be_used_as_a_parameter_property_name_2398", "'constructor' cannot be used as a parameter property name."),
        Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference: diag(2399, ts2.DiagnosticCategory.Error, "Duplicate_identifier_this_Compiler_uses_variable_declaration_this_to_capture_this_reference_2399", "Duplicate identifier '_this'. Compiler uses variable declaration '_this' to capture 'this' reference."),
        Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference: diag(2400, ts2.DiagnosticCategory.Error, "Expression_resolves_to_variable_declaration_this_that_compiler_uses_to_capture_this_reference_2400", "Expression resolves to variable declaration '_this' that compiler uses to capture 'this' reference."),
        A_super_call_must_be_a_root_level_statement_within_a_constructor_of_a_derived_class_that_contains_initialized_properties_parameter_properties_or_private_identifiers: diag(2401, ts2.DiagnosticCategory.Error, "A_super_call_must_be_a_root_level_statement_within_a_constructor_of_a_derived_class_that_contains_in_2401", "A 'super' call must be a root-level statement within a constructor of a derived class that contains initialized properties, parameter properties, or private identifiers."),
        Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference: diag(2402, ts2.DiagnosticCategory.Error, "Expression_resolves_to_super_that_compiler_uses_to_capture_base_class_reference_2402", "Expression resolves to '_super' that compiler uses to capture base class reference."),
        Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_type_2: diag(2403, ts2.DiagnosticCategory.Error, "Subsequent_variable_declarations_must_have_the_same_type_Variable_0_must_be_of_type_1_but_here_has_t_2403", "Subsequent variable declarations must have the same type.  Variable '{0}' must be of type '{1}', but here has type '{2}'."),
        The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation: diag(2404, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_cannot_use_a_type_annotation_2404", "The left-hand side of a 'for...in' statement cannot use a type annotation."),
        The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any: diag(2405, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_must_be_of_type_string_or_any_2405", "The left-hand side of a 'for...in' statement must be of type 'string' or 'any'."),
        The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access: diag(2406, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_must_be_a_variable_or_a_property_access_2406", "The left-hand side of a 'for...in' statement must be a variable or a property access."),
        The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_here_has_type_0: diag(2407, ts2.DiagnosticCategory.Error, "The_right_hand_side_of_a_for_in_statement_must_be_of_type_any_an_object_type_or_a_type_parameter_but_2407", "The right-hand side of a 'for...in' statement must be of type 'any', an object type or a type parameter, but here has type '{0}'."),
        Setters_cannot_return_a_value: diag(2408, ts2.DiagnosticCategory.Error, "Setters_cannot_return_a_value_2408", "Setters cannot return a value."),
        Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class: diag(2409, ts2.DiagnosticCategory.Error, "Return_type_of_constructor_signature_must_be_assignable_to_the_instance_type_of_the_class_2409", "Return type of constructor signature must be assignable to the instance type of the class."),
        The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any: diag(2410, ts2.DiagnosticCategory.Error, "The_with_statement_is_not_supported_All_symbols_in_a_with_block_will_have_type_any_2410", "The 'with' statement is not supported. All symbols in a 'with' block will have type 'any'."),
        Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefined_to_the_type_of_the_target: diag(2412, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_with_exactOptionalPropertyTypes_Colon_true_Consider_adding_undefi_2412", "Type '{0}' is not assignable to type '{1}' with 'exactOptionalPropertyTypes: true'. Consider adding 'undefined' to the type of the target."),
        Property_0_of_type_1_is_not_assignable_to_2_index_type_3: diag(2411, ts2.DiagnosticCategory.Error, "Property_0_of_type_1_is_not_assignable_to_2_index_type_3_2411", "Property '{0}' of type '{1}' is not assignable to '{2}' index type '{3}'."),
        _0_index_type_1_is_not_assignable_to_2_index_type_3: diag(2413, ts2.DiagnosticCategory.Error, "_0_index_type_1_is_not_assignable_to_2_index_type_3_2413", "'{0}' index type '{1}' is not assignable to '{2}' index type '{3}'."),
        Class_name_cannot_be_0: diag(2414, ts2.DiagnosticCategory.Error, "Class_name_cannot_be_0_2414", "Class name cannot be '{0}'."),
        Class_0_incorrectly_extends_base_class_1: diag(2415, ts2.DiagnosticCategory.Error, "Class_0_incorrectly_extends_base_class_1_2415", "Class '{0}' incorrectly extends base class '{1}'."),
        Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2: diag(2416, ts2.DiagnosticCategory.Error, "Property_0_in_type_1_is_not_assignable_to_the_same_property_in_base_type_2_2416", "Property '{0}' in type '{1}' is not assignable to the same property in base type '{2}'."),
        Class_static_side_0_incorrectly_extends_base_class_static_side_1: diag(2417, ts2.DiagnosticCategory.Error, "Class_static_side_0_incorrectly_extends_base_class_static_side_1_2417", "Class static side '{0}' incorrectly extends base class static side '{1}'."),
        Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1: diag(2418, ts2.DiagnosticCategory.Error, "Type_of_computed_property_s_value_is_0_which_is_not_assignable_to_type_1_2418", "Type of computed property's value is '{0}', which is not assignable to type '{1}'."),
        Types_of_construct_signatures_are_incompatible: diag(2419, ts2.DiagnosticCategory.Error, "Types_of_construct_signatures_are_incompatible_2419", "Types of construct signatures are incompatible."),
        Class_0_incorrectly_implements_interface_1: diag(2420, ts2.DiagnosticCategory.Error, "Class_0_incorrectly_implements_interface_1_2420", "Class '{0}' incorrectly implements interface '{1}'."),
        A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2422, ts2.DiagnosticCategory.Error, "A_class_can_only_implement_an_object_type_or_intersection_of_object_types_with_statically_known_memb_2422", "A class can only implement an object type or intersection of object types with statically known members."),
        Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_accessor: diag(2423, ts2.DiagnosticCategory.Error, "Class_0_defines_instance_member_function_1_but_extended_class_2_defines_it_as_instance_member_access_2423", "Class '{0}' defines instance member function '{1}', but extended class '{2}' defines it as instance member accessor."),
        Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_function: diag(2425, ts2.DiagnosticCategory.Error, "Class_0_defines_instance_member_property_1_but_extended_class_2_defines_it_as_instance_member_functi_2425", "Class '{0}' defines instance member property '{1}', but extended class '{2}' defines it as instance member function."),
        Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_function: diag(2426, ts2.DiagnosticCategory.Error, "Class_0_defines_instance_member_accessor_1_but_extended_class_2_defines_it_as_instance_member_functi_2426", "Class '{0}' defines instance member accessor '{1}', but extended class '{2}' defines it as instance member function."),
        Interface_name_cannot_be_0: diag(2427, ts2.DiagnosticCategory.Error, "Interface_name_cannot_be_0_2427", "Interface name cannot be '{0}'."),
        All_declarations_of_0_must_have_identical_type_parameters: diag(2428, ts2.DiagnosticCategory.Error, "All_declarations_of_0_must_have_identical_type_parameters_2428", "All declarations of '{0}' must have identical type parameters."),
        Interface_0_incorrectly_extends_interface_1: diag(2430, ts2.DiagnosticCategory.Error, "Interface_0_incorrectly_extends_interface_1_2430", "Interface '{0}' incorrectly extends interface '{1}'."),
        Enum_name_cannot_be_0: diag(2431, ts2.DiagnosticCategory.Error, "Enum_name_cannot_be_0_2431", "Enum name cannot be '{0}'."),
        In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enum_element: diag(2432, ts2.DiagnosticCategory.Error, "In_an_enum_with_multiple_declarations_only_one_declaration_can_omit_an_initializer_for_its_first_enu_2432", "In an enum with multiple declarations, only one declaration can omit an initializer for its first enum element."),
        A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merged: diag(2433, ts2.DiagnosticCategory.Error, "A_namespace_declaration_cannot_be_in_a_different_file_from_a_class_or_function_with_which_it_is_merg_2433", "A namespace declaration cannot be in a different file from a class or function with which it is merged."),
        A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged: diag(2434, ts2.DiagnosticCategory.Error, "A_namespace_declaration_cannot_be_located_prior_to_a_class_or_function_with_which_it_is_merged_2434", "A namespace declaration cannot be located prior to a class or function with which it is merged."),
        Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces: diag(2435, ts2.DiagnosticCategory.Error, "Ambient_modules_cannot_be_nested_in_other_modules_or_namespaces_2435", "Ambient modules cannot be nested in other modules or namespaces."),
        Ambient_module_declaration_cannot_specify_relative_module_name: diag(2436, ts2.DiagnosticCategory.Error, "Ambient_module_declaration_cannot_specify_relative_module_name_2436", "Ambient module declaration cannot specify relative module name."),
        Module_0_is_hidden_by_a_local_declaration_with_the_same_name: diag(2437, ts2.DiagnosticCategory.Error, "Module_0_is_hidden_by_a_local_declaration_with_the_same_name_2437", "Module '{0}' is hidden by a local declaration with the same name."),
        Import_name_cannot_be_0: diag(2438, ts2.DiagnosticCategory.Error, "Import_name_cannot_be_0_2438", "Import name cannot be '{0}'."),
        Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relative_module_name: diag(2439, ts2.DiagnosticCategory.Error, "Import_or_export_declaration_in_an_ambient_module_declaration_cannot_reference_module_through_relati_2439", "Import or export declaration in an ambient module declaration cannot reference module through relative module name."),
        Import_declaration_conflicts_with_local_declaration_of_0: diag(2440, ts2.DiagnosticCategory.Error, "Import_declaration_conflicts_with_local_declaration_of_0_2440", "Import declaration conflicts with local declaration of '{0}'."),
        Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module: diag(2441, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_2441", "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module."),
        Types_have_separate_declarations_of_a_private_property_0: diag(2442, ts2.DiagnosticCategory.Error, "Types_have_separate_declarations_of_a_private_property_0_2442", "Types have separate declarations of a private property '{0}'."),
        Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2: diag(2443, ts2.DiagnosticCategory.Error, "Property_0_is_protected_but_type_1_is_not_a_class_derived_from_2_2443", "Property '{0}' is protected but type '{1}' is not a class derived from '{2}'."),
        Property_0_is_protected_in_type_1_but_public_in_type_2: diag(2444, ts2.DiagnosticCategory.Error, "Property_0_is_protected_in_type_1_but_public_in_type_2_2444", "Property '{0}' is protected in type '{1}' but public in type '{2}'."),
        Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses: diag(2445, ts2.DiagnosticCategory.Error, "Property_0_is_protected_and_only_accessible_within_class_1_and_its_subclasses_2445", "Property '{0}' is protected and only accessible within class '{1}' and its subclasses."),
        Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1_This_is_an_instance_of_class_2: diag(2446, ts2.DiagnosticCategory.Error, "Property_0_is_protected_and_only_accessible_through_an_instance_of_class_1_This_is_an_instance_of_cl_2446", "Property '{0}' is protected and only accessible through an instance of class '{1}'. This is an instance of class '{2}'."),
        The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead: diag(2447, ts2.DiagnosticCategory.Error, "The_0_operator_is_not_allowed_for_boolean_types_Consider_using_1_instead_2447", "The '{0}' operator is not allowed for boolean types. Consider using '{1}' instead."),
        Block_scoped_variable_0_used_before_its_declaration: diag(2448, ts2.DiagnosticCategory.Error, "Block_scoped_variable_0_used_before_its_declaration_2448", "Block-scoped variable '{0}' used before its declaration."),
        Class_0_used_before_its_declaration: diag(2449, ts2.DiagnosticCategory.Error, "Class_0_used_before_its_declaration_2449", "Class '{0}' used before its declaration."),
        Enum_0_used_before_its_declaration: diag(2450, ts2.DiagnosticCategory.Error, "Enum_0_used_before_its_declaration_2450", "Enum '{0}' used before its declaration."),
        Cannot_redeclare_block_scoped_variable_0: diag(2451, ts2.DiagnosticCategory.Error, "Cannot_redeclare_block_scoped_variable_0_2451", "Cannot redeclare block-scoped variable '{0}'."),
        An_enum_member_cannot_have_a_numeric_name: diag(2452, ts2.DiagnosticCategory.Error, "An_enum_member_cannot_have_a_numeric_name_2452", "An enum member cannot have a numeric name."),
        Variable_0_is_used_before_being_assigned: diag(2454, ts2.DiagnosticCategory.Error, "Variable_0_is_used_before_being_assigned_2454", "Variable '{0}' is used before being assigned."),
        Type_alias_0_circularly_references_itself: diag(2456, ts2.DiagnosticCategory.Error, "Type_alias_0_circularly_references_itself_2456", "Type alias '{0}' circularly references itself."),
        Type_alias_name_cannot_be_0: diag(2457, ts2.DiagnosticCategory.Error, "Type_alias_name_cannot_be_0_2457", "Type alias name cannot be '{0}'."),
        An_AMD_module_cannot_have_multiple_name_assignments: diag(2458, ts2.DiagnosticCategory.Error, "An_AMD_module_cannot_have_multiple_name_assignments_2458", "An AMD module cannot have multiple name assignments."),
        Module_0_declares_1_locally_but_it_is_not_exported: diag(2459, ts2.DiagnosticCategory.Error, "Module_0_declares_1_locally_but_it_is_not_exported_2459", "Module '{0}' declares '{1}' locally, but it is not exported."),
        Module_0_declares_1_locally_but_it_is_exported_as_2: diag(2460, ts2.DiagnosticCategory.Error, "Module_0_declares_1_locally_but_it_is_exported_as_2_2460", "Module '{0}' declares '{1}' locally, but it is exported as '{2}'."),
        Type_0_is_not_an_array_type: diag(2461, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_2461", "Type '{0}' is not an array type."),
        A_rest_element_must_be_last_in_a_destructuring_pattern: diag(2462, ts2.DiagnosticCategory.Error, "A_rest_element_must_be_last_in_a_destructuring_pattern_2462", "A rest element must be last in a destructuring pattern."),
        A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature: diag(2463, ts2.DiagnosticCategory.Error, "A_binding_pattern_parameter_cannot_be_optional_in_an_implementation_signature_2463", "A binding pattern parameter cannot be optional in an implementation signature."),
        A_computed_property_name_must_be_of_type_string_number_symbol_or_any: diag(2464, ts2.DiagnosticCategory.Error, "A_computed_property_name_must_be_of_type_string_number_symbol_or_any_2464", "A computed property name must be of type 'string', 'number', 'symbol', or 'any'."),
        this_cannot_be_referenced_in_a_computed_property_name: diag(2465, ts2.DiagnosticCategory.Error, "this_cannot_be_referenced_in_a_computed_property_name_2465", "'this' cannot be referenced in a computed property name."),
        super_cannot_be_referenced_in_a_computed_property_name: diag(2466, ts2.DiagnosticCategory.Error, "super_cannot_be_referenced_in_a_computed_property_name_2466", "'super' cannot be referenced in a computed property name."),
        A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type: diag(2467, ts2.DiagnosticCategory.Error, "A_computed_property_name_cannot_reference_a_type_parameter_from_its_containing_type_2467", "A computed property name cannot reference a type parameter from its containing type."),
        Cannot_find_global_value_0: diag(2468, ts2.DiagnosticCategory.Error, "Cannot_find_global_value_0_2468", "Cannot find global value '{0}'."),
        The_0_operator_cannot_be_applied_to_type_symbol: diag(2469, ts2.DiagnosticCategory.Error, "The_0_operator_cannot_be_applied_to_type_symbol_2469", "The '{0}' operator cannot be applied to type 'symbol'."),
        Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher: diag(2472, ts2.DiagnosticCategory.Error, "Spread_operator_in_new_expressions_is_only_available_when_targeting_ECMAScript_5_and_higher_2472", "Spread operator in 'new' expressions is only available when targeting ECMAScript 5 and higher."),
        Enum_declarations_must_all_be_const_or_non_const: diag(2473, ts2.DiagnosticCategory.Error, "Enum_declarations_must_all_be_const_or_non_const_2473", "Enum declarations must all be const or non-const."),
        const_enum_member_initializers_can_only_contain_literal_values_and_other_computed_enum_values: diag(2474, ts2.DiagnosticCategory.Error, "const_enum_member_initializers_can_only_contain_literal_values_and_other_computed_enum_values_2474", "const enum member initializers can only contain literal values and other computed enum values."),
        const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_import_declaration_or_export_assignment_or_type_query: diag(2475, ts2.DiagnosticCategory.Error, "const_enums_can_only_be_used_in_property_or_index_access_expressions_or_the_right_hand_side_of_an_im_2475", "'const' enums can only be used in property or index access expressions or the right hand side of an import declaration or export assignment or type query."),
        A_const_enum_member_can_only_be_accessed_using_a_string_literal: diag(2476, ts2.DiagnosticCategory.Error, "A_const_enum_member_can_only_be_accessed_using_a_string_literal_2476", "A const enum member can only be accessed using a string literal."),
        const_enum_member_initializer_was_evaluated_to_a_non_finite_value: diag(2477, ts2.DiagnosticCategory.Error, "const_enum_member_initializer_was_evaluated_to_a_non_finite_value_2477", "'const' enum member initializer was evaluated to a non-finite value."),
        const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN: diag(2478, ts2.DiagnosticCategory.Error, "const_enum_member_initializer_was_evaluated_to_disallowed_value_NaN_2478", "'const' enum member initializer was evaluated to disallowed value 'NaN'."),
        let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations: diag(2480, ts2.DiagnosticCategory.Error, "let_is_not_allowed_to_be_used_as_a_name_in_let_or_const_declarations_2480", "'let' is not allowed to be used as a name in 'let' or 'const' declarations."),
        Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1: diag(2481, ts2.DiagnosticCategory.Error, "Cannot_initialize_outer_scoped_variable_0_in_the_same_scope_as_block_scoped_declaration_1_2481", "Cannot initialize outer scoped variable '{0}' in the same scope as block scoped declaration '{1}'."),
        The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation: diag(2483, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_cannot_use_a_type_annotation_2483", "The left-hand side of a 'for...of' statement cannot use a type annotation."),
        Export_declaration_conflicts_with_exported_declaration_of_0: diag(2484, ts2.DiagnosticCategory.Error, "Export_declaration_conflicts_with_exported_declaration_of_0_2484", "Export declaration conflicts with exported declaration of '{0}'."),
        The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access: diag(2487, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_must_be_a_variable_or_a_property_access_2487", "The left-hand side of a 'for...of' statement must be a variable or a property access."),
        Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2488, ts2.DiagnosticCategory.Error, "Type_0_must_have_a_Symbol_iterator_method_that_returns_an_iterator_2488", "Type '{0}' must have a '[Symbol.iterator]()' method that returns an iterator."),
        An_iterator_must_have_a_next_method: diag(2489, ts2.DiagnosticCategory.Error, "An_iterator_must_have_a_next_method_2489", "An iterator must have a 'next()' method."),
        The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property: diag(2490, ts2.DiagnosticCategory.Error, "The_type_returned_by_the_0_method_of_an_iterator_must_have_a_value_property_2490", "The type returned by the '{0}()' method of an iterator must have a 'value' property."),
        The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern: diag(2491, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_cannot_be_a_destructuring_pattern_2491", "The left-hand side of a 'for...in' statement cannot be a destructuring pattern."),
        Cannot_redeclare_identifier_0_in_catch_clause: diag(2492, ts2.DiagnosticCategory.Error, "Cannot_redeclare_identifier_0_in_catch_clause_2492", "Cannot redeclare identifier '{0}' in catch clause."),
        Tuple_type_0_of_length_1_has_no_element_at_index_2: diag(2493, ts2.DiagnosticCategory.Error, "Tuple_type_0_of_length_1_has_no_element_at_index_2_2493", "Tuple type '{0}' of length '{1}' has no element at index '{2}'."),
        Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher: diag(2494, ts2.DiagnosticCategory.Error, "Using_a_string_in_a_for_of_statement_is_only_supported_in_ECMAScript_5_and_higher_2494", "Using a string in a 'for...of' statement is only supported in ECMAScript 5 and higher."),
        Type_0_is_not_an_array_type_or_a_string_type: diag(2495, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_2495", "Type '{0}' is not an array type or a string type."),
        The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_standard_function_expression: diag(2496, ts2.DiagnosticCategory.Error, "The_arguments_object_cannot_be_referenced_in_an_arrow_function_in_ES3_and_ES5_Consider_using_a_stand_2496", "The 'arguments' object cannot be referenced in an arrow function in ES3 and ES5. Consider using a standard function expression."),
        This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_referencing_its_default_export: diag(2497, ts2.DiagnosticCategory.Error, "This_module_can_only_be_referenced_with_ECMAScript_imports_Slashexports_by_turning_on_the_0_flag_and_2497", "This module can only be referenced with ECMAScript imports/exports by turning on the '{0}' flag and referencing its default export."),
        Module_0_uses_export_and_cannot_be_used_with_export_Asterisk: diag(2498, ts2.DiagnosticCategory.Error, "Module_0_uses_export_and_cannot_be_used_with_export_Asterisk_2498", "Module '{0}' uses 'export =' and cannot be used with 'export *'."),
        An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments: diag(2499, ts2.DiagnosticCategory.Error, "An_interface_can_only_extend_an_identifier_Slashqualified_name_with_optional_type_arguments_2499", "An interface can only extend an identifier/qualified-name with optional type arguments."),
        A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments: diag(2500, ts2.DiagnosticCategory.Error, "A_class_can_only_implement_an_identifier_Slashqualified_name_with_optional_type_arguments_2500", "A class can only implement an identifier/qualified-name with optional type arguments."),
        A_rest_element_cannot_contain_a_binding_pattern: diag(2501, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_contain_a_binding_pattern_2501", "A rest element cannot contain a binding pattern."),
        _0_is_referenced_directly_or_indirectly_in_its_own_type_annotation: diag(2502, ts2.DiagnosticCategory.Error, "_0_is_referenced_directly_or_indirectly_in_its_own_type_annotation_2502", "'{0}' is referenced directly or indirectly in its own type annotation."),
        Cannot_find_namespace_0: diag(2503, ts2.DiagnosticCategory.Error, "Cannot_find_namespace_0_2503", "Cannot find namespace '{0}'."),
        Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator: diag(2504, ts2.DiagnosticCategory.Error, "Type_0_must_have_a_Symbol_asyncIterator_method_that_returns_an_async_iterator_2504", "Type '{0}' must have a '[Symbol.asyncIterator]()' method that returns an async iterator."),
        A_generator_cannot_have_a_void_type_annotation: diag(2505, ts2.DiagnosticCategory.Error, "A_generator_cannot_have_a_void_type_annotation_2505", "A generator cannot have a 'void' type annotation."),
        _0_is_referenced_directly_or_indirectly_in_its_own_base_expression: diag(2506, ts2.DiagnosticCategory.Error, "_0_is_referenced_directly_or_indirectly_in_its_own_base_expression_2506", "'{0}' is referenced directly or indirectly in its own base expression."),
        Type_0_is_not_a_constructor_function_type: diag(2507, ts2.DiagnosticCategory.Error, "Type_0_is_not_a_constructor_function_type_2507", "Type '{0}' is not a constructor function type."),
        No_base_constructor_has_the_specified_number_of_type_arguments: diag(2508, ts2.DiagnosticCategory.Error, "No_base_constructor_has_the_specified_number_of_type_arguments_2508", "No base constructor has the specified number of type arguments."),
        Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_known_members: diag(2509, ts2.DiagnosticCategory.Error, "Base_constructor_return_type_0_is_not_an_object_type_or_intersection_of_object_types_with_statically_2509", "Base constructor return type '{0}' is not an object type or intersection of object types with statically known members."),
        Base_constructors_must_all_have_the_same_return_type: diag(2510, ts2.DiagnosticCategory.Error, "Base_constructors_must_all_have_the_same_return_type_2510", "Base constructors must all have the same return type."),
        Cannot_create_an_instance_of_an_abstract_class: diag(2511, ts2.DiagnosticCategory.Error, "Cannot_create_an_instance_of_an_abstract_class_2511", "Cannot create an instance of an abstract class."),
        Overload_signatures_must_all_be_abstract_or_non_abstract: diag(2512, ts2.DiagnosticCategory.Error, "Overload_signatures_must_all_be_abstract_or_non_abstract_2512", "Overload signatures must all be abstract or non-abstract."),
        Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression: diag(2513, ts2.DiagnosticCategory.Error, "Abstract_method_0_in_class_1_cannot_be_accessed_via_super_expression_2513", "Abstract method '{0}' in class '{1}' cannot be accessed via super expression."),
        A_tuple_type_cannot_be_indexed_with_a_negative_value: diag(2514, ts2.DiagnosticCategory.Error, "A_tuple_type_cannot_be_indexed_with_a_negative_value_2514", "A tuple type cannot be indexed with a negative value."),
        Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2: diag(2515, ts2.DiagnosticCategory.Error, "Non_abstract_class_0_does_not_implement_inherited_abstract_member_1_from_class_2_2515", "Non-abstract class '{0}' does not implement inherited abstract member '{1}' from class '{2}'."),
        All_declarations_of_an_abstract_method_must_be_consecutive: diag(2516, ts2.DiagnosticCategory.Error, "All_declarations_of_an_abstract_method_must_be_consecutive_2516", "All declarations of an abstract method must be consecutive."),
        Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type: diag(2517, ts2.DiagnosticCategory.Error, "Cannot_assign_an_abstract_constructor_type_to_a_non_abstract_constructor_type_2517", "Cannot assign an abstract constructor type to a non-abstract constructor type."),
        A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard: diag(2518, ts2.DiagnosticCategory.Error, "A_this_based_type_guard_is_not_compatible_with_a_parameter_based_type_guard_2518", "A 'this'-based type guard is not compatible with a parameter-based type guard."),
        An_async_iterator_must_have_a_next_method: diag(2519, ts2.DiagnosticCategory.Error, "An_async_iterator_must_have_a_next_method_2519", "An async iterator must have a 'next()' method."),
        Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions: diag(2520, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_uses_declaration_1_to_support_async_functions_2520", "Duplicate identifier '{0}'. Compiler uses declaration '{1}' to support async functions."),
        The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_using_a_standard_function_or_method: diag(2522, ts2.DiagnosticCategory.Error, "The_arguments_object_cannot_be_referenced_in_an_async_function_or_method_in_ES3_and_ES5_Consider_usi_2522", "The 'arguments' object cannot be referenced in an async function or method in ES3 and ES5. Consider using a standard function or method."),
        yield_expressions_cannot_be_used_in_a_parameter_initializer: diag(2523, ts2.DiagnosticCategory.Error, "yield_expressions_cannot_be_used_in_a_parameter_initializer_2523", "'yield' expressions cannot be used in a parameter initializer."),
        await_expressions_cannot_be_used_in_a_parameter_initializer: diag(2524, ts2.DiagnosticCategory.Error, "await_expressions_cannot_be_used_in_a_parameter_initializer_2524", "'await' expressions cannot be used in a parameter initializer."),
        Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value: diag(2525, ts2.DiagnosticCategory.Error, "Initializer_provides_no_value_for_this_binding_element_and_the_binding_element_has_no_default_value_2525", "Initializer provides no value for this binding element and the binding element has no default value."),
        A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface: diag(2526, ts2.DiagnosticCategory.Error, "A_this_type_is_available_only_in_a_non_static_member_of_a_class_or_interface_2526", "A 'this' type is available only in a non-static member of a class or interface."),
        The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary: diag(2527, ts2.DiagnosticCategory.Error, "The_inferred_type_of_0_references_an_inaccessible_1_type_A_type_annotation_is_necessary_2527", "The inferred type of '{0}' references an inaccessible '{1}' type. A type annotation is necessary."),
        A_module_cannot_have_multiple_default_exports: diag(2528, ts2.DiagnosticCategory.Error, "A_module_cannot_have_multiple_default_exports_2528", "A module cannot have multiple default exports."),
        Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_functions: diag(2529, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_reserves_name_1_in_top_level_scope_of_a_module_containing_async_func_2529", "Duplicate identifier '{0}'. Compiler reserves name '{1}' in top level scope of a module containing async functions."),
        Property_0_is_incompatible_with_index_signature: diag(2530, ts2.DiagnosticCategory.Error, "Property_0_is_incompatible_with_index_signature_2530", "Property '{0}' is incompatible with index signature."),
        Object_is_possibly_null: diag(2531, ts2.DiagnosticCategory.Error, "Object_is_possibly_null_2531", "Object is possibly 'null'."),
        Object_is_possibly_undefined: diag(2532, ts2.DiagnosticCategory.Error, "Object_is_possibly_undefined_2532", "Object is possibly 'undefined'."),
        Object_is_possibly_null_or_undefined: diag(2533, ts2.DiagnosticCategory.Error, "Object_is_possibly_null_or_undefined_2533", "Object is possibly 'null' or 'undefined'."),
        A_function_returning_never_cannot_have_a_reachable_end_point: diag(2534, ts2.DiagnosticCategory.Error, "A_function_returning_never_cannot_have_a_reachable_end_point_2534", "A function returning 'never' cannot have a reachable end point."),
        Enum_type_0_has_members_with_initializers_that_are_not_literals: diag(2535, ts2.DiagnosticCategory.Error, "Enum_type_0_has_members_with_initializers_that_are_not_literals_2535", "Enum type '{0}' has members with initializers that are not literals."),
        Type_0_cannot_be_used_to_index_type_1: diag(2536, ts2.DiagnosticCategory.Error, "Type_0_cannot_be_used_to_index_type_1_2536", "Type '{0}' cannot be used to index type '{1}'."),
        Type_0_has_no_matching_index_signature_for_type_1: diag(2537, ts2.DiagnosticCategory.Error, "Type_0_has_no_matching_index_signature_for_type_1_2537", "Type '{0}' has no matching index signature for type '{1}'."),
        Type_0_cannot_be_used_as_an_index_type: diag(2538, ts2.DiagnosticCategory.Error, "Type_0_cannot_be_used_as_an_index_type_2538", "Type '{0}' cannot be used as an index type."),
        Cannot_assign_to_0_because_it_is_not_a_variable: diag(2539, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_not_a_variable_2539", "Cannot assign to '{0}' because it is not a variable."),
        Cannot_assign_to_0_because_it_is_a_read_only_property: diag(2540, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_read_only_property_2540", "Cannot assign to '{0}' because it is a read-only property."),
        Index_signature_in_type_0_only_permits_reading: diag(2542, ts2.DiagnosticCategory.Error, "Index_signature_in_type_0_only_permits_reading_2542", "Index signature in type '{0}' only permits reading."),
        Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_meta_property_reference: diag(2543, ts2.DiagnosticCategory.Error, "Duplicate_identifier_newTarget_Compiler_uses_variable_declaration_newTarget_to_capture_new_target_me_2543", "Duplicate identifier '_newTarget'. Compiler uses variable declaration '_newTarget' to capture 'new.target' meta-property reference."),
        Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta_property_reference: diag(2544, ts2.DiagnosticCategory.Error, "Expression_resolves_to_variable_declaration_newTarget_that_compiler_uses_to_capture_new_target_meta__2544", "Expression resolves to variable declaration '_newTarget' that compiler uses to capture 'new.target' meta-property reference."),
        A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any: diag(2545, ts2.DiagnosticCategory.Error, "A_mixin_class_must_have_a_constructor_with_a_single_rest_parameter_of_type_any_2545", "A mixin class must have a constructor with a single rest parameter of type 'any[]'."),
        The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_property: diag(2547, ts2.DiagnosticCategory.Error, "The_type_returned_by_the_0_method_of_an_async_iterator_must_be_a_promise_for_a_type_with_a_value_pro_2547", "The type returned by the '{0}()' method of an async iterator must be a promise for a type with a 'value' property."),
        Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2548, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator_2548", "Type '{0}' is not an array type or does not have a '[Symbol.iterator]()' method that returns an iterator."),
        Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns_an_iterator: diag(2549, ts2.DiagnosticCategory.Error, "Type_0_is_not_an_array_type_or_a_string_type_or_does_not_have_a_Symbol_iterator_method_that_returns__2549", "Type '{0}' is not an array type or a string type or does not have a '[Symbol.iterator]()' method that returns an iterator."),
        Property_0_does_not_exist_on_type_1_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2_or_later: diag(2550, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Do_you_need_to_change_your_target_library_Try_changing_the_lib_c_2550", "Property '{0}' does not exist on type '{1}'. Do you need to change your target library? Try changing the 'lib' compiler option to '{2}' or later."),
        Property_0_does_not_exist_on_type_1_Did_you_mean_2: diag(2551, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Did_you_mean_2_2551", "Property '{0}' does not exist on type '{1}'. Did you mean '{2}'?"),
        Cannot_find_name_0_Did_you_mean_1: diag(2552, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_1_2552", "Cannot find name '{0}'. Did you mean '{1}'?"),
        Computed_values_are_not_permitted_in_an_enum_with_string_valued_members: diag(2553, ts2.DiagnosticCategory.Error, "Computed_values_are_not_permitted_in_an_enum_with_string_valued_members_2553", "Computed values are not permitted in an enum with string valued members."),
        Expected_0_arguments_but_got_1: diag(2554, ts2.DiagnosticCategory.Error, "Expected_0_arguments_but_got_1_2554", "Expected {0} arguments, but got {1}."),
        Expected_at_least_0_arguments_but_got_1: diag(2555, ts2.DiagnosticCategory.Error, "Expected_at_least_0_arguments_but_got_1_2555", "Expected at least {0} arguments, but got {1}."),
        A_spread_argument_must_either_have_a_tuple_type_or_be_passed_to_a_rest_parameter: diag(2556, ts2.DiagnosticCategory.Error, "A_spread_argument_must_either_have_a_tuple_type_or_be_passed_to_a_rest_parameter_2556", "A spread argument must either have a tuple type or be passed to a rest parameter."),
        Expected_0_type_arguments_but_got_1: diag(2558, ts2.DiagnosticCategory.Error, "Expected_0_type_arguments_but_got_1_2558", "Expected {0} type arguments, but got {1}."),
        Type_0_has_no_properties_in_common_with_type_1: diag(2559, ts2.DiagnosticCategory.Error, "Type_0_has_no_properties_in_common_with_type_1_2559", "Type '{0}' has no properties in common with type '{1}'."),
        Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it: diag(2560, ts2.DiagnosticCategory.Error, "Value_of_type_0_has_no_properties_in_common_with_type_1_Did_you_mean_to_call_it_2560", "Value of type '{0}' has no properties in common with type '{1}'. Did you mean to call it?"),
        Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_write_2: diag(2561, ts2.DiagnosticCategory.Error, "Object_literal_may_only_specify_known_properties_but_0_does_not_exist_in_type_1_Did_you_mean_to_writ_2561", "Object literal may only specify known properties, but '{0}' does not exist in type '{1}'. Did you mean to write '{2}'?"),
        Base_class_expressions_cannot_reference_class_type_parameters: diag(2562, ts2.DiagnosticCategory.Error, "Base_class_expressions_cannot_reference_class_type_parameters_2562", "Base class expressions cannot reference class type parameters."),
        The_containing_function_or_module_body_is_too_large_for_control_flow_analysis: diag(2563, ts2.DiagnosticCategory.Error, "The_containing_function_or_module_body_is_too_large_for_control_flow_analysis_2563", "The containing function or module body is too large for control flow analysis."),
        Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor: diag(2564, ts2.DiagnosticCategory.Error, "Property_0_has_no_initializer_and_is_not_definitely_assigned_in_the_constructor_2564", "Property '{0}' has no initializer and is not definitely assigned in the constructor."),
        Property_0_is_used_before_being_assigned: diag(2565, ts2.DiagnosticCategory.Error, "Property_0_is_used_before_being_assigned_2565", "Property '{0}' is used before being assigned."),
        A_rest_element_cannot_have_a_property_name: diag(2566, ts2.DiagnosticCategory.Error, "A_rest_element_cannot_have_a_property_name_2566", "A rest element cannot have a property name."),
        Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations: diag(2567, ts2.DiagnosticCategory.Error, "Enum_declarations_can_only_merge_with_namespace_or_other_enum_declarations_2567", "Enum declarations can only merge with namespace or other enum declarations."),
        Property_0_may_not_exist_on_type_1_Did_you_mean_2: diag(2568, ts2.DiagnosticCategory.Error, "Property_0_may_not_exist_on_type_1_Did_you_mean_2_2568", "Property '{0}' may not exist on type '{1}'. Did you mean '{2}'?"),
        Could_not_find_name_0_Did_you_mean_1: diag(2570, ts2.DiagnosticCategory.Error, "Could_not_find_name_0_Did_you_mean_1_2570", "Could not find name '{0}'. Did you mean '{1}'?"),
        Object_is_of_type_unknown: diag(2571, ts2.DiagnosticCategory.Error, "Object_is_of_type_unknown_2571", "Object is of type 'unknown'."),
        A_rest_element_type_must_be_an_array_type: diag(2574, ts2.DiagnosticCategory.Error, "A_rest_element_type_must_be_an_array_type_2574", "A rest element type must be an array type."),
        No_overload_expects_0_arguments_but_overloads_do_exist_that_expect_either_1_or_2_arguments: diag(2575, ts2.DiagnosticCategory.Error, "No_overload_expects_0_arguments_but_overloads_do_exist_that_expect_either_1_or_2_arguments_2575", "No overload expects {0} arguments, but overloads do exist that expect either {1} or {2} arguments."),
        Property_0_does_not_exist_on_type_1_Did_you_mean_to_access_the_static_member_2_instead: diag(2576, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Did_you_mean_to_access_the_static_member_2_instead_2576", "Property '{0}' does not exist on type '{1}'. Did you mean to access the static member '{2}' instead?"),
        Return_type_annotation_circularly_references_itself: diag(2577, ts2.DiagnosticCategory.Error, "Return_type_annotation_circularly_references_itself_2577", "Return type annotation circularly references itself."),
        Unused_ts_expect_error_directive: diag(2578, ts2.DiagnosticCategory.Error, "Unused_ts_expect_error_directive_2578", "Unused '@ts-expect-error' directive."),
        Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashnode: diag(2580, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashno_2580", "Cannot find name '{0}'. Do you need to install type definitions for node? Try `npm i --save-dev @types/node`."),
        Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slashjquery: diag(2581, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slash_2581", "Cannot find name '{0}'. Do you need to install type definitions for jQuery? Try `npm i --save-dev @types/jquery`."),
        Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_types_Slashjest_or_npm_i_save_dev_types_Slashmocha: diag(2582, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_type_2582", "Cannot find name '{0}'. Do you need to install type definitions for a test runner? Try `npm i --save-dev @types/jest` or `npm i --save-dev @types/mocha`."),
        Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_1_or_later: diag(2583, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2583", "Cannot find name '{0}'. Do you need to change your target library? Try changing the 'lib' compiler option to '{1}' or later."),
        Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_include_dom: diag(2584, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_2584", "Cannot find name '{0}'. Do you need to change your target library? Try changing the 'lib' compiler option to include 'dom'."),
        _0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Do_you_need_to_change_your_target_library_Try_changing_the_lib_compiler_option_to_es2015_or_later: diag(2585, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Do_you_need_to_change_your_target_library_2585", "'{0}' only refers to a type, but is being used as a value here. Do you need to change your target library? Try changing the 'lib' compiler option to es2015 or later."),
        Cannot_assign_to_0_because_it_is_a_constant: diag(2588, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_constant_2588", "Cannot assign to '{0}' because it is a constant."),
        Type_instantiation_is_excessively_deep_and_possibly_infinite: diag(2589, ts2.DiagnosticCategory.Error, "Type_instantiation_is_excessively_deep_and_possibly_infinite_2589", "Type instantiation is excessively deep and possibly infinite."),
        Expression_produces_a_union_type_that_is_too_complex_to_represent: diag(2590, ts2.DiagnosticCategory.Error, "Expression_produces_a_union_type_that_is_too_complex_to_represent_2590", "Expression produces a union type that is too complex to represent."),
        Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashnode_and_then_add_node_to_the_types_field_in_your_tsconfig: diag(2591, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_node_Try_npm_i_save_dev_types_Slashno_2591", "Cannot find name '{0}'. Do you need to install type definitions for node? Try `npm i --save-dev @types/node` and then add 'node' to the types field in your tsconfig."),
        Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slashjquery_and_then_add_jquery_to_the_types_field_in_your_tsconfig: diag(2592, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_jQuery_Try_npm_i_save_dev_types_Slash_2592", "Cannot find name '{0}'. Do you need to install type definitions for jQuery? Try `npm i --save-dev @types/jquery` and then add 'jquery' to the types field in your tsconfig."),
        Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_types_Slashjest_or_npm_i_save_dev_types_Slashmocha_and_then_add_jest_or_mocha_to_the_types_field_in_your_tsconfig: diag(2593, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Do_you_need_to_install_type_definitions_for_a_test_runner_Try_npm_i_save_dev_type_2593", "Cannot find name '{0}'. Do you need to install type definitions for a test runner? Try `npm i --save-dev @types/jest` or `npm i --save-dev @types/mocha` and then add 'jest' or 'mocha' to the types field in your tsconfig."),
        This_module_is_declared_with_using_export_and_can_only_be_used_with_a_default_import_when_using_the_0_flag: diag(2594, ts2.DiagnosticCategory.Error, "This_module_is_declared_with_using_export_and_can_only_be_used_with_a_default_import_when_using_the__2594", "This module is declared with using 'export =', and can only be used with a default import when using the '{0}' flag."),
        _0_can_only_be_imported_by_using_a_default_import: diag(2595, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_a_default_import_2595", "'{0}' can only be imported by using a default import."),
        _0_can_only_be_imported_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2596, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import_2596", "'{0}' can only be imported by turning on the 'esModuleInterop' flag and using a default import."),
        _0_can_only_be_imported_by_using_a_require_call_or_by_using_a_default_import: diag(2597, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_a_require_call_or_by_using_a_default_import_2597", "'{0}' can only be imported by using a 'require' call or by using a default import."),
        _0_can_only_be_imported_by_using_a_require_call_or_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2598, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_a_require_call_or_by_turning_on_the_esModuleInterop_flag_and_using__2598", "'{0}' can only be imported by using a 'require' call or by turning on the 'esModuleInterop' flag and using a default import."),
        JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist: diag(2602, ts2.DiagnosticCategory.Error, "JSX_element_implicitly_has_type_any_because_the_global_type_JSX_Element_does_not_exist_2602", "JSX element implicitly has type 'any' because the global type 'JSX.Element' does not exist."),
        Property_0_in_type_1_is_not_assignable_to_type_2: diag(2603, ts2.DiagnosticCategory.Error, "Property_0_in_type_1_is_not_assignable_to_type_2_2603", "Property '{0}' in type '{1}' is not assignable to type '{2}'."),
        JSX_element_type_0_does_not_have_any_construct_or_call_signatures: diag(2604, ts2.DiagnosticCategory.Error, "JSX_element_type_0_does_not_have_any_construct_or_call_signatures_2604", "JSX element type '{0}' does not have any construct or call signatures."),
        Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property: diag(2606, ts2.DiagnosticCategory.Error, "Property_0_of_JSX_spread_attribute_is_not_assignable_to_target_property_2606", "Property '{0}' of JSX spread attribute is not assignable to target property."),
        JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property: diag(2607, ts2.DiagnosticCategory.Error, "JSX_element_class_does_not_support_attributes_because_it_does_not_have_a_0_property_2607", "JSX element class does not support attributes because it does not have a '{0}' property."),
        The_global_type_JSX_0_may_not_have_more_than_one_property: diag(2608, ts2.DiagnosticCategory.Error, "The_global_type_JSX_0_may_not_have_more_than_one_property_2608", "The global type 'JSX.{0}' may not have more than one property."),
        JSX_spread_child_must_be_an_array_type: diag(2609, ts2.DiagnosticCategory.Error, "JSX_spread_child_must_be_an_array_type_2609", "JSX spread child must be an array type."),
        _0_is_defined_as_an_accessor_in_class_1_but_is_overridden_here_in_2_as_an_instance_property: diag(2610, ts2.DiagnosticCategory.Error, "_0_is_defined_as_an_accessor_in_class_1_but_is_overridden_here_in_2_as_an_instance_property_2610", "'{0}' is defined as an accessor in class '{1}', but is overridden here in '{2}' as an instance property."),
        _0_is_defined_as_a_property_in_class_1_but_is_overridden_here_in_2_as_an_accessor: diag(2611, ts2.DiagnosticCategory.Error, "_0_is_defined_as_a_property_in_class_1_but_is_overridden_here_in_2_as_an_accessor_2611", "'{0}' is defined as a property in class '{1}', but is overridden here in '{2}' as an accessor."),
        Property_0_will_overwrite_the_base_property_in_1_If_this_is_intentional_add_an_initializer_Otherwise_add_a_declare_modifier_or_remove_the_redundant_declaration: diag(2612, ts2.DiagnosticCategory.Error, "Property_0_will_overwrite_the_base_property_in_1_If_this_is_intentional_add_an_initializer_Otherwise_2612", "Property '{0}' will overwrite the base property in '{1}'. If this is intentional, add an initializer. Otherwise, add a 'declare' modifier or remove the redundant declaration."),
        Module_0_has_no_default_export_Did_you_mean_to_use_import_1_from_0_instead: diag(2613, ts2.DiagnosticCategory.Error, "Module_0_has_no_default_export_Did_you_mean_to_use_import_1_from_0_instead_2613", "Module '{0}' has no default export. Did you mean to use 'import { {1} } from {0}' instead?"),
        Module_0_has_no_exported_member_1_Did_you_mean_to_use_import_1_from_0_instead: diag(2614, ts2.DiagnosticCategory.Error, "Module_0_has_no_exported_member_1_Did_you_mean_to_use_import_1_from_0_instead_2614", "Module '{0}' has no exported member '{1}'. Did you mean to use 'import {1} from {0}' instead?"),
        Type_of_property_0_circularly_references_itself_in_mapped_type_1: diag(2615, ts2.DiagnosticCategory.Error, "Type_of_property_0_circularly_references_itself_in_mapped_type_1_2615", "Type of property '{0}' circularly references itself in mapped type '{1}'."),
        _0_can_only_be_imported_by_using_import_1_require_2_or_a_default_import: diag(2616, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_import_1_require_2_or_a_default_import_2616", "'{0}' can only be imported by using 'import {1} = require({2})' or a default import."),
        _0_can_only_be_imported_by_using_import_1_require_2_or_by_turning_on_the_esModuleInterop_flag_and_using_a_default_import: diag(2617, ts2.DiagnosticCategory.Error, "_0_can_only_be_imported_by_using_import_1_require_2_or_by_turning_on_the_esModuleInterop_flag_and_us_2617", "'{0}' can only be imported by using 'import {1} = require({2})' or by turning on the 'esModuleInterop' flag and using a default import."),
        Source_has_0_element_s_but_target_requires_1: diag(2618, ts2.DiagnosticCategory.Error, "Source_has_0_element_s_but_target_requires_1_2618", "Source has {0} element(s) but target requires {1}."),
        Source_has_0_element_s_but_target_allows_only_1: diag(2619, ts2.DiagnosticCategory.Error, "Source_has_0_element_s_but_target_allows_only_1_2619", "Source has {0} element(s) but target allows only {1}."),
        Target_requires_0_element_s_but_source_may_have_fewer: diag(2620, ts2.DiagnosticCategory.Error, "Target_requires_0_element_s_but_source_may_have_fewer_2620", "Target requires {0} element(s) but source may have fewer."),
        Target_allows_only_0_element_s_but_source_may_have_more: diag(2621, ts2.DiagnosticCategory.Error, "Target_allows_only_0_element_s_but_source_may_have_more_2621", "Target allows only {0} element(s) but source may have more."),
        Source_provides_no_match_for_required_element_at_position_0_in_target: diag(2623, ts2.DiagnosticCategory.Error, "Source_provides_no_match_for_required_element_at_position_0_in_target_2623", "Source provides no match for required element at position {0} in target."),
        Source_provides_no_match_for_variadic_element_at_position_0_in_target: diag(2624, ts2.DiagnosticCategory.Error, "Source_provides_no_match_for_variadic_element_at_position_0_in_target_2624", "Source provides no match for variadic element at position {0} in target."),
        Variadic_element_at_position_0_in_source_does_not_match_element_at_position_1_in_target: diag(2625, ts2.DiagnosticCategory.Error, "Variadic_element_at_position_0_in_source_does_not_match_element_at_position_1_in_target_2625", "Variadic element at position {0} in source does not match element at position {1} in target."),
        Type_at_position_0_in_source_is_not_compatible_with_type_at_position_1_in_target: diag(2626, ts2.DiagnosticCategory.Error, "Type_at_position_0_in_source_is_not_compatible_with_type_at_position_1_in_target_2626", "Type at position {0} in source is not compatible with type at position {1} in target."),
        Type_at_positions_0_through_1_in_source_is_not_compatible_with_type_at_position_2_in_target: diag(2627, ts2.DiagnosticCategory.Error, "Type_at_positions_0_through_1_in_source_is_not_compatible_with_type_at_position_2_in_target_2627", "Type at positions {0} through {1} in source is not compatible with type at position {2} in target."),
        Cannot_assign_to_0_because_it_is_an_enum: diag(2628, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_an_enum_2628", "Cannot assign to '{0}' because it is an enum."),
        Cannot_assign_to_0_because_it_is_a_class: diag(2629, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_class_2629", "Cannot assign to '{0}' because it is a class."),
        Cannot_assign_to_0_because_it_is_a_function: diag(2630, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_function_2630", "Cannot assign to '{0}' because it is a function."),
        Cannot_assign_to_0_because_it_is_a_namespace: diag(2631, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_a_namespace_2631", "Cannot assign to '{0}' because it is a namespace."),
        Cannot_assign_to_0_because_it_is_an_import: diag(2632, ts2.DiagnosticCategory.Error, "Cannot_assign_to_0_because_it_is_an_import_2632", "Cannot assign to '{0}' because it is an import."),
        JSX_property_access_expressions_cannot_include_JSX_namespace_names: diag(2633, ts2.DiagnosticCategory.Error, "JSX_property_access_expressions_cannot_include_JSX_namespace_names_2633", "JSX property access expressions cannot include JSX namespace names"),
        _0_index_signatures_are_incompatible: diag(2634, ts2.DiagnosticCategory.Error, "_0_index_signatures_are_incompatible_2634", "'{0}' index signatures are incompatible."),
        Type_0_has_no_signatures_for_which_the_type_argument_list_is_applicable: diag(2635, ts2.DiagnosticCategory.Error, "Type_0_has_no_signatures_for_which_the_type_argument_list_is_applicable_2635", "Type '{0}' has no signatures for which the type argument list is applicable."),
        Type_0_is_not_assignable_to_type_1_as_implied_by_variance_annotation: diag(2636, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_as_implied_by_variance_annotation_2636", "Type '{0}' is not assignable to type '{1}' as implied by variance annotation."),
        Variance_annotations_are_only_supported_in_type_aliases_for_object_function_constructor_and_mapped_types: diag(2637, ts2.DiagnosticCategory.Error, "Variance_annotations_are_only_supported_in_type_aliases_for_object_function_constructor_and_mapped_t_2637", "Variance annotations are only supported in type aliases for object, function, constructor, and mapped types."),
        Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity: diag(2649, ts2.DiagnosticCategory.Error, "Cannot_augment_module_0_with_value_exports_because_it_resolves_to_a_non_module_entity_2649", "Cannot augment module '{0}' with value exports because it resolves to a non-module entity."),
        A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_members_defined_in_other_enums: diag(2651, ts2.DiagnosticCategory.Error, "A_member_initializer_in_a_enum_declaration_cannot_reference_members_declared_after_it_including_memb_2651", "A member initializer in a enum declaration cannot reference members declared after it, including members defined in other enums."),
        Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_default_0_declaration_instead: diag(2652, ts2.DiagnosticCategory.Error, "Merged_declaration_0_cannot_include_a_default_export_declaration_Consider_adding_a_separate_export_d_2652", "Merged declaration '{0}' cannot include a default export declaration. Consider adding a separate 'export default {0}' declaration instead."),
        Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1: diag(2653, ts2.DiagnosticCategory.Error, "Non_abstract_class_expression_does_not_implement_inherited_abstract_member_0_from_class_1_2653", "Non-abstract class expression does not implement inherited abstract member '{0}' from class '{1}'."),
        JSX_expressions_must_have_one_parent_element: diag(2657, ts2.DiagnosticCategory.Error, "JSX_expressions_must_have_one_parent_element_2657", "JSX expressions must have one parent element."),
        Type_0_provides_no_match_for_the_signature_1: diag(2658, ts2.DiagnosticCategory.Error, "Type_0_provides_no_match_for_the_signature_1_2658", "Type '{0}' provides no match for the signature '{1}'."),
        super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_higher: diag(2659, ts2.DiagnosticCategory.Error, "super_is_only_allowed_in_members_of_object_literal_expressions_when_option_target_is_ES2015_or_highe_2659", "'super' is only allowed in members of object literal expressions when option 'target' is 'ES2015' or higher."),
        super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions: diag(2660, ts2.DiagnosticCategory.Error, "super_can_only_be_referenced_in_members_of_derived_classes_or_object_literal_expressions_2660", "'super' can only be referenced in members of derived classes or object literal expressions."),
        Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module: diag(2661, ts2.DiagnosticCategory.Error, "Cannot_export_0_Only_local_declarations_can_be_exported_from_a_module_2661", "Cannot export '{0}'. Only local declarations can be exported from a module."),
        Cannot_find_name_0_Did_you_mean_the_static_member_1_0: diag(2662, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_the_static_member_1_0_2662", "Cannot find name '{0}'. Did you mean the static member '{1}.{0}'?"),
        Cannot_find_name_0_Did_you_mean_the_instance_member_this_0: diag(2663, ts2.DiagnosticCategory.Error, "Cannot_find_name_0_Did_you_mean_the_instance_member_this_0_2663", "Cannot find name '{0}'. Did you mean the instance member 'this.{0}'?"),
        Invalid_module_name_in_augmentation_module_0_cannot_be_found: diag(2664, ts2.DiagnosticCategory.Error, "Invalid_module_name_in_augmentation_module_0_cannot_be_found_2664", "Invalid module name in augmentation, module '{0}' cannot be found."),
        Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augmented: diag(2665, ts2.DiagnosticCategory.Error, "Invalid_module_name_in_augmentation_Module_0_resolves_to_an_untyped_module_at_1_which_cannot_be_augm_2665", "Invalid module name in augmentation. Module '{0}' resolves to an untyped module at '{1}', which cannot be augmented."),
        Exports_and_export_assignments_are_not_permitted_in_module_augmentations: diag(2666, ts2.DiagnosticCategory.Error, "Exports_and_export_assignments_are_not_permitted_in_module_augmentations_2666", "Exports and export assignments are not permitted in module augmentations."),
        Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_module: diag(2667, ts2.DiagnosticCategory.Error, "Imports_are_not_permitted_in_module_augmentations_Consider_moving_them_to_the_enclosing_external_mod_2667", "Imports are not permitted in module augmentations. Consider moving them to the enclosing external module."),
        export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always_visible: diag(2668, ts2.DiagnosticCategory.Error, "export_modifier_cannot_be_applied_to_ambient_modules_and_module_augmentations_since_they_are_always__2668", "'export' modifier cannot be applied to ambient modules and module augmentations since they are always visible."),
        Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_declarations: diag(2669, ts2.DiagnosticCategory.Error, "Augmentations_for_the_global_scope_can_only_be_directly_nested_in_external_modules_or_ambient_module_2669", "Augmentations for the global scope can only be directly nested in external modules or ambient module declarations."),
        Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambient_context: diag(2670, ts2.DiagnosticCategory.Error, "Augmentations_for_the_global_scope_should_have_declare_modifier_unless_they_appear_in_already_ambien_2670", "Augmentations for the global scope should have 'declare' modifier unless they appear in already ambient context."),
        Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity: diag(2671, ts2.DiagnosticCategory.Error, "Cannot_augment_module_0_because_it_resolves_to_a_non_module_entity_2671", "Cannot augment module '{0}' because it resolves to a non-module entity."),
        Cannot_assign_a_0_constructor_type_to_a_1_constructor_type: diag(2672, ts2.DiagnosticCategory.Error, "Cannot_assign_a_0_constructor_type_to_a_1_constructor_type_2672", "Cannot assign a '{0}' constructor type to a '{1}' constructor type."),
        Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration: diag(2673, ts2.DiagnosticCategory.Error, "Constructor_of_class_0_is_private_and_only_accessible_within_the_class_declaration_2673", "Constructor of class '{0}' is private and only accessible within the class declaration."),
        Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration: diag(2674, ts2.DiagnosticCategory.Error, "Constructor_of_class_0_is_protected_and_only_accessible_within_the_class_declaration_2674", "Constructor of class '{0}' is protected and only accessible within the class declaration."),
        Cannot_extend_a_class_0_Class_constructor_is_marked_as_private: diag(2675, ts2.DiagnosticCategory.Error, "Cannot_extend_a_class_0_Class_constructor_is_marked_as_private_2675", "Cannot extend a class '{0}'. Class constructor is marked as private."),
        Accessors_must_both_be_abstract_or_non_abstract: diag(2676, ts2.DiagnosticCategory.Error, "Accessors_must_both_be_abstract_or_non_abstract_2676", "Accessors must both be abstract or non-abstract."),
        A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type: diag(2677, ts2.DiagnosticCategory.Error, "A_type_predicate_s_type_must_be_assignable_to_its_parameter_s_type_2677", "A type predicate's type must be assignable to its parameter's type."),
        Type_0_is_not_comparable_to_type_1: diag(2678, ts2.DiagnosticCategory.Error, "Type_0_is_not_comparable_to_type_1_2678", "Type '{0}' is not comparable to type '{1}'."),
        A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void: diag(2679, ts2.DiagnosticCategory.Error, "A_function_that_is_called_with_the_new_keyword_cannot_have_a_this_type_that_is_void_2679", "A function that is called with the 'new' keyword cannot have a 'this' type that is 'void'."),
        A_0_parameter_must_be_the_first_parameter: diag(2680, ts2.DiagnosticCategory.Error, "A_0_parameter_must_be_the_first_parameter_2680", "A '{0}' parameter must be the first parameter."),
        A_constructor_cannot_have_a_this_parameter: diag(2681, ts2.DiagnosticCategory.Error, "A_constructor_cannot_have_a_this_parameter_2681", "A constructor cannot have a 'this' parameter."),
        this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation: diag(2683, ts2.DiagnosticCategory.Error, "this_implicitly_has_type_any_because_it_does_not_have_a_type_annotation_2683", "'this' implicitly has type 'any' because it does not have a type annotation."),
        The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1: diag(2684, ts2.DiagnosticCategory.Error, "The_this_context_of_type_0_is_not_assignable_to_method_s_this_of_type_1_2684", "The 'this' context of type '{0}' is not assignable to method's 'this' of type '{1}'."),
        The_this_types_of_each_signature_are_incompatible: diag(2685, ts2.DiagnosticCategory.Error, "The_this_types_of_each_signature_are_incompatible_2685", "The 'this' types of each signature are incompatible."),
        _0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead: diag(2686, ts2.DiagnosticCategory.Error, "_0_refers_to_a_UMD_global_but_the_current_file_is_a_module_Consider_adding_an_import_instead_2686", "'{0}' refers to a UMD global, but the current file is a module. Consider adding an import instead."),
        All_declarations_of_0_must_have_identical_modifiers: diag(2687, ts2.DiagnosticCategory.Error, "All_declarations_of_0_must_have_identical_modifiers_2687", "All declarations of '{0}' must have identical modifiers."),
        Cannot_find_type_definition_file_for_0: diag(2688, ts2.DiagnosticCategory.Error, "Cannot_find_type_definition_file_for_0_2688", "Cannot find type definition file for '{0}'."),
        Cannot_extend_an_interface_0_Did_you_mean_implements: diag(2689, ts2.DiagnosticCategory.Error, "Cannot_extend_an_interface_0_Did_you_mean_implements_2689", "Cannot extend an interface '{0}'. Did you mean 'implements'?"),
        _0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Did_you_mean_to_use_1_in_0: diag(2690, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_Did_you_mean_to_use_1_in_0_2690", "'{0}' only refers to a type, but is being used as a value here. Did you mean to use '{1} in {0}'?"),
        An_import_path_cannot_end_with_a_0_extension_Consider_importing_1_instead: diag(2691, ts2.DiagnosticCategory.Error, "An_import_path_cannot_end_with_a_0_extension_Consider_importing_1_instead_2691", "An import path cannot end with a '{0}' extension. Consider importing '{1}' instead."),
        _0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible: diag(2692, ts2.DiagnosticCategory.Error, "_0_is_a_primitive_but_1_is_a_wrapper_object_Prefer_using_0_when_possible_2692", "'{0}' is a primitive, but '{1}' is a wrapper object. Prefer using '{0}' when possible."),
        _0_only_refers_to_a_type_but_is_being_used_as_a_value_here: diag(2693, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_value_here_2693", "'{0}' only refers to a type, but is being used as a value here."),
        Namespace_0_has_no_exported_member_1: diag(2694, ts2.DiagnosticCategory.Error, "Namespace_0_has_no_exported_member_1_2694", "Namespace '{0}' has no exported member '{1}'."),
        Left_side_of_comma_operator_is_unused_and_has_no_side_effects: diag(2695, ts2.DiagnosticCategory.Error, "Left_side_of_comma_operator_is_unused_and_has_no_side_effects_2695", "Left side of comma operator is unused and has no side effects.", true),
        The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead: diag(2696, ts2.DiagnosticCategory.Error, "The_Object_type_is_assignable_to_very_few_other_types_Did_you_mean_to_use_the_any_type_instead_2696", "The 'Object' type is assignable to very few other types. Did you mean to use the 'any' type instead?"),
        An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option: diag(2697, ts2.DiagnosticCategory.Error, "An_async_function_or_method_must_return_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_in_2697", "An async function or method must return a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your '--lib' option."),
        Spread_types_may_only_be_created_from_object_types: diag(2698, ts2.DiagnosticCategory.Error, "Spread_types_may_only_be_created_from_object_types_2698", "Spread types may only be created from object types."),
        Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1: diag(2699, ts2.DiagnosticCategory.Error, "Static_property_0_conflicts_with_built_in_property_Function_0_of_constructor_function_1_2699", "Static property '{0}' conflicts with built-in property 'Function.{0}' of constructor function '{1}'."),
        Rest_types_may_only_be_created_from_object_types: diag(2700, ts2.DiagnosticCategory.Error, "Rest_types_may_only_be_created_from_object_types_2700", "Rest types may only be created from object types."),
        The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access: diag(2701, ts2.DiagnosticCategory.Error, "The_target_of_an_object_rest_assignment_must_be_a_variable_or_a_property_access_2701", "The target of an object rest assignment must be a variable or a property access."),
        _0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here: diag(2702, ts2.DiagnosticCategory.Error, "_0_only_refers_to_a_type_but_is_being_used_as_a_namespace_here_2702", "'{0}' only refers to a type, but is being used as a namespace here."),
        The_operand_of_a_delete_operator_must_be_a_property_reference: diag(2703, ts2.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_must_be_a_property_reference_2703", "The operand of a 'delete' operator must be a property reference."),
        The_operand_of_a_delete_operator_cannot_be_a_read_only_property: diag(2704, ts2.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_cannot_be_a_read_only_property_2704", "The operand of a 'delete' operator cannot be a read-only property."),
        An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option: diag(2705, ts2.DiagnosticCategory.Error, "An_async_function_or_method_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_de_2705", "An async function or method in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your '--lib' option."),
        Required_type_parameters_may_not_follow_optional_type_parameters: diag(2706, ts2.DiagnosticCategory.Error, "Required_type_parameters_may_not_follow_optional_type_parameters_2706", "Required type parameters may not follow optional type parameters."),
        Generic_type_0_requires_between_1_and_2_type_arguments: diag(2707, ts2.DiagnosticCategory.Error, "Generic_type_0_requires_between_1_and_2_type_arguments_2707", "Generic type '{0}' requires between {1} and {2} type arguments."),
        Cannot_use_namespace_0_as_a_value: diag(2708, ts2.DiagnosticCategory.Error, "Cannot_use_namespace_0_as_a_value_2708", "Cannot use namespace '{0}' as a value."),
        Cannot_use_namespace_0_as_a_type: diag(2709, ts2.DiagnosticCategory.Error, "Cannot_use_namespace_0_as_a_type_2709", "Cannot use namespace '{0}' as a type."),
        _0_are_specified_twice_The_attribute_named_0_will_be_overwritten: diag(2710, ts2.DiagnosticCategory.Error, "_0_are_specified_twice_The_attribute_named_0_will_be_overwritten_2710", "'{0}' are specified twice. The attribute named '{0}' will be overwritten."),
        A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES2015_in_your_lib_option: diag(2711, ts2.DiagnosticCategory.Error, "A_dynamic_import_call_returns_a_Promise_Make_sure_you_have_a_declaration_for_Promise_or_include_ES20_2711", "A dynamic import call returns a 'Promise'. Make sure you have a declaration for 'Promise' or include 'ES2015' in your '--lib' option."),
        A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declaration_for_the_Promise_constructor_or_include_ES2015_in_your_lib_option: diag(2712, ts2.DiagnosticCategory.Error, "A_dynamic_import_call_in_ES5_SlashES3_requires_the_Promise_constructor_Make_sure_you_have_a_declarat_2712", "A dynamic import call in ES5/ES3 requires the 'Promise' constructor.  Make sure you have a declaration for the 'Promise' constructor or include 'ES2015' in your '--lib' option."),
        Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_property_1_in_0_with_0_1: diag(2713, ts2.DiagnosticCategory.Error, "Cannot_access_0_1_because_0_is_a_type_but_not_a_namespace_Did_you_mean_to_retrieve_the_type_of_the_p_2713", `Cannot access '{0}.{1}' because '{0}' is a type, but not a namespace. Did you mean to retrieve the type of the property '{1}' in '{0}' with '{0}["{1}"]'?`),
        The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context: diag(2714, ts2.DiagnosticCategory.Error, "The_expression_of_an_export_assignment_must_be_an_identifier_or_qualified_name_in_an_ambient_context_2714", "The expression of an export assignment must be an identifier or qualified name in an ambient context."),
        Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor: diag(2715, ts2.DiagnosticCategory.Error, "Abstract_property_0_in_class_1_cannot_be_accessed_in_the_constructor_2715", "Abstract property '{0}' in class '{1}' cannot be accessed in the constructor."),
        Type_parameter_0_has_a_circular_default: diag(2716, ts2.DiagnosticCategory.Error, "Type_parameter_0_has_a_circular_default_2716", "Type parameter '{0}' has a circular default."),
        Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_type_2: diag(2717, ts2.DiagnosticCategory.Error, "Subsequent_property_declarations_must_have_the_same_type_Property_0_must_be_of_type_1_but_here_has_t_2717", "Subsequent property declarations must have the same type.  Property '{0}' must be of type '{1}', but here has type '{2}'."),
        Duplicate_property_0: diag(2718, ts2.DiagnosticCategory.Error, "Duplicate_property_0_2718", "Duplicate property '{0}'."),
        Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated: diag(2719, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_Two_different_types_with_this_name_exist_but_they_are_unrelated_2719", "Type '{0}' is not assignable to type '{1}'. Two different types with this name exist, but they are unrelated."),
        Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclass: diag(2720, ts2.DiagnosticCategory.Error, "Class_0_incorrectly_implements_class_1_Did_you_mean_to_extend_1_and_inherit_its_members_as_a_subclas_2720", "Class '{0}' incorrectly implements class '{1}'. Did you mean to extend '{1}' and inherit its members as a subclass?"),
        Cannot_invoke_an_object_which_is_possibly_null: diag(2721, ts2.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_null_2721", "Cannot invoke an object which is possibly 'null'."),
        Cannot_invoke_an_object_which_is_possibly_undefined: diag(2722, ts2.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_undefined_2722", "Cannot invoke an object which is possibly 'undefined'."),
        Cannot_invoke_an_object_which_is_possibly_null_or_undefined: diag(2723, ts2.DiagnosticCategory.Error, "Cannot_invoke_an_object_which_is_possibly_null_or_undefined_2723", "Cannot invoke an object which is possibly 'null' or 'undefined'."),
        _0_has_no_exported_member_named_1_Did_you_mean_2: diag(2724, ts2.DiagnosticCategory.Error, "_0_has_no_exported_member_named_1_Did_you_mean_2_2724", "'{0}' has no exported member named '{1}'. Did you mean '{2}'?"),
        Class_name_cannot_be_Object_when_targeting_ES5_with_module_0: diag(2725, ts2.DiagnosticCategory.Error, "Class_name_cannot_be_Object_when_targeting_ES5_with_module_0_2725", "Class name cannot be 'Object' when targeting ES5 with module {0}."),
        Cannot_find_lib_definition_for_0: diag(2726, ts2.DiagnosticCategory.Error, "Cannot_find_lib_definition_for_0_2726", "Cannot find lib definition for '{0}'."),
        Cannot_find_lib_definition_for_0_Did_you_mean_1: diag(2727, ts2.DiagnosticCategory.Error, "Cannot_find_lib_definition_for_0_Did_you_mean_1_2727", "Cannot find lib definition for '{0}'. Did you mean '{1}'?"),
        _0_is_declared_here: diag(2728, ts2.DiagnosticCategory.Message, "_0_is_declared_here_2728", "'{0}' is declared here."),
        Property_0_is_used_before_its_initialization: diag(2729, ts2.DiagnosticCategory.Error, "Property_0_is_used_before_its_initialization_2729", "Property '{0}' is used before its initialization."),
        An_arrow_function_cannot_have_a_this_parameter: diag(2730, ts2.DiagnosticCategory.Error, "An_arrow_function_cannot_have_a_this_parameter_2730", "An arrow function cannot have a 'this' parameter."),
        Implicit_conversion_of_a_symbol_to_a_string_will_fail_at_runtime_Consider_wrapping_this_expression_in_String: diag(2731, ts2.DiagnosticCategory.Error, "Implicit_conversion_of_a_symbol_to_a_string_will_fail_at_runtime_Consider_wrapping_this_expression_i_2731", "Implicit conversion of a 'symbol' to a 'string' will fail at runtime. Consider wrapping this expression in 'String(...)'."),
        Cannot_find_module_0_Consider_using_resolveJsonModule_to_import_module_with_json_extension: diag(2732, ts2.DiagnosticCategory.Error, "Cannot_find_module_0_Consider_using_resolveJsonModule_to_import_module_with_json_extension_2732", "Cannot find module '{0}'. Consider using '--resolveJsonModule' to import module with '.json' extension."),
        Property_0_was_also_declared_here: diag(2733, ts2.DiagnosticCategory.Error, "Property_0_was_also_declared_here_2733", "Property '{0}' was also declared here."),
        Are_you_missing_a_semicolon: diag(2734, ts2.DiagnosticCategory.Error, "Are_you_missing_a_semicolon_2734", "Are you missing a semicolon?"),
        Did_you_mean_for_0_to_be_constrained_to_type_new_args_Colon_any_1: diag(2735, ts2.DiagnosticCategory.Error, "Did_you_mean_for_0_to_be_constrained_to_type_new_args_Colon_any_1_2735", "Did you mean for '{0}' to be constrained to type 'new (...args: any[]) => {1}'?"),
        Operator_0_cannot_be_applied_to_type_1: diag(2736, ts2.DiagnosticCategory.Error, "Operator_0_cannot_be_applied_to_type_1_2736", "Operator '{0}' cannot be applied to type '{1}'."),
        BigInt_literals_are_not_available_when_targeting_lower_than_ES2020: diag(2737, ts2.DiagnosticCategory.Error, "BigInt_literals_are_not_available_when_targeting_lower_than_ES2020_2737", "BigInt literals are not available when targeting lower than ES2020."),
        An_outer_value_of_this_is_shadowed_by_this_container: diag(2738, ts2.DiagnosticCategory.Message, "An_outer_value_of_this_is_shadowed_by_this_container_2738", "An outer value of 'this' is shadowed by this container."),
        Type_0_is_missing_the_following_properties_from_type_1_Colon_2: diag(2739, ts2.DiagnosticCategory.Error, "Type_0_is_missing_the_following_properties_from_type_1_Colon_2_2739", "Type '{0}' is missing the following properties from type '{1}': {2}"),
        Type_0_is_missing_the_following_properties_from_type_1_Colon_2_and_3_more: diag(2740, ts2.DiagnosticCategory.Error, "Type_0_is_missing_the_following_properties_from_type_1_Colon_2_and_3_more_2740", "Type '{0}' is missing the following properties from type '{1}': {2}, and {3} more."),
        Property_0_is_missing_in_type_1_but_required_in_type_2: diag(2741, ts2.DiagnosticCategory.Error, "Property_0_is_missing_in_type_1_but_required_in_type_2_2741", "Property '{0}' is missing in type '{1}' but required in type '{2}'."),
        The_inferred_type_of_0_cannot_be_named_without_a_reference_to_1_This_is_likely_not_portable_A_type_annotation_is_necessary: diag(2742, ts2.DiagnosticCategory.Error, "The_inferred_type_of_0_cannot_be_named_without_a_reference_to_1_This_is_likely_not_portable_A_type_a_2742", "The inferred type of '{0}' cannot be named without a reference to '{1}'. This is likely not portable. A type annotation is necessary."),
        No_overload_expects_0_type_arguments_but_overloads_do_exist_that_expect_either_1_or_2_type_arguments: diag(2743, ts2.DiagnosticCategory.Error, "No_overload_expects_0_type_arguments_but_overloads_do_exist_that_expect_either_1_or_2_type_arguments_2743", "No overload expects {0} type arguments, but overloads do exist that expect either {1} or {2} type arguments."),
        Type_parameter_defaults_can_only_reference_previously_declared_type_parameters: diag(2744, ts2.DiagnosticCategory.Error, "Type_parameter_defaults_can_only_reference_previously_declared_type_parameters_2744", "Type parameter defaults can only reference previously declared type parameters."),
        This_JSX_tag_s_0_prop_expects_type_1_which_requires_multiple_children_but_only_a_single_child_was_provided: diag(2745, ts2.DiagnosticCategory.Error, "This_JSX_tag_s_0_prop_expects_type_1_which_requires_multiple_children_but_only_a_single_child_was_pr_2745", "This JSX tag's '{0}' prop expects type '{1}' which requires multiple children, but only a single child was provided."),
        This_JSX_tag_s_0_prop_expects_a_single_child_of_type_1_but_multiple_children_were_provided: diag(2746, ts2.DiagnosticCategory.Error, "This_JSX_tag_s_0_prop_expects_a_single_child_of_type_1_but_multiple_children_were_provided_2746", "This JSX tag's '{0}' prop expects a single child of type '{1}', but multiple children were provided."),
        _0_components_don_t_accept_text_as_child_elements_Text_in_JSX_has_the_type_string_but_the_expected_type_of_1_is_2: diag(2747, ts2.DiagnosticCategory.Error, "_0_components_don_t_accept_text_as_child_elements_Text_in_JSX_has_the_type_string_but_the_expected_t_2747", "'{0}' components don't accept text as child elements. Text in JSX has the type 'string', but the expected type of '{1}' is '{2}'."),
        Cannot_access_ambient_const_enums_when_the_isolatedModules_flag_is_provided: diag(2748, ts2.DiagnosticCategory.Error, "Cannot_access_ambient_const_enums_when_the_isolatedModules_flag_is_provided_2748", "Cannot access ambient const enums when the '--isolatedModules' flag is provided."),
        _0_refers_to_a_value_but_is_being_used_as_a_type_here_Did_you_mean_typeof_0: diag(2749, ts2.DiagnosticCategory.Error, "_0_refers_to_a_value_but_is_being_used_as_a_type_here_Did_you_mean_typeof_0_2749", "'{0}' refers to a value, but is being used as a type here. Did you mean 'typeof {0}'?"),
        The_implementation_signature_is_declared_here: diag(2750, ts2.DiagnosticCategory.Error, "The_implementation_signature_is_declared_here_2750", "The implementation signature is declared here."),
        Circularity_originates_in_type_at_this_location: diag(2751, ts2.DiagnosticCategory.Error, "Circularity_originates_in_type_at_this_location_2751", "Circularity originates in type at this location."),
        The_first_export_default_is_here: diag(2752, ts2.DiagnosticCategory.Error, "The_first_export_default_is_here_2752", "The first export default is here."),
        Another_export_default_is_here: diag(2753, ts2.DiagnosticCategory.Error, "Another_export_default_is_here_2753", "Another export default is here."),
        super_may_not_use_type_arguments: diag(2754, ts2.DiagnosticCategory.Error, "super_may_not_use_type_arguments_2754", "'super' may not use type arguments."),
        No_constituent_of_type_0_is_callable: diag(2755, ts2.DiagnosticCategory.Error, "No_constituent_of_type_0_is_callable_2755", "No constituent of type '{0}' is callable."),
        Not_all_constituents_of_type_0_are_callable: diag(2756, ts2.DiagnosticCategory.Error, "Not_all_constituents_of_type_0_are_callable_2756", "Not all constituents of type '{0}' are callable."),
        Type_0_has_no_call_signatures: diag(2757, ts2.DiagnosticCategory.Error, "Type_0_has_no_call_signatures_2757", "Type '{0}' has no call signatures."),
        Each_member_of_the_union_type_0_has_signatures_but_none_of_those_signatures_are_compatible_with_each_other: diag(2758, ts2.DiagnosticCategory.Error, "Each_member_of_the_union_type_0_has_signatures_but_none_of_those_signatures_are_compatible_with_each_2758", "Each member of the union type '{0}' has signatures, but none of those signatures are compatible with each other."),
        No_constituent_of_type_0_is_constructable: diag(2759, ts2.DiagnosticCategory.Error, "No_constituent_of_type_0_is_constructable_2759", "No constituent of type '{0}' is constructable."),
        Not_all_constituents_of_type_0_are_constructable: diag(2760, ts2.DiagnosticCategory.Error, "Not_all_constituents_of_type_0_are_constructable_2760", "Not all constituents of type '{0}' are constructable."),
        Type_0_has_no_construct_signatures: diag(2761, ts2.DiagnosticCategory.Error, "Type_0_has_no_construct_signatures_2761", "Type '{0}' has no construct signatures."),
        Each_member_of_the_union_type_0_has_construct_signatures_but_none_of_those_signatures_are_compatible_with_each_other: diag(2762, ts2.DiagnosticCategory.Error, "Each_member_of_the_union_type_0_has_construct_signatures_but_none_of_those_signatures_are_compatible_2762", "Each member of the union type '{0}' has construct signatures, but none of those signatures are compatible with each other."),
        Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_for_of_will_always_send_0: diag(2763, ts2.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_for_of_will_always_s_2763", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but for-of will always send '{0}'."),
        Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_spread_will_always_send_0: diag(2764, ts2.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_spread_will_al_2764", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but array spread will always send '{0}'."),
        Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_destructuring_will_always_send_0: diag(2765, ts2.DiagnosticCategory.Error, "Cannot_iterate_value_because_the_next_method_of_its_iterator_expects_type_1_but_array_destructuring__2765", "Cannot iterate value because the 'next' method of its iterator expects type '{1}', but array destructuring will always send '{0}'."),
        Cannot_delegate_iteration_to_value_because_the_next_method_of_its_iterator_expects_type_1_but_the_containing_generator_will_always_send_0: diag(2766, ts2.DiagnosticCategory.Error, "Cannot_delegate_iteration_to_value_because_the_next_method_of_its_iterator_expects_type_1_but_the_co_2766", "Cannot delegate iteration to value because the 'next' method of its iterator expects type '{1}', but the containing generator will always send '{0}'."),
        The_0_property_of_an_iterator_must_be_a_method: diag(2767, ts2.DiagnosticCategory.Error, "The_0_property_of_an_iterator_must_be_a_method_2767", "The '{0}' property of an iterator must be a method."),
        The_0_property_of_an_async_iterator_must_be_a_method: diag(2768, ts2.DiagnosticCategory.Error, "The_0_property_of_an_async_iterator_must_be_a_method_2768", "The '{0}' property of an async iterator must be a method."),
        No_overload_matches_this_call: diag(2769, ts2.DiagnosticCategory.Error, "No_overload_matches_this_call_2769", "No overload matches this call."),
        The_last_overload_gave_the_following_error: diag(2770, ts2.DiagnosticCategory.Error, "The_last_overload_gave_the_following_error_2770", "The last overload gave the following error."),
        The_last_overload_is_declared_here: diag(2771, ts2.DiagnosticCategory.Error, "The_last_overload_is_declared_here_2771", "The last overload is declared here."),
        Overload_0_of_1_2_gave_the_following_error: diag(2772, ts2.DiagnosticCategory.Error, "Overload_0_of_1_2_gave_the_following_error_2772", "Overload {0} of {1}, '{2}', gave the following error."),
        Did_you_forget_to_use_await: diag(2773, ts2.DiagnosticCategory.Error, "Did_you_forget_to_use_await_2773", "Did you forget to use 'await'?"),
        This_condition_will_always_return_true_since_this_function_is_always_defined_Did_you_mean_to_call_it_instead: diag(2774, ts2.DiagnosticCategory.Error, "This_condition_will_always_return_true_since_this_function_is_always_defined_Did_you_mean_to_call_it_2774", "This condition will always return true since this function is always defined. Did you mean to call it instead?"),
        Assertions_require_every_name_in_the_call_target_to_be_declared_with_an_explicit_type_annotation: diag(2775, ts2.DiagnosticCategory.Error, "Assertions_require_every_name_in_the_call_target_to_be_declared_with_an_explicit_type_annotation_2775", "Assertions require every name in the call target to be declared with an explicit type annotation."),
        Assertions_require_the_call_target_to_be_an_identifier_or_qualified_name: diag(2776, ts2.DiagnosticCategory.Error, "Assertions_require_the_call_target_to_be_an_identifier_or_qualified_name_2776", "Assertions require the call target to be an identifier or qualified name."),
        The_operand_of_an_increment_or_decrement_operator_may_not_be_an_optional_property_access: diag(2777, ts2.DiagnosticCategory.Error, "The_operand_of_an_increment_or_decrement_operator_may_not_be_an_optional_property_access_2777", "The operand of an increment or decrement operator may not be an optional property access."),
        The_target_of_an_object_rest_assignment_may_not_be_an_optional_property_access: diag(2778, ts2.DiagnosticCategory.Error, "The_target_of_an_object_rest_assignment_may_not_be_an_optional_property_access_2778", "The target of an object rest assignment may not be an optional property access."),
        The_left_hand_side_of_an_assignment_expression_may_not_be_an_optional_property_access: diag(2779, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_an_assignment_expression_may_not_be_an_optional_property_access_2779", "The left-hand side of an assignment expression may not be an optional property access."),
        The_left_hand_side_of_a_for_in_statement_may_not_be_an_optional_property_access: diag(2780, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_in_statement_may_not_be_an_optional_property_access_2780", "The left-hand side of a 'for...in' statement may not be an optional property access."),
        The_left_hand_side_of_a_for_of_statement_may_not_be_an_optional_property_access: diag(2781, ts2.DiagnosticCategory.Error, "The_left_hand_side_of_a_for_of_statement_may_not_be_an_optional_property_access_2781", "The left-hand side of a 'for...of' statement may not be an optional property access."),
        _0_needs_an_explicit_type_annotation: diag(2782, ts2.DiagnosticCategory.Message, "_0_needs_an_explicit_type_annotation_2782", "'{0}' needs an explicit type annotation."),
        _0_is_specified_more_than_once_so_this_usage_will_be_overwritten: diag(2783, ts2.DiagnosticCategory.Error, "_0_is_specified_more_than_once_so_this_usage_will_be_overwritten_2783", "'{0}' is specified more than once, so this usage will be overwritten."),
        get_and_set_accessors_cannot_declare_this_parameters: diag(2784, ts2.DiagnosticCategory.Error, "get_and_set_accessors_cannot_declare_this_parameters_2784", "'get' and 'set' accessors cannot declare 'this' parameters."),
        This_spread_always_overwrites_this_property: diag(2785, ts2.DiagnosticCategory.Error, "This_spread_always_overwrites_this_property_2785", "This spread always overwrites this property."),
        _0_cannot_be_used_as_a_JSX_component: diag(2786, ts2.DiagnosticCategory.Error, "_0_cannot_be_used_as_a_JSX_component_2786", "'{0}' cannot be used as a JSX component."),
        Its_return_type_0_is_not_a_valid_JSX_element: diag(2787, ts2.DiagnosticCategory.Error, "Its_return_type_0_is_not_a_valid_JSX_element_2787", "Its return type '{0}' is not a valid JSX element."),
        Its_instance_type_0_is_not_a_valid_JSX_element: diag(2788, ts2.DiagnosticCategory.Error, "Its_instance_type_0_is_not_a_valid_JSX_element_2788", "Its instance type '{0}' is not a valid JSX element."),
        Its_element_type_0_is_not_a_valid_JSX_element: diag(2789, ts2.DiagnosticCategory.Error, "Its_element_type_0_is_not_a_valid_JSX_element_2789", "Its element type '{0}' is not a valid JSX element."),
        The_operand_of_a_delete_operator_must_be_optional: diag(2790, ts2.DiagnosticCategory.Error, "The_operand_of_a_delete_operator_must_be_optional_2790", "The operand of a 'delete' operator must be optional."),
        Exponentiation_cannot_be_performed_on_bigint_values_unless_the_target_option_is_set_to_es2016_or_later: diag(2791, ts2.DiagnosticCategory.Error, "Exponentiation_cannot_be_performed_on_bigint_values_unless_the_target_option_is_set_to_es2016_or_lat_2791", "Exponentiation cannot be performed on 'bigint' values unless the 'target' option is set to 'es2016' or later."),
        Cannot_find_module_0_Did_you_mean_to_set_the_moduleResolution_option_to_node_or_to_add_aliases_to_the_paths_option: diag(2792, ts2.DiagnosticCategory.Error, "Cannot_find_module_0_Did_you_mean_to_set_the_moduleResolution_option_to_node_or_to_add_aliases_to_th_2792", "Cannot find module '{0}'. Did you mean to set the 'moduleResolution' option to 'node', or to add aliases to the 'paths' option?"),
        The_call_would_have_succeeded_against_this_implementation_but_implementation_signatures_of_overloads_are_not_externally_visible: diag(2793, ts2.DiagnosticCategory.Error, "The_call_would_have_succeeded_against_this_implementation_but_implementation_signatures_of_overloads_2793", "The call would have succeeded against this implementation, but implementation signatures of overloads are not externally visible."),
        Expected_0_arguments_but_got_1_Did_you_forget_to_include_void_in_your_type_argument_to_Promise: diag(2794, ts2.DiagnosticCategory.Error, "Expected_0_arguments_but_got_1_Did_you_forget_to_include_void_in_your_type_argument_to_Promise_2794", "Expected {0} arguments, but got {1}. Did you forget to include 'void' in your type argument to 'Promise'?"),
        The_intrinsic_keyword_can_only_be_used_to_declare_compiler_provided_intrinsic_types: diag(2795, ts2.DiagnosticCategory.Error, "The_intrinsic_keyword_can_only_be_used_to_declare_compiler_provided_intrinsic_types_2795", "The 'intrinsic' keyword can only be used to declare compiler provided intrinsic types."),
        It_is_likely_that_you_are_missing_a_comma_to_separate_these_two_template_expressions_They_form_a_tagged_template_expression_which_cannot_be_invoked: diag(2796, ts2.DiagnosticCategory.Error, "It_is_likely_that_you_are_missing_a_comma_to_separate_these_two_template_expressions_They_form_a_tag_2796", "It is likely that you are missing a comma to separate these two template expressions. They form a tagged template expression which cannot be invoked."),
        A_mixin_class_that_extends_from_a_type_variable_containing_an_abstract_construct_signature_must_also_be_declared_abstract: diag(2797, ts2.DiagnosticCategory.Error, "A_mixin_class_that_extends_from_a_type_variable_containing_an_abstract_construct_signature_must_also_2797", "A mixin class that extends from a type variable containing an abstract construct signature must also be declared 'abstract'."),
        The_declaration_was_marked_as_deprecated_here: diag(2798, ts2.DiagnosticCategory.Error, "The_declaration_was_marked_as_deprecated_here_2798", "The declaration was marked as deprecated here."),
        Type_produces_a_tuple_type_that_is_too_large_to_represent: diag(2799, ts2.DiagnosticCategory.Error, "Type_produces_a_tuple_type_that_is_too_large_to_represent_2799", "Type produces a tuple type that is too large to represent."),
        Expression_produces_a_tuple_type_that_is_too_large_to_represent: diag(2800, ts2.DiagnosticCategory.Error, "Expression_produces_a_tuple_type_that_is_too_large_to_represent_2800", "Expression produces a tuple type that is too large to represent."),
        This_condition_will_always_return_true_since_this_0_is_always_defined: diag(2801, ts2.DiagnosticCategory.Error, "This_condition_will_always_return_true_since_this_0_is_always_defined_2801", "This condition will always return true since this '{0}' is always defined."),
        Type_0_can_only_be_iterated_through_when_using_the_downlevelIteration_flag_or_with_a_target_of_es2015_or_higher: diag(2802, ts2.DiagnosticCategory.Error, "Type_0_can_only_be_iterated_through_when_using_the_downlevelIteration_flag_or_with_a_target_of_es201_2802", "Type '{0}' can only be iterated through when using the '--downlevelIteration' flag or with a '--target' of 'es2015' or higher."),
        Cannot_assign_to_private_method_0_Private_methods_are_not_writable: diag(2803, ts2.DiagnosticCategory.Error, "Cannot_assign_to_private_method_0_Private_methods_are_not_writable_2803", "Cannot assign to private method '{0}'. Private methods are not writable."),
        Duplicate_identifier_0_Static_and_instance_elements_cannot_share_the_same_private_name: diag(2804, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Static_and_instance_elements_cannot_share_the_same_private_name_2804", "Duplicate identifier '{0}'. Static and instance elements cannot share the same private name."),
        Private_accessor_was_defined_without_a_getter: diag(2806, ts2.DiagnosticCategory.Error, "Private_accessor_was_defined_without_a_getter_2806", "Private accessor was defined without a getter."),
        This_syntax_requires_an_imported_helper_named_1_with_2_parameters_which_is_not_compatible_with_the_one_in_0_Consider_upgrading_your_version_of_0: diag(2807, ts2.DiagnosticCategory.Error, "This_syntax_requires_an_imported_helper_named_1_with_2_parameters_which_is_not_compatible_with_the_o_2807", "This syntax requires an imported helper named '{1}' with {2} parameters, which is not compatible with the one in '{0}'. Consider upgrading your version of '{0}'."),
        A_get_accessor_must_be_at_least_as_accessible_as_the_setter: diag(2808, ts2.DiagnosticCategory.Error, "A_get_accessor_must_be_at_least_as_accessible_as_the_setter_2808", "A get accessor must be at least as accessible as the setter"),
        Declaration_or_statement_expected_This_follows_a_block_of_statements_so_if_you_intended_to_write_a_destructuring_assignment_you_might_need_to_wrap_the_the_whole_assignment_in_parentheses: diag(2809, ts2.DiagnosticCategory.Error, "Declaration_or_statement_expected_This_follows_a_block_of_statements_so_if_you_intended_to_write_a_d_2809", "Declaration or statement expected. This '=' follows a block of statements, so if you intended to write a destructuring assignment, you might need to wrap the the whole assignment in parentheses."),
        Expected_1_argument_but_got_0_new_Promise_needs_a_JSDoc_hint_to_produce_a_resolve_that_can_be_called_without_arguments: diag(2810, ts2.DiagnosticCategory.Error, "Expected_1_argument_but_got_0_new_Promise_needs_a_JSDoc_hint_to_produce_a_resolve_that_can_be_called_2810", "Expected 1 argument, but got 0. 'new Promise()' needs a JSDoc hint to produce a 'resolve' that can be called without arguments."),
        Initializer_for_property_0: diag(2811, ts2.DiagnosticCategory.Error, "Initializer_for_property_0_2811", "Initializer for property '{0}'"),
        Property_0_does_not_exist_on_type_1_Try_changing_the_lib_compiler_option_to_include_dom: diag(2812, ts2.DiagnosticCategory.Error, "Property_0_does_not_exist_on_type_1_Try_changing_the_lib_compiler_option_to_include_dom_2812", "Property '{0}' does not exist on type '{1}'. Try changing the 'lib' compiler option to include 'dom'."),
        Class_declaration_cannot_implement_overload_list_for_0: diag(2813, ts2.DiagnosticCategory.Error, "Class_declaration_cannot_implement_overload_list_for_0_2813", "Class declaration cannot implement overload list for '{0}'."),
        Function_with_bodies_can_only_merge_with_classes_that_are_ambient: diag(2814, ts2.DiagnosticCategory.Error, "Function_with_bodies_can_only_merge_with_classes_that_are_ambient_2814", "Function with bodies can only merge with classes that are ambient."),
        arguments_cannot_be_referenced_in_property_initializers: diag(2815, ts2.DiagnosticCategory.Error, "arguments_cannot_be_referenced_in_property_initializers_2815", "'arguments' cannot be referenced in property initializers."),
        Cannot_use_this_in_a_static_property_initializer_of_a_decorated_class: diag(2816, ts2.DiagnosticCategory.Error, "Cannot_use_this_in_a_static_property_initializer_of_a_decorated_class_2816", "Cannot use 'this' in a static property initializer of a decorated class."),
        Property_0_has_no_initializer_and_is_not_definitely_assigned_in_a_class_static_block: diag(2817, ts2.DiagnosticCategory.Error, "Property_0_has_no_initializer_and_is_not_definitely_assigned_in_a_class_static_block_2817", "Property '{0}' has no initializer and is not definitely assigned in a class static block."),
        Duplicate_identifier_0_Compiler_reserves_name_1_when_emitting_super_references_in_static_initializers: diag(2818, ts2.DiagnosticCategory.Error, "Duplicate_identifier_0_Compiler_reserves_name_1_when_emitting_super_references_in_static_initializer_2818", "Duplicate identifier '{0}'. Compiler reserves name '{1}' when emitting 'super' references in static initializers."),
        Namespace_name_cannot_be_0: diag(2819, ts2.DiagnosticCategory.Error, "Namespace_name_cannot_be_0_2819", "Namespace name cannot be '{0}'."),
        Type_0_is_not_assignable_to_type_1_Did_you_mean_2: diag(2820, ts2.DiagnosticCategory.Error, "Type_0_is_not_assignable_to_type_1_Did_you_mean_2_2820", "Type '{0}' is not assignable to type '{1}'. Did you mean '{2}'?"),
        Import_assertions_are_only_supported_when_the_module_option_is_set_to_esnext_or_nodenext: diag(2821, ts2.DiagnosticCategory.Error, "Import_assertions_are_only_supported_when_the_module_option_is_set_to_esnext_or_nodenext_2821", "Import assertions are only supported when the '--module' option is set to 'esnext' or 'nodenext'."),
        Import_assertions_cannot_be_used_with_type_only_imports_or_exports: diag(2822, ts2.DiagnosticCategory.Error, "Import_assertions_cannot_be_used_with_type_only_imports_or_exports_2822", "Import assertions cannot be used with type-only imports or exports."),
        Cannot_find_namespace_0_Did_you_mean_1: diag(2833, ts2.DiagnosticCategory.Error, "Cannot_find_namespace_0_Did_you_mean_1_2833", "Cannot find namespace '{0}'. Did you mean '{1}'?"),
        Relative_import_paths_need_explicit_file_extensions_in_EcmaScript_imports_when_moduleResolution_is_node16_or_nodenext_Consider_adding_an_extension_to_the_import_path: diag(2834, ts2.DiagnosticCategory.Error, "Relative_import_paths_need_explicit_file_extensions_in_EcmaScript_imports_when_moduleResolution_is_n_2834", "Relative import paths need explicit file extensions in EcmaScript imports when '--moduleResolution' is 'node16' or 'nodenext'. Consider adding an extension to the import path."),
        Relative_import_paths_need_explicit_file_extensions_in_EcmaScript_imports_when_moduleResolution_is_node16_or_nodenext_Did_you_mean_0: diag(2835, ts2.DiagnosticCategory.Error, "Relative_import_paths_need_explicit_file_extensions_in_EcmaScript_imports_when_moduleResolution_is_n_2835", "Relative import paths need explicit file extensions in EcmaScript imports when '--moduleResolution' is 'node16' or 'nodenext'. Did you mean '{0}'?"),
        Import_assertions_are_not_allowed_on_statements_that_transpile_to_commonjs_require_calls: diag(2836, ts2.DiagnosticCategory.Error, "Import_assertions_are_not_allowed_on_statements_that_transpile_to_commonjs_require_calls_2836", "Import assertions are not allowed on statements that transpile to commonjs 'require' calls."),
        Import_assertion_values_must_be_string_literal_expressions: diag(2837, ts2.DiagnosticCategory.Error, "Import_assertion_values_must_be_string_literal_expressions_2837", "Import assertion values must be string literal expressions."),
        All_declarations_of_0_must_have_identical_constraints: diag(2838, ts2.DiagnosticCategory.Error, "All_declarations_of_0_must_have_identical_constraints_2838", "All declarations of '{0}' must have identical constraints."),
        This_condition_will_always_return_0_since_JavaScript_compares_objects_by_reference_not_value: diag(2839, ts2.DiagnosticCategory.Error, "This_condition_will_always_return_0_since_JavaScript_compares_objects_by_reference_not_value_2839", "This condition will always return '{0}' since JavaScript compares objects by reference, not value."),
        An_interface_cannot_extend_a_primitive_type_like_0_an_interface_can_only_extend_named_types_and_classes: diag(2840, ts2.DiagnosticCategory.Error, "An_interface_cannot_extend_a_primitive_type_like_0_an_interface_can_only_extend_named_types_and_clas_2840", "An interface cannot extend a primitive type like '{0}'; an interface can only extend named types and classes"),
        The_type_of_this_expression_cannot_be_named_without_a_resolution_mode_assertion_which_is_an_unstable_feature_Use_nightly_TypeScript_to_silence_this_error_Try_updating_with_npm_install_D_typescript_next: diag(2841, ts2.DiagnosticCategory.Error, "The_type_of_this_expression_cannot_be_named_without_a_resolution_mode_assertion_which_is_an_unstable_2841", "The type of this expression cannot be named without a 'resolution-mode' assertion, which is an unstable feature. Use nightly TypeScript to silence this error. Try updating with 'npm install -D typescript@next'."),
        _0_is_an_unused_renaming_of_1_Did_you_intend_to_use_it_as_a_type_annotation: diag(2842, ts2.DiagnosticCategory.Error, "_0_is_an_unused_renaming_of_1_Did_you_intend_to_use_it_as_a_type_annotation_2842", "'{0}' is an unused renaming of '{1}'. Did you intend to use it as a type annotation?"),
        We_can_only_write_a_type_for_0_by_adding_a_type_for_the_entire_parameter_here: diag(2843, ts2.DiagnosticCategory.Error, "We_can_only_write_a_type_for_0_by_adding_a_type_for_the_entire_parameter_here_2843", "We can only write a type for '{0}' by adding a type for the entire parameter here."),
        Type_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor: diag(2844, ts2.DiagnosticCategory.Error, "Type_of_instance_member_variable_0_cannot_reference_identifier_1_declared_in_the_constructor_2844", "Type of instance member variable '{0}' cannot reference identifier '{1}' declared in the constructor."),
        Import_declaration_0_is_using_private_name_1: diag(4e3, ts2.DiagnosticCategory.Error, "Import_declaration_0_is_using_private_name_1_4000", "Import declaration '{0}' is using private name '{1}'."),
        Type_parameter_0_of_exported_class_has_or_is_using_private_name_1: diag(4002, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_class_has_or_is_using_private_name_1_4002", "Type parameter '{0}' of exported class has or is using private name '{1}'."),
        Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1: diag(4004, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_interface_has_or_is_using_private_name_1_4004", "Type parameter '{0}' of exported interface has or is using private name '{1}'."),
        Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4006, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4006", "Type parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),
        Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4008, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4008", "Type parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),
        Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: diag(4010, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4010", "Type parameter '{0}' of public static method from exported class has or is using private name '{1}'."),
        Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: diag(4012, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4012", "Type parameter '{0}' of public method from exported class has or is using private name '{1}'."),
        Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: diag(4014, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4014", "Type parameter '{0}' of method from exported interface has or is using private name '{1}'."),
        Type_parameter_0_of_exported_function_has_or_is_using_private_name_1: diag(4016, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_function_has_or_is_using_private_name_1_4016", "Type parameter '{0}' of exported function has or is using private name '{1}'."),
        Implements_clause_of_exported_class_0_has_or_is_using_private_name_1: diag(4019, ts2.DiagnosticCategory.Error, "Implements_clause_of_exported_class_0_has_or_is_using_private_name_1_4019", "Implements clause of exported class '{0}' has or is using private name '{1}'."),
        extends_clause_of_exported_class_0_has_or_is_using_private_name_1: diag(4020, ts2.DiagnosticCategory.Error, "extends_clause_of_exported_class_0_has_or_is_using_private_name_1_4020", "'extends' clause of exported class '{0}' has or is using private name '{1}'."),
        extends_clause_of_exported_class_has_or_is_using_private_name_0: diag(4021, ts2.DiagnosticCategory.Error, "extends_clause_of_exported_class_has_or_is_using_private_name_0_4021", "'extends' clause of exported class has or is using private name '{0}'."),
        extends_clause_of_exported_interface_0_has_or_is_using_private_name_1: diag(4022, ts2.DiagnosticCategory.Error, "extends_clause_of_exported_interface_0_has_or_is_using_private_name_1_4022", "'extends' clause of exported interface '{0}' has or is using private name '{1}'."),
        Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4023, ts2.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4023", "Exported variable '{0}' has or is using name '{1}' from external module {2} but cannot be named."),
        Exported_variable_0_has_or_is_using_name_1_from_private_module_2: diag(4024, ts2.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_name_1_from_private_module_2_4024", "Exported variable '{0}' has or is using name '{1}' from private module '{2}'."),
        Exported_variable_0_has_or_is_using_private_name_1: diag(4025, ts2.DiagnosticCategory.Error, "Exported_variable_0_has_or_is_using_private_name_1_4025", "Exported variable '{0}' has or is using private name '{1}'."),
        Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4026, ts2.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot__4026", "Public static property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4027, ts2.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4027", "Public static property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
        Public_static_property_0_of_exported_class_has_or_is_using_private_name_1: diag(4028, ts2.DiagnosticCategory.Error, "Public_static_property_0_of_exported_class_has_or_is_using_private_name_1_4028", "Public static property '{0}' of exported class has or is using private name '{1}'."),
        Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4029, ts2.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_name_4029", "Public property '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4030, ts2.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4030", "Public property '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
        Public_property_0_of_exported_class_has_or_is_using_private_name_1: diag(4031, ts2.DiagnosticCategory.Error, "Public_property_0_of_exported_class_has_or_is_using_private_name_1_4031", "Public property '{0}' of exported class has or is using private name '{1}'."),
        Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4032, ts2.DiagnosticCategory.Error, "Property_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4032", "Property '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),
        Property_0_of_exported_interface_has_or_is_using_private_name_1: diag(4033, ts2.DiagnosticCategory.Error, "Property_0_of_exported_interface_has_or_is_using_private_name_1_4033", "Property '{0}' of exported interface has or is using private name '{1}'."),
        Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4034, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_name_1_from_private_mod_4034", "Parameter type of public static setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
        Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1: diag(4035, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_static_setter_0_from_exported_class_has_or_is_using_private_name_1_4035", "Parameter type of public static setter '{0}' from exported class has or is using private name '{1}'."),
        Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4036, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4036", "Parameter type of public setter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
        Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1: diag(4037, ts2.DiagnosticCategory.Error, "Parameter_type_of_public_setter_0_from_exported_class_has_or_is_using_private_name_1_4037", "Parameter type of public setter '{0}' from exported class has or is using private name '{1}'."),
        Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4038, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_external_modul_4038", "Return type of public static getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4039, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_4039", "Return type of public static getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
        Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1: diag(4040, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_getter_0_from_exported_class_has_or_is_using_private_name_1_4040", "Return type of public static getter '{0}' from exported class has or is using private name '{1}'."),
        Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4041, ts2.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_4041", "Return type of public getter '{0}' from exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4042, ts2.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_name_1_from_private_module_2_4042", "Return type of public getter '{0}' from exported class has or is using name '{1}' from private module '{2}'."),
        Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1: diag(4043, ts2.DiagnosticCategory.Error, "Return_type_of_public_getter_0_from_exported_class_has_or_is_using_private_name_1_4043", "Return type of public getter '{0}' from exported class has or is using private name '{1}'."),
        Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4044, ts2.DiagnosticCategory.Error, "Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_name_0_from_private_mod_4044", "Return type of constructor signature from exported interface has or is using name '{0}' from private module '{1}'."),
        Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4045, ts2.DiagnosticCategory.Error, "Return_type_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_0_4045", "Return type of constructor signature from exported interface has or is using private name '{0}'."),
        Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4046, ts2.DiagnosticCategory.Error, "Return_type_of_call_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4046", "Return type of call signature from exported interface has or is using name '{0}' from private module '{1}'."),
        Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4047, ts2.DiagnosticCategory.Error, "Return_type_of_call_signature_from_exported_interface_has_or_is_using_private_name_0_4047", "Return type of call signature from exported interface has or is using private name '{0}'."),
        Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4048, ts2.DiagnosticCategory.Error, "Return_type_of_index_signature_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4048", "Return type of index signature from exported interface has or is using name '{0}' from private module '{1}'."),
        Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0: diag(4049, ts2.DiagnosticCategory.Error, "Return_type_of_index_signature_from_exported_interface_has_or_is_using_private_name_0_4049", "Return type of index signature from exported interface has or is using private name '{0}'."),
        Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4050, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_external_module__4050", "Return type of public static method from exported class has or is using name '{0}' from external module {1} but cannot be named."),
        Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: diag(4051, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4051", "Return type of public static method from exported class has or is using name '{0}' from private module '{1}'."),
        Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0: diag(4052, ts2.DiagnosticCategory.Error, "Return_type_of_public_static_method_from_exported_class_has_or_is_using_private_name_0_4052", "Return type of public static method from exported class has or is using private name '{0}'."),
        Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4053, ts2.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_external_module_1_but_c_4053", "Return type of public method from exported class has or is using name '{0}' from external module {1} but cannot be named."),
        Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1: diag(4054, ts2.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_name_0_from_private_module_1_4054", "Return type of public method from exported class has or is using name '{0}' from private module '{1}'."),
        Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0: diag(4055, ts2.DiagnosticCategory.Error, "Return_type_of_public_method_from_exported_class_has_or_is_using_private_name_0_4055", "Return type of public method from exported class has or is using private name '{0}'."),
        Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1: diag(4056, ts2.DiagnosticCategory.Error, "Return_type_of_method_from_exported_interface_has_or_is_using_name_0_from_private_module_1_4056", "Return type of method from exported interface has or is using name '{0}' from private module '{1}'."),
        Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0: diag(4057, ts2.DiagnosticCategory.Error, "Return_type_of_method_from_exported_interface_has_or_is_using_private_name_0_4057", "Return type of method from exported interface has or is using private name '{0}'."),
        Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named: diag(4058, ts2.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_name_0_from_external_module_1_but_cannot_be_named_4058", "Return type of exported function has or is using name '{0}' from external module {1} but cannot be named."),
        Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1: diag(4059, ts2.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_name_0_from_private_module_1_4059", "Return type of exported function has or is using name '{0}' from private module '{1}'."),
        Return_type_of_exported_function_has_or_is_using_private_name_0: diag(4060, ts2.DiagnosticCategory.Error, "Return_type_of_exported_function_has_or_is_using_private_name_0_4060", "Return type of exported function has or is using private name '{0}'."),
        Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4061, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_can_4061", "Parameter '{0}' of constructor from exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4062, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_name_1_from_private_module_2_4062", "Parameter '{0}' of constructor from exported class has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1: diag(4063, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_from_exported_class_has_or_is_using_private_name_1_4063", "Parameter '{0}' of constructor from exported class has or is using private name '{1}'."),
        Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4064, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_name_1_from_private_mod_4064", "Parameter '{0}' of constructor signature from exported interface has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4065, ts2.DiagnosticCategory.Error, "Parameter_0_of_constructor_signature_from_exported_interface_has_or_is_using_private_name_1_4065", "Parameter '{0}' of constructor signature from exported interface has or is using private name '{1}'."),
        Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4066, ts2.DiagnosticCategory.Error, "Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4066", "Parameter '{0}' of call signature from exported interface has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4067, ts2.DiagnosticCategory.Error, "Parameter_0_of_call_signature_from_exported_interface_has_or_is_using_private_name_1_4067", "Parameter '{0}' of call signature from exported interface has or is using private name '{1}'."),
        Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4068, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_external_module__4068", "Parameter '{0}' of public static method from exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4069, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4069", "Parameter '{0}' of public static method from exported class has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1: diag(4070, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_static_method_from_exported_class_has_or_is_using_private_name_1_4070", "Parameter '{0}' of public static method from exported class has or is using private name '{1}'."),
        Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4071, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_external_module_2_but_c_4071", "Parameter '{0}' of public method from exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4072, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_name_1_from_private_module_2_4072", "Parameter '{0}' of public method from exported class has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1: diag(4073, ts2.DiagnosticCategory.Error, "Parameter_0_of_public_method_from_exported_class_has_or_is_using_private_name_1_4073", "Parameter '{0}' of public method from exported class has or is using private name '{1}'."),
        Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4074, ts2.DiagnosticCategory.Error, "Parameter_0_of_method_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4074", "Parameter '{0}' of method from exported interface has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1: diag(4075, ts2.DiagnosticCategory.Error, "Parameter_0_of_method_from_exported_interface_has_or_is_using_private_name_1_4075", "Parameter '{0}' of method from exported interface has or is using private name '{1}'."),
        Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4076, ts2.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4076", "Parameter '{0}' of exported function has or is using name '{1}' from external module {2} but cannot be named."),
        Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2: diag(4077, ts2.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_name_1_from_private_module_2_4077", "Parameter '{0}' of exported function has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_exported_function_has_or_is_using_private_name_1: diag(4078, ts2.DiagnosticCategory.Error, "Parameter_0_of_exported_function_has_or_is_using_private_name_1_4078", "Parameter '{0}' of exported function has or is using private name '{1}'."),
        Exported_type_alias_0_has_or_is_using_private_name_1: diag(4081, ts2.DiagnosticCategory.Error, "Exported_type_alias_0_has_or_is_using_private_name_1_4081", "Exported type alias '{0}' has or is using private name '{1}'."),
        Default_export_of_the_module_has_or_is_using_private_name_0: diag(4082, ts2.DiagnosticCategory.Error, "Default_export_of_the_module_has_or_is_using_private_name_0_4082", "Default export of the module has or is using private name '{0}'."),
        Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1: diag(4083, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_type_alias_has_or_is_using_private_name_1_4083", "Type parameter '{0}' of exported type alias has or is using private name '{1}'."),
        Exported_type_alias_0_has_or_is_using_private_name_1_from_module_2: diag(4084, ts2.DiagnosticCategory.Error, "Exported_type_alias_0_has_or_is_using_private_name_1_from_module_2_4084", "Exported type alias '{0}' has or is using private name '{1}' from module {2}."),
        Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_library_to_resolve_the_conflict: diag(4090, ts2.DiagnosticCategory.Error, "Conflicting_definitions_for_0_found_at_1_and_2_Consider_installing_a_specific_version_of_this_librar_4090", "Conflicting definitions for '{0}' found at '{1}' and '{2}'. Consider installing a specific version of this library to resolve the conflict."),
        Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4091, ts2.DiagnosticCategory.Error, "Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_name_1_from_private_module_2_4091", "Parameter '{0}' of index signature from exported interface has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1: diag(4092, ts2.DiagnosticCategory.Error, "Parameter_0_of_index_signature_from_exported_interface_has_or_is_using_private_name_1_4092", "Parameter '{0}' of index signature from exported interface has or is using private name '{1}'."),
        Property_0_of_exported_class_expression_may_not_be_private_or_protected: diag(4094, ts2.DiagnosticCategory.Error, "Property_0_of_exported_class_expression_may_not_be_private_or_protected_4094", "Property '{0}' of exported class expression may not be private or protected."),
        Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4095, ts2.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_4095", "Public static method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4096, ts2.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4096", "Public static method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
        Public_static_method_0_of_exported_class_has_or_is_using_private_name_1: diag(4097, ts2.DiagnosticCategory.Error, "Public_static_method_0_of_exported_class_has_or_is_using_private_name_1_4097", "Public static method '{0}' of exported class has or is using private name '{1}'."),
        Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4098, ts2.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4098", "Public method '{0}' of exported class has or is using name '{1}' from external module {2} but cannot be named."),
        Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2: diag(4099, ts2.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_name_1_from_private_module_2_4099", "Public method '{0}' of exported class has or is using name '{1}' from private module '{2}'."),
        Public_method_0_of_exported_class_has_or_is_using_private_name_1: diag(4100, ts2.DiagnosticCategory.Error, "Public_method_0_of_exported_class_has_or_is_using_private_name_1_4100", "Public method '{0}' of exported class has or is using private name '{1}'."),
        Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2: diag(4101, ts2.DiagnosticCategory.Error, "Method_0_of_exported_interface_has_or_is_using_name_1_from_private_module_2_4101", "Method '{0}' of exported interface has or is using name '{1}' from private module '{2}'."),
        Method_0_of_exported_interface_has_or_is_using_private_name_1: diag(4102, ts2.DiagnosticCategory.Error, "Method_0_of_exported_interface_has_or_is_using_private_name_1_4102", "Method '{0}' of exported interface has or is using private name '{1}'."),
        Type_parameter_0_of_exported_mapped_object_type_is_using_private_name_1: diag(4103, ts2.DiagnosticCategory.Error, "Type_parameter_0_of_exported_mapped_object_type_is_using_private_name_1_4103", "Type parameter '{0}' of exported mapped object type is using private name '{1}'."),
        The_type_0_is_readonly_and_cannot_be_assigned_to_the_mutable_type_1: diag(4104, ts2.DiagnosticCategory.Error, "The_type_0_is_readonly_and_cannot_be_assigned_to_the_mutable_type_1_4104", "The type '{0}' is 'readonly' and cannot be assigned to the mutable type '{1}'."),
        Private_or_protected_member_0_cannot_be_accessed_on_a_type_parameter: diag(4105, ts2.DiagnosticCategory.Error, "Private_or_protected_member_0_cannot_be_accessed_on_a_type_parameter_4105", "Private or protected member '{0}' cannot be accessed on a type parameter."),
        Parameter_0_of_accessor_has_or_is_using_private_name_1: diag(4106, ts2.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_private_name_1_4106", "Parameter '{0}' of accessor has or is using private name '{1}'."),
        Parameter_0_of_accessor_has_or_is_using_name_1_from_private_module_2: diag(4107, ts2.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_name_1_from_private_module_2_4107", "Parameter '{0}' of accessor has or is using name '{1}' from private module '{2}'."),
        Parameter_0_of_accessor_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named: diag(4108, ts2.DiagnosticCategory.Error, "Parameter_0_of_accessor_has_or_is_using_name_1_from_external_module_2_but_cannot_be_named_4108", "Parameter '{0}' of accessor has or is using name '{1}' from external module '{2}' but cannot be named."),
        Type_arguments_for_0_circularly_reference_themselves: diag(4109, ts2.DiagnosticCategory.Error, "Type_arguments_for_0_circularly_reference_themselves_4109", "Type arguments for '{0}' circularly reference themselves."),
        Tuple_type_arguments_circularly_reference_themselves: diag(4110, ts2.DiagnosticCategory.Error, "Tuple_type_arguments_circularly_reference_themselves_4110", "Tuple type arguments circularly reference themselves."),
        Property_0_comes_from_an_index_signature_so_it_must_be_accessed_with_0: diag(4111, ts2.DiagnosticCategory.Error, "Property_0_comes_from_an_index_signature_so_it_must_be_accessed_with_0_4111", "Property '{0}' comes from an index signature, so it must be accessed with ['{0}']."),
        This_member_cannot_have_an_override_modifier_because_its_containing_class_0_does_not_extend_another_class: diag(4112, ts2.DiagnosticCategory.Error, "This_member_cannot_have_an_override_modifier_because_its_containing_class_0_does_not_extend_another__4112", "This member cannot have an 'override' modifier because its containing class '{0}' does not extend another class."),
        This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0: diag(4113, ts2.DiagnosticCategory.Error, "This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0_4113", "This member cannot have an 'override' modifier because it is not declared in the base class '{0}'."),
        This_member_must_have_an_override_modifier_because_it_overrides_a_member_in_the_base_class_0: diag(4114, ts2.DiagnosticCategory.Error, "This_member_must_have_an_override_modifier_because_it_overrides_a_member_in_the_base_class_0_4114", "This member must have an 'override' modifier because it overrides a member in the base class '{0}'."),
        This_parameter_property_must_have_an_override_modifier_because_it_overrides_a_member_in_base_class_0: diag(4115, ts2.DiagnosticCategory.Error, "This_parameter_property_must_have_an_override_modifier_because_it_overrides_a_member_in_base_class_0_4115", "This parameter property must have an 'override' modifier because it overrides a member in base class '{0}'."),
        This_member_must_have_an_override_modifier_because_it_overrides_an_abstract_method_that_is_declared_in_the_base_class_0: diag(4116, ts2.DiagnosticCategory.Error, "This_member_must_have_an_override_modifier_because_it_overrides_an_abstract_method_that_is_declared__4116", "This member must have an 'override' modifier because it overrides an abstract method that is declared in the base class '{0}'."),
        This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0_Did_you_mean_1: diag(4117, ts2.DiagnosticCategory.Error, "This_member_cannot_have_an_override_modifier_because_it_is_not_declared_in_the_base_class_0_Did_you__4117", "This member cannot have an 'override' modifier because it is not declared in the base class '{0}'. Did you mean '{1}'?"),
        The_type_of_this_node_cannot_be_serialized_because_its_property_0_cannot_be_serialized: diag(4118, ts2.DiagnosticCategory.Error, "The_type_of_this_node_cannot_be_serialized_because_its_property_0_cannot_be_serialized_4118", "The type of this node cannot be serialized because its property '{0}' cannot be serialized."),
        This_member_must_have_a_JSDoc_comment_with_an_override_tag_because_it_overrides_a_member_in_the_base_class_0: diag(4119, ts2.DiagnosticCategory.Error, "This_member_must_have_a_JSDoc_comment_with_an_override_tag_because_it_overrides_a_member_in_the_base_4119", "This member must have a JSDoc comment with an '@override' tag because it overrides a member in the base class '{0}'."),
        This_parameter_property_must_have_a_JSDoc_comment_with_an_override_tag_because_it_overrides_a_member_in_the_base_class_0: diag(4120, ts2.DiagnosticCategory.Error, "This_parameter_property_must_have_a_JSDoc_comment_with_an_override_tag_because_it_overrides_a_member_4120", "This parameter property must have a JSDoc comment with an '@override' tag because it overrides a member in the base class '{0}'."),
        This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_its_containing_class_0_does_not_extend_another_class: diag(4121, ts2.DiagnosticCategory.Error, "This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_its_containing_class_0_does_not_4121", "This member cannot have a JSDoc comment with an '@override' tag because its containing class '{0}' does not extend another class."),
        This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_it_is_not_declared_in_the_base_class_0: diag(4122, ts2.DiagnosticCategory.Error, "This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_it_is_not_declared_in_the_base__4122", "This member cannot have a JSDoc comment with an '@override' tag because it is not declared in the base class '{0}'."),
        This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_it_is_not_declared_in_the_base_class_0_Did_you_mean_1: diag(4123, ts2.DiagnosticCategory.Error, "This_member_cannot_have_a_JSDoc_comment_with_an_override_tag_because_it_is_not_declared_in_the_base__4123", "This member cannot have a JSDoc comment with an 'override' tag because it is not declared in the base class '{0}'. Did you mean '{1}'?"),
        Compiler_option_0_of_value_1_is_unstable_Use_nightly_TypeScript_to_silence_this_error_Try_updating_with_npm_install_D_typescript_next: diag(4124, ts2.DiagnosticCategory.Error, "Compiler_option_0_of_value_1_is_unstable_Use_nightly_TypeScript_to_silence_this_error_Try_updating_w_4124", "Compiler option '{0}' of value '{1}' is unstable. Use nightly TypeScript to silence this error. Try updating with 'npm install -D typescript@next'."),
        resolution_mode_assertions_are_unstable_Use_nightly_TypeScript_to_silence_this_error_Try_updating_with_npm_install_D_typescript_next: diag(4125, ts2.DiagnosticCategory.Error, "resolution_mode_assertions_are_unstable_Use_nightly_TypeScript_to_silence_this_error_Try_updating_wi_4125", "'resolution-mode' assertions are unstable. Use nightly TypeScript to silence this error. Try updating with 'npm install -D typescript@next'."),
        The_current_host_does_not_support_the_0_option: diag(5001, ts2.DiagnosticCategory.Error, "The_current_host_does_not_support_the_0_option_5001", "The current host does not support the '{0}' option."),
        Cannot_find_the_common_subdirectory_path_for_the_input_files: diag(5009, ts2.DiagnosticCategory.Error, "Cannot_find_the_common_subdirectory_path_for_the_input_files_5009", "Cannot find the common subdirectory path for the input files."),
        File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0: diag(5010, ts2.DiagnosticCategory.Error, "File_specification_cannot_end_in_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0_5010", "File specification cannot end in a recursive directory wildcard ('**'): '{0}'."),
        Cannot_read_file_0_Colon_1: diag(5012, ts2.DiagnosticCategory.Error, "Cannot_read_file_0_Colon_1_5012", "Cannot read file '{0}': {1}."),
        Failed_to_parse_file_0_Colon_1: diag(5014, ts2.DiagnosticCategory.Error, "Failed_to_parse_file_0_Colon_1_5014", "Failed to parse file '{0}': {1}."),
        Unknown_compiler_option_0: diag(5023, ts2.DiagnosticCategory.Error, "Unknown_compiler_option_0_5023", "Unknown compiler option '{0}'."),
        Compiler_option_0_requires_a_value_of_type_1: diag(5024, ts2.DiagnosticCategory.Error, "Compiler_option_0_requires_a_value_of_type_1_5024", "Compiler option '{0}' requires a value of type {1}."),
        Unknown_compiler_option_0_Did_you_mean_1: diag(5025, ts2.DiagnosticCategory.Error, "Unknown_compiler_option_0_Did_you_mean_1_5025", "Unknown compiler option '{0}'. Did you mean '{1}'?"),
        Could_not_write_file_0_Colon_1: diag(5033, ts2.DiagnosticCategory.Error, "Could_not_write_file_0_Colon_1_5033", "Could not write file '{0}': {1}."),
        Option_project_cannot_be_mixed_with_source_files_on_a_command_line: diag(5042, ts2.DiagnosticCategory.Error, "Option_project_cannot_be_mixed_with_source_files_on_a_command_line_5042", "Option 'project' cannot be mixed with source files on a command line."),
        Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES2015_or_higher: diag(5047, ts2.DiagnosticCategory.Error, "Option_isolatedModules_can_only_be_used_when_either_option_module_is_provided_or_option_target_is_ES_5047", "Option 'isolatedModules' can only be used when either option '--module' is provided or option 'target' is 'ES2015' or higher."),
        Option_0_cannot_be_specified_when_option_target_is_ES3: diag(5048, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_when_option_target_is_ES3_5048", "Option '{0}' cannot be specified when option 'target' is 'ES3'."),
        Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided: diag(5051, ts2.DiagnosticCategory.Error, "Option_0_can_only_be_used_when_either_option_inlineSourceMap_or_option_sourceMap_is_provided_5051", "Option '{0} can only be used when either option '--inlineSourceMap' or option '--sourceMap' is provided."),
        Option_0_cannot_be_specified_without_specifying_option_1: diag(5052, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_without_specifying_option_1_5052", "Option '{0}' cannot be specified without specifying option '{1}'."),
        Option_0_cannot_be_specified_with_option_1: diag(5053, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_with_option_1_5053", "Option '{0}' cannot be specified with option '{1}'."),
        A_tsconfig_json_file_is_already_defined_at_Colon_0: diag(5054, ts2.DiagnosticCategory.Error, "A_tsconfig_json_file_is_already_defined_at_Colon_0_5054", "A 'tsconfig.json' file is already defined at: '{0}'."),
        Cannot_write_file_0_because_it_would_overwrite_input_file: diag(5055, ts2.DiagnosticCategory.Error, "Cannot_write_file_0_because_it_would_overwrite_input_file_5055", "Cannot write file '{0}' because it would overwrite input file."),
        Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files: diag(5056, ts2.DiagnosticCategory.Error, "Cannot_write_file_0_because_it_would_be_overwritten_by_multiple_input_files_5056", "Cannot write file '{0}' because it would be overwritten by multiple input files."),
        Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0: diag(5057, ts2.DiagnosticCategory.Error, "Cannot_find_a_tsconfig_json_file_at_the_specified_directory_Colon_0_5057", "Cannot find a tsconfig.json file at the specified directory: '{0}'."),
        The_specified_path_does_not_exist_Colon_0: diag(5058, ts2.DiagnosticCategory.Error, "The_specified_path_does_not_exist_Colon_0_5058", "The specified path does not exist: '{0}'."),
        Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier: diag(5059, ts2.DiagnosticCategory.Error, "Invalid_value_for_reactNamespace_0_is_not_a_valid_identifier_5059", "Invalid value for '--reactNamespace'. '{0}' is not a valid identifier."),
        Pattern_0_can_have_at_most_one_Asterisk_character: diag(5061, ts2.DiagnosticCategory.Error, "Pattern_0_can_have_at_most_one_Asterisk_character_5061", "Pattern '{0}' can have at most one '*' character."),
        Substitution_0_in_pattern_1_can_have_at_most_one_Asterisk_character: diag(5062, ts2.DiagnosticCategory.Error, "Substitution_0_in_pattern_1_can_have_at_most_one_Asterisk_character_5062", "Substitution '{0}' in pattern '{1}' can have at most one '*' character."),
        Substitutions_for_pattern_0_should_be_an_array: diag(5063, ts2.DiagnosticCategory.Error, "Substitutions_for_pattern_0_should_be_an_array_5063", "Substitutions for pattern '{0}' should be an array."),
        Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2: diag(5064, ts2.DiagnosticCategory.Error, "Substitution_0_for_pattern_1_has_incorrect_type_expected_string_got_2_5064", "Substitution '{0}' for pattern '{1}' has incorrect type, expected 'string', got '{2}'."),
        File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildcard_Asterisk_Asterisk_Colon_0: diag(5065, ts2.DiagnosticCategory.Error, "File_specification_cannot_contain_a_parent_directory_that_appears_after_a_recursive_directory_wildca_5065", "File specification cannot contain a parent directory ('..') that appears after a recursive directory wildcard ('**'): '{0}'."),
        Substitutions_for_pattern_0_shouldn_t_be_an_empty_array: diag(5066, ts2.DiagnosticCategory.Error, "Substitutions_for_pattern_0_shouldn_t_be_an_empty_array_5066", "Substitutions for pattern '{0}' shouldn't be an empty array."),
        Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name: diag(5067, ts2.DiagnosticCategory.Error, "Invalid_value_for_jsxFactory_0_is_not_a_valid_identifier_or_qualified_name_5067", "Invalid value for 'jsxFactory'. '{0}' is not a valid identifier or qualified-name."),
        Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript_files_Learn_more_at_https_Colon_Slash_Slashaka_ms_Slashtsconfig: diag(5068, ts2.DiagnosticCategory.Error, "Adding_a_tsconfig_json_file_will_help_organize_projects_that_contain_both_TypeScript_and_JavaScript__5068", "Adding a tsconfig.json file will help organize projects that contain both TypeScript and JavaScript files. Learn more at https://aka.ms/tsconfig."),
        Option_0_cannot_be_specified_without_specifying_option_1_or_option_2: diag(5069, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_without_specifying_option_1_or_option_2_5069", "Option '{0}' cannot be specified without specifying option '{1}' or option '{2}'."),
        Option_resolveJsonModule_cannot_be_specified_without_node_module_resolution_strategy: diag(5070, ts2.DiagnosticCategory.Error, "Option_resolveJsonModule_cannot_be_specified_without_node_module_resolution_strategy_5070", "Option '--resolveJsonModule' cannot be specified without 'node' module resolution strategy."),
        Option_resolveJsonModule_can_only_be_specified_when_module_code_generation_is_commonjs_amd_es2015_or_esNext: diag(5071, ts2.DiagnosticCategory.Error, "Option_resolveJsonModule_can_only_be_specified_when_module_code_generation_is_commonjs_amd_es2015_or_5071", "Option '--resolveJsonModule' can only be specified when module code generation is 'commonjs', 'amd', 'es2015' or 'esNext'."),
        Unknown_build_option_0: diag(5072, ts2.DiagnosticCategory.Error, "Unknown_build_option_0_5072", "Unknown build option '{0}'."),
        Build_option_0_requires_a_value_of_type_1: diag(5073, ts2.DiagnosticCategory.Error, "Build_option_0_requires_a_value_of_type_1_5073", "Build option '{0}' requires a value of type {1}."),
        Option_incremental_can_only_be_specified_using_tsconfig_emitting_to_single_file_or_when_option_tsBuildInfoFile_is_specified: diag(5074, ts2.DiagnosticCategory.Error, "Option_incremental_can_only_be_specified_using_tsconfig_emitting_to_single_file_or_when_option_tsBui_5074", "Option '--incremental' can only be specified using tsconfig, emitting to single file or when option '--tsBuildInfoFile' is specified."),
        _0_is_assignable_to_the_constraint_of_type_1_but_1_could_be_instantiated_with_a_different_subtype_of_constraint_2: diag(5075, ts2.DiagnosticCategory.Error, "_0_is_assignable_to_the_constraint_of_type_1_but_1_could_be_instantiated_with_a_different_subtype_of_5075", "'{0}' is assignable to the constraint of type '{1}', but '{1}' could be instantiated with a different subtype of constraint '{2}'."),
        _0_and_1_operations_cannot_be_mixed_without_parentheses: diag(5076, ts2.DiagnosticCategory.Error, "_0_and_1_operations_cannot_be_mixed_without_parentheses_5076", "'{0}' and '{1}' operations cannot be mixed without parentheses."),
        Unknown_build_option_0_Did_you_mean_1: diag(5077, ts2.DiagnosticCategory.Error, "Unknown_build_option_0_Did_you_mean_1_5077", "Unknown build option '{0}'. Did you mean '{1}'?"),
        Unknown_watch_option_0: diag(5078, ts2.DiagnosticCategory.Error, "Unknown_watch_option_0_5078", "Unknown watch option '{0}'."),
        Unknown_watch_option_0_Did_you_mean_1: diag(5079, ts2.DiagnosticCategory.Error, "Unknown_watch_option_0_Did_you_mean_1_5079", "Unknown watch option '{0}'. Did you mean '{1}'?"),
        Watch_option_0_requires_a_value_of_type_1: diag(5080, ts2.DiagnosticCategory.Error, "Watch_option_0_requires_a_value_of_type_1_5080", "Watch option '{0}' requires a value of type {1}."),
        Cannot_find_a_tsconfig_json_file_at_the_current_directory_Colon_0: diag(5081, ts2.DiagnosticCategory.Error, "Cannot_find_a_tsconfig_json_file_at_the_current_directory_Colon_0_5081", "Cannot find a tsconfig.json file at the current directory: {0}."),
        _0_could_be_instantiated_with_an_arbitrary_type_which_could_be_unrelated_to_1: diag(5082, ts2.DiagnosticCategory.Error, "_0_could_be_instantiated_with_an_arbitrary_type_which_could_be_unrelated_to_1_5082", "'{0}' could be instantiated with an arbitrary type which could be unrelated to '{1}'."),
        Cannot_read_file_0: diag(5083, ts2.DiagnosticCategory.Error, "Cannot_read_file_0_5083", "Cannot read file '{0}'."),
        Tuple_members_must_all_have_names_or_all_not_have_names: diag(5084, ts2.DiagnosticCategory.Error, "Tuple_members_must_all_have_names_or_all_not_have_names_5084", "Tuple members must all have names or all not have names."),
        A_tuple_member_cannot_be_both_optional_and_rest: diag(5085, ts2.DiagnosticCategory.Error, "A_tuple_member_cannot_be_both_optional_and_rest_5085", "A tuple member cannot be both optional and rest."),
        A_labeled_tuple_element_is_declared_as_optional_with_a_question_mark_after_the_name_and_before_the_colon_rather_than_after_the_type: diag(5086, ts2.DiagnosticCategory.Error, "A_labeled_tuple_element_is_declared_as_optional_with_a_question_mark_after_the_name_and_before_the_c_5086", "A labeled tuple element is declared as optional with a question mark after the name and before the colon, rather than after the type."),
        A_labeled_tuple_element_is_declared_as_rest_with_a_before_the_name_rather_than_before_the_type: diag(5087, ts2.DiagnosticCategory.Error, "A_labeled_tuple_element_is_declared_as_rest_with_a_before_the_name_rather_than_before_the_type_5087", "A labeled tuple element is declared as rest with a '...' before the name, rather than before the type."),
        The_inferred_type_of_0_references_a_type_with_a_cyclic_structure_which_cannot_be_trivially_serialized_A_type_annotation_is_necessary: diag(5088, ts2.DiagnosticCategory.Error, "The_inferred_type_of_0_references_a_type_with_a_cyclic_structure_which_cannot_be_trivially_serialize_5088", "The inferred type of '{0}' references a type with a cyclic structure which cannot be trivially serialized. A type annotation is necessary."),
        Option_0_cannot_be_specified_when_option_jsx_is_1: diag(5089, ts2.DiagnosticCategory.Error, "Option_0_cannot_be_specified_when_option_jsx_is_1_5089", "Option '{0}' cannot be specified when option 'jsx' is '{1}'."),
        Non_relative_paths_are_not_allowed_when_baseUrl_is_not_set_Did_you_forget_a_leading_Slash: diag(5090, ts2.DiagnosticCategory.Error, "Non_relative_paths_are_not_allowed_when_baseUrl_is_not_set_Did_you_forget_a_leading_Slash_5090", "Non-relative paths are not allowed when 'baseUrl' is not set. Did you forget a leading './'?"),
        Option_preserveConstEnums_cannot_be_disabled_when_isolatedModules_is_enabled: diag(5091, ts2.DiagnosticCategory.Error, "Option_preserveConstEnums_cannot_be_disabled_when_isolatedModules_is_enabled_5091", "Option 'preserveConstEnums' cannot be disabled when 'isolatedModules' is enabled."),
        The_root_value_of_a_0_file_must_be_an_object: diag(5092, ts2.DiagnosticCategory.Error, "The_root_value_of_a_0_file_must_be_an_object_5092", "The root value of a '{0}' file must be an object."),
        Compiler_option_0_may_only_be_used_with_build: diag(5093, ts2.DiagnosticCategory.Error, "Compiler_option_0_may_only_be_used_with_build_5093", "Compiler option '--{0}' may only be used with '--build'."),
        Compiler_option_0_may_not_be_used_with_build: diag(5094, ts2.DiagnosticCategory.Error, "Compiler_option_0_may_not_be_used_with_build_5094", "Compiler option '--{0}' may not be used with '--build'."),
        Option_preserveValueImports_can_only_be_used_when_module_is_set_to_es2015_or_later: diag(5095, ts2.DiagnosticCategory.Error, "Option_preserveValueImports_can_only_be_used_when_module_is_set_to_es2015_or_later_5095", "Option 'preserveValueImports' can only be used when 'module' is set to 'es2015' or later."),
        Generates_a_sourcemap_for_each_corresponding_d_ts_file: diag(6e3, ts2.DiagnosticCategory.Message, "Generates_a_sourcemap_for_each_corresponding_d_ts_file_6000", "Generates a sourcemap for each corresponding '.d.ts' file."),
        Concatenate_and_emit_output_to_single_file: diag(6001, ts2.DiagnosticCategory.Message, "Concatenate_and_emit_output_to_single_file_6001", "Concatenate and emit output to single file."),
        Generates_corresponding_d_ts_file: diag(6002, ts2.DiagnosticCategory.Message, "Generates_corresponding_d_ts_file_6002", "Generates corresponding '.d.ts' file."),
        Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations: diag(6004, ts2.DiagnosticCategory.Message, "Specify_the_location_where_debugger_should_locate_TypeScript_files_instead_of_source_locations_6004", "Specify the location where debugger should locate TypeScript files instead of source locations."),
        Watch_input_files: diag(6005, ts2.DiagnosticCategory.Message, "Watch_input_files_6005", "Watch input files."),
        Redirect_output_structure_to_the_directory: diag(6006, ts2.DiagnosticCategory.Message, "Redirect_output_structure_to_the_directory_6006", "Redirect output structure to the directory."),
        Do_not_erase_const_enum_declarations_in_generated_code: diag(6007, ts2.DiagnosticCategory.Message, "Do_not_erase_const_enum_declarations_in_generated_code_6007", "Do not erase const enum declarations in generated code."),
        Do_not_emit_outputs_if_any_errors_were_reported: diag(6008, ts2.DiagnosticCategory.Message, "Do_not_emit_outputs_if_any_errors_were_reported_6008", "Do not emit outputs if any errors were reported."),
        Do_not_emit_comments_to_output: diag(6009, ts2.DiagnosticCategory.Message, "Do_not_emit_comments_to_output_6009", "Do not emit comments to output."),
        Do_not_emit_outputs: diag(6010, ts2.DiagnosticCategory.Message, "Do_not_emit_outputs_6010", "Do not emit outputs."),
        Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typechecking: diag(6011, ts2.DiagnosticCategory.Message, "Allow_default_imports_from_modules_with_no_default_export_This_does_not_affect_code_emit_just_typech_6011", "Allow default imports from modules with no default export. This does not affect code emit, just typechecking."),
        Skip_type_checking_of_declaration_files: diag(6012, ts2.DiagnosticCategory.Message, "Skip_type_checking_of_declaration_files_6012", "Skip type checking of declaration files."),
        Do_not_resolve_the_real_path_of_symlinks: diag(6013, ts2.DiagnosticCategory.Message, "Do_not_resolve_the_real_path_of_symlinks_6013", "Do not resolve the real path of symlinks."),
        Only_emit_d_ts_declaration_files: diag(6014, ts2.DiagnosticCategory.Message, "Only_emit_d_ts_declaration_files_6014", "Only emit '.d.ts' declaration files."),
        Specify_ECMAScript_target_version: diag(6015, ts2.DiagnosticCategory.Message, "Specify_ECMAScript_target_version_6015", "Specify ECMAScript target version."),
        Specify_module_code_generation: diag(6016, ts2.DiagnosticCategory.Message, "Specify_module_code_generation_6016", "Specify module code generation."),
        Print_this_message: diag(6017, ts2.DiagnosticCategory.Message, "Print_this_message_6017", "Print this message."),
        Print_the_compiler_s_version: diag(6019, ts2.DiagnosticCategory.Message, "Print_the_compiler_s_version_6019", "Print the compiler's version."),
        Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json: diag(6020, ts2.DiagnosticCategory.Message, "Compile_the_project_given_the_path_to_its_configuration_file_or_to_a_folder_with_a_tsconfig_json_6020", "Compile the project given the path to its configuration file, or to a folder with a 'tsconfig.json'."),
        Syntax_Colon_0: diag(6023, ts2.DiagnosticCategory.Message, "Syntax_Colon_0_6023", "Syntax: {0}"),
        options: diag(6024, ts2.DiagnosticCategory.Message, "options_6024", "options"),
        file: diag(6025, ts2.DiagnosticCategory.Message, "file_6025", "file"),
        Examples_Colon_0: diag(6026, ts2.DiagnosticCategory.Message, "Examples_Colon_0_6026", "Examples: {0}"),
        Options_Colon: diag(6027, ts2.DiagnosticCategory.Message, "Options_Colon_6027", "Options:"),
        Version_0: diag(6029, ts2.DiagnosticCategory.Message, "Version_0_6029", "Version {0}"),
        Insert_command_line_options_and_files_from_a_file: diag(6030, ts2.DiagnosticCategory.Message, "Insert_command_line_options_and_files_from_a_file_6030", "Insert command line options and files from a file."),
        Starting_compilation_in_watch_mode: diag(6031, ts2.DiagnosticCategory.Message, "Starting_compilation_in_watch_mode_6031", "Starting compilation in watch mode..."),
        File_change_detected_Starting_incremental_compilation: diag(6032, ts2.DiagnosticCategory.Message, "File_change_detected_Starting_incremental_compilation_6032", "File change detected. Starting incremental compilation..."),
        KIND: diag(6034, ts2.DiagnosticCategory.Message, "KIND_6034", "KIND"),
        FILE: diag(6035, ts2.DiagnosticCategory.Message, "FILE_6035", "FILE"),
        VERSION: diag(6036, ts2.DiagnosticCategory.Message, "VERSION_6036", "VERSION"),
        LOCATION: diag(6037, ts2.DiagnosticCategory.Message, "LOCATION_6037", "LOCATION"),
        DIRECTORY: diag(6038, ts2.DiagnosticCategory.Message, "DIRECTORY_6038", "DIRECTORY"),
        STRATEGY: diag(6039, ts2.DiagnosticCategory.Message, "STRATEGY_6039", "STRATEGY"),
        FILE_OR_DIRECTORY: diag(6040, ts2.DiagnosticCategory.Message, "FILE_OR_DIRECTORY_6040", "FILE OR DIRECTORY"),
        Errors_Files: diag(6041, ts2.DiagnosticCategory.Message, "Errors_Files_6041", "Errors  Files"),
        Generates_corresponding_map_file: diag(6043, ts2.DiagnosticCategory.Message, "Generates_corresponding_map_file_6043", "Generates corresponding '.map' file."),
        Compiler_option_0_expects_an_argument: diag(6044, ts2.DiagnosticCategory.Error, "Compiler_option_0_expects_an_argument_6044", "Compiler option '{0}' expects an argument."),
        Unterminated_quoted_string_in_response_file_0: diag(6045, ts2.DiagnosticCategory.Error, "Unterminated_quoted_string_in_response_file_0_6045", "Unterminated quoted string in response file '{0}'."),
        Argument_for_0_option_must_be_Colon_1: diag(6046, ts2.DiagnosticCategory.Error, "Argument_for_0_option_must_be_Colon_1_6046", "Argument for '{0}' option must be: {1}."),
        Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1: diag(6048, ts2.DiagnosticCategory.Error, "Locale_must_be_of_the_form_language_or_language_territory_For_example_0_or_1_6048", "Locale must be of the form <language> or <language>-<territory>. For example '{0}' or '{1}'."),
        Unable_to_open_file_0: diag(6050, ts2.DiagnosticCategory.Error, "Unable_to_open_file_0_6050", "Unable to open file '{0}'."),
        Corrupted_locale_file_0: diag(6051, ts2.DiagnosticCategory.Error, "Corrupted_locale_file_0_6051", "Corrupted locale file {0}."),
        Raise_error_on_expressions_and_declarations_with_an_implied_any_type: diag(6052, ts2.DiagnosticCategory.Message, "Raise_error_on_expressions_and_declarations_with_an_implied_any_type_6052", "Raise error on expressions and declarations with an implied 'any' type."),
        File_0_not_found: diag(6053, ts2.DiagnosticCategory.Error, "File_0_not_found_6053", "File '{0}' not found."),
        File_0_has_an_unsupported_extension_The_only_supported_extensions_are_1: diag(6054, ts2.DiagnosticCategory.Error, "File_0_has_an_unsupported_extension_The_only_supported_extensions_are_1_6054", "File '{0}' has an unsupported extension. The only supported extensions are {1}."),
        Suppress_noImplicitAny_errors_for_indexing_objects_lacking_index_signatures: diag(6055, ts2.DiagnosticCategory.Message, "Suppress_noImplicitAny_errors_for_indexing_objects_lacking_index_signatures_6055", "Suppress noImplicitAny errors for indexing objects lacking index signatures."),
        Do_not_emit_declarations_for_code_that_has_an_internal_annotation: diag(6056, ts2.DiagnosticCategory.Message, "Do_not_emit_declarations_for_code_that_has_an_internal_annotation_6056", "Do not emit declarations for code that has an '@internal' annotation."),
        Specify_the_root_directory_of_input_files_Use_to_control_the_output_directory_structure_with_outDir: diag(6058, ts2.DiagnosticCategory.Message, "Specify_the_root_directory_of_input_files_Use_to_control_the_output_directory_structure_with_outDir_6058", "Specify the root directory of input files. Use to control the output directory structure with --outDir."),
        File_0_is_not_under_rootDir_1_rootDir_is_expected_to_contain_all_source_files: diag(6059, ts2.DiagnosticCategory.Error, "File_0_is_not_under_rootDir_1_rootDir_is_expected_to_contain_all_source_files_6059", "File '{0}' is not under 'rootDir' '{1}'. 'rootDir' is expected to contain all source files."),
        Specify_the_end_of_line_sequence_to_be_used_when_emitting_files_Colon_CRLF_dos_or_LF_unix: diag(6060, ts2.DiagnosticCategory.Message, "Specify_the_end_of_line_sequence_to_be_used_when_emitting_files_Colon_CRLF_dos_or_LF_unix_6060", "Specify the end of line sequence to be used when emitting files: 'CRLF' (dos) or 'LF' (unix)."),
        NEWLINE: diag(6061, ts2.DiagnosticCategory.Message, "NEWLINE_6061", "NEWLINE"),
        Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_null_on_command_line: diag(6064, ts2.DiagnosticCategory.Error, "Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_null_on_command_line_6064", "Option '{0}' can only be specified in 'tsconfig.json' file or set to 'null' on command line."),
        Enables_experimental_support_for_ES7_decorators: diag(6065, ts2.DiagnosticCategory.Message, "Enables_experimental_support_for_ES7_decorators_6065", "Enables experimental support for ES7 decorators."),
        Enables_experimental_support_for_emitting_type_metadata_for_decorators: diag(6066, ts2.DiagnosticCategory.Message, "Enables_experimental_support_for_emitting_type_metadata_for_decorators_6066", "Enables experimental support for emitting type metadata for decorators."),
        Specify_module_resolution_strategy_Colon_node_Node_js_or_classic_TypeScript_pre_1_6: diag(6069, ts2.DiagnosticCategory.Message, "Specify_module_resolution_strategy_Colon_node_Node_js_or_classic_TypeScript_pre_1_6_6069", "Specify module resolution strategy: 'node' (Node.js) or 'classic' (TypeScript pre-1.6)."),
        Initializes_a_TypeScript_project_and_creates_a_tsconfig_json_file: diag(6070, ts2.DiagnosticCategory.Message, "Initializes_a_TypeScript_project_and_creates_a_tsconfig_json_file_6070", "Initializes a TypeScript project and creates a tsconfig.json file."),
        Successfully_created_a_tsconfig_json_file: diag(6071, ts2.DiagnosticCategory.Message, "Successfully_created_a_tsconfig_json_file_6071", "Successfully created a tsconfig.json file."),
        Suppress_excess_property_checks_for_object_literals: diag(6072, ts2.DiagnosticCategory.Message, "Suppress_excess_property_checks_for_object_literals_6072", "Suppress excess property checks for object literals."),
        Stylize_errors_and_messages_using_color_and_context_experimental: diag(6073, ts2.DiagnosticCategory.Message, "Stylize_errors_and_messages_using_color_and_context_experimental_6073", "Stylize errors and messages using color and context (experimental)."),
        Do_not_report_errors_on_unused_labels: diag(6074, ts2.DiagnosticCategory.Message, "Do_not_report_errors_on_unused_labels_6074", "Do not report errors on unused labels."),
        Report_error_when_not_all_code_paths_in_function_return_a_value: diag(6075, ts2.DiagnosticCategory.Message, "Report_error_when_not_all_code_paths_in_function_return_a_value_6075", "Report error when not all code paths in function return a value."),
        Report_errors_for_fallthrough_cases_in_switch_statement: diag(6076, ts2.DiagnosticCategory.Message, "Report_errors_for_fallthrough_cases_in_switch_statement_6076", "Report errors for fallthrough cases in switch statement."),
        Do_not_report_errors_on_unreachable_code: diag(6077, ts2.DiagnosticCategory.Message, "Do_not_report_errors_on_unreachable_code_6077", "Do not report errors on unreachable code."),
        Disallow_inconsistently_cased_references_to_the_same_file: diag(6078, ts2.DiagnosticCategory.Message, "Disallow_inconsistently_cased_references_to_the_same_file_6078", "Disallow inconsistently-cased references to the same file."),
        Specify_library_files_to_be_included_in_the_compilation: diag(6079, ts2.DiagnosticCategory.Message, "Specify_library_files_to_be_included_in_the_compilation_6079", "Specify library files to be included in the compilation."),
        Specify_JSX_code_generation: diag(6080, ts2.DiagnosticCategory.Message, "Specify_JSX_code_generation_6080", "Specify JSX code generation."),
        File_0_has_an_unsupported_extension_so_skipping_it: diag(6081, ts2.DiagnosticCategory.Message, "File_0_has_an_unsupported_extension_so_skipping_it_6081", "File '{0}' has an unsupported extension, so skipping it."),
        Only_amd_and_system_modules_are_supported_alongside_0: diag(6082, ts2.DiagnosticCategory.Error, "Only_amd_and_system_modules_are_supported_alongside_0_6082", "Only 'amd' and 'system' modules are supported alongside --{0}."),
        Base_directory_to_resolve_non_absolute_module_names: diag(6083, ts2.DiagnosticCategory.Message, "Base_directory_to_resolve_non_absolute_module_names_6083", "Base directory to resolve non-absolute module names."),
        Deprecated_Use_jsxFactory_instead_Specify_the_object_invoked_for_createElement_when_targeting_react_JSX_emit: diag(6084, ts2.DiagnosticCategory.Message, "Deprecated_Use_jsxFactory_instead_Specify_the_object_invoked_for_createElement_when_targeting_react__6084", "[Deprecated] Use '--jsxFactory' instead. Specify the object invoked for createElement when targeting 'react' JSX emit"),
        Enable_tracing_of_the_name_resolution_process: diag(6085, ts2.DiagnosticCategory.Message, "Enable_tracing_of_the_name_resolution_process_6085", "Enable tracing of the name resolution process."),
        Resolving_module_0_from_1: diag(6086, ts2.DiagnosticCategory.Message, "Resolving_module_0_from_1_6086", "======== Resolving module '{0}' from '{1}'. ========"),
        Explicitly_specified_module_resolution_kind_Colon_0: diag(6087, ts2.DiagnosticCategory.Message, "Explicitly_specified_module_resolution_kind_Colon_0_6087", "Explicitly specified module resolution kind: '{0}'."),
        Module_resolution_kind_is_not_specified_using_0: diag(6088, ts2.DiagnosticCategory.Message, "Module_resolution_kind_is_not_specified_using_0_6088", "Module resolution kind is not specified, using '{0}'."),
        Module_name_0_was_successfully_resolved_to_1: diag(6089, ts2.DiagnosticCategory.Message, "Module_name_0_was_successfully_resolved_to_1_6089", "======== Module name '{0}' was successfully resolved to '{1}'. ========"),
        Module_name_0_was_not_resolved: diag(6090, ts2.DiagnosticCategory.Message, "Module_name_0_was_not_resolved_6090", "======== Module name '{0}' was not resolved. ========"),
        paths_option_is_specified_looking_for_a_pattern_to_match_module_name_0: diag(6091, ts2.DiagnosticCategory.Message, "paths_option_is_specified_looking_for_a_pattern_to_match_module_name_0_6091", "'paths' option is specified, looking for a pattern to match module name '{0}'."),
        Module_name_0_matched_pattern_1: diag(6092, ts2.DiagnosticCategory.Message, "Module_name_0_matched_pattern_1_6092", "Module name '{0}', matched pattern '{1}'."),
        Trying_substitution_0_candidate_module_location_Colon_1: diag(6093, ts2.DiagnosticCategory.Message, "Trying_substitution_0_candidate_module_location_Colon_1_6093", "Trying substitution '{0}', candidate module location: '{1}'."),
        Resolving_module_name_0_relative_to_base_url_1_2: diag(6094, ts2.DiagnosticCategory.Message, "Resolving_module_name_0_relative_to_base_url_1_2_6094", "Resolving module name '{0}' relative to base url '{1}' - '{2}'."),
        Loading_module_as_file_Slash_folder_candidate_module_location_0_target_file_type_1: diag(6095, ts2.DiagnosticCategory.Message, "Loading_module_as_file_Slash_folder_candidate_module_location_0_target_file_type_1_6095", "Loading module as file / folder, candidate module location '{0}', target file type '{1}'."),
        File_0_does_not_exist: diag(6096, ts2.DiagnosticCategory.Message, "File_0_does_not_exist_6096", "File '{0}' does not exist."),
        File_0_exist_use_it_as_a_name_resolution_result: diag(6097, ts2.DiagnosticCategory.Message, "File_0_exist_use_it_as_a_name_resolution_result_6097", "File '{0}' exist - use it as a name resolution result."),
        Loading_module_0_from_node_modules_folder_target_file_type_1: diag(6098, ts2.DiagnosticCategory.Message, "Loading_module_0_from_node_modules_folder_target_file_type_1_6098", "Loading module '{0}' from 'node_modules' folder, target file type '{1}'."),
        Found_package_json_at_0: diag(6099, ts2.DiagnosticCategory.Message, "Found_package_json_at_0_6099", "Found 'package.json' at '{0}'."),
        package_json_does_not_have_a_0_field: diag(6100, ts2.DiagnosticCategory.Message, "package_json_does_not_have_a_0_field_6100", "'package.json' does not have a '{0}' field."),
        package_json_has_0_field_1_that_references_2: diag(6101, ts2.DiagnosticCategory.Message, "package_json_has_0_field_1_that_references_2_6101", "'package.json' has '{0}' field '{1}' that references '{2}'."),
        Allow_javascript_files_to_be_compiled: diag(6102, ts2.DiagnosticCategory.Message, "Allow_javascript_files_to_be_compiled_6102", "Allow javascript files to be compiled."),
        Checking_if_0_is_the_longest_matching_prefix_for_1_2: diag(6104, ts2.DiagnosticCategory.Message, "Checking_if_0_is_the_longest_matching_prefix_for_1_2_6104", "Checking if '{0}' is the longest matching prefix for '{1}' - '{2}'."),
        Expected_type_of_0_field_in_package_json_to_be_1_got_2: diag(6105, ts2.DiagnosticCategory.Message, "Expected_type_of_0_field_in_package_json_to_be_1_got_2_6105", "Expected type of '{0}' field in 'package.json' to be '{1}', got '{2}'."),
        baseUrl_option_is_set_to_0_using_this_value_to_resolve_non_relative_module_name_1: diag(6106, ts2.DiagnosticCategory.Message, "baseUrl_option_is_set_to_0_using_this_value_to_resolve_non_relative_module_name_1_6106", "'baseUrl' option is set to '{0}', using this value to resolve non-relative module name '{1}'."),
        rootDirs_option_is_set_using_it_to_resolve_relative_module_name_0: diag(6107, ts2.DiagnosticCategory.Message, "rootDirs_option_is_set_using_it_to_resolve_relative_module_name_0_6107", "'rootDirs' option is set, using it to resolve relative module name '{0}'."),
        Longest_matching_prefix_for_0_is_1: diag(6108, ts2.DiagnosticCategory.Message, "Longest_matching_prefix_for_0_is_1_6108", "Longest matching prefix for '{0}' is '{1}'."),
        Loading_0_from_the_root_dir_1_candidate_location_2: diag(6109, ts2.DiagnosticCategory.Message, "Loading_0_from_the_root_dir_1_candidate_location_2_6109", "Loading '{0}' from the root dir '{1}', candidate location '{2}'."),
        Trying_other_entries_in_rootDirs: diag(6110, ts2.DiagnosticCategory.Message, "Trying_other_entries_in_rootDirs_6110", "Trying other entries in 'rootDirs'."),
        Module_resolution_using_rootDirs_has_failed: diag(6111, ts2.DiagnosticCategory.Message, "Module_resolution_using_rootDirs_has_failed_6111", "Module resolution using 'rootDirs' has failed."),
        Do_not_emit_use_strict_directives_in_module_output: diag(6112, ts2.DiagnosticCategory.Message, "Do_not_emit_use_strict_directives_in_module_output_6112", "Do not emit 'use strict' directives in module output."),
        Enable_strict_null_checks: diag(6113, ts2.DiagnosticCategory.Message, "Enable_strict_null_checks_6113", "Enable strict null checks."),
        Unknown_option_excludes_Did_you_mean_exclude: diag(6114, ts2.DiagnosticCategory.Error, "Unknown_option_excludes_Did_you_mean_exclude_6114", "Unknown option 'excludes'. Did you mean 'exclude'?"),
        Raise_error_on_this_expressions_with_an_implied_any_type: diag(6115, ts2.DiagnosticCategory.Message, "Raise_error_on_this_expressions_with_an_implied_any_type_6115", "Raise error on 'this' expressions with an implied 'any' type."),
        Resolving_type_reference_directive_0_containing_file_1_root_directory_2: diag(6116, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_1_root_directory_2_6116", "======== Resolving type reference directive '{0}', containing file '{1}', root directory '{2}'. ========"),
        Type_reference_directive_0_was_successfully_resolved_to_1_primary_Colon_2: diag(6119, ts2.DiagnosticCategory.Message, "Type_reference_directive_0_was_successfully_resolved_to_1_primary_Colon_2_6119", "======== Type reference directive '{0}' was successfully resolved to '{1}', primary: {2}. ========"),
        Type_reference_directive_0_was_not_resolved: diag(6120, ts2.DiagnosticCategory.Message, "Type_reference_directive_0_was_not_resolved_6120", "======== Type reference directive '{0}' was not resolved. ========"),
        Resolving_with_primary_search_path_0: diag(6121, ts2.DiagnosticCategory.Message, "Resolving_with_primary_search_path_0_6121", "Resolving with primary search path '{0}'."),
        Root_directory_cannot_be_determined_skipping_primary_search_paths: diag(6122, ts2.DiagnosticCategory.Message, "Root_directory_cannot_be_determined_skipping_primary_search_paths_6122", "Root directory cannot be determined, skipping primary search paths."),
        Resolving_type_reference_directive_0_containing_file_1_root_directory_not_set: diag(6123, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_1_root_directory_not_set_6123", "======== Resolving type reference directive '{0}', containing file '{1}', root directory not set. ========"),
        Type_declaration_files_to_be_included_in_compilation: diag(6124, ts2.DiagnosticCategory.Message, "Type_declaration_files_to_be_included_in_compilation_6124", "Type declaration files to be included in compilation."),
        Looking_up_in_node_modules_folder_initial_location_0: diag(6125, ts2.DiagnosticCategory.Message, "Looking_up_in_node_modules_folder_initial_location_0_6125", "Looking up in 'node_modules' folder, initial location '{0}'."),
        Containing_file_is_not_specified_and_root_directory_cannot_be_determined_skipping_lookup_in_node_modules_folder: diag(6126, ts2.DiagnosticCategory.Message, "Containing_file_is_not_specified_and_root_directory_cannot_be_determined_skipping_lookup_in_node_mod_6126", "Containing file is not specified and root directory cannot be determined, skipping lookup in 'node_modules' folder."),
        Resolving_type_reference_directive_0_containing_file_not_set_root_directory_1: diag(6127, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_not_set_root_directory_1_6127", "======== Resolving type reference directive '{0}', containing file not set, root directory '{1}'. ========"),
        Resolving_type_reference_directive_0_containing_file_not_set_root_directory_not_set: diag(6128, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_not_set_root_directory_not_set_6128", "======== Resolving type reference directive '{0}', containing file not set, root directory not set. ========"),
        Resolving_real_path_for_0_result_1: diag(6130, ts2.DiagnosticCategory.Message, "Resolving_real_path_for_0_result_1_6130", "Resolving real path for '{0}', result '{1}'."),
        Cannot_compile_modules_using_option_0_unless_the_module_flag_is_amd_or_system: diag(6131, ts2.DiagnosticCategory.Error, "Cannot_compile_modules_using_option_0_unless_the_module_flag_is_amd_or_system_6131", "Cannot compile modules using option '{0}' unless the '--module' flag is 'amd' or 'system'."),
        File_name_0_has_a_1_extension_stripping_it: diag(6132, ts2.DiagnosticCategory.Message, "File_name_0_has_a_1_extension_stripping_it_6132", "File name '{0}' has a '{1}' extension - stripping it."),
        _0_is_declared_but_its_value_is_never_read: diag(6133, ts2.DiagnosticCategory.Error, "_0_is_declared_but_its_value_is_never_read_6133", "'{0}' is declared but its value is never read.", true),
        Report_errors_on_unused_locals: diag(6134, ts2.DiagnosticCategory.Message, "Report_errors_on_unused_locals_6134", "Report errors on unused locals."),
        Report_errors_on_unused_parameters: diag(6135, ts2.DiagnosticCategory.Message, "Report_errors_on_unused_parameters_6135", "Report errors on unused parameters."),
        The_maximum_dependency_depth_to_search_under_node_modules_and_load_JavaScript_files: diag(6136, ts2.DiagnosticCategory.Message, "The_maximum_dependency_depth_to_search_under_node_modules_and_load_JavaScript_files_6136", "The maximum dependency depth to search under node_modules and load JavaScript files."),
        Cannot_import_type_declaration_files_Consider_importing_0_instead_of_1: diag(6137, ts2.DiagnosticCategory.Error, "Cannot_import_type_declaration_files_Consider_importing_0_instead_of_1_6137", "Cannot import type declaration files. Consider importing '{0}' instead of '{1}'."),
        Property_0_is_declared_but_its_value_is_never_read: diag(6138, ts2.DiagnosticCategory.Error, "Property_0_is_declared_but_its_value_is_never_read_6138", "Property '{0}' is declared but its value is never read.", true),
        Import_emit_helpers_from_tslib: diag(6139, ts2.DiagnosticCategory.Message, "Import_emit_helpers_from_tslib_6139", "Import emit helpers from 'tslib'."),
        Auto_discovery_for_typings_is_enabled_in_project_0_Running_extra_resolution_pass_for_module_1_using_cache_location_2: diag(6140, ts2.DiagnosticCategory.Error, "Auto_discovery_for_typings_is_enabled_in_project_0_Running_extra_resolution_pass_for_module_1_using__6140", "Auto discovery for typings is enabled in project '{0}'. Running extra resolution pass for module '{1}' using cache location '{2}'."),
        Parse_in_strict_mode_and_emit_use_strict_for_each_source_file: diag(6141, ts2.DiagnosticCategory.Message, "Parse_in_strict_mode_and_emit_use_strict_for_each_source_file_6141", 'Parse in strict mode and emit "use strict" for each source file.'),
        Module_0_was_resolved_to_1_but_jsx_is_not_set: diag(6142, ts2.DiagnosticCategory.Error, "Module_0_was_resolved_to_1_but_jsx_is_not_set_6142", "Module '{0}' was resolved to '{1}', but '--jsx' is not set."),
        Module_0_was_resolved_as_locally_declared_ambient_module_in_file_1: diag(6144, ts2.DiagnosticCategory.Message, "Module_0_was_resolved_as_locally_declared_ambient_module_in_file_1_6144", "Module '{0}' was resolved as locally declared ambient module in file '{1}'."),
        Module_0_was_resolved_as_ambient_module_declared_in_1_since_this_file_was_not_modified: diag(6145, ts2.DiagnosticCategory.Message, "Module_0_was_resolved_as_ambient_module_declared_in_1_since_this_file_was_not_modified_6145", "Module '{0}' was resolved as ambient module declared in '{1}' since this file was not modified."),
        Specify_the_JSX_factory_function_to_use_when_targeting_react_JSX_emit_e_g_React_createElement_or_h: diag(6146, ts2.DiagnosticCategory.Message, "Specify_the_JSX_factory_function_to_use_when_targeting_react_JSX_emit_e_g_React_createElement_or_h_6146", "Specify the JSX factory function to use when targeting 'react' JSX emit, e.g. 'React.createElement' or 'h'."),
        Resolution_for_module_0_was_found_in_cache_from_location_1: diag(6147, ts2.DiagnosticCategory.Message, "Resolution_for_module_0_was_found_in_cache_from_location_1_6147", "Resolution for module '{0}' was found in cache from location '{1}'."),
        Directory_0_does_not_exist_skipping_all_lookups_in_it: diag(6148, ts2.DiagnosticCategory.Message, "Directory_0_does_not_exist_skipping_all_lookups_in_it_6148", "Directory '{0}' does not exist, skipping all lookups in it."),
        Show_diagnostic_information: diag(6149, ts2.DiagnosticCategory.Message, "Show_diagnostic_information_6149", "Show diagnostic information."),
        Show_verbose_diagnostic_information: diag(6150, ts2.DiagnosticCategory.Message, "Show_verbose_diagnostic_information_6150", "Show verbose diagnostic information."),
        Emit_a_single_file_with_source_maps_instead_of_having_a_separate_file: diag(6151, ts2.DiagnosticCategory.Message, "Emit_a_single_file_with_source_maps_instead_of_having_a_separate_file_6151", "Emit a single file with source maps instead of having a separate file."),
        Emit_the_source_alongside_the_sourcemaps_within_a_single_file_requires_inlineSourceMap_or_sourceMap_to_be_set: diag(6152, ts2.DiagnosticCategory.Message, "Emit_the_source_alongside_the_sourcemaps_within_a_single_file_requires_inlineSourceMap_or_sourceMap__6152", "Emit the source alongside the sourcemaps within a single file; requires '--inlineSourceMap' or '--sourceMap' to be set."),
        Transpile_each_file_as_a_separate_module_similar_to_ts_transpileModule: diag(6153, ts2.DiagnosticCategory.Message, "Transpile_each_file_as_a_separate_module_similar_to_ts_transpileModule_6153", "Transpile each file as a separate module (similar to 'ts.transpileModule')."),
        Print_names_of_generated_files_part_of_the_compilation: diag(6154, ts2.DiagnosticCategory.Message, "Print_names_of_generated_files_part_of_the_compilation_6154", "Print names of generated files part of the compilation."),
        Print_names_of_files_part_of_the_compilation: diag(6155, ts2.DiagnosticCategory.Message, "Print_names_of_files_part_of_the_compilation_6155", "Print names of files part of the compilation."),
        The_locale_used_when_displaying_messages_to_the_user_e_g_en_us: diag(6156, ts2.DiagnosticCategory.Message, "The_locale_used_when_displaying_messages_to_the_user_e_g_en_us_6156", "The locale used when displaying messages to the user (e.g. 'en-us')"),
        Do_not_generate_custom_helper_functions_like_extends_in_compiled_output: diag(6157, ts2.DiagnosticCategory.Message, "Do_not_generate_custom_helper_functions_like_extends_in_compiled_output_6157", "Do not generate custom helper functions like '__extends' in compiled output."),
        Do_not_include_the_default_library_file_lib_d_ts: diag(6158, ts2.DiagnosticCategory.Message, "Do_not_include_the_default_library_file_lib_d_ts_6158", "Do not include the default library file (lib.d.ts)."),
        Do_not_add_triple_slash_references_or_imported_modules_to_the_list_of_compiled_files: diag(6159, ts2.DiagnosticCategory.Message, "Do_not_add_triple_slash_references_or_imported_modules_to_the_list_of_compiled_files_6159", "Do not add triple-slash references or imported modules to the list of compiled files."),
        Deprecated_Use_skipLibCheck_instead_Skip_type_checking_of_default_library_declaration_files: diag(6160, ts2.DiagnosticCategory.Message, "Deprecated_Use_skipLibCheck_instead_Skip_type_checking_of_default_library_declaration_files_6160", "[Deprecated] Use '--skipLibCheck' instead. Skip type checking of default library declaration files."),
        List_of_folders_to_include_type_definitions_from: diag(6161, ts2.DiagnosticCategory.Message, "List_of_folders_to_include_type_definitions_from_6161", "List of folders to include type definitions from."),
        Disable_size_limitations_on_JavaScript_projects: diag(6162, ts2.DiagnosticCategory.Message, "Disable_size_limitations_on_JavaScript_projects_6162", "Disable size limitations on JavaScript projects."),
        The_character_set_of_the_input_files: diag(6163, ts2.DiagnosticCategory.Message, "The_character_set_of_the_input_files_6163", "The character set of the input files."),
        Do_not_truncate_error_messages: diag(6165, ts2.DiagnosticCategory.Message, "Do_not_truncate_error_messages_6165", "Do not truncate error messages."),
        Output_directory_for_generated_declaration_files: diag(6166, ts2.DiagnosticCategory.Message, "Output_directory_for_generated_declaration_files_6166", "Output directory for generated declaration files."),
        A_series_of_entries_which_re_map_imports_to_lookup_locations_relative_to_the_baseUrl: diag(6167, ts2.DiagnosticCategory.Message, "A_series_of_entries_which_re_map_imports_to_lookup_locations_relative_to_the_baseUrl_6167", "A series of entries which re-map imports to lookup locations relative to the 'baseUrl'."),
        List_of_root_folders_whose_combined_content_represents_the_structure_of_the_project_at_runtime: diag(6168, ts2.DiagnosticCategory.Message, "List_of_root_folders_whose_combined_content_represents_the_structure_of_the_project_at_runtime_6168", "List of root folders whose combined content represents the structure of the project at runtime."),
        Show_all_compiler_options: diag(6169, ts2.DiagnosticCategory.Message, "Show_all_compiler_options_6169", "Show all compiler options."),
        Deprecated_Use_outFile_instead_Concatenate_and_emit_output_to_single_file: diag(6170, ts2.DiagnosticCategory.Message, "Deprecated_Use_outFile_instead_Concatenate_and_emit_output_to_single_file_6170", "[Deprecated] Use '--outFile' instead. Concatenate and emit output to single file"),
        Command_line_Options: diag(6171, ts2.DiagnosticCategory.Message, "Command_line_Options_6171", "Command-line Options"),
        Provide_full_support_for_iterables_in_for_of_spread_and_destructuring_when_targeting_ES5_or_ES3: diag(6179, ts2.DiagnosticCategory.Message, "Provide_full_support_for_iterables_in_for_of_spread_and_destructuring_when_targeting_ES5_or_ES3_6179", "Provide full support for iterables in 'for-of', spread, and destructuring when targeting 'ES5' or 'ES3'."),
        Enable_all_strict_type_checking_options: diag(6180, ts2.DiagnosticCategory.Message, "Enable_all_strict_type_checking_options_6180", "Enable all strict type-checking options."),
        Scoped_package_detected_looking_in_0: diag(6182, ts2.DiagnosticCategory.Message, "Scoped_package_detected_looking_in_0_6182", "Scoped package detected, looking in '{0}'"),
        Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2: diag(6183, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2_6183", "Reusing resolution of module '{0}' from '{1}' of old program, it was successfully resolved to '{2}'."),
        Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2_with_Package_ID_3: diag(6184, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_of_old_program_it_was_successfully_resolved_to_2_with_Package__6184", "Reusing resolution of module '{0}' from '{1}' of old program, it was successfully resolved to '{2}' with Package ID '{3}'."),
        Enable_strict_checking_of_function_types: diag(6186, ts2.DiagnosticCategory.Message, "Enable_strict_checking_of_function_types_6186", "Enable strict checking of function types."),
        Enable_strict_checking_of_property_initialization_in_classes: diag(6187, ts2.DiagnosticCategory.Message, "Enable_strict_checking_of_property_initialization_in_classes_6187", "Enable strict checking of property initialization in classes."),
        Numeric_separators_are_not_allowed_here: diag(6188, ts2.DiagnosticCategory.Error, "Numeric_separators_are_not_allowed_here_6188", "Numeric separators are not allowed here."),
        Multiple_consecutive_numeric_separators_are_not_permitted: diag(6189, ts2.DiagnosticCategory.Error, "Multiple_consecutive_numeric_separators_are_not_permitted_6189", "Multiple consecutive numeric separators are not permitted."),
        Whether_to_keep_outdated_console_output_in_watch_mode_instead_of_clearing_the_screen: diag(6191, ts2.DiagnosticCategory.Message, "Whether_to_keep_outdated_console_output_in_watch_mode_instead_of_clearing_the_screen_6191", "Whether to keep outdated console output in watch mode instead of clearing the screen."),
        All_imports_in_import_declaration_are_unused: diag(6192, ts2.DiagnosticCategory.Error, "All_imports_in_import_declaration_are_unused_6192", "All imports in import declaration are unused.", true),
        Found_1_error_Watching_for_file_changes: diag(6193, ts2.DiagnosticCategory.Message, "Found_1_error_Watching_for_file_changes_6193", "Found 1 error. Watching for file changes."),
        Found_0_errors_Watching_for_file_changes: diag(6194, ts2.DiagnosticCategory.Message, "Found_0_errors_Watching_for_file_changes_6194", "Found {0} errors. Watching for file changes."),
        Resolve_keyof_to_string_valued_property_names_only_no_numbers_or_symbols: diag(6195, ts2.DiagnosticCategory.Message, "Resolve_keyof_to_string_valued_property_names_only_no_numbers_or_symbols_6195", "Resolve 'keyof' to string valued property names only (no numbers or symbols)."),
        _0_is_declared_but_never_used: diag(6196, ts2.DiagnosticCategory.Error, "_0_is_declared_but_never_used_6196", "'{0}' is declared but never used.", true),
        Include_modules_imported_with_json_extension: diag(6197, ts2.DiagnosticCategory.Message, "Include_modules_imported_with_json_extension_6197", "Include modules imported with '.json' extension"),
        All_destructured_elements_are_unused: diag(6198, ts2.DiagnosticCategory.Error, "All_destructured_elements_are_unused_6198", "All destructured elements are unused.", true),
        All_variables_are_unused: diag(6199, ts2.DiagnosticCategory.Error, "All_variables_are_unused_6199", "All variables are unused.", true),
        Definitions_of_the_following_identifiers_conflict_with_those_in_another_file_Colon_0: diag(6200, ts2.DiagnosticCategory.Error, "Definitions_of_the_following_identifiers_conflict_with_those_in_another_file_Colon_0_6200", "Definitions of the following identifiers conflict with those in another file: {0}"),
        Conflicts_are_in_this_file: diag(6201, ts2.DiagnosticCategory.Message, "Conflicts_are_in_this_file_6201", "Conflicts are in this file."),
        Project_references_may_not_form_a_circular_graph_Cycle_detected_Colon_0: diag(6202, ts2.DiagnosticCategory.Error, "Project_references_may_not_form_a_circular_graph_Cycle_detected_Colon_0_6202", "Project references may not form a circular graph. Cycle detected: {0}"),
        _0_was_also_declared_here: diag(6203, ts2.DiagnosticCategory.Message, "_0_was_also_declared_here_6203", "'{0}' was also declared here."),
        and_here: diag(6204, ts2.DiagnosticCategory.Message, "and_here_6204", "and here."),
        All_type_parameters_are_unused: diag(6205, ts2.DiagnosticCategory.Error, "All_type_parameters_are_unused_6205", "All type parameters are unused."),
        package_json_has_a_typesVersions_field_with_version_specific_path_mappings: diag(6206, ts2.DiagnosticCategory.Message, "package_json_has_a_typesVersions_field_with_version_specific_path_mappings_6206", "'package.json' has a 'typesVersions' field with version-specific path mappings."),
        package_json_does_not_have_a_typesVersions_entry_that_matches_version_0: diag(6207, ts2.DiagnosticCategory.Message, "package_json_does_not_have_a_typesVersions_entry_that_matches_version_0_6207", "'package.json' does not have a 'typesVersions' entry that matches version '{0}'."),
        package_json_has_a_typesVersions_entry_0_that_matches_compiler_version_1_looking_for_a_pattern_to_match_module_name_2: diag(6208, ts2.DiagnosticCategory.Message, "package_json_has_a_typesVersions_entry_0_that_matches_compiler_version_1_looking_for_a_pattern_to_ma_6208", "'package.json' has a 'typesVersions' entry '{0}' that matches compiler version '{1}', looking for a pattern to match module name '{2}'."),
        package_json_has_a_typesVersions_entry_0_that_is_not_a_valid_semver_range: diag(6209, ts2.DiagnosticCategory.Message, "package_json_has_a_typesVersions_entry_0_that_is_not_a_valid_semver_range_6209", "'package.json' has a 'typesVersions' entry '{0}' that is not a valid semver range."),
        An_argument_for_0_was_not_provided: diag(6210, ts2.DiagnosticCategory.Message, "An_argument_for_0_was_not_provided_6210", "An argument for '{0}' was not provided."),
        An_argument_matching_this_binding_pattern_was_not_provided: diag(6211, ts2.DiagnosticCategory.Message, "An_argument_matching_this_binding_pattern_was_not_provided_6211", "An argument matching this binding pattern was not provided."),
        Did_you_mean_to_call_this_expression: diag(6212, ts2.DiagnosticCategory.Message, "Did_you_mean_to_call_this_expression_6212", "Did you mean to call this expression?"),
        Did_you_mean_to_use_new_with_this_expression: diag(6213, ts2.DiagnosticCategory.Message, "Did_you_mean_to_use_new_with_this_expression_6213", "Did you mean to use 'new' with this expression?"),
        Enable_strict_bind_call_and_apply_methods_on_functions: diag(6214, ts2.DiagnosticCategory.Message, "Enable_strict_bind_call_and_apply_methods_on_functions_6214", "Enable strict 'bind', 'call', and 'apply' methods on functions."),
        Using_compiler_options_of_project_reference_redirect_0: diag(6215, ts2.DiagnosticCategory.Message, "Using_compiler_options_of_project_reference_redirect_0_6215", "Using compiler options of project reference redirect '{0}'."),
        Found_1_error: diag(6216, ts2.DiagnosticCategory.Message, "Found_1_error_6216", "Found 1 error."),
        Found_0_errors: diag(6217, ts2.DiagnosticCategory.Message, "Found_0_errors_6217", "Found {0} errors."),
        Module_name_0_was_successfully_resolved_to_1_with_Package_ID_2: diag(6218, ts2.DiagnosticCategory.Message, "Module_name_0_was_successfully_resolved_to_1_with_Package_ID_2_6218", "======== Module name '{0}' was successfully resolved to '{1}' with Package ID '{2}'. ========"),
        Type_reference_directive_0_was_successfully_resolved_to_1_with_Package_ID_2_primary_Colon_3: diag(6219, ts2.DiagnosticCategory.Message, "Type_reference_directive_0_was_successfully_resolved_to_1_with_Package_ID_2_primary_Colon_3_6219", "======== Type reference directive '{0}' was successfully resolved to '{1}' with Package ID '{2}', primary: {3}. ========"),
        package_json_had_a_falsy_0_field: diag(6220, ts2.DiagnosticCategory.Message, "package_json_had_a_falsy_0_field_6220", "'package.json' had a falsy '{0}' field."),
        Disable_use_of_source_files_instead_of_declaration_files_from_referenced_projects: diag(6221, ts2.DiagnosticCategory.Message, "Disable_use_of_source_files_instead_of_declaration_files_from_referenced_projects_6221", "Disable use of source files instead of declaration files from referenced projects."),
        Emit_class_fields_with_Define_instead_of_Set: diag(6222, ts2.DiagnosticCategory.Message, "Emit_class_fields_with_Define_instead_of_Set_6222", "Emit class fields with Define instead of Set."),
        Generates_a_CPU_profile: diag(6223, ts2.DiagnosticCategory.Message, "Generates_a_CPU_profile_6223", "Generates a CPU profile."),
        Disable_solution_searching_for_this_project: diag(6224, ts2.DiagnosticCategory.Message, "Disable_solution_searching_for_this_project_6224", "Disable solution searching for this project."),
        Specify_strategy_for_watching_file_Colon_FixedPollingInterval_default_PriorityPollingInterval_DynamicPriorityPolling_FixedChunkSizePolling_UseFsEvents_UseFsEventsOnParentDirectory: diag(6225, ts2.DiagnosticCategory.Message, "Specify_strategy_for_watching_file_Colon_FixedPollingInterval_default_PriorityPollingInterval_Dynami_6225", "Specify strategy for watching file: 'FixedPollingInterval' (default), 'PriorityPollingInterval', 'DynamicPriorityPolling', 'FixedChunkSizePolling', 'UseFsEvents', 'UseFsEventsOnParentDirectory'."),
        Specify_strategy_for_watching_directory_on_platforms_that_don_t_support_recursive_watching_natively_Colon_UseFsEvents_default_FixedPollingInterval_DynamicPriorityPolling_FixedChunkSizePolling: diag(6226, ts2.DiagnosticCategory.Message, "Specify_strategy_for_watching_directory_on_platforms_that_don_t_support_recursive_watching_natively__6226", "Specify strategy for watching directory on platforms that don't support recursive watching natively: 'UseFsEvents' (default), 'FixedPollingInterval', 'DynamicPriorityPolling', 'FixedChunkSizePolling'."),
        Specify_strategy_for_creating_a_polling_watch_when_it_fails_to_create_using_file_system_events_Colon_FixedInterval_default_PriorityInterval_DynamicPriority_FixedChunkSize: diag(6227, ts2.DiagnosticCategory.Message, "Specify_strategy_for_creating_a_polling_watch_when_it_fails_to_create_using_file_system_events_Colon_6227", "Specify strategy for creating a polling watch when it fails to create using file system events: 'FixedInterval' (default), 'PriorityInterval', 'DynamicPriority', 'FixedChunkSize'."),
        Tag_0_expects_at_least_1_arguments_but_the_JSX_factory_2_provides_at_most_3: diag(6229, ts2.DiagnosticCategory.Error, "Tag_0_expects_at_least_1_arguments_but_the_JSX_factory_2_provides_at_most_3_6229", "Tag '{0}' expects at least '{1}' arguments, but the JSX factory '{2}' provides at most '{3}'."),
        Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_false_or_null_on_command_line: diag(6230, ts2.DiagnosticCategory.Error, "Option_0_can_only_be_specified_in_tsconfig_json_file_or_set_to_false_or_null_on_command_line_6230", "Option '{0}' can only be specified in 'tsconfig.json' file or set to 'false' or 'null' on command line."),
        Could_not_resolve_the_path_0_with_the_extensions_Colon_1: diag(6231, ts2.DiagnosticCategory.Error, "Could_not_resolve_the_path_0_with_the_extensions_Colon_1_6231", "Could not resolve the path '{0}' with the extensions: {1}."),
        Declaration_augments_declaration_in_another_file_This_cannot_be_serialized: diag(6232, ts2.DiagnosticCategory.Error, "Declaration_augments_declaration_in_another_file_This_cannot_be_serialized_6232", "Declaration augments declaration in another file. This cannot be serialized."),
        This_is_the_declaration_being_augmented_Consider_moving_the_augmenting_declaration_into_the_same_file: diag(6233, ts2.DiagnosticCategory.Error, "This_is_the_declaration_being_augmented_Consider_moving_the_augmenting_declaration_into_the_same_fil_6233", "This is the declaration being augmented. Consider moving the augmenting declaration into the same file."),
        This_expression_is_not_callable_because_it_is_a_get_accessor_Did_you_mean_to_use_it_without: diag(6234, ts2.DiagnosticCategory.Error, "This_expression_is_not_callable_because_it_is_a_get_accessor_Did_you_mean_to_use_it_without_6234", "This expression is not callable because it is a 'get' accessor. Did you mean to use it without '()'?"),
        Disable_loading_referenced_projects: diag(6235, ts2.DiagnosticCategory.Message, "Disable_loading_referenced_projects_6235", "Disable loading referenced projects."),
        Arguments_for_the_rest_parameter_0_were_not_provided: diag(6236, ts2.DiagnosticCategory.Error, "Arguments_for_the_rest_parameter_0_were_not_provided_6236", "Arguments for the rest parameter '{0}' were not provided."),
        Generates_an_event_trace_and_a_list_of_types: diag(6237, ts2.DiagnosticCategory.Message, "Generates_an_event_trace_and_a_list_of_types_6237", "Generates an event trace and a list of types."),
        Specify_the_module_specifier_to_be_used_to_import_the_jsx_and_jsxs_factory_functions_from_eg_react: diag(6238, ts2.DiagnosticCategory.Error, "Specify_the_module_specifier_to_be_used_to_import_the_jsx_and_jsxs_factory_functions_from_eg_react_6238", "Specify the module specifier to be used to import the 'jsx' and 'jsxs' factory functions from. eg, react"),
        File_0_exists_according_to_earlier_cached_lookups: diag(6239, ts2.DiagnosticCategory.Message, "File_0_exists_according_to_earlier_cached_lookups_6239", "File '{0}' exists according to earlier cached lookups."),
        File_0_does_not_exist_according_to_earlier_cached_lookups: diag(6240, ts2.DiagnosticCategory.Message, "File_0_does_not_exist_according_to_earlier_cached_lookups_6240", "File '{0}' does not exist according to earlier cached lookups."),
        Resolution_for_type_reference_directive_0_was_found_in_cache_from_location_1: diag(6241, ts2.DiagnosticCategory.Message, "Resolution_for_type_reference_directive_0_was_found_in_cache_from_location_1_6241", "Resolution for type reference directive '{0}' was found in cache from location '{1}'."),
        Resolving_type_reference_directive_0_containing_file_1: diag(6242, ts2.DiagnosticCategory.Message, "Resolving_type_reference_directive_0_containing_file_1_6242", "======== Resolving type reference directive '{0}', containing file '{1}'. ========"),
        Interpret_optional_property_types_as_written_rather_than_adding_undefined: diag(6243, ts2.DiagnosticCategory.Message, "Interpret_optional_property_types_as_written_rather_than_adding_undefined_6243", "Interpret optional property types as written, rather than adding 'undefined'."),
        Modules: diag(6244, ts2.DiagnosticCategory.Message, "Modules_6244", "Modules"),
        File_Management: diag(6245, ts2.DiagnosticCategory.Message, "File_Management_6245", "File Management"),
        Emit: diag(6246, ts2.DiagnosticCategory.Message, "Emit_6246", "Emit"),
        JavaScript_Support: diag(6247, ts2.DiagnosticCategory.Message, "JavaScript_Support_6247", "JavaScript Support"),
        Type_Checking: diag(6248, ts2.DiagnosticCategory.Message, "Type_Checking_6248", "Type Checking"),
        Editor_Support: diag(6249, ts2.DiagnosticCategory.Message, "Editor_Support_6249", "Editor Support"),
        Watch_and_Build_Modes: diag(6250, ts2.DiagnosticCategory.Message, "Watch_and_Build_Modes_6250", "Watch and Build Modes"),
        Compiler_Diagnostics: diag(6251, ts2.DiagnosticCategory.Message, "Compiler_Diagnostics_6251", "Compiler Diagnostics"),
        Interop_Constraints: diag(6252, ts2.DiagnosticCategory.Message, "Interop_Constraints_6252", "Interop Constraints"),
        Backwards_Compatibility: diag(6253, ts2.DiagnosticCategory.Message, "Backwards_Compatibility_6253", "Backwards Compatibility"),
        Language_and_Environment: diag(6254, ts2.DiagnosticCategory.Message, "Language_and_Environment_6254", "Language and Environment"),
        Projects: diag(6255, ts2.DiagnosticCategory.Message, "Projects_6255", "Projects"),
        Output_Formatting: diag(6256, ts2.DiagnosticCategory.Message, "Output_Formatting_6256", "Output Formatting"),
        Completeness: diag(6257, ts2.DiagnosticCategory.Message, "Completeness_6257", "Completeness"),
        _0_should_be_set_inside_the_compilerOptions_object_of_the_config_json_file: diag(6258, ts2.DiagnosticCategory.Error, "_0_should_be_set_inside_the_compilerOptions_object_of_the_config_json_file_6258", "'{0}' should be set inside the 'compilerOptions' object of the config json file"),
        Found_1_error_in_1: diag(6259, ts2.DiagnosticCategory.Message, "Found_1_error_in_1_6259", "Found 1 error in {1}"),
        Found_0_errors_in_the_same_file_starting_at_Colon_1: diag(6260, ts2.DiagnosticCategory.Message, "Found_0_errors_in_the_same_file_starting_at_Colon_1_6260", "Found {0} errors in the same file, starting at: {1}"),
        Found_0_errors_in_1_files: diag(6261, ts2.DiagnosticCategory.Message, "Found_0_errors_in_1_files_6261", "Found {0} errors in {1} files."),
        Directory_0_has_no_containing_package_json_scope_Imports_will_not_resolve: diag(6270, ts2.DiagnosticCategory.Message, "Directory_0_has_no_containing_package_json_scope_Imports_will_not_resolve_6270", "Directory '{0}' has no containing package.json scope. Imports will not resolve."),
        Import_specifier_0_does_not_exist_in_package_json_scope_at_path_1: diag(6271, ts2.DiagnosticCategory.Message, "Import_specifier_0_does_not_exist_in_package_json_scope_at_path_1_6271", "Import specifier '{0}' does not exist in package.json scope at path '{1}'."),
        Invalid_import_specifier_0_has_no_possible_resolutions: diag(6272, ts2.DiagnosticCategory.Message, "Invalid_import_specifier_0_has_no_possible_resolutions_6272", "Invalid import specifier '{0}' has no possible resolutions."),
        package_json_scope_0_has_no_imports_defined: diag(6273, ts2.DiagnosticCategory.Message, "package_json_scope_0_has_no_imports_defined_6273", "package.json scope '{0}' has no imports defined."),
        package_json_scope_0_explicitly_maps_specifier_1_to_null: diag(6274, ts2.DiagnosticCategory.Message, "package_json_scope_0_explicitly_maps_specifier_1_to_null_6274", "package.json scope '{0}' explicitly maps specifier '{1}' to null."),
        package_json_scope_0_has_invalid_type_for_target_of_specifier_1: diag(6275, ts2.DiagnosticCategory.Message, "package_json_scope_0_has_invalid_type_for_target_of_specifier_1_6275", "package.json scope '{0}' has invalid type for target of specifier '{1}'"),
        Export_specifier_0_does_not_exist_in_package_json_scope_at_path_1: diag(6276, ts2.DiagnosticCategory.Message, "Export_specifier_0_does_not_exist_in_package_json_scope_at_path_1_6276", "Export specifier '{0}' does not exist in package.json scope at path '{1}'."),
        Enable_project_compilation: diag(6302, ts2.DiagnosticCategory.Message, "Enable_project_compilation_6302", "Enable project compilation"),
        Composite_projects_may_not_disable_declaration_emit: diag(6304, ts2.DiagnosticCategory.Error, "Composite_projects_may_not_disable_declaration_emit_6304", "Composite projects may not disable declaration emit."),
        Output_file_0_has_not_been_built_from_source_file_1: diag(6305, ts2.DiagnosticCategory.Error, "Output_file_0_has_not_been_built_from_source_file_1_6305", "Output file '{0}' has not been built from source file '{1}'."),
        Referenced_project_0_must_have_setting_composite_Colon_true: diag(6306, ts2.DiagnosticCategory.Error, "Referenced_project_0_must_have_setting_composite_Colon_true_6306", `Referenced project '{0}' must have setting "composite": true.`),
        File_0_is_not_listed_within_the_file_list_of_project_1_Projects_must_list_all_files_or_use_an_include_pattern: diag(6307, ts2.DiagnosticCategory.Error, "File_0_is_not_listed_within_the_file_list_of_project_1_Projects_must_list_all_files_or_use_an_includ_6307", "File '{0}' is not listed within the file list of project '{1}'. Projects must list all files or use an 'include' pattern."),
        Cannot_prepend_project_0_because_it_does_not_have_outFile_set: diag(6308, ts2.DiagnosticCategory.Error, "Cannot_prepend_project_0_because_it_does_not_have_outFile_set_6308", "Cannot prepend project '{0}' because it does not have 'outFile' set"),
        Output_file_0_from_project_1_does_not_exist: diag(6309, ts2.DiagnosticCategory.Error, "Output_file_0_from_project_1_does_not_exist_6309", "Output file '{0}' from project '{1}' does not exist"),
        Referenced_project_0_may_not_disable_emit: diag(6310, ts2.DiagnosticCategory.Error, "Referenced_project_0_may_not_disable_emit_6310", "Referenced project '{0}' may not disable emit."),
        Project_0_is_out_of_date_because_output_1_is_older_than_input_2: diag(6350, ts2.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_output_1_is_older_than_input_2_6350", "Project '{0}' is out of date because output '{1}' is older than input '{2}'"),
        Project_0_is_up_to_date_because_newest_input_1_is_older_than_output_2: diag(6351, ts2.DiagnosticCategory.Message, "Project_0_is_up_to_date_because_newest_input_1_is_older_than_output_2_6351", "Project '{0}' is up to date because newest input '{1}' is older than output '{2}'"),
        Project_0_is_out_of_date_because_output_file_1_does_not_exist: diag(6352, ts2.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_output_file_1_does_not_exist_6352", "Project '{0}' is out of date because output file '{1}' does not exist"),
        Project_0_is_out_of_date_because_its_dependency_1_is_out_of_date: diag(6353, ts2.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_its_dependency_1_is_out_of_date_6353", "Project '{0}' is out of date because its dependency '{1}' is out of date"),
        Project_0_is_up_to_date_with_d_ts_files_from_its_dependencies: diag(6354, ts2.DiagnosticCategory.Message, "Project_0_is_up_to_date_with_d_ts_files_from_its_dependencies_6354", "Project '{0}' is up to date with .d.ts files from its dependencies"),
        Projects_in_this_build_Colon_0: diag(6355, ts2.DiagnosticCategory.Message, "Projects_in_this_build_Colon_0_6355", "Projects in this build: {0}"),
        A_non_dry_build_would_delete_the_following_files_Colon_0: diag(6356, ts2.DiagnosticCategory.Message, "A_non_dry_build_would_delete_the_following_files_Colon_0_6356", "A non-dry build would delete the following files: {0}"),
        A_non_dry_build_would_build_project_0: diag(6357, ts2.DiagnosticCategory.Message, "A_non_dry_build_would_build_project_0_6357", "A non-dry build would build project '{0}'"),
        Building_project_0: diag(6358, ts2.DiagnosticCategory.Message, "Building_project_0_6358", "Building project '{0}'..."),
        Updating_output_timestamps_of_project_0: diag(6359, ts2.DiagnosticCategory.Message, "Updating_output_timestamps_of_project_0_6359", "Updating output timestamps of project '{0}'..."),
        Project_0_is_up_to_date: diag(6361, ts2.DiagnosticCategory.Message, "Project_0_is_up_to_date_6361", "Project '{0}' is up to date"),
        Skipping_build_of_project_0_because_its_dependency_1_has_errors: diag(6362, ts2.DiagnosticCategory.Message, "Skipping_build_of_project_0_because_its_dependency_1_has_errors_6362", "Skipping build of project '{0}' because its dependency '{1}' has errors"),
        Project_0_can_t_be_built_because_its_dependency_1_has_errors: diag(6363, ts2.DiagnosticCategory.Message, "Project_0_can_t_be_built_because_its_dependency_1_has_errors_6363", "Project '{0}' can't be built because its dependency '{1}' has errors"),
        Build_one_or_more_projects_and_their_dependencies_if_out_of_date: diag(6364, ts2.DiagnosticCategory.Message, "Build_one_or_more_projects_and_their_dependencies_if_out_of_date_6364", "Build one or more projects and their dependencies, if out of date"),
        Delete_the_outputs_of_all_projects: diag(6365, ts2.DiagnosticCategory.Message, "Delete_the_outputs_of_all_projects_6365", "Delete the outputs of all projects."),
        Show_what_would_be_built_or_deleted_if_specified_with_clean: diag(6367, ts2.DiagnosticCategory.Message, "Show_what_would_be_built_or_deleted_if_specified_with_clean_6367", "Show what would be built (or deleted, if specified with '--clean')"),
        Option_build_must_be_the_first_command_line_argument: diag(6369, ts2.DiagnosticCategory.Error, "Option_build_must_be_the_first_command_line_argument_6369", "Option '--build' must be the first command line argument."),
        Options_0_and_1_cannot_be_combined: diag(6370, ts2.DiagnosticCategory.Error, "Options_0_and_1_cannot_be_combined_6370", "Options '{0}' and '{1}' cannot be combined."),
        Updating_unchanged_output_timestamps_of_project_0: diag(6371, ts2.DiagnosticCategory.Message, "Updating_unchanged_output_timestamps_of_project_0_6371", "Updating unchanged output timestamps of project '{0}'..."),
        Project_0_is_out_of_date_because_output_of_its_dependency_1_has_changed: diag(6372, ts2.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_output_of_its_dependency_1_has_changed_6372", "Project '{0}' is out of date because output of its dependency '{1}' has changed"),
        Updating_output_of_project_0: diag(6373, ts2.DiagnosticCategory.Message, "Updating_output_of_project_0_6373", "Updating output of project '{0}'..."),
        A_non_dry_build_would_update_timestamps_for_output_of_project_0: diag(6374, ts2.DiagnosticCategory.Message, "A_non_dry_build_would_update_timestamps_for_output_of_project_0_6374", "A non-dry build would update timestamps for output of project '{0}'"),
        A_non_dry_build_would_update_output_of_project_0: diag(6375, ts2.DiagnosticCategory.Message, "A_non_dry_build_would_update_output_of_project_0_6375", "A non-dry build would update output of project '{0}'"),
        Cannot_update_output_of_project_0_because_there_was_error_reading_file_1: diag(6376, ts2.DiagnosticCategory.Message, "Cannot_update_output_of_project_0_because_there_was_error_reading_file_1_6376", "Cannot update output of project '{0}' because there was error reading file '{1}'"),
        Cannot_write_file_0_because_it_will_overwrite_tsbuildinfo_file_generated_by_referenced_project_1: diag(6377, ts2.DiagnosticCategory.Error, "Cannot_write_file_0_because_it_will_overwrite_tsbuildinfo_file_generated_by_referenced_project_1_6377", "Cannot write file '{0}' because it will overwrite '.tsbuildinfo' file generated by referenced project '{1}'"),
        Composite_projects_may_not_disable_incremental_compilation: diag(6379, ts2.DiagnosticCategory.Error, "Composite_projects_may_not_disable_incremental_compilation_6379", "Composite projects may not disable incremental compilation."),
        Specify_file_to_store_incremental_compilation_information: diag(6380, ts2.DiagnosticCategory.Message, "Specify_file_to_store_incremental_compilation_information_6380", "Specify file to store incremental compilation information"),
        Project_0_is_out_of_date_because_output_for_it_was_generated_with_version_1_that_differs_with_current_version_2: diag(6381, ts2.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_output_for_it_was_generated_with_version_1_that_differs_with_curren_6381", "Project '{0}' is out of date because output for it was generated with version '{1}' that differs with current version '{2}'"),
        Skipping_build_of_project_0_because_its_dependency_1_was_not_built: diag(6382, ts2.DiagnosticCategory.Message, "Skipping_build_of_project_0_because_its_dependency_1_was_not_built_6382", "Skipping build of project '{0}' because its dependency '{1}' was not built"),
        Project_0_can_t_be_built_because_its_dependency_1_was_not_built: diag(6383, ts2.DiagnosticCategory.Message, "Project_0_can_t_be_built_because_its_dependency_1_was_not_built_6383", "Project '{0}' can't be built because its dependency '{1}' was not built"),
        Have_recompiles_in_incremental_and_watch_assume_that_changes_within_a_file_will_only_affect_files_directly_depending_on_it: diag(6384, ts2.DiagnosticCategory.Message, "Have_recompiles_in_incremental_and_watch_assume_that_changes_within_a_file_will_only_affect_files_di_6384", "Have recompiles in '--incremental' and '--watch' assume that changes within a file will only affect files directly depending on it."),
        _0_is_deprecated: diag(6385, ts2.DiagnosticCategory.Suggestion, "_0_is_deprecated_6385", "'{0}' is deprecated.", void 0, void 0, true),
        Performance_timings_for_diagnostics_or_extendedDiagnostics_are_not_available_in_this_session_A_native_implementation_of_the_Web_Performance_API_could_not_be_found: diag(6386, ts2.DiagnosticCategory.Message, "Performance_timings_for_diagnostics_or_extendedDiagnostics_are_not_available_in_this_session_A_nativ_6386", "Performance timings for '--diagnostics' or '--extendedDiagnostics' are not available in this session. A native implementation of the Web Performance API could not be found."),
        The_signature_0_of_1_is_deprecated: diag(6387, ts2.DiagnosticCategory.Suggestion, "The_signature_0_of_1_is_deprecated_6387", "The signature '{0}' of '{1}' is deprecated.", void 0, void 0, true),
        Project_0_is_being_forcibly_rebuilt: diag(6388, ts2.DiagnosticCategory.Message, "Project_0_is_being_forcibly_rebuilt_6388", "Project '{0}' is being forcibly rebuilt"),
        Reusing_resolution_of_module_0_from_1_of_old_program_it_was_not_resolved: diag(6389, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_of_old_program_it_was_not_resolved_6389", "Reusing resolution of module '{0}' from '{1}' of old program, it was not resolved."),
        Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_successfully_resolved_to_2: diag(6390, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_successfully_resolved__6390", "Reusing resolution of type reference directive '{0}' from '{1}' of old program, it was successfully resolved to '{2}'."),
        Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_successfully_resolved_to_2_with_Package_ID_3: diag(6391, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_successfully_resolved__6391", "Reusing resolution of type reference directive '{0}' from '{1}' of old program, it was successfully resolved to '{2}' with Package ID '{3}'."),
        Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_not_resolved: diag(6392, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_type_reference_directive_0_from_1_of_old_program_it_was_not_resolved_6392", "Reusing resolution of type reference directive '{0}' from '{1}' of old program, it was not resolved."),
        Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_3: diag(6393, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_6393", "Reusing resolution of module '{0}' from '{1}' found in cache from location '{2}', it was successfully resolved to '{3}'."),
        Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_3_with_Package_ID_4: diag(6394, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_6394", "Reusing resolution of module '{0}' from '{1}' found in cache from location '{2}', it was successfully resolved to '{3}' with Package ID '{4}'."),
        Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_not_resolved: diag(6395, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_module_0_from_1_found_in_cache_from_location_2_it_was_not_resolved_6395", "Reusing resolution of module '{0}' from '{1}' found in cache from location '{2}', it was not resolved."),
        Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_3: diag(6396, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_succes_6396", "Reusing resolution of type reference directive '{0}' from '{1}' found in cache from location '{2}', it was successfully resolved to '{3}'."),
        Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_successfully_resolved_to_3_with_Package_ID_4: diag(6397, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_succes_6397", "Reusing resolution of type reference directive '{0}' from '{1}' found in cache from location '{2}', it was successfully resolved to '{3}' with Package ID '{4}'."),
        Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_not_resolved: diag(6398, ts2.DiagnosticCategory.Message, "Reusing_resolution_of_type_reference_directive_0_from_1_found_in_cache_from_location_2_it_was_not_re_6398", "Reusing resolution of type reference directive '{0}' from '{1}' found in cache from location '{2}', it was not resolved."),
        Project_0_is_out_of_date_because_buildinfo_file_1_indicates_that_some_of_the_changes_were_not_emitted: diag(6399, ts2.DiagnosticCategory.Message, "Project_0_is_out_of_date_because_buildinfo_file_1_indicates_that_some_of_the_changes_were_not_emitte_6399", "Project '{0}' is out of date because buildinfo file '{1}' indicates that some of the changes were not emitted"),
        Project_0_is_up_to_date_but_needs_to_update_timestamps_of_output_files_that_are_older_than_input_files: diag(6400, ts2.DiagnosticCategory.Message, "Project_0_is_up_to_date_but_needs_to_update_timestamps_of_output_files_that_are_older_than_input_fil_6400", "Project '{0}' is up to date but needs to update timestamps of output files that are older than input files"),
        The_expected_type_comes_from_property_0_which_is_declared_here_on_type_1: diag(6500, ts2.DiagnosticCategory.Message, "The_expected_type_comes_from_property_0_which_is_declared_here_on_type_1_6500", "The expected type comes from property '{0}' which is declared here on type '{1}'"),
        The_expected_type_comes_from_this_index_signature: diag(6501, ts2.DiagnosticCategory.Message, "The_expected_type_comes_from_this_index_signature_6501", "The expected type comes from this index signature."),
        The_expected_type_comes_from_the_return_type_of_this_signature: diag(6502, ts2.DiagnosticCategory.Message, "The_expected_type_comes_from_the_return_type_of_this_signature_6502", "The expected type comes from the return type of this signature."),
        Print_names_of_files_that_are_part_of_the_compilation_and_then_stop_processing: diag(6503, ts2.DiagnosticCategory.Message, "Print_names_of_files_that_are_part_of_the_compilation_and_then_stop_processing_6503", "Print names of files that are part of the compilation and then stop processing."),
        File_0_is_a_JavaScript_file_Did_you_mean_to_enable_the_allowJs_option: diag(6504, ts2.DiagnosticCategory.Error, "File_0_is_a_JavaScript_file_Did_you_mean_to_enable_the_allowJs_option_6504", "File '{0}' is a JavaScript file. Did you mean to enable the 'allowJs' option?"),
        Print_names_of_files_and_the_reason_they_are_part_of_the_compilation: diag(6505, ts2.DiagnosticCategory.Message, "Print_names_of_files_and_the_reason_they_are_part_of_the_compilation_6505", "Print names of files and the reason they are part of the compilation."),
        Consider_adding_a_declare_modifier_to_this_class: diag(6506, ts2.DiagnosticCategory.Message, "Consider_adding_a_declare_modifier_to_this_class_6506", "Consider adding a 'declare' modifier to this class."),
        Allow_JavaScript_files_to_be_a_part_of_your_program_Use_the_checkJS_option_to_get_errors_from_these_files: diag(6600, ts2.DiagnosticCategory.Message, "Allow_JavaScript_files_to_be_a_part_of_your_program_Use_the_checkJS_option_to_get_errors_from_these__6600", "Allow JavaScript files to be a part of your program. Use the 'checkJS' option to get errors from these files."),
        Allow_import_x_from_y_when_a_module_doesn_t_have_a_default_export: diag(6601, ts2.DiagnosticCategory.Message, "Allow_import_x_from_y_when_a_module_doesn_t_have_a_default_export_6601", "Allow 'import x from y' when a module doesn't have a default export."),
        Allow_accessing_UMD_globals_from_modules: diag(6602, ts2.DiagnosticCategory.Message, "Allow_accessing_UMD_globals_from_modules_6602", "Allow accessing UMD globals from modules."),
        Disable_error_reporting_for_unreachable_code: diag(6603, ts2.DiagnosticCategory.Message, "Disable_error_reporting_for_unreachable_code_6603", "Disable error reporting for unreachable code."),
        Disable_error_reporting_for_unused_labels: diag(6604, ts2.DiagnosticCategory.Message, "Disable_error_reporting_for_unused_labels_6604", "Disable error reporting for unused labels."),
        Ensure_use_strict_is_always_emitted: diag(6605, ts2.DiagnosticCategory.Message, "Ensure_use_strict_is_always_emitted_6605", "Ensure 'use strict' is always emitted."),
        Have_recompiles_in_projects_that_use_incremental_and_watch_mode_assume_that_changes_within_a_file_will_only_affect_files_directly_depending_on_it: diag(6606, ts2.DiagnosticCategory.Message, "Have_recompiles_in_projects_that_use_incremental_and_watch_mode_assume_that_changes_within_a_file_wi_6606", "Have recompiles in projects that use 'incremental' and 'watch' mode assume that changes within a file will only affect files directly depending on it."),
        Specify_the_base_directory_to_resolve_non_relative_module_names: diag(6607, ts2.DiagnosticCategory.Message, "Specify_the_base_directory_to_resolve_non_relative_module_names_6607", "Specify the base directory to resolve non-relative module names."),
        No_longer_supported_In_early_versions_manually_set_the_text_encoding_for_reading_files: diag(6608, ts2.DiagnosticCategory.Message, "No_longer_supported_In_early_versions_manually_set_the_text_encoding_for_reading_files_6608", "No longer supported. In early versions, manually set the text encoding for reading files."),
        Enable_error_reporting_in_type_checked_JavaScript_files: diag(6609, ts2.DiagnosticCategory.Message, "Enable_error_reporting_in_type_checked_JavaScript_files_6609", "Enable error reporting in type-checked JavaScript files."),
        Enable_constraints_that_allow_a_TypeScript_project_to_be_used_with_project_references: diag(6611, ts2.DiagnosticCategory.Message, "Enable_constraints_that_allow_a_TypeScript_project_to_be_used_with_project_references_6611", "Enable constraints that allow a TypeScript project to be used with project references."),
        Generate_d_ts_files_from_TypeScript_and_JavaScript_files_in_your_project: diag(6612, ts2.DiagnosticCategory.Message, "Generate_d_ts_files_from_TypeScript_and_JavaScript_files_in_your_project_6612", "Generate .d.ts files from TypeScript and JavaScript files in your project."),
        Specify_the_output_directory_for_generated_declaration_files: diag(6613, ts2.DiagnosticCategory.Message, "Specify_the_output_directory_for_generated_declaration_files_6613", "Specify the output directory for generated declaration files."),
        Create_sourcemaps_for_d_ts_files: diag(6614, ts2.DiagnosticCategory.Message, "Create_sourcemaps_for_d_ts_files_6614", "Create sourcemaps for d.ts files."),
        Output_compiler_performance_information_after_building: diag(6615, ts2.DiagnosticCategory.Message, "Output_compiler_performance_information_after_building_6615", "Output compiler performance information after building."),
        Disables_inference_for_type_acquisition_by_looking_at_filenames_in_a_project: diag(6616, ts2.DiagnosticCategory.Message, "Disables_inference_for_type_acquisition_by_looking_at_filenames_in_a_project_6616", "Disables inference for type acquisition by looking at filenames in a project."),
        Reduce_the_number_of_projects_loaded_automatically_by_TypeScript: diag(6617, ts2.DiagnosticCategory.Message, "Reduce_the_number_of_projects_loaded_automatically_by_TypeScript_6617", "Reduce the number of projects loaded automatically by TypeScript."),
        Remove_the_20mb_cap_on_total_source_code_size_for_JavaScript_files_in_the_TypeScript_language_server: diag(6618, ts2.DiagnosticCategory.Message, "Remove_the_20mb_cap_on_total_source_code_size_for_JavaScript_files_in_the_TypeScript_language_server_6618", "Remove the 20mb cap on total source code size for JavaScript files in the TypeScript language server."),
        Opt_a_project_out_of_multi_project_reference_checking_when_editing: diag(6619, ts2.DiagnosticCategory.Message, "Opt_a_project_out_of_multi_project_reference_checking_when_editing_6619", "Opt a project out of multi-project reference checking when editing."),
        Disable_preferring_source_files_instead_of_declaration_files_when_referencing_composite_projects: diag(6620, ts2.DiagnosticCategory.Message, "Disable_preferring_source_files_instead_of_declaration_files_when_referencing_composite_projects_6620", "Disable preferring source files instead of declaration files when referencing composite projects."),
        Emit_more_compliant_but_verbose_and_less_performant_JavaScript_for_iteration: diag(6621, ts2.DiagnosticCategory.Message, "Emit_more_compliant_but_verbose_and_less_performant_JavaScript_for_iteration_6621", "Emit more compliant, but verbose and less performant JavaScript for iteration."),
        Emit_a_UTF_8_Byte_Order_Mark_BOM_in_the_beginning_of_output_files: diag(6622, ts2.DiagnosticCategory.Message, "Emit_a_UTF_8_Byte_Order_Mark_BOM_in_the_beginning_of_output_files_6622", "Emit a UTF-8 Byte Order Mark (BOM) in the beginning of output files."),
        Only_output_d_ts_files_and_not_JavaScript_files: diag(6623, ts2.DiagnosticCategory.Message, "Only_output_d_ts_files_and_not_JavaScript_files_6623", "Only output d.ts files and not JavaScript files."),
        Emit_design_type_metadata_for_decorated_declarations_in_source_files: diag(6624, ts2.DiagnosticCategory.Message, "Emit_design_type_metadata_for_decorated_declarations_in_source_files_6624", "Emit design-type metadata for decorated declarations in source files."),
        Disable_the_type_acquisition_for_JavaScript_projects: diag(6625, ts2.DiagnosticCategory.Message, "Disable_the_type_acquisition_for_JavaScript_projects_6625", "Disable the type acquisition for JavaScript projects"),
        Emit_additional_JavaScript_to_ease_support_for_importing_CommonJS_modules_This_enables_allowSyntheticDefaultImports_for_type_compatibility: diag(6626, ts2.DiagnosticCategory.Message, "Emit_additional_JavaScript_to_ease_support_for_importing_CommonJS_modules_This_enables_allowSyntheti_6626", "Emit additional JavaScript to ease support for importing CommonJS modules. This enables 'allowSyntheticDefaultImports' for type compatibility."),
        Filters_results_from_the_include_option: diag(6627, ts2.DiagnosticCategory.Message, "Filters_results_from_the_include_option_6627", "Filters results from the `include` option."),
        Remove_a_list_of_directories_from_the_watch_process: diag(6628, ts2.DiagnosticCategory.Message, "Remove_a_list_of_directories_from_the_watch_process_6628", "Remove a list of directories from the watch process."),
        Remove_a_list_of_files_from_the_watch_mode_s_processing: diag(6629, ts2.DiagnosticCategory.Message, "Remove_a_list_of_files_from_the_watch_mode_s_processing_6629", "Remove a list of files from the watch mode's processing."),
        Enable_experimental_support_for_TC39_stage_2_draft_decorators: diag(6630, ts2.DiagnosticCategory.Message, "Enable_experimental_support_for_TC39_stage_2_draft_decorators_6630", "Enable experimental support for TC39 stage 2 draft decorators."),
        Print_files_read_during_the_compilation_including_why_it_was_included: diag(6631, ts2.DiagnosticCategory.Message, "Print_files_read_during_the_compilation_including_why_it_was_included_6631", "Print files read during the compilation including why it was included."),
        Output_more_detailed_compiler_performance_information_after_building: diag(6632, ts2.DiagnosticCategory.Message, "Output_more_detailed_compiler_performance_information_after_building_6632", "Output more detailed compiler performance information after building."),
        Specify_one_or_more_path_or_node_module_references_to_base_configuration_files_from_which_settings_are_inherited: diag(6633, ts2.DiagnosticCategory.Message, "Specify_one_or_more_path_or_node_module_references_to_base_configuration_files_from_which_settings_a_6633", "Specify one or more path or node module references to base configuration files from which settings are inherited."),
        Specify_what_approach_the_watcher_should_use_if_the_system_runs_out_of_native_file_watchers: diag(6634, ts2.DiagnosticCategory.Message, "Specify_what_approach_the_watcher_should_use_if_the_system_runs_out_of_native_file_watchers_6634", "Specify what approach the watcher should use if the system runs out of native file watchers."),
        Include_a_list_of_files_This_does_not_support_glob_patterns_as_opposed_to_include: diag(6635, ts2.DiagnosticCategory.Message, "Include_a_list_of_files_This_does_not_support_glob_patterns_as_opposed_to_include_6635", "Include a list of files. This does not support glob patterns, as opposed to `include`."),
        Build_all_projects_including_those_that_appear_to_be_up_to_date: diag(6636, ts2.DiagnosticCategory.Message, "Build_all_projects_including_those_that_appear_to_be_up_to_date_6636", "Build all projects, including those that appear to be up to date."),
        Ensure_that_casing_is_correct_in_imports: diag(6637, ts2.DiagnosticCategory.Message, "Ensure_that_casing_is_correct_in_imports_6637", "Ensure that casing is correct in imports."),
        Emit_a_v8_CPU_profile_of_the_compiler_run_for_debugging: diag(6638, ts2.DiagnosticCategory.Message, "Emit_a_v8_CPU_profile_of_the_compiler_run_for_debugging_6638", "Emit a v8 CPU profile of the compiler run for debugging."),
        Allow_importing_helper_functions_from_tslib_once_per_project_instead_of_including_them_per_file: diag(6639, ts2.DiagnosticCategory.Message, "Allow_importing_helper_functions_from_tslib_once_per_project_instead_of_including_them_per_file_6639", "Allow importing helper functions from tslib once per project, instead of including them per-file."),
        Specify_a_list_of_glob_patterns_that_match_files_to_be_included_in_compilation: diag(6641, ts2.DiagnosticCategory.Message, "Specify_a_list_of_glob_patterns_that_match_files_to_be_included_in_compilation_6641", "Specify a list of glob patterns that match files to be included in compilation."),
        Save_tsbuildinfo_files_to_allow_for_incremental_compilation_of_projects: diag(6642, ts2.DiagnosticCategory.Message, "Save_tsbuildinfo_files_to_allow_for_incremental_compilation_of_projects_6642", "Save .tsbuildinfo files to allow for incremental compilation of projects."),
        Include_sourcemap_files_inside_the_emitted_JavaScript: diag(6643, ts2.DiagnosticCategory.Message, "Include_sourcemap_files_inside_the_emitted_JavaScript_6643", "Include sourcemap files inside the emitted JavaScript."),
        Include_source_code_in_the_sourcemaps_inside_the_emitted_JavaScript: diag(6644, ts2.DiagnosticCategory.Message, "Include_source_code_in_the_sourcemaps_inside_the_emitted_JavaScript_6644", "Include source code in the sourcemaps inside the emitted JavaScript."),
        Ensure_that_each_file_can_be_safely_transpiled_without_relying_on_other_imports: diag(6645, ts2.DiagnosticCategory.Message, "Ensure_that_each_file_can_be_safely_transpiled_without_relying_on_other_imports_6645", "Ensure that each file can be safely transpiled without relying on other imports."),
        Specify_what_JSX_code_is_generated: diag(6646, ts2.DiagnosticCategory.Message, "Specify_what_JSX_code_is_generated_6646", "Specify what JSX code is generated."),
        Specify_the_JSX_factory_function_used_when_targeting_React_JSX_emit_e_g_React_createElement_or_h: diag(6647, ts2.DiagnosticCategory.Message, "Specify_the_JSX_factory_function_used_when_targeting_React_JSX_emit_e_g_React_createElement_or_h_6647", "Specify the JSX factory function used when targeting React JSX emit, e.g. 'React.createElement' or 'h'."),
        Specify_the_JSX_Fragment_reference_used_for_fragments_when_targeting_React_JSX_emit_e_g_React_Fragment_or_Fragment: diag(6648, ts2.DiagnosticCategory.Message, "Specify_the_JSX_Fragment_reference_used_for_fragments_when_targeting_React_JSX_emit_e_g_React_Fragme_6648", "Specify the JSX Fragment reference used for fragments when targeting React JSX emit e.g. 'React.Fragment' or 'Fragment'."),
        Specify_module_specifier_used_to_import_the_JSX_factory_functions_when_using_jsx_Colon_react_jsx_Asterisk: diag(6649, ts2.DiagnosticCategory.Message, "Specify_module_specifier_used_to_import_the_JSX_factory_functions_when_using_jsx_Colon_react_jsx_Ast_6649", "Specify module specifier used to import the JSX factory functions when using 'jsx: react-jsx*'."),
        Make_keyof_only_return_strings_instead_of_string_numbers_or_symbols_Legacy_option: diag(6650, ts2.DiagnosticCategory.Message, "Make_keyof_only_return_strings_instead_of_string_numbers_or_symbols_Legacy_option_6650", "Make keyof only return strings instead of string, numbers or symbols. Legacy option."),
        Specify_a_set_of_bundled_library_declaration_files_that_describe_the_target_runtime_environment: diag(6651, ts2.DiagnosticCategory.Message, "Specify_a_set_of_bundled_library_declaration_files_that_describe_the_target_runtime_environment_6651", "Specify a set of bundled library declaration files that describe the target runtime environment."),
        Print_the_names_of_emitted_files_after_a_compilation: diag(6652, ts2.DiagnosticCategory.Message, "Print_the_names_of_emitted_files_after_a_compilation_6652", "Print the names of emitted files after a compilation."),
        Print_all_of_the_files_read_during_the_compilation: diag(6653, ts2.DiagnosticCategory.Message, "Print_all_of_the_files_read_during_the_compilation_6653", "Print all of the files read during the compilation."),
        Set_the_language_of_the_messaging_from_TypeScript_This_does_not_affect_emit: diag(6654, ts2.DiagnosticCategory.Message, "Set_the_language_of_the_messaging_from_TypeScript_This_does_not_affect_emit_6654", "Set the language of the messaging from TypeScript. This does not affect emit."),
        Specify_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations: diag(6655, ts2.DiagnosticCategory.Message, "Specify_the_location_where_debugger_should_locate_map_files_instead_of_generated_locations_6655", "Specify the location where debugger should locate map files instead of generated locations."),
        Specify_the_maximum_folder_depth_used_for_checking_JavaScript_files_from_node_modules_Only_applicable_with_allowJs: diag(6656, ts2.DiagnosticCategory.Message, "Specify_the_maximum_folder_depth_used_for_checking_JavaScript_files_from_node_modules_Only_applicabl_6656", "Specify the maximum folder depth used for checking JavaScript files from 'node_modules'. Only applicable with 'allowJs'."),
        Specify_what_module_code_is_generated: diag(6657, ts2.DiagnosticCategory.Message, "Specify_what_module_code_is_generated_6657", "Specify what module code is generated."),
        Specify_how_TypeScript_looks_up_a_file_from_a_given_module_specifier: diag(6658, ts2.DiagnosticCategory.Message, "Specify_how_TypeScript_looks_up_a_file_from_a_given_module_specifier_6658", "Specify how TypeScript looks up a file from a given module specifier."),
        Set_the_newline_character_for_emitting_files: diag(6659, ts2.DiagnosticCategory.Message, "Set_the_newline_character_for_emitting_files_6659", "Set the newline character for emitting files."),
        Disable_emitting_files_from_a_compilation: diag(6660, ts2.DiagnosticCategory.Message, "Disable_emitting_files_from_a_compilation_6660", "Disable emitting files from a compilation."),
        Disable_generating_custom_helper_functions_like_extends_in_compiled_output: diag(6661, ts2.DiagnosticCategory.Message, "Disable_generating_custom_helper_functions_like_extends_in_compiled_output_6661", "Disable generating custom helper functions like '__extends' in compiled output."),
        Disable_emitting_files_if_any_type_checking_errors_are_reported: diag(6662, ts2.DiagnosticCategory.Message, "Disable_emitting_files_if_any_type_checking_errors_are_reported_6662", "Disable emitting files if any type checking errors are reported."),
        Disable_truncating_types_in_error_messages: diag(6663, ts2.DiagnosticCategory.Message, "Disable_truncating_types_in_error_messages_6663", "Disable truncating types in error messages."),
        Enable_error_reporting_for_fallthrough_cases_in_switch_statements: diag(6664, ts2.DiagnosticCategory.Message, "Enable_error_reporting_for_fallthrough_cases_in_switch_statements_6664", "Enable error reporting for fallthrough cases in switch statements."),
        Enable_error_reporting_for_expressions_and_declarations_with_an_implied_any_type: diag(6665, ts2.DiagnosticCategory.Message, "Enable_error_reporting_for_expressions_and_declarations_with_an_implied_any_type_6665", "Enable error reporting for expressions and declarations with an implied 'any' type."),
        Ensure_overriding_members_in_derived_classes_are_marked_with_an_override_modifier: diag(6666, ts2.DiagnosticCategory.Message, "Ensure_overriding_members_in_derived_classes_are_marked_with_an_override_modifier_6666", "Ensure overriding members in derived classes are marked with an override modifier."),
        Enable_error_reporting_for_codepaths_that_do_not_explicitly_return_in_a_function: diag(6667, ts2.DiagnosticCategory.Message, "Enable_error_reporting_for_codepaths_that_do_not_explicitly_return_in_a_function_6667", "Enable error reporting for codepaths that do not explicitly return in a function."),
        Enable_error_reporting_when_this_is_given_the_type_any: diag(6668, ts2.DiagnosticCategory.Message, "Enable_error_reporting_when_this_is_given_the_type_any_6668", "Enable error reporting when 'this' is given the type 'any'."),
        Disable_adding_use_strict_directives_in_emitted_JavaScript_files: diag(6669, ts2.DiagnosticCategory.Message, "Disable_adding_use_strict_directives_in_emitted_JavaScript_files_6669", "Disable adding 'use strict' directives in emitted JavaScript files."),
        Disable_including_any_library_files_including_the_default_lib_d_ts: diag(6670, ts2.DiagnosticCategory.Message, "Disable_including_any_library_files_including_the_default_lib_d_ts_6670", "Disable including any library files, including the default lib.d.ts."),
        Enforces_using_indexed_accessors_for_keys_declared_using_an_indexed_type: diag(6671, ts2.DiagnosticCategory.Message, "Enforces_using_indexed_accessors_for_keys_declared_using_an_indexed_type_6671", "Enforces using indexed accessors for keys declared using an indexed type."),
        Disallow_import_s_require_s_or_reference_s_from_expanding_the_number_of_files_TypeScript_should_add_to_a_project: diag(6672, ts2.DiagnosticCategory.Message, "Disallow_import_s_require_s_or_reference_s_from_expanding_the_number_of_files_TypeScript_should_add__6672", "Disallow 'import's, 'require's or '<reference>'s from expanding the number of files TypeScript should add to a project."),
        Disable_strict_checking_of_generic_signatures_in_function_types: diag(6673, ts2.DiagnosticCategory.Message, "Disable_strict_checking_of_generic_signatures_in_function_types_6673", "Disable strict checking of generic signatures in function types."),
        Add_undefined_to_a_type_when_accessed_using_an_index: diag(6674, ts2.DiagnosticCategory.Message, "Add_undefined_to_a_type_when_accessed_using_an_index_6674", "Add 'undefined' to a type when accessed using an index."),
        Enable_error_reporting_when_local_variables_aren_t_read: diag(6675, ts2.DiagnosticCategory.Message, "Enable_error_reporting_when_local_variables_aren_t_read_6675", "Enable error reporting when local variables aren't read."),
        Raise_an_error_when_a_function_parameter_isn_t_read: diag(6676, ts2.DiagnosticCategory.Message, "Raise_an_error_when_a_function_parameter_isn_t_read_6676", "Raise an error when a function parameter isn't read."),
        Deprecated_setting_Use_outFile_instead: diag(6677, ts2.DiagnosticCategory.Message, "Deprecated_setting_Use_outFile_instead_6677", "Deprecated setting. Use 'outFile' instead."),
        Specify_an_output_folder_for_all_emitted_files: diag(6678, ts2.DiagnosticCategory.Message, "Specify_an_output_folder_for_all_emitted_files_6678", "Specify an output folder for all emitted files."),
        Specify_a_file_that_bundles_all_outputs_into_one_JavaScript_file_If_declaration_is_true_also_designates_a_file_that_bundles_all_d_ts_output: diag(6679, ts2.DiagnosticCategory.Message, "Specify_a_file_that_bundles_all_outputs_into_one_JavaScript_file_If_declaration_is_true_also_designa_6679", "Specify a file that bundles all outputs into one JavaScript file. If 'declaration' is true, also designates a file that bundles all .d.ts output."),
        Specify_a_set_of_entries_that_re_map_imports_to_additional_lookup_locations: diag(6680, ts2.DiagnosticCategory.Message, "Specify_a_set_of_entries_that_re_map_imports_to_additional_lookup_locations_6680", "Specify a set of entries that re-map imports to additional lookup locations."),
        Specify_a_list_of_language_service_plugins_to_include: diag(6681, ts2.DiagnosticCategory.Message, "Specify_a_list_of_language_service_plugins_to_include_6681", "Specify a list of language service plugins to include."),
        Disable_erasing_const_enum_declarations_in_generated_code: diag(6682, ts2.DiagnosticCategory.Message, "Disable_erasing_const_enum_declarations_in_generated_code_6682", "Disable erasing 'const enum' declarations in generated code."),
        Disable_resolving_symlinks_to_their_realpath_This_correlates_to_the_same_flag_in_node: diag(6683, ts2.DiagnosticCategory.Message, "Disable_resolving_symlinks_to_their_realpath_This_correlates_to_the_same_flag_in_node_6683", "Disable resolving symlinks to their realpath. This correlates to the same flag in node."),
        Disable_wiping_the_console_in_watch_mode: diag(6684, ts2.DiagnosticCategory.Message, "Disable_wiping_the_console_in_watch_mode_6684", "Disable wiping the console in watch mode."),
        Enable_color_and_formatting_in_TypeScript_s_output_to_make_compiler_errors_easier_to_read: diag(6685, ts2.DiagnosticCategory.Message, "Enable_color_and_formatting_in_TypeScript_s_output_to_make_compiler_errors_easier_to_read_6685", "Enable color and formatting in TypeScript's output to make compiler errors easier to read."),
        Specify_the_object_invoked_for_createElement_This_only_applies_when_targeting_react_JSX_emit: diag(6686, ts2.DiagnosticCategory.Message, "Specify_the_object_invoked_for_createElement_This_only_applies_when_targeting_react_JSX_emit_6686", "Specify the object invoked for 'createElement'. This only applies when targeting 'react' JSX emit."),
        Specify_an_array_of_objects_that_specify_paths_for_projects_Used_in_project_references: diag(6687, ts2.DiagnosticCategory.Message, "Specify_an_array_of_objects_that_specify_paths_for_projects_Used_in_project_references_6687", "Specify an array of objects that specify paths for projects. Used in project references."),
        Disable_emitting_comments: diag(6688, ts2.DiagnosticCategory.Message, "Disable_emitting_comments_6688", "Disable emitting comments."),
        Enable_importing_json_files: diag(6689, ts2.DiagnosticCategory.Message, "Enable_importing_json_files_6689", "Enable importing .json files."),
        Specify_the_root_folder_within_your_source_files: diag(6690, ts2.DiagnosticCategory.Message, "Specify_the_root_folder_within_your_source_files_6690", "Specify the root folder within your source files."),
        Allow_multiple_folders_to_be_treated_as_one_when_resolving_modules: diag(6691, ts2.DiagnosticCategory.Message, "Allow_multiple_folders_to_be_treated_as_one_when_resolving_modules_6691", "Allow multiple folders to be treated as one when resolving modules."),
        Skip_type_checking_d_ts_files_that_are_included_with_TypeScript: diag(6692, ts2.DiagnosticCategory.Message, "Skip_type_checking_d_ts_files_that_are_included_with_TypeScript_6692", "Skip type checking .d.ts files that are included with TypeScript."),
        Skip_type_checking_all_d_ts_files: diag(6693, ts2.DiagnosticCategory.Message, "Skip_type_checking_all_d_ts_files_6693", "Skip type checking all .d.ts files."),
        Create_source_map_files_for_emitted_JavaScript_files: diag(6694, ts2.DiagnosticCategory.Message, "Create_source_map_files_for_emitted_JavaScript_files_6694", "Create source map files for emitted JavaScript files."),
        Specify_the_root_path_for_debuggers_to_find_the_reference_source_code: diag(6695, ts2.DiagnosticCategory.Message, "Specify_the_root_path_for_debuggers_to_find_the_reference_source_code_6695", "Specify the root path for debuggers to find the reference source code."),
        Check_that_the_arguments_for_bind_call_and_apply_methods_match_the_original_function: diag(6697, ts2.DiagnosticCategory.Message, "Check_that_the_arguments_for_bind_call_and_apply_methods_match_the_original_function_6697", "Check that the arguments for 'bind', 'call', and 'apply' methods match the original function."),
        When_assigning_functions_check_to_ensure_parameters_and_the_return_values_are_subtype_compatible: diag(6698, ts2.DiagnosticCategory.Message, "When_assigning_functions_check_to_ensure_parameters_and_the_return_values_are_subtype_compatible_6698", "When assigning functions, check to ensure parameters and the return values are subtype-compatible."),
        When_type_checking_take_into_account_null_and_undefined: diag(6699, ts2.DiagnosticCategory.Message, "When_type_checking_take_into_account_null_and_undefined_6699", "When type checking, take into account 'null' and 'undefined'."),
        Check_for_class_properties_that_are_declared_but_not_set_in_the_constructor: diag(6700, ts2.DiagnosticCategory.Message, "Check_for_class_properties_that_are_declared_but_not_set_in_the_constructor_6700", "Check for class properties that are declared but not set in the constructor."),
        Disable_emitting_declarations_that_have_internal_in_their_JSDoc_comments: diag(6701, ts2.DiagnosticCategory.Message, "Disable_emitting_declarations_that_have_internal_in_their_JSDoc_comments_6701", "Disable emitting declarations that have '@internal' in their JSDoc comments."),
        Disable_reporting_of_excess_property_errors_during_the_creation_of_object_literals: diag(6702, ts2.DiagnosticCategory.Message, "Disable_reporting_of_excess_property_errors_during_the_creation_of_object_literals_6702", "Disable reporting of excess property errors during the creation of object literals."),
        Suppress_noImplicitAny_errors_when_indexing_objects_that_lack_index_signatures: diag(6703, ts2.DiagnosticCategory.Message, "Suppress_noImplicitAny_errors_when_indexing_objects_that_lack_index_signatures_6703", "Suppress 'noImplicitAny' errors when indexing objects that lack index signatures."),
        Synchronously_call_callbacks_and_update_the_state_of_directory_watchers_on_platforms_that_don_t_support_recursive_watching_natively: diag(6704, ts2.DiagnosticCategory.Message, "Synchronously_call_callbacks_and_update_the_state_of_directory_watchers_on_platforms_that_don_t_supp_6704", "Synchronously call callbacks and update the state of directory watchers on platforms that don`t support recursive watching natively."),
        Set_the_JavaScript_language_version_for_emitted_JavaScript_and_include_compatible_library_declarations: diag(6705, ts2.DiagnosticCategory.Message, "Set_the_JavaScript_language_version_for_emitted_JavaScript_and_include_compatible_library_declaratio_6705", "Set the JavaScript language version for emitted JavaScript and include compatible library declarations."),
        Log_paths_used_during_the_moduleResolution_process: diag(6706, ts2.DiagnosticCategory.Message, "Log_paths_used_during_the_moduleResolution_process_6706", "Log paths used during the 'moduleResolution' process."),
        Specify_the_path_to_tsbuildinfo_incremental_compilation_file: diag(6707, ts2.DiagnosticCategory.Message, "Specify_the_path_to_tsbuildinfo_incremental_compilation_file_6707", "Specify the path to .tsbuildinfo incremental compilation file."),
        Specify_options_for_automatic_acquisition_of_declaration_files: diag(6709, ts2.DiagnosticCategory.Message, "Specify_options_for_automatic_acquisition_of_declaration_files_6709", "Specify options for automatic acquisition of declaration files."),
        Specify_multiple_folders_that_act_like_Slashnode_modules_Slash_types: diag(6710, ts2.DiagnosticCategory.Message, "Specify_multiple_folders_that_act_like_Slashnode_modules_Slash_types_6710", "Specify multiple folders that act like './node_modules/@types'."),
        Specify_type_package_names_to_be_included_without_being_referenced_in_a_source_file: diag(6711, ts2.DiagnosticCategory.Message, "Specify_type_package_names_to_be_included_without_being_referenced_in_a_source_file_6711", "Specify type package names to be included without being referenced in a source file."),
        Emit_ECMAScript_standard_compliant_class_fields: diag(6712, ts2.DiagnosticCategory.Message, "Emit_ECMAScript_standard_compliant_class_fields_6712", "Emit ECMAScript-standard-compliant class fields."),
        Enable_verbose_logging: diag(6713, ts2.DiagnosticCategory.Message, "Enable_verbose_logging_6713", "Enable verbose logging."),
        Specify_how_directories_are_watched_on_systems_that_lack_recursive_file_watching_functionality: diag(6714, ts2.DiagnosticCategory.Message, "Specify_how_directories_are_watched_on_systems_that_lack_recursive_file_watching_functionality_6714", "Specify how directories are watched on systems that lack recursive file-watching functionality."),
        Specify_how_the_TypeScript_watch_mode_works: diag(6715, ts2.DiagnosticCategory.Message, "Specify_how_the_TypeScript_watch_mode_works_6715", "Specify how the TypeScript watch mode works."),
        Require_undeclared_properties_from_index_signatures_to_use_element_accesses: diag(6717, ts2.DiagnosticCategory.Message, "Require_undeclared_properties_from_index_signatures_to_use_element_accesses_6717", "Require undeclared properties from index signatures to use element accesses."),
        Specify_emit_Slashchecking_behavior_for_imports_that_are_only_used_for_types: diag(6718, ts2.DiagnosticCategory.Message, "Specify_emit_Slashchecking_behavior_for_imports_that_are_only_used_for_types_6718", "Specify emit/checking behavior for imports that are only used for types."),
        Default_catch_clause_variables_as_unknown_instead_of_any: diag(6803, ts2.DiagnosticCategory.Message, "Default_catch_clause_variables_as_unknown_instead_of_any_6803", "Default catch clause variables as 'unknown' instead of 'any'."),
        one_of_Colon: diag(6900, ts2.DiagnosticCategory.Message, "one_of_Colon_6900", "one of:"),
        one_or_more_Colon: diag(6901, ts2.DiagnosticCategory.Message, "one_or_more_Colon_6901", "one or more:"),
        type_Colon: diag(6902, ts2.DiagnosticCategory.Message, "type_Colon_6902", "type:"),
        default_Colon: diag(6903, ts2.DiagnosticCategory.Message, "default_Colon_6903", "default:"),
        module_system_or_esModuleInterop: diag(6904, ts2.DiagnosticCategory.Message, "module_system_or_esModuleInterop_6904", 'module === "system" or esModuleInterop'),
        false_unless_strict_is_set: diag(6905, ts2.DiagnosticCategory.Message, "false_unless_strict_is_set_6905", "`false`, unless `strict` is set"),
        false_unless_composite_is_set: diag(6906, ts2.DiagnosticCategory.Message, "false_unless_composite_is_set_6906", "`false`, unless `composite` is set"),
        node_modules_bower_components_jspm_packages_plus_the_value_of_outDir_if_one_is_specified: diag(6907, ts2.DiagnosticCategory.Message, "node_modules_bower_components_jspm_packages_plus_the_value_of_outDir_if_one_is_specified_6907", '`["node_modules", "bower_components", "jspm_packages"]`, plus the value of `outDir` if one is specified.'),
        if_files_is_specified_otherwise_Asterisk_Asterisk_Slash_Asterisk: diag(6908, ts2.DiagnosticCategory.Message, "if_files_is_specified_otherwise_Asterisk_Asterisk_Slash_Asterisk_6908", '`[]` if `files` is specified, otherwise `["**/*"]`'),
        true_if_composite_false_otherwise: diag(6909, ts2.DiagnosticCategory.Message, "true_if_composite_false_otherwise_6909", "`true` if `composite`, `false` otherwise"),
        module_AMD_or_UMD_or_System_or_ES6_then_Classic_Otherwise_Node: diag(69010, ts2.DiagnosticCategory.Message, "module_AMD_or_UMD_or_System_or_ES6_then_Classic_Otherwise_Node_69010", "module === `AMD` or `UMD` or `System` or `ES6`, then `Classic`, Otherwise `Node`"),
        Computed_from_the_list_of_input_files: diag(6911, ts2.DiagnosticCategory.Message, "Computed_from_the_list_of_input_files_6911", "Computed from the list of input files"),
        Platform_specific: diag(6912, ts2.DiagnosticCategory.Message, "Platform_specific_6912", "Platform specific"),
        You_can_learn_about_all_of_the_compiler_options_at_0: diag(6913, ts2.DiagnosticCategory.Message, "You_can_learn_about_all_of_the_compiler_options_at_0_6913", "You can learn about all of the compiler options at {0}"),
        Including_watch_w_will_start_watching_the_current_project_for_the_file_changes_Once_set_you_can_config_watch_mode_with_Colon: diag(6914, ts2.DiagnosticCategory.Message, "Including_watch_w_will_start_watching_the_current_project_for_the_file_changes_Once_set_you_can_conf_6914", "Including --watch, -w will start watching the current project for the file changes. Once set, you can config watch mode with:"),
        Using_build_b_will_make_tsc_behave_more_like_a_build_orchestrator_than_a_compiler_This_is_used_to_trigger_building_composite_projects_which_you_can_learn_more_about_at_0: diag(6915, ts2.DiagnosticCategory.Message, "Using_build_b_will_make_tsc_behave_more_like_a_build_orchestrator_than_a_compiler_This_is_used_to_tr_6915", "Using --build, -b will make tsc behave more like a build orchestrator than a compiler. This is used to trigger building composite projects which you can learn more about at {0}"),
        COMMON_COMMANDS: diag(6916, ts2.DiagnosticCategory.Message, "COMMON_COMMANDS_6916", "COMMON COMMANDS"),
        ALL_COMPILER_OPTIONS: diag(6917, ts2.DiagnosticCategory.Message, "ALL_COMPILER_OPTIONS_6917", "ALL COMPILER OPTIONS"),
        WATCH_OPTIONS: diag(6918, ts2.DiagnosticCategory.Message, "WATCH_OPTIONS_6918", "WATCH OPTIONS"),
        BUILD_OPTIONS: diag(6919, ts2.DiagnosticCategory.Message, "BUILD_OPTIONS_6919", "BUILD OPTIONS"),
        COMMON_COMPILER_OPTIONS: diag(6920, ts2.DiagnosticCategory.Message, "COMMON_COMPILER_OPTIONS_6920", "COMMON COMPILER OPTIONS"),
        COMMAND_LINE_FLAGS: diag(6921, ts2.DiagnosticCategory.Message, "COMMAND_LINE_FLAGS_6921", "COMMAND LINE FLAGS"),
        tsc_Colon_The_TypeScript_Compiler: diag(6922, ts2.DiagnosticCategory.Message, "tsc_Colon_The_TypeScript_Compiler_6922", "tsc: The TypeScript Compiler"),
        Compiles_the_current_project_tsconfig_json_in_the_working_directory: diag(6923, ts2.DiagnosticCategory.Message, "Compiles_the_current_project_tsconfig_json_in_the_working_directory_6923", "Compiles the current project (tsconfig.json in the working directory.)"),
        Ignoring_tsconfig_json_compiles_the_specified_files_with_default_compiler_options: diag(6924, ts2.DiagnosticCategory.Message, "Ignoring_tsconfig_json_compiles_the_specified_files_with_default_compiler_options_6924", "Ignoring tsconfig.json, compiles the specified files with default compiler options."),
        Build_a_composite_project_in_the_working_directory: diag(6925, ts2.DiagnosticCategory.Message, "Build_a_composite_project_in_the_working_directory_6925", "Build a composite project in the working directory."),
        Creates_a_tsconfig_json_with_the_recommended_settings_in_the_working_directory: diag(6926, ts2.DiagnosticCategory.Message, "Creates_a_tsconfig_json_with_the_recommended_settings_in_the_working_directory_6926", "Creates a tsconfig.json with the recommended settings in the working directory."),
        Compiles_the_TypeScript_project_located_at_the_specified_path: diag(6927, ts2.DiagnosticCategory.Message, "Compiles_the_TypeScript_project_located_at