/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.CopyProjectOperation;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.views.navigator.ResourceNavigatorMessages;
import org.eclipse.ui.part.ResourceTransfer;

@Deprecated
class PasteAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.PasteAction";
    private Shell shell;
    private Clipboard clipboard;

    public PasteAction(Shell shell, Clipboard clipboard) {
        super(ResourceNavigatorMessages.PasteAction_title);
        Assert.isNotNull((Object)shell);
        Assert.isNotNull((Object)clipboard);
        this.shell = shell;
        this.clipboard = clipboard;
        this.setToolTipText(ResourceNavigatorMessages.PasteAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.resource_navigator_paste_action_context");
    }

    /*
     * WARNING - void declaration
     */
    private IResource getTarget() {
        for (IResource iResource : this.getSelectedResources()) {
            void var1_2;
            if (iResource instanceof IProject && !((IProject)iResource).isOpen()) {
                return null;
            }
            if (iResource.getType() == 1) {
                IContainer iContainer = iResource.getParent();
            }
            if (var1_2 == null) continue;
            return var1_2;
        }
        return null;
    }

    private boolean isLinked(IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.isLinked()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void run() {
        ResourceTransfer resTransfer = ResourceTransfer.getInstance();
        IResource[] resourceData = (IResource[])this.clipboard.getContents((Transfer)resTransfer);
        if (resourceData != null && resourceData.length > 0) {
            if (resourceData[0].getType() == 4) {
                IResource[] iResourceArray = resourceData;
                int n = resourceData.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    CopyProjectOperation operation = new CopyProjectOperation(this.shell);
                    operation.copyProject((IProject)resource);
                    ++n2;
                }
            } else {
                IContainer container = this.getContainer();
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.shell);
                operation.copyResources(resourceData, container);
            }
            return;
        }
        FileTransfer fileTransfer = FileTransfer.getInstance();
        String[] fileData = (String[])this.clipboard.getContents((Transfer)fileTransfer);
        if (fileData != null) {
            IContainer container = this.getContainer();
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.shell);
            operation.copyFiles(fileData, container);
        }
    }

    private IContainer getContainer() {
        List<? extends IResource> selection = this.getSelectedResources();
        if (selection.get(0) instanceof IFile) {
            return ((IFile)selection.get(0)).getParent();
        }
        return (IContainer)selection.get(0);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean isProjectRes;
        if (!super.updateSelection(selection)) {
            return false;
        }
        IResource[][] clipboardData = new IResource[1][];
        this.shell.getDisplay().syncExec(() -> {
            ResourceTransfer resTransfer = ResourceTransfer.getInstance();
            iResourceArray[0] = (IResource[])this.clipboard.getContents((Transfer)resTransfer);
        });
        IResource[] resourceData = clipboardData[0];
        boolean bl = isProjectRes = resourceData != null && resourceData.length > 0 && resourceData[0].getType() == 4;
        if (isProjectRes) {
            IResource[] iResourceArray = resourceData;
            int n = resourceData.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getType() != 4 || !((IProject)resource).isOpen()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (this.getSelectedNonResources().size() > 0) {
            return false;
        }
        IResource targetResource = this.getTarget();
        if (targetResource == null) {
            return false;
        }
        List<? extends IResource> selectedResources = this.getSelectedResources();
        if (selectedResources.size() > 1) {
            for (IResource iResource : selectedResources) {
                if (iResource.getType() != 1) {
                    return false;
                }
                if (targetResource.equals((Object)iResource.getParent())) continue;
                return false;
            }
        }
        if (resourceData != null) {
            if (this.isLinked(resourceData) && targetResource.getType() != 4 && targetResource.getType() != 2) {
                return false;
            }
            if (targetResource.getType() == 2) {
                IResource[] iResourceArray = resourceData;
                int n = resourceData.length;
                int n3 = 0;
                while (n3 < n) {
                    IResource iResource = iResourceArray[n3];
                    if (targetResource.equals((Object)iResource)) {
                        return false;
                    }
                    ++n3;
                }
            }
            return true;
        }
        TransferData[] transferDataArray = this.clipboard.getAvailableTypes();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        TransferData[] transferDataArray2 = transferDataArray;
        int n = transferDataArray.length;
        int n3 = 0;
        while (n3 < n) {
            TransferData transfer = transferDataArray2[n3];
            if (fileTransfer.isSupportedType(transfer)) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

