/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IDocumentSetupParticipantExtension;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.FileBufferListenerAdapter;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;

public class ConnectDocumentToLanguageServerSetupParticipant
implements IDocumentSetupParticipant,
IDocumentSetupParticipantExtension {
    private final Map<IPath, Job> locationMap = new HashMap<IPath, Job>();
    private static final Set<Job> SUBMITTED_JOBS = new HashSet<Job>();

    public ConnectDocumentToLanguageServerSetupParticipant() {
        ITextFileBufferManager.DEFAULT.addFileBufferListener((IFileBufferListener)new FileBufferListenerAdapter(){

            @Override
            public void bufferDisposed(IFileBuffer buffer) {
                Job job = ConnectDocumentToLanguageServerSetupParticipant.this.locationMap.remove(buffer.getLocation());
                if (job != null) {
                    job.cancel();
                }
            }
        });
    }

    public void setup(IDocument document) {
        ITextFileBuffer buffer = ITextFileBufferManager.DEFAULT.getTextFileBuffer(document);
        if (buffer == null || buffer.getLocation() == null) {
            return;
        }
        this.setup(document, buffer.getLocation(), LocationKind.IFILE);
    }

    public void setup(final IDocument document, final IPath location, LocationKind locationKind) {
        if (document == null) {
            return;
        }
        Job job = new Job("Initialize Language Servers for " + location.toFile().getName()){

            protected IStatus run(IProgressMonitor monitor) {
                ITextFileBuffer buffer = ITextFileBufferManager.DEFAULT.getTextFileBuffer(document);
                if (buffer == null || buffer.getLocation() == null) {
                    return Status.OK_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                LanguageServiceAccessor.getLanguageServers(document, capabilities -> true).thenRun(() -> {
                    ConnectDocumentToLanguageServerSetupParticipant.this.locationMap.remove(location);
                    SUBMITTED_JOBS.remove((Object)this);
                });
                return Status.OK_STATUS;
            }
        };
        SUBMITTED_JOBS.add(job);
        this.locationMap.put(location, job);
        job.setUser(true);
        job.setPriority(10);
        job.schedule(100L);
    }

    public static void waitForAll() {
        SUBMITTED_JOBS.forEach(job -> {
            job.cancel();
            try {
                job.join(1000L, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logInfo("Interrupted trying to cancel document setup");
            }
        });
    }
}

