/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotatableType;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;

public class PrimitiveType
extends AnnotatableType {
    public static final Code INT = new Code("int");
    public static final Code CHAR = new Code("char");
    public static final Code BOOLEAN = new Code("boolean");
    public static final Code SHORT = new Code("short");
    public static final Code LONG = new Code("long");
    public static final Code FLOAT = new Code("float");
    public static final Code DOUBLE = new Code("double");
    public static final Code BYTE = new Code("byte");
    public static final Code VOID = new Code("void");
    private Code typeCode = INT;
    private static final Map CODES = new HashMap(20);
    public static final ChildListPropertyDescriptor ANNOTATIONS_PROPERTY;
    public static final SimplePropertyDescriptor PRIMITIVE_TYPE_CODE_PROPERTY;
    private static final List PROPERTY_DESCRIPTORS;
    private static final List PROPERTY_DESCRIPTORS_8_0;

    static {
        Code[] ops = new Code[]{INT, BYTE, CHAR, BOOLEAN, SHORT, LONG, FLOAT, DOUBLE, VOID};
        int i = 0;
        while (i < ops.length) {
            CODES.put(ops[i].toString(), ops[i]);
            ++i;
        }
        ANNOTATIONS_PROPERTY = PrimitiveType.internalAnnotationsPropertyFactory(PrimitiveType.class);
        PRIMITIVE_TYPE_CODE_PROPERTY = new SimplePropertyDescriptor(PrimitiveType.class, "primitiveTypeCode", Code.class, true);
        ArrayList propertyList = new ArrayList(2);
        PrimitiveType.createPropertyList(PrimitiveType.class, propertyList);
        PrimitiveType.addProperty(PRIMITIVE_TYPE_CODE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = PrimitiveType.reapPropertyList(propertyList);
        propertyList = new ArrayList(3);
        PrimitiveType.createPropertyList(PrimitiveType.class, propertyList);
        PrimitiveType.addProperty(ANNOTATIONS_PROPERTY, propertyList);
        PrimitiveType.addProperty(PRIMITIVE_TYPE_CODE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_8_0 = PrimitiveType.reapPropertyList(propertyList);
    }

    public static Code toCode(String token) {
        return (Code)CODES.get(token);
    }

    public static List propertyDescriptors(int apiLevel) {
        switch (apiLevel) {
            case 2: 
            case 3: 
            case 4: {
                return PROPERTY_DESCRIPTORS;
            }
        }
        return PROPERTY_DESCRIPTORS_8_0;
    }

    PrimitiveType(AST ast) {
        super(ast);
    }

    @Override
    final ChildListPropertyDescriptor internalAnnotationsProperty() {
        return ANNOTATIONS_PROPERTY;
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return PrimitiveType.propertyDescriptors(apiLevel);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == ANNOTATIONS_PROPERTY) {
            return this.annotations();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == PRIMITIVE_TYPE_CODE_PROPERTY) {
            if (get) {
                return this.getPrimitiveTypeCode();
            }
            this.setPrimitiveTypeCode((Code)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    final int getNodeType0() {
        return 39;
    }

    @Override
    ASTNode clone0(AST target) {
        PrimitiveType result = new PrimitiveType(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        if (this.ast.apiLevel >= 8) {
            result.annotations().addAll(ASTNode.copySubtrees(target, this.annotations()));
        }
        result.setPrimitiveTypeCode(this.getPrimitiveTypeCode());
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren && this.ast.apiLevel >= 8) {
            this.acceptChildren(visitor, this.annotations);
        }
        visitor.endVisit(this);
    }

    public Code getPrimitiveTypeCode() {
        return this.typeCode;
    }

    public void setPrimitiveTypeCode(Code typeCode) {
        if (typeCode == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(PRIMITIVE_TYPE_CODE_PROPERTY);
        this.typeCode = typeCode;
        this.postValueChange(PRIMITIVE_TYPE_CODE_PROPERTY);
    }

    @Override
    int memSize() {
        return 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.annotations == null ? 0 : this.annotations.listSize());
    }

    public static class Code {
        private String name;

        Code(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

