/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.Objects;

public class Semaphore {
    protected long notifications;
    protected Runnable runnable;
    private static final int NANOS_IN_MS = 1000000;

    public Semaphore(Runnable runnable) {
        this.runnable = runnable;
        this.notifications = 0L;
    }

    public synchronized boolean acquire(long delay) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long start = System.nanoTime();
        long timeLeft = delay;
        while (true) {
            if (this.notifications > 0L) {
                --this.notifications;
                return true;
            }
            if (timeLeft <= 0L) {
                return false;
            }
            this.wait(timeLeft);
            timeLeft = (start - System.nanoTime()) / 1000000L + delay;
        }
    }

    public synchronized boolean attempt() {
        if (this.notifications > 0L) {
            --this.notifications;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Semaphore)) {
            return false;
        }
        return this.runnable == ((Semaphore)obj).runnable;
    }

    public int hashCode() {
        return Objects.hashCode(this.runnable);
    }

    public synchronized void release() {
        ++this.notifications;
        this.notifyAll();
    }

    public String toString() {
        return "Semaphore(" + this.runnable + ")";
    }
}

