/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.NumericDocValuesWriter;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.SortingLeafReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.packed.PackedLongValues;

class NormValuesWriter {
    private DocsWithFieldSet docsWithField = new DocsWithFieldSet();
    private PackedLongValues.Builder pending = PackedLongValues.deltaPackedBuilder(0.0f);
    private final Counter iwBytesUsed;
    private long bytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
    private final FieldInfo fieldInfo;
    private int lastDocID = -1;

    public NormValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, long value) {
        if (docID <= this.lastDocID) {
            throw new IllegalArgumentException("Norm for \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        this.pending.add(value);
        this.docsWithField.add(docID);
        this.updateBytesUsed();
        this.lastDocID = docID;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    public void finish(int maxDoc) {
    }

    public void flush(SegmentWriteState state, Sorter.DocMap sortMap, NormsConsumer normsConsumer) throws IOException {
        final PackedLongValues values = this.pending.build();
        final SortingLeafReader.CachedNumericDVs sorted = sortMap != null ? NumericDocValuesWriter.sortDocValues(state.segmentInfo.maxDoc(), sortMap, new BufferedNorms(values, this.docsWithField.iterator())) : null;
        normsConsumer.addNormsField(this.fieldInfo, new NormsProducer(){

            @Override
            public NumericDocValues getNorms(FieldInfo fieldInfo2) {
                if (NormValuesWriter.this.fieldInfo != NormValuesWriter.this.fieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                if (sorted == null) {
                    return new BufferedNorms(values, NormValuesWriter.this.docsWithField.iterator());
                }
                return new SortingLeafReader.SortingNumericDocValues(sorted);
            }

            @Override
            public void checkIntegrity() {
            }

            @Override
            public void close() {
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }
        });
    }

    private static class BufferedNorms
    extends NumericDocValues {
        final PackedLongValues.Iterator iter;
        final DocIdSetIterator docsWithField;
        private long value;

        BufferedNorms(PackedLongValues values, DocIdSetIterator docsWithFields) {
            this.iter = values.iterator();
            this.docsWithField = docsWithFields;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.value = this.iter.next();
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        public long longValue() {
            return this.value;
        }
    }
}

