'use strict';

var utilContainsNewline = require('./util-contains-newline.js');

function flowIndentCheck(indent, fc, onError) {
    if ((fc === null || fc === void 0 ? void 0 : fc.type) === 'flow-collection') {
        const end = fc.end[0];
        if (end.indent === indent &&
            (end.source === ']' || end.source === '}') &&
            utilContainsNewline.containsNewline(fc)) {
            const msg = 'Flow end indicator should be more indented than parent';
            onError(end, 'BAD_INDENT', msg, true);
        }
    }
}

exports.flowIndentCheck = flowIndentCheck;
