/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.html;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4e.LanguageClientImpl;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.wildwebdeveloper.css.ui.preferences.CSSPreferenceServerConstants;
import org.eclipse.wildwebdeveloper.html.ui.preferences.HTMLPreferenceServerConstants;
import org.eclipse.wildwebdeveloper.ui.preferences.Settings;

public class HTMLLanguageClient
extends LanguageClientImpl {
    public CompletableFuture<List<Object>> configuration(ConfigurationParams params) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<Object> settings = new ArrayList<Object>();
            for (ConfigurationItem item : params.getItems()) {
                String section = item.getSection();
                if (HTMLPreferenceServerConstants.isMatchHtmlSection(section)) {
                    Settings htmlSettings = HTMLPreferenceServerConstants.getGlobalSettings();
                    settings.add(htmlSettings.findSettings(section.split("[.]")));
                    continue;
                }
                if (CSSPreferenceServerConstants.isMatchCssSection(section)) {
                    Settings cssSettings = CSSPreferenceServerConstants.getGlobalSettings();
                    settings.add(cssSettings.findSettings(section.split("[.]")));
                    continue;
                }
                settings.add(null);
            }
            return settings;
        });
    }
}

