/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestJsTs {
    private static final String WIZARD_CLASSNAME_TEMPLATE = "org.eclipse.ltk.internal.ui.refactoring.Refactoring";
    private static final String WIZARD_RENAME = "Rename";
    private static final String WIZARD_REFACTORING = "Refactoring";
    private static final String BUTTON_OK = "OK";
    private static final String BUTTON_CANCEL = "Cancel";
    private static final String BUTTON_CONTINUE = "Con&tinue";
    private static final String BUTTON_BACK = "< &Back";
    private IProject project;

    @BeforeEach
    public void setUpProject() throws CoreException {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(this.getClass().getName()) + System.nanoTime());
        this.project.create(null);
        this.project.open(null);
    }

    @Test
    public void testRefactoringRename() throws Exception {
        Display display;
        IFile file = this.project.getFile("TestJsTs.js");
        String content = "function testVar(test) {\n\tif (\"truetrue\" == \"true\" + test ) {\n\t\treturn true;\n\t}\n\treturn false;\n}\nprint(\"Testing var with true argument == \" + testVar(true));\nprint(\"Testing var with false argument == \" + testVar(false));\n";
        String oldName = "testVar";
        String newName = "newName";
        final String newContent = content.replaceAll("testVar", "newName");
        int offset = content.indexOf("testVar");
        file.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, null);
        AbstractTextEditor editor = (AbstractTextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file, (String)"org.eclipse.ui.genericeditor.GenericEditor");
        editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset, 0));
        editor.setFocus();
        DisplayHelper.sleep((long)5000L);
        final IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        Command command = commandService.getCommand("org.eclipse.ui.edit.rename");
        Assertions.assertTrue((command.isEnabled() && command.isHandled() ? 1 : 0) != 0);
        Event e = new Event();
        e.widget = (Widget)editor.getAdapter(Control.class);
        Shell ideShell = editor.getSite().getShell();
        e.display = display = ideShell.getDisplay();
        final AtomicBoolean renameDialogOkPressed = new AtomicBoolean();
        AtomicBoolean renameDialogContinuePressed = new AtomicBoolean();
        AtomicBoolean renameDialogCancelPressed = new AtomicBoolean();
        AtomicBoolean errorDialogOkPressed = new AtomicBoolean();
        Listener pressOKonRenameDialogPaint = event -> {
            void c;
            Shell shell2;
            Widget widget = event.widget;
            if (widget instanceof Composite var6_7 && (shell2 = c.getShell()) != ideShell && shell2.getData().getClass().getName().startsWith(WIZARD_CLASSNAME_TEMPLATE)) {
                Set<String> buttons = TestJsTs.getButtons((Widget)c);
                if (WIZARD_RENAME.equals(shell2.getText())) {
                    if (!renameDialogOkPressed.get()) {
                        if (buttons.contains(BUTTON_OK)) {
                            event.widget.getDisplay().asyncExec(() -> TestJsTs.pressOk(shell2));
                            renameDialogOkPressed.set(true);
                        }
                    } else if (!renameDialogContinuePressed.get()) {
                        if (buttons.contains(BUTTON_CONTINUE)) {
                            event.widget.getDisplay().asyncExec(() -> TestJsTs.pressOk(shell2));
                            renameDialogContinuePressed.set(true);
                        } else if (!renameDialogCancelPressed.get() && buttons.contains(BUTTON_CANCEL) && buttons.contains(BUTTON_BACK)) {
                            event.widget.getDisplay().asyncExec(() -> TestJsTs.pressCancel(shell2));
                            renameDialogCancelPressed.set(true);
                        }
                    }
                } else if (WIZARD_REFACTORING.equals(shell2.getText()) && !errorDialogOkPressed.get() && buttons.contains(BUTTON_OK)) {
                    event.widget.getDisplay().asyncExec(() -> TestJsTs.pressOk(shell2));
                    errorDialogOkPressed.set(true);
                }
            }
        };
        try {
            display.addFilter(9, pressOKonRenameDialogPaint);
            ExecutionEvent executionEvent = handlerService.createExecutionEvent(command, e);
            command.executeWithChecks(executionEvent);
            Assertions.assertTrue((boolean)new DisplayHelper(){

                protected boolean condition() {
                    return renameDialogOkPressed.get();
                }
            }.waitForCondition(display, 2000L), (String)"Rename dialog not shown");
            Assertions.assertTrue((boolean)new DisplayHelper(){

                protected boolean condition() {
                    return newContent.equals(document.get());
                }
            }.waitForCondition(display, 5000L), (String)"document not modified, rename not applied");
        }
        finally {
            ideShell.getDisplay().removeFilter(9, pressOKonRenameDialogPaint);
        }
    }

    private static Set<String> getButtons(Widget w) {
        HashSet<String> result = new HashSet<String>();
        Widget widget = w;
        if (widget instanceof Button && (var2_3 = (Button)widget) == (Button)var3_2) {
            result.add(button.getText());
        } else {
            if (w instanceof Composite var4_5) {
                Control[] controlArray = composite.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control child = controlArray[n2];
                    result.addAll(TestJsTs.getButtons((Widget)child));
                    ++n2;
                }
            }
        }
        return result;
    }

    private static void pressOk(Shell dialogShell) {
        try {
            Dialog dialog = (Dialog)dialogShell.getData();
            Method okPressedMethod = Dialog.class.getDeclaredMethod("okPressed", new Class[0]);
            okPressedMethod.setAccessible(true);
            okPressedMethod.invoke((Object)dialog, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Error(ex);
        }
    }

    private static void pressCancel(Shell dialogShell) {
        try {
            Dialog dialog = (Dialog)dialogShell.getData();
            Method cancelPressedMethod = Dialog.class.getDeclaredMethod("cancelPressed", new Class[0]);
            cancelPressedMethod.setAccessible(true);
            cancelPressedMethod.invoke((Object)dialog, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Error(ex);
        }
    }
}

