/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.MarkerGroup;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

public class ContentGeneratorDescriptor {
    private static final String ATTRIBUTE_DEFAULT_MARKER_GROUPING = "defaultMarkerGrouping";
    private static final String ATTRIBUTE_VISIBLE = "visible";
    private static final String ELEMENT_MARKER_FIELD_CONFIGURATION = "markerFieldConfiguration";
    private static final String MARKER_FIELD_REFERENCE = "markerFieldReference";
    private IConfigurationElement configurationElement;
    private MarkerField[] allFields;
    private Collection<MarkerType> markerTypes;
    private MarkerField[] initialVisible;
    private Collection<MarkerGroup> groups;
    private Collection<IConfigurationElement> generatorExtensions = new ArrayList<IConfigurationElement>();
    private Map<String, MarkerType> allTypesTable;

    public ContentGeneratorDescriptor(IConfigurationElement element) {
        this.configurationElement = element;
    }

    private void addDefinedGroups(Collection<MarkerGroup> groupss) {
        this.addGroupsFrom(this.configurationElement, groupss);
        Iterator<IConfigurationElement> extensions = this.generatorExtensions.iterator();
        while (extensions.hasNext()) {
            this.addGroupsFrom(extensions.next(), groupss);
        }
    }

    public void addExtensions(Collection<IConfigurationElement> extensions) {
        this.generatorExtensions = extensions;
    }

    private void addGroupsFrom(IConfigurationElement element, Collection<MarkerGroup> groupss) {
        IConfigurationElement[] iConfigurationElementArray = element.getChildren("markerGrouping");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement grouping = iConfigurationElementArray[n2];
            groupss.add(MarkerGroup.createMarkerGroup(grouping));
            ++n2;
        }
    }

    public boolean allTypesSelected(Collection<MarkerType> selectedTypes) {
        return selectedTypes.containsAll(this.markerTypes);
    }

    public MarkerField[] getAllFields() {
        return this.allFields;
    }

    public String getCategoryName() {
        return this.configurationElement.getAttribute(ATTRIBUTE_DEFAULT_MARKER_GROUPING);
    }

    public IConfigurationElement[] getFilterReferences() {
        IConfigurationElement[] filterGroups = this.configurationElement.getChildren(ELEMENT_MARKER_FIELD_CONFIGURATION);
        if (this.generatorExtensions.isEmpty()) {
            return filterGroups;
        }
        Iterator<IConfigurationElement> extensions = this.generatorExtensions.iterator();
        ArrayList<IConfigurationElement> extendedElements = new ArrayList<IConfigurationElement>();
        while (extensions.hasNext()) {
            IConfigurationElement extension = extensions.next();
            IConfigurationElement[] extensionFilters = extension.getChildren(ELEMENT_MARKER_FIELD_CONFIGURATION);
            extendedElements.addAll(Arrays.asList(extensionFilters));
        }
        if (extendedElements.size() > 0) {
            IConfigurationElement[] allGroups = new IConfigurationElement[filterGroups.length + extendedElements.size()];
            System.arraycopy(filterGroups, 0, allGroups, 0, filterGroups.length);
            Iterator extras = extendedElements.iterator();
            int index = filterGroups.length;
            while (extras.hasNext()) {
                allGroups[index] = (IConfigurationElement)extras.next();
            }
            return allGroups;
        }
        return filterGroups;
    }

    public String getId() {
        return this.configurationElement.getAttribute("id");
    }

    public MarkerField[] getInitialVisible() {
        return this.initialVisible;
    }

    public Collection<MarkerGroup> getMarkerGroups() {
        if (this.groups == null) {
            this.groups = new TreeSet<MarkerGroup>((mg1, mg2) -> mg1.getMarkerField().getName().compareTo(mg2.getMarkerField().getName()));
            this.addDefinedGroups(this.groups);
            if (this.getId().equals("org.eclipse.ui.ide.problemsGenerator")) {
                this.groups.addAll(MarkerSupportRegistry.getInstance().getMarkerGroups());
            }
        }
        return this.groups;
    }

    public Collection<MarkerType> getMarkerTypes() {
        if (this.markerTypes == null) {
            IConfigurationElement[] markerTypeElements;
            this.markerTypes = new HashSet<MarkerType>();
            IConfigurationElement[] iConfigurationElementArray = markerTypeElements = this.configurationElement.getChildren("markerTypeReference");
            int n = markerTypeElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                String elementName = configElement.getAttribute("id");
                MarkerType[] types = MarkerTypesModel.getInstance().getType(elementName).getAllSubTypes();
                this.markerTypes.addAll(Arrays.asList(types));
                this.markerTypes.add(MarkerTypesModel.getInstance().getType(elementName));
                ++n2;
            }
            if (this.markerTypes.isEmpty()) {
                MarkerType[] types = MarkerTypesModel.getInstance().getType("org.eclipse.core.resources.problemmarker").getAllSubTypes();
                this.markerTypes.addAll(Arrays.asList(types));
            }
        }
        return this.markerTypes;
    }

    public String getName() {
        return this.configurationElement.getAttribute("name");
    }

    public MarkerType getType(String typeId) {
        return this.getTypesTable().get(typeId);
    }

    public Map<String, MarkerType> getTypesTable() {
        if (this.allTypesTable == null) {
            this.allTypesTable = new HashMap<String, MarkerType>();
            for (MarkerType next : this.markerTypes) {
                this.allTypesTable.put(next.getId(), next);
            }
        }
        return this.allTypesTable;
    }

    public void initializeFromConfigurationElement(MarkerSupportRegistry registry) {
        IConfigurationElement[] elements = this.configurationElement.getChildren(MARKER_FIELD_REFERENCE);
        ArrayList<MarkerField> allFieldList = new ArrayList<MarkerField>();
        ArrayList<MarkerField> initialVisibleList = new ArrayList<MarkerField>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            MarkerField field = registry.getField(element.getAttribute("id"));
            if (field != null) {
                allFieldList.add(field);
                if (!MarkerSupportInternalUtilities.VALUE_FALSE.equals(element.getAttribute(ATTRIBUTE_VISIBLE))) {
                    initialVisibleList.add(field);
                }
            }
            ++n2;
        }
        this.allFields = new MarkerField[allFieldList.size()];
        allFieldList.toArray(this.allFields);
        this.initialVisible = new MarkerField[initialVisibleList.size()];
        initialVisibleList.toArray(this.initialVisible);
    }

    public void removeExtension(IConfigurationElement element) {
        this.generatorExtensions.remove(element);
    }
}

