/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.SeverityAndDescriptionFieldFilter;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.MarkerItem;

public class AllMarkersSeverityAndDescriptionFieldFilter
extends SeverityAndDescriptionFieldFilter {
    private boolean filterOnSeverity = false;
    private static String FILTER_ON_SEVERITY = "FILTER_ON_SEVERITY";

    @Override
    public boolean select(MarkerItem item) {
        if (this.filterOnSeverity) {
            IMarker marker = item.getMarker();
            if (marker == null) {
                return false;
            }
            if (!this.checkSeverity(item.getAttributeValue("severity", -1))) {
                return false;
            }
        }
        return super.select(item);
    }

    boolean getFilterOnSeverity() {
        return this.filterOnSeverity;
    }

    void setFilterOnSeverity(boolean filter) {
        this.filterOnSeverity = filter;
    }

    @Override
    public void loadSettings(IMemento memento) {
        super.loadSettings(memento);
        Boolean filtering = memento.getBoolean(FILTER_ON_SEVERITY);
        if (filtering != null) {
            this.filterOnSeverity = filtering;
        }
    }

    @Override
    public void saveSettings(IMemento memento) {
        super.saveSettings(memento);
        memento.putBoolean(FILTER_ON_SEVERITY, this.filterOnSeverity);
    }

    @Override
    public void populateWorkingCopy(MarkerFieldFilter copy) {
        super.populateWorkingCopy(copy);
        ((AllMarkersSeverityAndDescriptionFieldFilter)copy).filterOnSeverity = this.filterOnSeverity;
    }
}

